#
# * Country/Zones Zen Cart SQL Load for MySQL databases
# * @access private
# * @copyright Copyright 2003-2024 Zen Cart Development Team
# * @copyright Portions Copyright 2003 osCommerce
# * @license http://www.zen-cart.com/license/2_0.txt GNU Public License V2.0
# * @version $Id: piloujp 2023 Aug 02 Modified in v2.0.0-alpha1 $
#
# NOTE: UTF8 files need to be saved with encoding format set to UTF8-without-BOM.
#


## SQL Sections Specific to UTF8 character set

INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) VALUES ('Convert currencies for Text emails', 'CURRENCIES_TRANSLATIONS', '&pound;,£:&euro;,€:&reg;,®:&trade;,™', 'What currency conversions do you need for Text emails?<br />Example = &amp;pound;,&pound;:&amp;euro;,&euro;', 12, 120, NULL, '2003-11-21 00:00:00', NULL, 'zen_cfg_textarea_small(');

INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (240,'Åland Islands','AX','ALA','5');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (1,'Afghanistan','AF','AFG','6');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (2,'Albania','AL','ALB','5');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (3,'Algeria','DZ','DZA','5');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (4,'American Samoa','AS','ASM','7');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (5,'Andorra','AD','AND','5');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (6,'Angola','AO','AGO','8');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (7,'Anguilla','AI','AIA','10');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (8,'Antarctica','AQ','ATA','10');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (9,'Antigua and Barbuda','AG','ATG','8');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (10,'Argentina','AR','ARG','5');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (11,'Armenia','AM','ARM','5');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (12,'Aruba','AW','ABW','8');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (13,'Australia','AU','AUS','7');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (14,'Austria','AT','AUT','5');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (15,'Azerbaijan','AZ','AZE','5');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (16,'Bahamas','BS','BHS','10');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (17,'Bahrain','BH','BHR','10');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (18,'Bangladesh','BD','BGD','10');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (19,'Barbados','BB','BRB','8');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (20,'Belarus','BY','BLR','14');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (21,'Belgium','BE','BEL','5');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (22,'Belize','BZ','BLZ','10');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (23,'Benin','BJ','BEN','8');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (24,'Bermuda','BM','BMU','10');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (25,'Bhutan','BT','BTN','10');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (26,'Bolivia','BO','BOL','8');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (27,'Bosnia and Herzegowina','BA','BIH','5');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (28,'Botswana','BW','BWA','8');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (29,'Bouvet Island','BV','BVT','8');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (30,'Brazil','BR','BRA','11');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (31,'British Indian Ocean Territory','IO','IOT','6');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (32,'Brunei Darussalam','BN','BRN','18');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (33,'Bulgaria','BG','BGR','5');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (34,'Burkina Faso','BF','BFA','10');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (35,'Burundi','BI','BDI','8');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (36,'Cambodia','KH','KHM','7');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (37,'Cameroon','CM','CMR','8');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (38,'Canada','CA','CAN','7');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (39,'Cape Verde','CV','CPV','5');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (40,'Cayman Islands','KY','CYM','7');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (41,'Central African Republic','CF','CAF','8');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (42,'Chad','TD','TCD','8');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (43,'Chile','CL','CHL','5');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (44,'China','CN','CHN','7');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (45,'Christmas Island','CX','CXR','7');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (46,'Cocos (Keeling) Islands','CC','CCK','7');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (47,'Colombia','CO','COL','7');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (48,'Comoros','KM','COM','8');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (49,'Congo','CG','COG','8');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (50,'Cook Islands','CK','COK','10');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (51,'Costa Rica','CR','CRI','11');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (52,"Côte d'Ivoire",'CI','CIV','8');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (53,'Croatia','HR','HRV','5');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (54,'Cuba','CU','CUB','9');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (55,'Cyprus','CY','CYP','5');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (56,'Czech Republic','CZ','CZE','5');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (57,'Denmark','DK','DNK','5');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (58,'Djibouti','DJ','DJI','8');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (59,'Dominica','DM','DMA','8');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (60,'Dominican Republic','DO','DOM','5');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (61,'Timor-Leste','TL','TLS','10');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (62,'Ecuador','EC','ECU','12');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (63,'Egypt','EG','EGY','6');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (64,'El Salvador','SV','SLV','14');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (65,'Equatorial Guinea','GQ','GNQ','5');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (66,'Eritrea','ER','ERI','8');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (67,'Estonia','EE','EST','5');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (68,'Ethiopia','ET','ETH','5');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (69,'Falkland Islands (Malvinas)','FK','FLK','6');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (70,'Faroe Islands','FO','FRO','5');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (71,'Fiji','FJ','FJI','8');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (72,'Finland','FI','FIN','5');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (73,'France','FR','FRA','5');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (75,'French Guiana','GF','GUF','5');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (76,'French Polynesia','PF','PYF','5');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (77,'French Southern Territories','TF','ATF','5');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (78,'Gabon','GA','GAB','5');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (79,'Gambia','GM','GMB','8');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (80,'Georgia','GE','GEO','5');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (81,'Germany','DE','DEU','5');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (82,'Ghana','GH','GHA','11');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (83,'Gibraltar','GI','GIB','6');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (84,'Greece','GR','GRC','5');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (85,'Greenland','GL','GRL','5');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (86,'Grenada','GD','GRD','8');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (87,'Guadeloupe','GP','GLP','5');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (88,'Guam','GU','GUM','7');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (89,'Guatemala','GT','GTM','14');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (90,'Guinea','GN','GIN','5');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (91,'Guinea-bissau','GW','GNB','5');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (92,'Guyana','GY','GUY','7');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (93,'Haiti','HT','HTI','5');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (94,'Heard and Mc Donald Islands','HM','HMD','7');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (95,'Honduras','HN','HND','9');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (96,'Hong Kong','HK','HKG','8');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (97,'Hungary','HU','HUN','19');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (98,'Iceland','IS','ISL','5');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (99,'India','IN','IND','6');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (100,'Indonesia','ID','IDN','10');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (101,'Iran (Islamic Republic of)','IR','IRN','6');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (102,'Iraq','IQ','IRQ','11');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (103,'Ireland','IE','IRL','6');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (104,'Israel','IL','ISR','5');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (105,'Italy','IT','ITA','9');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (106,'Jamaica','JM','JAM','5');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (107,'Japan','JP','JPN','7');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (108,'Jordan','JO','JOR','10');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (109,'Kazakhstan','KZ','KAZ','6');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (110,'Kenya','KE','KEN','6');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (111,'Kiribati','KI','KIR','6');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (112,"Korea, Democratic People's Republic of",'KP','PRK','10');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (113,'Korea,  Republic of' ,'KR','KOR','7');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (114,'Kuwait','KW','KWT','5');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (115,'Kyrgyzstan','KG','KGZ','14');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (116,"Lao People's Democratic Republic",'LA','LAO','5');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (117,'Latvia','LV','LVA','2');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (118,'Lebanon','LB','LBN','10');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (119,'Lesotho','LS','LSO','10');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (120,'Liberia','LR','LBR','9');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (121,'Libya','LY','LBY','8');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (122,'Liechtenstein','LI','LIE','5');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (123,'Lithuania','LT','LTU','5');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (124,'Luxembourg','LU','LUX','5');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (125,'Macao','MO','MAC','8');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (126,'Macedonia, The Former Yugoslav Republic of' ,'MK','MKD','5');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (127,'Madagascar','MG','MDG','5');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (128,'Malawi','MW','MWI','8');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (129,'Malaysia','MY','MYS','14');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (130,'Maldives','MV','MDV','10');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (131,'Mali','ML','MLI','8');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (132,'Malta','MT','MLT','6');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (133,'Marshall Islands','MH','MHL','7');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (134,'Martinique','MQ','MTQ','5');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (135,'Mauritania','MR','MRT','8');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (136,'Mauritius','MU','MUS','8');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (137,'Mayotte','YT','MYT','5');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (138,'Mexico','MX','MEX','9');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (139,'Micronesia, Federated States of' ,'FM','FSM','7');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (140,'Moldova','MD','MDA','5');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (141,'Monaco','MC','MCO','5');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (142,'Mongolia','MN','MNG','10');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (143,'Montserrat','MS','MSR','6');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (144,'Morocco','MA','MAR','5');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (145,'Mozambique','MZ','MOZ','14');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (146,'Myanmar','MM','MMR','2');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (147,'Namibia','NA','NAM','8');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (148,'Nauru','NR','NRU','10');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (149,'Nepal','NP','NPL','10');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (150,'Netherlands','NL','NLD','5');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (151,'Bonaire, Sint Eustatius and Saba' ,'BQ','BES','10');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (152,'New Caledonia','NC','NCL','5');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (153,'New Zealand','NZ','NZL','10');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (154,'Nicaragua','NI','NIC','12');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (155,'Niger','NE','NER','5');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (156,'Nigeria','NG','NGA','13');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (157,'Niue','NU','NIU','10');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (158,'Norfolk Island','NF','NFK','7');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (159,'Northern Mariana Islands','MP','MNP','7');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (160,'Norway','NO','NOR','5');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (161,'Oman','OM','OMN','15');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (162,'Pakistan','PK','PAK','7');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (163,'Palau','PW','PLW','7');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (164,'Panama','PA','PAN','14');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (165,'Papua New Guinea','PG','PNG','16');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (166,'Paraguay','PY','PRY','5');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (167,'Peru','PE','PER','12');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (168,'Philippines','PH','PHL','17');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (169,'Pitcairn','PN','PCN','6');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (170,'Poland','PL','POL','5');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (171,'Portugal','PT','PRT','5');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (172,'Puerto Rico','PR','PRI','7');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (173,'Qatar','QA','QAT','8');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (174,'Réunion','RE','REU','5');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (175,'Romania','RO','ROU','5');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (176,'Russian Federation','RU','RUS','6');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (177,'Rwanda','RW','RWA','8');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (178,'Saint Kitts and Nevis','KN','KNA','2');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (179,'Saint Lucia','LC','LCA','8');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (180,'Saint Vincent and the Grenadines','VC','VCT','10');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (181,'Samoa','WS','WSM','8');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (182,'San Marino','SM','SMR','5');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (183,'Sao Tome and Principe','ST','STP','8');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (184,'Saudi Arabia','SA','SAU','10');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (185,'Senegal','SN','SEN','5');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (186,'Seychelles','SC','SYC','6');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (187,'Sierra Leone','SL','SLE','8');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (188,'Singapore','SG','SGP','10');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (189,'Slovakia (Slovak Republic)','SK','SVK','5');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (190,'Slovenia','SI','SVN','5');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (191,'Solomon Islands','SB','SLB','6');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (192,'Somalia','SO','SOM','2');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (193,'South Africa','ZA','ZAF','6');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (194,'South Georgia and the South Sandwich Islands','GS','SGS','6');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (195,'Spain','ES','ESP','20');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (196,'Sri Lanka','LK','LKA','6');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (197,'St. Helena','SH','SHN','6');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (198,'St. Pierre and Miquelon','PM','SPM','5');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (199,'Sudan','SD','SDN','12');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (200,'Suriname','SR','SUR','8');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (201,'Svalbard and Jan Mayen Islands','SJ','SJM','5');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (202,'Swaziland','SZ','SWZ','6');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (203,'Sweden','SE','SWE','5');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (204,'Switzerland','CH','CHE','5');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (205,'Syrian Arab Republic','SY','SYR','5');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (206,'Taiwan','TW','TWN','10');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (207,'Tajikistan','TJ','TJK','5');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (208,'Tanzania, United Republic of' ,'TZ','TZA','14');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (209,'Thailand','TH','THA','11');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (210,'Togo','TG','TGO','6');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (211,'Tokelau','TK','TKL','10');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (212,'Tonga','TO','TON','8');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (213,'Trinidad and Tobago','TT','TTO','2');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (214,'Tunisia','TN','TUN','9');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (215,'Türkiye','TR','TUR','9');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (216,'Turkmenistan','TM','TKM','5');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (217,'Turks and Caicos Islands','TC','TCA','6');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (218,'Tuvalu','TV','TUV','6');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (219,'Uganda','UG','UGA','8');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (220,'Ukraine','UA','UKR','6');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (221,'United Arab Emirates','AE','ARE','6');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (222,'United Kingdom','GB','GBR','6');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (223,'United States','US','USA','7');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (224,'United States Minor Outlying Islands','UM','UMI','7');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (225,'Uruguay','UY','URY','5');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (226,'Uzbekistan','UZ','UZB','6');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (227,'Vanuatu','VU','VUT','8');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (228,'Vatican City State (Holy See)','VA','VAT','9');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (229,'Venezuela','VE','VEN','16');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (230,'Viet Nam','VN','VNM','18');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (231,'Virgin Islands (British)','VG','VGB','10');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (232,'Virgin Islands (U.S.)','VI','VIR','7');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (233,'Wallis and Futuna Islands','WF','WLF','5');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (234,'Western Sahara','EH','ESH','8');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (235,'Yemen','YE','YEM','8');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (236,'Serbia','RS','SRB','6');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (238,'Zambia','ZM','ZMB','10');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (239,'Zimbabwe','ZW','ZWE','6');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (241,'Palestine,  State of' ,'PS','PSE','5');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (242,'Montenegro','ME','MNE','5');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (243,'Guernsey','GG','GGY','6');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (244,'Isle of Man','IM','IMN','6');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (245,'Jersey','JE','JEY','6');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (246,'South Sudan','SS','SSD','5');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (247,'Curaçao','CW','CUW','7');
INSERT INTO countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) VALUES (248,'Sint Maarten (Dutch part)','SX','SXM','7');



# USA
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (1,223,'AL','Alabama');
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (2,223,'AK','Alaska');
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (3,223,'AS','American Samoa');
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (4,223,'AZ','Arizona');
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (5,223,'AR','Arkansas');
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (7,223,'AA','Armed Forces Americas');
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (9,223,'AE','Armed Forces Europe');
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (11,223,'AP','Armed Forces Pacific');
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (12,223,'CA','California');
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (13,223,'CO','Colorado');
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (14,223,'CT','Connecticut');
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (15,223,'DE','Delaware');
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (16,223,'DC','District of Columbia');
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (17,223,'FM','Federated States Of Micronesia');
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (18,223,'FL','Florida');
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (19,223,'GA','Georgia');
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (20,223,'GU','Guam');
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (21,223,'HI','Hawaii');
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (22,223,'ID','Idaho');
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (23,223,'IL','Illinois');
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (24,223,'IN','Indiana');
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (25,223,'IA','Iowa');
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (26,223,'KS','Kansas');
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (27,223,'KY','Kentucky');
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (28,223,'LA','Louisiana');
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (29,223,'ME','Maine');
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (30,223,'MH','Marshall Islands');
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (31,223,'MD','Maryland');
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (32,223,'MA','Massachusetts');
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (33,223,'MI','Michigan');
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (34,223,'MN','Minnesota');
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (35,223,'MS','Mississippi');
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (36,223,'MO','Missouri');
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (37,223,'MT','Montana');
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (38,223,'NE','Nebraska');
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (39,223,'NV','Nevada');
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (40,223,'NH','New Hampshire');
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (41,223,'NJ','New Jersey');
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (42,223,'NM','New Mexico');
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (43,223,'NY','New York');
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (44,223,'NC','North Carolina');
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (45,223,'ND','North Dakota');
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (46,223,'MP','Northern Mariana Islands');
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (47,223,'OH','Ohio');
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (48,223,'OK','Oklahoma');
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (49,223,'OR','Oregon');
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (50,163,'PW','Palau');
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (51,223,'PA','Pennsylvania');
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (52,223,'PR','Puerto Rico');
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (53,223,'RI','Rhode Island');
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (54,223,'SC','South Carolina');
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (55,223,'SD','South Dakota');
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (56,223,'TN','Tennessee');
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (57,223,'TX','Texas');
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (58,223,'UT','Utah');
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (59,223,'VT','Vermont');
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (60,223,'VI','Virgin Islands');
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (61,223,'VA','Virginia');
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (62,223,'WA','Washington');
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (63,223,'WV','West Virginia');
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (64,223,'WI','Wisconsin');
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (65,223,'WY','Wyoming');

# Canada
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (66,38,'AB','Alberta');
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (67,38,'BC','British Columbia');
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (68,38,'MB','Manitoba');
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (69,38,'NL','Newfoundland');
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (70,38,'NB','New Brunswick');
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (71,38,'NS','Nova Scotia');
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (72,38,'NT','Northwest Territories');
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (73,38,'NU','Nunavut');
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (74,38,'ON','Ontario');
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (75,38,'PE','Prince Edward Island');
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (76,38,'QC','Quebec');
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (77,38,'SK','Saskatchewan');
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (78,38,'YT','Yukon Territory');

# Germany
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (79,81,'NDS','Niedersachsen');
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (80,81,'BAW','Baden-Württemberg');
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (81,81,'BAY','Bayern');
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (82,81,'BER','Berlin');
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (83,81,'BRG','Brandenburg');
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (84,81,'BRE','Bremen');
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (85,81,'HAM','Hamburg');
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (86,81,'HES','Hessen');
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (87,81,'MEC','Mecklenburg-Vorpommern');
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (88,81,'NRW','Nordrhein-Westfalen');
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (89,81,'RHE','Rheinland-Pfalz');
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (90,81,'SAR','Saarland');
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (91,81,'SAS','Sachsen');
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (92,81,'SAC','Sachsen-Anhalt');
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (93,81,'SCN','Schleswig-Holstein');
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (94,81,'THE','Thüringen');

# Austria
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (95,14,'WI','Wien');
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (96,14,'NO','Niederösterreich');
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (97,14,'OO','Oberösterreich');
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (98,14,'SB','Salzburg');
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (99,14,'KN','Kärnten');
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (100,14,'ST','Steiermark');
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (101,14,'TI','Tirol');
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (102,14,'BL','Burgenland');
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (103,14,'VB','Vorarlberg');

# Spain
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (195,'A Coruña','A Coruña');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (195,'Álava','Álava');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (195,'Albacete','Albacete');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (195,'Alicante','Alicante');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (195,'Almería','Almería');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (195,'Asturias','Asturias');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (195,'Ávila','Ávila');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (195,'Badajoz','Badajoz');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (195,'Baleares','Baleares');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (195,'Barcelona','Barcelona');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (195,'Burgos','Burgos');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (195,'Cáceres','Cáceres');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (195,'Cádiz','Cádiz');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (195,'Cantabria','Cantabria');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (195,'Castellón','Castellón');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (195,'Ceuta','Ceuta');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (195,'Ciudad Real','Ciudad Real');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (195,'Córdoba','Córdoba');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (195,'Cuenca','Cuenca');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (195,'Girona','Girona');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (195,'Granada','Granada');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (195,'Guadalajara','Guadalajara');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (195,'Guipúzcoa','Guipúzcoa');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (195,'Huelva','Huelva');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (195,'Huesca','Huesca');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (195,'Jaén','Jaén');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (195,'La Rioja','La Rioja');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (195,'Las Palmas','Las Palmas');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (195,'León','León');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (195,'Lérida','Lérida');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (195,'Lugo','Lugo');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (195,'Madrid','Madrid');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (195,'Málaga','Málaga');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (195,'Melilla','Melilla');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (195,'Murcia','Murcia');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (195,'Navarra','Navarra');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (195,'Ourense','Ourense');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (195,'Palencia','Palencia');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (195,'Pontevedra','Pontevedra');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (195,'Salamanca','Salamanca');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (195,'Santa Cruz de Tenerife','Santa Cruz de Tenerife');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (195,'Segovia','Segovia');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (195,'Sevilla','Sevilla');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (195,'Soria','Soria');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (195,'Tarragona','Tarragona');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (195,'Teruel','Teruel');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (195,'Toledo','Toledo');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (195,'Valencia','Valencia');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (195,'Valladolid','Valladolid');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (195,'Vizcaya','Vizcaya');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (195,'Zamora','Zamora');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (195,'Zaragoza','Zaragoza');

#australian zones
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (NULL, 13, 'ACT', 'Australian Capital Territory');
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (NULL, 13, 'NSW', 'New South Wales');
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (NULL, 13, 'NT', 'Northern Territory');
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (NULL, 13, 'QLD', 'Queensland');
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (NULL, 13, 'SA', 'South Australia');
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (NULL, 13, 'TAS', 'Tasmania');
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (NULL, 13, 'VIC', 'Victoria');
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (NULL, 13, 'WA', 'Western Australia');

#italian zones
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (NULL, 105,'AG','Agrigento');
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (NULL, 105,'AL','Alessandria');
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (NULL, 105,'AN','Ancona');
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (NULL, 105,'AO','Valle D\'Aosta');
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (NULL, 105,'AR','Arezzo');
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (NULL, 105,'AP','Ascoli Piceno');
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (NULL, 105,'AT','Asti');
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (NULL, 105,'AV','Avellino');
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (NULL, 105,'BA','Bari');
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (NULL, 105,'BT','Barletta-Andria-Trani');
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (NULL, 105,'BL','Belluno');
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (NULL, 105,'BN','Benevento');
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (NULL, 105,'BG','Bergamo');
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (NULL, 105,'BI','Biella');
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (NULL, 105,'BO','Bologna');
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (NULL, 105,'BZ','Bolzano');
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (NULL, 105,'BS','Brescia');
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (NULL, 105,'BR','Brindisi');
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (NULL, 105,'CA','Cagliari');
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (NULL, 105,'CL','Caltanissetta');
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (NULL, 105,'CB','Campobasso');
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (NULL, 105,'CE','Caserta');
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (NULL, 105,'CT','Catania');
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (NULL, 105,'CZ','Catanzaro');
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (NULL, 105,'CH','Chieti');
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (NULL, 105,'CO','Como');
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (NULL, 105,'CS','Cosenza');
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (NULL, 105,'CR','Cremona');
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (NULL, 105,'KR','Crotone');
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (NULL, 105,'CN','Cuneo');
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (NULL, 105,'EN','Enna');
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (NULL, 105,'FM','Fermo');
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (NULL, 105,'FE','Ferrara');
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (NULL, 105,'FI','Firenze');
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (NULL, 105,'FG','Foggia');
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (NULL, 105,'FC','Forlì-Cesena');
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (NULL, 105,'FR','Frosinone');
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (NULL, 105,'GE','Genova');
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (NULL, 105,'GO','Gorizia');
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (NULL, 105,'GR','Grosseto');
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (NULL, 105,'IM','Imperia');
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (NULL, 105,'IS','Isernia');
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (NULL, 105,'AQ','L\'Aquila');
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (NULL, 105,'SP','La Spezia');
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (NULL, 105,'LT','Latina');
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (NULL, 105,'LE','Lecce');
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (NULL, 105,'LC','Lecco');
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (NULL, 105,'LI','Livorno');
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (NULL, 105,'LO','Lodi');
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (NULL, 105,'LU','Lucca');
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (NULL, 105,'MC','Macerata');
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (NULL, 105,'MN','Mantova');
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (NULL, 105,'MS','Massa-Carrara');
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (NULL, 105,'MT','Matera');
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (NULL, 105,'ME','Messina');
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (NULL, 105,'MI','Milano');
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (NULL, 105,'MO','Modena');
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (NULL, 105,'MB','Monza e Brianza');
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (NULL, 105,'NA','Napoli');
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (NULL, 105,'NO','Novara');
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (NULL, 105,'NU','Nuoro');
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (NULL, 105,'OR','Oristano');
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (NULL, 105,'PD','Padova');
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (NULL, 105,'PA','Palermo');
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (NULL, 105,'PR','Parma');
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (NULL, 105,'PG','Perugia');
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (NULL, 105,'PV','Pavia');
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (NULL, 105,'PU','Pesaro E Urbino');
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (NULL, 105,'PE','Pescara');
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (NULL, 105,'PC','Piacenza');
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (NULL, 105,'PI','Pisa');
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (NULL, 105,'PT','Pistoia');
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (NULL, 105,'PN','Pordenone');
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (NULL, 105,'PZ','Potenza');
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (NULL, 105,'PO','Prato');
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (NULL, 105,'RG','Ragusa');
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (NULL, 105,'RA','Ravenna');
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (NULL, 105,'RC','Reggio Calabria');
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (NULL, 105,'RE','Reggio Emilia');
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (NULL, 105,'RI','Rieti');
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (NULL, 105,'RN','Rimini');
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (NULL, 105,'RM','Roma');
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (NULL, 105,'RO','Rovigo');
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (NULL, 105,'SA','Salerno');
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (NULL, 105,'SS','Sassari');
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (NULL, 105,'SV','Savona');
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (NULL, 105,'SI','Siena');
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (NULL, 105,'SR','Siracusa');
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (NULL, 105,'SO','Sondrio');
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (NULL, 105,'SU','Sud Sardegna');
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (NULL, 105,'TA','Taranto');
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (NULL, 105,'TE','Teramo');
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (NULL, 105,'TR','Terni');
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (NULL, 105,'TO','Torino');
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (NULL, 105,'TP','Trapani');
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (NULL, 105,'TN','Trento');
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (NULL, 105,'TV','Treviso');
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (NULL, 105,'TS','Trieste');
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (NULL, 105,'UD','Udine');
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (NULL, 105,'VA','Varese');
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (NULL, 105,'VE','Venezia');
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (NULL, 105,'VB','Verbano-Cusio-Ossola');
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (NULL, 105,'VC','Vercelli');
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (NULL, 105,'VR','Verona');
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (NULL, 105,'VV','Vibo Valentia');
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (NULL, 105,'VI','Vicenza');
INSERT INTO zones (zone_id, zone_country_id, zone_code, zone_name) VALUES (NULL, 105,'VT','Viterbo');

