<?php
namespace NumbersPHP\Tests;

use NumbersPHP\DSP;

/**
 * Generated by PHPUnit_SkeletonGenerator 1.2.0 on 2013-02-25 at 11:15:07.
 */
class DSPTest extends \PHPUnit_Framework_TestCase
{
    /**
     * @var DSP
     */
    protected $object;

    /**
     * Sets up the fixture, for example, opens a network connection.
     * This method is called before a test is executed.
     */
    protected function setUp()
    {
        $this->object = new DSP;
    }

    /**
     * Tears down the fixture, for example, closes a network connection.
     * This method is called after a test is executed.
     */
    protected function tearDown()
    {
    }

    /**
     * @covers NumbersPHP\DSP::segment
     */
    public function testSegment()
    {
        $this->assertEquals(array(3, 6, 9), \NumbersPHP\DSP::segment(array(1, 2, 3, 4, 5, 6, 7, 8, 9), 2, 3));
    }

    /**
     * @covers NumbersPHP\DSP::fft
     */
    public function testFft()
    {
        $result = \NumbersPHP\DSP::fft(array(1, 1, 1, 1, 0, 0, 0, 0));
        $this->assertTrue($result[0]->equals(new \NumbersPHP\Complex(4, 0), \NumbersPHP\Numbers::EPSILON));
        $this->assertFalse($result[2]->equals(new \NumbersPHP\Complex(1, -1), \NumbersPHP\Numbers::EPSILON));
        $this->assertTrue($result[4]->equals(new \NumbersPHP\Complex(4, 0), \NumbersPHP\Numbers::EPSILON));
    }
}
