tinymce.PluginManager.add('tinyzenpage', function(editor, url) {
	// Add a button that opens a window
	editor.ui.registry.addIcon('tinyZpButton', '<svg width="24" height="24" xmlns="http://www.w3.org/2000/svg" fill-rule="evenodd" stroke-linejoin="round" stroke-miterlimit="2" clip-rule="evenodd" viewBox="0 0 375 375"><path d="M213.19 305.04H24.4v-11.89L195.6 70.09H37.25v-9.51h168.33v11.9L34.4 295.52h178.79v9.51zm132.62-87.92a39.03 39.03 0 01-7.4 14.91c-3.62 4.6-8.76 8.38-15.44 11.37-6.67 3-15.3 4.48-25.86 4.48H257.5v57.16h-26.07V156.1h65.7c10.56 0 19.18 1.53 25.85 4.6 6.68 3.05 11.82 6.88 15.43 11.46a38.93 38.93 0 017.4 15.02 63.81 63.81 0 012 15.02c0 4.6-.67 9.57-2 14.92zm-26.17-27.22a19.37 19.37 0 00-5.64-7.62 20.09 20.09 0 00-8.13-3.86 44.37 44.37 0 00-9.8-1.04H257.5v49.23h38.16c2.92 0 5.91-.42 8.97-1.25 3.06-.84 5.87-2.2 8.45-4.07a20.84 20.84 0 006.26-7.51c1.6-3.13 2.4-7.06 2.4-11.79 0-4.86-.7-8.9-2.1-12.1z"/></svg>')
	editor.ui.registry.addButton('tinyzenpage', {
		icon: 'tinyZpButton',
		tooltip: 'tinyZenpage',
		onAction: () => editor.windowManager.openUrl({
			// Open window with a specific url
			title: 'tinyZenpage',
			url: url + '/tinyzenpage.php',
			size: 'normal',
			body: {
				type: 'bar',
			},
			buttons: [{
				text: 'Close',
				type: 'cancel',
				onclick: 'close'
			}]
		}),
	})
	// Add menu item action
	editor.ui.registry.addMenuItem('tinyZenpage', {
		icon: 'tinyZpButton',
		text: 'tinyZenpage',
		//context: 'tools', //context property removed in v5
		onAction: () => editor.windowManager.openUrl({
			// Open window with a specific url
			title: 'tinyZenpage',
			url: url + '/tinyzenpage.php',
			size: 'normal',
			body: {
				type: 'bar',
			},
			buttons: [{
				text: 'Close',
				type: 'cancel',
				onclick: 'close'
			}]
		}),
	})
	return {
		getMetadata: () => ({
			name: 'tinyZenpage',
			url: 'https://www.zenphoto.org/news/using-tinyzenpage/'
		})
	}
})
