Компоненти додатка
==================

Додатки є [Локаторами служб](concept-service-locators.md). Вони зберігають багато так званих
*компонентів додатку*, які надають різноманітні служби для обробки запитів. Наприклад,
компонент `urlManager` відповідає за маршрутизацію веб-запитів до потрібного контролера; 
компонент `db` надає служби для роботи з базою даних; і т. д.

Кожний компонент додатка має свій унікальний ідентифікатор, який дозволяє ідентифікувати його серед інших різноманітних компонентів
в одному і тому ж додатку. Ви можете отримати доступ до компонента за допомогою виразу:

```php
\Yii::$app->componentID
```

Наприклад, ви можете використовувати `\Yii::$app->db` для отримання [[yii\db\Connection|з’єднання з БД]],
і `\Yii::$app->cache` для отримання доступу до основного компонента [[yii\caching\Cache|кешу]], зареєстрованих в додатку.

Компонент додатка створюється при першому звертанні через попередній вираз. 
Будь-які подальші звертання будуть повертати той же екземпляр компонента.

Компонентами додатку можуть бути будь-які об’єкти. Ви можете зареєструвати їх за допомогою властивості 
[[yii\base\Application::components]] в [конфігурації додатка](structure-applications.md#application-configurations).
Наприклад,

```php
[
    'components' => [
        // реєстрація компонента "cache" за допомогою назви класу
        'cache' => 'yii\caching\ApcCache',

        // реєстрація компонента "db" за допомогою масиву конфігурації
        'db' => [
            'class' => 'yii\db\Connection',
            'dsn' => 'mysql:host=localhost;dbname=demo',
            'username' => 'root',
            'password' => '',
        ],

        // реєстрація компонента "search" за допомогою анонімної функції
        'search' => function () {
            return new app\components\SolrService;
        },
    ],
]
```

> Info: Хоча ви можете зареєструвати стільки компонентів в додатку скільки вам потрібно, все ж таки варто робити це осмислено.
  Компоненти додатку схожі на глобальні змінні. Використання дуже великої кількості компонентів додатку може потенційно зробити
  ваш код складним для тестування і подальшої підтримки. У більшості випадків ви можете просто створити локальний компонент
  і використовувати його при необхідності.


## Попереднє завантаження компонентів <span id="bootstrapping-components"></span>

Як згадувалося вище, компонент додатка буде створено при першому звертанні.
Якщо до нього не буде зроблено звертань під час запиту - його взагалі не буде створено.
Однак, за необхідності, ви можете створювати екземпляр компонента додатка для кожного запиту, навіть якщо до нього не зверталися явно.
Щоб зробити це, ви можете додати ідентифікатор компонента до властивості [[yii\base\Application::bootstrap|bootstrap]] додатка.

Наприклад, наступна конфігурація додатка завжди гарантує створення компонента `log`:

```php
[
    'bootstrap' => [
        'log',
    ],
    'components' => [
        'log' => [
            // конфігурація для компонента "log"
        ],
    ],
]
```


## Вбудовані компоненти додатку <span id="core-application-components"></span>

В Yii є декілька *вбудованих* компонентів додатку із фіксованими ідентифікаторами та конфігураціями за замовчуванням. 
Наприклад, компонент [[yii\web\Application::request|request]] використовується для збору інформації про запит 
користувача і розбору його у певний [маршрут](runtime-routing.md); компонент [[yii\base\Application::db|db]] 
являє собою з’єднання з базою даних, через яке ви можете виконувати запити до бази даних. 
Саме з допомогою цих вбудованих компонентів Yii додатки можуть обробляти запити користувача.

Нижче наведено перелік вбудованих компонентів додатку. Ви можете налаштовувати їх так само, як і інші компоненти додатку.
Коли ви сконфігуруєте вбудований компонент додатку і не вкажете клас цього компонента, то буде використовуватись 
значення за замовчуванням.

* [[yii\web\AssetManager|assetManager]]: керує колекціями ресурсів та публікацією ресурсів.
  Більш детальна інформація наведена у розділі [Ресурси](structure-assets.md).
* [[yii\db\Connection|db]]: являє собою з’єднання з базою даних, через яке ви можете виконувати запити до бази даних.
  Зверніть увагу, що, при конфігурації даного компоненту, ви маєте вказати клас компонента, разом із рештою 
  необхідних параметрів, наприклад [[yii\db\Connection::dsn]].
  Більш детальна інформація наведена у розділі [Об’єкти доступу до даних (DAO)](db-dao.md).
* [[yii\base\Application::errorHandler|errorHandler]]: здійснює обробку помилок і виключень PHP.
  Більш детальна інформація наведена у розділі [Обробка помилок](runtime-handling-errors.md).
* [[yii\i18n\Formatter|formatter]]: форматує дані для відображення їх кінцевому користувачу. Наприклад, число може
  бути відображене із роздільниками тисячних розрядів, дата може бути зображена у розширеному форматі.
  Більш детальна інформація наведена у розділі [Форматування даних](output-formatting.md).
* [[yii\i18n\I18N|i18n]]: підтримує переклад і форматування повідомлень.
  Більш детальна інформація наведена у розділі [Інтернаціоналізація](tutorial-i18n.md).
* [[yii\log\Dispatcher|log]]: керує призначенням журналу.
  Більш детальна інформація наведена у розділі [Журналювання](runtime-logging.md).
* [[yii\swiftmailer\Mailer|mail]]: надає можливості для побудови і відправлення поштових повідомлень.
  Більш детальна інформація наведена у розділі [Робота з поштою](tutorial-mailing.md).
* [[yii\base\Application::response|response]]: являє собою об’єкт відповіді сервера кінцевим користувачам.
  Більш детальна інформація наведена у розділі [Відповіді](runtime-responses.md).
* [[yii\base\Application::request|request]]: являє собою об’єкт запиту, який сервер отримує від кінцевих користувачів.
  Більш детальна інформація наведена у розділі [Запити](runtime-requests.md).
* [[yii\web\Session|session]]: надає інформацію про сесію. 
  Даний компонент доступний тільки у [[yii\web\Application|веб-додатках]].
  Більш детальна інформація наведена у розділі [Сесії та кукі](runtime-sessions-cookies.md).
* [[yii\web\UrlManager|urlManager]]: використовується для розбору і побудови URL.
  Більш детальна інформація наведена у розділі [Маршрутизація та створення URL](runtime-routing.md).
* [[yii\web\User|user]]: надає інформацію про аутентифікацію користувача.
  Даний компонент доступний тільки у [[yii\web\Application|веб-додатках]].
  Більш детальна інформація наведена у розділі [Аутентифікація](security-authentication.md).
* [[yii\web\View|view]]: використовується для формування представлень.
  Більш детальна інформація наведена у розділі [Представлення](structure-views.md).
