Повний посібник з Yii 2.0
=========================

Даний посібник випущено відповідно до [положень про документацію Yii](https://www.yiiframework.com/doc/terms/).

All Rights Reserved.

2014 (c) Yii Software LLC.


Введення
--------

* [Про Yii](intro-yii.md)
* [Оновлення із версії 1.1](intro-upgrade-from-v1.md)


Перше знайомство
----------------

* [Встановлення Yii](start-installation.md)
* [Виконання додатків](start-workflow.md)
* [Говоримо "Привіт"](start-hello.md)
* [Робота з формами](start-forms.md)
* [Робота з базами даних](start-databases.md)
* [Генерування коду за допомогою Gii](start-gii.md)
* [Наступні кроки](start-looking-ahead.md)


Структура додатка
-----------------

* [Огляд](structure-overview.md)
* [Вхідні скрипти](structure-entry-scripts.md)
* [Додатки](structure-applications.md)
* [Компоненти додатка](structure-application-components.md)
* [Контролери](structure-controllers.md)
* [Моделі](structure-models.md)
* **TBD** [Представлення](structure-views.md)
* **TBD** [Модулі](structure-modules.md)
* **TBD** [Фільтри](structure-filters.md)
* **TBD** [Віджети](structure-widgets.md)
* **TBD** [Ресурси](structure-assets.md)
* **TBD** [Розширення](structure-extensions.md)


Обробка запитів
---------------

* **TBD** [Огляд](runtime-overview.md)
* **TBD** [Початкове завантаження](runtime-bootstrapping.md)
* **TBD** [Маршрутизація та створення URL](runtime-routing.md)
* **TBD** [Запити](runtime-requests.md)
* **TBD** [Відповіді](runtime-responses.md)
* **TBD** [Сесії та кукі](runtime-sessions-cookies.md)
* **TBD** [Обробка помилок](runtime-handling-errors.md)
* **TBD** [Журналювання](runtime-logging.md)


Основні поняття
---------------

* **TBD** [Компоненти](concept-components.md)
* **TBD** [Властивості](concept-properties.md)
* **TBD** [Події](concept-events.md)
* **TBD** [Поведінки](concept-behaviors.md)
* **TBD** [Конфігурації](concept-configurations.md)
* [Псевдоніми](concept-aliases.md)
* [Автозавантаження класів](concept-autoloading.md)
* **TBD** [Локатор служб](concept-service-locator.md)
* **TBD** [Dependency Injection Container](concept-di-container.md)


Робота з базами даних
---------------------

* **TBD** [Обʼєкти доступу до даних (DAO)](db-dao.md): Зʼєднання з базою даних, прості запити, транзакції і робота зі схемою
* **TBD** [Конструктор запитів](db-query-builder.md): Запити до бази даних через простий шар абстракції
* **TBD** [Active Record](db-active-record.md): Отримання обʼєктів AR, робота з ними та визначення звʼязків
* **TBD** [Міграції](db-migrations.md): Контроль версій схеми даних при роботі в команді
* [Sphinx](https://github.com/yiisoft/yii2-sphinx/blob/master/docs/guide/README.md)
* [Redis](https://github.com/yiisoft/yii2-redis/blob/master/docs/guide/README.md)
* [MongoDB](https://github.com/yiisoft/yii2-mongodb/blob/master/docs/guide/README.md)
* [ElasticSearch](https://github.com/yiisoft/yii2-elasticsearch/blob/master/docs/guide/README.md)


Отримання даних від користувача
-------------------------------

* **TBD** [Створення форм](input-forms.md)
* **TBD** [Перевірка вводу](input-validation.md)
* **TBD** [Завантаження файлів](input-file-uploading.md)
* **TBD** [Збір табличного вводу](input-tabular-input.md)
* **TBD** [Робота з декількома моделями](input-multiple-models.md)


Відображення даних
------------------

* **TBD** [Форматування даних](output-formatting.md)
* **TBD** [Розділення на сторінки](output-pagination.md)
* **TBD** [Сортування](output-sorting.md)
* **TBD** [Провайдери даних](output-data-providers.md)
* **TBD** [Віджети даних](output-data-widgets.md)
* **TBD** [Робота з клієнтськими скриптами](output-client-scripts.md)
* **TBD** [Темізація](output-theming.md)


Безпека
-------

* **TBD** [Аутентифікація](security-authentication.md)
* **TBD** [Авторизація](security-authorization.md)
* **TBD** [Робота з паролями](security-passwords.md)
* [Клієнти авторизації](https://github.com/yiisoft/yii2-authclient/blob/master/docs/guide/README.md)
* **TBD** [Кращі практики](security-best-practices.md)


Кешування
---------

* **TBD** [Огляд](caching-overview.md)
* **TBD** [Кешування даних](caching-data.md)
* [Кешування фрагментів](caching-fragment.md)
* **TBD** [Кешування сторінок](caching-page.md)
* **TBD** [HTTP кешування](caching-http.md)


Веб-сервіси RESTful
-------------------

* [Швидкий старт](rest-quick-start.md)
* **TBD** [Ресурси](rest-resources.md)
* **TBD** [Контролери](rest-controllers.md)
* **TBD** [Маршрутизація](rest-routing.md)
* **TBD** [Форматування відповіді](rest-response-formatting.md)
* **TBD** [Аутентифікація](rest-authentication.md)
* [Обмеження частоти запитів](rest-rate-limiting.md)
* **TBD** [Версіонування](rest-versioning.md)
* **TBD** [Обробка помилок](rest-error-handling.md)


Інструменти розробника
----------------------

* [Панель налагодження та налагоджувач](https://github.com/yiisoft/yii2-debug/blob/master/docs/guide-uk/README.md)
* [Генерування коду за допомогою Gii](https://github.com/yiisoft/yii2-gii/blob/master/docs/guide-uk/README.md)
* **TBD** [Генерування документації API](https://github.com/yiisoft/yii2-apidoc)


Тестування
----------

* **TBD** [Огляд](test-overview.md)
* **TBD** [Налаштування середовища тестування](test-environment-setup.md)
* **TBD** [Модульні тести](test-unit.md)
* **TBD** [Функціональні тести](test-functional.md)
* **TBD** [Приймальні тести](test-acceptance.md)
* **TBD** [Фікстури](test-fixtures.md)


Спеціальні теми
---------------

* **TBD** [Розширений шаблон проекту](https://github.com/yiisoft/yii2-app-advanced/blob/master/docs/guide-uk/README.md)
* [Створення додатка з нуля](tutorial-start-from-scratch.md)
* [Консольні додатки](tutorial-console.md)
* **TBD** [Основні валідатори](tutorial-core-validators.md)
* **TBD** [Інтернаціоналізація](tutorial-i18n.md)
* **TBD** [Робота з поштою](tutorial-mailing.md)
* **TBD** [Покращення швидкодії](tutorial-performance-tuning.md)
* **TBD** [Робота на віртуальному хостингу](tutorial-shared-hosting.md)
* [Шаблонізатори](tutorial-template-engines.md)
* [Робота із стороннім кодом](tutorial-yii-integration.md)


Віджети
-------

* GridView: **TBD** link to demo page
* ListView: **TBD** link to demo page
* DetailView: **TBD** link to demo page
* ActiveForm: **TBD** link to demo page
* Pjax: **TBD** link to demo page
* Menu: **TBD** link to demo page
* LinkPager: **TBD** link to demo page
* LinkSorter: **TBD** link to demo page
* [Віджети Bootstrap](https://github.com/yiisoft/yii2-bootstrap/blob/master/docs/guide-uk/README.md)
* [Віджети jQuery UI](https://github.com/yiisoft/yii2-jui/blob/master/docs/guide-uk/README.md)


Хелпери
-------

* **TBD** [Огляд хелперів](helper-overview.md)
* **TBD** [ArrayHelper](helper-array.md)
* **TBD** [Html](helper-html.md)
* **TBD** [Url](helper-url.md)
