'use strict';

/* {[The file is published on the basis of YetiForce Public License 7.0 that can be found in the following directory: licenses/LicenseEN.txt or yetiforce.com]} */"use strict";Vtiger_Edit_Js("SMSNotifier_Edit_Js",{},{/**
		 * Load variables panel
		 * @param {jQuery} form
		 */loadVariablePanel:function loadVariablePanel(form){var _this=this,panel=form.find("#variablePanel"),reletedField=form.find("[name=\"related_to\"]"),sourceRecord=parseInt(reletedField.val()),sourceModule=reletedField.closest(".fieldValue ").find("input[name=\"popupReferenceModule\"]").val();return sourceRecord?void(panel.progressIndicator(),AppConnector.request({module:"SMSNotifier",record:app.getRecordId(),view:"VariablePanel",type:"sms",sourceRecord:sourceRecord,selectedModule:sourceModule}).done(function(response){panel.html(response),_this.afterLoadVariablePanel(panel),App.Tools.VariablesPanel.registerRefreshCompanyVariables(panel);}).fail(function(){panel.progressIndicator({mode:"hide"});})):(panel.html(""),!1)},/**
		 * Events after load variables panel
		 * @param {jQuery} html
		 */afterLoadVariablePanel:function afterLoadVariablePanel(html){App.Fields.Picklist.showSelect2ElementView(html.find("select.select2")),App.Fields.Text.registerCopyClipboard(html);},/**
		 * Register variables panel events
		 * @param {jQuery} form
		 */registerVariablePanelEvent:function registerVariablePanelEvent(form){var _this2=this;"undefined"==typeof form&&(form=this.getForm()),form.find("[name=\"message\"]").closest(".js-block-content").prepend("<div id=\"variablePanel\" class=\"row px-0 borderBottom bc-gray-lighter mt-n1\"></div>"),this.loadVariablePanel(form),form.find("[name=\"target\"]").on("change",function(){_this2.loadVariablePanel(form);});},/**
		 * Register phone change
		 */registerPhoneChange:function registerPhoneChange(){this.getForm().find(".js-phone-change").on("click",function(e){var phoneField=$(e.currentTarget).closest(".fieldValue").find("input[name]"),value=e.currentTarget.dataset.value;phoneField.length&&value&&phoneField.val(value).trigger("focusout");});},/**
		 * Register basic events
		 * @param {jQuery} container
		 */registerBasicEvents:function registerBasicEvents(container){this._super(container),this.registerVariablePanelEvent(container),App.Tools.VariablesPanel.registerRefreshCompanyVariables(container),App.Tools.VariablesPanel.refreshCompanyVariables(container),new App.Fields.Text.Completions(container.find("[name=\"message\"]"),{completionsCollection:{emojis:!0},autolink:!1}),this.registerPhoneChange();}});
//# sourceMappingURL=Edit.min.js.map
