<?php

use App\Language;
use App\Record;

/**
 * Check Links handler.
 *
 * @package Handler
 *
 * @copyright YetiForce S.A.
 * @license YetiForce Public License 7.0 (licenses/LicenseEN.txt or yetiforce.com)
 * @author Radosław Skrzypczak <r.skrzypczak@yetiforce.com>
 */
class Products_CheckLinks_Handler
{
	/**
	 * Register pre delete.
	 *
	 * @param App\EventHandler $eventHandler
	 *
	 * @return array
	 */
	public function preDelete(App\EventHandler $eventHandler)
	{
		$recordModel = $eventHandler->getRecordModel();
		$result = ['result' => true];
		if (Record::isRelatedToInventory($recordModel->getId())) {
			$result = [
				'result' => false,
				'type' => 'confirm',
				'message' => Language::translate('LBL_CONFIRM_DELETE_WHEN_HAS_RELATION_IN_INVENTORY', $recordModel->getModuleName()),
				'hash' => hash('sha256', implode('|', $recordModel->getData()))
			];
		}
		return $result;
	}

	/**
	 * Register pre state change.
	 *
	 * @param App\EventHandler $eventHandler
	 *
	 * @return array
	 */
	public function preStateChange(App\EventHandler $eventHandler)
	{
		$recordModel = $eventHandler->getRecordModel();
		$recordId = $recordModel->getId();
		$result = ['result' => true];
		if (Record::STATE_TRASH === ($recordModel->ext['newState'] ?? null) && Record::isRelatedToInventory($recordId)) {
			$result = [
				'result' => false,
				'type' => 'confirm',
				'message' => Language::translate('LBL_CONFIRM_DELETE_WHEN_HAS_RELATION_IN_INVENTORY', $recordModel->getModuleName()),
				'hash' => hash('sha256', implode('|', $recordModel->getData()))
			];
		}
		return $result;
	}
}
