<?php
/**
 * OpenStreetMap module config.
 *
 * @copyright YetiForce S.A.
 * @license   YetiForce Public License 7.0 (licenses/LicenseEN.txt or yetiforce.com)
 */
return [
	'cronMaxUpdatedAddresses' => [
		'default' => 1000,
		'description' => 'Number of entries to be updated in one run of cron',
		'validation' => '\App\Validator::naturalNumber',
		'docTags' => ['var' => 'int'],
	],
	'mapModules' => [
		'default' => ['Accounts', 'Contacts', 'Competition', 'Vendors', 'Partners', 'Leads', 'Locations'],
		'description' => 'Allow modules.',
		'validation' => static function () {
			$arg = func_get_arg(0);
			return \is_array($arg) && \count($arg) === \count(array_filter($arg, static fn ($v) => \App\Validator::alnum($v)));
		},
		'docTags' => ['var' => 'string[]'],
	],
	'mapPinFields' => [
		'default' => [
			'Accounts' => ['accountname', 'email1', 'phone'],
			'Leads' => ['company', 'firstname', 'lastname', 'email'],
			'Partners' => ['subject', 'email'],
			'Competition' => ['subject', 'email'],
			'Vendors' => ['vendorname', 'email', 'website'],
			'Contacts' => ['firstname', 'lastname', 'email', 'phone'],
			'Locations' => ['subject', 'email']
		],
		'description' => 'List of fields from which to show information in the map pin',
		'validation' => static function () {
			$arg = func_get_arg(0);
			return \is_array($arg) && \count($arg) === \count(array_filter($arg, static fn ($v, $k) => \App\Validator::alnum($k) && \is_array($v) && \count($v) === \count(array_filter($v, static fn ($i) => \App\Validator::alnum($i))), ARRAY_FILTER_USE_BOTH));
		},
		'docTags' => ['var' => 'array'],
	],
];
