<?php
/* +***********************************************************************************
 * The contents of this file are subject to the vtiger CRM Public License Version 1.0
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is:  vtiger CRM Open Source
 * The Initial Developer of the Original Code is vtiger.
 * Portions created by vtiger are Copyright (C) vtiger.
 * All Rights Reserved.
 * *********************************************************************************** */

use App\Installer\Installer;

class Install_InitSchema_Model
{
	private Installer $installer;

	public function __construct()
	{
		$this->installer = (new Installer());
	}

	/**
	 * Function starts applying schema changes.
	 */
	public function initialize(): void
	{
		$this->initializeDatabase();

		if ($_SESSION['installation_success'] ?? false) {
			$this->installer->setLanguage($_SESSION['language'] ?? '');
			$this->installer->setCurrency($_SESSION['config_file_info']['currency_name'] ?? '');
			$this->installer->createConfigFiles();
			$this->installer->updateVersion();
			$this->installer->prepareAdminUser(
				$_SESSION['config_file_info']['user_name'],
				$_SESSION['config_file_info']['password'],
				$_SESSION['config_file_info']['admin_email'],
				$_SESSION['config_file_info']['firstname'],
				$_SESSION['config_file_info']['lastname'],
				$_SESSION['config_file_info']['dateformat'],
			);
			$this->installer->recalculateSharingRules();
		}
	}

	/**
	 * Check if database is initialized.
	 *
	 * @return bool
	 */
	public function isInitialized(): bool
	{
		return $this->installer->isDbInitialized();
	}

	/**
	 * Execute database migrations.
	 *
	 * @return void
	 */
	public function initializeDatabase(): void
	{
		try {
			if (!$migrator = $this->installer->getMigrator()) {
				throw new \Api\Core\Exception('Missing DB configuration!');
			}
			$migrator->migrate();
			$_SESSION['installation_success'] = true;
		} catch (Throwable $e) {
			\App\Log::error($e->__toString(), 'Install');
			$_SESSION['installation_success'] = false;
			$_SESSION['installation_failed_reason'] = $e->__toString();
		}
	}
}
