<?php
/**
 * YetiForce shop Pbx BriaSoftphone file.
 *
 * @package App
 *
 * @copyright YetiForce S.A.
 * @license   YetiForce Public License 7.0 (licenses/LicenseEN.txt or yetiforce.com)
 * @author    Mariusz Krzaczkowski <m.krzaczkowski@yetiforce.com>
 */

namespace App\YetiForce\Shop\Product;

use App\Security\AdminAccess;
use App\YetiForce\Shop\AbstractBaseProduct;

/**
 * YetiForce shop Pbx BriaSoftphone class.
 */
class YetiForcePbxBriaSoftphone extends AbstractBaseProduct
{
	/** {@inheritdoc} */
	public function getAdditionalButtons(): array
	{
		$links = [];
		if ($this->website) {
			$links[] = \Vtiger_Link_Model::getInstanceFromValues([
				'linklabel' => 'Website',
				'relatedModuleName' => '_Base',
				'linkicon' => 'fas fa-globe mr-2',
				'linkhref' => true,
				'linkExternal' => true,
				'linktarget' => '_blank',
				'linkurl' => $this->website,
				'linkclass' => 'btn-outline-primary',
				'showLabel' => 1,
			]);
		}

		$links[] = \Vtiger_Link_Model::getInstanceFromValues([
			'linklabel' => 'counterpath.com',
			'relatedModuleName' => 'Settings:_Base',
			'linkicon' => 'fa-solid fa-link',
			'linkhref' => true,
			'linkExternal' => true,
			'linktarget' => '_blank',
			'linkurl' => 'https://www.counterpath.com/teams-pricing/',
			'linkclass' => 'btn-outline-primary',
			'showLabel' => 1,
		]);

		if (AdminAccess::isPermitted('PBX')) {
			$links[] = \Vtiger_Link_Model::getInstanceFromValues([
				'linklabel' => 'LBL_PBX',
				'relatedModuleName' => 'Settings:PBX',
				'linkicon' => 'yfi yfi-pbx',
				'linkhref' => true,
				'linkurl' => 'index.php?parent=Settings&module=PBX&view=List',
				'linkclass' => 'btn-primary',
				'showLabel' => 1,
			]);
		}

		return $links;
	}
}
