'use strict';

/*+***********************************************************************************
 * The contents of this file are subject to the vtiger CRM Public License Version 1.0
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is:  vtiger CRM Open Source
 * The Initial Developer of the Original Code is vtiger.
 * Portions created by vtiger are Copyright (C) vtiger.
 * All Rights Reserved.
 * Contributor(s): YetiForce S.A.
 *************************************************************************************/"use strict";function _typeof(o){"@babel/helpers - typeof";return _typeof="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(o){return typeof o}:function(o){return o&&"function"==typeof Symbol&&o.constructor===Symbol&&o!==Symbol.prototype?"symbol":typeof o},_typeof(o)}jQuery.Class("Vtiger_Detail_Js",{detailInstance:!1,getInstance:function getInstance(){if(!1==Vtiger_Detail_Js.detailInstance){var instance,moduleClassName=app.getModuleName()+"_"+app.getViewName()+"_Js";instance="undefined"==typeof window[moduleClassName]?new Vtiger_Detail_Js:new window[moduleClassName],Vtiger_Detail_Js.detailInstance=instance;}return Vtiger_Detail_Js.detailInstance},/*
		 * function to trigger Detail view actions
		 * @params: Action url , callback function.
		 */triggerDetailViewAction:function triggerDetailViewAction(detailActionUrl,callBackFunction){var detailInstance=Vtiger_Detail_Js.getInstance(),selectedIds=[];selectedIds.push(detailInstance.getRecordId());var postData={selected_ids:JSON.stringify(selectedIds)};AppConnector.request({type:"POST",url:detailActionUrl,dataType:"html",data:postData}).done(function(data){data&&(app.showModalWindow(data,{"text-align":"left"}),"function"==typeof callBackFunction&&callBackFunction(data));}).fail(function(){});},/**
		 * Function to trigger SMS quick view actions
		 */triggerSMSmodal:function triggerSMSmodal(){App.Components.QuickCreate.createRecord("SMSNotifier",{noCache:!0});},reloadRelatedList:function reloadRelatedList(){var detailInstance=Vtiger_Detail_Js.getInstance(),params={};0<jQuery("[name=\"currentPageNum\"]").length&&(params.page=jQuery("[name=\"currentPageNum\"]").val()),detailInstance.loadRelatedList(params);},runRecordChanger:function runRecordChanger(id){AppConnector.request({module:app.getModuleName(),record:app.getRecordId(),action:"Save",mode:"recordChanger",id:id}).done(function(){window.location.reload();}).fail(function(jqXHR,textStatus){app.showNotify({type:"error",text:textStatus});});},showWorkflowTriggerView:function showWorkflowTriggerView(instance){$(instance).popover("hide");var detailInstance=Vtiger_Detail_Js.getInstance(),callback=function(data){var treeInstance=data.find("#treeWorkflowContents");treeInstance.jstree({core:{data:JSON.parse(data.find(".js-tree-workflow-data").val()),themes:{name:"proton",responsive:!0,icons:!1}},checkbox:{three_state:!1},plugins:["search","category"]}),data.find("[type=\"submit\"]").on("click",function(){var tasks={},selected=treeInstance.jstree("getCategory",!0);$.each(selected,function(index,treeElement){"record"===treeElement.attr&&(tasks[treeElement.record_id]=[]);}),$.each(selected,function(index,treeElement){tasks[treeElement.parent]!==void 0&&"task"===treeElement.attr&&tasks[treeElement.parent].push(treeElement.record_id);}),0===Object.keys(tasks).length?app.showNotify({title:app.vtranslate("JS_INFORMATION"),text:app.vtranslate("JS_NOT_SELECTED_WORKFLOW_TRIGGER"),type:"error"}):(app.showNotify({title:app.vtranslate("JS_MESSAGE"),text:app.vtranslate("JS_STARTED_PERFORM_WORKFLOW"),type:"info"}),AppConnector.request({module:app.getModuleName(),action:"Workflow",mode:"execute",user:data.find("[name=\"user\"]").val(),record:detailInstance.getRecordId(),tasks:JSON.stringify(tasks)}).done(function(){app.showNotify({title:app.vtranslate("JS_MESSAGE"),text:app.vtranslate("JS_COMPLETED_PERFORM_WORKFLOW"),type:"success"}),app.hideModalWindow(),detailInstance.loadWidgets();}).fail(function(){app.showNotify({title:app.vtranslate("JS_ERROR"),text:app.vtranslate("JS_ERROR_DURING_TRIGGER_OF_WORKFLOW"),type:"error"}),app.hideModalWindow();}));});};AppConnector.request({module:app.getModuleName(),view:"WorkflowTrigger",record:detailInstance.getRecordId()}).done(function(data){data&&app.showModalWindow(data,"",callback);});}},{targetPicklistChange:!1,targetPicklist:!1,detailViewContentHolder:!1,detailViewForm:!1,detailViewDetailsTabLabel:"LBL_RECORD_DETAILS",detailViewSummaryTabLabel:"LBL_RECORD_SUMMARY",detailViewRecentCommentsTabLabel:"ModComments",detailViewRecentActivitiesTabLabel:"Activities",detailViewRecentUpdatesTabLabel:"LBL_UPDATES",detailViewRecentDocumentsTabLabel:"Documents",fieldUpdatedEvent:"Vtiger.Field.Updated",//Filels list on updation of which we need to upate the detailview header
updatedFields:["company","designation","title"],//Event that will triggered before saving the ajax edit of fields
fieldPreSave:"Vtiger.Field.PreSave",tempData:[],//constructor
init:function init(){},loadWidgetsEvents:function loadWidgetsEvents(){var thisInstance=this;app.event.on("DetailView.Widget.AfterLoad",function(e,widgetContent,relatedModuleName){"Calendar"===relatedModuleName&&thisInstance.reloadWidgetActivitesStats(widgetContent.closest(".activityWidgetContainer")),"ModComments"===relatedModuleName&&thisInstance.registerCommentEventsInDetail(widgetContent.closest(".updatesWidgetContainer")),widgetContent.find("[name=\"relatedModule\"]").length&&thisInstance.registerShowSummary(widgetContent),"OSSMailView"===relatedModuleName&&(Vtiger_Index_Js.registerMailButtons(widgetContent),widgetContent.find(".showMailModal").on("click",function(e){e.preventDefault();var progressIndicatorElement=jQuery.progressIndicator();app.showModalWindow("",$(e.currentTarget).data("url")+"&noloadlibs=1",function(data){Vtiger_Index_Js.registerMailButtons(data),progressIndicatorElement.progressIndicator({mode:"hide"});});})),thisInstance.registerEmailEvents(widgetContent),"DetailView"===relatedModuleName&&thisInstance.registerBlockStatusCheckOnLoad(),thisInstance.registerCollapsiblePanels(widgetContent.closest(".js-detail-widget"));});},loadWidgets:function loadWidgets(){var _this=this,container=this.getForm(),widgetList=jQuery("[class^=\"widgetContainer_\"]"),length=widgetList.length;widgetList.each(function(index,widget){widget=$(widget),widget.is(":visible")&&_this.loadWidget(widget),length===index+1&&(container.validationEngine("detach"),container.validationEngine(app.validationEngineOptionsForRecord));}),this.registerRelatedModulesRecordCount();},loadWidget:function loadWidget(widgetContainer,params){var relatedModuleName,thisInstance=this,contentContainer=$(".js-detail-widget-content",widgetContainer);if(this.registerFilterForAddingModuleRelatedRecordFromSummaryWidget(widgetContainer),relatedModuleName=widgetContainer.find("[name=\"relatedModule\"]").length?widgetContainer.find("[name=\"relatedModule\"]").val():widgetContainer.data("name"),void 0===params){var urlParams=widgetContainer.data("url");if(null==urlParams)return;var index,queryParameters=urlParams.split("&"),keyValueMap={};for(index=0;index<queryParameters.length;index++){var queryParamComponents=queryParameters[index].split("=");keyValueMap[queryParamComponents[0]]=queryParamComponents[1];}params=keyValueMap;}var aDeferred=$.Deferred();return contentContainer.progressIndicator({}),AppConnector.request({type:"POST",async:!1,dataType:"html",data:params}).done(function(data){if(contentContainer.progressIndicator({mode:"hide"}),contentContainer.html(data),App.Fields.Picklist.showSelect2ElementView(widgetContainer.find(".select2")),app.registerModal(contentContainer),App.Components.DropFile.register(contentContainer),relatedModuleName){var relatedController=Vtiger_RelatedList_Js.getInstanceByUrl(widgetContainer.data("url"),thisInstance.getSelectedTab());relatedController.setRelatedContainer(contentContainer),relatedController.registerRelatedEvents(),thisInstance.widgetRelatedRecordView(widgetContainer,!0);var chart=contentContainer.find("[name=\"typeChart\"]");if(chart.length&&"undefined"!=typeof window.Vtiger_Widget_Js){var widgetInstance=Vtiger_Widget_Js.getInstance(contentContainer,chart.val());widgetInstance.init(contentContainer),widgetInstance.postLoadWidget();}}app.event.trigger("DetailView.Widget.AfterLoad",contentContainer,relatedModuleName,thisInstance),aDeferred.resolve(params);}).fail(function(){contentContainer.progressIndicator({mode:"hide"}),aDeferred.reject();}),aDeferred.promise()},/**
		 * Adding relationships in the products and services widget.
		 */registerWidgetProductAndServices:function registerWidgetProductAndServices(){var thisInstance=this;this.getForm().on("click",".js-widget-products-services",function(e){var currentTarget=$(e.currentTarget),params={module:app.getModuleName(),action:"RelationAjax",mode:"updateRelation",recordsToAdd:[],src_record:app.getRecordId(),related_module:currentTarget.closest(".js-detail-widget-header").find("[name=\"relatedModule\"]").val()},url=currentTarget.data("url");app.showRecordsList(url,function(_,instance){instance.setSelectEvent(function(data){for(var i in data)params.recordsToAdd.push(i);AppConnector.request(params).done(function(){thisInstance.reloadTabContent();});});});});},widgetRelatedRecordView:function widgetRelatedRecordView(container,load){var cacheKey=this.getRecordId()+"_"+container.data("id"),relatedRecordCacheID=app.moduleCacheGet(cacheKey);if(null!==relatedRecordCacheID){var newActive=container.find(".js-carousel-item[data-id = '"+relatedRecordCacheID+"']");newActive.length&&(container.find(".js-carousel-item.active").removeClass("active"),container.find(".js-carousel-item[data-id = '"+relatedRecordCacheID+"']").addClass("active"));}var controlBox=container.find(".control-widget"),prev=controlBox.find(".prev"),next=controlBox.find(".next"),active=container.find(".js-carousel-item.active");1>=container.find(".js-carousel-item").length||!active.next().length?next.addClass("disabled"):next.removeClass("disabled"),1>=container.find(".js-carousel-item").length||!active.prev().length?prev.addClass("disabled"):prev.removeClass("disabled"),load&&(next.on("click",function(){if(!$(this).hasClass("disabled")){var active=container.find(".js-carousel-item.active");active.removeClass("active");var nextElement=active.next();nextElement.addClass("active"),nextElement.next().length||next.addClass("disabled"),active.prev()&&prev.removeClass("disabled"),app.moduleCacheSet(cacheKey,nextElement.data("id"));}}),prev.on("click",function(){if(!$(this).hasClass("disabled")){var active=container.find(".js-carousel-item.active");active.removeClass("active");var prevElement=active.prev();prevElement.addClass("active"),prevElement.prev().length||prev.addClass("disabled"),active.next()&&next.removeClass("disabled"),app.moduleCacheSet(cacheKey,prevElement.data("id"));}}));},loadContents:function loadContents(url,data){var thisInstance=this,aDeferred=jQuery.Deferred(),detailContentsHolder=this.getContentHolder(),params=url;return "undefined"!=typeof data&&(params={},params.url=url,params.data=data),AppConnector.requestPjax(params).done(function(responseData){detailContentsHolder.html(responseData),responseData=detailContentsHolder.html(),thisInstance.registerBlockStatusCheckOnLoad(),App.Fields.Picklist.changeSelectElementView(detailContentsHolder),App.Fields.Date.register(detailContentsHolder),thisInstance.getForm().validationEngine(),app.event.trigger("DetailView.LoadContents.AfterLoad",responseData),aDeferred.resolve(responseData);}),aDeferred.promise()},getUpdateFieldsArray:function getUpdateFieldsArray(){return this.updatedFields},/**
		 * Function to return related tab.
		 * @return : jQuery Object.
		 */getTabByLabel:function getTabByLabel(tabLabel){var tabs=this.getTabs(),targetTab=!1;return tabs.each(function(index,element){var tab=jQuery(element),labelKey=tab.data("labelKey");if(labelKey==tabLabel)return targetTab=tab,!1}),targetTab},getTabByModule:function getTabByModule(moduleName){var relationId=1<arguments.length&&void 0!==arguments[1]?arguments[1]:"",tabs=this.getTabs(),targetTab=!1;return tabs.each(function(index,element){var tab=jQuery(element);if(tab.data("reference")==moduleName&&(!relationId||relationId&&relationId==tab.data("relation-id")))return targetTab=tab,!1}),targetTab},selectModuleTab:function selectModuleTab(){var relatedTabContainer=this.getTabContainer(),moduleTab=relatedTabContainer.find("li.module-tab");this.deSelectAllrelatedTabs(),this.markTabAsSelected(moduleTab);},deSelectAllrelatedTabs:function deSelectAllrelatedTabs(){this.getTabs().removeClass("active");},markTabAsSelected:function markTabAsSelected(tabElement){tabElement.addClass("active"),$(".related .dropdown [data-reference=\""+tabElement.data("reference")+"\"][data-relation-id=\""+tabElement.data("relation-id")+"\"]").addClass("active");},reloadTabContent:function reloadTabContent(){this.getSelectedTab().trigger("click");},getSelectedTab:function getSelectedTab(){var tabContainer=this.getTabContainer();return tabContainer.find(".js-detail-tab.active:not(.d-none)")},getTabContainer:function getTabContainer(){return jQuery("div.related")},getTabs:function getTabs(){var topTabs=this.getTabContainer().find("li.js-baseLink:not(.d-none)"),dropdownMenuTabs=this.getTabContainer().find("li:not(.js-baseLink)");return dropdownMenuTabs.each(function(){var currentTarget=jQuery(this),iteration=currentTarget.data("iteration"),className=currentTarget.hasClass("mainNav")?"mainNav":"relatedNav";null!=iteration&&1>topTabs.filter("."+className+"[data-iteration=\""+iteration+"\"]").length&&topTabs.push(currentTarget.get(0));}),topTabs},getContentHolder:function getContentHolder(){return !1==this.detailViewContentHolder&&(this.detailViewContentHolder=jQuery("div.details div.contents")),this.detailViewContentHolder},/**
		 * Function which will give the detail view form
		 * @return : jQuery element
		 */getForm:function getForm(){return !1==this.detailViewForm&&(this.detailViewForm=jQuery("#detailView")),this.detailViewForm},getRecordId:function getRecordId(){return app.getRecordId()},getRelatedModuleName:function getRelatedModuleName(){if(1==jQuery(".relatedModuleName",this.getContentHolder()).length)return jQuery(".relatedModuleName",this.getContentHolder()).val()},getRelatedListCurrentPageNum:function getRelatedListCurrentPageNum(){return jQuery("input[name=\"currentPageNum\"]",this.getContentHolder()).val()},/**
		 * function to hide button action.
		 */hideButtonAction:function hideButtonAction(){$(".js-hb__container").removeClass("u-hidden-block__opened");},/**
		 * function to get the Comment thread for the given parent.
		 * params: Url to get the Comment thread
		 */getCommentThread:function getCommentThread(url){var aDeferred=jQuery.Deferred();return AppConnector.request(url).done(function(data){aDeferred.resolve(data);}).fail(function(){}),aDeferred.promise()},/**
		 * Function to save comment
		 */saveCommentAjax:function saveCommentAjax(element,commentMode,commentContentValue,editCommentReason,commentId,parentCommentId,aDeferred){var thisInstance=this,progressIndicatorElement=jQuery.progressIndicator({}),commentInfoBlock=element.closest(".js-comment-single"),relatedTo=commentInfoBlock.find(".related_to").val();relatedTo||(relatedTo=thisInstance.getRecordId());var postData={action:"SaveAjax",commentcontent:commentContentValue,related_to:relatedTo,module:"ModComments"};"edit"==commentMode?(postData.fromView="QuickEdit",postData.record=commentId,postData.reasontoedit=editCommentReason,postData.parent_comments=parentCommentId):"add"==commentMode&&(postData.parent_comments=commentId),AppConnector.request(postData).done(function(data){progressIndicatorElement.progressIndicator({mode:"hide"}),"add"==commentMode&&thisInstance.addRelationBetweenRecords("ModComments",data.result._recordId,thisInstance.getTabByLabel(thisInstance.detailViewRecentCommentsTabLabel),{relationId:null}),app.event.trigger("DetailView.SaveComment.AfterAjax",commentInfoBlock,postData,data),aDeferred.resolve(data);}).fail(function(textStatus,errorThrown){progressIndicatorElement.progressIndicator({mode:"hide"}),element.removeAttr("disabled"),aDeferred.reject(textStatus,errorThrown);});},saveComment:function saveComment(e){var errorMsg,editCommentReason,aDeferred=jQuery.Deferred(),currentTarget=jQuery(e.currentTarget),commentMode=currentTarget.data("mode"),closestCommentBlock=currentTarget.closest(".js-add-comment-block"),commentContent=closestCommentBlock.find(".js-comment-content"),commentContentValue=commentContent.html();if(""===commentContentValue)return errorMsg=app.vtranslate("JS_LBL_COMMENT_VALUE_CANT_BE_EMPTY"),commentContent.validationEngine("showPrompt",errorMsg,"error","bottomLeft",!0),aDeferred.reject(errorMsg),aDeferred.promise();commentContent.val(commentContentValue);var resultOfValidation=Vtiger_MaxSizeInByte_Validator_Js.invokeValidation(commentContent);if("undefined"!=typeof resultOfValidation)return commentContent.validationEngine("showPrompt",resultOfValidation,"","topLeft",!0),aDeferred.reject(resultOfValidation),aDeferred.promise();"edit"===commentMode&&(editCommentReason=closestCommentBlock.find("[name=\"reasonToEdit\"]").val());var element=jQuery(e.currentTarget),commentInfoHeader=closestCommentBlock.closest(".js-comment-details").find(".js-comment-info-header"),commentId=commentInfoHeader.data("commentid"),parentCommentId=commentInfoHeader.data("parentcommentid");return this.saveCommentAjax(element,commentMode,commentContentValue,editCommentReason,commentId,parentCommentId,aDeferred),aDeferred.promise()},/**
		 * function to return the UI of the comment.
		 * return html
		 */getCommentUI:function getCommentUI(commentId){var aDeferred=jQuery.Deferred();return AppConnector.request({view:"DetailAjax",module:"ModComments",record:commentId}).done(function(data){aDeferred.resolve(data);}).fail(function(){}),aDeferred.promise()},/**
		 * function to return cloned add comment block
		 * return jQuery Obj.
		 */getCommentBlock:function getCommentBlock(){var clonedCommentBlock=jQuery(".basicAddCommentBlock",this.getContentHolder()).clone(!0,!0).removeClass("basicAddCommentBlock d-none").addClass("js-add-comment-block");return clonedCommentBlock.find(".commentcontenthidden").removeClass("commentcontenthidden").addClass("js-comment-content"),clonedCommentBlock},/**
		 * function to return cloned edit comment block
		 * return jQuery Obj.
		 */getEditCommentBlock:function getEditCommentBlock(){var clonedCommentBlock=jQuery(".basicEditCommentBlock",this.getContentHolder()).clone(!0,!0).removeClass("basicEditCommentBlock d-none").addClass("js-add-comment-block");return clonedCommentBlock.find(".commentcontenthidden").removeClass("commentcontenthidden").addClass("js-comment-content"),new App.Fields.Text.Completions(clonedCommentBlock.find(".js-completions")),clonedCommentBlock},/*
		 * Function to register the submit event for Send Sms
		 */registerSendSmsSubmitEvent:function registerSendSmsSubmitEvent(){var thisInstance=this;jQuery("body").on("submit","#massSave",function(e){var form=jQuery(e.currentTarget),smsTextLength=form.find("#message").html().length;if(160<smsTextLength){var params={title:app.vtranslate("JS_MESSAGE"),text:app.vtranslate("LBL_SMS_MAX_CHARACTERS_ALLOWED"),type:"error"};return app.showNotify(params),!1}var submitButton=form.find(":submit");submitButton.attr("disabled","disabled"),thisInstance.SendSmsSave(form),e.preventDefault();});},/*
		 * Function to Save and sending the Sms and hide the modal window of send sms
		 */SendSmsSave:function SendSmsSave(form){var progressInstance=jQuery.progressIndicator({position:"html",blockInfo:{enabled:!0}}),SendSmsUrl=form.serializeFormData();AppConnector.request(SendSmsUrl).done(function(){app.hideModalWindow(),progressInstance.progressIndicator({mode:"hide"});}).fail(function(){});},/**
		 * Function which will register events to update the record name in the detail view when any of
		 * the name field is changed
		 */registerNameAjaxEditEvent:function registerNameAjaxEditEvent(){var thisInstance=this,detailContentsHolder=thisInstance.getContentHolder();detailContentsHolder.on(thisInstance.fieldUpdatedEvent,".nameField",function(){var form=thisInstance.getForm(),nameFields=form.data("nameFields"),recordLabel="";for(var index in nameFields){0!=index&&(recordLabel+=" ");var nameFieldName=nameFields[index];recordLabel+=form.find("[name=\""+nameFieldName+"\"]").val();}var recordLabelElement=detailContentsHolder.closest(".contentsDiv").find(".recordLabel");recordLabelElement.text(recordLabel);});},updateHeaderNameFields:function updateHeaderNameFields(){var thisInstance=this,detailContentsHolder=thisInstance.getContentHolder(),form=thisInstance.getForm(),nameFields=form.data("nameFields"),recordLabelElement=detailContentsHolder.closest(".contentsDiv").find(".recordLabel"),title="";for(var index in nameFields){var nameFieldName=nameFields[index],nameField=form.find("[name=\""+nameFieldName+"\"]");if(0<nameField.length){var recordLabel=nameField.val();title+=recordLabel+" ",recordLabelElement.find("[class=\""+nameFieldName+"\"]").text(recordLabel);}}var salutatioField=recordLabelElement.find(".salutation");if(0<salutatioField.length){var salutatioValue=salutatioField.text();title=salutatioValue+title;}recordLabelElement.attr("title",title);},registerAjaxEditEvent:function registerAjaxEditEvent(){var thisInstance=this,detailContentsHolder=thisInstance.getContentHolder();detailContentsHolder.on(thisInstance.fieldUpdatedEvent,"input,select,textarea",function(e){thisInstance.updateHeaderValues(jQuery(e.currentTarget));});},updateHeaderValues:function updateHeaderValues(currentElement){var thisInstance=this;if(currentElement.hasClass("nameField"))return thisInstance.updateHeaderNameFields(),!0;var name=currentElement.attr("name"),updatedFields=this.getUpdateFieldsArray(),detailContentsHolder=thisInstance.getContentHolder();if("-1"!=jQuery.inArray(name,updatedFields)){var recordLabel=currentElement.val(),recordLabelElement=detailContentsHolder.closest(".contentsDiv").find("."+name+"_label");recordLabelElement.text(recordLabel);}},/*
		 * Function to register the click event of url field
		 */registerUrlFieldClickEvent:function registerUrlFieldClickEvent(){var detailContentsHolder=this.getContentHolder();detailContentsHolder.on("click",".urlField",function(e){e.stopPropagation();});},/**
		 * Function to register event for related list row click
		 */registerRelatedRowClickEvent:function registerRelatedRowClickEvent(){var detailContentsHolder=this.getContentHolder();detailContentsHolder.on("click",".listViewEntries",function(e){var targetElement=jQuery(e.target,jQuery(e.currentTarget));if(!(targetElement.is("td:first-child")&&0<targetElement.children("input[type=\"checkbox\"]").length)&&!jQuery(e.target).is("input[type=\"checkbox\"]")){var elem=jQuery(e.currentTarget),recordUrl=elem.data("recordurl");"undefined"!=typeof recordUrl&&(window.location.href=recordUrl);}});},loadRelatedList:function loadRelatedList(params){var aDeferred=jQuery.Deferred();null==params&&(params={});var relatedListInstance=Vtiger_RelatedList_Js.getInstance(this.getRecordId(),app.getModuleName(),this.getSelectedTab(),this.getRelatedModuleName());return relatedListInstance.loadRelatedList(params).done(function(data){aDeferred.resolve(data);}).fail(function(textStatus,errorThrown){aDeferred.reject(textStatus,errorThrown);}),aDeferred.promise()},/**
		 * Function to register Event for Sorting
		 */registerEventForRelatedList:function registerEventForRelatedList(){var self=this,detailContentsHolder=this.getContentHolder(),relatedModuleName=self.getRelatedModuleName();if(relatedModuleName){var relatedController=Vtiger_RelatedList_Js.getInstance(self.getRecordId(),app.getModuleName(),self.getSelectedTab(),relatedModuleName);relatedController.setRelatedContainer(detailContentsHolder),relatedController.registerRelatedEvents();}detailContentsHolder.find(".detailViewBlockLink").each(function(n,block){self.reloadDetailViewBlock($(block),!1);}),detailContentsHolder.find(".detailViewBlockLink .blockHeader").on("click",function(e){var target=$(e.target);return !(target.is("input")||target.is("button")||target.parents().is("button")||target.hasClass("js-stop-propagation")||target.parents().hasClass("js-stop-propagation"))&&void self.reloadDetailViewBlock($(this).closest(".js-toggle-panel"))});},/**
		 * Function to reload detail view block
		 * @param {$} block - Jquery container.
		 */reloadDetailViewBlock:function reloadDetailViewBlock(block){var progressIndicator=!(1<arguments.length&&arguments[1]!==void 0)||arguments[1],self=this,blockContent=block.find(".blockContent"),isEmpty=blockContent.is(":empty"),url=block.data("url");blockContent.is(":visible")&&url&&(progressIndicator&&blockContent.progressIndicator(),AppConnector.request(url).done(function(response){blockContent.html(response);var relatedController=Vtiger_RelatedList_Js.getInstanceByUrl(url,self.getSelectedTab());relatedController.setRelatedContainer(blockContent),isEmpty?relatedController.registerRelatedEvents():(relatedController.registerPostLoadEvents(),relatedController.registerListEvents());}));},registerBlockStatusCheckOnLoad:function registerBlockStatusCheckOnLoad(){var blocks=this.getContentHolder().find(".js-toggle-panel"),module=app.getModuleName();blocks.each(function(index,block){var currentBlock=jQuery(block),dynamicAttr=currentBlock.attr("data-dynamic");if(_typeof(dynamicAttr)!=="undefined"&&!1!==dynamicAttr){var headerAnimationElement=currentBlock.find(".js-block-toggle").not(".d-none"),bodyContents=currentBlock.closest(".js-toggle-panel").find(".blockContent"),blockId=headerAnimationElement.data("id"),value=app.cacheGet(module+"."+blockId,null);null!=value&&(1==value?(headerAnimationElement.addClass("d-none"),currentBlock.find("[data-mode='show']").removeClass("d-none"),bodyContents.removeClass("d-none")):(headerAnimationElement.addClass("d-none"),currentBlock.find("[data-mode='hide']").removeClass("d-none"),bodyContents.addClass("d-none")));}});},/**
		 * Function to handle the ajax edit for detailview and summary view fields
		 * which will expects the currentTdElement
		 */ajaxEditHandling:function ajaxEditHandling(currentTdElement){var thisInstance=this,readRecord=$(".setReadRecord"),detailViewValue=$(".value",currentTdElement),editElement=$(".edit",currentTdElement),actionElement=$(".js-detail-quick-edit",currentTdElement),fieldElement=$(".fieldname",editElement);readRecord.prop("disabled",!0),$(fieldElement).each(function(index,element){var fieldName=$(element).val(),elementTarget=$(element),elementName=-1==$.inArray(elementTarget.data("type"),["taxes","sharedOwner","multipicklist","multiListFields","multiDomain","mailScannerFields","mailScannerActions","multipicklistTags"])?fieldName:fieldName+"[]",fieldElement=$("[name=\""+elementName+"\"]:not([type=\"hidden\"])",editElement);if(("disabled"!=fieldElement.attr("disabled")||"password"===fieldElement.attr("type"))&&!(0>=editElement.length)&&!editElement.is(":visible")){fieldElement.attr("data-inputmask")&&fieldElement.inputmask(),detailViewValue.addClass("d-none"),actionElement.addClass("d-none"),editElement.removeClass("d-none").children().filter("input[type!=\"hidden\"]input[type!=\"image\"],select").filter(":first").focus();var saveHandler=function saveHandler(e){function toStr(v){return void 0===v||null===v?"":v+""}elementTarget.closest(".blockContent.d-none").siblings(".blockHeader").trigger("click"),thisInstance.registerNameAjaxEditEvent();var element=$(e.target);if(!($(e.currentTarget).find(".dateTimePickerField").length&&(element.closest(".drp-calendar").length||element.hasClass("drp-calendar")))&&!(element.closest(".fieldValue").is(currentTdElement)||element.closest(".pnotify-modal").length||element.hasClass("select2-selection__choice__remove")||element.closest(".select2-container--open").length||element.parents(".clockpicker-popover").length)){currentTdElement.removeAttr("tabindex"),currentTdElement.removeClass("is-edit-active");var previousValue=elementTarget.data("prevValue"),editElement=elementTarget.closest(".edit"),ajaxEditNewValue=0<editElement.find("[name=\""+elementName+"\"]").length?editElement.find("[name=\""+elementName+"\"]").val():editElement.find("[name=\""+fieldName+"\"]").val(),fieldInfo=Vtiger_Field_Js.getInstance(fieldElement.data("fieldinfo")),dateTimeField=[],dateTime=!1;if(2==editElement.find("[data-fieldinfo]").length&&editElement.find("[data-fieldinfo]").each(function(){var field={name:$(this).attr("name"),type:$(this).data("fieldinfo").type};"datetime"==field.type&&(dateTime=!0),dateTimeField.push(field);}),fieldElement.is("input:checkbox")&&(ajaxEditNewValue=fieldElement.is(":checked")?"1":"0",fieldElement=fieldElement.filter("[type=\"checkbox\"]")),fieldElement.validationEngine("validate"))return void(fieldElement.attr("data-inputmask")&&fieldElement.inputmask());if(fieldElement.validationEngine("hide"),toStr(previousValue)===toStr(ajaxEditNewValue))editElement.addClass("d-none"),detailViewValue.removeClass("d-none"),actionElement.removeClass("d-none"),readRecord.prop("disabled",!1),editElement.off("clickoutside");else {var preFieldSaveEvent=jQuery.Event(thisInstance.fieldPreSave);if(fieldElement.trigger(preFieldSaveEvent,{fieldValue:ajaxEditNewValue,recordId:thisInstance.getRecordId()}),preFieldSaveEvent.isDefaultPrevented())return void readRecord.prop("disabled",!1);editElement.addClass("d-none"),Vtiger_Edit_Js.saveAjax(thisInstance.getCustomFieldNameValueMap({field:fieldName,value:ajaxEditNewValue})).done(function(response){if(editElement.off("clickoutside"),readRecord.prop("disabled",!1),detailViewValue.removeClass("d-none"),actionElement.removeClass("d-none"),!!response.success){var postSaveRecordDetails=response.result,displayValue=postSaveRecordDetails[fieldName].display_value,prevDisplayValue=postSaveRecordDetails[fieldName].prev_display_value;if(dateTimeField.length&&dateTime&&(displayValue=postSaveRecordDetails[dateTimeField[0].name].display_value+" "+postSaveRecordDetails[dateTimeField[1].name].display_value),detailViewValue.html(displayValue),app.showNotify({title:app.vtranslate("JS_SAVE_NOTIFY_OK"),text:"<b>"+fieldInfo.data.label+"</b><br><b>"+app.vtranslate("JS_SAVED_FROM")+"</b>: "+prevDisplayValue+"<br> <b>"+app.vtranslate("JS_SAVED_TO")+"</b>: "+displayValue,type:"info",textTrusted:!0}),!1===postSaveRecordDetails._isViewable){var urlObject=app.convertUrlToObject(window.location.href);window===window.parent?window.location.href="index.php?module="+urlObject.module+"&view=List":window.parent.location.href="index.php?module="+urlObject.module+"&view=ListPreview";}else (!1===postSaveRecordDetails._isEditable||!0===postSaveRecordDetails._reload)&&($.progressIndicator({position:"html",blockInfo:{enabled:!0}}),window===window.parent?window.location.reload():window.location.href=window.location.href.replace("view=Detail","view=DetailPreview"));fieldElement.trigger(thisInstance.fieldUpdatedEvent,{old:previousValue,new:ajaxEditNewValue}),ajaxEditNewValue=void 0===ajaxEditNewValue?"":ajaxEditNewValue,elementTarget.data("prevValue",ajaxEditNewValue),fieldElement.data("selectedValue",ajaxEditNewValue),thisInstance.targetPicklistChange&&(0<$(".js-widget-general-info",thisInstance.getForm()).length?thisInstance.targetPicklist.find(".js-detail-quick-edit").trigger("click"):thisInstance.targetPicklist.trigger("click"),thisInstance.targetPicklistChange=!1,thisInstance.targetPicklist=!1);var selectedTabElement=thisInstance.getSelectedTab();if(selectedTabElement.data("linkKey")==thisInstance.detailViewSummaryTabLabel){var detailContentsHolder=thisInstance.getContentHolder();thisInstance.reloadTabContent(),thisInstance.registerSummaryViewContainerEvents(detailContentsHolder),thisInstance.registerEventForRelatedList();}thisInstance.updateRecordsPDFTemplateBtn(thisInstance.getForm());}}).fail(function(jqXHR,textStatus,errorThrown){editElement.addClass("d-none"),detailViewValue.removeClass("d-none"),actionElement.removeClass("d-none"),editElement.off("clickoutside"),readRecord.prop("disabled",!1),app.showNotify({type:"error",title:app.vtranslate("JS_SAVE_NOTIFY_FAIL"),text:textStatus});});}}};editElement.on("clickoutside",saveHandler);}});},/**
		 * Function updates the hidden elements which is used for creating relations
		 */addElementsToQuickCreateForCreatingRelation:function addElementsToQuickCreateForCreatingRelation(container,customParams){jQuery("<input type=\"hidden\" name=\"relationOperation\" value=\"true\" >").appendTo(container),jQuery.each(customParams,function(index,value){jQuery("<input type=\"hidden\" name=\""+index+"\" value=\""+value+"\" >").appendTo(container);});},/**
		 * Function to register event for activity widget for adding
		 * event and task from the widget
		 */registerEventForActivityWidget:function registerEventForActivityWidget(){var thisInstance=this;/*
			 * Register click event for add button in Related Activities widget
			 */jQuery(".createActivity").on("click",function(e){var referenceModuleName="Calendar",recordId=thisInstance.getRecordId(),module=app.getModuleName(),element=jQuery(e.currentTarget),customParams={};customParams.sourceModule=module,customParams.sourceRecord=recordId;var fullFormUrl=element.data("url"),preQuickCreateSave=function preQuickCreateSave(data){thisInstance.addElementsToQuickCreateForCreatingRelation(data,customParams);var taskGoToFullFormButton=data.find("[class^=\"CalendarQuikcCreateContents\"]").find(".js-full-editlink"),eventsGoToFullFormButton=data.find("[class^=\"EventsQuikcCreateContents\"]").find(".js-full-editlink"),taskFullFormUrl=taskGoToFullFormButton.data("url")+"&"+fullFormUrl,eventsFullFormUrl=eventsGoToFullFormButton.data("url")+"&"+fullFormUrl;taskGoToFullFormButton.data("url",taskFullFormUrl),eventsGoToFullFormButton.data("url",eventsFullFormUrl);},callbackFunction=function callbackFunction(){thisInstance.getFiltersDataAndLoad(e),thisInstance.loadWidget($(".widgetContentBlock[data-type=\"Updates\"]"));},QuickCreateParams={};QuickCreateParams.callbackPostShown=preQuickCreateSave,QuickCreateParams.callbackFunction=callbackFunction,QuickCreateParams.data=Object.assign({},customParams),QuickCreateParams.noCache=!1,App.Components.QuickCreate.createRecord("Calendar",QuickCreateParams);});},/**
		 * Function to add module related record from summary widget
		 */registerFilterForAddingModuleRelatedRecordFromSummaryWidget:function registerFilterForAddingModuleRelatedRecordFromSummaryWidget(container){var thisInstance=this;container.find(".createRecordFromFilter").off().on("click",function(e){var currentElement=jQuery(e.currentTarget),summaryWidgetContainer=currentElement.closest(".js-detail-widget"),referenceModuleName=summaryWidgetContainer.data("moduleName"),quickcreateUrl=currentElement.data("url"),quickCreateParams={},autoCompleteFields=currentElement.data("acf"),moduleName=currentElement.closest(".js-detail-widget-header").find("[name=\"relatedModule\"]").val(),relatedParams={},postQuickCreateSave=function postQuickCreateSave(data){thisInstance.postSummaryWidgetAddRecord(data,currentElement),"ProjectTask"==referenceModuleName&&thisInstance.loadModuleSummary();};"undefined"!=typeof autoCompleteFields&&$.each(autoCompleteFields,function(index,value){relatedParams[index]=value;}),0<Object.keys(relatedParams).length&&(quickCreateParams.data=relatedParams),quickCreateParams.noCache=!0,quickCreateParams.callbackFunction=postQuickCreateSave;var quickCreate,progress=jQuery.progressIndicator({blockInfo:{enabled:!0}});quickCreate=window===window.parent?App.Components.QuickCreate:window.parent.App.Components.QuickCreate,quickCreate.getForm(quickcreateUrl,moduleName,quickCreateParams).done(function(data){quickCreate.showModal(data,quickCreateParams,currentElement),progress.progressIndicator({mode:"hide"});});}),container.find("button.selectRelation").off("click").on("click",function(e){var summaryWidgetContainer=jQuery(e.currentTarget).closest(".js-detail-widget"),referenceModuleName=summaryWidgetContainer.data("moduleName"),restrictionsField=$(this).data("rf"),params={module:referenceModuleName,src_module:app.getModuleName(),src_record:thisInstance.getRecordId(),multi_select:!0,relationId:summaryWidgetContainer.data("relationId")};restrictionsField&&0<Object.keys(restrictionsField).length&&(params.search_key=restrictionsField.key,params.search_value=restrictionsField.name),app.showRecordsList(params,function(_modal,instance){instance.setSelectEvent(function(responseData){thisInstance.addRelationBetweenRecords(referenceModuleName,Object.keys(responseData),null,{relationId:params.relationId}).done(function(){thisInstance.loadWidget(summaryWidgetContainer.find(".widgetContentBlock"));});});});});},registerAddingInventoryRecords:function registerAddingInventoryRecords(){jQuery(".createInventoryRecordFromFilter").on("click",function(e){var currentElement=jQuery(e.currentTarget),createUrl=currentElement.data("url"),autoCompleteFields=currentElement.data("acf"),addidtionalParams="";"undefined"!=typeof autoCompleteFields&&$.each(autoCompleteFields,function(index,value){addidtionalParams="&"+index+"="+value,createUrl=createUrl.concat(addidtionalParams);}),window.location.href=createUrl;});},getFiltersDataAndLoad:function getFiltersDataAndLoad(e,params){var data=this.getFiltersData(e,params);this.loadWidget(data.container,data.params);},getFiltersData:function getFiltersData(e,params){var currentElement;currentElement=e.currentTarget?jQuery(e.currentTarget):e;var summaryWidgetContainer=currentElement.closest(".js-detail-widget"),widget=summaryWidgetContainer.find(".widgetContentBlock"),url="&"+widget.data("url"),urlParams={};url.replace(/[?&]+([^=&]+)=([^&]*)/gi,function(m,key,value){urlParams[key]=value;});var urlNewParams=[];return summaryWidgetContainer.find(".js-switch, .js-filter_field").each(function(n,item){var value="",element=jQuery(item),name=element.data("urlparams");if("radio"!=element.attr("type")){var selectedFilter=element.find("option:selected").val(),fieldlable=element.data("fieldlable"),filter=element.data("filter");if("value"===element.data("return"))value=selectedFilter;else if(selectedFilter!=fieldlable)value=[[filter,"e",selectedFilter]];else return}else if(element.prop("checked")){value="undefined"==typeof element.data("on-val")?element.data("off-val"):element.data("on-val");var additionalParams=element.data("params");_typeof(additionalParams)!==(0?_typeof(void 0):"undefined")&&!1!==additionalParams&&$.each(additionalParams,function(paramName,paramValue){paramName in urlNewParams?urlNewParams[paramName].push(paramValue):urlNewParams[paramName]=paramValue;});}name&&value&&("value"===element.data("return")?urlNewParams[name]=value:name in urlNewParams?urlNewParams[name].push(value):urlNewParams[name]=[value]);}),null!=params&&$.extend(urlNewParams,params),{container:$(widget),params:$.extend(urlParams,urlNewParams)}},registerChangeFilterForWidget:function registerChangeFilterForWidget(){var thisInstance=this;jQuery(".js-switch").on("change",function(e,state){$(e.currentTarget).closest(".js-switch__btn").addClass("active").siblings().removeClass("active"),thisInstance.getFiltersDataAndLoad(e);}),jQuery(".js-filter_field").on("select2:select",function(e,state){thisInstance.getFiltersDataAndLoad(e);});},/**
		 * Function to register all the events related to summary view widgets
		 */registerSummaryViewContainerEvents:function registerSummaryViewContainerEvents(summaryViewContainer){var thisInstance=this;/**
			 * Function to handle the ajax edit for summary view fields
			 */ /**
			 * Function to handle actions after ajax save in summary view
			 */ /*
			 * Register the event to edit Description for related activities
			 */ /*
			 * Register click event for add button in Related widgets
			 * to add record from widget
			 */this.registerEventForActivityWidget(),this.registerChangeFilterForWidget(),this.registerAddingInventoryRecords(),summaryViewContainer.off("click").on("click",".row .js-detail-quick-edit",function(e){var currentTarget=jQuery(e.currentTarget);currentTarget.addClass("d-none");var currentTdElement=currentTarget.closest(".fieldValue");thisInstance.ajaxEditHandling(currentTdElement);}),summaryViewContainer.on(thisInstance.fieldUpdatedEvent,".js-widget-general-info",function(){var params,updatesWidget=summaryViewContainer.find("[data-type='Updates']");updatesWidget.length&&(params=thisInstance.getFiltersData(updatesWidget),updatesWidget.find(".btnChangesReviewedOn").parent().remove(),thisInstance.loadWidget(updatesWidget,params.params));}),summaryViewContainer.on("click",".editDefaultStatus",function(e){var currentTarget=jQuery(e.currentTarget);currentTarget.popover("hide");var url=currentTarget.data("url");if(url)if(currentTarget.hasClass("showEdit")){var quickCreate=App.Components.QuickCreate;window!==window.parent&&(quickCreate=window.parent.App.Components.QuickCreate),quickCreate.getForm(url,"Calendar",{noCache:!0}).done(function(data){quickCreate.showModal(data,{callbackFunction:function callbackFunction(){var widget=currentTarget.closest(".widgetContentBlock");if(widget.length){thisInstance.loadWidget(widget);var updatesWidget=thisInstance.getContentHolder().find("[data-type='Updates']");0<updatesWidget.length&&thisInstance.loadWidget(updatesWidget);}else thisInstance.loadRelatedList();thisInstance.registerRelatedModulesRecordCount();}},currentTarget);});}else app.showModalWindow(null,url);}),summaryViewContainer.on("click",".editDescription",function(e){var currentTarget=jQuery(e.currentTarget),currentDiv=currentTarget.closest(".activityDescription"),editElement=currentDiv.find(".edit"),detailViewElement=currentDiv.find(".value"),descriptionText=currentDiv.find(".js-description-text"),descriptionEmpty=currentDiv.find(".js-no-description"),saveButton=currentDiv.find(".js-save-description"),closeButton=currentDiv.find(".js-close-description"),activityButtonContainer=currentDiv.find(".js-activity-buttons__container"),fieldnameElement=jQuery(".fieldname",editElement),fieldName=fieldnameElement.val(),fieldElement=jQuery("[name=\""+fieldName+"\"]",editElement),callbackFunction=function callbackFunction(){var previousValue=fieldnameElement.data("prevValue"),ajaxEditNewValue=fieldElement.val(),ajaxEditNewLable=fieldElement.val(),activityDiv=currentDiv.closest(".activityEntries"),activityId=activityDiv.find(".activityId").val(),moduleName=activityDiv.find(".activityModule").val(),activityType=activityDiv.find(".activityType").val();return previousValue==ajaxEditNewValue?void closeDescription():(currentDiv.progressIndicator(),editElement.add(activityButtonContainer).addClass("d-none"),new Promise(function(resolve,reject){resolve(fieldElement.validationEngine("validate"));}).then(function(errorExists){//If validation fails
return errorExists?void Vtiger_Helper_Js.addClickOutSideEvent(currentDiv,callbackFunction):void(//update editor value after conversion
ajaxEditNewValue=fieldElement.val(),AppConnector.request({action:"SaveAjax",record:activityId,field:fieldName,value:ajaxEditNewValue,module:moduleName,activitytype:activityType}).done(function(){currentDiv.progressIndicator({mode:"hide"}),detailViewElement.removeClass("d-none"),currentTarget.show(),descriptionText.html(ajaxEditNewLable),fieldnameElement.data("prevValue",ajaxEditNewValue),""===ajaxEditNewValue?descriptionEmpty.removeClass("d-none"):descriptionEmpty.addClass("d-none");}))}))},closeDescription=function closeDescription(){fieldElement.val(fieldnameElement.data("prevValue")),editElement.add(activityButtonContainer).addClass("d-none"),detailViewElement.removeClass("d-none"),currentTarget.show();};App.Fields.Text.Editor.register(currentDiv,{toolbar:"Min"}),currentTarget.hide(),detailViewElement.addClass("d-none"),activityButtonContainer.removeClass("d-none"),editElement.removeClass("d-none").show(),saveButton.off("click").one("click",callbackFunction),closeButton.off("click").one("click",closeDescription);}),$(".changeDetailViewMode").on("click",function(e){thisInstance.getTabs().filter("[data-link-key=\""+thisInstance.detailViewDetailsTabLabel+"\"]:not(.d-none)").trigger("click");}),this.registerFastEditingFields();},addRelationBetweenRecords:function addRelationBetweenRecords(relatedModule,relatedModuleRecordId,selectedTabElement){var relatedController,params=3<arguments.length&&void 0!==arguments[3]?arguments[3]:{},url=4<arguments.length?arguments[4]:void 0,aDeferred=jQuery.Deferred(),thisInstance=this;return null==selectedTabElement&&(selectedTabElement=thisInstance.getSelectedTab()),relatedController=url?Vtiger_RelatedList_Js.getInstanceByUrl(url,selectedTabElement):Vtiger_RelatedList_Js.getInstance(thisInstance.getRecordId(),app.getModuleName(),selectedTabElement,relatedModule),relatedController.addRelations(relatedModuleRecordId,params).done(function(data){var summaryViewContainer=thisInstance.getContentHolder(),updatesWidget=summaryViewContainer.find("[data-type='Updates']");if(0<updatesWidget.length){var _params=thisInstance.getFiltersData(updatesWidget);updatesWidget.find(".btnChangesReviewedOn").parent().remove(),thisInstance.loadWidget(updatesWidget,_params.params);}aDeferred.resolve(data);}).fail(function(textStatus,errorThrown){aDeferred.reject(textStatus,errorThrown);}),aDeferred.promise()},/**
		 * Function to handle Post actions after adding record from
		 * summary view widget
		 */postSummaryWidgetAddRecord:function postSummaryWidgetAddRecord(data,currentElement){var summaryWidgetContainer=currentElement.closest(".js-detail-widget"),widgetContainer=summaryWidgetContainer.find("[class^=\"widgetContainer_\"]");this.loadWidget(widgetContainer);var updatesWidget=this.getContentHolder().find("[data-type='Updates']");if(0<updatesWidget.length){var params=this.getFiltersData(updatesWidget);updatesWidget.find(".btnChangesReviewedOn").parent().remove(),this.loadWidget(updatesWidget,params.params);}},registerChangeEventForModulesList:function registerChangeEventForModulesList(){jQuery("#tagSearchModulesList").on("change",function(e){var modulesSelectElement=jQuery(e.currentTarget);if("all"==modulesSelectElement.val())jQuery("[name=\"tagSearchModuleResults\"]").removeClass("d-none");else {jQuery("[name=\"tagSearchModuleResults\"]").removeClass("d-none");var selectedOptionValue=modulesSelectElement.val();jQuery("[name=\"tagSearchModuleResults\"]").filter(":not(#"+selectedOptionValue+")").addClass("d-none");}});},registerEventForRelatedTabClick:function registerEventForRelatedTabClick(){var thisInstance=this,detailContentsHolder=thisInstance.getContentHolder(),detailContainer=detailContentsHolder.closest("div.detailViewInfo");jQuery(".related",detailContainer).on("click","li:not(.spaceRelatedList)",function(e,urlAttributes){var tabElement=jQuery(e.currentTarget);if(!tabElement.hasClass("dropdown")){var element=jQuery("<div></div>");element.progressIndicator({position:"html",blockInfo:{enabled:!0,elementToBlock:detailContainer}});var url=tabElement.data("url");if("undefined"!=typeof urlAttributes){var _callBack=urlAttributes.callback;delete urlAttributes.callback;}thisInstance.loadContents(url,urlAttributes).done(function(data){// Let listeners know about page state change.
thisInstance.deSelectAllrelatedTabs(),thisInstance.markTabAsSelected(tabElement),Vtiger_Helper_Js.showHorizontalTopScrollBar(),element.progressIndicator({mode:"hide"}),app.registerModal(detailContentsHolder),"function"==typeof callBack&&callBack(data),tabElement.data("linkKey")==thisInstance.detailViewSummaryTabLabel&&thisInstance.loadWidgets(),thisInstance.registerBasicEvents(),app.notifyPostAjaxReady(),app.event.trigger("DetailView.Tab.AfterLoad",data,thisInstance);}).fail(function(){element.progressIndicator({mode:"hide"});});}});},/**
		 * Function to get child comments
		 */getChildComments:function getChildComments(commentId){var aDeferred=jQuery.Deferred(),url="module="+app.getModuleName()+"&view=Detail&record="+this.getRecordId()+"&mode=showChildComments&commentid="+commentId,dataObj=this.getCommentThread(url);return dataObj.done(function(data){aDeferred.resolve(data);}),aDeferred.promise()},/**
		 * Function to get parent comment
		 * @param {number} commentId
		 * @returns {string}
		 */getParentComments:function getParentComments(commentId){var aDeferred=$.Deferred(),url="module="+app.getModuleName()+"&view=Detail&record="+this.getRecordId()+"&mode=showParentComments&commentid="+commentId;return this.getCommentThread(url).done(function(data){aDeferred.resolve(data);}),aDeferred.promise()},/**
		 * Function to show total records count in listview on hover
		 * of pageNumber text
		 */registerEventForTotalRecordsCount:function registerEventForTotalRecordsCount(){var thisInstance=this,detailContentsHolder=this.getContentHolder();detailContentsHolder.on("click",".totalNumberOfRecords",function(e){var element=jQuery(e.currentTarget),totalNumberOfRecords=jQuery("#totalCount").val();if(element.addClass("d-none"),element.parent().progressIndicator({}),""==totalNumberOfRecords){var selectedTabElement=thisInstance.getSelectedTab(),relatedModuleName=thisInstance.getRelatedModuleName(),relatedController=Vtiger_RelatedList_Js.getInstance(thisInstance.getRecordId(),app.getModuleName(),selectedTabElement,relatedModuleName);relatedController.getRelatedPageCount().done(function(){thisInstance.showPagingInfo();});}else thisInstance.showPagingInfo();element.parent().progressIndicator({mode:"hide"});});},showPagingInfo:function showPagingInfo(){var totalNumberOfRecords=jQuery("#totalCount").val(),pageNumberElement=jQuery(".pageNumbersText"),pageRange=pageNumberElement.text(),newPagingInfo=pageRange+" ("+totalNumberOfRecords+")",listViewEntriesCount=parseInt(jQuery("#noOfEntries").val());0==listViewEntriesCount?jQuery(".pageNumbersText").html(""):jQuery(".pageNumbersText").html(newPagingInfo);},getCustomFieldNameValueMap:function getCustomFieldNameValueMap(fieldNameValueMap){return fieldNameValueMap},registerSetReadRecord:function registerSetReadRecord(detailContentsHolder){var thisInstance=this;detailContentsHolder.on("click",".setReadRecord",function(e){var currentElement=jQuery(e.currentTarget);currentElement.closest(".btn-group").addClass("d-none"),jQuery("#Accounts_detailView_fieldValue_was_read").find(".value").text(app.vtranslate("LBL_YES"));var params={module:app.getModuleName(),action:"SaveAjax",record:thisInstance.getRecordId(),field:"was_read",value:"on"};AppConnector.request(params).done(function(data){var params={text:app.vtranslate("JS_SET_READ_RECORD"),title:app.vtranslate("System"),type:"info"};app.showNotify(params);var relatedTabKey=jQuery(".related li.active");(relatedTabKey.data("linkKey")==thisInstance.detailViewSummaryTabLabel||relatedTabKey.data("linkKey")==thisInstance.detailViewDetailsTabLabel)&&thisInstance.reloadTabContent();});});},registerFastEditingFields:function registerFastEditingFields(){var thisInstance=this,fastEditingFiels=jQuery(".summaryWidgetFastEditing select");fastEditingFiels.on("change",function(e){var fieldElement=jQuery(e.currentTarget),fieldContainer=fieldElement.closest(".editField"),progressIndicatorElement=jQuery.progressIndicator({message:app.vtranslate("JS_SAVE_LOADER_INFO"),position:"summaryWidgetFastEditing",blockInfo:{enabled:!0}}),fieldName=fieldContainer.data("fieldname");fieldName=fieldName.replace("q_","");var fieldValue=fieldElement.val(),errorExists=fieldElement.validationEngine("validate");if(errorExists)return void fieldContainer.progressIndicator({mode:"hide"});var preFieldSaveEvent=jQuery.Event(thisInstance.fieldPreSave);fieldElement.trigger(preFieldSaveEvent,{fieldValue:fieldValue,recordId:thisInstance.getRecordId()}),Vtiger_Edit_Js.saveAjax(thisInstance.getCustomFieldNameValueMap({field:fieldName,value:fieldValue}),!1).always(function(){progressIndicatorElement.progressIndicator({mode:"hide"}),app.showNotify({title:app.vtranslate("JS_SAVE_NOTIFY_OK"),type:"success"}),thisInstance.reloadTabContent();});});},registerHelpInfo:function registerHelpInfo(form){form||(form=this.getForm()),app.showPopoverElementView(form.find(".js-help-info"));},/**
		 * Register related modules record cound
		 * @param {jQuery} tabContainer
		 */registerRelatedModulesRecordCount:function registerRelatedModulesRecordCount(tabContainer){var moreList=$(".related .nav .dropdown-menu"),relationContainer=tabContainer;relationContainer&&"undefined"!=typeof relationContainer.length||(relationContainer=$(".related .nav > .relatedNav, .related .nav > .mainNav, .detailViewBlockLink, .related .nav .dropdown-menu > .relatedNav")),relationContainer.each(function(n,item){item=$(item);var relationId=item.data("relationId"),relatedModule=item.data("reference");1===item.data("count")&&AppConnector.request({module:app.getModuleName(),action:"RelationAjax",record:app.getRecordId(),relatedModule:relatedModule,mode:"getRelatedListPageCount",relationId:relationId,tab_label:item.data("label-key")}).done(function(response){response.success&&(0===response.result.numberOfRecords&&(response.result.numberOfRecords=""),item.find(".count").text(response.result.numberOfRecords),moreList.find("[data-reference=\"${relatedModule}\"][data-relation-id=\"${relationId}\"] .count").text(response.result.numberOfRecords));});});},/**
		 * Function to display a new comments
		 */addComment:function addComment(currentTarget,data){var self=this,mode=currentTarget.data("mode"),closestAddCommentBlock=currentTarget.closest(".js-add-comment-block"),commentTextAreaElement=closestAddCommentBlock.find(".js-comment-content"),commentInfoBlock=currentTarget.closest(".js-comment-single");if(commentTextAreaElement.html(""),"add"==mode){var commentHtml=self.getCommentUI(data.result._recordId);commentHtml.done(function(data){var commentBlock=closestAddCommentBlock.closest(".js-comment-details"),detailContentsHolder=self.getContentHolder(),noCommentsMsgContainer=$(".js-noCommentsMsgContainer",detailContentsHolder);if(noCommentsMsgContainer.remove(),0<commentBlock.length){closestAddCommentBlock.remove();var childComments=commentBlock.find("ul");if(0>=childComments.length){var currentChildCommentsCount=commentInfoBlock.find(".js-view-thread-block").data("data-child-comments-count"),newChildCommentCount=currentChildCommentsCount+1;commentInfoBlock.find(".js-child-comments-count").text(newChildCommentCount);var parentCommentId=commentInfoBlock.find(".js-comment-info-header").data("commentid");self.getChildComments(parentCommentId).done(function(responsedata){$(responsedata).appendTo(commentBlock),commentInfoBlock.find(".js-view-thread-block").hide(),commentInfoBlock.find(".hideThreadBlock").show();});}else $("<li class=\"js-comment-details commentDetails\">"+data+"</li>").appendTo(commentBlock.find(".js-comments-body"));}else $("<li class=\"js-comment-details commentDetails\">"+data+"</li>").prependTo(closestAddCommentBlock.closest(".contents").find(".commentsList"));commentInfoBlock.find(".js-comment-container").show(),app.event.trigger("DetailView.SaveComment.AfterLoad",commentInfoBlock,data);});}else if("edit"==mode){var modifiedTime=commentInfoBlock.find(".js-comment-modified-time"),commentInfoContent=commentInfoBlock.find(".js-comment-info"),commentEditStatus=commentInfoBlock.find(".js-edited-status"),commentReason=commentInfoBlock.find(".js-edit-reason-span");commentInfoContent.html(data.result.commentcontent.display_value),commentReason.html(data.result.reasontoedit.display_value),modifiedTime.html(data.result.modifiedtime.formatToViewDate),modifiedTime.attr("title",data.result.modifiedtime.formatToDay),commentEditStatus.hasClass("d-none")&&commentEditStatus.removeClass("d-none"),""!=data.result.reasontoedit.display_value&&commentInfoBlock.find(".js-edit-reason").removeClass("d-none"),commentInfoContent.show(),commentInfoBlock.find(".js-comment-container").show(),closestAddCommentBlock.remove(),app.event.trigger("DetailView.SaveComment.AfterUpdate",commentInfoBlock,data);}},/**
		 * Register all comment events
		 * @param {jQuery} detailContentsHolder
		 */registerCommentEvents:function registerCommentEvents(detailContentsHolder){var self=this;detailContentsHolder.on("click",".js-close-comment-block",function(e){var commentInfoBlock=$(e.currentTarget.closest(".js-comment-single"));commentInfoBlock.find(".js-comment-container").show(),commentInfoBlock.find(".js-comment-info").show(),commentInfoBlock.find(".js-add-comment-block").remove();}),detailContentsHolder.on("click",".js-reply-comment",function(e){var commentInfoBlock=$(e.currentTarget).closest(".js-comment-single");commentInfoBlock.find(".js-add-comment-block").remove(),self.hideButtonAction(),commentInfoBlock.find(".js-comment-info").show(),self.getCommentBlock().appendTo(commentInfoBlock).show();}),detailContentsHolder.on("click",".js-edit-comment",function(e){var commentInfoBlock=$(e.currentTarget).closest(".js-comment-single");commentInfoBlock.find(".js-add-comment-block").remove(),self.hideButtonAction();var commentInfoContent=commentInfoBlock.find(".js-comment-info"),editCommentBlock=self.getEditCommentBlock();editCommentBlock.find(".js-comment-content").html(commentInfoContent.html()),editCommentBlock.find(".js-reason-to-edit").html(commentInfoBlock.find(".js-edit-reason-span").text()),commentInfoContent.hide(),commentInfoBlock.find(".js-comment-container").hide(),editCommentBlock.appendTo(commentInfoBlock).show();}),detailContentsHolder.on("click",".js-detail-view-save-comment",function(e){var element=$(e.currentTarget);element.is(":disabled")||self.saveComment(e).done(function(){self.registerRelatedModulesRecordCount(),self.loadWidget(detailContentsHolder.find("[data-type='Comments']")).done(function(){element.removeAttr("disabled");});}).fail(function(error,err){element.removeAttr("disabled"),app.errorLog(error,err);});}),detailContentsHolder.on("click",".js-save-comment",function(e){var element=$(e.currentTarget);element.is(":disabled")||self.saveComment(e).done(function(data){self.registerRelatedModulesRecordCount(self.getTabByLabel(self.detailViewRecentCommentsTabLabel)),self.addComment(element,data),element.removeAttr("disabled");}).fail(function(error,err){element.removeAttr("disabled"),app.errorLog(error,err);});}),detailContentsHolder.on("click",".js-more-recent-comments ",function(){self.getTabByLabel(self.detailViewRecentCommentsTabLabel).trigger("click");}),detailContentsHolder.find(".js-detail-hierarchy-comments").on("change",function(e){var recentCommentsTab=self.getTabByLabel(self.detailViewRecentCommentsTabLabel),url=recentCommentsTab.data("url"),regex=/&hierarchy=+([\w,]+)/;url=url.replace(regex,"");var hierarchy=[];detailContentsHolder.find(".js-detail-hierarchy-comments:checked").each(function(){hierarchy.push($(this).val());}),0!==hierarchy.length&&(url+="&hierarchy="+hierarchy.join(",")),recentCommentsTab.data("url",url),recentCommentsTab.trigger("click");}),detailContentsHolder.on("keypress",".js-comment-search",function(e){13===e.which&&self.submitSearchForm(detailContentsHolder);}),detailContentsHolder.on("click",".js-search-icon",function(e){self.submitSearchForm(detailContentsHolder);});},/**
		 * Submit search comment form
		 * @param {jQuery} detailContentsHolder
		 */submitSearchForm:function submitSearchForm(detailContentsHolder){var searchTextDom=detailContentsHolder.find(".js-comment-search"),widgetContainer=searchTextDom.closest("[data-name=\"ModComments\"]"),progressIndicatorElement=$.progressIndicator();if("widget"===searchTextDom.data("container")&&!searchTextDom.val()){var request=widgetContainer.data("url");AppConnector.request(request).done(function(data){progressIndicatorElement.progressIndicator({mode:"hide"}),detailContentsHolder.find(".js-comments-container").html(data);});}else {var hierarchy=[],limit="",isWidget=!1;"widget"===searchTextDom.data("container")?(limit=widgetContainer.data("limit"),isWidget=!0,widgetContainer.find(".js-hierarchy-comments:checked").each(function(){hierarchy.push($(this).val());})):detailContentsHolder.find(".js-detail-hierarchy-comments:checked").each(function(){hierarchy.push($(this).val());}),AppConnector.request({module:app.getModuleName(),view:"Detail",mode:"showSearchComments",hierarchy:hierarchy.join(","),limit:limit,record:app.getRecordId(),search_key:searchTextDom.val(),is_widget:isWidget}).done(function(data){progressIndicatorElement.progressIndicator({mode:"hide"}),searchTextDom.val()?detailContentsHolder.find(".js-comments-body").html(data):detailContentsHolder.html(data);});}},/**
		 * Register hierarchy comments buttons
		 * @param {jQuery} widgetContainer
		 */registerCommentEventsInDetail:function registerCommentEventsInDetail(widgetContainer){new App.Fields.Text.Completions($(".js-completions").eq(0)),widgetContainer.on("change",".js-hierarchy-comments",function(e){var hierarchy=[];if(widgetContainer.find(".js-hierarchy-comments").each(function(){$(this).is(":checked")&&hierarchy.push($(this).val());}),!hierarchy.length)return widgetContainer.find(".js-detail-widget-content").html(""),!1;var progressIndicatorElement=$.progressIndicator();AppConnector.request({module:app.getModuleName(),view:"Detail",mode:"showRecentComments",hierarchy:hierarchy.join(","),record:app.getRecordId(),limit:widgetContainer.find(".widgetContentBlock").data("limit")}).done(function(data){progressIndicatorElement.progressIndicator({mode:"hide"});var widgetDataContainer=widgetContainer.find(".js-detail-widget-content");widgetDataContainer.html(data),App.Fields.Picklist.showSelect2ElementView(widgetDataContainer.find(".select2"));});});},registerMailPreviewWidget:function registerMailPreviewWidget(container){var self=this;container.on("click",".showMailBody",function(e){var row=$(e.currentTarget).closest(".js-mail-row"),mailBody=row.find(".mailBody"),mailTeaser=row.find(".mailTeaser");mailBody.toggleClass("d-none"),mailTeaser.toggleClass("d-none");}),container.find("[name=\"mail-type\"]").on("change",function(e){self.loadMailPreviewWidget(container);}),container.find("[name=\"mailFilter\"]").on("change",function(e){self.loadMailPreviewWidget(container);}),container.on("click",".showMailsModal",function(e){var url=$(e.currentTarget).data("url"),type=container.find("[name=\"mail-type\"]"),typeValue="";typeValue=0<type.length?type.val():"All",url+="&type="+typeValue,0<container.find("[name=\"mailFilter\"]").length&&(url+="&mailFilter="+container.find("[name=\"mailFilter\"]").val()),app.showModalWindow("",url);});},loadMailPreviewWidget:function loadMailPreviewWidget(widgetContent){var thisInstance=this,widgetDataContainer=widgetContent.find(".js-detail-widget-content"),recordId=$("#recordId").val(),progress=widgetDataContainer.progressIndicator(),params={};params.module="OSSMailView",params.view="Widget",params.smodule=$("#module").val(),params.srecord=recordId,params.mode="showEmailsList",params.type=$("[name=\"mail-type\"]").val(),params.mailFilter=$("[name=\"mailFilter\"]").val(),AppConnector.request(params).done(function(data){widgetDataContainer.html(data),app.event.trigger("DetailView.Widget.AfterLoad",widgetDataContainer,params.module,thisInstance),progress.progressIndicator({mode:"hide"});});},registerEmailEvents:function registerEmailEvents(detailContentsHolder){Vtiger_Index_Js.registerMailButtons(detailContentsHolder);},registerMapsEvents:function registerMapsEvents(container){if(container.find("#coordinates").length){var mapView=new OpenStreetMap_Map_Js;mapView.registerDetailView(container);}},registerShowSummary:function registerShowSummary(container){container.on("click",".showSummaryRelRecord",function(e){var currentTarget=$(e.currentTarget),id=currentTarget.data("id"),summaryView=container.find(".summaryRelRecordView"+id);container.find(".listViewEntriesTable").css("display","none"),summaryView.show();}),container.on("click",".hideSummaryRelRecordView",function(e){var summaryView=container.find(".summaryRelRecordView");container.find(".listViewEntriesTable").css("display","table"),summaryView.hide();});},/**
		 * Show confirmation on event click
		 * @param {jQuery} element
		 * @param {string} picklistName
		 */showProgressConfirmation:function showProgressConfirmation(element,picklistName){var picklistValue=$(element).data("picklistValue");app.showConfirmModal({title:$(element).data("picklistLabel"),text:app.vtranslate("JS_CHANGE_VALUE_CONFIRMATION"),confirmedCallback:function confirmedCallback(){Vtiger_Edit_Js.saveAjax({value:picklistValue,field:picklistName}).done(function(response){response&&!1===response.success||window.location.reload();}).fail(function(error,err){app.errorLog(error,err);});}});},/**
		 * Change status from progress
		 */registerProgress:function registerProgress(){var self=this;$(".js-header-progress-bar").each(function(index,element){var picklistName=$(element).data("picklistName");$(element).find(".js-access").on("click",function(e){self.showProgressConfirmation(e.currentTarget,picklistName);});});},loadChat:function loadChat(){var chatVue=$("#ChatRecordRoomVue",this.detailViewContentHolder);if(chatVue.length){var chatContainer=this.detailViewContentHolder.find(".js-chat-container"),padding=10;chatContainer.height($(document).height()-chatContainer.offset().top-$(".js-footer").outerHeight()-padding),window.ChatRecordRoomVueComponent.mount({el:"#ChatRecordRoomVue"});}},registerChat:function registerChat(){var _this2=this;window.ChatRecordRoomVueComponent!==void 0&&(this.loadChat(),app.event.on("DetailView.Tab.AfterLoad",function(e,data,instance){instance.detailViewContentHolder.ready(function(){_this2.loadChat();});}));},registerBasicEvents:function registerBasicEvents(){var thisInstance=this,detailContentsHolder=thisInstance.getContentHolder(),selectedTabElement=thisInstance.getSelectedTab();//register all the events for summary view container
//Attach time picker event to time fields
"ModComments"===this.getSelectedTab().data("labelKey")&&new App.Fields.Text.Completions(detailContentsHolder.find(".js-completions")),app.registerBlockAnimationEvent(this.getForm()),thisInstance.registerSummaryViewContainerEvents(detailContentsHolder),thisInstance.registerCommentEvents(detailContentsHolder),thisInstance.registerEmailEvents(detailContentsHolder),thisInstance.registerMapsEvents(detailContentsHolder),thisInstance.registerSubProducts(detailContentsHolder),thisInstance.registerCollapsiblePanels(detailContentsHolder),App.Fields.Date.register(detailContentsHolder),App.Fields.DateTime.register(detailContentsHolder),App.Fields.MultiImage.register(detailContentsHolder),App.Fields.Password.register(detailContentsHolder),App.Fields.MultiAttachment.register(detailContentsHolder),app.registerEventForClockPicker(),this.registerHelpInfo(detailContentsHolder),App.Fields.Picklist.showSelect2ElementView(detailContentsHolder.find("select.select2")),App.Fields.Text.Editor.register(detailContentsHolder,{toolbar:"Min"}),detailContentsHolder.on("click","#detailViewNextRecordButton",function(e){var url=selectedTabElement.data("url"),currentPageNum=thisInstance.getRelatedListCurrentPageNum(),requestedPage=parseInt(currentPageNum)+1,nextPageUrl=url+"&page="+requestedPage;thisInstance.loadContents(nextPageUrl);}),detailContentsHolder.on("click","#detailViewPreviousRecordButton",function(e){var url=selectedTabElement.data("url"),currentPageNum=thisInstance.getRelatedListCurrentPageNum(),requestedPage=parseInt(currentPageNum)-1,nextPageUrl=url+"&page="+requestedPage;thisInstance.loadContents(nextPageUrl);}),detailContentsHolder.on("click",".js-detail-quick-edit",function(e){thisInstance.ajaxEditHandling(jQuery(e.currentTarget).closest(".fieldValue"));}),detailContentsHolder.on("click","div.recordDetails span.squeezedWell",function(e){var currentElement=jQuery(e.currentTarget),relatedLabel=currentElement.data("reference");jQuery(".detailViewInfo .related .nav > li[data-reference=\""+relatedLabel+"\"]").trigger("click");}),detailContentsHolder.on("click",".relatedPopup",function(e){var editViewObj=new Vtiger_Edit_Js;return editViewObj.showRecordsList(e),!1}),detailContentsHolder.on("click",".viewThread",function(e){thisInstance.hideButtonAction();var currentTarget=jQuery(e.currentTarget),currentTargetParent=currentTarget.parent(),commentActionsBlock=currentTarget.closest(".js-comment-actions"),currentCommentBlock=currentTarget.closest(".js-comment-details"),ulElements=currentCommentBlock.find("ul");if(0<ulElements.length)return ulElements.show(),commentActionsBlock.find(".hideThreadBlock").show(),void currentTargetParent.hide();var commentId=currentTarget.closest(".js-comment-div").find(".js-comment-info-header").data("commentid");thisInstance.getChildComments(commentId).done(function(data){jQuery(data).appendTo(jQuery(e.currentTarget).closest(".js-comment-details")),commentActionsBlock.find(".hideThreadBlock").show(),currentTargetParent.hide();});}),detailContentsHolder.on("click",".js-view-parent-thread",function(e){var currentTarget=jQuery(e.currentTarget),currentTargetParent=currentTarget.parent(),commentId=currentTarget.closest(".js-comment-div").find(".js-comment-info-header").data("commentid");thisInstance.getParentComments(commentId).done(function(data){$(e.currentTarget.closest(".js-comment-details")).html(data),currentTarget.closest(".js-comment-actions").find(".hideThreadBlock").show(),currentTargetParent.hide();});}),detailContentsHolder.on("click",".hideThread",function(e){var currentTarget=jQuery(e.currentTarget),currentTargetParent=currentTarget.parent(),commentActionsBlock=currentTarget.closest(".js-comment-actions"),currentCommentBlock=currentTarget.closest(".js-comment-details");currentCommentBlock.find("ul").hide(),currentTargetParent.hide(),commentActionsBlock.find(".js-view-thread-block").show();}),detailContentsHolder.on("click",".detailViewThread",function(e){var recentCommentsTab=thisInstance.getTabByLabel(thisInstance.detailViewRecentCommentsTabLabel),commentId=jQuery(e.currentTarget).closest(".js-comment-single").find(".js-comment-info-header").data("commentid"),commentLoad=function commentLoad(data){window.location.href=window.location.href+"#"+commentId;};recentCommentsTab.trigger("click",{commentid:commentId,callback:commentLoad});}),detailContentsHolder.on("click",".moreRecentRecords",function(e){e.preventDefault();var recentCommentsTab=thisInstance.getTabByModule($(this).data("label-key"),$(this).data("relation-id"));if(recentCommentsTab.length)recentCommentsTab.trigger("click");else {var currentTarget=$(e.currentTarget),container=currentTarget.closest("[class^='widgetContainer_']");if(container.length){var page=container.find("[name=\"page\"]:last").val(),url=container.data("url");currentTarget.prop("disabled",!0),url=url.replace("&page=1","&page="+ ++page),AppConnector.request(url).done(function(data){var dataObj=$(data),containerTable=container.find(".js-detail-widget-content table");currentTarget.prop("disabled",!1).addClass("d-none"),container.find("[name=\"page\"]:last").val(dataObj.find("[name=\"page\"]").val()),containerTable.length?(containerTable.append(dataObj.find("tbody tr")),dataObj.find(".moreRecentRecords").length&&currentTarget.removeClass("d-none")):container.find(".js-detail-widget-content").append(dataObj);});}}}),detailContentsHolder.on("change",".relatedHistoryTypes",function(e){var widgetContent=jQuery(this).closest(".widgetContentBlock").find(".widgetContent"),progressIndicatorElement=jQuery.progressIndicator({position:"html",blockInfo:{enabled:!0,elementToBlock:widgetContent}});AppConnector.request({module:app.getModuleName(),view:"Detail",record:app.getRecordId(),mode:"showRecentRelation",page:1,limit:widgetContent.find(".js-relatedHistoryPageLimit").val(),type:$(e.currentTarget).val()}).done(function(data){progressIndicatorElement.progressIndicator({mode:"hide"}),widgetContent.find("#relatedHistoryCurrentPage").remove(),widgetContent.find("#moreRelatedUpdates").remove(),widgetContent.html(data),Vtiger_Index_Js.registerMailButtons(widgetContent);});}),detailContentsHolder.on("click",".moreProductsService",function(){jQuery(".related .mainNav[data-reference=\"ProductsAndServices\"]:not(.d-none)").trigger("click");}),detailContentsHolder.on("click",".moreRelatedUpdates",function(){var widgetContainer=jQuery(this).closest(".widgetContentBlock"),widgetContent=widgetContainer.find(".widgetContent"),progressIndicatorElement=jQuery.progressIndicator({position:"html",blockInfo:{enabled:!0,elementToBlock:widgetContent}}),currentPage=widgetContent.find("#relatedHistoryCurrentPage").val(),nextPage=parseInt(currentPage)+1,types=widgetContainer.find(".relatedHistoryTypes").val(),pageLimit=widgetContent.find("#relatedHistoryPageLimit").val();AppConnector.request({module:app.getModuleName(),view:"Detail",record:app.getRecordId(),mode:"showRecentRelation",page:nextPage,limit:pageLimit,type:types}).done(function(data){progressIndicatorElement.progressIndicator({mode:"hide"}),widgetContent.find("#relatedHistoryCurrentPage").remove(),widgetContent.find("#moreRelatedUpdates").remove(),widgetContent.find("#relatedUpdates").append(data);});}),detailContentsHolder.on("click",".moreRecentUpdates",function(e){var url,container=$(e.currentTarget).closest(".recentActivitiesContainer"),newChange=container.find("#newChange").val(),nextPage=parseInt(container.find("#updatesCurrentPage").val())+1;if(container.closest(".js-detail-widget").length){var data=thisInstance.getFiltersData(e,{page:nextPage,tab_label:"LBL_UPDATES",newChange:newChange},container.find("#updates"));url=data.params;}else if(url=thisInstance.getTabByLabel(thisInstance.detailViewRecentUpdatesTabLabel).data("url"),url=url.replace("&page=1","&page="+nextPage)+"&skipHeader=true&newChange="+newChange,-1===url.indexOf("&whereCondition")){var switchBtn=jQuery(".active .js-switch--recentActivities");url+="&whereCondition="+("undefined"==typeof switchBtn.data("on-val")?switchBtn.data("off-val"):switchBtn.data("on-val"));}AppConnector.request(url).done(function(data){var dataContainer=jQuery(data);container.find("#newChange").val(dataContainer.find("#newChange").val()),container.find("#updatesCurrentPage").val(dataContainer.find("#updatesCurrentPage").val()),container.find(".js-more-link").html(dataContainer.find(".js-more-link").html()),container.find("#updates ul").append(dataContainer.find("#updates ul").html()),app.event.trigger("DetailView.UpdatesWidget.AddMore",data,thisInstance);});}),detailContentsHolder.on("click",".btnChangesReviewedOn",function(e){var progressInstance=jQuery.progressIndicator({position:"html",blockInfo:{enabled:!0}}),url="index.php?module=ModTracker&action=ChangesReviewedOn&record="+app.getRecordId();AppConnector.request(url).done(function(data){if(progressInstance.progressIndicator({mode:"hide"}),jQuery(e.currentTarget).parent().remove(),thisInstance.getTabByLabel(thisInstance.detailViewRecentUpdatesTabLabel).find(".count.badge").text(""),selectedTabElement.data("labelKey")==thisInstance.detailViewRecentUpdatesTabLabel)thisInstance.reloadTabContent();else if(selectedTabElement.data("linkKey")==thisInstance.detailViewSummaryTabLabel){var updatesWidget=detailContentsHolder.find("[data-type='Updates']");if(0<updatesWidget.length){var params=thisInstance.getFiltersData(updatesWidget);thisInstance.loadWidget(updatesWidget,params.params);}}});}),detailContentsHolder.on("click",".moreRecentDocuments",function(){var recentDocumentsTab=thisInstance.getTabByLabel(thisInstance.detailViewRecentDocumentsTabLabel);recentDocumentsTab.trigger("click");}),detailContentsHolder.on("click",".moreRecentActivities",function(e){var currentTarget=$(e.currentTarget);currentTarget.prop("disabled",!0);var container=currentTarget.closest(".activityWidgetContainer"),page=container.find(".currentPage").val(),records=container.find(".countActivities").val(),data=thisInstance.getFiltersData(e,{page:++page});AppConnector.request({type:"POST",async:!1,dataType:"html",data:data.params}).done(function(data){currentTarget.prop("disabled",!1),currentTarget.addClass("d-none"),container.find(".currentPage").remove(),container.find(".countActivities").remove(),container.find(".js-detail-widget-content").append(data);var newRecords=container.find(".countActivities").val();container.find(".countActivities").val(parseInt(newRecords)+parseInt(records)),thisInstance.reloadWidgetActivitesStats(container);});}),detailContentsHolder.on("click",".widgetFullscreen",function(e){var currentTarget=$(e.currentTarget),widgetContentBlock=currentTarget.closest(".widgetContentBlock"),url=widgetContentBlock.data("url");url=url.replace("&view=Detail&","&view=WidgetFullscreen&");var progressIndicatorElement=jQuery.progressIndicator({position:"html",blockInfo:{enabled:!0}});app.showModalWindow(null,"index.php?"+url,function(modal){progressIndicatorElement.progressIndicator({mode:"hide"});});}),thisInstance.registerEventForRelatedList(),thisInstance.registerMailPreviewWidget(detailContentsHolder.find(".widgetContentBlock[data-type=\"EmailList\"]")),thisInstance.registerMailPreviewWidget(detailContentsHolder.find(".widgetContentBlock[data-type=\"HistoryRelation\"]")),detailContentsHolder.find(".js-switch--recentActivities").off().on("change",function(e){var currentTarget=jQuery(e.currentTarget),tabElement=thisInstance.getTabByLabel(thisInstance.detailViewRecentUpdatesTabLabel),variableName=currentTarget.data("urlparams"),valueOn=$(this).data("on-val"),valueOff=$(this).data("off-val"),url=tabElement.data("url");url=url.replace("&"+variableName+"="+valueOn,"").replace("&"+variableName+"="+valueOff,""),"undefined"==typeof currentTarget.data("on-val")?"undefined"!=typeof currentTarget.data("off-val")&&(url+="&"+variableName+"="+valueOff):url+="&"+variableName+"="+valueOn,tabElement.data("url",url),tabElement.trigger("click");}),app.registerIframeEvents(detailContentsHolder),app.registerBlockToggleEvent(detailContentsHolder);},reloadWidgetActivitesStats:function reloadWidgetActivitesStats(container){var countElement=container.find(".countActivities"),totalElement=container.find(".totaltActivities"),switchBtn=container.find(".active .js-switch");if(switchBtn.length?(container.find(".js-switch").removeClass("previousMark"),switchBtn.addClass("previousMark")):switchBtn=container.find(".js-switch.previousMark"),container.find(".js-switch").toggleClass("previousMark"),!countElement.length||!totalElement.length||""===totalElement.val())return !1;var stats=" ("+countElement.val()+"/"+totalElement.val()+")",switchBtnParent=switchBtn.parent(),text=switchBtn.data("basic-text")+stats;switchBtnParent.removeTextNode(),switchBtnParent.append(text);},refreshCommentContainer:function refreshCommentContainer(commentId){var thisInstance=this,commentContainer=$(".commentsBody"),params={module:app.getModuleName(),view:"Detail",record:thisInstance.getRecordId(),mode:"showThreadComments",commentid:commentId},progressIndicatorElement=jQuery.progressIndicator({position:"html",blockInfo:{enabled:!0,elementToBlock:commentContainer}});AppConnector.request(params).done(function(data){progressIndicatorElement.progressIndicator({mode:"hide"}),commentContainer.html(data);});},updateRecordsPDFTemplateBtn:function updateRecordsPDFTemplateBtn(form){var thisInstance=this,btnToolbar=$(".js-btn-toolbar .js-pdf");btnToolbar.length&&AppConnector.request({data:{module:app.getModuleName(),action:"PDF",mode:"hasValidTemplate",record:app.getRecordId(),view:app.getViewName()},dataType:"json"}).done(function(data){!1===data.result.valid?btnToolbar.addClass("d-none"):btnToolbar.removeClass("d-none");}).fail(function(data,err){app.errorLog(data,err);});},updateWindowHeight:function updateWindowHeight(currentHeight,frame){frame.height(currentHeight);},loadSubProducts:function loadSubProducts(parentRow){var thisInstance=this,recordId=parentRow.data("product-id"),subProrductParams={module:"Products",action:"SubProducts",record:recordId};AppConnector.request(subProrductParams).done(function(data){var responseData=data.result;thisInstance.addSubProducts(parentRow,responseData);});},addSubProducts:function addSubProducts(parentRow,responseData){var subProductsContainer=$(".js-subproducts-container ul",parentRow);for(var id in responseData){var productText=$("<li>").text(responseData[id]);subProductsContainer.append(productText);}},registerSubProducts:function registerSubProducts(container){var thisInstance=this;container.find(".inventoryItems .js-inventory-row").each(function(index){thisInstance.loadSubProducts($(this),!1);});},registerCollapsiblePanels:function registerCollapsiblePanels(detailViewContainer){var _this3=this,panels=detailViewContainer.find(".js-detail-widget-collapse"),storageName="yf-".concat(app.getModuleName(),"-detail-widgets");if(Quasar.plugins.LocalStorage.has(storageName))this.setPanels({panels:panels,storageName:storageName});else {panels.collapse("show");var panelsStorage={};panels.each(function(i,item){panelsStorage[item.dataset.storageId]="shown";}),Quasar.plugins.LocalStorage.set(storageName,panelsStorage);}panels.on("hidden.bs.collapse shown.bs.collapse",function(e){_this3.updatePanelsStorage({id:e.target.dataset.storageKey,type:e.type,storageName:storageName});}),panels.on("hide.bs.collapse show.bs.collapse",function(e){$(e.currentTarget).siblings(".js-detail-widget-header").toggleClass("collapsed");});},setPanels:function setPanels(_ref){var panels=_ref.panels,storageName=_ref.storageName,panelsStorage=Quasar.plugins.LocalStorage.getItem(storageName);panels.each(function(i,item){("shown"===panelsStorage[item.dataset.storageKey]||void 0===panelsStorage[item.dataset.storageKey])&&($(item).collapse("show"),$(item).siblings(".js-detail-widget-header").toggleClass("collapsed"));});},updatePanelsStorage:function updatePanelsStorage(_ref2){var id=_ref2.id,type=_ref2.type,storageName=_ref2.storageName,panelsStorage=Quasar.plugins.LocalStorage.getItem(storageName);panelsStorage[id]=type,Quasar.plugins.LocalStorage.set(storageName,panelsStorage);},registerSendPdfFromPdfViewer:function registerSendPdfFromPdfViewer(container){container.find(".js-email-pdf").on("click",function(e){var selectedPdfTemplate=$(e.currentTarget).closest(".js-detail-widget").find(".js-pdf-viewer-template").val(),url=$(this).attr("data-url");url&&selectedPdfTemplate&&0<selectedPdfTemplate&&window.open(url+selectedPdfTemplate,"_blank");});},/**
		 * Register keyboard shortcuts events
		 * @param {jQuery} container
		 */registerKeyboardShortcutsEvent:function registerKeyboardShortcutsEvent(container){document.addEventListener("keydown",function(event){event.shiftKey&&event.ctrlKey&&"KeyD"===event.code&&container.find(".js-duplicate-btn").trigger("click"),event.shiftKey&&event.ctrlKey&&"KeyE"===event.code&&container.find(".js-edit-btn").length&&container.find(".js-edit-btn").trigger("click"),event.shiftKey&&event.ctrlKey&&"KeyW"===event.code&&container.find(".js-edit-btn").length&&App.Components.QuickEdit.showModal({module:app.getModuleName(),record:app.getRecordId(),removeFromUrl:"step"});});},registerEvents:function registerEvents(){this.registerSendSmsSubmitEvent(),this.registerAjaxEditEvent(),this.registerRelatedRowClickEvent(),this.registerBlockStatusCheckOnLoad(),this.registerEventForRelatedTabClick(),Vtiger_Helper_Js.showHorizontalTopScrollBar(),this.registerUrlFieldClickEvent();var detailViewContainer=jQuery("div.detailViewContainer");0>=detailViewContainer.length||(App.Fields.Text.registerCopyClipboard(detailViewContainer),this.registerWidgetProductAndServices(),this.registerSetReadRecord(detailViewContainer),this.getForm().validationEngine(app.validationEngineOptionsForRecord),this.loadWidgetsEvents(),this.loadWidgets(),this.registerBasicEvents(),this.registerEventForTotalRecordsCount(),this.registerProgress(),this.registerChat(detailViewContainer),this.registerSendPdfFromPdfViewer(detailViewContainer),this.registerKeyboardShortcutsEvent(detailViewContainer),App.Components.ActivityNotifier.register(detailViewContainer));}});
//# sourceMappingURL=Detail.min.js.map
