'use strict';

/* {[The file is published on the basis of YetiForce Public License 7.0 that can be found in the following directory: licenses/LicenseEN.txt or yetiforce.com]} */"use strict";jQuery.Class("Settings_QuickCreateEditor_Js",{},{updatedBlockSequence:{},updatedBlockFieldsList:[],/**
		 * Function which will enable the save button in realted tabs list
		 */showSaveButton:function showSaveButton(){var relatedList=jQuery("#relatedTabOrder"),saveButton=relatedList.find(".saveRelatedList");"disabled"==saveButton.attr("disabled")&&saveButton.removeAttr("disabled");},/**
		 * Function to regiser the event to make the fields sortable
		 */makeFieldsListSortable:function makeFieldsListSortable(){var thisInstance=this,contents=jQuery("#quickCreateEditorContainer").find(".contents");jQuery("#quickCreateEditorContainer .contents .editFieldsTable").each(function(){jQuery(this).find("ul[name=sortable1], ul[name=sortable2]").sortable({containment:"#moduleBlocks",revert:!0,tolerance:"pointer",cursor:"move",connectWith:jQuery(this).find(".connectedSortable"),update:function update(e,ui){// rearrange the older block fields
if(thisInstance.showSaveFieldSequenceButton(),ui.sender){var olderBlock=ui.sender.closest(".editFieldsTable");thisInstance.reArrangeBlockFields(olderBlock);}}});});},/**
		 * Function to show the save button of fieldSequence
		 */showSaveFieldSequenceButton:function showSaveFieldSequenceButton(){var thisInstance=this,layout=jQuery("#detailViewLayout"),saveButton=layout.find(".saveFieldSequence");thisInstance.updatedBlockFieldsList=[],saveButton.removeClass("visibility");},/**
		 * Function which will hide the saveFieldSequence button
		 */hideSaveFieldSequenceButton:function hideSaveFieldSequenceButton(){var layout=jQuery("#detailViewLayout"),saveButton=layout.find(".saveFieldSequence");saveButton.addClass("visibility");},/**
		 * Function that rearranges fields in the block when the fields are moved
		 * @param <jQuery object> block
		 */reArrangeBlockFields:function reArrangeBlockFields(block){// 1.get the containers, 2.compare the length, 3.if uneven then move the last element
var leftSideContainer=block.find("ul[name=sortable1]"),rightSideContainer=block.find("ul[name=sortable2]");if(leftSideContainer.children().length<rightSideContainer.children().length){var lastElementInRightContainer=rightSideContainer.children(":last");leftSideContainer.append(lastElementInRightContainer);}else if(leftSideContainer.children().length>rightSideContainer.children().length+1){//greater than 1
var lastElementInLeftContainer=leftSideContainer.children(":last");rightSideContainer.append(lastElementInLeftContainer);}},/**
		 * Function to create the list of updated blocks with all the fields and their sequences
		 */createUpdatedBlockFieldsList:function createUpdatedBlockFieldsList(){var thisInstance=this,contents=$("#quickCreateEditorContainer").find(".contents"),updatedBlock=contents.find(".block");if("blocks"===app.getMainParams("quickCreateLayout"))updatedBlock.each(function(i,domElement){var updatedBlock=jQuery(domElement),firstBlockSortFields=updatedBlock.find("ul[name=sortable1]"),editFields=firstBlockSortFields.find(".editFields"),expectedFieldSequence=1;editFields.each(function(i,domElement){var fieldEle=$(domElement),fieldId=fieldEle.data("fieldId");thisInstance.updatedBlockFieldsList.push({fieldid:fieldId,sequence:expectedFieldSequence}),expectedFieldSequence+=2;});var secondBlockSortFields=updatedBlock.find("ul[name=sortable2]"),secondEditFields=secondBlockSortFields.find(".editFields"),sequenceValue=2;secondEditFields.each(function(i,domElement){var fieldEle=$(domElement),fieldId=fieldEle.data("fieldId");thisInstance.updatedBlockFieldsList.push({fieldid:fieldId,sequence:sequenceValue}),sequenceValue+=2;});});else {var firstBlockSortFields=updatedBlock.find("ul[name=sortable1]"),tmpArray=[];firstBlockSortFields.each(function(i,domElement){var fieldEle=jQuery(domElement),eleAmount=fieldEle.find(".editFields").length;tmpArray.push(eleAmount);});var editFields=firstBlockSortFields.find(".editFields"),expectedFieldSequence=1;editFields.each(function(i,domElement){var fieldEle=jQuery(domElement),fieldId=fieldEle.data("fieldId");thisInstance.updatedBlockFieldsList.push({fieldid:fieldId,sequence:expectedFieldSequence}),expectedFieldSequence+=2,i==tmpArray[0]-1&&(expectedFieldSequence=1);});var secondBlockSortFields=updatedBlock.find("ul[name=sortable2]"),secondEditFields=secondBlockSortFields.find(".editFields"),sequenceValue=2;tmpArray=[],secondBlockSortFields.each(function(i,domElement){var fieldEle=jQuery(domElement),eleAmount=fieldEle.find(".editFields").length;tmpArray.push(eleAmount);}),secondEditFields.each(function(i,domElement){var fieldEle=jQuery(domElement),fieldId=fieldEle.data("fieldId");thisInstance.updatedBlockFieldsList.push({fieldid:fieldId,sequence:sequenceValue}),sequenceValue+=2,i==tmpArray[0]-1&&(sequenceValue=2);});}},/**
		 * Function to register click event for save button of fields sequence
		 */registerFieldSequenceSaveClick:function registerFieldSequenceSaveClick(){var thisInstance=this,layout=jQuery("#detailViewLayout");layout.on("click",".saveFieldSequence",function(){thisInstance.hideSaveFieldSequenceButton(),thisInstance.createUpdatedBlockFieldsList(),thisInstance.updateFieldSequence();});},/**
		 * Function will save the field sequences
		 */updateFieldSequence:function updateFieldSequence(){var thisInstance=this,progressIndicatorElement=jQuery.progressIndicator({position:"html",blockInfo:{enabled:!0}}),params={};params.module=app.getModuleName(),params.parent=app.getParentModuleName(),params.action="SaveSequenceNumber",params.mode="move",params.updatedFields=thisInstance.updatedBlockFieldsList,AppConnector.request(params).done(function(){//window.location.reload();
progressIndicatorElement.progressIndicator({mode:"hide"}),Settings_Vtiger_Index_Js.showMessage({text:app.vtranslate("JS_FIELD_SEQUENCE_UPDATED")});}).fail(function(){progressIndicatorElement.progressIndicator({mode:"hide"});});},/**
		 * Function to register click event for drop-downs in fields list
		 */avoidDropDownClick:function avoidDropDownClick(dropDownContainer){dropDownContainer.find(".dropdown-menu").on("click",function(e){e.stopPropagation();});},/*
		 * Function to add clickoutside event on the element - By using outside events plugin
		 * @params element---On which element you want to apply the click outside event
		 * @params callbackFunction---This function will contain the actions triggered after clickoutside event
		 */addClickOutSideEvent:function addClickOutSideEvent(element,callbackFunction){element.one("clickoutside",callbackFunction);},/**
		 * Function to register the change event for layout editor modules list
		 */registerModulesChangeEvent:function registerModulesChangeEvent(){var thisInstance=this,container=jQuery("#quickCreateEditorContainer"),contentsDiv=container.closest(".contentsDiv");App.Fields.Picklist.showSelect2ElementView(container.find("[name=\"quickCreateEditorModules\"]"),{dropdownCss:{"z-index":0}}),container.on("change","[name=\"quickCreateEditorModules\"]",function(e){var currentTarget=jQuery(e.currentTarget),selectedModule=currentTarget.val();thisInstance.getModuleQuickCreateEditor(selectedModule).done(function(data){contentsDiv.html(data),thisInstance.registerEvents();});});},/**
		 * Function to get the respective module layout editor through pjax
		 */getModuleQuickCreateEditor:function getModuleQuickCreateEditor(selectedModule){var aDeferred=jQuery.Deferred(),progressIndicatorElement=jQuery.progressIndicator({position:"html",blockInfo:{enabled:!0}}),params={};return params.module=app.getModuleName(),params.parent=app.getParentModuleName(),params.view="Index",params.sourceModule=selectedModule,AppConnector.requestPjax(params).done(function(data){progressIndicatorElement.progressIndicator({mode:"hide"}),aDeferred.resolve(data);}).fail(function(){progressIndicatorElement.progressIndicator({mode:"hide"}),aDeferred.reject();}),aDeferred.promise()},/**
		 * register events for layout editor
		 */registerEvents:function registerEvents(){var thisInstance=this;thisInstance.registerModulesChangeEvent(),thisInstance.makeFieldsListSortable(),thisInstance.registerFieldSequenceSaveClick();}}),jQuery(document).ready(function(){var instance=new Settings_QuickCreateEditor_Js;instance.registerEvents();});
//# sourceMappingURL=QuickCreateEditor.min.js.map
