<?php

/**
 * OAuth authorization action file.
 *
 * @package Action
 *
 * @copyright YetiForce S.A.
 * @license   YetiForce Public License 7.0 (licenses/LicenseEN.txt or yetiforce.com)
 * @author    Radosław Skrzypczak <r.skrzypczak@yetiforce.com>
 */

use App\Mail\Account\Repository;
use App\Mail\Account\Repository\SmtpRepository;

/**
 * OAuth authorization action class.
 */
class Settings_MailSmtp_OAuth_Action extends Settings_Vtiger_Basic_Action
{
	/** {@inheritdoc} */
	public function checkPermission(App\Request $request)
	{
		parent::checkPermission($request);

		$recordModel = Settings_MailSmtp_Record_Model::getInstanceById($request->getInteger('record'));
		if (!$recordModel || !$recordModel->isOAuth()) {
			throw new \App\Exceptions\NoPermittedToRecord('ERR_NO_PERMISSIONS_FOR_THE_RECORD', 406);
		}
	}

	/** {@inheritdoc} */
	public function process(App\Request $request)
	{
		$recordId = $request->getInteger('record');
		$class = SmtpRepository::class;

		$repository = (new Repository())->get($class);
		$accountEntity = $repository->findById($recordId);
		$mailAccount = new \App\Mail\Account($accountEntity, $repository);
		$provider = $mailAccount->getOAuthProvider();
		$recordModel = Settings_MailSmtp_Record_Model::getInstanceById($recordId);

		$state = $provider->getState();
		$options = ['login_hint' => $mailAccount->getLogin()];
		if (!$accountEntity->getRefreshToken() || !$accountEntity->getPassword()) {
			$options['prompt'] = 'consent';
		}
		$url = $provider->getAuthorizationUrl($options);

		$hash = sha1($state);
		\App\Session::set("OAuth.State.{$hash}", [
			'state' => $state,
			'recordId' => $recordId,
			'redirectUri' => \App\Config::main('site_URL') . $recordModel->getEditViewUrl(),
			'repositoryClass' => $class,
		]);

		header('location: ' . $url);
		exit;
	}

	/** {@inheritdoc} */
	public function validateRequest(App\Request $request)
	{
		$request->validateReadAccess();
	}
}
