<?php

/**
 * Select modules for report modal view file.
 *
 * @package View
 *
 * @copyright YetiForce S.A.
 * @license   YetiForce Public License 7.0 (licenses/LicenseEN.txt or yetiforce.com)
 * @author    Adrian Kon <a.kon@yetiforce.com>
 */

use App\Report\Provider\RestrictedModulesProvider;

/**
 * Select modules for report modal view class.
 */
class ReportTemplate_SelectModulesModal_View extends \App\Controller\Modal
{
	/** {@inheritdoc} */
	public $modalSize = 'modal-xl';

	/** {@inheritdoc} */
	public $modalIcon = 'fa-solid fa-repeat';

	/** {@inheritdoc} */
	public $showFooter = false;

	/** {@inheritdoc} */
	public $lockExit = true;

	/** {@inheritdoc} */
	protected $pageTitle = 'LBL_SELECT_DATA_SOURCES';

	/** {@inheritdoc} */
	public function checkPermission(App\Request $request)
	{
		if (!\App\Privilege::isPermitted($request->getModule())) {
			throw new \App\Exceptions\NoPermittedToRecord('ERR_NO_PERMISSIONS_FOR_THE_RECORD', 406);
		}
	}

	/** {@inheritdoc} */
	public function process(App\Request $request): void
	{
		$moduleName = $request->getModule();
		$viewer = $this->getViewer($request);
		$viewer->assign('RELATIONS', Vtiger_Module_Model::getInstance($moduleName)->getRelations());
		$restrictedFields = RestrictedModulesProvider::provide();
		if (false === in_array($userModuleName = 'Users', $restrictedFields)) {
			$restrictedFields[] = $userModuleName;
		}

		$viewer->assign('ALL_MODULES',
			Vtiger_Module_Model::getAll([0], $restrictedFields, true),
		);
		$viewer->view('Modals/SelectModules.tpl', $moduleName);
	}
}
