<?php

/**
 * Comarch account address synchronization map file.
 *
 * The file is part of the paid functionality. Using the file is allowed only after purchasing a subscription.
 * File modification allowed only with the consent of the system producer.
 *
 * @package Integration
 *
 * @copyright YetiForce S.A.
 * @license   YetiForce Public License 7.0 (licenses/LicenseEN.txt or yetiforce.com)
 * @author    Mariusz Krzaczkowski <m.krzaczkowski@yetiforce.com>
 */

namespace App\Integrations\Comarch\Xl\Maps;

/**
 * Comarch account address synchronization map class.
 */
class AccountAddress extends \App\Integrations\Comarch\Map
{
	/** {@inheritdoc} */
	const API_NAME_ID = 'knA_GidNumer';
	/** {@inheritdoc} */
	protected $moduleName = 'Accounts';
	/** {@inheritdoc} */
	protected $fieldMap = [
		'company_name_' => ['names' => ['get' => 'knA_Nazwa1', 'create' => 'Nazwa1']],
		'vat_id_' => [
			'names' => ['get' => 'knA_NipE', 'create' => 'NipE'],
			'prefixNames' => ['get' => 'knA_NipPrefiks', 'create' => 'NipPrefiks'],
			'fn' => 'convertVatId',
		],
		'addresslevel1' => ['names' => ['get' => 'knA_Kraj', 'create' => 'Kraj'], 'fn' => 'convertCountry'],
		'addresslevel2' => [
			'names' => ['get' => 'knA_Wojewodztwo', 'create' => 'Wojewodztwo'], 'optional' => true
		],
		'addresslevel3' => [
			'names' => ['get' => 'knA_Powiat', 'create' => 'Powiat'], 'optional' => true
		],
		'addresslevel4' => [
			'names' => ['get' => 'knA_Gmina', 'create' => 'Gmina'], 'optional' => true
		],
		'addresslevel5' => [
			'names' => ['get' => 'knA_Miasto', 'create' => 'Miasto'], 'optional' => true
		],
		'addresslevel7' => [
			'names' => ['get' => 'knA_KodP', 'create' => 'KodP'], 'optional' => true
		],
		'addresslevel8' => ['names' => ['get' => 'knA_Ulica', 'create' => 'Ulica']],
		'buildingnumber' => [
			'names' => ['get' => 'knA_Adres', 'create' => 'Adres'], 'optional' => true
		],
		'email_' => [
			'names' => ['get' => 'knA_Email', 'create' => 'Email'], 'fn' => 'convertTrim', 'optional' => true
		],
		'phone_' => [
			'names' => ['get' => 'knA_Telefon1', 'create' => 'Telefon1'], 'fn' => 'convertPhone', 'optional' => true
		],
		'account_id' => [
			'name' => 'KntNumer', 'direction' => 'api',
			'fn' => 'findByRelationship', 'synchronizer' => 'Accounts',
		],
	];
}
