<?php
/**
 * Mongo Query file
 *
 * @package \App\Db\Mongo
 *
 * @copyright YetiForce S.A.
 * @license   YetiForce Public License 7.0 (licenses/LicenseEN.txt or yetiforce.com)
 * @author    Mateusz Slominski <m.slominski@yetiforce.com>
 */
declare(strict_types=1);

namespace App\Db\Mongo;

/**
 * Mongo Query class
 */
class Query extends \yii\mongodb\Query
{
	/** @var int Sort Ascending */
	public const SORT_ASC = 1;

	/** @var int Sort Descending */
	public const SORT_DESC = -1;

	/**
	 * {@inheritDoc}
	 */
	public function getCollection($db = null)
	{
		if ($db === null) {
			$db = \App\Db\Mongo::getInstance();
		}

		return $db->getCollection($this->from);
	}
}
