/* {[The file is published on the basis of YetiForce Public License 7.0 that can be found in the following directory: licenses/LicenseEN.txt or yetiforce.com]} */
'use strict';

Settings_Vtiger_List_Js(
	'Settings_OSSMailScanner_List_Js',
	{},
	{
		/**
		 * Register list modal
		 */
		registerListModal: function () {
			this.getListViewContainer().on('click', '.js-mail-show-folders', (e) => {
				this.showListModal(e);
			});
		},

		saveAjax: function (data, id) {
			let progress = $.progressIndicator({
				message: app.vtranslate('JS_SAVE_LOADER_INFO'),
				position: 'html',
				blockInfo: {
					enabled: true
				}
			});
			app.saveAjax(null, null, { folders: data.id, record: id }).done((data) => {
				progress.progressIndicator({ mode: 'hide' });
				if (data.success) {
					this.getListViewRecords();
				} else {
					app.showNotify({
						text: app.vtranslate('JS_ERROR'),
						type: 'error'
					});
				}
			});
		},

		/**
		 * Show list modal
		 * @param {int} id
		 */
		showListModal: function (e) {
			let progress = $.progressIndicator({
				position: 'html',
				blockInfo: {
					enabled: true
				}
			});
			app.showModalWindow(null, e.currentTarget.dataset.url, (modalContainer) => {
				progress.progressIndicator({ mode: 'hide' });
				let id = e.currentTarget.dataset.id;
				app.registerModalController(false, modalContainer, (_modal, instance) => {
					instance.setSelectEvent((responseData) => {
						this.saveAjax(responseData, id);
					});
				});
			});
		},
		/**
		 * Function to register events
		 */
		registerEvents: function () {
			this._super();
			this.registerListModal();
		}
	}
);
