<?php

/**
 * Configuration file.
 * This file is auto-generated.
 *
 * @package Config
 *
 * @copyright YetiForce S.A.
 * @license   YetiForce Public License 7.0 (licenses/LicenseEN.txt or yetiforce.com)
 */

namespace Config;

/**
 * Configuration file: Config\Db.
 */
class Db
{
	/** Gets the database server */
	public static $db_server = '[[softdbhost]]';

	/** Gets the database port */
	public static $db_port = '3306';

	/** Gets the database user name */
	public static $db_username = '[[softdbuser]]';

	/** Gets the database password */
	public static $db_password = '[[softdbpass]]';

	/** Gets the database name */
	public static $db_name = '[[softdb]]';

	/** Gets the database type */
	public static $db_type = 'mysql';

	/** Gets the mongo database server */
	public static $mongo_server = '';

	/** Gets the mongo database port */
	public static $mongo_port = '';

	/** Gets the mongo database user name */
	public static $mongo_username = '';

	/** Gets the mongo database password */
	public static $mongo_password = '';

	/** Gets the mongo database name */
	public static $mongo_name = '';

	/** Gets the mongo database type */
	public static $mongo_type = 'mongodb';


	/**
	 * Gets host name.
	 */
	public static function db_hostname()
	{
		return self::$db_server . ':' . self::$db_port;
	}


	/**
	 * Basic database configuration.
	 */
	public static function base()
	{
		return [
			'dsn' => self::$db_type . ':host=' . self::$db_server . ';dbname=' . self::$db_name . ';port=' . self::$db_port,
			'host' => self::$db_server,
			'port' => self::$db_port,
			'username' => self::$db_username,
			'password' => self::$db_password,
			'dbName' => self::$db_name,
			'tablePrefix' => 'yf_',
			'charset' => 'utf8',
		];
	}


	/**
	 * Mongo database configuration.
	 */
	public static function mongo()
	{
		if (!self::$mongo_username) {
			return null;
		}
		return [
			'dsn' => sprintf('%s://%s:%s@%s:%d/%s', self::$mongo_type, urlencode(self::$mongo_username), urlencode(self::$mongo_password), self::$mongo_server, self::$mongo_port, self::$mongo_name),
			'tablePrefix' => 'yf_',
		];
	}
}
