<?php
//Default Configuration
$CONFIG = '{"lang":"en","error_reporting":false,"show_hidden":true,"hide_Cols":false,"theme":"dark"}';

/**
 * H3K | Tiny File Manager V2.5.3-WH1Z-Edition
 * @author CCP Programmers
 * @modder PinoyWH1Z
 * @mod-email g2mfuotbs@mozmail.com
 * @mod-github https://github.com/PinoyWH1Z/tinyfilemanager-wh1z-edition
 * @mod-note I made some changes/update to ensure that the file manager remains compact and doesn't rely on external resources. 
 * This modification can be incredibly useful for red teaming purposes.
 */

//TFM version
define('VERSION', '2.5.3-WH1Z-Edition');

//Application Title
define('APP_TITLE', 'Tiny File Manager [WH1Z-Edition]');
define('APP_TITLE_LOGIN', "Tiny File Manager<br>[WH1Z-Edition]");

// --- EDIT BELOW CONFIGURATION CAREFULLY ---

// Auth with login/password
// set true/false to enable/disable it
// Is independent from IP white- and blacklisting
$use_auth = true;

// Login user name and password
// Users: array('Username' => 'Password', 'Username2' => 'Password2', ...)
// Generate secure password hash: Click Admin -> Help -> Generate new password hash
$auth_users = array(
    'admin' => '$2y$10$/K.hjNr84lLNDt8fTXjoI.DBp6PpeyoJ.mGwrrLuCZfAwfSAGqhOW', //admin@123
    'user' => '$2y$10$Zdju9e.6o38Su430se1MA.oP0z9l0eF4jSQRExZ6rNkn4dN8C0hGC' //WH1Z123
);

// Readonly users
// e.g. array('users', 'guest', ...)
$readonly_users = array(
    'user'
);

// Global readonly, including when auth is not being used
$global_readonly = false;

// user specific directories
// array('Username' => 'Directory path', 'Username2' => 'Directory path', ...)
$directories_users = array();

// Enable highlight.js (https://highlightjs.org/) on view's page
$use_highlightjs = true;

// highlight.js style
// for dark theme use 'ir-black'
$highlightjs_style = 'vs';

// Enable ace.js (https://ace.c9.io/) on view's page
$edit_files = true;

// Default timezone for date() and time()
// Doc - http://php.net/manual/en/timezones.php
$default_timezone = 'Etc/UTC'; // UTC

// Root path for file manager
// use absolute path of directory i.e: '/var/www/folder' or $_SERVER['DOCUMENT_ROOT'].'/folder'
$root_path = $_SERVER['DOCUMENT_ROOT'];

// Root url for links in file manager.Relative to $http_host. Variants: '', 'path/to/subfolder'
// Will not working if $root_path will be outside of server document root
$root_url = '';

// Server hostname. Can set manually if wrong
// $_SERVER['HTTP_HOST'].'/folder'
$http_host = $_SERVER['HTTP_HOST'];

// input encoding for iconv
$iconv_input_encoding = 'UTF-8';

// date() format for file modification date
// Doc - https://www.php.net/manual/en/function.date.php
$datetime_format = 'm/d/Y g:i A';

// Path display mode when viewing file information
// 'full' => show full path
// 'relative' => show path relative to root_path
// 'host' => show path on the host
$path_display_mode = 'full';

// Allowed file extensions for create and rename files
// e.g. 'txt,html,css,js'
$allowed_file_extensions = '';

// Allowed file extensions for upload files
// e.g. 'gif,png,jpg,html,txt'
$allowed_upload_extensions = '';

// Files and folders to excluded from listing
// e.g. array('myfile.html', 'personal-folder', '*.php', ...)
$exclude_items = array();

// Online office Docs Viewer
// Availabe rules are 'google', 'microsoft' or false
// Google => View documents using Google Docs Viewer
// Microsoft => View documents using Microsoft Web Apps Viewer
// false => disable online doc viewer
$online_viewer = 'google';

// Sticky Nav bar
// true => enable sticky header
// false => disable sticky header
$sticky_navbar = true;

// Maximum file upload size
// Increase the following values in php.ini to work properly
// memory_limit, upload_max_filesize, post_max_size
$max_upload_size_bytes = 5000000000; // size 5,000,000,000 bytes (~5GB)

// chunk size used for upload
// eg. decrease to 1MB if nginx reports problem 413 entity too large
$upload_chunk_size_bytes = 2000000; // chunk size 2,000,000 bytes (~2MB)

// Possible rules are 'OFF', 'AND' or 'OR'
// OFF => Don't check connection IP, defaults to OFF
// AND => Connection must be on the whitelist, and not on the blacklist
// OR => Connection must be on the whitelist, or not on the blacklist
$ip_ruleset = 'OFF';

// Should users be notified of their block?
$ip_silent = true;

// IP-addresses, both ipv4 and ipv6
$ip_whitelist = array(
    '127.0.0.1',    // local ipv4
    '::1'           // local ipv6
);

// IP-addresses, both ipv4 and ipv6
$ip_blacklist = array(
    '0.0.0.0',      // non-routable meta ipv4
    '::'            // non-routable meta ipv6
);

// if User has the external config file, try to use it to override the default config above [config.php]
// Intentionally disabled. To enable, refer to the orig author's site: https://tinyfilemanager.github.io/
/*
$config_file = __DIR__.'/config.php';
if (is_readable($config_file)) {
    @include($config_file);
}
*/

$highlightjs_style_resource = '';

if($highlightjs_style === 'ir-black'){
    $highlightjs_style_resource = 'cHJlIGNvZGUuaGxqc3tkaXNwbGF5OmJsb2NrO292ZXJmbG93LXg6YXV0bztwYWRkaW5nOjFlbX1jb2RlLmhsanN7cGFkZGluZzozcHggNXB4fS5obGpze2JhY2tncm91bmQ6IzAwMDtjb2xvcjojZjhmOGY4fS5obGpzLWNvbW1lbnQsLmhsanMtbWV0YSwuaGxqcy1xdW90ZXtjb2xvcjojN2M3YzdjfS5obGpzLWtleXdvcmQsLmhsanMtbmFtZSwuaGxqcy1zZWxlY3Rvci10YWcsLmhsanMtdGFne2NvbG9yOiM5NmNiZmV9LmhsanMtYXR0cmlidXRlLC5obGpzLXNlbGVjdG9yLWlke2NvbG9yOiNmZmZmYjZ9LmhsanMtYWRkaXRpb24sLmhsanMtc2VsZWN0b3ItYXR0ciwuaGxqcy1zZWxlY3Rvci1wc2V1ZG8sLmhsanMtc3RyaW5ne2NvbG9yOiNhOGZmNjB9LmhsanMtc3Vic3R7Y29sb3I6I2RhZWZhM30uaGxqcy1saW5rLC5obGpzLXJlZ2V4cHtjb2xvcjojZTljMDYyfS5obGpzLWRvY3RhZywuaGxqcy1zZWN0aW9uLC5obGpzLXRpdGxlLC5obGpzLXR5cGV7Y29sb3I6I2ZmZmZiNn0uaGxqcy1idWxsZXQsLmhsanMtbGl0ZXJhbCwuaGxqcy1zeW1ib2wsLmhsanMtdGVtcGxhdGUtdmFyaWFibGUsLmhsanMtdmFyaWFibGV7Y29sb3I6I2M2YzVmZX0uaGxqcy1kZWxldGlvbiwuaGxqcy1udW1iZXJ7Y29sb3I6I2ZmNzNmZH0uaGxqcy1lbXBoYXNpc3tmb250LXN0eWxlOml0YWxpY30uaGxqcy1zdHJvbmd7Zm9udC13ZWlnaHQ6NzAwfQ==';
}
else if($highlightjs_style === 'vs'){
    $highlightjs_style_resource = 'cHJlIGNvZGUuaGxqc3tkaXNwbGF5OmJsb2NrO292ZXJmbG93LXg6YXV0bztwYWRkaW5nOjFlbX1jb2RlLmhsanN7cGFkZGluZzozcHggNXB4fS5obGpze2JhY2tncm91bmQ6I2ZmZjtjb2xvcjojMDAwfS5obGpzLWNvbW1lbnQsLmhsanMtcXVvdGUsLmhsanMtdmFyaWFibGV7Y29sb3I6Z3JlZW59LmhsanMtYnVpbHRfaW4sLmhsanMta2V5d29yZCwuaGxqcy1uYW1lLC5obGpzLXNlbGVjdG9yLXRhZywuaGxqcy10YWd7Y29sb3I6IzAwZn0uaGxqcy1hZGRpdGlvbiwuaGxqcy1hdHRyaWJ1dGUsLmhsanMtbGl0ZXJhbCwuaGxqcy1zZWN0aW9uLC5obGpzLXN0cmluZywuaGxqcy10ZW1wbGF0ZS10YWcsLmhsanMtdGVtcGxhdGUtdmFyaWFibGUsLmhsanMtdGl0bGUsLmhsanMtdHlwZXtjb2xvcjojYTMxNTE1fS5obGpzLWRlbGV0aW9uLC5obGpzLW1ldGEsLmhsanMtc2VsZWN0b3ItYXR0ciwuaGxqcy1zZWxlY3Rvci1wc2V1ZG97Y29sb3I6IzJiOTFhZn0uaGxqcy1kb2N0YWd7Y29sb3I6Z3JleX0uaGxqcy1hdHRye2NvbG9yOnJlZH0uaGxqcy1idWxsZXQsLmhsanMtbGluaywuaGxqcy1zeW1ib2x7Y29sb3I6IzAwYjBlOH0uaGxqcy1lbXBoYXNpc3tmb250LXN0eWxlOml0YWxpY30uaGxqcy1zdHJvbmd7Zm9udC13ZWlnaHQ6NzAwfQ==';
}

// Embedded resources
$external = array(
    'css-bootstrap' => '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',
    'css-dropzone' => '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',
    'css-font-awesome' => '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',
    'css-highlightjs' => $highlightjs_style_resource,
    'js-ace' => 'KGZ1bmN0aW9uKCl7ZnVuY3Rpb24gbyhuKXt2YXIgaT1lO24mJihlW25dfHwoZVtuXT17fSksaT1lW25dKTtpZighaS5kZWZpbmV8fCFpLmRlZmluZS5wYWNrYWdlZCl0Lm9yaWdpbmFsPWkuZGVmaW5lLGkuZGVmaW5lPXQsaS5kZWZpbmUucGFja2FnZWQ9ITA7aWYoIWkucmVxdWlyZXx8IWkucmVxdWlyZS5wYWNrYWdlZClyLm9yaWdpbmFsPWkucmVxdWlyZSxpLnJlcXVpcmU9cixpLnJlcXVpcmUucGFja2FnZWQ9ITB9dmFyIEFDRV9OQU1FU1BBQ0U9IiIsZT1mdW5jdGlvbigpe3JldHVybiB0aGlzfSgpOyFlJiZ0eXBlb2Ygd2luZG93IT0idW5kZWZpbmVkIiYmKGU9d2luZG93KTtpZighQUNFX05BTUVTUEFDRSYmdHlwZW9mIHJlcXVpcmVqcyE9InVuZGVmaW5lZCIpcmV0dXJuO3ZhciB0PWZ1bmN0aW9uKGUsbixyKXtpZih0eXBlb2YgZSE9InN0cmluZyIpe3Qub3JpZ2luYWw/dC5vcmlnaW5hbC5hcHBseSh0aGlzLGFyZ3VtZW50cyk6KGNvbnNvbGUuZXJyb3IoImRyb3BwaW5nIG1vZHVsZSBiZWNhdXNlIGRlZmluZSB3YXNuJ3QgYSBzdHJpbmcuIiksY29uc29sZS50cmFjZSgpKTtyZXR1cm59YXJndW1lbnRzLmxlbmd0aD09MiYmKHI9biksdC5tb2R1bGVzW2VdfHwodC5wYXlsb2Fkc1tlXT1yLHQubW9kdWxlc1tlXT1udWxsKX07dC5tb2R1bGVzPXt9LHQucGF5bG9hZHM9e307dmFyIG49ZnVuY3Rpb24oZSx0LG4pe2lmKHR5cGVvZiB0PT0ic3RyaW5nIil7dmFyIGk9cyhlLHQpO2lmKGkhPXVuZGVmaW5lZClyZXR1cm4gbiYmbigpLGl9ZWxzZSBpZihPYmplY3QucHJvdG90eXBlLnRvU3RyaW5nLmNhbGwodCk9PT0iW29iamVjdCBBcnJheV0iKXt2YXIgbz1bXTtmb3IodmFyIHU9MCxhPXQubGVuZ3RoO3U8YTsrK3Upe3ZhciBmPXMoZSx0W3VdKTtpZihmPT11bmRlZmluZWQmJnIub3JpZ2luYWwpcmV0dXJuO28ucHVzaChmKX1yZXR1cm4gbiYmbi5hcHBseShudWxsLG8pfHwhMH19LHI9ZnVuY3Rpb24oZSx0KXt2YXIgaT1uKCIiLGUsdCk7cmV0dXJuIGk9PXVuZGVmaW5lZCYmci5vcmlnaW5hbD9yLm9yaWdpbmFsLmFwcGx5KHRoaXMsYXJndW1lbnRzKTppfSxpPWZ1bmN0aW9uKGUsdCl7aWYodC5pbmRleE9mKCIhIikhPT0tMSl7dmFyIG49dC5zcGxpdCgiISIpO3JldHVybiBpKGUsblswXSkrIiEiK2koZSxuWzFdKX1pZih0LmNoYXJBdCgwKT09Ii4iKXt2YXIgcj1lLnNwbGl0KCIvIikuc2xpY2UoMCwtMSkuam9pbigiLyIpO3Q9cisiLyIrdDt3aGlsZSh0LmluZGV4T2YoIi4iKSE9PS0xJiZzIT10KXt2YXIgcz10O3Q9dC5yZXBsYWNlKC9cL1wuXC8vLCIvIikucmVwbGFjZSgvW15cL10rXC9cLlwuXC8vLCIiKX19cmV0dXJuIHR9LHM9ZnVuY3Rpb24oZSxyKXtyPWkoZSxyKTt2YXIgcz10Lm1vZHVsZXNbcl07aWYoIXMpe3M9dC5wYXlsb2Fkc1tyXTtpZih0eXBlb2Ygcz09ImZ1bmN0aW9uIil7dmFyIG89e30sdT17aWQ6cix1cmk6IiIsZXhwb3J0czpvLHBhY2thZ2VkOiEwfSxhPWZ1bmN0aW9uKGUsdCl7cmV0dXJuIG4ocixlLHQpfSxmPXMoYSxvLHUpO289Znx8dS5leHBvcnRzLHQubW9kdWxlc1tyXT1vLGRlbGV0ZSB0LnBheWxvYWRzW3JdfXM9dC5tb2R1bGVzW3JdPW98fHN9cmV0dXJuIHN9O28oQUNFX05BTUVTUEFDRSl9KSgpLGRlZmluZSgiYWNlL2xpYi9lczYtc2hpbSIsWyJyZXF1aXJlIiwiZXhwb3J0cyIsIm1vZHVsZSJdLGZ1bmN0aW9uKGUsdCxuKXtmdW5jdGlvbiByKGUsdCxuKXtPYmplY3QuZGVmaW5lUHJvcGVydHkoZSx0LHt2YWx1ZTpuLGVudW1lcmFibGU6ITEsd3JpdGFibGU6ITAsY29uZmlndXJhYmxlOiEwfSl9U3RyaW5nLnByb3RvdHlwZS5zdGFydHNXaXRofHxyKFN0cmluZy5wcm90b3R5cGUsInN0YXJ0c1dpdGgiLGZ1bmN0aW9uKGUsdCl7cmV0dXJuIHQ9dHx8MCx0aGlzLmxhc3RJbmRleE9mKGUsdCk9PT10fSksU3RyaW5nLnByb3RvdHlwZS5lbmRzV2l0aHx8cihTdHJpbmcucHJvdG90eXBlLCJlbmRzV2l0aCIsZnVuY3Rpb24oZSx0KXt2YXIgbj10aGlzO2lmKHQ9PT11bmRlZmluZWR8fHQ+bi5sZW5ndGgpdD1uLmxlbmd0aDt0LT1lLmxlbmd0aDt2YXIgcj1uLmluZGV4T2YoZSx0KTtyZXR1cm4gciE9PS0xJiZyPT09dH0pLFN0cmluZy5wcm90b3R5cGUucmVwZWF0fHxyKFN0cmluZy5wcm90b3R5cGUsInJlcGVhdCIsZnVuY3Rpb24oZSl7dmFyIHQ9IiIsbj10aGlzO3doaWxlKGU+MCl7ZSYxJiYodCs9bik7aWYoZT4+PTEpbis9bn1yZXR1cm4gdH0pLFN0cmluZy5wcm90b3R5cGUuaW5jbHVkZXN8fHIoU3RyaW5nLnByb3RvdHlwZSwiaW5jbHVkZXMiLGZ1bmN0aW9uKGUsdCl7cmV0dXJuIHRoaXMuaW5kZXhPZihlLHQpIT0tMX0pLE9iamVjdC5hc3NpZ258fChPYmplY3QuYXNzaWduPWZ1bmN0aW9uKGUpe2lmKGU9PT11bmRlZmluZWR8fGU9PT1udWxsKXRocm93IG5ldyBUeXBlRXJyb3IoIkNhbm5vdCBjb252ZXJ0IHVuZGVmaW5lZCBvciBudWxsIHRvIG9iamVjdCIpO3ZhciB0PU9iamVjdChlKTtmb3IodmFyIG49MTtuPGFyZ3VtZW50cy5sZW5ndGg7bisrKXt2YXIgcj1hcmd1bWVudHNbbl07ciE9PXVuZGVmaW5lZCYmciE9PW51bGwmJk9iamVjdC5rZXlzKHIpLmZvckVhY2goZnVuY3Rpb24oZSl7dFtlXT1yW2VdfSl9cmV0dXJuIHR9KSxPYmplY3QudmFsdWVzfHwoT2JqZWN0LnZhbHVlcz1mdW5jdGlvbihlKXtyZXR1cm4gT2JqZWN0LmtleXMoZSkubWFwKGZ1bmN0aW9uKHQpe3JldHVybiBlW3RdfSl9KSxBcnJheS5wcm90b3R5cGUuZmluZHx8cihBcnJheS5wcm90b3R5cGUsImZpbmQiLGZ1bmN0aW9uKGUpe3ZhciB0PXRoaXMubGVuZ3RoLG49YXJndW1lbnRzWzFdO2Zvcih2YXIgcj0wO3I8dDtyKyspe3ZhciBpPXRoaXNbcl07aWYoZS5jYWxsKG4saSxyLHRoaXMpKXJldHVybiBpfX0pLEFycmF5LnByb3RvdHlwZS5maW5kSW5kZXh8fHIoQXJyYXkucHJvdG90eXBlLCJmaW5kSW5kZXgiLGZ1bmN0aW9uKGUpe3ZhciB0PXRoaXMubGVuZ3RoLG49YXJndW1lbnRzWzFdO2Zvcih2YXIgcj0wO3I8dDtyKyspe3ZhciBpPXRoaXNbcl07aWYoZS5jYWxsKG4saSxyLHRoaXMpKXJldHVybiByfX0pLEFycmF5LnByb3RvdHlwZS5pbmNsdWRlc3x8cihBcnJheS5wcm90b3R5cGUsImluY2x1ZGVzIixmdW5jdGlvbihlLHQpe3JldHVybiB0aGlzLmluZGV4T2YoZSx0KSE9LTF9KSxBcnJheS5wcm90b3R5cGUuZmlsbHx8cihBcnJheS5wcm90b3R5cGUsImZpbGwiLGZ1bmN0aW9uKGUpe3ZhciB0PXRoaXMsbj10Lmxlbmd0aD4+PjAscj1hcmd1bWVudHNbMV0saT1yPj4wLHM9aTwwP01hdGgubWF4KG4raSwwKTpNYXRoLm1pbihpLG4pLG89YXJndW1lbnRzWzJdLHU9bz09PXVuZGVmaW5lZD9uOm8+PjAsYT11PDA/TWF0aC5tYXgobit1LDApOk1hdGgubWluKHUsbik7d2hpbGUoczxhKXRbc109ZSxzKys7cmV0dXJuIHR9KSxBcnJheS5vZnx8cihBcnJheSwib2YiLGZ1bmN0aW9uKCl7cmV0dXJuIEFycmF5LnByb3RvdHlwZS5zbGljZS5jYWxsKGFyZ3VtZW50cyl9KX0pLGRlZmluZSgiYWNlL2xpYi9maXhvbGRicm93c2VycyIsWyJyZXF1aXJlIiwiZXhwb3J0cyIsIm1vZHVsZSIsImFjZS9saWIvZXM2LXNoaW0iXSxmdW5jdGlvbihlLHQsbil7InVzZSBzdHJpY3QiO2UoIi4vZXM2LXNoaW0iKX0pLGRlZmluZSgiYWNlL2xpYi9sYW5nIixbInJlcXVpcmUiLCJleHBvcnRzIiwibW9kdWxlIl0sZnVuY3Rpb24oZSx0LG4peyJ1c2Ugc3RyaWN0Ijt0Lmxhc3Q9ZnVuY3Rpb24oZSl7cmV0dXJuIGVbZS5sZW5ndGgtMV19LHQuc3RyaW5nUmV2ZXJzZT1mdW5jdGlvbihlKXtyZXR1cm4gZS5zcGxpdCgiIikucmV2ZXJzZSgpLmpvaW4oIiIpfSx0LnN0cmluZ1JlcGVhdD1mdW5jdGlvbihlLHQpe3ZhciBuPSIiO3doaWxlKHQ+MCl7dCYxJiYobis9ZSk7aWYodD4+PTEpZSs9ZX1yZXR1cm4gbn07dmFyIHI9L15cc1xzKi8saT0vXHNccyokLzt0LnN0cmluZ1RyaW1MZWZ0PWZ1bmN0aW9uKGUpe3JldHVybiBlLnJlcGxhY2UociwiIil9LHQuc3RyaW5nVHJpbVJpZ2h0PWZ1bmN0aW9uKGUpe3JldHVybiBlLnJlcGxhY2UoaSwiIil9LHQuY29weU9iamVjdD1mdW5jdGlvbihlKXt2YXIgdD17fTtmb3IodmFyIG4gaW4gZSl0W25dPWVbbl07cmV0dXJuIHR9LHQuY29weUFycmF5PWZ1bmN0aW9uKGUpe3ZhciB0PVtdO2Zvcih2YXIgbj0wLHI9ZS5sZW5ndGg7bjxyO24rKyllW25dJiZ0eXBlb2YgZVtuXT09Im9iamVjdCI/dFtuXT10aGlzLmNvcHlPYmplY3QoZVtuXSk6dFtuXT1lW25dO3JldHVybiB0fSx0LmRlZXBDb3B5PWZ1bmN0aW9uIHMoZSl7aWYodHlwZW9mIGUhPSJvYmplY3QifHwhZSlyZXR1cm4gZTt2YXIgdDtpZihBcnJheS5pc0FycmF5KGUpKXt0PVtdO2Zvcih2YXIgbj0wO248ZS5sZW5ndGg7bisrKXRbbl09cyhlW25dKTtyZXR1cm4gdH1pZihPYmplY3QucHJvdG90eXBlLnRvU3RyaW5nLmNhbGwoZSkhPT0iW29iamVjdCBPYmplY3RdIilyZXR1cm4gZTt0PXt9O2Zvcih2YXIgbiBpbiBlKXRbbl09cyhlW25dKTtyZXR1cm4gdH0sdC5hcnJheVRvTWFwPWZ1bmN0aW9uKGUpe3ZhciB0PXt9O2Zvcih2YXIgbj0wO248ZS5sZW5ndGg7bisrKXRbZVtuXV09MTtyZXR1cm4gdH0sdC5jcmVhdGVNYXA9ZnVuY3Rpb24oZSl7dmFyIHQ9T2JqZWN0LmNyZWF0ZShudWxsKTtmb3IodmFyIG4gaW4gZSl0W25dPWVbbl07cmV0dXJuIHR9LHQuYXJyYXlSZW1vdmU9ZnVuY3Rpb24oZSx0KXtmb3IodmFyIG49MDtuPD1lLmxlbmd0aDtuKyspdD09PWVbbl0mJmUuc3BsaWNlKG4sMSl9LHQuZXNjYXBlUmVnRXhwPWZ1bmN0aW9uKGUpe3JldHVybiBlLnJlcGxhY2UoLyhbLiorP14ke30oKXxbXF1cL1xcXSkvZywiXFwkMSIpfSx0LmVzY2FwZUhUTUw9ZnVuY3Rpb24oZSl7cmV0dXJuKCIiK2UpLnJlcGxhY2UoLyYvZywiJiMzODsiKS5yZXBsYWNlKC8iL2csIiYjMzQ7IikucmVwbGFjZSgvJy9nLCImIzM5OyIpLnJlcGxhY2UoLzwvZywiJiM2MDsiKX0sdC5nZXRNYXRjaE9mZnNldHM9ZnVuY3Rpb24oZSx0KXt2YXIgbj1bXTtyZXR1cm4gZS5yZXBsYWNlKHQsZnVuY3Rpb24oZSl7bi5wdXNoKHtvZmZzZXQ6YXJndW1lbnRzW2FyZ3VtZW50cy5sZW5ndGgtMl0sbGVuZ3RoOmUubGVuZ3RofSl9KSxufSx0LmRlZmVycmVkQ2FsbD1mdW5jdGlvbihlKXt2YXIgdD1udWxsLG49ZnVuY3Rpb24oKXt0PW51bGwsZSgpfSxyPWZ1bmN0aW9uKGUpe3JldHVybiByLmNhbmNlbCgpLHQ9c2V0VGltZW91dChuLGV8fDApLHJ9O3JldHVybiByLnNjaGVkdWxlPXIsci5jYWxsPWZ1bmN0aW9uKCl7cmV0dXJuIHRoaXMuY2FuY2VsKCksZSgpLHJ9LHIuY2FuY2VsPWZ1bmN0aW9uKCl7cmV0dXJuIGNsZWFyVGltZW91dCh0KSx0PW51bGwscn0sci5pc1BlbmRpbmc9ZnVuY3Rpb24oKXtyZXR1cm4gdH0scn0sdC5kZWxheWVkQ2FsbD1mdW5jdGlvbihlLHQpe3ZhciBuPW51bGwscj1mdW5jdGlvbigpe249bnVsbCxlKCl9LGk9ZnVuY3Rpb24oZSl7bj09bnVsbCYmKG49c2V0VGltZW91dChyLGV8fHQpKX07cmV0dXJuIGkuZGVsYXk9ZnVuY3Rpb24oZSl7biYmY2xlYXJUaW1lb3V0KG4pLG49c2V0VGltZW91dChyLGV8fHQpfSxpLnNjaGVkdWxlPWksaS5jYWxsPWZ1bmN0aW9uKCl7dGhpcy5jYW5jZWwoKSxlKCl9LGkuY2FuY2VsPWZ1bmN0aW9uKCl7biYmY2xlYXJUaW1lb3V0KG4pLG49bnVsbH0saS5pc1BlbmRpbmc9ZnVuY3Rpb24oKXtyZXR1cm4gbn0saX19KSxkZWZpbmUoImFjZS9saWIvb29wIixbInJlcXVpcmUiLCJleHBvcnRzIiwibW9kdWxlIl0sZnVuY3Rpb24oZSx0LG4peyJ1c2Ugc3RyaWN0Ijt0LmluaGVyaXRzPWZ1bmN0aW9uKGUsdCl7ZS5zdXBlcl89dCxlLnByb3RvdHlwZT1PYmplY3QuY3JlYXRlKHQucHJvdG90eXBlLHtjb25zdHJ1Y3Rvcjp7dmFsdWU6ZSxlbnVtZXJhYmxlOiExLHdyaXRhYmxlOiEwLGNvbmZpZ3VyYWJsZTohMH19KX0sdC5taXhpbj1mdW5jdGlvbihlLHQpe2Zvcih2YXIgbiBpbiB0KWVbbl09dFtuXTtyZXR1cm4gZX0sdC5pbXBsZW1lbnQ9ZnVuY3Rpb24oZSxuKXt0Lm1peGluKGUsbil9fSksZGVmaW5lKCJhY2UvbGliL3VzZXJhZ2VudCIsWyJyZXF1aXJlIiwiZXhwb3J0cyIsIm1vZHVsZSJdLGZ1bmN0aW9uKGUsdCxuKXsidXNlIHN0cmljdCI7dC5PUz17TElOVVg6IkxJTlVYIixNQUM6Ik1BQyIsV0lORE9XUzoiV0lORE9XUyJ9LHQuZ2V0T1M9ZnVuY3Rpb24oKXtyZXR1cm4gdC5pc01hYz90Lk9TLk1BQzp0LmlzTGludXg/dC5PUy5MSU5VWDp0Lk9TLldJTkRPV1N9O3ZhciByPXR5cGVvZiBuYXZpZ2F0b3I9PSJvYmplY3QiP25hdmlnYXRvcjp7fSxpPSgvbWFjfHdpbnxsaW51eC9pLmV4ZWMoci5wbGF0Zm9ybSl8fFsib3RoZXIiXSlbMF0udG9Mb3dlckNhc2UoKSxzPXIudXNlckFnZW50fHwiIixvPXIuYXBwTmFtZXx8IiI7dC5pc1dpbj1pPT0id2luIix0LmlzTWFjPWk9PSJtYWMiLHQuaXNMaW51eD1pPT0ibGludXgiLHQuaXNJRT1vPT0iTWljcm9zb2Z0IEludGVybmV0IEV4cGxvcmVyInx8by5pbmRleE9mKCJNU0FwcEhvc3QiKT49MD9wYXJzZUZsb2F0KChzLm1hdGNoKC8oPzpNU0lFIHxUcmlkZW50XC9bMC05XStbXC4wLTldKzsuKnJ2OikoWzAtOV0rW1wuMC05XSspLyl8fFtdKVsxXSk6cGFyc2VGbG9hdCgocy5tYXRjaCgvKD86VHJpZGVudFwvWzAtOV0rW1wuMC05XSs7LipydjopKFswLTldK1tcLjAtOV0rKS8pfHxbXSlbMV0pLHQuaXNPbGRJRT10LmlzSUUmJnQuaXNJRTw5LHQuaXNHZWNrbz10LmlzTW96aWxsYT1zLm1hdGNoKC8gR2Vja29cL1xkKy8pLHQuaXNPcGVyYT10eXBlb2Ygb3BlcmE9PSJvYmplY3QiJiZPYmplY3QucHJvdG90eXBlLnRvU3RyaW5nLmNhbGwod2luZG93Lm9wZXJhKT09IltvYmplY3QgT3BlcmFdIix0LmlzV2ViS2l0PXBhcnNlRmxvYXQocy5zcGxpdCgiV2ViS2l0LyIpWzFdKXx8dW5kZWZpbmVkLHQuaXNDaHJvbWU9cGFyc2VGbG9hdChzLnNwbGl0KCIgQ2hyb21lLyIpWzFdKXx8dW5kZWZpbmVkLHQuaXNFZGdlPXBhcnNlRmxvYXQocy5zcGxpdCgiIEVkZ2UvIilbMV0pfHx1bmRlZmluZWQsdC5pc0FJUj1zLmluZGV4T2YoIkFkb2JlQUlSIik+PTAsdC5pc0FuZHJvaWQ9cy5pbmRleE9mKCJBbmRyb2lkIik+PTAsdC5pc0Nocm9tZU9TPXMuaW5kZXhPZigiIENyT1MgIik+PTAsdC5pc0lPUz0vaVBhZHxpUGhvbmV8aVBvZC8udGVzdChzKSYmIXdpbmRvdy5NU1N0cmVhbSx0LmlzSU9TJiYodC5pc01hYz0hMCksdC5pc01vYmlsZT10LmlzSU9TfHx0LmlzQW5kcm9pZH0pLGRlZmluZSgiYWNlL2xpYi9kb20iLFsicmVxdWlyZSIsImV4cG9ydHMiLCJtb2R1bGUiLCJhY2UvbGliL3VzZXJhZ2VudCJdLGZ1bmN0aW9uKGUsdCxuKXsidXNlIHN0cmljdCI7ZnVuY3Rpb24gdSgpe3ZhciBlPW87bz1udWxsLGUmJmUuZm9yRWFjaChmdW5jdGlvbihlKXthKGVbMF0sZVsxXSl9KX1mdW5jdGlvbiBhKGUsbixyKXtpZih0eXBlb2YgZG9jdW1lbnQ9PSJ1bmRlZmluZWQiKXJldHVybjtpZihvKWlmKHIpdSgpO2Vsc2UgaWYocj09PSExKXJldHVybiBvLnB1c2goW2Usbl0pO2lmKHMpcmV0dXJuO3ZhciBpPXI7aWYoIXJ8fCFyLmdldFJvb3ROb2RlKWk9ZG9jdW1lbnQ7ZWxzZXtpPXIuZ2V0Um9vdE5vZGUoKTtpZighaXx8aT09cilpPWRvY3VtZW50fXZhciBhPWkub3duZXJEb2N1bWVudHx8aTtpZihuJiZ0Lmhhc0Nzc1N0cmluZyhuLGkpKXJldHVybiBudWxsO24mJihlKz0iXG4vKiMgc291cmNlVVJMPWFjZS9jc3MvIituKyIgKi8iKTt2YXIgZj10LmNyZWF0ZUVsZW1lbnQoInN0eWxlIik7Zi5hcHBlbmRDaGlsZChhLmNyZWF0ZVRleHROb2RlKGUpKSxuJiYoZi5pZD1uKSxpPT1hJiYoaT10LmdldERvY3VtZW50SGVhZChhKSksaS5pbnNlcnRCZWZvcmUoZixpLmZpcnN0Q2hpbGQpfXZhciByPWUoIi4vdXNlcmFnZW50IiksaT0iaHR0cDovL3d3dy53My5vcmcvMTk5OS94aHRtbCI7dC5idWlsZERvbT1mdW5jdGlvbiBsKGUsdCxuKXtpZih0eXBlb2YgZT09InN0cmluZyImJmUpe3ZhciByPWRvY3VtZW50LmNyZWF0ZVRleHROb2RlKGUpO3JldHVybiB0JiZ0LmFwcGVuZENoaWxkKHIpLHJ9aWYoIUFycmF5LmlzQXJyYXkoZSkpcmV0dXJuIGUmJmUuYXBwZW5kQ2hpbGQmJnQmJnQuYXBwZW5kQ2hpbGQoZSksZTtpZih0eXBlb2YgZVswXSE9InN0cmluZyJ8fCFlWzBdKXt2YXIgaT1bXTtmb3IodmFyIHM9MDtzPGUubGVuZ3RoO3MrKyl7dmFyIG89bChlW3NdLHQsbik7byYmaS5wdXNoKG8pfXJldHVybiBpfXZhciB1PWRvY3VtZW50LmNyZWF0ZUVsZW1lbnQoZVswXSksYT1lWzFdLGY9MTthJiZ0eXBlb2YgYT09Im9iamVjdCImJiFBcnJheS5pc0FycmF5KGEpJiYoZj0yKTtmb3IodmFyIHM9ZjtzPGUubGVuZ3RoO3MrKylsKGVbc10sdSxuKTtyZXR1cm4gZj09MiYmT2JqZWN0LmtleXMoYSkuZm9yRWFjaChmdW5jdGlvbihlKXt2YXIgdD1hW2VdO2U9PT0iY2xhc3MiP3UuY2xhc3NOYW1lPUFycmF5LmlzQXJyYXkodCk/dC5qb2luKCIgIik6dDp0eXBlb2YgdD09ImZ1bmN0aW9uInx8ZT09InZhbHVlInx8ZVswXT09IiQiP3VbZV09dDplPT09InJlZiI/biYmKG5bdF09dSk6ZT09PSJzdHlsZSI/dHlwZW9mIHQ9PSJzdHJpbmciJiYodS5zdHlsZS5jc3NUZXh0PXQpOnQhPW51bGwmJnUuc2V0QXR0cmlidXRlKGUsdCl9KSx0JiZ0LmFwcGVuZENoaWxkKHUpLHV9LHQuZ2V0RG9jdW1lbnRIZWFkPWZ1bmN0aW9uKGUpe3JldHVybiBlfHwoZT1kb2N1bWVudCksZS5oZWFkfHxlLmdldEVsZW1lbnRzQnlUYWdOYW1lKCJoZWFkIilbMF18fGUuZG9jdW1lbnRFbGVtZW50fSx0LmNyZWF0ZUVsZW1lbnQ9ZnVuY3Rpb24oZSx0KXtyZXR1cm4gZG9jdW1lbnQuY3JlYXRlRWxlbWVudE5TP2RvY3VtZW50LmNyZWF0ZUVsZW1lbnROUyh0fHxpLGUpOmRvY3VtZW50LmNyZWF0ZUVsZW1lbnQoZSl9LHQucmVtb3ZlQ2hpbGRyZW49ZnVuY3Rpb24oZSl7ZS5pbm5lckhUTUw9IiJ9LHQuY3JlYXRlVGV4dE5vZGU9ZnVuY3Rpb24oZSx0KXt2YXIgbj10P3Qub3duZXJEb2N1bWVudDpkb2N1bWVudDtyZXR1cm4gbi5jcmVhdGVUZXh0Tm9kZShlKX0sdC5jcmVhdGVGcmFnbWVudD1mdW5jdGlvbihlKXt2YXIgdD1lP2Uub3duZXJEb2N1bWVudDpkb2N1bWVudDtyZXR1cm4gdC5jcmVhdGVEb2N1bWVudEZyYWdtZW50KCl9LHQuaGFzQ3NzQ2xhc3M9ZnVuY3Rpb24oZSx0KXt2YXIgbj0oZS5jbGFzc05hbWUrIiIpLnNwbGl0KC9ccysvZyk7cmV0dXJuIG4uaW5kZXhPZih0KSE9PS0xfSx0LmFkZENzc0NsYXNzPWZ1bmN0aW9uKGUsbil7dC5oYXNDc3NDbGFzcyhlLG4pfHwoZS5jbGFzc05hbWUrPSIgIituKX0sdC5yZW1vdmVDc3NDbGFzcz1mdW5jdGlvbihlLHQpe3ZhciBuPWUuY2xhc3NOYW1lLnNwbGl0KC9ccysvZyk7Zm9yKDs7KXt2YXIgcj1uLmluZGV4T2YodCk7aWYocj09LTEpYnJlYWs7bi5zcGxpY2UociwxKX1lLmNsYXNzTmFtZT1uLmpvaW4oIiAiKX0sdC50b2dnbGVDc3NDbGFzcz1mdW5jdGlvbihlLHQpe3ZhciBuPWUuY2xhc3NOYW1lLnNwbGl0KC9ccysvZykscj0hMDtmb3IoOzspe3ZhciBpPW4uaW5kZXhPZih0KTtpZihpPT0tMSlicmVhaztyPSExLG4uc3BsaWNlKGksMSl9cmV0dXJuIHImJm4ucHVzaCh0KSxlLmNsYXNzTmFtZT1uLmpvaW4oIiAiKSxyfSx0LnNldENzc0NsYXNzPWZ1bmN0aW9uKGUsbixyKXtyP3QuYWRkQ3NzQ2xhc3MoZSxuKTp0LnJlbW92ZUNzc0NsYXNzKGUsbil9LHQuaGFzQ3NzU3RyaW5nPWZ1bmN0aW9uKGUsdCl7dmFyIG49MCxyO3Q9dHx8ZG9jdW1lbnQ7aWYocj10LnF1ZXJ5U2VsZWN0b3JBbGwoInN0eWxlIikpd2hpbGUobjxyLmxlbmd0aClpZihyW24rK10uaWQ9PT1lKXJldHVybiEwfSx0LnJlbW92ZUVsZW1lbnRCeUlkPWZ1bmN0aW9uKGUsdCl7dD10fHxkb2N1bWVudCx0LmdldEVsZW1lbnRCeUlkKGUpJiZ0LmdldEVsZW1lbnRCeUlkKGUpLnJlbW92ZSgpfTt2YXIgcyxvPVtdO3QudXNlU3RyaWN0Q1NQPWZ1bmN0aW9uKGUpe3M9ZSxlPT0wP3UoKTpvfHwobz1bXSl9LHQuaW1wb3J0Q3NzU3RyaW5nPWEsdC5pbXBvcnRDc3NTdHlsc2hlZXQ9ZnVuY3Rpb24oZSxuKXt0LmJ1aWxkRG9tKFsibGluayIse3JlbDoic3R5bGVzaGVldCIsaHJlZjplfV0sdC5nZXREb2N1bWVudEhlYWQobikpfSx0LnNjcm9sbGJhcldpZHRoPWZ1bmN0aW9uKGUpe3ZhciBuPXQuY3JlYXRlRWxlbWVudCgiYWNlX2lubmVyIik7bi5zdHlsZS53aWR0aD0iMTAwJSIsbi5zdHlsZS5taW5XaWR0aD0iMHB4IixuLnN0eWxlLmhlaWdodD0iMjAwcHgiLG4uc3R5bGUuZGlzcGxheT0iYmxvY2siO3ZhciByPXQuY3JlYXRlRWxlbWVudCgiYWNlX291dGVyIiksaT1yLnN0eWxlO2kucG9zaXRpb249ImFic29sdXRlIixpLmxlZnQ9Ii0xMDAwMHB4IixpLm92ZXJmbG93PSJoaWRkZW4iLGkud2lkdGg9IjIwMHB4IixpLm1pbldpZHRoPSIwcHgiLGkuaGVpZ2h0PSIxNTBweCIsaS5kaXNwbGF5PSJibG9jayIsci5hcHBlbmRDaGlsZChuKTt2YXIgcz1lJiZlLmRvY3VtZW50RWxlbWVudHx8ZG9jdW1lbnQmJmRvY3VtZW50LmRvY3VtZW50RWxlbWVudDtpZighcylyZXR1cm4gMDtzLmFwcGVuZENoaWxkKHIpO3ZhciBvPW4ub2Zmc2V0V2lkdGg7aS5vdmVyZmxvdz0ic2Nyb2xsIjt2YXIgdT1uLm9mZnNldFdpZHRoO3JldHVybiBvPT09dSYmKHU9ci5jbGllbnRXaWR0aCkscy5yZW1vdmVDaGlsZChyKSxvLXV9LHQuY29tcHV0ZWRTdHlsZT1mdW5jdGlvbihlLHQpe3JldHVybiB3aW5kb3cuZ2V0Q29tcHV0ZWRTdHlsZShlLCIiKXx8e319LHQuc2V0U3R5bGU9ZnVuY3Rpb24oZSx0LG4pe2VbdF0hPT1uJiYoZVt0XT1uKX0sdC5IQVNfQ1NTX0FOSU1BVElPTj0hMSx0LkhBU19DU1NfVFJBTlNGT1JNUz0hMSx0LkhJX0RQST1yLmlzV2luP3R5cGVvZiB3aW5kb3chPSJ1bmRlZmluZWQiJiZ3aW5kb3cuZGV2aWNlUGl4ZWxSYXRpbz49MS41OiEwLHIuaXNDaHJvbWVPUyYmKHQuSElfRFBJPSExKTtpZih0eXBlb2YgZG9jdW1lbnQhPSJ1bmRlZmluZWQiKXt2YXIgZj1kb2N1bWVudC5jcmVhdGVFbGVtZW50KCJkaXYiKTt0LkhJX0RQSSYmZi5zdHlsZS50cmFuc2Zvcm0hPT11bmRlZmluZWQmJih0LkhBU19DU1NfVFJBTlNGT1JNUz0hMCksIXIuaXNFZGdlJiZ0eXBlb2YgZi5zdHlsZS5hbmltYXRpb25OYW1lIT0idW5kZWZpbmVkIiYmKHQuSEFTX0NTU19BTklNQVRJT049ITApLGY9bnVsbH10LkhBU19DU1NfVFJBTlNGT1JNUz90LnRyYW5zbGF0ZT1mdW5jdGlvbihlLHQsbil7ZS5zdHlsZS50cmFuc2Zvcm09InRyYW5zbGF0ZSgiK01hdGgucm91bmQodCkrInB4LCAiK01hdGgucm91bmQobikrInB4KSJ9OnQudHJhbnNsYXRlPWZ1bmN0aW9uKGUsdCxuKXtlLnN0eWxlLnRvcD1NYXRoLnJvdW5kKG4pKyJweCIsZS5zdHlsZS5sZWZ0PU1hdGgucm91bmQodCkrInB4In19KSxkZWZpbmUoImFjZS9saWIvbmV0IixbInJlcXVpcmUiLCJleHBvcnRzIiwibW9kdWxlIiwiYWNlL2xpYi9kb20iXSxmdW5jdGlvbihlLHQsbil7InVzZSBzdHJpY3QiO3ZhciByPWUoIi4vZG9tIik7dC5nZXQ9ZnVuY3Rpb24oZSx0KXt2YXIgbj1uZXcgWE1MSHR0cFJlcXVlc3Q7bi5vcGVuKCJHRVQiLGUsITApLG4ub25yZWFkeXN0YXRlY2hhbmdlPWZ1bmN0aW9uKCl7bi5yZWFkeVN0YXRlPT09NCYmdChuLnJlc3BvbnNlVGV4dCl9LG4uc2VuZChudWxsKX0sdC5sb2FkU2NyaXB0PWZ1bmN0aW9uKGUsdCl7dmFyIG49ci5nZXREb2N1bWVudEhlYWQoKSxpPWRvY3VtZW50LmNyZWF0ZUVsZW1lbnQoInNjcmlwdCIpO2kuc3JjPWUsbi5hcHBlbmRDaGlsZChpKSxpLm9ubG9hZD1pLm9ucmVhZHlzdGF0ZWNoYW5nZT1mdW5jdGlvbihlLG4pe2lmKG58fCFpLnJlYWR5U3RhdGV8fGkucmVhZHlTdGF0ZT09ImxvYWRlZCJ8fGkucmVhZHlTdGF0ZT09ImNvbXBsZXRlIilpPWkub25sb2FkPWkub25yZWFkeXN0YXRlY2hhbmdlPW51bGwsbnx8dCgpfX0sdC5xdWFsaWZ5VVJMPWZ1bmN0aW9uKGUpe3ZhciB0PWRvY3VtZW50LmNyZWF0ZUVsZW1lbnQoImEiKTtyZXR1cm4gdC5ocmVmPWUsdC5ocmVmfX0pLGRlZmluZSgiYWNlL2xpYi9ldmVudF9lbWl0dGVyIixbInJlcXVpcmUiLCJleHBvcnRzIiwibW9kdWxlIl0sZnVuY3Rpb24oZSx0LG4peyJ1c2Ugc3RyaWN0Ijt2YXIgcj17fSxpPWZ1bmN0aW9uKCl7dGhpcy5wcm9wYWdhdGlvblN0b3BwZWQ9ITB9LHM9ZnVuY3Rpb24oKXt0aGlzLmRlZmF1bHRQcmV2ZW50ZWQ9ITB9O3IuX2VtaXQ9ci5fZGlzcGF0Y2hFdmVudD1mdW5jdGlvbihlLHQpe3RoaXMuX2V2ZW50UmVnaXN0cnl8fCh0aGlzLl9ldmVudFJlZ2lzdHJ5PXt9KSx0aGlzLl9kZWZhdWx0SGFuZGxlcnN8fCh0aGlzLl9kZWZhdWx0SGFuZGxlcnM9e30pO3ZhciBuPXRoaXMuX2V2ZW50UmVnaXN0cnlbZV18fFtdLHI9dGhpcy5fZGVmYXVsdEhhbmRsZXJzW2VdO2lmKCFuLmxlbmd0aCYmIXIpcmV0dXJuO2lmKHR5cGVvZiB0IT0ib2JqZWN0Inx8IXQpdD17fTt0LnR5cGV8fCh0LnR5cGU9ZSksdC5zdG9wUHJvcGFnYXRpb258fCh0LnN0b3BQcm9wYWdhdGlvbj1pKSx0LnByZXZlbnREZWZhdWx0fHwodC5wcmV2ZW50RGVmYXVsdD1zKSxuPW4uc2xpY2UoKTtmb3IodmFyIG89MDtvPG4ubGVuZ3RoO28rKyl7bltvXSh0LHRoaXMpO2lmKHQucHJvcGFnYXRpb25TdG9wcGVkKWJyZWFrfWlmKHImJiF0LmRlZmF1bHRQcmV2ZW50ZWQpcmV0dXJuIHIodCx0aGlzKX0sci5fc2lnbmFsPWZ1bmN0aW9uKGUsdCl7dmFyIG49KHRoaXMuX2V2ZW50UmVnaXN0cnl8fHt9KVtlXTtpZighbilyZXR1cm47bj1uLnNsaWNlKCk7Zm9yKHZhciByPTA7cjxuLmxlbmd0aDtyKyspbltyXSh0LHRoaXMpfSxyLm9uY2U9ZnVuY3Rpb24oZSx0KXt2YXIgbj10aGlzO3RoaXMub24oZSxmdW5jdGlvbiByKCl7bi5vZmYoZSxyKSx0LmFwcGx5KG51bGwsYXJndW1lbnRzKX0pO2lmKCF0KXJldHVybiBuZXcgUHJvbWlzZShmdW5jdGlvbihlKXt0PWV9KX0sci5zZXREZWZhdWx0SGFuZGxlcj1mdW5jdGlvbihlLHQpe3ZhciBuPXRoaXMuX2RlZmF1bHRIYW5kbGVycztufHwobj10aGlzLl9kZWZhdWx0SGFuZGxlcnM9e19kaXNhYmxlZF86e319KTtpZihuW2VdKXt2YXIgcj1uW2VdLGk9bi5fZGlzYWJsZWRfW2VdO2l8fChuLl9kaXNhYmxlZF9bZV09aT1bXSksaS5wdXNoKHIpO3ZhciBzPWkuaW5kZXhPZih0KTtzIT0tMSYmaS5zcGxpY2UocywxKX1uW2VdPXR9LHIucmVtb3ZlRGVmYXVsdEhhbmRsZXI9ZnVuY3Rpb24oZSx0KXt2YXIgbj10aGlzLl9kZWZhdWx0SGFuZGxlcnM7aWYoIW4pcmV0dXJuO3ZhciByPW4uX2Rpc2FibGVkX1tlXTtpZihuW2VdPT10KXImJnRoaXMuc2V0RGVmYXVsdEhhbmRsZXIoZSxyLnBvcCgpKTtlbHNlIGlmKHIpe3ZhciBpPXIuaW5kZXhPZih0KTtpIT0tMSYmci5zcGxpY2UoaSwxKX19LHIub249ci5hZGRFdmVudExpc3RlbmVyPWZ1bmN0aW9uKGUsdCxuKXt0aGlzLl9ldmVudFJlZ2lzdHJ5PXRoaXMuX2V2ZW50UmVnaXN0cnl8fHt9O3ZhciByPXRoaXMuX2V2ZW50UmVnaXN0cnlbZV07cmV0dXJuIHJ8fChyPXRoaXMuX2V2ZW50UmVnaXN0cnlbZV09W10pLHIuaW5kZXhPZih0KT09LTEmJnJbbj8idW5zaGlmdCI6InB1c2giXSh0KSx0fSxyLm9mZj1yLnJlbW92ZUxpc3RlbmVyPXIucmVtb3ZlRXZlbnRMaXN0ZW5lcj1mdW5jdGlvbihlLHQpe3RoaXMuX2V2ZW50UmVnaXN0cnk9dGhpcy5fZXZlbnRSZWdpc3RyeXx8e307dmFyIG49dGhpcy5fZXZlbnRSZWdpc3RyeVtlXTtpZighbilyZXR1cm47dmFyIHI9bi5pbmRleE9mKHQpO3IhPT0tMSYmbi5zcGxpY2UociwxKX0sci5yZW1vdmVBbGxMaXN0ZW5lcnM9ZnVuY3Rpb24oZSl7ZXx8KHRoaXMuX2V2ZW50UmVnaXN0cnk9dGhpcy5fZGVmYXVsdEhhbmRsZXJzPXVuZGVmaW5lZCksdGhpcy5fZXZlbnRSZWdpc3RyeSYmKHRoaXMuX2V2ZW50UmVnaXN0cnlbZV09dW5kZWZpbmVkKSx0aGlzLl9kZWZhdWx0SGFuZGxlcnMmJih0aGlzLl9kZWZhdWx0SGFuZGxlcnNbZV09dW5kZWZpbmVkKX0sdC5FdmVudEVtaXR0ZXI9cn0pLGRlZmluZSgiYWNlL2xpYi9hcHBfY29uZmlnIixbInJlcXVpcmUiLCJleHBvcnRzIiwibW9kdWxlIiwiYWNlL2xpYi9vb3AiLCJhY2UvbGliL2V2ZW50X2VtaXR0ZXIiXSxmdW5jdGlvbihlLHQsbil7Im5vIHVzZSBzdHJpY3QiO2Z1bmN0aW9uIG8oZSl7dHlwZW9mIGNvbnNvbGUhPSJ1bmRlZmluZWQiJiZjb25zb2xlLndhcm4mJmNvbnNvbGUud2Fybi5hcHBseShjb25zb2xlLGFyZ3VtZW50cyl9ZnVuY3Rpb24gdShlLHQpe3ZhciBuPW5ldyBFcnJvcihlKTtuLmRhdGE9dCx0eXBlb2YgY29uc29sZT09Im9iamVjdCImJmNvbnNvbGUuZXJyb3ImJmNvbnNvbGUuZXJyb3Iobiksc2V0VGltZW91dChmdW5jdGlvbigpe3Rocm93IG59KX12YXIgcj1lKCIuL29vcCIpLGk9ZSgiLi9ldmVudF9lbWl0dGVyIikuRXZlbnRFbWl0dGVyLHM9e3NldE9wdGlvbnM6ZnVuY3Rpb24oZSl7T2JqZWN0LmtleXMoZSkuZm9yRWFjaChmdW5jdGlvbih0KXt0aGlzLnNldE9wdGlvbih0LGVbdF0pfSx0aGlzKX0sZ2V0T3B0aW9uczpmdW5jdGlvbihlKXt2YXIgdD17fTtpZighZSl7dmFyIG49dGhpcy4kb3B0aW9ucztlPU9iamVjdC5rZXlzKG4pLmZpbHRlcihmdW5jdGlvbihlKXtyZXR1cm4hbltlXS5oaWRkZW59KX1lbHNlIEFycmF5LmlzQXJyYXkoZSl8fCh0PWUsZT1PYmplY3Qua2V5cyh0KSk7cmV0dXJuIGUuZm9yRWFjaChmdW5jdGlvbihlKXt0W2VdPXRoaXMuZ2V0T3B0aW9uKGUpfSx0aGlzKSx0fSxzZXRPcHRpb246ZnVuY3Rpb24oZSx0KXtpZih0aGlzWyIkIitlXT09PXQpcmV0dXJuO3ZhciBuPXRoaXMuJG9wdGlvbnNbZV07aWYoIW4pcmV0dXJuIG8oJ21pc3NwZWxsZWQgb3B0aW9uICInK2UrJyInKTtpZihuLmZvcndhcmRUbylyZXR1cm4gdGhpc1tuLmZvcndhcmRUb10mJnRoaXNbbi5mb3J3YXJkVG9dLnNldE9wdGlvbihlLHQpO24uaGFuZGxlc1NldHx8KHRoaXNbIiQiK2VdPXQpLG4mJm4uc2V0JiZuLnNldC5jYWxsKHRoaXMsdCl9LGdldE9wdGlvbjpmdW5jdGlvbihlKXt2YXIgdD10aGlzLiRvcHRpb25zW2VdO3JldHVybiB0P3QuZm9yd2FyZFRvP3RoaXNbdC5mb3J3YXJkVG9dJiZ0aGlzW3QuZm9yd2FyZFRvXS5nZXRPcHRpb24oZSk6dCYmdC5nZXQ/dC5nZXQuY2FsbCh0aGlzKTp0aGlzWyIkIitlXTpvKCdtaXNzcGVsbGVkIG9wdGlvbiAiJytlKyciJyl9fSxhPWZ1bmN0aW9uKCl7dGhpcy4kZGVmYXVsdE9wdGlvbnM9e319OyhmdW5jdGlvbigpe3IuaW1wbGVtZW50KHRoaXMsaSksdGhpcy5kZWZpbmVPcHRpb25zPWZ1bmN0aW9uKGUsdCxuKXtyZXR1cm4gZS4kb3B0aW9uc3x8KHRoaXMuJGRlZmF1bHRPcHRpb25zW3RdPWUuJG9wdGlvbnM9e30pLE9iamVjdC5rZXlzKG4pLmZvckVhY2goZnVuY3Rpb24odCl7dmFyIHI9blt0XTt0eXBlb2Ygcj09InN0cmluZyImJihyPXtmb3J3YXJkVG86cn0pLHIubmFtZXx8KHIubmFtZT10KSxlLiRvcHRpb25zW3IubmFtZV09ciwiaW5pdGlhbFZhbHVlImluIHImJihlWyIkIityLm5hbWVdPXIuaW5pdGlhbFZhbHVlKX0pLHIuaW1wbGVtZW50KGUscyksdGhpc30sdGhpcy5yZXNldE9wdGlvbnM9ZnVuY3Rpb24oZSl7T2JqZWN0LmtleXMoZS4kb3B0aW9ucykuZm9yRWFjaChmdW5jdGlvbih0KXt2YXIgbj1lLiRvcHRpb25zW3RdOyJ2YWx1ZSJpbiBuJiZlLnNldE9wdGlvbih0LG4udmFsdWUpfSl9LHRoaXMuc2V0RGVmYXVsdFZhbHVlPWZ1bmN0aW9uKGUsdCxuKXtpZighZSl7Zm9yKGUgaW4gdGhpcy4kZGVmYXVsdE9wdGlvbnMpaWYodGhpcy4kZGVmYXVsdE9wdGlvbnNbZV1bdF0pYnJlYWs7aWYoIXRoaXMuJGRlZmF1bHRPcHRpb25zW2VdW3RdKXJldHVybiExfXZhciByPXRoaXMuJGRlZmF1bHRPcHRpb25zW2VdfHwodGhpcy4kZGVmYXVsdE9wdGlvbnNbZV09e30pO3JbdF0mJihyLmZvcndhcmRUbz90aGlzLnNldERlZmF1bHRWYWx1ZShyLmZvcndhcmRUbyx0LG4pOnJbdF0udmFsdWU9bil9LHRoaXMuc2V0RGVmYXVsdFZhbHVlcz1mdW5jdGlvbihlLHQpe09iamVjdC5rZXlzKHQpLmZvckVhY2goZnVuY3Rpb24obil7dGhpcy5zZXREZWZhdWx0VmFsdWUoZSxuLHRbbl0pfSx0aGlzKX0sdGhpcy53YXJuPW8sdGhpcy5yZXBvcnRFcnJvcj11fSkuY2FsbChhLnByb3RvdHlwZSksdC5BcHBDb25maWc9YX0pLGRlZmluZSgiYWNlL3RoZW1lL3RleHRtYXRlLmNzcyIsWyJyZXF1aXJlIiwiZXhwb3J0cyIsIm1vZHVsZSJdLGZ1bmN0aW9uKGUsdCxuKXtuLmV4cG9ydHM9Jy5hY2UtdG0gLmFjZV9ndXR0ZXIge1xuICBiYWNrZ3JvdW5kOiAjZjBmMGYwO1xuICBjb2xvcjogIzMzMztcbn1cblxuLmFjZS10bSAuYWNlX3ByaW50LW1hcmdpbiB7XG4gIHdpZHRoOiAxcHg7XG4gIGJhY2tncm91bmQ6ICNlOGU4ZTg7XG59XG5cbi5hY2UtdG0gLmFjZV9mb2xkIHtcbiAgICBiYWNrZ3JvdW5kLWNvbG9yOiAjNkI3MkU2O1xufVxuXG4uYWNlLXRtIHtcbiAgYmFja2dyb3VuZC1jb2xvcjogI0ZGRkZGRjtcbiAgY29sb3I6IGJsYWNrO1xufVxuXG4uYWNlLXRtIC5hY2VfY3Vyc29yIHtcbiAgY29sb3I6IGJsYWNrO1xufVxuICAgICAgICBcbi5hY2UtdG0gLmFjZV9pbnZpc2libGUge1xuICBjb2xvcjogcmdiKDE5MSwgMTkxLCAxOTEpO1xufVxuXG4uYWNlLXRtIC5hY2Vfc3RvcmFnZSxcbi5hY2UtdG0gLmFjZV9rZXl3b3JkIHtcbiAgY29sb3I6IGJsdWU7XG59XG5cbi5hY2UtdG0gLmFjZV9jb25zdGFudCB7XG4gIGNvbG9yOiByZ2IoMTk3LCA2LCAxMSk7XG59XG5cbi5hY2UtdG0gLmFjZV9jb25zdGFudC5hY2VfYnVpbGRpbiB7XG4gIGNvbG9yOiByZ2IoODgsIDcyLCAyNDYpO1xufVxuXG4uYWNlLXRtIC5hY2VfY29uc3RhbnQuYWNlX2xhbmd1YWdlIHtcbiAgY29sb3I6IHJnYig4OCwgOTIsIDI0Nik7XG59XG5cbi5hY2UtdG0gLmFjZV9jb25zdGFudC5hY2VfbGlicmFyeSB7XG4gIGNvbG9yOiByZ2IoNiwgMTUwLCAxNCk7XG59XG5cbi5hY2UtdG0gLmFjZV9pbnZhbGlkIHtcbiAgYmFja2dyb3VuZC1jb2xvcjogcmdiYSgyNTUsIDAsIDAsIDAuMSk7XG4gIGNvbG9yOiByZWQ7XG59XG5cbi5hY2UtdG0gLmFjZV9zdXBwb3J0LmFjZV9mdW5jdGlvbiB7XG4gIGNvbG9yOiByZ2IoNjAsIDc2LCAxMTQpO1xufVxuXG4uYWNlLXRtIC5hY2Vfc3VwcG9ydC5hY2VfY29uc3RhbnQge1xuICBjb2xvcjogcmdiKDYsIDE1MCwgMTQpO1xufVxuXG4uYWNlLXRtIC5hY2Vfc3VwcG9ydC5hY2VfdHlwZSxcbi5hY2UtdG0gLmFjZV9zdXBwb3J0LmFjZV9jbGFzcyB7XG4gIGNvbG9yOiByZ2IoMTA5LCAxMjEsIDIyMik7XG59XG5cbi5hY2UtdG0gLmFjZV9rZXl3b3JkLmFjZV9vcGVyYXRvciB7XG4gIGNvbG9yOiByZ2IoMTA0LCAxMTgsIDEzNSk7XG59XG5cbi5hY2UtdG0gLmFjZV9zdHJpbmcge1xuICBjb2xvcjogcmdiKDMsIDEwNiwgNyk7XG59XG5cbi5hY2UtdG0gLmFjZV9jb21tZW50IHtcbiAgY29sb3I6IHJnYig3NiwgMTM2LCAxMDcpO1xufVxuXG4uYWNlLXRtIC5hY2VfY29tbWVudC5hY2VfZG9jIHtcbiAgY29sb3I6IHJnYigwLCAxMDIsIDI1NSk7XG59XG5cbi5hY2UtdG0gLmFjZV9jb21tZW50LmFjZV9kb2MuYWNlX3RhZyB7XG4gIGNvbG9yOiByZ2IoMTI4LCAxNTksIDE5MSk7XG59XG5cbi5hY2UtdG0gLmFjZV9jb25zdGFudC5hY2VfbnVtZXJpYyB7XG4gIGNvbG9yOiByZ2IoMCwgMCwgMjA1KTtcbn1cblxuLmFjZS10bSAuYWNlX3ZhcmlhYmxlIHtcbiAgY29sb3I6IHJnYig0OSwgMTMyLCAxNDkpO1xufVxuXG4uYWNlLXRtIC5hY2VfeG1sLXBlIHtcbiAgY29sb3I6IHJnYigxMDQsIDEwNCwgOTEpO1xufVxuXG4uYWNlLXRtIC5hY2VfZW50aXR5LmFjZV9uYW1lLmFjZV9mdW5jdGlvbiB7XG4gIGNvbG9yOiAjMDAwMEEyO1xufVxuXG5cbi5hY2UtdG0gLmFjZV9oZWFkaW5nIHtcbiAgY29sb3I6IHJnYigxMiwgNywgMjU1KTtcbn1cblxuLmFjZS10bSAuYWNlX2xpc3Qge1xuICBjb2xvcjpyZ2IoMTg1LCA2LCAxNDQpO1xufVxuXG4uYWNlLXRtIC5hY2VfbWV0YS5hY2VfdGFnIHtcbiAgY29sb3I6cmdiKDAsIDIyLCAxNDIpO1xufVxuXG4uYWNlLXRtIC5hY2Vfc3RyaW5nLmFjZV9yZWdleCB7XG4gIGNvbG9yOiByZ2IoMjU1LCAwLCAwKVxufVxuXG4uYWNlLXRtIC5hY2VfbWFya2VyLWxheWVyIC5hY2Vfc2VsZWN0aW9uIHtcbiAgYmFja2dyb3VuZDogcmdiKDE4MSwgMjEzLCAyNTUpO1xufVxuLmFjZS10bS5hY2VfbXVsdGlzZWxlY3QgLmFjZV9zZWxlY3Rpb24uYWNlX3N0YXJ0IHtcbiAgYm94LXNoYWRvdzogMCAwIDNweCAwcHggd2hpdGU7XG59XG4uYWNlLXRtIC5hY2VfbWFya2VyLWxheWVyIC5hY2Vfc3RlcCB7XG4gIGJhY2tncm91bmQ6IHJnYigyNTIsIDI1NSwgMCk7XG59XG5cbi5hY2UtdG0gLmFjZV9tYXJrZXItbGF5ZXIgLmFjZV9zdGFjayB7XG4gIGJhY2tncm91bmQ6IHJnYigxNjQsIDIyOSwgMTAxKTtcbn1cblxuLmFjZS10bSAuYWNlX21hcmtlci1sYXllciAuYWNlX2JyYWNrZXQge1xuICBtYXJnaW46IC0xcHggMCAwIC0xcHg7XG4gIGJvcmRlcjogMXB4IHNvbGlkIHJnYigxOTIsIDE5MiwgMTkyKTtcbn1cblxuLmFjZS10bSAuYWNlX21hcmtlci1sYXllciAuYWNlX2FjdGl2ZS1saW5lIHtcbiAgYmFja2dyb3VuZDogcmdiYSgwLCAwLCAwLCAwLjA3KTtcbn1cblxuLmFjZS10bSAuYWNlX2d1dHRlci1hY3RpdmUtbGluZSB7XG4gICAgYmFja2dyb3VuZC1jb2xvciA6ICNkY2RjZGM7XG59XG5cbi5hY2UtdG0gLmFjZV9tYXJrZXItbGF5ZXIgLmFjZV9zZWxlY3RlZC13b3JkIHtcbiAgYmFja2dyb3VuZDogcmdiKDI1MCwgMjUwLCAyNTUpO1xuICBib3JkZXI6IDFweCBzb2xpZCByZ2IoMjAwLCAyMDAsIDI1MCk7XG59XG5cbi5hY2UtdG0gLmFjZV9pbmRlbnQtZ3VpZGUge1xuICBiYWNrZ3JvdW5kOiB1cmwoImRhdGE6aW1hZ2UvcG5nO2Jhc2U2NCxpVkJPUncwS0dnb0FBQUFOU1VoRVVnQUFBQUVBQUFBQ0NBWUFBQUNaZ2JZbkFBQUFFMGxFUVZRSW1XUDQvLy8vZjRiTGx5Ly9Cd0FtVmdkMS93MTEvZ0FBQUFCSlJVNUVya0pnZ2c9PSIpIHJpZ2h0IHJlcGVhdC15O1xufVxuXG4uYWNlLXRtIC5hY2VfaW5kZW50LWd1aWRlLWFjdGl2ZSB7XG4gIGJhY2tncm91bmQ6IHVybCgiZGF0YTppbWFnZS9wbmc7YmFzZTY0LGlWQk9SdzBLR2dvQUFBQU5TVWhFVWdBQUFBRUFBQUFDQ0FZQUFBQ1pnYlluQUFBQUNYQklXWE1BQUFzVEFBQUxFd0VBbXB3WUFBQUFJR05JVWswQUFIb2xBQUNBZ3dBQStmOEFBSURwQUFCMU1BQUE2bUFBQURxWUFBQVhiNUpmeFVZQUFBQVpTVVJCVkhqYVl2ai8vLzkvaGl2S3l2OEJBQUFBLy84REFDTHFCaGJ2aysvZUFBQUFBRWxGVGtTdVFtQ0MiKSByaWdodCByZXBlYXQteTtcbn1cbid9KSxkZWZpbmUoImFjZS90aGVtZS90ZXh0bWF0ZSIsWyJyZXF1aXJlIiwiZXhwb3J0cyIsIm1vZHVsZSIsImFjZS90aGVtZS90ZXh0bWF0ZS5jc3MiLCJhY2UvbGliL2RvbSJdLGZ1bmN0aW9uKGUsdCxuKXsidXNlIHN0cmljdCI7dC5pc0Rhcms9ITEsdC5jc3NDbGFzcz0iYWNlLXRtIix0LmNzc1RleHQ9ZSgiLi90ZXh0bWF0ZS5jc3MiKSx0LiRpZD0iYWNlL3RoZW1lL3RleHRtYXRlIjt2YXIgcj1lKCIuLi9saWIvZG9tIik7ci5pbXBvcnRDc3NTdHJpbmcodC5jc3NUZXh0LHQuY3NzQ2xhc3MsITEpfSksZGVmaW5lKCJhY2UvY29uZmlnIixbInJlcXVpcmUiLCJleHBvcnRzIiwibW9kdWxlIiwiYWNlL2xpYi9sYW5nIiwiYWNlL2xpYi9vb3AiLCJhY2UvbGliL25ldCIsImFjZS9saWIvZG9tIiwiYWNlL2xpYi9hcHBfY29uZmlnIiwiYWNlL3RoZW1lL3RleHRtYXRlIl0sZnVuY3Rpb24oZSx0LG4peyJubyB1c2Ugc3RyaWN0Ijt2YXIgcj1lKCIuL2xpYi9sYW5nIiksaT1lKCIuL2xpYi9vb3AiKSxzPWUoIi4vbGliL25ldCIpLG89ZSgiLi9saWIvZG9tIiksdT1lKCIuL2xpYi9hcHBfY29uZmlnIikuQXBwQ29uZmlnO24uZXhwb3J0cz10PW5ldyB1O3ZhciBhPXtwYWNrYWdlZDohMSx3b3JrZXJQYXRoOm51bGwsbW9kZVBhdGg6bnVsbCx0aGVtZVBhdGg6bnVsbCxiYXNlUGF0aDoiIixzdWZmaXg6Ii5qcyIsJG1vZHVsZVVybHM6e30sbG9hZFdvcmtlckZyb21CbG9iOiEwLHNoYXJlZFBvcHVwczohMSx1c2VTdHJpY3RDU1A6bnVsbH07dC5nZXQ9ZnVuY3Rpb24oZSl7aWYoIWEuaGFzT3duUHJvcGVydHkoZSkpdGhyb3cgbmV3IEVycm9yKCJVbmtub3duIGNvbmZpZyBrZXk6ICIrZSk7cmV0dXJuIGFbZV19LHQuc2V0PWZ1bmN0aW9uKGUsdCl7aWYoYS5oYXNPd25Qcm9wZXJ0eShlKSlhW2VdPXQ7ZWxzZSBpZih0aGlzLnNldERlZmF1bHRWYWx1ZSgiIixlLHQpPT0wKXRocm93IG5ldyBFcnJvcigiVW5rbm93biBjb25maWcga2V5OiAiK2UpO2U9PSJ1c2VTdHJpY3RDU1AiJiZvLnVzZVN0cmljdENTUCh0KX0sdC5hbGw9ZnVuY3Rpb24oKXtyZXR1cm4gci5jb3B5T2JqZWN0KGEpfSx0LiRtb2Rlcz17fSx0Lm1vZHVsZVVybD1mdW5jdGlvbihlLHQpe2lmKGEuJG1vZHVsZVVybHNbZV0pcmV0dXJuIGEuJG1vZHVsZVVybHNbZV07dmFyIG49ZS5zcGxpdCgiLyIpO3Q9dHx8bltuLmxlbmd0aC0yXXx8IiI7dmFyIHI9dD09InNuaXBwZXRzIj8iLyI6Ii0iLGk9bltuLmxlbmd0aC0xXTtpZih0PT0id29ya2VyIiYmcj09Ii0iKXt2YXIgcz1uZXcgUmVnRXhwKCJeIit0KyJbXFwtX118W1xcLV9dIit0KyIkIiwiZyIpO2k9aS5yZXBsYWNlKHMsIiIpfSghaXx8aT09dCkmJm4ubGVuZ3RoPjEmJihpPW5bbi5sZW5ndGgtMl0pO3ZhciBvPWFbdCsiUGF0aCJdO3JldHVybiBvPT1udWxsP289YS5iYXNlUGF0aDpyPT0iLyImJih0PXI9IiIpLG8mJm8uc2xpY2UoLTEpIT0iLyImJihvKz0iLyIpLG8rdCtyK2krdGhpcy5nZXQoInN1ZmZpeCIpfSx0LnNldE1vZHVsZVVybD1mdW5jdGlvbihlLHQpe3JldHVybiBhLiRtb2R1bGVVcmxzW2VdPXR9O3ZhciBmPWZ1bmN0aW9uKHQsbil7cmV0dXJuIHQ9PSJhY2UvdGhlbWUvdGV4dG1hdGUiP24obnVsbCxlKCIuL3RoZW1lL3RleHRtYXRlIikpOmNvbnNvbGUuZXJyb3IoImxvYWRlciBpcyBub3QgY29uZmlndXJlZCIpfTt0LnNldExvYWRlcj1mdW5jdGlvbihlKXtmPWV9LHQuJGxvYWRpbmc9e30sdC5sb2FkTW9kdWxlPWZ1bmN0aW9uKG4scil7dmFyIGksbztBcnJheS5pc0FycmF5KG4pJiYobz1uWzBdLG49blsxXSk7dHJ5e2k9ZShuKX1jYXRjaCh1KXt9aWYoaSYmIXQuJGxvYWRpbmdbbl0pcmV0dXJuIHImJnIoaSk7dC4kbG9hZGluZ1tuXXx8KHQuJGxvYWRpbmdbbl09W10pLHQuJGxvYWRpbmdbbl0ucHVzaChyKTtpZih0LiRsb2FkaW5nW25dLmxlbmd0aD4xKXJldHVybjt2YXIgYT1mdW5jdGlvbigpe2YobixmdW5jdGlvbihlLHIpe3QuX2VtaXQoImxvYWQubW9kdWxlIix7bmFtZTpuLG1vZHVsZTpyfSk7dmFyIGk9dC4kbG9hZGluZ1tuXTt0LiRsb2FkaW5nW25dPW51bGwsaS5mb3JFYWNoKGZ1bmN0aW9uKGUpe2UmJmUocil9KX0pfTtpZighdC5nZXQoInBhY2thZ2VkIikpcmV0dXJuIGEoKTtzLmxvYWRTY3JpcHQodC5tb2R1bGVVcmwobixvKSxhKSxsKCl9O3ZhciBsPWZ1bmN0aW9uKCl7IWEuYmFzZVBhdGgmJiFhLndvcmtlclBhdGgmJiFhLm1vZGVQYXRoJiYhYS50aGVtZVBhdGgmJiFPYmplY3Qua2V5cyhhLiRtb2R1bGVVcmxzKS5sZW5ndGgmJihjb25zb2xlLmVycm9yKCJVbmFibGUgdG8gaW5mZXIgcGF0aCB0byBhY2UgZnJvbSBzY3JpcHQgc3JjLCIsInVzZSBhY2UuY29uZmlnLnNldCgnYmFzZVBhdGgnLCAncGF0aCcpIHRvIGVuYWJsZSBkeW5hbWljIGxvYWRpbmcgb2YgbW9kZXMgYW5kIHRoZW1lcyIsIm9yIHdpdGggd2VicGFjayB1c2UgYWNlL3dlYnBhY2stcmVzb2x2ZXIiKSxsPWZ1bmN0aW9uKCl7fSl9O3QudmVyc2lvbj0iMS4xMy4xIn0pLGRlZmluZSgiYWNlL2xvYWRlcl9idWlsZCIsWyJyZXF1aXJlIiwiZXhwb3J0cyIsIm1vZHVsZSIsImFjZS9saWIvZml4b2xkYnJvd3NlcnMiLCJhY2UvY29uZmlnIl0sZnVuY3Rpb24oZSx0LG4peyJ1c2Ugc3RyaWN0IjtmdW5jdGlvbiBzKHQpe2lmKCFpfHwhaS5kb2N1bWVudClyZXR1cm47ci5zZXQoInBhY2thZ2VkIix0fHxlLnBhY2thZ2VkfHxuLnBhY2thZ2VkfHxpLmRlZmluZSYmZGVmaW5lLnBhY2thZ2VkKTt2YXIgcz17fSx1PSIiLGE9ZG9jdW1lbnQuY3VycmVudFNjcmlwdHx8ZG9jdW1lbnQuX2N1cnJlbnRTY3JpcHQsZj1hJiZhLm93bmVyRG9jdW1lbnR8fGRvY3VtZW50LGw9Zi5nZXRFbGVtZW50c0J5VGFnTmFtZSgic2NyaXB0Iik7Zm9yKHZhciBjPTA7YzxsLmxlbmd0aDtjKyspe3ZhciBoPWxbY10scD1oLnNyY3x8aC5nZXRBdHRyaWJ1dGUoInNyYyIpO2lmKCFwKWNvbnRpbnVlO3ZhciBkPWguYXR0cmlidXRlcztmb3IodmFyIHY9MCxtPWQubGVuZ3RoO3Y8bTt2Kyspe3ZhciBnPWRbdl07Zy5uYW1lLmluZGV4T2YoImRhdGEtYWNlLSIpPT09MCYmKHNbbyhnLm5hbWUucmVwbGFjZSgvXmRhdGEtYWNlLS8sIiIpKV09Zy52YWx1ZSl9dmFyIHk9cC5tYXRjaCgvXiguKilcL2FjZShcLVx3Kyk/XC5qcyhcP3wkKS8pO3kmJih1PXlbMV0pfXUmJihzLmJhc2U9cy5iYXNlfHx1LHMucGFja2FnZWQ9ITApLHMuYmFzZVBhdGg9cy5iYXNlLHMud29ya2VyUGF0aD1zLndvcmtlclBhdGh8fHMuYmFzZSxzLm1vZGVQYXRoPXMubW9kZVBhdGh8fHMuYmFzZSxzLnRoZW1lUGF0aD1zLnRoZW1lUGF0aHx8cy5iYXNlLGRlbGV0ZSBzLmJhc2U7Zm9yKHZhciBiIGluIHMpdHlwZW9mIHNbYl0hPSJ1bmRlZmluZWQiJiZyLnNldChiLHNbYl0pfWZ1bmN0aW9uIG8oZSl7cmV0dXJuIGUucmVwbGFjZSgvLSguKS9nLGZ1bmN0aW9uKGUsdCl7cmV0dXJuIHQudG9VcHBlckNhc2UoKX0pfWUoIi4vbGliL2ZpeG9sZGJyb3dzZXJzIik7dmFyIHI9ZSgiLi9jb25maWciKTtyLnNldExvYWRlcihmdW5jdGlvbih0LG4pe2UoW3RdLGZ1bmN0aW9uKGUpe24obnVsbCxlKX0pfSk7dmFyIGk9ZnVuY3Rpb24oKXtyZXR1cm4gdGhpc3x8dHlwZW9mIHdpbmRvdyE9InVuZGVmaW5lZCImJndpbmRvd30oKTtuLmV4cG9ydHM9ZnVuY3Rpb24odCl7ci5pbml0PXMsdC5yZXF1aXJlPWUsdHlwZW9mIGRlZmluZT09ImZ1bmN0aW9uIiYmKHQuZGVmaW5lPWRlZmluZSl9fSksZGVmaW5lKCJhY2UvbGliL2tleXMiLFsicmVxdWlyZSIsImV4cG9ydHMiLCJtb2R1bGUiLCJhY2UvbGliL29vcCJdLGZ1bmN0aW9uKGUsdCxuKXsidXNlIHN0cmljdCI7dmFyIHI9ZSgiLi9vb3AiKSxpPWZ1bmN0aW9uKCl7dmFyIGU9e01PRElGSUVSX0tFWVM6ezE2OiJTaGlmdCIsMTc6IkN0cmwiLDE4OiJBbHQiLDIyNDoiTWV0YSIsOTE6Ik1ldGFMZWZ0Iiw5MjoiTWV0YVJpZ2h0Iiw5MzoiQ29udGV4dE1lbnUifSxLRVlfTU9EUzp7Y3RybDoxLGFsdDoyLG9wdGlvbjoyLHNoaWZ0OjQsInN1cGVyIjo4LG1ldGE6OCxjb21tYW5kOjgsY21kOjgsY29udHJvbDoxfSxGVU5DVElPTl9LRVlTOns4OiJCYWNrc3BhY2UiLDk6IlRhYiIsMTM6IlJldHVybiIsMTk6IlBhdXNlIiwyNzoiRXNjIiwzMjoiU3BhY2UiLDMzOiJQYWdlVXAiLDM0OiJQYWdlRG93biIsMzU6IkVuZCIsMzY6IkhvbWUiLDM3OiJMZWZ0IiwzODoiVXAiLDM5OiJSaWdodCIsNDA6IkRvd24iLDQ0OiJQcmludCIsNDU6Ikluc2VydCIsNDY6IkRlbGV0ZSIsOTY6Ik51bXBhZDAiLDk3OiJOdW1wYWQxIiw5ODoiTnVtcGFkMiIsOTk6Ik51bXBhZDMiLDEwMDoiTnVtcGFkNCIsMTAxOiJOdW1wYWQ1IiwxMDI6Ik51bXBhZDYiLDEwMzoiTnVtcGFkNyIsMTA0OiJOdW1wYWQ4IiwxMDU6Ik51bXBhZDkiLCItMTMiOiJOdW1wYWRFbnRlciIsMTEyOiJGMSIsMTEzOiJGMiIsMTE0OiJGMyIsMTE1OiJGNCIsMTE2OiJGNSIsMTE3OiJGNiIsMTE4OiJGNyIsMTE5OiJGOCIsMTIwOiJGOSIsMTIxOiJGMTAiLDEyMjoiRjExIiwxMjM6IkYxMiIsMTQ0OiJOdW1sb2NrIiwxNDU6IlNjcm9sbGxvY2sifSxQUklOVEFCTEVfS0VZUzp7MzI6IiAiLDQ4OiIwIiw0OToiMSIsNTA6IjIiLDUxOiIzIiw1MjoiNCIsNTM6IjUiLDU0OiI2Iiw1NToiNyIsNTY6IjgiLDU3OiI5Iiw1OToiOyIsNjE6Ij0iLDY1OiJhIiw2NjoiYiIsNjc6ImMiLDY4OiJkIiw2OToiZSIsNzA6ImYiLDcxOiJnIiw3MjoiaCIsNzM6ImkiLDc0OiJqIiw3NToiayIsNzY6ImwiLDc3OiJtIiw3ODoibiIsNzk6Im8iLDgwOiJwIiw4MToicSIsODI6InIiLDgzOiJzIiw4NDoidCIsODU6InUiLDg2OiJ2Iiw4NzoidyIsODg6IngiLDg5OiJ5Iiw5MDoieiIsMTA3OiIrIiwxMDk6Ii0iLDExMDoiLiIsMTg2OiI7IiwxODc6Ij0iLDE4ODoiLCIsMTg5OiItIiwxOTA6Ii4iLDE5MToiLyIsMTkyOiJgIiwyMTk6IlsiLDIyMDoiXFwiLDIyMToiXSIsMjIyOiInIiwxMTE6Ii8iLDEwNjoiKiJ9fTtlLlBSSU5UQUJMRV9LRVlTWzE3M109Ii0iO3ZhciB0LG47Zm9yKG4gaW4gZS5GVU5DVElPTl9LRVlTKXQ9ZS5GVU5DVElPTl9LRVlTW25dLnRvTG93ZXJDYXNlKCksZVt0XT1wYXJzZUludChuLDEwKTtmb3IobiBpbiBlLlBSSU5UQUJMRV9LRVlTKXQ9ZS5QUklOVEFCTEVfS0VZU1tuXS50b0xvd2VyQ2FzZSgpLGVbdF09cGFyc2VJbnQobiwxMCk7cmV0dXJuIHIubWl4aW4oZSxlLk1PRElGSUVSX0tFWVMpLHIubWl4aW4oZSxlLlBSSU5UQUJMRV9LRVlTKSxyLm1peGluKGUsZS5GVU5DVElPTl9LRVlTKSxlLmVudGVyPWVbInJldHVybiJdLGUuZXNjYXBlPWUuZXNjLGUuZGVsPWVbImRlbGV0ZSJdLGZ1bmN0aW9uKCl7dmFyIHQ9WyJjbWQiLCJjdHJsIiwiYWx0Iiwic2hpZnQiXTtmb3IodmFyIG49TWF0aC5wb3coMix0Lmxlbmd0aCk7bi0tOyllLktFWV9NT0RTW25dPXQuZmlsdGVyKGZ1bmN0aW9uKHQpe3JldHVybiBuJmUuS0VZX01PRFNbdF19KS5qb2luKCItIikrIi0ifSgpLGUuS0VZX01PRFNbMF09IiIsZS5LRVlfTU9EU1stMV09ImlucHV0LSIsZX0oKTtyLm1peGluKHQsaSksdC5rZXlDb2RlVG9TdHJpbmc9ZnVuY3Rpb24oZSl7dmFyIHQ9aVtlXTtyZXR1cm4gdHlwZW9mIHQhPSJzdHJpbmciJiYodD1TdHJpbmcuZnJvbUNoYXJDb2RlKGUpKSx0LnRvTG93ZXJDYXNlKCl9fSksZGVmaW5lKCJhY2UvbGliL2V2ZW50IixbInJlcXVpcmUiLCJleHBvcnRzIiwibW9kdWxlIiwiYWNlL2xpYi9rZXlzIiwiYWNlL2xpYi91c2VyYWdlbnQiXSxmdW5jdGlvbihlLHQsbil7InVzZSBzdHJpY3QiO2Z1bmN0aW9uIGEoKXt1PSExO3RyeXtkb2N1bWVudC5jcmVhdGVDb21tZW50KCIiKS5hZGRFdmVudExpc3RlbmVyKCJ0ZXN0IixmdW5jdGlvbigpe30se2dldCBwYXNzaXZlKCl7dT17cGFzc2l2ZTohMX19fSl9Y2F0Y2goZSl7fX1mdW5jdGlvbiBmKCl7cmV0dXJuIHU9PXVuZGVmaW5lZCYmYSgpLHV9ZnVuY3Rpb24gbChlLHQsbil7dGhpcy5lbGVtPWUsdGhpcy50eXBlPXQsdGhpcy5jYWxsYmFjaz1ufWZ1bmN0aW9uIGQoZSx0LG4pe3ZhciB1PXAodCk7aWYoIWkuaXNNYWMmJnMpe3QuZ2V0TW9kaWZpZXJTdGF0ZSYmKHQuZ2V0TW9kaWZpZXJTdGF0ZSgiT1MiKXx8dC5nZXRNb2RpZmllclN0YXRlKCJXaW4iKSkmJih1fD04KTtpZihzLmFsdEdyKXtpZigoMyZ1KT09MylyZXR1cm47cy5hbHRHcj0wfWlmKG49PT0xOHx8bj09PTE3KXt2YXIgYT0ibG9jYXRpb24iaW4gdD90LmxvY2F0aW9uOnQua2V5TG9jYXRpb247aWYobj09PTE3JiZhPT09MSlzW25dPT0xJiYobz10LnRpbWVTdGFtcCk7ZWxzZSBpZihuPT09MTgmJnU9PT0zJiZhPT09Mil7dmFyIGY9dC50aW1lU3RhbXAtbztmPDUwJiYocy5hbHRHcj0hMCl9fX1uIGluIHIuTU9ESUZJRVJfS0VZUyYmKG49LTEpO2lmKCF1JiZuPT09MTMpe3ZhciBhPSJsb2NhdGlvbiJpbiB0P3QubG9jYXRpb246dC5rZXlMb2NhdGlvbjtpZihhPT09Myl7ZSh0LHUsLW4pO2lmKHQuZGVmYXVsdFByZXZlbnRlZClyZXR1cm59fWlmKGkuaXNDaHJvbWVPUyYmdSY4KXtlKHQsdSxuKTtpZih0LmRlZmF1bHRQcmV2ZW50ZWQpcmV0dXJuO3UmPS05fXJldHVybiEhdXx8biBpbiByLkZVTkNUSU9OX0tFWVN8fG4gaW4gci5QUklOVEFCTEVfS0VZUz9lKHQsdSxuKTohMX1mdW5jdGlvbiB2KCl7cz1PYmplY3QuY3JlYXRlKG51bGwpfXZhciByPWUoIi4va2V5cyIpLGk9ZSgiLi91c2VyYWdlbnQiKSxzPW51bGwsbz0wLHU7bC5wcm90b3R5cGUuZGVzdHJveT1mdW5jdGlvbigpe2godGhpcy5lbGVtLHRoaXMudHlwZSx0aGlzLmNhbGxiYWNrKSx0aGlzLmVsZW09dGhpcy50eXBlPXRoaXMuY2FsbGJhY2s9dW5kZWZpbmVkfTt2YXIgYz10LmFkZExpc3RlbmVyPWZ1bmN0aW9uKGUsdCxuLHIpe2UuYWRkRXZlbnRMaXN0ZW5lcih0LG4sZigpKSxyJiZyLiR0b0Rlc3Ryb3kucHVzaChuZXcgbChlLHQsbikpfSxoPXQucmVtb3ZlTGlzdGVuZXI9ZnVuY3Rpb24oZSx0LG4pe2UucmVtb3ZlRXZlbnRMaXN0ZW5lcih0LG4sZigpKX07dC5zdG9wRXZlbnQ9ZnVuY3Rpb24oZSl7cmV0dXJuIHQuc3RvcFByb3BhZ2F0aW9uKGUpLHQucHJldmVudERlZmF1bHQoZSksITF9LHQuc3RvcFByb3BhZ2F0aW9uPWZ1bmN0aW9uKGUpe2Uuc3RvcFByb3BhZ2F0aW9uJiZlLnN0b3BQcm9wYWdhdGlvbigpfSx0LnByZXZlbnREZWZhdWx0PWZ1bmN0aW9uKGUpe2UucHJldmVudERlZmF1bHQmJmUucHJldmVudERlZmF1bHQoKX0sdC5nZXRCdXR0b249ZnVuY3Rpb24oZSl7cmV0dXJuIGUudHlwZT09ImRibGNsaWNrIj8wOmUudHlwZT09ImNvbnRleHRtZW51Inx8aS5pc01hYyYmZS5jdHJsS2V5JiYhZS5hbHRLZXkmJiFlLnNoaWZ0S2V5PzI6ZS5idXR0b259LHQuY2FwdHVyZT1mdW5jdGlvbihlLHQsbil7ZnVuY3Rpb24gaShlKXt0JiZ0KGUpLG4mJm4oZSksaChyLCJtb3VzZW1vdmUiLHQpLGgociwibW91c2V1cCIsaSksaChyLCJkcmFnc3RhcnQiLGkpfXZhciByPWUmJmUub3duZXJEb2N1bWVudHx8ZG9jdW1lbnQ7cmV0dXJuIGMociwibW91c2Vtb3ZlIix0KSxjKHIsIm1vdXNldXAiLGkpLGMociwiZHJhZ3N0YXJ0IixpKSxpfSx0LmFkZE1vdXNlV2hlZWxMaXN0ZW5lcj1mdW5jdGlvbihlLHQsbil7YyhlLCJ3aGVlbCIsZnVuY3Rpb24oZSl7dmFyIG49LjE1LHI9ZS5kZWx0YVh8fDAsaT1lLmRlbHRhWXx8MDtzd2l0Y2goZS5kZWx0YU1vZGUpe2Nhc2UgZS5ET01fREVMVEFfUElYRUw6ZS53aGVlbFg9cipuLGUud2hlZWxZPWkqbjticmVhaztjYXNlIGUuRE9NX0RFTFRBX0xJTkU6dmFyIHM9MTU7ZS53aGVlbFg9cipzLGUud2hlZWxZPWkqczticmVhaztjYXNlIGUuRE9NX0RFTFRBX1BBR0U6dmFyIG89MTUwO2Uud2hlZWxYPXIqbyxlLndoZWVsWT1pKm99dChlKX0sbil9LHQuYWRkTXVsdGlNb3VzZURvd25MaXN0ZW5lcj1mdW5jdGlvbihlLG4scixzLG8pe2Z1bmN0aW9uIHAoZSl7dC5nZXRCdXR0b24oZSkhPT0wP3U9MDplLmRldGFpbD4xPyh1KyssdT40JiYodT0xKSk6dT0xO2lmKGkuaXNJRSl7dmFyIG89TWF0aC5hYnMoZS5jbGllbnRYLWEpPjV8fE1hdGguYWJzKGUuY2xpZW50WS1mKT41O2lmKCFsfHxvKXU9MTtsJiZjbGVhclRpbWVvdXQobCksbD1zZXRUaW1lb3V0KGZ1bmN0aW9uKCl7bD1udWxsfSxuW3UtMV18fDYwMCksdT09MSYmKGE9ZS5jbGllbnRYLGY9ZS5jbGllbnRZKX1lLl9jbGlja3M9dSxyW3NdKCJtb3VzZWRvd24iLGUpO2lmKHU+NCl1PTA7ZWxzZSBpZih1PjEpcmV0dXJuIHJbc10oaFt1XSxlKX12YXIgdT0wLGEsZixsLGg9ezI6ImRibGNsaWNrIiwzOiJ0cmlwbGVjbGljayIsNDoicXVhZGNsaWNrIn07QXJyYXkuaXNBcnJheShlKXx8KGU9W2VdKSxlLmZvckVhY2goZnVuY3Rpb24oZSl7YyhlLCJtb3VzZWRvd24iLHAsbyl9KX07dmFyIHA9ZnVuY3Rpb24oZSl7cmV0dXJuIDB8KGUuY3RybEtleT8xOjApfChlLmFsdEtleT8yOjApfChlLnNoaWZ0S2V5PzQ6MCl8KGUubWV0YUtleT84OjApfTt0LmdldE1vZGlmaWVyU3RyaW5nPWZ1bmN0aW9uKGUpe3JldHVybiByLktFWV9NT0RTW3AoZSldfSx0LmFkZENvbW1hbmRLZXlMaXN0ZW5lcj1mdW5jdGlvbihlLG4scil7aWYoaS5pc09sZEdlY2tvfHxpLmlzT3BlcmEmJiEoIktleWJvYXJkRXZlbnQiaW4gd2luZG93KSl7dmFyIG89bnVsbDtjKGUsImtleWRvd24iLGZ1bmN0aW9uKGUpe289ZS5rZXlDb2RlfSxyKSxjKGUsImtleXByZXNzIixmdW5jdGlvbihlKXtyZXR1cm4gZChuLGUsbyl9LHIpfWVsc2V7dmFyIHU9bnVsbDtjKGUsImtleWRvd24iLGZ1bmN0aW9uKGUpe3NbZS5rZXlDb2RlXT0oc1tlLmtleUNvZGVdfHwwKSsxO3ZhciB0PWQobixlLGUua2V5Q29kZSk7cmV0dXJuIHU9ZS5kZWZhdWx0UHJldmVudGVkLHR9LHIpLGMoZSwia2V5cHJlc3MiLGZ1bmN0aW9uKGUpe3UmJihlLmN0cmxLZXl8fGUuYWx0S2V5fHxlLnNoaWZ0S2V5fHxlLm1ldGFLZXkpJiYodC5zdG9wRXZlbnQoZSksdT1udWxsKX0sciksYyhlLCJrZXl1cCIsZnVuY3Rpb24oZSl7c1tlLmtleUNvZGVdPW51bGx9LHIpLHN8fCh2KCksYyh3aW5kb3csImZvY3VzIix2KSl9fTtpZih0eXBlb2Ygd2luZG93PT0ib2JqZWN0IiYmd2luZG93LnBvc3RNZXNzYWdlJiYhaS5pc09sZElFKXt2YXIgbT0xO3QubmV4dFRpY2s9ZnVuY3Rpb24oZSxuKXtuPW58fHdpbmRvdzt2YXIgcj0iemVyby10aW1lb3V0LW1lc3NhZ2UtIittKyssaT1mdW5jdGlvbihzKXtzLmRhdGE9PXImJih0LnN0b3BQcm9wYWdhdGlvbihzKSxoKG4sIm1lc3NhZ2UiLGkpLGUoKSl9O2MobiwibWVzc2FnZSIsaSksbi5wb3N0TWVzc2FnZShyLCIqIil9fXQuJGlkbGVCbG9ja2VkPSExLHQub25JZGxlPWZ1bmN0aW9uKGUsbil7cmV0dXJuIHNldFRpbWVvdXQoZnVuY3Rpb24gcigpe3QuJGlkbGVCbG9ja2VkP3NldFRpbWVvdXQociwxMDApOmUoKX0sbil9LHQuJGlkbGVCbG9ja0lkPW51bGwsdC5ibG9ja0lkbGU9ZnVuY3Rpb24oZSl7dC4kaWRsZUJsb2NrSWQmJmNsZWFyVGltZW91dCh0LiRpZGxlQmxvY2tJZCksdC4kaWRsZUJsb2NrZWQ9ITAsdC4kaWRsZUJsb2NrSWQ9c2V0VGltZW91dChmdW5jdGlvbigpe3QuJGlkbGVCbG9ja2VkPSExfSxlfHwxMDApfSx0Lm5leHRGcmFtZT10eXBlb2Ygd2luZG93PT0ib2JqZWN0IiYmKHdpbmRvdy5yZXF1ZXN0QW5pbWF0aW9uRnJhbWV8fHdpbmRvdy5tb3pSZXF1ZXN0QW5pbWF0aW9uRnJhbWV8fHdpbmRvdy53ZWJraXRSZXF1ZXN0QW5pbWF0aW9uRnJhbWV8fHdpbmRvdy5tc1JlcXVlc3RBbmltYXRpb25GcmFtZXx8d2luZG93Lm9SZXF1ZXN0QW5pbWF0aW9uRnJhbWUpLHQubmV4dEZyYW1lP3QubmV4dEZyYW1lPXQubmV4dEZyYW1lLmJpbmQod2luZG93KTp0Lm5leHRGcmFtZT1mdW5jdGlvbihlKXtzZXRUaW1lb3V0KGUsMTcpfX0pLGRlZmluZSgiYWNlL3JhbmdlIixbInJlcXVpcmUiLCJleHBvcnRzIiwibW9kdWxlIl0sZnVuY3Rpb24oZSx0LG4peyJ1c2Ugc3RyaWN0Ijt2YXIgcj1mdW5jdGlvbihlLHQpe3JldHVybiBlLnJvdy10LnJvd3x8ZS5jb2x1bW4tdC5jb2x1bW59LGk9ZnVuY3Rpb24oZSx0LG4scil7dGhpcy5zdGFydD17cm93OmUsY29sdW1uOnR9LHRoaXMuZW5kPXtyb3c6bixjb2x1bW46cn19OyhmdW5jdGlvbigpe3RoaXMuaXNFcXVhbD1mdW5jdGlvbihlKXtyZXR1cm4gdGhpcy5zdGFydC5yb3c9PT1lLnN0YXJ0LnJvdyYmdGhpcy5lbmQucm93PT09ZS5lbmQucm93JiZ0aGlzLnN0YXJ0LmNvbHVtbj09PWUuc3RhcnQuY29sdW1uJiZ0aGlzLmVuZC5jb2x1bW49PT1lLmVuZC5jb2x1bW59LHRoaXMudG9TdHJpbmc9ZnVuY3Rpb24oKXtyZXR1cm4iUmFuZ2U6IFsiK3RoaXMuc3RhcnQucm93KyIvIit0aGlzLnN0YXJ0LmNvbHVtbisiXSAtPiBbIit0aGlzLmVuZC5yb3crIi8iK3RoaXMuZW5kLmNvbHVtbisiXSJ9LHRoaXMuY29udGFpbnM9ZnVuY3Rpb24oZSx0KXtyZXR1cm4gdGhpcy5jb21wYXJlKGUsdCk9PTB9LHRoaXMuY29tcGFyZVJhbmdlPWZ1bmN0aW9uKGUpe3ZhciB0LG49ZS5lbmQscj1lLnN0YXJ0O3JldHVybiB0PXRoaXMuY29tcGFyZShuLnJvdyxuLmNvbHVtbiksdD09MT8odD10aGlzLmNvbXBhcmUoci5yb3csci5jb2x1bW4pLHQ9PTE/Mjp0PT0wPzE6MCk6dD09LTE/LTI6KHQ9dGhpcy5jb21wYXJlKHIucm93LHIuY29sdW1uKSx0PT0tMT8tMTp0PT0xPzQyOjApfSx0aGlzLmNvbXBhcmVQb2ludD1mdW5jdGlvbihlKXtyZXR1cm4gdGhpcy5jb21wYXJlKGUucm93LGUuY29sdW1uKX0sdGhpcy5jb250YWluc1JhbmdlPWZ1bmN0aW9uKGUpe3JldHVybiB0aGlzLmNvbXBhcmVQb2ludChlLnN0YXJ0KT09MCYmdGhpcy5jb21wYXJlUG9pbnQoZS5lbmQpPT0wfSx0aGlzLmludGVyc2VjdHM9ZnVuY3Rpb24oZSl7dmFyIHQ9dGhpcy5jb21wYXJlUmFuZ2UoZSk7cmV0dXJuIHQ9PS0xfHx0PT0wfHx0PT0xfSx0aGlzLmlzRW5kPWZ1bmN0aW9uKGUsdCl7cmV0dXJuIHRoaXMuZW5kLnJvdz09ZSYmdGhpcy5lbmQuY29sdW1uPT10fSx0aGlzLmlzU3RhcnQ9ZnVuY3Rpb24oZSx0KXtyZXR1cm4gdGhpcy5zdGFydC5yb3c9PWUmJnRoaXMuc3RhcnQuY29sdW1uPT10fSx0aGlzLnNldFN0YXJ0PWZ1bmN0aW9uKGUsdCl7dHlwZW9mIGU9PSJvYmplY3QiPyh0aGlzLnN0YXJ0LmNvbHVtbj1lLmNvbHVtbix0aGlzLnN0YXJ0LnJvdz1lLnJvdyk6KHRoaXMuc3RhcnQucm93PWUsdGhpcy5zdGFydC5jb2x1bW49dCl9LHRoaXMuc2V0RW5kPWZ1bmN0aW9uKGUsdCl7dHlwZW9mIGU9PSJvYmplY3QiPyh0aGlzLmVuZC5jb2x1bW49ZS5jb2x1bW4sdGhpcy5lbmQucm93PWUucm93KToodGhpcy5lbmQucm93PWUsdGhpcy5lbmQuY29sdW1uPXQpfSx0aGlzLmluc2lkZT1mdW5jdGlvbihlLHQpe3JldHVybiB0aGlzLmNvbXBhcmUoZSx0KT09MD90aGlzLmlzRW5kKGUsdCl8fHRoaXMuaXNTdGFydChlLHQpPyExOiEwOiExfSx0aGlzLmluc2lkZVN0YXJ0PWZ1bmN0aW9uKGUsdCl7cmV0dXJuIHRoaXMuY29tcGFyZShlLHQpPT0wP3RoaXMuaXNFbmQoZSx0KT8hMTohMDohMX0sdGhpcy5pbnNpZGVFbmQ9ZnVuY3Rpb24oZSx0KXtyZXR1cm4gdGhpcy5jb21wYXJlKGUsdCk9PTA/dGhpcy5pc1N0YXJ0KGUsdCk/ITE6ITA6ITF9LHRoaXMuY29tcGFyZT1mdW5jdGlvbihlLHQpe3JldHVybiF0aGlzLmlzTXVsdGlMaW5lKCkmJmU9PT10aGlzLnN0YXJ0LnJvdz90PHRoaXMuc3RhcnQuY29sdW1uPy0xOnQ+dGhpcy5lbmQuY29sdW1uPzE6MDplPHRoaXMuc3RhcnQucm93Py0xOmU+dGhpcy5lbmQucm93PzE6dGhpcy5zdGFydC5yb3c9PT1lP3Q+PXRoaXMuc3RhcnQuY29sdW1uPzA6LTE6dGhpcy5lbmQucm93PT09ZT90PD10aGlzLmVuZC5jb2x1bW4/MDoxOjB9LHRoaXMuY29tcGFyZVN0YXJ0PWZ1bmN0aW9uKGUsdCl7cmV0dXJuIHRoaXMuc3RhcnQucm93PT1lJiZ0aGlzLnN0YXJ0LmNvbHVtbj09dD8tMTp0aGlzLmNvbXBhcmUoZSx0KX0sdGhpcy5jb21wYXJlRW5kPWZ1bmN0aW9uKGUsdCl7cmV0dXJuIHRoaXMuZW5kLnJvdz09ZSYmdGhpcy5lbmQuY29sdW1uPT10PzE6dGhpcy5jb21wYXJlKGUsdCl9LHRoaXMuY29tcGFyZUluc2lkZT1mdW5jdGlvbihlLHQpe3JldHVybiB0aGlzLmVuZC5yb3c9PWUmJnRoaXMuZW5kLmNvbHVtbj09dD8xOnRoaXMuc3RhcnQucm93PT1lJiZ0aGlzLnN0YXJ0LmNvbHVtbj09dD8tMTp0aGlzLmNvbXBhcmUoZSx0KX0sdGhpcy5jbGlwUm93cz1mdW5jdGlvbihlLHQpe2lmKHRoaXMuZW5kLnJvdz50KXZhciBuPXtyb3c6dCsxLGNvbHVtbjowfTtlbHNlIGlmKHRoaXMuZW5kLnJvdzxlKXZhciBuPXtyb3c6ZSxjb2x1bW46MH07aWYodGhpcy5zdGFydC5yb3c+dCl2YXIgcj17cm93OnQrMSxjb2x1bW46MH07ZWxzZSBpZih0aGlzLnN0YXJ0LnJvdzxlKXZhciByPXtyb3c6ZSxjb2x1bW46MH07cmV0dXJuIGkuZnJvbVBvaW50cyhyfHx0aGlzLnN0YXJ0LG58fHRoaXMuZW5kKX0sdGhpcy5leHRlbmQ9ZnVuY3Rpb24oZSx0KXt2YXIgbj10aGlzLmNvbXBhcmUoZSx0KTtpZihuPT0wKXJldHVybiB0aGlzO2lmKG49PS0xKXZhciByPXtyb3c6ZSxjb2x1bW46dH07ZWxzZSB2YXIgcz17cm93OmUsY29sdW1uOnR9O3JldHVybiBpLmZyb21Qb2ludHMocnx8dGhpcy5zdGFydCxzfHx0aGlzLmVuZCl9LHRoaXMuaXNFbXB0eT1mdW5jdGlvbigpe3JldHVybiB0aGlzLnN0YXJ0LnJvdz09PXRoaXMuZW5kLnJvdyYmdGhpcy5zdGFydC5jb2x1bW49PT10aGlzLmVuZC5jb2x1bW59LHRoaXMuaXNNdWx0aUxpbmU9ZnVuY3Rpb24oKXtyZXR1cm4gdGhpcy5zdGFydC5yb3chPT10aGlzLmVuZC5yb3d9LHRoaXMuY2xvbmU9ZnVuY3Rpb24oKXtyZXR1cm4gaS5mcm9tUG9pbnRzKHRoaXMuc3RhcnQsdGhpcy5lbmQpfSx0aGlzLmNvbGxhcHNlUm93cz1mdW5jdGlvbigpe3JldHVybiB0aGlzLmVuZC5jb2x1bW49PTA/bmV3IGkodGhpcy5zdGFydC5yb3csMCxNYXRoLm1heCh0aGlzLnN0YXJ0LnJvdyx0aGlzLmVuZC5yb3ctMSksMCk6bmV3IGkodGhpcy5zdGFydC5yb3csMCx0aGlzLmVuZC5yb3csMCl9LHRoaXMudG9TY3JlZW5SYW5nZT1mdW5jdGlvbihlKXt2YXIgdD1lLmRvY3VtZW50VG9TY3JlZW5Qb3NpdGlvbih0aGlzLnN0YXJ0KSxuPWUuZG9jdW1lbnRUb1NjcmVlblBvc2l0aW9uKHRoaXMuZW5kKTtyZXR1cm4gbmV3IGkodC5yb3csdC5jb2x1bW4sbi5yb3csbi5jb2x1bW4pfSx0aGlzLm1vdmVCeT1mdW5jdGlvbihlLHQpe3RoaXMuc3RhcnQucm93Kz1lLHRoaXMuc3RhcnQuY29sdW1uKz10LHRoaXMuZW5kLnJvdys9ZSx0aGlzLmVuZC5jb2x1bW4rPXR9fSkuY2FsbChpLnByb3RvdHlwZSksaS5mcm9tUG9pbnRzPWZ1bmN0aW9uKGUsdCl7cmV0dXJuIG5ldyBpKGUucm93LGUuY29sdW1uLHQucm93LHQuY29sdW1uKX0saS5jb21wYXJlUG9pbnRzPXIsaS5jb21wYXJlUG9pbnRzPWZ1bmN0aW9uKGUsdCl7cmV0dXJuIGUucm93LXQucm93fHxlLmNvbHVtbi10LmNvbHVtbn0sdC5SYW5nZT1pfSksZGVmaW5lKCJhY2UvY2xpcGJvYXJkIixbInJlcXVpcmUiLCJleHBvcnRzIiwibW9kdWxlIl0sZnVuY3Rpb24oZSx0LG4peyJ1c2Ugc3RyaWN0Ijt2YXIgcjtuLmV4cG9ydHM9e2xpbmVNb2RlOiExLHBhc3RlQ2FuY2VsbGVkOmZ1bmN0aW9uKCl7cmV0dXJuIHImJnI+RGF0ZS5ub3coKS01MD8hMDpyPSExfSxjYW5jZWw6ZnVuY3Rpb24oKXtyPURhdGUubm93KCl9fX0pLGRlZmluZSgiYWNlL2tleWJvYXJkL3RleHRpbnB1dCIsWyJyZXF1aXJlIiwiZXhwb3J0cyIsIm1vZHVsZSIsImFjZS9saWIvZXZlbnQiLCJhY2UvbGliL3VzZXJhZ2VudCIsImFjZS9saWIvZG9tIiwiYWNlL2xpYi9sYW5nIiwiYWNlL2NsaXBib2FyZCIsImFjZS9saWIva2V5cyJdLGZ1bmN0aW9uKGUsdCxuKXsidXNlIHN0cmljdCI7dmFyIHI9ZSgiLi4vbGliL2V2ZW50IiksaT1lKCIuLi9saWIvdXNlcmFnZW50Iikscz1lKCIuLi9saWIvZG9tIiksbz1lKCIuLi9saWIvbGFuZyIpLHU9ZSgiLi4vY2xpcGJvYXJkIiksYT1pLmlzQ2hyb21lPDE4LGY9aS5pc0lFLGw9aS5pc0Nocm9tZT42MyxjPTQwMCxoPWUoIi4uL2xpYi9rZXlzIikscD1oLktFWV9NT0RTLGQ9aS5pc0lPUyx2PWQ/L1xzLzovXG4vLG09aS5pc01vYmlsZSxnPWZ1bmN0aW9uKGUsdCl7ZnVuY3Rpb24gWCgpe3g9ITAsbi5ibHVyKCksbi5mb2N1cygpLHg9ITF9ZnVuY3Rpb24gJChlKXtlLmtleUNvZGU9PTI3JiZuLnZhbHVlLmxlbmd0aDxuLnNlbGVjdGlvblN0YXJ0JiYoYnx8KFQ9bi52YWx1ZSksTj1DPS0xLE8oKSksVigpfWZ1bmN0aW9uIEsoKXtjbGVhclRpbWVvdXQoSiksSj1zZXRUaW1lb3V0KGZ1bmN0aW9uKCl7RSYmKG4uc3R5bGUuY3NzVGV4dD1FLEU9IiIpLHQucmVuZGVyZXIuJGlzTW91c2VQcmVzc2VkPSExLHQucmVuZGVyZXIuJGtlZXBUZXh0QXJlYUF0Q3Vyc29yJiZ0LnJlbmRlcmVyLiRtb3ZlVGV4dEFyZWFUb0N1cnNvcigpfSwwKX1mdW5jdGlvbiBHKGUsdCxuKXt2YXIgcj1udWxsLGk9ITE7bi5hZGRFdmVudExpc3RlbmVyKCJrZXlkb3duIixmdW5jdGlvbihlKXtyJiZjbGVhclRpbWVvdXQociksaT0hMH0sITApLG4uYWRkRXZlbnRMaXN0ZW5lcigia2V5dXAiLGZ1bmN0aW9uKGUpe3I9c2V0VGltZW91dChmdW5jdGlvbigpe2k9ITF9LDEwMCl9LCEwKTt2YXIgcz1mdW5jdGlvbihlKXtpZihkb2N1bWVudC5hY3RpdmVFbGVtZW50IT09bilyZXR1cm47aWYoaXx8Ynx8dC4kbW91c2VIYW5kbGVyLmlzTW91c2VQcmVzc2VkKXJldHVybjtpZihnKXJldHVybjt2YXIgcj1uLnNlbGVjdGlvblN0YXJ0LHM9bi5zZWxlY3Rpb25FbmQsbz1udWxsLHU9MDtpZihyPT0wKW89aC51cDtlbHNlIGlmKHI9PTEpbz1oLmhvbWU7ZWxzZSBpZihzPkMmJlRbc109PSJcbiIpbz1oLmVuZDtlbHNlIGlmKHI8TiYmVFtyLTFdPT0iICIpbz1oLmxlZnQsdT1wLm9wdGlvbjtlbHNlIGlmKHI8Tnx8cj09TiYmQyE9TiYmcj09cylvPWgubGVmdDtlbHNlIGlmKHM+QyYmVC5zbGljZSgwLHMpLnNwbGl0KCJcbiIpLmxlbmd0aD4yKW89aC5kb3duO2Vsc2UgaWYocz5DJiZUW3MtMV09PSIgIilvPWgucmlnaHQsdT1wLm9wdGlvbjtlbHNlIGlmKHM+Q3x8cz09QyYmQyE9TiYmcj09cylvPWgucmlnaHQ7ciE9PXMmJih1fD1wLnNoaWZ0KTtpZihvKXt2YXIgYT10Lm9uQ29tbWFuZEtleSh7fSx1LG8pO2lmKCFhJiZ0LmNvbW1hbmRzKXtvPWgua2V5Q29kZVRvU3RyaW5nKG8pO3ZhciBmPXQuY29tbWFuZHMuZmluZEtleUNvbW1hbmQodSxvKTtmJiZ0LmV4ZWNDb21tYW5kKGYpfU49cixDPXMsTygiIil9fTtkb2N1bWVudC5hZGRFdmVudExpc3RlbmVyKCJzZWxlY3Rpb25jaGFuZ2UiLHMpLHQub24oImRlc3Ryb3kiLGZ1bmN0aW9uKCl7ZG9jdW1lbnQucmVtb3ZlRXZlbnRMaXN0ZW5lcigic2VsZWN0aW9uY2hhbmdlIixzKX0pfXZhciBuPXMuY3JlYXRlRWxlbWVudCgidGV4dGFyZWEiKTtuLmNsYXNzTmFtZT0iYWNlX3RleHQtaW5wdXQiLG4uc2V0QXR0cmlidXRlKCJ3cmFwIiwib2ZmIiksbi5zZXRBdHRyaWJ1dGUoImF1dG9jb3JyZWN0Iiwib2ZmIiksbi5zZXRBdHRyaWJ1dGUoImF1dG9jYXBpdGFsaXplIiwib2ZmIiksbi5zZXRBdHRyaWJ1dGUoInNwZWxsY2hlY2siLCExKSxuLnN0eWxlLm9wYWNpdHk9IjAiLGUuaW5zZXJ0QmVmb3JlKG4sZS5maXJzdENoaWxkKTt2YXIgZz0hMSx5PSExLGI9ITEsdz0hMSxFPSIiO218fChuLnN0eWxlLmZvbnRTaXplPSIxcHgiKTt2YXIgUz0hMSx4PSExLFQ9IiIsTj0wLEM9MCxrPTA7dHJ5e3ZhciBMPWRvY3VtZW50LmFjdGl2ZUVsZW1lbnQ9PT1ufWNhdGNoKEEpe31yLmFkZExpc3RlbmVyKG4sImJsdXIiLGZ1bmN0aW9uKGUpe2lmKHgpcmV0dXJuO3Qub25CbHVyKGUpLEw9ITF9LHQpLHIuYWRkTGlzdGVuZXIobiwiZm9jdXMiLGZ1bmN0aW9uKGUpe2lmKHgpcmV0dXJuO0w9ITA7aWYoaS5pc0VkZ2UpdHJ5e2lmKCFkb2N1bWVudC5oYXNGb2N1cygpKXJldHVybn1jYXRjaChlKXt9dC5vbkZvY3VzKGUpLGkuaXNFZGdlP3NldFRpbWVvdXQoTyk6TygpfSx0KSx0aGlzLiRmb2N1c1Njcm9sbD0hMSx0aGlzLmZvY3VzPWZ1bmN0aW9uKCl7aWYoRXx8bHx8dGhpcy4kZm9jdXNTY3JvbGw9PSJicm93c2VyIilyZXR1cm4gbi5mb2N1cyh7cHJldmVudFNjcm9sbDohMH0pO3ZhciBlPW4uc3R5bGUudG9wO24uc3R5bGUucG9zaXRpb249ImZpeGVkIixuLnN0eWxlLnRvcD0iMHB4Ijt0cnl7dmFyIHQ9bi5nZXRCb3VuZGluZ0NsaWVudFJlY3QoKS50b3AhPTB9Y2F0Y2gocil7cmV0dXJufXZhciBpPVtdO2lmKHQpe3ZhciBzPW4ucGFyZW50RWxlbWVudDt3aGlsZShzJiZzLm5vZGVUeXBlPT0xKWkucHVzaChzKSxzLnNldEF0dHJpYnV0ZSgiYWNlX25vY29udGV4dCIsITApLCFzLnBhcmVudEVsZW1lbnQmJnMuZ2V0Um9vdE5vZGU/cz1zLmdldFJvb3ROb2RlKCkuaG9zdDpzPXMucGFyZW50RWxlbWVudH1uLmZvY3VzKHtwcmV2ZW50U2Nyb2xsOiEwfSksdCYmaS5mb3JFYWNoKGZ1bmN0aW9uKGUpe2UucmVtb3ZlQXR0cmlidXRlKCJhY2Vfbm9jb250ZXh0Iil9KSxzZXRUaW1lb3V0KGZ1bmN0aW9uKCl7bi5zdHlsZS5wb3NpdGlvbj0iIixuLnN0eWxlLnRvcD09IjBweCImJihuLnN0eWxlLnRvcD1lKX0sMCl9LHRoaXMuYmx1cj1mdW5jdGlvbigpe24uYmx1cigpfSx0aGlzLmlzRm9jdXNlZD1mdW5jdGlvbigpe3JldHVybiBMfSx0Lm9uKCJiZWZvcmVFbmRPcGVyYXRpb24iLGZ1bmN0aW9uKCl7dmFyIGU9dC5jdXJPcCxyPWUmJmUuY29tbWFuZCYmZS5jb21tYW5kLm5hbWU7aWYocj09Imluc2VydHN0cmluZyIpcmV0dXJuO3ZhciBpPXImJihlLmRvY0NoYW5nZWR8fGUuc2VsZWN0aW9uQ2hhbmdlZCk7YiYmaSYmKFQ9bi52YWx1ZT0iIixXKCkpLE8oKX0pO3ZhciBPPWQ/ZnVuY3Rpb24oZSl7aWYoIUx8fGcmJiFlfHx3KXJldHVybjtlfHwoZT0iIik7dmFyIHI9IlxuIGFiIitlKyJjZGUgZmdcbiI7ciE9bi52YWx1ZSYmKG4udmFsdWU9VD1yKTt2YXIgaT00LHM9NCsoZS5sZW5ndGh8fCh0LnNlbGVjdGlvbi5pc0VtcHR5KCk/MDoxKSk7KE4hPWl8fEMhPXMpJiZuLnNldFNlbGVjdGlvblJhbmdlKGkscyksTj1pLEM9c306ZnVuY3Rpb24oKXtpZihifHx3KXJldHVybjtpZighTCYmIVApcmV0dXJuO2I9ITA7dmFyIGU9MCxyPTAsaT0iIjtpZih0LnNlc3Npb24pe3ZhciBzPXQuc2VsZWN0aW9uLG89cy5nZXRSYW5nZSgpLHU9cy5jdXJzb3Iucm93O2U9by5zdGFydC5jb2x1bW4scj1vLmVuZC5jb2x1bW4saT10LnNlc3Npb24uZ2V0TGluZSh1KTtpZihvLnN0YXJ0LnJvdyE9dSl7dmFyIGE9dC5zZXNzaW9uLmdldExpbmUodS0xKTtlPW8uc3RhcnQucm93PHUtMT8wOmUscis9YS5sZW5ndGgrMSxpPWErIlxuIitpfWVsc2UgaWYoby5lbmQucm93IT11KXt2YXIgZj10LnNlc3Npb24uZ2V0TGluZSh1KzEpO3I9by5lbmQucm93PnUrMT9mLmxlbmd0aDpyLHIrPWkubGVuZ3RoKzEsaT1pKyJcbiIrZn1lbHNlIG0mJnU+MCYmKGk9IlxuIitpLHIrPTEsZSs9MSk7aS5sZW5ndGg+YyYmKGU8YyYmcjxjP2k9aS5zbGljZSgwLGMpOihpPSJcbiIsZT09cj9lPXI9MDooZT0wLHI9MSkpKX12YXIgbD1pKyJcblxuIjtsIT1UJiYobi52YWx1ZT1UPWwsTj1DPWwubGVuZ3RoKSxQJiYoTj1uLnNlbGVjdGlvblN0YXJ0LEM9bi5zZWxlY3Rpb25FbmQpO2lmKEMhPXJ8fE4hPWV8fG4uc2VsZWN0aW9uRW5kIT1DKXRyeXtuLnNldFNlbGVjdGlvblJhbmdlKGUsciksTj1lLEM9cn1jYXRjaChoKXt9Yj0hMX07dGhpcy5yZXNldFNlbGVjdGlvbj1PLEwmJnQub25Gb2N1cygpO3ZhciBNPWZ1bmN0aW9uKGUpe3JldHVybiBlLnNlbGVjdGlvblN0YXJ0PT09MCYmZS5zZWxlY3Rpb25FbmQ+PVQubGVuZ3RoJiZlLnZhbHVlPT09VCYmVCYmZS5zZWxlY3Rpb25FbmQhPT1DfSxfPWZ1bmN0aW9uKGUpe2lmKGIpcmV0dXJuO2c/Zz0hMTpNKG4pPyh0LnNlbGVjdEFsbCgpLE8oKSk6bSYmbi5zZWxlY3Rpb25TdGFydCE9TiYmTygpfSxEPW51bGw7dGhpcy5zZXRJbnB1dEhhbmRsZXI9ZnVuY3Rpb24oZSl7RD1lfSx0aGlzLmdldElucHV0SGFuZGxlcj1mdW5jdGlvbigpe3JldHVybiBEfTt2YXIgUD0hMSxIPWZ1bmN0aW9uKGUscil7UCYmKFA9ITEpO2lmKHkpcmV0dXJuIE8oKSxlJiZ0Lm9uUGFzdGUoZSkseT0hMSwiIjt2YXIgcz1uLnNlbGVjdGlvblN0YXJ0LG89bi5zZWxlY3Rpb25FbmQsdT1OLGE9VC5sZW5ndGgtQyxmPWUsbD1lLmxlbmd0aC1zLGM9ZS5sZW5ndGgtbyxoPTA7d2hpbGUodT4wJiZUW2hdPT1lW2hdKWgrKyx1LS07Zj1mLnNsaWNlKGgpLGg9MTt3aGlsZShhPjAmJlQubGVuZ3RoLWg+Ti0xJiZUW1QubGVuZ3RoLWhdPT1lW2UubGVuZ3RoLWhdKWgrKyxhLS07bC09aC0xLGMtPWgtMTt2YXIgcD1mLmxlbmd0aC1oKzE7cDwwJiYodT0tcCxwPTApLGY9Zi5zbGljZSgwLHApO2lmKCFyJiYhZiYmIWwmJiF1JiYhYSYmIWMpcmV0dXJuIiI7dz0hMDt2YXIgZD0hMTtyZXR1cm4gaS5pc0FuZHJvaWQmJmY9PSIuICImJihmPSIgICIsZD0hMCksZiYmIXUmJiFhJiYhbCYmIWN8fFM/dC5vblRleHRJbnB1dChmKTp0Lm9uVGV4dElucHV0KGYse2V4dGVuZExlZnQ6dSxleHRlbmRSaWdodDphLHJlc3RvcmVTdGFydDpsLHJlc3RvcmVFbmQ6Y30pLHc9ITEsVD1lLE49cyxDPW8saz1jLGQ/IlxuIjpmfSxCPWZ1bmN0aW9uKGUpe2lmKGIpcmV0dXJuIHooKTtpZihlJiZlLmlucHV0VHlwZSl7aWYoZS5pbnB1dFR5cGU9PSJoaXN0b3J5VW5kbyIpcmV0dXJuIHQuZXhlY0NvbW1hbmQoInVuZG8iKTtpZihlLmlucHV0VHlwZT09Imhpc3RvcnlSZWRvIilyZXR1cm4gdC5leGVjQ29tbWFuZCgicmVkbyIpfXZhciByPW4udmFsdWUsaT1IKHIsITApOyhyLmxlbmd0aD5jKzEwMHx8di50ZXN0KGkpfHxtJiZOPDEmJk49PUMpJiZPKCl9LGo9ZnVuY3Rpb24oZSx0LG4pe3ZhciByPWUuY2xpcGJvYXJkRGF0YXx8d2luZG93LmNsaXBib2FyZERhdGE7aWYoIXJ8fGEpcmV0dXJuO3ZhciBpPWZ8fG4/IlRleHQiOiJ0ZXh0L3BsYWluIjt0cnl7cmV0dXJuIHQ/ci5zZXREYXRhKGksdCkhPT0hMTpyLmdldERhdGEoaSl9Y2F0Y2goZSl7aWYoIW4pcmV0dXJuIGooZSx0LCEwKX19LEY9ZnVuY3Rpb24oZSxpKXt2YXIgcz10LmdldENvcHlUZXh0KCk7aWYoIXMpcmV0dXJuIHIucHJldmVudERlZmF1bHQoZSk7aihlLHMpPyhkJiYoTyhzKSxnPXMsc2V0VGltZW91dChmdW5jdGlvbigpe2c9ITF9LDEwKSksaT90Lm9uQ3V0KCk6dC5vbkNvcHkoKSxyLnByZXZlbnREZWZhdWx0KGUpKTooZz0hMCxuLnZhbHVlPXMsbi5zZWxlY3QoKSxzZXRUaW1lb3V0KGZ1bmN0aW9uKCl7Zz0hMSxPKCksaT90Lm9uQ3V0KCk6dC5vbkNvcHkoKX0pKX0sST1mdW5jdGlvbihlKXtGKGUsITApfSxxPWZ1bmN0aW9uKGUpe0YoZSwhMSl9LFI9ZnVuY3Rpb24oZSl7dmFyIHM9aihlKTtpZih1LnBhc3RlQ2FuY2VsbGVkKCkpcmV0dXJuO3R5cGVvZiBzPT0ic3RyaW5nIj8ocyYmdC5vblBhc3RlKHMsZSksaS5pc0lFJiZzZXRUaW1lb3V0KE8pLHIucHJldmVudERlZmF1bHQoZSkpOihuLnZhbHVlPSIiLHk9ITApfTtyLmFkZENvbW1hbmRLZXlMaXN0ZW5lcihuLHQub25Db21tYW5kS2V5LmJpbmQodCksdCksci5hZGRMaXN0ZW5lcihuLCJzZWxlY3QiLF8sdCksci5hZGRMaXN0ZW5lcihuLCJpbnB1dCIsQix0KSxyLmFkZExpc3RlbmVyKG4sImN1dCIsSSx0KSxyLmFkZExpc3RlbmVyKG4sImNvcHkiLHEsdCksci5hZGRMaXN0ZW5lcihuLCJwYXN0ZSIsUix0KSwoISgib25jdXQiaW4gbil8fCEoIm9uY29weSJpbiBuKXx8ISgib25wYXN0ZSJpbiBuKSkmJnIuYWRkTGlzdGVuZXIoZSwia2V5ZG93biIsZnVuY3Rpb24oZSl7aWYoaS5pc01hYyYmIWUubWV0YUtleXx8IWUuY3RybEtleSlyZXR1cm47c3dpdGNoKGUua2V5Q29kZSl7Y2FzZSA2NzpxKGUpO2JyZWFrO2Nhc2UgODY6UihlKTticmVhaztjYXNlIDg4OkkoZSl9fSx0KTt2YXIgVT1mdW5jdGlvbihlKXtpZihifHwhdC5vbkNvbXBvc2l0aW9uU3RhcnR8fHQuJHJlYWRPbmx5KXJldHVybjtiPXt9O2lmKFMpcmV0dXJuO2UuZGF0YSYmKGIudXNlVGV4dGFyZWFGb3JJTUU9ITEpLHNldFRpbWVvdXQoeiwwKSx0Ll9zaWduYWwoImNvbXBvc2l0aW9uU3RhcnQiKSx0Lm9uKCJtb3VzZWRvd24iLFgpO3ZhciByPXQuZ2V0U2VsZWN0aW9uUmFuZ2UoKTtyLmVuZC5yb3c9ci5zdGFydC5yb3csci5lbmQuY29sdW1uPXIuc3RhcnQuY29sdW1uLGIubWFya2VyUmFuZ2U9cixiLnNlbGVjdGlvblN0YXJ0PU4sdC5vbkNvbXBvc2l0aW9uU3RhcnQoYiksYi51c2VUZXh0YXJlYUZvcklNRT8oVD1uLnZhbHVlPSIiLE49MCxDPTApOihuLm1zR2V0SW5wdXRDb250ZXh0JiYoYi5jb250ZXh0PW4ubXNHZXRJbnB1dENvbnRleHQoKSksbi5nZXRJbnB1dENvbnRleHQmJihiLmNvbnRleHQ9bi5nZXRJbnB1dENvbnRleHQoKSkpfSx6PWZ1bmN0aW9uKCl7aWYoIWJ8fCF0Lm9uQ29tcG9zaXRpb25VcGRhdGV8fHQuJHJlYWRPbmx5KXJldHVybjtpZihTKXJldHVybiBYKCk7aWYoYi51c2VUZXh0YXJlYUZvcklNRSl0Lm9uQ29tcG9zaXRpb25VcGRhdGUobi52YWx1ZSk7ZWxzZXt2YXIgZT1uLnZhbHVlO0goZSksYi5tYXJrZXJSYW5nZSYmKGIuY29udGV4dCYmKGIubWFya2VyUmFuZ2Uuc3RhcnQuY29sdW1uPWIuc2VsZWN0aW9uU3RhcnQ9Yi5jb250ZXh0LmNvbXBvc2l0aW9uU3RhcnRPZmZzZXQpLGIubWFya2VyUmFuZ2UuZW5kLmNvbHVtbj1iLm1hcmtlclJhbmdlLnN0YXJ0LmNvbHVtbitDLWIuc2VsZWN0aW9uU3RhcnQrayl9fSxXPWZ1bmN0aW9uKGUpe2lmKCF0Lm9uQ29tcG9zaXRpb25FbmR8fHQuJHJlYWRPbmx5KXJldHVybjtiPSExLHQub25Db21wb3NpdGlvbkVuZCgpLHQub2ZmKCJtb3VzZWRvd24iLFgpLGUmJkIoKX0sVj1vLmRlbGF5ZWRDYWxsKHosNTApLnNjaGVkdWxlLmJpbmQobnVsbCxudWxsKTtyLmFkZExpc3RlbmVyKG4sImNvbXBvc2l0aW9uc3RhcnQiLFUsdCksci5hZGRMaXN0ZW5lcihuLCJjb21wb3NpdGlvbnVwZGF0ZSIseix0KSxyLmFkZExpc3RlbmVyKG4sImtleXVwIiwkLHQpLHIuYWRkTGlzdGVuZXIobiwia2V5ZG93biIsVix0KSxyLmFkZExpc3RlbmVyKG4sImNvbXBvc2l0aW9uZW5kIixXLHQpLHRoaXMuZ2V0RWxlbWVudD1mdW5jdGlvbigpe3JldHVybiBufSx0aGlzLnNldENvbW1hbmRNb2RlPWZ1bmN0aW9uKGUpe1M9ZSxuLnJlYWRPbmx5PSExfSx0aGlzLnNldFJlYWRPbmx5PWZ1bmN0aW9uKGUpe1N8fChuLnJlYWRPbmx5PWUpfSx0aGlzLnNldENvcHlXaXRoRW1wdHlTZWxlY3Rpb249ZnVuY3Rpb24oZSl7fSx0aGlzLm9uQ29udGV4dE1lbnU9ZnVuY3Rpb24oZSl7UD0hMCxPKCksdC5fZW1pdCgibmF0aXZlY29udGV4dG1lbnUiLHt0YXJnZXQ6dCxkb21FdmVudDplfSksdGhpcy5tb3ZlVG9Nb3VzZShlLCEwKX0sdGhpcy5tb3ZlVG9Nb3VzZT1mdW5jdGlvbihlLG8pe0V8fChFPW4uc3R5bGUuY3NzVGV4dCksbi5zdHlsZS5jc3NUZXh0PShvPyJ6LWluZGV4OjEwMDAwMDsiOiIiKSsoaS5pc0lFPyJvcGFjaXR5OjAuMTsiOiIiKSsidGV4dC1pbmRlbnQ6IC0iKyhOK0MpKnQucmVuZGVyZXIuY2hhcmFjdGVyV2lkdGgqLjUrInB4OyI7dmFyIHU9dC5jb250YWluZXIuZ2V0Qm91bmRpbmdDbGllbnRSZWN0KCksYT1zLmNvbXB1dGVkU3R5bGUodC5jb250YWluZXIpLGY9dS50b3ArKHBhcnNlSW50KGEuYm9yZGVyVG9wV2lkdGgpfHwwKSxsPXUubGVmdCsocGFyc2VJbnQodS5ib3JkZXJMZWZ0V2lkdGgpfHwwKSxjPXUuYm90dG9tLWYtbi5jbGllbnRIZWlnaHQtMixoPWZ1bmN0aW9uKGUpe3MudHJhbnNsYXRlKG4sZS5jbGllbnRYLWwtMixNYXRoLm1pbihlLmNsaWVudFktZi0yLGMpKX07aChlKTtpZihlLnR5cGUhPSJtb3VzZWRvd24iKXJldHVybjt0LnJlbmRlcmVyLiRpc01vdXNlUHJlc3NlZD0hMCxjbGVhclRpbWVvdXQoSiksaS5pc1dpbiYmci5jYXB0dXJlKHQuY29udGFpbmVyLGgsSyl9LHRoaXMub25Db250ZXh0TWVudUNsb3NlPUs7dmFyIEosUT1mdW5jdGlvbihlKXt0LnRleHRJbnB1dC5vbkNvbnRleHRNZW51KGUpLEsoKX07ci5hZGRMaXN0ZW5lcihuLCJtb3VzZXVwIixRLHQpLHIuYWRkTGlzdGVuZXIobiwibW91c2Vkb3duIixmdW5jdGlvbihlKXtlLnByZXZlbnREZWZhdWx0KCksSygpfSx0KSxyLmFkZExpc3RlbmVyKHQucmVuZGVyZXIuc2Nyb2xsZXIsImNvbnRleHRtZW51IixRLHQpLHIuYWRkTGlzdGVuZXIobiwiY29udGV4dG1lbnUiLFEsdCksZCYmRyhlLHQsbiksdGhpcy5kZXN0cm95PWZ1bmN0aW9uKCl7bi5wYXJlbnRFbGVtZW50JiZuLnBhcmVudEVsZW1lbnQucmVtb3ZlQ2hpbGQobil9fTt0LlRleHRJbnB1dD1nLHQuJHNldFVzZXJBZ2VudEZvclRlc3RzPWZ1bmN0aW9uKGUsdCl7bT1lLGQ9dH19KSxkZWZpbmUoImFjZS9tb3VzZS9kZWZhdWx0X2hhbmRsZXJzIixbInJlcXVpcmUiLCJleHBvcnRzIiwibW9kdWxlIiwiYWNlL2xpYi91c2VyYWdlbnQiXSxmdW5jdGlvbihlLHQsbil7InVzZSBzdHJpY3QiO2Z1bmN0aW9uIG8oZSl7ZS4kY2xpY2tTZWxlY3Rpb249bnVsbDt2YXIgdD1lLmVkaXRvcjt0LnNldERlZmF1bHRIYW5kbGVyKCJtb3VzZWRvd24iLHRoaXMub25Nb3VzZURvd24uYmluZChlKSksdC5zZXREZWZhdWx0SGFuZGxlcigiZGJsY2xpY2siLHRoaXMub25Eb3VibGVDbGljay5iaW5kKGUpKSx0LnNldERlZmF1bHRIYW5kbGVyKCJ0cmlwbGVjbGljayIsdGhpcy5vblRyaXBsZUNsaWNrLmJpbmQoZSkpLHQuc2V0RGVmYXVsdEhhbmRsZXIoInF1YWRjbGljayIsdGhpcy5vblF1YWRDbGljay5iaW5kKGUpKSx0LnNldERlZmF1bHRIYW5kbGVyKCJtb3VzZXdoZWVsIix0aGlzLm9uTW91c2VXaGVlbC5iaW5kKGUpKTt2YXIgbj1bInNlbGVjdCIsInN0YXJ0U2VsZWN0Iiwic2VsZWN0RW5kIiwic2VsZWN0QWxsRW5kIiwic2VsZWN0QnlXb3Jkc0VuZCIsInNlbGVjdEJ5TGluZXNFbmQiLCJkcmFnV2FpdCIsImRyYWdXYWl0RW5kIiwiZm9jdXNXYWl0Il07bi5mb3JFYWNoKGZ1bmN0aW9uKHQpe2VbdF09dGhpc1t0XX0sdGhpcyksZS5zZWxlY3RCeUxpbmVzPXRoaXMuZXh0ZW5kU2VsZWN0aW9uQnkuYmluZChlLCJnZXRMaW5lUmFuZ2UiKSxlLnNlbGVjdEJ5V29yZHM9dGhpcy5leHRlbmRTZWxlY3Rpb25CeS5iaW5kKGUsImdldFdvcmRSYW5nZSIpfWZ1bmN0aW9uIHUoZSx0LG4scil7cmV0dXJuIE1hdGguc3FydChNYXRoLnBvdyhuLWUsMikrTWF0aC5wb3coci10LDIpKX1mdW5jdGlvbiBhKGUsdCl7aWYoZS5zdGFydC5yb3c9PWUuZW5kLnJvdyl2YXIgbj0yKnQuY29sdW1uLWUuc3RhcnQuY29sdW1uLWUuZW5kLmNvbHVtbjtlbHNlIGlmKGUuc3RhcnQucm93PT1lLmVuZC5yb3ctMSYmIWUuc3RhcnQuY29sdW1uJiYhZS5lbmQuY29sdW1uKXZhciBuPXQuY29sdW1uLTQ7ZWxzZSB2YXIgbj0yKnQucm93LWUuc3RhcnQucm93LWUuZW5kLnJvdztyZXR1cm4gbjwwP3tjdXJzb3I6ZS5zdGFydCxhbmNob3I6ZS5lbmR9OntjdXJzb3I6ZS5lbmQsYW5jaG9yOmUuc3RhcnR9fXZhciByPWUoIi4uL2xpYi91c2VyYWdlbnQiKSxpPTAscz01NTA7KGZ1bmN0aW9uKCl7dGhpcy5vbk1vdXNlRG93bj1mdW5jdGlvbihlKXt2YXIgdD1lLmluU2VsZWN0aW9uKCksbj1lLmdldERvY3VtZW50UG9zaXRpb24oKTt0aGlzLm1vdXNlZG93bkV2ZW50PWU7dmFyIGk9dGhpcy5lZGl0b3Iscz1lLmdldEJ1dHRvbigpO2lmKHMhPT0wKXt2YXIgbz1pLmdldFNlbGVjdGlvblJhbmdlKCksdT1vLmlzRW1wdHkoKTsodXx8cz09MSkmJmkuc2VsZWN0aW9uLm1vdmVUb1Bvc2l0aW9uKG4pLHM9PTImJihpLnRleHRJbnB1dC5vbkNvbnRleHRNZW51KGUuZG9tRXZlbnQpLHIuaXNNb3ppbGxhfHxlLnByZXZlbnREZWZhdWx0KCkpO3JldHVybn10aGlzLm1vdXNlZG93bkV2ZW50LnRpbWU9RGF0ZS5ub3coKTtpZih0JiYhaS5pc0ZvY3VzZWQoKSl7aS5mb2N1cygpO2lmKHRoaXMuJGZvY3VzVGltZW91dCYmIXRoaXMuJGNsaWNrU2VsZWN0aW9uJiYhaS5pbk11bHRpU2VsZWN0TW9kZSl7dGhpcy5zZXRTdGF0ZSgiZm9jdXNXYWl0IiksdGhpcy5jYXB0dXJlTW91c2UoZSk7cmV0dXJufX1yZXR1cm4gdGhpcy5jYXB0dXJlTW91c2UoZSksdGhpcy5zdGFydFNlbGVjdChuLGUuZG9tRXZlbnQuX2NsaWNrcz4xKSxlLnByZXZlbnREZWZhdWx0KCl9LHRoaXMuc3RhcnRTZWxlY3Q9ZnVuY3Rpb24oZSx0KXtlPWV8fHRoaXMuZWRpdG9yLnJlbmRlcmVyLnNjcmVlblRvVGV4dENvb3JkaW5hdGVzKHRoaXMueCx0aGlzLnkpO3ZhciBuPXRoaXMuZWRpdG9yO2lmKCF0aGlzLm1vdXNlZG93bkV2ZW50KXJldHVybjt0aGlzLm1vdXNlZG93bkV2ZW50LmdldFNoaWZ0S2V5KCk/bi5zZWxlY3Rpb24uc2VsZWN0VG9Qb3NpdGlvbihlKTp0fHxuLnNlbGVjdGlvbi5tb3ZlVG9Qb3NpdGlvbihlKSx0fHx0aGlzLnNlbGVjdCgpLG4ucmVuZGVyZXIuc2Nyb2xsZXIuc2V0Q2FwdHVyZSYmbi5yZW5kZXJlci5zY3JvbGxlci5zZXRDYXB0dXJlKCksbi5zZXRTdHlsZSgiYWNlX3NlbGVjdGluZyIpLHRoaXMuc2V0U3RhdGUoInNlbGVjdCIpfSx0aGlzLnNlbGVjdD1mdW5jdGlvbigpe3ZhciBlLHQ9dGhpcy5lZGl0b3Isbj10LnJlbmRlcmVyLnNjcmVlblRvVGV4dENvb3JkaW5hdGVzKHRoaXMueCx0aGlzLnkpO2lmKHRoaXMuJGNsaWNrU2VsZWN0aW9uKXt2YXIgcj10aGlzLiRjbGlja1NlbGVjdGlvbi5jb21wYXJlUG9pbnQobik7aWYocj09LTEpZT10aGlzLiRjbGlja1NlbGVjdGlvbi5lbmQ7ZWxzZSBpZihyPT0xKWU9dGhpcy4kY2xpY2tTZWxlY3Rpb24uc3RhcnQ7ZWxzZXt2YXIgaT1hKHRoaXMuJGNsaWNrU2VsZWN0aW9uLG4pO249aS5jdXJzb3IsZT1pLmFuY2hvcn10LnNlbGVjdGlvbi5zZXRTZWxlY3Rpb25BbmNob3IoZS5yb3csZS5jb2x1bW4pfXQuc2VsZWN0aW9uLnNlbGVjdFRvUG9zaXRpb24obiksdC5yZW5kZXJlci5zY3JvbGxDdXJzb3JJbnRvVmlldygpfSx0aGlzLmV4dGVuZFNlbGVjdGlvbkJ5PWZ1bmN0aW9uKGUpe3ZhciB0LG49dGhpcy5lZGl0b3Iscj1uLnJlbmRlcmVyLnNjcmVlblRvVGV4dENvb3JkaW5hdGVzKHRoaXMueCx0aGlzLnkpLGk9bi5zZWxlY3Rpb25bZV0oci5yb3csci5jb2x1bW4pO2lmKHRoaXMuJGNsaWNrU2VsZWN0aW9uKXt2YXIgcz10aGlzLiRjbGlja1NlbGVjdGlvbi5jb21wYXJlUG9pbnQoaS5zdGFydCksbz10aGlzLiRjbGlja1NlbGVjdGlvbi5jb21wYXJlUG9pbnQoaS5lbmQpO2lmKHM9PS0xJiZvPD0wKXt0PXRoaXMuJGNsaWNrU2VsZWN0aW9uLmVuZDtpZihpLmVuZC5yb3chPXIucm93fHxpLmVuZC5jb2x1bW4hPXIuY29sdW1uKXI9aS5zdGFydH1lbHNlIGlmKG89PTEmJnM+PTApe3Q9dGhpcy4kY2xpY2tTZWxlY3Rpb24uc3RhcnQ7aWYoaS5zdGFydC5yb3chPXIucm93fHxpLnN0YXJ0LmNvbHVtbiE9ci5jb2x1bW4pcj1pLmVuZH1lbHNlIGlmKHM9PS0xJiZvPT0xKXI9aS5lbmQsdD1pLnN0YXJ0O2Vsc2V7dmFyIHU9YSh0aGlzLiRjbGlja1NlbGVjdGlvbixyKTtyPXUuY3Vyc29yLHQ9dS5hbmNob3J9bi5zZWxlY3Rpb24uc2V0U2VsZWN0aW9uQW5jaG9yKHQucm93LHQuY29sdW1uKX1uLnNlbGVjdGlvbi5zZWxlY3RUb1Bvc2l0aW9uKHIpLG4ucmVuZGVyZXIuc2Nyb2xsQ3Vyc29ySW50b1ZpZXcoKX0sdGhpcy5zZWxlY3RFbmQ9dGhpcy5zZWxlY3RBbGxFbmQ9dGhpcy5zZWxlY3RCeVdvcmRzRW5kPXRoaXMuc2VsZWN0QnlMaW5lc0VuZD1mdW5jdGlvbigpe3RoaXMuJGNsaWNrU2VsZWN0aW9uPW51bGwsdGhpcy5lZGl0b3IudW5zZXRTdHlsZSgiYWNlX3NlbGVjdGluZyIpLHRoaXMuZWRpdG9yLnJlbmRlcmVyLnNjcm9sbGVyLnJlbGVhc2VDYXB0dXJlJiZ0aGlzLmVkaXRvci5yZW5kZXJlci5zY3JvbGxlci5yZWxlYXNlQ2FwdHVyZSgpfSx0aGlzLmZvY3VzV2FpdD1mdW5jdGlvbigpe3ZhciBlPXUodGhpcy5tb3VzZWRvd25FdmVudC54LHRoaXMubW91c2Vkb3duRXZlbnQueSx0aGlzLngsdGhpcy55KSx0PURhdGUubm93KCk7KGU+aXx8dC10aGlzLm1vdXNlZG93bkV2ZW50LnRpbWU+dGhpcy4kZm9jdXNUaW1lb3V0KSYmdGhpcy5zdGFydFNlbGVjdCh0aGlzLm1vdXNlZG93bkV2ZW50LmdldERvY3VtZW50UG9zaXRpb24oKSl9LHRoaXMub25Eb3VibGVDbGljaz1mdW5jdGlvbihlKXt2YXIgdD1lLmdldERvY3VtZW50UG9zaXRpb24oKSxuPXRoaXMuZWRpdG9yLHI9bi5zZXNzaW9uLGk9ci5nZXRCcmFja2V0UmFuZ2UodCk7aT8oaS5pc0VtcHR5KCkmJihpLnN0YXJ0LmNvbHVtbi0tLGkuZW5kLmNvbHVtbisrKSx0aGlzLnNldFN0YXRlKCJzZWxlY3QiKSk6KGk9bi5zZWxlY3Rpb24uZ2V0V29yZFJhbmdlKHQucm93LHQuY29sdW1uKSx0aGlzLnNldFN0YXRlKCJzZWxlY3RCeVdvcmRzIikpLHRoaXMuJGNsaWNrU2VsZWN0aW9uPWksdGhpcy5zZWxlY3QoKX0sdGhpcy5vblRyaXBsZUNsaWNrPWZ1bmN0aW9uKGUpe3ZhciB0PWUuZ2V0RG9jdW1lbnRQb3NpdGlvbigpLG49dGhpcy5lZGl0b3I7dGhpcy5zZXRTdGF0ZSgic2VsZWN0QnlMaW5lcyIpO3ZhciByPW4uZ2V0U2VsZWN0aW9uUmFuZ2UoKTtyLmlzTXVsdGlMaW5lKCkmJnIuY29udGFpbnModC5yb3csdC5jb2x1bW4pPyh0aGlzLiRjbGlja1NlbGVjdGlvbj1uLnNlbGVjdGlvbi5nZXRMaW5lUmFuZ2Uoci5zdGFydC5yb3cpLHRoaXMuJGNsaWNrU2VsZWN0aW9uLmVuZD1uLnNlbGVjdGlvbi5nZXRMaW5lUmFuZ2Uoci5lbmQucm93KS5lbmQpOnRoaXMuJGNsaWNrU2VsZWN0aW9uPW4uc2VsZWN0aW9uLmdldExpbmVSYW5nZSh0LnJvdyksdGhpcy5zZWxlY3QoKX0sdGhpcy5vblF1YWRDbGljaz1mdW5jdGlvbihlKXt2YXIgdD10aGlzLmVkaXRvcjt0LnNlbGVjdEFsbCgpLHRoaXMuJGNsaWNrU2VsZWN0aW9uPXQuZ2V0U2VsZWN0aW9uUmFuZ2UoKSx0aGlzLnNldFN0YXRlKCJzZWxlY3RBbGwiKX0sdGhpcy5vbk1vdXNlV2hlZWw9ZnVuY3Rpb24oZSl7aWYoZS5nZXRBY2NlbEtleSgpKXJldHVybjtlLmdldFNoaWZ0S2V5KCkmJmUud2hlZWxZJiYhZS53aGVlbFgmJihlLndoZWVsWD1lLndoZWVsWSxlLndoZWVsWT0wKTt2YXIgdD10aGlzLmVkaXRvcjt0aGlzLiRsYXN0U2Nyb2xsfHwodGhpcy4kbGFzdFNjcm9sbD17dDowLHZ4OjAsdnk6MCxhbGxvd2VkOjB9KTt2YXIgbj10aGlzLiRsYXN0U2Nyb2xsLHI9ZS5kb21FdmVudC50aW1lU3RhbXAsaT1yLW4udCxvPWk/ZS53aGVlbFgvaTpuLnZ4LHU9aT9lLndoZWVsWS9pOm4udnk7aTxzJiYobz0obytuLnZ4KS8yLHU9KHUrbi52eSkvMik7dmFyIGE9TWF0aC5hYnMoby91KSxmPSExO2E+PTEmJnQucmVuZGVyZXIuaXNTY3JvbGxhYmxlQnkoZS53aGVlbFgqZS5zcGVlZCwwKSYmKGY9ITApLGE8PTEmJnQucmVuZGVyZXIuaXNTY3JvbGxhYmxlQnkoMCxlLndoZWVsWSplLnNwZWVkKSYmKGY9ITApO2lmKGYpbi5hbGxvd2VkPXI7ZWxzZSBpZihyLW4uYWxsb3dlZDxzKXt2YXIgbD1NYXRoLmFicyhvKTw9MS41Kk1hdGguYWJzKG4udngpJiZNYXRoLmFicyh1KTw9MS41Kk1hdGguYWJzKG4udnkpO2w/KGY9ITAsbi5hbGxvd2VkPXIpOm4uYWxsb3dlZD0wfW4udD1yLG4udng9byxuLnZ5PXU7aWYoZilyZXR1cm4gdC5yZW5kZXJlci5zY3JvbGxCeShlLndoZWVsWCplLnNwZWVkLGUud2hlZWxZKmUuc3BlZWQpLGUuc3RvcCgpfX0pLmNhbGwoby5wcm90b3R5cGUpLHQuRGVmYXVsdEhhbmRsZXJzPW99KSxkZWZpbmUoImFjZS90b29sdGlwIixbInJlcXVpcmUiLCJleHBvcnRzIiwibW9kdWxlIiwiYWNlL2xpYi9vb3AiLCJhY2UvbGliL2RvbSJdLGZ1bmN0aW9uKGUsdCxuKXsidXNlIHN0cmljdCI7ZnVuY3Rpb24gbyhlKXt0aGlzLmlzT3Blbj0hMSx0aGlzLiRlbGVtZW50PW51bGwsdGhpcy4kcGFyZW50Tm9kZT1lfXZhciByPWUoIi4vbGliL29vcCIpLGk9ZSgiLi9saWIvZG9tIikscz0iYWNlX3Rvb2x0aXAiOyhmdW5jdGlvbigpe3RoaXMuJGluaXQ9ZnVuY3Rpb24oKXtyZXR1cm4gdGhpcy4kZWxlbWVudD1pLmNyZWF0ZUVsZW1lbnQoImRpdiIpLHRoaXMuJGVsZW1lbnQuY2xhc3NOYW1lPXMsdGhpcy4kZWxlbWVudC5zdHlsZS5kaXNwbGF5PSJub25lIix0aGlzLiRwYXJlbnROb2RlLmFwcGVuZENoaWxkKHRoaXMuJGVsZW1lbnQpLHRoaXMuJGVsZW1lbnR9LHRoaXMuZ2V0RWxlbWVudD1mdW5jdGlvbigpe3JldHVybiB0aGlzLiRlbGVtZW50fHx0aGlzLiRpbml0KCl9LHRoaXMuc2V0VGV4dD1mdW5jdGlvbihlKXt0aGlzLmdldEVsZW1lbnQoKS50ZXh0Q29udGVudD1lfSx0aGlzLnNldEh0bWw9ZnVuY3Rpb24oZSl7dGhpcy5nZXRFbGVtZW50KCkuaW5uZXJIVE1MPWV9LHRoaXMuc2V0UG9zaXRpb249ZnVuY3Rpb24oZSx0KXt0aGlzLmdldEVsZW1lbnQoKS5zdHlsZS5sZWZ0PWUrInB4Iix0aGlzLmdldEVsZW1lbnQoKS5zdHlsZS50b3A9dCsicHgifSx0aGlzLnNldENsYXNzTmFtZT1mdW5jdGlvbihlKXtpLmFkZENzc0NsYXNzKHRoaXMuZ2V0RWxlbWVudCgpLGUpfSx0aGlzLnNob3c9ZnVuY3Rpb24oZSx0LG4pe2UhPW51bGwmJnRoaXMuc2V0VGV4dChlKSx0IT1udWxsJiZuIT1udWxsJiZ0aGlzLnNldFBvc2l0aW9uKHQsbiksdGhpcy5pc09wZW58fCh0aGlzLmdldEVsZW1lbnQoKS5zdHlsZS5kaXNwbGF5PSJibG9jayIsdGhpcy5pc09wZW49ITApfSx0aGlzLmhpZGU9ZnVuY3Rpb24oKXt0aGlzLmlzT3BlbiYmKHRoaXMuZ2V0RWxlbWVudCgpLnN0eWxlLmRpc3BsYXk9Im5vbmUiLHRoaXMuZ2V0RWxlbWVudCgpLmNsYXNzTmFtZT1zLHRoaXMuaXNPcGVuPSExKX0sdGhpcy5nZXRIZWlnaHQ9ZnVuY3Rpb24oKXtyZXR1cm4gdGhpcy5nZXRFbGVtZW50KCkub2Zmc2V0SGVpZ2h0fSx0aGlzLmdldFdpZHRoPWZ1bmN0aW9uKCl7cmV0dXJuIHRoaXMuZ2V0RWxlbWVudCgpLm9mZnNldFdpZHRofSx0aGlzLmRlc3Ryb3k9ZnVuY3Rpb24oKXt0aGlzLmlzT3Blbj0hMSx0aGlzLiRlbGVtZW50JiZ0aGlzLiRlbGVtZW50LnBhcmVudE5vZGUmJnRoaXMuJGVsZW1lbnQucGFyZW50Tm9kZS5yZW1vdmVDaGlsZCh0aGlzLiRlbGVtZW50KX19KS5jYWxsKG8ucHJvdG90eXBlKSx0LlRvb2x0aXA9b30pLGRlZmluZSgiYWNlL21vdXNlL2RlZmF1bHRfZ3V0dGVyX2hhbmRsZXIiLFsicmVxdWlyZSIsImV4cG9ydHMiLCJtb2R1bGUiLCJhY2UvbGliL2RvbSIsImFjZS9saWIvb29wIiwiYWNlL2xpYi9ldmVudCIsImFjZS90b29sdGlwIl0sZnVuY3Rpb24oZSx0LG4peyJ1c2Ugc3RyaWN0IjtmdW5jdGlvbiB1KGUpe2Z1bmN0aW9uIGwoKXt2YXIgcj11LmdldERvY3VtZW50UG9zaXRpb24oKS5yb3cscz1uLiRhbm5vdGF0aW9uc1tyXTtpZighcylyZXR1cm4gYygpO3ZhciBvPXQuc2Vzc2lvbi5nZXRMZW5ndGgoKTtpZihyPT1vKXt2YXIgYT10LnJlbmRlcmVyLnBpeGVsVG9TY3JlZW5Db29yZGluYXRlcygwLHUueSkucm93LGw9dS4kcG9zO2lmKGE+dC5zZXNzaW9uLmRvY3VtZW50VG9TY3JlZW5Sb3cobC5yb3csbC5jb2x1bW4pKXJldHVybiBjKCl9aWYoZj09cylyZXR1cm47Zj1zLnRleHQuam9pbigiPGJyLz4iKSxpLnNldEh0bWwoZik7dmFyIHA9cy5jbGFzc05hbWU7cCYmaS5zZXRDbGFzc05hbWUocC50cmltKCkpLGkuc2hvdygpLHQuX3NpZ25hbCgic2hvd0d1dHRlclRvb2x0aXAiLGkpLHQub24oIm1vdXNld2hlZWwiLGMpO2lmKGUuJHRvb2x0aXBGb2xsb3dzTW91c2UpaCh1KTtlbHNle3ZhciBkPXUuZG9tRXZlbnQudGFyZ2V0LHY9ZC5nZXRCb3VuZGluZ0NsaWVudFJlY3QoKSxtPWkuZ2V0RWxlbWVudCgpLnN0eWxlO20ubGVmdD12LnJpZ2h0KyJweCIsbS50b3A9di5ib3R0b20rInB4In19ZnVuY3Rpb24gYygpe28mJihvPWNsZWFyVGltZW91dChvKSksZiYmKGkuaGlkZSgpLGY9bnVsbCx0Ll9zaWduYWwoImhpZGVHdXR0ZXJUb29sdGlwIixpKSx0Lm9mZigibW91c2V3aGVlbCIsYykpfWZ1bmN0aW9uIGgoZSl7aS5zZXRQb3NpdGlvbihlLngsZS55KX12YXIgdD1lLmVkaXRvcixuPXQucmVuZGVyZXIuJGd1dHRlckxheWVyLGk9bmV3IGEodC5jb250YWluZXIpO2UuZWRpdG9yLnNldERlZmF1bHRIYW5kbGVyKCJndXR0ZXJtb3VzZWRvd24iLGZ1bmN0aW9uKHIpe2lmKCF0LmlzRm9jdXNlZCgpfHxyLmdldEJ1dHRvbigpIT0wKXJldHVybjt2YXIgaT1uLmdldFJlZ2lvbihyKTtpZihpPT0iZm9sZFdpZGdldHMiKXJldHVybjt2YXIgcz1yLmdldERvY3VtZW50UG9zaXRpb24oKS5yb3csbz10LnNlc3Npb24uc2VsZWN0aW9uO2lmKHIuZ2V0U2hpZnRLZXkoKSlvLnNlbGVjdFRvKHMsMCk7ZWxzZXtpZihyLmRvbUV2ZW50LmRldGFpbD09MilyZXR1cm4gdC5zZWxlY3RBbGwoKSxyLnByZXZlbnREZWZhdWx0KCk7ZS4kY2xpY2tTZWxlY3Rpb249dC5zZWxlY3Rpb24uZ2V0TGluZVJhbmdlKHMpfXJldHVybiBlLnNldFN0YXRlKCJzZWxlY3RCeUxpbmVzIiksZS5jYXB0dXJlTW91c2Uociksci5wcmV2ZW50RGVmYXVsdCgpfSk7dmFyIG8sdSxmO2UuZWRpdG9yLnNldERlZmF1bHRIYW5kbGVyKCJndXR0ZXJtb3VzZW1vdmUiLGZ1bmN0aW9uKHQpe3ZhciBuPXQuZG9tRXZlbnQudGFyZ2V0fHx0LmRvbUV2ZW50LnNyY0VsZW1lbnQ7aWYoci5oYXNDc3NDbGFzcyhuLCJhY2VfZm9sZC13aWRnZXQiKSlyZXR1cm4gYygpO2YmJmUuJHRvb2x0aXBGb2xsb3dzTW91c2UmJmgodCksdT10O2lmKG8pcmV0dXJuO289c2V0VGltZW91dChmdW5jdGlvbigpe289bnVsbCx1JiYhZS5pc01vdXNlUHJlc3NlZD9sKCk6YygpfSw1MCl9KSxzLmFkZExpc3RlbmVyKHQucmVuZGVyZXIuJGd1dHRlciwibW91c2VvdXQiLGZ1bmN0aW9uKGUpe3U9bnVsbDtpZighZnx8bylyZXR1cm47bz1zZXRUaW1lb3V0KGZ1bmN0aW9uKCl7bz1udWxsLGMoKX0sNTApfSx0KSx0Lm9uKCJjaGFuZ2VTZXNzaW9uIixjKX1mdW5jdGlvbiBhKGUpe28uY2FsbCh0aGlzLGUpfXZhciByPWUoIi4uL2xpYi9kb20iKSxpPWUoIi4uL2xpYi9vb3AiKSxzPWUoIi4uL2xpYi9ldmVudCIpLG89ZSgiLi4vdG9vbHRpcCIpLlRvb2x0aXA7aS5pbmhlcml0cyhhLG8pLGZ1bmN0aW9uKCl7dGhpcy5zZXRQb3NpdGlvbj1mdW5jdGlvbihlLHQpe3ZhciBuPXdpbmRvdy5pbm5lcldpZHRofHxkb2N1bWVudC5kb2N1bWVudEVsZW1lbnQuY2xpZW50V2lkdGgscj13aW5kb3cuaW5uZXJIZWlnaHR8fGRvY3VtZW50LmRvY3VtZW50RWxlbWVudC5jbGllbnRIZWlnaHQsaT10aGlzLmdldFdpZHRoKCkscz10aGlzLmdldEhlaWdodCgpO2UrPTE1LHQrPTE1LGUraT5uJiYoZS09ZStpLW4pLHQrcz5yJiYodC09MjArcyksby5wcm90b3R5cGUuc2V0UG9zaXRpb24uY2FsbCh0aGlzLGUsdCl9fS5jYWxsKGEucHJvdG90eXBlKSx0Lkd1dHRlckhhbmRsZXI9dX0pLGRlZmluZSgiYWNlL21vdXNlL21vdXNlX2V2ZW50IixbInJlcXVpcmUiLCJleHBvcnRzIiwibW9kdWxlIiwiYWNlL2xpYi9ldmVudCIsImFjZS9saWIvdXNlcmFnZW50Il0sZnVuY3Rpb24oZSx0LG4peyJ1c2Ugc3RyaWN0Ijt2YXIgcj1lKCIuLi9saWIvZXZlbnQiKSxpPWUoIi4uL2xpYi91c2VyYWdlbnQiKSxzPXQuTW91c2VFdmVudD1mdW5jdGlvbihlLHQpe3RoaXMuZG9tRXZlbnQ9ZSx0aGlzLmVkaXRvcj10LHRoaXMueD10aGlzLmNsaWVudFg9ZS5jbGllbnRYLHRoaXMueT10aGlzLmNsaWVudFk9ZS5jbGllbnRZLHRoaXMuJHBvcz1udWxsLHRoaXMuJGluU2VsZWN0aW9uPW51bGwsdGhpcy5wcm9wYWdhdGlvblN0b3BwZWQ9ITEsdGhpcy5kZWZhdWx0UHJldmVudGVkPSExfTsoZnVuY3Rpb24oKXt0aGlzLnN0b3BQcm9wYWdhdGlvbj1mdW5jdGlvbigpe3Iuc3RvcFByb3BhZ2F0aW9uKHRoaXMuZG9tRXZlbnQpLHRoaXMucHJvcGFnYXRpb25TdG9wcGVkPSEwfSx0aGlzLnByZXZlbnREZWZhdWx0PWZ1bmN0aW9uKCl7ci5wcmV2ZW50RGVmYXVsdCh0aGlzLmRvbUV2ZW50KSx0aGlzLmRlZmF1bHRQcmV2ZW50ZWQ9ITB9LHRoaXMuc3RvcD1mdW5jdGlvbigpe3RoaXMuc3RvcFByb3BhZ2F0aW9uKCksdGhpcy5wcmV2ZW50RGVmYXVsdCgpfSx0aGlzLmdldERvY3VtZW50UG9zaXRpb249ZnVuY3Rpb24oKXtyZXR1cm4gdGhpcy4kcG9zP3RoaXMuJHBvczoodGhpcy4kcG9zPXRoaXMuZWRpdG9yLnJlbmRlcmVyLnNjcmVlblRvVGV4dENvb3JkaW5hdGVzKHRoaXMuY2xpZW50WCx0aGlzLmNsaWVudFkpLHRoaXMuJHBvcyl9LHRoaXMuaW5TZWxlY3Rpb249ZnVuY3Rpb24oKXtpZih0aGlzLiRpblNlbGVjdGlvbiE9PW51bGwpcmV0dXJuIHRoaXMuJGluU2VsZWN0aW9uO3ZhciBlPXRoaXMuZWRpdG9yLHQ9ZS5nZXRTZWxlY3Rpb25SYW5nZSgpO2lmKHQuaXNFbXB0eSgpKXRoaXMuJGluU2VsZWN0aW9uPSExO2Vsc2V7dmFyIG49dGhpcy5nZXREb2N1bWVudFBvc2l0aW9uKCk7dGhpcy4kaW5TZWxlY3Rpb249dC5jb250YWlucyhuLnJvdyxuLmNvbHVtbil9cmV0dXJuIHRoaXMuJGluU2VsZWN0aW9ufSx0aGlzLmdldEJ1dHRvbj1mdW5jdGlvbigpe3JldHVybiByLmdldEJ1dHRvbih0aGlzLmRvbUV2ZW50KX0sdGhpcy5nZXRTaGlmdEtleT1mdW5jdGlvbigpe3JldHVybiB0aGlzLmRvbUV2ZW50LnNoaWZ0S2V5fSx0aGlzLmdldEFjY2VsS2V5PWkuaXNNYWM/ZnVuY3Rpb24oKXtyZXR1cm4gdGhpcy5kb21FdmVudC5tZXRhS2V5fTpmdW5jdGlvbigpe3JldHVybiB0aGlzLmRvbUV2ZW50LmN0cmxLZXl9fSkuY2FsbChzLnByb3RvdHlwZSl9KSxkZWZpbmUoImFjZS9tb3VzZS9kcmFnZHJvcF9oYW5kbGVyIixbInJlcXVpcmUiLCJleHBvcnRzIiwibW9kdWxlIiwiYWNlL2xpYi9kb20iLCJhY2UvbGliL2V2ZW50IiwiYWNlL2xpYi91c2VyYWdlbnQiXSxmdW5jdGlvbihlLHQsbil7InVzZSBzdHJpY3QiO2Z1bmN0aW9uIGYoZSl7ZnVuY3Rpb24gVChlLG4pe3ZhciByPURhdGUubm93KCksaT0hbnx8ZS5yb3chPW4ucm93LHM9IW58fGUuY29sdW1uIT1uLmNvbHVtbjtpZighU3x8aXx8cyl0Lm1vdmVDdXJzb3JUb1Bvc2l0aW9uKGUpLFM9cix4PXt4OnAseTpkfTtlbHNle3ZhciBvPWwoeC54LHgueSxwLGQpO28+YT9TPW51bGw6ci1TPj11JiYodC5yZW5kZXJlci5zY3JvbGxDdXJzb3JJbnRvVmlldygpLFM9bnVsbCl9fWZ1bmN0aW9uIE4oZSxuKXt2YXIgcj1EYXRlLm5vdygpLGk9dC5yZW5kZXJlci5sYXllckNvbmZpZy5saW5lSGVpZ2h0LHM9dC5yZW5kZXJlci5sYXllckNvbmZpZy5jaGFyYWN0ZXJXaWR0aCx1PXQucmVuZGVyZXIuc2Nyb2xsZXIuZ2V0Qm91bmRpbmdDbGllbnRSZWN0KCksYT17eDp7bGVmdDpwLXUubGVmdCxyaWdodDp1LnJpZ2h0LXB9LHk6e3RvcDpkLXUudG9wLGJvdHRvbTp1LmJvdHRvbS1kfX0sZj1NYXRoLm1pbihhLngubGVmdCxhLngucmlnaHQpLGw9TWF0aC5taW4oYS55LnRvcCxhLnkuYm90dG9tKSxjPXtyb3c6ZS5yb3csY29sdW1uOmUuY29sdW1ufTtmL3M8PTImJihjLmNvbHVtbis9YS54LmxlZnQ8YS54LnJpZ2h0Py0zOjIpLGwvaTw9MSYmKGMucm93Kz1hLnkudG9wPGEueS5ib3R0b20/LTE6MSk7dmFyIGg9ZS5yb3chPWMucm93LHY9ZS5jb2x1bW4hPWMuY29sdW1uLG09IW58fGUucm93IT1uLnJvdztofHx2JiYhbT9FP3ItRT49byYmdC5yZW5kZXJlci5zY3JvbGxDdXJzb3JJbnRvVmlldyhjKTpFPXI6RT1udWxsfWZ1bmN0aW9uIEMoKXt2YXIgZT1nO2c9dC5yZW5kZXJlci5zY3JlZW5Ub1RleHRDb29yZGluYXRlcyhwLGQpLFQoZyxlKSxOKGcsZSl9ZnVuY3Rpb24gaygpe209dC5zZWxlY3Rpb24udG9PcmllbnRlZFJhbmdlKCksaD10LnNlc3Npb24uYWRkTWFya2VyKG0sImFjZV9zZWxlY3Rpb24iLHQuZ2V0U2VsZWN0aW9uU3R5bGUoKSksdC5jbGVhclNlbGVjdGlvbigpLHQuaXNGb2N1c2VkKCkmJnQucmVuZGVyZXIuJGN1cnNvckxheWVyLnNldEJsaW5raW5nKCExKSxjbGVhckludGVydmFsKHYpLEMoKSx2PXNldEludGVydmFsKEMsMjApLHk9MCxpLmFkZExpc3RlbmVyKGRvY3VtZW50LCJtb3VzZW1vdmUiLE8pfWZ1bmN0aW9uIEwoKXtjbGVhckludGVydmFsKHYpLHQuc2Vzc2lvbi5yZW1vdmVNYXJrZXIoaCksaD1udWxsLHQuc2VsZWN0aW9uLmZyb21PcmllbnRlZFJhbmdlKG0pLHQuaXNGb2N1c2VkKCkmJiF3JiZ0LiRyZXNldEN1cnNvclN0eWxlKCksbT1udWxsLGc9bnVsbCx5PTAsRT1udWxsLFM9bnVsbCxpLnJlbW92ZUxpc3RlbmVyKGRvY3VtZW50LCJtb3VzZW1vdmUiLE8pfWZ1bmN0aW9uIE8oKXtBPT1udWxsJiYoQT1zZXRUaW1lb3V0KGZ1bmN0aW9uKCl7QSE9bnVsbCYmaCYmTCgpfSwyMCkpfWZ1bmN0aW9uIE0oZSl7dmFyIHQ9ZS50eXBlcztyZXR1cm4hdHx8QXJyYXkucHJvdG90eXBlLnNvbWUuY2FsbCh0LGZ1bmN0aW9uKGUpe3JldHVybiBlPT0idGV4dC9wbGFpbiJ8fGU9PSJUZXh0In0pfWZ1bmN0aW9uIF8oZSl7dmFyIHQ9WyJjb3B5IiwiY29weW1vdmUiLCJhbGwiLCJ1bmluaXRpYWxpemVkIl0sbj1bIm1vdmUiLCJjb3B5bW92ZSIsImxpbmttb3ZlIiwiYWxsIiwidW5pbml0aWFsaXplZCJdLHI9cy5pc01hYz9lLmFsdEtleTplLmN0cmxLZXksaT0idW5pbml0aWFsaXplZCI7dHJ5e2k9ZS5kYXRhVHJhbnNmZXIuZWZmZWN0QWxsb3dlZC50b0xvd2VyQ2FzZSgpfWNhdGNoKGUpe312YXIgbz0ibm9uZSI7cmV0dXJuIHImJnQuaW5kZXhPZihpKT49MD9vPSJjb3B5IjpuLmluZGV4T2YoaSk+PTA/bz0ibW92ZSI6dC5pbmRleE9mKGkpPj0wJiYobz0iY29weSIpLG99dmFyIHQ9ZS5lZGl0b3Isbj1yLmNyZWF0ZUVsZW1lbnQoImRpdiIpO24uc3R5bGUuY3NzVGV4dD0idG9wOi0xMDBweDtwb3NpdGlvbjphYnNvbHV0ZTt6LWluZGV4OjIxNDc0ODM2NDc7b3BhY2l0eTowLjUiLG4udGV4dENvbnRlbnQ9Ilx1MDBhMCI7dmFyIGY9WyJkcmFnV2FpdCIsImRyYWdXYWl0RW5kIiwic3RhcnREcmFnIiwiZHJhZ1JlYWR5RW5kIiwib25Nb3VzZURyYWciXTtmLmZvckVhY2goZnVuY3Rpb24odCl7ZVt0XT10aGlzW3RdfSx0aGlzKSx0Lm9uKCJtb3VzZWRvd24iLHRoaXMub25Nb3VzZURvd24uYmluZChlKSk7dmFyIGM9dC5jb250YWluZXIsaCxwLGQsdixtLGcseT0wLGIsdyxFLFMseDt0aGlzLm9uRHJhZ1N0YXJ0PWZ1bmN0aW9uKGUpe2lmKHRoaXMuY2FuY2VsRHJhZ3x8IWMuZHJhZ2dhYmxlKXt2YXIgcj10aGlzO3JldHVybiBzZXRUaW1lb3V0KGZ1bmN0aW9uKCl7ci5zdGFydFNlbGVjdCgpLHIuY2FwdHVyZU1vdXNlKGUpfSwwKSxlLnByZXZlbnREZWZhdWx0KCl9bT10LmdldFNlbGVjdGlvblJhbmdlKCk7dmFyIGk9ZS5kYXRhVHJhbnNmZXI7aS5lZmZlY3RBbGxvd2VkPXQuZ2V0UmVhZE9ubHkoKT8iY29weSI6ImNvcHlNb3ZlIix0LmNvbnRhaW5lci5hcHBlbmRDaGlsZChuKSxpLnNldERyYWdJbWFnZSYmaS5zZXREcmFnSW1hZ2UobiwwLDApLHNldFRpbWVvdXQoZnVuY3Rpb24oKXt0LmNvbnRhaW5lci5yZW1vdmVDaGlsZChuKX0pLGkuY2xlYXJEYXRhKCksaS5zZXREYXRhKCJUZXh0Iix0LnNlc3Npb24uZ2V0VGV4dFJhbmdlKCkpLHc9ITAsdGhpcy5zZXRTdGF0ZSgiZHJhZyIpfSx0aGlzLm9uRHJhZ0VuZD1mdW5jdGlvbihlKXtjLmRyYWdnYWJsZT0hMSx3PSExLHRoaXMuc2V0U3RhdGUobnVsbCk7aWYoIXQuZ2V0UmVhZE9ubHkoKSl7dmFyIG49ZS5kYXRhVHJhbnNmZXIuZHJvcEVmZmVjdDshYiYmbj09Im1vdmUiJiZ0LnNlc3Npb24ucmVtb3ZlKHQuZ2V0U2VsZWN0aW9uUmFuZ2UoKSksdC4kcmVzZXRDdXJzb3JTdHlsZSgpfXRoaXMuZWRpdG9yLnVuc2V0U3R5bGUoImFjZV9kcmFnZ2luZyIpLHRoaXMuZWRpdG9yLnJlbmRlcmVyLnNldEN1cnNvclN0eWxlKCIiKX0sdGhpcy5vbkRyYWdFbnRlcj1mdW5jdGlvbihlKXtpZih0LmdldFJlYWRPbmx5KCl8fCFNKGUuZGF0YVRyYW5zZmVyKSlyZXR1cm47cmV0dXJuIHA9ZS5jbGllbnRYLGQ9ZS5jbGllbnRZLGh8fGsoKSx5KyssZS5kYXRhVHJhbnNmZXIuZHJvcEVmZmVjdD1iPV8oZSksaS5wcmV2ZW50RGVmYXVsdChlKX0sdGhpcy5vbkRyYWdPdmVyPWZ1bmN0aW9uKGUpe2lmKHQuZ2V0UmVhZE9ubHkoKXx8IU0oZS5kYXRhVHJhbnNmZXIpKXJldHVybjtyZXR1cm4gcD1lLmNsaWVudFgsZD1lLmNsaWVudFksaHx8KGsoKSx5KyspLEEhPT1udWxsJiYoQT1udWxsKSxlLmRhdGFUcmFuc2Zlci5kcm9wRWZmZWN0PWI9XyhlKSxpLnByZXZlbnREZWZhdWx0KGUpfSx0aGlzLm9uRHJhZ0xlYXZlPWZ1bmN0aW9uKGUpe3ktLTtpZih5PD0wJiZoKXJldHVybiBMKCksYj1udWxsLGkucHJldmVudERlZmF1bHQoZSl9LHRoaXMub25Ecm9wPWZ1bmN0aW9uKGUpe2lmKCFnKXJldHVybjt2YXIgbj1lLmRhdGFUcmFuc2ZlcjtpZih3KXN3aXRjaChiKXtjYXNlIm1vdmUiOm0uY29udGFpbnMoZy5yb3csZy5jb2x1bW4pP209e3N0YXJ0OmcsZW5kOmd9Om09dC5tb3ZlVGV4dChtLGcpO2JyZWFrO2Nhc2UiY29weSI6bT10Lm1vdmVUZXh0KG0sZywhMCl9ZWxzZXt2YXIgcj1uLmdldERhdGEoIlRleHQiKTttPXtzdGFydDpnLGVuZDp0LnNlc3Npb24uaW5zZXJ0KGcscil9LHQuZm9jdXMoKSxiPW51bGx9cmV0dXJuIEwoKSxpLnByZXZlbnREZWZhdWx0KGUpfSxpLmFkZExpc3RlbmVyKGMsImRyYWdzdGFydCIsdGhpcy5vbkRyYWdTdGFydC5iaW5kKGUpLHQpLGkuYWRkTGlzdGVuZXIoYywiZHJhZ2VuZCIsdGhpcy5vbkRyYWdFbmQuYmluZChlKSx0KSxpLmFkZExpc3RlbmVyKGMsImRyYWdlbnRlciIsdGhpcy5vbkRyYWdFbnRlci5iaW5kKGUpLHQpLGkuYWRkTGlzdGVuZXIoYywiZHJhZ292ZXIiLHRoaXMub25EcmFnT3Zlci5iaW5kKGUpLHQpLGkuYWRkTGlzdGVuZXIoYywiZHJhZ2xlYXZlIix0aGlzLm9uRHJhZ0xlYXZlLmJpbmQoZSksdCksaS5hZGRMaXN0ZW5lcihjLCJkcm9wIix0aGlzLm9uRHJvcC5iaW5kKGUpLHQpO3ZhciBBPW51bGx9ZnVuY3Rpb24gbChlLHQsbixyKXtyZXR1cm4gTWF0aC5zcXJ0KE1hdGgucG93KG4tZSwyKStNYXRoLnBvdyhyLXQsMikpfXZhciByPWUoIi4uL2xpYi9kb20iKSxpPWUoIi4uL2xpYi9ldmVudCIpLHM9ZSgiLi4vbGliL3VzZXJhZ2VudCIpLG89MjAwLHU9MjAwLGE9NTsoZnVuY3Rpb24oKXt0aGlzLmRyYWdXYWl0PWZ1bmN0aW9uKCl7dmFyIGU9RGF0ZS5ub3coKS10aGlzLm1vdXNlZG93bkV2ZW50LnRpbWU7ZT50aGlzLmVkaXRvci5nZXREcmFnRGVsYXkoKSYmdGhpcy5zdGFydERyYWcoKX0sdGhpcy5kcmFnV2FpdEVuZD1mdW5jdGlvbigpe3ZhciBlPXRoaXMuZWRpdG9yLmNvbnRhaW5lcjtlLmRyYWdnYWJsZT0hMSx0aGlzLnN0YXJ0U2VsZWN0KHRoaXMubW91c2Vkb3duRXZlbnQuZ2V0RG9jdW1lbnRQb3NpdGlvbigpKSx0aGlzLnNlbGVjdEVuZCgpfSx0aGlzLmRyYWdSZWFkeUVuZD1mdW5jdGlvbihlKXt0aGlzLmVkaXRvci4kcmVzZXRDdXJzb3JTdHlsZSgpLHRoaXMuZWRpdG9yLnVuc2V0U3R5bGUoImFjZV9kcmFnZ2luZyIpLHRoaXMuZWRpdG9yLnJlbmRlcmVyLnNldEN1cnNvclN0eWxlKCIiKSx0aGlzLmRyYWdXYWl0RW5kKCl9LHRoaXMuc3RhcnREcmFnPWZ1bmN0aW9uKCl7dGhpcy5jYW5jZWxEcmFnPSExO3ZhciBlPXRoaXMuZWRpdG9yLHQ9ZS5jb250YWluZXI7dC5kcmFnZ2FibGU9ITAsZS5yZW5kZXJlci4kY3Vyc29yTGF5ZXIuc2V0QmxpbmtpbmcoITEpLGUuc2V0U3R5bGUoImFjZV9kcmFnZ2luZyIpO3ZhciBuPXMuaXNXaW4/ImRlZmF1bHQiOiJtb3ZlIjtlLnJlbmRlcmVyLnNldEN1cnNvclN0eWxlKG4pLHRoaXMuc2V0U3RhdGUoImRyYWdSZWFkeSIpfSx0aGlzLm9uTW91c2VEcmFnPWZ1bmN0aW9uKGUpe3ZhciB0PXRoaXMuZWRpdG9yLmNvbnRhaW5lcjtpZihzLmlzSUUmJnRoaXMuc3RhdGU9PSJkcmFnUmVhZHkiKXt2YXIgbj1sKHRoaXMubW91c2Vkb3duRXZlbnQueCx0aGlzLm1vdXNlZG93bkV2ZW50LnksdGhpcy54LHRoaXMueSk7bj4zJiZ0LmRyYWdEcm9wKCl9aWYodGhpcy5zdGF0ZT09PSJkcmFnV2FpdCIpe3ZhciBuPWwodGhpcy5tb3VzZWRvd25FdmVudC54LHRoaXMubW91c2Vkb3duRXZlbnQueSx0aGlzLngsdGhpcy55KTtuPjAmJih0LmRyYWdnYWJsZT0hMSx0aGlzLnN0YXJ0U2VsZWN0KHRoaXMubW91c2Vkb3duRXZlbnQuZ2V0RG9jdW1lbnRQb3NpdGlvbigpKSl9fSx0aGlzLm9uTW91c2VEb3duPWZ1bmN0aW9uKGUpe2lmKCF0aGlzLiRkcmFnRW5hYmxlZClyZXR1cm47dGhpcy5tb3VzZWRvd25FdmVudD1lO3ZhciB0PXRoaXMuZWRpdG9yLG49ZS5pblNlbGVjdGlvbigpLHI9ZS5nZXRCdXR0b24oKSxpPWUuZG9tRXZlbnQuZGV0YWlsfHwxO2lmKGk9PT0xJiZyPT09MCYmbil7aWYoZS5lZGl0b3IuaW5NdWx0aVNlbGVjdE1vZGUmJihlLmdldEFjY2VsS2V5KCl8fGUuZ2V0U2hpZnRLZXkoKSkpcmV0dXJuO3RoaXMubW91c2Vkb3duRXZlbnQudGltZT1EYXRlLm5vdygpO3ZhciBvPWUuZG9tRXZlbnQudGFyZ2V0fHxlLmRvbUV2ZW50LnNyY0VsZW1lbnQ7InVuc2VsZWN0YWJsZSJpbiBvJiYoby51bnNlbGVjdGFibGU9Im9uIik7aWYodC5nZXREcmFnRGVsYXkoKSl7aWYocy5pc1dlYktpdCl7dGhpcy5jYW5jZWxEcmFnPSEwO3ZhciB1PXQuY29udGFpbmVyO3UuZHJhZ2dhYmxlPSEwfXRoaXMuc2V0U3RhdGUoImRyYWdXYWl0Iil9ZWxzZSB0aGlzLnN0YXJ0RHJhZygpO3RoaXMuY2FwdHVyZU1vdXNlKGUsdGhpcy5vbk1vdXNlRHJhZy5iaW5kKHRoaXMpKSxlLmRlZmF1bHRQcmV2ZW50ZWQ9ITB9fX0pLmNhbGwoZi5wcm90b3R5cGUpLHQuRHJhZ2Ryb3BIYW5kbGVyPWZ9KSxkZWZpbmUoImFjZS9tb3VzZS90b3VjaF9oYW5kbGVyIixbInJlcXVpcmUiLCJleHBvcnRzIiwibW9kdWxlIiwiYWNlL21vdXNlL21vdXNlX2V2ZW50IiwiYWNlL2xpYi9ldmVudCIsImFjZS9saWIvZG9tIl0sZnVuY3Rpb24oZSx0LG4peyJ1c2Ugc3RyaWN0Ijt2YXIgcj1lKCIuL21vdXNlX2V2ZW50IikuTW91c2VFdmVudCxpPWUoIi4uL2xpYi9ldmVudCIpLHM9ZSgiLi4vbGliL2RvbSIpO3QuYWRkVG91Y2hMaXN0ZW5lcnM9ZnVuY3Rpb24oZSx0KXtmdW5jdGlvbiBiKCl7dmFyIGU9d2luZG93Lm5hdmlnYXRvciYmd2luZG93Lm5hdmlnYXRvci5jbGlwYm9hcmQscj0hMSxpPWZ1bmN0aW9uKCl7dmFyIG49dC5nZXRDb3B5VGV4dCgpLGk9dC5zZXNzaW9uLmdldFVuZG9NYW5hZ2VyKCkuaGFzVW5kbygpO3kucmVwbGFjZUNoaWxkKHMuYnVpbGREb20ocj9bInNwYW4iLCFuJiZbInNwYW4iLHsiY2xhc3MiOiJhY2VfbW9iaWxlLWJ1dHRvbiIsYWN0aW9uOiJzZWxlY3RhbGwifSwiU2VsZWN0IEFsbCJdLG4mJlsic3BhbiIseyJjbGFzcyI6ImFjZV9tb2JpbGUtYnV0dG9uIixhY3Rpb246ImNvcHkifSwiQ29weSJdLG4mJlsic3BhbiIseyJjbGFzcyI6ImFjZV9tb2JpbGUtYnV0dG9uIixhY3Rpb246ImN1dCJ9LCJDdXQiXSxlJiZbInNwYW4iLHsiY2xhc3MiOiJhY2VfbW9iaWxlLWJ1dHRvbiIsYWN0aW9uOiJwYXN0ZSJ9LCJQYXN0ZSJdLGkmJlsic3BhbiIseyJjbGFzcyI6ImFjZV9tb2JpbGUtYnV0dG9uIixhY3Rpb246InVuZG8ifSwiVW5kbyJdLFsic3BhbiIseyJjbGFzcyI6ImFjZV9tb2JpbGUtYnV0dG9uIixhY3Rpb246ImZpbmQifSwiRmluZCJdLFsic3BhbiIseyJjbGFzcyI6ImFjZV9tb2JpbGUtYnV0dG9uIixhY3Rpb246Im9wZW5Db21tYW5kUGFsbGV0ZSJ9LCJQYWxldHRlIl1dOlsic3BhbiJdKSx5LmZpcnN0Q2hpbGQpfSxvPWZ1bmN0aW9uKG4pe3ZhciBzPW4udGFyZ2V0LmdldEF0dHJpYnV0ZSgiYWN0aW9uIik7aWYocz09Im1vcmUifHwhcilyZXR1cm4gcj0hcixpKCk7aWYocz09InBhc3RlIillLnJlYWRUZXh0KCkudGhlbihmdW5jdGlvbihlKXt0LmV4ZWNDb21tYW5kKHMsZSl9KTtlbHNlIGlmKHMpe2lmKHM9PSJjdXQifHxzPT0iY29weSIpZT9lLndyaXRlVGV4dCh0LmdldENvcHlUZXh0KCkpOmRvY3VtZW50LmV4ZWNDb21tYW5kKCJjb3B5Iik7dC5leGVjQ29tbWFuZChzKX15LmZpcnN0Q2hpbGQuc3R5bGUuZGlzcGxheT0ibm9uZSIscj0hMSxzIT0ib3BlbkNvbW1hbmRQYWxsZXRlIiYmdC5mb2N1cygpfTt5PXMuYnVpbGREb20oWyJkaXYiLHsiY2xhc3MiOiJhY2VfbW9iaWxlLW1lbnUiLG9udG91Y2hzdGFydDpmdW5jdGlvbihlKXtuPSJtZW51IixlLnN0b3BQcm9wYWdhdGlvbigpLGUucHJldmVudERlZmF1bHQoKSx0LnRleHRJbnB1dC5mb2N1cygpfSxvbnRvdWNoZW5kOmZ1bmN0aW9uKGUpe2Uuc3RvcFByb3BhZ2F0aW9uKCksZS5wcmV2ZW50RGVmYXVsdCgpLG8oZSl9LG9uY2xpY2s6b30sWyJzcGFuIl0sWyJzcGFuIix7ImNsYXNzIjoiYWNlX21vYmlsZS1idXR0b24iLGFjdGlvbjoibW9yZSJ9LCIuLi4iXV0sdC5jb250YWluZXIpfWZ1bmN0aW9uIHcoKXt5fHxiKCk7dmFyIGU9dC5zZWxlY3Rpb24uY3Vyc29yLG49dC5yZW5kZXJlci50ZXh0VG9TY3JlZW5Db29yZGluYXRlcyhlLnJvdyxlLmNvbHVtbikscj10LnJlbmRlcmVyLnRleHRUb1NjcmVlbkNvb3JkaW5hdGVzKDAsMCkucGFnZVgsaT10LnJlbmRlcmVyLnNjcm9sbExlZnQscz10LmNvbnRhaW5lci5nZXRCb3VuZGluZ0NsaWVudFJlY3QoKTt5LnN0eWxlLnRvcD1uLnBhZ2VZLXMudG9wLTMrInB4IixuLnBhZ2VYLXMubGVmdDxzLndpZHRoLTcwPyh5LnN0eWxlLmxlZnQ9IiIseS5zdHlsZS5yaWdodD0iMTBweCIpOih5LnN0eWxlLnJpZ2h0PSIiLHkuc3R5bGUubGVmdD1yK2ktcy5sZWZ0KyJweCIpLHkuc3R5bGUuZGlzcGxheT0iIix5LmZpcnN0Q2hpbGQuc3R5bGUuZGlzcGxheT0ibm9uZSIsdC5vbigiaW5wdXQiLEUpfWZ1bmN0aW9uIEUoZSl7eSYmKHkuc3R5bGUuZGlzcGxheT0ibm9uZSIpLHQub2ZmKCJpbnB1dCIsRSl9ZnVuY3Rpb24gUygpe2w9bnVsbCxjbGVhclRpbWVvdXQobCk7dmFyIGU9dC5zZWxlY3Rpb24uZ2V0UmFuZ2UoKSxyPWUuY29udGFpbnMocC5yb3cscC5jb2x1bW4pO2lmKGUuaXNFbXB0eSgpfHwhcil0LnNlbGVjdGlvbi5tb3ZlVG9Qb3NpdGlvbihwKSx0LnNlbGVjdGlvbi5zZWxlY3RXb3JkKCk7bj0id2FpdCIsdygpfWZ1bmN0aW9uIHgoKXtsPW51bGwsY2xlYXJUaW1lb3V0KGwpLHQuc2VsZWN0aW9uLm1vdmVUb1Bvc2l0aW9uKHApO3ZhciBlPWQ+PTI/dC5zZWxlY3Rpb24uZ2V0TGluZVJhbmdlKHAucm93KTp0LnNlc3Npb24uZ2V0QnJhY2tldFJhbmdlKHApO2UmJiFlLmlzRW1wdHkoKT90LnNlbGVjdGlvbi5zZXRSYW5nZShlKTp0LnNlbGVjdGlvbi5zZWxlY3RXb3JkKCksbj0id2FpdCJ9ZnVuY3Rpb24gVCgpe2grPTYwLGM9c2V0SW50ZXJ2YWwoZnVuY3Rpb24oKXtoLS08PTAmJihjbGVhckludGVydmFsKGMpLGM9bnVsbCksTWF0aC5hYnModik8LjAxJiYodj0wKSxNYXRoLmFicyhtKTwuMDEmJihtPTApLGg8MjAmJih2PS45KnYpLGg8MjAmJihtPS45Km0pO3ZhciBlPXQuc2Vzc2lvbi5nZXRTY3JvbGxUb3AoKTt0LnJlbmRlcmVyLnNjcm9sbEJ5KDEwKnYsMTAqbSksZT09dC5zZXNzaW9uLmdldFNjcm9sbFRvcCgpJiYoaD0wKX0sMTApfXZhciBuPSJzY3JvbGwiLG8sdSxhLGYsbCxjLGg9MCxwLGQ9MCx2PTAsbT0wLGcseTtpLmFkZExpc3RlbmVyKGUsImNvbnRleHRtZW51IixmdW5jdGlvbihlKXtpZighZylyZXR1cm47dmFyIG49dC50ZXh0SW5wdXQuZ2V0RWxlbWVudCgpO24uZm9jdXMoKX0sdCksaS5hZGRMaXN0ZW5lcihlLCJ0b3VjaHN0YXJ0IixmdW5jdGlvbihlKXt2YXIgaT1lLnRvdWNoZXM7aWYobHx8aS5sZW5ndGg+MSl7Y2xlYXJUaW1lb3V0KGwpLGw9bnVsbCxhPS0xLG49Inpvb20iO3JldHVybn1nPXQuJG1vdXNlSGFuZGxlci5pc01vdXNlUHJlc3NlZD0hMDt2YXIgcz10LnJlbmRlcmVyLmxheWVyQ29uZmlnLmxpbmVIZWlnaHQsYz10LnJlbmRlcmVyLmxheWVyQ29uZmlnLmxpbmVIZWlnaHQseT1lLnRpbWVTdGFtcDtmPXk7dmFyIGI9aVswXSx3PWIuY2xpZW50WCxFPWIuY2xpZW50WTtNYXRoLmFicyhvLXcpK01hdGguYWJzKHUtRSk+cyYmKGE9LTEpLG89ZS5jbGllbnRYPXcsdT1lLmNsaWVudFk9RSx2PW09MDt2YXIgVD1uZXcgcihlLHQpO3A9VC5nZXREb2N1bWVudFBvc2l0aW9uKCk7aWYoeS1hPDUwMCYmaS5sZW5ndGg9PTEmJiFoKWQrKyxlLnByZXZlbnREZWZhdWx0KCksZS5idXR0b249MCx4KCk7ZWxzZXtkPTA7dmFyIE49dC5zZWxlY3Rpb24uY3Vyc29yLEM9dC5zZWxlY3Rpb24uaXNFbXB0eSgpP046dC5zZWxlY3Rpb24uYW5jaG9yLGs9dC5yZW5kZXJlci4kY3Vyc29yTGF5ZXIuZ2V0UGl4ZWxQb3NpdGlvbihOLCEwKSxMPXQucmVuZGVyZXIuJGN1cnNvckxheWVyLmdldFBpeGVsUG9zaXRpb24oQywhMCksQT10LnJlbmRlcmVyLnNjcm9sbGVyLmdldEJvdW5kaW5nQ2xpZW50UmVjdCgpLE89dC5yZW5kZXJlci5sYXllckNvbmZpZy5vZmZzZXQsTT10LnJlbmRlcmVyLnNjcm9sbExlZnQsXz1mdW5jdGlvbihlLHQpe3JldHVybiBlLz1jLHQ9dC9zLS43NSxlKmUrdCp0fTtpZihlLmNsaWVudFg8QS5sZWZ0KXtuPSJ6b29tIjtyZXR1cm59dmFyIEQ9XyhlLmNsaWVudFgtQS5sZWZ0LWsubGVmdCtNLGUuY2xpZW50WS1BLnRvcC1rLnRvcCtPKSxQPV8oZS5jbGllbnRYLUEubGVmdC1MLmxlZnQrTSxlLmNsaWVudFktQS50b3AtTC50b3ArTyk7RDwzLjUmJlA8My41JiYobj1EPlA/ImN1cnNvciI6ImFuY2hvciIpLFA8My41P249ImFuY2hvciI6RDwzLjU/bj0iY3Vyc29yIjpuPSJzY3JvbGwiLGw9c2V0VGltZW91dChTLDQ1MCl9YT15fSx0KSxpLmFkZExpc3RlbmVyKGUsInRvdWNoZW5kIixmdW5jdGlvbihlKXtnPXQuJG1vdXNlSGFuZGxlci5pc01vdXNlUHJlc3NlZD0hMSxjJiZjbGVhckludGVydmFsKGMpLG49PSJ6b29tIj8obj0iIixoPTApOmw/KHQuc2VsZWN0aW9uLm1vdmVUb1Bvc2l0aW9uKHApLGg9MCx3KCkpOm49PSJzY3JvbGwiPyhUKCksRSgpKTp3KCksY2xlYXJUaW1lb3V0KGwpLGw9bnVsbH0sdCksaS5hZGRMaXN0ZW5lcihlLCJ0b3VjaG1vdmUiLGZ1bmN0aW9uKGUpe2wmJihjbGVhclRpbWVvdXQobCksbD1udWxsKTt2YXIgaT1lLnRvdWNoZXM7aWYoaS5sZW5ndGg+MXx8bj09Inpvb20iKXJldHVybjt2YXIgcz1pWzBdLGE9by1zLmNsaWVudFgsYz11LXMuY2xpZW50WTtpZihuPT0id2FpdCIpe2lmKCEoYSphK2MqYz40KSlyZXR1cm4gZS5wcmV2ZW50RGVmYXVsdCgpO249ImN1cnNvciJ9bz1zLmNsaWVudFgsdT1zLmNsaWVudFksZS5jbGllbnRYPXMuY2xpZW50WCxlLmNsaWVudFk9cy5jbGllbnRZO3ZhciBoPWUudGltZVN0YW1wLHA9aC1mO2Y9aDtpZihuPT0ic2Nyb2xsIil7dmFyIGQ9bmV3IHIoZSx0KTtkLnNwZWVkPTEsZC53aGVlbFg9YSxkLndoZWVsWT1jLDEwKk1hdGguYWJzKGEpPE1hdGguYWJzKGMpJiYoYT0wKSwxMCpNYXRoLmFicyhjKTxNYXRoLmFicyhhKSYmKGM9MCkscCE9MCYmKHY9YS9wLG09Yy9wKSx0Ll9lbWl0KCJtb3VzZXdoZWVsIixkKSxkLnByb3BhZ2F0aW9uU3RvcHBlZHx8KHY9bT0wKX1lbHNle3ZhciBnPW5ldyByKGUsdCkseT1nLmdldERvY3VtZW50UG9zaXRpb24oKTtuPT0iY3Vyc29yIj90LnNlbGVjdGlvbi5tb3ZlQ3Vyc29yVG9Qb3NpdGlvbih5KTpuPT0iYW5jaG9yIiYmdC5zZWxlY3Rpb24uc2V0U2VsZWN0aW9uQW5jaG9yKHkucm93LHkuY29sdW1uKSx0LnJlbmRlcmVyLnNjcm9sbEN1cnNvckludG9WaWV3KHkpLGUucHJldmVudERlZmF1bHQoKX19LHQpfX0pLGRlZmluZSgiYWNlL21vdXNlL21vdXNlX2hhbmRsZXIiLFsicmVxdWlyZSIsImV4cG9ydHMiLCJtb2R1bGUiLCJhY2UvbGliL2V2ZW50IiwiYWNlL2xpYi91c2VyYWdlbnQiLCJhY2UvbW91c2UvZGVmYXVsdF9oYW5kbGVycyIsImFjZS9tb3VzZS9kZWZhdWx0X2d1dHRlcl9oYW5kbGVyIiwiYWNlL21vdXNlL21vdXNlX2V2ZW50IiwiYWNlL21vdXNlL2RyYWdkcm9wX2hhbmRsZXIiLCJhY2UvbW91c2UvdG91Y2hfaGFuZGxlciIsImFjZS9jb25maWciXSxmdW5jdGlvbihlLHQsbil7InVzZSBzdHJpY3QiO3ZhciByPWUoIi4uL2xpYi9ldmVudCIpLGk9ZSgiLi4vbGliL3VzZXJhZ2VudCIpLHM9ZSgiLi9kZWZhdWx0X2hhbmRsZXJzIikuRGVmYXVsdEhhbmRsZXJzLG89ZSgiLi9kZWZhdWx0X2d1dHRlcl9oYW5kbGVyIikuR3V0dGVySGFuZGxlcix1PWUoIi4vbW91c2VfZXZlbnQiKS5Nb3VzZUV2ZW50LGE9ZSgiLi9kcmFnZHJvcF9oYW5kbGVyIikuRHJhZ2Ryb3BIYW5kbGVyLGY9ZSgiLi90b3VjaF9oYW5kbGVyIikuYWRkVG91Y2hMaXN0ZW5lcnMsbD1lKCIuLi9jb25maWciKSxjPWZ1bmN0aW9uKGUpe3ZhciB0PXRoaXM7dGhpcy5lZGl0b3I9ZSxuZXcgcyh0aGlzKSxuZXcgbyh0aGlzKSxuZXcgYSh0aGlzKTt2YXIgbj1mdW5jdGlvbih0KXt2YXIgbj0hZG9jdW1lbnQuaGFzRm9jdXN8fCFkb2N1bWVudC5oYXNGb2N1cygpfHwhZS5pc0ZvY3VzZWQoKSYmZG9jdW1lbnQuYWN0aXZlRWxlbWVudD09KGUudGV4dElucHV0JiZlLnRleHRJbnB1dC5nZXRFbGVtZW50KCkpO24mJndpbmRvdy5mb2N1cygpLGUuZm9jdXMoKSxzZXRUaW1lb3V0KGZ1bmN0aW9uKCl7ZS5pc0ZvY3VzZWQoKXx8ZS5mb2N1cygpfSl9LHU9ZS5yZW5kZXJlci5nZXRNb3VzZUV2ZW50VGFyZ2V0KCk7ci5hZGRMaXN0ZW5lcih1LCJjbGljayIsdGhpcy5vbk1vdXNlRXZlbnQuYmluZCh0aGlzLCJjbGljayIpLGUpLHIuYWRkTGlzdGVuZXIodSwibW91c2Vtb3ZlIix0aGlzLm9uTW91c2VNb3ZlLmJpbmQodGhpcywibW91c2Vtb3ZlIiksZSksci5hZGRNdWx0aU1vdXNlRG93bkxpc3RlbmVyKFt1LGUucmVuZGVyZXIuc2Nyb2xsQmFyViYmZS5yZW5kZXJlci5zY3JvbGxCYXJWLmlubmVyLGUucmVuZGVyZXIuc2Nyb2xsQmFySCYmZS5yZW5kZXJlci5zY3JvbGxCYXJILmlubmVyLGUudGV4dElucHV0JiZlLnRleHRJbnB1dC5nZXRFbGVtZW50KCldLmZpbHRlcihCb29sZWFuKSxbNDAwLDMwMCwyNTBdLHRoaXMsIm9uTW91c2VFdmVudCIsZSksci5hZGRNb3VzZVdoZWVsTGlzdGVuZXIoZS5jb250YWluZXIsdGhpcy5vbk1vdXNlV2hlZWwuYmluZCh0aGlzLCJtb3VzZXdoZWVsIiksZSksZihlLmNvbnRhaW5lcixlKTt2YXIgbD1lLnJlbmRlcmVyLiRndXR0ZXI7ci5hZGRMaXN0ZW5lcihsLCJtb3VzZWRvd24iLHRoaXMub25Nb3VzZUV2ZW50LmJpbmQodGhpcywiZ3V0dGVybW91c2Vkb3duIiksZSksci5hZGRMaXN0ZW5lcihsLCJjbGljayIsdGhpcy5vbk1vdXNlRXZlbnQuYmluZCh0aGlzLCJndXR0ZXJjbGljayIpLGUpLHIuYWRkTGlzdGVuZXIobCwiZGJsY2xpY2siLHRoaXMub25Nb3VzZUV2ZW50LmJpbmQodGhpcywiZ3V0dGVyZGJsY2xpY2siKSxlKSxyLmFkZExpc3RlbmVyKGwsIm1vdXNlbW92ZSIsdGhpcy5vbk1vdXNlRXZlbnQuYmluZCh0aGlzLCJndXR0ZXJtb3VzZW1vdmUiKSxlKSxyLmFkZExpc3RlbmVyKHUsIm1vdXNlZG93biIsbixlKSxyLmFkZExpc3RlbmVyKGwsIm1vdXNlZG93biIsbixlKSxpLmlzSUUmJmUucmVuZGVyZXIuc2Nyb2xsQmFyViYmKHIuYWRkTGlzdGVuZXIoZS5yZW5kZXJlci5zY3JvbGxCYXJWLmVsZW1lbnQsIm1vdXNlZG93biIsbixlKSxyLmFkZExpc3RlbmVyKGUucmVuZGVyZXIuc2Nyb2xsQmFySC5lbGVtZW50LCJtb3VzZWRvd24iLG4sZSkpLGUub24oIm1vdXNlbW92ZSIsZnVuY3Rpb24obil7aWYodC5zdGF0ZXx8dC4kZHJhZ0RlbGF5fHwhdC4kZHJhZ0VuYWJsZWQpcmV0dXJuO3ZhciByPWUucmVuZGVyZXIuc2NyZWVuVG9UZXh0Q29vcmRpbmF0ZXMobi54LG4ueSksaT1lLnNlc3Npb24uc2VsZWN0aW9uLmdldFJhbmdlKCkscz1lLnJlbmRlcmVyOyFpLmlzRW1wdHkoKSYmaS5pbnNpZGVTdGFydChyLnJvdyxyLmNvbHVtbik/cy5zZXRDdXJzb3JTdHlsZSgiZGVmYXVsdCIpOnMuc2V0Q3Vyc29yU3R5bGUoIiIpfSxlKX07KGZ1bmN0aW9uKCl7dGhpcy5vbk1vdXNlRXZlbnQ9ZnVuY3Rpb24oZSx0KXtpZighdGhpcy5lZGl0b3Iuc2Vzc2lvbilyZXR1cm47dGhpcy5lZGl0b3IuX2VtaXQoZSxuZXcgdSh0LHRoaXMuZWRpdG9yKSl9LHRoaXMub25Nb3VzZU1vdmU9ZnVuY3Rpb24oZSx0KXt2YXIgbj10aGlzLmVkaXRvci5fZXZlbnRSZWdpc3RyeSYmdGhpcy5lZGl0b3IuX2V2ZW50UmVnaXN0cnkubW91c2Vtb3ZlO2lmKCFufHwhbi5sZW5ndGgpcmV0dXJuO3RoaXMuZWRpdG9yLl9lbWl0KGUsbmV3IHUodCx0aGlzLmVkaXRvcikpfSx0aGlzLm9uTW91c2VXaGVlbD1mdW5jdGlvbihlLHQpe3ZhciBuPW5ldyB1KHQsdGhpcy5lZGl0b3IpO24uc3BlZWQ9dGhpcy4kc2Nyb2xsU3BlZWQqMixuLndoZWVsWD10LndoZWVsWCxuLndoZWVsWT10LndoZWVsWSx0aGlzLmVkaXRvci5fZW1pdChlLG4pfSx0aGlzLnNldFN0YXRlPWZ1bmN0aW9uKGUpe3RoaXMuc3RhdGU9ZX0sdGhpcy5jYXB0dXJlTW91c2U9ZnVuY3Rpb24oZSx0KXt0aGlzLng9ZS54LHRoaXMueT1lLnksdGhpcy5pc01vdXNlUHJlc3NlZD0hMDt2YXIgbj10aGlzLmVkaXRvcixzPXRoaXMuZWRpdG9yLnJlbmRlcmVyO3MuJGlzTW91c2VQcmVzc2VkPSEwO3ZhciBvPXRoaXMsYT1mdW5jdGlvbihlKXtpZighZSlyZXR1cm47aWYoaS5pc1dlYktpdCYmIWUud2hpY2gmJm8ucmVsZWFzZU1vdXNlKXJldHVybiBvLnJlbGVhc2VNb3VzZSgpO28ueD1lLmNsaWVudFgsby55PWUuY2xpZW50WSx0JiZ0KGUpLG8ubW91c2VFdmVudD1uZXcgdShlLG8uZWRpdG9yKSxvLiRtb3VzZU1vdmVkPSEwfSxmPWZ1bmN0aW9uKGUpe24ub2ZmKCJiZWZvcmVFbmRPcGVyYXRpb24iLGMpLGNsZWFySW50ZXJ2YWwoaCksbi5zZXNzaW9uJiZsKCksb1tvLnN0YXRlKyJFbmQiXSYmb1tvLnN0YXRlKyJFbmQiXShlKSxvLnN0YXRlPSIiLG8uaXNNb3VzZVByZXNzZWQ9cy4kaXNNb3VzZVByZXNzZWQ9ITEscy4ka2VlcFRleHRBcmVhQXRDdXJzb3ImJnMuJG1vdmVUZXh0QXJlYVRvQ3Vyc29yKCksby4kb25DYXB0dXJlTW91c2VNb3ZlPW8ucmVsZWFzZU1vdXNlPW51bGwsZSYmby5vbk1vdXNlRXZlbnQoIm1vdXNldXAiLGUpLG4uZW5kT3BlcmF0aW9uKCl9LGw9ZnVuY3Rpb24oKXtvW28uc3RhdGVdJiZvW28uc3RhdGVdKCksby4kbW91c2VNb3ZlZD0hMX07aWYoaS5pc09sZElFJiZlLmRvbUV2ZW50LnR5cGU9PSJkYmxjbGljayIpcmV0dXJuIHNldFRpbWVvdXQoZnVuY3Rpb24oKXtmKGUpfSk7dmFyIGM9ZnVuY3Rpb24oZSl7aWYoIW8ucmVsZWFzZU1vdXNlKXJldHVybjtuLmN1ck9wLmNvbW1hbmQubmFtZSYmbi5jdXJPcC5zZWxlY3Rpb25DaGFuZ2VkJiYob1tvLnN0YXRlKyJFbmQiXSYmb1tvLnN0YXRlKyJFbmQiXSgpLG8uc3RhdGU9IiIsby5yZWxlYXNlTW91c2UoKSl9O24ub24oImJlZm9yZUVuZE9wZXJhdGlvbiIsYyksbi5zdGFydE9wZXJhdGlvbih7Y29tbWFuZDp7bmFtZToibW91c2UifX0pLG8uJG9uQ2FwdHVyZU1vdXNlTW92ZT1hLG8ucmVsZWFzZU1vdXNlPXIuY2FwdHVyZSh0aGlzLmVkaXRvci5jb250YWluZXIsYSxmKTt2YXIgaD1zZXRJbnRlcnZhbChsLDIwKX0sdGhpcy5yZWxlYXNlTW91c2U9bnVsbCx0aGlzLmNhbmNlbENvbnRleHRNZW51PWZ1bmN0aW9uKCl7dmFyIGU9ZnVuY3Rpb24odCl7aWYodCYmdC5kb21FdmVudCYmdC5kb21FdmVudC50eXBlIT0iY29udGV4dG1lbnUiKXJldHVybjt0aGlzLmVkaXRvci5vZmYoIm5hdGl2ZWNvbnRleHRtZW51IixlKSx0JiZ0LmRvbUV2ZW50JiZyLnN0b3BFdmVudCh0LmRvbUV2ZW50KX0uYmluZCh0aGlzKTtzZXRUaW1lb3V0KGUsMTApLHRoaXMuZWRpdG9yLm9uKCJuYXRpdmVjb250ZXh0bWVudSIsZSl9LHRoaXMuZGVzdHJveT1mdW5jdGlvbigpe3RoaXMucmVsZWFzZU1vdXNlJiZ0aGlzLnJlbGVhc2VNb3VzZSgpfX0pLmNhbGwoYy5wcm90b3R5cGUpLGwuZGVmaW5lT3B0aW9ucyhjLnByb3RvdHlwZSwibW91c2VIYW5kbGVyIix7c2Nyb2xsU3BlZWQ6e2luaXRpYWxWYWx1ZToyfSxkcmFnRGVsYXk6e2luaXRpYWxWYWx1ZTppLmlzTWFjPzE1MDowfSxkcmFnRW5hYmxlZDp7aW5pdGlhbFZhbHVlOiEwfSxmb2N1c1RpbWVvdXQ6e2luaXRpYWxWYWx1ZTowfSx0b29sdGlwRm9sbG93c01vdXNlOntpbml0aWFsVmFsdWU6ITB9fSksdC5Nb3VzZUhhbmRsZXI9Y30pLGRlZmluZSgiYWNlL21vdXNlL2ZvbGRfaGFuZGxlciIsWyJyZXF1aXJlIiwiZXhwb3J0cyIsIm1vZHVsZSIsImFjZS9saWIvZG9tIl0sZnVuY3Rpb24oZSx0LG4peyJ1c2Ugc3RyaWN0IjtmdW5jdGlvbiBpKGUpe2Uub24oImNsaWNrIixmdW5jdGlvbih0KXt2YXIgbj10LmdldERvY3VtZW50UG9zaXRpb24oKSxpPWUuc2Vzc2lvbixzPWkuZ2V0Rm9sZEF0KG4ucm93LG4uY29sdW1uLDEpO3MmJih0LmdldEFjY2VsS2V5KCk/aS5yZW1vdmVGb2xkKHMpOmkuZXhwYW5kRm9sZChzKSx0LnN0b3AoKSk7dmFyIG89dC5kb21FdmVudCYmdC5kb21FdmVudC50YXJnZXQ7byYmci5oYXNDc3NDbGFzcyhvLCJhY2VfaW5saW5lX2J1dHRvbiIpJiZyLmhhc0Nzc0NsYXNzKG8sImFjZV90b2dnbGVfd3JhcCIpJiYoaS5zZXRPcHRpb24oIndyYXAiLCFpLmdldFVzZVdyYXBNb2RlKCkpLGUucmVuZGVyZXIuc2Nyb2xsQ3Vyc29ySW50b1ZpZXcoKSl9KSxlLm9uKCJndXR0ZXJjbGljayIsZnVuY3Rpb24odCl7dmFyIG49ZS5yZW5kZXJlci4kZ3V0dGVyTGF5ZXIuZ2V0UmVnaW9uKHQpO2lmKG49PSJmb2xkV2lkZ2V0cyIpe3ZhciByPXQuZ2V0RG9jdW1lbnRQb3NpdGlvbigpLnJvdyxpPWUuc2Vzc2lvbjtpLmZvbGRXaWRnZXRzJiZpLmZvbGRXaWRnZXRzW3JdJiZlLnNlc3Npb24ub25Gb2xkV2lkZ2V0Q2xpY2socix0KSxlLmlzRm9jdXNlZCgpfHxlLmZvY3VzKCksdC5zdG9wKCl9fSksZS5vbigiZ3V0dGVyZGJsY2xpY2siLGZ1bmN0aW9uKHQpe3ZhciBuPWUucmVuZGVyZXIuJGd1dHRlckxheWVyLmdldFJlZ2lvbih0KTtpZihuPT0iZm9sZFdpZGdldHMiKXt2YXIgcj10LmdldERvY3VtZW50UG9zaXRpb24oKS5yb3csaT1lLnNlc3Npb24scz1pLmdldFBhcmVudEZvbGRSYW5nZURhdGEociwhMCksbz1zLnJhbmdlfHxzLmZpcnN0UmFuZ2U7aWYobyl7cj1vLnN0YXJ0LnJvdzt2YXIgdT1pLmdldEZvbGRBdChyLGkuZ2V0TGluZShyKS5sZW5ndGgsMSk7dT9pLnJlbW92ZUZvbGQodSk6KGkuYWRkRm9sZCgiLi4uIixvKSxlLnJlbmRlcmVyLnNjcm9sbEN1cnNvckludG9WaWV3KHtyb3c6by5zdGFydC5yb3csY29sdW1uOjB9KSl9dC5zdG9wKCl9fSl9dmFyIHI9ZSgiLi4vbGliL2RvbSIpO3QuRm9sZEhhbmRsZXI9aX0pLGRlZmluZSgiYWNlL2tleWJvYXJkL2tleWJpbmRpbmciLFsicmVxdWlyZSIsImV4cG9ydHMiLCJtb2R1bGUiLCJhY2UvbGliL2tleXMiLCJhY2UvbGliL2V2ZW50Il0sZnVuY3Rpb24oZSx0LG4peyJ1c2Ugc3RyaWN0Ijt2YXIgcj1lKCIuLi9saWIva2V5cyIpLGk9ZSgiLi4vbGliL2V2ZW50Iikscz1mdW5jdGlvbihlKXt0aGlzLiRlZGl0b3I9ZSx0aGlzLiRkYXRhPXtlZGl0b3I6ZX0sdGhpcy4kaGFuZGxlcnM9W10sdGhpcy5zZXREZWZhdWx0SGFuZGxlcihlLmNvbW1hbmRzKX07KGZ1bmN0aW9uKCl7dGhpcy5zZXREZWZhdWx0SGFuZGxlcj1mdW5jdGlvbihlKXt0aGlzLnJlbW92ZUtleWJvYXJkSGFuZGxlcih0aGlzLiRkZWZhdWx0SGFuZGxlciksdGhpcy4kZGVmYXVsdEhhbmRsZXI9ZSx0aGlzLmFkZEtleWJvYXJkSGFuZGxlcihlLDApfSx0aGlzLnNldEtleWJvYXJkSGFuZGxlcj1mdW5jdGlvbihlKXt2YXIgdD10aGlzLiRoYW5kbGVycztpZih0W3QubGVuZ3RoLTFdPT1lKXJldHVybjt3aGlsZSh0W3QubGVuZ3RoLTFdJiZ0W3QubGVuZ3RoLTFdIT10aGlzLiRkZWZhdWx0SGFuZGxlcil0aGlzLnJlbW92ZUtleWJvYXJkSGFuZGxlcih0W3QubGVuZ3RoLTFdKTt0aGlzLmFkZEtleWJvYXJkSGFuZGxlcihlLDEpfSx0aGlzLmFkZEtleWJvYXJkSGFuZGxlcj1mdW5jdGlvbihlLHQpe2lmKCFlKXJldHVybjt0eXBlb2YgZT09ImZ1bmN0aW9uIiYmIWUuaGFuZGxlS2V5Ym9hcmQmJihlLmhhbmRsZUtleWJvYXJkPWUpO3ZhciBuPXRoaXMuJGhhbmRsZXJzLmluZGV4T2YoZSk7biE9LTEmJnRoaXMuJGhhbmRsZXJzLnNwbGljZShuLDEpLHQ9PXVuZGVmaW5lZD90aGlzLiRoYW5kbGVycy5wdXNoKGUpOnRoaXMuJGhhbmRsZXJzLnNwbGljZSh0LDAsZSksbj09LTEmJmUuYXR0YWNoJiZlLmF0dGFjaCh0aGlzLiRlZGl0b3IpfSx0aGlzLnJlbW92ZUtleWJvYXJkSGFuZGxlcj1mdW5jdGlvbihlKXt2YXIgdD10aGlzLiRoYW5kbGVycy5pbmRleE9mKGUpO3JldHVybiB0PT0tMT8hMToodGhpcy4kaGFuZGxlcnMuc3BsaWNlKHQsMSksZS5kZXRhY2gmJmUuZGV0YWNoKHRoaXMuJGVkaXRvciksITApfSx0aGlzLmdldEtleWJvYXJkSGFuZGxlcj1mdW5jdGlvbigpe3JldHVybiB0aGlzLiRoYW5kbGVyc1t0aGlzLiRoYW5kbGVycy5sZW5ndGgtMV19LHRoaXMuZ2V0U3RhdHVzVGV4dD1mdW5jdGlvbigpe3ZhciBlPXRoaXMuJGRhdGEsdD1lLmVkaXRvcjtyZXR1cm4gdGhpcy4kaGFuZGxlcnMubWFwKGZ1bmN0aW9uKG4pe3JldHVybiBuLmdldFN0YXR1c1RleHQmJm4uZ2V0U3RhdHVzVGV4dCh0LGUpfHwiIn0pLmZpbHRlcihCb29sZWFuKS5qb2luKCIgIil9LHRoaXMuJGNhbGxLZXlib2FyZEhhbmRsZXJzPWZ1bmN0aW9uKGUsdCxuLHIpe3ZhciBzLG89ITEsdT10aGlzLiRlZGl0b3IuY29tbWFuZHM7Zm9yKHZhciBhPXRoaXMuJGhhbmRsZXJzLmxlbmd0aDthLS07KXtzPXRoaXMuJGhhbmRsZXJzW2FdLmhhbmRsZUtleWJvYXJkKHRoaXMuJGRhdGEsZSx0LG4scik7aWYoIXN8fCFzLmNvbW1hbmQpY29udGludWU7cy5jb21tYW5kPT0ibnVsbCI/bz0hMDpvPXUuZXhlYyhzLmNvbW1hbmQsdGhpcy4kZWRpdG9yLHMuYXJncyxyKSxvJiZyJiZlIT0tMSYmcy5wYXNzRXZlbnQhPTEmJnMuY29tbWFuZC5wYXNzRXZlbnQhPTEmJmkuc3RvcEV2ZW50KHIpO2lmKG8pYnJlYWt9cmV0dXJuIW8mJmU9PS0xJiYocz17Y29tbWFuZDoiaW5zZXJ0c3RyaW5nIn0sbz11LmV4ZWMoImluc2VydHN0cmluZyIsdGhpcy4kZWRpdG9yLHQpKSxvJiZ0aGlzLiRlZGl0b3IuX3NpZ25hbCYmdGhpcy4kZWRpdG9yLl9zaWduYWwoImtleWJvYXJkQWN0aXZpdHkiLHMpLG99LHRoaXMub25Db21tYW5kS2V5PWZ1bmN0aW9uKGUsdCxuKXt2YXIgaT1yLmtleUNvZGVUb1N0cmluZyhuKTtyZXR1cm4gdGhpcy4kY2FsbEtleWJvYXJkSGFuZGxlcnModCxpLG4sZSl9LHRoaXMub25UZXh0SW5wdXQ9ZnVuY3Rpb24oZSl7cmV0dXJuIHRoaXMuJGNhbGxLZXlib2FyZEhhbmRsZXJzKC0xLGUpfX0pLmNhbGwocy5wcm90b3R5cGUpLHQuS2V5QmluZGluZz1zfSksZGVmaW5lKCJhY2UvbGliL2JpZGl1dGlsIixbInJlcXVpcmUiLCJleHBvcnRzIiwibW9kdWxlIl0sZnVuY3Rpb24oZSx0LG4peyJ1c2Ugc3RyaWN0IjtmdW5jdGlvbiBGKGUsdCxuLHIpe3ZhciBpPXM/ZDpwLGM9bnVsbCxoPW51bGwsdj1udWxsLG09MCxnPW51bGwseT1udWxsLGI9LTEsdz1udWxsLEU9bnVsbCxUPVtdO2lmKCFyKWZvcih3PTAscj1bXTt3PG47dysrKXJbd109UihlW3ddKTtvPXMsdT0hMSxhPSExLGY9ITEsbD0hMTtmb3IoRT0wO0U8bjtFKyspe2M9bSxUW0VdPWg9cShlLHIsVCxFKSxtPWlbY11baF0sZz1tJjI0MCxtJj0xNSx0W0VdPXY9aVttXVs1XTtpZihnPjApaWYoZz09MTYpe2Zvcih3PWI7dzxFO3crKyl0W3ddPTE7Yj0tMX1lbHNlIGI9LTE7eT1pW21dWzZdO2lmKHkpYj09LTEmJihiPUUpO2Vsc2UgaWYoYj4tMSl7Zm9yKHc9Yjt3PEU7dysrKXRbd109djtiPS0xfXJbRV09PVMmJih0W0VdPTApLG98PXZ9aWYobClmb3Iodz0wO3c8bjt3KyspaWYoclt3XT09eCl7dFt3XT1zO2Zvcih2YXIgQz13LTE7Qz49MDtDLS0pe2lmKHJbQ10hPU4pYnJlYWs7dFtDXT1zfX19ZnVuY3Rpb24gSShlLHQsbil7aWYobzxlKXJldHVybjtpZihlPT0xJiZzPT1tJiYhZil7bi5yZXZlcnNlKCk7cmV0dXJufXZhciByPW4ubGVuZ3RoLGk9MCx1LGEsbCxjO3doaWxlKGk8cil7aWYodFtpXT49ZSl7dT1pKzE7d2hpbGUodTxyJiZ0W3VdPj1lKXUrKztmb3IoYT1pLGw9dS0xO2E8bDthKyssbC0tKWM9blthXSxuW2FdPW5bbF0sbltsXT1jO2k9dX1pKyt9fWZ1bmN0aW9uIHEoZSx0LG4scil7dmFyIGk9dFtyXSxvLGMsaCxwO3N3aXRjaChpKXtjYXNlIGc6Y2FzZSB5OnU9ITE7Y2FzZSBFOmNhc2UgdzpyZXR1cm4gaTtjYXNlIGI6cmV0dXJuIHU/dzpiO2Nhc2UgVDpyZXR1cm4gdT0hMCxhPSEwLHk7Y2FzZSBOOnJldHVybiBFO2Nhc2UgQzppZihyPDF8fHIrMT49dC5sZW5ndGh8fChvPW5bci0xXSkhPWImJm8hPXd8fChjPXRbcisxXSkhPWImJmMhPXcpcmV0dXJuIEU7cmV0dXJuIHUmJihjPXcpLGM9PW8/YzpFO2Nhc2UgazpvPXI+MD9uW3ItMV06UztpZihvPT1iJiZyKzE8dC5sZW5ndGgmJnRbcisxXT09YilyZXR1cm4gYjtyZXR1cm4gRTtjYXNlIEw6aWYocj4wJiZuW3ItMV09PWIpcmV0dXJuIGI7aWYodSlyZXR1cm4gRTtwPXIrMSxoPXQubGVuZ3RoO3doaWxlKHA8aCYmdFtwXT09TClwKys7aWYocDxoJiZ0W3BdPT1iKXJldHVybiBiO3JldHVybiBFO2Nhc2UgQTpoPXQubGVuZ3RoLHA9cisxO3doaWxlKHA8aCYmdFtwXT09QSlwKys7aWYocDxoKXt2YXIgZD1lW3JdLHY9ZD49MTQyNSYmZDw9MjMwM3x8ZD09NjQyODY7bz10W3BdO2lmKHYmJihvPT15fHxvPT1UKSlyZXR1cm4geX1pZihyPDF8fChvPXRbci0xXSk9PVMpcmV0dXJuIEU7cmV0dXJuIG5bci0xXTtjYXNlIFM6cmV0dXJuIHU9ITEsZj0hMCxzO2Nhc2UgeDpyZXR1cm4gbD0hMCxFO2Nhc2UgTzpjYXNlIE06Y2FzZSBEOmNhc2UgUDpjYXNlIF86dT0hMTtjYXNlIEg6cmV0dXJuIEV9fWZ1bmN0aW9uIFIoZSl7dmFyIHQ9ZS5jaGFyQ29kZUF0KDApLG49dD4+ODtyZXR1cm4gbj09MD90PjE5MT9nOkJbdF06bj09NT8vW1x1MDU5MS1cdTA1ZjRdLy50ZXN0KGUpP3k6ZzpuPT02Py9bXHUwNjEwLVx1MDYxYVx1MDY0Yi1cdTA2NWZcdTA2ZDYtXHUwNmU0XHUwNmU3LVx1MDZlZF0vLnRlc3QoZSk/QTovW1x1MDY2MC1cdTA2NjlcdTA2NmItXHUwNjZjXS8udGVzdChlKT93OnQ9PTE2NDI/TDovW1x1MDZmMC1cdTA2ZjldLy50ZXN0KGUpP2I6VDpuPT0zMiYmdDw9ODI4Nz9qW3QmMjU1XTpuPT0yNTQ/dD49NjUxMzY/VDpFOkV9ZnVuY3Rpb24gVShlKXtyZXR1cm4gZT49Ilx1MDY0YiImJmU8PSJcdTA2NTUifXZhciByPVsiXHUwNjIxIiwiXHUwNjQxIl0saT1bIlx1MDYzYSIsIlx1MDY0YSJdLHM9MCxvPTAsdT0hMSxhPSExLGY9ITEsbD0hMSxjPSExLGg9ITEscD1bWzAsMywwLDEsMCwwLDBdLFswLDMsMCwxLDIsMiwwXSxbMCwzLDAsMTcsMiwwLDFdLFswLDMsNSw1LDQsMSwwXSxbMCwzLDIxLDIxLDQsMCwxXSxbMCwzLDUsNSw0LDIsMF1dLGQ9W1syLDAsMSwxLDAsMSwwXSxbMiwwLDEsMSwwLDIsMF0sWzIsMCwyLDEsMywyLDBdLFsyLDAsMiwzMywzLDEsMV1dLHY9MCxtPTEsZz0wLHk9MSxiPTIsdz0zLEU9NCxTPTUseD02LFQ9NyxOPTgsQz05LGs9MTAsTD0xMSxBPTEyLE89MTMsTT0xNCxfPTE1LEQ9MTYsUD0xNyxIPTE4LEI9W0gsSCxILEgsSCxILEgsSCxILHgsUyx4LE4sUyxILEgsSCxILEgsSCxILEgsSCxILEgsSCxILEgsUyxTLFMseCxOLEUsRSxMLEwsTCxFLEUsRSxFLEUsayxDLGssQyxDLGIsYixiLGIsYixiLGIsYixiLGIsQyxFLEUsRSxFLEUsRSxnLGcsZyxnLGcsZyxnLGcsZyxnLGcsZyxnLGcsZyxnLGcsZyxnLGcsZyxnLGcsZyxnLGcsRSxFLEUsRSxFLEUsZyxnLGcsZyxnLGcsZyxnLGcsZyxnLGcsZyxnLGcsZyxnLGcsZyxnLGcsZyxnLGcsZyxnLEUsRSxFLEUsSCxILEgsSCxILEgsUyxILEgsSCxILEgsSCxILEgsSCxILEgsSCxILEgsSCxILEgsSCxILEgsSCxILEgsSCxILEgsQyxFLEwsTCxMLEwsRSxFLEUsRSxnLEUsRSxILEUsRSxMLEwsYixiLEUsZyxFLEUsRSxiLGcsRSxFLEUsRSxFXSxqPVtOLE4sTixOLE4sTixOLE4sTixOLE4sSCxILEgsZyx5LEUsRSxFLEUsRSxFLEUsRSxFLEUsRSxFLEUsRSxFLEUsRSxFLEUsRSxFLEUsRSxFLE4sUyxPLE0sXyxELFAsQyxMLEwsTCxMLEwsRSxFLEUsRSxFLEUsRSxFLEUsRSxFLEUsRSxFLEUsQyxFLEUsRSxFLEUsRSxFLEUsRSxFLEUsRSxFLEUsRSxFLEUsRSxFLEUsRSxFLEUsRSxFLEUsTl07dC5MPWcsdC5SPXksdC5FTj1iLHQuT05fUj0zLHQuQU49NCx0LlJfSD01LHQuQj02LHQuUkxFPTcsdC5ET1Q9Ilx1MDBiNyIsdC5kb0JpZGlSZW9yZGVyPWZ1bmN0aW9uKGUsbixyKXtpZihlLmxlbmd0aDwyKXJldHVybnt9O3ZhciBpPWUuc3BsaXQoIiIpLG89bmV3IEFycmF5KGkubGVuZ3RoKSx1PW5ldyBBcnJheShpLmxlbmd0aCksYT1bXTtzPXI/bTp2LEYoaSxhLGkubGVuZ3RoLG4pO2Zvcih2YXIgZj0wO2Y8by5sZW5ndGg7b1tmXT1mLGYrKyk7SSgyLGEsbyksSSgxLGEsbyk7Zm9yKHZhciBmPTA7ZjxvLmxlbmd0aC0xO2YrKyluW2ZdPT09dz9hW2ZdPXQuQU46YVtmXT09PXkmJihuW2ZdPlQmJm5bZl08T3x8bltmXT09PUV8fG5bZl09PT1IKT9hW2ZdPXQuT05fUjpmPjAmJmlbZi0xXT09PSJcdTA2NDQiJiYvXHUwNjIyfFx1MDYyM3xcdTA2MjV8XHUwNjI3Ly50ZXN0KGlbZl0pJiYoYVtmLTFdPWFbZl09dC5SX0gsZisrKTtpW2kubGVuZ3RoLTFdPT09dC5ET1QmJihhW2kubGVuZ3RoLTFdPXQuQiksaVswXT09PSJcdTIwMmIiJiYoYVswXT10LlJMRSk7Zm9yKHZhciBmPTA7ZjxvLmxlbmd0aDtmKyspdVtmXT1hW29bZl1dO3JldHVybntsb2dpY2FsRnJvbVZpc3VhbDpvLGJpZGlMZXZlbHM6dX19LHQuaGFzQmlkaUNoYXJhY3RlcnM9ZnVuY3Rpb24oZSx0KXt2YXIgbj0hMTtmb3IodmFyIHI9MDtyPGUubGVuZ3RoO3IrKyl0W3JdPVIoZS5jaGFyQXQocikpLCFuJiYodFtyXT09eXx8dFtyXT09VHx8dFtyXT09dykmJihuPSEwKTtyZXR1cm4gbn0sdC5nZXRWaXN1YWxGcm9tTG9naWNhbElkeD1mdW5jdGlvbihlLHQpe2Zvcih2YXIgbj0wO248dC5sb2dpY2FsRnJvbVZpc3VhbC5sZW5ndGg7bisrKWlmKHQubG9naWNhbEZyb21WaXN1YWxbbl09PWUpcmV0dXJuIG47cmV0dXJuIDB9fSksZGVmaW5lKCJhY2UvYmlkaWhhbmRsZXIiLFsicmVxdWlyZSIsImV4cG9ydHMiLCJtb2R1bGUiLCJhY2UvbGliL2JpZGl1dGlsIiwiYWNlL2xpYi9sYW5nIl0sZnVuY3Rpb24oZSx0LG4peyJ1c2Ugc3RyaWN0Ijt2YXIgcj1lKCIuL2xpYi9iaWRpdXRpbCIpLGk9ZSgiLi9saWIvbGFuZyIpLHM9L1tcdTA1OTAtXHUwNWY0XHUwNjAwLVx1MDZmZlx1MDcwMC1cdTA4YWNcdTIwMkJdLyxvPWZ1bmN0aW9uKGUpe3RoaXMuc2Vzc2lvbj1lLHRoaXMuYmlkaU1hcD17fSx0aGlzLmN1cnJlbnRSb3c9bnVsbCx0aGlzLmJpZGlVdGlsPXIsdGhpcy5jaGFyV2lkdGhzPVtdLHRoaXMuRU9MPSJcdTAwYWMiLHRoaXMuc2hvd0ludmlzaWJsZXM9ITAsdGhpcy5pc1J0bERpcj0hMSx0aGlzLiRpc1J0bD0hMSx0aGlzLmxpbmU9IiIsdGhpcy53cmFwSW5kZW50PTAsdGhpcy5FT0Y9Ilx1MDBiNiIsdGhpcy5STEU9Ilx1MjAyYiIsdGhpcy5jb250ZW50V2lkdGg9MCx0aGlzLmZvbnRNZXRyaWNzPW51bGwsdGhpcy5ydGxMaW5lT2Zmc2V0PTAsdGhpcy53cmFwT2Zmc2V0PTAsdGhpcy5pc01vdmVMZWZ0T3BlcmF0aW9uPSExLHRoaXMuc2VlbkJpZGk9cy50ZXN0KGUuZ2V0VmFsdWUoKSl9OyhmdW5jdGlvbigpe3RoaXMuaXNCaWRpUm93PWZ1bmN0aW9uKGUsdCxuKXtyZXR1cm4gdGhpcy5zZWVuQmlkaT8oZSE9PXRoaXMuY3VycmVudFJvdyYmKHRoaXMuY3VycmVudFJvdz1lLHRoaXMudXBkYXRlUm93TGluZSh0LG4pLHRoaXMudXBkYXRlQmlkaU1hcCgpKSx0aGlzLmJpZGlNYXAuYmlkaUxldmVscyk6ITF9LHRoaXMub25DaGFuZ2U9ZnVuY3Rpb24oZSl7dGhpcy5zZWVuQmlkaT90aGlzLmN1cnJlbnRSb3c9bnVsbDplLmFjdGlvbj09Imluc2VydCImJnMudGVzdChlLmxpbmVzLmpvaW4oIlxuIikpJiYodGhpcy5zZWVuQmlkaT0hMCx0aGlzLmN1cnJlbnRSb3c9bnVsbCl9LHRoaXMuZ2V0RG9jdW1lbnRSb3c9ZnVuY3Rpb24oKXt2YXIgZT0wLHQ9dGhpcy5zZXNzaW9uLiRzY3JlZW5Sb3dDYWNoZTtpZih0Lmxlbmd0aCl7dmFyIG49dGhpcy5zZXNzaW9uLiRnZXRSb3dDYWNoZUluZGV4KHQsdGhpcy5jdXJyZW50Um93KTtuPj0wJiYoZT10aGlzLnNlc3Npb24uJGRvY1Jvd0NhY2hlW25dKX1yZXR1cm4gZX0sdGhpcy5nZXRTcGxpdEluZGV4PWZ1bmN0aW9uKCl7dmFyIGU9MCx0PXRoaXMuc2Vzc2lvbi4kc2NyZWVuUm93Q2FjaGU7aWYodC5sZW5ndGgpe3ZhciBuLHI9dGhpcy5zZXNzaW9uLiRnZXRSb3dDYWNoZUluZGV4KHQsdGhpcy5jdXJyZW50Um93KTt3aGlsZSh0aGlzLmN1cnJlbnRSb3ctZT4wKXtuPXRoaXMuc2Vzc2lvbi4kZ2V0Um93Q2FjaGVJbmRleCh0LHRoaXMuY3VycmVudFJvdy1lLTEpO2lmKG4hPT1yKWJyZWFrO3I9bixlKyt9fWVsc2UgZT10aGlzLmN1cnJlbnRSb3c7cmV0dXJuIGV9LHRoaXMudXBkYXRlUm93TGluZT1mdW5jdGlvbihlLHQpe2U9PT11bmRlZmluZWQmJihlPXRoaXMuZ2V0RG9jdW1lbnRSb3coKSk7dmFyIG49ZT09PXRoaXMuc2Vzc2lvbi5nZXRMZW5ndGgoKS0xLHM9bj90aGlzLkVPRjp0aGlzLkVPTDt0aGlzLndyYXBJbmRlbnQ9MCx0aGlzLmxpbmU9dGhpcy5zZXNzaW9uLmdldExpbmUoZSksdGhpcy5pc1J0bERpcj10aGlzLiRpc1J0bHx8dGhpcy5saW5lLmNoYXJBdCgwKT09PXRoaXMuUkxFO2lmKHRoaXMuc2Vzc2lvbi4kdXNlV3JhcE1vZGUpe3ZhciBvPXRoaXMuc2Vzc2lvbi4kd3JhcERhdGFbZV07byYmKHQ9PT11bmRlZmluZWQmJih0PXRoaXMuZ2V0U3BsaXRJbmRleCgpKSx0PjAmJm8ubGVuZ3RoPyh0aGlzLndyYXBJbmRlbnQ9by5pbmRlbnQsdGhpcy53cmFwT2Zmc2V0PXRoaXMud3JhcEluZGVudCp0aGlzLmNoYXJXaWR0aHNbci5MXSx0aGlzLmxpbmU9dDxvLmxlbmd0aD90aGlzLmxpbmUuc3Vic3RyaW5nKG9bdC0xXSxvW3RdKTp0aGlzLmxpbmUuc3Vic3RyaW5nKG9bby5sZW5ndGgtMV0pKTp0aGlzLmxpbmU9dGhpcy5saW5lLnN1YnN0cmluZygwLG9bdF0pLHQ9PW8ubGVuZ3RoJiYodGhpcy5saW5lKz10aGlzLnNob3dJbnZpc2libGVzP3M6ci5ET1QpKX1lbHNlIHRoaXMubGluZSs9dGhpcy5zaG93SW52aXNpYmxlcz9zOnIuRE9UO3ZhciB1PXRoaXMuc2Vzc2lvbixhPTAsZjt0aGlzLmxpbmU9dGhpcy5saW5lLnJlcGxhY2UoL1x0fFtcdTExMDAtXHUyMDI5LCBcdTIwMkYtXHVGRkU2XS9nLGZ1bmN0aW9uKGUsdCl7cmV0dXJuIGU9PT0iCSJ8fHUuaXNGdWxsV2lkdGgoZS5jaGFyQ29kZUF0KDApKT8oZj1lPT09IgkiP3UuZ2V0U2NyZWVuVGFiU2l6ZSh0K2EpOjIsYSs9Zi0xLGkuc3RyaW5nUmVwZWF0KHIuRE9ULGYpKTplfSksdGhpcy5pc1J0bERpciYmKHRoaXMuZm9udE1ldHJpY3MuJG1haW4udGV4dENvbnRlbnQ9dGhpcy5saW5lLmNoYXJBdCh0aGlzLmxpbmUubGVuZ3RoLTEpPT1yLkRPVD90aGlzLmxpbmUuc3Vic3RyKDAsdGhpcy5saW5lLmxlbmd0aC0xKTp0aGlzLmxpbmUsdGhpcy5ydGxMaW5lT2Zmc2V0PXRoaXMuY29udGVudFdpZHRoLXRoaXMuZm9udE1ldHJpY3MuJG1haW4uZ2V0Qm91bmRpbmdDbGllbnRSZWN0KCkud2lkdGgpfSx0aGlzLnVwZGF0ZUJpZGlNYXA9ZnVuY3Rpb24oKXt2YXIgZT1bXTtyLmhhc0JpZGlDaGFyYWN0ZXJzKHRoaXMubGluZSxlKXx8dGhpcy5pc1J0bERpcj90aGlzLmJpZGlNYXA9ci5kb0JpZGlSZW9yZGVyKHRoaXMubGluZSxlLHRoaXMuaXNSdGxEaXIpOnRoaXMuYmlkaU1hcD17fX0sdGhpcy5tYXJrQXNEaXJ0eT1mdW5jdGlvbigpe3RoaXMuY3VycmVudFJvdz1udWxsfSx0aGlzLnVwZGF0ZUNoYXJhY3RlcldpZHRocz1mdW5jdGlvbihlKXtpZih0aGlzLmNoYXJhY3RlcldpZHRoPT09ZS4kY2hhcmFjdGVyU2l6ZS53aWR0aClyZXR1cm47dGhpcy5mb250TWV0cmljcz1lO3ZhciB0PXRoaXMuY2hhcmFjdGVyV2lkdGg9ZS4kY2hhcmFjdGVyU2l6ZS53aWR0aCxuPWUuJG1lYXN1cmVDaGFyV2lkdGgoIlx1MDVkNCIpO3RoaXMuY2hhcldpZHRoc1tyLkxdPXRoaXMuY2hhcldpZHRoc1tyLkVOXT10aGlzLmNoYXJXaWR0aHNbci5PTl9SXT10LHRoaXMuY2hhcldpZHRoc1tyLlJdPXRoaXMuY2hhcldpZHRoc1tyLkFOXT1uLHRoaXMuY2hhcldpZHRoc1tyLlJfSF09biouNDUsdGhpcy5jaGFyV2lkdGhzW3IuQl09dGhpcy5jaGFyV2lkdGhzW3IuUkxFXT0wLHRoaXMuY3VycmVudFJvdz1udWxsfSx0aGlzLnNldFNob3dJbnZpc2libGVzPWZ1bmN0aW9uKGUpe3RoaXMuc2hvd0ludmlzaWJsZXM9ZSx0aGlzLmN1cnJlbnRSb3c9bnVsbH0sdGhpcy5zZXRFb2xDaGFyPWZ1bmN0aW9uKGUpe3RoaXMuRU9MPWV9LHRoaXMuc2V0Q29udGVudFdpZHRoPWZ1bmN0aW9uKGUpe3RoaXMuY29udGVudFdpZHRoPWV9LHRoaXMuaXNSdGxMaW5lPWZ1bmN0aW9uKGUpe3JldHVybiB0aGlzLiRpc1J0bD8hMDplIT11bmRlZmluZWQ/dGhpcy5zZXNzaW9uLmdldExpbmUoZSkuY2hhckF0KDApPT10aGlzLlJMRTp0aGlzLmlzUnRsRGlyfSx0aGlzLnNldFJ0bERpcmVjdGlvbj1mdW5jdGlvbihlLHQpe3ZhciBuPWUuZ2V0Q3Vyc29yUG9zaXRpb24oKTtmb3IodmFyIHI9ZS5zZWxlY3Rpb24uZ2V0U2VsZWN0aW9uQW5jaG9yKCkucm93O3I8PW4ucm93O3IrKykhdCYmZS5zZXNzaW9uLmdldExpbmUocikuY2hhckF0KDApPT09ZS5zZXNzaW9uLiRiaWRpSGFuZGxlci5STEU/ZS5zZXNzaW9uLmRvYy5yZW1vdmVJbkxpbmUociwwLDEpOnQmJmUuc2Vzc2lvbi5nZXRMaW5lKHIpLmNoYXJBdCgwKSE9PWUuc2Vzc2lvbi4kYmlkaUhhbmRsZXIuUkxFJiZlLnNlc3Npb24uZG9jLmluc2VydCh7Y29sdW1uOjAscm93OnJ9LGUuc2Vzc2lvbi4kYmlkaUhhbmRsZXIuUkxFKX0sdGhpcy5nZXRQb3NMZWZ0PWZ1bmN0aW9uKGUpe2UtPXRoaXMud3JhcEluZGVudDt2YXIgdD10aGlzLmxpbmUuY2hhckF0KDApPT09dGhpcy5STEU/MTowLG49ZT50P3RoaXMuc2Vzc2lvbi5nZXRPdmVyd3JpdGUoKT9lOmUtMTp0LGk9ci5nZXRWaXN1YWxGcm9tTG9naWNhbElkeChuLHRoaXMuYmlkaU1hcCkscz10aGlzLmJpZGlNYXAuYmlkaUxldmVscyxvPTA7IXRoaXMuc2Vzc2lvbi5nZXRPdmVyd3JpdGUoKSYmZTw9dCYmc1tpXSUyIT09MCYmaSsrO2Zvcih2YXIgdT0wO3U8aTt1Kyspbys9dGhpcy5jaGFyV2lkdGhzW3NbdV1dO3JldHVybiF0aGlzLnNlc3Npb24uZ2V0T3ZlcndyaXRlKCkmJmU+dCYmc1tpXSUyPT09MCYmKG8rPXRoaXMuY2hhcldpZHRoc1tzW2ldXSksdGhpcy53cmFwSW5kZW50JiYobys9dGhpcy5pc1J0bERpcj8tMSp0aGlzLndyYXBPZmZzZXQ6dGhpcy53cmFwT2Zmc2V0KSx0aGlzLmlzUnRsRGlyJiYobys9dGhpcy5ydGxMaW5lT2Zmc2V0KSxvfSx0aGlzLmdldFNlbGVjdGlvbnM9ZnVuY3Rpb24oZSx0KXt2YXIgbj10aGlzLmJpZGlNYXAscj1uLmJpZGlMZXZlbHMsaSxzPVtdLG89MCx1PU1hdGgubWluKGUsdCktdGhpcy53cmFwSW5kZW50LGE9TWF0aC5tYXgoZSx0KS10aGlzLndyYXBJbmRlbnQsZj0hMSxsPSExLGM9MDt0aGlzLndyYXBJbmRlbnQmJihvKz10aGlzLmlzUnRsRGlyPy0xKnRoaXMud3JhcE9mZnNldDp0aGlzLndyYXBPZmZzZXQpO2Zvcih2YXIgaCxwPTA7cDxyLmxlbmd0aDtwKyspaD1uLmxvZ2ljYWxGcm9tVmlzdWFsW3BdLGk9cltwXSxmPWg+PXUmJmg8YSxmJiYhbD9jPW86IWYmJmwmJnMucHVzaCh7bGVmdDpjLHdpZHRoOm8tY30pLG8rPXRoaXMuY2hhcldpZHRoc1tpXSxsPWY7ZiYmcD09PXIubGVuZ3RoJiZzLnB1c2goe2xlZnQ6Yyx3aWR0aDpvLWN9KTtpZih0aGlzLmlzUnRsRGlyKWZvcih2YXIgZD0wO2Q8cy5sZW5ndGg7ZCsrKXNbZF0ubGVmdCs9dGhpcy5ydGxMaW5lT2Zmc2V0O3JldHVybiBzfSx0aGlzLm9mZnNldFRvQ29sPWZ1bmN0aW9uKGUpe3RoaXMuaXNSdGxEaXImJihlLT10aGlzLnJ0bExpbmVPZmZzZXQpO3ZhciB0PTAsZT1NYXRoLm1heChlLDApLG49MCxyPTAsaT10aGlzLmJpZGlNYXAuYmlkaUxldmVscyxzPXRoaXMuY2hhcldpZHRoc1tpW3JdXTt0aGlzLndyYXBJbmRlbnQmJihlLT10aGlzLmlzUnRsRGlyPy0xKnRoaXMud3JhcE9mZnNldDp0aGlzLndyYXBPZmZzZXQpO3doaWxlKGU+bitzLzIpe24rPXM7aWYocj09PWkubGVuZ3RoLTEpe3M9MDticmVha31zPXRoaXMuY2hhcldpZHRoc1tpWysrcl1dfXJldHVybiByPjAmJmlbci0xXSUyIT09MCYmaVtyXSUyPT09MD8oZTxuJiZyLS0sdD10aGlzLmJpZGlNYXAubG9naWNhbEZyb21WaXN1YWxbcl0pOnI+MCYmaVtyLTFdJTI9PT0wJiZpW3JdJTIhPT0wP3Q9MSsoZT5uP3RoaXMuYmlkaU1hcC5sb2dpY2FsRnJvbVZpc3VhbFtyXTp0aGlzLmJpZGlNYXAubG9naWNhbEZyb21WaXN1YWxbci0xXSk6dGhpcy5pc1J0bERpciYmcj09PWkubGVuZ3RoLTEmJnM9PT0wJiZpW3ItMV0lMj09PTB8fCF0aGlzLmlzUnRsRGlyJiZyPT09MCYmaVtyXSUyIT09MD90PTErdGhpcy5iaWRpTWFwLmxvZ2ljYWxGcm9tVmlzdWFsW3JdOihyPjAmJmlbci0xXSUyIT09MCYmcyE9PTAmJnItLSx0PXRoaXMuYmlkaU1hcC5sb2dpY2FsRnJvbVZpc3VhbFtyXSksdD09PTAmJnRoaXMuaXNSdGxEaXImJnQrKyx0K3RoaXMud3JhcEluZGVudH19KS5jYWxsKG8ucHJvdG90eXBlKSx0LkJpZGlIYW5kbGVyPW99KSxkZWZpbmUoImFjZS9zZWxlY3Rpb24iLFsicmVxdWlyZSIsImV4cG9ydHMiLCJtb2R1bGUiLCJhY2UvbGliL29vcCIsImFjZS9saWIvbGFuZyIsImFjZS9saWIvZXZlbnRfZW1pdHRlciIsImFjZS9yYW5nZSJdLGZ1bmN0aW9uKGUsdCxuKXsidXNlIHN0cmljdCI7dmFyIHI9ZSgiLi9saWIvb29wIiksaT1lKCIuL2xpYi9sYW5nIikscz1lKCIuL2xpYi9ldmVudF9lbWl0dGVyIikuRXZlbnRFbWl0dGVyLG89ZSgiLi9yYW5nZSIpLlJhbmdlLHU9ZnVuY3Rpb24oZSl7dGhpcy5zZXNzaW9uPWUsdGhpcy5kb2M9ZS5nZXREb2N1bWVudCgpLHRoaXMuY2xlYXJTZWxlY3Rpb24oKSx0aGlzLmN1cnNvcj10aGlzLmxlYWQ9dGhpcy5kb2MuY3JlYXRlQW5jaG9yKDAsMCksdGhpcy5hbmNob3I9dGhpcy5kb2MuY3JlYXRlQW5jaG9yKDAsMCksdGhpcy4kc2lsZW50PSExO3ZhciB0PXRoaXM7dGhpcy5jdXJzb3Iub24oImNoYW5nZSIsZnVuY3Rpb24oZSl7dC4kY3Vyc29yQ2hhbmdlZD0hMCx0LiRzaWxlbnR8fHQuX2VtaXQoImNoYW5nZUN1cnNvciIpLCF0LiRpc0VtcHR5JiYhdC4kc2lsZW50JiZ0Ll9lbWl0KCJjaGFuZ2VTZWxlY3Rpb24iKSwhdC4ka2VlcERlc2lyZWRDb2x1bW5PbkNoYW5nZSYmZS5vbGQuY29sdW1uIT1lLnZhbHVlLmNvbHVtbiYmKHQuJGRlc2lyZWRDb2x1bW49bnVsbCl9KSx0aGlzLmFuY2hvci5vbigiY2hhbmdlIixmdW5jdGlvbigpe3QuJGFuY2hvckNoYW5nZWQ9ITAsIXQuJGlzRW1wdHkmJiF0LiRzaWxlbnQmJnQuX2VtaXQoImNoYW5nZVNlbGVjdGlvbiIpfSl9OyhmdW5jdGlvbigpe3IuaW1wbGVtZW50KHRoaXMscyksdGhpcy5pc0VtcHR5PWZ1bmN0aW9uKCl7cmV0dXJuIHRoaXMuJGlzRW1wdHl8fHRoaXMuYW5jaG9yLnJvdz09dGhpcy5sZWFkLnJvdyYmdGhpcy5hbmNob3IuY29sdW1uPT10aGlzLmxlYWQuY29sdW1ufSx0aGlzLmlzTXVsdGlMaW5lPWZ1bmN0aW9uKCl7cmV0dXJuIXRoaXMuJGlzRW1wdHkmJnRoaXMuYW5jaG9yLnJvdyE9dGhpcy5jdXJzb3Iucm93fSx0aGlzLmdldEN1cnNvcj1mdW5jdGlvbigpe3JldHVybiB0aGlzLmxlYWQuZ2V0UG9zaXRpb24oKX0sdGhpcy5zZXRTZWxlY3Rpb25BbmNob3I9ZnVuY3Rpb24oZSx0KXt0aGlzLiRpc0VtcHR5PSExLHRoaXMuYW5jaG9yLnNldFBvc2l0aW9uKGUsdCl9LHRoaXMuZ2V0QW5jaG9yPXRoaXMuZ2V0U2VsZWN0aW9uQW5jaG9yPWZ1bmN0aW9uKCl7cmV0dXJuIHRoaXMuJGlzRW1wdHk/dGhpcy5nZXRTZWxlY3Rpb25MZWFkKCk6dGhpcy5hbmNob3IuZ2V0UG9zaXRpb24oKX0sdGhpcy5nZXRTZWxlY3Rpb25MZWFkPWZ1bmN0aW9uKCl7cmV0dXJuIHRoaXMubGVhZC5nZXRQb3NpdGlvbigpfSx0aGlzLmlzQmFja3dhcmRzPWZ1bmN0aW9uKCl7dmFyIGU9dGhpcy5hbmNob3IsdD10aGlzLmxlYWQ7cmV0dXJuIGUucm93PnQucm93fHxlLnJvdz09dC5yb3cmJmUuY29sdW1uPnQuY29sdW1ufSx0aGlzLmdldFJhbmdlPWZ1bmN0aW9uKCl7dmFyIGU9dGhpcy5hbmNob3IsdD10aGlzLmxlYWQ7cmV0dXJuIHRoaXMuJGlzRW1wdHk/by5mcm9tUG9pbnRzKHQsdCk6dGhpcy5pc0JhY2t3YXJkcygpP28uZnJvbVBvaW50cyh0LGUpOm8uZnJvbVBvaW50cyhlLHQpfSx0aGlzLmNsZWFyU2VsZWN0aW9uPWZ1bmN0aW9uKCl7dGhpcy4kaXNFbXB0eXx8KHRoaXMuJGlzRW1wdHk9ITAsdGhpcy5fZW1pdCgiY2hhbmdlU2VsZWN0aW9uIikpfSx0aGlzLnNlbGVjdEFsbD1mdW5jdGlvbigpe3RoaXMuJHNldFNlbGVjdGlvbigwLDAsTnVtYmVyLk1BWF9WQUxVRSxOdW1iZXIuTUFYX1ZBTFVFKX0sdGhpcy5zZXRSYW5nZT10aGlzLnNldFNlbGVjdGlvblJhbmdlPWZ1bmN0aW9uKGUsdCl7dmFyIG49dD9lLmVuZDplLnN0YXJ0LHI9dD9lLnN0YXJ0OmUuZW5kO3RoaXMuJHNldFNlbGVjdGlvbihuLnJvdyxuLmNvbHVtbixyLnJvdyxyLmNvbHVtbil9LHRoaXMuJHNldFNlbGVjdGlvbj1mdW5jdGlvbihlLHQsbixyKXtpZih0aGlzLiRzaWxlbnQpcmV0dXJuO3ZhciBpPXRoaXMuJGlzRW1wdHkscz10aGlzLmluTXVsdGlTZWxlY3RNb2RlO3RoaXMuJHNpbGVudD0hMCx0aGlzLiRjdXJzb3JDaGFuZ2VkPXRoaXMuJGFuY2hvckNoYW5nZWQ9ITEsdGhpcy5hbmNob3Iuc2V0UG9zaXRpb24oZSx0KSx0aGlzLmN1cnNvci5zZXRQb3NpdGlvbihuLHIpLHRoaXMuJGlzRW1wdHk9IW8uY29tcGFyZVBvaW50cyh0aGlzLmFuY2hvcix0aGlzLmN1cnNvciksdGhpcy4kc2lsZW50PSExLHRoaXMuJGN1cnNvckNoYW5nZWQmJnRoaXMuX2VtaXQoImNoYW5nZUN1cnNvciIpLCh0aGlzLiRjdXJzb3JDaGFuZ2VkfHx0aGlzLiRhbmNob3JDaGFuZ2VkfHxpIT10aGlzLiRpc0VtcHR5fHxzKSYmdGhpcy5fZW1pdCgiY2hhbmdlU2VsZWN0aW9uIil9LHRoaXMuJG1vdmVTZWxlY3Rpb249ZnVuY3Rpb24oZSl7dmFyIHQ9dGhpcy5sZWFkO3RoaXMuJGlzRW1wdHkmJnRoaXMuc2V0U2VsZWN0aW9uQW5jaG9yKHQucm93LHQuY29sdW1uKSxlLmNhbGwodGhpcyl9LHRoaXMuc2VsZWN0VG89ZnVuY3Rpb24oZSx0KXt0aGlzLiRtb3ZlU2VsZWN0aW9uKGZ1bmN0aW9uKCl7dGhpcy5tb3ZlQ3Vyc29yVG8oZSx0KX0pfSx0aGlzLnNlbGVjdFRvUG9zaXRpb249ZnVuY3Rpb24oZSl7dGhpcy4kbW92ZVNlbGVjdGlvbihmdW5jdGlvbigpe3RoaXMubW92ZUN1cnNvclRvUG9zaXRpb24oZSl9KX0sdGhpcy5tb3ZlVG89ZnVuY3Rpb24oZSx0KXt0aGlzLmNsZWFyU2VsZWN0aW9uKCksdGhpcy5tb3ZlQ3Vyc29yVG8oZSx0KX0sdGhpcy5tb3ZlVG9Qb3NpdGlvbj1mdW5jdGlvbihlKXt0aGlzLmNsZWFyU2VsZWN0aW9uKCksdGhpcy5tb3ZlQ3Vyc29yVG9Qb3NpdGlvbihlKX0sdGhpcy5zZWxlY3RVcD1mdW5jdGlvbigpe3RoaXMuJG1vdmVTZWxlY3Rpb24odGhpcy5tb3ZlQ3Vyc29yVXApfSx0aGlzLnNlbGVjdERvd249ZnVuY3Rpb24oKXt0aGlzLiRtb3ZlU2VsZWN0aW9uKHRoaXMubW92ZUN1cnNvckRvd24pfSx0aGlzLnNlbGVjdFJpZ2h0PWZ1bmN0aW9uKCl7dGhpcy4kbW92ZVNlbGVjdGlvbih0aGlzLm1vdmVDdXJzb3JSaWdodCl9LHRoaXMuc2VsZWN0TGVmdD1mdW5jdGlvbigpe3RoaXMuJG1vdmVTZWxlY3Rpb24odGhpcy5tb3ZlQ3Vyc29yTGVmdCl9LHRoaXMuc2VsZWN0TGluZVN0YXJ0PWZ1bmN0aW9uKCl7dGhpcy4kbW92ZVNlbGVjdGlvbih0aGlzLm1vdmVDdXJzb3JMaW5lU3RhcnQpfSx0aGlzLnNlbGVjdExpbmVFbmQ9ZnVuY3Rpb24oKXt0aGlzLiRtb3ZlU2VsZWN0aW9uKHRoaXMubW92ZUN1cnNvckxpbmVFbmQpfSx0aGlzLnNlbGVjdEZpbGVFbmQ9ZnVuY3Rpb24oKXt0aGlzLiRtb3ZlU2VsZWN0aW9uKHRoaXMubW92ZUN1cnNvckZpbGVFbmQpfSx0aGlzLnNlbGVjdEZpbGVTdGFydD1mdW5jdGlvbigpe3RoaXMuJG1vdmVTZWxlY3Rpb24odGhpcy5tb3ZlQ3Vyc29yRmlsZVN0YXJ0KX0sdGhpcy5zZWxlY3RXb3JkUmlnaHQ9ZnVuY3Rpb24oKXt0aGlzLiRtb3ZlU2VsZWN0aW9uKHRoaXMubW92ZUN1cnNvcldvcmRSaWdodCl9LHRoaXMuc2VsZWN0V29yZExlZnQ9ZnVuY3Rpb24oKXt0aGlzLiRtb3ZlU2VsZWN0aW9uKHRoaXMubW92ZUN1cnNvcldvcmRMZWZ0KX0sdGhpcy5nZXRXb3JkUmFuZ2U9ZnVuY3Rpb24oZSx0KXtpZih0eXBlb2YgdD09InVuZGVmaW5lZCIpe3ZhciBuPWV8fHRoaXMubGVhZDtlPW4ucm93LHQ9bi5jb2x1bW59cmV0dXJuIHRoaXMuc2Vzc2lvbi5nZXRXb3JkUmFuZ2UoZSx0KX0sdGhpcy5zZWxlY3RXb3JkPWZ1bmN0aW9uKCl7dGhpcy5zZXRTZWxlY3Rpb25SYW5nZSh0aGlzLmdldFdvcmRSYW5nZSgpKX0sdGhpcy5zZWxlY3RBV29yZD1mdW5jdGlvbigpe3ZhciBlPXRoaXMuZ2V0Q3Vyc29yKCksdD10aGlzLnNlc3Npb24uZ2V0QVdvcmRSYW5nZShlLnJvdyxlLmNvbHVtbik7dGhpcy5zZXRTZWxlY3Rpb25SYW5nZSh0KX0sdGhpcy5nZXRMaW5lUmFuZ2U9ZnVuY3Rpb24oZSx0KXt2YXIgbj10eXBlb2YgZT09Im51bWJlciI/ZTp0aGlzLmxlYWQucm93LHIsaT10aGlzLnNlc3Npb24uZ2V0Rm9sZExpbmUobik7cmV0dXJuIGk/KG49aS5zdGFydC5yb3cscj1pLmVuZC5yb3cpOnI9bix0PT09ITA/bmV3IG8obiwwLHIsdGhpcy5zZXNzaW9uLmdldExpbmUocikubGVuZ3RoKTpuZXcgbyhuLDAscisxLDApfSx0aGlzLnNlbGVjdExpbmU9ZnVuY3Rpb24oKXt0aGlzLnNldFNlbGVjdGlvblJhbmdlKHRoaXMuZ2V0TGluZVJhbmdlKCkpfSx0aGlzLm1vdmVDdXJzb3JVcD1mdW5jdGlvbigpe3RoaXMubW92ZUN1cnNvckJ5KC0xLDApfSx0aGlzLm1vdmVDdXJzb3JEb3duPWZ1bmN0aW9uKCl7dGhpcy5tb3ZlQ3Vyc29yQnkoMSwwKX0sdGhpcy53b3VsZE1vdmVJbnRvU29mdFRhYj1mdW5jdGlvbihlLHQsbil7dmFyIHI9ZS5jb2x1bW4saT1lLmNvbHVtbit0O3JldHVybiBuPDAmJihyPWUuY29sdW1uLXQsaT1lLmNvbHVtbiksdGhpcy5zZXNzaW9uLmlzVGFiU3RvcChlKSYmdGhpcy5kb2MuZ2V0TGluZShlLnJvdykuc2xpY2UocixpKS5zcGxpdCgiICIpLmxlbmd0aC0xPT10fSx0aGlzLm1vdmVDdXJzb3JMZWZ0PWZ1bmN0aW9uKCl7dmFyIGU9dGhpcy5sZWFkLmdldFBvc2l0aW9uKCksdDtpZih0PXRoaXMuc2Vzc2lvbi5nZXRGb2xkQXQoZS5yb3csZS5jb2x1bW4sLTEpKXRoaXMubW92ZUN1cnNvclRvKHQuc3RhcnQucm93LHQuc3RhcnQuY29sdW1uKTtlbHNlIGlmKGUuY29sdW1uPT09MCllLnJvdz4wJiZ0aGlzLm1vdmVDdXJzb3JUbyhlLnJvdy0xLHRoaXMuZG9jLmdldExpbmUoZS5yb3ctMSkubGVuZ3RoKTtlbHNle3ZhciBuPXRoaXMuc2Vzc2lvbi5nZXRUYWJTaXplKCk7dGhpcy53b3VsZE1vdmVJbnRvU29mdFRhYihlLG4sLTEpJiYhdGhpcy5zZXNzaW9uLmdldE5hdmlnYXRlV2l0aGluU29mdFRhYnMoKT90aGlzLm1vdmVDdXJzb3JCeSgwLC1uKTp0aGlzLm1vdmVDdXJzb3JCeSgwLC0xKX19LHRoaXMubW92ZUN1cnNvclJpZ2h0PWZ1bmN0aW9uKCl7dmFyIGU9dGhpcy5sZWFkLmdldFBvc2l0aW9uKCksdDtpZih0PXRoaXMuc2Vzc2lvbi5nZXRGb2xkQXQoZS5yb3csZS5jb2x1bW4sMSkpdGhpcy5tb3ZlQ3Vyc29yVG8odC5lbmQucm93LHQuZW5kLmNvbHVtbik7ZWxzZSBpZih0aGlzLmxlYWQuY29sdW1uPT10aGlzLmRvYy5nZXRMaW5lKHRoaXMubGVhZC5yb3cpLmxlbmd0aCl0aGlzLmxlYWQucm93PHRoaXMuZG9jLmdldExlbmd0aCgpLTEmJnRoaXMubW92ZUN1cnNvclRvKHRoaXMubGVhZC5yb3crMSwwKTtlbHNle3ZhciBuPXRoaXMuc2Vzc2lvbi5nZXRUYWJTaXplKCksZT10aGlzLmxlYWQ7dGhpcy53b3VsZE1vdmVJbnRvU29mdFRhYihlLG4sMSkmJiF0aGlzLnNlc3Npb24uZ2V0TmF2aWdhdGVXaXRoaW5Tb2Z0VGFicygpP3RoaXMubW92ZUN1cnNvckJ5KDAsbik6dGhpcy5tb3ZlQ3Vyc29yQnkoMCwxKX19LHRoaXMubW92ZUN1cnNvckxpbmVTdGFydD1mdW5jdGlvbigpe3ZhciBlPXRoaXMubGVhZC5yb3csdD10aGlzLmxlYWQuY29sdW1uLG49dGhpcy5zZXNzaW9uLmRvY3VtZW50VG9TY3JlZW5Sb3coZSx0KSxyPXRoaXMuc2Vzc2lvbi5zY3JlZW5Ub0RvY3VtZW50UG9zaXRpb24obiwwKSxpPXRoaXMuc2Vzc2lvbi5nZXREaXNwbGF5TGluZShlLG51bGwsci5yb3csci5jb2x1bW4pLHM9aS5tYXRjaCgvXlxzKi8pO3NbMF0ubGVuZ3RoIT10JiYhdGhpcy5zZXNzaW9uLiR1c2VFbWFjc1N0eWxlTGluZVN0YXJ0JiYoci5jb2x1bW4rPXNbMF0ubGVuZ3RoKSx0aGlzLm1vdmVDdXJzb3JUb1Bvc2l0aW9uKHIpfSx0aGlzLm1vdmVDdXJzb3JMaW5lRW5kPWZ1bmN0aW9uKCl7dmFyIGU9dGhpcy5sZWFkLHQ9dGhpcy5zZXNzaW9uLmdldERvY3VtZW50TGFzdFJvd0NvbHVtblBvc2l0aW9uKGUucm93LGUuY29sdW1uKTtpZih0aGlzLmxlYWQuY29sdW1uPT10LmNvbHVtbil7dmFyIG49dGhpcy5zZXNzaW9uLmdldExpbmUodC5yb3cpO2lmKHQuY29sdW1uPT1uLmxlbmd0aCl7dmFyIHI9bi5zZWFyY2goL1xzKyQvKTtyPjAmJih0LmNvbHVtbj1yKX19dGhpcy5tb3ZlQ3Vyc29yVG8odC5yb3csdC5jb2x1bW4pfSx0aGlzLm1vdmVDdXJzb3JGaWxlRW5kPWZ1bmN0aW9uKCl7dmFyIGU9dGhpcy5kb2MuZ2V0TGVuZ3RoKCktMSx0PXRoaXMuZG9jLmdldExpbmUoZSkubGVuZ3RoO3RoaXMubW92ZUN1cnNvclRvKGUsdCl9LHRoaXMubW92ZUN1cnNvckZpbGVTdGFydD1mdW5jdGlvbigpe3RoaXMubW92ZUN1cnNvclRvKDAsMCl9LHRoaXMubW92ZUN1cnNvckxvbmdXb3JkUmlnaHQ9ZnVuY3Rpb24oKXt2YXIgZT10aGlzLmxlYWQucm93LHQ9dGhpcy5sZWFkLmNvbHVtbixuPXRoaXMuZG9jLmdldExpbmUoZSkscj1uLnN1YnN0cmluZyh0KTt0aGlzLnNlc3Npb24ubm9uVG9rZW5SZS5sYXN0SW5kZXg9MCx0aGlzLnNlc3Npb24udG9rZW5SZS5sYXN0SW5kZXg9MDt2YXIgaT10aGlzLnNlc3Npb24uZ2V0Rm9sZEF0KGUsdCwxKTtpZihpKXt0aGlzLm1vdmVDdXJzb3JUbyhpLmVuZC5yb3csaS5lbmQuY29sdW1uKTtyZXR1cm59dGhpcy5zZXNzaW9uLm5vblRva2VuUmUuZXhlYyhyKSYmKHQrPXRoaXMuc2Vzc2lvbi5ub25Ub2tlblJlLmxhc3RJbmRleCx0aGlzLnNlc3Npb24ubm9uVG9rZW5SZS5sYXN0SW5kZXg9MCxyPW4uc3Vic3RyaW5nKHQpKTtpZih0Pj1uLmxlbmd0aCl7dGhpcy5tb3ZlQ3Vyc29yVG8oZSxuLmxlbmd0aCksdGhpcy5tb3ZlQ3Vyc29yUmlnaHQoKSxlPHRoaXMuZG9jLmdldExlbmd0aCgpLTEmJnRoaXMubW92ZUN1cnNvcldvcmRSaWdodCgpO3JldHVybn10aGlzLnNlc3Npb24udG9rZW5SZS5leGVjKHIpJiYodCs9dGhpcy5zZXNzaW9uLnRva2VuUmUubGFzdEluZGV4LHRoaXMuc2Vzc2lvbi50b2tlblJlLmxhc3RJbmRleD0wKSx0aGlzLm1vdmVDdXJzb3JUbyhlLHQpfSx0aGlzLm1vdmVDdXJzb3JMb25nV29yZExlZnQ9ZnVuY3Rpb24oKXt2YXIgZT10aGlzLmxlYWQucm93LHQ9dGhpcy5sZWFkLmNvbHVtbixuO2lmKG49dGhpcy5zZXNzaW9uLmdldEZvbGRBdChlLHQsLTEpKXt0aGlzLm1vdmVDdXJzb3JUbyhuLnN0YXJ0LnJvdyxuLnN0YXJ0LmNvbHVtbik7cmV0dXJufXZhciByPXRoaXMuc2Vzc2lvbi5nZXRGb2xkU3RyaW5nQXQoZSx0LC0xKTtyPT1udWxsJiYocj10aGlzLmRvYy5nZXRMaW5lKGUpLnN1YnN0cmluZygwLHQpKTt2YXIgcz1pLnN0cmluZ1JldmVyc2Uocik7dGhpcy5zZXNzaW9uLm5vblRva2VuUmUubGFzdEluZGV4PTAsdGhpcy5zZXNzaW9uLnRva2VuUmUubGFzdEluZGV4PTAsdGhpcy5zZXNzaW9uLm5vblRva2VuUmUuZXhlYyhzKSYmKHQtPXRoaXMuc2Vzc2lvbi5ub25Ub2tlblJlLmxhc3RJbmRleCxzPXMuc2xpY2UodGhpcy5zZXNzaW9uLm5vblRva2VuUmUubGFzdEluZGV4KSx0aGlzLnNlc3Npb24ubm9uVG9rZW5SZS5sYXN0SW5kZXg9MCk7aWYodDw9MCl7dGhpcy5tb3ZlQ3Vyc29yVG8oZSwwKSx0aGlzLm1vdmVDdXJzb3JMZWZ0KCksZT4wJiZ0aGlzLm1vdmVDdXJzb3JXb3JkTGVmdCgpO3JldHVybn10aGlzLnNlc3Npb24udG9rZW5SZS5leGVjKHMpJiYodC09dGhpcy5zZXNzaW9uLnRva2VuUmUubGFzdEluZGV4LHRoaXMuc2Vzc2lvbi50b2tlblJlLmxhc3RJbmRleD0wKSx0aGlzLm1vdmVDdXJzb3JUbyhlLHQpfSx0aGlzLiRzaG9ydFdvcmRFbmRJbmRleD1mdW5jdGlvbihlKXt2YXIgdD0wLG4scj0vXHMvLGk9dGhpcy5zZXNzaW9uLnRva2VuUmU7aS5sYXN0SW5kZXg9MDtpZih0aGlzLnNlc3Npb24udG9rZW5SZS5leGVjKGUpKXQ9dGhpcy5zZXNzaW9uLnRva2VuUmUubGFzdEluZGV4O2Vsc2V7d2hpbGUoKG49ZVt0XSkmJnIudGVzdChuKSl0Kys7aWYodDwxKXtpLmxhc3RJbmRleD0wO3doaWxlKChuPWVbdF0pJiYhaS50ZXN0KG4pKXtpLmxhc3RJbmRleD0wLHQrKztpZihyLnRlc3Qobikpe2lmKHQ+Mil7dC0tO2JyZWFrfXdoaWxlKChuPWVbdF0pJiZyLnRlc3QobikpdCsrO2lmKHQ+MilicmVha319fX1yZXR1cm4gaS5sYXN0SW5kZXg9MCx0fSx0aGlzLm1vdmVDdXJzb3JTaG9ydFdvcmRSaWdodD1mdW5jdGlvbigpe3ZhciBlPXRoaXMubGVhZC5yb3csdD10aGlzLmxlYWQuY29sdW1uLG49dGhpcy5kb2MuZ2V0TGluZShlKSxyPW4uc3Vic3RyaW5nKHQpLGk9dGhpcy5zZXNzaW9uLmdldEZvbGRBdChlLHQsMSk7aWYoaSlyZXR1cm4gdGhpcy5tb3ZlQ3Vyc29yVG8oaS5lbmQucm93LGkuZW5kLmNvbHVtbik7aWYodD09bi5sZW5ndGgpe3ZhciBzPXRoaXMuZG9jLmdldExlbmd0aCgpO2RvIGUrKyxyPXRoaXMuZG9jLmdldExpbmUoZSk7d2hpbGUoZTxzJiYvXlxzKiQvLnRlc3QocikpOy9eXHMrLy50ZXN0KHIpfHwocj0iIiksdD0wfXZhciBvPXRoaXMuJHNob3J0V29yZEVuZEluZGV4KHIpO3RoaXMubW92ZUN1cnNvclRvKGUsdCtvKX0sdGhpcy5tb3ZlQ3Vyc29yU2hvcnRXb3JkTGVmdD1mdW5jdGlvbigpe3ZhciBlPXRoaXMubGVhZC5yb3csdD10aGlzLmxlYWQuY29sdW1uLG47aWYobj10aGlzLnNlc3Npb24uZ2V0Rm9sZEF0KGUsdCwtMSkpcmV0dXJuIHRoaXMubW92ZUN1cnNvclRvKG4uc3RhcnQucm93LG4uc3RhcnQuY29sdW1uKTt2YXIgcj10aGlzLnNlc3Npb24uZ2V0TGluZShlKS5zdWJzdHJpbmcoMCx0KTtpZih0PT09MCl7ZG8gZS0tLHI9dGhpcy5kb2MuZ2V0TGluZShlKTt3aGlsZShlPjAmJi9eXHMqJC8udGVzdChyKSk7dD1yLmxlbmd0aCwvXHMrJC8udGVzdChyKXx8KHI9IiIpfXZhciBzPWkuc3RyaW5nUmV2ZXJzZShyKSxvPXRoaXMuJHNob3J0V29yZEVuZEluZGV4KHMpO3JldHVybiB0aGlzLm1vdmVDdXJzb3JUbyhlLHQtbyl9LHRoaXMubW92ZUN1cnNvcldvcmRSaWdodD1mdW5jdGlvbigpe3RoaXMuc2Vzc2lvbi4kc2VsZWN0TG9uZ1dvcmRzP3RoaXMubW92ZUN1cnNvckxvbmdXb3JkUmlnaHQoKTp0aGlzLm1vdmVDdXJzb3JTaG9ydFdvcmRSaWdodCgpfSx0aGlzLm1vdmVDdXJzb3JXb3JkTGVmdD1mdW5jdGlvbigpe3RoaXMuc2Vzc2lvbi4kc2VsZWN0TG9uZ1dvcmRzP3RoaXMubW92ZUN1cnNvckxvbmdXb3JkTGVmdCgpOnRoaXMubW92ZUN1cnNvclNob3J0V29yZExlZnQoKX0sdGhpcy5tb3ZlQ3Vyc29yQnk9ZnVuY3Rpb24oZSx0KXt2YXIgbj10aGlzLnNlc3Npb24uZG9jdW1lbnRUb1NjcmVlblBvc2l0aW9uKHRoaXMubGVhZC5yb3csdGhpcy5sZWFkLmNvbHVtbikscjt0PT09MCYmKGUhPT0wJiYodGhpcy5zZXNzaW9uLiRiaWRpSGFuZGxlci5pc0JpZGlSb3cobi5yb3csdGhpcy5sZWFkLnJvdyk/KHI9dGhpcy5zZXNzaW9uLiRiaWRpSGFuZGxlci5nZXRQb3NMZWZ0KG4uY29sdW1uKSxuLmNvbHVtbj1NYXRoLnJvdW5kKHIvdGhpcy5zZXNzaW9uLiRiaWRpSGFuZGxlci5jaGFyV2lkdGhzWzBdKSk6cj1uLmNvbHVtbip0aGlzLnNlc3Npb24uJGJpZGlIYW5kbGVyLmNoYXJXaWR0aHNbMF0pLHRoaXMuJGRlc2lyZWRDb2x1bW4/bi5jb2x1bW49dGhpcy4kZGVzaXJlZENvbHVtbjp0aGlzLiRkZXNpcmVkQ29sdW1uPW4uY29sdW1uKTtpZihlIT0wJiZ0aGlzLnNlc3Npb24ubGluZVdpZGdldHMmJnRoaXMuc2Vzc2lvbi5saW5lV2lkZ2V0c1t0aGlzLmxlYWQucm93XSl7dmFyIGk9dGhpcy5zZXNzaW9uLmxpbmVXaWRnZXRzW3RoaXMubGVhZC5yb3ddO2U8MD9lLT1pLnJvd3NBYm92ZXx8MDplPjAmJihlKz1pLnJvd0NvdW50LShpLnJvd3NBYm92ZXx8MCkpfXZhciBzPXRoaXMuc2Vzc2lvbi5zY3JlZW5Ub0RvY3VtZW50UG9zaXRpb24obi5yb3crZSxuLmNvbHVtbixyKTtlIT09MCYmdD09PTAmJnMucm93PT09dGhpcy5sZWFkLnJvdyYmcy5jb2x1bW49PT10aGlzLmxlYWQuY29sdW1uLHRoaXMubW92ZUN1cnNvclRvKHMucm93LHMuY29sdW1uK3QsdD09PTApfSx0aGlzLm1vdmVDdXJzb3JUb1Bvc2l0aW9uPWZ1bmN0aW9uKGUpe3RoaXMubW92ZUN1cnNvclRvKGUucm93LGUuY29sdW1uKX0sdGhpcy5tb3ZlQ3Vyc29yVG89ZnVuY3Rpb24oZSx0LG4pe3ZhciByPXRoaXMuc2Vzc2lvbi5nZXRGb2xkQXQoZSx0LDEpO3ImJihlPXIuc3RhcnQucm93LHQ9ci5zdGFydC5jb2x1bW4pLHRoaXMuJGtlZXBEZXNpcmVkQ29sdW1uT25DaGFuZ2U9ITA7dmFyIGk9dGhpcy5zZXNzaW9uLmdldExpbmUoZSk7L1tcdURDMDAtXHVERkZGXS8udGVzdChpLmNoYXJBdCh0KSkmJmkuY2hhckF0KHQtMSkmJih0aGlzLmxlYWQucm93PT1lJiZ0aGlzLmxlYWQuY29sdW1uPT10KzE/dC09MTp0Kz0xKSx0aGlzLmxlYWQuc2V0UG9zaXRpb24oZSx0KSx0aGlzLiRrZWVwRGVzaXJlZENvbHVtbk9uQ2hhbmdlPSExLG58fCh0aGlzLiRkZXNpcmVkQ29sdW1uPW51bGwpfSx0aGlzLm1vdmVDdXJzb3JUb1NjcmVlbj1mdW5jdGlvbihlLHQsbil7dmFyIHI9dGhpcy5zZXNzaW9uLnNjcmVlblRvRG9jdW1lbnRQb3NpdGlvbihlLHQpO3RoaXMubW92ZUN1cnNvclRvKHIucm93LHIuY29sdW1uLG4pfSx0aGlzLmRldGFjaD1mdW5jdGlvbigpe3RoaXMubGVhZC5kZXRhY2goKSx0aGlzLmFuY2hvci5kZXRhY2goKX0sdGhpcy5mcm9tT3JpZW50ZWRSYW5nZT1mdW5jdGlvbihlKXt0aGlzLnNldFNlbGVjdGlvblJhbmdlKGUsZS5jdXJzb3I9PWUuc3RhcnQpLHRoaXMuJGRlc2lyZWRDb2x1bW49ZS5kZXNpcmVkQ29sdW1ufHx0aGlzLiRkZXNpcmVkQ29sdW1ufSx0aGlzLnRvT3JpZW50ZWRSYW5nZT1mdW5jdGlvbihlKXt2YXIgdD10aGlzLmdldFJhbmdlKCk7cmV0dXJuIGU/KGUuc3RhcnQuY29sdW1uPXQuc3RhcnQuY29sdW1uLGUuc3RhcnQucm93PXQuc3RhcnQucm93LGUuZW5kLmNvbHVtbj10LmVuZC5jb2x1bW4sZS5lbmQucm93PXQuZW5kLnJvdyk6ZT10LGUuY3Vyc29yPXRoaXMuaXNCYWNrd2FyZHMoKT9lLnN0YXJ0OmUuZW5kLGUuZGVzaXJlZENvbHVtbj10aGlzLiRkZXNpcmVkQ29sdW1uLGV9LHRoaXMuZ2V0UmFuZ2VPZk1vdmVtZW50cz1mdW5jdGlvbihlKXt2YXIgdD10aGlzLmdldEN1cnNvcigpO3RyeXtlKHRoaXMpO3ZhciBuPXRoaXMuZ2V0Q3Vyc29yKCk7cmV0dXJuIG8uZnJvbVBvaW50cyh0LG4pfWNhdGNoKHIpe3JldHVybiBvLmZyb21Qb2ludHModCx0KX1maW5hbGx5e3RoaXMubW92ZUN1cnNvclRvUG9zaXRpb24odCl9fSx0aGlzLnRvSlNPTj1mdW5jdGlvbigpe2lmKHRoaXMucmFuZ2VDb3VudCl2YXIgZT10aGlzLnJhbmdlcy5tYXAoZnVuY3Rpb24oZSl7dmFyIHQ9ZS5jbG9uZSgpO3JldHVybiB0LmlzQmFja3dhcmRzPWUuY3Vyc29yPT1lLnN0YXJ0LHR9KTtlbHNle3ZhciBlPXRoaXMuZ2V0UmFuZ2UoKTtlLmlzQmFja3dhcmRzPXRoaXMuaXNCYWNrd2FyZHMoKX1yZXR1cm4gZX0sdGhpcy5mcm9tSlNPTj1mdW5jdGlvbihlKXtpZihlLnN0YXJ0PT11bmRlZmluZWQpe2lmKHRoaXMucmFuZ2VMaXN0JiZlLmxlbmd0aD4xKXt0aGlzLnRvU2luZ2xlUmFuZ2UoZVswXSk7Zm9yKHZhciB0PWUubGVuZ3RoO3QtLTspe3ZhciBuPW8uZnJvbVBvaW50cyhlW3RdLnN0YXJ0LGVbdF0uZW5kKTtlW3RdLmlzQmFja3dhcmRzJiYobi5jdXJzb3I9bi5zdGFydCksdGhpcy5hZGRSYW5nZShuLCEwKX1yZXR1cm59ZT1lWzBdfXRoaXMucmFuZ2VMaXN0JiZ0aGlzLnRvU2luZ2xlUmFuZ2UoZSksdGhpcy5zZXRTZWxlY3Rpb25SYW5nZShlLGUuaXNCYWNrd2FyZHMpfSx0aGlzLmlzRXF1YWw9ZnVuY3Rpb24oZSl7aWYoKGUubGVuZ3RofHx0aGlzLnJhbmdlQ291bnQpJiZlLmxlbmd0aCE9dGhpcy5yYW5nZUNvdW50KXJldHVybiExO2lmKCFlLmxlbmd0aHx8IXRoaXMucmFuZ2VzKXJldHVybiB0aGlzLmdldFJhbmdlKCkuaXNFcXVhbChlKTtmb3IodmFyIHQ9dGhpcy5yYW5nZXMubGVuZ3RoO3QtLTspaWYoIXRoaXMucmFuZ2VzW3RdLmlzRXF1YWwoZVt0XSkpcmV0dXJuITE7cmV0dXJuITB9fSkuY2FsbCh1LnByb3RvdHlwZSksdC5TZWxlY3Rpb249dX0pLGRlZmluZSgiYWNlL3Rva2VuaXplciIsWyJyZXF1aXJlIiwiZXhwb3J0cyIsIm1vZHVsZSIsImFjZS9jb25maWciXSxmdW5jdGlvbihlLHQsbil7InVzZSBzdHJpY3QiO3ZhciByPWUoIi4vY29uZmlnIiksaT0yZTMscz1mdW5jdGlvbihlKXt0aGlzLnN0YXRlcz1lLHRoaXMucmVnRXhwcz17fSx0aGlzLm1hdGNoTWFwcGluZ3M9e307Zm9yKHZhciB0IGluIHRoaXMuc3RhdGVzKXt2YXIgbj10aGlzLnN0YXRlc1t0XSxyPVtdLGk9MCxzPXRoaXMubWF0Y2hNYXBwaW5nc1t0XT17ZGVmYXVsdFRva2VuOiJ0ZXh0In0sbz0iZyIsdT1bXTtmb3IodmFyIGE9MDthPG4ubGVuZ3RoO2ErKyl7dmFyIGY9blthXTtmLmRlZmF1bHRUb2tlbiYmKHMuZGVmYXVsdFRva2VuPWYuZGVmYXVsdFRva2VuKSxmLmNhc2VJbnNlbnNpdGl2ZSYmby5pbmRleE9mKCJpIik9PT0tMSYmKG8rPSJpIiksZi51bmljb2RlJiZvLmluZGV4T2YoInUiKT09PS0xJiYobys9InUiKTtpZihmLnJlZ2V4PT1udWxsKWNvbnRpbnVlO2YucmVnZXggaW5zdGFuY2VvZiBSZWdFeHAmJihmLnJlZ2V4PWYucmVnZXgudG9TdHJpbmcoKS5zbGljZSgxLC0xKSk7dmFyIGw9Zi5yZWdleCxjPShuZXcgUmVnRXhwKCIoPzooIitsKyIpfCguKSkiKSkuZXhlYygiYSIpLmxlbmd0aC0yO0FycmF5LmlzQXJyYXkoZi50b2tlbik/Zi50b2tlbi5sZW5ndGg9PTF8fGM9PTE/Zi50b2tlbj1mLnRva2VuWzBdOmMtMSE9Zi50b2tlbi5sZW5ndGg/KHRoaXMucmVwb3J0RXJyb3IoIm51bWJlciBvZiBjbGFzc2VzIGFuZCByZWdleHAgZ3JvdXBzIGRvZXNuJ3QgbWF0Y2giLHtydWxlOmYsZ3JvdXBDb3VudDpjLTF9KSxmLnRva2VuPWYudG9rZW5bMF0pOihmLnRva2VuQXJyYXk9Zi50b2tlbixmLnRva2VuPW51bGwsZi5vbk1hdGNoPXRoaXMuJGFycmF5VG9rZW5zKTp0eXBlb2YgZi50b2tlbj09ImZ1bmN0aW9uIiYmIWYub25NYXRjaCYmKGM+MT9mLm9uTWF0Y2g9dGhpcy4kYXBwbHlUb2tlbjpmLm9uTWF0Y2g9Zi50b2tlbiksYz4xJiYoL1xcXGQvLnRlc3QoZi5yZWdleCk/bD1mLnJlZ2V4LnJlcGxhY2UoL1xcKFswLTldKykvZyxmdW5jdGlvbihlLHQpe3JldHVybiJcXCIrKHBhcnNlSW50KHQsMTApK2krMSl9KTooYz0xLGw9dGhpcy5yZW1vdmVDYXB0dXJpbmdHcm91cHMoZi5yZWdleCkpLCFmLnNwbGl0UmVnZXgmJnR5cGVvZiBmLnRva2VuIT0ic3RyaW5nIiYmdS5wdXNoKGYpKSxzW2ldPWEsaSs9YyxyLnB1c2gobCksZi5vbk1hdGNofHwoZi5vbk1hdGNoPW51bGwpfXIubGVuZ3RofHwoc1swXT0wLHIucHVzaCgiJCIpKSx1LmZvckVhY2goZnVuY3Rpb24oZSl7ZS5zcGxpdFJlZ2V4PXRoaXMuY3JlYXRlU3BsaXR0ZXJSZWdleHAoZS5yZWdleCxvKX0sdGhpcyksdGhpcy5yZWdFeHBzW3RdPW5ldyBSZWdFeHAoIigiK3Iuam9pbigiKXwoIikrIil8KCQpIixvKX19OyhmdW5jdGlvbigpe3RoaXMuJHNldE1heFRva2VuQ291bnQ9ZnVuY3Rpb24oZSl7aT1lfDB9LHRoaXMuJGFwcGx5VG9rZW49ZnVuY3Rpb24oZSl7dmFyIHQ9dGhpcy5zcGxpdFJlZ2V4LmV4ZWMoZSkuc2xpY2UoMSksbj10aGlzLnRva2VuLmFwcGx5KHRoaXMsdCk7aWYodHlwZW9mIG49PSJzdHJpbmciKXJldHVyblt7dHlwZTpuLHZhbHVlOmV9XTt2YXIgcj1bXTtmb3IodmFyIGk9MCxzPW4ubGVuZ3RoO2k8cztpKyspdFtpXSYmKHJbci5sZW5ndGhdPXt0eXBlOm5baV0sdmFsdWU6dFtpXX0pO3JldHVybiByfSx0aGlzLiRhcnJheVRva2Vucz1mdW5jdGlvbihlKXtpZighZSlyZXR1cm5bXTt2YXIgdD10aGlzLnNwbGl0UmVnZXguZXhlYyhlKTtpZighdClyZXR1cm4idGV4dCI7dmFyIG49W10scj10aGlzLnRva2VuQXJyYXk7Zm9yKHZhciBpPTAscz1yLmxlbmd0aDtpPHM7aSsrKXRbaSsxXSYmKG5bbi5sZW5ndGhdPXt0eXBlOnJbaV0sdmFsdWU6dFtpKzFdfSk7cmV0dXJuIG59LHRoaXMucmVtb3ZlQ2FwdHVyaW5nR3JvdXBzPWZ1bmN0aW9uKGUpe3ZhciB0PWUucmVwbGFjZSgvXFwufFxbKD86XFwufFteXFxcXV0pKnxcKFw/Wzo9ITxdfChcKCkvZyxmdW5jdGlvbihlLHQpe3JldHVybiB0PyIoPzoiOmV9KTtyZXR1cm4gdH0sdGhpcy5jcmVhdGVTcGxpdHRlclJlZ2V4cD1mdW5jdGlvbihlLHQpe2lmKGUuaW5kZXhPZigiKD89IikhPS0xKXt2YXIgbj0wLHI9ITEsaT17fTtlLnJlcGxhY2UoLyhcXC4pfChcKCg/Olw/Wz0hXSk/KXwoXCkpfChbXFtcXV0pL2csZnVuY3Rpb24oZSx0LHMsbyx1LGEpe3JldHVybiByP3I9dSE9Il0iOnU/cj0hMDpvPyhuPT1pLnN0YWNrJiYoaS5lbmQ9YSsxLGkuc3RhY2s9LTEpLG4tLSk6cyYmKG4rKyxzLmxlbmd0aCE9MSYmKGkuc3RhY2s9bixpLnN0YXJ0PWEpKSxlfSksaS5lbmQhPW51bGwmJi9eXCkqJC8udGVzdChlLnN1YnN0cihpLmVuZCkpJiYoZT1lLnN1YnN0cmluZygwLGkuc3RhcnQpK2Uuc3Vic3RyKGkuZW5kKSl9cmV0dXJuIGUuY2hhckF0KDApIT0iXiImJihlPSJeIitlKSxlLmNoYXJBdChlLmxlbmd0aC0xKSE9IiQiJiYoZSs9IiQiKSxuZXcgUmVnRXhwKGUsKHR8fCIiKS5yZXBsYWNlKCJnIiwiIikpfSx0aGlzLmdldExpbmVUb2tlbnM9ZnVuY3Rpb24oZSx0KXtpZih0JiZ0eXBlb2YgdCE9InN0cmluZyIpe3ZhciBuPXQuc2xpY2UoMCk7dD1uWzBdLHQ9PT0iI3RtcCImJihuLnNoaWZ0KCksdD1uLnNoaWZ0KCkpfWVsc2UgdmFyIG49W107dmFyIHI9dHx8InN0YXJ0IixzPXRoaXMuc3RhdGVzW3JdO3N8fChyPSJzdGFydCIscz10aGlzLnN0YXRlc1tyXSk7dmFyIG89dGhpcy5tYXRjaE1hcHBpbmdzW3JdLHU9dGhpcy5yZWdFeHBzW3JdO3UubGFzdEluZGV4PTA7dmFyIGEsZj1bXSxsPTAsYz0wLGg9e3R5cGU6bnVsbCx2YWx1ZToiIn07d2hpbGUoYT11LmV4ZWMoZSkpe3ZhciBwPW8uZGVmYXVsdFRva2VuLGQ9bnVsbCx2PWFbMF0sbT11Lmxhc3RJbmRleDtpZihtLXYubGVuZ3RoPmwpe3ZhciBnPWUuc3Vic3RyaW5nKGwsbS12Lmxlbmd0aCk7aC50eXBlPT1wP2gudmFsdWUrPWc6KGgudHlwZSYmZi5wdXNoKGgpLGg9e3R5cGU6cCx2YWx1ZTpnfSl9Zm9yKHZhciB5PTA7eTxhLmxlbmd0aC0yO3krKyl7aWYoYVt5KzFdPT09dW5kZWZpbmVkKWNvbnRpbnVlO2Q9c1tvW3ldXSxkLm9uTWF0Y2g/cD1kLm9uTWF0Y2godixyLG4sZSk6cD1kLnRva2VuLGQubmV4dCYmKHR5cGVvZiBkLm5leHQ9PSJzdHJpbmciP3I9ZC5uZXh0OnI9ZC5uZXh0KHIsbikscz10aGlzLnN0YXRlc1tyXSxzfHwodGhpcy5yZXBvcnRFcnJvcigic3RhdGUgZG9lc24ndCBleGlzdCIscikscj0ic3RhcnQiLHM9dGhpcy5zdGF0ZXNbcl0pLG89dGhpcy5tYXRjaE1hcHBpbmdzW3JdLGw9bSx1PXRoaXMucmVnRXhwc1tyXSx1Lmxhc3RJbmRleD1tKSxkLmNvbnN1bWVMaW5lRW5kJiYobD1tKTticmVha31pZih2KWlmKHR5cGVvZiBwPT0ic3RyaW5nIikhIWQmJmQubWVyZ2U9PT0hMXx8aC50eXBlIT09cD8oaC50eXBlJiZmLnB1c2goaCksaD17dHlwZTpwLHZhbHVlOnZ9KTpoLnZhbHVlKz12O2Vsc2UgaWYocCl7aC50eXBlJiZmLnB1c2goaCksaD17dHlwZTpudWxsLHZhbHVlOiIifTtmb3IodmFyIHk9MDt5PHAubGVuZ3RoO3krKylmLnB1c2gocFt5XSl9aWYobD09ZS5sZW5ndGgpYnJlYWs7bD1tO2lmKGMrKz5pKXtjPjIqZS5sZW5ndGgmJnRoaXMucmVwb3J0RXJyb3IoImluZmluaXRlIGxvb3Agd2l0aCBpbiBhY2UgdG9rZW5pemVyIix7c3RhcnRTdGF0ZTp0LGxpbmU6ZX0pO3doaWxlKGw8ZS5sZW5ndGgpaC50eXBlJiZmLnB1c2goaCksaD17dmFsdWU6ZS5zdWJzdHJpbmcobCxsKz01MDApLHR5cGU6Im92ZXJmbG93In07cj0ic3RhcnQiLG49W107YnJlYWt9fXJldHVybiBoLnR5cGUmJmYucHVzaChoKSxuLmxlbmd0aD4xJiZuWzBdIT09ciYmbi51bnNoaWZ0KCIjdG1wIixyKSx7dG9rZW5zOmYsc3RhdGU6bi5sZW5ndGg/bjpyfX0sdGhpcy5yZXBvcnRFcnJvcj1yLnJlcG9ydEVycm9yfSkuY2FsbChzLnByb3RvdHlwZSksdC5Ub2tlbml6ZXI9c30pLGRlZmluZSgiYWNlL21vZGUvdGV4dF9oaWdobGlnaHRfcnVsZXMiLFsicmVxdWlyZSIsImV4cG9ydHMiLCJtb2R1bGUiLCJhY2UvbGliL2xhbmciXSxmdW5jdGlvbihlLHQsbil7InVzZSBzdHJpY3QiO3ZhciByPWUoIi4uL2xpYi9sYW5nIiksaT1mdW5jdGlvbigpe3RoaXMuJHJ1bGVzPXtzdGFydDpbe3Rva2VuOiJlbXB0eV9saW5lIixyZWdleDoiXiQifSx7ZGVmYXVsdFRva2VuOiJ0ZXh0In1dfX07KGZ1bmN0aW9uKCl7dGhpcy5hZGRSdWxlcz1mdW5jdGlvbihlLHQpe2lmKCF0KXtmb3IodmFyIG4gaW4gZSl0aGlzLiRydWxlc1tuXT1lW25dO3JldHVybn1mb3IodmFyIG4gaW4gZSl7dmFyIHI9ZVtuXTtmb3IodmFyIGk9MDtpPHIubGVuZ3RoO2krKyl7dmFyIHM9cltpXTtpZihzLm5leHR8fHMub25NYXRjaCl0eXBlb2Ygcy5uZXh0PT0ic3RyaW5nIiYmcy5uZXh0LmluZGV4T2YodCkhPT0wJiYocy5uZXh0PXQrcy5uZXh0KSxzLm5leHRTdGF0ZSYmcy5uZXh0U3RhdGUuaW5kZXhPZih0KSE9PTAmJihzLm5leHRTdGF0ZT10K3MubmV4dFN0YXRlKX10aGlzLiRydWxlc1t0K25dPXJ9fSx0aGlzLmdldFJ1bGVzPWZ1bmN0aW9uKCl7cmV0dXJuIHRoaXMuJHJ1bGVzfSx0aGlzLmVtYmVkUnVsZXM9ZnVuY3Rpb24oZSx0LG4saSxzKXt2YXIgbz10eXBlb2YgZT09ImZ1bmN0aW9uIj8obmV3IGUpLmdldFJ1bGVzKCk6ZTtpZihpKWZvcih2YXIgdT0wO3U8aS5sZW5ndGg7dSsrKWlbdV09dCtpW3VdO2Vsc2V7aT1bXTtmb3IodmFyIGEgaW4gbylpLnB1c2godCthKX10aGlzLmFkZFJ1bGVzKG8sdCk7aWYobil7dmFyIGY9QXJyYXkucHJvdG90eXBlW3M/InB1c2giOiJ1bnNoaWZ0Il07Zm9yKHZhciB1PTA7dTxpLmxlbmd0aDt1KyspZi5hcHBseSh0aGlzLiRydWxlc1tpW3VdXSxyLmRlZXBDb3B5KG4pKX10aGlzLiRlbWJlZHN8fCh0aGlzLiRlbWJlZHM9W10pLHRoaXMuJGVtYmVkcy5wdXNoKHQpfSx0aGlzLmdldEVtYmVkcz1mdW5jdGlvbigpe3JldHVybiB0aGlzLiRlbWJlZHN9O3ZhciBlPWZ1bmN0aW9uKGUsdCl7cmV0dXJuKGUhPSJzdGFydCJ8fHQubGVuZ3RoKSYmdC51bnNoaWZ0KHRoaXMubmV4dFN0YXRlLGUpLHRoaXMubmV4dFN0YXRlfSx0PWZ1bmN0aW9uKGUsdCl7cmV0dXJuIHQuc2hpZnQoKSx0LnNoaWZ0KCl8fCJzdGFydCJ9O3RoaXMubm9ybWFsaXplUnVsZXM9ZnVuY3Rpb24oKXtmdW5jdGlvbiBpKHMpe3ZhciBvPXJbc107by5wcm9jZXNzZWQ9ITA7Zm9yKHZhciB1PTA7dTxvLmxlbmd0aDt1Kyspe3ZhciBhPW9bdV0sZj1udWxsO0FycmF5LmlzQXJyYXkoYSkmJihmPWEsYT17fSksIWEucmVnZXgmJmEuc3RhcnQmJihhLnJlZ2V4PWEuc3RhcnQsYS5uZXh0fHwoYS5uZXh0PVtdKSxhLm5leHQucHVzaCh7ZGVmYXVsdFRva2VuOmEudG9rZW59LHt0b2tlbjphLnRva2VuKyIuZW5kIixyZWdleDphLmVuZHx8YS5zdGFydCxuZXh0OiJwb3AifSksYS50b2tlbj1hLnRva2VuKyIuc3RhcnQiLGEucHVzaD0hMCk7dmFyIGw9YS5uZXh0fHxhLnB1c2g7aWYobCYmQXJyYXkuaXNBcnJheShsKSl7dmFyIGM9YS5zdGF0ZU5hbWU7Y3x8KGM9YS50b2tlbix0eXBlb2YgYyE9InN0cmluZyImJihjPWNbMF18fCIiKSxyW2NdJiYoYys9bisrKSkscltjXT1sLGEubmV4dD1jLGkoYyl9ZWxzZSBsPT0icG9wIiYmKGEubmV4dD10KTthLnB1c2gmJihhLm5leHRTdGF0ZT1hLm5leHR8fGEucHVzaCxhLm5leHQ9ZSxkZWxldGUgYS5wdXNoKTtpZihhLnJ1bGVzKWZvcih2YXIgaCBpbiBhLnJ1bGVzKXJbaF0/cltoXS5wdXNoJiZyW2hdLnB1c2guYXBwbHkocltoXSxhLnJ1bGVzW2hdKTpyW2hdPWEucnVsZXNbaF07dmFyIHA9dHlwZW9mIGE9PSJzdHJpbmciP2E6YS5pbmNsdWRlO3AmJihBcnJheS5pc0FycmF5KHApP2Y9cC5tYXAoZnVuY3Rpb24oZSl7cmV0dXJuIHJbZV19KTpmPXJbcF0pO2lmKGYpe3ZhciBkPVt1LDFdLmNvbmNhdChmKTthLm5vRXNjYXBlJiYoZD1kLmZpbHRlcihmdW5jdGlvbihlKXtyZXR1cm4hZS5uZXh0fSkpLG8uc3BsaWNlLmFwcGx5KG8sZCksdS0tfWEua2V5d29yZE1hcCYmKGEudG9rZW49dGhpcy5jcmVhdGVLZXl3b3JkTWFwcGVyKGEua2V5d29yZE1hcCxhLmRlZmF1bHRUb2tlbnx8InRleHQiLGEuY2FzZUluc2Vuc2l0aXZlKSxkZWxldGUgYS5kZWZhdWx0VG9rZW4pfX12YXIgbj0wLHI9dGhpcy4kcnVsZXM7T2JqZWN0LmtleXMocikuZm9yRWFjaChpLHRoaXMpfSx0aGlzLmNyZWF0ZUtleXdvcmRNYXBwZXI9ZnVuY3Rpb24oZSx0LG4scil7dmFyIGk9T2JqZWN0LmNyZWF0ZShudWxsKTtyZXR1cm4gdGhpcy4ka2V5d29yZExpc3Q9W10sT2JqZWN0LmtleXMoZSkuZm9yRWFjaChmdW5jdGlvbih0KXt2YXIgcz1lW3RdLG89cy5zcGxpdChyfHwifCIpO2Zvcih2YXIgdT1vLmxlbmd0aDt1LS07KXt2YXIgYT1vW3VdO3RoaXMuJGtleXdvcmRMaXN0LnB1c2goYSksbiYmKGE9YS50b0xvd2VyQ2FzZSgpKSxpW2FdPXR9fSx0aGlzKSxlPW51bGwsbj9mdW5jdGlvbihlKXtyZXR1cm4gaVtlLnRvTG93ZXJDYXNlKCldfHx0fTpmdW5jdGlvbihlKXtyZXR1cm4gaVtlXXx8dH19LHRoaXMuZ2V0S2V5d29yZHM9ZnVuY3Rpb24oKXtyZXR1cm4gdGhpcy4ka2V5d29yZHN9fSkuY2FsbChpLnByb3RvdHlwZSksdC5UZXh0SGlnaGxpZ2h0UnVsZXM9aX0pLGRlZmluZSgiYWNlL21vZGUvYmVoYXZpb3VyIixbInJlcXVpcmUiLCJleHBvcnRzIiwibW9kdWxlIl0sZnVuY3Rpb24oZSx0LG4peyJ1c2Ugc3RyaWN0Ijt2YXIgcj1mdW5jdGlvbigpe3RoaXMuJGJlaGF2aW91cnM9e319OyhmdW5jdGlvbigpe3RoaXMuYWRkPWZ1bmN0aW9uKGUsdCxuKXtzd2l0Y2godW5kZWZpbmVkKXtjYXNlIHRoaXMuJGJlaGF2aW91cnM6dGhpcy4kYmVoYXZpb3Vycz17fTtjYXNlIHRoaXMuJGJlaGF2aW91cnNbZV06dGhpcy4kYmVoYXZpb3Vyc1tlXT17fX10aGlzLiRiZWhhdmlvdXJzW2VdW3RdPW59LHRoaXMuYWRkQmVoYXZpb3Vycz1mdW5jdGlvbihlKXtmb3IodmFyIHQgaW4gZSlmb3IodmFyIG4gaW4gZVt0XSl0aGlzLmFkZCh0LG4sZVt0XVtuXSl9LHRoaXMucmVtb3ZlPWZ1bmN0aW9uKGUpe3RoaXMuJGJlaGF2aW91cnMmJnRoaXMuJGJlaGF2aW91cnNbZV0mJmRlbGV0ZSB0aGlzLiRiZWhhdmlvdXJzW2VdfSx0aGlzLmluaGVyaXQ9ZnVuY3Rpb24oZSx0KXtpZih0eXBlb2YgZT09ImZ1bmN0aW9uIil2YXIgbj0obmV3IGUpLmdldEJlaGF2aW91cnModCk7ZWxzZSB2YXIgbj1lLmdldEJlaGF2aW91cnModCk7dGhpcy5hZGRCZWhhdmlvdXJzKG4pfSx0aGlzLmdldEJlaGF2aW91cnM9ZnVuY3Rpb24oZSl7aWYoIWUpcmV0dXJuIHRoaXMuJGJlaGF2aW91cnM7dmFyIHQ9e307Zm9yKHZhciBuPTA7bjxlLmxlbmd0aDtuKyspdGhpcy4kYmVoYXZpb3Vyc1tlW25dXSYmKHRbZVtuXV09dGhpcy4kYmVoYXZpb3Vyc1tlW25dXSk7cmV0dXJuIHR9fSkuY2FsbChyLnByb3RvdHlwZSksdC5CZWhhdmlvdXI9cn0pLGRlZmluZSgiYWNlL3Rva2VuX2l0ZXJhdG9yIixbInJlcXVpcmUiLCJleHBvcnRzIiwibW9kdWxlIiwiYWNlL3JhbmdlIl0sZnVuY3Rpb24oZSx0LG4peyJ1c2Ugc3RyaWN0Ijt2YXIgcj1lKCIuL3JhbmdlIikuUmFuZ2UsaT1mdW5jdGlvbihlLHQsbil7dGhpcy4kc2Vzc2lvbj1lLHRoaXMuJHJvdz10LHRoaXMuJHJvd1Rva2Vucz1lLmdldFRva2Vucyh0KTt2YXIgcj1lLmdldFRva2VuQXQodCxuKTt0aGlzLiR0b2tlbkluZGV4PXI/ci5pbmRleDotMX07KGZ1bmN0aW9uKCl7dGhpcy5zdGVwQmFja3dhcmQ9ZnVuY3Rpb24oKXt0aGlzLiR0b2tlbkluZGV4LT0xO3doaWxlKHRoaXMuJHRva2VuSW5kZXg8MCl7dGhpcy4kcm93LT0xO2lmKHRoaXMuJHJvdzwwKXJldHVybiB0aGlzLiRyb3c9MCxudWxsO3RoaXMuJHJvd1Rva2Vucz10aGlzLiRzZXNzaW9uLmdldFRva2Vucyh0aGlzLiRyb3cpLHRoaXMuJHRva2VuSW5kZXg9dGhpcy4kcm93VG9rZW5zLmxlbmd0aC0xfXJldHVybiB0aGlzLiRyb3dUb2tlbnNbdGhpcy4kdG9rZW5JbmRleF19LHRoaXMuc3RlcEZvcndhcmQ9ZnVuY3Rpb24oKXt0aGlzLiR0b2tlbkluZGV4Kz0xO3ZhciBlO3doaWxlKHRoaXMuJHRva2VuSW5kZXg+PXRoaXMuJHJvd1Rva2Vucy5sZW5ndGgpe3RoaXMuJHJvdys9MSxlfHwoZT10aGlzLiRzZXNzaW9uLmdldExlbmd0aCgpKTtpZih0aGlzLiRyb3c+PWUpcmV0dXJuIHRoaXMuJHJvdz1lLTEsbnVsbDt0aGlzLiRyb3dUb2tlbnM9dGhpcy4kc2Vzc2lvbi5nZXRUb2tlbnModGhpcy4kcm93KSx0aGlzLiR0b2tlbkluZGV4PTB9cmV0dXJuIHRoaXMuJHJvd1Rva2Vuc1t0aGlzLiR0b2tlbkluZGV4XX0sdGhpcy5nZXRDdXJyZW50VG9rZW49ZnVuY3Rpb24oKXtyZXR1cm4gdGhpcy4kcm93VG9rZW5zW3RoaXMuJHRva2VuSW5kZXhdfSx0aGlzLmdldEN1cnJlbnRUb2tlblJvdz1mdW5jdGlvbigpe3JldHVybiB0aGlzLiRyb3d9LHRoaXMuZ2V0Q3VycmVudFRva2VuQ29sdW1uPWZ1bmN0aW9uKCl7dmFyIGU9dGhpcy4kcm93VG9rZW5zLHQ9dGhpcy4kdG9rZW5JbmRleCxuPWVbdF0uc3RhcnQ7aWYobiE9PXVuZGVmaW5lZClyZXR1cm4gbjtuPTA7d2hpbGUodD4wKXQtPTEsbis9ZVt0XS52YWx1ZS5sZW5ndGg7cmV0dXJuIG59LHRoaXMuZ2V0Q3VycmVudFRva2VuUG9zaXRpb249ZnVuY3Rpb24oKXtyZXR1cm57cm93OnRoaXMuJHJvdyxjb2x1bW46dGhpcy5nZXRDdXJyZW50VG9rZW5Db2x1bW4oKX19LHRoaXMuZ2V0Q3VycmVudFRva2VuUmFuZ2U9ZnVuY3Rpb24oKXt2YXIgZT10aGlzLiRyb3dUb2tlbnNbdGhpcy4kdG9rZW5JbmRleF0sdD10aGlzLmdldEN1cnJlbnRUb2tlbkNvbHVtbigpO3JldHVybiBuZXcgcih0aGlzLiRyb3csdCx0aGlzLiRyb3csdCtlLnZhbHVlLmxlbmd0aCl9fSkuY2FsbChpLnByb3RvdHlwZSksdC5Ub2tlbkl0ZXJhdG9yPWl9KSxkZWZpbmUoImFjZS9tb2RlL2JlaGF2aW91ci9jc3R5bGUiLFsicmVxdWlyZSIsImV4cG9ydHMiLCJtb2R1bGUiLCJhY2UvbGliL29vcCIsImFjZS9tb2RlL2JlaGF2aW91ciIsImFjZS90b2tlbl9pdGVyYXRvciIsImFjZS9saWIvbGFuZyJdLGZ1bmN0aW9uKGUsdCxuKXsidXNlIHN0cmljdCI7dmFyIHI9ZSgiLi4vLi4vbGliL29vcCIpLGk9ZSgiLi4vYmVoYXZpb3VyIikuQmVoYXZpb3VyLHM9ZSgiLi4vLi4vdG9rZW5faXRlcmF0b3IiKS5Ub2tlbkl0ZXJhdG9yLG89ZSgiLi4vLi4vbGliL2xhbmciKSx1PVsidGV4dCIsInBhcmVuLnJwYXJlbiIsInJwYXJlbiIsInBhcmVuIiwicHVuY3R1YXRpb24ub3BlcmF0b3IiXSxhPVsidGV4dCIsInBhcmVuLnJwYXJlbiIsInJwYXJlbiIsInBhcmVuIiwicHVuY3R1YXRpb24ub3BlcmF0b3IiLCJjb21tZW50Il0sZixsPXt9LGM9eyciJzonIicsIiciOiInIn0saD1mdW5jdGlvbihlKXt2YXIgdD0tMTtlLm11bHRpU2VsZWN0JiYodD1lLnNlbGVjdGlvbi5pbmRleCxsLnJhbmdlQ291bnQhPWUubXVsdGlTZWxlY3QucmFuZ2VDb3VudCYmKGw9e3JhbmdlQ291bnQ6ZS5tdWx0aVNlbGVjdC5yYW5nZUNvdW50fSkpO2lmKGxbdF0pcmV0dXJuIGY9bFt0XTtmPWxbdF09e2F1dG9JbnNlcnRlZEJyYWNrZXRzOjAsYXV0b0luc2VydGVkUm93Oi0xLGF1dG9JbnNlcnRlZExpbmVFbmQ6IiIsbWF5YmVJbnNlcnRlZEJyYWNrZXRzOjAsbWF5YmVJbnNlcnRlZFJvdzotMSxtYXliZUluc2VydGVkTGluZVN0YXJ0OiIiLG1heWJlSW5zZXJ0ZWRMaW5lRW5kOiIifX0scD1mdW5jdGlvbihlLHQsbixyKXt2YXIgaT1lLmVuZC5yb3ctZS5zdGFydC5yb3c7cmV0dXJue3RleHQ6bit0K3Isc2VsZWN0aW9uOlswLGUuc3RhcnQuY29sdW1uKzEsaSxlLmVuZC5jb2x1bW4rKGk/MDoxKV19fSxkPWZ1bmN0aW9uKGUpe3RoaXMuYWRkKCJicmFjZXMiLCJpbnNlcnRpb24iLGZ1bmN0aW9uKHQsbixyLGkscyl7dmFyIHU9ci5nZXRDdXJzb3JQb3NpdGlvbigpLGE9aS5kb2MuZ2V0TGluZSh1LnJvdyk7aWYocz09InsiKXtoKHIpO3ZhciBsPXIuZ2V0U2VsZWN0aW9uUmFuZ2UoKSxjPWkuZG9jLmdldFRleHRSYW5nZShsKTtpZihjIT09IiImJmMhPT0ieyImJnIuZ2V0V3JhcEJlaGF2aW91cnNFbmFibGVkKCkpcmV0dXJuIHAobCxjLCJ7IiwifSIpO2lmKGQuaXNTYW5lSW5zZXJ0aW9uKHIsaSkpcmV0dXJuL1tcXVx9XCldLy50ZXN0KGFbdS5jb2x1bW5dKXx8ci5pbk11bHRpU2VsZWN0TW9kZXx8ZSYmZS5icmFjZXM/KGQucmVjb3JkQXV0b0luc2VydChyLGksIn0iKSx7dGV4dDoie30iLHNlbGVjdGlvbjpbMSwxXX0pOihkLnJlY29yZE1heWJlSW5zZXJ0KHIsaSwieyIpLHt0ZXh0OiJ7IixzZWxlY3Rpb246WzEsMV19KX1lbHNlIGlmKHM9PSJ9Iil7aChyKTt2YXIgdj1hLnN1YnN0cmluZyh1LmNvbHVtbix1LmNvbHVtbisxKTtpZih2PT0ifSIpe3ZhciBtPWkuJGZpbmRPcGVuaW5nQnJhY2tldCgifSIse2NvbHVtbjp1LmNvbHVtbisxLHJvdzp1LnJvd30pO2lmKG0hPT1udWxsJiZkLmlzQXV0b0luc2VydGVkQ2xvc2luZyh1LGEscykpcmV0dXJuIGQucG9wQXV0b0luc2VydGVkQ2xvc2luZygpLHt0ZXh0OiIiLHNlbGVjdGlvbjpbMSwxXX19fWVsc2V7aWYocz09IlxuInx8cz09IlxyXG4iKXtoKHIpO3ZhciBnPSIiO2QuaXNNYXliZUluc2VydGVkQ2xvc2luZyh1LGEpJiYoZz1vLnN0cmluZ1JlcGVhdCgifSIsZi5tYXliZUluc2VydGVkQnJhY2tldHMpLGQuY2xlYXJNYXliZUluc2VydGVkQ2xvc2luZygpKTt2YXIgdj1hLnN1YnN0cmluZyh1LmNvbHVtbix1LmNvbHVtbisxKTtpZih2PT09In0iKXt2YXIgeT1pLmZpbmRNYXRjaGluZ0JyYWNrZXQoe3Jvdzp1LnJvdyxjb2x1bW46dS5jb2x1bW4rMX0sIn0iKTtpZigheSlyZXR1cm4gbnVsbDt2YXIgYj10aGlzLiRnZXRJbmRlbnQoaS5nZXRMaW5lKHkucm93KSl9ZWxzZXtpZighZyl7ZC5jbGVhck1heWJlSW5zZXJ0ZWRDbG9zaW5nKCk7cmV0dXJufXZhciBiPXRoaXMuJGdldEluZGVudChhKX12YXIgdz1iK2kuZ2V0VGFiU3RyaW5nKCk7cmV0dXJue3RleHQ6IlxuIit3KyJcbiIrYitnLHNlbGVjdGlvbjpbMSx3Lmxlbmd0aCwxLHcubGVuZ3RoXX19ZC5jbGVhck1heWJlSW5zZXJ0ZWRDbG9zaW5nKCl9fSksdGhpcy5hZGQoImJyYWNlcyIsImRlbGV0aW9uIixmdW5jdGlvbihlLHQsbixyLGkpe3ZhciBzPXIuZG9jLmdldFRleHRSYW5nZShpKTtpZighaS5pc011bHRpTGluZSgpJiZzPT0ieyIpe2gobik7dmFyIG89ci5kb2MuZ2V0TGluZShpLnN0YXJ0LnJvdyksdT1vLnN1YnN0cmluZyhpLmVuZC5jb2x1bW4saS5lbmQuY29sdW1uKzEpO2lmKHU9PSJ9IilyZXR1cm4gaS5lbmQuY29sdW1uKyssaTtmLm1heWJlSW5zZXJ0ZWRCcmFja2V0cy0tfX0pLHRoaXMuYWRkKCJwYXJlbnMiLCJpbnNlcnRpb24iLGZ1bmN0aW9uKGUsdCxuLHIsaSl7aWYoaT09IigiKXtoKG4pO3ZhciBzPW4uZ2V0U2VsZWN0aW9uUmFuZ2UoKSxvPXIuZG9jLmdldFRleHRSYW5nZShzKTtpZihvIT09IiImJm4uZ2V0V3JhcEJlaGF2aW91cnNFbmFibGVkKCkpcmV0dXJuIHAocyxvLCIoIiwiKSIpO2lmKGQuaXNTYW5lSW5zZXJ0aW9uKG4scikpcmV0dXJuIGQucmVjb3JkQXV0b0luc2VydChuLHIsIikiKSx7dGV4dDoiKCkiLHNlbGVjdGlvbjpbMSwxXX19ZWxzZSBpZihpPT0iKSIpe2gobik7dmFyIHU9bi5nZXRDdXJzb3JQb3NpdGlvbigpLGE9ci5kb2MuZ2V0TGluZSh1LnJvdyksZj1hLnN1YnN0cmluZyh1LmNvbHVtbix1LmNvbHVtbisxKTtpZihmPT0iKSIpe3ZhciBsPXIuJGZpbmRPcGVuaW5nQnJhY2tldCgiKSIse2NvbHVtbjp1LmNvbHVtbisxLHJvdzp1LnJvd30pO2lmKGwhPT1udWxsJiZkLmlzQXV0b0luc2VydGVkQ2xvc2luZyh1LGEsaSkpcmV0dXJuIGQucG9wQXV0b0luc2VydGVkQ2xvc2luZygpLHt0ZXh0OiIiLHNlbGVjdGlvbjpbMSwxXX19fX0pLHRoaXMuYWRkKCJwYXJlbnMiLCJkZWxldGlvbiIsZnVuY3Rpb24oZSx0LG4scixpKXt2YXIgcz1yLmRvYy5nZXRUZXh0UmFuZ2UoaSk7aWYoIWkuaXNNdWx0aUxpbmUoKSYmcz09IigiKXtoKG4pO3ZhciBvPXIuZG9jLmdldExpbmUoaS5zdGFydC5yb3cpLHU9by5zdWJzdHJpbmcoaS5zdGFydC5jb2x1bW4rMSxpLnN0YXJ0LmNvbHVtbisyKTtpZih1PT0iKSIpcmV0dXJuIGkuZW5kLmNvbHVtbisrLGl9fSksdGhpcy5hZGQoImJyYWNrZXRzIiwiaW5zZXJ0aW9uIixmdW5jdGlvbihlLHQsbixyLGkpe2lmKGk9PSJbIil7aChuKTt2YXIgcz1uLmdldFNlbGVjdGlvblJhbmdlKCksbz1yLmRvYy5nZXRUZXh0UmFuZ2Uocyk7aWYobyE9PSIiJiZuLmdldFdyYXBCZWhhdmlvdXJzRW5hYmxlZCgpKXJldHVybiBwKHMsbywiWyIsIl0iKTtpZihkLmlzU2FuZUluc2VydGlvbihuLHIpKXJldHVybiBkLnJlY29yZEF1dG9JbnNlcnQobixyLCJdIikse3RleHQ6IltdIixzZWxlY3Rpb246WzEsMV19fWVsc2UgaWYoaT09Il0iKXtoKG4pO3ZhciB1PW4uZ2V0Q3Vyc29yUG9zaXRpb24oKSxhPXIuZG9jLmdldExpbmUodS5yb3cpLGY9YS5zdWJzdHJpbmcodS5jb2x1bW4sdS5jb2x1bW4rMSk7aWYoZj09Il0iKXt2YXIgbD1yLiRmaW5kT3BlbmluZ0JyYWNrZXQoIl0iLHtjb2x1bW46dS5jb2x1bW4rMSxyb3c6dS5yb3d9KTtpZihsIT09bnVsbCYmZC5pc0F1dG9JbnNlcnRlZENsb3NpbmcodSxhLGkpKXJldHVybiBkLnBvcEF1dG9JbnNlcnRlZENsb3NpbmcoKSx7dGV4dDoiIixzZWxlY3Rpb246WzEsMV19fX19KSx0aGlzLmFkZCgiYnJhY2tldHMiLCJkZWxldGlvbiIsZnVuY3Rpb24oZSx0LG4scixpKXt2YXIgcz1yLmRvYy5nZXRUZXh0UmFuZ2UoaSk7aWYoIWkuaXNNdWx0aUxpbmUoKSYmcz09IlsiKXtoKG4pO3ZhciBvPXIuZG9jLmdldExpbmUoaS5zdGFydC5yb3cpLHU9by5zdWJzdHJpbmcoaS5zdGFydC5jb2x1bW4rMSxpLnN0YXJ0LmNvbHVtbisyKTtpZih1PT0iXSIpcmV0dXJuIGkuZW5kLmNvbHVtbisrLGl9fSksdGhpcy5hZGQoInN0cmluZ19kcXVvdGVzIiwiaW5zZXJ0aW9uIixmdW5jdGlvbihlLHQsbixyLGkpe3ZhciBzPXIuJG1vZGUuJHF1b3Rlc3x8YztpZihpLmxlbmd0aD09MSYmc1tpXSl7aWYodGhpcy5saW5lQ29tbWVudFN0YXJ0JiZ0aGlzLmxpbmVDb21tZW50U3RhcnQuaW5kZXhPZihpKSE9LTEpcmV0dXJuO2gobik7dmFyIG89aSx1PW4uZ2V0U2VsZWN0aW9uUmFuZ2UoKSxhPXIuZG9jLmdldFRleHRSYW5nZSh1KTtpZihhIT09IiImJihhLmxlbmd0aCE9MXx8IXNbYV0pJiZuLmdldFdyYXBCZWhhdmlvdXJzRW5hYmxlZCgpKXJldHVybiBwKHUsYSxvLG8pO2lmKCFhKXt2YXIgZj1uLmdldEN1cnNvclBvc2l0aW9uKCksbD1yLmRvYy5nZXRMaW5lKGYucm93KSxkPWwuc3Vic3RyaW5nKGYuY29sdW1uLTEsZi5jb2x1bW4pLHY9bC5zdWJzdHJpbmcoZi5jb2x1bW4sZi5jb2x1bW4rMSksbT1yLmdldFRva2VuQXQoZi5yb3csZi5jb2x1bW4pLGc9ci5nZXRUb2tlbkF0KGYucm93LGYuY29sdW1uKzEpO2lmKGQ9PSJcXCImJm0mJi9lc2NhcGUvLnRlc3QobS50eXBlKSlyZXR1cm4gbnVsbDt2YXIgeT1tJiYvc3RyaW5nfGVzY2FwZS8udGVzdChtLnR5cGUpLGI9IWd8fC9zdHJpbmd8ZXNjYXBlLy50ZXN0KGcudHlwZSksdztpZih2PT1vKXc9eSE9PWIsdyYmL3N0cmluZ1wuZW5kLy50ZXN0KGcudHlwZSkmJih3PSExKTtlbHNle2lmKHkmJiFiKXJldHVybiBudWxsO2lmKHkmJmIpcmV0dXJuIG51bGw7dmFyIEU9ci4kbW9kZS50b2tlblJlO0UubGFzdEluZGV4PTA7dmFyIFM9RS50ZXN0KGQpO0UubGFzdEluZGV4PTA7dmFyIHg9RS50ZXN0KGQpO2lmKFN8fHgpcmV0dXJuIG51bGw7aWYodiYmIS9bXHM7LC59KVxdXFxdLy50ZXN0KHYpKXJldHVybiBudWxsO3ZhciBUPWxbZi5jb2x1bW4tMl07aWYoIShkIT1vfHxUIT1vJiYhRS50ZXN0KFQpKSlyZXR1cm4gbnVsbDt3PSEwfXJldHVybnt0ZXh0Onc/bytvOiIiLHNlbGVjdGlvbjpbMSwxXX19fX0pLHRoaXMuYWRkKCJzdHJpbmdfZHF1b3RlcyIsImRlbGV0aW9uIixmdW5jdGlvbihlLHQsbixyLGkpe3ZhciBzPXIuJG1vZGUuJHF1b3Rlc3x8YyxvPXIuZG9jLmdldFRleHRSYW5nZShpKTtpZighaS5pc011bHRpTGluZSgpJiZzLmhhc093blByb3BlcnR5KG8pKXtoKG4pO3ZhciB1PXIuZG9jLmdldExpbmUoaS5zdGFydC5yb3cpLGE9dS5zdWJzdHJpbmcoaS5zdGFydC5jb2x1bW4rMSxpLnN0YXJ0LmNvbHVtbisyKTtpZihhPT1vKXJldHVybiBpLmVuZC5jb2x1bW4rKyxpfX0pfTtkLmlzU2FuZUluc2VydGlvbj1mdW5jdGlvbihlLHQpe3ZhciBuPWUuZ2V0Q3Vyc29yUG9zaXRpb24oKSxyPW5ldyBzKHQsbi5yb3csbi5jb2x1bW4pO2lmKCF0aGlzLiRtYXRjaFRva2VuVHlwZShyLmdldEN1cnJlbnRUb2tlbigpfHwidGV4dCIsdSkpe2lmKC9bKX1cXV0vLnRlc3QoZS5zZXNzaW9uLmdldExpbmUobi5yb3cpW24uY29sdW1uXSkpcmV0dXJuITA7dmFyIGk9bmV3IHModCxuLnJvdyxuLmNvbHVtbisxKTtpZighdGhpcy4kbWF0Y2hUb2tlblR5cGUoaS5nZXRDdXJyZW50VG9rZW4oKXx8InRleHQiLHUpKXJldHVybiExfXJldHVybiByLnN0ZXBGb3J3YXJkKCksci5nZXRDdXJyZW50VG9rZW5Sb3coKSE9PW4ucm93fHx0aGlzLiRtYXRjaFRva2VuVHlwZShyLmdldEN1cnJlbnRUb2tlbigpfHwidGV4dCIsYSl9LGQuJG1hdGNoVG9rZW5UeXBlPWZ1bmN0aW9uKGUsdCl7cmV0dXJuIHQuaW5kZXhPZihlLnR5cGV8fGUpPi0xfSxkLnJlY29yZEF1dG9JbnNlcnQ9ZnVuY3Rpb24oZSx0LG4pe3ZhciByPWUuZ2V0Q3Vyc29yUG9zaXRpb24oKSxpPXQuZG9jLmdldExpbmUoci5yb3cpO3RoaXMuaXNBdXRvSW5zZXJ0ZWRDbG9zaW5nKHIsaSxmLmF1dG9JbnNlcnRlZExpbmVFbmRbMF0pfHwoZi5hdXRvSW5zZXJ0ZWRCcmFja2V0cz0wKSxmLmF1dG9JbnNlcnRlZFJvdz1yLnJvdyxmLmF1dG9JbnNlcnRlZExpbmVFbmQ9bitpLnN1YnN0cihyLmNvbHVtbiksZi5hdXRvSW5zZXJ0ZWRCcmFja2V0cysrfSxkLnJlY29yZE1heWJlSW5zZXJ0PWZ1bmN0aW9uKGUsdCxuKXt2YXIgcj1lLmdldEN1cnNvclBvc2l0aW9uKCksaT10LmRvYy5nZXRMaW5lKHIucm93KTt0aGlzLmlzTWF5YmVJbnNlcnRlZENsb3NpbmcocixpKXx8KGYubWF5YmVJbnNlcnRlZEJyYWNrZXRzPTApLGYubWF5YmVJbnNlcnRlZFJvdz1yLnJvdyxmLm1heWJlSW5zZXJ0ZWRMaW5lU3RhcnQ9aS5zdWJzdHIoMCxyLmNvbHVtbikrbixmLm1heWJlSW5zZXJ0ZWRMaW5lRW5kPWkuc3Vic3RyKHIuY29sdW1uKSxmLm1heWJlSW5zZXJ0ZWRCcmFja2V0cysrfSxkLmlzQXV0b0luc2VydGVkQ2xvc2luZz1mdW5jdGlvbihlLHQsbil7cmV0dXJuIGYuYXV0b0luc2VydGVkQnJhY2tldHM+MCYmZS5yb3c9PT1mLmF1dG9JbnNlcnRlZFJvdyYmbj09PWYuYXV0b0luc2VydGVkTGluZUVuZFswXSYmdC5zdWJzdHIoZS5jb2x1bW4pPT09Zi5hdXRvSW5zZXJ0ZWRMaW5lRW5kfSxkLmlzTWF5YmVJbnNlcnRlZENsb3Npbmc9ZnVuY3Rpb24oZSx0KXtyZXR1cm4gZi5tYXliZUluc2VydGVkQnJhY2tldHM+MCYmZS5yb3c9PT1mLm1heWJlSW5zZXJ0ZWRSb3cmJnQuc3Vic3RyKGUuY29sdW1uKT09PWYubWF5YmVJbnNlcnRlZExpbmVFbmQmJnQuc3Vic3RyKDAsZS5jb2x1bW4pPT1mLm1heWJlSW5zZXJ0ZWRMaW5lU3RhcnR9LGQucG9wQXV0b0luc2VydGVkQ2xvc2luZz1mdW5jdGlvbigpe2YuYXV0b0luc2VydGVkTGluZUVuZD1mLmF1dG9JbnNlcnRlZExpbmVFbmQuc3Vic3RyKDEpLGYuYXV0b0luc2VydGVkQnJhY2tldHMtLX0sZC5jbGVhck1heWJlSW5zZXJ0ZWRDbG9zaW5nPWZ1bmN0aW9uKCl7ZiYmKGYubWF5YmVJbnNlcnRlZEJyYWNrZXRzPTAsZi5tYXliZUluc2VydGVkUm93PS0xKX0sci5pbmhlcml0cyhkLGkpLHQuQ3N0eWxlQmVoYXZpb3VyPWR9KSxkZWZpbmUoImFjZS91bmljb2RlIixbInJlcXVpcmUiLCJleHBvcnRzIiwibW9kdWxlIl0sZnVuY3Rpb24oZSx0LG4peyJ1c2Ugc3RyaWN0Ijt2YXIgcj1bNDgsOSw4LDI1LDUsMCwyLDI1LDQ4LDAsMTEsMCw1LDAsNiwyMiwyLDMwLDIsNDU3LDUsMTEsMTUsNCw4LDAsMiwwLDE4LDExNiwyLDEsMywzLDksMCwyLDIsMiwwLDIsMTksMiw4MiwyLDEzOCwyLDQsMywxNTUsMTIsMzcsMywwLDgsMzgsMTAsNDQsMiwwLDIsMSwyLDEsMiwwLDksMjYsNiwyLDMwLDEwLDcsNjEsMiw5LDUsMTAxLDIsNywzLDksMiwxOCwzLDAsMTcsNTgsMywxMDAsMTUsNTMsNSwwLDYsNDUsMjExLDU3LDMsMTgsMiw1LDMsMTEsMyw5LDIsMSw3LDYsMiwyLDIsNywzLDEsMywyMSwyLDYsMiwwLDQsMywzLDgsMywxLDMsMyw5LDAsNSwxLDIsNCwzLDExLDE2LDIsMiw1LDUsMSwzLDIxLDIsNiwyLDEsMiwxLDIsMSwzLDAsMiw0LDUsMSwzLDIsNCwwLDgsMywyLDAsOCwxNSwxMiwyLDIsOCwyLDIsMiwyMSwyLDYsMiwxLDIsNCwzLDksMiwyLDIsMiwzLDAsMTYsMywzLDksMTgsMiwyLDcsMywxLDMsMjEsMiw2LDIsMSwyLDQsMyw4LDMsMSwzLDIsOSwxLDUsMSwyLDQsMyw5LDIsMCwxNywxLDIsNSw0LDIsMiwzLDQsMSwyLDAsMiwxLDQsMSw0LDIsNCwxMSw1LDQsNCwyLDIsMywzLDAsNywwLDE1LDksMTgsMiwyLDcsMiwyLDIsMjIsMiw5LDIsNCw0LDcsMiwyLDIsMyw4LDEsMiwxLDcsMywzLDksMTksMSwyLDcsMiwyLDIsMjIsMiw5LDIsNCwzLDgsMiwyLDIsMyw4LDEsOCwwLDIsMywzLDksMTksMSwyLDcsMiwyLDIsMjIsMiwxNSw0LDcsMiwyLDIsMywxMCwwLDksMywzLDksMTEsNSwzLDEsMiwxNyw0LDIzLDIsOCwyLDAsMyw2LDQsMCw1LDUsMiwwLDIsNywxOSwxLDE0LDU3LDYsMTQsMiw5LDQwLDEsMiwwLDMsMSwyLDAsMywwLDcsMywyLDYsMiwyLDIsMCwyLDAsMywxLDIsMTIsMiwyLDMsNCwyLDAsMiw1LDMsOSwzLDEsMzUsMCwyNCwxLDcsOSwxMiwwLDIsMCwyLDAsNSw5LDIsMzUsNSwxOSwyLDUsNSw3LDIsMzUsMTAsMCw1OCw3Myw3LDc3LDMsMzcsMTEsNDIsMiwwLDQsMzI4LDIsMywzLDYsMiwwLDIsMywzLDQwLDIsMywzLDMyLDIsMywzLDYsMiwwLDIsMywzLDE0LDIsNTYsMiwzLDMsNjYsNSwwLDMzLDE1LDE3LDg0LDEzLDYxOSwzLDE2LDIsMjUsNiw3NCwyMiwxMiwyLDYsMTIsMjAsMTIsMTksMTMsMTIsMiwyLDIsMSwxMyw1MSwzLDI5LDQsMCw1LDEsMyw5LDM0LDIsMyw5LDcsODcsOSw0Miw2LDY5LDExLDI4LDQsMTEsNSwxMSwxMSwzOSwzLDQsMTIsNDMsNSwyNSw3LDEwLDM4LDI3LDUsNjIsMiwyOCwzLDEwLDcsOSwxNCwwLDg5LDc1LDUsOSwxOCw4LDEzLDQyLDQsMTEsNzEsNTUsOSw5LDQsNDgsODMsMiwyLDMwLDE0LDIzMCwyMywyODAsMyw1LDMsMzcsMyw1LDMsNywyLDAsMiwwLDIsMCwyLDMwLDMsNTIsMiw2LDIsMCw0LDIsMiw2LDQsMywzLDUsNSwxMiw2LDIsMiw2LDY3LDEsMjAsMCwyOSwwLDE0LDAsMTcsNCw2MCwxMiw1LDAsNCwxMSwxOCwwLDUsMCwzLDksMiwwLDQsNCw3LDAsMiwwLDIsMCwyLDMsMiwxMCwzLDMsNiw0LDUsMCw1MywxLDI2ODQsNDYsMiw0NiwyLDEzMiw3LDYsMTUsMzcsMTEsNTMsMTAsMCwxNywyMiwxMCw2LDIsNiwyLDYsMiw2LDIsNiwyLDYsMiw2LDIsNiwyLDMxLDQ4LDAsNDcwLDEsMzYsNSwyLDQsNiwxLDUsODUsMywxLDMsMiwyLDg5LDIsMyw2LDQwLDQsOTMsMTgsMjMsNTcsMTUsNTEzLDY1ODEsNzUsMjA5MzksNTMsMTE2NCw2OCw0NSwzLDI2OCw0LDI3LDIxLDMxLDMsMTMsMTMsMSwyLDI0LDksNjksMTEsMSwzOCw4LDMsMTAyLDMsMSwxMTEsNDQsMjUsNTEsMTMsNjgsMTIsOSw3LDIzLDQsMCw1LDQ1LDMsMzUsMTMsMjgsNCw2NCwxNSwxMCwzOSw1NCwxMCwxMywzLDksNywyMiw0LDEsNSw2NiwyNSwyLDIyNyw0MiwyLDEsMyw5LDcsMTExNzEsMTMsMjIsNSw0OCw4NDUzLDMwMSwzLDYxLDMsMTA1LDM5LDYsMTMsNCw2LDExLDIsMTIsMiw0LDIsMCwyLDEsMiwxLDIsMTA3LDM0LDM2MiwxOSw2MywzLDUzLDQxLDExLDUsMTUsMTcsNiwxMywxLDI1LDIsMzMsNCwyLDEzNCwyMCw5LDgsMjUsNSwwLDIsMjUsMTIsODgsNCw1LDMsNSwzLDUsMywyXSxpPTAscz1bXTtmb3IodmFyIG89MDtvPHIubGVuZ3RoO28rPTIpcy5wdXNoKGkrPXJbb10pLHJbbysxXSYmcy5wdXNoKDQ1LGkrPXJbbysxXSk7dC53b3JkQ2hhcnM9U3RyaW5nLmZyb21DaGFyQ29kZS5hcHBseShudWxsLHMpfSksZGVmaW5lKCJhY2UvbW9kZS90ZXh0IixbInJlcXVpcmUiLCJleHBvcnRzIiwibW9kdWxlIiwiYWNlL2NvbmZpZyIsImFjZS90b2tlbml6ZXIiLCJhY2UvbW9kZS90ZXh0X2hpZ2hsaWdodF9ydWxlcyIsImFjZS9tb2RlL2JlaGF2aW91ci9jc3R5bGUiLCJhY2UvdW5pY29kZSIsImFjZS9saWIvbGFuZyIsImFjZS90b2tlbl9pdGVyYXRvciIsImFjZS9yYW5nZSJdLGZ1bmN0aW9uKGUsdCxuKXsidXNlIHN0cmljdCI7dmFyIHI9ZSgiLi4vY29uZmlnIiksaT1lKCIuLi90b2tlbml6ZXIiKS5Ub2tlbml6ZXIscz1lKCIuL3RleHRfaGlnaGxpZ2h0X3J1bGVzIikuVGV4dEhpZ2hsaWdodFJ1bGVzLG89ZSgiLi9iZWhhdmlvdXIvY3N0eWxlIikuQ3N0eWxlQmVoYXZpb3VyLHU9ZSgiLi4vdW5pY29kZSIpLGE9ZSgiLi4vbGliL2xhbmciKSxmPWUoIi4uL3Rva2VuX2l0ZXJhdG9yIikuVG9rZW5JdGVyYXRvcixsPWUoIi4uL3JhbmdlIikuUmFuZ2UsYz1mdW5jdGlvbigpe3RoaXMuSGlnaGxpZ2h0UnVsZXM9c307KGZ1bmN0aW9uKCl7dGhpcy4kZGVmYXVsdEJlaGF2aW91cj1uZXcgbyx0aGlzLnRva2VuUmU9bmV3IFJlZ0V4cCgiXlsiK3Uud29yZENoYXJzKyJcXCRfXSsiLCJnIiksdGhpcy5ub25Ub2tlblJlPW5ldyBSZWdFeHAoIl4oPzpbXiIrdS53b3JkQ2hhcnMrIlxcJF9dfFxcc10pKyIsImciKSx0aGlzLmdldFRva2VuaXplcj1mdW5jdGlvbigpe3JldHVybiB0aGlzLiR0b2tlbml6ZXJ8fCh0aGlzLiRoaWdobGlnaHRSdWxlcz10aGlzLiRoaWdobGlnaHRSdWxlc3x8bmV3IHRoaXMuSGlnaGxpZ2h0UnVsZXModGhpcy4kaGlnaGxpZ2h0UnVsZUNvbmZpZyksdGhpcy4kdG9rZW5pemVyPW5ldyBpKHRoaXMuJGhpZ2hsaWdodFJ1bGVzLmdldFJ1bGVzKCkpKSx0aGlzLiR0b2tlbml6ZXJ9LHRoaXMubGluZUNvbW1lbnRTdGFydD0iIix0aGlzLmJsb2NrQ29tbWVudD0iIix0aGlzLnRvZ2dsZUNvbW1lbnRMaW5lcz1mdW5jdGlvbihlLHQsbixyKXtmdW5jdGlvbiB3KGUpe2Zvcih2YXIgdD1uO3Q8PXI7dCsrKWUoaS5nZXRMaW5lKHQpLHQpfXZhciBpPXQuZG9jLHM9ITAsbz0hMCx1PUluZmluaXR5LGY9dC5nZXRUYWJTaXplKCksbD0hMTtpZighdGhpcy5saW5lQ29tbWVudFN0YXJ0KXtpZighdGhpcy5ibG9ja0NvbW1lbnQpcmV0dXJuITE7dmFyIGM9dGhpcy5ibG9ja0NvbW1lbnQuc3RhcnQsaD10aGlzLmJsb2NrQ29tbWVudC5lbmQscD1uZXcgUmVnRXhwKCJeKFxccyopKD86IithLmVzY2FwZVJlZ0V4cChjKSsiKSIpLGQ9bmV3IFJlZ0V4cCgiKD86IithLmVzY2FwZVJlZ0V4cChoKSsiKVxccyokIiksdj1mdW5jdGlvbihlLHQpe2lmKGcoZSx0KSlyZXR1cm47aWYoIXN8fC9cUy8udGVzdChlKSlpLmluc2VydEluTGluZSh7cm93OnQsY29sdW1uOmUubGVuZ3RofSxoKSxpLmluc2VydEluTGluZSh7cm93OnQsY29sdW1uOnV9LGMpfSxtPWZ1bmN0aW9uKGUsdCl7dmFyIG47KG49ZS5tYXRjaChkKSkmJmkucmVtb3ZlSW5MaW5lKHQsZS5sZW5ndGgtblswXS5sZW5ndGgsZS5sZW5ndGgpLChuPWUubWF0Y2gocCkpJiZpLnJlbW92ZUluTGluZSh0LG5bMV0ubGVuZ3RoLG5bMF0ubGVuZ3RoKX0sZz1mdW5jdGlvbihlLG4pe2lmKHAudGVzdChlKSlyZXR1cm4hMDt2YXIgcj10LmdldFRva2VucyhuKTtmb3IodmFyIGk9MDtpPHIubGVuZ3RoO2krKylpZihyW2ldLnR5cGU9PT0iY29tbWVudCIpcmV0dXJuITB9fWVsc2V7aWYoQXJyYXkuaXNBcnJheSh0aGlzLmxpbmVDb21tZW50U3RhcnQpKXZhciBwPXRoaXMubGluZUNvbW1lbnRTdGFydC5tYXAoYS5lc2NhcGVSZWdFeHApLmpvaW4oInwiKSxjPXRoaXMubGluZUNvbW1lbnRTdGFydFswXTtlbHNlIHZhciBwPWEuZXNjYXBlUmVnRXhwKHRoaXMubGluZUNvbW1lbnRTdGFydCksYz10aGlzLmxpbmVDb21tZW50U3RhcnQ7cD1uZXcgUmVnRXhwKCJeKFxccyopKD86IitwKyIpID8iKSxsPXQuZ2V0VXNlU29mdFRhYnMoKTt2YXIgbT1mdW5jdGlvbihlLHQpe3ZhciBuPWUubWF0Y2gocCk7aWYoIW4pcmV0dXJuO3ZhciByPW5bMV0ubGVuZ3RoLHM9blswXS5sZW5ndGg7IWIoZSxyLHMpJiZuWzBdW3MtMV09PSIgIiYmcy0tLGkucmVtb3ZlSW5MaW5lKHQscixzKX0seT1jKyIgIix2PWZ1bmN0aW9uKGUsdCl7aWYoIXN8fC9cUy8udGVzdChlKSliKGUsdSx1KT9pLmluc2VydEluTGluZSh7cm93OnQsY29sdW1uOnV9LHkpOmkuaW5zZXJ0SW5MaW5lKHtyb3c6dCxjb2x1bW46dX0sYyl9LGc9ZnVuY3Rpb24oZSx0KXtyZXR1cm4gcC50ZXN0KGUpfSxiPWZ1bmN0aW9uKGUsdCxuKXt2YXIgcj0wO3doaWxlKHQtLSYmZS5jaGFyQXQodCk9PSIgIilyKys7aWYociVmIT0wKXJldHVybiExO3ZhciByPTA7d2hpbGUoZS5jaGFyQXQobisrKT09IiAiKXIrKztyZXR1cm4gZj4yP3IlZiE9Zi0xOnIlZj09MH19dmFyIEU9SW5maW5pdHk7dyhmdW5jdGlvbihlLHQpe3ZhciBuPWUuc2VhcmNoKC9cUy8pO24hPT0tMT8objx1JiYodT1uKSxvJiYhZyhlLHQpJiYobz0hMSkpOkU+ZS5sZW5ndGgmJihFPWUubGVuZ3RoKX0pLHU9PUluZmluaXR5JiYodT1FLHM9ITEsbz0hMSksbCYmdSVmIT0wJiYodT1NYXRoLmZsb29yKHUvZikqZiksdyhvP206dil9LHRoaXMudG9nZ2xlQmxvY2tDb21tZW50PWZ1bmN0aW9uKGUsdCxuLHIpe3ZhciBpPXRoaXMuYmxvY2tDb21tZW50O2lmKCFpKXJldHVybjshaS5zdGFydCYmaVswXSYmKGk9aVswXSk7dmFyIHM9bmV3IGYodCxyLnJvdyxyLmNvbHVtbiksbz1zLmdldEN1cnJlbnRUb2tlbigpLHU9dC5zZWxlY3Rpb24sYT10LnNlbGVjdGlvbi50b09yaWVudGVkUmFuZ2UoKSxjLGg7aWYobyYmL2NvbW1lbnQvLnRlc3Qoby50eXBlKSl7dmFyIHAsZDt3aGlsZShvJiYvY29tbWVudC8udGVzdChvLnR5cGUpKXt2YXIgdj1vLnZhbHVlLmluZGV4T2YoaS5zdGFydCk7aWYodiE9LTEpe3ZhciBtPXMuZ2V0Q3VycmVudFRva2VuUm93KCksZz1zLmdldEN1cnJlbnRUb2tlbkNvbHVtbigpK3Y7cD1uZXcgbChtLGcsbSxnK2kuc3RhcnQubGVuZ3RoKTticmVha31vPXMuc3RlcEJhY2t3YXJkKCl9dmFyIHM9bmV3IGYodCxyLnJvdyxyLmNvbHVtbiksbz1zLmdldEN1cnJlbnRUb2tlbigpO3doaWxlKG8mJi9jb21tZW50Ly50ZXN0KG8udHlwZSkpe3ZhciB2PW8udmFsdWUuaW5kZXhPZihpLmVuZCk7aWYodiE9LTEpe3ZhciBtPXMuZ2V0Q3VycmVudFRva2VuUm93KCksZz1zLmdldEN1cnJlbnRUb2tlbkNvbHVtbigpK3Y7ZD1uZXcgbChtLGcsbSxnK2kuZW5kLmxlbmd0aCk7YnJlYWt9bz1zLnN0ZXBGb3J3YXJkKCl9ZCYmdC5yZW1vdmUoZCkscCYmKHQucmVtb3ZlKHApLGM9cC5zdGFydC5yb3csaD0taS5zdGFydC5sZW5ndGgpfWVsc2UgaD1pLnN0YXJ0Lmxlbmd0aCxjPW4uc3RhcnQucm93LHQuaW5zZXJ0KG4uZW5kLGkuZW5kKSx0Lmluc2VydChuLnN0YXJ0LGkuc3RhcnQpO2Euc3RhcnQucm93PT1jJiYoYS5zdGFydC5jb2x1bW4rPWgpLGEuZW5kLnJvdz09YyYmKGEuZW5kLmNvbHVtbis9aCksdC5zZWxlY3Rpb24uZnJvbU9yaWVudGVkUmFuZ2UoYSl9LHRoaXMuZ2V0TmV4dExpbmVJbmRlbnQ9ZnVuY3Rpb24oZSx0LG4pe3JldHVybiB0aGlzLiRnZXRJbmRlbnQodCl9LHRoaXMuY2hlY2tPdXRkZW50PWZ1bmN0aW9uKGUsdCxuKXtyZXR1cm4hMX0sdGhpcy5hdXRvT3V0ZGVudD1mdW5jdGlvbihlLHQsbil7fSx0aGlzLiRnZXRJbmRlbnQ9ZnVuY3Rpb24oZSl7cmV0dXJuIGUubWF0Y2goL15ccyovKVswXX0sdGhpcy5jcmVhdGVXb3JrZXI9ZnVuY3Rpb24oZSl7cmV0dXJuIG51bGx9LHRoaXMuY3JlYXRlTW9kZURlbGVnYXRlcz1mdW5jdGlvbihlKXt0aGlzLiRlbWJlZHM9W10sdGhpcy4kbW9kZXM9e307Zm9yKHZhciB0IGluIGUpaWYoZVt0XSl7dmFyIG49ZVt0XSxpPW4ucHJvdG90eXBlLiRpZCxzPXIuJG1vZGVzW2ldO3N8fChyLiRtb2Rlc1tpXT1zPW5ldyBuKSxyLiRtb2Rlc1t0XXx8KHIuJG1vZGVzW3RdPXMpLHRoaXMuJGVtYmVkcy5wdXNoKHQpLHRoaXMuJG1vZGVzW3RdPXN9dmFyIG89WyJ0b2dnbGVCbG9ja0NvbW1lbnQiLCJ0b2dnbGVDb21tZW50TGluZXMiLCJnZXROZXh0TGluZUluZGVudCIsImNoZWNrT3V0ZGVudCIsImF1dG9PdXRkZW50IiwidHJhbnNmb3JtQWN0aW9uIiwiZ2V0Q29tcGxldGlvbnMiXTtmb3IodmFyIHQ9MDt0PG8ubGVuZ3RoO3QrKykoZnVuY3Rpb24oZSl7dmFyIG49b1t0XSxyPWVbbl07ZVtvW3RdXT1mdW5jdGlvbigpe3JldHVybiB0aGlzLiRkZWxlZ2F0b3Iobixhcmd1bWVudHMscil9fSkodGhpcyl9LHRoaXMuJGRlbGVnYXRvcj1mdW5jdGlvbihlLHQsbil7dmFyIHI9dFswXXx8InN0YXJ0IjtpZih0eXBlb2YgciE9InN0cmluZyIpe2lmKEFycmF5LmlzQXJyYXkoclsyXSkpe3ZhciBpPXJbMl1bclsyXS5sZW5ndGgtMV0scz10aGlzLiRtb2Rlc1tpXTtpZihzKXJldHVybiBzW2VdLmFwcGx5KHMsW3JbMV1dLmNvbmNhdChbXS5zbGljZS5jYWxsKHQsMSkpKX1yPXJbMF18fCJzdGFydCJ9Zm9yKHZhciBvPTA7bzx0aGlzLiRlbWJlZHMubGVuZ3RoO28rKyl7aWYoIXRoaXMuJG1vZGVzW3RoaXMuJGVtYmVkc1tvXV0pY29udGludWU7dmFyIHU9ci5zcGxpdCh0aGlzLiRlbWJlZHNbb10pO2lmKCF1WzBdJiZ1WzFdKXt0WzBdPXVbMV07dmFyIHM9dGhpcy4kbW9kZXNbdGhpcy4kZW1iZWRzW29dXTtyZXR1cm4gc1tlXS5hcHBseShzLHQpfX12YXIgYT1uLmFwcGx5KHRoaXMsdCk7cmV0dXJuIG4/YTp1bmRlZmluZWR9LHRoaXMudHJhbnNmb3JtQWN0aW9uPWZ1bmN0aW9uKGUsdCxuLHIsaSl7aWYodGhpcy4kYmVoYXZpb3VyKXt2YXIgcz10aGlzLiRiZWhhdmlvdXIuZ2V0QmVoYXZpb3VycygpO2Zvcih2YXIgbyBpbiBzKWlmKHNbb11bdF0pe3ZhciB1PXNbb11bdF0uYXBwbHkodGhpcyxhcmd1bWVudHMpO2lmKHUpcmV0dXJuIHV9fX0sdGhpcy5nZXRLZXl3b3Jkcz1mdW5jdGlvbihlKXtpZighdGhpcy5jb21wbGV0aW9uS2V5d29yZHMpe3ZhciB0PXRoaXMuJHRva2VuaXplci5ydWxlcyxuPVtdO2Zvcih2YXIgciBpbiB0KXt2YXIgaT10W3JdO2Zvcih2YXIgcz0wLG89aS5sZW5ndGg7czxvO3MrKylpZih0eXBlb2YgaVtzXS50b2tlbj09InN0cmluZyIpL2tleXdvcmR8c3VwcG9ydHxzdG9yYWdlLy50ZXN0KGlbc10udG9rZW4pJiZuLnB1c2goaVtzXS5yZWdleCk7ZWxzZSBpZih0eXBlb2YgaVtzXS50b2tlbj09Im9iamVjdCIpZm9yKHZhciB1PTAsYT1pW3NdLnRva2VuLmxlbmd0aDt1PGE7dSsrKWlmKC9rZXl3b3JkfHN1cHBvcnR8c3RvcmFnZS8udGVzdChpW3NdLnRva2VuW3VdKSl7dmFyIHI9aVtzXS5yZWdleC5tYXRjaCgvXCguKz9cKS9nKVt1XTtuLnB1c2goci5zdWJzdHIoMSxyLmxlbmd0aC0yKSl9fXRoaXMuY29tcGxldGlvbktleXdvcmRzPW59cmV0dXJuIGU/bi5jb25jYXQodGhpcy4ka2V5d29yZExpc3R8fFtdKTp0aGlzLiRrZXl3b3JkTGlzdH0sdGhpcy4kY3JlYXRlS2V5d29yZExpc3Q9ZnVuY3Rpb24oKXtyZXR1cm4gdGhpcy4kaGlnaGxpZ2h0UnVsZXN8fHRoaXMuZ2V0VG9rZW5pemVyKCksdGhpcy4ka2V5d29yZExpc3Q9dGhpcy4kaGlnaGxpZ2h0UnVsZXMuJGtleXdvcmRMaXN0fHxbXX0sdGhpcy5nZXRDb21wbGV0aW9ucz1mdW5jdGlvbihlLHQsbixyKXt2YXIgaT10aGlzLiRrZXl3b3JkTGlzdHx8dGhpcy4kY3JlYXRlS2V5d29yZExpc3QoKTtyZXR1cm4gaS5tYXAoZnVuY3Rpb24oZSl7cmV0dXJue25hbWU6ZSx2YWx1ZTplLHNjb3JlOjAsbWV0YToia2V5d29yZCJ9fSl9LHRoaXMuJGlkPSJhY2UvbW9kZS90ZXh0In0pLmNhbGwoYy5wcm90b3R5cGUpLHQuTW9kZT1jfSksZGVmaW5lKCJhY2UvYXBwbHlfZGVsdGEiLFsicmVxdWlyZSIsImV4cG9ydHMiLCJtb2R1bGUiXSxmdW5jdGlvbihlLHQsbil7InVzZSBzdHJpY3QiO2Z1bmN0aW9uIHIoZSx0KXt0aHJvdyBjb25zb2xlLmxvZygiSW52YWxpZCBEZWx0YToiLGUpLCJJbnZhbGlkIERlbHRhOiAiK3R9ZnVuY3Rpb24gaShlLHQpe3JldHVybiB0LnJvdz49MCYmdC5yb3c8ZS5sZW5ndGgmJnQuY29sdW1uPj0wJiZ0LmNvbHVtbjw9ZVt0LnJvd10ubGVuZ3RofWZ1bmN0aW9uIHMoZSx0KXt0LmFjdGlvbiE9Imluc2VydCImJnQuYWN0aW9uIT0icmVtb3ZlIiYmcih0LCJkZWx0YS5hY3Rpb24gbXVzdCBiZSAnaW5zZXJ0JyBvciAncmVtb3ZlJyIpLHQubGluZXMgaW5zdGFuY2VvZiBBcnJheXx8cih0LCJkZWx0YS5saW5lcyBtdXN0IGJlIGFuIEFycmF5IiksKCF0LnN0YXJ0fHwhdC5lbmQpJiZyKHQsImRlbHRhLnN0YXJ0L2VuZCBtdXN0IGJlIGFuIHByZXNlbnQiKTt2YXIgbj10LnN0YXJ0O2koZSx0LnN0YXJ0KXx8cih0LCJkZWx0YS5zdGFydCBtdXN0IGJlIGNvbnRhaW5lZCBpbiBkb2N1bWVudCIpO3ZhciBzPXQuZW5kO3QuYWN0aW9uPT0icmVtb3ZlIiYmIWkoZSxzKSYmcih0LCJkZWx0YS5lbmQgbXVzdCBjb250YWluZWQgaW4gZG9jdW1lbnQgZm9yICdyZW1vdmUnIGFjdGlvbnMiKTt2YXIgbz1zLnJvdy1uLnJvdyx1PXMuY29sdW1uLShvPT0wP24uY29sdW1uOjApOyhvIT10LmxpbmVzLmxlbmd0aC0xfHx0LmxpbmVzW29dLmxlbmd0aCE9dSkmJnIodCwiZGVsdGEucmFuZ2UgbXVzdCBtYXRjaCBkZWx0YSBsaW5lcyIpfXQuYXBwbHlEZWx0YT1mdW5jdGlvbihlLHQsbil7dmFyIHI9dC5zdGFydC5yb3csaT10LnN0YXJ0LmNvbHVtbixzPWVbcl18fCIiO3N3aXRjaCh0LmFjdGlvbil7Y2FzZSJpbnNlcnQiOnZhciBvPXQubGluZXM7aWYoby5sZW5ndGg9PT0xKWVbcl09cy5zdWJzdHJpbmcoMCxpKSt0LmxpbmVzWzBdK3Muc3Vic3RyaW5nKGkpO2Vsc2V7dmFyIHU9W3IsMV0uY29uY2F0KHQubGluZXMpO2Uuc3BsaWNlLmFwcGx5KGUsdSksZVtyXT1zLnN1YnN0cmluZygwLGkpK2Vbcl0sZVtyK3QubGluZXMubGVuZ3RoLTFdKz1zLnN1YnN0cmluZyhpKX1icmVhaztjYXNlInJlbW92ZSI6dmFyIGE9dC5lbmQuY29sdW1uLGY9dC5lbmQucm93O3I9PT1mP2Vbcl09cy5zdWJzdHJpbmcoMCxpKStzLnN1YnN0cmluZyhhKTplLnNwbGljZShyLGYtcisxLHMuc3Vic3RyaW5nKDAsaSkrZVtmXS5zdWJzdHJpbmcoYSkpfX19KSxkZWZpbmUoImFjZS9hbmNob3IiLFsicmVxdWlyZSIsImV4cG9ydHMiLCJtb2R1bGUiLCJhY2UvbGliL29vcCIsImFjZS9saWIvZXZlbnRfZW1pdHRlciJdLGZ1bmN0aW9uKGUsdCxuKXsidXNlIHN0cmljdCI7dmFyIHI9ZSgiLi9saWIvb29wIiksaT1lKCIuL2xpYi9ldmVudF9lbWl0dGVyIikuRXZlbnRFbWl0dGVyLHM9dC5BbmNob3I9ZnVuY3Rpb24oZSx0LG4pe3RoaXMuJG9uQ2hhbmdlPXRoaXMub25DaGFuZ2UuYmluZCh0aGlzKSx0aGlzLmF0dGFjaChlKSx0eXBlb2Ygbj09InVuZGVmaW5lZCI/dGhpcy5zZXRQb3NpdGlvbih0LnJvdyx0LmNvbHVtbik6dGhpcy5zZXRQb3NpdGlvbih0LG4pfTsoZnVuY3Rpb24oKXtmdW5jdGlvbiBlKGUsdCxuKXt2YXIgcj1uP2UuY29sdW1uPD10LmNvbHVtbjplLmNvbHVtbjx0LmNvbHVtbjtyZXR1cm4gZS5yb3c8dC5yb3d8fGUucm93PT10LnJvdyYmcn1mdW5jdGlvbiB0KHQsbixyKXt2YXIgaT10LmFjdGlvbj09Imluc2VydCIscz0oaT8xOi0xKSoodC5lbmQucm93LXQuc3RhcnQucm93KSxvPShpPzE6LTEpKih0LmVuZC5jb2x1bW4tdC5zdGFydC5jb2x1bW4pLHU9dC5zdGFydCxhPWk/dTp0LmVuZDtyZXR1cm4gZShuLHUscik/e3JvdzpuLnJvdyxjb2x1bW46bi5jb2x1bW59OmUoYSxuLCFyKT97cm93Om4ucm93K3MsY29sdW1uOm4uY29sdW1uKyhuLnJvdz09YS5yb3c/bzowKX06e3Jvdzp1LnJvdyxjb2x1bW46dS5jb2x1bW59fXIuaW1wbGVtZW50KHRoaXMsaSksdGhpcy5nZXRQb3NpdGlvbj1mdW5jdGlvbigpe3JldHVybiB0aGlzLiRjbGlwUG9zaXRpb25Ub0RvY3VtZW50KHRoaXMucm93LHRoaXMuY29sdW1uKX0sdGhpcy5nZXREb2N1bWVudD1mdW5jdGlvbigpe3JldHVybiB0aGlzLmRvY3VtZW50fSx0aGlzLiRpbnNlcnRSaWdodD0hMSx0aGlzLm9uQ2hhbmdlPWZ1bmN0aW9uKGUpe2lmKGUuc3RhcnQucm93PT1lLmVuZC5yb3cmJmUuc3RhcnQucm93IT10aGlzLnJvdylyZXR1cm47aWYoZS5zdGFydC5yb3c+dGhpcy5yb3cpcmV0dXJuO3ZhciBuPXQoZSx7cm93OnRoaXMucm93LGNvbHVtbjp0aGlzLmNvbHVtbn0sdGhpcy4kaW5zZXJ0UmlnaHQpO3RoaXMuc2V0UG9zaXRpb24obi5yb3csbi5jb2x1bW4sITApfSx0aGlzLnNldFBvc2l0aW9uPWZ1bmN0aW9uKGUsdCxuKXt2YXIgcjtuP3I9e3JvdzplLGNvbHVtbjp0fTpyPXRoaXMuJGNsaXBQb3NpdGlvblRvRG9jdW1lbnQoZSx0KTtpZih0aGlzLnJvdz09ci5yb3cmJnRoaXMuY29sdW1uPT1yLmNvbHVtbilyZXR1cm47dmFyIGk9e3Jvdzp0aGlzLnJvdyxjb2x1bW46dGhpcy5jb2x1bW59O3RoaXMucm93PXIucm93LHRoaXMuY29sdW1uPXIuY29sdW1uLHRoaXMuX3NpZ25hbCgiY2hhbmdlIix7b2xkOmksdmFsdWU6cn0pfSx0aGlzLmRldGFjaD1mdW5jdGlvbigpe3RoaXMuZG9jdW1lbnQub2ZmKCJjaGFuZ2UiLHRoaXMuJG9uQ2hhbmdlKX0sdGhpcy5hdHRhY2g9ZnVuY3Rpb24oZSl7dGhpcy5kb2N1bWVudD1lfHx0aGlzLmRvY3VtZW50LHRoaXMuZG9jdW1lbnQub24oImNoYW5nZSIsdGhpcy4kb25DaGFuZ2UpfSx0aGlzLiRjbGlwUG9zaXRpb25Ub0RvY3VtZW50PWZ1bmN0aW9uKGUsdCl7dmFyIG49e307cmV0dXJuIGU+PXRoaXMuZG9jdW1lbnQuZ2V0TGVuZ3RoKCk/KG4ucm93PU1hdGgubWF4KDAsdGhpcy5kb2N1bWVudC5nZXRMZW5ndGgoKS0xKSxuLmNvbHVtbj10aGlzLmRvY3VtZW50LmdldExpbmUobi5yb3cpLmxlbmd0aCk6ZTwwPyhuLnJvdz0wLG4uY29sdW1uPTApOihuLnJvdz1lLG4uY29sdW1uPU1hdGgubWluKHRoaXMuZG9jdW1lbnQuZ2V0TGluZShuLnJvdykubGVuZ3RoLE1hdGgubWF4KDAsdCkpKSx0PDAmJihuLmNvbHVtbj0wKSxufX0pLmNhbGwocy5wcm90b3R5cGUpfSksZGVmaW5lKCJhY2UvZG9jdW1lbnQiLFsicmVxdWlyZSIsImV4cG9ydHMiLCJtb2R1bGUiLCJhY2UvbGliL29vcCIsImFjZS9hcHBseV9kZWx0YSIsImFjZS9saWIvZXZlbnRfZW1pdHRlciIsImFjZS9yYW5nZSIsImFjZS9hbmNob3IiXSxmdW5jdGlvbihlLHQsbil7InVzZSBzdHJpY3QiO3ZhciByPWUoIi4vbGliL29vcCIpLGk9ZSgiLi9hcHBseV9kZWx0YSIpLmFwcGx5RGVsdGEscz1lKCIuL2xpYi9ldmVudF9lbWl0dGVyIikuRXZlbnRFbWl0dGVyLG89ZSgiLi9yYW5nZSIpLlJhbmdlLHU9ZSgiLi9hbmNob3IiKS5BbmNob3IsYT1mdW5jdGlvbihlKXt0aGlzLiRsaW5lcz1bIiJdLGUubGVuZ3RoPT09MD90aGlzLiRsaW5lcz1bIiJdOkFycmF5LmlzQXJyYXkoZSk/dGhpcy5pbnNlcnRNZXJnZWRMaW5lcyh7cm93OjAsY29sdW1uOjB9LGUpOnRoaXMuaW5zZXJ0KHtyb3c6MCxjb2x1bW46MH0sZSl9OyhmdW5jdGlvbigpe3IuaW1wbGVtZW50KHRoaXMscyksdGhpcy5zZXRWYWx1ZT1mdW5jdGlvbihlKXt2YXIgdD10aGlzLmdldExlbmd0aCgpLTE7dGhpcy5yZW1vdmUobmV3IG8oMCwwLHQsdGhpcy5nZXRMaW5lKHQpLmxlbmd0aCkpLHRoaXMuaW5zZXJ0KHtyb3c6MCxjb2x1bW46MH0sZXx8IiIpfSx0aGlzLmdldFZhbHVlPWZ1bmN0aW9uKCl7cmV0dXJuIHRoaXMuZ2V0QWxsTGluZXMoKS5qb2luKHRoaXMuZ2V0TmV3TGluZUNoYXJhY3RlcigpKX0sdGhpcy5jcmVhdGVBbmNob3I9ZnVuY3Rpb24oZSx0KXtyZXR1cm4gbmV3IHUodGhpcyxlLHQpfSwiYWFhIi5zcGxpdCgvYS8pLmxlbmd0aD09PTA/dGhpcy4kc3BsaXQ9ZnVuY3Rpb24oZSl7cmV0dXJuIGUucmVwbGFjZSgvXHJcbnxcci9nLCJcbiIpLnNwbGl0KCJcbiIpfTp0aGlzLiRzcGxpdD1mdW5jdGlvbihlKXtyZXR1cm4gZS5zcGxpdCgvXHJcbnxccnxcbi8pfSx0aGlzLiRkZXRlY3ROZXdMaW5lPWZ1bmN0aW9uKGUpe3ZhciB0PWUubWF0Y2goL14uKj8oXHJcbnxccnxcbikvbSk7dGhpcy4kYXV0b05ld0xpbmU9dD90WzFdOiJcbiIsdGhpcy5fc2lnbmFsKCJjaGFuZ2VOZXdMaW5lTW9kZSIpfSx0aGlzLmdldE5ld0xpbmVDaGFyYWN0ZXI9ZnVuY3Rpb24oKXtzd2l0Y2godGhpcy4kbmV3TGluZU1vZGUpe2Nhc2Uid2luZG93cyI6cmV0dXJuIlxyXG4iO2Nhc2UidW5peCI6cmV0dXJuIlxuIjtkZWZhdWx0OnJldHVybiB0aGlzLiRhdXRvTmV3TGluZXx8IlxuIn19LHRoaXMuJGF1dG9OZXdMaW5lPSIiLHRoaXMuJG5ld0xpbmVNb2RlPSJhdXRvIix0aGlzLnNldE5ld0xpbmVNb2RlPWZ1bmN0aW9uKGUpe2lmKHRoaXMuJG5ld0xpbmVNb2RlPT09ZSlyZXR1cm47dGhpcy4kbmV3TGluZU1vZGU9ZSx0aGlzLl9zaWduYWwoImNoYW5nZU5ld0xpbmVNb2RlIil9LHRoaXMuZ2V0TmV3TGluZU1vZGU9ZnVuY3Rpb24oKXtyZXR1cm4gdGhpcy4kbmV3TGluZU1vZGV9LHRoaXMuaXNOZXdMaW5lPWZ1bmN0aW9uKGUpe3JldHVybiBlPT0iXHJcbiJ8fGU9PSJcciJ8fGU9PSJcbiJ9LHRoaXMuZ2V0TGluZT1mdW5jdGlvbihlKXtyZXR1cm4gdGhpcy4kbGluZXNbZV18fCIifSx0aGlzLmdldExpbmVzPWZ1bmN0aW9uKGUsdCl7cmV0dXJuIHRoaXMuJGxpbmVzLnNsaWNlKGUsdCsxKX0sdGhpcy5nZXRBbGxMaW5lcz1mdW5jdGlvbigpe3JldHVybiB0aGlzLmdldExpbmVzKDAsdGhpcy5nZXRMZW5ndGgoKSl9LHRoaXMuZ2V0TGVuZ3RoPWZ1bmN0aW9uKCl7cmV0dXJuIHRoaXMuJGxpbmVzLmxlbmd0aH0sdGhpcy5nZXRUZXh0UmFuZ2U9ZnVuY3Rpb24oZSl7cmV0dXJuIHRoaXMuZ2V0TGluZXNGb3JSYW5nZShlKS5qb2luKHRoaXMuZ2V0TmV3TGluZUNoYXJhY3RlcigpKX0sdGhpcy5nZXRMaW5lc0ZvclJhbmdlPWZ1bmN0aW9uKGUpe3ZhciB0O2lmKGUuc3RhcnQucm93PT09ZS5lbmQucm93KXQ9W3RoaXMuZ2V0TGluZShlLnN0YXJ0LnJvdykuc3Vic3RyaW5nKGUuc3RhcnQuY29sdW1uLGUuZW5kLmNvbHVtbildO2Vsc2V7dD10aGlzLmdldExpbmVzKGUuc3RhcnQucm93LGUuZW5kLnJvdyksdFswXT0odFswXXx8IiIpLnN1YnN0cmluZyhlLnN0YXJ0LmNvbHVtbik7dmFyIG49dC5sZW5ndGgtMTtlLmVuZC5yb3ctZS5zdGFydC5yb3c9PW4mJih0W25dPXRbbl0uc3Vic3RyaW5nKDAsZS5lbmQuY29sdW1uKSl9cmV0dXJuIHR9LHRoaXMuaW5zZXJ0TGluZXM9ZnVuY3Rpb24oZSx0KXtyZXR1cm4gY29uc29sZS53YXJuKCJVc2Ugb2YgZG9jdW1lbnQuaW5zZXJ0TGluZXMgaXMgZGVwcmVjYXRlZC4gVXNlIHRoZSBpbnNlcnRGdWxsTGluZXMgbWV0aG9kIGluc3RlYWQuIiksdGhpcy5pbnNlcnRGdWxsTGluZXMoZSx0KX0sdGhpcy5yZW1vdmVMaW5lcz1mdW5jdGlvbihlLHQpe3JldHVybiBjb25zb2xlLndhcm4oIlVzZSBvZiBkb2N1bWVudC5yZW1vdmVMaW5lcyBpcyBkZXByZWNhdGVkLiBVc2UgdGhlIHJlbW92ZUZ1bGxMaW5lcyBtZXRob2QgaW5zdGVhZC4iKSx0aGlzLnJlbW92ZUZ1bGxMaW5lcyhlLHQpfSx0aGlzLmluc2VydE5ld0xpbmU9ZnVuY3Rpb24oZSl7cmV0dXJuIGNvbnNvbGUud2FybigiVXNlIG9mIGRvY3VtZW50Lmluc2VydE5ld0xpbmUgaXMgZGVwcmVjYXRlZC4gVXNlIGluc2VydE1lcmdlZExpbmVzKHBvc2l0aW9uLCBbJycsICcnXSkgaW5zdGVhZC4iKSx0aGlzLmluc2VydE1lcmdlZExpbmVzKGUsWyIiLCIiXSl9LHRoaXMuaW5zZXJ0PWZ1bmN0aW9uKGUsdCl7cmV0dXJuIHRoaXMuZ2V0TGVuZ3RoKCk8PTEmJnRoaXMuJGRldGVjdE5ld0xpbmUodCksdGhpcy5pbnNlcnRNZXJnZWRMaW5lcyhlLHRoaXMuJHNwbGl0KHQpKX0sdGhpcy5pbnNlcnRJbkxpbmU9ZnVuY3Rpb24oZSx0KXt2YXIgbj10aGlzLmNsaXBwZWRQb3MoZS5yb3csZS5jb2x1bW4pLHI9dGhpcy5wb3MoZS5yb3csZS5jb2x1bW4rdC5sZW5ndGgpO3JldHVybiB0aGlzLmFwcGx5RGVsdGEoe3N0YXJ0Om4sZW5kOnIsYWN0aW9uOiJpbnNlcnQiLGxpbmVzOlt0XX0sITApLHRoaXMuY2xvbmVQb3Mocil9LHRoaXMuY2xpcHBlZFBvcz1mdW5jdGlvbihlLHQpe3ZhciBuPXRoaXMuZ2V0TGVuZ3RoKCk7ZT09PXVuZGVmaW5lZD9lPW46ZTwwP2U9MDplPj1uJiYoZT1uLTEsdD11bmRlZmluZWQpO3ZhciByPXRoaXMuZ2V0TGluZShlKTtyZXR1cm4gdD09dW5kZWZpbmVkJiYodD1yLmxlbmd0aCksdD1NYXRoLm1pbihNYXRoLm1heCh0LDApLHIubGVuZ3RoKSx7cm93OmUsY29sdW1uOnR9fSx0aGlzLmNsb25lUG9zPWZ1bmN0aW9uKGUpe3JldHVybntyb3c6ZS5yb3csY29sdW1uOmUuY29sdW1ufX0sdGhpcy5wb3M9ZnVuY3Rpb24oZSx0KXtyZXR1cm57cm93OmUsY29sdW1uOnR9fSx0aGlzLiRjbGlwUG9zaXRpb249ZnVuY3Rpb24oZSl7dmFyIHQ9dGhpcy5nZXRMZW5ndGgoKTtyZXR1cm4gZS5yb3c+PXQ/KGUucm93PU1hdGgubWF4KDAsdC0xKSxlLmNvbHVtbj10aGlzLmdldExpbmUodC0xKS5sZW5ndGgpOihlLnJvdz1NYXRoLm1heCgwLGUucm93KSxlLmNvbHVtbj1NYXRoLm1pbihNYXRoLm1heChlLmNvbHVtbiwwKSx0aGlzLmdldExpbmUoZS5yb3cpLmxlbmd0aCkpLGV9LHRoaXMuaW5zZXJ0RnVsbExpbmVzPWZ1bmN0aW9uKGUsdCl7ZT1NYXRoLm1pbihNYXRoLm1heChlLDApLHRoaXMuZ2V0TGVuZ3RoKCkpO3ZhciBuPTA7ZTx0aGlzLmdldExlbmd0aCgpPyh0PXQuY29uY2F0KFsiIl0pLG49MCk6KHQ9WyIiXS5jb25jYXQodCksZS0tLG49dGhpcy4kbGluZXNbZV0ubGVuZ3RoKSx0aGlzLmluc2VydE1lcmdlZExpbmVzKHtyb3c6ZSxjb2x1bW46bn0sdCl9LHRoaXMuaW5zZXJ0TWVyZ2VkTGluZXM9ZnVuY3Rpb24oZSx0KXt2YXIgbj10aGlzLmNsaXBwZWRQb3MoZS5yb3csZS5jb2x1bW4pLHI9e3JvdzpuLnJvdyt0Lmxlbmd0aC0xLGNvbHVtbjoodC5sZW5ndGg9PTE/bi5jb2x1bW46MCkrdFt0Lmxlbmd0aC0xXS5sZW5ndGh9O3JldHVybiB0aGlzLmFwcGx5RGVsdGEoe3N0YXJ0Om4sZW5kOnIsYWN0aW9uOiJpbnNlcnQiLGxpbmVzOnR9KSx0aGlzLmNsb25lUG9zKHIpfSx0aGlzLnJlbW92ZT1mdW5jdGlvbihlKXt2YXIgdD10aGlzLmNsaXBwZWRQb3MoZS5zdGFydC5yb3csZS5zdGFydC5jb2x1bW4pLG49dGhpcy5jbGlwcGVkUG9zKGUuZW5kLnJvdyxlLmVuZC5jb2x1bW4pO3JldHVybiB0aGlzLmFwcGx5RGVsdGEoe3N0YXJ0OnQsZW5kOm4sYWN0aW9uOiJyZW1vdmUiLGxpbmVzOnRoaXMuZ2V0TGluZXNGb3JSYW5nZSh7c3RhcnQ6dCxlbmQ6bn0pfSksdGhpcy5jbG9uZVBvcyh0KX0sdGhpcy5yZW1vdmVJbkxpbmU9ZnVuY3Rpb24oZSx0LG4pe3ZhciByPXRoaXMuY2xpcHBlZFBvcyhlLHQpLGk9dGhpcy5jbGlwcGVkUG9zKGUsbik7cmV0dXJuIHRoaXMuYXBwbHlEZWx0YSh7c3RhcnQ6cixlbmQ6aSxhY3Rpb246InJlbW92ZSIsbGluZXM6dGhpcy5nZXRMaW5lc0ZvclJhbmdlKHtzdGFydDpyLGVuZDppfSl9LCEwKSx0aGlzLmNsb25lUG9zKHIpfSx0aGlzLnJlbW92ZUZ1bGxMaW5lcz1mdW5jdGlvbihlLHQpe2U9TWF0aC5taW4oTWF0aC5tYXgoMCxlKSx0aGlzLmdldExlbmd0aCgpLTEpLHQ9TWF0aC5taW4oTWF0aC5tYXgoMCx0KSx0aGlzLmdldExlbmd0aCgpLTEpO3ZhciBuPXQ9PXRoaXMuZ2V0TGVuZ3RoKCktMSYmZT4wLHI9dDx0aGlzLmdldExlbmd0aCgpLTEsaT1uP2UtMTplLHM9bj90aGlzLmdldExpbmUoaSkubGVuZ3RoOjAsdT1yP3QrMTp0LGE9cj8wOnRoaXMuZ2V0TGluZSh1KS5sZW5ndGgsZj1uZXcgbyhpLHMsdSxhKSxsPXRoaXMuJGxpbmVzLnNsaWNlKGUsdCsxKTtyZXR1cm4gdGhpcy5hcHBseURlbHRhKHtzdGFydDpmLnN0YXJ0LGVuZDpmLmVuZCxhY3Rpb246InJlbW92ZSIsbGluZXM6dGhpcy5nZXRMaW5lc0ZvclJhbmdlKGYpfSksbH0sdGhpcy5yZW1vdmVOZXdMaW5lPWZ1bmN0aW9uKGUpe2U8dGhpcy5nZXRMZW5ndGgoKS0xJiZlPj0wJiZ0aGlzLmFwcGx5RGVsdGEoe3N0YXJ0OnRoaXMucG9zKGUsdGhpcy5nZXRMaW5lKGUpLmxlbmd0aCksZW5kOnRoaXMucG9zKGUrMSwwKSxhY3Rpb246InJlbW92ZSIsbGluZXM6WyIiLCIiXX0pfSx0aGlzLnJlcGxhY2U9ZnVuY3Rpb24oZSx0KXtlIGluc3RhbmNlb2Ygb3x8KGU9by5mcm9tUG9pbnRzKGUuc3RhcnQsZS5lbmQpKTtpZih0Lmxlbmd0aD09PTAmJmUuaXNFbXB0eSgpKXJldHVybiBlLnN0YXJ0O2lmKHQ9PXRoaXMuZ2V0VGV4dFJhbmdlKGUpKXJldHVybiBlLmVuZDt0aGlzLnJlbW92ZShlKTt2YXIgbjtyZXR1cm4gdD9uPXRoaXMuaW5zZXJ0KGUuc3RhcnQsdCk6bj1lLnN0YXJ0LG59LHRoaXMuYXBwbHlEZWx0YXM9ZnVuY3Rpb24oZSl7Zm9yKHZhciB0PTA7dDxlLmxlbmd0aDt0KyspdGhpcy5hcHBseURlbHRhKGVbdF0pfSx0aGlzLnJldmVydERlbHRhcz1mdW5jdGlvbihlKXtmb3IodmFyIHQ9ZS5sZW5ndGgtMTt0Pj0wO3QtLSl0aGlzLnJldmVydERlbHRhKGVbdF0pfSx0aGlzLmFwcGx5RGVsdGE9ZnVuY3Rpb24oZSx0KXt2YXIgbj1lLmFjdGlvbj09Imluc2VydCI7aWYobj9lLmxpbmVzLmxlbmd0aDw9MSYmIWUubGluZXNbMF06IW8uY29tcGFyZVBvaW50cyhlLnN0YXJ0LGUuZW5kKSlyZXR1cm47biYmZS5saW5lcy5sZW5ndGg+MmU0P3RoaXMuJHNwbGl0QW5kYXBwbHlMYXJnZURlbHRhKGUsMmU0KTooaSh0aGlzLiRsaW5lcyxlLHQpLHRoaXMuX3NpZ25hbCgiY2hhbmdlIixlKSl9LHRoaXMuJHNhZmVBcHBseURlbHRhPWZ1bmN0aW9uKGUpe3ZhciB0PXRoaXMuJGxpbmVzLmxlbmd0aDsoZS5hY3Rpb249PSJyZW1vdmUiJiZlLnN0YXJ0LnJvdzx0JiZlLmVuZC5yb3c8dHx8ZS5hY3Rpb249PSJpbnNlcnQiJiZlLnN0YXJ0LnJvdzw9dCkmJnRoaXMuYXBwbHlEZWx0YShlKX0sdGhpcy4kc3BsaXRBbmRhcHBseUxhcmdlRGVsdGE9ZnVuY3Rpb24oZSx0KXt2YXIgbj1lLmxpbmVzLHI9bi5sZW5ndGgtdCsxLGk9ZS5zdGFydC5yb3cscz1lLnN0YXJ0LmNvbHVtbjtmb3IodmFyIG89MCx1PTA7bzxyO289dSl7dSs9dC0xO3ZhciBhPW4uc2xpY2Uobyx1KTthLnB1c2goIiIpLHRoaXMuYXBwbHlEZWx0YSh7c3RhcnQ6dGhpcy5wb3MoaStvLHMpLGVuZDp0aGlzLnBvcyhpK3Uscz0wKSxhY3Rpb246ZS5hY3Rpb24sbGluZXM6YX0sITApfWUubGluZXM9bi5zbGljZShvKSxlLnN0YXJ0LnJvdz1pK28sZS5zdGFydC5jb2x1bW49cyx0aGlzLmFwcGx5RGVsdGEoZSwhMCl9LHRoaXMucmV2ZXJ0RGVsdGE9ZnVuY3Rpb24oZSl7dGhpcy4kc2FmZUFwcGx5RGVsdGEoe3N0YXJ0OnRoaXMuY2xvbmVQb3MoZS5zdGFydCksZW5kOnRoaXMuY2xvbmVQb3MoZS5lbmQpLGFjdGlvbjplLmFjdGlvbj09Imluc2VydCI/InJlbW92ZSI6Imluc2VydCIsbGluZXM6ZS5saW5lcy5zbGljZSgpfSl9LHRoaXMuaW5kZXhUb1Bvc2l0aW9uPWZ1bmN0aW9uKGUsdCl7dmFyIG49dGhpcy4kbGluZXN8fHRoaXMuZ2V0QWxsTGluZXMoKSxyPXRoaXMuZ2V0TmV3TGluZUNoYXJhY3RlcigpLmxlbmd0aDtmb3IodmFyIGk9dHx8MCxzPW4ubGVuZ3RoO2k8cztpKyspe2UtPW5baV0ubGVuZ3RoK3I7aWYoZTwwKXJldHVybntyb3c6aSxjb2x1bW46ZStuW2ldLmxlbmd0aCtyfX1yZXR1cm57cm93OnMtMSxjb2x1bW46ZStuW3MtMV0ubGVuZ3RoK3J9fSx0aGlzLnBvc2l0aW9uVG9JbmRleD1mdW5jdGlvbihlLHQpe3ZhciBuPXRoaXMuJGxpbmVzfHx0aGlzLmdldEFsbExpbmVzKCkscj10aGlzLmdldE5ld0xpbmVDaGFyYWN0ZXIoKS5sZW5ndGgsaT0wLHM9TWF0aC5taW4oZS5yb3csbi5sZW5ndGgpO2Zvcih2YXIgbz10fHwwO288czsrK28paSs9bltvXS5sZW5ndGgrcjtyZXR1cm4gaStlLmNvbHVtbn19KS5jYWxsKGEucHJvdG90eXBlKSx0LkRvY3VtZW50PWF9KSxkZWZpbmUoImFjZS9iYWNrZ3JvdW5kX3Rva2VuaXplciIsWyJyZXF1aXJlIiwiZXhwb3J0cyIsIm1vZHVsZSIsImFjZS9saWIvb29wIiwiYWNlL2xpYi9ldmVudF9lbWl0dGVyIl0sZnVuY3Rpb24oZSx0LG4peyJ1c2Ugc3RyaWN0Ijt2YXIgcj1lKCIuL2xpYi9vb3AiKSxpPWUoIi4vbGliL2V2ZW50X2VtaXR0ZXIiKS5FdmVudEVtaXR0ZXIscz1mdW5jdGlvbihlLHQpe3RoaXMucnVubmluZz0hMSx0aGlzLmxpbmVzPVtdLHRoaXMuc3RhdGVzPVtdLHRoaXMuY3VycmVudExpbmU9MCx0aGlzLnRva2VuaXplcj1lO3ZhciBuPXRoaXM7dGhpcy4kd29ya2VyPWZ1bmN0aW9uKCl7aWYoIW4ucnVubmluZylyZXR1cm47dmFyIGU9bmV3IERhdGUsdD1uLmN1cnJlbnRMaW5lLHI9LTEsaT1uLmRvYyxzPXQ7d2hpbGUobi5saW5lc1t0XSl0Kys7dmFyIG89aS5nZXRMZW5ndGgoKSx1PTA7bi5ydW5uaW5nPSExO3doaWxlKHQ8byl7bi4kdG9rZW5pemVSb3codCkscj10O2RvIHQrKzt3aGlsZShuLmxpbmVzW3RdKTt1Kys7aWYodSU1PT09MCYmbmV3IERhdGUtZT4yMCl7bi5ydW5uaW5nPXNldFRpbWVvdXQobi4kd29ya2VyLDIwKTticmVha319bi5jdXJyZW50TGluZT10LHI9PS0xJiYocj10KSxzPD1yJiZuLmZpcmVVcGRhdGVFdmVudChzLHIpfX07KGZ1bmN0aW9uKCl7ci5pbXBsZW1lbnQodGhpcyxpKSx0aGlzLnNldFRva2VuaXplcj1mdW5jdGlvbihlKXt0aGlzLnRva2VuaXplcj1lLHRoaXMubGluZXM9W10sdGhpcy5zdGF0ZXM9W10sdGhpcy5zdGFydCgwKX0sdGhpcy5zZXREb2N1bWVudD1mdW5jdGlvbihlKXt0aGlzLmRvYz1lLHRoaXMubGluZXM9W10sdGhpcy5zdGF0ZXM9W10sdGhpcy5zdG9wKCl9LHRoaXMuZmlyZVVwZGF0ZUV2ZW50PWZ1bmN0aW9uKGUsdCl7dmFyIG49e2ZpcnN0OmUsbGFzdDp0fTt0aGlzLl9zaWduYWwoInVwZGF0ZSIse2RhdGE6bn0pfSx0aGlzLnN0YXJ0PWZ1bmN0aW9uKGUpe3RoaXMuY3VycmVudExpbmU9TWF0aC5taW4oZXx8MCx0aGlzLmN1cnJlbnRMaW5lLHRoaXMuZG9jLmdldExlbmd0aCgpKSx0aGlzLmxpbmVzLnNwbGljZSh0aGlzLmN1cnJlbnRMaW5lLHRoaXMubGluZXMubGVuZ3RoKSx0aGlzLnN0YXRlcy5zcGxpY2UodGhpcy5jdXJyZW50TGluZSx0aGlzLnN0YXRlcy5sZW5ndGgpLHRoaXMuc3RvcCgpLHRoaXMucnVubmluZz1zZXRUaW1lb3V0KHRoaXMuJHdvcmtlciw3MDApfSx0aGlzLnNjaGVkdWxlU3RhcnQ9ZnVuY3Rpb24oKXt0aGlzLnJ1bm5pbmd8fCh0aGlzLnJ1bm5pbmc9c2V0VGltZW91dCh0aGlzLiR3b3JrZXIsNzAwKSl9LHRoaXMuJHVwZGF0ZU9uQ2hhbmdlPWZ1bmN0aW9uKGUpe3ZhciB0PWUuc3RhcnQucm93LG49ZS5lbmQucm93LXQ7aWYobj09PTApdGhpcy5saW5lc1t0XT1udWxsO2Vsc2UgaWYoZS5hY3Rpb249PSJyZW1vdmUiKXRoaXMubGluZXMuc3BsaWNlKHQsbisxLG51bGwpLHRoaXMuc3RhdGVzLnNwbGljZSh0LG4rMSxudWxsKTtlbHNle3ZhciByPUFycmF5KG4rMSk7ci51bnNoaWZ0KHQsMSksdGhpcy5saW5lcy5zcGxpY2UuYXBwbHkodGhpcy5saW5lcyxyKSx0aGlzLnN0YXRlcy5zcGxpY2UuYXBwbHkodGhpcy5zdGF0ZXMscil9dGhpcy5jdXJyZW50TGluZT1NYXRoLm1pbih0LHRoaXMuY3VycmVudExpbmUsdGhpcy5kb2MuZ2V0TGVuZ3RoKCkpLHRoaXMuc3RvcCgpfSx0aGlzLnN0b3A9ZnVuY3Rpb24oKXt0aGlzLnJ1bm5pbmcmJmNsZWFyVGltZW91dCh0aGlzLnJ1bm5pbmcpLHRoaXMucnVubmluZz0hMX0sdGhpcy5nZXRUb2tlbnM9ZnVuY3Rpb24oZSl7cmV0dXJuIHRoaXMubGluZXNbZV18fHRoaXMuJHRva2VuaXplUm93KGUpfSx0aGlzLmdldFN0YXRlPWZ1bmN0aW9uKGUpe3JldHVybiB0aGlzLmN1cnJlbnRMaW5lPT1lJiZ0aGlzLiR0b2tlbml6ZVJvdyhlKSx0aGlzLnN0YXRlc1tlXXx8InN0YXJ0In0sdGhpcy4kdG9rZW5pemVSb3c9ZnVuY3Rpb24oZSl7dmFyIHQ9dGhpcy5kb2MuZ2V0TGluZShlKSxuPXRoaXMuc3RhdGVzW2UtMV0scj10aGlzLnRva2VuaXplci5nZXRMaW5lVG9rZW5zKHQsbixlKTtyZXR1cm4gdGhpcy5zdGF0ZXNbZV0rIiIhPXIuc3RhdGUrIiI/KHRoaXMuc3RhdGVzW2VdPXIuc3RhdGUsdGhpcy5saW5lc1tlKzFdPW51bGwsdGhpcy5jdXJyZW50TGluZT5lKzEmJih0aGlzLmN1cnJlbnRMaW5lPWUrMSkpOnRoaXMuY3VycmVudExpbmU9PWUmJih0aGlzLmN1cnJlbnRMaW5lPWUrMSksdGhpcy5saW5lc1tlXT1yLnRva2Vuc30sdGhpcy5jbGVhbnVwPWZ1bmN0aW9uKCl7dGhpcy5ydW5uaW5nPSExLHRoaXMubGluZXM9W10sdGhpcy5zdGF0ZXM9W10sdGhpcy5jdXJyZW50TGluZT0wLHRoaXMucmVtb3ZlQWxsTGlzdGVuZXJzKCl9fSkuY2FsbChzLnByb3RvdHlwZSksdC5CYWNrZ3JvdW5kVG9rZW5pemVyPXN9KSxkZWZpbmUoImFjZS9zZWFyY2hfaGlnaGxpZ2h0IixbInJlcXVpcmUiLCJleHBvcnRzIiwibW9kdWxlIiwiYWNlL2xpYi9sYW5nIiwiYWNlL2xpYi9vb3AiLCJhY2UvcmFuZ2UiXSxmdW5jdGlvbihlLHQsbil7InVzZSBzdHJpY3QiO3ZhciByPWUoIi4vbGliL2xhbmciKSxpPWUoIi4vbGliL29vcCIpLHM9ZSgiLi9yYW5nZSIpLlJhbmdlLG89ZnVuY3Rpb24oZSx0LG4pe3RoaXMuc2V0UmVnZXhwKGUpLHRoaXMuY2xheno9dCx0aGlzLnR5cGU9bnx8InRleHQifTsoZnVuY3Rpb24oKXt0aGlzLk1BWF9SQU5HRVM9NTAwLHRoaXMuc2V0UmVnZXhwPWZ1bmN0aW9uKGUpe2lmKHRoaXMucmVnRXhwKyIiPT1lKyIiKXJldHVybjt0aGlzLnJlZ0V4cD1lLHRoaXMuY2FjaGU9W119LHRoaXMudXBkYXRlPWZ1bmN0aW9uKGUsdCxuLGkpe2lmKCF0aGlzLnJlZ0V4cClyZXR1cm47dmFyIG89aS5maXJzdFJvdyx1PWkubGFzdFJvdyxhPXt9O2Zvcih2YXIgZj1vO2Y8PXU7ZisrKXt2YXIgbD10aGlzLmNhY2hlW2ZdO2w9PW51bGwmJihsPXIuZ2V0TWF0Y2hPZmZzZXRzKG4uZ2V0TGluZShmKSx0aGlzLnJlZ0V4cCksbC5sZW5ndGg+dGhpcy5NQVhfUkFOR0VTJiYobD1sLnNsaWNlKDAsdGhpcy5NQVhfUkFOR0VTKSksbD1sLm1hcChmdW5jdGlvbihlKXtyZXR1cm4gbmV3IHMoZixlLm9mZnNldCxmLGUub2Zmc2V0K2UubGVuZ3RoKX0pLHRoaXMuY2FjaGVbZl09bC5sZW5ndGg/bDoiIik7Zm9yKHZhciBjPWwubGVuZ3RoO2MtLTspe3ZhciBoPWxbY10udG9TY3JlZW5SYW5nZShuKSxwPWgudG9TdHJpbmcoKTtpZihhW3BdKWNvbnRpbnVlO2FbcF09ITAsdC5kcmF3U2luZ2xlTGluZU1hcmtlcihlLGgsdGhpcy5jbGF6eixpKX19fX0pLmNhbGwoby5wcm90b3R5cGUpLHQuU2VhcmNoSGlnaGxpZ2h0PW99KSxkZWZpbmUoImFjZS9lZGl0X3Nlc3Npb24vZm9sZF9saW5lIixbInJlcXVpcmUiLCJleHBvcnRzIiwibW9kdWxlIiwiYWNlL3JhbmdlIl0sZnVuY3Rpb24oZSx0LG4peyJ1c2Ugc3RyaWN0IjtmdW5jdGlvbiBpKGUsdCl7dGhpcy5mb2xkRGF0YT1lLEFycmF5LmlzQXJyYXkodCk/dGhpcy5mb2xkcz10OnQ9dGhpcy5mb2xkcz1bdF07dmFyIG49dFt0Lmxlbmd0aC0xXTt0aGlzLnJhbmdlPW5ldyByKHRbMF0uc3RhcnQucm93LHRbMF0uc3RhcnQuY29sdW1uLG4uZW5kLnJvdyxuLmVuZC5jb2x1bW4pLHRoaXMuc3RhcnQ9dGhpcy5yYW5nZS5zdGFydCx0aGlzLmVuZD10aGlzLnJhbmdlLmVuZCx0aGlzLmZvbGRzLmZvckVhY2goZnVuY3Rpb24oZSl7ZS5zZXRGb2xkTGluZSh0aGlzKX0sdGhpcyl9dmFyIHI9ZSgiLi4vcmFuZ2UiKS5SYW5nZTsoZnVuY3Rpb24oKXt0aGlzLnNoaWZ0Um93PWZ1bmN0aW9uKGUpe3RoaXMuc3RhcnQucm93Kz1lLHRoaXMuZW5kLnJvdys9ZSx0aGlzLmZvbGRzLmZvckVhY2goZnVuY3Rpb24odCl7dC5zdGFydC5yb3crPWUsdC5lbmQucm93Kz1lfSl9LHRoaXMuYWRkRm9sZD1mdW5jdGlvbihlKXtpZihlLnNhbWVSb3cpe2lmKGUuc3RhcnQucm93PHRoaXMuc3RhcnRSb3d8fGUuZW5kUm93PnRoaXMuZW5kUm93KXRocm93IG5ldyBFcnJvcigiQ2FuJ3QgYWRkIGEgZm9sZCB0byB0aGlzIEZvbGRMaW5lIGFzIGl0IGhhcyBubyBjb25uZWN0aW9uIik7dGhpcy5mb2xkcy5wdXNoKGUpLHRoaXMuZm9sZHMuc29ydChmdW5jdGlvbihlLHQpe3JldHVybi1lLnJhbmdlLmNvbXBhcmVFbmQodC5zdGFydC5yb3csdC5zdGFydC5jb2x1bW4pfSksdGhpcy5yYW5nZS5jb21wYXJlRW5kKGUuc3RhcnQucm93LGUuc3RhcnQuY29sdW1uKT4wPyh0aGlzLmVuZC5yb3c9ZS5lbmQucm93LHRoaXMuZW5kLmNvbHVtbj1lLmVuZC5jb2x1bW4pOnRoaXMucmFuZ2UuY29tcGFyZVN0YXJ0KGUuZW5kLnJvdyxlLmVuZC5jb2x1bW4pPDAmJih0aGlzLnN0YXJ0LnJvdz1lLnN0YXJ0LnJvdyx0aGlzLnN0YXJ0LmNvbHVtbj1lLnN0YXJ0LmNvbHVtbil9ZWxzZSBpZihlLnN0YXJ0LnJvdz09dGhpcy5lbmQucm93KXRoaXMuZm9sZHMucHVzaChlKSx0aGlzLmVuZC5yb3c9ZS5lbmQucm93LHRoaXMuZW5kLmNvbHVtbj1lLmVuZC5jb2x1bW47ZWxzZXtpZihlLmVuZC5yb3chPXRoaXMuc3RhcnQucm93KXRocm93IG5ldyBFcnJvcigiVHJ5aW5nIHRvIGFkZCBmb2xkIHRvIEZvbGRSb3cgdGhhdCBkb2Vzbid0IGhhdmUgYSBtYXRjaGluZyByb3ciKTt0aGlzLmZvbGRzLnVuc2hpZnQoZSksdGhpcy5zdGFydC5yb3c9ZS5zdGFydC5yb3csdGhpcy5zdGFydC5jb2x1bW49ZS5zdGFydC5jb2x1bW59ZS5mb2xkTGluZT10aGlzfSx0aGlzLmNvbnRhaW5zUm93PWZ1bmN0aW9uKGUpe3JldHVybiBlPj10aGlzLnN0YXJ0LnJvdyYmZTw9dGhpcy5lbmQucm93fSx0aGlzLndhbGs9ZnVuY3Rpb24oZSx0LG4pe3ZhciByPTAsaT10aGlzLmZvbGRzLHMsbyx1LGE9ITA7dD09bnVsbCYmKHQ9dGhpcy5lbmQucm93LG49dGhpcy5lbmQuY29sdW1uKTtmb3IodmFyIGY9MDtmPGkubGVuZ3RoO2YrKyl7cz1pW2ZdLG89cy5yYW5nZS5jb21wYXJlU3RhcnQodCxuKTtpZihvPT0tMSl7ZShudWxsLHQsbixyLGEpO3JldHVybn11PWUobnVsbCxzLnN0YXJ0LnJvdyxzLnN0YXJ0LmNvbHVtbixyLGEpLHU9IXUmJmUocy5wbGFjZWhvbGRlcixzLnN0YXJ0LnJvdyxzLnN0YXJ0LmNvbHVtbixyKTtpZih1fHxvPT09MClyZXR1cm47YT0hcy5zYW1lUm93LHI9cy5lbmQuY29sdW1ufWUobnVsbCx0LG4scixhKX0sdGhpcy5nZXROZXh0Rm9sZFRvPWZ1bmN0aW9uKGUsdCl7dmFyIG4scjtmb3IodmFyIGk9MDtpPHRoaXMuZm9sZHMubGVuZ3RoO2krKyl7bj10aGlzLmZvbGRzW2ldLHI9bi5yYW5nZS5jb21wYXJlRW5kKGUsdCk7aWYocj09LTEpcmV0dXJue2ZvbGQ6bixraW5kOiJhZnRlciJ9O2lmKHI9PT0wKXJldHVybntmb2xkOm4sa2luZDoiaW5zaWRlIn19cmV0dXJuIG51bGx9LHRoaXMuYWRkUmVtb3ZlQ2hhcnM9ZnVuY3Rpb24oZSx0LG4pe3ZhciByPXRoaXMuZ2V0TmV4dEZvbGRUbyhlLHQpLGkscztpZihyKXtpPXIuZm9sZDtpZihyLmtpbmQ9PSJpbnNpZGUiJiZpLnN0YXJ0LmNvbHVtbiE9dCYmaS5zdGFydC5yb3chPWUpd2luZG93LmNvbnNvbGUmJndpbmRvdy5jb25zb2xlLmxvZyhlLHQsaSk7ZWxzZSBpZihpLnN0YXJ0LnJvdz09ZSl7cz10aGlzLmZvbGRzO3ZhciBvPXMuaW5kZXhPZihpKTtvPT09MCYmKHRoaXMuc3RhcnQuY29sdW1uKz1uKTtmb3IobztvPHMubGVuZ3RoO28rKyl7aT1zW29dLGkuc3RhcnQuY29sdW1uKz1uO2lmKCFpLnNhbWVSb3cpcmV0dXJuO2kuZW5kLmNvbHVtbis9bn10aGlzLmVuZC5jb2x1bW4rPW59fX0sdGhpcy5zcGxpdD1mdW5jdGlvbihlLHQpe3ZhciBuPXRoaXMuZ2V0TmV4dEZvbGRUbyhlLHQpO2lmKCFufHxuLmtpbmQ9PSJpbnNpZGUiKXJldHVybiBudWxsO3ZhciByPW4uZm9sZCxzPXRoaXMuZm9sZHMsbz10aGlzLmZvbGREYXRhLHU9cy5pbmRleE9mKHIpLGE9c1t1LTFdO3RoaXMuZW5kLnJvdz1hLmVuZC5yb3csdGhpcy5lbmQuY29sdW1uPWEuZW5kLmNvbHVtbixzPXMuc3BsaWNlKHUscy5sZW5ndGgtdSk7dmFyIGY9bmV3IGkobyxzKTtyZXR1cm4gby5zcGxpY2Uoby5pbmRleE9mKHRoaXMpKzEsMCxmKSxmfSx0aGlzLm1lcmdlPWZ1bmN0aW9uKGUpe3ZhciB0PWUuZm9sZHM7Zm9yKHZhciBuPTA7bjx0Lmxlbmd0aDtuKyspdGhpcy5hZGRGb2xkKHRbbl0pO3ZhciByPXRoaXMuZm9sZERhdGE7ci5zcGxpY2Uoci5pbmRleE9mKGUpLDEpfSx0aGlzLnRvU3RyaW5nPWZ1bmN0aW9uKCl7dmFyIGU9W3RoaXMucmFuZ2UudG9TdHJpbmcoKSsiOiBbIl07cmV0dXJuIHRoaXMuZm9sZHMuZm9yRWFjaChmdW5jdGlvbih0KXtlLnB1c2goIiAgIit0LnRvU3RyaW5nKCkpfSksZS5wdXNoKCJdIiksZS5qb2luKCJcbiIpfSx0aGlzLmlkeFRvUG9zaXRpb249ZnVuY3Rpb24oZSl7dmFyIHQ9MDtmb3IodmFyIG49MDtuPHRoaXMuZm9sZHMubGVuZ3RoO24rKyl7dmFyIHI9dGhpcy5mb2xkc1tuXTtlLT1yLnN0YXJ0LmNvbHVtbi10O2lmKGU8MClyZXR1cm57cm93OnIuc3RhcnQucm93LGNvbHVtbjpyLnN0YXJ0LmNvbHVtbitlfTtlLT1yLnBsYWNlaG9sZGVyLmxlbmd0aDtpZihlPDApcmV0dXJuIHIuc3RhcnQ7dD1yLmVuZC5jb2x1bW59cmV0dXJue3Jvdzp0aGlzLmVuZC5yb3csY29sdW1uOnRoaXMuZW5kLmNvbHVtbitlfX19KS5jYWxsKGkucHJvdG90eXBlKSx0LkZvbGRMaW5lPWl9KSxkZWZpbmUoImFjZS9yYW5nZV9saXN0IixbInJlcXVpcmUiLCJleHBvcnRzIiwibW9kdWxlIiwiYWNlL3JhbmdlIl0sZnVuY3Rpb24oZSx0LG4peyJ1c2Ugc3RyaWN0Ijt2YXIgcj1lKCIuL3JhbmdlIikuUmFuZ2UsaT1yLmNvbXBhcmVQb2ludHMscz1mdW5jdGlvbigpe3RoaXMucmFuZ2VzPVtdLHRoaXMuJGJpYXM9MX07KGZ1bmN0aW9uKCl7dGhpcy5jb21wYXJlUG9pbnRzPWksdGhpcy5wb2ludEluZGV4PWZ1bmN0aW9uKGUsdCxuKXt2YXIgcj10aGlzLnJhbmdlcztmb3IodmFyIHM9bnx8MDtzPHIubGVuZ3RoO3MrKyl7dmFyIG89cltzXSx1PWkoZSxvLmVuZCk7aWYodT4wKWNvbnRpbnVlO3ZhciBhPWkoZSxvLnN0YXJ0KTtyZXR1cm4gdT09PTA/dCYmYSE9PTA/LXMtMjpzOmE+MHx8YT09PTAmJiF0P3M6LXMtMX1yZXR1cm4tcy0xfSx0aGlzLmFkZD1mdW5jdGlvbihlKXt2YXIgdD0hZS5pc0VtcHR5KCksbj10aGlzLnBvaW50SW5kZXgoZS5zdGFydCx0KTtuPDAmJihuPS1uLTEpO3ZhciByPXRoaXMucG9pbnRJbmRleChlLmVuZCx0LG4pO3JldHVybiByPDA/cj0tci0xOnIrKyx0aGlzLnJhbmdlcy5zcGxpY2UobixyLW4sZSl9LHRoaXMuYWRkTGlzdD1mdW5jdGlvbihlKXt2YXIgdD1bXTtmb3IodmFyIG49ZS5sZW5ndGg7bi0tOyl0LnB1c2guYXBwbHkodCx0aGlzLmFkZChlW25dKSk7cmV0dXJuIHR9LHRoaXMuc3Vic3RyYWN0UG9pbnQ9ZnVuY3Rpb24oZSl7dmFyIHQ9dGhpcy5wb2ludEluZGV4KGUpO2lmKHQ+PTApcmV0dXJuIHRoaXMucmFuZ2VzLnNwbGljZSh0LDEpfSx0aGlzLm1lcmdlPWZ1bmN0aW9uKCl7dmFyIGU9W10sdD10aGlzLnJhbmdlczt0PXQuc29ydChmdW5jdGlvbihlLHQpe3JldHVybiBpKGUuc3RhcnQsdC5zdGFydCl9KTt2YXIgbj10WzBdLHI7Zm9yKHZhciBzPTE7czx0Lmxlbmd0aDtzKyspe3I9bixuPXRbc107dmFyIG89aShyLmVuZCxuLnN0YXJ0KTtpZihvPDApY29udGludWU7aWYobz09MCYmIXIuaXNFbXB0eSgpJiYhbi5pc0VtcHR5KCkpY29udGludWU7aShyLmVuZCxuLmVuZCk8MCYmKHIuZW5kLnJvdz1uLmVuZC5yb3csci5lbmQuY29sdW1uPW4uZW5kLmNvbHVtbiksdC5zcGxpY2UocywxKSxlLnB1c2gobiksbj1yLHMtLX1yZXR1cm4gdGhpcy5yYW5nZXM9dCxlfSx0aGlzLmNvbnRhaW5zPWZ1bmN0aW9uKGUsdCl7cmV0dXJuIHRoaXMucG9pbnRJbmRleCh7cm93OmUsY29sdW1uOnR9KT49MH0sdGhpcy5jb250YWluc1BvaW50PWZ1bmN0aW9uKGUpe3JldHVybiB0aGlzLnBvaW50SW5kZXgoZSk+PTB9LHRoaXMucmFuZ2VBdFBvaW50PWZ1bmN0aW9uKGUpe3ZhciB0PXRoaXMucG9pbnRJbmRleChlKTtpZih0Pj0wKXJldHVybiB0aGlzLnJhbmdlc1t0XX0sdGhpcy5jbGlwUm93cz1mdW5jdGlvbihlLHQpe3ZhciBuPXRoaXMucmFuZ2VzO2lmKG5bMF0uc3RhcnQucm93PnR8fG5bbi5sZW5ndGgtMV0uc3RhcnQucm93PGUpcmV0dXJuW107dmFyIHI9dGhpcy5wb2ludEluZGV4KHtyb3c6ZSxjb2x1bW46MH0pO3I8MCYmKHI9LXItMSk7dmFyIGk9dGhpcy5wb2ludEluZGV4KHtyb3c6dCxjb2x1bW46MH0scik7aTwwJiYoaT0taS0xKTt2YXIgcz1bXTtmb3IodmFyIG89cjtvPGk7bysrKXMucHVzaChuW29dKTtyZXR1cm4gc30sdGhpcy5yZW1vdmVBbGw9ZnVuY3Rpb24oKXtyZXR1cm4gdGhpcy5yYW5nZXMuc3BsaWNlKDAsdGhpcy5yYW5nZXMubGVuZ3RoKX0sdGhpcy5hdHRhY2g9ZnVuY3Rpb24oZSl7dGhpcy5zZXNzaW9uJiZ0aGlzLmRldGFjaCgpLHRoaXMuc2Vzc2lvbj1lLHRoaXMub25DaGFuZ2U9dGhpcy4kb25DaGFuZ2UuYmluZCh0aGlzKSx0aGlzLnNlc3Npb24ub24oImNoYW5nZSIsdGhpcy5vbkNoYW5nZSl9LHRoaXMuZGV0YWNoPWZ1bmN0aW9uKCl7aWYoIXRoaXMuc2Vzc2lvbilyZXR1cm47dGhpcy5zZXNzaW9uLnJlbW92ZUxpc3RlbmVyKCJjaGFuZ2UiLHRoaXMub25DaGFuZ2UpLHRoaXMuc2Vzc2lvbj1udWxsfSx0aGlzLiRvbkNoYW5nZT1mdW5jdGlvbihlKXt2YXIgdD1lLnN0YXJ0LG49ZS5lbmQscj10LnJvdyxpPW4ucm93LHM9dGhpcy5yYW5nZXM7Zm9yKHZhciBvPTAsdT1zLmxlbmd0aDtvPHU7bysrKXt2YXIgYT1zW29dO2lmKGEuZW5kLnJvdz49cilicmVha31pZihlLmFjdGlvbj09Imluc2VydCIpe3ZhciBmPWktcixsPS10LmNvbHVtbituLmNvbHVtbjtmb3IoO288dTtvKyspe3ZhciBhPXNbb107aWYoYS5zdGFydC5yb3c+cilicmVhazthLnN0YXJ0LnJvdz09ciYmYS5zdGFydC5jb2x1bW4+PXQuY29sdW1uJiYoYS5zdGFydC5jb2x1bW49PXQuY29sdW1uJiZ0aGlzLiRiaWFzPD0wfHwoYS5zdGFydC5jb2x1bW4rPWwsYS5zdGFydC5yb3crPWYpKTtpZihhLmVuZC5yb3c9PXImJmEuZW5kLmNvbHVtbj49dC5jb2x1bW4pe2lmKGEuZW5kLmNvbHVtbj09dC5jb2x1bW4mJnRoaXMuJGJpYXM8MCljb250aW51ZTthLmVuZC5jb2x1bW49PXQuY29sdW1uJiZsPjAmJm88dS0xJiZhLmVuZC5jb2x1bW4+YS5zdGFydC5jb2x1bW4mJmEuZW5kLmNvbHVtbj09c1tvKzFdLnN0YXJ0LmNvbHVtbiYmKGEuZW5kLmNvbHVtbi09bCksYS5lbmQuY29sdW1uKz1sLGEuZW5kLnJvdys9Zn19fWVsc2V7dmFyIGY9ci1pLGw9dC5jb2x1bW4tbi5jb2x1bW47Zm9yKDtvPHU7bysrKXt2YXIgYT1zW29dO2lmKGEuc3RhcnQucm93PmkpYnJlYWs7aWYoYS5lbmQucm93PGkmJihyPGEuZW5kLnJvd3x8cj09YS5lbmQucm93JiZ0LmNvbHVtbjxhLmVuZC5jb2x1bW4pKWEuZW5kLnJvdz1yLGEuZW5kLmNvbHVtbj10LmNvbHVtbjtlbHNlIGlmKGEuZW5kLnJvdz09aSlpZihhLmVuZC5jb2x1bW48PW4uY29sdW1uKXtpZihmfHxhLmVuZC5jb2x1bW4+dC5jb2x1bW4pYS5lbmQuY29sdW1uPXQuY29sdW1uLGEuZW5kLnJvdz10LnJvd31lbHNlIGEuZW5kLmNvbHVtbis9bCxhLmVuZC5yb3crPWY7ZWxzZSBhLmVuZC5yb3c+aSYmKGEuZW5kLnJvdys9Zik7aWYoYS5zdGFydC5yb3c8aSYmKHI8YS5zdGFydC5yb3d8fHI9PWEuc3RhcnQucm93JiZ0LmNvbHVtbjxhLnN0YXJ0LmNvbHVtbikpYS5zdGFydC5yb3c9cixhLnN0YXJ0LmNvbHVtbj10LmNvbHVtbjtlbHNlIGlmKGEuc3RhcnQucm93PT1pKWlmKGEuc3RhcnQuY29sdW1uPD1uLmNvbHVtbil7aWYoZnx8YS5zdGFydC5jb2x1bW4+dC5jb2x1bW4pYS5zdGFydC5jb2x1bW49dC5jb2x1bW4sYS5zdGFydC5yb3c9dC5yb3d9ZWxzZSBhLnN0YXJ0LmNvbHVtbis9bCxhLnN0YXJ0LnJvdys9ZjtlbHNlIGEuc3RhcnQucm93PmkmJihhLnN0YXJ0LnJvdys9Zil9fWlmKGYhPTAmJm88dSlmb3IoO288dTtvKyspe3ZhciBhPXNbb107YS5zdGFydC5yb3crPWYsYS5lbmQucm93Kz1mfX19KS5jYWxsKHMucHJvdG90eXBlKSx0LlJhbmdlTGlzdD1zfSksZGVmaW5lKCJhY2UvZWRpdF9zZXNzaW9uL2ZvbGQiLFsicmVxdWlyZSIsImV4cG9ydHMiLCJtb2R1bGUiLCJhY2UvcmFuZ2VfbGlzdCIsImFjZS9saWIvb29wIl0sZnVuY3Rpb24oZSx0LG4peyJ1c2Ugc3RyaWN0IjtmdW5jdGlvbiBvKGUsdCl7ZS5yb3ctPXQucm93LGUucm93PT0wJiYoZS5jb2x1bW4tPXQuY29sdW1uKX1mdW5jdGlvbiB1KGUsdCl7byhlLnN0YXJ0LHQpLG8oZS5lbmQsdCl9ZnVuY3Rpb24gYShlLHQpe2Uucm93PT0wJiYoZS5jb2x1bW4rPXQuY29sdW1uKSxlLnJvdys9dC5yb3d9ZnVuY3Rpb24gZihlLHQpe2EoZS5zdGFydCx0KSxhKGUuZW5kLHQpfXZhciByPWUoIi4uL3JhbmdlX2xpc3QiKS5SYW5nZUxpc3QsaT1lKCIuLi9saWIvb29wIikscz10LkZvbGQ9ZnVuY3Rpb24oZSx0KXt0aGlzLmZvbGRMaW5lPW51bGwsdGhpcy5wbGFjZWhvbGRlcj10LHRoaXMucmFuZ2U9ZSx0aGlzLnN0YXJ0PWUuc3RhcnQsdGhpcy5lbmQ9ZS5lbmQsdGhpcy5zYW1lUm93PWUuc3RhcnQucm93PT1lLmVuZC5yb3csdGhpcy5zdWJGb2xkcz10aGlzLnJhbmdlcz1bXX07aS5pbmhlcml0cyhzLHIpLGZ1bmN0aW9uKCl7dGhpcy50b1N0cmluZz1mdW5jdGlvbigpe3JldHVybiciJyt0aGlzLnBsYWNlaG9sZGVyKyciICcrdGhpcy5yYW5nZS50b1N0cmluZygpfSx0aGlzLnNldEZvbGRMaW5lPWZ1bmN0aW9uKGUpe3RoaXMuZm9sZExpbmU9ZSx0aGlzLnN1YkZvbGRzLmZvckVhY2goZnVuY3Rpb24odCl7dC5zZXRGb2xkTGluZShlKX0pfSx0aGlzLmNsb25lPWZ1bmN0aW9uKCl7dmFyIGU9dGhpcy5yYW5nZS5jbG9uZSgpLHQ9bmV3IHMoZSx0aGlzLnBsYWNlaG9sZGVyKTtyZXR1cm4gdGhpcy5zdWJGb2xkcy5mb3JFYWNoKGZ1bmN0aW9uKGUpe3Quc3ViRm9sZHMucHVzaChlLmNsb25lKCkpfSksdC5jb2xsYXBzZUNoaWxkcmVuPXRoaXMuY29sbGFwc2VDaGlsZHJlbix0fSx0aGlzLmFkZFN1YkZvbGQ9ZnVuY3Rpb24oZSl7aWYodGhpcy5yYW5nZS5pc0VxdWFsKGUpKXJldHVybjt1KGUsdGhpcy5zdGFydCk7dmFyIHQ9ZS5zdGFydC5yb3csbj1lLnN0YXJ0LmNvbHVtbjtmb3IodmFyIHI9MCxpPS0xO3I8dGhpcy5zdWJGb2xkcy5sZW5ndGg7cisrKXtpPXRoaXMuc3ViRm9sZHNbcl0ucmFuZ2UuY29tcGFyZSh0LG4pO2lmKGkhPTEpYnJlYWt9dmFyIHM9dGhpcy5zdWJGb2xkc1tyXSxvPTA7aWYoaT09MCl7aWYocy5yYW5nZS5jb250YWluc1JhbmdlKGUpKXJldHVybiBzLmFkZFN1YkZvbGQoZSk7bz0xfXZhciB0PWUucmFuZ2UuZW5kLnJvdyxuPWUucmFuZ2UuZW5kLmNvbHVtbjtmb3IodmFyIGE9cixpPS0xO2E8dGhpcy5zdWJGb2xkcy5sZW5ndGg7YSsrKXtpPXRoaXMuc3ViRm9sZHNbYV0ucmFuZ2UuY29tcGFyZSh0LG4pO2lmKGkhPTEpYnJlYWt9aT09MCYmYSsrO3ZhciBmPXRoaXMuc3ViRm9sZHMuc3BsaWNlKHIsYS1yLGUpLGw9aT09MD9mLmxlbmd0aC0xOmYubGVuZ3RoO2Zvcih2YXIgYz1vO2M8bDtjKyspZS5hZGRTdWJGb2xkKGZbY10pO3JldHVybiBlLnNldEZvbGRMaW5lKHRoaXMuZm9sZExpbmUpLGV9LHRoaXMucmVzdG9yZVJhbmdlPWZ1bmN0aW9uKGUpe3JldHVybiBmKGUsdGhpcy5zdGFydCl9fS5jYWxsKHMucHJvdG90eXBlKX0pLGRlZmluZSgiYWNlL2VkaXRfc2Vzc2lvbi9mb2xkaW5nIixbInJlcXVpcmUiLCJleHBvcnRzIiwibW9kdWxlIiwiYWNlL3JhbmdlIiwiYWNlL2VkaXRfc2Vzc2lvbi9mb2xkX2xpbmUiLCJhY2UvZWRpdF9zZXNzaW9uL2ZvbGQiLCJhY2UvdG9rZW5faXRlcmF0b3IiXSxmdW5jdGlvbihlLHQsbil7InVzZSBzdHJpY3QiO2Z1bmN0aW9uIHUoKXt0aGlzLmdldEZvbGRBdD1mdW5jdGlvbihlLHQsbil7dmFyIHI9dGhpcy5nZXRGb2xkTGluZShlKTtpZighcilyZXR1cm4gbnVsbDt2YXIgaT1yLmZvbGRzO2Zvcih2YXIgcz0wO3M8aS5sZW5ndGg7cysrKXt2YXIgbz1pW3NdLnJhbmdlO2lmKG8uY29udGFpbnMoZSx0KSl7aWYobj09MSYmby5pc0VuZChlLHQpJiYhby5pc0VtcHR5KCkpY29udGludWU7aWYobj09LTEmJm8uaXNTdGFydChlLHQpJiYhby5pc0VtcHR5KCkpY29udGludWU7cmV0dXJuIGlbc119fX0sdGhpcy5nZXRGb2xkc0luUmFuZ2U9ZnVuY3Rpb24oZSl7dmFyIHQ9ZS5zdGFydCxuPWUuZW5kLHI9dGhpcy4kZm9sZERhdGEsaT1bXTt0LmNvbHVtbis9MSxuLmNvbHVtbi09MTtmb3IodmFyIHM9MDtzPHIubGVuZ3RoO3MrKyl7dmFyIG89cltzXS5yYW5nZS5jb21wYXJlUmFuZ2UoZSk7aWYobz09Miljb250aW51ZTtpZihvPT0tMilicmVhazt2YXIgdT1yW3NdLmZvbGRzO2Zvcih2YXIgYT0wO2E8dS5sZW5ndGg7YSsrKXt2YXIgZj11W2FdO289Zi5yYW5nZS5jb21wYXJlUmFuZ2UoZSk7aWYobz09LTIpYnJlYWs7aWYobz09Miljb250aW51ZTtpZihvPT00MilicmVhaztpLnB1c2goZil9fXJldHVybiB0LmNvbHVtbi09MSxuLmNvbHVtbis9MSxpfSx0aGlzLmdldEZvbGRzSW5SYW5nZUxpc3Q9ZnVuY3Rpb24oZSl7aWYoQXJyYXkuaXNBcnJheShlKSl7dmFyIHQ9W107ZS5mb3JFYWNoKGZ1bmN0aW9uKGUpe3Q9dC5jb25jYXQodGhpcy5nZXRGb2xkc0luUmFuZ2UoZSkpfSx0aGlzKX1lbHNlIHZhciB0PXRoaXMuZ2V0Rm9sZHNJblJhbmdlKGUpO3JldHVybiB0fSx0aGlzLmdldEFsbEZvbGRzPWZ1bmN0aW9uKCl7dmFyIGU9W10sdD10aGlzLiRmb2xkRGF0YTtmb3IodmFyIG49MDtuPHQubGVuZ3RoO24rKylmb3IodmFyIHI9MDtyPHRbbl0uZm9sZHMubGVuZ3RoO3IrKyllLnB1c2godFtuXS5mb2xkc1tyXSk7cmV0dXJuIGV9LHRoaXMuZ2V0Rm9sZFN0cmluZ0F0PWZ1bmN0aW9uKGUsdCxuLHIpe3I9cnx8dGhpcy5nZXRGb2xkTGluZShlKTtpZighcilyZXR1cm4gbnVsbDt2YXIgaT17ZW5kOntjb2x1bW46MH19LHMsbztmb3IodmFyIHU9MDt1PHIuZm9sZHMubGVuZ3RoO3UrKyl7bz1yLmZvbGRzW3VdO3ZhciBhPW8ucmFuZ2UuY29tcGFyZUVuZChlLHQpO2lmKGE9PS0xKXtzPXRoaXMuZ2V0TGluZShvLnN0YXJ0LnJvdykuc3Vic3RyaW5nKGkuZW5kLmNvbHVtbixvLnN0YXJ0LmNvbHVtbik7YnJlYWt9aWYoYT09PTApcmV0dXJuIG51bGw7aT1vfXJldHVybiBzfHwocz10aGlzLmdldExpbmUoby5zdGFydC5yb3cpLnN1YnN0cmluZyhpLmVuZC5jb2x1bW4pKSxuPT0tMT9zLnN1YnN0cmluZygwLHQtaS5lbmQuY29sdW1uKTpuPT0xP3Muc3Vic3RyaW5nKHQtaS5lbmQuY29sdW1uKTpzfSx0aGlzLmdldEZvbGRMaW5lPWZ1bmN0aW9uKGUsdCl7dmFyIG49dGhpcy4kZm9sZERhdGEscj0wO3QmJihyPW4uaW5kZXhPZih0KSkscj09LTEmJihyPTApO2ZvcihyO3I8bi5sZW5ndGg7cisrKXt2YXIgaT1uW3JdO2lmKGkuc3RhcnQucm93PD1lJiZpLmVuZC5yb3c+PWUpcmV0dXJuIGk7aWYoaS5lbmQucm93PmUpcmV0dXJuIG51bGx9cmV0dXJuIG51bGx9LHRoaXMuZ2V0TmV4dEZvbGRMaW5lPWZ1bmN0aW9uKGUsdCl7dmFyIG49dGhpcy4kZm9sZERhdGEscj0wO3QmJihyPW4uaW5kZXhPZih0KSkscj09LTEmJihyPTApO2ZvcihyO3I8bi5sZW5ndGg7cisrKXt2YXIgaT1uW3JdO2lmKGkuZW5kLnJvdz49ZSlyZXR1cm4gaX1yZXR1cm4gbnVsbH0sdGhpcy5nZXRGb2xkZWRSb3dDb3VudD1mdW5jdGlvbihlLHQpe3ZhciBuPXRoaXMuJGZvbGREYXRhLHI9dC1lKzE7Zm9yKHZhciBpPTA7aTxuLmxlbmd0aDtpKyspe3ZhciBzPW5baV0sbz1zLmVuZC5yb3csdT1zLnN0YXJ0LnJvdztpZihvPj10KXt1PHQmJih1Pj1lP3ItPXQtdTpyPTApO2JyZWFrfW8+PWUmJih1Pj1lP3ItPW8tdTpyLT1vLWUrMSl9cmV0dXJuIHJ9LHRoaXMuJGFkZEZvbGRMaW5lPWZ1bmN0aW9uKGUpe3JldHVybiB0aGlzLiRmb2xkRGF0YS5wdXNoKGUpLHRoaXMuJGZvbGREYXRhLnNvcnQoZnVuY3Rpb24oZSx0KXtyZXR1cm4gZS5zdGFydC5yb3ctdC5zdGFydC5yb3d9KSxlfSx0aGlzLmFkZEZvbGQ9ZnVuY3Rpb24oZSx0KXt2YXIgbj10aGlzLiRmb2xkRGF0YSxyPSExLG87ZSBpbnN0YW5jZW9mIHM/bz1lOihvPW5ldyBzKHQsZSksby5jb2xsYXBzZUNoaWxkcmVuPXQuY29sbGFwc2VDaGlsZHJlbiksdGhpcy4kY2xpcFJhbmdlVG9Eb2N1bWVudChvLnJhbmdlKTt2YXIgdT1vLnN0YXJ0LnJvdyxhPW8uc3RhcnQuY29sdW1uLGY9by5lbmQucm93LGw9by5lbmQuY29sdW1uLGM9dGhpcy5nZXRGb2xkQXQodSxhLDEpLGg9dGhpcy5nZXRGb2xkQXQoZixsLC0xKTtpZihjJiZoPT1jKXJldHVybiBjLmFkZFN1YkZvbGQobyk7YyYmIWMucmFuZ2UuaXNTdGFydCh1LGEpJiZ0aGlzLnJlbW92ZUZvbGQoYyksaCYmIWgucmFuZ2UuaXNFbmQoZixsKSYmdGhpcy5yZW1vdmVGb2xkKGgpO3ZhciBwPXRoaXMuZ2V0Rm9sZHNJblJhbmdlKG8ucmFuZ2UpO3AubGVuZ3RoPjAmJih0aGlzLnJlbW92ZUZvbGRzKHApLG8uY29sbGFwc2VDaGlsZHJlbnx8cC5mb3JFYWNoKGZ1bmN0aW9uKGUpe28uYWRkU3ViRm9sZChlKX0pKTtmb3IodmFyIGQ9MDtkPG4ubGVuZ3RoO2QrKyl7dmFyIHY9bltkXTtpZihmPT12LnN0YXJ0LnJvdyl7di5hZGRGb2xkKG8pLHI9ITA7YnJlYWt9aWYodT09di5lbmQucm93KXt2LmFkZEZvbGQobykscj0hMDtpZighby5zYW1lUm93KXt2YXIgbT1uW2QrMV07aWYobSYmbS5zdGFydC5yb3c9PWYpe3YubWVyZ2UobSk7YnJlYWt9fWJyZWFrfWlmKGY8PXYuc3RhcnQucm93KWJyZWFrfXJldHVybiByfHwodj10aGlzLiRhZGRGb2xkTGluZShuZXcgaSh0aGlzLiRmb2xkRGF0YSxvKSkpLHRoaXMuJHVzZVdyYXBNb2RlP3RoaXMuJHVwZGF0ZVdyYXBEYXRhKHYuc3RhcnQucm93LHYuc3RhcnQucm93KTp0aGlzLiR1cGRhdGVSb3dMZW5ndGhDYWNoZSh2LnN0YXJ0LnJvdyx2LnN0YXJ0LnJvdyksdGhpcy4kbW9kaWZpZWQ9ITAsdGhpcy5fc2lnbmFsKCJjaGFuZ2VGb2xkIix7ZGF0YTpvLGFjdGlvbjoiYWRkIn0pLG99LHRoaXMuYWRkRm9sZHM9ZnVuY3Rpb24oZSl7ZS5mb3JFYWNoKGZ1bmN0aW9uKGUpe3RoaXMuYWRkRm9sZChlKX0sdGhpcyl9LHRoaXMucmVtb3ZlRm9sZD1mdW5jdGlvbihlKXt2YXIgdD1lLmZvbGRMaW5lLG49dC5zdGFydC5yb3cscj10LmVuZC5yb3csaT10aGlzLiRmb2xkRGF0YSxzPXQuZm9sZHM7aWYocy5sZW5ndGg9PTEpaS5zcGxpY2UoaS5pbmRleE9mKHQpLDEpO2Vsc2UgaWYodC5yYW5nZS5pc0VuZChlLmVuZC5yb3csZS5lbmQuY29sdW1uKSlzLnBvcCgpLHQuZW5kLnJvdz1zW3MubGVuZ3RoLTFdLmVuZC5yb3csdC5lbmQuY29sdW1uPXNbcy5sZW5ndGgtMV0uZW5kLmNvbHVtbjtlbHNlIGlmKHQucmFuZ2UuaXNTdGFydChlLnN0YXJ0LnJvdyxlLnN0YXJ0LmNvbHVtbikpcy5zaGlmdCgpLHQuc3RhcnQucm93PXNbMF0uc3RhcnQucm93LHQuc3RhcnQuY29sdW1uPXNbMF0uc3RhcnQuY29sdW1uO2Vsc2UgaWYoZS5zYW1lUm93KXMuc3BsaWNlKHMuaW5kZXhPZihlKSwxKTtlbHNle3ZhciBvPXQuc3BsaXQoZS5zdGFydC5yb3csZS5zdGFydC5jb2x1bW4pO3M9by5mb2xkcyxzLnNoaWZ0KCksby5zdGFydC5yb3c9c1swXS5zdGFydC5yb3csby5zdGFydC5jb2x1bW49c1swXS5zdGFydC5jb2x1bW59dGhpcy4kdXBkYXRpbmd8fCh0aGlzLiR1c2VXcmFwTW9kZT90aGlzLiR1cGRhdGVXcmFwRGF0YShuLHIpOnRoaXMuJHVwZGF0ZVJvd0xlbmd0aENhY2hlKG4scikpLHRoaXMuJG1vZGlmaWVkPSEwLHRoaXMuX3NpZ25hbCgiY2hhbmdlRm9sZCIse2RhdGE6ZSxhY3Rpb246InJlbW92ZSJ9KX0sdGhpcy5yZW1vdmVGb2xkcz1mdW5jdGlvbihlKXt2YXIgdD1bXTtmb3IodmFyIG49MDtuPGUubGVuZ3RoO24rKyl0LnB1c2goZVtuXSk7dC5mb3JFYWNoKGZ1bmN0aW9uKGUpe3RoaXMucmVtb3ZlRm9sZChlKX0sdGhpcyksdGhpcy4kbW9kaWZpZWQ9ITB9LHRoaXMuZXhwYW5kRm9sZD1mdW5jdGlvbihlKXt0aGlzLnJlbW92ZUZvbGQoZSksZS5zdWJGb2xkcy5mb3JFYWNoKGZ1bmN0aW9uKHQpe2UucmVzdG9yZVJhbmdlKHQpLHRoaXMuYWRkRm9sZCh0KX0sdGhpcyksZS5jb2xsYXBzZUNoaWxkcmVuPjAmJnRoaXMuZm9sZEFsbChlLnN0YXJ0LnJvdysxLGUuZW5kLnJvdyxlLmNvbGxhcHNlQ2hpbGRyZW4tMSksZS5zdWJGb2xkcz1bXX0sdGhpcy5leHBhbmRGb2xkcz1mdW5jdGlvbihlKXtlLmZvckVhY2goZnVuY3Rpb24oZSl7dGhpcy5leHBhbmRGb2xkKGUpfSx0aGlzKX0sdGhpcy51bmZvbGQ9ZnVuY3Rpb24oZSx0KXt2YXIgbixpO2lmKGU9PW51bGwpbj1uZXcgcigwLDAsdGhpcy5nZXRMZW5ndGgoKSwwKSx0PT1udWxsJiYodD0hMCk7ZWxzZSBpZih0eXBlb2YgZT09Im51bWJlciIpbj1uZXcgcihlLDAsZSx0aGlzLmdldExpbmUoZSkubGVuZ3RoKTtlbHNlIGlmKCJyb3ciaW4gZSluPXIuZnJvbVBvaW50cyhlLGUpO2Vsc2V7aWYoQXJyYXkuaXNBcnJheShlKSlyZXR1cm4gaT1bXSxlLmZvckVhY2goZnVuY3Rpb24oZSl7aT1pLmNvbmNhdCh0aGlzLnVuZm9sZChlKSl9LHRoaXMpLGk7bj1lfWk9dGhpcy5nZXRGb2xkc0luUmFuZ2VMaXN0KG4pO3ZhciBzPWk7d2hpbGUoaS5sZW5ndGg9PTEmJnIuY29tcGFyZVBvaW50cyhpWzBdLnN0YXJ0LG4uc3RhcnQpPDAmJnIuY29tcGFyZVBvaW50cyhpWzBdLmVuZCxuLmVuZCk+MCl0aGlzLmV4cGFuZEZvbGRzKGkpLGk9dGhpcy5nZXRGb2xkc0luUmFuZ2VMaXN0KG4pO3QhPTA/dGhpcy5yZW1vdmVGb2xkcyhpKTp0aGlzLmV4cGFuZEZvbGRzKGkpO2lmKHMubGVuZ3RoKXJldHVybiBzfSx0aGlzLmlzUm93Rm9sZGVkPWZ1bmN0aW9uKGUsdCl7cmV0dXJuISF0aGlzLmdldEZvbGRMaW5lKGUsdCl9LHRoaXMuZ2V0Um93Rm9sZEVuZD1mdW5jdGlvbihlLHQpe3ZhciBuPXRoaXMuZ2V0Rm9sZExpbmUoZSx0KTtyZXR1cm4gbj9uLmVuZC5yb3c6ZX0sdGhpcy5nZXRSb3dGb2xkU3RhcnQ9ZnVuY3Rpb24oZSx0KXt2YXIgbj10aGlzLmdldEZvbGRMaW5lKGUsdCk7cmV0dXJuIG4/bi5zdGFydC5yb3c6ZX0sdGhpcy5nZXRGb2xkRGlzcGxheUxpbmU9ZnVuY3Rpb24oZSx0LG4scixpKXtyPT1udWxsJiYocj1lLnN0YXJ0LnJvdyksaT09bnVsbCYmKGk9MCksdD09bnVsbCYmKHQ9ZS5lbmQucm93KSxuPT1udWxsJiYobj10aGlzLmdldExpbmUodCkubGVuZ3RoKTt2YXIgcz10aGlzLmRvYyxvPSIiO3JldHVybiBlLndhbGsoZnVuY3Rpb24oZSx0LG4sdSl7aWYodDxyKXJldHVybjtpZih0PT1yKXtpZihuPGkpcmV0dXJuO3U9TWF0aC5tYXgoaSx1KX1lIT1udWxsP28rPWU6bys9cy5nZXRMaW5lKHQpLnN1YnN0cmluZyh1LG4pfSx0LG4pLG99LHRoaXMuZ2V0RGlzcGxheUxpbmU9ZnVuY3Rpb24oZSx0LG4scil7dmFyIGk9dGhpcy5nZXRGb2xkTGluZShlKTtpZighaSl7dmFyIHM7cmV0dXJuIHM9dGhpcy5kb2MuZ2V0TGluZShlKSxzLnN1YnN0cmluZyhyfHwwLHR8fHMubGVuZ3RoKX1yZXR1cm4gdGhpcy5nZXRGb2xkRGlzcGxheUxpbmUoaSxlLHQsbixyKX0sdGhpcy4kY2xvbmVGb2xkRGF0YT1mdW5jdGlvbigpe3ZhciBlPVtdO3JldHVybiBlPXRoaXMuJGZvbGREYXRhLm1hcChmdW5jdGlvbih0KXt2YXIgbj10LmZvbGRzLm1hcChmdW5jdGlvbihlKXtyZXR1cm4gZS5jbG9uZSgpfSk7cmV0dXJuIG5ldyBpKGUsbil9KSxlfSx0aGlzLnRvZ2dsZUZvbGQ9ZnVuY3Rpb24oZSl7dmFyIHQ9dGhpcy5zZWxlY3Rpb24sbj10LmdldFJhbmdlKCkscixpO2lmKG4uaXNFbXB0eSgpKXt2YXIgcz1uLnN0YXJ0O3I9dGhpcy5nZXRGb2xkQXQocy5yb3cscy5jb2x1bW4pO2lmKHIpe3RoaXMuZXhwYW5kRm9sZChyKTtyZXR1cm59KGk9dGhpcy5maW5kTWF0Y2hpbmdCcmFja2V0KHMpKT9uLmNvbXBhcmVQb2ludChpKT09MT9uLmVuZD1pOihuLnN0YXJ0PWksbi5zdGFydC5jb2x1bW4rKyxuLmVuZC5jb2x1bW4tLSk6KGk9dGhpcy5maW5kTWF0Y2hpbmdCcmFja2V0KHtyb3c6cy5yb3csY29sdW1uOnMuY29sdW1uKzF9KSk/KG4uY29tcGFyZVBvaW50KGkpPT0xP24uZW5kPWk6bi5zdGFydD1pLG4uc3RhcnQuY29sdW1uKyspOm49dGhpcy5nZXRDb21tZW50Rm9sZFJhbmdlKHMucm93LHMuY29sdW1uKXx8bn1lbHNle3ZhciBvPXRoaXMuZ2V0Rm9sZHNJblJhbmdlKG4pO2lmKGUmJm8ubGVuZ3RoKXt0aGlzLmV4cGFuZEZvbGRzKG8pO3JldHVybn1vLmxlbmd0aD09MSYmKHI9b1swXSl9cnx8KHI9dGhpcy5nZXRGb2xkQXQobi5zdGFydC5yb3csbi5zdGFydC5jb2x1bW4pKTtpZihyJiZyLnJhbmdlLnRvU3RyaW5nKCk9PW4udG9TdHJpbmcoKSl7dGhpcy5leHBhbmRGb2xkKHIpO3JldHVybn12YXIgdT0iLi4uIjtpZighbi5pc011bHRpTGluZSgpKXt1PXRoaXMuZ2V0VGV4dFJhbmdlKG4pO2lmKHUubGVuZ3RoPDQpcmV0dXJuO3U9dS50cmltKCkuc3Vic3RyaW5nKDAsMikrIi4uIn10aGlzLmFkZEZvbGQodSxuKX0sdGhpcy5nZXRDb21tZW50Rm9sZFJhbmdlPWZ1bmN0aW9uKGUsdCxuKXt2YXIgaT1uZXcgbyh0aGlzLGUsdCkscz1pLmdldEN1cnJlbnRUb2tlbigpLHU9cyYmcy50eXBlO2lmKHMmJi9eY29tbWVudHxzdHJpbmcvLnRlc3QodSkpe3U9dS5tYXRjaCgvY29tbWVudHxzdHJpbmcvKVswXSx1PT0iY29tbWVudCImJih1Kz0ifGRvYy1zdGFydCIpO3ZhciBhPW5ldyBSZWdFeHAodSksZj1uZXcgcjtpZihuIT0xKXtkbyBzPWkuc3RlcEJhY2t3YXJkKCk7d2hpbGUocyYmYS50ZXN0KHMudHlwZSkmJiEvXmNvbW1lbnQuZW5kLy50ZXN0KHMudHlwZSkpO3M9aS5zdGVwRm9yd2FyZCgpfWYuc3RhcnQucm93PWkuZ2V0Q3VycmVudFRva2VuUm93KCksZi5zdGFydC5jb2x1bW49aS5nZXRDdXJyZW50VG9rZW5Db2x1bW4oKSsoL15jb21tZW50LnN0YXJ0Ly50ZXN0KHMudHlwZSk/cy52YWx1ZS5sZW5ndGg6MiksaT1uZXcgbyh0aGlzLGUsdCk7aWYobiE9LTEpe3ZhciBsPS0xO2Rve3M9aS5zdGVwRm9yd2FyZCgpO2lmKGw9PS0xKXt2YXIgYz10aGlzLmdldFN0YXRlKGkuJHJvdyk7YS50ZXN0KGMpfHwobD1pLiRyb3cpfWVsc2UgaWYoaS4kcm93PmwpYnJlYWt9d2hpbGUocyYmYS50ZXN0KHMudHlwZSkmJiEvXmNvbW1lbnQuc3RhcnQvLnRlc3Qocy50eXBlKSk7cz1pLnN0ZXBCYWNrd2FyZCgpfWVsc2Ugcz1pLmdldEN1cnJlbnRUb2tlbigpO3JldHVybiBmLmVuZC5yb3c9aS5nZXRDdXJyZW50VG9rZW5Sb3coKSxmLmVuZC5jb2x1bW49aS5nZXRDdXJyZW50VG9rZW5Db2x1bW4oKSwvXmNvbW1lbnQuZW5kLy50ZXN0KHMudHlwZSl8fChmLmVuZC5jb2x1bW4rPXMudmFsdWUubGVuZ3RoLTIpLGZ9fSx0aGlzLmZvbGRBbGw9ZnVuY3Rpb24oZSx0LG4scil7bj09dW5kZWZpbmVkJiYobj0xZTUpO3ZhciBpPXRoaXMuZm9sZFdpZGdldHM7aWYoIWkpcmV0dXJuO3Q9dHx8dGhpcy5nZXRMZW5ndGgoKSxlPWV8fDA7Zm9yKHZhciBzPWU7czx0O3MrKyl7aVtzXT09bnVsbCYmKGlbc109dGhpcy5nZXRGb2xkV2lkZ2V0KHMpKTtpZihpW3NdIT0ic3RhcnQiKWNvbnRpbnVlO2lmKHImJiFyKHMpKWNvbnRpbnVlO3ZhciBvPXRoaXMuZ2V0Rm9sZFdpZGdldFJhbmdlKHMpO28mJm8uaXNNdWx0aUxpbmUoKSYmby5lbmQucm93PD10JiZvLnN0YXJ0LnJvdz49ZSYmKHM9by5lbmQucm93LG8uY29sbGFwc2VDaGlsZHJlbj1uLHRoaXMuYWRkRm9sZCgiLi4uIixvKSl9fSx0aGlzLmZvbGRUb0xldmVsPWZ1bmN0aW9uKGUpe3RoaXMuZm9sZEFsbCgpO3doaWxlKGUtLT4wKXRoaXMudW5mb2xkKG51bGwsITEpfSx0aGlzLmZvbGRBbGxDb21tZW50cz1mdW5jdGlvbigpe3ZhciBlPXRoaXM7dGhpcy5mb2xkQWxsKG51bGwsbnVsbCxudWxsLGZ1bmN0aW9uKHQpe3ZhciBuPWUuZ2V0VG9rZW5zKHQpO2Zvcih2YXIgcj0wO3I8bi5sZW5ndGg7cisrKXt2YXIgaT1uW3JdO2lmKGkudHlwZT09InRleHQiJiYvXlxzKyQvLnRlc3QoaS52YWx1ZSkpY29udGludWU7cmV0dXJuL2NvbW1lbnQvLnRlc3QoaS50eXBlKT8hMDohMX19KX0sdGhpcy4kZm9sZFN0eWxlcz17bWFudWFsOjEsbWFya2JlZ2luOjEsbWFya2JlZ2luZW5kOjF9LHRoaXMuJGZvbGRTdHlsZT0ibWFya2JlZ2luIix0aGlzLnNldEZvbGRTdHlsZT1mdW5jdGlvbihlKXtpZighdGhpcy4kZm9sZFN0eWxlc1tlXSl0aHJvdyBuZXcgRXJyb3IoImludmFsaWQgZm9sZCBzdHlsZTogIitlKyJbIitPYmplY3Qua2V5cyh0aGlzLiRmb2xkU3R5bGVzKS5qb2luKCIsICIpKyJdIik7aWYodGhpcy4kZm9sZFN0eWxlPT1lKXJldHVybjt0aGlzLiRmb2xkU3R5bGU9ZSxlPT0ibWFudWFsIiYmdGhpcy51bmZvbGQoKTt2YXIgdD10aGlzLiRmb2xkTW9kZTt0aGlzLiRzZXRGb2xkaW5nKG51bGwpLHRoaXMuJHNldEZvbGRpbmcodCl9LHRoaXMuJHNldEZvbGRpbmc9ZnVuY3Rpb24oZSl7aWYodGhpcy4kZm9sZE1vZGU9PWUpcmV0dXJuO3RoaXMuJGZvbGRNb2RlPWUsdGhpcy5vZmYoImNoYW5nZSIsdGhpcy4kdXBkYXRlRm9sZFdpZGdldHMpLHRoaXMub2ZmKCJ0b2tlbml6ZXJVcGRhdGUiLHRoaXMuJHRva2VuaXplclVwZGF0ZUZvbGRXaWRnZXRzKSx0aGlzLl9zaWduYWwoImNoYW5nZUFubm90YXRpb24iKTtpZighZXx8dGhpcy4kZm9sZFN0eWxlPT0ibWFudWFsIil7dGhpcy5mb2xkV2lkZ2V0cz1udWxsO3JldHVybn10aGlzLmZvbGRXaWRnZXRzPVtdLHRoaXMuZ2V0Rm9sZFdpZGdldD1lLmdldEZvbGRXaWRnZXQuYmluZChlLHRoaXMsdGhpcy4kZm9sZFN0eWxlKSx0aGlzLmdldEZvbGRXaWRnZXRSYW5nZT1lLmdldEZvbGRXaWRnZXRSYW5nZS5iaW5kKGUsdGhpcyx0aGlzLiRmb2xkU3R5bGUpLHRoaXMuJHVwZGF0ZUZvbGRXaWRnZXRzPXRoaXMudXBkYXRlRm9sZFdpZGdldHMuYmluZCh0aGlzKSx0aGlzLiR0b2tlbml6ZXJVcGRhdGVGb2xkV2lkZ2V0cz10aGlzLnRva2VuaXplclVwZGF0ZUZvbGRXaWRnZXRzLmJpbmQodGhpcyksdGhpcy5vbigiY2hhbmdlIix0aGlzLiR1cGRhdGVGb2xkV2lkZ2V0cyksdGhpcy5vbigidG9rZW5pemVyVXBkYXRlIix0aGlzLiR0b2tlbml6ZXJVcGRhdGVGb2xkV2lkZ2V0cyl9LHRoaXMuZ2V0UGFyZW50Rm9sZFJhbmdlRGF0YT1mdW5jdGlvbihlLHQpe3ZhciBuPXRoaXMuZm9sZFdpZGdldHM7aWYoIW58fHQmJm5bZV0pcmV0dXJue307dmFyIHI9ZS0xLGk7d2hpbGUocj49MCl7dmFyIHM9bltyXTtzPT1udWxsJiYocz1uW3JdPXRoaXMuZ2V0Rm9sZFdpZGdldChyKSk7aWYocz09InN0YXJ0Iil7dmFyIG89dGhpcy5nZXRGb2xkV2lkZ2V0UmFuZ2Uocik7aXx8KGk9byk7aWYobyYmby5lbmQucm93Pj1lKWJyZWFrfXItLX1yZXR1cm57cmFuZ2U6ciE9PS0xJiZvLGZpcnN0UmFuZ2U6aX19LHRoaXMub25Gb2xkV2lkZ2V0Q2xpY2s9ZnVuY3Rpb24oZSx0KXt0PXQuZG9tRXZlbnQ7dmFyIG49e2NoaWxkcmVuOnQuc2hpZnRLZXksYWxsOnQuY3RybEtleXx8dC5tZXRhS2V5LHNpYmxpbmdzOnQuYWx0S2V5fSxyPXRoaXMuJHRvZ2dsZUZvbGRXaWRnZXQoZSxuKTtpZighcil7dmFyIGk9dC50YXJnZXR8fHQuc3JjRWxlbWVudDtpJiYvYWNlX2ZvbGQtd2lkZ2V0Ly50ZXN0KGkuY2xhc3NOYW1lKSYmKGkuY2xhc3NOYW1lKz0iIGFjZV9pbnZhbGlkIil9fSx0aGlzLiR0b2dnbGVGb2xkV2lkZ2V0PWZ1bmN0aW9uKGUsdCl7aWYoIXRoaXMuZ2V0Rm9sZFdpZGdldClyZXR1cm47dmFyIG49dGhpcy5nZXRGb2xkV2lkZ2V0KGUpLHI9dGhpcy5nZXRMaW5lKGUpLGk9bj09PSJlbmQiPy0xOjEscz10aGlzLmdldEZvbGRBdChlLGk9PT0tMT8wOnIubGVuZ3RoLGkpO2lmKHMpcmV0dXJuIHQuY2hpbGRyZW58fHQuYWxsP3RoaXMucmVtb3ZlRm9sZChzKTp0aGlzLmV4cGFuZEZvbGQocyksczt2YXIgbz10aGlzLmdldEZvbGRXaWRnZXRSYW5nZShlLCEwKTtpZihvJiYhby5pc011bHRpTGluZSgpKXtzPXRoaXMuZ2V0Rm9sZEF0KG8uc3RhcnQucm93LG8uc3RhcnQuY29sdW1uLDEpO2lmKHMmJm8uaXNFcXVhbChzLnJhbmdlKSlyZXR1cm4gdGhpcy5yZW1vdmVGb2xkKHMpLHN9aWYodC5zaWJsaW5ncyl7dmFyIHU9dGhpcy5nZXRQYXJlbnRGb2xkUmFuZ2VEYXRhKGUpO2lmKHUucmFuZ2UpdmFyIGE9dS5yYW5nZS5zdGFydC5yb3crMSxmPXUucmFuZ2UuZW5kLnJvdzt0aGlzLmZvbGRBbGwoYSxmLHQuYWxsPzFlNDowKX1lbHNlIHQuY2hpbGRyZW4/KGY9bz9vLmVuZC5yb3c6dGhpcy5nZXRMZW5ndGgoKSx0aGlzLmZvbGRBbGwoZSsxLGYsdC5hbGw/MWU0OjApKTpvJiYodC5hbGwmJihvLmNvbGxhcHNlQ2hpbGRyZW49MWU0KSx0aGlzLmFkZEZvbGQoIi4uLiIsbykpO3JldHVybiBvfSx0aGlzLnRvZ2dsZUZvbGRXaWRnZXQ9ZnVuY3Rpb24oZSl7dmFyIHQ9dGhpcy5zZWxlY3Rpb24uZ2V0Q3Vyc29yKCkucm93O3Q9dGhpcy5nZXRSb3dGb2xkU3RhcnQodCk7dmFyIG49dGhpcy4kdG9nZ2xlRm9sZFdpZGdldCh0LHt9KTtpZihuKXJldHVybjt2YXIgcj10aGlzLmdldFBhcmVudEZvbGRSYW5nZURhdGEodCwhMCk7bj1yLnJhbmdlfHxyLmZpcnN0UmFuZ2U7aWYobil7dD1uLnN0YXJ0LnJvdzt2YXIgaT10aGlzLmdldEZvbGRBdCh0LHRoaXMuZ2V0TGluZSh0KS5sZW5ndGgsMSk7aT90aGlzLnJlbW92ZUZvbGQoaSk6dGhpcy5hZGRGb2xkKCIuLi4iLG4pfX0sdGhpcy51cGRhdGVGb2xkV2lkZ2V0cz1mdW5jdGlvbihlKXt2YXIgdD1lLnN0YXJ0LnJvdyxuPWUuZW5kLnJvdy10O2lmKG49PT0wKXRoaXMuZm9sZFdpZGdldHNbdF09bnVsbDtlbHNlIGlmKGUuYWN0aW9uPT0icmVtb3ZlIil0aGlzLmZvbGRXaWRnZXRzLnNwbGljZSh0LG4rMSxudWxsKTtlbHNle3ZhciByPUFycmF5KG4rMSk7ci51bnNoaWZ0KHQsMSksdGhpcy5mb2xkV2lkZ2V0cy5zcGxpY2UuYXBwbHkodGhpcy5mb2xkV2lkZ2V0cyxyKX19LHRoaXMudG9rZW5pemVyVXBkYXRlRm9sZFdpZGdldHM9ZnVuY3Rpb24oZSl7dmFyIHQ9ZS5kYXRhO3QuZmlyc3QhPXQubGFzdCYmdGhpcy5mb2xkV2lkZ2V0cy5sZW5ndGg+dC5maXJzdCYmdGhpcy5mb2xkV2lkZ2V0cy5zcGxpY2UodC5maXJzdCx0aGlzLmZvbGRXaWRnZXRzLmxlbmd0aCl9fXZhciByPWUoIi4uL3JhbmdlIikuUmFuZ2UsaT1lKCIuL2ZvbGRfbGluZSIpLkZvbGRMaW5lLHM9ZSgiLi9mb2xkIikuRm9sZCxvPWUoIi4uL3Rva2VuX2l0ZXJhdG9yIikuVG9rZW5JdGVyYXRvcjt0LkZvbGRpbmc9dX0pLGRlZmluZSgiYWNlL2VkaXRfc2Vzc2lvbi9icmFja2V0X21hdGNoIixbInJlcXVpcmUiLCJleHBvcnRzIiwibW9kdWxlIiwiYWNlL3Rva2VuX2l0ZXJhdG9yIiwiYWNlL3JhbmdlIl0sZnVuY3Rpb24oZSx0LG4peyJ1c2Ugc3RyaWN0IjtmdW5jdGlvbiBzKCl7dGhpcy5maW5kTWF0Y2hpbmdCcmFja2V0PWZ1bmN0aW9uKGUsdCl7aWYoZS5jb2x1bW49PTApcmV0dXJuIG51bGw7dmFyIG49dHx8dGhpcy5nZXRMaW5lKGUucm93KS5jaGFyQXQoZS5jb2x1bW4tMSk7aWYobj09IiIpcmV0dXJuIG51bGw7dmFyIHI9bi5tYXRjaCgvKFtcKFxbXHtdKXwoW1wpXF1cfV0pLyk7cmV0dXJuIHI/clsxXT90aGlzLiRmaW5kQ2xvc2luZ0JyYWNrZXQoclsxXSxlKTp0aGlzLiRmaW5kT3BlbmluZ0JyYWNrZXQoclsyXSxlKTpudWxsfSx0aGlzLmdldEJyYWNrZXRSYW5nZT1mdW5jdGlvbihlKXt2YXIgdD10aGlzLmdldExpbmUoZS5yb3cpLG49ITAscixzPXQuY2hhckF0KGUuY29sdW1uLTEpLG89cyYmcy5tYXRjaCgvKFtcKFxbXHtdKXwoW1wpXF1cfV0pLyk7b3x8KHM9dC5jaGFyQXQoZS5jb2x1bW4pLGU9e3JvdzplLnJvdyxjb2x1bW46ZS5jb2x1bW4rMX0sbz1zJiZzLm1hdGNoKC8oW1woXFtce10pfChbXClcXVx9XSkvKSxuPSExKTtpZighbylyZXR1cm4gbnVsbDtpZihvWzFdKXt2YXIgdT10aGlzLiRmaW5kQ2xvc2luZ0JyYWNrZXQob1sxXSxlKTtpZighdSlyZXR1cm4gbnVsbDtyPWkuZnJvbVBvaW50cyhlLHUpLG58fChyLmVuZC5jb2x1bW4rKyxyLnN0YXJ0LmNvbHVtbi0tKSxyLmN1cnNvcj1yLmVuZH1lbHNle3ZhciB1PXRoaXMuJGZpbmRPcGVuaW5nQnJhY2tldChvWzJdLGUpO2lmKCF1KXJldHVybiBudWxsO3I9aS5mcm9tUG9pbnRzKHUsZSksbnx8KHIuc3RhcnQuY29sdW1uKyssci5lbmQuY29sdW1uLS0pLHIuY3Vyc29yPXIuc3RhcnR9cmV0dXJuIHJ9LHRoaXMuZ2V0TWF0Y2hpbmdCcmFja2V0UmFuZ2VzPWZ1bmN0aW9uKGUsdCl7dmFyIG49dGhpcy5nZXRMaW5lKGUucm93KSxyPS8oW1woXFtce10pfChbXClcXVx9XSkvLHM9IXQmJm4uY2hhckF0KGUuY29sdW1uLTEpLG89cyYmcy5tYXRjaChyKTtvfHwocz0odD09PXVuZGVmaW5lZHx8dCkmJm4uY2hhckF0KGUuY29sdW1uKSxlPXtyb3c6ZS5yb3csY29sdW1uOmUuY29sdW1uKzF9LG89cyYmcy5tYXRjaChyKSk7aWYoIW8pcmV0dXJuIG51bGw7dmFyIHU9bmV3IGkoZS5yb3csZS5jb2x1bW4tMSxlLnJvdyxlLmNvbHVtbiksYT1vWzFdP3RoaXMuJGZpbmRDbG9zaW5nQnJhY2tldChvWzFdLGUpOnRoaXMuJGZpbmRPcGVuaW5nQnJhY2tldChvWzJdLGUpO2lmKCFhKXJldHVyblt1XTt2YXIgZj1uZXcgaShhLnJvdyxhLmNvbHVtbixhLnJvdyxhLmNvbHVtbisxKTtyZXR1cm5bdSxmXX0sdGhpcy4kYnJhY2tldHM9eyIpIjoiKCIsIigiOiIpIiwiXSI6IlsiLCJbIjoiXSIsInsiOiJ9IiwifSI6InsiLCI8IjoiPiIsIj4iOiI8In0sdGhpcy4kZmluZE9wZW5pbmdCcmFja2V0PWZ1bmN0aW9uKGUsdCxuKXt2YXIgaT10aGlzLiRicmFja2V0c1tlXSxzPTEsbz1uZXcgcih0aGlzLHQucm93LHQuY29sdW1uKSx1PW8uZ2V0Q3VycmVudFRva2VuKCk7dXx8KHU9by5zdGVwRm9yd2FyZCgpKTtpZighdSlyZXR1cm47bnx8KG49bmV3IFJlZ0V4cCgiKFxcLj8iK3UudHlwZS5yZXBsYWNlKCIuIiwiXFwuIikucmVwbGFjZSgicnBhcmVuIiwiLnBhcmVuIikucmVwbGFjZSgvXGIoPzplbmQpXGIvLCIoPzpzdGFydHxiZWdpbnxlbmQpIikrIikrIikpO3ZhciBhPXQuY29sdW1uLW8uZ2V0Q3VycmVudFRva2VuQ29sdW1uKCktMixmPXUudmFsdWU7Zm9yKDs7KXt3aGlsZShhPj0wKXt2YXIgbD1mLmNoYXJBdChhKTtpZihsPT1pKXtzLT0xO2lmKHM9PTApcmV0dXJue3JvdzpvLmdldEN1cnJlbnRUb2tlblJvdygpLGNvbHVtbjphK28uZ2V0Q3VycmVudFRva2VuQ29sdW1uKCl9fWVsc2UgbD09ZSYmKHMrPTEpO2EtPTF9ZG8gdT1vLnN0ZXBCYWNrd2FyZCgpO3doaWxlKHUmJiFuLnRlc3QodS50eXBlKSk7aWYodT09bnVsbClicmVhaztmPXUudmFsdWUsYT1mLmxlbmd0aC0xfXJldHVybiBudWxsfSx0aGlzLiRmaW5kQ2xvc2luZ0JyYWNrZXQ9ZnVuY3Rpb24oZSx0LG4pe3ZhciBpPXRoaXMuJGJyYWNrZXRzW2VdLHM9MSxvPW5ldyByKHRoaXMsdC5yb3csdC5jb2x1bW4pLHU9by5nZXRDdXJyZW50VG9rZW4oKTt1fHwodT1vLnN0ZXBGb3J3YXJkKCkpO2lmKCF1KXJldHVybjtufHwobj1uZXcgUmVnRXhwKCIoXFwuPyIrdS50eXBlLnJlcGxhY2UoIi4iLCJcXC4iKS5yZXBsYWNlKCJscGFyZW4iLCIucGFyZW4iKS5yZXBsYWNlKC9cYig/OnN0YXJ0fGJlZ2luKVxiLywiKD86c3RhcnR8YmVnaW58ZW5kKSIpKyIpKyIpKTt2YXIgYT10LmNvbHVtbi1vLmdldEN1cnJlbnRUb2tlbkNvbHVtbigpO2Zvcig7Oyl7dmFyIGY9dS52YWx1ZSxsPWYubGVuZ3RoO3doaWxlKGE8bCl7dmFyIGM9Zi5jaGFyQXQoYSk7aWYoYz09aSl7cy09MTtpZihzPT0wKXJldHVybntyb3c6by5nZXRDdXJyZW50VG9rZW5Sb3coKSxjb2x1bW46YStvLmdldEN1cnJlbnRUb2tlbkNvbHVtbigpfX1lbHNlIGM9PWUmJihzKz0xKTthKz0xfWRvIHU9by5zdGVwRm9yd2FyZCgpO3doaWxlKHUmJiFuLnRlc3QodS50eXBlKSk7aWYodT09bnVsbClicmVhazthPTB9cmV0dXJuIG51bGx9LHRoaXMuZ2V0TWF0Y2hpbmdUYWdzPWZ1bmN0aW9uKGUpe3ZhciB0PW5ldyByKHRoaXMsZS5yb3csZS5jb2x1bW4pLG49dGhpcy4kZmluZFRhZ05hbWUodCk7aWYoIW4pcmV0dXJuO3ZhciBpPXQuc3RlcEJhY2t3YXJkKCk7cmV0dXJuIGkudmFsdWU9PT0iPCI/dGhpcy4kZmluZENsb3NpbmdUYWcodCxuKTp0aGlzLiRmaW5kT3BlbmluZ1RhZyh0LG4pfSx0aGlzLiRmaW5kVGFnTmFtZT1mdW5jdGlvbihlKXt2YXIgdD1lLmdldEN1cnJlbnRUb2tlbigpLG49ITEscj0hMTtpZih0JiZ0LnR5cGUuaW5kZXhPZigidGFnLW5hbWUiKT09PS0xKWRvIHI/dD1lLnN0ZXBCYWNrd2FyZCgpOnQ9ZS5zdGVwRm9yd2FyZCgpLHQmJih0LnZhbHVlPT09Ii8+Ij9yPSEwOnQudHlwZS5pbmRleE9mKCJ0YWctbmFtZSIpIT09LTEmJihuPSEwKSk7d2hpbGUodCYmIW4pO3JldHVybiB0fSx0aGlzLiRmaW5kQ2xvc2luZ1RhZz1mdW5jdGlvbihlLHQpe3ZhciBuLHI9dC52YWx1ZSxzPXQudmFsdWUsbz0wLHU9bmV3IGkoZS5nZXRDdXJyZW50VG9rZW5Sb3coKSxlLmdldEN1cnJlbnRUb2tlbkNvbHVtbigpLGUuZ2V0Q3VycmVudFRva2VuUm93KCksZS5nZXRDdXJyZW50VG9rZW5Db2x1bW4oKSsxKTt0PWUuc3RlcEZvcndhcmQoKTt2YXIgYT1uZXcgaShlLmdldEN1cnJlbnRUb2tlblJvdygpLGUuZ2V0Q3VycmVudFRva2VuQ29sdW1uKCksZS5nZXRDdXJyZW50VG9rZW5Sb3coKSxlLmdldEN1cnJlbnRUb2tlbkNvbHVtbigpK3QudmFsdWUubGVuZ3RoKSxmPSExO2Rve249dCx0PWUuc3RlcEZvcndhcmQoKTtpZih0KXtpZih0LnZhbHVlPT09Ij4iJiYhZil7dmFyIGw9bmV3IGkoZS5nZXRDdXJyZW50VG9rZW5Sb3coKSxlLmdldEN1cnJlbnRUb2tlbkNvbHVtbigpLGUuZ2V0Q3VycmVudFRva2VuUm93KCksZS5nZXRDdXJyZW50VG9rZW5Db2x1bW4oKSsxKTtmPSEwfWlmKHQudHlwZS5pbmRleE9mKCJ0YWctbmFtZSIpIT09LTEpe3I9dC52YWx1ZTtpZihzPT09cilpZihuLnZhbHVlPT09IjwiKW8rKztlbHNlIGlmKG4udmFsdWU9PT0iPC8iKXtvLS07aWYobzwwKXtlLnN0ZXBCYWNrd2FyZCgpO3ZhciBjPW5ldyBpKGUuZ2V0Q3VycmVudFRva2VuUm93KCksZS5nZXRDdXJyZW50VG9rZW5Db2x1bW4oKSxlLmdldEN1cnJlbnRUb2tlblJvdygpLGUuZ2V0Q3VycmVudFRva2VuQ29sdW1uKCkrMik7dD1lLnN0ZXBGb3J3YXJkKCk7dmFyIGg9bmV3IGkoZS5nZXRDdXJyZW50VG9rZW5Sb3coKSxlLmdldEN1cnJlbnRUb2tlbkNvbHVtbigpLGUuZ2V0Q3VycmVudFRva2VuUm93KCksZS5nZXRDdXJyZW50VG9rZW5Db2x1bW4oKSt0LnZhbHVlLmxlbmd0aCk7dD1lLnN0ZXBGb3J3YXJkKCk7aWYoIXR8fHQudmFsdWUhPT0iPiIpcmV0dXJuO3ZhciBwPW5ldyBpKGUuZ2V0Q3VycmVudFRva2VuUm93KCksZS5nZXRDdXJyZW50VG9rZW5Db2x1bW4oKSxlLmdldEN1cnJlbnRUb2tlblJvdygpLGUuZ2V0Q3VycmVudFRva2VuQ29sdW1uKCkrMSl9fX1lbHNlIGlmKHM9PT1yJiZ0LnZhbHVlPT09Ii8+Iil7by0tO2lmKG88MCl2YXIgYz1uZXcgaShlLmdldEN1cnJlbnRUb2tlblJvdygpLGUuZ2V0Q3VycmVudFRva2VuQ29sdW1uKCksZS5nZXRDdXJyZW50VG9rZW5Sb3coKSxlLmdldEN1cnJlbnRUb2tlbkNvbHVtbigpKzIpLGg9YyxwPWgsbD1uZXcgaShhLmVuZC5yb3csYS5lbmQuY29sdW1uLGEuZW5kLnJvdyxhLmVuZC5jb2x1bW4rMSl9fX13aGlsZSh0JiZvPj0wKTtpZih1JiZsJiZjJiZwJiZhJiZoKXJldHVybntvcGVuVGFnOm5ldyBpKHUuc3RhcnQucm93LHUuc3RhcnQuY29sdW1uLGwuZW5kLnJvdyxsLmVuZC5jb2x1bW4pLGNsb3NlVGFnOm5ldyBpKGMuc3RhcnQucm93LGMuc3RhcnQuY29sdW1uLHAuZW5kLnJvdyxwLmVuZC5jb2x1bW4pLG9wZW5UYWdOYW1lOmEsY2xvc2VUYWdOYW1lOmh9fSx0aGlzLiRmaW5kT3BlbmluZ1RhZz1mdW5jdGlvbihlLHQpe3ZhciBuPWUuZ2V0Q3VycmVudFRva2VuKCkscj10LnZhbHVlLHM9MCxvPWUuZ2V0Q3VycmVudFRva2VuUm93KCksdT1lLmdldEN1cnJlbnRUb2tlbkNvbHVtbigpLGE9dSsyLGY9bmV3IGkobyx1LG8sYSk7ZS5zdGVwRm9yd2FyZCgpO3ZhciBsPW5ldyBpKGUuZ2V0Q3VycmVudFRva2VuUm93KCksZS5nZXRDdXJyZW50VG9rZW5Db2x1bW4oKSxlLmdldEN1cnJlbnRUb2tlblJvdygpLGUuZ2V0Q3VycmVudFRva2VuQ29sdW1uKCkrdC52YWx1ZS5sZW5ndGgpO3Q9ZS5zdGVwRm9yd2FyZCgpO2lmKCF0fHx0LnZhbHVlIT09Ij4iKXJldHVybjt2YXIgYz1uZXcgaShlLmdldEN1cnJlbnRUb2tlblJvdygpLGUuZ2V0Q3VycmVudFRva2VuQ29sdW1uKCksZS5nZXRDdXJyZW50VG9rZW5Sb3coKSxlLmdldEN1cnJlbnRUb2tlbkNvbHVtbigpKzEpO2Uuc3RlcEJhY2t3YXJkKCksZS5zdGVwQmFja3dhcmQoKTtkb3t0PW4sbz1lLmdldEN1cnJlbnRUb2tlblJvdygpLHU9ZS5nZXRDdXJyZW50VG9rZW5Db2x1bW4oKSxhPXUrdC52YWx1ZS5sZW5ndGgsbj1lLnN0ZXBCYWNrd2FyZCgpO2lmKHQpaWYodC50eXBlLmluZGV4T2YoInRhZy1uYW1lIikhPT0tMSl7aWYocj09PXQudmFsdWUpaWYobi52YWx1ZT09PSI8Iil7cysrO2lmKHM+MCl7dmFyIGg9bmV3IGkobyx1LG8sYSkscD1uZXcgaShlLmdldEN1cnJlbnRUb2tlblJvdygpLGUuZ2V0Q3VycmVudFRva2VuQ29sdW1uKCksZS5nZXRDdXJyZW50VG9rZW5Sb3coKSxlLmdldEN1cnJlbnRUb2tlbkNvbHVtbigpKzEpO2RvIHQ9ZS5zdGVwRm9yd2FyZCgpO3doaWxlKHQmJnQudmFsdWUhPT0iPiIpO3ZhciBkPW5ldyBpKGUuZ2V0Q3VycmVudFRva2VuUm93KCksZS5nZXRDdXJyZW50VG9rZW5Db2x1bW4oKSxlLmdldEN1cnJlbnRUb2tlblJvdygpLGUuZ2V0Q3VycmVudFRva2VuQ29sdW1uKCkrMSl9fWVsc2Ugbi52YWx1ZT09PSI8LyImJnMtLX1lbHNlIGlmKHQudmFsdWU9PT0iLz4iKXt2YXIgdj0wLG09bjt3aGlsZShtKXtpZihtLnR5cGUuaW5kZXhPZigidGFnLW5hbWUiKSE9PS0xJiZtLnZhbHVlPT09cil7cy0tO2JyZWFrfWlmKG0udmFsdWU9PT0iPCIpYnJlYWs7bT1lLnN0ZXBCYWNrd2FyZCgpLHYrK31mb3IodmFyIGc9MDtnPHY7ZysrKWUuc3RlcEZvcndhcmQoKX19d2hpbGUobiYmczw9MCk7aWYocCYmZCYmZiYmYyYmaCYmbClyZXR1cm57b3BlblRhZzpuZXcgaShwLnN0YXJ0LnJvdyxwLnN0YXJ0LmNvbHVtbixkLmVuZC5yb3csZC5lbmQuY29sdW1uKSxjbG9zZVRhZzpuZXcgaShmLnN0YXJ0LnJvdyxmLnN0YXJ0LmNvbHVtbixjLmVuZC5yb3csYy5lbmQuY29sdW1uKSxvcGVuVGFnTmFtZTpoLGNsb3NlVGFnTmFtZTpsfX19dmFyIHI9ZSgiLi4vdG9rZW5faXRlcmF0b3IiKS5Ub2tlbkl0ZXJhdG9yLGk9ZSgiLi4vcmFuZ2UiKS5SYW5nZTt0LkJyYWNrZXRNYXRjaD1zfSksZGVmaW5lKCJhY2UvZWRpdF9zZXNzaW9uIixbInJlcXVpcmUiLCJleHBvcnRzIiwibW9kdWxlIiwiYWNlL2xpYi9vb3AiLCJhY2UvbGliL2xhbmciLCJhY2UvYmlkaWhhbmRsZXIiLCJhY2UvY29uZmlnIiwiYWNlL2xpYi9ldmVudF9lbWl0dGVyIiwiYWNlL3NlbGVjdGlvbiIsImFjZS9tb2RlL3RleHQiLCJhY2UvcmFuZ2UiLCJhY2UvZG9jdW1lbnQiLCJhY2UvYmFja2dyb3VuZF90b2tlbml6ZXIiLCJhY2Uvc2VhcmNoX2hpZ2hsaWdodCIsImFjZS9lZGl0X3Nlc3Npb24vZm9sZGluZyIsImFjZS9lZGl0X3Nlc3Npb24vYnJhY2tldF9tYXRjaCJdLGZ1bmN0aW9uKGUsdCxuKXsidXNlIHN0cmljdCI7dmFyIHI9ZSgiLi9saWIvb29wIiksaT1lKCIuL2xpYi9sYW5nIikscz1lKCIuL2JpZGloYW5kbGVyIikuQmlkaUhhbmRsZXIsbz1lKCIuL2NvbmZpZyIpLHU9ZSgiLi9saWIvZXZlbnRfZW1pdHRlciIpLkV2ZW50RW1pdHRlcixhPWUoIi4vc2VsZWN0aW9uIikuU2VsZWN0aW9uLGY9ZSgiLi9tb2RlL3RleHQiKS5Nb2RlLGw9ZSgiLi9yYW5nZSIpLlJhbmdlLGM9ZSgiLi9kb2N1bWVudCIpLkRvY3VtZW50LGg9ZSgiLi9iYWNrZ3JvdW5kX3Rva2VuaXplciIpLkJhY2tncm91bmRUb2tlbml6ZXIscD1lKCIuL3NlYXJjaF9oaWdobGlnaHQiKS5TZWFyY2hIaWdobGlnaHQsZD1mdW5jdGlvbihlLHQpe3RoaXMuJGJyZWFrcG9pbnRzPVtdLHRoaXMuJGRlY29yYXRpb25zPVtdLHRoaXMuJGZyb250TWFya2Vycz17fSx0aGlzLiRiYWNrTWFya2Vycz17fSx0aGlzLiRtYXJrZXJJZD0xLHRoaXMuJHVuZG9TZWxlY3Q9ITAsdGhpcy4kZm9sZERhdGE9W10sdGhpcy5pZD0ic2Vzc2lvbiIrICsrZC4kdWlkLHRoaXMuJGZvbGREYXRhLnRvU3RyaW5nPWZ1bmN0aW9uKCl7cmV0dXJuIHRoaXMuam9pbigiXG4iKX0sdGhpcy5iZ1Rva2VuaXplcj1uZXcgaCgobmV3IGYpLmdldFRva2VuaXplcigpLHRoaXMpO3ZhciBuPXRoaXM7dGhpcy5iZ1Rva2VuaXplci5vbigidXBkYXRlIixmdW5jdGlvbihlKXtuLl9zaWduYWwoInRva2VuaXplclVwZGF0ZSIsZSl9KSx0aGlzLm9uKCJjaGFuZ2VGb2xkIix0aGlzLm9uQ2hhbmdlRm9sZC5iaW5kKHRoaXMpKSx0aGlzLiRvbkNoYW5nZT10aGlzLm9uQ2hhbmdlLmJpbmQodGhpcyk7aWYodHlwZW9mIGUhPSJvYmplY3QifHwhZS5nZXRMaW5lKWU9bmV3IGMoZSk7dGhpcy5zZXREb2N1bWVudChlKSx0aGlzLnNlbGVjdGlvbj1uZXcgYSh0aGlzKSx0aGlzLiRiaWRpSGFuZGxlcj1uZXcgcyh0aGlzKSxvLnJlc2V0T3B0aW9ucyh0aGlzKSx0aGlzLnNldE1vZGUodCksby5fc2lnbmFsKCJzZXNzaW9uIix0aGlzKSx0aGlzLmRlc3Ryb3llZD0hMX07ZC4kdWlkPTAsZnVuY3Rpb24oKXtmdW5jdGlvbiB2KGUpe3JldHVybiBlPDQzNTI/ITE6ZT49NDM1MiYmZTw9NDQ0N3x8ZT49NDUxNSYmZTw9NDUxOXx8ZT49NDYwMiYmZTw9NDYwN3x8ZT49OTAwMSYmZTw9OTAwMnx8ZT49MTE5MDQmJmU8PTExOTI5fHxlPj0xMTkzMSYmZTw9MTIwMTl8fGU+PTEyMDMyJiZlPD0xMjI0NXx8ZT49MTIyNzImJmU8PTEyMjgzfHxlPj0xMjI4OCYmZTw9MTIzNTB8fGU+PTEyMzUzJiZlPD0xMjQzOHx8ZT49MTI0NDEmJmU8PTEyNTQzfHxlPj0xMjU0OSYmZTw9MTI1ODl8fGU+PTEyNTkzJiZlPD0xMjY4Nnx8ZT49MTI2ODgmJmU8PTEyNzMwfHxlPj0xMjczNiYmZTw9MTI3NzF8fGU+PTEyNzg0JiZlPD0xMjgzMHx8ZT49MTI4MzImJmU8PTEyODcxfHxlPj0xMjg4MCYmZTw9MTMwNTR8fGU+PTEzMDU2JiZlPD0xOTkwM3x8ZT49MTk5NjgmJmU8PTQyMTI0fHxlPj00MjEyOCYmZTw9NDIxODJ8fGU+PTQzMzYwJiZlPD00MzM4OHx8ZT49NDQwMzImJmU8PTU1MjAzfHxlPj01NTIxNiYmZTw9NTUyMzh8fGU+PTU1MjQzJiZlPD01NTI5MXx8ZT49NjM3NDQmJmU8PTY0MjU1fHxlPj02NTA0MCYmZTw9NjUwNDl8fGU+PTY1MDcyJiZlPD02NTEwNnx8ZT49NjUxMDgmJmU8PTY1MTI2fHxlPj02NTEyOCYmZTw9NjUxMzF8fGU+PTY1MjgxJiZlPD02NTM3Nnx8ZT49NjU1MDQmJmU8PTY1NTEwfXIuaW1wbGVtZW50KHRoaXMsdSksdGhpcy5zZXREb2N1bWVudD1mdW5jdGlvbihlKXt0aGlzLmRvYyYmdGhpcy5kb2Mub2ZmKCJjaGFuZ2UiLHRoaXMuJG9uQ2hhbmdlKSx0aGlzLmRvYz1lLGUub24oImNoYW5nZSIsdGhpcy4kb25DaGFuZ2UsITApLHRoaXMuYmdUb2tlbml6ZXIuc2V0RG9jdW1lbnQodGhpcy5nZXREb2N1bWVudCgpKSx0aGlzLnJlc2V0Q2FjaGVzKCl9LHRoaXMuZ2V0RG9jdW1lbnQ9ZnVuY3Rpb24oKXtyZXR1cm4gdGhpcy5kb2N9LHRoaXMuJHJlc2V0Um93Q2FjaGU9ZnVuY3Rpb24oZSl7aWYoIWUpe3RoaXMuJGRvY1Jvd0NhY2hlPVtdLHRoaXMuJHNjcmVlblJvd0NhY2hlPVtdO3JldHVybn12YXIgdD10aGlzLiRkb2NSb3dDYWNoZS5sZW5ndGgsbj10aGlzLiRnZXRSb3dDYWNoZUluZGV4KHRoaXMuJGRvY1Jvd0NhY2hlLGUpKzE7dD5uJiYodGhpcy4kZG9jUm93Q2FjaGUuc3BsaWNlKG4sdCksdGhpcy4kc2NyZWVuUm93Q2FjaGUuc3BsaWNlKG4sdCkpfSx0aGlzLiRnZXRSb3dDYWNoZUluZGV4PWZ1bmN0aW9uKGUsdCl7dmFyIG49MCxyPWUubGVuZ3RoLTE7d2hpbGUobjw9cil7dmFyIGk9bityPj4xLHM9ZVtpXTtpZih0PnMpbj1pKzE7ZWxzZXtpZighKHQ8cykpcmV0dXJuIGk7cj1pLTF9fXJldHVybiBuLTF9LHRoaXMucmVzZXRDYWNoZXM9ZnVuY3Rpb24oKXt0aGlzLiRtb2RpZmllZD0hMCx0aGlzLiR3cmFwRGF0YT1bXSx0aGlzLiRyb3dMZW5ndGhDYWNoZT1bXSx0aGlzLiRyZXNldFJvd0NhY2hlKDApLHRoaXMuZGVzdHJveWVkfHx0aGlzLmJnVG9rZW5pemVyLnN0YXJ0KDApfSx0aGlzLm9uQ2hhbmdlRm9sZD1mdW5jdGlvbihlKXt2YXIgdD1lLmRhdGE7dGhpcy4kcmVzZXRSb3dDYWNoZSh0LnN0YXJ0LnJvdyl9LHRoaXMub25DaGFuZ2U9ZnVuY3Rpb24oZSl7dGhpcy4kbW9kaWZpZWQ9ITAsdGhpcy4kYmlkaUhhbmRsZXIub25DaGFuZ2UoZSksdGhpcy4kcmVzZXRSb3dDYWNoZShlLnN0YXJ0LnJvdyk7dmFyIHQ9dGhpcy4kdXBkYXRlSW50ZXJuYWxEYXRhT25DaGFuZ2UoZSk7IXRoaXMuJGZyb21VbmRvJiZ0aGlzLiR1bmRvTWFuYWdlciYmKHQmJnQubGVuZ3RoJiYodGhpcy4kdW5kb01hbmFnZXIuYWRkKHthY3Rpb246InJlbW92ZUZvbGRzIixmb2xkczp0fSx0aGlzLm1lcmdlVW5kb0RlbHRhcyksdGhpcy5tZXJnZVVuZG9EZWx0YXM9ITApLHRoaXMuJHVuZG9NYW5hZ2VyLmFkZChlLHRoaXMubWVyZ2VVbmRvRGVsdGFzKSx0aGlzLm1lcmdlVW5kb0RlbHRhcz0hMCx0aGlzLiRpbmZvcm1VbmRvTWFuYWdlci5zY2hlZHVsZSgpKSx0aGlzLmJnVG9rZW5pemVyLiR1cGRhdGVPbkNoYW5nZShlKSx0aGlzLl9zaWduYWwoImNoYW5nZSIsZSl9LHRoaXMuc2V0VmFsdWU9ZnVuY3Rpb24oZSl7dGhpcy5kb2Muc2V0VmFsdWUoZSksdGhpcy5zZWxlY3Rpb24ubW92ZVRvKDAsMCksdGhpcy4kcmVzZXRSb3dDYWNoZSgwKSx0aGlzLnNldFVuZG9NYW5hZ2VyKHRoaXMuJHVuZG9NYW5hZ2VyKSx0aGlzLmdldFVuZG9NYW5hZ2VyKCkucmVzZXQoKX0sdGhpcy5nZXRWYWx1ZT10aGlzLnRvU3RyaW5nPWZ1bmN0aW9uKCl7cmV0dXJuIHRoaXMuZG9jLmdldFZhbHVlKCl9LHRoaXMuZ2V0U2VsZWN0aW9uPWZ1bmN0aW9uKCl7cmV0dXJuIHRoaXMuc2VsZWN0aW9ufSx0aGlzLmdldFN0YXRlPWZ1bmN0aW9uKGUpe3JldHVybiB0aGlzLmJnVG9rZW5pemVyLmdldFN0YXRlKGUpfSx0aGlzLmdldFRva2Vucz1mdW5jdGlvbihlKXtyZXR1cm4gdGhpcy5iZ1Rva2VuaXplci5nZXRUb2tlbnMoZSl9LHRoaXMuZ2V0VG9rZW5BdD1mdW5jdGlvbihlLHQpe3ZhciBuPXRoaXMuYmdUb2tlbml6ZXIuZ2V0VG9rZW5zKGUpLHIsaT0wO2lmKHQ9PW51bGwpe3ZhciBzPW4ubGVuZ3RoLTE7aT10aGlzLmdldExpbmUoZSkubGVuZ3RofWVsc2UgZm9yKHZhciBzPTA7czxuLmxlbmd0aDtzKyspe2krPW5bc10udmFsdWUubGVuZ3RoO2lmKGk+PXQpYnJlYWt9cmV0dXJuIHI9bltzXSxyPyhyLmluZGV4PXMsci5zdGFydD1pLXIudmFsdWUubGVuZ3RoLHIpOm51bGx9LHRoaXMuc2V0VW5kb01hbmFnZXI9ZnVuY3Rpb24oZSl7dGhpcy4kdW5kb01hbmFnZXI9ZSx0aGlzLiRpbmZvcm1VbmRvTWFuYWdlciYmdGhpcy4kaW5mb3JtVW5kb01hbmFnZXIuY2FuY2VsKCk7aWYoZSl7dmFyIHQ9dGhpcztlLmFkZFNlc3Npb24odGhpcyksdGhpcy4kc3luY0luZm9ybVVuZG9NYW5hZ2VyPWZ1bmN0aW9uKCl7dC4kaW5mb3JtVW5kb01hbmFnZXIuY2FuY2VsKCksdC5tZXJnZVVuZG9EZWx0YXM9ITF9LHRoaXMuJGluZm9ybVVuZG9NYW5hZ2VyPWkuZGVsYXllZENhbGwodGhpcy4kc3luY0luZm9ybVVuZG9NYW5hZ2VyKX1lbHNlIHRoaXMuJHN5bmNJbmZvcm1VbmRvTWFuYWdlcj1mdW5jdGlvbigpe319LHRoaXMubWFya1VuZG9Hcm91cD1mdW5jdGlvbigpe3RoaXMuJHN5bmNJbmZvcm1VbmRvTWFuYWdlciYmdGhpcy4kc3luY0luZm9ybVVuZG9NYW5hZ2VyKCl9LHRoaXMuJGRlZmF1bHRVbmRvTWFuYWdlcj17dW5kbzpmdW5jdGlvbigpe30scmVkbzpmdW5jdGlvbigpe30saGFzVW5kbzpmdW5jdGlvbigpe30saGFzUmVkbzpmdW5jdGlvbigpe30scmVzZXQ6ZnVuY3Rpb24oKXt9LGFkZDpmdW5jdGlvbigpe30sYWRkU2VsZWN0aW9uOmZ1bmN0aW9uKCl7fSxzdGFydE5ld0dyb3VwOmZ1bmN0aW9uKCl7fSxhZGRTZXNzaW9uOmZ1bmN0aW9uKCl7fX0sdGhpcy5nZXRVbmRvTWFuYWdlcj1mdW5jdGlvbigpe3JldHVybiB0aGlzLiR1bmRvTWFuYWdlcnx8dGhpcy4kZGVmYXVsdFVuZG9NYW5hZ2VyfSx0aGlzLmdldFRhYlN0cmluZz1mdW5jdGlvbigpe3JldHVybiB0aGlzLmdldFVzZVNvZnRUYWJzKCk/aS5zdHJpbmdSZXBlYXQoIiAiLHRoaXMuZ2V0VGFiU2l6ZSgpKToiCSJ9LHRoaXMuc2V0VXNlU29mdFRhYnM9ZnVuY3Rpb24oZSl7dGhpcy5zZXRPcHRpb24oInVzZVNvZnRUYWJzIixlKX0sdGhpcy5nZXRVc2VTb2Z0VGFicz1mdW5jdGlvbigpe3JldHVybiB0aGlzLiR1c2VTb2Z0VGFicyYmIXRoaXMuJG1vZGUuJGluZGVudFdpdGhUYWJzfSx0aGlzLnNldFRhYlNpemU9ZnVuY3Rpb24oZSl7dGhpcy5zZXRPcHRpb24oInRhYlNpemUiLGUpfSx0aGlzLmdldFRhYlNpemU9ZnVuY3Rpb24oKXtyZXR1cm4gdGhpcy4kdGFiU2l6ZX0sdGhpcy5pc1RhYlN0b3A9ZnVuY3Rpb24oZSl7cmV0dXJuIHRoaXMuJHVzZVNvZnRUYWJzJiZlLmNvbHVtbiV0aGlzLiR0YWJTaXplPT09MH0sdGhpcy5zZXROYXZpZ2F0ZVdpdGhpblNvZnRUYWJzPWZ1bmN0aW9uKGUpe3RoaXMuc2V0T3B0aW9uKCJuYXZpZ2F0ZVdpdGhpblNvZnRUYWJzIixlKX0sdGhpcy5nZXROYXZpZ2F0ZVdpdGhpblNvZnRUYWJzPWZ1bmN0aW9uKCl7cmV0dXJuIHRoaXMuJG5hdmlnYXRlV2l0aGluU29mdFRhYnN9LHRoaXMuJG92ZXJ3cml0ZT0hMSx0aGlzLnNldE92ZXJ3cml0ZT1mdW5jdGlvbihlKXt0aGlzLnNldE9wdGlvbigib3ZlcndyaXRlIixlKX0sdGhpcy5nZXRPdmVyd3JpdGU9ZnVuY3Rpb24oKXtyZXR1cm4gdGhpcy4kb3ZlcndyaXRlfSx0aGlzLnRvZ2dsZU92ZXJ3cml0ZT1mdW5jdGlvbigpe3RoaXMuc2V0T3ZlcndyaXRlKCF0aGlzLiRvdmVyd3JpdGUpfSx0aGlzLmFkZEd1dHRlckRlY29yYXRpb249ZnVuY3Rpb24oZSx0KXt0aGlzLiRkZWNvcmF0aW9uc1tlXXx8KHRoaXMuJGRlY29yYXRpb25zW2VdPSIiKSx0aGlzLiRkZWNvcmF0aW9uc1tlXSs9IiAiK3QsdGhpcy5fc2lnbmFsKCJjaGFuZ2VCcmVha3BvaW50Iix7fSl9LHRoaXMucmVtb3ZlR3V0dGVyRGVjb3JhdGlvbj1mdW5jdGlvbihlLHQpe3RoaXMuJGRlY29yYXRpb25zW2VdPSh0aGlzLiRkZWNvcmF0aW9uc1tlXXx8IiIpLnJlcGxhY2UoIiAiK3QsIiIpLHRoaXMuX3NpZ25hbCgiY2hhbmdlQnJlYWtwb2ludCIse30pfSx0aGlzLmdldEJyZWFrcG9pbnRzPWZ1bmN0aW9uKCl7cmV0dXJuIHRoaXMuJGJyZWFrcG9pbnRzfSx0aGlzLnNldEJyZWFrcG9pbnRzPWZ1bmN0aW9uKGUpe3RoaXMuJGJyZWFrcG9pbnRzPVtdO2Zvcih2YXIgdD0wO3Q8ZS5sZW5ndGg7dCsrKXRoaXMuJGJyZWFrcG9pbnRzW2VbdF1dPSJhY2VfYnJlYWtwb2ludCI7dGhpcy5fc2lnbmFsKCJjaGFuZ2VCcmVha3BvaW50Iix7fSl9LHRoaXMuY2xlYXJCcmVha3BvaW50cz1mdW5jdGlvbigpe3RoaXMuJGJyZWFrcG9pbnRzPVtdLHRoaXMuX3NpZ25hbCgiY2hhbmdlQnJlYWtwb2ludCIse30pfSx0aGlzLnNldEJyZWFrcG9pbnQ9ZnVuY3Rpb24oZSx0KXt0PT09dW5kZWZpbmVkJiYodD0iYWNlX2JyZWFrcG9pbnQiKSx0P3RoaXMuJGJyZWFrcG9pbnRzW2VdPXQ6ZGVsZXRlIHRoaXMuJGJyZWFrcG9pbnRzW2VdLHRoaXMuX3NpZ25hbCgiY2hhbmdlQnJlYWtwb2ludCIse30pfSx0aGlzLmNsZWFyQnJlYWtwb2ludD1mdW5jdGlvbihlKXtkZWxldGUgdGhpcy4kYnJlYWtwb2ludHNbZV0sdGhpcy5fc2lnbmFsKCJjaGFuZ2VCcmVha3BvaW50Iix7fSl9LHRoaXMuYWRkTWFya2VyPWZ1bmN0aW9uKGUsdCxuLHIpe3ZhciBpPXRoaXMuJG1hcmtlcklkKysscz17cmFuZ2U6ZSx0eXBlOm58fCJsaW5lIixyZW5kZXJlcjp0eXBlb2Ygbj09ImZ1bmN0aW9uIj9uOm51bGwsY2xheno6dCxpbkZyb250OiEhcixpZDppfTtyZXR1cm4gcj8odGhpcy4kZnJvbnRNYXJrZXJzW2ldPXMsdGhpcy5fc2lnbmFsKCJjaGFuZ2VGcm9udE1hcmtlciIpKToodGhpcy4kYmFja01hcmtlcnNbaV09cyx0aGlzLl9zaWduYWwoImNoYW5nZUJhY2tNYXJrZXIiKSksaX0sdGhpcy5hZGREeW5hbWljTWFya2VyPWZ1bmN0aW9uKGUsdCl7aWYoIWUudXBkYXRlKXJldHVybjt2YXIgbj10aGlzLiRtYXJrZXJJZCsrO3JldHVybiBlLmlkPW4sZS5pbkZyb250PSEhdCx0Pyh0aGlzLiRmcm9udE1hcmtlcnNbbl09ZSx0aGlzLl9zaWduYWwoImNoYW5nZUZyb250TWFya2VyIikpOih0aGlzLiRiYWNrTWFya2Vyc1tuXT1lLHRoaXMuX3NpZ25hbCgiY2hhbmdlQmFja01hcmtlciIpKSxlfSx0aGlzLnJlbW92ZU1hcmtlcj1mdW5jdGlvbihlKXt2YXIgdD10aGlzLiRmcm9udE1hcmtlcnNbZV18fHRoaXMuJGJhY2tNYXJrZXJzW2VdO2lmKCF0KXJldHVybjt2YXIgbj10LmluRnJvbnQ/dGhpcy4kZnJvbnRNYXJrZXJzOnRoaXMuJGJhY2tNYXJrZXJzO2RlbGV0ZSBuW2VdLHRoaXMuX3NpZ25hbCh0LmluRnJvbnQ/ImNoYW5nZUZyb250TWFya2VyIjoiY2hhbmdlQmFja01hcmtlciIpfSx0aGlzLmdldE1hcmtlcnM9ZnVuY3Rpb24oZSl7cmV0dXJuIGU/dGhpcy4kZnJvbnRNYXJrZXJzOnRoaXMuJGJhY2tNYXJrZXJzfSx0aGlzLmhpZ2hsaWdodD1mdW5jdGlvbihlKXtpZighdGhpcy4kc2VhcmNoSGlnaGxpZ2h0KXt2YXIgdD1uZXcgcChudWxsLCJhY2Vfc2VsZWN0ZWQtd29yZCIsInRleHQiKTt0aGlzLiRzZWFyY2hIaWdobGlnaHQ9dGhpcy5hZGREeW5hbWljTWFya2VyKHQpfXRoaXMuJHNlYXJjaEhpZ2hsaWdodC5zZXRSZWdleHAoZSl9LHRoaXMuaGlnaGxpZ2h0TGluZXM9ZnVuY3Rpb24oZSx0LG4scil7dHlwZW9mIHQhPSJudW1iZXIiJiYobj10LHQ9ZSksbnx8KG49ImFjZV9zdGVwIik7dmFyIGk9bmV3IGwoZSwwLHQsSW5maW5pdHkpO3JldHVybiBpLmlkPXRoaXMuYWRkTWFya2VyKGksbiwiZnVsbExpbmUiLHIpLGl9LHRoaXMuc2V0QW5ub3RhdGlvbnM9ZnVuY3Rpb24oZSl7dGhpcy4kYW5ub3RhdGlvbnM9ZSx0aGlzLl9zaWduYWwoImNoYW5nZUFubm90YXRpb24iLHt9KX0sdGhpcy5nZXRBbm5vdGF0aW9ucz1mdW5jdGlvbigpe3JldHVybiB0aGlzLiRhbm5vdGF0aW9uc3x8W119LHRoaXMuY2xlYXJBbm5vdGF0aW9ucz1mdW5jdGlvbigpe3RoaXMuc2V0QW5ub3RhdGlvbnMoW10pfSx0aGlzLiRkZXRlY3ROZXdMaW5lPWZ1bmN0aW9uKGUpe3ZhciB0PWUubWF0Y2goL14uKj8oXHI/XG4pL20pO3Q/dGhpcy4kYXV0b05ld0xpbmU9dFsxXTp0aGlzLiRhdXRvTmV3TGluZT0iXG4ifSx0aGlzLmdldFdvcmRSYW5nZT1mdW5jdGlvbihlLHQpe3ZhciBuPXRoaXMuZ2V0TGluZShlKSxyPSExO3Q+MCYmKHI9ISFuLmNoYXJBdCh0LTEpLm1hdGNoKHRoaXMudG9rZW5SZSkpLHJ8fChyPSEhbi5jaGFyQXQodCkubWF0Y2godGhpcy50b2tlblJlKSk7aWYocil2YXIgaT10aGlzLnRva2VuUmU7ZWxzZSBpZigvXlxzKyQvLnRlc3Qobi5zbGljZSh0LTEsdCsxKSkpdmFyIGk9L1xzLztlbHNlIHZhciBpPXRoaXMubm9uVG9rZW5SZTt2YXIgcz10O2lmKHM+MCl7ZG8gcy0tO3doaWxlKHM+PTAmJm4uY2hhckF0KHMpLm1hdGNoKGkpKTtzKyt9dmFyIG89dDt3aGlsZShvPG4ubGVuZ3RoJiZuLmNoYXJBdChvKS5tYXRjaChpKSlvKys7cmV0dXJuIG5ldyBsKGUscyxlLG8pfSx0aGlzLmdldEFXb3JkUmFuZ2U9ZnVuY3Rpb24oZSx0KXt2YXIgbj10aGlzLmdldFdvcmRSYW5nZShlLHQpLHI9dGhpcy5nZXRMaW5lKG4uZW5kLnJvdyk7d2hpbGUoci5jaGFyQXQobi5lbmQuY29sdW1uKS5tYXRjaCgvWyBcdF0vKSluLmVuZC5jb2x1bW4rPTE7cmV0dXJuIG59LHRoaXMuc2V0TmV3TGluZU1vZGU9ZnVuY3Rpb24oZSl7dGhpcy5kb2Muc2V0TmV3TGluZU1vZGUoZSl9LHRoaXMuZ2V0TmV3TGluZU1vZGU9ZnVuY3Rpb24oKXtyZXR1cm4gdGhpcy5kb2MuZ2V0TmV3TGluZU1vZGUoKX0sdGhpcy5zZXRVc2VXb3JrZXI9ZnVuY3Rpb24oZSl7dGhpcy5zZXRPcHRpb24oInVzZVdvcmtlciIsZSl9LHRoaXMuZ2V0VXNlV29ya2VyPWZ1bmN0aW9uKCl7cmV0dXJuIHRoaXMuJHVzZVdvcmtlcn0sdGhpcy5vblJlbG9hZFRva2VuaXplcj1mdW5jdGlvbihlKXt2YXIgdD1lLmRhdGE7dGhpcy5iZ1Rva2VuaXplci5zdGFydCh0LmZpcnN0KSx0aGlzLl9zaWduYWwoInRva2VuaXplclVwZGF0ZSIsZSl9LHRoaXMuJG1vZGVzPW8uJG1vZGVzLHRoaXMuJG1vZGU9bnVsbCx0aGlzLiRtb2RlSWQ9bnVsbCx0aGlzLnNldE1vZGU9ZnVuY3Rpb24oZSx0KXtpZihlJiZ0eXBlb2YgZT09Im9iamVjdCIpe2lmKGUuZ2V0VG9rZW5pemVyKXJldHVybiB0aGlzLiRvbkNoYW5nZU1vZGUoZSk7dmFyIG49ZSxyPW4ucGF0aH1lbHNlIHI9ZXx8ImFjZS9tb2RlL3RleHQiO3RoaXMuJG1vZGVzWyJhY2UvbW9kZS90ZXh0Il18fCh0aGlzLiRtb2Rlc1siYWNlL21vZGUvdGV4dCJdPW5ldyBmKTtpZih0aGlzLiRtb2Rlc1tyXSYmIW4pe3RoaXMuJG9uQ2hhbmdlTW9kZSh0aGlzLiRtb2Rlc1tyXSksdCYmdCgpO3JldHVybn10aGlzLiRtb2RlSWQ9cixvLmxvYWRNb2R1bGUoWyJtb2RlIixyXSxmdW5jdGlvbihlKXtpZih0aGlzLiRtb2RlSWQhPT1yKXJldHVybiB0JiZ0KCk7dGhpcy4kbW9kZXNbcl0mJiFuP3RoaXMuJG9uQ2hhbmdlTW9kZSh0aGlzLiRtb2Rlc1tyXSk6ZSYmZS5Nb2RlJiYoZT1uZXcgZS5Nb2RlKG4pLG58fCh0aGlzLiRtb2Rlc1tyXT1lLGUuJGlkPXIpLHRoaXMuJG9uQ2hhbmdlTW9kZShlKSksdCYmdCgpfS5iaW5kKHRoaXMpKSx0aGlzLiRtb2RlfHx0aGlzLiRvbkNoYW5nZU1vZGUodGhpcy4kbW9kZXNbImFjZS9tb2RlL3RleHQiXSwhMCl9LHRoaXMuJG9uQ2hhbmdlTW9kZT1mdW5jdGlvbihlLHQpe3R8fCh0aGlzLiRtb2RlSWQ9ZS4kaWQpO2lmKHRoaXMuJG1vZGU9PT1lKXJldHVybjt2YXIgbj10aGlzLiRtb2RlO3RoaXMuJG1vZGU9ZSx0aGlzLiRzdG9wV29ya2VyKCksdGhpcy4kdXNlV29ya2VyJiZ0aGlzLiRzdGFydFdvcmtlcigpO3ZhciByPWUuZ2V0VG9rZW5pemVyKCk7aWYoci5vbiE9PXVuZGVmaW5lZCl7dmFyIGk9dGhpcy5vblJlbG9hZFRva2VuaXplci5iaW5kKHRoaXMpO3Iub24oInVwZGF0ZSIsaSl9dGhpcy5iZ1Rva2VuaXplci5zZXRUb2tlbml6ZXIociksdGhpcy5iZ1Rva2VuaXplci5zZXREb2N1bWVudCh0aGlzLmdldERvY3VtZW50KCkpLHRoaXMudG9rZW5SZT1lLnRva2VuUmUsdGhpcy5ub25Ub2tlblJlPWUubm9uVG9rZW5SZSx0fHwoZS5hdHRhY2hUb1Nlc3Npb24mJmUuYXR0YWNoVG9TZXNzaW9uKHRoaXMpLHRoaXMuJG9wdGlvbnMud3JhcE1ldGhvZC5zZXQuY2FsbCh0aGlzLHRoaXMuJHdyYXBNZXRob2QpLHRoaXMuJHNldEZvbGRpbmcoZS5mb2xkaW5nUnVsZXMpLHRoaXMuYmdUb2tlbml6ZXIuc3RhcnQoMCksdGhpcy5fZW1pdCgiY2hhbmdlTW9kZSIse29sZE1vZGU6bixtb2RlOmV9KSl9LHRoaXMuJHN0b3BXb3JrZXI9ZnVuY3Rpb24oKXt0aGlzLiR3b3JrZXImJih0aGlzLiR3b3JrZXIudGVybWluYXRlKCksdGhpcy4kd29ya2VyPW51bGwpfSx0aGlzLiRzdGFydFdvcmtlcj1mdW5jdGlvbigpe3RyeXt0aGlzLiR3b3JrZXI9dGhpcy4kbW9kZS5jcmVhdGVXb3JrZXIodGhpcyl9Y2F0Y2goZSl7by53YXJuKCJDb3VsZCBub3QgbG9hZCB3b3JrZXIiLGUpLHRoaXMuJHdvcmtlcj1udWxsfX0sdGhpcy5nZXRNb2RlPWZ1bmN0aW9uKCl7cmV0dXJuIHRoaXMuJG1vZGV9LHRoaXMuJHNjcm9sbFRvcD0wLHRoaXMuc2V0U2Nyb2xsVG9wPWZ1bmN0aW9uKGUpe2lmKHRoaXMuJHNjcm9sbFRvcD09PWV8fGlzTmFOKGUpKXJldHVybjt0aGlzLiRzY3JvbGxUb3A9ZSx0aGlzLl9zaWduYWwoImNoYW5nZVNjcm9sbFRvcCIsZSl9LHRoaXMuZ2V0U2Nyb2xsVG9wPWZ1bmN0aW9uKCl7cmV0dXJuIHRoaXMuJHNjcm9sbFRvcH0sdGhpcy4kc2Nyb2xsTGVmdD0wLHRoaXMuc2V0U2Nyb2xsTGVmdD1mdW5jdGlvbihlKXtpZih0aGlzLiRzY3JvbGxMZWZ0PT09ZXx8aXNOYU4oZSkpcmV0dXJuO3RoaXMuJHNjcm9sbExlZnQ9ZSx0aGlzLl9zaWduYWwoImNoYW5nZVNjcm9sbExlZnQiLGUpfSx0aGlzLmdldFNjcm9sbExlZnQ9ZnVuY3Rpb24oKXtyZXR1cm4gdGhpcy4kc2Nyb2xsTGVmdH0sdGhpcy5nZXRTY3JlZW5XaWR0aD1mdW5jdGlvbigpe3JldHVybiB0aGlzLiRjb21wdXRlV2lkdGgoKSx0aGlzLmxpbmVXaWRnZXRzP01hdGgubWF4KHRoaXMuZ2V0TGluZVdpZGdldE1heFdpZHRoKCksdGhpcy5zY3JlZW5XaWR0aCk6dGhpcy5zY3JlZW5XaWR0aH0sdGhpcy5nZXRMaW5lV2lkZ2V0TWF4V2lkdGg9ZnVuY3Rpb24oKXtpZih0aGlzLmxpbmVXaWRnZXRzV2lkdGghPW51bGwpcmV0dXJuIHRoaXMubGluZVdpZGdldHNXaWR0aDt2YXIgZT0wO3JldHVybiB0aGlzLmxpbmVXaWRnZXRzLmZvckVhY2goZnVuY3Rpb24odCl7dCYmdC5zY3JlZW5XaWR0aD5lJiYoZT10LnNjcmVlbldpZHRoKX0pLHRoaXMubGluZVdpZGdldFdpZHRoPWV9LHRoaXMuJGNvbXB1dGVXaWR0aD1mdW5jdGlvbihlKXtpZih0aGlzLiRtb2RpZmllZHx8ZSl7dGhpcy4kbW9kaWZpZWQ9ITE7aWYodGhpcy4kdXNlV3JhcE1vZGUpcmV0dXJuIHRoaXMuc2NyZWVuV2lkdGg9dGhpcy4kd3JhcExpbWl0O3ZhciB0PXRoaXMuZG9jLmdldEFsbExpbmVzKCksbj10aGlzLiRyb3dMZW5ndGhDYWNoZSxyPTAsaT0wLHM9dGhpcy4kZm9sZERhdGFbaV0sbz1zP3Muc3RhcnQucm93OkluZmluaXR5LHU9dC5sZW5ndGg7Zm9yKHZhciBhPTA7YTx1O2ErKyl7aWYoYT5vKXthPXMuZW5kLnJvdysxO2lmKGE+PXUpYnJlYWs7cz10aGlzLiRmb2xkRGF0YVtpKytdLG89cz9zLnN0YXJ0LnJvdzpJbmZpbml0eX1uW2FdPT1udWxsJiYoblthXT10aGlzLiRnZXRTdHJpbmdTY3JlZW5XaWR0aCh0W2FdKVswXSksblthXT5yJiYocj1uW2FdKX10aGlzLnNjcmVlbldpZHRoPXJ9fSx0aGlzLmdldExpbmU9ZnVuY3Rpb24oZSl7cmV0dXJuIHRoaXMuZG9jLmdldExpbmUoZSl9LHRoaXMuZ2V0TGluZXM9ZnVuY3Rpb24oZSx0KXtyZXR1cm4gdGhpcy5kb2MuZ2V0TGluZXMoZSx0KX0sdGhpcy5nZXRMZW5ndGg9ZnVuY3Rpb24oKXtyZXR1cm4gdGhpcy5kb2MuZ2V0TGVuZ3RoKCl9LHRoaXMuZ2V0VGV4dFJhbmdlPWZ1bmN0aW9uKGUpe3JldHVybiB0aGlzLmRvYy5nZXRUZXh0UmFuZ2UoZXx8dGhpcy5zZWxlY3Rpb24uZ2V0UmFuZ2UoKSl9LHRoaXMuaW5zZXJ0PWZ1bmN0aW9uKGUsdCl7cmV0dXJuIHRoaXMuZG9jLmluc2VydChlLHQpfSx0aGlzLnJlbW92ZT1mdW5jdGlvbihlKXtyZXR1cm4gdGhpcy5kb2MucmVtb3ZlKGUpfSx0aGlzLnJlbW92ZUZ1bGxMaW5lcz1mdW5jdGlvbihlLHQpe3JldHVybiB0aGlzLmRvYy5yZW1vdmVGdWxsTGluZXMoZSx0KX0sdGhpcy51bmRvQ2hhbmdlcz1mdW5jdGlvbihlLHQpe2lmKCFlLmxlbmd0aClyZXR1cm47dGhpcy4kZnJvbVVuZG89ITA7Zm9yKHZhciBuPWUubGVuZ3RoLTE7biE9LTE7bi0tKXt2YXIgcj1lW25dO3IuYWN0aW9uPT0iaW5zZXJ0Inx8ci5hY3Rpb249PSJyZW1vdmUiP3RoaXMuZG9jLnJldmVydERlbHRhKHIpOnIuZm9sZHMmJnRoaXMuYWRkRm9sZHMoci5mb2xkcyl9IXQmJnRoaXMuJHVuZG9TZWxlY3QmJihlLnNlbGVjdGlvbkJlZm9yZT90aGlzLnNlbGVjdGlvbi5mcm9tSlNPTihlLnNlbGVjdGlvbkJlZm9yZSk6dGhpcy5zZWxlY3Rpb24uc2V0UmFuZ2UodGhpcy4kZ2V0VW5kb1NlbGVjdGlvbihlLCEwKSkpLHRoaXMuJGZyb21VbmRvPSExfSx0aGlzLnJlZG9DaGFuZ2VzPWZ1bmN0aW9uKGUsdCl7aWYoIWUubGVuZ3RoKXJldHVybjt0aGlzLiRmcm9tVW5kbz0hMDtmb3IodmFyIG49MDtuPGUubGVuZ3RoO24rKyl7dmFyIHI9ZVtuXTsoci5hY3Rpb249PSJpbnNlcnQifHxyLmFjdGlvbj09InJlbW92ZSIpJiZ0aGlzLmRvYy4kc2FmZUFwcGx5RGVsdGEocil9IXQmJnRoaXMuJHVuZG9TZWxlY3QmJihlLnNlbGVjdGlvbkFmdGVyP3RoaXMuc2VsZWN0aW9uLmZyb21KU09OKGUuc2VsZWN0aW9uQWZ0ZXIpOnRoaXMuc2VsZWN0aW9uLnNldFJhbmdlKHRoaXMuJGdldFVuZG9TZWxlY3Rpb24oZSwhMSkpKSx0aGlzLiRmcm9tVW5kbz0hMX0sdGhpcy5zZXRVbmRvU2VsZWN0PWZ1bmN0aW9uKGUpe3RoaXMuJHVuZG9TZWxlY3Q9ZX0sdGhpcy4kZ2V0VW5kb1NlbGVjdGlvbj1mdW5jdGlvbihlLHQpe2Z1bmN0aW9uIG4oZSl7cmV0dXJuIHQ/ZS5hY3Rpb24hPT0iaW5zZXJ0IjplLmFjdGlvbj09PSJpbnNlcnQifXZhciByLGk7Zm9yKHZhciBzPTA7czxlLmxlbmd0aDtzKyspe3ZhciBvPWVbc107aWYoIW8uc3RhcnQpY29udGludWU7aWYoIXIpe24obyk/cj1sLmZyb21Qb2ludHMoby5zdGFydCxvLmVuZCk6cj1sLmZyb21Qb2ludHMoby5zdGFydCxvLnN0YXJ0KTtjb250aW51ZX1uKG8pPyhpPW8uc3RhcnQsci5jb21wYXJlKGkucm93LGkuY29sdW1uKT09LTEmJnIuc2V0U3RhcnQoaSksaT1vLmVuZCxyLmNvbXBhcmUoaS5yb3csaS5jb2x1bW4pPT0xJiZyLnNldEVuZChpKSk6KGk9by5zdGFydCxyLmNvbXBhcmUoaS5yb3csaS5jb2x1bW4pPT0tMSYmKHI9bC5mcm9tUG9pbnRzKG8uc3RhcnQsby5zdGFydCkpKX1yZXR1cm4gcn0sdGhpcy5yZXBsYWNlPWZ1bmN0aW9uKGUsdCl7cmV0dXJuIHRoaXMuZG9jLnJlcGxhY2UoZSx0KX0sdGhpcy5tb3ZlVGV4dD1mdW5jdGlvbihlLHQsbil7dmFyIHI9dGhpcy5nZXRUZXh0UmFuZ2UoZSksaT10aGlzLmdldEZvbGRzSW5SYW5nZShlKSxzPWwuZnJvbVBvaW50cyh0LHQpO2lmKCFuKXt0aGlzLnJlbW92ZShlKTt2YXIgbz1lLnN0YXJ0LnJvdy1lLmVuZC5yb3csdT1vPy1lLmVuZC5jb2x1bW46ZS5zdGFydC5jb2x1bW4tZS5lbmQuY29sdW1uO3UmJihzLnN0YXJ0LnJvdz09ZS5lbmQucm93JiZzLnN0YXJ0LmNvbHVtbj5lLmVuZC5jb2x1bW4mJihzLnN0YXJ0LmNvbHVtbis9dSkscy5lbmQucm93PT1lLmVuZC5yb3cmJnMuZW5kLmNvbHVtbj5lLmVuZC5jb2x1bW4mJihzLmVuZC5jb2x1bW4rPXUpKSxvJiZzLnN0YXJ0LnJvdz49ZS5lbmQucm93JiYocy5zdGFydC5yb3crPW8scy5lbmQucm93Kz1vKX1zLmVuZD10aGlzLmluc2VydChzLnN0YXJ0LHIpO2lmKGkubGVuZ3RoKXt2YXIgYT1lLnN0YXJ0LGY9cy5zdGFydCxvPWYucm93LWEucm93LHU9Zi5jb2x1bW4tYS5jb2x1bW47dGhpcy5hZGRGb2xkcyhpLm1hcChmdW5jdGlvbihlKXtyZXR1cm4gZT1lLmNsb25lKCksZS5zdGFydC5yb3c9PWEucm93JiYoZS5zdGFydC5jb2x1bW4rPXUpLGUuZW5kLnJvdz09YS5yb3cmJihlLmVuZC5jb2x1bW4rPXUpLGUuc3RhcnQucm93Kz1vLGUuZW5kLnJvdys9byxlfSkpfXJldHVybiBzfSx0aGlzLmluZGVudFJvd3M9ZnVuY3Rpb24oZSx0LG4pe249bi5yZXBsYWNlKC9cdC9nLHRoaXMuZ2V0VGFiU3RyaW5nKCkpO2Zvcih2YXIgcj1lO3I8PXQ7cisrKXRoaXMuZG9jLmluc2VydEluTGluZSh7cm93OnIsY29sdW1uOjB9LG4pfSx0aGlzLm91dGRlbnRSb3dzPWZ1bmN0aW9uKGUpe3ZhciB0PWUuY29sbGFwc2VSb3dzKCksbj1uZXcgbCgwLDAsMCwwKSxyPXRoaXMuZ2V0VGFiU2l6ZSgpO2Zvcih2YXIgaT10LnN0YXJ0LnJvdztpPD10LmVuZC5yb3c7KytpKXt2YXIgcz10aGlzLmdldExpbmUoaSk7bi5zdGFydC5yb3c9aSxuLmVuZC5yb3c9aTtmb3IodmFyIG89MDtvPHI7KytvKWlmKHMuY2hhckF0KG8pIT0iICIpYnJlYWs7bzxyJiZzLmNoYXJBdChvKT09IgkiPyhuLnN0YXJ0LmNvbHVtbj1vLG4uZW5kLmNvbHVtbj1vKzEpOihuLnN0YXJ0LmNvbHVtbj0wLG4uZW5kLmNvbHVtbj1vKSx0aGlzLnJlbW92ZShuKX19LHRoaXMuJG1vdmVMaW5lcz1mdW5jdGlvbihlLHQsbil7ZT10aGlzLmdldFJvd0ZvbGRTdGFydChlKSx0PXRoaXMuZ2V0Um93Rm9sZEVuZCh0KTtpZihuPDApe3ZhciByPXRoaXMuZ2V0Um93Rm9sZFN0YXJ0KGUrbik7aWYocjwwKXJldHVybiAwO3ZhciBpPXItZX1lbHNlIGlmKG4+MCl7dmFyIHI9dGhpcy5nZXRSb3dGb2xkRW5kKHQrbik7aWYocj50aGlzLmRvYy5nZXRMZW5ndGgoKS0xKXJldHVybiAwO3ZhciBpPXItdH1lbHNle2U9dGhpcy4kY2xpcFJvd1RvRG9jdW1lbnQoZSksdD10aGlzLiRjbGlwUm93VG9Eb2N1bWVudCh0KTt2YXIgaT10LWUrMX12YXIgcz1uZXcgbChlLDAsdCxOdW1iZXIuTUFYX1ZBTFVFKSxvPXRoaXMuZ2V0Rm9sZHNJblJhbmdlKHMpLm1hcChmdW5jdGlvbihlKXtyZXR1cm4gZT1lLmNsb25lKCksZS5zdGFydC5yb3crPWksZS5lbmQucm93Kz1pLGV9KSx1PW49PTA/dGhpcy5kb2MuZ2V0TGluZXMoZSx0KTp0aGlzLmRvYy5yZW1vdmVGdWxsTGluZXMoZSx0KTtyZXR1cm4gdGhpcy5kb2MuaW5zZXJ0RnVsbExpbmVzKGUraSx1KSxvLmxlbmd0aCYmdGhpcy5hZGRGb2xkcyhvKSxpfSx0aGlzLm1vdmVMaW5lc1VwPWZ1bmN0aW9uKGUsdCl7cmV0dXJuIHRoaXMuJG1vdmVMaW5lcyhlLHQsLTEpfSx0aGlzLm1vdmVMaW5lc0Rvd249ZnVuY3Rpb24oZSx0KXtyZXR1cm4gdGhpcy4kbW92ZUxpbmVzKGUsdCwxKX0sdGhpcy5kdXBsaWNhdGVMaW5lcz1mdW5jdGlvbihlLHQpe3JldHVybiB0aGlzLiRtb3ZlTGluZXMoZSx0LDApfSx0aGlzLiRjbGlwUm93VG9Eb2N1bWVudD1mdW5jdGlvbihlKXtyZXR1cm4gTWF0aC5tYXgoMCxNYXRoLm1pbihlLHRoaXMuZG9jLmdldExlbmd0aCgpLTEpKX0sdGhpcy4kY2xpcENvbHVtblRvUm93PWZ1bmN0aW9uKGUsdCl7cmV0dXJuIHQ8MD8wOk1hdGgubWluKHRoaXMuZG9jLmdldExpbmUoZSkubGVuZ3RoLHQpfSx0aGlzLiRjbGlwUG9zaXRpb25Ub0RvY3VtZW50PWZ1bmN0aW9uKGUsdCl7dD1NYXRoLm1heCgwLHQpO2lmKGU8MCllPTAsdD0wO2Vsc2V7dmFyIG49dGhpcy5kb2MuZ2V0TGVuZ3RoKCk7ZT49bj8oZT1uLTEsdD10aGlzLmRvYy5nZXRMaW5lKG4tMSkubGVuZ3RoKTp0PU1hdGgubWluKHRoaXMuZG9jLmdldExpbmUoZSkubGVuZ3RoLHQpfXJldHVybntyb3c6ZSxjb2x1bW46dH19LHRoaXMuJGNsaXBSYW5nZVRvRG9jdW1lbnQ9ZnVuY3Rpb24oZSl7ZS5zdGFydC5yb3c8MD8oZS5zdGFydC5yb3c9MCxlLnN0YXJ0LmNvbHVtbj0wKTplLnN0YXJ0LmNvbHVtbj10aGlzLiRjbGlwQ29sdW1uVG9Sb3coZS5zdGFydC5yb3csZS5zdGFydC5jb2x1bW4pO3ZhciB0PXRoaXMuZG9jLmdldExlbmd0aCgpLTE7cmV0dXJuIGUuZW5kLnJvdz50PyhlLmVuZC5yb3c9dCxlLmVuZC5jb2x1bW49dGhpcy5kb2MuZ2V0TGluZSh0KS5sZW5ndGgpOmUuZW5kLmNvbHVtbj10aGlzLiRjbGlwQ29sdW1uVG9Sb3coZS5lbmQucm93LGUuZW5kLmNvbHVtbiksZX0sdGhpcy4kd3JhcExpbWl0PTgwLHRoaXMuJHVzZVdyYXBNb2RlPSExLHRoaXMuJHdyYXBMaW1pdFJhbmdlPXttaW46bnVsbCxtYXg6bnVsbH0sdGhpcy5zZXRVc2VXcmFwTW9kZT1mdW5jdGlvbihlKXtpZihlIT10aGlzLiR1c2VXcmFwTW9kZSl7dGhpcy4kdXNlV3JhcE1vZGU9ZSx0aGlzLiRtb2RpZmllZD0hMCx0aGlzLiRyZXNldFJvd0NhY2hlKDApO2lmKGUpe3ZhciB0PXRoaXMuZ2V0TGVuZ3RoKCk7dGhpcy4kd3JhcERhdGE9QXJyYXkodCksdGhpcy4kdXBkYXRlV3JhcERhdGEoMCx0LTEpfXRoaXMuX3NpZ25hbCgiY2hhbmdlV3JhcE1vZGUiKX19LHRoaXMuZ2V0VXNlV3JhcE1vZGU9ZnVuY3Rpb24oKXtyZXR1cm4gdGhpcy4kdXNlV3JhcE1vZGV9LHRoaXMuc2V0V3JhcExpbWl0UmFuZ2U9ZnVuY3Rpb24oZSx0KXtpZih0aGlzLiR3cmFwTGltaXRSYW5nZS5taW4hPT1lfHx0aGlzLiR3cmFwTGltaXRSYW5nZS5tYXghPT10KXRoaXMuJHdyYXBMaW1pdFJhbmdlPXttaW46ZSxtYXg6dH0sdGhpcy4kbW9kaWZpZWQ9ITAsdGhpcy4kYmlkaUhhbmRsZXIubWFya0FzRGlydHkoKSx0aGlzLiR1c2VXcmFwTW9kZSYmdGhpcy5fc2lnbmFsKCJjaGFuZ2VXcmFwTW9kZSIpfSx0aGlzLmFkanVzdFdyYXBMaW1pdD1mdW5jdGlvbihlLHQpe3ZhciBuPXRoaXMuJHdyYXBMaW1pdFJhbmdlO24ubWF4PDAmJihuPXttaW46dCxtYXg6dH0pO3ZhciByPXRoaXMuJGNvbnN0cmFpbldyYXBMaW1pdChlLG4ubWluLG4ubWF4KTtyZXR1cm4gciE9dGhpcy4kd3JhcExpbWl0JiZyPjE/KHRoaXMuJHdyYXBMaW1pdD1yLHRoaXMuJG1vZGlmaWVkPSEwLHRoaXMuJHVzZVdyYXBNb2RlJiYodGhpcy4kdXBkYXRlV3JhcERhdGEoMCx0aGlzLmdldExlbmd0aCgpLTEpLHRoaXMuJHJlc2V0Um93Q2FjaGUoMCksdGhpcy5fc2lnbmFsKCJjaGFuZ2VXcmFwTGltaXQiKSksITApOiExfSx0aGlzLiRjb25zdHJhaW5XcmFwTGltaXQ9ZnVuY3Rpb24oZSx0LG4pe3JldHVybiB0JiYoZT1NYXRoLm1heCh0LGUpKSxuJiYoZT1NYXRoLm1pbihuLGUpKSxlfSx0aGlzLmdldFdyYXBMaW1pdD1mdW5jdGlvbigpe3JldHVybiB0aGlzLiR3cmFwTGltaXR9LHRoaXMuc2V0V3JhcExpbWl0PWZ1bmN0aW9uKGUpe3RoaXMuc2V0V3JhcExpbWl0UmFuZ2UoZSxlKX0sdGhpcy5nZXRXcmFwTGltaXRSYW5nZT1mdW5jdGlvbigpe3JldHVybnttaW46dGhpcy4kd3JhcExpbWl0UmFuZ2UubWluLG1heDp0aGlzLiR3cmFwTGltaXRSYW5nZS5tYXh9fSx0aGlzLiR1cGRhdGVJbnRlcm5hbERhdGFPbkNoYW5nZT1mdW5jdGlvbihlKXt2YXIgdD10aGlzLiR1c2VXcmFwTW9kZSxuPWUuYWN0aW9uLHI9ZS5zdGFydCxpPWUuZW5kLHM9ci5yb3csbz1pLnJvdyx1PW8tcyxhPW51bGw7dGhpcy4kdXBkYXRpbmc9ITA7aWYodSE9MClpZihuPT09InJlbW92ZSIpe3RoaXNbdD8iJHdyYXBEYXRhIjoiJHJvd0xlbmd0aENhY2hlIl0uc3BsaWNlKHMsdSk7dmFyIGY9dGhpcy4kZm9sZERhdGE7YT10aGlzLmdldEZvbGRzSW5SYW5nZShlKSx0aGlzLnJlbW92ZUZvbGRzKGEpO3ZhciBsPXRoaXMuZ2V0Rm9sZExpbmUoaS5yb3cpLGM9MDtpZihsKXtsLmFkZFJlbW92ZUNoYXJzKGkucm93LGkuY29sdW1uLHIuY29sdW1uLWkuY29sdW1uKSxsLnNoaWZ0Um93KC11KTt2YXIgaD10aGlzLmdldEZvbGRMaW5lKHMpO2gmJmghPT1sJiYoaC5tZXJnZShsKSxsPWgpLGM9Zi5pbmRleE9mKGwpKzF9Zm9yKGM7YzxmLmxlbmd0aDtjKyspe3ZhciBsPWZbY107bC5zdGFydC5yb3c+PWkucm93JiZsLnNoaWZ0Um93KC11KX1vPXN9ZWxzZXt2YXIgcD1BcnJheSh1KTtwLnVuc2hpZnQocywwKTt2YXIgZD10P3RoaXMuJHdyYXBEYXRhOnRoaXMuJHJvd0xlbmd0aENhY2hlO2Quc3BsaWNlLmFwcGx5KGQscCk7dmFyIGY9dGhpcy4kZm9sZERhdGEsbD10aGlzLmdldEZvbGRMaW5lKHMpLGM9MDtpZihsKXt2YXIgdj1sLnJhbmdlLmNvbXBhcmVJbnNpZGUoci5yb3csci5jb2x1bW4pO3Y9PTA/KGw9bC5zcGxpdChyLnJvdyxyLmNvbHVtbiksbCYmKGwuc2hpZnRSb3codSksbC5hZGRSZW1vdmVDaGFycyhvLDAsaS5jb2x1bW4tci5jb2x1bW4pKSk6dj09LTEmJihsLmFkZFJlbW92ZUNoYXJzKHMsMCxpLmNvbHVtbi1yLmNvbHVtbiksbC5zaGlmdFJvdyh1KSksYz1mLmluZGV4T2YobCkrMX1mb3IoYztjPGYubGVuZ3RoO2MrKyl7dmFyIGw9ZltjXTtsLnN0YXJ0LnJvdz49cyYmbC5zaGlmdFJvdyh1KX19ZWxzZXt1PU1hdGguYWJzKGUuc3RhcnQuY29sdW1uLWUuZW5kLmNvbHVtbiksbj09PSJyZW1vdmUiJiYoYT10aGlzLmdldEZvbGRzSW5SYW5nZShlKSx0aGlzLnJlbW92ZUZvbGRzKGEpLHU9LXUpO3ZhciBsPXRoaXMuZ2V0Rm9sZExpbmUocyk7bCYmbC5hZGRSZW1vdmVDaGFycyhzLHIuY29sdW1uLHUpfXJldHVybiB0JiZ0aGlzLiR3cmFwRGF0YS5sZW5ndGghPXRoaXMuZG9jLmdldExlbmd0aCgpJiZjb25zb2xlLmVycm9yKCJkb2MuZ2V0TGVuZ3RoKCkgYW5kICR3cmFwRGF0YS5sZW5ndGggaGF2ZSB0byBiZSB0aGUgc2FtZSEiKSx0aGlzLiR1cGRhdGluZz0hMSx0P3RoaXMuJHVwZGF0ZVdyYXBEYXRhKHMsbyk6dGhpcy4kdXBkYXRlUm93TGVuZ3RoQ2FjaGUocyxvKSxhfSx0aGlzLiR1cGRhdGVSb3dMZW5ndGhDYWNoZT1mdW5jdGlvbihlLHQsbil7dGhpcy4kcm93TGVuZ3RoQ2FjaGVbZV09bnVsbCx0aGlzLiRyb3dMZW5ndGhDYWNoZVt0XT1udWxsfSx0aGlzLiR1cGRhdGVXcmFwRGF0YT1mdW5jdGlvbihlLHQpe3ZhciByPXRoaXMuZG9jLmdldEFsbExpbmVzKCksaT10aGlzLmdldFRhYlNpemUoKSxvPXRoaXMuJHdyYXBEYXRhLHU9dGhpcy4kd3JhcExpbWl0LGEsZixsPWU7dD1NYXRoLm1pbih0LHIubGVuZ3RoLTEpO3doaWxlKGw8PXQpZj10aGlzLmdldEZvbGRMaW5lKGwsZiksZj8oYT1bXSxmLndhbGsoZnVuY3Rpb24oZSx0LGksbyl7dmFyIHU7aWYoZSE9bnVsbCl7dT10aGlzLiRnZXREaXNwbGF5VG9rZW5zKGUsYS5sZW5ndGgpLHVbMF09bjtmb3IodmFyIGY9MTtmPHUubGVuZ3RoO2YrKyl1W2ZdPXN9ZWxzZSB1PXRoaXMuJGdldERpc3BsYXlUb2tlbnMoclt0XS5zdWJzdHJpbmcobyxpKSxhLmxlbmd0aCk7YT1hLmNvbmNhdCh1KX0uYmluZCh0aGlzKSxmLmVuZC5yb3cscltmLmVuZC5yb3ddLmxlbmd0aCsxKSxvW2Yuc3RhcnQucm93XT10aGlzLiRjb21wdXRlV3JhcFNwbGl0cyhhLHUsaSksbD1mLmVuZC5yb3crMSk6KGE9dGhpcy4kZ2V0RGlzcGxheVRva2VucyhyW2xdKSxvW2xdPXRoaXMuJGNvbXB1dGVXcmFwU3BsaXRzKGEsdSxpKSxsKyspfTt2YXIgZT0xLHQ9MixuPTMscz00LGE9OSxjPTEwLGg9MTEsZD0xMjt0aGlzLiRjb21wdXRlV3JhcFNwbGl0cz1mdW5jdGlvbihlLHIsaSl7ZnVuY3Rpb24gZygpe3ZhciB0PTA7aWYobT09PTApcmV0dXJuIHQ7aWYodilmb3IodmFyIG49MDtuPGUubGVuZ3RoO24rKyl7dmFyIHI9ZVtuXTtpZihyPT1jKXQrPTE7ZWxzZXtpZihyIT1oKXtpZihyPT1kKWNvbnRpbnVlO2JyZWFrfXQrPWl9fXJldHVybiBwJiZ2IT09ITEmJih0Kz1pKSxNYXRoLm1pbih0LG0pfWZ1bmN0aW9uIHkodCl7dmFyIG49dC1mO2Zvcih2YXIgcj1mO3I8dDtyKyspe3ZhciBpPWVbcl07aWYoaT09PTEyfHxpPT09MiluLT0xfW8ubGVuZ3RofHwoYj1nKCksby5pbmRlbnQ9YiksbCs9bixvLnB1c2gobCksZj10fWlmKGUubGVuZ3RoPT0wKXJldHVybltdO3ZhciBvPVtdLHU9ZS5sZW5ndGgsZj0wLGw9MCxwPXRoaXMuJHdyYXBBc0NvZGUsdj10aGlzLiRpbmRlbnRlZFNvZnRXcmFwLG09cjw9TWF0aC5tYXgoMippLDgpfHx2PT09ITE/MDpNYXRoLmZsb29yKHIvMiksYj0wO3doaWxlKHUtZj5yLWIpe3ZhciB3PWYrci1iO2lmKGVbdy0xXT49YyYmZVt3XT49Yyl7eSh3KTtjb250aW51ZX1pZihlW3ddPT1ufHxlW3ddPT1zKXtmb3Iodzt3IT1mLTE7dy0tKWlmKGVbd109PW4pYnJlYWs7aWYodz5mKXt5KHcpO2NvbnRpbnVlfXc9ZityO2Zvcih3O3c8ZS5sZW5ndGg7dysrKWlmKGVbd10hPXMpYnJlYWs7aWYodz09ZS5sZW5ndGgpYnJlYWs7eSh3KTtjb250aW51ZX12YXIgRT1NYXRoLm1heCh3LShyLShyPj4yKSksZi0xKTt3aGlsZSh3PkUmJmVbd108bil3LS07aWYocCl7d2hpbGUodz5FJiZlW3ddPG4pdy0tO3doaWxlKHc+RSYmZVt3XT09YSl3LS19ZWxzZSB3aGlsZSh3PkUmJmVbd108Yyl3LS07aWYodz5FKXt5KCsrdyk7Y29udGludWV9dz1mK3IsZVt3XT09dCYmdy0tLHkody1iKX1yZXR1cm4gb30sdGhpcy4kZ2V0RGlzcGxheVRva2Vucz1mdW5jdGlvbihuLHIpe3ZhciBpPVtdLHM7cj1yfHwwO2Zvcih2YXIgbz0wO288bi5sZW5ndGg7bysrKXt2YXIgdT1uLmNoYXJDb2RlQXQobyk7aWYodT09OSl7cz10aGlzLmdldFNjcmVlblRhYlNpemUoaS5sZW5ndGgrciksaS5wdXNoKGgpO2Zvcih2YXIgZj0xO2Y8cztmKyspaS5wdXNoKGQpfWVsc2UgdT09MzI/aS5wdXNoKGMpOnU+MzkmJnU8NDh8fHU+NTcmJnU8NjQ/aS5wdXNoKGEpOnU+PTQzNTImJnYodSk/aS5wdXNoKGUsdCk6aS5wdXNoKGUpfXJldHVybiBpfSx0aGlzLiRnZXRTdHJpbmdTY3JlZW5XaWR0aD1mdW5jdGlvbihlLHQsbil7aWYodD09MClyZXR1cm5bMCwwXTt0PT1udWxsJiYodD1JbmZpbml0eSksbj1ufHwwO3ZhciByLGk7Zm9yKGk9MDtpPGUubGVuZ3RoO2krKyl7cj1lLmNoYXJDb2RlQXQoaSkscj09OT9uKz10aGlzLmdldFNjcmVlblRhYlNpemUobik6cj49NDM1MiYmdihyKT9uKz0yOm4rPTE7aWYobj50KWJyZWFrfXJldHVybltuLGldfSx0aGlzLmxpbmVXaWRnZXRzPW51bGwsdGhpcy5nZXRSb3dMZW5ndGg9ZnVuY3Rpb24oZSl7dmFyIHQ9MTtyZXR1cm4gdGhpcy5saW5lV2lkZ2V0cyYmKHQrPXRoaXMubGluZVdpZGdldHNbZV0mJnRoaXMubGluZVdpZGdldHNbZV0ucm93Q291bnR8fDApLCF0aGlzLiR1c2VXcmFwTW9kZXx8IXRoaXMuJHdyYXBEYXRhW2VdP3Q6dGhpcy4kd3JhcERhdGFbZV0ubGVuZ3RoK3R9LHRoaXMuZ2V0Um93TGluZUNvdW50PWZ1bmN0aW9uKGUpe3JldHVybiF0aGlzLiR1c2VXcmFwTW9kZXx8IXRoaXMuJHdyYXBEYXRhW2VdPzE6dGhpcy4kd3JhcERhdGFbZV0ubGVuZ3RoKzF9LHRoaXMuZ2V0Um93V3JhcEluZGVudD1mdW5jdGlvbihlKXtpZih0aGlzLiR1c2VXcmFwTW9kZSl7dmFyIHQ9dGhpcy5zY3JlZW5Ub0RvY3VtZW50UG9zaXRpb24oZSxOdW1iZXIuTUFYX1ZBTFVFKSxuPXRoaXMuJHdyYXBEYXRhW3Qucm93XTtyZXR1cm4gbi5sZW5ndGgmJm5bMF08dC5jb2x1bW4/bi5pbmRlbnQ6MH1yZXR1cm4gMH0sdGhpcy5nZXRTY3JlZW5MYXN0Um93Q29sdW1uPWZ1bmN0aW9uKGUpe3ZhciB0PXRoaXMuc2NyZWVuVG9Eb2N1bWVudFBvc2l0aW9uKGUsTnVtYmVyLk1BWF9WQUxVRSk7cmV0dXJuIHRoaXMuZG9jdW1lbnRUb1NjcmVlbkNvbHVtbih0LnJvdyx0LmNvbHVtbil9LHRoaXMuZ2V0RG9jdW1lbnRMYXN0Um93Q29sdW1uPWZ1bmN0aW9uKGUsdCl7dmFyIG49dGhpcy5kb2N1bWVudFRvU2NyZWVuUm93KGUsdCk7cmV0dXJuIHRoaXMuZ2V0U2NyZWVuTGFzdFJvd0NvbHVtbihuKX0sdGhpcy5nZXREb2N1bWVudExhc3RSb3dDb2x1bW5Qb3NpdGlvbj1mdW5jdGlvbihlLHQpe3ZhciBuPXRoaXMuZG9jdW1lbnRUb1NjcmVlblJvdyhlLHQpO3JldHVybiB0aGlzLnNjcmVlblRvRG9jdW1lbnRQb3NpdGlvbihuLE51bWJlci5NQVhfVkFMVUUvMTApfSx0aGlzLmdldFJvd1NwbGl0RGF0YT1mdW5jdGlvbihlKXtyZXR1cm4gdGhpcy4kdXNlV3JhcE1vZGU/dGhpcy4kd3JhcERhdGFbZV06dW5kZWZpbmVkfSx0aGlzLmdldFNjcmVlblRhYlNpemU9ZnVuY3Rpb24oZSl7cmV0dXJuIHRoaXMuJHRhYlNpemUtKGUldGhpcy4kdGFiU2l6ZXwwKX0sdGhpcy5zY3JlZW5Ub0RvY3VtZW50Um93PWZ1bmN0aW9uKGUsdCl7cmV0dXJuIHRoaXMuc2NyZWVuVG9Eb2N1bWVudFBvc2l0aW9uKGUsdCkucm93fSx0aGlzLnNjcmVlblRvRG9jdW1lbnRDb2x1bW49ZnVuY3Rpb24oZSx0KXtyZXR1cm4gdGhpcy5zY3JlZW5Ub0RvY3VtZW50UG9zaXRpb24oZSx0KS5jb2x1bW59LHRoaXMuc2NyZWVuVG9Eb2N1bWVudFBvc2l0aW9uPWZ1bmN0aW9uKGUsdCxuKXtpZihlPDApcmV0dXJue3JvdzowLGNvbHVtbjowfTt2YXIgcixpPTAscz0wLG8sdT0wLGE9MCxmPXRoaXMuJHNjcmVlblJvd0NhY2hlLGw9dGhpcy4kZ2V0Um93Q2FjaGVJbmRleChmLGUpLGM9Zi5sZW5ndGg7aWYoYyYmbD49MCl2YXIgdT1mW2xdLGk9dGhpcy4kZG9jUm93Q2FjaGVbbF0saD1lPmZbYy0xXTtlbHNlIHZhciBoPSFjO3ZhciBwPXRoaXMuZ2V0TGVuZ3RoKCktMSxkPXRoaXMuZ2V0TmV4dEZvbGRMaW5lKGkpLHY9ZD9kLnN0YXJ0LnJvdzpJbmZpbml0eTt3aGlsZSh1PD1lKXthPXRoaXMuZ2V0Um93TGVuZ3RoKGkpO2lmKHUrYT5lfHxpPj1wKWJyZWFrO3UrPWEsaSsrLGk+diYmKGk9ZC5lbmQucm93KzEsZD10aGlzLmdldE5leHRGb2xkTGluZShpLGQpLHY9ZD9kLnN0YXJ0LnJvdzpJbmZpbml0eSksaCYmKHRoaXMuJGRvY1Jvd0NhY2hlLnB1c2goaSksdGhpcy4kc2NyZWVuUm93Q2FjaGUucHVzaCh1KSl9aWYoZCYmZC5zdGFydC5yb3c8PWkpcj10aGlzLmdldEZvbGREaXNwbGF5TGluZShkKSxpPWQuc3RhcnQucm93O2Vsc2V7aWYodSthPD1lfHxpPnApcmV0dXJue3JvdzpwLGNvbHVtbjp0aGlzLmdldExpbmUocCkubGVuZ3RofTtyPXRoaXMuZ2V0TGluZShpKSxkPW51bGx9dmFyIG09MCxnPU1hdGguZmxvb3IoZS11KTtpZih0aGlzLiR1c2VXcmFwTW9kZSl7dmFyIHk9dGhpcy4kd3JhcERhdGFbaV07eSYmKG89eVtnXSxnPjAmJnkubGVuZ3RoJiYobT15LmluZGVudCxzPXlbZy0xXXx8eVt5Lmxlbmd0aC0xXSxyPXIuc3Vic3RyaW5nKHMpKSl9cmV0dXJuIG4hPT11bmRlZmluZWQmJnRoaXMuJGJpZGlIYW5kbGVyLmlzQmlkaVJvdyh1K2csaSxnKSYmKHQ9dGhpcy4kYmlkaUhhbmRsZXIub2Zmc2V0VG9Db2wobikpLHMrPXRoaXMuJGdldFN0cmluZ1NjcmVlbldpZHRoKHIsdC1tKVsxXSx0aGlzLiR1c2VXcmFwTW9kZSYmcz49byYmKHM9by0xKSxkP2QuaWR4VG9Qb3NpdGlvbihzKTp7cm93OmksY29sdW1uOnN9fSx0aGlzLmRvY3VtZW50VG9TY3JlZW5Qb3NpdGlvbj1mdW5jdGlvbihlLHQpe2lmKHR5cGVvZiB0PT0idW5kZWZpbmVkIil2YXIgbj10aGlzLiRjbGlwUG9zaXRpb25Ub0RvY3VtZW50KGUucm93LGUuY29sdW1uKTtlbHNlIG49dGhpcy4kY2xpcFBvc2l0aW9uVG9Eb2N1bWVudChlLHQpO2U9bi5yb3csdD1uLmNvbHVtbjt2YXIgcj0wLGk9bnVsbCxzPW51bGw7cz10aGlzLmdldEZvbGRBdChlLHQsMSkscyYmKGU9cy5zdGFydC5yb3csdD1zLnN0YXJ0LmNvbHVtbik7dmFyIG8sdT0wLGE9dGhpcy4kZG9jUm93Q2FjaGUsZj10aGlzLiRnZXRSb3dDYWNoZUluZGV4KGEsZSksbD1hLmxlbmd0aDtpZihsJiZmPj0wKXZhciB1PWFbZl0scj10aGlzLiRzY3JlZW5Sb3dDYWNoZVtmXSxjPWU+YVtsLTFdO2Vsc2UgdmFyIGM9IWw7dmFyIGg9dGhpcy5nZXROZXh0Rm9sZExpbmUodSkscD1oP2guc3RhcnQucm93OkluZmluaXR5O3doaWxlKHU8ZSl7aWYodT49cCl7bz1oLmVuZC5yb3crMTtpZihvPmUpYnJlYWs7aD10aGlzLmdldE5leHRGb2xkTGluZShvLGgpLHA9aD9oLnN0YXJ0LnJvdzpJbmZpbml0eX1lbHNlIG89dSsxO3IrPXRoaXMuZ2V0Um93TGVuZ3RoKHUpLHU9byxjJiYodGhpcy4kZG9jUm93Q2FjaGUucHVzaCh1KSx0aGlzLiRzY3JlZW5Sb3dDYWNoZS5wdXNoKHIpKX12YXIgZD0iIjtoJiZ1Pj1wPyhkPXRoaXMuZ2V0Rm9sZERpc3BsYXlMaW5lKGgsZSx0KSxpPWguc3RhcnQucm93KTooZD10aGlzLmdldExpbmUoZSkuc3Vic3RyaW5nKDAsdCksaT1lKTt2YXIgdj0wO2lmKHRoaXMuJHVzZVdyYXBNb2RlKXt2YXIgbT10aGlzLiR3cmFwRGF0YVtpXTtpZihtKXt2YXIgZz0wO3doaWxlKGQubGVuZ3RoPj1tW2ddKXIrKyxnKys7ZD1kLnN1YnN0cmluZyhtW2ctMV18fDAsZC5sZW5ndGgpLHY9Zz4wP20uaW5kZW50OjB9fXJldHVybiB0aGlzLmxpbmVXaWRnZXRzJiZ0aGlzLmxpbmVXaWRnZXRzW3VdJiZ0aGlzLmxpbmVXaWRnZXRzW3VdLnJvd3NBYm92ZSYmKHIrPXRoaXMubGluZVdpZGdldHNbdV0ucm93c0Fib3ZlKSx7cm93OnIsY29sdW1uOnYrdGhpcy4kZ2V0U3RyaW5nU2NyZWVuV2lkdGgoZClbMF19fSx0aGlzLmRvY3VtZW50VG9TY3JlZW5Db2x1bW49ZnVuY3Rpb24oZSx0KXtyZXR1cm4gdGhpcy5kb2N1bWVudFRvU2NyZWVuUG9zaXRpb24oZSx0KS5jb2x1bW59LHRoaXMuZG9jdW1lbnRUb1NjcmVlblJvdz1mdW5jdGlvbihlLHQpe3JldHVybiB0aGlzLmRvY3VtZW50VG9TY3JlZW5Qb3NpdGlvbihlLHQpLnJvd30sdGhpcy5nZXRTY3JlZW5MZW5ndGg9ZnVuY3Rpb24oKXt2YXIgZT0wLHQ9bnVsbDtpZighdGhpcy4kdXNlV3JhcE1vZGUpe2U9dGhpcy5nZXRMZW5ndGgoKTt2YXIgbj10aGlzLiRmb2xkRGF0YTtmb3IodmFyIHI9MDtyPG4ubGVuZ3RoO3IrKyl0PW5bcl0sZS09dC5lbmQucm93LXQuc3RhcnQucm93fWVsc2V7dmFyIGk9dGhpcy4kd3JhcERhdGEubGVuZ3RoLHM9MCxyPTAsdD10aGlzLiRmb2xkRGF0YVtyKytdLG89dD90LnN0YXJ0LnJvdzpJbmZpbml0eTt3aGlsZShzPGkpe3ZhciB1PXRoaXMuJHdyYXBEYXRhW3NdO2UrPXU/dS5sZW5ndGgrMToxLHMrKyxzPm8mJihzPXQuZW5kLnJvdysxLHQ9dGhpcy4kZm9sZERhdGFbcisrXSxvPXQ/dC5zdGFydC5yb3c6SW5maW5pdHkpfX1yZXR1cm4gdGhpcy5saW5lV2lkZ2V0cyYmKGUrPXRoaXMuJGdldFdpZGdldFNjcmVlbkxlbmd0aCgpKSxlfSx0aGlzLiRzZXRGb250TWV0cmljcz1mdW5jdGlvbihlKXtpZighdGhpcy4kZW5hYmxlVmFyQ2hhcilyZXR1cm47dGhpcy4kZ2V0U3RyaW5nU2NyZWVuV2lkdGg9ZnVuY3Rpb24odCxuLHIpe2lmKG49PT0wKXJldHVyblswLDBdO258fChuPUluZmluaXR5KSxyPXJ8fDA7dmFyIGkscztmb3Iocz0wO3M8dC5sZW5ndGg7cysrKXtpPXQuY2hhckF0KHMpLGk9PT0iCSI/cis9dGhpcy5nZXRTY3JlZW5UYWJTaXplKHIpOnIrPWUuZ2V0Q2hhcmFjdGVyV2lkdGgoaSk7aWYocj5uKWJyZWFrfXJldHVybltyLHNdfX0sdGhpcy5kZXN0cm95PWZ1bmN0aW9uKCl7dGhpcy5kZXN0cm95ZWR8fCh0aGlzLmJnVG9rZW5pemVyLnNldERvY3VtZW50KG51bGwpLHRoaXMuYmdUb2tlbml6ZXIuY2xlYW51cCgpLHRoaXMuZGVzdHJveWVkPSEwKSx0aGlzLiRzdG9wV29ya2VyKCksdGhpcy5yZW1vdmVBbGxMaXN0ZW5lcnMoKSx0aGlzLmRvYyYmdGhpcy5kb2Mub2ZmKCJjaGFuZ2UiLHRoaXMuJG9uQ2hhbmdlKSx0aGlzLnNlbGVjdGlvbi5kZXRhY2goKX0sdGhpcy5pc0Z1bGxXaWR0aD12fS5jYWxsKGQucHJvdG90eXBlKSxlKCIuL2VkaXRfc2Vzc2lvbi9mb2xkaW5nIikuRm9sZGluZy5jYWxsKGQucHJvdG90eXBlKSxlKCIuL2VkaXRfc2Vzc2lvbi9icmFja2V0X21hdGNoIikuQnJhY2tldE1hdGNoLmNhbGwoZC5wcm90b3R5cGUpLG8uZGVmaW5lT3B0aW9ucyhkLnByb3RvdHlwZSwic2Vzc2lvbiIse3dyYXA6e3NldDpmdW5jdGlvbihlKXshZXx8ZT09Im9mZiI/ZT0hMTplPT0iZnJlZSI/ZT0hMDplPT0icHJpbnRNYXJnaW4iP2U9LTE6dHlwZW9mIGU9PSJzdHJpbmciJiYoZT1wYXJzZUludChlLDEwKXx8ITEpO2lmKHRoaXMuJHdyYXA9PWUpcmV0dXJuO3RoaXMuJHdyYXA9ZTtpZighZSl0aGlzLnNldFVzZVdyYXBNb2RlKCExKTtlbHNle3ZhciB0PXR5cGVvZiBlPT0ibnVtYmVyIj9lOm51bGw7dGhpcy5zZXRXcmFwTGltaXRSYW5nZSh0LHQpLHRoaXMuc2V0VXNlV3JhcE1vZGUoITApfX0sZ2V0OmZ1bmN0aW9uKCl7cmV0dXJuIHRoaXMuZ2V0VXNlV3JhcE1vZGUoKT90aGlzLiR3cmFwPT0tMT8icHJpbnRNYXJnaW4iOnRoaXMuZ2V0V3JhcExpbWl0UmFuZ2UoKS5taW4/dGhpcy4kd3JhcDoiZnJlZSI6Im9mZiJ9LGhhbmRsZXNTZXQ6ITB9LHdyYXBNZXRob2Q6e3NldDpmdW5jdGlvbihlKXtlPWU9PSJhdXRvIj90aGlzLiRtb2RlLnR5cGUhPSJ0ZXh0IjplIT0idGV4dCIsZSE9dGhpcy4kd3JhcEFzQ29kZSYmKHRoaXMuJHdyYXBBc0NvZGU9ZSx0aGlzLiR1c2VXcmFwTW9kZSYmKHRoaXMuJHVzZVdyYXBNb2RlPSExLHRoaXMuc2V0VXNlV3JhcE1vZGUoITApKSl9LGluaXRpYWxWYWx1ZToiYXV0byJ9LGluZGVudGVkU29mdFdyYXA6e3NldDpmdW5jdGlvbigpe3RoaXMuJHVzZVdyYXBNb2RlJiYodGhpcy4kdXNlV3JhcE1vZGU9ITEsdGhpcy5zZXRVc2VXcmFwTW9kZSghMCkpfSxpbml0aWFsVmFsdWU6ITB9LGZpcnN0TGluZU51bWJlcjp7c2V0OmZ1bmN0aW9uKCl7dGhpcy5fc2lnbmFsKCJjaGFuZ2VCcmVha3BvaW50Iil9LGluaXRpYWxWYWx1ZToxfSx1c2VXb3JrZXI6e3NldDpmdW5jdGlvbihlKXt0aGlzLiR1c2VXb3JrZXI9ZSx0aGlzLiRzdG9wV29ya2VyKCksZSYmdGhpcy4kc3RhcnRXb3JrZXIoKX0saW5pdGlhbFZhbHVlOiEwfSx1c2VTb2Z0VGFiczp7aW5pdGlhbFZhbHVlOiEwfSx0YWJTaXplOntzZXQ6ZnVuY3Rpb24oZSl7ZT1wYXJzZUludChlKSxlPjAmJnRoaXMuJHRhYlNpemUhPT1lJiYodGhpcy4kbW9kaWZpZWQ9ITAsdGhpcy4kcm93TGVuZ3RoQ2FjaGU9W10sdGhpcy4kdGFiU2l6ZT1lLHRoaXMuX3NpZ25hbCgiY2hhbmdlVGFiU2l6ZSIpKX0saW5pdGlhbFZhbHVlOjQsaGFuZGxlc1NldDohMH0sbmF2aWdhdGVXaXRoaW5Tb2Z0VGFiczp7aW5pdGlhbFZhbHVlOiExfSxmb2xkU3R5bGU6e3NldDpmdW5jdGlvbihlKXt0aGlzLnNldEZvbGRTdHlsZShlKX0saGFuZGxlc1NldDohMH0sb3ZlcndyaXRlOntzZXQ6ZnVuY3Rpb24oZSl7dGhpcy5fc2lnbmFsKCJjaGFuZ2VPdmVyd3JpdGUiKX0saW5pdGlhbFZhbHVlOiExfSxuZXdMaW5lTW9kZTp7c2V0OmZ1bmN0aW9uKGUpe3RoaXMuZG9jLnNldE5ld0xpbmVNb2RlKGUpfSxnZXQ6ZnVuY3Rpb24oKXtyZXR1cm4gdGhpcy5kb2MuZ2V0TmV3TGluZU1vZGUoKX0saGFuZGxlc1NldDohMH0sbW9kZTp7c2V0OmZ1bmN0aW9uKGUpe3RoaXMuc2V0TW9kZShlKX0sZ2V0OmZ1bmN0aW9uKCl7cmV0dXJuIHRoaXMuJG1vZGVJZH0saGFuZGxlc1NldDohMH19KSx0LkVkaXRTZXNzaW9uPWR9KSxkZWZpbmUoImFjZS9zZWFyY2giLFsicmVxdWlyZSIsImV4cG9ydHMiLCJtb2R1bGUiLCJhY2UvbGliL2xhbmciLCJhY2UvbGliL29vcCIsImFjZS9yYW5nZSJdLGZ1bmN0aW9uKGUsdCxuKXsidXNlIHN0cmljdCI7ZnVuY3Rpb24gdShlLHQpe2Z1bmN0aW9uIG4oZSl7cmV0dXJuL1x3Ly50ZXN0KGUpfHx0LnJlZ0V4cD8iXFxiIjoiIn1yZXR1cm4gbihlWzBdKStlK24oZVtlLmxlbmd0aC0xXSl9dmFyIHI9ZSgiLi9saWIvbGFuZyIpLGk9ZSgiLi9saWIvb29wIikscz1lKCIuL3JhbmdlIikuUmFuZ2Usbz1mdW5jdGlvbigpe3RoaXMuJG9wdGlvbnM9e319OyhmdW5jdGlvbigpe3RoaXMuc2V0PWZ1bmN0aW9uKGUpe3JldHVybiBpLm1peGluKHRoaXMuJG9wdGlvbnMsZSksdGhpc30sdGhpcy5nZXRPcHRpb25zPWZ1bmN0aW9uKCl7cmV0dXJuIHIuY29weU9iamVjdCh0aGlzLiRvcHRpb25zKX0sdGhpcy5zZXRPcHRpb25zPWZ1bmN0aW9uKGUpe3RoaXMuJG9wdGlvbnM9ZX0sdGhpcy5maW5kPWZ1bmN0aW9uKGUpe3ZhciB0PXRoaXMuJG9wdGlvbnMsbj10aGlzLiRtYXRjaEl0ZXJhdG9yKGUsdCk7aWYoIW4pcmV0dXJuITE7dmFyIHI9bnVsbDtyZXR1cm4gbi5mb3JFYWNoKGZ1bmN0aW9uKGUsbixpLG8pe3JldHVybiByPW5ldyBzKGUsbixpLG8pLG49PW8mJnQuc3RhcnQmJnQuc3RhcnQuc3RhcnQmJnQuc2tpcEN1cnJlbnQhPTAmJnIuaXNFcXVhbCh0LnN0YXJ0KT8ocj1udWxsLCExKTohMH0pLHJ9LHRoaXMuZmluZEFsbD1mdW5jdGlvbihlKXt2YXIgdD10aGlzLiRvcHRpb25zO2lmKCF0Lm5lZWRsZSlyZXR1cm5bXTt0aGlzLiRhc3NlbWJsZVJlZ0V4cCh0KTt2YXIgbj10LnJhbmdlLGk9bj9lLmdldExpbmVzKG4uc3RhcnQucm93LG4uZW5kLnJvdyk6ZS5kb2MuZ2V0QWxsTGluZXMoKSxvPVtdLHU9dC5yZTtpZih0LiRpc011bHRpTGluZSl7dmFyIGE9dS5sZW5ndGgsZj1pLmxlbmd0aC1hLGw7ZTpmb3IodmFyIGM9dS5vZmZzZXR8fDA7Yzw9ZjtjKyspe2Zvcih2YXIgaD0wO2g8YTtoKyspaWYoaVtjK2hdLnNlYXJjaCh1W2hdKT09LTEpY29udGludWUgZTt2YXIgcD1pW2NdLGQ9aVtjK2EtMV0sdj1wLmxlbmd0aC1wLm1hdGNoKHVbMF0pWzBdLmxlbmd0aCxtPWQubWF0Y2godVthLTFdKVswXS5sZW5ndGg7aWYobCYmbC5lbmQucm93PT09YyYmbC5lbmQuY29sdW1uPnYpY29udGludWU7by5wdXNoKGw9bmV3IHMoYyx2LGMrYS0xLG0pKSxhPjImJihjPWMrYS0yKX19ZWxzZSBmb3IodmFyIGc9MDtnPGkubGVuZ3RoO2crKyl7dmFyIHk9ci5nZXRNYXRjaE9mZnNldHMoaVtnXSx1KTtmb3IodmFyIGg9MDtoPHkubGVuZ3RoO2grKyl7dmFyIGI9eVtoXTtvLnB1c2gobmV3IHMoZyxiLm9mZnNldCxnLGIub2Zmc2V0K2IubGVuZ3RoKSl9fWlmKG4pe3ZhciB3PW4uc3RhcnQuY29sdW1uLEU9bi5lbmQuY29sdW1uLGc9MCxoPW8ubGVuZ3RoLTE7d2hpbGUoZzxoJiZvW2ddLnN0YXJ0LmNvbHVtbjx3JiZvW2ddLnN0YXJ0LnJvdz09MClnKys7dmFyIFM9bi5lbmQucm93LW4uc3RhcnQucm93O3doaWxlKGc8aCYmb1toXS5lbmQuY29sdW1uPkUmJm9baF0uZW5kLnJvdz09UyloLS07bz1vLnNsaWNlKGcsaCsxKTtmb3IoZz0wLGg9by5sZW5ndGg7ZzxoO2crKylvW2ddLnN0YXJ0LnJvdys9bi5zdGFydC5yb3csb1tnXS5lbmQucm93Kz1uLnN0YXJ0LnJvd31yZXR1cm4gb30sdGhpcy5yZXBsYWNlPWZ1bmN0aW9uKGUsdCl7dmFyIG49dGhpcy4kb3B0aW9ucyxyPXRoaXMuJGFzc2VtYmxlUmVnRXhwKG4pO2lmKG4uJGlzTXVsdGlMaW5lKXJldHVybiB0O2lmKCFyKXJldHVybjt2YXIgaT1yLmV4ZWMoZSk7aWYoIWl8fGlbMF0ubGVuZ3RoIT1lLmxlbmd0aClyZXR1cm4gbnVsbDt0PWUucmVwbGFjZShyLHQpO2lmKG4ucHJlc2VydmVDYXNlKXt0PXQuc3BsaXQoIiIpO2Zvcih2YXIgcz1NYXRoLm1pbihlLmxlbmd0aCxlLmxlbmd0aCk7cy0tOyl7dmFyIG89ZVtzXTtvJiZvLnRvTG93ZXJDYXNlKCkhPW8/dFtzXT10W3NdLnRvVXBwZXJDYXNlKCk6dFtzXT10W3NdLnRvTG93ZXJDYXNlKCl9dD10LmpvaW4oIiIpfXJldHVybiB0fSx0aGlzLiRhc3NlbWJsZVJlZ0V4cD1mdW5jdGlvbihlLHQpe2lmKGUubmVlZGxlIGluc3RhbmNlb2YgUmVnRXhwKXJldHVybiBlLnJlPWUubmVlZGxlO3ZhciBuPWUubmVlZGxlO2lmKCFlLm5lZWRsZSlyZXR1cm4gZS5yZT0hMTtlLnJlZ0V4cHx8KG49ci5lc2NhcGVSZWdFeHAobikpLGUud2hvbGVXb3JkJiYobj11KG4sZSkpO3ZhciBpPWUuY2FzZVNlbnNpdGl2ZT8iZ20iOiJnbWkiO2UuJGlzTXVsdGlMaW5lPSF0JiYvW1xuXHJdLy50ZXN0KG4pO2lmKGUuJGlzTXVsdGlMaW5lKXJldHVybiBlLnJlPXRoaXMuJGFzc2VtYmxlTXVsdGlsaW5lUmVnRXhwKG4saSk7dHJ5e3ZhciBzPW5ldyBSZWdFeHAobixpKX1jYXRjaChvKXtzPSExfXJldHVybiBlLnJlPXN9LHRoaXMuJGFzc2VtYmxlTXVsdGlsaW5lUmVnRXhwPWZ1bmN0aW9uKGUsdCl7dmFyIG49ZS5yZXBsYWNlKC9cclxufFxyfFxuL2csIiRcbl4iKS5zcGxpdCgiXG4iKSxyPVtdO2Zvcih2YXIgaT0wO2k8bi5sZW5ndGg7aSsrKXRyeXtyLnB1c2gobmV3IFJlZ0V4cChuW2ldLHQpKX1jYXRjaChzKXtyZXR1cm4hMX1yZXR1cm4gcn0sdGhpcy4kbWF0Y2hJdGVyYXRvcj1mdW5jdGlvbihlLHQpe3ZhciBuPXRoaXMuJGFzc2VtYmxlUmVnRXhwKHQpO2lmKCFuKXJldHVybiExO3ZhciByPXQuYmFja3dhcmRzPT0xLGk9dC5za2lwQ3VycmVudCE9MCxzPXQucmFuZ2Usbz10LnN0YXJ0O298fChvPXM/c1tyPyJlbmQiOiJzdGFydCJdOmUuc2VsZWN0aW9uLmdldFJhbmdlKCkpLG8uc3RhcnQmJihvPW9baSE9cj8iZW5kIjoic3RhcnQiXSk7dmFyIHU9cz9zLnN0YXJ0LnJvdzowLGE9cz9zLmVuZC5yb3c6ZS5nZXRMZW5ndGgoKS0xO2lmKHIpdmFyIGY9ZnVuY3Rpb24oZSl7dmFyIG49by5yb3c7aWYoYyhuLG8uY29sdW1uLGUpKXJldHVybjtmb3Iobi0tO24+PXU7bi0tKWlmKGMobixOdW1iZXIuTUFYX1ZBTFVFLGUpKXJldHVybjtpZih0LndyYXA9PTApcmV0dXJuO2ZvcihuPWEsdT1vLnJvdztuPj11O24tLSlpZihjKG4sTnVtYmVyLk1BWF9WQUxVRSxlKSlyZXR1cm59O2Vsc2UgdmFyIGY9ZnVuY3Rpb24oZSl7dmFyIG49by5yb3c7aWYoYyhuLG8uY29sdW1uLGUpKXJldHVybjtmb3Iobis9MTtuPD1hO24rKylpZihjKG4sMCxlKSlyZXR1cm47aWYodC53cmFwPT0wKXJldHVybjtmb3Iobj11LGE9by5yb3c7bjw9YTtuKyspaWYoYyhuLDAsZSkpcmV0dXJufTtpZih0LiRpc011bHRpTGluZSl2YXIgbD1uLmxlbmd0aCxjPWZ1bmN0aW9uKHQsaSxzKXt2YXIgbz1yP3QtbCsxOnQ7aWYobzwwfHxvK2w+ZS5nZXRMZW5ndGgoKSlyZXR1cm47dmFyIHU9ZS5nZXRMaW5lKG8pLGE9dS5zZWFyY2goblswXSk7aWYoIXImJmE8aXx8YT09PS0xKXJldHVybjtmb3IodmFyIGY9MTtmPGw7ZisrKXt1PWUuZ2V0TGluZShvK2YpO2lmKHUuc2VhcmNoKG5bZl0pPT0tMSlyZXR1cm59dmFyIGM9dS5tYXRjaChuW2wtMV0pWzBdLmxlbmd0aDtpZihyJiZjPmkpcmV0dXJuO2lmKHMobyxhLG8rbC0xLGMpKXJldHVybiEwfTtlbHNlIGlmKHIpdmFyIGM9ZnVuY3Rpb24odCxyLGkpe3ZhciBzPWUuZ2V0TGluZSh0KSxvPVtdLHUsYT0wO24ubGFzdEluZGV4PTA7d2hpbGUodT1uLmV4ZWMocykpe3ZhciBmPXVbMF0ubGVuZ3RoO2E9dS5pbmRleDtpZighZil7aWYoYT49cy5sZW5ndGgpYnJlYWs7bi5sYXN0SW5kZXg9YSs9MX1pZih1LmluZGV4K2Y+cilicmVhaztvLnB1c2godS5pbmRleCxmKX1mb3IodmFyIGw9by5sZW5ndGgtMTtsPj0wO2wtPTIpe3ZhciBjPW9bbC0xXSxmPW9bbF07aWYoaSh0LGMsdCxjK2YpKXJldHVybiEwfX07ZWxzZSB2YXIgYz1mdW5jdGlvbih0LHIsaSl7dmFyIHM9ZS5nZXRMaW5lKHQpLG8sdTtuLmxhc3RJbmRleD1yO3doaWxlKHU9bi5leGVjKHMpKXt2YXIgYT11WzBdLmxlbmd0aDtvPXUuaW5kZXg7aWYoaSh0LG8sdCxvK2EpKXJldHVybiEwO2lmKCFhKXtuLmxhc3RJbmRleD1vKz0xO2lmKG8+PXMubGVuZ3RoKXJldHVybiExfX19O3JldHVybntmb3JFYWNoOmZ9fX0pLmNhbGwoby5wcm90b3R5cGUpLHQuU2VhcmNoPW99KSxkZWZpbmUoImFjZS9rZXlib2FyZC9oYXNoX2hhbmRsZXIiLFsicmVxdWlyZSIsImV4cG9ydHMiLCJtb2R1bGUiLCJhY2UvbGliL2tleXMiLCJhY2UvbGliL3VzZXJhZ2VudCJdLGZ1bmN0aW9uKGUsdCxuKXsidXNlIHN0cmljdCI7ZnVuY3Rpb24gbyhlLHQpe3RoaXMucGxhdGZvcm09dHx8KGkuaXNNYWM/Im1hYyI6IndpbiIpLHRoaXMuY29tbWFuZHM9e30sdGhpcy5jb21tYW5kS2V5QmluZGluZz17fSx0aGlzLmFkZENvbW1hbmRzKGUpLHRoaXMuJHNpbmdsZUNvbW1hbmQ9ITB9ZnVuY3Rpb24gdShlLHQpe28uY2FsbCh0aGlzLGUsdCksdGhpcy4kc2luZ2xlQ29tbWFuZD0hMX12YXIgcj1lKCIuLi9saWIva2V5cyIpLGk9ZSgiLi4vbGliL3VzZXJhZ2VudCIpLHM9ci5LRVlfTU9EUzt1LnByb3RvdHlwZT1vLnByb3RvdHlwZSxmdW5jdGlvbigpe2Z1bmN0aW9uIGUoZSl7cmV0dXJuIHR5cGVvZiBlPT0ib2JqZWN0IiYmZS5iaW5kS2V5JiZlLmJpbmRLZXkucG9zaXRpb258fChlLmlzRGVmYXVsdD8tMTAwOjApfXRoaXMuYWRkQ29tbWFuZD1mdW5jdGlvbihlKXt0aGlzLmNvbW1hbmRzW2UubmFtZV0mJnRoaXMucmVtb3ZlQ29tbWFuZChlKSx0aGlzLmNvbW1hbmRzW2UubmFtZV09ZSxlLmJpbmRLZXkmJnRoaXMuX2J1aWxkS2V5SGFzaChlKX0sdGhpcy5yZW1vdmVDb21tYW5kPWZ1bmN0aW9uKGUsdCl7dmFyIG49ZSYmKHR5cGVvZiBlPT0ic3RyaW5nIj9lOmUubmFtZSk7ZT10aGlzLmNvbW1hbmRzW25dLHR8fGRlbGV0ZSB0aGlzLmNvbW1hbmRzW25dO3ZhciByPXRoaXMuY29tbWFuZEtleUJpbmRpbmc7Zm9yKHZhciBpIGluIHIpe3ZhciBzPXJbaV07aWYocz09ZSlkZWxldGUgcltpXTtlbHNlIGlmKEFycmF5LmlzQXJyYXkocykpe3ZhciBvPXMuaW5kZXhPZihlKTtvIT0tMSYmKHMuc3BsaWNlKG8sMSkscy5sZW5ndGg9PTEmJihyW2ldPXNbMF0pKX19fSx0aGlzLmJpbmRLZXk9ZnVuY3Rpb24oZSx0LG4pe3R5cGVvZiBlPT0ib2JqZWN0IiYmZSYmKG49PXVuZGVmaW5lZCYmKG49ZS5wb3NpdGlvbiksZT1lW3RoaXMucGxhdGZvcm1dKTtpZighZSlyZXR1cm47aWYodHlwZW9mIHQ9PSJmdW5jdGlvbiIpcmV0dXJuIHRoaXMuYWRkQ29tbWFuZCh7ZXhlYzp0LGJpbmRLZXk6ZSxuYW1lOnQubmFtZXx8ZX0pO2Uuc3BsaXQoInwiKS5mb3JFYWNoKGZ1bmN0aW9uKGUpe3ZhciByPSIiO2lmKGUuaW5kZXhPZigiICIpIT0tMSl7dmFyIGk9ZS5zcGxpdCgvXHMrLyk7ZT1pLnBvcCgpLGkuZm9yRWFjaChmdW5jdGlvbihlKXt2YXIgdD10aGlzLnBhcnNlS2V5cyhlKSxuPXNbdC5oYXNoSWRdK3Qua2V5O3IrPShyPyIgIjoiIikrbix0aGlzLl9hZGRDb21tYW5kVG9CaW5kaW5nKHIsImNoYWluS2V5cyIpfSx0aGlzKSxyKz0iICJ9dmFyIG89dGhpcy5wYXJzZUtleXMoZSksdT1zW28uaGFzaElkXStvLmtleTt0aGlzLl9hZGRDb21tYW5kVG9CaW5kaW5nKHIrdSx0LG4pfSx0aGlzKX0sdGhpcy5fYWRkQ29tbWFuZFRvQmluZGluZz1mdW5jdGlvbih0LG4scil7dmFyIGk9dGhpcy5jb21tYW5kS2V5QmluZGluZyxzO2lmKCFuKWRlbGV0ZSBpW3RdO2Vsc2UgaWYoIWlbdF18fHRoaXMuJHNpbmdsZUNvbW1hbmQpaVt0XT1uO2Vsc2V7QXJyYXkuaXNBcnJheShpW3RdKT8ocz1pW3RdLmluZGV4T2YobikpIT0tMSYmaVt0XS5zcGxpY2UocywxKTppW3RdPVtpW3RdXSx0eXBlb2YgciE9Im51bWJlciImJihyPWUobikpO3ZhciBvPWlbdF07Zm9yKHM9MDtzPG8ubGVuZ3RoO3MrKyl7dmFyIHU9b1tzXSxhPWUodSk7aWYoYT5yKWJyZWFrfW8uc3BsaWNlKHMsMCxuKX19LHRoaXMuYWRkQ29tbWFuZHM9ZnVuY3Rpb24oZSl7ZSYmT2JqZWN0LmtleXMoZSkuZm9yRWFjaChmdW5jdGlvbih0KXt2YXIgbj1lW3RdO2lmKCFuKXJldHVybjtpZih0eXBlb2Ygbj09InN0cmluZyIpcmV0dXJuIHRoaXMuYmluZEtleShuLHQpO3R5cGVvZiBuPT0iZnVuY3Rpb24iJiYobj17ZXhlYzpufSk7aWYodHlwZW9mIG4hPSJvYmplY3QiKXJldHVybjtuLm5hbWV8fChuLm5hbWU9dCksdGhpcy5hZGRDb21tYW5kKG4pfSx0aGlzKX0sdGhpcy5yZW1vdmVDb21tYW5kcz1mdW5jdGlvbihlKXtPYmplY3Qua2V5cyhlKS5mb3JFYWNoKGZ1bmN0aW9uKHQpe3RoaXMucmVtb3ZlQ29tbWFuZChlW3RdKX0sdGhpcyl9LHRoaXMuYmluZEtleXM9ZnVuY3Rpb24oZSl7T2JqZWN0LmtleXMoZSkuZm9yRWFjaChmdW5jdGlvbih0KXt0aGlzLmJpbmRLZXkodCxlW3RdKX0sdGhpcyl9LHRoaXMuX2J1aWxkS2V5SGFzaD1mdW5jdGlvbihlKXt0aGlzLmJpbmRLZXkoZS5iaW5kS2V5LGUpfSx0aGlzLnBhcnNlS2V5cz1mdW5jdGlvbihlKXt2YXIgdD1lLnRvTG93ZXJDYXNlKCkuc3BsaXQoL1tcLVwrXShbXC1cK10pPy8pLmZpbHRlcihmdW5jdGlvbihlKXtyZXR1cm4gZX0pLG49dC5wb3AoKSxpPXJbbl07aWYoci5GVU5DVElPTl9LRVlTW2ldKW49ci5GVU5DVElPTl9LRVlTW2ldLnRvTG93ZXJDYXNlKCk7ZWxzZXtpZighdC5sZW5ndGgpcmV0dXJue2tleTpuLGhhc2hJZDotMX07aWYodC5sZW5ndGg9PTEmJnRbMF09PSJzaGlmdCIpcmV0dXJue2tleTpuLnRvVXBwZXJDYXNlKCksaGFzaElkOi0xfX12YXIgcz0wO2Zvcih2YXIgbz10Lmxlbmd0aDtvLS07KXt2YXIgdT1yLktFWV9NT0RTW3Rbb11dO2lmKHU9PW51bGwpcmV0dXJuIHR5cGVvZiBjb25zb2xlIT0idW5kZWZpbmVkIiYmY29uc29sZS5lcnJvcigiaW52YWxpZCBtb2RpZmllciAiK3Rbb10rIiBpbiAiK2UpLCExO3N8PXV9cmV0dXJue2tleTpuLGhhc2hJZDpzfX0sdGhpcy5maW5kS2V5Q29tbWFuZD1mdW5jdGlvbih0LG4pe3ZhciByPXNbdF0rbjtyZXR1cm4gdGhpcy5jb21tYW5kS2V5QmluZGluZ1tyXX0sdGhpcy5oYW5kbGVLZXlib2FyZD1mdW5jdGlvbihlLHQsbixyKXtpZihyPDApcmV0dXJuO3ZhciBpPXNbdF0rbixvPXRoaXMuY29tbWFuZEtleUJpbmRpbmdbaV07ZS4ka2V5Q2hhaW4mJihlLiRrZXlDaGFpbis9IiAiK2ksbz10aGlzLmNvbW1hbmRLZXlCaW5kaW5nW2UuJGtleUNoYWluXXx8byk7aWYobylpZihvPT0iY2hhaW5LZXlzInx8b1tvLmxlbmd0aC0xXT09ImNoYWluS2V5cyIpcmV0dXJuIGUuJGtleUNoYWluPWUuJGtleUNoYWlufHxpLHtjb21tYW5kOiJudWxsIn07aWYoZS4ka2V5Q2hhaW4paWYoISF0JiZ0IT00fHxuLmxlbmd0aCE9MSl7aWYodD09LTF8fHI+MCllLiRrZXlDaGFpbj0iIn1lbHNlIGUuJGtleUNoYWluPWUuJGtleUNoYWluLnNsaWNlKDAsLWkubGVuZ3RoLTEpO3JldHVybntjb21tYW5kOm99fSx0aGlzLmdldFN0YXR1c1RleHQ9ZnVuY3Rpb24oZSx0KXtyZXR1cm4gdC4ka2V5Q2hhaW58fCIifX0uY2FsbChvLnByb3RvdHlwZSksdC5IYXNoSGFuZGxlcj1vLHQuTXVsdGlIYXNoSGFuZGxlcj11fSksZGVmaW5lKCJhY2UvY29tbWFuZHMvY29tbWFuZF9tYW5hZ2VyIixbInJlcXVpcmUiLCJleHBvcnRzIiwibW9kdWxlIiwiYWNlL2xpYi9vb3AiLCJhY2Uva2V5Ym9hcmQvaGFzaF9oYW5kbGVyIiwiYWNlL2xpYi9ldmVudF9lbWl0dGVyIl0sZnVuY3Rpb24oZSx0LG4peyJ1c2Ugc3RyaWN0Ijt2YXIgcj1lKCIuLi9saWIvb29wIiksaT1lKCIuLi9rZXlib2FyZC9oYXNoX2hhbmRsZXIiKS5NdWx0aUhhc2hIYW5kbGVyLHM9ZSgiLi4vbGliL2V2ZW50X2VtaXR0ZXIiKS5FdmVudEVtaXR0ZXIsbz1mdW5jdGlvbihlLHQpe2kuY2FsbCh0aGlzLHQsZSksdGhpcy5ieU5hbWU9dGhpcy5jb21tYW5kcyx0aGlzLnNldERlZmF1bHRIYW5kbGVyKCJleGVjIixmdW5jdGlvbihlKXtyZXR1cm4gZS5hcmdzP2UuY29tbWFuZC5leGVjKGUuZWRpdG9yLGUuYXJncyxlLmV2ZW50LCExKTplLmNvbW1hbmQuZXhlYyhlLmVkaXRvcix7fSxlLmV2ZW50LCEwKX0pfTtyLmluaGVyaXRzKG8saSksZnVuY3Rpb24oKXtyLmltcGxlbWVudCh0aGlzLHMpLHRoaXMuZXhlYz1mdW5jdGlvbihlLHQsbil7aWYoQXJyYXkuaXNBcnJheShlKSl7Zm9yKHZhciByPWUubGVuZ3RoO3ItLTspaWYodGhpcy5leGVjKGVbcl0sdCxuKSlyZXR1cm4hMDtyZXR1cm4hMX10eXBlb2YgZT09InN0cmluZyImJihlPXRoaXMuY29tbWFuZHNbZV0pO2lmKCFlKXJldHVybiExO2lmKHQmJnQuJHJlYWRPbmx5JiYhZS5yZWFkT25seSlyZXR1cm4hMTtpZih0aGlzLiRjaGVja0NvbW1hbmRTdGF0ZSE9MCYmZS5pc0F2YWlsYWJsZSYmIWUuaXNBdmFpbGFibGUodCkpcmV0dXJuITE7dmFyIGk9e2VkaXRvcjp0LGNvbW1hbmQ6ZSxhcmdzOm59O3JldHVybiBpLnJldHVyblZhbHVlPXRoaXMuX2VtaXQoImV4ZWMiLGkpLHRoaXMuX3NpZ25hbCgiYWZ0ZXJFeGVjIixpKSxpLnJldHVyblZhbHVlPT09ITE/ITE6ITB9LHRoaXMudG9nZ2xlUmVjb3JkaW5nPWZ1bmN0aW9uKGUpe2lmKHRoaXMuJGluUmVwbGF5KXJldHVybjtyZXR1cm4gZSYmZS5fZW1pdCgiY2hhbmdlU3RhdHVzIiksdGhpcy5yZWNvcmRpbmc/KHRoaXMubWFjcm8ucG9wKCksdGhpcy5vZmYoImV4ZWMiLHRoaXMuJGFkZENvbW1hbmRUb01hY3JvKSx0aGlzLm1hY3JvLmxlbmd0aHx8KHRoaXMubWFjcm89dGhpcy5vbGRNYWNybyksdGhpcy5yZWNvcmRpbmc9ITEpOih0aGlzLiRhZGRDb21tYW5kVG9NYWNyb3x8KHRoaXMuJGFkZENvbW1hbmRUb01hY3JvPWZ1bmN0aW9uKGUpe3RoaXMubWFjcm8ucHVzaChbZS5jb21tYW5kLGUuYXJnc10pfS5iaW5kKHRoaXMpKSx0aGlzLm9sZE1hY3JvPXRoaXMubWFjcm8sdGhpcy5tYWNybz1bXSx0aGlzLm9uKCJleGVjIix0aGlzLiRhZGRDb21tYW5kVG9NYWNybyksdGhpcy5yZWNvcmRpbmc9ITApfSx0aGlzLnJlcGxheT1mdW5jdGlvbihlKXtpZih0aGlzLiRpblJlcGxheXx8IXRoaXMubWFjcm8pcmV0dXJuO2lmKHRoaXMucmVjb3JkaW5nKXJldHVybiB0aGlzLnRvZ2dsZVJlY29yZGluZyhlKTt0cnl7dGhpcy4kaW5SZXBsYXk9ITAsdGhpcy5tYWNyby5mb3JFYWNoKGZ1bmN0aW9uKHQpe3R5cGVvZiB0PT0ic3RyaW5nIj90aGlzLmV4ZWModCxlKTp0aGlzLmV4ZWModFswXSxlLHRbMV0pfSx0aGlzKX1maW5hbGx5e3RoaXMuJGluUmVwbGF5PSExfX0sdGhpcy50cmltTWFjcm89ZnVuY3Rpb24oZSl7cmV0dXJuIGUubWFwKGZ1bmN0aW9uKGUpe3JldHVybiB0eXBlb2YgZVswXSE9InN0cmluZyImJihlWzBdPWVbMF0ubmFtZSksZVsxXXx8KGU9ZVswXSksZX0pfX0uY2FsbChvLnByb3RvdHlwZSksdC5Db21tYW5kTWFuYWdlcj1vfSksZGVmaW5lKCJhY2UvY29tbWFuZHMvZGVmYXVsdF9jb21tYW5kcyIsWyJyZXF1aXJlIiwiZXhwb3J0cyIsIm1vZHVsZSIsImFjZS9saWIvbGFuZyIsImFjZS9jb25maWciLCJhY2UvcmFuZ2UiXSxmdW5jdGlvbihlLHQsbil7InVzZSBzdHJpY3QiO2Z1bmN0aW9uIG8oZSx0KXtyZXR1cm57d2luOmUsbWFjOnR9fXZhciByPWUoIi4uL2xpYi9sYW5nIiksaT1lKCIuLi9jb25maWciKSxzPWUoIi4uL3JhbmdlIikuUmFuZ2U7dC5jb21tYW5kcz1be25hbWU6InNob3dTZXR0aW5nc01lbnUiLGRlc2NyaXB0aW9uOiJTaG93IHNldHRpbmdzIG1lbnUiLGJpbmRLZXk6bygiQ3RybC0sIiwiQ29tbWFuZC0sIiksZXhlYzpmdW5jdGlvbihlKXtpLmxvYWRNb2R1bGUoImFjZS9leHQvc2V0dGluZ3NfbWVudSIsZnVuY3Rpb24odCl7dC5pbml0KGUpLGUuc2hvd1NldHRpbmdzTWVudSgpfSl9LHJlYWRPbmx5OiEwfSx7bmFtZToiZ29Ub05leHRFcnJvciIsZGVzY3JpcHRpb246IkdvIHRvIG5leHQgZXJyb3IiLGJpbmRLZXk6bygiQWx0LUUiLCJGNCIpLGV4ZWM6ZnVuY3Rpb24oZSl7aS5sb2FkTW9kdWxlKCIuL2V4dC9lcnJvcl9tYXJrZXIiLGZ1bmN0aW9uKHQpe3Quc2hvd0Vycm9yTWFya2VyKGUsMSl9KX0sc2Nyb2xsSW50b1ZpZXc6ImFuaW1hdGUiLHJlYWRPbmx5OiEwfSx7bmFtZToiZ29Ub1ByZXZpb3VzRXJyb3IiLGRlc2NyaXB0aW9uOiJHbyB0byBwcmV2aW91cyBlcnJvciIsYmluZEtleTpvKCJBbHQtU2hpZnQtRSIsIlNoaWZ0LUY0IiksZXhlYzpmdW5jdGlvbihlKXtpLmxvYWRNb2R1bGUoIi4vZXh0L2Vycm9yX21hcmtlciIsZnVuY3Rpb24odCl7dC5zaG93RXJyb3JNYXJrZXIoZSwtMSl9KX0sc2Nyb2xsSW50b1ZpZXc6ImFuaW1hdGUiLHJlYWRPbmx5OiEwfSx7bmFtZToic2VsZWN0YWxsIixkZXNjcmlwdGlvbjoiU2VsZWN0IGFsbCIsYmluZEtleTpvKCJDdHJsLUEiLCJDb21tYW5kLUEiKSxleGVjOmZ1bmN0aW9uKGUpe2Uuc2VsZWN0QWxsKCl9LHJlYWRPbmx5OiEwfSx7bmFtZToiY2VudGVyc2VsZWN0aW9uIixkZXNjcmlwdGlvbjoiQ2VudGVyIHNlbGVjdGlvbiIsYmluZEtleTpvKG51bGwsIkN0cmwtTCIpLGV4ZWM6ZnVuY3Rpb24oZSl7ZS5jZW50ZXJTZWxlY3Rpb24oKX0scmVhZE9ubHk6ITB9LHtuYW1lOiJnb3RvbGluZSIsZGVzY3JpcHRpb246IkdvIHRvIGxpbmUuLi4iLGJpbmRLZXk6bygiQ3RybC1MIiwiQ29tbWFuZC1MIiksZXhlYzpmdW5jdGlvbihlLHQpe3R5cGVvZiB0PT0ibnVtYmVyIiYmIWlzTmFOKHQpJiZlLmdvdG9MaW5lKHQpLGUucHJvbXB0KHskdHlwZToiZ290b0xpbmUifSl9LHJlYWRPbmx5OiEwfSx7bmFtZToiZm9sZCIsYmluZEtleTpvKCJBbHQtTHxDdHJsLUYxIiwiQ29tbWFuZC1BbHQtTHxDb21tYW5kLUYxIiksZXhlYzpmdW5jdGlvbihlKXtlLnNlc3Npb24udG9nZ2xlRm9sZCghMSl9LG11bHRpU2VsZWN0QWN0aW9uOiJmb3JFYWNoIixzY3JvbGxJbnRvVmlldzoiY2VudGVyIixyZWFkT25seTohMH0se25hbWU6InVuZm9sZCIsYmluZEtleTpvKCJBbHQtU2hpZnQtTHxDdHJsLVNoaWZ0LUYxIiwiQ29tbWFuZC1BbHQtU2hpZnQtTHxDb21tYW5kLVNoaWZ0LUYxIiksZXhlYzpmdW5jdGlvbihlKXtlLnNlc3Npb24udG9nZ2xlRm9sZCghMCl9LG11bHRpU2VsZWN0QWN0aW9uOiJmb3JFYWNoIixzY3JvbGxJbnRvVmlldzoiY2VudGVyIixyZWFkT25seTohMH0se25hbWU6InRvZ2dsZUZvbGRXaWRnZXQiLGRlc2NyaXB0aW9uOiJUb2dnbGUgZm9sZCB3aWRnZXQiLGJpbmRLZXk6bygiRjIiLCJGMiIpLGV4ZWM6ZnVuY3Rpb24oZSl7ZS5zZXNzaW9uLnRvZ2dsZUZvbGRXaWRnZXQoKX0sbXVsdGlTZWxlY3RBY3Rpb246ImZvckVhY2giLHNjcm9sbEludG9WaWV3OiJjZW50ZXIiLHJlYWRPbmx5OiEwfSx7bmFtZToidG9nZ2xlUGFyZW50Rm9sZFdpZGdldCIsZGVzY3JpcHRpb246IlRvZ2dsZSBwYXJlbnQgZm9sZCB3aWRnZXQiLGJpbmRLZXk6bygiQWx0LUYyIiwiQWx0LUYyIiksZXhlYzpmdW5jdGlvbihlKXtlLnNlc3Npb24udG9nZ2xlRm9sZFdpZGdldCghMCl9LG11bHRpU2VsZWN0QWN0aW9uOiJmb3JFYWNoIixzY3JvbGxJbnRvVmlldzoiY2VudGVyIixyZWFkT25seTohMH0se25hbWU6ImZvbGRhbGwiLGRlc2NyaXB0aW9uOiJGb2xkIGFsbCIsYmluZEtleTpvKG51bGwsIkN0cmwtQ29tbWFuZC1PcHRpb24tMCIpLGV4ZWM6ZnVuY3Rpb24oZSl7ZS5zZXNzaW9uLmZvbGRBbGwoKX0sc2Nyb2xsSW50b1ZpZXc6ImNlbnRlciIscmVhZE9ubHk6ITB9LHtuYW1lOiJmb2xkQWxsQ29tbWVudHMiLGRlc2NyaXB0aW9uOiJGb2xkIGFsbCBjb21tZW50cyIsYmluZEtleTpvKG51bGwsIkN0cmwtQ29tbWFuZC1PcHRpb24tMCIpLGV4ZWM6ZnVuY3Rpb24oZSl7ZS5zZXNzaW9uLmZvbGRBbGxDb21tZW50cygpfSxzY3JvbGxJbnRvVmlldzoiY2VudGVyIixyZWFkT25seTohMH0se25hbWU6ImZvbGRPdGhlciIsZGVzY3JpcHRpb246IkZvbGQgb3RoZXIiLGJpbmRLZXk6bygiQWx0LTAiLCJDb21tYW5kLU9wdGlvbi0wIiksZXhlYzpmdW5jdGlvbihlKXtlLnNlc3Npb24uZm9sZEFsbCgpLGUuc2Vzc2lvbi51bmZvbGQoZS5zZWxlY3Rpb24uZ2V0QWxsUmFuZ2VzKCkpfSxzY3JvbGxJbnRvVmlldzoiY2VudGVyIixyZWFkT25seTohMH0se25hbWU6InVuZm9sZGFsbCIsZGVzY3JpcHRpb246IlVuZm9sZCBhbGwiLGJpbmRLZXk6bygiQWx0LVNoaWZ0LTAiLCJDb21tYW5kLU9wdGlvbi1TaGlmdC0wIiksZXhlYzpmdW5jdGlvbihlKXtlLnNlc3Npb24udW5mb2xkKCl9LHNjcm9sbEludG9WaWV3OiJjZW50ZXIiLHJlYWRPbmx5OiEwfSx7bmFtZToiZmluZG5leHQiLGRlc2NyaXB0aW9uOiJGaW5kIG5leHQiLGJpbmRLZXk6bygiQ3RybC1LIiwiQ29tbWFuZC1HIiksZXhlYzpmdW5jdGlvbihlKXtlLmZpbmROZXh0KCl9LG11bHRpU2VsZWN0QWN0aW9uOiJmb3JFYWNoIixzY3JvbGxJbnRvVmlldzoiY2VudGVyIixyZWFkT25seTohMH0se25hbWU6ImZpbmRwcmV2aW91cyIsZGVzY3JpcHRpb246IkZpbmQgcHJldmlvdXMiLGJpbmRLZXk6bygiQ3RybC1TaGlmdC1LIiwiQ29tbWFuZC1TaGlmdC1HIiksZXhlYzpmdW5jdGlvbihlKXtlLmZpbmRQcmV2aW91cygpfSxtdWx0aVNlbGVjdEFjdGlvbjoiZm9yRWFjaCIsc2Nyb2xsSW50b1ZpZXc6ImNlbnRlciIscmVhZE9ubHk6ITB9LHtuYW1lOiJzZWxlY3RPckZpbmROZXh0IixkZXNjcmlwdGlvbjoiU2VsZWN0IG9yIGZpbmQgbmV4dCIsYmluZEtleTpvKCJBbHQtSyIsIkN0cmwtRyIpLGV4ZWM6ZnVuY3Rpb24oZSl7ZS5zZWxlY3Rpb24uaXNFbXB0eSgpP2Uuc2VsZWN0aW9uLnNlbGVjdFdvcmQoKTplLmZpbmROZXh0KCl9LHJlYWRPbmx5OiEwfSx7bmFtZToic2VsZWN0T3JGaW5kUHJldmlvdXMiLGRlc2NyaXB0aW9uOiJTZWxlY3Qgb3IgZmluZCBwcmV2aW91cyIsYmluZEtleTpvKCJBbHQtU2hpZnQtSyIsIkN0cmwtU2hpZnQtRyIpLGV4ZWM6ZnVuY3Rpb24oZSl7ZS5zZWxlY3Rpb24uaXNFbXB0eSgpP2Uuc2VsZWN0aW9uLnNlbGVjdFdvcmQoKTplLmZpbmRQcmV2aW91cygpfSxyZWFkT25seTohMH0se25hbWU6ImZpbmQiLGRlc2NyaXB0aW9uOiJGaW5kIixiaW5kS2V5Om8oIkN0cmwtRiIsIkNvbW1hbmQtRiIpLGV4ZWM6ZnVuY3Rpb24oZSl7aS5sb2FkTW9kdWxlKCJhY2UvZXh0L3NlYXJjaGJveCIsZnVuY3Rpb24odCl7dC5TZWFyY2goZSl9KX0scmVhZE9ubHk6ITB9LHtuYW1lOiJvdmVyd3JpdGUiLGRlc2NyaXB0aW9uOiJPdmVyd3JpdGUiLGJpbmRLZXk6Ikluc2VydCIsZXhlYzpmdW5jdGlvbihlKXtlLnRvZ2dsZU92ZXJ3cml0ZSgpfSxyZWFkT25seTohMH0se25hbWU6InNlbGVjdHRvc3RhcnQiLGRlc2NyaXB0aW9uOiJTZWxlY3QgdG8gc3RhcnQiLGJpbmRLZXk6bygiQ3RybC1TaGlmdC1Ib21lIiwiQ29tbWFuZC1TaGlmdC1Ib21lfENvbW1hbmQtU2hpZnQtVXAiKSxleGVjOmZ1bmN0aW9uKGUpe2UuZ2V0U2VsZWN0aW9uKCkuc2VsZWN0RmlsZVN0YXJ0KCl9LG11bHRpU2VsZWN0QWN0aW9uOiJmb3JFYWNoIixyZWFkT25seTohMCxzY3JvbGxJbnRvVmlldzoiYW5pbWF0ZSIsYWNlQ29tbWFuZEdyb3VwOiJmaWxlSnVtcCJ9LHtuYW1lOiJnb3Rvc3RhcnQiLGRlc2NyaXB0aW9uOiJHbyB0byBzdGFydCIsYmluZEtleTpvKCJDdHJsLUhvbWUiLCJDb21tYW5kLUhvbWV8Q29tbWFuZC1VcCIpLGV4ZWM6ZnVuY3Rpb24oZSl7ZS5uYXZpZ2F0ZUZpbGVTdGFydCgpfSxtdWx0aVNlbGVjdEFjdGlvbjoiZm9yRWFjaCIscmVhZE9ubHk6ITAsc2Nyb2xsSW50b1ZpZXc6ImFuaW1hdGUiLGFjZUNvbW1hbmRHcm91cDoiZmlsZUp1bXAifSx7bmFtZToic2VsZWN0dXAiLGRlc2NyaXB0aW9uOiJTZWxlY3QgdXAiLGJpbmRLZXk6bygiU2hpZnQtVXAiLCJTaGlmdC1VcHxDdHJsLVNoaWZ0LVAiKSxleGVjOmZ1bmN0aW9uKGUpe2UuZ2V0U2VsZWN0aW9uKCkuc2VsZWN0VXAoKX0sbXVsdGlTZWxlY3RBY3Rpb246ImZvckVhY2giLHNjcm9sbEludG9WaWV3OiJjdXJzb3IiLHJlYWRPbmx5OiEwfSx7bmFtZToiZ29saW5ldXAiLGRlc2NyaXB0aW9uOiJHbyBsaW5lIHVwIixiaW5kS2V5Om8oIlVwIiwiVXB8Q3RybC1QIiksZXhlYzpmdW5jdGlvbihlLHQpe2UubmF2aWdhdGVVcCh0LnRpbWVzKX0sbXVsdGlTZWxlY3RBY3Rpb246ImZvckVhY2giLHNjcm9sbEludG9WaWV3OiJjdXJzb3IiLHJlYWRPbmx5OiEwfSx7bmFtZToic2VsZWN0dG9lbmQiLGRlc2NyaXB0aW9uOiJTZWxlY3QgdG8gZW5kIixiaW5kS2V5Om8oIkN0cmwtU2hpZnQtRW5kIiwiQ29tbWFuZC1TaGlmdC1FbmR8Q29tbWFuZC1TaGlmdC1Eb3duIiksZXhlYzpmdW5jdGlvbihlKXtlLmdldFNlbGVjdGlvbigpLnNlbGVjdEZpbGVFbmQoKX0sbXVsdGlTZWxlY3RBY3Rpb246ImZvckVhY2giLHJlYWRPbmx5OiEwLHNjcm9sbEludG9WaWV3OiJhbmltYXRlIixhY2VDb21tYW5kR3JvdXA6ImZpbGVKdW1wIn0se25hbWU6ImdvdG9lbmQiLGRlc2NyaXB0aW9uOiJHbyB0byBlbmQiLGJpbmRLZXk6bygiQ3RybC1FbmQiLCJDb21tYW5kLUVuZHxDb21tYW5kLURvd24iKSxleGVjOmZ1bmN0aW9uKGUpe2UubmF2aWdhdGVGaWxlRW5kKCl9LG11bHRpU2VsZWN0QWN0aW9uOiJmb3JFYWNoIixyZWFkT25seTohMCxzY3JvbGxJbnRvVmlldzoiYW5pbWF0ZSIsYWNlQ29tbWFuZEdyb3VwOiJmaWxlSnVtcCJ9LHtuYW1lOiJzZWxlY3Rkb3duIixkZXNjcmlwdGlvbjoiU2VsZWN0IGRvd24iLGJpbmRLZXk6bygiU2hpZnQtRG93biIsIlNoaWZ0LURvd258Q3RybC1TaGlmdC1OIiksZXhlYzpmdW5jdGlvbihlKXtlLmdldFNlbGVjdGlvbigpLnNlbGVjdERvd24oKX0sbXVsdGlTZWxlY3RBY3Rpb246ImZvckVhY2giLHNjcm9sbEludG9WaWV3OiJjdXJzb3IiLHJlYWRPbmx5OiEwfSx7bmFtZToiZ29saW5lZG93biIsZGVzY3JpcHRpb246IkdvIGxpbmUgZG93biIsYmluZEtleTpvKCJEb3duIiwiRG93bnxDdHJsLU4iKSxleGVjOmZ1bmN0aW9uKGUsdCl7ZS5uYXZpZ2F0ZURvd24odC50aW1lcyl9LG11bHRpU2VsZWN0QWN0aW9uOiJmb3JFYWNoIixzY3JvbGxJbnRvVmlldzoiY3Vyc29yIixyZWFkT25seTohMH0se25hbWU6InNlbGVjdHdvcmRsZWZ0IixkZXNjcmlwdGlvbjoiU2VsZWN0IHdvcmQgbGVmdCIsYmluZEtleTpvKCJDdHJsLVNoaWZ0LUxlZnQiLCJPcHRpb24tU2hpZnQtTGVmdCIpLGV4ZWM6ZnVuY3Rpb24oZSl7ZS5nZXRTZWxlY3Rpb24oKS5zZWxlY3RXb3JkTGVmdCgpfSxtdWx0aVNlbGVjdEFjdGlvbjoiZm9yRWFjaCIsc2Nyb2xsSW50b1ZpZXc6ImN1cnNvciIscmVhZE9ubHk6ITB9LHtuYW1lOiJnb3Rvd29yZGxlZnQiLGRlc2NyaXB0aW9uOiJHbyB0byB3b3JkIGxlZnQiLGJpbmRLZXk6bygiQ3RybC1MZWZ0IiwiT3B0aW9uLUxlZnQiKSxleGVjOmZ1bmN0aW9uKGUpe2UubmF2aWdhdGVXb3JkTGVmdCgpfSxtdWx0aVNlbGVjdEFjdGlvbjoiZm9yRWFjaCIsc2Nyb2xsSW50b1ZpZXc6ImN1cnNvciIscmVhZE9ubHk6ITB9LHtuYW1lOiJzZWxlY3R0b2xpbmVzdGFydCIsZGVzY3JpcHRpb246IlNlbGVjdCB0byBsaW5lIHN0YXJ0IixiaW5kS2V5Om8oIkFsdC1TaGlmdC1MZWZ0IiwiQ29tbWFuZC1TaGlmdC1MZWZ0fEN0cmwtU2hpZnQtQSIpLGV4ZWM6ZnVuY3Rpb24oZSl7ZS5nZXRTZWxlY3Rpb24oKS5zZWxlY3RMaW5lU3RhcnQoKX0sbXVsdGlTZWxlY3RBY3Rpb246ImZvckVhY2giLHNjcm9sbEludG9WaWV3OiJjdXJzb3IiLHJlYWRPbmx5OiEwfSx7bmFtZToiZ290b2xpbmVzdGFydCIsZGVzY3JpcHRpb246IkdvIHRvIGxpbmUgc3RhcnQiLGJpbmRLZXk6bygiQWx0LUxlZnR8SG9tZSIsIkNvbW1hbmQtTGVmdHxIb21lfEN0cmwtQSIpLGV4ZWM6ZnVuY3Rpb24oZSl7ZS5uYXZpZ2F0ZUxpbmVTdGFydCgpfSxtdWx0aVNlbGVjdEFjdGlvbjoiZm9yRWFjaCIsc2Nyb2xsSW50b1ZpZXc6ImN1cnNvciIscmVhZE9ubHk6ITB9LHtuYW1lOiJzZWxlY3RsZWZ0IixkZXNjcmlwdGlvbjoiU2VsZWN0IGxlZnQiLGJpbmRLZXk6bygiU2hpZnQtTGVmdCIsIlNoaWZ0LUxlZnR8Q3RybC1TaGlmdC1CIiksZXhlYzpmdW5jdGlvbihlKXtlLmdldFNlbGVjdGlvbigpLnNlbGVjdExlZnQoKX0sbXVsdGlTZWxlY3RBY3Rpb246ImZvckVhY2giLHNjcm9sbEludG9WaWV3OiJjdXJzb3IiLHJlYWRPbmx5OiEwfSx7bmFtZToiZ290b2xlZnQiLGRlc2NyaXB0aW9uOiJHbyB0byBsZWZ0IixiaW5kS2V5Om8oIkxlZnQiLCJMZWZ0fEN0cmwtQiIpLGV4ZWM6ZnVuY3Rpb24oZSx0KXtlLm5hdmlnYXRlTGVmdCh0LnRpbWVzKX0sbXVsdGlTZWxlY3RBY3Rpb246ImZvckVhY2giLHNjcm9sbEludG9WaWV3OiJjdXJzb3IiLHJlYWRPbmx5OiEwfSx7bmFtZToic2VsZWN0d29yZHJpZ2h0IixkZXNjcmlwdGlvbjoiU2VsZWN0IHdvcmQgcmlnaHQiLGJpbmRLZXk6bygiQ3RybC1TaGlmdC1SaWdodCIsIk9wdGlvbi1TaGlmdC1SaWdodCIpLGV4ZWM6ZnVuY3Rpb24oZSl7ZS5nZXRTZWxlY3Rpb24oKS5zZWxlY3RXb3JkUmlnaHQoKX0sbXVsdGlTZWxlY3RBY3Rpb246ImZvckVhY2giLHNjcm9sbEludG9WaWV3OiJjdXJzb3IiLHJlYWRPbmx5OiEwfSx7bmFtZToiZ290b3dvcmRyaWdodCIsZGVzY3JpcHRpb246IkdvIHRvIHdvcmQgcmlnaHQiLGJpbmRLZXk6bygiQ3RybC1SaWdodCIsIk9wdGlvbi1SaWdodCIpLGV4ZWM6ZnVuY3Rpb24oZSl7ZS5uYXZpZ2F0ZVdvcmRSaWdodCgpfSxtdWx0aVNlbGVjdEFjdGlvbjoiZm9yRWFjaCIsc2Nyb2xsSW50b1ZpZXc6ImN1cnNvciIscmVhZE9ubHk6ITB9LHtuYW1lOiJzZWxlY3R0b2xpbmVlbmQiLGRlc2NyaXB0aW9uOiJTZWxlY3QgdG8gbGluZSBlbmQiLGJpbmRLZXk6bygiQWx0LVNoaWZ0LVJpZ2h0IiwiQ29tbWFuZC1TaGlmdC1SaWdodHxTaGlmdC1FbmR8Q3RybC1TaGlmdC1FIiksZXhlYzpmdW5jdGlvbihlKXtlLmdldFNlbGVjdGlvbigpLnNlbGVjdExpbmVFbmQoKX0sbXVsdGlTZWxlY3RBY3Rpb246ImZvckVhY2giLHNjcm9sbEludG9WaWV3OiJjdXJzb3IiLHJlYWRPbmx5OiEwfSx7bmFtZToiZ290b2xpbmVlbmQiLGRlc2NyaXB0aW9uOiJHbyB0byBsaW5lIGVuZCIsYmluZEtleTpvKCJBbHQtUmlnaHR8RW5kIiwiQ29tbWFuZC1SaWdodHxFbmR8Q3RybC1FIiksZXhlYzpmdW5jdGlvbihlKXtlLm5hdmlnYXRlTGluZUVuZCgpfSxtdWx0aVNlbGVjdEFjdGlvbjoiZm9yRWFjaCIsc2Nyb2xsSW50b1ZpZXc6ImN1cnNvciIscmVhZE9ubHk6ITB9LHtuYW1lOiJzZWxlY3RyaWdodCIsZGVzY3JpcHRpb246IlNlbGVjdCByaWdodCIsYmluZEtleTpvKCJTaGlmdC1SaWdodCIsIlNoaWZ0LVJpZ2h0IiksZXhlYzpmdW5jdGlvbihlKXtlLmdldFNlbGVjdGlvbigpLnNlbGVjdFJpZ2h0KCl9LG11bHRpU2VsZWN0QWN0aW9uOiJmb3JFYWNoIixzY3JvbGxJbnRvVmlldzoiY3Vyc29yIixyZWFkT25seTohMH0se25hbWU6ImdvdG9yaWdodCIsZGVzY3JpcHRpb246IkdvIHRvIHJpZ2h0IixiaW5kS2V5Om8oIlJpZ2h0IiwiUmlnaHR8Q3RybC1GIiksZXhlYzpmdW5jdGlvbihlLHQpe2UubmF2aWdhdGVSaWdodCh0LnRpbWVzKX0sbXVsdGlTZWxlY3RBY3Rpb246ImZvckVhY2giLHNjcm9sbEludG9WaWV3OiJjdXJzb3IiLHJlYWRPbmx5OiEwfSx7bmFtZToic2VsZWN0cGFnZWRvd24iLGRlc2NyaXB0aW9uOiJTZWxlY3QgcGFnZSBkb3duIixiaW5kS2V5OiJTaGlmdC1QYWdlRG93biIsZXhlYzpmdW5jdGlvbihlKXtlLnNlbGVjdFBhZ2VEb3duKCl9LHJlYWRPbmx5OiEwfSx7bmFtZToicGFnZWRvd24iLGRlc2NyaXB0aW9uOiJQYWdlIGRvd24iLGJpbmRLZXk6byhudWxsLCJPcHRpb24tUGFnZURvd24iKSxleGVjOmZ1bmN0aW9uKGUpe2Uuc2Nyb2xsUGFnZURvd24oKX0scmVhZE9ubHk6ITB9LHtuYW1lOiJnb3RvcGFnZWRvd24iLGRlc2NyaXB0aW9uOiJHbyB0byBwYWdlIGRvd24iLGJpbmRLZXk6bygiUGFnZURvd24iLCJQYWdlRG93bnxDdHJsLVYiKSxleGVjOmZ1bmN0aW9uKGUpe2UuZ290b1BhZ2VEb3duKCl9LHJlYWRPbmx5OiEwfSx7bmFtZToic2VsZWN0cGFnZXVwIixkZXNjcmlwdGlvbjoiU2VsZWN0IHBhZ2UgdXAiLGJpbmRLZXk6IlNoaWZ0LVBhZ2VVcCIsZXhlYzpmdW5jdGlvbihlKXtlLnNlbGVjdFBhZ2VVcCgpfSxyZWFkT25seTohMH0se25hbWU6InBhZ2V1cCIsZGVzY3JpcHRpb246IlBhZ2UgdXAiLGJpbmRLZXk6byhudWxsLCJPcHRpb24tUGFnZVVwIiksZXhlYzpmdW5jdGlvbihlKXtlLnNjcm9sbFBhZ2VVcCgpfSxyZWFkT25seTohMH0se25hbWU6ImdvdG9wYWdldXAiLGRlc2NyaXB0aW9uOiJHbyB0byBwYWdlIHVwIixiaW5kS2V5OiJQYWdlVXAiLGV4ZWM6ZnVuY3Rpb24oZSl7ZS5nb3RvUGFnZVVwKCl9LHJlYWRPbmx5OiEwfSx7bmFtZToic2Nyb2xsdXAiLGRlc2NyaXB0aW9uOiJTY3JvbGwgdXAiLGJpbmRLZXk6bygiQ3RybC1VcCIsbnVsbCksZXhlYzpmdW5jdGlvbihlKXtlLnJlbmRlcmVyLnNjcm9sbEJ5KDAsLTIqZS5yZW5kZXJlci5sYXllckNvbmZpZy5saW5lSGVpZ2h0KX0scmVhZE9ubHk6ITB9LHtuYW1lOiJzY3JvbGxkb3duIixkZXNjcmlwdGlvbjoiU2Nyb2xsIGRvd24iLGJpbmRLZXk6bygiQ3RybC1Eb3duIixudWxsKSxleGVjOmZ1bmN0aW9uKGUpe2UucmVuZGVyZXIuc2Nyb2xsQnkoMCwyKmUucmVuZGVyZXIubGF5ZXJDb25maWcubGluZUhlaWdodCl9LHJlYWRPbmx5OiEwfSx7bmFtZToic2VsZWN0bGluZXN0YXJ0IixkZXNjcmlwdGlvbjoiU2VsZWN0IGxpbmUgc3RhcnQiLGJpbmRLZXk6IlNoaWZ0LUhvbWUiLGV4ZWM6ZnVuY3Rpb24oZSl7ZS5nZXRTZWxlY3Rpb24oKS5zZWxlY3RMaW5lU3RhcnQoKX0sbXVsdGlTZWxlY3RBY3Rpb246ImZvckVhY2giLHNjcm9sbEludG9WaWV3OiJjdXJzb3IiLHJlYWRPbmx5OiEwfSx7bmFtZToic2VsZWN0bGluZWVuZCIsZGVzY3JpcHRpb246IlNlbGVjdCBsaW5lIGVuZCIsYmluZEtleToiU2hpZnQtRW5kIixleGVjOmZ1bmN0aW9uKGUpe2UuZ2V0U2VsZWN0aW9uKCkuc2VsZWN0TGluZUVuZCgpfSxtdWx0aVNlbGVjdEFjdGlvbjoiZm9yRWFjaCIsc2Nyb2xsSW50b1ZpZXc6ImN1cnNvciIscmVhZE9ubHk6ITB9LHtuYW1lOiJ0b2dnbGVyZWNvcmRpbmciLGRlc2NyaXB0aW9uOiJUb2dnbGUgcmVjb3JkaW5nIixiaW5kS2V5Om8oIkN0cmwtQWx0LUUiLCJDb21tYW5kLU9wdGlvbi1FIiksZXhlYzpmdW5jdGlvbihlKXtlLmNvbW1hbmRzLnRvZ2dsZVJlY29yZGluZyhlKX0scmVhZE9ubHk6ITB9LHtuYW1lOiJyZXBsYXltYWNybyIsZGVzY3JpcHRpb246IlJlcGxheSBtYWNybyIsYmluZEtleTpvKCJDdHJsLVNoaWZ0LUUiLCJDb21tYW5kLVNoaWZ0LUUiKSxleGVjOmZ1bmN0aW9uKGUpe2UuY29tbWFuZHMucmVwbGF5KGUpfSxyZWFkT25seTohMH0se25hbWU6Imp1bXB0b21hdGNoaW5nIixkZXNjcmlwdGlvbjoiSnVtcCB0byBtYXRjaGluZyIsYmluZEtleTpvKCJDdHJsLVxcfEN0cmwtUCIsIkNvbW1hbmQtXFwiKSxleGVjOmZ1bmN0aW9uKGUpe2UuanVtcFRvTWF0Y2hpbmcoKX0sbXVsdGlTZWxlY3RBY3Rpb246ImZvckVhY2giLHNjcm9sbEludG9WaWV3OiJhbmltYXRlIixyZWFkT25seTohMH0se25hbWU6InNlbGVjdHRvbWF0Y2hpbmciLGRlc2NyaXB0aW9uOiJTZWxlY3QgdG8gbWF0Y2hpbmciLGJpbmRLZXk6bygiQ3RybC1TaGlmdC1cXHxDdHJsLVNoaWZ0LVAiLCJDb21tYW5kLVNoaWZ0LVxcIiksZXhlYzpmdW5jdGlvbihlKXtlLmp1bXBUb01hdGNoaW5nKCEwKX0sbXVsdGlTZWxlY3RBY3Rpb246ImZvckVhY2giLHNjcm9sbEludG9WaWV3OiJhbmltYXRlIixyZWFkT25seTohMH0se25hbWU6ImV4cGFuZFRvTWF0Y2hpbmciLGRlc2NyaXB0aW9uOiJFeHBhbmQgdG8gbWF0Y2hpbmciLGJpbmRLZXk6bygiQ3RybC1TaGlmdC1NIiwiQ3RybC1TaGlmdC1NIiksZXhlYzpmdW5jdGlvbihlKXtlLmp1bXBUb01hdGNoaW5nKCEwLCEwKX0sbXVsdGlTZWxlY3RBY3Rpb246ImZvckVhY2giLHNjcm9sbEludG9WaWV3OiJhbmltYXRlIixyZWFkT25seTohMH0se25hbWU6InBhc3NLZXlzVG9Ccm93c2VyIixkZXNjcmlwdGlvbjoiUGFzcyBrZXlzIHRvIGJyb3dzZXIiLGJpbmRLZXk6byhudWxsLG51bGwpLGV4ZWM6ZnVuY3Rpb24oKXt9LHBhc3NFdmVudDohMCxyZWFkT25seTohMH0se25hbWU6ImNvcHkiLGRlc2NyaXB0aW9uOiJDb3B5IixleGVjOmZ1bmN0aW9uKGUpe30scmVhZE9ubHk6ITB9LHtuYW1lOiJjdXQiLGRlc2NyaXB0aW9uOiJDdXQiLGV4ZWM6ZnVuY3Rpb24oZSl7dmFyIHQ9ZS4kY29weVdpdGhFbXB0eVNlbGVjdGlvbiYmZS5zZWxlY3Rpb24uaXNFbXB0eSgpLG49dD9lLnNlbGVjdGlvbi5nZXRMaW5lUmFuZ2UoKTplLnNlbGVjdGlvbi5nZXRSYW5nZSgpO2UuX2VtaXQoImN1dCIsbiksbi5pc0VtcHR5KCl8fGUuc2Vzc2lvbi5yZW1vdmUobiksZS5jbGVhclNlbGVjdGlvbigpfSxzY3JvbGxJbnRvVmlldzoiY3Vyc29yIixtdWx0aVNlbGVjdEFjdGlvbjoiZm9yRWFjaCJ9LHtuYW1lOiJwYXN0ZSIsZGVzY3JpcHRpb246IlBhc3RlIixleGVjOmZ1bmN0aW9uKGUsdCl7ZS4kaGFuZGxlUGFzdGUodCl9LHNjcm9sbEludG9WaWV3OiJjdXJzb3IifSx7bmFtZToicmVtb3ZlbGluZSIsZGVzY3JpcHRpb246IlJlbW92ZSBsaW5lIixiaW5kS2V5Om8oIkN0cmwtRCIsIkNvbW1hbmQtRCIpLGV4ZWM6ZnVuY3Rpb24oZSl7ZS5yZW1vdmVMaW5lcygpfSxzY3JvbGxJbnRvVmlldzoiY3Vyc29yIixtdWx0aVNlbGVjdEFjdGlvbjoiZm9yRWFjaExpbmUifSx7bmFtZToiZHVwbGljYXRlU2VsZWN0aW9uIixkZXNjcmlwdGlvbjoiRHVwbGljYXRlIHNlbGVjdGlvbiIsYmluZEtleTpvKCJDdHJsLVNoaWZ0LUQiLCJDb21tYW5kLVNoaWZ0LUQiKSxleGVjOmZ1bmN0aW9uKGUpe2UuZHVwbGljYXRlU2VsZWN0aW9uKCl9LHNjcm9sbEludG9WaWV3OiJjdXJzb3IiLG11bHRpU2VsZWN0QWN0aW9uOiJmb3JFYWNoIn0se25hbWU6InNvcnRsaW5lcyIsZGVzY3JpcHRpb246IlNvcnQgbGluZXMiLGJpbmRLZXk6bygiQ3RybC1BbHQtUyIsIkNvbW1hbmQtQWx0LVMiKSxleGVjOmZ1bmN0aW9uKGUpe2Uuc29ydExpbmVzKCl9LHNjcm9sbEludG9WaWV3OiJzZWxlY3Rpb24iLG11bHRpU2VsZWN0QWN0aW9uOiJmb3JFYWNoTGluZSJ9LHtuYW1lOiJ0b2dnbGVjb21tZW50IixkZXNjcmlwdGlvbjoiVG9nZ2xlIGNvbW1lbnQiLGJpbmRLZXk6bygiQ3RybC0vIiwiQ29tbWFuZC0vIiksZXhlYzpmdW5jdGlvbihlKXtlLnRvZ2dsZUNvbW1lbnRMaW5lcygpfSxtdWx0aVNlbGVjdEFjdGlvbjoiZm9yRWFjaExpbmUiLHNjcm9sbEludG9WaWV3OiJzZWxlY3Rpb25QYXJ0In0se25hbWU6InRvZ2dsZUJsb2NrQ29tbWVudCIsZGVzY3JpcHRpb246IlRvZ2dsZSBibG9jayBjb21tZW50IixiaW5kS2V5Om8oIkN0cmwtU2hpZnQtLyIsIkNvbW1hbmQtU2hpZnQtLyIpLGV4ZWM6ZnVuY3Rpb24oZSl7ZS50b2dnbGVCbG9ja0NvbW1lbnQoKX0sbXVsdGlTZWxlY3RBY3Rpb246ImZvckVhY2giLHNjcm9sbEludG9WaWV3OiJzZWxlY3Rpb25QYXJ0In0se25hbWU6Im1vZGlmeU51bWJlclVwIixkZXNjcmlwdGlvbjoiTW9kaWZ5IG51bWJlciB1cCIsYmluZEtleTpvKCJDdHJsLVNoaWZ0LVVwIiwiQWx0LVNoaWZ0LVVwIiksZXhlYzpmdW5jdGlvbihlKXtlLm1vZGlmeU51bWJlcigxKX0sc2Nyb2xsSW50b1ZpZXc6ImN1cnNvciIsbXVsdGlTZWxlY3RBY3Rpb246ImZvckVhY2gifSx7bmFtZToibW9kaWZ5TnVtYmVyRG93biIsZGVzY3JpcHRpb246Ik1vZGlmeSBudW1iZXIgZG93biIsYmluZEtleTpvKCJDdHJsLVNoaWZ0LURvd24iLCJBbHQtU2hpZnQtRG93biIpLGV4ZWM6ZnVuY3Rpb24oZSl7ZS5tb2RpZnlOdW1iZXIoLTEpfSxzY3JvbGxJbnRvVmlldzoiY3Vyc29yIixtdWx0aVNlbGVjdEFjdGlvbjoiZm9yRWFjaCJ9LHtuYW1lOiJyZXBsYWNlIixkZXNjcmlwdGlvbjoiUmVwbGFjZSIsYmluZEtleTpvKCJDdHJsLUgiLCJDb21tYW5kLU9wdGlvbi1GIiksZXhlYzpmdW5jdGlvbihlKXtpLmxvYWRNb2R1bGUoImFjZS9leHQvc2VhcmNoYm94IixmdW5jdGlvbih0KXt0LlNlYXJjaChlLCEwKX0pfX0se25hbWU6InVuZG8iLGRlc2NyaXB0aW9uOiJVbmRvIixiaW5kS2V5Om8oIkN0cmwtWiIsIkNvbW1hbmQtWiIpLGV4ZWM6ZnVuY3Rpb24oZSl7ZS51bmRvKCl9fSx7bmFtZToicmVkbyIsZGVzY3JpcHRpb246IlJlZG8iLGJpbmRLZXk6bygiQ3RybC1TaGlmdC1afEN0cmwtWSIsIkNvbW1hbmQtU2hpZnQtWnxDb21tYW5kLVkiKSxleGVjOmZ1bmN0aW9uKGUpe2UucmVkbygpfX0se25hbWU6ImNvcHlsaW5lc3VwIixkZXNjcmlwdGlvbjoiQ29weSBsaW5lcyB1cCIsYmluZEtleTpvKCJBbHQtU2hpZnQtVXAiLCJDb21tYW5kLU9wdGlvbi1VcCIpLGV4ZWM6ZnVuY3Rpb24oZSl7ZS5jb3B5TGluZXNVcCgpfSxzY3JvbGxJbnRvVmlldzoiY3Vyc29yIn0se25hbWU6Im1vdmVsaW5lc3VwIixkZXNjcmlwdGlvbjoiTW92ZSBsaW5lcyB1cCIsYmluZEtleTpvKCJBbHQtVXAiLCJPcHRpb24tVXAiKSxleGVjOmZ1bmN0aW9uKGUpe2UubW92ZUxpbmVzVXAoKX0sc2Nyb2xsSW50b1ZpZXc6ImN1cnNvciJ9LHtuYW1lOiJjb3B5bGluZXNkb3duIixkZXNjcmlwdGlvbjoiQ29weSBsaW5lcyBkb3duIixiaW5kS2V5Om8oIkFsdC1TaGlmdC1Eb3duIiwiQ29tbWFuZC1PcHRpb24tRG93biIpLGV4ZWM6ZnVuY3Rpb24oZSl7ZS5jb3B5TGluZXNEb3duKCl9LHNjcm9sbEludG9WaWV3OiJjdXJzb3IifSx7bmFtZToibW92ZWxpbmVzZG93biIsZGVzY3JpcHRpb246Ik1vdmUgbGluZXMgZG93biIsYmluZEtleTpvKCJBbHQtRG93biIsIk9wdGlvbi1Eb3duIiksZXhlYzpmdW5jdGlvbihlKXtlLm1vdmVMaW5lc0Rvd24oKX0sc2Nyb2xsSW50b1ZpZXc6ImN1cnNvciJ9LHtuYW1lOiJkZWwiLGRlc2NyaXB0aW9uOiJEZWxldGUiLGJpbmRLZXk6bygiRGVsZXRlIiwiRGVsZXRlfEN0cmwtRHxTaGlmdC1EZWxldGUiKSxleGVjOmZ1bmN0aW9uKGUpe2UucmVtb3ZlKCJyaWdodCIpfSxtdWx0aVNlbGVjdEFjdGlvbjoiZm9yRWFjaCIsc2Nyb2xsSW50b1ZpZXc6ImN1cnNvciJ9LHtuYW1lOiJiYWNrc3BhY2UiLGRlc2NyaXB0aW9uOiJCYWNrc3BhY2UiLGJpbmRLZXk6bygiU2hpZnQtQmFja3NwYWNlfEJhY2tzcGFjZSIsIkN0cmwtQmFja3NwYWNlfFNoaWZ0LUJhY2tzcGFjZXxCYWNrc3BhY2V8Q3RybC1IIiksZXhlYzpmdW5jdGlvbihlKXtlLnJlbW92ZSgibGVmdCIpfSxtdWx0aVNlbGVjdEFjdGlvbjoiZm9yRWFjaCIsc2Nyb2xsSW50b1ZpZXc6ImN1cnNvciJ9LHtuYW1lOiJjdXRfb3JfZGVsZXRlIixkZXNjcmlwdGlvbjoiQ3V0IG9yIGRlbGV0ZSIsYmluZEtleTpvKCJTaGlmdC1EZWxldGUiLG51bGwpLGV4ZWM6ZnVuY3Rpb24oZSl7aWYoIWUuc2VsZWN0aW9uLmlzRW1wdHkoKSlyZXR1cm4hMTtlLnJlbW92ZSgibGVmdCIpfSxtdWx0aVNlbGVjdEFjdGlvbjoiZm9yRWFjaCIsc2Nyb2xsSW50b1ZpZXc6ImN1cnNvciJ9LHtuYW1lOiJyZW1vdmV0b2xpbmVzdGFydCIsZGVzY3JpcHRpb246IlJlbW92ZSB0byBsaW5lIHN0YXJ0IixiaW5kS2V5Om8oIkFsdC1CYWNrc3BhY2UiLCJDb21tYW5kLUJhY2tzcGFjZSIpLGV4ZWM6ZnVuY3Rpb24oZSl7ZS5yZW1vdmVUb0xpbmVTdGFydCgpfSxtdWx0aVNlbGVjdEFjdGlvbjoiZm9yRWFjaCIsc2Nyb2xsSW50b1ZpZXc6ImN1cnNvciJ9LHtuYW1lOiJyZW1vdmV0b2xpbmVlbmQiLGRlc2NyaXB0aW9uOiJSZW1vdmUgdG8gbGluZSBlbmQiLGJpbmRLZXk6bygiQWx0LURlbGV0ZSIsIkN0cmwtS3xDb21tYW5kLURlbGV0ZSIpLGV4ZWM6ZnVuY3Rpb24oZSl7ZS5yZW1vdmVUb0xpbmVFbmQoKX0sbXVsdGlTZWxlY3RBY3Rpb246ImZvckVhY2giLHNjcm9sbEludG9WaWV3OiJjdXJzb3IifSx7bmFtZToicmVtb3ZldG9saW5lc3RhcnRoYXJkIixkZXNjcmlwdGlvbjoiUmVtb3ZlIHRvIGxpbmUgc3RhcnQgaGFyZCIsYmluZEtleTpvKCJDdHJsLVNoaWZ0LUJhY2tzcGFjZSIsbnVsbCksZXhlYzpmdW5jdGlvbihlKXt2YXIgdD1lLnNlbGVjdGlvbi5nZXRSYW5nZSgpO3Quc3RhcnQuY29sdW1uPTAsZS5zZXNzaW9uLnJlbW92ZSh0KX0sbXVsdGlTZWxlY3RBY3Rpb246ImZvckVhY2giLHNjcm9sbEludG9WaWV3OiJjdXJzb3IifSx7bmFtZToicmVtb3ZldG9saW5lZW5kaGFyZCIsZGVzY3JpcHRpb246IlJlbW92ZSB0byBsaW5lIGVuZCBoYXJkIixiaW5kS2V5Om8oIkN0cmwtU2hpZnQtRGVsZXRlIixudWxsKSxleGVjOmZ1bmN0aW9uKGUpe3ZhciB0PWUuc2VsZWN0aW9uLmdldFJhbmdlKCk7dC5lbmQuY29sdW1uPU51bWJlci5NQVhfVkFMVUUsZS5zZXNzaW9uLnJlbW92ZSh0KX0sbXVsdGlTZWxlY3RBY3Rpb246ImZvckVhY2giLHNjcm9sbEludG9WaWV3OiJjdXJzb3IifSx7bmFtZToicmVtb3Zld29yZGxlZnQiLGRlc2NyaXB0aW9uOiJSZW1vdmUgd29yZCBsZWZ0IixiaW5kS2V5Om8oIkN0cmwtQmFja3NwYWNlIiwiQWx0LUJhY2tzcGFjZXxDdHJsLUFsdC1CYWNrc3BhY2UiKSxleGVjOmZ1bmN0aW9uKGUpe2UucmVtb3ZlV29yZExlZnQoKX0sbXVsdGlTZWxlY3RBY3Rpb246ImZvckVhY2giLHNjcm9sbEludG9WaWV3OiJjdXJzb3IifSx7bmFtZToicmVtb3Zld29yZHJpZ2h0IixkZXNjcmlwdGlvbjoiUmVtb3ZlIHdvcmQgcmlnaHQiLGJpbmRLZXk6bygiQ3RybC1EZWxldGUiLCJBbHQtRGVsZXRlIiksZXhlYzpmdW5jdGlvbihlKXtlLnJlbW92ZVdvcmRSaWdodCgpfSxtdWx0aVNlbGVjdEFjdGlvbjoiZm9yRWFjaCIsc2Nyb2xsSW50b1ZpZXc6ImN1cnNvciJ9LHtuYW1lOiJvdXRkZW50IixkZXNjcmlwdGlvbjoiT3V0ZGVudCIsYmluZEtleTpvKCJTaGlmdC1UYWIiLCJTaGlmdC1UYWIiKSxleGVjOmZ1bmN0aW9uKGUpe2UuYmxvY2tPdXRkZW50KCl9LG11bHRpU2VsZWN0QWN0aW9uOiJmb3JFYWNoIixzY3JvbGxJbnRvVmlldzoic2VsZWN0aW9uUGFydCJ9LHtuYW1lOiJpbmRlbnQiLGRlc2NyaXB0aW9uOiJJbmRlbnQiLGJpbmRLZXk6bygiVGFiIiwiVGFiIiksZXhlYzpmdW5jdGlvbihlKXtlLmluZGVudCgpfSxtdWx0aVNlbGVjdEFjdGlvbjoiZm9yRWFjaCIsc2Nyb2xsSW50b1ZpZXc6InNlbGVjdGlvblBhcnQifSx7bmFtZToiYmxvY2tvdXRkZW50IixkZXNjcmlwdGlvbjoiQmxvY2sgb3V0ZGVudCIsYmluZEtleTpvKCJDdHJsLVsiLCJDdHJsLVsiKSxleGVjOmZ1bmN0aW9uKGUpe2UuYmxvY2tPdXRkZW50KCl9LG11bHRpU2VsZWN0QWN0aW9uOiJmb3JFYWNoTGluZSIsc2Nyb2xsSW50b1ZpZXc6InNlbGVjdGlvblBhcnQifSx7bmFtZToiYmxvY2tpbmRlbnQiLGRlc2NyaXB0aW9uOiJCbG9jayBpbmRlbnQiLGJpbmRLZXk6bygiQ3RybC1dIiwiQ3RybC1dIiksZXhlYzpmdW5jdGlvbihlKXtlLmJsb2NrSW5kZW50KCl9LG11bHRpU2VsZWN0QWN0aW9uOiJmb3JFYWNoTGluZSIsc2Nyb2xsSW50b1ZpZXc6InNlbGVjdGlvblBhcnQifSx7bmFtZToiaW5zZXJ0c3RyaW5nIixkZXNjcmlwdGlvbjoiSW5zZXJ0IHN0cmluZyIsZXhlYzpmdW5jdGlvbihlLHQpe2UuaW5zZXJ0KHQpfSxtdWx0aVNlbGVjdEFjdGlvbjoiZm9yRWFjaCIsc2Nyb2xsSW50b1ZpZXc6ImN1cnNvciJ9LHtuYW1lOiJpbnNlcnR0ZXh0IixkZXNjcmlwdGlvbjoiSW5zZXJ0IHRleHQiLGV4ZWM6ZnVuY3Rpb24oZSx0KXtlLmluc2VydChyLnN0cmluZ1JlcGVhdCh0LnRleHR8fCIiLHQudGltZXN8fDEpKX0sbXVsdGlTZWxlY3RBY3Rpb246ImZvckVhY2giLHNjcm9sbEludG9WaWV3OiJjdXJzb3IifSx7bmFtZToic3BsaXRsaW5lIixkZXNjcmlwdGlvbjoiU3BsaXQgbGluZSIsYmluZEtleTpvKG51bGwsIkN0cmwtTyIpLGV4ZWM6ZnVuY3Rpb24oZSl7ZS5zcGxpdExpbmUoKX0sbXVsdGlTZWxlY3RBY3Rpb246ImZvckVhY2giLHNjcm9sbEludG9WaWV3OiJjdXJzb3IifSx7bmFtZToidHJhbnNwb3NlbGV0dGVycyIsZGVzY3JpcHRpb246IlRyYW5zcG9zZSBsZXR0ZXJzIixiaW5kS2V5Om8oIkFsdC1TaGlmdC1YIiwiQ3RybC1UIiksZXhlYzpmdW5jdGlvbihlKXtlLnRyYW5zcG9zZUxldHRlcnMoKX0sbXVsdGlTZWxlY3RBY3Rpb246ZnVuY3Rpb24oZSl7ZS50cmFuc3Bvc2VTZWxlY3Rpb25zKDEpfSxzY3JvbGxJbnRvVmlldzoiY3Vyc29yIn0se25hbWU6InRvdXBwZXJjYXNlIixkZXNjcmlwdGlvbjoiVG8gdXBwZXJjYXNlIixiaW5kS2V5Om8oIkN0cmwtVSIsIkN0cmwtVSIpLGV4ZWM6ZnVuY3Rpb24oZSl7ZS50b1VwcGVyQ2FzZSgpfSxtdWx0aVNlbGVjdEFjdGlvbjoiZm9yRWFjaCIsc2Nyb2xsSW50b1ZpZXc6ImN1cnNvciJ9LHtuYW1lOiJ0b2xvd2VyY2FzZSIsZGVzY3JpcHRpb246IlRvIGxvd2VyY2FzZSIsYmluZEtleTpvKCJDdHJsLVNoaWZ0LVUiLCJDdHJsLVNoaWZ0LVUiKSxleGVjOmZ1bmN0aW9uKGUpe2UudG9Mb3dlckNhc2UoKX0sbXVsdGlTZWxlY3RBY3Rpb246ImZvckVhY2giLHNjcm9sbEludG9WaWV3OiJjdXJzb3IifSx7bmFtZToiYXV0b2luZGVudCIsZGVzY3JpcHRpb246IkF1dG8gSW5kZW50IixiaW5kS2V5Om8obnVsbCxudWxsKSxleGVjOmZ1bmN0aW9uKGUpe2UuYXV0b0luZGVudCgpfSxtdWx0aVNlbGVjdEFjdGlvbjoiZm9yRWFjaExpbmUiLHNjcm9sbEludG9WaWV3OiJhbmltYXRlIn0se25hbWU6ImV4cGFuZHRvbGluZSIsZGVzY3JpcHRpb246IkV4cGFuZCB0byBsaW5lIixiaW5kS2V5Om8oIkN0cmwtU2hpZnQtTCIsIkNvbW1hbmQtU2hpZnQtTCIpLGV4ZWM6ZnVuY3Rpb24oZSl7dmFyIHQ9ZS5zZWxlY3Rpb24uZ2V0UmFuZ2UoKTt0LnN0YXJ0LmNvbHVtbj10LmVuZC5jb2x1bW49MCx0LmVuZC5yb3crKyxlLnNlbGVjdGlvbi5zZXRSYW5nZSh0LCExKX0sbXVsdGlTZWxlY3RBY3Rpb246ImZvckVhY2giLHNjcm9sbEludG9WaWV3OiJjdXJzb3IiLHJlYWRPbmx5OiEwfSx7bmFtZToib3BlbmxpbmsiLGJpbmRLZXk6bygiQ3RybCtGMyIsIkYzIiksZXhlYzpmdW5jdGlvbihlKXtlLm9wZW5MaW5rKCl9fSx7bmFtZToiam9pbmxpbmVzIixkZXNjcmlwdGlvbjoiSm9pbiBsaW5lcyIsYmluZEtleTpvKG51bGwsbnVsbCksZXhlYzpmdW5jdGlvbihlKXt2YXIgdD1lLnNlbGVjdGlvbi5pc0JhY2t3YXJkcygpLG49dD9lLnNlbGVjdGlvbi5nZXRTZWxlY3Rpb25MZWFkKCk6ZS5zZWxlY3Rpb24uZ2V0U2VsZWN0aW9uQW5jaG9yKCksaT10P2Uuc2VsZWN0aW9uLmdldFNlbGVjdGlvbkFuY2hvcigpOmUuc2VsZWN0aW9uLmdldFNlbGVjdGlvbkxlYWQoKSxvPWUuc2Vzc2lvbi5kb2MuZ2V0TGluZShuLnJvdykubGVuZ3RoLHU9ZS5zZXNzaW9uLmRvYy5nZXRUZXh0UmFuZ2UoZS5zZWxlY3Rpb24uZ2V0UmFuZ2UoKSksYT11LnJlcGxhY2UoL1xuXHMqLywiICIpLmxlbmd0aCxmPWUuc2Vzc2lvbi5kb2MuZ2V0TGluZShuLnJvdyk7Zm9yKHZhciBsPW4ucm93KzE7bDw9aS5yb3crMTtsKyspe3ZhciBjPXIuc3RyaW5nVHJpbUxlZnQoci5zdHJpbmdUcmltUmlnaHQoZS5zZXNzaW9uLmRvYy5nZXRMaW5lKGwpKSk7Yy5sZW5ndGghPT0wJiYoYz0iICIrYyksZis9Y31pLnJvdysxPGUuc2Vzc2lvbi5kb2MuZ2V0TGVuZ3RoKCktMSYmKGYrPWUuc2Vzc2lvbi5kb2MuZ2V0TmV3TGluZUNoYXJhY3RlcigpKSxlLmNsZWFyU2VsZWN0aW9uKCksZS5zZXNzaW9uLmRvYy5yZXBsYWNlKG5ldyBzKG4ucm93LDAsaS5yb3crMiwwKSxmKSxhPjA/KGUuc2VsZWN0aW9uLm1vdmVDdXJzb3JUbyhuLnJvdyxuLmNvbHVtbiksZS5zZWxlY3Rpb24uc2VsZWN0VG8obi5yb3csbi5jb2x1bW4rYSkpOihvPWUuc2Vzc2lvbi5kb2MuZ2V0TGluZShuLnJvdykubGVuZ3RoPm8/bysxOm8sZS5zZWxlY3Rpb24ubW92ZUN1cnNvclRvKG4ucm93LG8pKX0sbXVsdGlTZWxlY3RBY3Rpb246ImZvckVhY2giLHJlYWRPbmx5OiEwfSx7bmFtZToiaW52ZXJ0U2VsZWN0aW9uIixkZXNjcmlwdGlvbjoiSW52ZXJ0IHNlbGVjdGlvbiIsYmluZEtleTpvKG51bGwsbnVsbCksZXhlYzpmdW5jdGlvbihlKXt2YXIgdD1lLnNlc3Npb24uZG9jLmdldExlbmd0aCgpLTEsbj1lLnNlc3Npb24uZG9jLmdldExpbmUodCkubGVuZ3RoLHI9ZS5zZWxlY3Rpb24ucmFuZ2VMaXN0LnJhbmdlcyxpPVtdO3IubGVuZ3RoPDEmJihyPVtlLnNlbGVjdGlvbi5nZXRSYW5nZSgpXSk7Zm9yKHZhciBvPTA7bzxyLmxlbmd0aDtvKyspbz09ci5sZW5ndGgtMSYmKHJbb10uZW5kLnJvdyE9PXR8fHJbb10uZW5kLmNvbHVtbiE9PW4pJiZpLnB1c2gobmV3IHMocltvXS5lbmQucm93LHJbb10uZW5kLmNvbHVtbix0LG4pKSxvPT09MD8ocltvXS5zdGFydC5yb3chPT0wfHxyW29dLnN0YXJ0LmNvbHVtbiE9PTApJiZpLnB1c2gobmV3IHMoMCwwLHJbb10uc3RhcnQucm93LHJbb10uc3RhcnQuY29sdW1uKSk6aS5wdXNoKG5ldyBzKHJbby0xXS5lbmQucm93LHJbby0xXS5lbmQuY29sdW1uLHJbb10uc3RhcnQucm93LHJbb10uc3RhcnQuY29sdW1uKSk7ZS5leGl0TXVsdGlTZWxlY3RNb2RlKCksZS5jbGVhclNlbGVjdGlvbigpO2Zvcih2YXIgbz0wO288aS5sZW5ndGg7bysrKWUuc2VsZWN0aW9uLmFkZFJhbmdlKGlbb10sITEpfSxyZWFkT25seTohMCxzY3JvbGxJbnRvVmlldzoibm9uZSJ9LHtuYW1lOiJhZGRMaW5lQWZ0ZXIiLGRlc2NyaXB0aW9uOiJBZGQgbmV3IGxpbmUgYWZ0ZXIgdGhlIGN1cnJlbnQgbGluZSIsZXhlYzpmdW5jdGlvbihlKXtlLnNlbGVjdGlvbi5jbGVhclNlbGVjdGlvbigpLGUubmF2aWdhdGVMaW5lRW5kKCksZS5pbnNlcnQoIlxuIil9LG11bHRpU2VsZWN0QWN0aW9uOiJmb3JFYWNoIixzY3JvbGxJbnRvVmlldzoiY3Vyc29yIn0se25hbWU6ImFkZExpbmVCZWZvcmUiLGRlc2NyaXB0aW9uOiJBZGQgbmV3IGxpbmUgYmVmb3JlIHRoZSBjdXJyZW50IGxpbmUiLGV4ZWM6ZnVuY3Rpb24oZSl7ZS5zZWxlY3Rpb24uY2xlYXJTZWxlY3Rpb24oKTt2YXIgdD1lLmdldEN1cnNvclBvc2l0aW9uKCk7ZS5zZWxlY3Rpb24ubW92ZVRvKHQucm93LTEsTnVtYmVyLk1BWF9WQUxVRSksZS5pbnNlcnQoIlxuIiksdC5yb3c9PT0wJiZlLm5hdmlnYXRlVXAoKX0sbXVsdGlTZWxlY3RBY3Rpb246ImZvckVhY2giLHNjcm9sbEludG9WaWV3OiJjdXJzb3IifSx7bmFtZToib3BlbkNvbW1hbmRQYWxsZXRlIixkZXNjcmlwdGlvbjoiT3BlbiBjb21tYW5kIHBhbGV0dGUiLGJpbmRLZXk6bygiRjEiLCJGMSIpLGV4ZWM6ZnVuY3Rpb24oZSl7ZS5wcm9tcHQoeyR0eXBlOiJjb21tYW5kcyJ9KX0scmVhZE9ubHk6ITB9LHtuYW1lOiJtb2RlU2VsZWN0IixkZXNjcmlwdGlvbjoiQ2hhbmdlIGxhbmd1YWdlIG1vZGUuLi4iLGJpbmRLZXk6byhudWxsLG51bGwpLGV4ZWM6ZnVuY3Rpb24oZSl7ZS5wcm9tcHQoeyR0eXBlOiJtb2RlcyJ9KX0scmVhZE9ubHk6ITB9XTtmb3IodmFyIHU9MTt1PDk7dSsrKXQuY29tbWFuZHMucHVzaCh7bmFtZToiZm9sZFRvTGV2ZWwiK3UsZGVzY3JpcHRpb246IkZvbGQgVG8gTGV2ZWwgIit1LGxldmVsOnUsZXhlYzpmdW5jdGlvbihlKXtlLnNlc3Npb24uZm9sZFRvTGV2ZWwodGhpcy5sZXZlbCl9LHNjcm9sbEludG9WaWV3OiJjZW50ZXIiLHJlYWRPbmx5OiEwfSl9KSxkZWZpbmUoImFjZS9lZGl0b3IiLFsicmVxdWlyZSIsImV4cG9ydHMiLCJtb2R1bGUiLCJhY2UvbGliL29vcCIsImFjZS9saWIvZG9tIiwiYWNlL2xpYi9sYW5nIiwiYWNlL2xpYi91c2VyYWdlbnQiLCJhY2Uva2V5Ym9hcmQvdGV4dGlucHV0IiwiYWNlL21vdXNlL21vdXNlX2hhbmRsZXIiLCJhY2UvbW91c2UvZm9sZF9oYW5kbGVyIiwiYWNlL2tleWJvYXJkL2tleWJpbmRpbmciLCJhY2UvZWRpdF9zZXNzaW9uIiwiYWNlL3NlYXJjaCIsImFjZS9yYW5nZSIsImFjZS9saWIvZXZlbnRfZW1pdHRlciIsImFjZS9jb21tYW5kcy9jb21tYW5kX21hbmFnZXIiLCJhY2UvY29tbWFuZHMvZGVmYXVsdF9jb21tYW5kcyIsImFjZS9jb25maWciLCJhY2UvdG9rZW5faXRlcmF0b3IiLCJhY2UvY2xpcGJvYXJkIl0sZnVuY3Rpb24oZSx0LG4peyJ1c2Ugc3RyaWN0Ijt2YXIgcj10aGlzJiZ0aGlzLl9fdmFsdWVzfHxmdW5jdGlvbihlKXt2YXIgdD10eXBlb2YgU3ltYm9sPT0iZnVuY3Rpb24iJiZTeW1ib2wuaXRlcmF0b3Isbj10JiZlW3RdLHI9MDtpZihuKXJldHVybiBuLmNhbGwoZSk7aWYoZSYmdHlwZW9mIGUubGVuZ3RoPT0ibnVtYmVyIilyZXR1cm57bmV4dDpmdW5jdGlvbigpe3JldHVybiBlJiZyPj1lLmxlbmd0aCYmKGU9dm9pZCAwKSx7dmFsdWU6ZSYmZVtyKytdLGRvbmU6IWV9fX07dGhyb3cgbmV3IFR5cGVFcnJvcih0PyJPYmplY3QgaXMgbm90IGl0ZXJhYmxlLiI6IlN5bWJvbC5pdGVyYXRvciBpcyBub3QgZGVmaW5lZC4iKX0saT1lKCIuL2xpYi9vb3AiKSxzPWUoIi4vbGliL2RvbSIpLG89ZSgiLi9saWIvbGFuZyIpLHU9ZSgiLi9saWIvdXNlcmFnZW50IiksYT1lKCIuL2tleWJvYXJkL3RleHRpbnB1dCIpLlRleHRJbnB1dCxmPWUoIi4vbW91c2UvbW91c2VfaGFuZGxlciIpLk1vdXNlSGFuZGxlcixsPWUoIi4vbW91c2UvZm9sZF9oYW5kbGVyIikuRm9sZEhhbmRsZXIsYz1lKCIuL2tleWJvYXJkL2tleWJpbmRpbmciKS5LZXlCaW5kaW5nLGg9ZSgiLi9lZGl0X3Nlc3Npb24iKS5FZGl0U2Vzc2lvbixwPWUoIi4vc2VhcmNoIikuU2VhcmNoLGQ9ZSgiLi9yYW5nZSIpLlJhbmdlLHY9ZSgiLi9saWIvZXZlbnRfZW1pdHRlciIpLkV2ZW50RW1pdHRlcixtPWUoIi4vY29tbWFuZHMvY29tbWFuZF9tYW5hZ2VyIikuQ29tbWFuZE1hbmFnZXIsZz1lKCIuL2NvbW1hbmRzL2RlZmF1bHRfY29tbWFuZHMiKS5jb21tYW5kcyx5PWUoIi4vY29uZmlnIiksYj1lKCIuL3Rva2VuX2l0ZXJhdG9yIikuVG9rZW5JdGVyYXRvcix3PWUoIi4vY2xpcGJvYXJkIiksRT1mdW5jdGlvbihlLHQsbil7dGhpcy4kdG9EZXN0cm95PVtdO3ZhciByPWUuZ2V0Q29udGFpbmVyRWxlbWVudCgpO3RoaXMuY29udGFpbmVyPXIsdGhpcy5yZW5kZXJlcj1lLHRoaXMuaWQ9ImVkaXRvciIrICsrRS4kdWlkLHRoaXMuY29tbWFuZHM9bmV3IG0odS5pc01hYz8ibWFjIjoid2luIixnKSx0eXBlb2YgZG9jdW1lbnQ9PSJvYmplY3QiJiYodGhpcy50ZXh0SW5wdXQ9bmV3IGEoZS5nZXRUZXh0QXJlYUNvbnRhaW5lcigpLHRoaXMpLHRoaXMucmVuZGVyZXIudGV4dGFyZWE9dGhpcy50ZXh0SW5wdXQuZ2V0RWxlbWVudCgpLHRoaXMuJG1vdXNlSGFuZGxlcj1uZXcgZih0aGlzKSxuZXcgbCh0aGlzKSksdGhpcy5rZXlCaW5kaW5nPW5ldyBjKHRoaXMpLHRoaXMuJHNlYXJjaD0obmV3IHApLnNldCh7d3JhcDohMH0pLHRoaXMuJGhpc3RvcnlUcmFja2VyPXRoaXMuJGhpc3RvcnlUcmFja2VyLmJpbmQodGhpcyksdGhpcy5jb21tYW5kcy5vbigiZXhlYyIsdGhpcy4kaGlzdG9yeVRyYWNrZXIpLHRoaXMuJGluaXRPcGVyYXRpb25MaXN0ZW5lcnMoKSx0aGlzLl8kZW1pdElucHV0RXZlbnQ9by5kZWxheWVkQ2FsbChmdW5jdGlvbigpe3RoaXMuX3NpZ25hbCgiaW5wdXQiLHt9KSx0aGlzLnNlc3Npb24mJiF0aGlzLnNlc3Npb24uZGVzdHJveWVkJiZ0aGlzLnNlc3Npb24uYmdUb2tlbml6ZXIuc2NoZWR1bGVTdGFydCgpfS5iaW5kKHRoaXMpKSx0aGlzLm9uKCJjaGFuZ2UiLGZ1bmN0aW9uKGUsdCl7dC5fJGVtaXRJbnB1dEV2ZW50LnNjaGVkdWxlKDMxKX0pLHRoaXMuc2V0U2Vzc2lvbih0fHxuJiZuLnNlc3Npb258fG5ldyBoKCIiKSkseS5yZXNldE9wdGlvbnModGhpcyksbiYmdGhpcy5zZXRPcHRpb25zKG4pLHkuX3NpZ25hbCgiZWRpdG9yIix0aGlzKX07RS4kdWlkPTAsZnVuY3Rpb24oKXtpLmltcGxlbWVudCh0aGlzLHYpLHRoaXMuJGluaXRPcGVyYXRpb25MaXN0ZW5lcnM9ZnVuY3Rpb24oKXt0aGlzLmNvbW1hbmRzLm9uKCJleGVjIix0aGlzLnN0YXJ0T3BlcmF0aW9uLmJpbmQodGhpcyksITApLHRoaXMuY29tbWFuZHMub24oImFmdGVyRXhlYyIsdGhpcy5lbmRPcGVyYXRpb24uYmluZCh0aGlzKSwhMCksdGhpcy4kb3BSZXNldFRpbWVyPW8uZGVsYXllZENhbGwodGhpcy5lbmRPcGVyYXRpb24uYmluZCh0aGlzLCEwKSksdGhpcy5vbigiY2hhbmdlIixmdW5jdGlvbigpe3RoaXMuY3VyT3B8fCh0aGlzLnN0YXJ0T3BlcmF0aW9uKCksdGhpcy5jdXJPcC5zZWxlY3Rpb25CZWZvcmU9dGhpcy4kbGFzdFNlbCksdGhpcy5jdXJPcC5kb2NDaGFuZ2VkPSEwfS5iaW5kKHRoaXMpLCEwKSx0aGlzLm9uKCJjaGFuZ2VTZWxlY3Rpb24iLGZ1bmN0aW9uKCl7dGhpcy5jdXJPcHx8KHRoaXMuc3RhcnRPcGVyYXRpb24oKSx0aGlzLmN1ck9wLnNlbGVjdGlvbkJlZm9yZT10aGlzLiRsYXN0U2VsKSx0aGlzLmN1ck9wLnNlbGVjdGlvbkNoYW5nZWQ9ITB9LmJpbmQodGhpcyksITApfSx0aGlzLmN1ck9wPW51bGwsdGhpcy5wcmV2T3A9e30sdGhpcy5zdGFydE9wZXJhdGlvbj1mdW5jdGlvbihlKXtpZih0aGlzLmN1ck9wKXtpZighZXx8dGhpcy5jdXJPcC5jb21tYW5kKXJldHVybjt0aGlzLnByZXZPcD10aGlzLmN1ck9wfWV8fCh0aGlzLnByZXZpb3VzQ29tbWFuZD1udWxsLGU9e30pLHRoaXMuJG9wUmVzZXRUaW1lci5zY2hlZHVsZSgpLHRoaXMuY3VyT3A9dGhpcy5zZXNzaW9uLmN1ck9wPXtjb21tYW5kOmUuY29tbWFuZHx8e30sYXJnczplLmFyZ3Msc2Nyb2xsVG9wOnRoaXMucmVuZGVyZXIuc2Nyb2xsVG9wfSx0aGlzLmN1ck9wLnNlbGVjdGlvbkJlZm9yZT10aGlzLnNlbGVjdGlvbi50b0pTT04oKX0sdGhpcy5lbmRPcGVyYXRpb249ZnVuY3Rpb24oZSl7aWYodGhpcy5jdXJPcCYmdGhpcy5zZXNzaW9uKXtpZihlJiZlLnJldHVyblZhbHVlPT09ITF8fCF0aGlzLnNlc3Npb24pcmV0dXJuIHRoaXMuY3VyT3A9bnVsbDtpZihlPT0xJiZ0aGlzLmN1ck9wLmNvbW1hbmQmJnRoaXMuY3VyT3AuY29tbWFuZC5uYW1lPT0ibW91c2UiKXJldHVybjt0aGlzLl9zaWduYWwoImJlZm9yZUVuZE9wZXJhdGlvbiIpO2lmKCF0aGlzLmN1ck9wKXJldHVybjt2YXIgdD10aGlzLmN1ck9wLmNvbW1hbmQsbj10JiZ0LnNjcm9sbEludG9WaWV3O2lmKG4pe3N3aXRjaChuKXtjYXNlImNlbnRlci1hbmltYXRlIjpuPSJhbmltYXRlIjtjYXNlImNlbnRlciI6dGhpcy5yZW5kZXJlci5zY3JvbGxDdXJzb3JJbnRvVmlldyhudWxsLC41KTticmVhaztjYXNlImFuaW1hdGUiOmNhc2UiY3Vyc29yIjp0aGlzLnJlbmRlcmVyLnNjcm9sbEN1cnNvckludG9WaWV3KCk7YnJlYWs7Y2FzZSJzZWxlY3Rpb25QYXJ0Ijp2YXIgcj10aGlzLnNlbGVjdGlvbi5nZXRSYW5nZSgpLGk9dGhpcy5yZW5kZXJlci5sYXllckNvbmZpZzsoci5zdGFydC5yb3c+PWkubGFzdFJvd3x8ci5lbmQucm93PD1pLmZpcnN0Um93KSYmdGhpcy5yZW5kZXJlci5zY3JvbGxTZWxlY3Rpb25JbnRvVmlldyh0aGlzLnNlbGVjdGlvbi5hbmNob3IsdGhpcy5zZWxlY3Rpb24ubGVhZCk7YnJlYWs7ZGVmYXVsdDp9bj09ImFuaW1hdGUiJiZ0aGlzLnJlbmRlcmVyLmFuaW1hdGVTY3JvbGxpbmcodGhpcy5jdXJPcC5zY3JvbGxUb3ApfXZhciBzPXRoaXMuc2VsZWN0aW9uLnRvSlNPTigpO3RoaXMuY3VyT3Auc2VsZWN0aW9uQWZ0ZXI9cyx0aGlzLiRsYXN0U2VsPXRoaXMuc2VsZWN0aW9uLnRvSlNPTigpLHRoaXMuc2Vzc2lvbi5nZXRVbmRvTWFuYWdlcigpLmFkZFNlbGVjdGlvbihzKSx0aGlzLnByZXZPcD10aGlzLmN1ck9wLHRoaXMuY3VyT3A9bnVsbH19LHRoaXMuJG1lcmdlYWJsZUNvbW1hbmRzPVsiYmFja3NwYWNlIiwiZGVsIiwiaW5zZXJ0c3RyaW5nIl0sdGhpcy4kaGlzdG9yeVRyYWNrZXI9ZnVuY3Rpb24oZSl7aWYoIXRoaXMuJG1lcmdlVW5kb0RlbHRhcylyZXR1cm47dmFyIHQ9dGhpcy5wcmV2T3Asbj10aGlzLiRtZXJnZWFibGVDb21tYW5kcyxyPXQuY29tbWFuZCYmZS5jb21tYW5kLm5hbWU9PXQuY29tbWFuZC5uYW1lO2lmKGUuY29tbWFuZC5uYW1lPT0iaW5zZXJ0c3RyaW5nIil7dmFyIGk9ZS5hcmdzO3RoaXMubWVyZ2VOZXh0Q29tbWFuZD09PXVuZGVmaW5lZCYmKHRoaXMubWVyZ2VOZXh0Q29tbWFuZD0hMCkscj1yJiZ0aGlzLm1lcmdlTmV4dENvbW1hbmQmJighL1xzLy50ZXN0KGkpfHwvXHMvLnRlc3QodC5hcmdzKSksdGhpcy5tZXJnZU5leHRDb21tYW5kPSEwfWVsc2Ugcj1yJiZuLmluZGV4T2YoZS5jb21tYW5kLm5hbWUpIT09LTE7dGhpcy4kbWVyZ2VVbmRvRGVsdGFzIT0iYWx3YXlzIiYmRGF0ZS5ub3coKS10aGlzLnNlcXVlbmNlU3RhcnRUaW1lPjJlMyYmKHI9ITEpLHI/dGhpcy5zZXNzaW9uLm1lcmdlVW5kb0RlbHRhcz0hMDpuLmluZGV4T2YoZS5jb21tYW5kLm5hbWUpIT09LTEmJih0aGlzLnNlcXVlbmNlU3RhcnRUaW1lPURhdGUubm93KCkpfSx0aGlzLnNldEtleWJvYXJkSGFuZGxlcj1mdW5jdGlvbihlLHQpe2lmKGUmJnR5cGVvZiBlPT0ic3RyaW5nIiYmZSE9ImFjZSIpe3RoaXMuJGtleWJpbmRpbmdJZD1lO3ZhciBuPXRoaXM7eS5sb2FkTW9kdWxlKFsia2V5YmluZGluZyIsZV0sZnVuY3Rpb24ocil7bi4ka2V5YmluZGluZ0lkPT1lJiZuLmtleUJpbmRpbmcuc2V0S2V5Ym9hcmRIYW5kbGVyKHImJnIuaGFuZGxlciksdCYmdCgpfSl9ZWxzZSB0aGlzLiRrZXliaW5kaW5nSWQ9bnVsbCx0aGlzLmtleUJpbmRpbmcuc2V0S2V5Ym9hcmRIYW5kbGVyKGUpLHQmJnQoKX0sdGhpcy5nZXRLZXlib2FyZEhhbmRsZXI9ZnVuY3Rpb24oKXtyZXR1cm4gdGhpcy5rZXlCaW5kaW5nLmdldEtleWJvYXJkSGFuZGxlcigpfSx0aGlzLnNldFNlc3Npb249ZnVuY3Rpb24oZSl7aWYodGhpcy5zZXNzaW9uPT1lKXJldHVybjt0aGlzLmN1ck9wJiZ0aGlzLmVuZE9wZXJhdGlvbigpLHRoaXMuY3VyT3A9e307dmFyIHQ9dGhpcy5zZXNzaW9uO2lmKHQpe3RoaXMuc2Vzc2lvbi5vZmYoImNoYW5nZSIsdGhpcy4kb25Eb2N1bWVudENoYW5nZSksdGhpcy5zZXNzaW9uLm9mZigiY2hhbmdlTW9kZSIsdGhpcy4kb25DaGFuZ2VNb2RlKSx0aGlzLnNlc3Npb24ub2ZmKCJ0b2tlbml6ZXJVcGRhdGUiLHRoaXMuJG9uVG9rZW5pemVyVXBkYXRlKSx0aGlzLnNlc3Npb24ub2ZmKCJjaGFuZ2VUYWJTaXplIix0aGlzLiRvbkNoYW5nZVRhYlNpemUpLHRoaXMuc2Vzc2lvbi5vZmYoImNoYW5nZVdyYXBMaW1pdCIsdGhpcy4kb25DaGFuZ2VXcmFwTGltaXQpLHRoaXMuc2Vzc2lvbi5vZmYoImNoYW5nZVdyYXBNb2RlIix0aGlzLiRvbkNoYW5nZVdyYXBNb2RlKSx0aGlzLnNlc3Npb24ub2ZmKCJjaGFuZ2VGb2xkIix0aGlzLiRvbkNoYW5nZUZvbGQpLHRoaXMuc2Vzc2lvbi5vZmYoImNoYW5nZUZyb250TWFya2VyIix0aGlzLiRvbkNoYW5nZUZyb250TWFya2VyKSx0aGlzLnNlc3Npb24ub2ZmKCJjaGFuZ2VCYWNrTWFya2VyIix0aGlzLiRvbkNoYW5nZUJhY2tNYXJrZXIpLHRoaXMuc2Vzc2lvbi5vZmYoImNoYW5nZUJyZWFrcG9pbnQiLHRoaXMuJG9uQ2hhbmdlQnJlYWtwb2ludCksdGhpcy5zZXNzaW9uLm9mZigiY2hhbmdlQW5ub3RhdGlvbiIsdGhpcy4kb25DaGFuZ2VBbm5vdGF0aW9uKSx0aGlzLnNlc3Npb24ub2ZmKCJjaGFuZ2VPdmVyd3JpdGUiLHRoaXMuJG9uQ3Vyc29yQ2hhbmdlKSx0aGlzLnNlc3Npb24ub2ZmKCJjaGFuZ2VTY3JvbGxUb3AiLHRoaXMuJG9uU2Nyb2xsVG9wQ2hhbmdlKSx0aGlzLnNlc3Npb24ub2ZmKCJjaGFuZ2VTY3JvbGxMZWZ0Iix0aGlzLiRvblNjcm9sbExlZnRDaGFuZ2UpO3ZhciBuPXRoaXMuc2Vzc2lvbi5nZXRTZWxlY3Rpb24oKTtuLm9mZigiY2hhbmdlQ3Vyc29yIix0aGlzLiRvbkN1cnNvckNoYW5nZSksbi5vZmYoImNoYW5nZVNlbGVjdGlvbiIsdGhpcy4kb25TZWxlY3Rpb25DaGFuZ2UpfXRoaXMuc2Vzc2lvbj1lLGU/KHRoaXMuJG9uRG9jdW1lbnRDaGFuZ2U9dGhpcy5vbkRvY3VtZW50Q2hhbmdlLmJpbmQodGhpcyksZS5vbigiY2hhbmdlIix0aGlzLiRvbkRvY3VtZW50Q2hhbmdlKSx0aGlzLnJlbmRlcmVyLnNldFNlc3Npb24oZSksdGhpcy4kb25DaGFuZ2VNb2RlPXRoaXMub25DaGFuZ2VNb2RlLmJpbmQodGhpcyksZS5vbigiY2hhbmdlTW9kZSIsdGhpcy4kb25DaGFuZ2VNb2RlKSx0aGlzLiRvblRva2VuaXplclVwZGF0ZT10aGlzLm9uVG9rZW5pemVyVXBkYXRlLmJpbmQodGhpcyksZS5vbigidG9rZW5pemVyVXBkYXRlIix0aGlzLiRvblRva2VuaXplclVwZGF0ZSksdGhpcy4kb25DaGFuZ2VUYWJTaXplPXRoaXMucmVuZGVyZXIub25DaGFuZ2VUYWJTaXplLmJpbmQodGhpcy5yZW5kZXJlciksZS5vbigiY2hhbmdlVGFiU2l6ZSIsdGhpcy4kb25DaGFuZ2VUYWJTaXplKSx0aGlzLiRvbkNoYW5nZVdyYXBMaW1pdD10aGlzLm9uQ2hhbmdlV3JhcExpbWl0LmJpbmQodGhpcyksZS5vbigiY2hhbmdlV3JhcExpbWl0Iix0aGlzLiRvbkNoYW5nZVdyYXBMaW1pdCksdGhpcy4kb25DaGFuZ2VXcmFwTW9kZT10aGlzLm9uQ2hhbmdlV3JhcE1vZGUuYmluZCh0aGlzKSxlLm9uKCJjaGFuZ2VXcmFwTW9kZSIsdGhpcy4kb25DaGFuZ2VXcmFwTW9kZSksdGhpcy4kb25DaGFuZ2VGb2xkPXRoaXMub25DaGFuZ2VGb2xkLmJpbmQodGhpcyksZS5vbigiY2hhbmdlRm9sZCIsdGhpcy4kb25DaGFuZ2VGb2xkKSx0aGlzLiRvbkNoYW5nZUZyb250TWFya2VyPXRoaXMub25DaGFuZ2VGcm9udE1hcmtlci5iaW5kKHRoaXMpLHRoaXMuc2Vzc2lvbi5vbigiY2hhbmdlRnJvbnRNYXJrZXIiLHRoaXMuJG9uQ2hhbmdlRnJvbnRNYXJrZXIpLHRoaXMuJG9uQ2hhbmdlQmFja01hcmtlcj10aGlzLm9uQ2hhbmdlQmFja01hcmtlci5iaW5kKHRoaXMpLHRoaXMuc2Vzc2lvbi5vbigiY2hhbmdlQmFja01hcmtlciIsdGhpcy4kb25DaGFuZ2VCYWNrTWFya2VyKSx0aGlzLiRvbkNoYW5nZUJyZWFrcG9pbnQ9dGhpcy5vbkNoYW5nZUJyZWFrcG9pbnQuYmluZCh0aGlzKSx0aGlzLnNlc3Npb24ub24oImNoYW5nZUJyZWFrcG9pbnQiLHRoaXMuJG9uQ2hhbmdlQnJlYWtwb2ludCksdGhpcy4kb25DaGFuZ2VBbm5vdGF0aW9uPXRoaXMub25DaGFuZ2VBbm5vdGF0aW9uLmJpbmQodGhpcyksdGhpcy5zZXNzaW9uLm9uKCJjaGFuZ2VBbm5vdGF0aW9uIix0aGlzLiRvbkNoYW5nZUFubm90YXRpb24pLHRoaXMuJG9uQ3Vyc29yQ2hhbmdlPXRoaXMub25DdXJzb3JDaGFuZ2UuYmluZCh0aGlzKSx0aGlzLnNlc3Npb24ub24oImNoYW5nZU92ZXJ3cml0ZSIsdGhpcy4kb25DdXJzb3JDaGFuZ2UpLHRoaXMuJG9uU2Nyb2xsVG9wQ2hhbmdlPXRoaXMub25TY3JvbGxUb3BDaGFuZ2UuYmluZCh0aGlzKSx0aGlzLnNlc3Npb24ub24oImNoYW5nZVNjcm9sbFRvcCIsdGhpcy4kb25TY3JvbGxUb3BDaGFuZ2UpLHRoaXMuJG9uU2Nyb2xsTGVmdENoYW5nZT10aGlzLm9uU2Nyb2xsTGVmdENoYW5nZS5iaW5kKHRoaXMpLHRoaXMuc2Vzc2lvbi5vbigiY2hhbmdlU2Nyb2xsTGVmdCIsdGhpcy4kb25TY3JvbGxMZWZ0Q2hhbmdlKSx0aGlzLnNlbGVjdGlvbj1lLmdldFNlbGVjdGlvbigpLHRoaXMuc2VsZWN0aW9uLm9uKCJjaGFuZ2VDdXJzb3IiLHRoaXMuJG9uQ3Vyc29yQ2hhbmdlKSx0aGlzLiRvblNlbGVjdGlvbkNoYW5nZT10aGlzLm9uU2VsZWN0aW9uQ2hhbmdlLmJpbmQodGhpcyksdGhpcy5zZWxlY3Rpb24ub24oImNoYW5nZVNlbGVjdGlvbiIsdGhpcy4kb25TZWxlY3Rpb25DaGFuZ2UpLHRoaXMub25DaGFuZ2VNb2RlKCksdGhpcy5vbkN1cnNvckNoYW5nZSgpLHRoaXMub25TY3JvbGxUb3BDaGFuZ2UoKSx0aGlzLm9uU2Nyb2xsTGVmdENoYW5nZSgpLHRoaXMub25TZWxlY3Rpb25DaGFuZ2UoKSx0aGlzLm9uQ2hhbmdlRnJvbnRNYXJrZXIoKSx0aGlzLm9uQ2hhbmdlQmFja01hcmtlcigpLHRoaXMub25DaGFuZ2VCcmVha3BvaW50KCksdGhpcy5vbkNoYW5nZUFubm90YXRpb24oKSx0aGlzLnNlc3Npb24uZ2V0VXNlV3JhcE1vZGUoKSYmdGhpcy5yZW5kZXJlci5hZGp1c3RXcmFwTGltaXQoKSx0aGlzLnJlbmRlcmVyLnVwZGF0ZUZ1bGwoKSk6KHRoaXMuc2VsZWN0aW9uPW51bGwsdGhpcy5yZW5kZXJlci5zZXRTZXNzaW9uKGUpKSx0aGlzLl9zaWduYWwoImNoYW5nZVNlc3Npb24iLHtzZXNzaW9uOmUsb2xkU2Vzc2lvbjp0fSksdGhpcy5jdXJPcD1udWxsLHQmJnQuX3NpZ25hbCgiY2hhbmdlRWRpdG9yIix7b2xkRWRpdG9yOnRoaXN9KSxlJiZlLl9zaWduYWwoImNoYW5nZUVkaXRvciIse2VkaXRvcjp0aGlzfSksZSYmIWUuZGVzdHJveWVkJiZlLmJnVG9rZW5pemVyLnNjaGVkdWxlU3RhcnQoKX0sdGhpcy5nZXRTZXNzaW9uPWZ1bmN0aW9uKCl7cmV0dXJuIHRoaXMuc2Vzc2lvbn0sdGhpcy5zZXRWYWx1ZT1mdW5jdGlvbihlLHQpe3JldHVybiB0aGlzLnNlc3Npb24uZG9jLnNldFZhbHVlKGUpLHQ/dD09MT90aGlzLm5hdmlnYXRlRmlsZUVuZCgpOnQ9PS0xJiZ0aGlzLm5hdmlnYXRlRmlsZVN0YXJ0KCk6dGhpcy5zZWxlY3RBbGwoKSxlfSx0aGlzLmdldFZhbHVlPWZ1bmN0aW9uKCl7cmV0dXJuIHRoaXMuc2Vzc2lvbi5nZXRWYWx1ZSgpfSx0aGlzLmdldFNlbGVjdGlvbj1mdW5jdGlvbigpe3JldHVybiB0aGlzLnNlbGVjdGlvbn0sdGhpcy5yZXNpemU9ZnVuY3Rpb24oZSl7dGhpcy5yZW5kZXJlci5vblJlc2l6ZShlKX0sdGhpcy5zZXRUaGVtZT1mdW5jdGlvbihlLHQpe3RoaXMucmVuZGVyZXIuc2V0VGhlbWUoZSx0KX0sdGhpcy5nZXRUaGVtZT1mdW5jdGlvbigpe3JldHVybiB0aGlzLnJlbmRlcmVyLmdldFRoZW1lKCl9LHRoaXMuc2V0U3R5bGU9ZnVuY3Rpb24oZSl7dGhpcy5yZW5kZXJlci5zZXRTdHlsZShlKX0sdGhpcy51bnNldFN0eWxlPWZ1bmN0aW9uKGUpe3RoaXMucmVuZGVyZXIudW5zZXRTdHlsZShlKX0sdGhpcy5nZXRGb250U2l6ZT1mdW5jdGlvbigpe3JldHVybiB0aGlzLmdldE9wdGlvbigiZm9udFNpemUiKXx8cy5jb21wdXRlZFN0eWxlKHRoaXMuY29udGFpbmVyKS5mb250U2l6ZX0sdGhpcy5zZXRGb250U2l6ZT1mdW5jdGlvbihlKXt0aGlzLnNldE9wdGlvbigiZm9udFNpemUiLGUpfSx0aGlzLiRoaWdobGlnaHRCcmFja2V0cz1mdW5jdGlvbigpe2lmKHRoaXMuJGhpZ2hsaWdodFBlbmRpbmcpcmV0dXJuO3ZhciBlPXRoaXM7dGhpcy4kaGlnaGxpZ2h0UGVuZGluZz0hMCxzZXRUaW1lb3V0KGZ1bmN0aW9uKCl7ZS4kaGlnaGxpZ2h0UGVuZGluZz0hMTt2YXIgdD1lLnNlc3Npb247aWYoIXR8fHQuZGVzdHJveWVkKXJldHVybjt0LiRicmFja2V0SGlnaGxpZ2h0JiYodC4kYnJhY2tldEhpZ2hsaWdodC5tYXJrZXJJZHMuZm9yRWFjaChmdW5jdGlvbihlKXt0LnJlbW92ZU1hcmtlcihlKX0pLHQuJGJyYWNrZXRIaWdobGlnaHQ9bnVsbCk7dmFyIG49ZS5nZXRDdXJzb3JQb3NpdGlvbigpLHI9ZS5nZXRLZXlib2FyZEhhbmRsZXIoKSxpPXImJnIuJGdldERpcmVjdGlvbkZvckhpZ2hsaWdodCYmci4kZ2V0RGlyZWN0aW9uRm9ySGlnaGxpZ2h0KGUpLHM9dC5nZXRNYXRjaGluZ0JyYWNrZXRSYW5nZXMobixpKTtpZighcyl7dmFyIG89bmV3IGIodCxuLnJvdyxuLmNvbHVtbiksdT1vLmdldEN1cnJlbnRUb2tlbigpO2lmKHUmJi9cYig/OnRhZy1vcGVufHRhZy1uYW1lKS8udGVzdCh1LnR5cGUpKXt2YXIgYT10LmdldE1hdGNoaW5nVGFncyhuKTthJiYocz1bYS5vcGVuVGFnTmFtZSxhLmNsb3NlVGFnTmFtZV0pfX0hcyYmdC4kbW9kZS5nZXRNYXRjaGluZyYmKHM9dC4kbW9kZS5nZXRNYXRjaGluZyhlLnNlc3Npb24pKTtpZighcyl7ZS5nZXRIaWdobGlnaHRJbmRlbnRHdWlkZXMoKSYmZS5yZW5kZXJlci4kdGV4dExheWVyLiRoaWdobGlnaHRJbmRlbnRHdWlkZSgpO3JldHVybn12YXIgZj0iYWNlX2JyYWNrZXQiO0FycmF5LmlzQXJyYXkocyk/cy5sZW5ndGg9PTEmJihmPSJhY2VfZXJyb3JfYnJhY2tldCIpOnM9W3NdLHMubGVuZ3RoPT0yJiYoZC5jb21wYXJlUG9pbnRzKHNbMF0uZW5kLHNbMV0uc3RhcnQpPT0wP3M9W2QuZnJvbVBvaW50cyhzWzBdLnN0YXJ0LHNbMV0uZW5kKV06ZC5jb21wYXJlUG9pbnRzKHNbMF0uc3RhcnQsc1sxXS5lbmQpPT0wJiYocz1bZC5mcm9tUG9pbnRzKHNbMV0uc3RhcnQsc1swXS5lbmQpXSkpLHQuJGJyYWNrZXRIaWdobGlnaHQ9e3JhbmdlczpzLG1hcmtlcklkczpzLm1hcChmdW5jdGlvbihlKXtyZXR1cm4gdC5hZGRNYXJrZXIoZSxmLCJ0ZXh0Iil9KX0sZS5nZXRIaWdobGlnaHRJbmRlbnRHdWlkZXMoKSYmZS5yZW5kZXJlci4kdGV4dExheWVyLiRoaWdobGlnaHRJbmRlbnRHdWlkZSgpfSw1MCl9LHRoaXMuZm9jdXM9ZnVuY3Rpb24oKXt0aGlzLnRleHRJbnB1dC5mb2N1cygpfSx0aGlzLmlzRm9jdXNlZD1mdW5jdGlvbigpe3JldHVybiB0aGlzLnRleHRJbnB1dC5pc0ZvY3VzZWQoKX0sdGhpcy5ibHVyPWZ1bmN0aW9uKCl7dGhpcy50ZXh0SW5wdXQuYmx1cigpfSx0aGlzLm9uRm9jdXM9ZnVuY3Rpb24oZSl7aWYodGhpcy4kaXNGb2N1c2VkKXJldHVybjt0aGlzLiRpc0ZvY3VzZWQ9ITAsdGhpcy5yZW5kZXJlci5zaG93Q3Vyc29yKCksdGhpcy5yZW5kZXJlci52aXN1YWxpemVGb2N1cygpLHRoaXMuX2VtaXQoImZvY3VzIixlKX0sdGhpcy5vbkJsdXI9ZnVuY3Rpb24oZSl7aWYoIXRoaXMuJGlzRm9jdXNlZClyZXR1cm47dGhpcy4kaXNGb2N1c2VkPSExLHRoaXMucmVuZGVyZXIuaGlkZUN1cnNvcigpLHRoaXMucmVuZGVyZXIudmlzdWFsaXplQmx1cigpLHRoaXMuX2VtaXQoImJsdXIiLGUpfSx0aGlzLiRjdXJzb3JDaGFuZ2U9ZnVuY3Rpb24oKXt0aGlzLnJlbmRlcmVyLnVwZGF0ZUN1cnNvcigpLHRoaXMuJGhpZ2hsaWdodEJyYWNrZXRzKCksdGhpcy4kdXBkYXRlSGlnaGxpZ2h0QWN0aXZlTGluZSgpfSx0aGlzLm9uRG9jdW1lbnRDaGFuZ2U9ZnVuY3Rpb24oZSl7dmFyIHQ9dGhpcy5zZXNzaW9uLiR1c2VXcmFwTW9kZSxuPWUuc3RhcnQucm93PT1lLmVuZC5yb3c/ZS5lbmQucm93OkluZmluaXR5O3RoaXMucmVuZGVyZXIudXBkYXRlTGluZXMoZS5zdGFydC5yb3csbix0KSx0aGlzLl9zaWduYWwoImNoYW5nZSIsZSksdGhpcy4kY3Vyc29yQ2hhbmdlKCl9LHRoaXMub25Ub2tlbml6ZXJVcGRhdGU9ZnVuY3Rpb24oZSl7dmFyIHQ9ZS5kYXRhO3RoaXMucmVuZGVyZXIudXBkYXRlTGluZXModC5maXJzdCx0Lmxhc3QpfSx0aGlzLm9uU2Nyb2xsVG9wQ2hhbmdlPWZ1bmN0aW9uKCl7dGhpcy5yZW5kZXJlci5zY3JvbGxUb1kodGhpcy5zZXNzaW9uLmdldFNjcm9sbFRvcCgpKX0sdGhpcy5vblNjcm9sbExlZnRDaGFuZ2U9ZnVuY3Rpb24oKXt0aGlzLnJlbmRlcmVyLnNjcm9sbFRvWCh0aGlzLnNlc3Npb24uZ2V0U2Nyb2xsTGVmdCgpKX0sdGhpcy5vbkN1cnNvckNoYW5nZT1mdW5jdGlvbigpe3RoaXMuJGN1cnNvckNoYW5nZSgpLHRoaXMuX3NpZ25hbCgiY2hhbmdlU2VsZWN0aW9uIil9LHRoaXMuJHVwZGF0ZUhpZ2hsaWdodEFjdGl2ZUxpbmU9ZnVuY3Rpb24oKXt2YXIgZT10aGlzLmdldFNlc3Npb24oKSx0O2lmKHRoaXMuJGhpZ2hsaWdodEFjdGl2ZUxpbmUpe2lmKHRoaXMuJHNlbGVjdGlvblN0eWxlIT0ibGluZSJ8fCF0aGlzLnNlbGVjdGlvbi5pc011bHRpTGluZSgpKXQ9dGhpcy5nZXRDdXJzb3JQb3NpdGlvbigpO3RoaXMucmVuZGVyZXIudGhlbWUmJnRoaXMucmVuZGVyZXIudGhlbWUuJHNlbGVjdGlvbkNvbG9yQ29uZmxpY3QmJiF0aGlzLnNlbGVjdGlvbi5pc0VtcHR5KCkmJih0PSExKSx0aGlzLnJlbmRlcmVyLiRtYXhMaW5lcyYmdGhpcy5zZXNzaW9uLmdldExlbmd0aCgpPT09MSYmISh0aGlzLnJlbmRlcmVyLiRtaW5MaW5lcz4xKSYmKHQ9ITEpfWlmKGUuJGhpZ2hsaWdodExpbmVNYXJrZXImJiF0KWUucmVtb3ZlTWFya2VyKGUuJGhpZ2hsaWdodExpbmVNYXJrZXIuaWQpLGUuJGhpZ2hsaWdodExpbmVNYXJrZXI9bnVsbDtlbHNlIGlmKCFlLiRoaWdobGlnaHRMaW5lTWFya2VyJiZ0KXt2YXIgbj1uZXcgZCh0LnJvdyx0LmNvbHVtbix0LnJvdyxJbmZpbml0eSk7bi5pZD1lLmFkZE1hcmtlcihuLCJhY2VfYWN0aXZlLWxpbmUiLCJzY3JlZW5MaW5lIiksZS4kaGlnaGxpZ2h0TGluZU1hcmtlcj1ufWVsc2UgdCYmKGUuJGhpZ2hsaWdodExpbmVNYXJrZXIuc3RhcnQucm93PXQucm93LGUuJGhpZ2hsaWdodExpbmVNYXJrZXIuZW5kLnJvdz10LnJvdyxlLiRoaWdobGlnaHRMaW5lTWFya2VyLnN0YXJ0LmNvbHVtbj10LmNvbHVtbixlLl9zaWduYWwoImNoYW5nZUJhY2tNYXJrZXIiKSl9LHRoaXMub25TZWxlY3Rpb25DaGFuZ2U9ZnVuY3Rpb24oZSl7dmFyIHQ9dGhpcy5zZXNzaW9uO3QuJHNlbGVjdGlvbk1hcmtlciYmdC5yZW1vdmVNYXJrZXIodC4kc2VsZWN0aW9uTWFya2VyKSx0LiRzZWxlY3Rpb25NYXJrZXI9bnVsbDtpZighdGhpcy5zZWxlY3Rpb24uaXNFbXB0eSgpKXt2YXIgbj10aGlzLnNlbGVjdGlvbi5nZXRSYW5nZSgpLHI9dGhpcy5nZXRTZWxlY3Rpb25TdHlsZSgpO3QuJHNlbGVjdGlvbk1hcmtlcj10LmFkZE1hcmtlcihuLCJhY2Vfc2VsZWN0aW9uIixyKX1lbHNlIHRoaXMuJHVwZGF0ZUhpZ2hsaWdodEFjdGl2ZUxpbmUoKTt2YXIgaT10aGlzLiRoaWdobGlnaHRTZWxlY3RlZFdvcmQmJnRoaXMuJGdldFNlbGVjdGlvbkhpZ2hMaWdodFJlZ2V4cCgpO3RoaXMuc2Vzc2lvbi5oaWdobGlnaHQoaSksdGhpcy5fc2lnbmFsKCJjaGFuZ2VTZWxlY3Rpb24iKX0sdGhpcy4kZ2V0U2VsZWN0aW9uSGlnaExpZ2h0UmVnZXhwPWZ1bmN0aW9uKCl7dmFyIGU9dGhpcy5zZXNzaW9uLHQ9dGhpcy5nZXRTZWxlY3Rpb25SYW5nZSgpO2lmKHQuaXNFbXB0eSgpfHx0LmlzTXVsdGlMaW5lKCkpcmV0dXJuO3ZhciBuPXQuc3RhcnQuY29sdW1uLHI9dC5lbmQuY29sdW1uLGk9ZS5nZXRMaW5lKHQuc3RhcnQucm93KSxzPWkuc3Vic3RyaW5nKG4scik7aWYocy5sZW5ndGg+NWUzfHwhL1tcd1xkXS8udGVzdChzKSlyZXR1cm47dmFyIG89dGhpcy4kc2VhcmNoLiRhc3NlbWJsZVJlZ0V4cCh7d2hvbGVXb3JkOiEwLGNhc2VTZW5zaXRpdmU6ITAsbmVlZGxlOnN9KSx1PWkuc3Vic3RyaW5nKG4tMSxyKzEpO2lmKCFvLnRlc3QodSkpcmV0dXJuO3JldHVybiBvfSx0aGlzLm9uQ2hhbmdlRnJvbnRNYXJrZXI9ZnVuY3Rpb24oKXt0aGlzLnJlbmRlcmVyLnVwZGF0ZUZyb250TWFya2VycygpfSx0aGlzLm9uQ2hhbmdlQmFja01hcmtlcj1mdW5jdGlvbigpe3RoaXMucmVuZGVyZXIudXBkYXRlQmFja01hcmtlcnMoKX0sdGhpcy5vbkNoYW5nZUJyZWFrcG9pbnQ9ZnVuY3Rpb24oKXt0aGlzLnJlbmRlcmVyLnVwZGF0ZUJyZWFrcG9pbnRzKCl9LHRoaXMub25DaGFuZ2VBbm5vdGF0aW9uPWZ1bmN0aW9uKCl7dGhpcy5yZW5kZXJlci5zZXRBbm5vdGF0aW9ucyh0aGlzLnNlc3Npb24uZ2V0QW5ub3RhdGlvbnMoKSl9LHRoaXMub25DaGFuZ2VNb2RlPWZ1bmN0aW9uKGUpe3RoaXMucmVuZGVyZXIudXBkYXRlVGV4dCgpLHRoaXMuX2VtaXQoImNoYW5nZU1vZGUiLGUpfSx0aGlzLm9uQ2hhbmdlV3JhcExpbWl0PWZ1bmN0aW9uKCl7dGhpcy5yZW5kZXJlci51cGRhdGVGdWxsKCl9LHRoaXMub25DaGFuZ2VXcmFwTW9kZT1mdW5jdGlvbigpe3RoaXMucmVuZGVyZXIub25SZXNpemUoITApfSx0aGlzLm9uQ2hhbmdlRm9sZD1mdW5jdGlvbigpe3RoaXMuJHVwZGF0ZUhpZ2hsaWdodEFjdGl2ZUxpbmUoKSx0aGlzLnJlbmRlcmVyLnVwZGF0ZUZ1bGwoKX0sdGhpcy5nZXRTZWxlY3RlZFRleHQ9ZnVuY3Rpb24oKXtyZXR1cm4gdGhpcy5zZXNzaW9uLmdldFRleHRSYW5nZSh0aGlzLmdldFNlbGVjdGlvblJhbmdlKCkpfSx0aGlzLmdldENvcHlUZXh0PWZ1bmN0aW9uKCl7dmFyIGU9dGhpcy5nZXRTZWxlY3RlZFRleHQoKSx0PXRoaXMuc2Vzc2lvbi5kb2MuZ2V0TmV3TGluZUNoYXJhY3RlcigpLG49ITE7aWYoIWUmJnRoaXMuJGNvcHlXaXRoRW1wdHlTZWxlY3Rpb24pe249ITA7dmFyIHI9dGhpcy5zZWxlY3Rpb24uZ2V0QWxsUmFuZ2VzKCk7Zm9yKHZhciBpPTA7aTxyLmxlbmd0aDtpKyspe3ZhciBzPXJbaV07aWYoaSYmcltpLTFdLnN0YXJ0LnJvdz09cy5zdGFydC5yb3cpY29udGludWU7ZSs9dGhpcy5zZXNzaW9uLmdldExpbmUocy5zdGFydC5yb3cpK3R9fXZhciBvPXt0ZXh0OmV9O3JldHVybiB0aGlzLl9zaWduYWwoImNvcHkiLG8pLHcubGluZU1vZGU9bj9vLnRleHQ6ITEsby50ZXh0fSx0aGlzLm9uQ29weT1mdW5jdGlvbigpe3RoaXMuY29tbWFuZHMuZXhlYygiY29weSIsdGhpcyl9LHRoaXMub25DdXQ9ZnVuY3Rpb24oKXt0aGlzLmNvbW1hbmRzLmV4ZWMoImN1dCIsdGhpcyl9LHRoaXMub25QYXN0ZT1mdW5jdGlvbihlLHQpe3ZhciBuPXt0ZXh0OmUsZXZlbnQ6dH07dGhpcy5jb21tYW5kcy5leGVjKCJwYXN0ZSIsdGhpcyxuKX0sdGhpcy4kaGFuZGxlUGFzdGU9ZnVuY3Rpb24oZSl7dHlwZW9mIGU9PSJzdHJpbmciJiYoZT17dGV4dDplfSksdGhpcy5fc2lnbmFsKCJwYXN0ZSIsZSk7dmFyIHQ9ZS50ZXh0LG49dD09PXcubGluZU1vZGUscj10aGlzLnNlc3Npb247aWYoIXRoaXMuaW5NdWx0aVNlbGVjdE1vZGV8fHRoaXMuaW5WaXJ0dWFsU2VsZWN0aW9uTW9kZSluP3IuaW5zZXJ0KHtyb3c6dGhpcy5zZWxlY3Rpb24ubGVhZC5yb3csY29sdW1uOjB9LHQpOnRoaXMuaW5zZXJ0KHQpO2Vsc2UgaWYobil0aGlzLnNlbGVjdGlvbi5yYW5nZUxpc3QucmFuZ2VzLmZvckVhY2goZnVuY3Rpb24oZSl7ci5pbnNlcnQoe3JvdzplLnN0YXJ0LnJvdyxjb2x1bW46MH0sdCl9KTtlbHNle3ZhciBpPXQuc3BsaXQoL1xyXG58XHJ8XG4vKSxzPXRoaXMuc2VsZWN0aW9uLnJhbmdlTGlzdC5yYW5nZXMsbz1pLmxlbmd0aD09MiYmKCFpWzBdfHwhaVsxXSk7aWYoaS5sZW5ndGghPXMubGVuZ3RofHxvKXJldHVybiB0aGlzLmNvbW1hbmRzLmV4ZWMoImluc2VydHN0cmluZyIsdGhpcyx0KTtmb3IodmFyIHU9cy5sZW5ndGg7dS0tOyl7dmFyIGE9c1t1XTthLmlzRW1wdHkoKXx8ci5yZW1vdmUoYSksci5pbnNlcnQoYS5zdGFydCxpW3VdKX19fSx0aGlzLmV4ZWNDb21tYW5kPWZ1bmN0aW9uKGUsdCl7cmV0dXJuIHRoaXMuY29tbWFuZHMuZXhlYyhlLHRoaXMsdCl9LHRoaXMuaW5zZXJ0PWZ1bmN0aW9uKGUsdCl7dmFyIG49dGhpcy5zZXNzaW9uLHI9bi5nZXRNb2RlKCksaT10aGlzLmdldEN1cnNvclBvc2l0aW9uKCk7aWYodGhpcy5nZXRCZWhhdmlvdXJzRW5hYmxlZCgpJiYhdCl7dmFyIHM9ci50cmFuc2Zvcm1BY3Rpb24obi5nZXRTdGF0ZShpLnJvdyksImluc2VydGlvbiIsdGhpcyxuLGUpO3MmJihlIT09cy50ZXh0JiYodGhpcy5pblZpcnR1YWxTZWxlY3Rpb25Nb2RlfHwodGhpcy5zZXNzaW9uLm1lcmdlVW5kb0RlbHRhcz0hMSx0aGlzLm1lcmdlTmV4dENvbW1hbmQ9ITEpKSxlPXMudGV4dCl9ZT09IgkiJiYoZT10aGlzLnNlc3Npb24uZ2V0VGFiU3RyaW5nKCkpO2lmKCF0aGlzLnNlbGVjdGlvbi5pc0VtcHR5KCkpe3ZhciBvPXRoaXMuZ2V0U2VsZWN0aW9uUmFuZ2UoKTtpPXRoaXMuc2Vzc2lvbi5yZW1vdmUobyksdGhpcy5jbGVhclNlbGVjdGlvbigpfWVsc2UgaWYodGhpcy5zZXNzaW9uLmdldE92ZXJ3cml0ZSgpJiZlLmluZGV4T2YoIlxuIik9PS0xKXt2YXIgbz1uZXcgZC5mcm9tUG9pbnRzKGksaSk7by5lbmQuY29sdW1uKz1lLmxlbmd0aCx0aGlzLnNlc3Npb24ucmVtb3ZlKG8pfWlmKGU9PSJcbiJ8fGU9PSJcclxuIil7dmFyIHU9bi5nZXRMaW5lKGkucm93KTtpZihpLmNvbHVtbj51LnNlYXJjaCgvXFN8JC8pKXt2YXIgYT11LnN1YnN0cihpLmNvbHVtbikuc2VhcmNoKC9cU3wkLyk7bi5kb2MucmVtb3ZlSW5MaW5lKGkucm93LGkuY29sdW1uLGkuY29sdW1uK2EpfX10aGlzLmNsZWFyU2VsZWN0aW9uKCk7dmFyIGY9aS5jb2x1bW4sbD1uLmdldFN0YXRlKGkucm93KSx1PW4uZ2V0TGluZShpLnJvdyksYz1yLmNoZWNrT3V0ZGVudChsLHUsZSk7bi5pbnNlcnQoaSxlKSxzJiZzLnNlbGVjdGlvbiYmKHMuc2VsZWN0aW9uLmxlbmd0aD09Mj90aGlzLnNlbGVjdGlvbi5zZXRTZWxlY3Rpb25SYW5nZShuZXcgZChpLnJvdyxmK3Muc2VsZWN0aW9uWzBdLGkucm93LGYrcy5zZWxlY3Rpb25bMV0pKTp0aGlzLnNlbGVjdGlvbi5zZXRTZWxlY3Rpb25SYW5nZShuZXcgZChpLnJvdytzLnNlbGVjdGlvblswXSxzLnNlbGVjdGlvblsxXSxpLnJvdytzLnNlbGVjdGlvblsyXSxzLnNlbGVjdGlvblszXSkpKTtpZih0aGlzLiRlbmFibGVBdXRvSW5kZW50KXtpZihuLmdldERvY3VtZW50KCkuaXNOZXdMaW5lKGUpKXt2YXIgaD1yLmdldE5leHRMaW5lSW5kZW50KGwsdS5zbGljZSgwLGkuY29sdW1uKSxuLmdldFRhYlN0cmluZygpKTtuLmluc2VydCh7cm93Omkucm93KzEsY29sdW1uOjB9LGgpfWMmJnIuYXV0b091dGRlbnQobCxuLGkucm93KX19LHRoaXMuYXV0b0luZGVudD1mdW5jdGlvbigpe3ZhciBlPXRoaXMuc2Vzc2lvbix0PWUuZ2V0TW9kZSgpLG4scjtpZih0aGlzLnNlbGVjdGlvbi5pc0VtcHR5KCkpbj0wLHI9ZS5kb2MuZ2V0TGVuZ3RoKCktMTtlbHNle3ZhciBpPXRoaXMuZ2V0U2VsZWN0aW9uUmFuZ2UoKTtuPWkuc3RhcnQucm93LHI9aS5lbmQucm93fXZhciBzPSIiLG89IiIsdT0iIixhLGYsbCxjPWUuZ2V0VGFiU3RyaW5nKCk7Zm9yKHZhciBoPW47aDw9cjtoKyspaD4wJiYocz1lLmdldFN0YXRlKGgtMSksbz1lLmdldExpbmUoaC0xKSx1PXQuZ2V0TmV4dExpbmVJbmRlbnQocyxvLGMpKSxhPWUuZ2V0TGluZShoKSxmPXQuJGdldEluZGVudChhKSx1IT09ZiYmKGYubGVuZ3RoPjAmJihsPW5ldyBkKGgsMCxoLGYubGVuZ3RoKSxlLnJlbW92ZShsKSksdS5sZW5ndGg+MCYmZS5pbnNlcnQoe3JvdzpoLGNvbHVtbjowfSx1KSksdC5hdXRvT3V0ZGVudChzLGUsaCl9LHRoaXMub25UZXh0SW5wdXQ9ZnVuY3Rpb24oZSx0KXtpZighdClyZXR1cm4gdGhpcy5rZXlCaW5kaW5nLm9uVGV4dElucHV0KGUpO3RoaXMuc3RhcnRPcGVyYXRpb24oe2NvbW1hbmQ6e25hbWU6Imluc2VydHN0cmluZyJ9fSk7dmFyIG49dGhpcy5hcHBseUNvbXBvc2l0aW9uLmJpbmQodGhpcyxlLHQpO3RoaXMuc2VsZWN0aW9uLnJhbmdlQ291bnQ/dGhpcy5mb3JFYWNoU2VsZWN0aW9uKG4pOm4oKSx0aGlzLmVuZE9wZXJhdGlvbigpfSx0aGlzLmFwcGx5Q29tcG9zaXRpb249ZnVuY3Rpb24oZSx0KXtpZih0LmV4dGVuZExlZnR8fHQuZXh0ZW5kUmlnaHQpe3ZhciBuPXRoaXMuc2VsZWN0aW9uLmdldFJhbmdlKCk7bi5zdGFydC5jb2x1bW4tPXQuZXh0ZW5kTGVmdCxuLmVuZC5jb2x1bW4rPXQuZXh0ZW5kUmlnaHQsbi5zdGFydC5jb2x1bW48MCYmKG4uc3RhcnQucm93LS0sbi5zdGFydC5jb2x1bW4rPXRoaXMuc2Vzc2lvbi5nZXRMaW5lKG4uc3RhcnQucm93KS5sZW5ndGgrMSksdGhpcy5zZWxlY3Rpb24uc2V0UmFuZ2UobiksIWUmJiFuLmlzRW1wdHkoKSYmdGhpcy5yZW1vdmUoKX0oZXx8IXRoaXMuc2VsZWN0aW9uLmlzRW1wdHkoKSkmJnRoaXMuaW5zZXJ0KGUsITApO2lmKHQucmVzdG9yZVN0YXJ0fHx0LnJlc3RvcmVFbmQpe3ZhciBuPXRoaXMuc2VsZWN0aW9uLmdldFJhbmdlKCk7bi5zdGFydC5jb2x1bW4tPXQucmVzdG9yZVN0YXJ0LG4uZW5kLmNvbHVtbi09dC5yZXN0b3JlRW5kLHRoaXMuc2VsZWN0aW9uLnNldFJhbmdlKG4pfX0sdGhpcy5vbkNvbW1hbmRLZXk9ZnVuY3Rpb24oZSx0LG4pe3JldHVybiB0aGlzLmtleUJpbmRpbmcub25Db21tYW5kS2V5KGUsdCxuKX0sdGhpcy5zZXRPdmVyd3JpdGU9ZnVuY3Rpb24oZSl7dGhpcy5zZXNzaW9uLnNldE92ZXJ3cml0ZShlKX0sdGhpcy5nZXRPdmVyd3JpdGU9ZnVuY3Rpb24oKXtyZXR1cm4gdGhpcy5zZXNzaW9uLmdldE92ZXJ3cml0ZSgpfSx0aGlzLnRvZ2dsZU92ZXJ3cml0ZT1mdW5jdGlvbigpe3RoaXMuc2Vzc2lvbi50b2dnbGVPdmVyd3JpdGUoKX0sdGhpcy5zZXRTY3JvbGxTcGVlZD1mdW5jdGlvbihlKXt0aGlzLnNldE9wdGlvbigic2Nyb2xsU3BlZWQiLGUpfSx0aGlzLmdldFNjcm9sbFNwZWVkPWZ1bmN0aW9uKCl7cmV0dXJuIHRoaXMuZ2V0T3B0aW9uKCJzY3JvbGxTcGVlZCIpfSx0aGlzLnNldERyYWdEZWxheT1mdW5jdGlvbihlKXt0aGlzLnNldE9wdGlvbigiZHJhZ0RlbGF5IixlKX0sdGhpcy5nZXREcmFnRGVsYXk9ZnVuY3Rpb24oKXtyZXR1cm4gdGhpcy5nZXRPcHRpb24oImRyYWdEZWxheSIpfSx0aGlzLnNldFNlbGVjdGlvblN0eWxlPWZ1bmN0aW9uKGUpe3RoaXMuc2V0T3B0aW9uKCJzZWxlY3Rpb25TdHlsZSIsZSl9LHRoaXMuZ2V0U2VsZWN0aW9uU3R5bGU9ZnVuY3Rpb24oKXtyZXR1cm4gdGhpcy5nZXRPcHRpb24oInNlbGVjdGlvblN0eWxlIil9LHRoaXMuc2V0SGlnaGxpZ2h0QWN0aXZlTGluZT1mdW5jdGlvbihlKXt0aGlzLnNldE9wdGlvbigiaGlnaGxpZ2h0QWN0aXZlTGluZSIsZSl9LHRoaXMuZ2V0SGlnaGxpZ2h0QWN0aXZlTGluZT1mdW5jdGlvbigpe3JldHVybiB0aGlzLmdldE9wdGlvbigiaGlnaGxpZ2h0QWN0aXZlTGluZSIpfSx0aGlzLnNldEhpZ2hsaWdodEd1dHRlckxpbmU9ZnVuY3Rpb24oZSl7dGhpcy5zZXRPcHRpb24oImhpZ2hsaWdodEd1dHRlckxpbmUiLGUpfSx0aGlzLmdldEhpZ2hsaWdodEd1dHRlckxpbmU9ZnVuY3Rpb24oKXtyZXR1cm4gdGhpcy5nZXRPcHRpb24oImhpZ2hsaWdodEd1dHRlckxpbmUiKX0sdGhpcy5zZXRIaWdobGlnaHRTZWxlY3RlZFdvcmQ9ZnVuY3Rpb24oZSl7dGhpcy5zZXRPcHRpb24oImhpZ2hsaWdodFNlbGVjdGVkV29yZCIsZSl9LHRoaXMuZ2V0SGlnaGxpZ2h0U2VsZWN0ZWRXb3JkPWZ1bmN0aW9uKCl7cmV0dXJuIHRoaXMuJGhpZ2hsaWdodFNlbGVjdGVkV29yZH0sdGhpcy5zZXRBbmltYXRlZFNjcm9sbD1mdW5jdGlvbihlKXt0aGlzLnJlbmRlcmVyLnNldEFuaW1hdGVkU2Nyb2xsKGUpfSx0aGlzLmdldEFuaW1hdGVkU2Nyb2xsPWZ1bmN0aW9uKCl7cmV0dXJuIHRoaXMucmVuZGVyZXIuZ2V0QW5pbWF0ZWRTY3JvbGwoKX0sdGhpcy5zZXRTaG93SW52aXNpYmxlcz1mdW5jdGlvbihlKXt0aGlzLnJlbmRlcmVyLnNldFNob3dJbnZpc2libGVzKGUpfSx0aGlzLmdldFNob3dJbnZpc2libGVzPWZ1bmN0aW9uKCl7cmV0dXJuIHRoaXMucmVuZGVyZXIuZ2V0U2hvd0ludmlzaWJsZXMoKX0sdGhpcy5zZXREaXNwbGF5SW5kZW50R3VpZGVzPWZ1bmN0aW9uKGUpe3RoaXMucmVuZGVyZXIuc2V0RGlzcGxheUluZGVudEd1aWRlcyhlKX0sdGhpcy5nZXREaXNwbGF5SW5kZW50R3VpZGVzPWZ1bmN0aW9uKCl7cmV0dXJuIHRoaXMucmVuZGVyZXIuZ2V0RGlzcGxheUluZGVudEd1aWRlcygpfSx0aGlzLnNldEhpZ2hsaWdodEluZGVudEd1aWRlcz1mdW5jdGlvbihlKXt0aGlzLnJlbmRlcmVyLnNldEhpZ2hsaWdodEluZGVudEd1aWRlcyhlKX0sdGhpcy5nZXRIaWdobGlnaHRJbmRlbnRHdWlkZXM9ZnVuY3Rpb24oKXtyZXR1cm4gdGhpcy5yZW5kZXJlci5nZXRIaWdobGlnaHRJbmRlbnRHdWlkZXMoKX0sdGhpcy5zZXRTaG93UHJpbnRNYXJnaW49ZnVuY3Rpb24oZSl7dGhpcy5yZW5kZXJlci5zZXRTaG93UHJpbnRNYXJnaW4oZSl9LHRoaXMuZ2V0U2hvd1ByaW50TWFyZ2luPWZ1bmN0aW9uKCl7cmV0dXJuIHRoaXMucmVuZGVyZXIuZ2V0U2hvd1ByaW50TWFyZ2luKCl9LHRoaXMuc2V0UHJpbnRNYXJnaW5Db2x1bW49ZnVuY3Rpb24oZSl7dGhpcy5yZW5kZXJlci5zZXRQcmludE1hcmdpbkNvbHVtbihlKX0sdGhpcy5nZXRQcmludE1hcmdpbkNvbHVtbj1mdW5jdGlvbigpe3JldHVybiB0aGlzLnJlbmRlcmVyLmdldFByaW50TWFyZ2luQ29sdW1uKCl9LHRoaXMuc2V0UmVhZE9ubHk9ZnVuY3Rpb24oZSl7dGhpcy5zZXRPcHRpb24oInJlYWRPbmx5IixlKX0sdGhpcy5nZXRSZWFkT25seT1mdW5jdGlvbigpe3JldHVybiB0aGlzLmdldE9wdGlvbigicmVhZE9ubHkiKX0sdGhpcy5zZXRCZWhhdmlvdXJzRW5hYmxlZD1mdW5jdGlvbihlKXt0aGlzLnNldE9wdGlvbigiYmVoYXZpb3Vyc0VuYWJsZWQiLGUpfSx0aGlzLmdldEJlaGF2aW91cnNFbmFibGVkPWZ1bmN0aW9uKCl7cmV0dXJuIHRoaXMuZ2V0T3B0aW9uKCJiZWhhdmlvdXJzRW5hYmxlZCIpfSx0aGlzLnNldFdyYXBCZWhhdmlvdXJzRW5hYmxlZD1mdW5jdGlvbihlKXt0aGlzLnNldE9wdGlvbigid3JhcEJlaGF2aW91cnNFbmFibGVkIixlKX0sdGhpcy5nZXRXcmFwQmVoYXZpb3Vyc0VuYWJsZWQ9ZnVuY3Rpb24oKXtyZXR1cm4gdGhpcy5nZXRPcHRpb24oIndyYXBCZWhhdmlvdXJzRW5hYmxlZCIpfSx0aGlzLnNldFNob3dGb2xkV2lkZ2V0cz1mdW5jdGlvbihlKXt0aGlzLnNldE9wdGlvbigic2hvd0ZvbGRXaWRnZXRzIixlKX0sdGhpcy5nZXRTaG93Rm9sZFdpZGdldHM9ZnVuY3Rpb24oKXtyZXR1cm4gdGhpcy5nZXRPcHRpb24oInNob3dGb2xkV2lkZ2V0cyIpfSx0aGlzLnNldEZhZGVGb2xkV2lkZ2V0cz1mdW5jdGlvbihlKXt0aGlzLnNldE9wdGlvbigiZmFkZUZvbGRXaWRnZXRzIixlKX0sdGhpcy5nZXRGYWRlRm9sZFdpZGdldHM9ZnVuY3Rpb24oKXtyZXR1cm4gdGhpcy5nZXRPcHRpb24oImZhZGVGb2xkV2lkZ2V0cyIpfSx0aGlzLnJlbW92ZT1mdW5jdGlvbihlKXt0aGlzLnNlbGVjdGlvbi5pc0VtcHR5KCkmJihlPT0ibGVmdCI/dGhpcy5zZWxlY3Rpb24uc2VsZWN0TGVmdCgpOnRoaXMuc2VsZWN0aW9uLnNlbGVjdFJpZ2h0KCkpO3ZhciB0PXRoaXMuZ2V0U2VsZWN0aW9uUmFuZ2UoKTtpZih0aGlzLmdldEJlaGF2aW91cnNFbmFibGVkKCkpe3ZhciBuPXRoaXMuc2Vzc2lvbixyPW4uZ2V0U3RhdGUodC5zdGFydC5yb3cpLGk9bi5nZXRNb2RlKCkudHJhbnNmb3JtQWN0aW9uKHIsImRlbGV0aW9uIix0aGlzLG4sdCk7aWYodC5lbmQuY29sdW1uPT09MCl7dmFyIHM9bi5nZXRUZXh0UmFuZ2UodCk7aWYoc1tzLmxlbmd0aC0xXT09IlxuIil7dmFyIG89bi5nZXRMaW5lKHQuZW5kLnJvdyk7L15ccyskLy50ZXN0KG8pJiYodC5lbmQuY29sdW1uPW8ubGVuZ3RoKX19aSYmKHQ9aSl9dGhpcy5zZXNzaW9uLnJlbW92ZSh0KSx0aGlzLmNsZWFyU2VsZWN0aW9uKCl9LHRoaXMucmVtb3ZlV29yZFJpZ2h0PWZ1bmN0aW9uKCl7dGhpcy5zZWxlY3Rpb24uaXNFbXB0eSgpJiZ0aGlzLnNlbGVjdGlvbi5zZWxlY3RXb3JkUmlnaHQoKSx0aGlzLnNlc3Npb24ucmVtb3ZlKHRoaXMuZ2V0U2VsZWN0aW9uUmFuZ2UoKSksdGhpcy5jbGVhclNlbGVjdGlvbigpfSx0aGlzLnJlbW92ZVdvcmRMZWZ0PWZ1bmN0aW9uKCl7dGhpcy5zZWxlY3Rpb24uaXNFbXB0eSgpJiZ0aGlzLnNlbGVjdGlvbi5zZWxlY3RXb3JkTGVmdCgpLHRoaXMuc2Vzc2lvbi5yZW1vdmUodGhpcy5nZXRTZWxlY3Rpb25SYW5nZSgpKSx0aGlzLmNsZWFyU2VsZWN0aW9uKCl9LHRoaXMucmVtb3ZlVG9MaW5lU3RhcnQ9ZnVuY3Rpb24oKXt0aGlzLnNlbGVjdGlvbi5pc0VtcHR5KCkmJnRoaXMuc2VsZWN0aW9uLnNlbGVjdExpbmVTdGFydCgpLHRoaXMuc2VsZWN0aW9uLmlzRW1wdHkoKSYmdGhpcy5zZWxlY3Rpb24uc2VsZWN0TGVmdCgpLHRoaXMuc2Vzc2lvbi5yZW1vdmUodGhpcy5nZXRTZWxlY3Rpb25SYW5nZSgpKSx0aGlzLmNsZWFyU2VsZWN0aW9uKCl9LHRoaXMucmVtb3ZlVG9MaW5lRW5kPWZ1bmN0aW9uKCl7dGhpcy5zZWxlY3Rpb24uaXNFbXB0eSgpJiZ0aGlzLnNlbGVjdGlvbi5zZWxlY3RMaW5lRW5kKCk7dmFyIGU9dGhpcy5nZXRTZWxlY3Rpb25SYW5nZSgpO2Uuc3RhcnQuY29sdW1uPT1lLmVuZC5jb2x1bW4mJmUuc3RhcnQucm93PT1lLmVuZC5yb3cmJihlLmVuZC5jb2x1bW49MCxlLmVuZC5yb3crKyksdGhpcy5zZXNzaW9uLnJlbW92ZShlKSx0aGlzLmNsZWFyU2VsZWN0aW9uKCl9LHRoaXMuc3BsaXRMaW5lPWZ1bmN0aW9uKCl7dGhpcy5zZWxlY3Rpb24uaXNFbXB0eSgpfHwodGhpcy5zZXNzaW9uLnJlbW92ZSh0aGlzLmdldFNlbGVjdGlvblJhbmdlKCkpLHRoaXMuY2xlYXJTZWxlY3Rpb24oKSk7dmFyIGU9dGhpcy5nZXRDdXJzb3JQb3NpdGlvbigpO3RoaXMuaW5zZXJ0KCJcbiIpLHRoaXMubW92ZUN1cnNvclRvUG9zaXRpb24oZSl9LHRoaXMudHJhbnNwb3NlTGV0dGVycz1mdW5jdGlvbigpe2lmKCF0aGlzLnNlbGVjdGlvbi5pc0VtcHR5KCkpcmV0dXJuO3ZhciBlPXRoaXMuZ2V0Q3Vyc29yUG9zaXRpb24oKSx0PWUuY29sdW1uO2lmKHQ9PT0wKXJldHVybjt2YXIgbj10aGlzLnNlc3Npb24uZ2V0TGluZShlLnJvdykscixpO3Q8bi5sZW5ndGg/KHI9bi5jaGFyQXQodCkrbi5jaGFyQXQodC0xKSxpPW5ldyBkKGUucm93LHQtMSxlLnJvdyx0KzEpKToocj1uLmNoYXJBdCh0LTEpK24uY2hhckF0KHQtMiksaT1uZXcgZChlLnJvdyx0LTIsZS5yb3csdCkpLHRoaXMuc2Vzc2lvbi5yZXBsYWNlKGksciksdGhpcy5zZXNzaW9uLnNlbGVjdGlvbi5tb3ZlVG9Qb3NpdGlvbihpLmVuZCl9LHRoaXMudG9Mb3dlckNhc2U9ZnVuY3Rpb24oKXt2YXIgZT10aGlzLmdldFNlbGVjdGlvblJhbmdlKCk7dGhpcy5zZWxlY3Rpb24uaXNFbXB0eSgpJiZ0aGlzLnNlbGVjdGlvbi5zZWxlY3RXb3JkKCk7dmFyIHQ9dGhpcy5nZXRTZWxlY3Rpb25SYW5nZSgpLG49dGhpcy5zZXNzaW9uLmdldFRleHRSYW5nZSh0KTt0aGlzLnNlc3Npb24ucmVwbGFjZSh0LG4udG9Mb3dlckNhc2UoKSksdGhpcy5zZWxlY3Rpb24uc2V0U2VsZWN0aW9uUmFuZ2UoZSl9LHRoaXMudG9VcHBlckNhc2U9ZnVuY3Rpb24oKXt2YXIgZT10aGlzLmdldFNlbGVjdGlvblJhbmdlKCk7dGhpcy5zZWxlY3Rpb24uaXNFbXB0eSgpJiZ0aGlzLnNlbGVjdGlvbi5zZWxlY3RXb3JkKCk7dmFyIHQ9dGhpcy5nZXRTZWxlY3Rpb25SYW5nZSgpLG49dGhpcy5zZXNzaW9uLmdldFRleHRSYW5nZSh0KTt0aGlzLnNlc3Npb24ucmVwbGFjZSh0LG4udG9VcHBlckNhc2UoKSksdGhpcy5zZWxlY3Rpb24uc2V0U2VsZWN0aW9uUmFuZ2UoZSl9LHRoaXMuaW5kZW50PWZ1bmN0aW9uKCl7dmFyIGU9dGhpcy5zZXNzaW9uLHQ9dGhpcy5nZXRTZWxlY3Rpb25SYW5nZSgpO2lmKHQuc3RhcnQucm93PHQuZW5kLnJvdyl7dmFyIG49dGhpcy4kZ2V0U2VsZWN0ZWRSb3dzKCk7ZS5pbmRlbnRSb3dzKG4uZmlyc3Qsbi5sYXN0LCIJIik7cmV0dXJufWlmKHQuc3RhcnQuY29sdW1uPHQuZW5kLmNvbHVtbil7dmFyIHI9ZS5nZXRUZXh0UmFuZ2UodCk7aWYoIS9eXHMrJC8udGVzdChyKSl7dmFyIG49dGhpcy4kZ2V0U2VsZWN0ZWRSb3dzKCk7ZS5pbmRlbnRSb3dzKG4uZmlyc3Qsbi5sYXN0LCIJIik7cmV0dXJufX12YXIgaT1lLmdldExpbmUodC5zdGFydC5yb3cpLHM9dC5zdGFydCx1PWUuZ2V0VGFiU2l6ZSgpLGE9ZS5kb2N1bWVudFRvU2NyZWVuQ29sdW1uKHMucm93LHMuY29sdW1uKTtpZih0aGlzLnNlc3Npb24uZ2V0VXNlU29mdFRhYnMoKSl2YXIgZj11LWEldSxsPW8uc3RyaW5nUmVwZWF0KCIgIixmKTtlbHNle3ZhciBmPWEldTt3aGlsZShpW3Quc3RhcnQuY29sdW1uLTFdPT0iICImJmYpdC5zdGFydC5jb2x1bW4tLSxmLS07dGhpcy5zZWxlY3Rpb24uc2V0U2VsZWN0aW9uUmFuZ2UodCksbD0iCSJ9cmV0dXJuIHRoaXMuaW5zZXJ0KGwpfSx0aGlzLmJsb2NrSW5kZW50PWZ1bmN0aW9uKCl7dmFyIGU9dGhpcy4kZ2V0U2VsZWN0ZWRSb3dzKCk7dGhpcy5zZXNzaW9uLmluZGVudFJvd3MoZS5maXJzdCxlLmxhc3QsIgkiKX0sdGhpcy5ibG9ja091dGRlbnQ9ZnVuY3Rpb24oKXt2YXIgZT10aGlzLnNlc3Npb24uZ2V0U2VsZWN0aW9uKCk7dGhpcy5zZXNzaW9uLm91dGRlbnRSb3dzKGUuZ2V0UmFuZ2UoKSl9LHRoaXMuc29ydExpbmVzPWZ1bmN0aW9uKCl7dmFyIGU9dGhpcy4kZ2V0U2VsZWN0ZWRSb3dzKCksdD10aGlzLnNlc3Npb24sbj1bXTtmb3IodmFyIHI9ZS5maXJzdDtyPD1lLmxhc3Q7cisrKW4ucHVzaCh0LmdldExpbmUocikpO24uc29ydChmdW5jdGlvbihlLHQpe3JldHVybiBlLnRvTG93ZXJDYXNlKCk8dC50b0xvd2VyQ2FzZSgpPy0xOmUudG9Mb3dlckNhc2UoKT50LnRvTG93ZXJDYXNlKCk/MTowfSk7dmFyIGk9bmV3IGQoMCwwLDAsMCk7Zm9yKHZhciByPWUuZmlyc3Q7cjw9ZS5sYXN0O3IrKyl7dmFyIHM9dC5nZXRMaW5lKHIpO2kuc3RhcnQucm93PXIsaS5lbmQucm93PXIsaS5lbmQuY29sdW1uPXMubGVuZ3RoLHQucmVwbGFjZShpLG5bci1lLmZpcnN0XSl9fSx0aGlzLnRvZ2dsZUNvbW1lbnRMaW5lcz1mdW5jdGlvbigpe3ZhciBlPXRoaXMuc2Vzc2lvbi5nZXRTdGF0ZSh0aGlzLmdldEN1cnNvclBvc2l0aW9uKCkucm93KSx0PXRoaXMuJGdldFNlbGVjdGVkUm93cygpO3RoaXMuc2Vzc2lvbi5nZXRNb2RlKCkudG9nZ2xlQ29tbWVudExpbmVzKGUsdGhpcy5zZXNzaW9uLHQuZmlyc3QsdC5sYXN0KX0sdGhpcy50b2dnbGVCbG9ja0NvbW1lbnQ9ZnVuY3Rpb24oKXt2YXIgZT10aGlzLmdldEN1cnNvclBvc2l0aW9uKCksdD10aGlzLnNlc3Npb24uZ2V0U3RhdGUoZS5yb3cpLG49dGhpcy5nZXRTZWxlY3Rpb25SYW5nZSgpO3RoaXMuc2Vzc2lvbi5nZXRNb2RlKCkudG9nZ2xlQmxvY2tDb21tZW50KHQsdGhpcy5zZXNzaW9uLG4sZSl9LHRoaXMuZ2V0TnVtYmVyQXQ9ZnVuY3Rpb24oZSx0KXt2YXIgbj0vW1wtXT9bMC05XSsoPzpcLlswLTldKyk/L2c7bi5sYXN0SW5kZXg9MDt2YXIgcj10aGlzLnNlc3Npb24uZ2V0TGluZShlKTt3aGlsZShuLmxhc3RJbmRleDx0KXt2YXIgaT1uLmV4ZWMocik7aWYoaS5pbmRleDw9dCYmaS5pbmRleCtpWzBdLmxlbmd0aD49dCl7dmFyIHM9e3ZhbHVlOmlbMF0sc3RhcnQ6aS5pbmRleCxlbmQ6aS5pbmRleCtpWzBdLmxlbmd0aH07cmV0dXJuIHN9fXJldHVybiBudWxsfSx0aGlzLm1vZGlmeU51bWJlcj1mdW5jdGlvbihlKXt2YXIgdD10aGlzLnNlbGVjdGlvbi5nZXRDdXJzb3IoKS5yb3csbj10aGlzLnNlbGVjdGlvbi5nZXRDdXJzb3IoKS5jb2x1bW4scj1uZXcgZCh0LG4tMSx0LG4pLGk9dGhpcy5zZXNzaW9uLmdldFRleHRSYW5nZShyKTtpZighaXNOYU4ocGFyc2VGbG9hdChpKSkmJmlzRmluaXRlKGkpKXt2YXIgcz10aGlzLmdldE51bWJlckF0KHQsbik7aWYocyl7dmFyIG89cy52YWx1ZS5pbmRleE9mKCIuIik+PTA/cy5zdGFydCtzLnZhbHVlLmluZGV4T2YoIi4iKSsxOnMuZW5kLHU9cy5zdGFydCtzLnZhbHVlLmxlbmd0aC1vLGE9cGFyc2VGbG9hdChzLnZhbHVlKTthKj1NYXRoLnBvdygxMCx1KSxvIT09cy5lbmQmJm48bz9lKj1NYXRoLnBvdygxMCxzLmVuZC1uLTEpOmUqPU1hdGgucG93KDEwLHMuZW5kLW4pLGErPWUsYS89TWF0aC5wb3coMTAsdSk7dmFyIGY9YS50b0ZpeGVkKHUpLGw9bmV3IGQodCxzLnN0YXJ0LHQscy5lbmQpO3RoaXMuc2Vzc2lvbi5yZXBsYWNlKGwsZiksdGhpcy5tb3ZlQ3Vyc29yVG8odCxNYXRoLm1heChzLnN0YXJ0KzEsbitmLmxlbmd0aC1zLnZhbHVlLmxlbmd0aCkpfX1lbHNlIHRoaXMudG9nZ2xlV29yZCgpfSx0aGlzLiR0b2dnbGVXb3JkUGFpcnM9W1siZmlyc3QiLCJsYXN0Il0sWyJ0cnVlIiwiZmFsc2UiXSxbInllcyIsIm5vIl0sWyJ3aWR0aCIsImhlaWdodCJdLFsidG9wIiwiYm90dG9tIl0sWyJyaWdodCIsImxlZnQiXSxbIm9uIiwib2ZmIl0sWyJ4IiwieSJdLFsiZ2V0Iiwic2V0Il0sWyJtYXgiLCJtaW4iXSxbImhvcml6b250YWwiLCJ2ZXJ0aWNhbCJdLFsic2hvdyIsImhpZGUiXSxbImFkZCIsInJlbW92ZSJdLFsidXAiLCJkb3duIl0sWyJiZWZvcmUiLCJhZnRlciJdLFsiZXZlbiIsIm9kZCJdLFsiaW4iLCJvdXQiXSxbImluc2lkZSIsIm91dHNpZGUiXSxbIm5leHQiLCJwcmV2aW91cyJdLFsiaW5jcmVhc2UiLCJkZWNyZWFzZSJdLFsiYXR0YWNoIiwiZGV0YWNoIl0sWyImJiIsInx8Il0sWyI9PSIsIiE9Il1dLHRoaXMudG9nZ2xlV29yZD1mdW5jdGlvbigpe3ZhciBlPXRoaXMuc2VsZWN0aW9uLmdldEN1cnNvcigpLnJvdyx0PXRoaXMuc2VsZWN0aW9uLmdldEN1cnNvcigpLmNvbHVtbjt0aGlzLnNlbGVjdGlvbi5zZWxlY3RXb3JkKCk7dmFyIG49dGhpcy5nZXRTZWxlY3RlZFRleHQoKSxyPXRoaXMuc2VsZWN0aW9uLmdldFdvcmRSYW5nZSgpLnN0YXJ0LmNvbHVtbixpPW4ucmVwbGFjZSgvKFthLXpdK3xbQS1aXSspKD89W0EtWl9dfCQpL2csIiQxICIpLnNwbGl0KC9ccy8pLHM9dC1yLTE7czwwJiYocz0wKTt2YXIgdT0wLGE9MCxmPXRoaXM7bi5tYXRjaCgvW0EtWmEtejAtOV9dKy8pJiZpLmZvckVhY2goZnVuY3Rpb24odCxpKXthPXUrdC5sZW5ndGgscz49dSYmczw9YSYmKG49dCxmLnNlbGVjdGlvbi5jbGVhclNlbGVjdGlvbigpLGYubW92ZUN1cnNvclRvKGUsdStyKSxmLnNlbGVjdGlvbi5zZWxlY3RUbyhlLGErcikpLHU9YX0pO3ZhciBsPXRoaXMuJHRvZ2dsZVdvcmRQYWlycyxjO2Zvcih2YXIgaD0wO2g8bC5sZW5ndGg7aCsrKXt2YXIgcD1sW2hdO2Zvcih2YXIgZD0wO2Q8PTE7ZCsrKXt2YXIgdj0rIWQsbT1uLm1hdGNoKG5ldyBSZWdFeHAoIl5cXHM/Xz8oIitvLmVzY2FwZVJlZ0V4cChwW2RdKSsiKVxccz8kIiwiaSIpKTtpZihtKXt2YXIgZz1uLm1hdGNoKG5ldyBSZWdFeHAoIihbX118XnxcXHMpKCIrby5lc2NhcGVSZWdFeHAobVsxXSkrIikoJHxcXHMpIiwiZyIpKTtnJiYoYz1uLnJlcGxhY2UobmV3IFJlZ0V4cChvLmVzY2FwZVJlZ0V4cChwW2RdKSwiaSIpLGZ1bmN0aW9uKGUpe3ZhciB0PXBbdl07cmV0dXJuIGUudG9VcHBlckNhc2UoKT09ZT90PXQudG9VcHBlckNhc2UoKTplLmNoYXJBdCgwKS50b1VwcGVyQ2FzZSgpPT1lLmNoYXJBdCgwKSYmKHQ9dC5zdWJzdHIoMCwwKStwW3ZdLmNoYXJBdCgwKS50b1VwcGVyQ2FzZSgpK3Quc3Vic3RyKDEpKSx0fSksdGhpcy5pbnNlcnQoYyksYz0iIil9fX19LHRoaXMuZmluZExpbmtBdD1mdW5jdGlvbihlLHQpe3ZhciBuLGkscz10aGlzLnNlc3Npb24uZ2V0TGluZShlKSxvPXMuc3BsaXQoLygoPzpodHRwcz98ZnRwKTpcL1wvW1xTXSspLyksdT10O3U8MCYmKHU9MCk7dmFyIGE9MCxmPTAsbDt0cnl7Zm9yKHZhciBjPXIobyksaD1jLm5leHQoKTshaC5kb25lO2g9Yy5uZXh0KCkpe3ZhciBwPWgudmFsdWU7Zj1hK3AubGVuZ3RoO2lmKHU+PWEmJnU8PWYmJnAubWF0Y2goLygoPzpodHRwcz98ZnRwKTpcL1wvW1xTXSspLykpe2w9cC5yZXBsYWNlKC9bXHM6LiwnIjt9XF1dKyQvLCIiKTticmVha31hPWZ9fWNhdGNoKGQpe249e2Vycm9yOmR9fWZpbmFsbHl7dHJ5e2gmJiFoLmRvbmUmJihpPWMucmV0dXJuKSYmaS5jYWxsKGMpfWZpbmFsbHl7aWYobil0aHJvdyBuLmVycm9yfX1yZXR1cm4gbH0sdGhpcy5vcGVuTGluaz1mdW5jdGlvbigpe3ZhciBlPXRoaXMuc2VsZWN0aW9uLmdldEN1cnNvcigpLHQ9dGhpcy5maW5kTGlua0F0KGUucm93LGUuY29sdW1uKTtyZXR1cm4gdCYmd2luZG93Lm9wZW4odCwiX2JsYW5rIiksdCE9bnVsbH0sdGhpcy5yZW1vdmVMaW5lcz1mdW5jdGlvbigpe3ZhciBlPXRoaXMuJGdldFNlbGVjdGVkUm93cygpO3RoaXMuc2Vzc2lvbi5yZW1vdmVGdWxsTGluZXMoZS5maXJzdCxlLmxhc3QpLHRoaXMuY2xlYXJTZWxlY3Rpb24oKX0sdGhpcy5kdXBsaWNhdGVTZWxlY3Rpb249ZnVuY3Rpb24oKXt2YXIgZT10aGlzLnNlbGVjdGlvbix0PXRoaXMuc2Vzc2lvbixuPWUuZ2V0UmFuZ2UoKSxyPWUuaXNCYWNrd2FyZHMoKTtpZihuLmlzRW1wdHkoKSl7dmFyIGk9bi5zdGFydC5yb3c7dC5kdXBsaWNhdGVMaW5lcyhpLGkpfWVsc2V7dmFyIHM9cj9uLnN0YXJ0Om4uZW5kLG89dC5pbnNlcnQocyx0LmdldFRleHRSYW5nZShuKSwhMSk7bi5zdGFydD1zLG4uZW5kPW8sZS5zZXRTZWxlY3Rpb25SYW5nZShuLHIpfX0sdGhpcy5tb3ZlTGluZXNEb3duPWZ1bmN0aW9uKCl7dGhpcy4kbW92ZUxpbmVzKDEsITEpfSx0aGlzLm1vdmVMaW5lc1VwPWZ1bmN0aW9uKCl7dGhpcy4kbW92ZUxpbmVzKC0xLCExKX0sdGhpcy5tb3ZlVGV4dD1mdW5jdGlvbihlLHQsbil7cmV0dXJuIHRoaXMuc2Vzc2lvbi5tb3ZlVGV4dChlLHQsbil9LHRoaXMuY29weUxpbmVzVXA9ZnVuY3Rpb24oKXt0aGlzLiRtb3ZlTGluZXMoLTEsITApfSx0aGlzLmNvcHlMaW5lc0Rvd249ZnVuY3Rpb24oKXt0aGlzLiRtb3ZlTGluZXMoMSwhMCl9LHRoaXMuJG1vdmVMaW5lcz1mdW5jdGlvbihlLHQpe3ZhciBuLHIsaT10aGlzLnNlbGVjdGlvbjtpZighaS5pbk11bHRpU2VsZWN0TW9kZXx8dGhpcy5pblZpcnR1YWxTZWxlY3Rpb25Nb2RlKXt2YXIgcz1pLnRvT3JpZW50ZWRSYW5nZSgpO249dGhpcy4kZ2V0U2VsZWN0ZWRSb3dzKHMpLHI9dGhpcy5zZXNzaW9uLiRtb3ZlTGluZXMobi5maXJzdCxuLmxhc3QsdD8wOmUpLHQmJmU9PS0xJiYocj0wKSxzLm1vdmVCeShyLDApLGkuZnJvbU9yaWVudGVkUmFuZ2Uocyl9ZWxzZXt2YXIgbz1pLnJhbmdlTGlzdC5yYW5nZXM7aS5yYW5nZUxpc3QuZGV0YWNoKHRoaXMuc2Vzc2lvbiksdGhpcy5pblZpcnR1YWxTZWxlY3Rpb25Nb2RlPSEwO3ZhciB1PTAsYT0wLGY9by5sZW5ndGg7Zm9yKHZhciBsPTA7bDxmO2wrKyl7dmFyIGM9bDtvW2xdLm1vdmVCeSh1LDApLG49dGhpcy4kZ2V0U2VsZWN0ZWRSb3dzKG9bbF0pO3ZhciBoPW4uZmlyc3QscD1uLmxhc3Q7d2hpbGUoKytsPGYpe2EmJm9bbF0ubW92ZUJ5KGEsMCk7dmFyIGQ9dGhpcy4kZ2V0U2VsZWN0ZWRSb3dzKG9bbF0pO2lmKHQmJmQuZmlyc3QhPXApYnJlYWs7aWYoIXQmJmQuZmlyc3Q+cCsxKWJyZWFrO3A9ZC5sYXN0fWwtLSx1PXRoaXMuc2Vzc2lvbi4kbW92ZUxpbmVzKGgscCx0PzA6ZSksdCYmZT09LTEmJihjPWwrMSk7d2hpbGUoYzw9bClvW2NdLm1vdmVCeSh1LDApLGMrKzt0fHwodT0wKSxhKz11fWkuZnJvbU9yaWVudGVkUmFuZ2UoaS5yYW5nZXNbMF0pLGkucmFuZ2VMaXN0LmF0dGFjaCh0aGlzLnNlc3Npb24pLHRoaXMuaW5WaXJ0dWFsU2VsZWN0aW9uTW9kZT0hMX19LHRoaXMuJGdldFNlbGVjdGVkUm93cz1mdW5jdGlvbihlKXtyZXR1cm4gZT0oZXx8dGhpcy5nZXRTZWxlY3Rpb25SYW5nZSgpKS5jb2xsYXBzZVJvd3MoKSx7Zmlyc3Q6dGhpcy5zZXNzaW9uLmdldFJvd0ZvbGRTdGFydChlLnN0YXJ0LnJvdyksbGFzdDp0aGlzLnNlc3Npb24uZ2V0Um93Rm9sZEVuZChlLmVuZC5yb3cpfX0sdGhpcy5vbkNvbXBvc2l0aW9uU3RhcnQ9ZnVuY3Rpb24oZSl7dGhpcy5yZW5kZXJlci5zaG93Q29tcG9zaXRpb24oZSl9LHRoaXMub25Db21wb3NpdGlvblVwZGF0ZT1mdW5jdGlvbihlKXt0aGlzLnJlbmRlcmVyLnNldENvbXBvc2l0aW9uVGV4dChlKX0sdGhpcy5vbkNvbXBvc2l0aW9uRW5kPWZ1bmN0aW9uKCl7dGhpcy5yZW5kZXJlci5oaWRlQ29tcG9zaXRpb24oKX0sdGhpcy5nZXRGaXJzdFZpc2libGVSb3c9ZnVuY3Rpb24oKXtyZXR1cm4gdGhpcy5yZW5kZXJlci5nZXRGaXJzdFZpc2libGVSb3coKX0sdGhpcy5nZXRMYXN0VmlzaWJsZVJvdz1mdW5jdGlvbigpe3JldHVybiB0aGlzLnJlbmRlcmVyLmdldExhc3RWaXNpYmxlUm93KCl9LHRoaXMuaXNSb3dWaXNpYmxlPWZ1bmN0aW9uKGUpe3JldHVybiBlPj10aGlzLmdldEZpcnN0VmlzaWJsZVJvdygpJiZlPD10aGlzLmdldExhc3RWaXNpYmxlUm93KCl9LHRoaXMuaXNSb3dGdWxseVZpc2libGU9ZnVuY3Rpb24oZSl7cmV0dXJuIGU+PXRoaXMucmVuZGVyZXIuZ2V0Rmlyc3RGdWxseVZpc2libGVSb3coKSYmZTw9dGhpcy5yZW5kZXJlci5nZXRMYXN0RnVsbHlWaXNpYmxlUm93KCl9LHRoaXMuJGdldFZpc2libGVSb3dDb3VudD1mdW5jdGlvbigpe3JldHVybiB0aGlzLnJlbmRlcmVyLmdldFNjcm9sbEJvdHRvbVJvdygpLXRoaXMucmVuZGVyZXIuZ2V0U2Nyb2xsVG9wUm93KCkrMX0sdGhpcy4kbW92ZUJ5UGFnZT1mdW5jdGlvbihlLHQpe3ZhciBuPXRoaXMucmVuZGVyZXIscj10aGlzLnJlbmRlcmVyLmxheWVyQ29uZmlnLGk9ZSpNYXRoLmZsb29yKHIuaGVpZ2h0L3IubGluZUhlaWdodCk7dD09PSEwP3RoaXMuc2VsZWN0aW9uLiRtb3ZlU2VsZWN0aW9uKGZ1bmN0aW9uKCl7dGhpcy5tb3ZlQ3Vyc29yQnkoaSwwKX0pOnQ9PT0hMSYmKHRoaXMuc2VsZWN0aW9uLm1vdmVDdXJzb3JCeShpLDApLHRoaXMuc2VsZWN0aW9uLmNsZWFyU2VsZWN0aW9uKCkpO3ZhciBzPW4uc2Nyb2xsVG9wO24uc2Nyb2xsQnkoMCxpKnIubGluZUhlaWdodCksdCE9bnVsbCYmbi5zY3JvbGxDdXJzb3JJbnRvVmlldyhudWxsLC41KSxuLmFuaW1hdGVTY3JvbGxpbmcocyl9LHRoaXMuc2VsZWN0UGFnZURvd249ZnVuY3Rpb24oKXt0aGlzLiRtb3ZlQnlQYWdlKDEsITApfSx0aGlzLnNlbGVjdFBhZ2VVcD1mdW5jdGlvbigpe3RoaXMuJG1vdmVCeVBhZ2UoLTEsITApfSx0aGlzLmdvdG9QYWdlRG93bj1mdW5jdGlvbigpe3RoaXMuJG1vdmVCeVBhZ2UoMSwhMSl9LHRoaXMuZ290b1BhZ2VVcD1mdW5jdGlvbigpe3RoaXMuJG1vdmVCeVBhZ2UoLTEsITEpfSx0aGlzLnNjcm9sbFBhZ2VEb3duPWZ1bmN0aW9uKCl7dGhpcy4kbW92ZUJ5UGFnZSgxKX0sdGhpcy5zY3JvbGxQYWdlVXA9ZnVuY3Rpb24oKXt0aGlzLiRtb3ZlQnlQYWdlKC0xKX0sdGhpcy5zY3JvbGxUb1Jvdz1mdW5jdGlvbihlKXt0aGlzLnJlbmRlcmVyLnNjcm9sbFRvUm93KGUpfSx0aGlzLnNjcm9sbFRvTGluZT1mdW5jdGlvbihlLHQsbixyKXt0aGlzLnJlbmRlcmVyLnNjcm9sbFRvTGluZShlLHQsbixyKX0sdGhpcy5jZW50ZXJTZWxlY3Rpb249ZnVuY3Rpb24oKXt2YXIgZT10aGlzLmdldFNlbGVjdGlvblJhbmdlKCksdD17cm93Ok1hdGguZmxvb3IoZS5zdGFydC5yb3crKGUuZW5kLnJvdy1lLnN0YXJ0LnJvdykvMiksY29sdW1uOk1hdGguZmxvb3IoZS5zdGFydC5jb2x1bW4rKGUuZW5kLmNvbHVtbi1lLnN0YXJ0LmNvbHVtbikvMil9O3RoaXMucmVuZGVyZXIuYWxpZ25DdXJzb3IodCwuNSl9LHRoaXMuZ2V0Q3Vyc29yUG9zaXRpb249ZnVuY3Rpb24oKXtyZXR1cm4gdGhpcy5zZWxlY3Rpb24uZ2V0Q3Vyc29yKCl9LHRoaXMuZ2V0Q3Vyc29yUG9zaXRpb25TY3JlZW49ZnVuY3Rpb24oKXtyZXR1cm4gdGhpcy5zZXNzaW9uLmRvY3VtZW50VG9TY3JlZW5Qb3NpdGlvbih0aGlzLmdldEN1cnNvclBvc2l0aW9uKCkpfSx0aGlzLmdldFNlbGVjdGlvblJhbmdlPWZ1bmN0aW9uKCl7cmV0dXJuIHRoaXMuc2VsZWN0aW9uLmdldFJhbmdlKCl9LHRoaXMuc2VsZWN0QWxsPWZ1bmN0aW9uKCl7dGhpcy5zZWxlY3Rpb24uc2VsZWN0QWxsKCl9LHRoaXMuY2xlYXJTZWxlY3Rpb249ZnVuY3Rpb24oKXt0aGlzLnNlbGVjdGlvbi5jbGVhclNlbGVjdGlvbigpfSx0aGlzLm1vdmVDdXJzb3JUbz1mdW5jdGlvbihlLHQpe3RoaXMuc2VsZWN0aW9uLm1vdmVDdXJzb3JUbyhlLHQpfSx0aGlzLm1vdmVDdXJzb3JUb1Bvc2l0aW9uPWZ1bmN0aW9uKGUpe3RoaXMuc2VsZWN0aW9uLm1vdmVDdXJzb3JUb1Bvc2l0aW9uKGUpfSx0aGlzLmp1bXBUb01hdGNoaW5nPWZ1bmN0aW9uKGUsdCl7dmFyIG49dGhpcy5nZXRDdXJzb3JQb3NpdGlvbigpLHI9bmV3IGIodGhpcy5zZXNzaW9uLG4ucm93LG4uY29sdW1uKSxpPXIuZ2V0Q3VycmVudFRva2VuKCkscz0wO2kmJmkudHlwZS5pbmRleE9mKCJ0YWctbmFtZSIpIT09LTEmJihpPXIuc3RlcEJhY2t3YXJkKCkpO3ZhciBvPWl8fHIuc3RlcEZvcndhcmQoKTtpZighbylyZXR1cm47dmFyIHUsYT0hMSxmPXt9LGw9bi5jb2x1bW4tby5zdGFydCxjLGg9eyIpIjoiKCIsIigiOiIoIiwiXSI6IlsiLCJbIjoiWyIsInsiOiJ7IiwifSI6InsifTtkb3tpZihvLnZhbHVlLm1hdGNoKC9be30oKVxbXF1dL2cpKWZvcig7bDxvLnZhbHVlLmxlbmd0aCYmIWE7bCsrKXtpZighaFtvLnZhbHVlW2xdXSljb250aW51ZTtjPWhbby52YWx1ZVtsXV0rIi4iK28udHlwZS5yZXBsYWNlKCJycGFyZW4iLCJscGFyZW4iKSxpc05hTihmW2NdKSYmKGZbY109MCk7c3dpdGNoKG8udmFsdWVbbF0pe2Nhc2UiKCI6Y2FzZSJbIjpjYXNlInsiOmZbY10rKzticmVhaztjYXNlIikiOmNhc2UiXSI6Y2FzZSJ9IjpmW2NdLS0sZltjXT09PS0xJiYodT0iYnJhY2tldCIsYT0hMCl9fWVsc2Ugby50eXBlLmluZGV4T2YoInRhZy1uYW1lIikhPT0tMSYmKGlzTmFOKGZbby52YWx1ZV0pJiYoZltvLnZhbHVlXT0wKSxpLnZhbHVlPT09IjwiJiZzPjE/ZltvLnZhbHVlXSsrOmkudmFsdWU9PT0iPC8iJiZmW28udmFsdWVdLS0sZltvLnZhbHVlXT09PS0xJiYodT0idGFnIixhPSEwKSk7YXx8KGk9byxzKyssbz1yLnN0ZXBGb3J3YXJkKCksbD0wKX13aGlsZShvJiYhYSk7aWYoIXUpcmV0dXJuO3ZhciBwLHY7aWYodT09PSJicmFja2V0Iil7cD10aGlzLnNlc3Npb24uZ2V0QnJhY2tldFJhbmdlKG4pO2lmKCFwKXtwPW5ldyBkKHIuZ2V0Q3VycmVudFRva2VuUm93KCksci5nZXRDdXJyZW50VG9rZW5Db2x1bW4oKStsLTEsci5nZXRDdXJyZW50VG9rZW5Sb3coKSxyLmdldEN1cnJlbnRUb2tlbkNvbHVtbigpK2wtMSksdj1wLnN0YXJ0O2lmKHR8fHYucm93PT09bi5yb3cmJk1hdGguYWJzKHYuY29sdW1uLW4uY29sdW1uKTwyKXA9dGhpcy5zZXNzaW9uLmdldEJyYWNrZXRSYW5nZSh2KX19ZWxzZSBpZih1PT09InRhZyIpe2lmKCFvfHxvLnR5cGUuaW5kZXhPZigidGFnLW5hbWUiKT09PS0xKXJldHVybjtwPW5ldyBkKHIuZ2V0Q3VycmVudFRva2VuUm93KCksci5nZXRDdXJyZW50VG9rZW5Db2x1bW4oKS0yLHIuZ2V0Q3VycmVudFRva2VuUm93KCksci5nZXRDdXJyZW50VG9rZW5Db2x1bW4oKS0yKTtpZihwLmNvbXBhcmUobi5yb3csbi5jb2x1bW4pPT09MCl7dmFyIG09dGhpcy5zZXNzaW9uLmdldE1hdGNoaW5nVGFncyhuKTttJiYobS5vcGVuVGFnLmNvbnRhaW5zKG4ucm93LG4uY29sdW1uKT8ocD1tLmNsb3NlVGFnLHY9cC5zdGFydCk6KHA9bS5vcGVuVGFnLG0uY2xvc2VUYWcuc3RhcnQucm93PT09bi5yb3cmJm0uY2xvc2VUYWcuc3RhcnQuY29sdW1uPT09bi5jb2x1bW4/dj1wLmVuZDp2PXAuc3RhcnQpKX12PXZ8fHAuc3RhcnR9dj1wJiZwLmN1cnNvcnx8dix2JiYoZT9wJiZ0P3RoaXMuc2VsZWN0aW9uLnNldFJhbmdlKHApOnAmJnAuaXNFcXVhbCh0aGlzLmdldFNlbGVjdGlvblJhbmdlKCkpP3RoaXMuY2xlYXJTZWxlY3Rpb24oKTp0aGlzLnNlbGVjdGlvbi5zZWxlY3RUbyh2LnJvdyx2LmNvbHVtbik6dGhpcy5zZWxlY3Rpb24ubW92ZVRvKHYucm93LHYuY29sdW1uKSl9LHRoaXMuZ290b0xpbmU9ZnVuY3Rpb24oZSx0LG4pe3RoaXMuc2VsZWN0aW9uLmNsZWFyU2VsZWN0aW9uKCksdGhpcy5zZXNzaW9uLnVuZm9sZCh7cm93OmUtMSxjb2x1bW46dHx8MH0pLHRoaXMuZXhpdE11bHRpU2VsZWN0TW9kZSYmdGhpcy5leGl0TXVsdGlTZWxlY3RNb2RlKCksdGhpcy5tb3ZlQ3Vyc29yVG8oZS0xLHR8fDApLHRoaXMuaXNSb3dGdWxseVZpc2libGUoZS0xKXx8dGhpcy5zY3JvbGxUb0xpbmUoZS0xLCEwLG4pfSx0aGlzLm5hdmlnYXRlVG89ZnVuY3Rpb24oZSx0KXt0aGlzLnNlbGVjdGlvbi5tb3ZlVG8oZSx0KX0sdGhpcy5uYXZpZ2F0ZVVwPWZ1bmN0aW9uKGUpe2lmKHRoaXMuc2VsZWN0aW9uLmlzTXVsdGlMaW5lKCkmJiF0aGlzLnNlbGVjdGlvbi5pc0JhY2t3YXJkcygpKXt2YXIgdD10aGlzLnNlbGVjdGlvbi5hbmNob3IuZ2V0UG9zaXRpb24oKTtyZXR1cm4gdGhpcy5tb3ZlQ3Vyc29yVG9Qb3NpdGlvbih0KX10aGlzLnNlbGVjdGlvbi5jbGVhclNlbGVjdGlvbigpLHRoaXMuc2VsZWN0aW9uLm1vdmVDdXJzb3JCeSgtZXx8LTEsMCl9LHRoaXMubmF2aWdhdGVEb3duPWZ1bmN0aW9uKGUpe2lmKHRoaXMuc2VsZWN0aW9uLmlzTXVsdGlMaW5lKCkmJnRoaXMuc2VsZWN0aW9uLmlzQmFja3dhcmRzKCkpe3ZhciB0PXRoaXMuc2VsZWN0aW9uLmFuY2hvci5nZXRQb3NpdGlvbigpO3JldHVybiB0aGlzLm1vdmVDdXJzb3JUb1Bvc2l0aW9uKHQpfXRoaXMuc2VsZWN0aW9uLmNsZWFyU2VsZWN0aW9uKCksdGhpcy5zZWxlY3Rpb24ubW92ZUN1cnNvckJ5KGV8fDEsMCl9LHRoaXMubmF2aWdhdGVMZWZ0PWZ1bmN0aW9uKGUpe2lmKCF0aGlzLnNlbGVjdGlvbi5pc0VtcHR5KCkpe3ZhciB0PXRoaXMuZ2V0U2VsZWN0aW9uUmFuZ2UoKS5zdGFydDt0aGlzLm1vdmVDdXJzb3JUb1Bvc2l0aW9uKHQpfWVsc2V7ZT1lfHwxO3doaWxlKGUtLSl0aGlzLnNlbGVjdGlvbi5tb3ZlQ3Vyc29yTGVmdCgpfXRoaXMuY2xlYXJTZWxlY3Rpb24oKX0sdGhpcy5uYXZpZ2F0ZVJpZ2h0PWZ1bmN0aW9uKGUpe2lmKCF0aGlzLnNlbGVjdGlvbi5pc0VtcHR5KCkpe3ZhciB0PXRoaXMuZ2V0U2VsZWN0aW9uUmFuZ2UoKS5lbmQ7dGhpcy5tb3ZlQ3Vyc29yVG9Qb3NpdGlvbih0KX1lbHNle2U9ZXx8MTt3aGlsZShlLS0pdGhpcy5zZWxlY3Rpb24ubW92ZUN1cnNvclJpZ2h0KCl9dGhpcy5jbGVhclNlbGVjdGlvbigpfSx0aGlzLm5hdmlnYXRlTGluZVN0YXJ0PWZ1bmN0aW9uKCl7dGhpcy5zZWxlY3Rpb24ubW92ZUN1cnNvckxpbmVTdGFydCgpLHRoaXMuY2xlYXJTZWxlY3Rpb24oKX0sdGhpcy5uYXZpZ2F0ZUxpbmVFbmQ9ZnVuY3Rpb24oKXt0aGlzLnNlbGVjdGlvbi5tb3ZlQ3Vyc29yTGluZUVuZCgpLHRoaXMuY2xlYXJTZWxlY3Rpb24oKX0sdGhpcy5uYXZpZ2F0ZUZpbGVFbmQ9ZnVuY3Rpb24oKXt0aGlzLnNlbGVjdGlvbi5tb3ZlQ3Vyc29yRmlsZUVuZCgpLHRoaXMuY2xlYXJTZWxlY3Rpb24oKX0sdGhpcy5uYXZpZ2F0ZUZpbGVTdGFydD1mdW5jdGlvbigpe3RoaXMuc2VsZWN0aW9uLm1vdmVDdXJzb3JGaWxlU3RhcnQoKSx0aGlzLmNsZWFyU2VsZWN0aW9uKCl9LHRoaXMubmF2aWdhdGVXb3JkUmlnaHQ9ZnVuY3Rpb24oKXt0aGlzLnNlbGVjdGlvbi5tb3ZlQ3Vyc29yV29yZFJpZ2h0KCksdGhpcy5jbGVhclNlbGVjdGlvbigpfSx0aGlzLm5hdmlnYXRlV29yZExlZnQ9ZnVuY3Rpb24oKXt0aGlzLnNlbGVjdGlvbi5tb3ZlQ3Vyc29yV29yZExlZnQoKSx0aGlzLmNsZWFyU2VsZWN0aW9uKCl9LHRoaXMucmVwbGFjZT1mdW5jdGlvbihlLHQpe3QmJnRoaXMuJHNlYXJjaC5zZXQodCk7dmFyIG49dGhpcy4kc2VhcmNoLmZpbmQodGhpcy5zZXNzaW9uKSxyPTA7cmV0dXJuIG4/KHRoaXMuJHRyeVJlcGxhY2UobixlKSYmKHI9MSksdGhpcy5zZWxlY3Rpb24uc2V0U2VsZWN0aW9uUmFuZ2UobiksdGhpcy5yZW5kZXJlci5zY3JvbGxTZWxlY3Rpb25JbnRvVmlldyhuLnN0YXJ0LG4uZW5kKSxyKTpyfSx0aGlzLnJlcGxhY2VBbGw9ZnVuY3Rpb24oZSx0KXt0JiZ0aGlzLiRzZWFyY2guc2V0KHQpO3ZhciBuPXRoaXMuJHNlYXJjaC5maW5kQWxsKHRoaXMuc2Vzc2lvbikscj0wO2lmKCFuLmxlbmd0aClyZXR1cm4gcjt2YXIgaT10aGlzLmdldFNlbGVjdGlvblJhbmdlKCk7dGhpcy5zZWxlY3Rpb24ubW92ZVRvKDAsMCk7Zm9yKHZhciBzPW4ubGVuZ3RoLTE7cz49MDstLXMpdGhpcy4kdHJ5UmVwbGFjZShuW3NdLGUpJiZyKys7cmV0dXJuIHRoaXMuc2VsZWN0aW9uLnNldFNlbGVjdGlvblJhbmdlKGkpLHJ9LHRoaXMuJHRyeVJlcGxhY2U9ZnVuY3Rpb24oZSx0KXt2YXIgbj10aGlzLnNlc3Npb24uZ2V0VGV4dFJhbmdlKGUpO3JldHVybiB0PXRoaXMuJHNlYXJjaC5yZXBsYWNlKG4sdCksdCE9PW51bGw/KGUuZW5kPXRoaXMuc2Vzc2lvbi5yZXBsYWNlKGUsdCksZSk6bnVsbH0sdGhpcy5nZXRMYXN0U2VhcmNoT3B0aW9ucz1mdW5jdGlvbigpe3JldHVybiB0aGlzLiRzZWFyY2guZ2V0T3B0aW9ucygpfSx0aGlzLmZpbmQ9ZnVuY3Rpb24oZSx0LG4pe3R8fCh0PXt9KSx0eXBlb2YgZT09InN0cmluZyJ8fGUgaW5zdGFuY2VvZiBSZWdFeHA/dC5uZWVkbGU9ZTp0eXBlb2YgZT09Im9iamVjdCImJmkubWl4aW4odCxlKTt2YXIgcj10aGlzLnNlbGVjdGlvbi5nZXRSYW5nZSgpO3QubmVlZGxlPT1udWxsJiYoZT10aGlzLnNlc3Npb24uZ2V0VGV4dFJhbmdlKHIpfHx0aGlzLiRzZWFyY2guJG9wdGlvbnMubmVlZGxlLGV8fChyPXRoaXMuc2Vzc2lvbi5nZXRXb3JkUmFuZ2Uoci5zdGFydC5yb3csci5zdGFydC5jb2x1bW4pLGU9dGhpcy5zZXNzaW9uLmdldFRleHRSYW5nZShyKSksdGhpcy4kc2VhcmNoLnNldCh7bmVlZGxlOmV9KSksdGhpcy4kc2VhcmNoLnNldCh0KSx0LnN0YXJ0fHx0aGlzLiRzZWFyY2guc2V0KHtzdGFydDpyfSk7dmFyIHM9dGhpcy4kc2VhcmNoLmZpbmQodGhpcy5zZXNzaW9uKTtpZih0LnByZXZlbnRTY3JvbGwpcmV0dXJuIHM7aWYocylyZXR1cm4gdGhpcy5yZXZlYWxSYW5nZShzLG4pLHM7dC5iYWNrd2FyZHM/ci5zdGFydD1yLmVuZDpyLmVuZD1yLnN0YXJ0LHRoaXMuc2VsZWN0aW9uLnNldFJhbmdlKHIpfSx0aGlzLmZpbmROZXh0PWZ1bmN0aW9uKGUsdCl7dGhpcy5maW5kKHtza2lwQ3VycmVudDohMCxiYWNrd2FyZHM6ITF9LGUsdCl9LHRoaXMuZmluZFByZXZpb3VzPWZ1bmN0aW9uKGUsdCl7dGhpcy5maW5kKGUse3NraXBDdXJyZW50OiEwLGJhY2t3YXJkczohMH0sdCl9LHRoaXMucmV2ZWFsUmFuZ2U9ZnVuY3Rpb24oZSx0KXt0aGlzLnNlc3Npb24udW5mb2xkKGUpLHRoaXMuc2VsZWN0aW9uLnNldFNlbGVjdGlvblJhbmdlKGUpO3ZhciBuPXRoaXMucmVuZGVyZXIuc2Nyb2xsVG9wO3RoaXMucmVuZGVyZXIuc2Nyb2xsU2VsZWN0aW9uSW50b1ZpZXcoZS5zdGFydCxlLmVuZCwuNSksdCE9PSExJiZ0aGlzLnJlbmRlcmVyLmFuaW1hdGVTY3JvbGxpbmcobil9LHRoaXMudW5kbz1mdW5jdGlvbigpe3RoaXMuc2Vzc2lvbi5nZXRVbmRvTWFuYWdlcigpLnVuZG8odGhpcy5zZXNzaW9uKSx0aGlzLnJlbmRlcmVyLnNjcm9sbEN1cnNvckludG9WaWV3KG51bGwsLjUpfSx0aGlzLnJlZG89ZnVuY3Rpb24oKXt0aGlzLnNlc3Npb24uZ2V0VW5kb01hbmFnZXIoKS5yZWRvKHRoaXMuc2Vzc2lvbiksdGhpcy5yZW5kZXJlci5zY3JvbGxDdXJzb3JJbnRvVmlldyhudWxsLC41KX0sdGhpcy5kZXN0cm95PWZ1bmN0aW9uKCl7dGhpcy4kdG9EZXN0cm95JiYodGhpcy4kdG9EZXN0cm95LmZvckVhY2goZnVuY3Rpb24oZSl7ZS5kZXN0cm95KCl9KSx0aGlzLiR0b0Rlc3Ryb3k9bnVsbCksdGhpcy4kbW91c2VIYW5kbGVyJiZ0aGlzLiRtb3VzZUhhbmRsZXIuZGVzdHJveSgpLHRoaXMucmVuZGVyZXIuZGVzdHJveSgpLHRoaXMuX3NpZ25hbCgiZGVzdHJveSIsdGhpcyksdGhpcy5zZXNzaW9uJiZ0aGlzLnNlc3Npb24uZGVzdHJveSgpLHRoaXMuXyRlbWl0SW5wdXRFdmVudCYmdGhpcy5fJGVtaXRJbnB1dEV2ZW50LmNhbmNlbCgpLHRoaXMucmVtb3ZlQWxsTGlzdGVuZXJzKCl9LHRoaXMuc2V0QXV0b1Njcm9sbEVkaXRvckludG9WaWV3PWZ1bmN0aW9uKGUpe2lmKCFlKXJldHVybjt2YXIgdCxuPXRoaXMscj0hMTt0aGlzLiRzY3JvbGxBbmNob3J8fCh0aGlzLiRzY3JvbGxBbmNob3I9ZG9jdW1lbnQuY3JlYXRlRWxlbWVudCgiZGl2IikpO3ZhciBpPXRoaXMuJHNjcm9sbEFuY2hvcjtpLnN0eWxlLmNzc1RleHQ9InBvc2l0aW9uOmFic29sdXRlIix0aGlzLmNvbnRhaW5lci5pbnNlcnRCZWZvcmUoaSx0aGlzLmNvbnRhaW5lci5maXJzdENoaWxkKTt2YXIgcz10aGlzLm9uKCJjaGFuZ2VTZWxlY3Rpb24iLGZ1bmN0aW9uKCl7cj0hMH0pLG89dGhpcy5yZW5kZXJlci5vbigiYmVmb3JlUmVuZGVyIixmdW5jdGlvbigpe3ImJih0PW4ucmVuZGVyZXIuY29udGFpbmVyLmdldEJvdW5kaW5nQ2xpZW50UmVjdCgpKX0pLHU9dGhpcy5yZW5kZXJlci5vbigiYWZ0ZXJSZW5kZXIiLGZ1bmN0aW9uKCl7aWYociYmdCYmKG4uaXNGb2N1c2VkKCl8fG4uc2VhcmNoQm94JiZuLnNlYXJjaEJveC5pc0ZvY3VzZWQoKSkpe3ZhciBlPW4ucmVuZGVyZXIscz1lLiRjdXJzb3JMYXllci4kcGl4ZWxQb3Msbz1lLmxheWVyQ29uZmlnLHU9cy50b3Atby5vZmZzZXQ7cy50b3A+PTAmJnUrdC50b3A8MD9yPSEwOnMudG9wPG8uaGVpZ2h0JiZzLnRvcCt0LnRvcCtvLmxpbmVIZWlnaHQ+d2luZG93LmlubmVySGVpZ2h0P3I9ITE6cj1udWxsLHIhPW51bGwmJihpLnN0eWxlLnRvcD11KyJweCIsaS5zdHlsZS5sZWZ0PXMubGVmdCsicHgiLGkuc3R5bGUuaGVpZ2h0PW8ubGluZUhlaWdodCsicHgiLGkuc2Nyb2xsSW50b1ZpZXcocikpLHI9dD1udWxsfX0pO3RoaXMuc2V0QXV0b1Njcm9sbEVkaXRvckludG9WaWV3PWZ1bmN0aW9uKGUpe2lmKGUpcmV0dXJuO2RlbGV0ZSB0aGlzLnNldEF1dG9TY3JvbGxFZGl0b3JJbnRvVmlldyx0aGlzLm9mZigiY2hhbmdlU2VsZWN0aW9uIixzKSx0aGlzLnJlbmRlcmVyLm9mZigiYWZ0ZXJSZW5kZXIiLHUpLHRoaXMucmVuZGVyZXIub2ZmKCJiZWZvcmVSZW5kZXIiLG8pfX0sdGhpcy4kcmVzZXRDdXJzb3JTdHlsZT1mdW5jdGlvbigpe3ZhciBlPXRoaXMuJGN1cnNvclN0eWxlfHwiYWNlIix0PXRoaXMucmVuZGVyZXIuJGN1cnNvckxheWVyO2lmKCF0KXJldHVybjt0LnNldFNtb290aEJsaW5raW5nKC9zbW9vdGgvLnRlc3QoZSkpLHQuaXNCbGlua2luZz0hdGhpcy4kcmVhZE9ubHkmJmUhPSJ3aWRlIixzLnNldENzc0NsYXNzKHQuZWxlbWVudCwiYWNlX3NsaW0tY3Vyc29ycyIsL3NsaW0vLnRlc3QoZSkpfSx0aGlzLnByb21wdD1mdW5jdGlvbihlLHQsbil7dmFyIHI9dGhpczt5LmxvYWRNb2R1bGUoIi4vZXh0L3Byb21wdCIsZnVuY3Rpb24oaSl7aS5wcm9tcHQocixlLHQsbil9KX19LmNhbGwoRS5wcm90b3R5cGUpLHkuZGVmaW5lT3B0aW9ucyhFLnByb3RvdHlwZSwiZWRpdG9yIix7c2VsZWN0aW9uU3R5bGU6e3NldDpmdW5jdGlvbihlKXt0aGlzLm9uU2VsZWN0aW9uQ2hhbmdlKCksdGhpcy5fc2lnbmFsKCJjaGFuZ2VTZWxlY3Rpb25TdHlsZSIse2RhdGE6ZX0pfSxpbml0aWFsVmFsdWU6ImxpbmUifSxoaWdobGlnaHRBY3RpdmVMaW5lOntzZXQ6ZnVuY3Rpb24oKXt0aGlzLiR1cGRhdGVIaWdobGlnaHRBY3RpdmVMaW5lKCl9LGluaXRpYWxWYWx1ZTohMH0saGlnaGxpZ2h0U2VsZWN0ZWRXb3JkOntzZXQ6ZnVuY3Rpb24oZSl7dGhpcy4kb25TZWxlY3Rpb25DaGFuZ2UoKX0saW5pdGlhbFZhbHVlOiEwfSxyZWFkT25seTp7c2V0OmZ1bmN0aW9uKGUpe3RoaXMudGV4dElucHV0LnNldFJlYWRPbmx5KGUpLHRoaXMuJHJlc2V0Q3Vyc29yU3R5bGUoKX0saW5pdGlhbFZhbHVlOiExfSxjb3B5V2l0aEVtcHR5U2VsZWN0aW9uOntzZXQ6ZnVuY3Rpb24oZSl7dGhpcy50ZXh0SW5wdXQuc2V0Q29weVdpdGhFbXB0eVNlbGVjdGlvbihlKX0saW5pdGlhbFZhbHVlOiExfSxjdXJzb3JTdHlsZTp7c2V0OmZ1bmN0aW9uKGUpe3RoaXMuJHJlc2V0Q3Vyc29yU3R5bGUoKX0sdmFsdWVzOlsiYWNlIiwic2xpbSIsInNtb290aCIsIndpZGUiXSxpbml0aWFsVmFsdWU6ImFjZSJ9LG1lcmdlVW5kb0RlbHRhczp7dmFsdWVzOlshMSwhMCwiYWx3YXlzIl0saW5pdGlhbFZhbHVlOiEwfSxiZWhhdmlvdXJzRW5hYmxlZDp7aW5pdGlhbFZhbHVlOiEwfSx3cmFwQmVoYXZpb3Vyc0VuYWJsZWQ6e2luaXRpYWxWYWx1ZTohMH0sZW5hYmxlQXV0b0luZGVudDp7aW5pdGlhbFZhbHVlOiEwfSxhdXRvU2Nyb2xsRWRpdG9ySW50b1ZpZXc6e3NldDpmdW5jdGlvbihlKXt0aGlzLnNldEF1dG9TY3JvbGxFZGl0b3JJbnRvVmlldyhlKX19LGtleWJvYXJkSGFuZGxlcjp7c2V0OmZ1bmN0aW9uKGUpe3RoaXMuc2V0S2V5Ym9hcmRIYW5kbGVyKGUpfSxnZXQ6ZnVuY3Rpb24oKXtyZXR1cm4gdGhpcy4ka2V5YmluZGluZ0lkfSxoYW5kbGVzU2V0OiEwfSx2YWx1ZTp7c2V0OmZ1bmN0aW9uKGUpe3RoaXMuc2Vzc2lvbi5zZXRWYWx1ZShlKX0sZ2V0OmZ1bmN0aW9uKCl7cmV0dXJuIHRoaXMuZ2V0VmFsdWUoKX0saGFuZGxlc1NldDohMCxoaWRkZW46ITB9LHNlc3Npb246e3NldDpmdW5jdGlvbihlKXt0aGlzLnNldFNlc3Npb24oZSl9LGdldDpmdW5jdGlvbigpe3JldHVybiB0aGlzLnNlc3Npb259LGhhbmRsZXNTZXQ6ITAsaGlkZGVuOiEwfSxzaG93TGluZU51bWJlcnM6e3NldDpmdW5jdGlvbihlKXt0aGlzLnJlbmRlcmVyLiRndXR0ZXJMYXllci5zZXRTaG93TGluZU51bWJlcnMoZSksdGhpcy5yZW5kZXJlci4kbG9vcC5zY2hlZHVsZSh0aGlzLnJlbmRlcmVyLkNIQU5HRV9HVVRURVIpLGUmJnRoaXMuJHJlbGF0aXZlTGluZU51bWJlcnM/Uy5hdHRhY2godGhpcyk6Uy5kZXRhY2godGhpcyl9LGluaXRpYWxWYWx1ZTohMH0scmVsYXRpdmVMaW5lTnVtYmVyczp7c2V0OmZ1bmN0aW9uKGUpe3RoaXMuJHNob3dMaW5lTnVtYmVycyYmZT9TLmF0dGFjaCh0aGlzKTpTLmRldGFjaCh0aGlzKX19LHBsYWNlaG9sZGVyOntzZXQ6ZnVuY3Rpb24oZSl7dGhpcy4kdXBkYXRlUGxhY2Vob2xkZXJ8fCh0aGlzLiR1cGRhdGVQbGFjZWhvbGRlcj1mdW5jdGlvbigpe3ZhciBlPXRoaXMuc2Vzc2lvbiYmKHRoaXMucmVuZGVyZXIuJGNvbXBvc2l0aW9ufHx0aGlzLmdldFZhbHVlKCkpO2lmKGUmJnRoaXMucmVuZGVyZXIucGxhY2Vob2xkZXJOb2RlKXRoaXMucmVuZGVyZXIub2ZmKCJhZnRlclJlbmRlciIsdGhpcy4kdXBkYXRlUGxhY2Vob2xkZXIpLHMucmVtb3ZlQ3NzQ2xhc3ModGhpcy5jb250YWluZXIsImFjZV9oYXNQbGFjZWhvbGRlciIpLHRoaXMucmVuZGVyZXIucGxhY2Vob2xkZXJOb2RlLnJlbW92ZSgpLHRoaXMucmVuZGVyZXIucGxhY2Vob2xkZXJOb2RlPW51bGw7ZWxzZSBpZighZSYmIXRoaXMucmVuZGVyZXIucGxhY2Vob2xkZXJOb2RlKXt0aGlzLnJlbmRlcmVyLm9uKCJhZnRlclJlbmRlciIsdGhpcy4kdXBkYXRlUGxhY2Vob2xkZXIpLHMuYWRkQ3NzQ2xhc3ModGhpcy5jb250YWluZXIsImFjZV9oYXNQbGFjZWhvbGRlciIpO3ZhciB0PXMuY3JlYXRlRWxlbWVudCgiZGl2Iik7dC5jbGFzc05hbWU9ImFjZV9wbGFjZWhvbGRlciIsdC50ZXh0Q29udGVudD10aGlzLiRwbGFjZWhvbGRlcnx8IiIsdGhpcy5yZW5kZXJlci5wbGFjZWhvbGRlck5vZGU9dCx0aGlzLnJlbmRlcmVyLmNvbnRlbnQuYXBwZW5kQ2hpbGQodGhpcy5yZW5kZXJlci5wbGFjZWhvbGRlck5vZGUpfWVsc2UhZSYmdGhpcy5yZW5kZXJlci5wbGFjZWhvbGRlck5vZGUmJih0aGlzLnJlbmRlcmVyLnBsYWNlaG9sZGVyTm9kZS50ZXh0Q29udGVudD10aGlzLiRwbGFjZWhvbGRlcnx8IiIpfS5iaW5kKHRoaXMpLHRoaXMub24oImlucHV0Iix0aGlzLiR1cGRhdGVQbGFjZWhvbGRlcikpLHRoaXMuJHVwZGF0ZVBsYWNlaG9sZGVyKCl9fSxjdXN0b21TY3JvbGxiYXI6InJlbmRlcmVyIixoU2Nyb2xsQmFyQWx3YXlzVmlzaWJsZToicmVuZGVyZXIiLHZTY3JvbGxCYXJBbHdheXNWaXNpYmxlOiJyZW5kZXJlciIsaGlnaGxpZ2h0R3V0dGVyTGluZToicmVuZGVyZXIiLGFuaW1hdGVkU2Nyb2xsOiJyZW5kZXJlciIsc2hvd0ludmlzaWJsZXM6InJlbmRlcmVyIixzaG93UHJpbnRNYXJnaW46InJlbmRlcmVyIixwcmludE1hcmdpbkNvbHVtbjoicmVuZGVyZXIiLHByaW50TWFyZ2luOiJyZW5kZXJlciIsZmFkZUZvbGRXaWRnZXRzOiJyZW5kZXJlciIsc2hvd0ZvbGRXaWRnZXRzOiJyZW5kZXJlciIsZGlzcGxheUluZGVudEd1aWRlczoicmVuZGVyZXIiLGhpZ2hsaWdodEluZGVudEd1aWRlczoicmVuZGVyZXIiLHNob3dHdXR0ZXI6InJlbmRlcmVyIixmb250U2l6ZToicmVuZGVyZXIiLGZvbnRGYW1pbHk6InJlbmRlcmVyIixtYXhMaW5lczoicmVuZGVyZXIiLG1pbkxpbmVzOiJyZW5kZXJlciIsc2Nyb2xsUGFzdEVuZDoicmVuZGVyZXIiLGZpeGVkV2lkdGhHdXR0ZXI6InJlbmRlcmVyIix0aGVtZToicmVuZGVyZXIiLGhhc0Nzc1RyYW5zZm9ybXM6InJlbmRlcmVyIixtYXhQaXhlbEhlaWdodDoicmVuZGVyZXIiLHVzZVRleHRhcmVhRm9ySU1FOiJyZW5kZXJlciIsc2Nyb2xsU3BlZWQ6IiRtb3VzZUhhbmRsZXIiLGRyYWdEZWxheToiJG1vdXNlSGFuZGxlciIsZHJhZ0VuYWJsZWQ6IiRtb3VzZUhhbmRsZXIiLGZvY3VzVGltZW91dDoiJG1vdXNlSGFuZGxlciIsdG9vbHRpcEZvbGxvd3NNb3VzZToiJG1vdXNlSGFuZGxlciIsZmlyc3RMaW5lTnVtYmVyOiJzZXNzaW9uIixvdmVyd3JpdGU6InNlc3Npb24iLG5ld0xpbmVNb2RlOiJzZXNzaW9uIix1c2VXb3JrZXI6InNlc3Npb24iLHVzZVNvZnRUYWJzOiJzZXNzaW9uIixuYXZpZ2F0ZVdpdGhpblNvZnRUYWJzOiJzZXNzaW9uIix0YWJTaXplOiJzZXNzaW9uIix3cmFwOiJzZXNzaW9uIixpbmRlbnRlZFNvZnRXcmFwOiJzZXNzaW9uIixmb2xkU3R5bGU6InNlc3Npb24iLG1vZGU6InNlc3Npb24ifSk7dmFyIFM9e2dldFRleHQ6ZnVuY3Rpb24oZSx0KXtyZXR1cm4oTWF0aC5hYnMoZS5zZWxlY3Rpb24ubGVhZC5yb3ctdCl8fHQrMSsodDw5PyJcdTAwYjciOiIiKSkrIiJ9LGdldFdpZHRoOmZ1bmN0aW9uKGUsdCxuKXtyZXR1cm4gTWF0aC5tYXgodC50b1N0cmluZygpLmxlbmd0aCwobi5sYXN0Um93KzEpLnRvU3RyaW5nKCkubGVuZ3RoLDIpKm4uY2hhcmFjdGVyV2lkdGh9LHVwZGF0ZTpmdW5jdGlvbihlLHQpe3QucmVuZGVyZXIuJGxvb3Auc2NoZWR1bGUodC5yZW5kZXJlci5DSEFOR0VfR1VUVEVSKX0sYXR0YWNoOmZ1bmN0aW9uKGUpe2UucmVuZGVyZXIuJGd1dHRlckxheWVyLiRyZW5kZXJlcj10aGlzLGUub24oImNoYW5nZVNlbGVjdGlvbiIsdGhpcy51cGRhdGUpLHRoaXMudXBkYXRlKG51bGwsZSl9LGRldGFjaDpmdW5jdGlvbihlKXtlLnJlbmRlcmVyLiRndXR0ZXJMYXllci4kcmVuZGVyZXI9PXRoaXMmJihlLnJlbmRlcmVyLiRndXR0ZXJMYXllci4kcmVuZGVyZXI9bnVsbCksZS5vZmYoImNoYW5nZVNlbGVjdGlvbiIsdGhpcy51cGRhdGUpLHRoaXMudXBkYXRlKG51bGwsZSl9fTt0LkVkaXRvcj1FfSksZGVmaW5lKCJhY2UvdW5kb21hbmFnZXIiLFsicmVxdWlyZSIsImV4cG9ydHMiLCJtb2R1bGUiLCJhY2UvcmFuZ2UiXSxmdW5jdGlvbihlLHQsbil7InVzZSBzdHJpY3QiO2Z1bmN0aW9uIGkoZSx0KXtmb3IodmFyIG49dDtuLS07KXt2YXIgcj1lW25dO2lmKHImJiFyWzBdLmlnbm9yZSl7d2hpbGUobjx0LTEpe3ZhciBpPWQoZVtuXSxlW24rMV0pO2Vbbl09aVswXSxlW24rMV09aVsxXSxuKyt9cmV0dXJuITB9fX1mdW5jdGlvbiBhKGUpe3ZhciB0PWUuYWN0aW9uPT0iaW5zZXJ0IixuPWUuc3RhcnQscj1lLmVuZCxpPShyLnJvdy1uLnJvdykqKHQ/MTotMSkscz0oci5jb2x1bW4tbi5jb2x1bW4pKih0PzE6LTEpO3QmJihyPW4pO2Zvcih2YXIgbyBpbiB0aGlzLm1hcmtzKXt2YXIgYT10aGlzLm1hcmtzW29dLGY9dShhLG4pO2lmKGY8MCljb250aW51ZTtpZihmPT09MCYmdCl7aWYoYS5iaWFzIT0xKXthLmJpYXM9PS0xO2NvbnRpbnVlfWY9MX12YXIgbD10P2Y6dShhLHIpO2lmKGw+MCl7YS5yb3crPWksYS5jb2x1bW4rPWEucm93PT1yLnJvdz9zOjA7Y29udGludWV9IXQmJmw8PTAmJihhLnJvdz1uLnJvdyxhLmNvbHVtbj1uLmNvbHVtbixsPT09MCYmKGEuYmlhcz0xKSl9fWZ1bmN0aW9uIGYoZSl7cmV0dXJue3JvdzplLnJvdyxjb2x1bW46ZS5jb2x1bW59fWZ1bmN0aW9uIGwoZSl7cmV0dXJue3N0YXJ0OmYoZS5zdGFydCksZW5kOmYoZS5lbmQpLGFjdGlvbjplLmFjdGlvbixsaW5lczplLmxpbmVzLnNsaWNlKCl9fWZ1bmN0aW9uIGMoZSl7ZT1lfHx0aGlzO2lmKEFycmF5LmlzQXJyYXkoZSkpcmV0dXJuIGUubWFwKGMpLmpvaW4oIlxuIik7dmFyIHQ9IiI7ZS5hY3Rpb24/KHQ9ZS5hY3Rpb249PSJpbnNlcnQiPyIrIjoiLSIsdCs9IlsiK2UubGluZXMrIl0iKTplLnZhbHVlJiYoQXJyYXkuaXNBcnJheShlLnZhbHVlKT90PWUudmFsdWUubWFwKGgpLmpvaW4oIlxuIik6dD1oKGUudmFsdWUpKSxlLnN0YXJ0JiYodCs9aChlKSk7aWYoZS5pZHx8ZS5yZXYpdCs9IgkoIisoZS5pZHx8ZS5yZXYpKyIpIjtyZXR1cm4gdH1mdW5jdGlvbiBoKGUpe3JldHVybiBlLnN0YXJ0LnJvdysiOiIrZS5zdGFydC5jb2x1bW4rIj0+IitlLmVuZC5yb3crIjoiK2UuZW5kLmNvbHVtbn1mdW5jdGlvbiBwKGUsdCl7dmFyIG49ZS5hY3Rpb249PSJpbnNlcnQiLHI9dC5hY3Rpb249PSJpbnNlcnQiO2lmKG4mJnIpaWYobyh0LnN0YXJ0LGUuZW5kKT49MCltKHQsZSwtMSk7ZWxzZXtpZighKG8odC5zdGFydCxlLnN0YXJ0KTw9MCkpcmV0dXJuIG51bGw7bShlLHQsMSl9ZWxzZSBpZihuJiYhcilpZihvKHQuc3RhcnQsZS5lbmQpPj0wKW0odCxlLC0xKTtlbHNle2lmKCEobyh0LmVuZCxlLnN0YXJ0KTw9MCkpcmV0dXJuIG51bGw7bShlLHQsLTEpfWVsc2UgaWYoIW4mJnIpaWYobyh0LnN0YXJ0LGUuc3RhcnQpPj0wKW0odCxlLDEpO2Vsc2V7aWYoIShvKHQuc3RhcnQsZS5zdGFydCk8PTApKXJldHVybiBudWxsO20oZSx0LDEpfWVsc2UgaWYoIW4mJiFyKWlmKG8odC5zdGFydCxlLnN0YXJ0KT49MCltKHQsZSwxKTtlbHNle2lmKCEobyh0LmVuZCxlLnN0YXJ0KTw9MCkpcmV0dXJuIG51bGw7bShlLHQsLTEpfXJldHVyblt0LGVdfWZ1bmN0aW9uIGQoZSx0KXtmb3IodmFyIG49ZS5sZW5ndGg7bi0tOylmb3IodmFyIHI9MDtyPHQubGVuZ3RoO3IrKylpZighcChlW25dLHRbcl0pKXt3aGlsZShuPGUubGVuZ3RoKXt3aGlsZShyLS0pcCh0W3JdLGVbbl0pO3I9dC5sZW5ndGgsbisrfXJldHVybltlLHRdfXJldHVybiBlLnNlbGVjdGlvbkJlZm9yZT10LnNlbGVjdGlvbkJlZm9yZT1lLnNlbGVjdGlvbkFmdGVyPXQuc2VsZWN0aW9uQWZ0ZXI9bnVsbCxbdCxlXX1mdW5jdGlvbiB2KGUsdCl7dmFyIG49ZS5hY3Rpb249PSJpbnNlcnQiLHI9dC5hY3Rpb249PSJpbnNlcnQiO2lmKG4mJnIpbyhlLnN0YXJ0LHQuc3RhcnQpPDA/bSh0LGUsMSk6bShlLHQsMSk7ZWxzZSBpZihuJiYhcilvKGUuc3RhcnQsdC5lbmQpPj0wP20oZSx0LC0xKTpvKGUuc3RhcnQsdC5zdGFydCk8PTA/bSh0LGUsMSk6KG0oZSxzLmZyb21Qb2ludHModC5zdGFydCxlLnN0YXJ0KSwtMSksbSh0LGUsMSkpO2Vsc2UgaWYoIW4mJnIpbyh0LnN0YXJ0LGUuZW5kKT49MD9tKHQsZSwtMSk6byh0LnN0YXJ0LGUuc3RhcnQpPD0wP20oZSx0LDEpOihtKHQscy5mcm9tUG9pbnRzKGUuc3RhcnQsdC5zdGFydCksLTEpLG0oZSx0LDEpKTtlbHNlIGlmKCFuJiYhcilpZihvKHQuc3RhcnQsZS5lbmQpPj0wKW0odCxlLC0xKTtlbHNle2lmKCEobyh0LmVuZCxlLnN0YXJ0KTw9MCkpe3ZhciBpLHU7cmV0dXJuIG8oZS5zdGFydCx0LnN0YXJ0KTwwJiYoaT1lLGU9eShlLHQuc3RhcnQpKSxvKGUuZW5kLHQuZW5kKT4wJiYodT15KGUsdC5lbmQpKSxnKHQuZW5kLGUuc3RhcnQsZS5lbmQsLTEpLHUmJiFpJiYoZS5saW5lcz11LmxpbmVzLGUuc3RhcnQ9dS5zdGFydCxlLmVuZD11LmVuZCx1PWUpLFt0LGksdV0uZmlsdGVyKEJvb2xlYW4pfW0oZSx0LC0xKX1yZXR1cm5bdCxlXX1mdW5jdGlvbiBtKGUsdCxuKXtnKGUuc3RhcnQsdC5zdGFydCx0LmVuZCxuKSxnKGUuZW5kLHQuc3RhcnQsdC5lbmQsbil9ZnVuY3Rpb24gZyhlLHQsbixyKXtlLnJvdz09KHI9PTE/dDpuKS5yb3cmJihlLmNvbHVtbis9cioobi5jb2x1bW4tdC5jb2x1bW4pKSxlLnJvdys9cioobi5yb3ctdC5yb3cpfWZ1bmN0aW9uIHkoZSx0KXt2YXIgbj1lLmxpbmVzLHI9ZS5lbmQ7ZS5lbmQ9Zih0KTt2YXIgaT1lLmVuZC5yb3ctZS5zdGFydC5yb3cscz1uLnNwbGljZShpLG4ubGVuZ3RoKSxvPWk/dC5jb2x1bW46dC5jb2x1bW4tZS5zdGFydC5jb2x1bW47bi5wdXNoKHNbMF0uc3Vic3RyaW5nKDAsbykpLHNbMF09c1swXS5zdWJzdHIobyk7dmFyIHU9e3N0YXJ0OmYodCksZW5kOnIsbGluZXM6cyxhY3Rpb246ZS5hY3Rpb259O3JldHVybiB1fWZ1bmN0aW9uIGIoZSx0KXt0PWwodCk7Zm9yKHZhciBuPWUubGVuZ3RoO24tLTspe3ZhciByPWVbbl07Zm9yKHZhciBpPTA7aTxyLmxlbmd0aDtpKyspe3ZhciBzPXJbaV0sbz12KHMsdCk7dD1vWzBdLG8ubGVuZ3RoIT0yJiYob1syXT8oci5zcGxpY2UoaSsxLDEsb1sxXSxvWzJdKSxpKyspOm9bMV18fChyLnNwbGljZShpLDEpLGktLSkpfXIubGVuZ3RofHxlLnNwbGljZShuLDEpfXJldHVybiBlfWZ1bmN0aW9uIHcoZSx0KXtmb3IodmFyIG49MDtuPHQubGVuZ3RoO24rKyl7dmFyIHI9dFtuXTtmb3IodmFyIGk9MDtpPHIubGVuZ3RoO2krKyliKGUscltpXSl9fXZhciByPWZ1bmN0aW9uKCl7dGhpcy4kbWF4UmV2PTAsdGhpcy4kZnJvbVVuZG89ITEsdGhpcy4kdW5kb0RlcHRoPUluZmluaXR5LHRoaXMucmVzZXQoKX07KGZ1bmN0aW9uKCl7dGhpcy5hZGRTZXNzaW9uPWZ1bmN0aW9uKGUpe3RoaXMuJHNlc3Npb249ZX0sdGhpcy5hZGQ9ZnVuY3Rpb24oZSx0LG4pe2lmKHRoaXMuJGZyb21VbmRvKXJldHVybjtpZihlPT10aGlzLiRsYXN0RGVsdGEpcmV0dXJuO3RoaXMuJGtlZXBSZWRvU3RhY2t8fCh0aGlzLiRyZWRvU3RhY2subGVuZ3RoPTApO2lmKHQ9PT0hMXx8IXRoaXMubGFzdERlbHRhcyl7dGhpcy5sYXN0RGVsdGFzPVtdO3ZhciByPXRoaXMuJHVuZG9TdGFjay5sZW5ndGg7cj50aGlzLiR1bmRvRGVwdGgtMSYmdGhpcy4kdW5kb1N0YWNrLnNwbGljZSgwLHItdGhpcy4kdW5kb0RlcHRoKzEpLHRoaXMuJHVuZG9TdGFjay5wdXNoKHRoaXMubGFzdERlbHRhcyksZS5pZD10aGlzLiRyZXY9Kyt0aGlzLiRtYXhSZXZ9aWYoZS5hY3Rpb249PSJyZW1vdmUifHxlLmFjdGlvbj09Imluc2VydCIpdGhpcy4kbGFzdERlbHRhPWU7dGhpcy5sYXN0RGVsdGFzLnB1c2goZSl9LHRoaXMuYWRkU2VsZWN0aW9uPWZ1bmN0aW9uKGUsdCl7dGhpcy5zZWxlY3Rpb25zLnB1c2goe3ZhbHVlOmUscmV2OnR8fHRoaXMuJHJldn0pfSx0aGlzLnN0YXJ0TmV3R3JvdXA9ZnVuY3Rpb24oKXtyZXR1cm4gdGhpcy5sYXN0RGVsdGFzPW51bGwsdGhpcy4kcmV2fSx0aGlzLm1hcmtJZ25vcmVkPWZ1bmN0aW9uKGUsdCl7dD09bnVsbCYmKHQ9dGhpcy4kcmV2KzEpO3ZhciBuPXRoaXMuJHVuZG9TdGFjaztmb3IodmFyIHI9bi5sZW5ndGg7ci0tOyl7dmFyIGk9bltyXVswXTtpZihpLmlkPD1lKWJyZWFrO2kuaWQ8dCYmKGkuaWdub3JlPSEwKX10aGlzLmxhc3REZWx0YXM9bnVsbH0sdGhpcy5nZXRTZWxlY3Rpb249ZnVuY3Rpb24oZSx0KXt2YXIgbj10aGlzLnNlbGVjdGlvbnM7Zm9yKHZhciByPW4ubGVuZ3RoO3ItLTspe3ZhciBpPW5bcl07aWYoaS5yZXY8ZSlyZXR1cm4gdCYmKGk9bltyKzFdKSxpfX0sdGhpcy5nZXRSZXZpc2lvbj1mdW5jdGlvbigpe3JldHVybiB0aGlzLiRyZXZ9LHRoaXMuZ2V0RGVsdGFzPWZ1bmN0aW9uKGUsdCl7dD09bnVsbCYmKHQ9dGhpcy4kcmV2KzEpO3ZhciBuPXRoaXMuJHVuZG9TdGFjayxyPW51bGwsaT0wO2Zvcih2YXIgcz1uLmxlbmd0aDtzLS07KXt2YXIgbz1uW3NdWzBdO28uaWQ8dCYmIXImJihyPXMrMSk7aWYoby5pZDw9ZSl7aT1zKzE7YnJlYWt9fXJldHVybiBuLnNsaWNlKGkscil9LHRoaXMuZ2V0Q2hhbmdlZFJhbmdlcz1mdW5jdGlvbihlLHQpe3Q9PW51bGwmJih0PXRoaXMuJHJldisxKX0sdGhpcy5nZXRDaGFuZ2VkTGluZXM9ZnVuY3Rpb24oZSx0KXt0PT1udWxsJiYodD10aGlzLiRyZXYrMSl9LHRoaXMudW5kbz1mdW5jdGlvbihlLHQpe3RoaXMubGFzdERlbHRhcz1udWxsO3ZhciBuPXRoaXMuJHVuZG9TdGFjaztpZighaShuLG4ubGVuZ3RoKSlyZXR1cm47ZXx8KGU9dGhpcy4kc2Vzc2lvbiksdGhpcy4kcmVkb1N0YWNrQmFzZVJldiE9PXRoaXMuJHJldiYmdGhpcy4kcmVkb1N0YWNrLmxlbmd0aCYmKHRoaXMuJHJlZG9TdGFjaz1bXSksdGhpcy4kZnJvbVVuZG89ITA7dmFyIHI9bi5wb3AoKSxzPW51bGw7cmV0dXJuIHImJihzPWUudW5kb0NoYW5nZXMocix0KSx0aGlzLiRyZWRvU3RhY2sucHVzaChyKSx0aGlzLiRzeW5jUmV2KCkpLHRoaXMuJGZyb21VbmRvPSExLHN9LHRoaXMucmVkbz1mdW5jdGlvbihlLHQpe3RoaXMubGFzdERlbHRhcz1udWxsLGV8fChlPXRoaXMuJHNlc3Npb24pLHRoaXMuJGZyb21VbmRvPSEwO2lmKHRoaXMuJHJlZG9TdGFja0Jhc2VSZXYhPXRoaXMuJHJldil7dmFyIG49dGhpcy5nZXREZWx0YXModGhpcy4kcmVkb1N0YWNrQmFzZVJldix0aGlzLiRyZXYrMSk7dyh0aGlzLiRyZWRvU3RhY2ssbiksdGhpcy4kcmVkb1N0YWNrQmFzZVJldj10aGlzLiRyZXYsdGhpcy4kcmVkb1N0YWNrLmZvckVhY2goZnVuY3Rpb24oZSl7ZVswXS5pZD0rK3RoaXMuJG1heFJldn0sdGhpcyl9dmFyIHI9dGhpcy4kcmVkb1N0YWNrLnBvcCgpLGk9bnVsbDtyZXR1cm4gciYmKGk9ZS5yZWRvQ2hhbmdlcyhyLHQpLHRoaXMuJHVuZG9TdGFjay5wdXNoKHIpLHRoaXMuJHN5bmNSZXYoKSksdGhpcy4kZnJvbVVuZG89ITEsaX0sdGhpcy4kc3luY1Jldj1mdW5jdGlvbigpe3ZhciBlPXRoaXMuJHVuZG9TdGFjayx0PWVbZS5sZW5ndGgtMV0sbj10JiZ0WzBdLmlkfHwwO3RoaXMuJHJlZG9TdGFja0Jhc2VSZXY9bix0aGlzLiRyZXY9bn0sdGhpcy5yZXNldD1mdW5jdGlvbigpe3RoaXMubGFzdERlbHRhcz1udWxsLHRoaXMuJGxhc3REZWx0YT1udWxsLHRoaXMuJHVuZG9TdGFjaz1bXSx0aGlzLiRyZWRvU3RhY2s9W10sdGhpcy4kcmV2PTAsdGhpcy5tYXJrPTAsdGhpcy4kcmVkb1N0YWNrQmFzZVJldj10aGlzLiRyZXYsdGhpcy5zZWxlY3Rpb25zPVtdfSx0aGlzLmNhblVuZG89ZnVuY3Rpb24oKXtyZXR1cm4gdGhpcy4kdW5kb1N0YWNrLmxlbmd0aD4wfSx0aGlzLmNhblJlZG89ZnVuY3Rpb24oKXtyZXR1cm4gdGhpcy4kcmVkb1N0YWNrLmxlbmd0aD4wfSx0aGlzLmJvb2ttYXJrPWZ1bmN0aW9uKGUpe2U9PXVuZGVmaW5lZCYmKGU9dGhpcy4kcmV2KSx0aGlzLm1hcms9ZX0sdGhpcy5pc0F0Qm9va21hcms9ZnVuY3Rpb24oKXtyZXR1cm4gdGhpcy4kcmV2PT09dGhpcy5tYXJrfSx0aGlzLnRvSlNPTj1mdW5jdGlvbigpe30sdGhpcy5mcm9tSlNPTj1mdW5jdGlvbigpe30sdGhpcy5oYXNVbmRvPXRoaXMuY2FuVW5kbyx0aGlzLmhhc1JlZG89dGhpcy5jYW5SZWRvLHRoaXMuaXNDbGVhbj10aGlzLmlzQXRCb29rbWFyayx0aGlzLm1hcmtDbGVhbj10aGlzLmJvb2ttYXJrLHRoaXMuJHByZXR0eVByaW50PWZ1bmN0aW9uKGUpe3JldHVybiBlP2MoZSk6Yyh0aGlzLiR1bmRvU3RhY2spKyJcbi0tLVxuIitjKHRoaXMuJHJlZG9TdGFjayl9fSkuY2FsbChyLnByb3RvdHlwZSk7dmFyIHM9ZSgiLi9yYW5nZSIpLlJhbmdlLG89cy5jb21wYXJlUG9pbnRzLHU9cy5jb21wYXJlUG9pbnRzO3QuVW5kb01hbmFnZXI9cn0pLGRlZmluZSgiYWNlL2xheWVyL2xpbmVzIixbInJlcXVpcmUiLCJleHBvcnRzIiwibW9kdWxlIiwiYWNlL2xpYi9kb20iXSxmdW5jdGlvbihlLHQsbil7InVzZSBzdHJpY3QiO3ZhciByPWUoIi4uL2xpYi9kb20iKSxpPWZ1bmN0aW9uKGUsdCl7dGhpcy5lbGVtZW50PWUsdGhpcy5jYW52YXNIZWlnaHQ9dHx8NWU1LHRoaXMuZWxlbWVudC5zdHlsZS5oZWlnaHQ9dGhpcy5jYW52YXNIZWlnaHQqMisicHgiLHRoaXMuY2VsbHM9W10sdGhpcy5jZWxsQ2FjaGU9W10sdGhpcy4kb2Zmc2V0Q29lZmZpY2llbnQ9MH07KGZ1bmN0aW9uKCl7dGhpcy5tb3ZlQ29udGFpbmVyPWZ1bmN0aW9uKGUpe3IudHJhbnNsYXRlKHRoaXMuZWxlbWVudCwwLC0oZS5maXJzdFJvd1NjcmVlbiplLmxpbmVIZWlnaHQldGhpcy5jYW52YXNIZWlnaHQpLWUub2Zmc2V0KnRoaXMuJG9mZnNldENvZWZmaWNpZW50KX0sdGhpcy5wYWdlQ2hhbmdlZD1mdW5jdGlvbihlLHQpe3JldHVybiBNYXRoLmZsb29yKGUuZmlyc3RSb3dTY3JlZW4qZS5saW5lSGVpZ2h0L3RoaXMuY2FudmFzSGVpZ2h0KSE9PU1hdGguZmxvb3IodC5maXJzdFJvd1NjcmVlbip0LmxpbmVIZWlnaHQvdGhpcy5jYW52YXNIZWlnaHQpfSx0aGlzLmNvbXB1dGVMaW5lVG9wPWZ1bmN0aW9uKGUsdCxuKXt2YXIgcj10LmZpcnN0Um93U2NyZWVuKnQubGluZUhlaWdodCxpPU1hdGguZmxvb3Ioci90aGlzLmNhbnZhc0hlaWdodCkscz1uLmRvY3VtZW50VG9TY3JlZW5Sb3coZSwwKSp0LmxpbmVIZWlnaHQ7cmV0dXJuIHMtaSp0aGlzLmNhbnZhc0hlaWdodH0sdGhpcy5jb21wdXRlTGluZUhlaWdodD1mdW5jdGlvbihlLHQsbil7cmV0dXJuIHQubGluZUhlaWdodCpuLmdldFJvd0xpbmVDb3VudChlKX0sdGhpcy5nZXRMZW5ndGg9ZnVuY3Rpb24oKXtyZXR1cm4gdGhpcy5jZWxscy5sZW5ndGh9LHRoaXMuZ2V0PWZ1bmN0aW9uKGUpe3JldHVybiB0aGlzLmNlbGxzW2VdfSx0aGlzLnNoaWZ0PWZ1bmN0aW9uKCl7dGhpcy4kY2FjaGVDZWxsKHRoaXMuY2VsbHMuc2hpZnQoKSl9LHRoaXMucG9wPWZ1bmN0aW9uKCl7dGhpcy4kY2FjaGVDZWxsKHRoaXMuY2VsbHMucG9wKCkpfSx0aGlzLnB1c2g9ZnVuY3Rpb24oZSl7aWYoQXJyYXkuaXNBcnJheShlKSl7dGhpcy5jZWxscy5wdXNoLmFwcGx5KHRoaXMuY2VsbHMsZSk7dmFyIHQ9ci5jcmVhdGVGcmFnbWVudCh0aGlzLmVsZW1lbnQpO2Zvcih2YXIgbj0wO248ZS5sZW5ndGg7bisrKXQuYXBwZW5kQ2hpbGQoZVtuXS5lbGVtZW50KTt0aGlzLmVsZW1lbnQuYXBwZW5kQ2hpbGQodCl9ZWxzZSB0aGlzLmNlbGxzLnB1c2goZSksdGhpcy5lbGVtZW50LmFwcGVuZENoaWxkKGUuZWxlbWVudCl9LHRoaXMudW5zaGlmdD1mdW5jdGlvbihlKXtpZihBcnJheS5pc0FycmF5KGUpKXt0aGlzLmNlbGxzLnVuc2hpZnQuYXBwbHkodGhpcy5jZWxscyxlKTt2YXIgdD1yLmNyZWF0ZUZyYWdtZW50KHRoaXMuZWxlbWVudCk7Zm9yKHZhciBuPTA7bjxlLmxlbmd0aDtuKyspdC5hcHBlbmRDaGlsZChlW25dLmVsZW1lbnQpO3RoaXMuZWxlbWVudC5maXJzdENoaWxkP3RoaXMuZWxlbWVudC5pbnNlcnRCZWZvcmUodCx0aGlzLmVsZW1lbnQuZmlyc3RDaGlsZCk6dGhpcy5lbGVtZW50LmFwcGVuZENoaWxkKHQpfWVsc2UgdGhpcy5jZWxscy51bnNoaWZ0KGUpLHRoaXMuZWxlbWVudC5pbnNlcnRBZGphY2VudEVsZW1lbnQoImFmdGVyYmVnaW4iLGUuZWxlbWVudCl9LHRoaXMubGFzdD1mdW5jdGlvbigpe3JldHVybiB0aGlzLmNlbGxzLmxlbmd0aD90aGlzLmNlbGxzW3RoaXMuY2VsbHMubGVuZ3RoLTFdOm51bGx9LHRoaXMuJGNhY2hlQ2VsbD1mdW5jdGlvbihlKXtpZighZSlyZXR1cm47ZS5lbGVtZW50LnJlbW92ZSgpLHRoaXMuY2VsbENhY2hlLnB1c2goZSl9LHRoaXMuY3JlYXRlQ2VsbD1mdW5jdGlvbihlLHQsbixpKXt2YXIgcz10aGlzLmNlbGxDYWNoZS5wb3AoKTtpZighcyl7dmFyIG89ci5jcmVhdGVFbGVtZW50KCJkaXYiKTtpJiZpKG8pLHRoaXMuZWxlbWVudC5hcHBlbmRDaGlsZChvKSxzPXtlbGVtZW50Om8sdGV4dDoiIixyb3c6ZX19cmV0dXJuIHMucm93PWUsc319KS5jYWxsKGkucHJvdG90eXBlKSx0LkxpbmVzPWl9KSxkZWZpbmUoImFjZS9sYXllci9ndXR0ZXIiLFsicmVxdWlyZSIsImV4cG9ydHMiLCJtb2R1bGUiLCJhY2UvbGliL2RvbSIsImFjZS9saWIvb29wIiwiYWNlL2xpYi9sYW5nIiwiYWNlL2xpYi9ldmVudF9lbWl0dGVyIiwiYWNlL2xheWVyL2xpbmVzIl0sZnVuY3Rpb24oZSx0LG4peyJ1c2Ugc3RyaWN0IjtmdW5jdGlvbiBmKGUpe3ZhciB0PWRvY3VtZW50LmNyZWF0ZVRleHROb2RlKCIiKTtlLmFwcGVuZENoaWxkKHQpO3ZhciBuPXIuY3JlYXRlRWxlbWVudCgic3BhbiIpO3JldHVybiBlLmFwcGVuZENoaWxkKG4pLGV9dmFyIHI9ZSgiLi4vbGliL2RvbSIpLGk9ZSgiLi4vbGliL29vcCIpLHM9ZSgiLi4vbGliL2xhbmciKSxvPWUoIi4uL2xpYi9ldmVudF9lbWl0dGVyIikuRXZlbnRFbWl0dGVyLHU9ZSgiLi9saW5lcyIpLkxpbmVzLGE9ZnVuY3Rpb24oZSl7dGhpcy5lbGVtZW50PXIuY3JlYXRlRWxlbWVudCgiZGl2IiksdGhpcy5lbGVtZW50LmNsYXNzTmFtZT0iYWNlX2xheWVyIGFjZV9ndXR0ZXItbGF5ZXIiLGUuYXBwZW5kQ2hpbGQodGhpcy5lbGVtZW50KSx0aGlzLnNldFNob3dGb2xkV2lkZ2V0cyh0aGlzLiRzaG93Rm9sZFdpZGdldHMpLHRoaXMuZ3V0dGVyV2lkdGg9MCx0aGlzLiRhbm5vdGF0aW9ucz1bXSx0aGlzLiR1cGRhdGVBbm5vdGF0aW9ucz10aGlzLiR1cGRhdGVBbm5vdGF0aW9ucy5iaW5kKHRoaXMpLHRoaXMuJGxpbmVzPW5ldyB1KHRoaXMuZWxlbWVudCksdGhpcy4kbGluZXMuJG9mZnNldENvZWZmaWNpZW50PTF9OyhmdW5jdGlvbigpe2kuaW1wbGVtZW50KHRoaXMsbyksdGhpcy5zZXRTZXNzaW9uPWZ1bmN0aW9uKGUpe3RoaXMuc2Vzc2lvbiYmdGhpcy5zZXNzaW9uLm9mZigiY2hhbmdlIix0aGlzLiR1cGRhdGVBbm5vdGF0aW9ucyksdGhpcy5zZXNzaW9uPWUsZSYmZS5vbigiY2hhbmdlIix0aGlzLiR1cGRhdGVBbm5vdGF0aW9ucyl9LHRoaXMuYWRkR3V0dGVyRGVjb3JhdGlvbj1mdW5jdGlvbihlLHQpe3dpbmRvdy5jb25zb2xlJiZjb25zb2xlLndhcm4mJmNvbnNvbGUud2FybigiZGVwcmVjYXRlZCB1c2Ugc2Vzc2lvbi5hZGRHdXR0ZXJEZWNvcmF0aW9uIiksdGhpcy5zZXNzaW9uLmFkZEd1dHRlckRlY29yYXRpb24oZSx0KX0sdGhpcy5yZW1vdmVHdXR0ZXJEZWNvcmF0aW9uPWZ1bmN0aW9uKGUsdCl7d2luZG93LmNvbnNvbGUmJmNvbnNvbGUud2FybiYmY29uc29sZS53YXJuKCJkZXByZWNhdGVkIHVzZSBzZXNzaW9uLnJlbW92ZUd1dHRlckRlY29yYXRpb24iKSx0aGlzLnNlc3Npb24ucmVtb3ZlR3V0dGVyRGVjb3JhdGlvbihlLHQpfSx0aGlzLnNldEFubm90YXRpb25zPWZ1bmN0aW9uKGUpe3RoaXMuJGFubm90YXRpb25zPVtdO2Zvcih2YXIgdD0wO3Q8ZS5sZW5ndGg7dCsrKXt2YXIgbj1lW3RdLHI9bi5yb3csaT10aGlzLiRhbm5vdGF0aW9uc1tyXTtpfHwoaT10aGlzLiRhbm5vdGF0aW9uc1tyXT17dGV4dDpbXX0pO3ZhciBvPW4udGV4dDtvPW8/cy5lc2NhcGVIVE1MKG8pOm4uaHRtbHx8IiIsaS50ZXh0LmluZGV4T2Yobyk9PT0tMSYmaS50ZXh0LnB1c2gobyk7dmFyIHU9bi50eXBlLGE9bi5jbGFzc05hbWU7YT9pLmNsYXNzTmFtZT1hOnU9PSJlcnJvciI/aS5jbGFzc05hbWU9IiBhY2VfZXJyb3IiOnU9PSJ3YXJuaW5nIiYmaS5jbGFzc05hbWUhPSIgYWNlX2Vycm9yIj9pLmNsYXNzTmFtZT0iIGFjZV93YXJuaW5nIjp1PT0iaW5mbyImJiFpLmNsYXNzTmFtZSYmKGkuY2xhc3NOYW1lPSIgYWNlX2luZm8iKX19LHRoaXMuJHVwZGF0ZUFubm90YXRpb25zPWZ1bmN0aW9uKGUpe2lmKCF0aGlzLiRhbm5vdGF0aW9ucy5sZW5ndGgpcmV0dXJuO3ZhciB0PWUuc3RhcnQucm93LG49ZS5lbmQucm93LXQ7aWYobiE9PTApaWYoZS5hY3Rpb249PSJyZW1vdmUiKXRoaXMuJGFubm90YXRpb25zLnNwbGljZSh0LG4rMSxudWxsKTtlbHNle3ZhciByPW5ldyBBcnJheShuKzEpO3IudW5zaGlmdCh0LDEpLHRoaXMuJGFubm90YXRpb25zLnNwbGljZS5hcHBseSh0aGlzLiRhbm5vdGF0aW9ucyxyKX19LHRoaXMudXBkYXRlPWZ1bmN0aW9uKGUpe3RoaXMuY29uZmlnPWU7dmFyIHQ9dGhpcy5zZXNzaW9uLG49ZS5maXJzdFJvdyxyPU1hdGgubWluKGUubGFzdFJvdytlLmd1dHRlck9mZnNldCx0LmdldExlbmd0aCgpLTEpO3RoaXMub2xkTGFzdFJvdz1yLHRoaXMuY29uZmlnPWUsdGhpcy4kbGluZXMubW92ZUNvbnRhaW5lcihlKSx0aGlzLiR1cGRhdGVDdXJzb3JSb3coKTt2YXIgaT10LmdldE5leHRGb2xkTGluZShuKSxzPWk/aS5zdGFydC5yb3c6SW5maW5pdHksbz1udWxsLHU9LTEsYT1uO2Zvcig7Oyl7YT5zJiYoYT1pLmVuZC5yb3crMSxpPXQuZ2V0TmV4dEZvbGRMaW5lKGEsaSkscz1pP2kuc3RhcnQucm93OkluZmluaXR5KTtpZihhPnIpe3doaWxlKHRoaXMuJGxpbmVzLmdldExlbmd0aCgpPnUrMSl0aGlzLiRsaW5lcy5wb3AoKTticmVha31vPXRoaXMuJGxpbmVzLmdldCgrK3UpLG8/by5yb3c9YToobz10aGlzLiRsaW5lcy5jcmVhdGVDZWxsKGEsZSx0aGlzLnNlc3Npb24sZiksdGhpcy4kbGluZXMucHVzaChvKSksdGhpcy4kcmVuZGVyQ2VsbChvLGUsaSxhKSxhKyt9dGhpcy5fc2lnbmFsKCJhZnRlclJlbmRlciIpLHRoaXMuJHVwZGF0ZUd1dHRlcldpZHRoKGUpfSx0aGlzLiR1cGRhdGVHdXR0ZXJXaWR0aD1mdW5jdGlvbihlKXt2YXIgdD10aGlzLnNlc3Npb24sbj10Lmd1dHRlclJlbmRlcmVyfHx0aGlzLiRyZW5kZXJlcixyPXQuJGZpcnN0TGluZU51bWJlcixpPXRoaXMuJGxpbmVzLmxhc3QoKT90aGlzLiRsaW5lcy5sYXN0KCkudGV4dDoiIjtpZih0aGlzLiRmaXhlZFdpZHRofHx0LiR1c2VXcmFwTW9kZSlpPXQuZ2V0TGVuZ3RoKCkrci0xO3ZhciBzPW4/bi5nZXRXaWR0aCh0LGksZSk6aS50b1N0cmluZygpLmxlbmd0aCplLmNoYXJhY3RlcldpZHRoLG89dGhpcy4kcGFkZGluZ3x8dGhpcy4kY29tcHV0ZVBhZGRpbmcoKTtzKz1vLmxlZnQrby5yaWdodCxzIT09dGhpcy5ndXR0ZXJXaWR0aCYmIWlzTmFOKHMpJiYodGhpcy5ndXR0ZXJXaWR0aD1zLHRoaXMuZWxlbWVudC5wYXJlbnROb2RlLnN0eWxlLndpZHRoPXRoaXMuZWxlbWVudC5zdHlsZS53aWR0aD1NYXRoLmNlaWwodGhpcy5ndXR0ZXJXaWR0aCkrInB4Iix0aGlzLl9zaWduYWwoImNoYW5nZUd1dHRlcldpZHRoIixzKSl9LHRoaXMuJHVwZGF0ZUN1cnNvclJvdz1mdW5jdGlvbigpe2lmKCF0aGlzLiRoaWdobGlnaHRHdXR0ZXJMaW5lKXJldHVybjt2YXIgZT10aGlzLnNlc3Npb24uc2VsZWN0aW9uLmdldEN1cnNvcigpO2lmKHRoaXMuJGN1cnNvclJvdz09PWUucm93KXJldHVybjt0aGlzLiRjdXJzb3JSb3c9ZS5yb3d9LHRoaXMudXBkYXRlTGluZUhpZ2hsaWdodD1mdW5jdGlvbigpe2lmKCF0aGlzLiRoaWdobGlnaHRHdXR0ZXJMaW5lKXJldHVybjt2YXIgZT10aGlzLnNlc3Npb24uc2VsZWN0aW9uLmN1cnNvci5yb3c7dGhpcy4kY3Vyc29yUm93PWU7aWYodGhpcy4kY3Vyc29yQ2VsbCYmdGhpcy4kY3Vyc29yQ2VsbC5yb3c9PWUpcmV0dXJuO3RoaXMuJGN1cnNvckNlbGwmJih0aGlzLiRjdXJzb3JDZWxsLmVsZW1lbnQuY2xhc3NOYW1lPXRoaXMuJGN1cnNvckNlbGwuZWxlbWVudC5jbGFzc05hbWUucmVwbGFjZSgiYWNlX2d1dHRlci1hY3RpdmUtbGluZSAiLCIiKSk7dmFyIHQ9dGhpcy4kbGluZXMuY2VsbHM7dGhpcy4kY3Vyc29yQ2VsbD1udWxsO2Zvcih2YXIgbj0wO248dC5sZW5ndGg7bisrKXt2YXIgcj10W25dO2lmKHIucm93Pj10aGlzLiRjdXJzb3JSb3cpe2lmKHIucm93PnRoaXMuJGN1cnNvclJvdyl7dmFyIGk9dGhpcy5zZXNzaW9uLmdldEZvbGRMaW5lKHRoaXMuJGN1cnNvclJvdyk7aWYoIShuPjAmJmkmJmkuc3RhcnQucm93PT10W24tMV0ucm93KSlicmVhaztyPXRbbi0xXX1yLmVsZW1lbnQuY2xhc3NOYW1lPSJhY2VfZ3V0dGVyLWFjdGl2ZS1saW5lICIrci5lbGVtZW50LmNsYXNzTmFtZSx0aGlzLiRjdXJzb3JDZWxsPXI7YnJlYWt9fX0sdGhpcy5zY3JvbGxMaW5lcz1mdW5jdGlvbihlKXt2YXIgdD10aGlzLmNvbmZpZzt0aGlzLmNvbmZpZz1lLHRoaXMuJHVwZGF0ZUN1cnNvclJvdygpO2lmKHRoaXMuJGxpbmVzLnBhZ2VDaGFuZ2VkKHQsZSkpcmV0dXJuIHRoaXMudXBkYXRlKGUpO3RoaXMuJGxpbmVzLm1vdmVDb250YWluZXIoZSk7dmFyIG49TWF0aC5taW4oZS5sYXN0Um93K2UuZ3V0dGVyT2Zmc2V0LHRoaXMuc2Vzc2lvbi5nZXRMZW5ndGgoKS0xKSxyPXRoaXMub2xkTGFzdFJvdzt0aGlzLm9sZExhc3RSb3c9bjtpZighdHx8cjxlLmZpcnN0Um93KXJldHVybiB0aGlzLnVwZGF0ZShlKTtpZihuPHQuZmlyc3RSb3cpcmV0dXJuIHRoaXMudXBkYXRlKGUpO2lmKHQuZmlyc3RSb3c8ZS5maXJzdFJvdylmb3IodmFyIGk9dGhpcy5zZXNzaW9uLmdldEZvbGRlZFJvd0NvdW50KHQuZmlyc3RSb3csZS5maXJzdFJvdy0xKTtpPjA7aS0tKXRoaXMuJGxpbmVzLnNoaWZ0KCk7aWYocj5uKWZvcih2YXIgaT10aGlzLnNlc3Npb24uZ2V0Rm9sZGVkUm93Q291bnQobisxLHIpO2k+MDtpLS0pdGhpcy4kbGluZXMucG9wKCk7ZS5maXJzdFJvdzx0LmZpcnN0Um93JiZ0aGlzLiRsaW5lcy51bnNoaWZ0KHRoaXMuJHJlbmRlckxpbmVzKGUsZS5maXJzdFJvdyx0LmZpcnN0Um93LTEpKSxuPnImJnRoaXMuJGxpbmVzLnB1c2godGhpcy4kcmVuZGVyTGluZXMoZSxyKzEsbikpLHRoaXMudXBkYXRlTGluZUhpZ2hsaWdodCgpLHRoaXMuX3NpZ25hbCgiYWZ0ZXJSZW5kZXIiKSx0aGlzLiR1cGRhdGVHdXR0ZXJXaWR0aChlKX0sdGhpcy4kcmVuZGVyTGluZXM9ZnVuY3Rpb24oZSx0LG4pe3ZhciByPVtdLGk9dCxzPXRoaXMuc2Vzc2lvbi5nZXROZXh0Rm9sZExpbmUoaSksbz1zP3Muc3RhcnQucm93OkluZmluaXR5O2Zvcig7Oyl7aT5vJiYoaT1zLmVuZC5yb3crMSxzPXRoaXMuc2Vzc2lvbi5nZXROZXh0Rm9sZExpbmUoaSxzKSxvPXM/cy5zdGFydC5yb3c6SW5maW5pdHkpO2lmKGk+bilicmVhazt2YXIgdT10aGlzLiRsaW5lcy5jcmVhdGVDZWxsKGksZSx0aGlzLnNlc3Npb24sZik7dGhpcy4kcmVuZGVyQ2VsbCh1LGUscyxpKSxyLnB1c2godSksaSsrfXJldHVybiByfSx0aGlzLiRyZW5kZXJDZWxsPWZ1bmN0aW9uKGUsdCxuLGkpe3ZhciBzPWUuZWxlbWVudCxvPXRoaXMuc2Vzc2lvbix1PXMuY2hpbGROb2Rlc1swXSxhPXMuY2hpbGROb2Rlc1sxXSxmPW8uJGZpcnN0TGluZU51bWJlcixsPW8uJGJyZWFrcG9pbnRzLGM9by4kZGVjb3JhdGlvbnMsaD1vLmd1dHRlclJlbmRlcmVyfHx0aGlzLiRyZW5kZXJlcixwPXRoaXMuJHNob3dGb2xkV2lkZ2V0cyYmby5mb2xkV2lkZ2V0cyxkPW4/bi5zdGFydC5yb3c6TnVtYmVyLk1BWF9WQUxVRSx2PSJhY2VfZ3V0dGVyLWNlbGwgIjt0aGlzLiRoaWdobGlnaHRHdXR0ZXJMaW5lJiYoaT09dGhpcy4kY3Vyc29yUm93fHxuJiZpPHRoaXMuJGN1cnNvclJvdyYmaT49ZCYmdGhpcy4kY3Vyc29yUm93PD1uLmVuZC5yb3cpJiYodis9ImFjZV9ndXR0ZXItYWN0aXZlLWxpbmUgIix0aGlzLiRjdXJzb3JDZWxsIT1lJiYodGhpcy4kY3Vyc29yQ2VsbCYmKHRoaXMuJGN1cnNvckNlbGwuZWxlbWVudC5jbGFzc05hbWU9dGhpcy4kY3Vyc29yQ2VsbC5lbGVtZW50LmNsYXNzTmFtZS5yZXBsYWNlKCJhY2VfZ3V0dGVyLWFjdGl2ZS1saW5lICIsIiIpKSx0aGlzLiRjdXJzb3JDZWxsPWUpKSxsW2ldJiYodis9bFtpXSksY1tpXSYmKHYrPWNbaV0pLHRoaXMuJGFubm90YXRpb25zW2ldJiYodis9dGhpcy4kYW5ub3RhdGlvbnNbaV0uY2xhc3NOYW1lKSxzLmNsYXNzTmFtZSE9diYmKHMuY2xhc3NOYW1lPXYpO2lmKHApe3ZhciBtPXBbaV07bT09bnVsbCYmKG09cFtpXT1vLmdldEZvbGRXaWRnZXQoaSkpfWlmKG0pe3ZhciB2PSJhY2VfZm9sZC13aWRnZXQgYWNlXyIrbTttPT0ic3RhcnQiJiZpPT1kJiZpPG4uZW5kLnJvdz92Kz0iIGFjZV9jbG9zZWQiOnYrPSIgYWNlX29wZW4iLGEuY2xhc3NOYW1lIT12JiYoYS5jbGFzc05hbWU9dik7dmFyIGc9dC5saW5lSGVpZ2h0KyJweCI7ci5zZXRTdHlsZShhLnN0eWxlLCJoZWlnaHQiLGcpLHIuc2V0U3R5bGUoYS5zdHlsZSwiZGlzcGxheSIsImlubGluZS1ibG9jayIpfWVsc2UgYSYmci5zZXRTdHlsZShhLnN0eWxlLCJkaXNwbGF5Iiwibm9uZSIpO3ZhciB5PShoP2guZ2V0VGV4dChvLGkpOmkrZikudG9TdHJpbmcoKTtyZXR1cm4geSE9PXUuZGF0YSYmKHUuZGF0YT15KSxyLnNldFN0eWxlKGUuZWxlbWVudC5zdHlsZSwiaGVpZ2h0Iix0aGlzLiRsaW5lcy5jb21wdXRlTGluZUhlaWdodChpLHQsbykrInB4Iiksci5zZXRTdHlsZShlLmVsZW1lbnQuc3R5bGUsInRvcCIsdGhpcy4kbGluZXMuY29tcHV0ZUxpbmVUb3AoaSx0LG8pKyJweCIpLGUudGV4dD15LGV9LHRoaXMuJGZpeGVkV2lkdGg9ITEsdGhpcy4kaGlnaGxpZ2h0R3V0dGVyTGluZT0hMCx0aGlzLiRyZW5kZXJlcj0iIix0aGlzLnNldEhpZ2hsaWdodEd1dHRlckxpbmU9ZnVuY3Rpb24oZSl7dGhpcy4kaGlnaGxpZ2h0R3V0dGVyTGluZT1lfSx0aGlzLiRzaG93TGluZU51bWJlcnM9ITAsdGhpcy4kcmVuZGVyZXI9IiIsdGhpcy5zZXRTaG93TGluZU51bWJlcnM9ZnVuY3Rpb24oZSl7dGhpcy4kcmVuZGVyZXI9IWUmJntnZXRXaWR0aDpmdW5jdGlvbigpe3JldHVybiAwfSxnZXRUZXh0OmZ1bmN0aW9uKCl7cmV0dXJuIiJ9fX0sdGhpcy5nZXRTaG93TGluZU51bWJlcnM9ZnVuY3Rpb24oKXtyZXR1cm4gdGhpcy4kc2hvd0xpbmVOdW1iZXJzfSx0aGlzLiRzaG93Rm9sZFdpZGdldHM9ITAsdGhpcy5zZXRTaG93Rm9sZFdpZGdldHM9ZnVuY3Rpb24oZSl7ZT9yLmFkZENzc0NsYXNzKHRoaXMuZWxlbWVudCwiYWNlX2ZvbGRpbmctZW5hYmxlZCIpOnIucmVtb3ZlQ3NzQ2xhc3ModGhpcy5lbGVtZW50LCJhY2VfZm9sZGluZy1lbmFibGVkIiksdGhpcy4kc2hvd0ZvbGRXaWRnZXRzPWUsdGhpcy4kcGFkZGluZz1udWxsfSx0aGlzLmdldFNob3dGb2xkV2lkZ2V0cz1mdW5jdGlvbigpe3JldHVybiB0aGlzLiRzaG93Rm9sZFdpZGdldHN9LHRoaXMuJGNvbXB1dGVQYWRkaW5nPWZ1bmN0aW9uKCl7aWYoIXRoaXMuZWxlbWVudC5maXJzdENoaWxkKXJldHVybntsZWZ0OjAscmlnaHQ6MH07dmFyIGU9ci5jb21wdXRlZFN0eWxlKHRoaXMuZWxlbWVudC5maXJzdENoaWxkKTtyZXR1cm4gdGhpcy4kcGFkZGluZz17fSx0aGlzLiRwYWRkaW5nLmxlZnQ9KHBhcnNlSW50KGUuYm9yZGVyTGVmdFdpZHRoKXx8MCkrKHBhcnNlSW50KGUucGFkZGluZ0xlZnQpfHwwKSsxLHRoaXMuJHBhZGRpbmcucmlnaHQ9KHBhcnNlSW50KGUuYm9yZGVyUmlnaHRXaWR0aCl8fDApKyhwYXJzZUludChlLnBhZGRpbmdSaWdodCl8fDApLHRoaXMuJHBhZGRpbmd9LHRoaXMuZ2V0UmVnaW9uPWZ1bmN0aW9uKGUpe3ZhciB0PXRoaXMuJHBhZGRpbmd8fHRoaXMuJGNvbXB1dGVQYWRkaW5nKCksbj10aGlzLmVsZW1lbnQuZ2V0Qm91bmRpbmdDbGllbnRSZWN0KCk7aWYoZS54PHQubGVmdCtuLmxlZnQpcmV0dXJuIm1hcmtlcnMiO2lmKHRoaXMuJHNob3dGb2xkV2lkZ2V0cyYmZS54Pm4ucmlnaHQtdC5yaWdodClyZXR1cm4iZm9sZFdpZGdldHMifX0pLmNhbGwoYS5wcm90b3R5cGUpLHQuR3V0dGVyPWF9KSxkZWZpbmUoImFjZS9sYXllci9tYXJrZXIiLFsicmVxdWlyZSIsImV4cG9ydHMiLCJtb2R1bGUiLCJhY2UvcmFuZ2UiLCJhY2UvbGliL2RvbSJdLGZ1bmN0aW9uKGUsdCxuKXsidXNlIHN0cmljdCI7dmFyIHI9ZSgiLi4vcmFuZ2UiKS5SYW5nZSxpPWUoIi4uL2xpYi9kb20iKSxzPWZ1bmN0aW9uKGUpe3RoaXMuZWxlbWVudD1pLmNyZWF0ZUVsZW1lbnQoImRpdiIpLHRoaXMuZWxlbWVudC5jbGFzc05hbWU9ImFjZV9sYXllciBhY2VfbWFya2VyLWxheWVyIixlLmFwcGVuZENoaWxkKHRoaXMuZWxlbWVudCl9OyhmdW5jdGlvbigpe2Z1bmN0aW9uIGUoZSx0LG4scil7cmV0dXJuKGU/MTowKXwodD8yOjApfChuPzQ6MCl8KHI/ODowKX10aGlzLiRwYWRkaW5nPTAsdGhpcy5zZXRQYWRkaW5nPWZ1bmN0aW9uKGUpe3RoaXMuJHBhZGRpbmc9ZX0sdGhpcy5zZXRTZXNzaW9uPWZ1bmN0aW9uKGUpe3RoaXMuc2Vzc2lvbj1lfSx0aGlzLnNldE1hcmtlcnM9ZnVuY3Rpb24oZSl7dGhpcy5tYXJrZXJzPWV9LHRoaXMuZWx0PWZ1bmN0aW9uKGUsdCl7dmFyIG49dGhpcy5pIT0tMSYmdGhpcy5lbGVtZW50LmNoaWxkTm9kZXNbdGhpcy5pXTtuP3RoaXMuaSsrOihuPWRvY3VtZW50LmNyZWF0ZUVsZW1lbnQoImRpdiIpLHRoaXMuZWxlbWVudC5hcHBlbmRDaGlsZChuKSx0aGlzLmk9LTEpLG4uc3R5bGUuY3NzVGV4dD10LG4uY2xhc3NOYW1lPWV9LHRoaXMudXBkYXRlPWZ1bmN0aW9uKGUpe2lmKCFlKXJldHVybjt0aGlzLmNvbmZpZz1lLHRoaXMuaT0wO3ZhciB0O2Zvcih2YXIgbiBpbiB0aGlzLm1hcmtlcnMpe3ZhciByPXRoaXMubWFya2Vyc1tuXTtpZighci5yYW5nZSl7ci51cGRhdGUodCx0aGlzLHRoaXMuc2Vzc2lvbixlKTtjb250aW51ZX12YXIgaT1yLnJhbmdlLmNsaXBSb3dzKGUuZmlyc3RSb3csZS5sYXN0Um93KTtpZihpLmlzRW1wdHkoKSljb250aW51ZTtpPWkudG9TY3JlZW5SYW5nZSh0aGlzLnNlc3Npb24pO2lmKHIucmVuZGVyZXIpe3ZhciBzPXRoaXMuJGdldFRvcChpLnN0YXJ0LnJvdyxlKSxvPXRoaXMuJHBhZGRpbmcraS5zdGFydC5jb2x1bW4qZS5jaGFyYWN0ZXJXaWR0aDtyLnJlbmRlcmVyKHQsaSxvLHMsZSl9ZWxzZSByLnR5cGU9PSJmdWxsTGluZSI/dGhpcy5kcmF3RnVsbExpbmVNYXJrZXIodCxpLHIuY2xhenosZSk6ci50eXBlPT0ic2NyZWVuTGluZSI/dGhpcy5kcmF3U2NyZWVuTGluZU1hcmtlcih0LGksci5jbGF6eixlKTppLmlzTXVsdGlMaW5lKCk/ci50eXBlPT0idGV4dCI/dGhpcy5kcmF3VGV4dE1hcmtlcih0LGksci5jbGF6eixlKTp0aGlzLmRyYXdNdWx0aUxpbmVNYXJrZXIodCxpLHIuY2xhenosZSk6dGhpcy5kcmF3U2luZ2xlTGluZU1hcmtlcih0LGksci5jbGF6eisiIGFjZV9zdGFydCIrIiBhY2VfYnIxNSIsZSl9aWYodGhpcy5pIT0tMSl3aGlsZSh0aGlzLmk8dGhpcy5lbGVtZW50LmNoaWxkRWxlbWVudENvdW50KXRoaXMuZWxlbWVudC5yZW1vdmVDaGlsZCh0aGlzLmVsZW1lbnQubGFzdENoaWxkKX0sdGhpcy4kZ2V0VG9wPWZ1bmN0aW9uKGUsdCl7cmV0dXJuKGUtdC5maXJzdFJvd1NjcmVlbikqdC5saW5lSGVpZ2h0fSx0aGlzLmRyYXdUZXh0TWFya2VyPWZ1bmN0aW9uKHQsbixpLHMsbyl7dmFyIHU9dGhpcy5zZXNzaW9uLGE9bi5zdGFydC5yb3csZj1uLmVuZC5yb3csbD1hLGM9MCxoPTAscD11LmdldFNjcmVlbkxhc3RSb3dDb2x1bW4obCksZD1uZXcgcihsLG4uc3RhcnQuY29sdW1uLGwsaCk7Zm9yKDtsPD1mO2wrKylkLnN0YXJ0LnJvdz1kLmVuZC5yb3c9bCxkLnN0YXJ0LmNvbHVtbj1sPT1hP24uc3RhcnQuY29sdW1uOnUuZ2V0Um93V3JhcEluZGVudChsKSxkLmVuZC5jb2x1bW49cCxjPWgsaD1wLHA9bCsxPGY/dS5nZXRTY3JlZW5MYXN0Um93Q29sdW1uKGwrMSk6bD09Zj8wOm4uZW5kLmNvbHVtbix0aGlzLmRyYXdTaW5nbGVMaW5lTWFya2VyKHQsZCxpKyhsPT1hPyIgYWNlX3N0YXJ0IjoiIikrIiBhY2VfYnIiK2UobD09YXx8bD09YSsxJiZuLnN0YXJ0LmNvbHVtbixjPGgsaD5wLGw9PWYpLHMsbD09Zj8wOjEsbyl9LHRoaXMuZHJhd011bHRpTGluZU1hcmtlcj1mdW5jdGlvbihlLHQsbixyLGkpe3ZhciBzPXRoaXMuJHBhZGRpbmcsbz1yLmxpbmVIZWlnaHQsdT10aGlzLiRnZXRUb3AodC5zdGFydC5yb3csciksYT1zK3Quc3RhcnQuY29sdW1uKnIuY2hhcmFjdGVyV2lkdGg7aT1pfHwiIjtpZih0aGlzLnNlc3Npb24uJGJpZGlIYW5kbGVyLmlzQmlkaVJvdyh0LnN0YXJ0LnJvdykpe3ZhciBmPXQuY2xvbmUoKTtmLmVuZC5yb3c9Zi5zdGFydC5yb3csZi5lbmQuY29sdW1uPXRoaXMuc2Vzc2lvbi5nZXRMaW5lKGYuc3RhcnQucm93KS5sZW5ndGgsdGhpcy5kcmF3QmlkaVNpbmdsZUxpbmVNYXJrZXIoZSxmLG4rIiBhY2VfYnIxIGFjZV9zdGFydCIscixudWxsLGkpfWVsc2UgdGhpcy5lbHQobisiIGFjZV9icjEgYWNlX3N0YXJ0IiwiaGVpZ2h0OiIrbysicHg7IisicmlnaHQ6MDsiKyJ0b3A6Iit1KyJweDtsZWZ0OiIrYSsicHg7IisoaXx8IiIpKTtpZih0aGlzLnNlc3Npb24uJGJpZGlIYW5kbGVyLmlzQmlkaVJvdyh0LmVuZC5yb3cpKXt2YXIgZj10LmNsb25lKCk7Zi5zdGFydC5yb3c9Zi5lbmQucm93LGYuc3RhcnQuY29sdW1uPTAsdGhpcy5kcmF3QmlkaVNpbmdsZUxpbmVNYXJrZXIoZSxmLG4rIiBhY2VfYnIxMiIscixudWxsLGkpfWVsc2V7dT10aGlzLiRnZXRUb3AodC5lbmQucm93LHIpO3ZhciBsPXQuZW5kLmNvbHVtbipyLmNoYXJhY3RlcldpZHRoO3RoaXMuZWx0KG4rIiBhY2VfYnIxMiIsImhlaWdodDoiK28rInB4OyIrIndpZHRoOiIrbCsicHg7IisidG9wOiIrdSsicHg7IisibGVmdDoiK3MrInB4OyIrKGl8fCIiKSl9bz0odC5lbmQucm93LXQuc3RhcnQucm93LTEpKnIubGluZUhlaWdodDtpZihvPD0wKXJldHVybjt1PXRoaXMuJGdldFRvcCh0LnN0YXJ0LnJvdysxLHIpO3ZhciBjPSh0LnN0YXJ0LmNvbHVtbj8xOjApfCh0LmVuZC5jb2x1bW4/MDo4KTt0aGlzLmVsdChuKyhjPyIgYWNlX2JyIitjOiIiKSwiaGVpZ2h0OiIrbysicHg7IisicmlnaHQ6MDsiKyJ0b3A6Iit1KyJweDsiKyJsZWZ0OiIrcysicHg7IisoaXx8IiIpKX0sdGhpcy5kcmF3U2luZ2xlTGluZU1hcmtlcj1mdW5jdGlvbihlLHQsbixyLGkscyl7aWYodGhpcy5zZXNzaW9uLiRiaWRpSGFuZGxlci5pc0JpZGlSb3codC5zdGFydC5yb3cpKXJldHVybiB0aGlzLmRyYXdCaWRpU2luZ2xlTGluZU1hcmtlcihlLHQsbixyLGkscyk7dmFyIG89ci5saW5lSGVpZ2h0LHU9KHQuZW5kLmNvbHVtbisoaXx8MCktdC5zdGFydC5jb2x1bW4pKnIuY2hhcmFjdGVyV2lkdGgsYT10aGlzLiRnZXRUb3AodC5zdGFydC5yb3csciksZj10aGlzLiRwYWRkaW5nK3Quc3RhcnQuY29sdW1uKnIuY2hhcmFjdGVyV2lkdGg7dGhpcy5lbHQobiwiaGVpZ2h0OiIrbysicHg7Iisid2lkdGg6Iit1KyJweDsiKyJ0b3A6IithKyJweDsiKyJsZWZ0OiIrZisicHg7Iisoc3x8IiIpKX0sdGhpcy5kcmF3QmlkaVNpbmdsZUxpbmVNYXJrZXI9ZnVuY3Rpb24oZSx0LG4scixpLHMpe3ZhciBvPXIubGluZUhlaWdodCx1PXRoaXMuJGdldFRvcCh0LnN0YXJ0LnJvdyxyKSxhPXRoaXMuJHBhZGRpbmcsZj10aGlzLnNlc3Npb24uJGJpZGlIYW5kbGVyLmdldFNlbGVjdGlvbnModC5zdGFydC5jb2x1bW4sdC5lbmQuY29sdW1uKTtmLmZvckVhY2goZnVuY3Rpb24oZSl7dGhpcy5lbHQobiwiaGVpZ2h0OiIrbysicHg7Iisid2lkdGg6IitlLndpZHRoKyhpfHwwKSsicHg7IisidG9wOiIrdSsicHg7IisibGVmdDoiKyhhK2UubGVmdCkrInB4OyIrKHN8fCIiKSl9LHRoaXMpfSx0aGlzLmRyYXdGdWxsTGluZU1hcmtlcj1mdW5jdGlvbihlLHQsbixyLGkpe3ZhciBzPXRoaXMuJGdldFRvcCh0LnN0YXJ0LnJvdyxyKSxvPXIubGluZUhlaWdodDt0LnN0YXJ0LnJvdyE9dC5lbmQucm93JiYobys9dGhpcy4kZ2V0VG9wKHQuZW5kLnJvdyxyKS1zKSx0aGlzLmVsdChuLCJoZWlnaHQ6IitvKyJweDsiKyJ0b3A6IitzKyJweDsiKyJsZWZ0OjA7cmlnaHQ6MDsiKyhpfHwiIikpfSx0aGlzLmRyYXdTY3JlZW5MaW5lTWFya2VyPWZ1bmN0aW9uKGUsdCxuLHIsaSl7dmFyIHM9dGhpcy4kZ2V0VG9wKHQuc3RhcnQucm93LHIpLG89ci5saW5lSGVpZ2h0O3RoaXMuZWx0KG4sImhlaWdodDoiK28rInB4OyIrInRvcDoiK3MrInB4OyIrImxlZnQ6MDtyaWdodDowOyIrKGl8fCIiKSl9fSkuY2FsbChzLnByb3RvdHlwZSksdC5NYXJrZXI9c30pLGRlZmluZSgiYWNlL2xheWVyL3RleHQiLFsicmVxdWlyZSIsImV4cG9ydHMiLCJtb2R1bGUiLCJhY2UvbGliL29vcCIsImFjZS9saWIvZG9tIiwiYWNlL2xpYi9sYW5nIiwiYWNlL2xheWVyL2xpbmVzIiwiYWNlL2xpYi9ldmVudF9lbWl0dGVyIl0sZnVuY3Rpb24oZSx0LG4peyJ1c2Ugc3RyaWN0Ijt2YXIgcj1lKCIuLi9saWIvb29wIiksaT1lKCIuLi9saWIvZG9tIikscz1lKCIuLi9saWIvbGFuZyIpLG89ZSgiLi9saW5lcyIpLkxpbmVzLHU9ZSgiLi4vbGliL2V2ZW50X2VtaXR0ZXIiKS5FdmVudEVtaXR0ZXIsYT1mdW5jdGlvbihlKXt0aGlzLmRvbT1pLHRoaXMuZWxlbWVudD10aGlzLmRvbS5jcmVhdGVFbGVtZW50KCJkaXYiKSx0aGlzLmVsZW1lbnQuY2xhc3NOYW1lPSJhY2VfbGF5ZXIgYWNlX3RleHQtbGF5ZXIiLGUuYXBwZW5kQ2hpbGQodGhpcy5lbGVtZW50KSx0aGlzLiR1cGRhdGVFb2xDaGFyPXRoaXMuJHVwZGF0ZUVvbENoYXIuYmluZCh0aGlzKSx0aGlzLiRsaW5lcz1uZXcgbyh0aGlzLmVsZW1lbnQpfTsoZnVuY3Rpb24oKXtyLmltcGxlbWVudCh0aGlzLHUpLHRoaXMuRU9GX0NIQVI9Ilx1MDBiNiIsdGhpcy5FT0xfQ0hBUl9MRj0iXHUwMGFjIix0aGlzLkVPTF9DSEFSX0NSTEY9Ilx1MDBhNCIsdGhpcy5FT0xfQ0hBUj10aGlzLkVPTF9DSEFSX0xGLHRoaXMuVEFCX0NIQVI9Ilx1MjAxNCIsdGhpcy5TUEFDRV9DSEFSPSJcdTAwYjciLHRoaXMuJHBhZGRpbmc9MCx0aGlzLk1BWF9MSU5FX0xFTkdUSD0xZTQsdGhpcy5NQVhfQ0hVTktfTEVOR1RIPTI1MCx0aGlzLiR1cGRhdGVFb2xDaGFyPWZ1bmN0aW9uKCl7dmFyIGU9dGhpcy5zZXNzaW9uLmRvYyx0PWUuZ2V0TmV3TGluZUNoYXJhY3RlcigpPT0iXG4iJiZlLmdldE5ld0xpbmVNb2RlKCkhPSJ3aW5kb3dzIixuPXQ/dGhpcy5FT0xfQ0hBUl9MRjp0aGlzLkVPTF9DSEFSX0NSTEY7aWYodGhpcy5FT0xfQ0hBUiE9bilyZXR1cm4gdGhpcy5FT0xfQ0hBUj1uLCEwfSx0aGlzLnNldFBhZGRpbmc9ZnVuY3Rpb24oZSl7dGhpcy4kcGFkZGluZz1lLHRoaXMuZWxlbWVudC5zdHlsZS5tYXJnaW49IjAgIitlKyJweCJ9LHRoaXMuZ2V0TGluZUhlaWdodD1mdW5jdGlvbigpe3JldHVybiB0aGlzLiRmb250TWV0cmljcy4kY2hhcmFjdGVyU2l6ZS5oZWlnaHR8fDB9LHRoaXMuZ2V0Q2hhcmFjdGVyV2lkdGg9ZnVuY3Rpb24oKXtyZXR1cm4gdGhpcy4kZm9udE1ldHJpY3MuJGNoYXJhY3RlclNpemUud2lkdGh8fDB9LHRoaXMuJHNldEZvbnRNZXRyaWNzPWZ1bmN0aW9uKGUpe3RoaXMuJGZvbnRNZXRyaWNzPWUsdGhpcy4kZm9udE1ldHJpY3Mub24oImNoYW5nZUNoYXJhY3RlclNpemUiLGZ1bmN0aW9uKGUpe3RoaXMuX3NpZ25hbCgiY2hhbmdlQ2hhcmFjdGVyU2l6ZSIsZSl9LmJpbmQodGhpcykpLHRoaXMuJHBvbGxTaXplQ2hhbmdlcygpfSx0aGlzLmNoZWNrRm9yU2l6ZUNoYW5nZXM9ZnVuY3Rpb24oKXt0aGlzLiRmb250TWV0cmljcy5jaGVja0ZvclNpemVDaGFuZ2VzKCl9LHRoaXMuJHBvbGxTaXplQ2hhbmdlcz1mdW5jdGlvbigpe3JldHVybiB0aGlzLiRwb2xsU2l6ZUNoYW5nZXNUaW1lcj10aGlzLiRmb250TWV0cmljcy4kcG9sbFNpemVDaGFuZ2VzKCl9LHRoaXMuc2V0U2Vzc2lvbj1mdW5jdGlvbihlKXt0aGlzLnNlc3Npb249ZSxlJiZ0aGlzLiRjb21wdXRlVGFiU3RyaW5nKCl9LHRoaXMuc2hvd0ludmlzaWJsZXM9ITEsdGhpcy5zaG93U3BhY2VzPSExLHRoaXMuc2hvd1RhYnM9ITEsdGhpcy5zaG93RU9MPSExLHRoaXMuc2V0U2hvd0ludmlzaWJsZXM9ZnVuY3Rpb24oZSl7cmV0dXJuIHRoaXMuc2hvd0ludmlzaWJsZXM9PWU/ITE6KHRoaXMuc2hvd0ludmlzaWJsZXM9ZSx0eXBlb2YgZT09InN0cmluZyI/KHRoaXMuc2hvd1NwYWNlcz0vdGFiL2kudGVzdChlKSx0aGlzLnNob3dUYWJzPS9zcGFjZS9pLnRlc3QoZSksdGhpcy5zaG93RU9MPS9lb2wvaS50ZXN0KGUpKTp0aGlzLnNob3dTcGFjZXM9dGhpcy5zaG93VGFicz10aGlzLnNob3dFT0w9ZSx0aGlzLiRjb21wdXRlVGFiU3RyaW5nKCksITApfSx0aGlzLmRpc3BsYXlJbmRlbnRHdWlkZXM9ITAsdGhpcy5zZXREaXNwbGF5SW5kZW50R3VpZGVzPWZ1bmN0aW9uKGUpe3JldHVybiB0aGlzLmRpc3BsYXlJbmRlbnRHdWlkZXM9PWU/ITE6KHRoaXMuZGlzcGxheUluZGVudEd1aWRlcz1lLHRoaXMuJGNvbXB1dGVUYWJTdHJpbmcoKSwhMCl9LHRoaXMuJGhpZ2hsaWdodEluZGVudEd1aWRlcz0hMCx0aGlzLnNldEhpZ2hsaWdodEluZGVudEd1aWRlcz1mdW5jdGlvbihlKXtyZXR1cm4gdGhpcy4kaGlnaGxpZ2h0SW5kZW50R3VpZGVzPT09ZT8hMToodGhpcy4kaGlnaGxpZ2h0SW5kZW50R3VpZGVzPWUsZSl9LHRoaXMuJHRhYlN0cmluZ3M9W10sdGhpcy5vbkNoYW5nZVRhYlNpemU9dGhpcy4kY29tcHV0ZVRhYlN0cmluZz1mdW5jdGlvbigpe3ZhciBlPXRoaXMuc2Vzc2lvbi5nZXRUYWJTaXplKCk7dGhpcy50YWJTaXplPWU7dmFyIHQ9dGhpcy4kdGFiU3RyaW5ncz1bMF07Zm9yKHZhciBuPTE7bjxlKzE7bisrKWlmKHRoaXMuc2hvd1RhYnMpe3ZhciByPXRoaXMuZG9tLmNyZWF0ZUVsZW1lbnQoInNwYW4iKTtyLmNsYXNzTmFtZT0iYWNlX2ludmlzaWJsZSBhY2VfaW52aXNpYmxlX3RhYiIsci50ZXh0Q29udGVudD1zLnN0cmluZ1JlcGVhdCh0aGlzLlRBQl9DSEFSLG4pLHQucHVzaChyKX1lbHNlIHQucHVzaCh0aGlzLmRvbS5jcmVhdGVUZXh0Tm9kZShzLnN0cmluZ1JlcGVhdCgiICIsbiksdGhpcy5lbGVtZW50KSk7aWYodGhpcy5kaXNwbGF5SW5kZW50R3VpZGVzKXt0aGlzLiRpbmRlbnRHdWlkZVJlPS9cc1xTfCBcdHxcdCB8XHMkLzt2YXIgaT0iYWNlX2luZGVudC1ndWlkZSIsbz10aGlzLnNob3dTcGFjZXM/IiBhY2VfaW52aXNpYmxlIGFjZV9pbnZpc2libGVfc3BhY2UiOiIiLHU9dGhpcy5zaG93U3BhY2VzP3Muc3RyaW5nUmVwZWF0KHRoaXMuU1BBQ0VfQ0hBUix0aGlzLnRhYlNpemUpOnMuc3RyaW5nUmVwZWF0KCIgIix0aGlzLnRhYlNpemUpLGE9dGhpcy5zaG93VGFicz8iIGFjZV9pbnZpc2libGUgYWNlX2ludmlzaWJsZV90YWIiOiIiLGY9dGhpcy5zaG93VGFicz9zLnN0cmluZ1JlcGVhdCh0aGlzLlRBQl9DSEFSLHRoaXMudGFiU2l6ZSk6dSxyPXRoaXMuZG9tLmNyZWF0ZUVsZW1lbnQoInNwYW4iKTtyLmNsYXNzTmFtZT1pK28sci50ZXh0Q29udGVudD11LHRoaXMuJHRhYlN0cmluZ3NbIiAiXT1yO3ZhciByPXRoaXMuZG9tLmNyZWF0ZUVsZW1lbnQoInNwYW4iKTtyLmNsYXNzTmFtZT1pK2Esci50ZXh0Q29udGVudD1mLHRoaXMuJHRhYlN0cmluZ3NbIgkiXT1yfX0sdGhpcy51cGRhdGVMaW5lcz1mdW5jdGlvbihlLHQsbil7aWYodGhpcy5jb25maWcubGFzdFJvdyE9ZS5sYXN0Um93fHx0aGlzLmNvbmZpZy5maXJzdFJvdyE9ZS5maXJzdFJvdylyZXR1cm4gdGhpcy51cGRhdGUoZSk7dGhpcy5jb25maWc9ZTt2YXIgcj1NYXRoLm1heCh0LGUuZmlyc3RSb3cpLGk9TWF0aC5taW4obixlLmxhc3RSb3cpLHM9dGhpcy5lbGVtZW50LmNoaWxkTm9kZXMsbz0wO2Zvcih2YXIgdT1lLmZpcnN0Um93O3U8cjt1Kyspe3ZhciBhPXRoaXMuc2Vzc2lvbi5nZXRGb2xkTGluZSh1KTtpZihhKXtpZihhLmNvbnRhaW5zUm93KHIpKXtyPWEuc3RhcnQucm93O2JyZWFrfXU9YS5lbmQucm93fW8rK312YXIgZj0hMSx1PXIsYT10aGlzLnNlc3Npb24uZ2V0TmV4dEZvbGRMaW5lKHUpLGw9YT9hLnN0YXJ0LnJvdzpJbmZpbml0eTtmb3IoOzspe3U+bCYmKHU9YS5lbmQucm93KzEsYT10aGlzLnNlc3Npb24uZ2V0TmV4dEZvbGRMaW5lKHUsYSksbD1hP2Euc3RhcnQucm93OkluZmluaXR5KTtpZih1PmkpYnJlYWs7dmFyIGM9c1tvKytdO2lmKGMpe3RoaXMuZG9tLnJlbW92ZUNoaWxkcmVuKGMpLHRoaXMuJHJlbmRlckxpbmUoYyx1LHU9PWw/YTohMSksZiYmKGMuc3R5bGUudG9wPXRoaXMuJGxpbmVzLmNvbXB1dGVMaW5lVG9wKHUsZSx0aGlzLnNlc3Npb24pKyJweCIpO3ZhciBoPWUubGluZUhlaWdodCp0aGlzLnNlc3Npb24uZ2V0Um93TGVuZ3RoKHUpKyJweCI7Yy5zdHlsZS5oZWlnaHQhPWgmJihmPSEwLGMuc3R5bGUuaGVpZ2h0PWgpfXUrK31pZihmKXdoaWxlKG88dGhpcy4kbGluZXMuY2VsbHMubGVuZ3RoKXt2YXIgcD10aGlzLiRsaW5lcy5jZWxsc1tvKytdO3AuZWxlbWVudC5zdHlsZS50b3A9dGhpcy4kbGluZXMuY29tcHV0ZUxpbmVUb3AocC5yb3csZSx0aGlzLnNlc3Npb24pKyJweCJ9fSx0aGlzLnNjcm9sbExpbmVzPWZ1bmN0aW9uKGUpe3ZhciB0PXRoaXMuY29uZmlnO3RoaXMuY29uZmlnPWU7aWYodGhpcy4kbGluZXMucGFnZUNoYW5nZWQodCxlKSlyZXR1cm4gdGhpcy51cGRhdGUoZSk7dGhpcy4kbGluZXMubW92ZUNvbnRhaW5lcihlKTt2YXIgbj1lLmxhc3RSb3cscj10P3QubGFzdFJvdzotMTtpZighdHx8cjxlLmZpcnN0Um93KXJldHVybiB0aGlzLnVwZGF0ZShlKTtpZihuPHQuZmlyc3RSb3cpcmV0dXJuIHRoaXMudXBkYXRlKGUpO2lmKCF0fHx0Lmxhc3RSb3c8ZS5maXJzdFJvdylyZXR1cm4gdGhpcy51cGRhdGUoZSk7aWYoZS5sYXN0Um93PHQuZmlyc3RSb3cpcmV0dXJuIHRoaXMudXBkYXRlKGUpO2lmKHQuZmlyc3RSb3c8ZS5maXJzdFJvdylmb3IodmFyIGk9dGhpcy5zZXNzaW9uLmdldEZvbGRlZFJvd0NvdW50KHQuZmlyc3RSb3csZS5maXJzdFJvdy0xKTtpPjA7aS0tKXRoaXMuJGxpbmVzLnNoaWZ0KCk7aWYodC5sYXN0Um93PmUubGFzdFJvdylmb3IodmFyIGk9dGhpcy5zZXNzaW9uLmdldEZvbGRlZFJvd0NvdW50KGUubGFzdFJvdysxLHQubGFzdFJvdyk7aT4wO2ktLSl0aGlzLiRsaW5lcy5wb3AoKTtlLmZpcnN0Um93PHQuZmlyc3RSb3cmJnRoaXMuJGxpbmVzLnVuc2hpZnQodGhpcy4kcmVuZGVyTGluZXNGcmFnbWVudChlLGUuZmlyc3RSb3csdC5maXJzdFJvdy0xKSksZS5sYXN0Um93PnQubGFzdFJvdyYmdGhpcy4kbGluZXMucHVzaCh0aGlzLiRyZW5kZXJMaW5lc0ZyYWdtZW50KGUsdC5sYXN0Um93KzEsZS5sYXN0Um93KSksdGhpcy4kaGlnaGxpZ2h0SW5kZW50R3VpZGUoKX0sdGhpcy4kcmVuZGVyTGluZXNGcmFnbWVudD1mdW5jdGlvbihlLHQsbil7dmFyIHI9W10scz10LG89dGhpcy5zZXNzaW9uLmdldE5leHRGb2xkTGluZShzKSx1PW8/by5zdGFydC5yb3c6SW5maW5pdHk7Zm9yKDs7KXtzPnUmJihzPW8uZW5kLnJvdysxLG89dGhpcy5zZXNzaW9uLmdldE5leHRGb2xkTGluZShzLG8pLHU9bz9vLnN0YXJ0LnJvdzpJbmZpbml0eSk7aWYocz5uKWJyZWFrO3ZhciBhPXRoaXMuJGxpbmVzLmNyZWF0ZUNlbGwocyxlLHRoaXMuc2Vzc2lvbiksZj1hLmVsZW1lbnQ7dGhpcy5kb20ucmVtb3ZlQ2hpbGRyZW4oZiksaS5zZXRTdHlsZShmLnN0eWxlLCJoZWlnaHQiLHRoaXMuJGxpbmVzLmNvbXB1dGVMaW5lSGVpZ2h0KHMsZSx0aGlzLnNlc3Npb24pKyJweCIpLGkuc2V0U3R5bGUoZi5zdHlsZSwidG9wIix0aGlzLiRsaW5lcy5jb21wdXRlTGluZVRvcChzLGUsdGhpcy5zZXNzaW9uKSsicHgiKSx0aGlzLiRyZW5kZXJMaW5lKGYscyxzPT11P286ITEpLHRoaXMuJHVzZUxpbmVHcm91cHMoKT9mLmNsYXNzTmFtZT0iYWNlX2xpbmVfZ3JvdXAiOmYuY2xhc3NOYW1lPSJhY2VfbGluZSIsci5wdXNoKGEpLHMrK31yZXR1cm4gcn0sdGhpcy51cGRhdGU9ZnVuY3Rpb24oZSl7dGhpcy4kbGluZXMubW92ZUNvbnRhaW5lcihlKSx0aGlzLmNvbmZpZz1lO3ZhciB0PWUuZmlyc3RSb3csbj1lLmxhc3RSb3cscj10aGlzLiRsaW5lczt3aGlsZShyLmdldExlbmd0aCgpKXIucG9wKCk7ci5wdXNoKHRoaXMuJHJlbmRlckxpbmVzRnJhZ21lbnQoZSx0LG4pKX0sdGhpcy4kdGV4dFRva2VuPXt0ZXh0OiEwLHJwYXJlbjohMCxscGFyZW46ITB9LHRoaXMuJHJlbmRlclRva2VuSW5DaHVua3M9ZnVuY3Rpb24oZSx0LG4scil7dmFyIGk7Zm9yKHZhciBzPTA7czxyLmxlbmd0aDtzKz10aGlzLk1BWF9DSFVOS19MRU5HVEgpe3ZhciBvPXIuc3Vic3RyaW5nKHMscyt0aGlzLk1BWF9DSFVOS19MRU5HVEgpLHU9e3R5cGU6bi50eXBlLHZhbHVlOm99O2k9dGhpcy4kcmVuZGVyVG9rZW4oZSx0K3MsdSxvKX1yZXR1cm4gaX0sdGhpcy4kcmVuZGVyVG9rZW49ZnVuY3Rpb24oZSx0LG4scil7dmFyIGk9dGhpcyxvPS8oXHQpfCggKyl8KFtceDAwLVx4MWZceDgwLVx4YTBceGFkXHUxNjgwXHUxODBFXHUyMDAwLVx1MjAwZlx1MjAyOFx1MjAyOVx1MjAyRlx1MjA1Rlx1RkVGRlx1RkZGOS1cdUZGRkNcdTIwNjZcdTIwNjdcdTIwNjhcdTIwMkFcdTIwMkJcdTIwMkRcdTIwMkVcdTIwMkNcdTIwNjldKyl8KFx1MzAwMCl8KFtcdTExMDAtXHUxMTVGXHUxMUEzLVx1MTFBN1x1MTFGQS1cdTExRkZcdTIzMjktXHUyMzJBXHUyRTgwLVx1MkU5OVx1MkU5Qi1cdTJFRjNcdTJGMDAtXHUyRkQ1XHUyRkYwLVx1MkZGQlx1MzAwMS1cdTMwM0VcdTMwNDEtXHUzMDk2XHUzMDk5LVx1MzBGRlx1MzEwNS1cdTMxMkRcdTMxMzEtXHUzMThFXHUzMTkwLVx1MzFCQVx1MzFDMC1cdTMxRTNcdTMxRjAtXHUzMjFFXHUzMjIwLVx1MzI0N1x1MzI1MC1cdTMyRkVcdTMzMDAtXHU0REJGXHU0RTAwLVx1QTQ4Q1x1QTQ5MC1cdUE0QzZcdUE5NjAtXHVBOTdDXHVBQzAwLVx1RDdBM1x1RDdCMC1cdUQ3QzZcdUQ3Q0ItXHVEN0ZCXHVGOTAwLVx1RkFGRlx1RkUxMC1cdUZFMTlcdUZFMzAtXHVGRTUyXHVGRTU0LVx1RkU2Nlx1RkU2OC1cdUZFNkJcdUZGMDEtXHVGRjYwXHVGRkUwLVx1RkZFNl18W1x1RDgwMC1cdURCRkZdW1x1REMwMC1cdURGRkZdKS9nLHU9dGhpcy5kb20uY3JlYXRlRnJhZ21lbnQodGhpcy5lbGVtZW50KSxhLGY9MDt3aGlsZShhPW8uZXhlYyhyKSl7dmFyIGw9YVsxXSxjPWFbMl0saD1hWzNdLHA9YVs0XSxkPWFbNV07aWYoIWkuc2hvd1NwYWNlcyYmYyljb250aW51ZTt2YXIgdj1mIT1hLmluZGV4P3Iuc2xpY2UoZixhLmluZGV4KToiIjtmPWEuaW5kZXgrYVswXS5sZW5ndGgsdiYmdS5hcHBlbmRDaGlsZCh0aGlzLmRvbS5jcmVhdGVUZXh0Tm9kZSh2LHRoaXMuZWxlbWVudCkpO2lmKGwpe3ZhciBtPWkuc2Vzc2lvbi5nZXRTY3JlZW5UYWJTaXplKHQrYS5pbmRleCk7dS5hcHBlbmRDaGlsZChpLiR0YWJTdHJpbmdzW21dLmNsb25lTm9kZSghMCkpLHQrPW0tMX1lbHNlIGlmKGMpaWYoaS5zaG93U3BhY2VzKXt2YXIgZz10aGlzLmRvbS5jcmVhdGVFbGVtZW50KCJzcGFuIik7Zy5jbGFzc05hbWU9ImFjZV9pbnZpc2libGUgYWNlX2ludmlzaWJsZV9zcGFjZSIsZy50ZXh0Q29udGVudD1zLnN0cmluZ1JlcGVhdChpLlNQQUNFX0NIQVIsYy5sZW5ndGgpLHUuYXBwZW5kQ2hpbGQoZyl9ZWxzZSB1LmFwcGVuZENoaWxkKHRoaXMuY29tLmNyZWF0ZVRleHROb2RlKGMsdGhpcy5lbGVtZW50KSk7ZWxzZSBpZihoKXt2YXIgZz10aGlzLmRvbS5jcmVhdGVFbGVtZW50KCJzcGFuIik7Zy5jbGFzc05hbWU9ImFjZV9pbnZpc2libGUgYWNlX2ludmlzaWJsZV9zcGFjZSBhY2VfaW52YWxpZCIsZy50ZXh0Q29udGVudD1zLnN0cmluZ1JlcGVhdChpLlNQQUNFX0NIQVIsaC5sZW5ndGgpLHUuYXBwZW5kQ2hpbGQoZyl9ZWxzZSBpZihwKXt0Kz0xO3ZhciBnPXRoaXMuZG9tLmNyZWF0ZUVsZW1lbnQoInNwYW4iKTtnLnN0eWxlLndpZHRoPWkuY29uZmlnLmNoYXJhY3RlcldpZHRoKjIrInB4IixnLmNsYXNzTmFtZT1pLnNob3dTcGFjZXM/ImFjZV9jamsgYWNlX2ludmlzaWJsZSBhY2VfaW52aXNpYmxlX3NwYWNlIjoiYWNlX2NqayIsZy50ZXh0Q29udGVudD1pLnNob3dTcGFjZXM/aS5TUEFDRV9DSEFSOnAsdS5hcHBlbmRDaGlsZChnKX1lbHNlIGlmKGQpe3QrPTE7dmFyIGc9dGhpcy5kb20uY3JlYXRlRWxlbWVudCgic3BhbiIpO2cuc3R5bGUud2lkdGg9aS5jb25maWcuY2hhcmFjdGVyV2lkdGgqMisicHgiLGcuY2xhc3NOYW1lPSJhY2VfY2prIixnLnRleHRDb250ZW50PWQsdS5hcHBlbmRDaGlsZChnKX19dS5hcHBlbmRDaGlsZCh0aGlzLmRvbS5jcmVhdGVUZXh0Tm9kZShmP3Iuc2xpY2UoZik6cix0aGlzLmVsZW1lbnQpKTt2YXIgZz10aGlzLmRvbS5jcmVhdGVFbGVtZW50KCJzcGFuIik7aWYoIXRoaXMuJHRleHRUb2tlbltuLnR5cGVdKXt2YXIgeT0iYWNlXyIrbi50eXBlLnJlcGxhY2UoL1wuL2csIiBhY2VfIik7bi50eXBlPT0iZm9sZCImJihnLnN0eWxlLndpZHRoPW4udmFsdWUubGVuZ3RoKnRoaXMuY29uZmlnLmNoYXJhY3RlcldpZHRoKyJweCIpLGcuY2xhc3NOYW1lPXl9cmV0dXJuIGcuYXBwZW5kQ2hpbGQodSksZS5hcHBlbmRDaGlsZChnKSx0K3IubGVuZ3RofSx0aGlzLnJlbmRlckluZGVudEd1aWRlPWZ1bmN0aW9uKGUsdCxuKXt2YXIgcj10LnNlYXJjaCh0aGlzLiRpbmRlbnRHdWlkZVJlKTtpZihyPD0wfHxyPj1uKXJldHVybiB0O2lmKHRbMF09PSIgIil7ci09ciV0aGlzLnRhYlNpemU7dmFyIGk9ci90aGlzLnRhYlNpemU7Zm9yKHZhciBzPTA7czxpO3MrKyllLmFwcGVuZENoaWxkKHRoaXMuJHRhYlN0cmluZ3NbIiAiXS5jbG9uZU5vZGUoITApKTtyZXR1cm4gdGhpcy4kaGlnaGxpZ2h0SW5kZW50R3VpZGUoKSx0LnN1YnN0cihyKX1pZih0WzBdPT0iCSIpe2Zvcih2YXIgcz0wO3M8cjtzKyspZS5hcHBlbmRDaGlsZCh0aGlzLiR0YWJTdHJpbmdzWyIJIl0uY2xvbmVOb2RlKCEwKSk7cmV0dXJuIHRoaXMuJGhpZ2hsaWdodEluZGVudEd1aWRlKCksdC5zdWJzdHIocil9cmV0dXJuIHRoaXMuJGhpZ2hsaWdodEluZGVudEd1aWRlKCksdH0sdGhpcy4kaGlnaGxpZ2h0SW5kZW50R3VpZGU9ZnVuY3Rpb24oKXtpZighdGhpcy4kaGlnaGxpZ2h0SW5kZW50R3VpZGVzfHwhdGhpcy5kaXNwbGF5SW5kZW50R3VpZGVzKXJldHVybjt0aGlzLiRoaWdobGlnaHRJbmRlbnRHdWlkZU1hcmtlcj17aW5kZW50TGV2ZWw6dW5kZWZpbmVkLHN0YXJ0OnVuZGVmaW5lZCxlbmQ6dW5kZWZpbmVkLGRpcjp1bmRlZmluZWR9O3ZhciBlPXRoaXMuc2Vzc2lvbi5kb2MuJGxpbmVzO2lmKCFlKXJldHVybjt2YXIgdD10aGlzLnNlc3Npb24uc2VsZWN0aW9uLmdldEN1cnNvcigpLG49L15ccyovLmV4ZWModGhpcy5zZXNzaW9uLmRvYy5nZXRMaW5lKHQucm93KSlbMF0ubGVuZ3RoLHI9TWF0aC5mbG9vcihuL3RoaXMudGFiU2l6ZSk7dGhpcy4kaGlnaGxpZ2h0SW5kZW50R3VpZGVNYXJrZXI9e2luZGVudExldmVsOnIsc3RhcnQ6dC5yb3d9O3ZhciBpPXRoaXMuc2Vzc2lvbi4kYnJhY2tldEhpZ2hsaWdodDtpZihpKXt2YXIgcz10aGlzLnNlc3Npb24uJGJyYWNrZXRIaWdobGlnaHQucmFuZ2VzO2Zvcih2YXIgbz0wO288cy5sZW5ndGg7bysrKWlmKHQucm93IT09c1tvXS5zdGFydC5yb3cpe3RoaXMuJGhpZ2hsaWdodEluZGVudEd1aWRlTWFya2VyLmVuZD1zW29dLnN0YXJ0LnJvdyx0LnJvdz5zW29dLnN0YXJ0LnJvdz90aGlzLiRoaWdobGlnaHRJbmRlbnRHdWlkZU1hcmtlci5kaXI9LTE6dGhpcy4kaGlnaGxpZ2h0SW5kZW50R3VpZGVNYXJrZXIuZGlyPTE7YnJlYWt9fWlmKCF0aGlzLiRoaWdobGlnaHRJbmRlbnRHdWlkZU1hcmtlci5lbmQmJmVbdC5yb3ddIT09IiImJnQuY29sdW1uPT09ZVt0LnJvd10ubGVuZ3RoKXt0aGlzLiRoaWdobGlnaHRJbmRlbnRHdWlkZU1hcmtlci5kaXI9MTtmb3IodmFyIG89dC5yb3crMTtvPGUubGVuZ3RoO28rKyl7dmFyIHU9ZVtvXSxhPS9eXHMqLy5leGVjKHUpWzBdLmxlbmd0aDtpZih1IT09IiIpe3RoaXMuJGhpZ2hsaWdodEluZGVudEd1aWRlTWFya2VyLmVuZD1vO2lmKGE8PW4pYnJlYWt9fX10aGlzLiRyZW5kZXJIaWdobGlnaHRJbmRlbnRHdWlkZSgpfSx0aGlzLiRjbGVhckFjdGl2ZUluZGVudEd1aWRlPWZ1bmN0aW9uKCl7dmFyIGU9dGhpcy4kbGluZXMuY2VsbHM7Zm9yKHZhciB0PTA7dDxlLmxlbmd0aDt0Kyspe3ZhciBuPWVbdF0scj1uLmVsZW1lbnQuY2hpbGROb2RlcztpZihyLmxlbmd0aD4wKWZvcih2YXIgaT0wO2k8ci5sZW5ndGg7aSsrKWlmKHJbaV0uY2xhc3NMaXN0JiZyW2ldLmNsYXNzTGlzdC5jb250YWlucygiYWNlX2luZGVudC1ndWlkZS1hY3RpdmUiKSl7cltpXS5jbGFzc0xpc3QucmVtb3ZlKCJhY2VfaW5kZW50LWd1aWRlLWFjdGl2ZSIpO2JyZWFrfX19LHRoaXMuJHNldEluZGVudEd1aWRlQWN0aXZlPWZ1bmN0aW9uKGUsdCl7dmFyIG49dGhpcy5zZXNzaW9uLmRvYy5nZXRMaW5lKGUucm93KTtpZihuIT09IiIpe3ZhciByPWUuZWxlbWVudC5jaGlsZE5vZGVzO2lmKHIpe3ZhciBpPXJbdC0xXTtpJiZpLmNsYXNzTGlzdCYmaS5jbGFzc0xpc3QuY29udGFpbnMoImFjZV9pbmRlbnQtZ3VpZGUiKSYmaS5jbGFzc0xpc3QuYWRkKCJhY2VfaW5kZW50LWd1aWRlLWFjdGl2ZSIpfX19LHRoaXMuJHJlbmRlckhpZ2hsaWdodEluZGVudEd1aWRlPWZ1bmN0aW9uKCl7aWYoIXRoaXMuJGxpbmVzKXJldHVybjt2YXIgZT10aGlzLiRsaW5lcy5jZWxsczt0aGlzLiRjbGVhckFjdGl2ZUluZGVudEd1aWRlKCk7dmFyIHQ9dGhpcy4kaGlnaGxpZ2h0SW5kZW50R3VpZGVNYXJrZXIuaW5kZW50TGV2ZWw7aWYodCE9PTApaWYodGhpcy4kaGlnaGxpZ2h0SW5kZW50R3VpZGVNYXJrZXIuZGlyPT09MSlmb3IodmFyIG49MDtuPGUubGVuZ3RoO24rKyl7dmFyIHI9ZVtuXTtpZih0aGlzLiRoaWdobGlnaHRJbmRlbnRHdWlkZU1hcmtlci5lbmQmJnIucm93Pj10aGlzLiRoaWdobGlnaHRJbmRlbnRHdWlkZU1hcmtlci5zdGFydCsxKXtpZihyLnJvdz49dGhpcy4kaGlnaGxpZ2h0SW5kZW50R3VpZGVNYXJrZXIuZW5kKWJyZWFrO3RoaXMuJHNldEluZGVudEd1aWRlQWN0aXZlKHIsdCl9fWVsc2UgZm9yKHZhciBuPWUubGVuZ3RoLTE7bj49MDtuLS0pe3ZhciByPWVbbl07aWYodGhpcy4kaGlnaGxpZ2h0SW5kZW50R3VpZGVNYXJrZXIuZW5kJiZyLnJvdzx0aGlzLiRoaWdobGlnaHRJbmRlbnRHdWlkZU1hcmtlci5zdGFydCl7aWYoci5yb3c8PXRoaXMuJGhpZ2hsaWdodEluZGVudEd1aWRlTWFya2VyLmVuZClicmVhazt0aGlzLiRzZXRJbmRlbnRHdWlkZUFjdGl2ZShyLHQpfX19LHRoaXMuJGNyZWF0ZUxpbmVFbGVtZW50PWZ1bmN0aW9uKGUpe3ZhciB0PXRoaXMuZG9tLmNyZWF0ZUVsZW1lbnQoImRpdiIpO3JldHVybiB0LmNsYXNzTmFtZT0iYWNlX2xpbmUiLHQuc3R5bGUuaGVpZ2h0PXRoaXMuY29uZmlnLmxpbmVIZWlnaHQrInB4Iix0fSx0aGlzLiRyZW5kZXJXcmFwcGVkTGluZT1mdW5jdGlvbihlLHQsbil7dmFyIHI9MCxpPTAsbz1uWzBdLHU9MCxhPXRoaXMuJGNyZWF0ZUxpbmVFbGVtZW50KCk7ZS5hcHBlbmRDaGlsZChhKTtmb3IodmFyIGY9MDtmPHQubGVuZ3RoO2YrKyl7dmFyIGw9dFtmXSxjPWwudmFsdWU7aWYoZj09MCYmdGhpcy5kaXNwbGF5SW5kZW50R3VpZGVzKXtyPWMubGVuZ3RoLGM9dGhpcy5yZW5kZXJJbmRlbnRHdWlkZShhLGMsbyk7aWYoIWMpY29udGludWU7ci09Yy5sZW5ndGh9aWYocitjLmxlbmd0aDxvKXU9dGhpcy4kcmVuZGVyVG9rZW5JbkNodW5rcyhhLHUsbCxjKSxyKz1jLmxlbmd0aDtlbHNle3doaWxlKHIrYy5sZW5ndGg+PW8pdT10aGlzLiRyZW5kZXJUb2tlbkluQ2h1bmtzKGEsdSxsLGMuc3Vic3RyaW5nKDAsby1yKSksYz1jLnN1YnN0cmluZyhvLXIpLHI9byxhPXRoaXMuJGNyZWF0ZUxpbmVFbGVtZW50KCksZS5hcHBlbmRDaGlsZChhKSxhLmFwcGVuZENoaWxkKHRoaXMuZG9tLmNyZWF0ZVRleHROb2RlKHMuc3RyaW5nUmVwZWF0KCJcdTAwYTAiLG4uaW5kZW50KSx0aGlzLmVsZW1lbnQpKSxpKyssdT0wLG89bltpXXx8TnVtYmVyLk1BWF9WQUxVRTtjLmxlbmd0aCE9MCYmKHIrPWMubGVuZ3RoLHU9dGhpcy4kcmVuZGVyVG9rZW5JbkNodW5rcyhhLHUsbCxjKSl9fW5bbi5sZW5ndGgtMV0+dGhpcy5NQVhfTElORV9MRU5HVEgmJnRoaXMuJHJlbmRlck92ZXJmbG93TWVzc2FnZShhLHUsbnVsbCwiIiwhMCl9LHRoaXMuJHJlbmRlclNpbXBsZUxpbmU9ZnVuY3Rpb24oZSx0KXt2YXIgbj0wO2Zvcih2YXIgcj0wO3I8dC5sZW5ndGg7cisrKXt2YXIgaT10W3JdLHM9aS52YWx1ZTtpZihyPT0wJiZ0aGlzLmRpc3BsYXlJbmRlbnRHdWlkZXMpe3M9dGhpcy5yZW5kZXJJbmRlbnRHdWlkZShlLHMpO2lmKCFzKWNvbnRpbnVlfWlmKG4rcy5sZW5ndGg+dGhpcy5NQVhfTElORV9MRU5HVEgpe3RoaXMuJHJlbmRlck92ZXJmbG93TWVzc2FnZShlLG4saSxzKTtyZXR1cm59bj10aGlzLiRyZW5kZXJUb2tlbkluQ2h1bmtzKGUsbixpLHMpfX0sdGhpcy4kcmVuZGVyT3ZlcmZsb3dNZXNzYWdlPWZ1bmN0aW9uKGUsdCxuLHIsaSl7biYmdGhpcy4kcmVuZGVyVG9rZW5JbkNodW5rcyhlLHQsbixyLnNsaWNlKDAsdGhpcy5NQVhfTElORV9MRU5HVEgtdCkpO3ZhciBzPXRoaXMuZG9tLmNyZWF0ZUVsZW1lbnQoInNwYW4iKTtzLmNsYXNzTmFtZT0iYWNlX2lubGluZV9idXR0b24gYWNlX2tleXdvcmQgYWNlX3RvZ2dsZV93cmFwIixzLnRleHRDb250ZW50PWk/IjxoaWRlPiI6IjxjbGljayB0byBzZWUgbW9yZS4uLj4iLGUuYXBwZW5kQ2hpbGQocyl9LHRoaXMuJHJlbmRlckxpbmU9ZnVuY3Rpb24oZSx0LG4peyFuJiZuIT0wJiYobj10aGlzLnNlc3Npb24uZ2V0Rm9sZExpbmUodCkpO2lmKG4pdmFyIHI9dGhpcy4kZ2V0Rm9sZExpbmVUb2tlbnModCxuKTtlbHNlIHZhciByPXRoaXMuc2Vzc2lvbi5nZXRUb2tlbnModCk7dmFyIGk9ZTtpZihyLmxlbmd0aCl7dmFyIHM9dGhpcy5zZXNzaW9uLmdldFJvd1NwbGl0RGF0YSh0KTtpZihzJiZzLmxlbmd0aCl7dGhpcy4kcmVuZGVyV3JhcHBlZExpbmUoZSxyLHMpO3ZhciBpPWUubGFzdENoaWxkfWVsc2V7dmFyIGk9ZTt0aGlzLiR1c2VMaW5lR3JvdXBzKCkmJihpPXRoaXMuJGNyZWF0ZUxpbmVFbGVtZW50KCksZS5hcHBlbmRDaGlsZChpKSksdGhpcy4kcmVuZGVyU2ltcGxlTGluZShpLHIpfX1lbHNlIHRoaXMuJHVzZUxpbmVHcm91cHMoKSYmKGk9dGhpcy4kY3JlYXRlTGluZUVsZW1lbnQoKSxlLmFwcGVuZENoaWxkKGkpKTtpZih0aGlzLnNob3dFT0wmJmkpe24mJih0PW4uZW5kLnJvdyk7dmFyIG89dGhpcy5kb20uY3JlYXRlRWxlbWVudCgic3BhbiIpO28uY2xhc3NOYW1lPSJhY2VfaW52aXNpYmxlIGFjZV9pbnZpc2libGVfZW9sIixvLnRleHRDb250ZW50PXQ9PXRoaXMuc2Vzc2lvbi5nZXRMZW5ndGgoKS0xP3RoaXMuRU9GX0NIQVI6dGhpcy5FT0xfQ0hBUixpLmFwcGVuZENoaWxkKG8pfX0sdGhpcy4kZ2V0Rm9sZExpbmVUb2tlbnM9ZnVuY3Rpb24oZSx0KXtmdW5jdGlvbiBpKGUsdCxuKXt2YXIgaT0wLHM9MDt3aGlsZShzK2VbaV0udmFsdWUubGVuZ3RoPHQpe3MrPWVbaV0udmFsdWUubGVuZ3RoLGkrKztpZihpPT1lLmxlbmd0aClyZXR1cm59aWYocyE9dCl7dmFyIG89ZVtpXS52YWx1ZS5zdWJzdHJpbmcodC1zKTtvLmxlbmd0aD5uLXQmJihvPW8uc3Vic3RyaW5nKDAsbi10KSksci5wdXNoKHt0eXBlOmVbaV0udHlwZSx2YWx1ZTpvfSkscz10K28ubGVuZ3RoLGkrPTF9d2hpbGUoczxuJiZpPGUubGVuZ3RoKXt2YXIgbz1lW2ldLnZhbHVlO28ubGVuZ3RoK3M+bj9yLnB1c2goe3R5cGU6ZVtpXS50eXBlLHZhbHVlOm8uc3Vic3RyaW5nKDAsbi1zKX0pOnIucHVzaChlW2ldKSxzKz1vLmxlbmd0aCxpKz0xfX12YXIgbj10aGlzLnNlc3Npb24scj1bXSxzPW4uZ2V0VG9rZW5zKGUpO3JldHVybiB0LndhbGsoZnVuY3Rpb24oZSx0LG8sdSxhKXtlIT1udWxsP3IucHVzaCh7dHlwZToiZm9sZCIsdmFsdWU6ZX0pOihhJiYocz1uLmdldFRva2Vucyh0KSkscy5sZW5ndGgmJmkocyx1LG8pKX0sdC5lbmQucm93LHRoaXMuc2Vzc2lvbi5nZXRMaW5lKHQuZW5kLnJvdykubGVuZ3RoKSxyfSx0aGlzLiR1c2VMaW5lR3JvdXBzPWZ1bmN0aW9uKCl7cmV0dXJuIHRoaXMuc2Vzc2lvbi5nZXRVc2VXcmFwTW9kZSgpfSx0aGlzLmRlc3Ryb3k9ZnVuY3Rpb24oKXt9fSkuY2FsbChhLnByb3RvdHlwZSksdC5UZXh0PWF9KSxkZWZpbmUoImFjZS9sYXllci9jdXJzb3IiLFsicmVxdWlyZSIsImV4cG9ydHMiLCJtb2R1bGUiLCJhY2UvbGliL2RvbSJdLGZ1bmN0aW9uKGUsdCxuKXsidXNlIHN0cmljdCI7dmFyIHI9ZSgiLi4vbGliL2RvbSIpLGk9ZnVuY3Rpb24oZSl7dGhpcy5lbGVtZW50PXIuY3JlYXRlRWxlbWVudCgiZGl2IiksdGhpcy5lbGVtZW50LmNsYXNzTmFtZT0iYWNlX2xheWVyIGFjZV9jdXJzb3ItbGF5ZXIiLGUuYXBwZW5kQ2hpbGQodGhpcy5lbGVtZW50KSx0aGlzLmlzVmlzaWJsZT0hMSx0aGlzLmlzQmxpbmtpbmc9ITAsdGhpcy5ibGlua0ludGVydmFsPTFlMyx0aGlzLnNtb290aEJsaW5raW5nPSExLHRoaXMuY3Vyc29ycz1bXSx0aGlzLmN1cnNvcj10aGlzLmFkZEN1cnNvcigpLHIuYWRkQ3NzQ2xhc3ModGhpcy5lbGVtZW50LCJhY2VfaGlkZGVuLWN1cnNvcnMiKSx0aGlzLiR1cGRhdGVDdXJzb3JzPXRoaXMuJHVwZGF0ZU9wYWNpdHkuYmluZCh0aGlzKX07KGZ1bmN0aW9uKCl7dGhpcy4kdXBkYXRlT3BhY2l0eT1mdW5jdGlvbihlKXt2YXIgdD10aGlzLmN1cnNvcnM7Zm9yKHZhciBuPXQubGVuZ3RoO24tLTspci5zZXRTdHlsZSh0W25dLnN0eWxlLCJvcGFjaXR5IixlPyIiOiIwIil9LHRoaXMuJHN0YXJ0Q3NzQW5pbWF0aW9uPWZ1bmN0aW9uKCl7dmFyIGU9dGhpcy5jdXJzb3JzO2Zvcih2YXIgdD1lLmxlbmd0aDt0LS07KWVbdF0uc3R5bGUuYW5pbWF0aW9uRHVyYXRpb249dGhpcy5ibGlua0ludGVydmFsKyJtcyI7dGhpcy4kaXNBbmltYXRpbmc9ITAsc2V0VGltZW91dChmdW5jdGlvbigpe3RoaXMuJGlzQW5pbWF0aW5nJiZyLmFkZENzc0NsYXNzKHRoaXMuZWxlbWVudCwiYWNlX2FuaW1hdGUtYmxpbmtpbmciKX0uYmluZCh0aGlzKSl9LHRoaXMuJHN0b3BDc3NBbmltYXRpb249ZnVuY3Rpb24oKXt0aGlzLiRpc0FuaW1hdGluZz0hMSxyLnJlbW92ZUNzc0NsYXNzKHRoaXMuZWxlbWVudCwiYWNlX2FuaW1hdGUtYmxpbmtpbmciKX0sdGhpcy4kcGFkZGluZz0wLHRoaXMuc2V0UGFkZGluZz1mdW5jdGlvbihlKXt0aGlzLiRwYWRkaW5nPWV9LHRoaXMuc2V0U2Vzc2lvbj1mdW5jdGlvbihlKXt0aGlzLnNlc3Npb249ZX0sdGhpcy5zZXRCbGlua2luZz1mdW5jdGlvbihlKXtlIT10aGlzLmlzQmxpbmtpbmcmJih0aGlzLmlzQmxpbmtpbmc9ZSx0aGlzLnJlc3RhcnRUaW1lcigpKX0sdGhpcy5zZXRCbGlua0ludGVydmFsPWZ1bmN0aW9uKGUpe2UhPXRoaXMuYmxpbmtJbnRlcnZhbCYmKHRoaXMuYmxpbmtJbnRlcnZhbD1lLHRoaXMucmVzdGFydFRpbWVyKCkpfSx0aGlzLnNldFNtb290aEJsaW5raW5nPWZ1bmN0aW9uKGUpe2UhPXRoaXMuc21vb3RoQmxpbmtpbmcmJih0aGlzLnNtb290aEJsaW5raW5nPWUsci5zZXRDc3NDbGFzcyh0aGlzLmVsZW1lbnQsImFjZV9zbW9vdGgtYmxpbmtpbmciLGUpLHRoaXMuJHVwZGF0ZUN1cnNvcnMoITApLHRoaXMucmVzdGFydFRpbWVyKCkpfSx0aGlzLmFkZEN1cnNvcj1mdW5jdGlvbigpe3ZhciBlPXIuY3JlYXRlRWxlbWVudCgiZGl2Iik7cmV0dXJuIGUuY2xhc3NOYW1lPSJhY2VfY3Vyc29yIix0aGlzLmVsZW1lbnQuYXBwZW5kQ2hpbGQoZSksdGhpcy5jdXJzb3JzLnB1c2goZSksZX0sdGhpcy5yZW1vdmVDdXJzb3I9ZnVuY3Rpb24oKXtpZih0aGlzLmN1cnNvcnMubGVuZ3RoPjEpe3ZhciBlPXRoaXMuY3Vyc29ycy5wb3AoKTtyZXR1cm4gZS5wYXJlbnROb2RlLnJlbW92ZUNoaWxkKGUpLGV9fSx0aGlzLmhpZGVDdXJzb3I9ZnVuY3Rpb24oKXt0aGlzLmlzVmlzaWJsZT0hMSxyLmFkZENzc0NsYXNzKHRoaXMuZWxlbWVudCwiYWNlX2hpZGRlbi1jdXJzb3JzIiksdGhpcy5yZXN0YXJ0VGltZXIoKX0sdGhpcy5zaG93Q3Vyc29yPWZ1bmN0aW9uKCl7dGhpcy5pc1Zpc2libGU9ITAsci5yZW1vdmVDc3NDbGFzcyh0aGlzLmVsZW1lbnQsImFjZV9oaWRkZW4tY3Vyc29ycyIpLHRoaXMucmVzdGFydFRpbWVyKCl9LHRoaXMucmVzdGFydFRpbWVyPWZ1bmN0aW9uKCl7dmFyIGU9dGhpcy4kdXBkYXRlQ3Vyc29ycztjbGVhckludGVydmFsKHRoaXMuaW50ZXJ2YWxJZCksY2xlYXJUaW1lb3V0KHRoaXMudGltZW91dElkKSx0aGlzLiRzdG9wQ3NzQW5pbWF0aW9uKCksdGhpcy5zbW9vdGhCbGlua2luZyYmKHRoaXMuJGlzU21vb3RoQmxpbmtpbmc9ITEsci5yZW1vdmVDc3NDbGFzcyh0aGlzLmVsZW1lbnQsImFjZV9zbW9vdGgtYmxpbmtpbmciKSksZSghMCk7aWYoIXRoaXMuaXNCbGlua2luZ3x8IXRoaXMuYmxpbmtJbnRlcnZhbHx8IXRoaXMuaXNWaXNpYmxlKXt0aGlzLiRzdG9wQ3NzQW5pbWF0aW9uKCk7cmV0dXJufXRoaXMuc21vb3RoQmxpbmtpbmcmJih0aGlzLiRpc1Ntb290aEJsaW5raW5nPSEwLHNldFRpbWVvdXQoZnVuY3Rpb24oKXt0aGlzLiRpc1Ntb290aEJsaW5raW5nJiZyLmFkZENzc0NsYXNzKHRoaXMuZWxlbWVudCwiYWNlX3Ntb290aC1ibGlua2luZyIpfS5iaW5kKHRoaXMpKSk7aWYoci5IQVNfQ1NTX0FOSU1BVElPTil0aGlzLiRzdGFydENzc0FuaW1hdGlvbigpO2Vsc2V7dmFyIHQ9ZnVuY3Rpb24oKXt0aGlzLnRpbWVvdXRJZD1zZXRUaW1lb3V0KGZ1bmN0aW9uKCl7ZSghMSl9LC42KnRoaXMuYmxpbmtJbnRlcnZhbCl9LmJpbmQodGhpcyk7dGhpcy5pbnRlcnZhbElkPXNldEludGVydmFsKGZ1bmN0aW9uKCl7ZSghMCksdCgpfSx0aGlzLmJsaW5rSW50ZXJ2YWwpLHQoKX19LHRoaXMuZ2V0UGl4ZWxQb3NpdGlvbj1mdW5jdGlvbihlLHQpe2lmKCF0aGlzLmNvbmZpZ3x8IXRoaXMuc2Vzc2lvbilyZXR1cm57bGVmdDowLHRvcDowfTtlfHwoZT10aGlzLnNlc3Npb24uc2VsZWN0aW9uLmdldEN1cnNvcigpKTt2YXIgbj10aGlzLnNlc3Npb24uZG9jdW1lbnRUb1NjcmVlblBvc2l0aW9uKGUpLHI9dGhpcy4kcGFkZGluZysodGhpcy5zZXNzaW9uLiRiaWRpSGFuZGxlci5pc0JpZGlSb3cobi5yb3csZS5yb3cpP3RoaXMuc2Vzc2lvbi4kYmlkaUhhbmRsZXIuZ2V0UG9zTGVmdChuLmNvbHVtbik6bi5jb2x1bW4qdGhpcy5jb25maWcuY2hhcmFjdGVyV2lkdGgpLGk9KG4ucm93LSh0P3RoaXMuY29uZmlnLmZpcnN0Um93U2NyZWVuOjApKSp0aGlzLmNvbmZpZy5saW5lSGVpZ2h0O3JldHVybntsZWZ0OnIsdG9wOml9fSx0aGlzLmlzQ3Vyc29ySW5WaWV3PWZ1bmN0aW9uKGUsdCl7cmV0dXJuIGUudG9wPj0wJiZlLnRvcDx0Lm1heEhlaWdodH0sdGhpcy51cGRhdGU9ZnVuY3Rpb24oZSl7dGhpcy5jb25maWc9ZTt2YXIgdD10aGlzLnNlc3Npb24uJHNlbGVjdGlvbk1hcmtlcnMsbj0wLGk9MDtpZih0PT09dW5kZWZpbmVkfHx0Lmxlbmd0aD09PTApdD1be2N1cnNvcjpudWxsfV07Zm9yKHZhciBuPTAscz10Lmxlbmd0aDtuPHM7bisrKXt2YXIgbz10aGlzLmdldFBpeGVsUG9zaXRpb24odFtuXS5jdXJzb3IsITApO2lmKChvLnRvcD5lLmhlaWdodCtlLm9mZnNldHx8by50b3A8MCkmJm4+MSljb250aW51ZTt2YXIgdT10aGlzLmN1cnNvcnNbaSsrXXx8dGhpcy5hZGRDdXJzb3IoKSxhPXUuc3R5bGU7dGhpcy5kcmF3Q3Vyc29yP3RoaXMuZHJhd0N1cnNvcih1LG8sZSx0W25dLHRoaXMuc2Vzc2lvbik6dGhpcy5pc0N1cnNvckluVmlldyhvLGUpPyhyLnNldFN0eWxlKGEsImRpc3BsYXkiLCJibG9jayIpLHIudHJhbnNsYXRlKHUsby5sZWZ0LG8udG9wKSxyLnNldFN0eWxlKGEsIndpZHRoIixNYXRoLnJvdW5kKGUuY2hhcmFjdGVyV2lkdGgpKyJweCIpLHIuc2V0U3R5bGUoYSwiaGVpZ2h0IixlLmxpbmVIZWlnaHQrInB4IikpOnIuc2V0U3R5bGUoYSwiZGlzcGxheSIsIm5vbmUiKX13aGlsZSh0aGlzLmN1cnNvcnMubGVuZ3RoPmkpdGhpcy5yZW1vdmVDdXJzb3IoKTt2YXIgZj10aGlzLnNlc3Npb24uZ2V0T3ZlcndyaXRlKCk7dGhpcy4kc2V0T3ZlcndyaXRlKGYpLHRoaXMuJHBpeGVsUG9zPW8sdGhpcy5yZXN0YXJ0VGltZXIoKX0sdGhpcy5kcmF3Q3Vyc29yPW51bGwsdGhpcy4kc2V0T3ZlcndyaXRlPWZ1bmN0aW9uKGUpe2UhPXRoaXMub3ZlcndyaXRlJiYodGhpcy5vdmVyd3JpdGU9ZSxlP3IuYWRkQ3NzQ2xhc3ModGhpcy5lbGVtZW50LCJhY2Vfb3ZlcndyaXRlLWN1cnNvcnMiKTpyLnJlbW92ZUNzc0NsYXNzKHRoaXMuZWxlbWVudCwiYWNlX292ZXJ3cml0ZS1jdXJzb3JzIikpfSx0aGlzLmRlc3Ryb3k9ZnVuY3Rpb24oKXtjbGVhckludGVydmFsKHRoaXMuaW50ZXJ2YWxJZCksY2xlYXJUaW1lb3V0KHRoaXMudGltZW91dElkKX19KS5jYWxsKGkucHJvdG90eXBlKSx0LkN1cnNvcj1pfSksZGVmaW5lKCJhY2Uvc2Nyb2xsYmFyIixbInJlcXVpcmUiLCJleHBvcnRzIiwibW9kdWxlIiwiYWNlL2xpYi9vb3AiLCJhY2UvbGliL2RvbSIsImFjZS9saWIvZXZlbnQiLCJhY2UvbGliL2V2ZW50X2VtaXR0ZXIiXSxmdW5jdGlvbihlLHQsbil7InVzZSBzdHJpY3QiO3ZhciByPWUoIi4vbGliL29vcCIpLGk9ZSgiLi9saWIvZG9tIikscz1lKCIuL2xpYi9ldmVudCIpLG89ZSgiLi9saWIvZXZlbnRfZW1pdHRlciIpLkV2ZW50RW1pdHRlcix1PTMyNzY4LGE9ZnVuY3Rpb24oZSl7dGhpcy5lbGVtZW50PWkuY3JlYXRlRWxlbWVudCgiZGl2IiksdGhpcy5lbGVtZW50LmNsYXNzTmFtZT0iYWNlX3Njcm9sbGJhciBhY2Vfc2Nyb2xsYmFyIit0aGlzLmNsYXNzU3VmZml4LHRoaXMuaW5uZXI9aS5jcmVhdGVFbGVtZW50KCJkaXYiKSx0aGlzLmlubmVyLmNsYXNzTmFtZT0iYWNlX3Njcm9sbGJhci1pbm5lciIsdGhpcy5pbm5lci50ZXh0Q29udGVudD0iXHUwMGEwIix0aGlzLmVsZW1lbnQuYXBwZW5kQ2hpbGQodGhpcy5pbm5lciksZS5hcHBlbmRDaGlsZCh0aGlzLmVsZW1lbnQpLHRoaXMuc2V0VmlzaWJsZSghMSksdGhpcy5za2lwRXZlbnQ9ITEscy5hZGRMaXN0ZW5lcih0aGlzLmVsZW1lbnQsInNjcm9sbCIsdGhpcy5vblNjcm9sbC5iaW5kKHRoaXMpKSxzLmFkZExpc3RlbmVyKHRoaXMuZWxlbWVudCwibW91c2Vkb3duIixzLnByZXZlbnREZWZhdWx0KX07KGZ1bmN0aW9uKCl7ci5pbXBsZW1lbnQodGhpcyxvKSx0aGlzLnNldFZpc2libGU9ZnVuY3Rpb24oZSl7dGhpcy5lbGVtZW50LnN0eWxlLmRpc3BsYXk9ZT8iIjoibm9uZSIsdGhpcy5pc1Zpc2libGU9ZSx0aGlzLmNvZWZmPTF9fSkuY2FsbChhLnByb3RvdHlwZSk7dmFyIGY9ZnVuY3Rpb24oZSx0KXthLmNhbGwodGhpcyxlKSx0aGlzLnNjcm9sbFRvcD0wLHRoaXMuc2Nyb2xsSGVpZ2h0PTAsdC4kc2Nyb2xsYmFyV2lkdGg9dGhpcy53aWR0aD1pLnNjcm9sbGJhcldpZHRoKGUub3duZXJEb2N1bWVudCksdGhpcy5pbm5lci5zdHlsZS53aWR0aD10aGlzLmVsZW1lbnQuc3R5bGUud2lkdGg9KHRoaXMud2lkdGh8fDE1KSs1KyJweCIsdGhpcy4kbWluV2lkdGg9MH07ci5pbmhlcml0cyhmLGEpLGZ1bmN0aW9uKCl7dGhpcy5jbGFzc1N1ZmZpeD0iLXYiLHRoaXMub25TY3JvbGw9ZnVuY3Rpb24oKXtpZighdGhpcy5za2lwRXZlbnQpe3RoaXMuc2Nyb2xsVG9wPXRoaXMuZWxlbWVudC5zY3JvbGxUb3A7aWYodGhpcy5jb2VmZiE9MSl7dmFyIGU9dGhpcy5lbGVtZW50LmNsaWVudEhlaWdodC90aGlzLnNjcm9sbEhlaWdodDt0aGlzLnNjcm9sbFRvcD10aGlzLnNjcm9sbFRvcCooMS1lKS8odGhpcy5jb2VmZi1lKX10aGlzLl9lbWl0KCJzY3JvbGwiLHtkYXRhOnRoaXMuc2Nyb2xsVG9wfSl9dGhpcy5za2lwRXZlbnQ9ITF9LHRoaXMuZ2V0V2lkdGg9ZnVuY3Rpb24oKXtyZXR1cm4gTWF0aC5tYXgodGhpcy5pc1Zpc2libGU/dGhpcy53aWR0aDowLHRoaXMuJG1pbldpZHRofHwwKX0sdGhpcy5zZXRIZWlnaHQ9ZnVuY3Rpb24oZSl7dGhpcy5lbGVtZW50LnN0eWxlLmhlaWdodD1lKyJweCJ9LHRoaXMuc2V0SW5uZXJIZWlnaHQ9dGhpcy5zZXRTY3JvbGxIZWlnaHQ9ZnVuY3Rpb24oZSl7dGhpcy5zY3JvbGxIZWlnaHQ9ZSxlPnU/KHRoaXMuY29lZmY9dS9lLGU9dSk6dGhpcy5jb2VmZiE9MSYmKHRoaXMuY29lZmY9MSksdGhpcy5pbm5lci5zdHlsZS5oZWlnaHQ9ZSsicHgifSx0aGlzLnNldFNjcm9sbFRvcD1mdW5jdGlvbihlKXt0aGlzLnNjcm9sbFRvcCE9ZSYmKHRoaXMuc2tpcEV2ZW50PSEwLHRoaXMuc2Nyb2xsVG9wPWUsdGhpcy5lbGVtZW50LnNjcm9sbFRvcD1lKnRoaXMuY29lZmYpfX0uY2FsbChmLnByb3RvdHlwZSk7dmFyIGw9ZnVuY3Rpb24oZSx0KXthLmNhbGwodGhpcyxlKSx0aGlzLnNjcm9sbExlZnQ9MCx0aGlzLmhlaWdodD10LiRzY3JvbGxiYXJXaWR0aCx0aGlzLmlubmVyLnN0eWxlLmhlaWdodD10aGlzLmVsZW1lbnQuc3R5bGUuaGVpZ2h0PSh0aGlzLmhlaWdodHx8MTUpKzUrInB4In07ci5pbmhlcml0cyhsLGEpLGZ1bmN0aW9uKCl7dGhpcy5jbGFzc1N1ZmZpeD0iLWgiLHRoaXMub25TY3JvbGw9ZnVuY3Rpb24oKXt0aGlzLnNraXBFdmVudHx8KHRoaXMuc2Nyb2xsTGVmdD10aGlzLmVsZW1lbnQuc2Nyb2xsTGVmdCx0aGlzLl9lbWl0KCJzY3JvbGwiLHtkYXRhOnRoaXMuc2Nyb2xsTGVmdH0pKSx0aGlzLnNraXBFdmVudD0hMX0sdGhpcy5nZXRIZWlnaHQ9ZnVuY3Rpb24oKXtyZXR1cm4gdGhpcy5pc1Zpc2libGU/dGhpcy5oZWlnaHQ6MH0sdGhpcy5zZXRXaWR0aD1mdW5jdGlvbihlKXt0aGlzLmVsZW1lbnQuc3R5bGUud2lkdGg9ZSsicHgifSx0aGlzLnNldElubmVyV2lkdGg9ZnVuY3Rpb24oZSl7dGhpcy5pbm5lci5zdHlsZS53aWR0aD1lKyJweCJ9LHRoaXMuc2V0U2Nyb2xsV2lkdGg9ZnVuY3Rpb24oZSl7dGhpcy5pbm5lci5zdHlsZS53aWR0aD1lKyJweCJ9LHRoaXMuc2V0U2Nyb2xsTGVmdD1mdW5jdGlvbihlKXt0aGlzLnNjcm9sbExlZnQhPWUmJih0aGlzLnNraXBFdmVudD0hMCx0aGlzLnNjcm9sbExlZnQ9dGhpcy5lbGVtZW50LnNjcm9sbExlZnQ9ZSl9fS5jYWxsKGwucHJvdG90eXBlKSx0LlNjcm9sbEJhcj1mLHQuU2Nyb2xsQmFyVj1mLHQuU2Nyb2xsQmFySD1sLHQuVlNjcm9sbEJhcj1mLHQuSFNjcm9sbEJhcj1sfSksZGVmaW5lKCJhY2Uvc2Nyb2xsYmFyX2N1c3RvbSIsWyJyZXF1aXJlIiwiZXhwb3J0cyIsIm1vZHVsZSIsImFjZS9saWIvb29wIiwiYWNlL2xpYi9kb20iLCJhY2UvbGliL2V2ZW50IiwiYWNlL2xpYi9ldmVudF9lbWl0dGVyIl0sZnVuY3Rpb24oZSx0LG4peyJ1c2Ugc3RyaWN0Ijt2YXIgcj1lKCIuL2xpYi9vb3AiKSxpPWUoIi4vbGliL2RvbSIpLHM9ZSgiLi9saWIvZXZlbnQiKSxvPWUoIi4vbGliL2V2ZW50X2VtaXR0ZXIiKS5FdmVudEVtaXR0ZXI7aS5pbXBvcnRDc3NTdHJpbmcoIi5hY2VfZWRpdG9yPi5hY2Vfc2ItdiBkaXYsIC5hY2VfZWRpdG9yPi5hY2Vfc2ItaCBkaXZ7XG4gIHBvc2l0aW9uOiBhYnNvbHV0ZTtcbiAgYmFja2dyb3VuZDogcmdiYSgxMjgsIDEyOCwgMTI4LCAwLjYpO1xuICAtbW96LWJveC1zaXppbmc6IGJvcmRlci1ib3g7XG4gIGJveC1zaXppbmc6IGJvcmRlci1ib3g7XG4gIGJvcmRlcjogMXB4IHNvbGlkICNiYmI7XG4gIGJvcmRlci1yYWRpdXM6IDJweDtcbiAgei1pbmRleDogODtcbn1cbi5hY2VfZWRpdG9yPi5hY2Vfc2ItdiwgLmFjZV9lZGl0b3I+LmFjZV9zYi1oIHtcbiAgcG9zaXRpb246IGFic29sdXRlO1xuICB6LWluZGV4OiA2O1xuICBiYWNrZ3JvdW5kOiBub25lO1xuICBvdmVyZmxvdzogaGlkZGVuIWltcG9ydGFudDtcbn1cbi5hY2VfZWRpdG9yPi5hY2Vfc2ItdiB7XG4gIHotaW5kZXg6IDY7XG4gIHJpZ2h0OiAwO1xuICB0b3A6IDA7XG4gIHdpZHRoOiAxMnB4O1xufVxuLmFjZV9lZGl0b3I+LmFjZV9zYi12IGRpdiB7XG4gIHotaW5kZXg6IDg7XG4gIHJpZ2h0OiAwO1xuICB3aWR0aDogMTAwJTtcbn1cbi5hY2VfZWRpdG9yPi5hY2Vfc2ItaCB7XG4gIGJvdHRvbTogMDtcbiAgbGVmdDogMDtcbiAgaGVpZ2h0OiAxMnB4O1xufVxuLmFjZV9lZGl0b3I+LmFjZV9zYi1oIGRpdiB7XG4gIGJvdHRvbTogMDtcbiAgaGVpZ2h0OiAxMDAlO1xufVxuLmFjZV9lZGl0b3I+LmFjZV9zYl9ncmFiYmVkIHtcbiAgei1pbmRleDogODtcbiAgYmFja2dyb3VuZDogIzAwMDtcbn0iLCJhY2Vfc2Nyb2xsYmFyLmNzcyIsITEpO3ZhciB1PWZ1bmN0aW9uKGUpe3RoaXMuZWxlbWVudD1pLmNyZWF0ZUVsZW1lbnQoImRpdiIpLHRoaXMuZWxlbWVudC5jbGFzc05hbWU9ImFjZV9zYiIrdGhpcy5jbGFzc1N1ZmZpeCx0aGlzLmlubmVyPWkuY3JlYXRlRWxlbWVudCgiZGl2IiksdGhpcy5pbm5lci5jbGFzc05hbWU9IiIsdGhpcy5lbGVtZW50LmFwcGVuZENoaWxkKHRoaXMuaW5uZXIpLHRoaXMuVlNjcm9sbFdpZHRoPTEyLHRoaXMuSFNjcm9sbEhlaWdodD0xMixlLmFwcGVuZENoaWxkKHRoaXMuZWxlbWVudCksdGhpcy5zZXRWaXNpYmxlKCExKSx0aGlzLnNraXBFdmVudD0hMSxzLmFkZE11bHRpTW91c2VEb3duTGlzdGVuZXIodGhpcy5lbGVtZW50LFs1MDAsMzAwLDMwMF0sdGhpcywib25Nb3VzZURvd24iKX07KGZ1bmN0aW9uKCl7ci5pbXBsZW1lbnQodGhpcyxvKSx0aGlzLnNldFZpc2libGU9ZnVuY3Rpb24oZSl7dGhpcy5lbGVtZW50LnN0eWxlLmRpc3BsYXk9ZT8iIjoibm9uZSIsdGhpcy5pc1Zpc2libGU9ZSx0aGlzLmNvZWZmPTF9fSkuY2FsbCh1LnByb3RvdHlwZSk7dmFyIGE9ZnVuY3Rpb24oZSx0KXt1LmNhbGwodGhpcyxlKSx0aGlzLnNjcm9sbFRvcD0wLHRoaXMuc2Nyb2xsSGVpZ2h0PTAsdGhpcy5wYXJlbnQ9ZSx0aGlzLndpZHRoPXRoaXMuVlNjcm9sbFdpZHRoLHRoaXMucmVuZGVyZXI9dCx0aGlzLmlubmVyLnN0eWxlLndpZHRoPXRoaXMuZWxlbWVudC5zdHlsZS53aWR0aD0odGhpcy53aWR0aHx8MTUpKyJweCIsdGhpcy4kbWluV2lkdGg9MH07ci5pbmhlcml0cyhhLHUpLGZ1bmN0aW9uKCl7dGhpcy5jbGFzc1N1ZmZpeD0iLXYiLHIuaW1wbGVtZW50KHRoaXMsbyksdGhpcy5vbk1vdXNlRG93bj1mdW5jdGlvbihlLHQpe2lmKGUhPT0ibW91c2Vkb3duIilyZXR1cm47aWYocy5nZXRCdXR0b24odCkhPT0wfHx0LmRldGFpbD09PTIpcmV0dXJuO2lmKHQudGFyZ2V0PT09dGhpcy5pbm5lcil7dmFyIG49dGhpcyxyPXQuY2xpZW50WSxpPWZ1bmN0aW9uKGUpe3I9ZS5jbGllbnRZfSxvPWZ1bmN0aW9uKCl7Y2xlYXJJbnRlcnZhbChsKX0sdT10LmNsaWVudFksYT10aGlzLnRodW1iVG9wLGY9ZnVuY3Rpb24oKXtpZihyPT09dW5kZWZpbmVkKXJldHVybjt2YXIgZT1uLnNjcm9sbFRvcEZyb21UaHVtYlRvcChhK3ItdSk7aWYoZT09PW4uc2Nyb2xsVG9wKXJldHVybjtuLl9lbWl0KCJzY3JvbGwiLHtkYXRhOmV9KX07cy5jYXB0dXJlKHRoaXMuaW5uZXIsaSxvKTt2YXIgbD1zZXRJbnRlcnZhbChmLDIwKTtyZXR1cm4gcy5wcmV2ZW50RGVmYXVsdCh0KX12YXIgYz10LmNsaWVudFktdGhpcy5lbGVtZW50LmdldEJvdW5kaW5nQ2xpZW50UmVjdCgpLnRvcC10aGlzLnRodW1iSGVpZ2h0LzI7cmV0dXJuIHRoaXMuX2VtaXQoInNjcm9sbCIse2RhdGE6dGhpcy5zY3JvbGxUb3BGcm9tVGh1bWJUb3AoYyl9KSxzLnByZXZlbnREZWZhdWx0KHQpfSx0aGlzLmdldEhlaWdodD1mdW5jdGlvbigpe3JldHVybiB0aGlzLmhlaWdodH0sdGhpcy5zY3JvbGxUb3BGcm9tVGh1bWJUb3A9ZnVuY3Rpb24oZSl7dmFyIHQ9ZSoodGhpcy5wYWdlSGVpZ2h0LXRoaXMudmlld0hlaWdodCkvKHRoaXMuc2xpZGVIZWlnaHQtdGhpcy50aHVtYkhlaWdodCk7cmV0dXJuIHQ+Pj0wLHQ8MD90PTA6dD50aGlzLnBhZ2VIZWlnaHQtdGhpcy52aWV3SGVpZ2h0JiYodD10aGlzLnBhZ2VIZWlnaHQtdGhpcy52aWV3SGVpZ2h0KSx0fSx0aGlzLmdldFdpZHRoPWZ1bmN0aW9uKCl7cmV0dXJuIE1hdGgubWF4KHRoaXMuaXNWaXNpYmxlP3RoaXMud2lkdGg6MCx0aGlzLiRtaW5XaWR0aHx8MCl9LHRoaXMuc2V0SGVpZ2h0PWZ1bmN0aW9uKGUpe3RoaXMuaGVpZ2h0PU1hdGgubWF4KDAsZSksdGhpcy5zbGlkZUhlaWdodD10aGlzLmhlaWdodCx0aGlzLnZpZXdIZWlnaHQ9dGhpcy5oZWlnaHQsdGhpcy5zZXRTY3JvbGxIZWlnaHQodGhpcy5wYWdlSGVpZ2h0LCEwKX0sdGhpcy5zZXRJbm5lckhlaWdodD10aGlzLnNldFNjcm9sbEhlaWdodD1mdW5jdGlvbihlLHQpe2lmKHRoaXMucGFnZUhlaWdodD09PWUmJiF0KXJldHVybjt0aGlzLnBhZ2VIZWlnaHQ9ZSx0aGlzLnRodW1iSGVpZ2h0PXRoaXMuc2xpZGVIZWlnaHQqdGhpcy52aWV3SGVpZ2h0L3RoaXMucGFnZUhlaWdodCx0aGlzLnRodW1iSGVpZ2h0PnRoaXMuc2xpZGVIZWlnaHQmJih0aGlzLnRodW1iSGVpZ2h0PXRoaXMuc2xpZGVIZWlnaHQpLHRoaXMudGh1bWJIZWlnaHQ8MTUmJih0aGlzLnRodW1iSGVpZ2h0PTE1KSx0aGlzLmlubmVyLnN0eWxlLmhlaWdodD10aGlzLnRodW1iSGVpZ2h0KyJweCIsdGhpcy5zY3JvbGxUb3A+dGhpcy5wYWdlSGVpZ2h0LXRoaXMudmlld0hlaWdodCYmKHRoaXMuc2Nyb2xsVG9wPXRoaXMucGFnZUhlaWdodC10aGlzLnZpZXdIZWlnaHQsdGhpcy5zY3JvbGxUb3A8MCYmKHRoaXMuc2Nyb2xsVG9wPTApLHRoaXMuX2VtaXQoInNjcm9sbCIse2RhdGE6dGhpcy5zY3JvbGxUb3B9KSl9LHRoaXMuc2V0U2Nyb2xsVG9wPWZ1bmN0aW9uKGUpe3RoaXMuc2Nyb2xsVG9wPWUsZTwwJiYoZT0wKSx0aGlzLnRodW1iVG9wPWUqKHRoaXMuc2xpZGVIZWlnaHQtdGhpcy50aHVtYkhlaWdodCkvKHRoaXMucGFnZUhlaWdodC10aGlzLnZpZXdIZWlnaHQpLHRoaXMuaW5uZXIuc3R5bGUudG9wPXRoaXMudGh1bWJUb3ArInB4In19LmNhbGwoYS5wcm90b3R5cGUpO3ZhciBmPWZ1bmN0aW9uKGUsdCl7dS5jYWxsKHRoaXMsZSksdGhpcy5zY3JvbGxMZWZ0PTAsdGhpcy5zY3JvbGxXaWR0aD0wLHRoaXMuaGVpZ2h0PXRoaXMuSFNjcm9sbEhlaWdodCx0aGlzLmlubmVyLnN0eWxlLmhlaWdodD10aGlzLmVsZW1lbnQuc3R5bGUuaGVpZ2h0PSh0aGlzLmhlaWdodHx8MTIpKyJweCIsdGhpcy5yZW5kZXJlcj10fTtyLmluaGVyaXRzKGYsdSksZnVuY3Rpb24oKXt0aGlzLmNsYXNzU3VmZml4PSItaCIsci5pbXBsZW1lbnQodGhpcyxvKSx0aGlzLm9uTW91c2VEb3duPWZ1bmN0aW9uKGUsdCl7aWYoZSE9PSJtb3VzZWRvd24iKXJldHVybjtpZihzLmdldEJ1dHRvbih0KSE9PTB8fHQuZGV0YWlsPT09MilyZXR1cm47aWYodC50YXJnZXQ9PT10aGlzLmlubmVyKXt2YXIgbj10aGlzLHI9dC5jbGllbnRYLGk9ZnVuY3Rpb24oZSl7cj1lLmNsaWVudFh9LG89ZnVuY3Rpb24oKXtjbGVhckludGVydmFsKGwpfSx1PXQuY2xpZW50WCxhPXRoaXMudGh1bWJMZWZ0LGY9ZnVuY3Rpb24oKXtpZihyPT09dW5kZWZpbmVkKXJldHVybjt2YXIgZT1uLnNjcm9sbExlZnRGcm9tVGh1bWJMZWZ0KGErci11KTtpZihlPT09bi5zY3JvbGxMZWZ0KXJldHVybjtuLl9lbWl0KCJzY3JvbGwiLHtkYXRhOmV9KX07cy5jYXB0dXJlKHRoaXMuaW5uZXIsaSxvKTt2YXIgbD1zZXRJbnRlcnZhbChmLDIwKTtyZXR1cm4gcy5wcmV2ZW50RGVmYXVsdCh0KX12YXIgYz10LmNsaWVudFgtdGhpcy5lbGVtZW50LmdldEJvdW5kaW5nQ2xpZW50UmVjdCgpLmxlZnQtdGhpcy50aHVtYldpZHRoLzI7cmV0dXJuIHRoaXMuX2VtaXQoInNjcm9sbCIse2RhdGE6dGhpcy5zY3JvbGxMZWZ0RnJvbVRodW1iTGVmdChjKX0pLHMucHJldmVudERlZmF1bHQodCl9LHRoaXMuZ2V0SGVpZ2h0PWZ1bmN0aW9uKCl7cmV0dXJuIHRoaXMuaXNWaXNpYmxlP3RoaXMuaGVpZ2h0OjB9LHRoaXMuc2Nyb2xsTGVmdEZyb21UaHVtYkxlZnQ9ZnVuY3Rpb24oZSl7dmFyIHQ9ZSoodGhpcy5wYWdlV2lkdGgtdGhpcy52aWV3V2lkdGgpLyh0aGlzLnNsaWRlV2lkdGgtdGhpcy50aHVtYldpZHRoKTtyZXR1cm4gdD4+PTAsdDwwP3Q9MDp0PnRoaXMucGFnZVdpZHRoLXRoaXMudmlld1dpZHRoJiYodD10aGlzLnBhZ2VXaWR0aC10aGlzLnZpZXdXaWR0aCksdH0sdGhpcy5zZXRXaWR0aD1mdW5jdGlvbihlKXt0aGlzLndpZHRoPU1hdGgubWF4KDAsZSksdGhpcy5lbGVtZW50LnN0eWxlLndpZHRoPXRoaXMud2lkdGgrInB4Iix0aGlzLnNsaWRlV2lkdGg9dGhpcy53aWR0aCx0aGlzLnZpZXdXaWR0aD10aGlzLndpZHRoLHRoaXMuc2V0U2Nyb2xsV2lkdGgodGhpcy5wYWdlV2lkdGgsITApfSx0aGlzLnNldElubmVyV2lkdGg9dGhpcy5zZXRTY3JvbGxXaWR0aD1mdW5jdGlvbihlLHQpe2lmKHRoaXMucGFnZVdpZHRoPT09ZSYmIXQpcmV0dXJuO3RoaXMucGFnZVdpZHRoPWUsdGhpcy50aHVtYldpZHRoPXRoaXMuc2xpZGVXaWR0aCp0aGlzLnZpZXdXaWR0aC90aGlzLnBhZ2VXaWR0aCx0aGlzLnRodW1iV2lkdGg+dGhpcy5zbGlkZVdpZHRoJiYodGhpcy50aHVtYldpZHRoPXRoaXMuc2xpZGVXaWR0aCksdGhpcy50aHVtYldpZHRoPDE1JiYodGhpcy50aHVtYldpZHRoPTE1KSx0aGlzLmlubmVyLnN0eWxlLndpZHRoPXRoaXMudGh1bWJXaWR0aCsicHgiLHRoaXMuc2Nyb2xsTGVmdD50aGlzLnBhZ2VXaWR0aC10aGlzLnZpZXdXaWR0aCYmKHRoaXMuc2Nyb2xsTGVmdD10aGlzLnBhZ2VXaWR0aC10aGlzLnZpZXdXaWR0aCx0aGlzLnNjcm9sbExlZnQ8MCYmKHRoaXMuc2Nyb2xsTGVmdD0wKSx0aGlzLl9lbWl0KCJzY3JvbGwiLHtkYXRhOnRoaXMuc2Nyb2xsTGVmdH0pKX0sdGhpcy5zZXRTY3JvbGxMZWZ0PWZ1bmN0aW9uKGUpe3RoaXMuc2Nyb2xsTGVmdD1lLGU8MCYmKGU9MCksdGhpcy50aHVtYkxlZnQ9ZSoodGhpcy5zbGlkZVdpZHRoLXRoaXMudGh1bWJXaWR0aCkvKHRoaXMucGFnZVdpZHRoLXRoaXMudmlld1dpZHRoKSx0aGlzLmlubmVyLnN0eWxlLmxlZnQ9dGhpcy50aHVtYkxlZnQrInB4In19LmNhbGwoZi5wcm90b3R5cGUpLHQuU2Nyb2xsQmFyPWEsdC5TY3JvbGxCYXJWPWEsdC5TY3JvbGxCYXJIPWYsdC5WU2Nyb2xsQmFyPWEsdC5IU2Nyb2xsQmFyPWZ9KSxkZWZpbmUoImFjZS9yZW5kZXJsb29wIixbInJlcXVpcmUiLCJleHBvcnRzIiwibW9kdWxlIiwiYWNlL2xpYi9ldmVudCJdLGZ1bmN0aW9uKGUsdCxuKXsidXNlIHN0cmljdCI7dmFyIHI9ZSgiLi9saWIvZXZlbnQiKSxpPWZ1bmN0aW9uKGUsdCl7dGhpcy5vblJlbmRlcj1lLHRoaXMucGVuZGluZz0hMSx0aGlzLmNoYW5nZXM9MCx0aGlzLiRyZWN1cnNpb25MaW1pdD0yLHRoaXMud2luZG93PXR8fHdpbmRvdzt2YXIgbj10aGlzO3RoaXMuX2ZsdXNoPWZ1bmN0aW9uKGUpe24ucGVuZGluZz0hMTt2YXIgdD1uLmNoYW5nZXM7dCYmKHIuYmxvY2tJZGxlKDEwMCksbi5jaGFuZ2VzPTAsbi5vblJlbmRlcih0KSk7aWYobi5jaGFuZ2VzKXtpZihuLiRyZWN1cnNpb25MaW1pdC0tPDApcmV0dXJuO24uc2NoZWR1bGUoKX1lbHNlIG4uJHJlY3Vyc2lvbkxpbWl0PTJ9fTsoZnVuY3Rpb24oKXt0aGlzLnNjaGVkdWxlPWZ1bmN0aW9uKGUpe3RoaXMuY2hhbmdlcz10aGlzLmNoYW5nZXN8ZSx0aGlzLmNoYW5nZXMmJiF0aGlzLnBlbmRpbmcmJihyLm5leHRGcmFtZSh0aGlzLl9mbHVzaCksdGhpcy5wZW5kaW5nPSEwKX0sdGhpcy5jbGVhcj1mdW5jdGlvbihlKXt2YXIgdD10aGlzLmNoYW5nZXM7cmV0dXJuIHRoaXMuY2hhbmdlcz0wLHR9fSkuY2FsbChpLnByb3RvdHlwZSksdC5SZW5kZXJMb29wPWl9KSxkZWZpbmUoImFjZS9sYXllci9mb250X21ldHJpY3MiLFsicmVxdWlyZSIsImV4cG9ydHMiLCJtb2R1bGUiLCJhY2UvbGliL29vcCIsImFjZS9saWIvZG9tIiwiYWNlL2xpYi9sYW5nIiwiYWNlL2xpYi9ldmVudCIsImFjZS9saWIvdXNlcmFnZW50IiwiYWNlL2xpYi9ldmVudF9lbWl0dGVyIl0sZnVuY3Rpb24oZSx0LG4pe3ZhciByPWUoIi4uL2xpYi9vb3AiKSxpPWUoIi4uL2xpYi9kb20iKSxzPWUoIi4uL2xpYi9sYW5nIiksbz1lKCIuLi9saWIvZXZlbnQiKSx1PWUoIi4uL2xpYi91c2VyYWdlbnQiKSxhPWUoIi4uL2xpYi9ldmVudF9lbWl0dGVyIikuRXZlbnRFbWl0dGVyLGY9MjUwLGw9dHlwZW9mIFJlc2l6ZU9ic2VydmVyPT0iZnVuY3Rpb24iLGM9MjAwLGg9dC5Gb250TWV0cmljcz1mdW5jdGlvbihlLHQpe3RoaXMuY2hhckNvdW50PXR8fGYsdGhpcy5lbD1pLmNyZWF0ZUVsZW1lbnQoImRpdiIpLHRoaXMuJHNldE1lYXN1cmVOb2RlU3R5bGVzKHRoaXMuZWwuc3R5bGUsITApLHRoaXMuJG1haW49aS5jcmVhdGVFbGVtZW50KCJkaXYiKSx0aGlzLiRzZXRNZWFzdXJlTm9kZVN0eWxlcyh0aGlzLiRtYWluLnN0eWxlKSx0aGlzLiRtZWFzdXJlTm9kZT1pLmNyZWF0ZUVsZW1lbnQoImRpdiIpLHRoaXMuJHNldE1lYXN1cmVOb2RlU3R5bGVzKHRoaXMuJG1lYXN1cmVOb2RlLnN0eWxlKSx0aGlzLmVsLmFwcGVuZENoaWxkKHRoaXMuJG1haW4pLHRoaXMuZWwuYXBwZW5kQ2hpbGQodGhpcy4kbWVhc3VyZU5vZGUpLGUuYXBwZW5kQ2hpbGQodGhpcy5lbCksdGhpcy4kbWVhc3VyZU5vZGUudGV4dENvbnRlbnQ9cy5zdHJpbmdSZXBlYXQoIlgiLHRoaXMuY2hhckNvdW50KSx0aGlzLiRjaGFyYWN0ZXJTaXplPXt3aWR0aDowLGhlaWdodDowfSxsP3RoaXMuJGFkZE9ic2VydmVyKCk6dGhpcy5jaGVja0ZvclNpemVDaGFuZ2VzKCl9OyhmdW5jdGlvbigpe3IuaW1wbGVtZW50KHRoaXMsYSksdGhpcy4kY2hhcmFjdGVyU2l6ZT17d2lkdGg6MCxoZWlnaHQ6MH0sdGhpcy4kc2V0TWVhc3VyZU5vZGVTdHlsZXM9ZnVuY3Rpb24oZSx0KXtlLndpZHRoPWUuaGVpZ2h0PSJhdXRvIixlLmxlZnQ9ZS50b3A9IjBweCIsZS52aXNpYmlsaXR5PSJoaWRkZW4iLGUucG9zaXRpb249ImFic29sdXRlIixlLndoaXRlU3BhY2U9InByZSIsdS5pc0lFPDg/ZVsiZm9udC1mYW1pbHkiXT0iaW5oZXJpdCI6ZS5mb250PSJpbmhlcml0IixlLm92ZXJmbG93PXQ/ImhpZGRlbiI6InZpc2libGUifSx0aGlzLmNoZWNrRm9yU2l6ZUNoYW5nZXM9ZnVuY3Rpb24oZSl7ZT09PXVuZGVmaW5lZCYmKGU9dGhpcy4kbWVhc3VyZVNpemVzKCkpO2lmKGUmJih0aGlzLiRjaGFyYWN0ZXJTaXplLndpZHRoIT09ZS53aWR0aHx8dGhpcy4kY2hhcmFjdGVyU2l6ZS5oZWlnaHQhPT1lLmhlaWdodCkpe3RoaXMuJG1lYXN1cmVOb2RlLnN0eWxlLmZvbnRXZWlnaHQ9ImJvbGQiO3ZhciB0PXRoaXMuJG1lYXN1cmVTaXplcygpO3RoaXMuJG1lYXN1cmVOb2RlLnN0eWxlLmZvbnRXZWlnaHQ9IiIsdGhpcy4kY2hhcmFjdGVyU2l6ZT1lLHRoaXMuY2hhclNpemVzPU9iamVjdC5jcmVhdGUobnVsbCksdGhpcy5hbGxvd0JvbGRGb250cz10JiZ0LndpZHRoPT09ZS53aWR0aCYmdC5oZWlnaHQ9PT1lLmhlaWdodCx0aGlzLl9lbWl0KCJjaGFuZ2VDaGFyYWN0ZXJTaXplIix7ZGF0YTplfSl9fSx0aGlzLiRhZGRPYnNlcnZlcj1mdW5jdGlvbigpe3ZhciBlPXRoaXM7dGhpcy4kb2JzZXJ2ZXI9bmV3IHdpbmRvdy5SZXNpemVPYnNlcnZlcihmdW5jdGlvbih0KXtlLmNoZWNrRm9yU2l6ZUNoYW5nZXMoKX0pLHRoaXMuJG9ic2VydmVyLm9ic2VydmUodGhpcy4kbWVhc3VyZU5vZGUpfSx0aGlzLiRwb2xsU2l6ZUNoYW5nZXM9ZnVuY3Rpb24oKXtpZih0aGlzLiRwb2xsU2l6ZUNoYW5nZXNUaW1lcnx8dGhpcy4kb2JzZXJ2ZXIpcmV0dXJuIHRoaXMuJHBvbGxTaXplQ2hhbmdlc1RpbWVyO3ZhciBlPXRoaXM7cmV0dXJuIHRoaXMuJHBvbGxTaXplQ2hhbmdlc1RpbWVyPW8ub25JZGxlKGZ1bmN0aW9uIHQoKXtlLmNoZWNrRm9yU2l6ZUNoYW5nZXMoKSxvLm9uSWRsZSh0LDUwMCl9LDUwMCl9LHRoaXMuc2V0UG9sbGluZz1mdW5jdGlvbihlKXtlP3RoaXMuJHBvbGxTaXplQ2hhbmdlcygpOnRoaXMuJHBvbGxTaXplQ2hhbmdlc1RpbWVyJiYoY2xlYXJJbnRlcnZhbCh0aGlzLiRwb2xsU2l6ZUNoYW5nZXNUaW1lciksdGhpcy4kcG9sbFNpemVDaGFuZ2VzVGltZXI9MCl9LHRoaXMuJG1lYXN1cmVTaXplcz1mdW5jdGlvbihlKXtlPWV8fHRoaXMuJG1lYXN1cmVOb2RlO3ZhciB0PWUuZ2V0Qm91bmRpbmdDbGllbnRSZWN0KCksbj17aGVpZ2h0OnQuaGVpZ2h0LHdpZHRoOnQud2lkdGgvdGhpcy5jaGFyQ291bnR9O3JldHVybiBuLndpZHRoPT09MHx8bi5oZWlnaHQ9PT0wP251bGw6bn0sdGhpcy4kbWVhc3VyZUNoYXJXaWR0aD1mdW5jdGlvbihlKXt0aGlzLiRtYWluLnRleHRDb250ZW50PXMuc3RyaW5nUmVwZWF0KGUsdGhpcy5jaGFyQ291bnQpO3ZhciB0PXRoaXMuJG1haW4uZ2V0Qm91bmRpbmdDbGllbnRSZWN0KCk7cmV0dXJuIHQud2lkdGgvdGhpcy5jaGFyQ291bnR9LHRoaXMuZ2V0Q2hhcmFjdGVyV2lkdGg9ZnVuY3Rpb24oZSl7dmFyIHQ9dGhpcy5jaGFyU2l6ZXNbZV07cmV0dXJuIHQ9PT11bmRlZmluZWQmJih0PXRoaXMuY2hhclNpemVzW2VdPXRoaXMuJG1lYXN1cmVDaGFyV2lkdGgoZSkvdGhpcy4kY2hhcmFjdGVyU2l6ZS53aWR0aCksdH0sdGhpcy5kZXN0cm95PWZ1bmN0aW9uKCl7Y2xlYXJJbnRlcnZhbCh0aGlzLiRwb2xsU2l6ZUNoYW5nZXNUaW1lciksdGhpcy4kb2JzZXJ2ZXImJnRoaXMuJG9ic2VydmVyLmRpc2Nvbm5lY3QoKSx0aGlzLmVsJiZ0aGlzLmVsLnBhcmVudE5vZGUmJnRoaXMuZWwucGFyZW50Tm9kZS5yZW1vdmVDaGlsZCh0aGlzLmVsKX0sdGhpcy4kZ2V0Wm9vbT1mdW5jdGlvbiBlKHQpe3JldHVybiF0fHwhdC5wYXJlbnRFbGVtZW50PzE6KHdpbmRvdy5nZXRDb21wdXRlZFN0eWxlKHQpLnpvb218fDEpKmUodC5wYXJlbnRFbGVtZW50KX0sdGhpcy4kaW5pdFRyYW5zZm9ybU1lYXN1cmVOb2Rlcz1mdW5jdGlvbigpe3ZhciBlPWZ1bmN0aW9uKGUsdCl7cmV0dXJuWyJkaXYiLHtzdHlsZToicG9zaXRpb246IGFic29sdXRlO3RvcDoiK2UrInB4O2xlZnQ6Iit0KyJweDsifV19O3RoaXMuZWxzPWkuYnVpbGREb20oW2UoMCwwKSxlKGMsMCksZSgwLGMpLGUoYyxjKV0sdGhpcy5lbCl9LHRoaXMudHJhbnNmb3JtQ29vcmRpbmF0ZXM9ZnVuY3Rpb24oZSx0KXtmdW5jdGlvbiByKGUsdCxuKXt2YXIgcj1lWzFdKnRbMF0tZVswXSp0WzFdO3JldHVyblsoLXRbMV0qblswXSt0WzBdKm5bMV0pL3IsKCtlWzFdKm5bMF0tZVswXSpuWzFdKS9yXX1mdW5jdGlvbiBpKGUsdCl7cmV0dXJuW2VbMF0tdFswXSxlWzFdLXRbMV1dfWZ1bmN0aW9uIHMoZSx0KXtyZXR1cm5bZVswXSt0WzBdLGVbMV0rdFsxXV19ZnVuY3Rpb24gbyhlLHQpe3JldHVybltlKnRbMF0sZSp0WzFdXX1mdW5jdGlvbiB1KGUpe3ZhciB0PWUuZ2V0Qm91bmRpbmdDbGllbnRSZWN0KCk7cmV0dXJuW3QubGVmdCx0LnRvcF19aWYoZSl7dmFyIG49dGhpcy4kZ2V0Wm9vbSh0aGlzLmVsKTtlPW8oMS9uLGUpfXRoaXMuZWxzfHx0aGlzLiRpbml0VHJhbnNmb3JtTWVhc3VyZU5vZGVzKCk7dmFyIGE9dSh0aGlzLmVsc1swXSksZj11KHRoaXMuZWxzWzFdKSxsPXUodGhpcy5lbHNbMl0pLGg9dSh0aGlzLmVsc1szXSkscD1yKGkoaCxmKSxpKGgsbCksaShzKGYsbCkscyhoLGEpKSksZD1vKDErcFswXSxpKGYsYSkpLHY9bygxK3BbMV0saShsLGEpKTtpZih0KXt2YXIgbT10LGc9cFswXSptWzBdL2MrcFsxXSptWzFdL2MrMSx5PXMobyhtWzBdLGQpLG8obVsxXSx2KSk7cmV0dXJuIHMobygxL2cvYyx5KSxhKX12YXIgYj1pKGUsYSksdz1yKGkoZCxvKHBbMF0sYikpLGkodixvKHBbMV0sYikpLGIpO3JldHVybiBvKGMsdyl9fSkuY2FsbChoLnByb3RvdHlwZSl9KSxkZWZpbmUoImFjZS9jc3MvZWRpdG9yLmNzcyIsWyJyZXF1aXJlIiwiZXhwb3J0cyIsIm1vZHVsZSJdLGZ1bmN0aW9uKGUsdCxuKXtuLmV4cG9ydHM9Jy8qXG5zdHlsZXMgPSBbXVxuZm9yICh2YXIgaSA9IDE7IGkgPCAxNjsgaSsrKSB7XG4gICAgc3R5bGVzLnB1c2goIi5hY2VfYnIiICsgaSArICJ7IiArIChcbiAgICAgICAgWyJ0b3AtbGVmdCIsICJ0b3AtcmlnaHQiLCAiYm90dG9tLXJpZ2h0IiwgImJvdHRvbS1sZWZ0Il1cbiAgICApLm1hcChmdW5jdGlvbih4LCBqKSB7XG4gICAgICAgIHJldHVybiBpICYgKDE8PGopID8gImJvcmRlci0iICsgeCArICItcmFkaXVzOiAzcHg7IiA6ICIiIFxuICAgIH0pLmZpbHRlcihCb29sZWFuKS5qb2luKCIgIikgKyAifSIpXG59XG5zdHlsZXMuam9pbigiXFxuIilcbiovXG4uYWNlX2JyMSB7Ym9yZGVyLXRvcC1sZWZ0LXJhZGl1cyAgICA6IDNweDt9XG4uYWNlX2JyMiB7Ym9yZGVyLXRvcC1yaWdodC1yYWRpdXMgICA6IDNweDt9XG4uYWNlX2JyMyB7Ym9yZGVyLXRvcC1sZWZ0LXJhZGl1cyAgICA6IDNweDsgYm9yZGVyLXRvcC1yaWdodC1yYWRpdXM6ICAgIDNweDt9XG4uYWNlX2JyNCB7Ym9yZGVyLWJvdHRvbS1yaWdodC1yYWRpdXM6IDNweDt9XG4uYWNlX2JyNSB7Ym9yZGVyLXRvcC1sZWZ0LXJhZGl1cyAgICA6IDNweDsgYm9yZGVyLWJvdHRvbS1yaWdodC1yYWRpdXM6IDNweDt9XG4uYWNlX2JyNiB7Ym9yZGVyLXRvcC1yaWdodC1yYWRpdXMgICA6IDNweDsgYm9yZGVyLWJvdHRvbS1yaWdodC1yYWRpdXM6IDNweDt9XG4uYWNlX2JyNyB7Ym9yZGVyLXRvcC1sZWZ0LXJhZGl1cyAgICA6IDNweDsgYm9yZGVyLXRvcC1yaWdodC1yYWRpdXM6ICAgIDNweDsgYm9yZGVyLWJvdHRvbS1yaWdodC1yYWRpdXM6IDNweDt9XG4uYWNlX2JyOCB7Ym9yZGVyLWJvdHRvbS1sZWZ0LXJhZGl1cyA6IDNweDt9XG4uYWNlX2JyOSB7Ym9yZGVyLXRvcC1sZWZ0LXJhZGl1cyAgICA6IDNweDsgYm9yZGVyLWJvdHRvbS1sZWZ0LXJhZGl1czogIDNweDt9XG4uYWNlX2JyMTB7Ym9yZGVyLXRvcC1yaWdodC1yYWRpdXMgICA6IDNweDsgYm9yZGVyLWJvdHRvbS1sZWZ0LXJhZGl1czogIDNweDt9XG4uYWNlX2JyMTF7Ym9yZGVyLXRvcC1sZWZ0LXJhZGl1cyAgICA6IDNweDsgYm9yZGVyLXRvcC1yaWdodC1yYWRpdXM6ICAgIDNweDsgYm9yZGVyLWJvdHRvbS1sZWZ0LXJhZGl1czogIDNweDt9XG4uYWNlX2JyMTJ7Ym9yZGVyLWJvdHRvbS1yaWdodC1yYWRpdXM6IDNweDsgYm9yZGVyLWJvdHRvbS1sZWZ0LXJhZGl1czogIDNweDt9XG4uYWNlX2JyMTN7Ym9yZGVyLXRvcC1sZWZ0LXJhZGl1cyAgICA6IDNweDsgYm9yZGVyLWJvdHRvbS1yaWdodC1yYWRpdXM6IDNweDsgYm9yZGVyLWJvdHRvbS1sZWZ0LXJhZGl1czogIDNweDt9XG4uYWNlX2JyMTR7Ym9yZGVyLXRvcC1yaWdodC1yYWRpdXMgICA6IDNweDsgYm9yZGVyLWJvdHRvbS1yaWdodC1yYWRpdXM6IDNweDsgYm9yZGVyLWJvdHRvbS1sZWZ0LXJhZGl1czogIDNweDt9XG4uYWNlX2JyMTV7Ym9yZGVyLXRvcC1sZWZ0LXJhZGl1cyAgICA6IDNweDsgYm9yZGVyLXRvcC1yaWdodC1yYWRpdXM6ICAgIDNweDsgYm9yZGVyLWJvdHRvbS1yaWdodC1yYWRpdXM6IDNweDsgYm9yZGVyLWJvdHRvbS1sZWZ0LXJhZGl1czogM3B4O31cblxuXG4uYWNlX2VkaXRvciB7XG4gICAgcG9zaXRpb246IHJlbGF0aXZlO1xuICAgIG92ZXJmbG93OiBoaWRkZW47XG4gICAgcGFkZGluZzogMDtcbiAgICBmb250OiAxMnB4L25vcm1hbCBcJ01vbmFjb1wnLCBcJ01lbmxvXCcsIFwnVWJ1bnR1IE1vbm9cJywgXCdDb25zb2xhc1wnLCBcJ3NvdXJjZS1jb2RlLXByb1wnLCBtb25vc3BhY2U7XG4gICAgZGlyZWN0aW9uOiBsdHI7XG4gICAgdGV4dC1hbGlnbjogbGVmdDtcbiAgICAtd2Via2l0LXRhcC1oaWdobGlnaHQtY29sb3I6IHJnYmEoMCwgMCwgMCwgMCk7XG59XG5cbi5hY2Vfc2Nyb2xsZXIge1xuICAgIHBvc2l0aW9uOiBhYnNvbHV0ZTtcbiAgICBvdmVyZmxvdzogaGlkZGVuO1xuICAgIHRvcDogMDtcbiAgICBib3R0b206IDA7XG4gICAgYmFja2dyb3VuZC1jb2xvcjogaW5oZXJpdDtcbiAgICAtbXMtdXNlci1zZWxlY3Q6IG5vbmU7XG4gICAgLW1vei11c2VyLXNlbGVjdDogbm9uZTtcbiAgICAtd2Via2l0LXVzZXItc2VsZWN0OiBub25lO1xuICAgIHVzZXItc2VsZWN0OiBub25lO1xuICAgIGN1cnNvcjogdGV4dDtcbn1cblxuLmFjZV9jb250ZW50IHtcbiAgICBwb3NpdGlvbjogYWJzb2x1dGU7XG4gICAgYm94LXNpemluZzogYm9yZGVyLWJveDtcbiAgICBtaW4td2lkdGg6IDEwMCU7XG4gICAgY29udGFpbjogc3R5bGUgc2l6ZSBsYXlvdXQ7XG4gICAgZm9udC12YXJpYW50LWxpZ2F0dXJlczogbm8tY29tbW9uLWxpZ2F0dXJlcztcbn1cblxuLmFjZV9kcmFnZ2luZyAuYWNlX3Njcm9sbGVyOmJlZm9yZXtcbiAgICBwb3NpdGlvbjogYWJzb2x1dGU7XG4gICAgdG9wOiAwO1xuICAgIGxlZnQ6IDA7XG4gICAgcmlnaHQ6IDA7XG4gICAgYm90dG9tOiAwO1xuICAgIGNvbnRlbnQ6IFwnXCc7XG4gICAgYmFja2dyb3VuZDogcmdiYSgyNTAsIDI1MCwgMjUwLCAwLjAxKTtcbiAgICB6LWluZGV4OiAxMDAwO1xufVxuLmFjZV9kcmFnZ2luZy5hY2VfZGFyayAuYWNlX3Njcm9sbGVyOmJlZm9yZXtcbiAgICBiYWNrZ3JvdW5kOiByZ2JhKDAsIDAsIDAsIDAuMDEpO1xufVxuXG4uYWNlX2d1dHRlciB7XG4gICAgcG9zaXRpb246IGFic29sdXRlO1xuICAgIG92ZXJmbG93IDogaGlkZGVuO1xuICAgIHdpZHRoOiBhdXRvO1xuICAgIHRvcDogMDtcbiAgICBib3R0b206IDA7XG4gICAgbGVmdDogMDtcbiAgICBjdXJzb3I6IGRlZmF1bHQ7XG4gICAgei1pbmRleDogNDtcbiAgICAtbXMtdXNlci1zZWxlY3Q6IG5vbmU7XG4gICAgLW1vei11c2VyLXNlbGVjdDogbm9uZTtcbiAgICAtd2Via2l0LXVzZXItc2VsZWN0OiBub25lO1xuICAgIHVzZXItc2VsZWN0OiBub25lO1xuICAgIGNvbnRhaW46IHN0eWxlIHNpemUgbGF5b3V0O1xufVxuXG4uYWNlX2d1dHRlci1hY3RpdmUtbGluZSB7XG4gICAgcG9zaXRpb246IGFic29sdXRlO1xuICAgIGxlZnQ6IDA7XG4gICAgcmlnaHQ6IDA7XG59XG5cbi5hY2Vfc2Nyb2xsZXIuYWNlX3Njcm9sbC1sZWZ0IHtcbiAgICBib3gtc2hhZG93OiAxN3B4IDAgMTZweCAtMTZweCByZ2JhKDAsIDAsIDAsIDAuNCkgaW5zZXQ7XG59XG5cbi5hY2VfZ3V0dGVyLWNlbGwge1xuICAgIHBvc2l0aW9uOiBhYnNvbHV0ZTtcbiAgICB0b3A6IDA7XG4gICAgbGVmdDogMDtcbiAgICByaWdodDogMDtcbiAgICBwYWRkaW5nLWxlZnQ6IDE5cHg7XG4gICAgcGFkZGluZy1yaWdodDogNnB4O1xuICAgIGJhY2tncm91bmQtcmVwZWF0OiBuby1yZXBlYXQ7XG59XG5cbi5hY2VfZ3V0dGVyLWNlbGwuYWNlX2Vycm9yIHtcbiAgICBiYWNrZ3JvdW5kLWltYWdlOiB1cmwoImRhdGE6aW1hZ2UvcG5nO2Jhc2U2NCxpVkJPUncwS0dnb0FBQUFOU1VoRVVnQUFBQkFBQUFBUUNBTUFBQUFvTFE5VEFBQUJPRkJNVkVYLy8vLy8vLy8vUVJzd0ZBYi9VaTR3RkFZd0ZBWXdGQWFXR0FmRFJ5bXpPU0gvUHhzd0ZBYi9TaVV3RkFZd0ZBYlVQUnZqUWlEbGxvZzVIaEhkUnlic1RpMy9UeXY5VGlyK1N5ai9VQzMvLy8vWHVyZWJNQkl3RkFiL1JTSGJQeC9nVXpmZHdMM2t6TWl2S0JBd0ZBYmJ2Ym5oUHg2Nk5ob3dGQVl3RkFhWkpnOHdGQWF4S0JEWnVyZi9SQjZtTXhiL1NDTXdGQVl3RkFieFFCMytSQjR3RkFiL1FoeTRPaCs0UWlmYk5SY3dGQVl3RkFZd0ZBYi9RUnpkTmhnd0ZBWXdGQWJhdjd2L1V5N29hRTY4TUJLNUx4TGV3ci9yMk5YZXdMc3dGQWF4Snc0d0ZBYmtQUnkyUHlZd0ZBYXhLaExtMXRNd0ZBYXpQaVF3RkFhVUdBYi9RQnJmT3gzYnZydi9WQy9tYUU0d0ZBYlJQQnE2TVJPOFF5bmV3OERwMnRqZndiMHdGQWJ4NmVqdTUrYnk2dW5zNHVIOS9mMzYrdnIvR2tIakFBQUFZblJTVGxNQUd0KzY0cm5XdS9ibzhlQUE0SW5IMytEd29ON2o0ZUxpNHhQOTlOZmc0K2IrL3U5Qi9lRHMxTUQxbU83KzRQSGcyTVhhMzQ3Zzd2RGl6TUxONGVHK1B2N2k1ZXZzL3Y3OXl1N1MzL0RWNy80OThZdjI0ZUgrNHVmUTNPenUvdjcreTEzc1Jxd0FBQURMU1VSQlZIamFaYy9YRHNGZ0dJQmh0RHJzaGxpdG1rMklyYkhGcUwycHZYZi8rNzhEUG9rajcrRno5cXBVLzlVWEpJbGhtUGFUYVE2UVBhejBtbSs1Z3drZ292Y1Y2R1p6ZDVKdENRd2dzeG9IT3ZKTzE1a2xlUkxBbk1nSEZJRVNVRVBtYXdCOW5nbWVsVHRpcHd3ZkFTaWx4T0x5aVY1VVZVeVZBZmJHMGNDUEhpZytHQmt6QUVOSFMwQXN0VkY2YmFjWklPemdMbXhzSGJ0Mk9lY05nSkM4M0pFUm1lUFVZcThBUkdrSng2WHRGc2RkZEJRZ1pFMm5QUjZDSUNaaGF3akE0RmIvY2h2KzM5OWtmUitNTU1ER09RQUFBQUJKUlU1RXJrSmdnZz09Iik7XG4gICAgYmFja2dyb3VuZC1yZXBlYXQ6IG5vLXJlcGVhdDtcbiAgICBiYWNrZ3JvdW5kLXBvc2l0aW9uOiAycHggY2VudGVyO1xufVxuXG4uYWNlX2d1dHRlci1jZWxsLmFjZV93YXJuaW5nIHtcbiAgICBiYWNrZ3JvdW5kLWltYWdlOiB1cmwoImRhdGE6aW1hZ2UvcG5nO2Jhc2U2NCxpVkJPUncwS0dnb0FBQUFOU1VoRVVnQUFBQkFBQUFBUUNBTUFBQUFvTFE5VEFBQUFtVkJNVkVYLy8vOEFBQUQvLy84QUFBQUFBQUJQU3piLzVzQUFBQUIvYmxILzczei91bGtBQUFBQUFBRDg1cGtBQUFBQUFBQUNBZ1Avdkd6L3JrRGVyR2JHclY3L3BrUUlDQWYvLy8vZTBJc0FBQUQvb0VEL3FUdmhyblVBQUFEL3lIRC9uamNBQUFEdXYyci9uei8vb1RqL3AwNjRvR2YvekhBQUFBQTlOaXIvdEZJQUFBRC90bFRpdVdmL3RrSUFBQUN5blhFQUFBQUFBQUF0SVJXN3pCcEJBQUFBTTNSU1RsTUFBQlIxbTdSWE84TG4zMVozNnpUK25lWGU1T3pvb1JEZm4rVFo0cDNoMmhUZjR0M2szdWN5ck4xSzUrWGFrczUyU2ZzOUNYZ3JBQUFBamtsRVFWUjQybzNQYlErQ0lCUUZZRXdib1BoU1lnb1l1bklxcUxuNi96OHVZZEg4Vm1kbnU5dno0V3dYZ04veFRQUkQyK3NnT2NaanNnZS93aFhaZ1VhWVl2VDhRbnVKYVVyanJIVVFyZUdjenVFYWZRQ08vU0pUdWZUYnJvV3NQZ3NsbFZocTN3SkVrMmpVU3pYM0NVRURKQzg0NzA3ZGpSYzVNVEFReG9MZ3VwV1J3VzZVQjVmUysrTlY4QWJPWmduc0M3QnBFQUFBQUFCSlJVNUVya0pnZ2c9PSIpO1xuICAgIGJhY2tncm91bmQtcG9zaXRpb246IDJweCBjZW50ZXI7XG59XG5cbi5hY2VfZ3V0dGVyLWNlbGwuYWNlX2luZm8ge1xuICAgIGJhY2tncm91bmQtaW1hZ2U6IHVybCgiZGF0YTppbWFnZS9wbmc7YmFzZTY0LGlWQk9SdzBLR2dvQUFBQU5TVWhFVWdBQUFCQUFBQUFRQ0FBQUFBQTZtS0M5QUFBQUdYUkZXSFJUYjJaMGQyRnlaUUJCWkc5aVpTQkpiV0ZuWlZKbFlXUjVjY2xsUEFBQUFBSjBVazVUQUFCMms4MDRBQUFBUGtsRVFWUVkwMk5nSUI2OFF1TzN0aUx6bmpBd3BLVGdOeURiTWVnd2lzQ0haVUVUVVpWMFpxT3F1QnBYajJydG5wU0pUMUFFbm5SbUwyT2dHZ0FBSUtrUlFhcDJodGdBQUFBQVNVVk9SSzVDWUlJPSIpO1xuICAgIGJhY2tncm91bmQtcG9zaXRpb246IDJweCBjZW50ZXI7XG59XG4uYWNlX2RhcmsgLmFjZV9ndXR0ZXItY2VsbC5hY2VfaW5mbyB7XG4gICAgYmFja2dyb3VuZC1pbWFnZTogdXJsKCJkYXRhOmltYWdlL3BuZztiYXNlNjQsaVZCT1J3MEtHZ29BQUFBTlNVaEVVZ0FBQUJBQUFBQVFCQU1BQUFEdDNlSlNBQUFBSkZCTVZFVUFBQUNob2FHQWdJQXFLaXErdnI2dHJhMVpXVm1VbEpTYm01czhQRHh1Ym01NmVucmRnemczQUFBQUFYUlNUbE1BUU9iWVpnQUFBQ2xKUkVGVWVOcGpZTUFQZHNNWUhlZ3lKWkZRQmxzVWxNRlZDV1VZS2tBWk14WkFHZHhsRE1RQkFHK1RCUDRCNlJ5SkFBQUFBRWxGVGtTdVFtQ0MiKTtcbn1cblxuLmFjZV9zY3JvbGxiYXIge1xuICAgIGNvbnRhaW46IHN0cmljdDtcbiAgICBwb3NpdGlvbjogYWJzb2x1dGU7XG4gICAgcmlnaHQ6IDA7XG4gICAgYm90dG9tOiAwO1xuICAgIHotaW5kZXg6IDY7XG59XG5cbi5hY2Vfc2Nyb2xsYmFyLWlubmVyIHtcbiAgICBwb3NpdGlvbjogYWJzb2x1dGU7XG4gICAgY3Vyc29yOiB0ZXh0O1xuICAgIGxlZnQ6IDA7XG4gICAgdG9wOiAwO1xufVxuXG4uYWNlX3Njcm9sbGJhci12e1xuICAgIG92ZXJmbG93LXg6IGhpZGRlbjtcbiAgICBvdmVyZmxvdy15OiBzY3JvbGw7XG4gICAgdG9wOiAwO1xufVxuXG4uYWNlX3Njcm9sbGJhci1oIHtcbiAgICBvdmVyZmxvdy14OiBzY3JvbGw7XG4gICAgb3ZlcmZsb3cteTogaGlkZGVuO1xuICAgIGxlZnQ6IDA7XG59XG5cbi5hY2VfcHJpbnQtbWFyZ2luIHtcbiAgICBwb3NpdGlvbjogYWJzb2x1dGU7XG4gICAgaGVpZ2h0OiAxMDAlO1xufVxuXG4uYWNlX3RleHQtaW5wdXQge1xuICAgIHBvc2l0aW9uOiBhYnNvbHV0ZTtcbiAgICB6LWluZGV4OiAwO1xuICAgIHdpZHRoOiAwLjVlbTtcbiAgICBoZWlnaHQ6IDFlbTtcbiAgICBvcGFjaXR5OiAwO1xuICAgIGJhY2tncm91bmQ6IHRyYW5zcGFyZW50O1xuICAgIC1tb3otYXBwZWFyYW5jZTogbm9uZTtcbiAgICBhcHBlYXJhbmNlOiBub25lO1xuICAgIGJvcmRlcjogbm9uZTtcbiAgICByZXNpemU6IG5vbmU7XG4gICAgb3V0bGluZTogbm9uZTtcbiAgICBvdmVyZmxvdzogaGlkZGVuO1xuICAgIGZvbnQ6IGluaGVyaXQ7XG4gICAgcGFkZGluZzogMCAxcHg7XG4gICAgbWFyZ2luOiAwIC0xcHg7XG4gICAgY29udGFpbjogc3RyaWN0O1xuICAgIC1tcy11c2VyLXNlbGVjdDogdGV4dDtcbiAgICAtbW96LXVzZXItc2VsZWN0OiB0ZXh0O1xuICAgIC13ZWJraXQtdXNlci1zZWxlY3Q6IHRleHQ7XG4gICAgdXNlci1zZWxlY3Q6IHRleHQ7XG4gICAgLyp3aXRoIGBwcmUtbGluZWAgY2hyb21lIGluc2VydHMgJm5ic3A7IGluc3RlYWQgb2Ygc3BhY2UqL1xuICAgIHdoaXRlLXNwYWNlOiBwcmUhaW1wb3J0YW50O1xufVxuLmFjZV90ZXh0LWlucHV0LmFjZV9jb21wb3NpdGlvbiB7XG4gICAgYmFja2dyb3VuZDogdHJhbnNwYXJlbnQ7XG4gICAgY29sb3I6IGluaGVyaXQ7XG4gICAgei1pbmRleDogMTAwMDtcbiAgICBvcGFjaXR5OiAxO1xufVxuLmFjZV9jb21wb3NpdGlvbl9wbGFjZWhvbGRlciB7IGNvbG9yOiB0cmFuc3BhcmVudCB9XG4uYWNlX2NvbXBvc2l0aW9uX21hcmtlciB7IFxuICAgIGJvcmRlci1ib3R0b206IDFweCBzb2xpZDtcbiAgICBwb3NpdGlvbjogYWJzb2x1dGU7XG4gICAgYm9yZGVyLXJhZGl1czogMDtcbiAgICBtYXJnaW4tdG9wOiAxcHg7XG59XG5cblthY2Vfbm9jb250ZXh0PXRydWVdIHtcbiAgICB0cmFuc2Zvcm06IG5vbmUhaW1wb3J0YW50O1xuICAgIGZpbHRlcjogbm9uZSFpbXBvcnRhbnQ7XG4gICAgY2xpcC1wYXRoOiBub25lIWltcG9ydGFudDtcbiAgICBtYXNrIDogbm9uZSFpbXBvcnRhbnQ7XG4gICAgY29udGFpbjogbm9uZSFpbXBvcnRhbnQ7XG4gICAgcGVyc3BlY3RpdmU6IG5vbmUhaW1wb3J0YW50O1xuICAgIG1peC1ibGVuZC1tb2RlOiBpbml0aWFsIWltcG9ydGFudDtcbiAgICB6LWluZGV4OiBhdXRvO1xufVxuXG4uYWNlX2xheWVyIHtcbiAgICB6LWluZGV4OiAxO1xuICAgIHBvc2l0aW9uOiBhYnNvbHV0ZTtcbiAgICBvdmVyZmxvdzogaGlkZGVuO1xuICAgIC8qIHdvcmthcm91bmQgZm9yIGNocm9tZSBidWcgaHR0cHM6Ly9naXRodWIuY29tL2FqYXhvcmcvYWNlL2lzc3Vlcy8yMzEyKi9cbiAgICB3b3JkLXdyYXA6IG5vcm1hbDtcbiAgICB3aGl0ZS1zcGFjZTogcHJlO1xuICAgIGhlaWdodDogMTAwJTtcbiAgICB3aWR0aDogMTAwJTtcbiAgICBib3gtc2l6aW5nOiBib3JkZXItYm94O1xuICAgIC8qIHNldHRpbmcgcG9pbnRlci1ldmVudHM6IGF1dG87IG9uIG5vZGUgdW5kZXIgdGhlIG1vdXNlLCB3aGljaCBjaGFuZ2VzXG4gICAgICAgIGR1cmluZyBzY3JvbGwsIHdpbGwgYnJlYWsgbW91c2Ugd2hlZWwgc2Nyb2xsaW5nIGluIFNhZmFyaSAqL1xuICAgIHBvaW50ZXItZXZlbnRzOiBub25lO1xufVxuXG4uYWNlX2d1dHRlci1sYXllciB7XG4gICAgcG9zaXRpb246IHJlbGF0aXZlO1xuICAgIHdpZHRoOiBhdXRvO1xuICAgIHRleHQtYWxpZ246IHJpZ2h0O1xuICAgIHBvaW50ZXItZXZlbnRzOiBhdXRvO1xuICAgIGhlaWdodDogMTAwMDAwMHB4O1xuICAgIGNvbnRhaW46IHN0eWxlIHNpemUgbGF5b3V0O1xufVxuXG4uYWNlX3RleHQtbGF5ZXIge1xuICAgIGZvbnQ6IGluaGVyaXQgIWltcG9ydGFudDtcbiAgICBwb3NpdGlvbjogYWJzb2x1dGU7XG4gICAgaGVpZ2h0OiAxMDAwMDAwcHg7XG4gICAgd2lkdGg6IDEwMDAwMDBweDtcbiAgICBjb250YWluOiBzdHlsZSBzaXplIGxheW91dDtcbn1cblxuLmFjZV90ZXh0LWxheWVyID4gLmFjZV9saW5lLCAuYWNlX3RleHQtbGF5ZXIgPiAuYWNlX2xpbmVfZ3JvdXAge1xuICAgIGNvbnRhaW46IHN0eWxlIHNpemUgbGF5b3V0O1xuICAgIHBvc2l0aW9uOiBhYnNvbHV0ZTtcbiAgICB0b3A6IDA7XG4gICAgbGVmdDogMDtcbiAgICByaWdodDogMDtcbn1cblxuLmFjZV9oaWRwaSAuYWNlX3RleHQtbGF5ZXIsXG4uYWNlX2hpZHBpIC5hY2VfZ3V0dGVyLWxheWVyLFxuLmFjZV9oaWRwaSAuYWNlX2NvbnRlbnQsXG4uYWNlX2hpZHBpIC5hY2VfZ3V0dGVyIHtcbiAgICBjb250YWluOiBzdHJpY3Q7XG4gICAgd2lsbC1jaGFuZ2U6IHRyYW5zZm9ybTtcbn1cbi5hY2VfaGlkcGkgLmFjZV90ZXh0LWxheWVyID4gLmFjZV9saW5lLCBcbi5hY2VfaGlkcGkgLmFjZV90ZXh0LWxheWVyID4gLmFjZV9saW5lX2dyb3VwIHtcbiAgICBjb250YWluOiBzdHJpY3Q7XG59XG5cbi5hY2VfY2prIHtcbiAgICBkaXNwbGF5OiBpbmxpbmUtYmxvY2s7XG4gICAgdGV4dC1hbGlnbjogY2VudGVyO1xufVxuXG4uYWNlX2N1cnNvci1sYXllciB7XG4gICAgei1pbmRleDogNDtcbn1cblxuLmFjZV9jdXJzb3Ige1xuICAgIHotaW5kZXg6IDQ7XG4gICAgcG9zaXRpb246IGFic29sdXRlO1xuICAgIGJveC1zaXppbmc6IGJvcmRlci1ib3g7XG4gICAgYm9yZGVyLWxlZnQ6IDJweCBzb2xpZDtcbiAgICAvKiB3b3JrYXJvdW5kIGZvciBzbW9vdGggY3Vyc29yIHJlcGFpbnRuZyB3aG9sZSBzY3JlZW4gaW4gY2hyb21lICovXG4gICAgdHJhbnNmb3JtOiB0cmFuc2xhdGV6KDApO1xufVxuXG4uYWNlX211bHRpc2VsZWN0IC5hY2VfY3Vyc29yIHtcbiAgICBib3JkZXItbGVmdC13aWR0aDogMXB4O1xufVxuXG4uYWNlX3NsaW0tY3Vyc29ycyAuYWNlX2N1cnNvciB7XG4gICAgYm9yZGVyLWxlZnQtd2lkdGg6IDFweDtcbn1cblxuLmFjZV9vdmVyd3JpdGUtY3Vyc29ycyAuYWNlX2N1cnNvciB7XG4gICAgYm9yZGVyLWxlZnQtd2lkdGg6IDA7XG4gICAgYm9yZGVyLWJvdHRvbTogMXB4IHNvbGlkO1xufVxuXG4uYWNlX2hpZGRlbi1jdXJzb3JzIC5hY2VfY3Vyc29yIHtcbiAgICBvcGFjaXR5OiAwLjI7XG59XG5cbi5hY2VfaGFzUGxhY2Vob2xkZXIgLmFjZV9oaWRkZW4tY3Vyc29ycyAuYWNlX2N1cnNvciB7XG4gICAgb3BhY2l0eTogMDtcbn1cblxuLmFjZV9zbW9vdGgtYmxpbmtpbmcgLmFjZV9jdXJzb3Ige1xuICAgIHRyYW5zaXRpb246IG9wYWNpdHkgMC4xOHM7XG59XG5cbi5hY2VfYW5pbWF0ZS1ibGlua2luZyAuYWNlX2N1cnNvciB7XG4gICAgYW5pbWF0aW9uLWR1cmF0aW9uOiAxMDAwbXM7XG4gICAgYW5pbWF0aW9uLXRpbWluZy1mdW5jdGlvbjogc3RlcC1lbmQ7XG4gICAgYW5pbWF0aW9uLW5hbWU6IGJsaW5rLWFjZS1hbmltYXRlO1xuICAgIGFuaW1hdGlvbi1pdGVyYXRpb24tY291bnQ6IGluZmluaXRlO1xufVxuXG4uYWNlX2FuaW1hdGUtYmxpbmtpbmcuYWNlX3Ntb290aC1ibGlua2luZyAuYWNlX2N1cnNvciB7XG4gICAgYW5pbWF0aW9uLWR1cmF0aW9uOiAxMDAwbXM7XG4gICAgYW5pbWF0aW9uLXRpbWluZy1mdW5jdGlvbjogZWFzZS1pbi1vdXQ7XG4gICAgYW5pbWF0aW9uLW5hbWU6IGJsaW5rLWFjZS1hbmltYXRlLXNtb290aDtcbn1cbiAgICBcbkBrZXlmcmFtZXMgYmxpbmstYWNlLWFuaW1hdGUge1xuICAgIGZyb20sIHRvIHsgb3BhY2l0eTogMTsgfVxuICAgIDYwJSB7IG9wYWNpdHk6IDA7IH1cbn1cblxuQGtleWZyYW1lcyBibGluay1hY2UtYW5pbWF0ZS1zbW9vdGgge1xuICAgIGZyb20sIHRvIHsgb3BhY2l0eTogMTsgfVxuICAgIDQ1JSB7IG9wYWNpdHk6IDE7IH1cbiAgICA2MCUgeyBvcGFjaXR5OiAwOyB9XG4gICAgODUlIHsgb3BhY2l0eTogMDsgfVxufVxuXG4uYWNlX21hcmtlci1sYXllciAuYWNlX3N0ZXAsIC5hY2VfbWFya2VyLWxheWVyIC5hY2Vfc3RhY2sge1xuICAgIHBvc2l0aW9uOiBhYnNvbHV0ZTtcbiAgICB6LWluZGV4OiAzO1xufVxuXG4uYWNlX21hcmtlci1sYXllciAuYWNlX3NlbGVjdGlvbiB7XG4gICAgcG9zaXRpb246IGFic29sdXRlO1xuICAgIHotaW5kZXg6IDU7XG59XG5cbi5hY2VfbWFya2VyLWxheWVyIC5hY2VfYnJhY2tldCB7XG4gICAgcG9zaXRpb246IGFic29sdXRlO1xuICAgIHotaW5kZXg6IDY7XG59XG5cbi5hY2VfbWFya2VyLWxheWVyIC5hY2VfZXJyb3JfYnJhY2tldCB7XG4gICAgcG9zaXRpb246IGFic29sdXRlO1xuICAgIGJvcmRlci1ib3R0b206IDFweCBzb2xpZCAjREU1NTU1O1xuICAgIGJvcmRlci1yYWRpdXM6IDA7XG59XG5cbi5hY2VfbWFya2VyLWxheWVyIC5hY2VfYWN0aXZlLWxpbmUge1xuICAgIHBvc2l0aW9uOiBhYnNvbHV0ZTtcbiAgICB6LWluZGV4OiAyO1xufVxuXG4uYWNlX21hcmtlci1sYXllciAuYWNlX3NlbGVjdGVkLXdvcmQge1xuICAgIHBvc2l0aW9uOiBhYnNvbHV0ZTtcbiAgICB6LWluZGV4OiA0O1xuICAgIGJveC1zaXppbmc6IGJvcmRlci1ib3g7XG59XG5cbi5hY2VfbGluZSAuYWNlX2ZvbGQge1xuICAgIGJveC1zaXppbmc6IGJvcmRlci1ib3g7XG5cbiAgICBkaXNwbGF5OiBpbmxpbmUtYmxvY2s7XG4gICAgaGVpZ2h0OiAxMXB4O1xuICAgIG1hcmdpbi10b3A6IC0ycHg7XG4gICAgdmVydGljYWwtYWxpZ246IG1pZGRsZTtcblxuICAgIGJhY2tncm91bmQtaW1hZ2U6XG4gICAgICAgIHVybCgiZGF0YTppbWFnZS9wbmc7YmFzZTY0LGlWQk9SdzBLR2dvQUFBQU5TVWhFVWdBQUFCRUFBQUFKQ0FZQUFBRFU2TWNNQUFBQUdYUkZXSFJUYjJaMGQyRnlaUUJCWkc5aVpTQkpiV0ZuWlZKbFlXUjVjY2xsUEFBQUFKcEpSRUZVZU5waS9QLy9Qd09sZ0FYR1lHUmtsQVZTb2tEOEdtandZMXdhc0tsalFwWUFDdHBDRmVBRGNIVlFmUXlNUUF3endBWkkzd0pLdkNMa2ZLQmFNU0NsQmxSN0JPUWlrQ0ZHUUVFcklIMFZxa2FiaUdDQXF3VWFkQXpaSlJ4UXIvMGd3aVhJYWw4elFRUG5OVlRnSjFUZGF3TDBUNWdCSVAxTVVKTmhCdjJIS29RSEhqcU5yQTRXTzR6WTBnbHlOS0xUMktJZklNQUFRc2RnR2lYdmduWUFBQUFBU1VWT1JLNUNZSUk9IiksXG4gICAgICAgIHVybCgiZGF0YTppbWFnZS9wbmc7YmFzZTY0LGlWQk9SdzBLR2dvQUFBQU5TVWhFVWdBQUFBRUFBQUEzQ0FZQUFBRE5OaUE1QUFBQUdYUkZXSFJUYjJaMGQyRnlaUUJCWkc5aVpTQkpiV0ZuWlZKbFlXUjVjY2xsUEFBQUFDSkpSRUZVZU5waStQLy9meGdUQXdQREJ4RHhEMDc4UlNYK1llRXlERk1DSU1BQUkzSU5tWGl3ZjJZQUFBQUFTVVZPUks1Q1lJST0iKTtcbiAgICBiYWNrZ3JvdW5kLXJlcGVhdDogbm8tcmVwZWF0LCByZXBlYXQteDtcbiAgICBiYWNrZ3JvdW5kLXBvc2l0aW9uOiBjZW50ZXIgY2VudGVyLCB0b3AgbGVmdDtcbiAgICBjb2xvcjogdHJhbnNwYXJlbnQ7XG5cbiAgICBib3JkZXI6IDFweCBzb2xpZCBibGFjaztcbiAgICBib3JkZXItcmFkaXVzOiAycHg7XG5cbiAgICBjdXJzb3I6IHBvaW50ZXI7XG4gICAgcG9pbnRlci1ldmVudHM6IGF1dG87XG59XG5cbi5hY2VfZGFyayAuYWNlX2ZvbGQge1xufVxuXG4uYWNlX2ZvbGQ6aG92ZXJ7XG4gICAgYmFja2dyb3VuZC1pbWFnZTpcbiAgICAgICAgdXJsKCJkYXRhOmltYWdlL3BuZztiYXNlNjQsaVZCT1J3MEtHZ29BQUFBTlNVaEVVZ0FBQUJFQUFBQUpDQVlBQUFEVTZNY01BQUFBR1hSRldIUlRiMlowZDJGeVpRQkJaRzlpWlNCSmJXRm5aVkpsWVdSNWNjbGxQQUFBQUpwSlJFRlVlTnBpL1AvL1B3T2xnQVhHWUdSa2xBVlNva0Q4R21qd1kxd2FzS2xqUXBZQUN0cENGZUFEY0hWUWZReU1RQXd6d0FaSTN3Skt2Q0xrZktCYU1TQ2xCbFI3Qk9RaWtDRkdRRUVySUgwVnFrYWJpR0NBcXdVYWRBelpKUnhRci8wZ3dpWElhbDh6UVFQbk5WVGdKMVRkYXdMMFQ1Z0JJUDFNVUpOaEJ2MkhLb1FISGpxTnJBNFdPNHpZMGdseU5LTFQyS0lmSU1BQVFzZGdHaVh2Z25ZQUFBQUFTVVZPUks1Q1lJST0iKSxcbiAgICAgICAgdXJsKCJkYXRhOmltYWdlL3BuZztiYXNlNjQsaVZCT1J3MEtHZ29BQUFBTlNVaEVVZ0FBQUFFQUFBQTNDQVlBQUFETk5pQTVBQUFBR1hSRldIUlRiMlowZDJGeVpRQkJaRzlpWlNCSmJXRm5aVkpsWVdSNWNjbGxQQUFBQUNCSlJFRlVlTnBpK1AvL2Z6NFRBd1BEWnhEeEQ1WDRpNWZMTUV3SmdBQURBRVBWRGJqTnc4N1pBQUFBQUVsRlRrU3VRbUNDIik7XG59XG5cbi5hY2VfdG9vbHRpcCB7XG4gICAgYmFja2dyb3VuZC1jb2xvcjogI0ZGRjtcbiAgICBiYWNrZ3JvdW5kLWltYWdlOiBsaW5lYXItZ3JhZGllbnQodG8gYm90dG9tLCB0cmFuc3BhcmVudCwgcmdiYSgwLCAwLCAwLCAwLjEpKTtcbiAgICBib3JkZXI6IDFweCBzb2xpZCBncmF5O1xuICAgIGJvcmRlci1yYWRpdXM6IDFweDtcbiAgICBib3gtc2hhZG93OiAwIDFweCAycHggcmdiYSgwLCAwLCAwLCAwLjMpO1xuICAgIGNvbG9yOiBibGFjaztcbiAgICBtYXgtd2lkdGg6IDEwMCU7XG4gICAgcGFkZGluZzogM3B4IDRweDtcbiAgICBwb3NpdGlvbjogZml4ZWQ7XG4gICAgei1pbmRleDogOTk5OTk5O1xuICAgIGJveC1zaXppbmc6IGJvcmRlci1ib3g7XG4gICAgY3Vyc29yOiBkZWZhdWx0O1xuICAgIHdoaXRlLXNwYWNlOiBwcmU7XG4gICAgd29yZC13cmFwOiBicmVhay13b3JkO1xuICAgIGxpbmUtaGVpZ2h0OiBub3JtYWw7XG4gICAgZm9udC1zdHlsZTogbm9ybWFsO1xuICAgIGZvbnQtd2VpZ2h0OiBub3JtYWw7XG4gICAgbGV0dGVyLXNwYWNpbmc6IG5vcm1hbDtcbiAgICBwb2ludGVyLWV2ZW50czogbm9uZTtcbn1cblxuLmFjZV9mb2xkaW5nLWVuYWJsZWQgPiAuYWNlX2d1dHRlci1jZWxsIHtcbiAgICBwYWRkaW5nLXJpZ2h0OiAxM3B4O1xufVxuXG4uYWNlX2ZvbGQtd2lkZ2V0IHtcbiAgICBib3gtc2l6aW5nOiBib3JkZXItYm94O1xuXG4gICAgbWFyZ2luOiAwIC0xMnB4IDAgMXB4O1xuICAgIGRpc3BsYXk6IG5vbmU7XG4gICAgd2lkdGg6IDExcHg7XG4gICAgdmVydGljYWwtYWxpZ246IHRvcDtcblxuICAgIGJhY2tncm91bmQtaW1hZ2U6IHVybCgiZGF0YTppbWFnZS9wbmc7YmFzZTY0LGlWQk9SdzBLR2dvQUFBQU5TVWhFVWdBQUFBVUFBQUFGQ0FZQUFBQ05ieWJsQUFBQU5FbEVRVlI0Mm1XS3NRMEFNQXpDOGl4TGxyelFqem1CaUVqcDBBNld3QkNTUGdLQVhvTGtxU290N25OM3lNd1I3cFozMk56cEtrVm9EQlV4S0FBQUFBQkpSVTVFcmtKZ2dnPT0iKTtcbiAgICBiYWNrZ3JvdW5kLXJlcGVhdDogbm8tcmVwZWF0O1xuICAgIGJhY2tncm91bmQtcG9zaXRpb246IGNlbnRlcjtcblxuICAgIGJvcmRlci1yYWRpdXM6IDNweDtcbiAgICBcbiAgICBib3JkZXI6IDFweCBzb2xpZCB0cmFuc3BhcmVudDtcbiAgICBjdXJzb3I6IHBvaW50ZXI7XG59XG5cbi5hY2VfZm9sZGluZy1lbmFibGVkIC5hY2VfZm9sZC13aWRnZXQge1xuICAgIGRpc3BsYXk6IGlubGluZS1ibG9jazsgICBcbn1cblxuLmFjZV9mb2xkLXdpZGdldC5hY2VfZW5kIHtcbiAgICBiYWNrZ3JvdW5kLWltYWdlOiB1cmwoImRhdGE6aW1hZ2UvcG5nO2Jhc2U2NCxpVkJPUncwS0dnb0FBQUFOU1VoRVVnQUFBQVVBQUFBRkNBWUFBQUNOYnlibEFBQUFORWxFUVZSNDJtM0h3UWtBTUFoRDBZenNSY2hGS0k3c0Fpa2VXa3J4d1NjRUIwbmg1ZTdLVFBXaW1aa2k0dFlmVmJYK01ObDRweVpYZWpVTzFRQUFBQUJKUlU1RXJrSmdnZz09Iik7XG59XG5cbi5hY2VfZm9sZC13aWRnZXQuYWNlX2Nsb3NlZCB7XG4gICAgYmFja2dyb3VuZC1pbWFnZTogdXJsKCJkYXRhOmltYWdlL3BuZztiYXNlNjQsaVZCT1J3MEtHZ29BQUFBTlNVaEVVZ0FBQUFNQUFBQUdDQVlBQUFBRzVTUU1BQUFBT1VsRVFWUjQyalhLd1FrQU1BZ0R3S3dxS0Q0RXdRMjZzU09rVldqZ0lJSEF6UGlDZ2FxaXFuSkhabktJQ0JFUkhOMTk0TzViOXZiTHVBVlJMK2wwWVduWkFBQUFBRWxGVGtTdVFtQ0NYQT09Iik7XG59XG5cbi5hY2VfZm9sZC13aWRnZXQ6aG92ZXIge1xuICAgIGJvcmRlcjogMXB4IHNvbGlkIHJnYmEoMCwgMCwgMCwgMC4zKTtcbiAgICBiYWNrZ3JvdW5kLWNvbG9yOiByZ2JhKDI1NSwgMjU1LCAyNTUsIDAuMik7XG4gICAgYm94LXNoYWRvdzogMCAxcHggMXB4IHJnYmEoMjU1LCAyNTUsIDI1NSwgMC43KTtcbn1cblxuLmFjZV9mb2xkLXdpZGdldDphY3RpdmUge1xuICAgIGJvcmRlcjogMXB4IHNvbGlkIHJnYmEoMCwgMCwgMCwgMC40KTtcbiAgICBiYWNrZ3JvdW5kLWNvbG9yOiByZ2JhKDAsIDAsIDAsIDAuMDUpO1xuICAgIGJveC1zaGFkb3c6IDAgMXB4IDFweCByZ2JhKDI1NSwgMjU1LCAyNTUsIDAuOCk7XG59XG4vKipcbiAqIERhcmsgdmVyc2lvbiBmb3IgZm9sZCB3aWRnZXRzXG4gKi9cbi5hY2VfZGFyayAuYWNlX2ZvbGQtd2lkZ2V0IHtcbiAgICBiYWNrZ3JvdW5kLWltYWdlOiB1cmwoImRhdGE6aW1hZ2UvcG5nO2Jhc2U2NCxpVkJPUncwS0dnb0FBQUFOU1VoRVVnQUFBQVVBQUFBRkNBWUFBQUNOYnlibEFBQUFIa2xFUVZRSVcyUDQvLzgvQXpvR0VRN29HQ2FMTEFoV2lTd0IxNDZCQVFDU1RQWW9jcVQwQUFBQUFFbEZUa1N1UW1DQyIpO1xufVxuLmFjZV9kYXJrIC5hY2VfZm9sZC13aWRnZXQuYWNlX2VuZCB7XG4gICAgYmFja2dyb3VuZC1pbWFnZTogdXJsKCJkYXRhOmltYWdlL3BuZztiYXNlNjQsaVZCT1J3MEtHZ29BQUFBTlNVaEVVZ0FBQUFVQUFBQUZDQVlBQUFDTmJ5YmxBQUFBSDBsRVFWUUlXMlA0Ly84L0F4UTd3TmpJQWpETWdDNEF4akNWS0JpcklBQUYwa3oycmxoeHBBQUFBQUJKUlU1RXJrSmdnZz09Iik7XG59XG4uYWNlX2RhcmsgLmFjZV9mb2xkLXdpZGdldC5hY2VfY2xvc2VkIHtcbiAgICBiYWNrZ3JvdW5kLWltYWdlOiB1cmwoImRhdGE6aW1hZ2UvcG5nO2Jhc2U2NCxpVkJPUncwS0dnb0FBQUFOU1VoRVVnQUFBQU1BQUFBRkNBWUFBQUNBY1ZhaUFBQUFIRWxFUVZRSVcyUDQvLysvQXhBemdEQURsT09Bem5IQUtnUFdBd0FSamk4VUlEVGZRUUFBQUFCSlJVNUVya0pnZ2c9PSIpO1xufVxuLmFjZV9kYXJrIC5hY2VfZm9sZC13aWRnZXQ6aG92ZXIge1xuICAgIGJveC1zaGFkb3c6IDAgMXB4IDFweCByZ2JhKDI1NSwgMjU1LCAyNTUsIDAuMik7XG4gICAgYmFja2dyb3VuZC1jb2xvcjogcmdiYSgyNTUsIDI1NSwgMjU1LCAwLjEpO1xufVxuLmFjZV9kYXJrIC5hY2VfZm9sZC13aWRnZXQ6YWN0aXZlIHtcbiAgICBib3gtc2hhZG93OiAwIDFweCAxcHggcmdiYSgyNTUsIDI1NSwgMjU1LCAwLjIpO1xufVxuXG4uYWNlX2lubGluZV9idXR0b24ge1xuICAgIGJvcmRlcjogMXB4IHNvbGlkIGxpZ2h0Z3JheTtcbiAgICBkaXNwbGF5OiBpbmxpbmUtYmxvY2s7XG4gICAgbWFyZ2luOiAtMXB4IDhweDtcbiAgICBwYWRkaW5nOiAwIDVweDtcbiAgICBwb2ludGVyLWV2ZW50czogYXV0bztcbiAgICBjdXJzb3I6IHBvaW50ZXI7XG59XG4uYWNlX2lubGluZV9idXR0b246aG92ZXIge1xuICAgIGJvcmRlci1jb2xvcjogZ3JheTtcbiAgICBiYWNrZ3JvdW5kOiByZ2JhKDIwMCwyMDAsMjAwLDAuMik7XG4gICAgZGlzcGxheTogaW5saW5lLWJsb2NrO1xuICAgIHBvaW50ZXItZXZlbnRzOiBhdXRvO1xufVxuXG4uYWNlX2ZvbGQtd2lkZ2V0LmFjZV9pbnZhbGlkIHtcbiAgICBiYWNrZ3JvdW5kLWNvbG9yOiAjRkZCNEI0O1xuICAgIGJvcmRlci1jb2xvcjogI0RFNTU1NTtcbn1cblxuLmFjZV9mYWRlLWZvbGQtd2lkZ2V0cyAuYWNlX2ZvbGQtd2lkZ2V0IHtcbiAgICB0cmFuc2l0aW9uOiBvcGFjaXR5IDAuNHMgZWFzZSAwLjA1cztcbiAgICBvcGFjaXR5OiAwO1xufVxuXG4uYWNlX2ZhZGUtZm9sZC13aWRnZXRzOmhvdmVyIC5hY2VfZm9sZC13aWRnZXQge1xuICAgIHRyYW5zaXRpb246IG9wYWNpdHkgMC4wNXMgZWFzZSAwLjA1cztcbiAgICBvcGFjaXR5OjE7XG59XG5cbi5hY2VfdW5kZXJsaW5lIHtcbiAgICB0ZXh0LWRlY29yYXRpb246IHVuZGVybGluZTtcbn1cblxuLmFjZV9ib2xkIHtcbiAgICBmb250LXdlaWdodDogYm9sZDtcbn1cblxuLmFjZV9ub2JvbGQgLmFjZV9ib2xkIHtcbiAgICBmb250LXdlaWdodDogbm9ybWFsO1xufVxuXG4uYWNlX2l0YWxpYyB7XG4gICAgZm9udC1zdHlsZTogaXRhbGljO1xufVxuXG5cbi5hY2VfZXJyb3ItbWFya2VyIHtcbiAgICBiYWNrZ3JvdW5kLWNvbG9yOiByZ2JhKDI1NSwgMCwgMCwwLjIpO1xuICAgIHBvc2l0aW9uOiBhYnNvbHV0ZTtcbiAgICB6LWluZGV4OiA5O1xufVxuXG4uYWNlX2hpZ2hsaWdodC1tYXJrZXIge1xuICAgIGJhY2tncm91bmQtY29sb3I6IHJnYmEoMjU1LCAyNTUsIDAsMC4yKTtcbiAgICBwb3NpdGlvbjogYWJzb2x1dGU7XG4gICAgei1pbmRleDogODtcbn1cblxuLmFjZV9tb2JpbGUtbWVudSB7XG4gICAgcG9zaXRpb246IGFic29sdXRlO1xuICAgIGxpbmUtaGVpZ2h0OiAxLjU7XG4gICAgYm9yZGVyLXJhZGl1czogNHB4O1xuICAgIC1tcy11c2VyLXNlbGVjdDogbm9uZTtcbiAgICAtbW96LXVzZXItc2VsZWN0OiBub25lO1xuICAgIC13ZWJraXQtdXNlci1zZWxlY3Q6IG5vbmU7XG4gICAgdXNlci1zZWxlY3Q6IG5vbmU7XG4gICAgYmFja2dyb3VuZDogd2hpdGU7XG4gICAgYm94LXNoYWRvdzogMXB4IDNweCAycHggZ3JleTtcbiAgICBib3JkZXI6IDFweCBzb2xpZCAjZGNkY2RjO1xuICAgIGNvbG9yOiBibGFjaztcbn1cbi5hY2VfZGFyayA+IC5hY2VfbW9iaWxlLW1lbnUge1xuICAgIGJhY2tncm91bmQ6ICMzMzM7XG4gICAgY29sb3I6ICNjY2M7XG4gICAgYm94LXNoYWRvdzogMXB4IDNweCAycHggZ3JleTtcbiAgICBib3JkZXI6IDFweCBzb2xpZCAjNDQ0O1xuXG59XG4uYWNlX21vYmlsZS1idXR0b24ge1xuICAgIHBhZGRpbmc6IDJweDtcbiAgICBjdXJzb3I6IHBvaW50ZXI7XG4gICAgb3ZlcmZsb3c6IGhpZGRlbjtcbn1cbi5hY2VfbW9iaWxlLWJ1dHRvbjpob3ZlciB7XG4gICAgYmFja2dyb3VuZC1jb2xvcjogI2VlZTtcbiAgICBvcGFjaXR5OjE7XG59XG4uYWNlX21vYmlsZS1idXR0b246YWN0aXZlIHtcbiAgICBiYWNrZ3JvdW5kLWNvbG9yOiAjZGRkO1xufVxuXG4uYWNlX3BsYWNlaG9sZGVyIHtcbiAgICBmb250LWZhbWlseTogYXJpYWw7XG4gICAgdHJhbnNmb3JtOiBzY2FsZSgwLjkpO1xuICAgIHRyYW5zZm9ybS1vcmlnaW46IGxlZnQ7XG4gICAgd2hpdGUtc3BhY2U6IHByZTtcbiAgICBvcGFjaXR5OiAwLjc7XG4gICAgbWFyZ2luOiAwIDEwcHg7XG59J30pLGRlZmluZSgiYWNlL2xheWVyL2RlY29yYXRvcnMiLFsicmVxdWlyZSIsImV4cG9ydHMiLCJtb2R1bGUiLCJhY2UvbGliL2RvbSIsImFjZS9saWIvb29wIiwiYWNlL2xpYi9ldmVudF9lbWl0dGVyIl0sZnVuY3Rpb24oZSx0LG4peyJ1c2Ugc3RyaWN0Ijt2YXIgcj1lKCIuLi9saWIvZG9tIiksaT1lKCIuLi9saWIvb29wIikscz1lKCIuLi9saWIvZXZlbnRfZW1pdHRlciIpLkV2ZW50RW1pdHRlcixvPWZ1bmN0aW9uKGUsdCl7dGhpcy5jYW52YXM9ci5jcmVhdGVFbGVtZW50KCJjYW52YXMiKSx0aGlzLnJlbmRlcmVyPXQsdGhpcy5waXhlbFJhdGlvPTEsdGhpcy5tYXhIZWlnaHQ9dC5sYXllckNvbmZpZy5tYXhIZWlnaHQsdGhpcy5saW5lSGVpZ2h0PXQubGF5ZXJDb25maWcubGluZUhlaWdodCx0aGlzLmNhbnZhc0hlaWdodD1lLnBhcmVudC5zY3JvbGxIZWlnaHQsdGhpcy5oZWlnaHRSYXRpbz10aGlzLmNhbnZhc0hlaWdodC90aGlzLm1heEhlaWdodCx0aGlzLmNhbnZhc1dpZHRoPWUud2lkdGgsdGhpcy5taW5EZWNvcmF0aW9uSGVpZ2h0PTIqdGhpcy5waXhlbFJhdGlvfDAsdGhpcy5oYWxmTWluRGVjb3JhdGlvbkhlaWdodD10aGlzLm1pbkRlY29yYXRpb25IZWlnaHQvMnwwLHRoaXMuY2FudmFzLndpZHRoPXRoaXMuY2FudmFzV2lkdGgsdGhpcy5jYW52YXMuaGVpZ2h0PXRoaXMuY2FudmFzSGVpZ2h0LHRoaXMuY2FudmFzLnN0eWxlLnRvcD0iMHB4Iix0aGlzLmNhbnZhcy5zdHlsZS5yaWdodD0iMHB4Iix0aGlzLmNhbnZhcy5zdHlsZS56SW5kZXg9IjdweCIsdGhpcy5jYW52YXMuc3R5bGUucG9zaXRpb249ImFic29sdXRlIix0aGlzLmNvbG9ycz17fSx0aGlzLmNvbG9ycy5kYXJrPXtlcnJvcjoicmdiYSgyNTUsIDE4LCAxOCwgMSkiLHdhcm5pbmc6InJnYmEoMTgsIDEzNiwgMTgsIDEpIixpbmZvOiJyZ2JhKDE4LCAxOCwgMTM2LCAxKSJ9LHRoaXMuY29sb3JzLmxpZ2h0PXtlcnJvcjoicmdiKDI1NSw1MSw1MSkiLHdhcm5pbmc6InJnYigzMiwxMzMsNzIpIixpbmZvOiJyZ2IoMzUsNjgsMTM4KSJ9LGUuZWxlbWVudC5hcHBlbmRDaGlsZCh0aGlzLmNhbnZhcyl9OyhmdW5jdGlvbigpe2kuaW1wbGVtZW50KHRoaXMscyksdGhpcy4kdXBkYXRlRGVjb3JhdG9ycz1mdW5jdGlvbihlKXtmdW5jdGlvbiBpKGUsdCl7cmV0dXJuIGUucHJpb3JpdHk8dC5wcmlvcml0eT8tMTplLnByaW9yaXR5PnQucHJpb3JpdHk/MTowfXZhciB0PXRoaXMucmVuZGVyZXIudGhlbWUuaXNEYXJrPT09ITA/dGhpcy5jb2xvcnMuZGFyazp0aGlzLmNvbG9ycy5saWdodDtpZihlKXt0aGlzLm1heEhlaWdodD1lLm1heEhlaWdodCx0aGlzLmxpbmVIZWlnaHQ9ZS5saW5lSGVpZ2h0LHRoaXMuY2FudmFzSGVpZ2h0PWUuaGVpZ2h0O3ZhciBuPShlLmxhc3RSb3crMSkqdGhpcy5saW5lSGVpZ2h0O248dGhpcy5jYW52YXNIZWlnaHQ/dGhpcy5oZWlnaHRSYXRpbz0xOnRoaXMuaGVpZ2h0UmF0aW89dGhpcy5jYW52YXNIZWlnaHQvdGhpcy5tYXhIZWlnaHR9dmFyIHI9dGhpcy5jYW52YXMuZ2V0Q29udGV4dCgiMmQiKSxzPXRoaXMucmVuZGVyZXIuc2Vzc2lvbi4kYW5ub3RhdGlvbnM7ci5jbGVhclJlY3QoMCwwLHRoaXMuY2FudmFzLndpZHRoLHRoaXMuY2FudmFzLmhlaWdodCk7aWYocyl7dmFyIG89e2luZm86MSx3YXJuaW5nOjIsZXJyb3I6M307cy5mb3JFYWNoKGZ1bmN0aW9uKGUpe2UucHJpb3JpdHk9b1tlLnR5cGVdfHxudWxsfSkscz1zLnNvcnQoaSk7dmFyIHU9dGhpcy5yZW5kZXJlci5zZXNzaW9uLiRmb2xkRGF0YTtmb3IodmFyIGE9MDthPHMubGVuZ3RoO2ErKyl7dmFyIGY9c1thXS5yb3csbD10aGlzLmNvbXBlbnNhdGVGb2xkUm93cyhmLHUpLGM9TWF0aC5yb3VuZCgoZi1sKSp0aGlzLmxpbmVIZWlnaHQqdGhpcy5oZWlnaHRSYXRpbyksaD1NYXRoLnJvdW5kKChmLWwpKnRoaXMubGluZUhlaWdodCp0aGlzLmhlaWdodFJhdGlvKSxwPU1hdGgucm91bmQoKChmLWwpKnRoaXMubGluZUhlaWdodCt0aGlzLmxpbmVIZWlnaHQpKnRoaXMuaGVpZ2h0UmF0aW8pLGQ9cC1oO2lmKGQ8dGhpcy5taW5EZWNvcmF0aW9uSGVpZ2h0KXt2YXIgdj0oaCtwKS8yfDA7djx0aGlzLmhhbGZNaW5EZWNvcmF0aW9uSGVpZ2h0P3Y9dGhpcy5oYWxmTWluRGVjb3JhdGlvbkhlaWdodDp2K3RoaXMuaGFsZk1pbkRlY29yYXRpb25IZWlnaHQ+dGhpcy5jYW52YXNIZWlnaHQmJih2PXRoaXMuY2FudmFzSGVpZ2h0LXRoaXMuaGFsZk1pbkRlY29yYXRpb25IZWlnaHQpLGg9TWF0aC5yb3VuZCh2LXRoaXMuaGFsZk1pbkRlY29yYXRpb25IZWlnaHQpLHA9TWF0aC5yb3VuZCh2K3RoaXMuaGFsZk1pbkRlY29yYXRpb25IZWlnaHQpfXIuZmlsbFN0eWxlPXRbc1thXS50eXBlXXx8bnVsbCxyLmZpbGxSZWN0KDAsYyx0aGlzLmNhbnZhc1dpZHRoLHAtaCl9fXZhciBtPXRoaXMucmVuZGVyZXIuc2Vzc2lvbi5zZWxlY3Rpb24uZ2V0Q3Vyc29yKCk7aWYobSl7dmFyIGw9dGhpcy5jb21wZW5zYXRlRm9sZFJvd3MobS5yb3csdSksYz1NYXRoLnJvdW5kKChtLnJvdy1sKSp0aGlzLmxpbmVIZWlnaHQqdGhpcy5oZWlnaHRSYXRpbyk7ci5maWxsU3R5bGU9InJnYmEoMCwgMCwgMCwgMC41KSIsci5maWxsUmVjdCgwLGMsdGhpcy5jYW52YXNXaWR0aCwyKX19LHRoaXMuY29tcGVuc2F0ZUZvbGRSb3dzPWZ1bmN0aW9uKGUsdCl7dmFyIG49MDtpZih0JiZ0Lmxlbmd0aD4wKWZvcih2YXIgcj0wO3I8dC5sZW5ndGg7cisrKWU+dFtyXS5zdGFydC5yb3cmJmU8dFtyXS5lbmQucm93P24rPWUtdFtyXS5zdGFydC5yb3c6ZT49dFtyXS5lbmQucm93JiYobis9dFtyXS5lbmQucm93LXRbcl0uc3RhcnQucm93KTtyZXR1cm4gbn19KS5jYWxsKG8ucHJvdG90eXBlKSx0LkRlY29yYXRvcj1vfSksZGVmaW5lKCJhY2UvdmlydHVhbF9yZW5kZXJlciIsWyJyZXF1aXJlIiwiZXhwb3J0cyIsIm1vZHVsZSIsImFjZS9saWIvb29wIiwiYWNlL2xpYi9kb20iLCJhY2UvY29uZmlnIiwiYWNlL2xheWVyL2d1dHRlciIsImFjZS9sYXllci9tYXJrZXIiLCJhY2UvbGF5ZXIvdGV4dCIsImFjZS9sYXllci9jdXJzb3IiLCJhY2Uvc2Nyb2xsYmFyIiwiYWNlL3Njcm9sbGJhciIsImFjZS9zY3JvbGxiYXJfY3VzdG9tIiwiYWNlL3Njcm9sbGJhcl9jdXN0b20iLCJhY2UvcmVuZGVybG9vcCIsImFjZS9sYXllci9mb250X21ldHJpY3MiLCJhY2UvbGliL2V2ZW50X2VtaXR0ZXIiLCJhY2UvY3NzL2VkaXRvci5jc3MiLCJhY2UvbGF5ZXIvZGVjb3JhdG9ycyIsImFjZS9saWIvdXNlcmFnZW50Il0sZnVuY3Rpb24oZSx0LG4peyJ1c2Ugc3RyaWN0Ijt2YXIgcj1lKCIuL2xpYi9vb3AiKSxpPWUoIi4vbGliL2RvbSIpLHM9ZSgiLi9jb25maWciKSxvPWUoIi4vbGF5ZXIvZ3V0dGVyIikuR3V0dGVyLHU9ZSgiLi9sYXllci9tYXJrZXIiKS5NYXJrZXIsYT1lKCIuL2xheWVyL3RleHQiKS5UZXh0LGY9ZSgiLi9sYXllci9jdXJzb3IiKS5DdXJzb3IsbD1lKCIuL3Njcm9sbGJhciIpLkhTY3JvbGxCYXIsYz1lKCIuL3Njcm9sbGJhciIpLlZTY3JvbGxCYXIsaD1lKCIuL3Njcm9sbGJhcl9jdXN0b20iKS5IU2Nyb2xsQmFyLHA9ZSgiLi9zY3JvbGxiYXJfY3VzdG9tIikuVlNjcm9sbEJhcixkPWUoIi4vcmVuZGVybG9vcCIpLlJlbmRlckxvb3Asdj1lKCIuL2xheWVyL2ZvbnRfbWV0cmljcyIpLkZvbnRNZXRyaWNzLG09ZSgiLi9saWIvZXZlbnRfZW1pdHRlciIpLkV2ZW50RW1pdHRlcixnPWUoIi4vY3NzL2VkaXRvci5jc3MiKSx5PWUoIi4vbGF5ZXIvZGVjb3JhdG9ycyIpLkRlY29yYXRvcixiPWUoIi4vbGliL3VzZXJhZ2VudCIpLHc9Yi5pc0lFO2kuaW1wb3J0Q3NzU3RyaW5nKGcsImFjZV9lZGl0b3IuY3NzIiwhMSk7dmFyIEU9ZnVuY3Rpb24oZSx0KXt2YXIgbj10aGlzO3RoaXMuY29udGFpbmVyPWV8fGkuY3JlYXRlRWxlbWVudCgiZGl2IiksaS5hZGRDc3NDbGFzcyh0aGlzLmNvbnRhaW5lciwiYWNlX2VkaXRvciIpLGkuSElfRFBJJiZpLmFkZENzc0NsYXNzKHRoaXMuY29udGFpbmVyLCJhY2VfaGlkcGkiKSx0aGlzLnNldFRoZW1lKHQpLHMuZ2V0KCJ1c2VTdHJpY3RDU1AiKT09bnVsbCYmcy5zZXQoInVzZVN0cmljdENTUCIsITEpLHRoaXMuJGd1dHRlcj1pLmNyZWF0ZUVsZW1lbnQoImRpdiIpLHRoaXMuJGd1dHRlci5jbGFzc05hbWU9ImFjZV9ndXR0ZXIiLHRoaXMuY29udGFpbmVyLmFwcGVuZENoaWxkKHRoaXMuJGd1dHRlciksdGhpcy4kZ3V0dGVyLnNldEF0dHJpYnV0ZSgiYXJpYS1oaWRkZW4iLCEwKSx0aGlzLnNjcm9sbGVyPWkuY3JlYXRlRWxlbWVudCgiZGl2IiksdGhpcy5zY3JvbGxlci5jbGFzc05hbWU9ImFjZV9zY3JvbGxlciIsdGhpcy5jb250YWluZXIuYXBwZW5kQ2hpbGQodGhpcy5zY3JvbGxlciksdGhpcy5jb250ZW50PWkuY3JlYXRlRWxlbWVudCgiZGl2IiksdGhpcy5jb250ZW50LmNsYXNzTmFtZT0iYWNlX2NvbnRlbnQiLHRoaXMuc2Nyb2xsZXIuYXBwZW5kQ2hpbGQodGhpcy5jb250ZW50KSx0aGlzLiRndXR0ZXJMYXllcj1uZXcgbyh0aGlzLiRndXR0ZXIpLHRoaXMuJGd1dHRlckxheWVyLm9uKCJjaGFuZ2VHdXR0ZXJXaWR0aCIsdGhpcy5vbkd1dHRlclJlc2l6ZS5iaW5kKHRoaXMpKSx0aGlzLiRtYXJrZXJCYWNrPW5ldyB1KHRoaXMuY29udGVudCk7dmFyIHI9dGhpcy4kdGV4dExheWVyPW5ldyBhKHRoaXMuY29udGVudCk7dGhpcy5jYW52YXM9ci5lbGVtZW50LHRoaXMuJG1hcmtlckZyb250PW5ldyB1KHRoaXMuY29udGVudCksdGhpcy4kY3Vyc29yTGF5ZXI9bmV3IGYodGhpcy5jb250ZW50KSx0aGlzLiRob3JpelNjcm9sbD0hMSx0aGlzLiR2U2Nyb2xsPSExLHRoaXMuc2Nyb2xsQmFyPXRoaXMuc2Nyb2xsQmFyVj1uZXcgYyh0aGlzLmNvbnRhaW5lcix0aGlzKSx0aGlzLnNjcm9sbEJhckg9bmV3IGwodGhpcy5jb250YWluZXIsdGhpcyksdGhpcy5zY3JvbGxCYXJWLm9uKCJzY3JvbGwiLGZ1bmN0aW9uKGUpe24uJHNjcm9sbEFuaW1hdGlvbnx8bi5zZXNzaW9uLnNldFNjcm9sbFRvcChlLmRhdGEtbi5zY3JvbGxNYXJnaW4udG9wKX0pLHRoaXMuc2Nyb2xsQmFySC5vbigic2Nyb2xsIixmdW5jdGlvbihlKXtuLiRzY3JvbGxBbmltYXRpb258fG4uc2Vzc2lvbi5zZXRTY3JvbGxMZWZ0KGUuZGF0YS1uLnNjcm9sbE1hcmdpbi5sZWZ0KX0pLHRoaXMuc2Nyb2xsVG9wPTAsdGhpcy5zY3JvbGxMZWZ0PTAsdGhpcy5jdXJzb3JQb3M9e3JvdzowLGNvbHVtbjowfSx0aGlzLiRmb250TWV0cmljcz1uZXcgdih0aGlzLmNvbnRhaW5lcix0aGlzLiR0ZXh0TGF5ZXIuTUFYX0NIVU5LX0xFTkdUSCksdGhpcy4kdGV4dExheWVyLiRzZXRGb250TWV0cmljcyh0aGlzLiRmb250TWV0cmljcyksdGhpcy4kdGV4dExheWVyLm9uKCJjaGFuZ2VDaGFyYWN0ZXJTaXplIixmdW5jdGlvbihlKXtuLnVwZGF0ZUNoYXJhY3RlclNpemUoKSxuLm9uUmVzaXplKCEwLG4uZ3V0dGVyV2lkdGgsbi4kc2l6ZS53aWR0aCxuLiRzaXplLmhlaWdodCksbi5fc2lnbmFsKCJjaGFuZ2VDaGFyYWN0ZXJTaXplIixlKX0pLHRoaXMuJHNpemU9e3dpZHRoOjAsaGVpZ2h0OjAsc2Nyb2xsZXJIZWlnaHQ6MCxzY3JvbGxlcldpZHRoOjAsJGRpcnR5OiEwfSx0aGlzLmxheWVyQ29uZmlnPXt3aWR0aDoxLHBhZGRpbmc6MCxmaXJzdFJvdzowLGZpcnN0Um93U2NyZWVuOjAsbGFzdFJvdzowLGxpbmVIZWlnaHQ6MCxjaGFyYWN0ZXJXaWR0aDowLG1pbkhlaWdodDoxLG1heEhlaWdodDoxLG9mZnNldDowLGhlaWdodDoxLGd1dHRlck9mZnNldDoxfSx0aGlzLnNjcm9sbE1hcmdpbj17bGVmdDowLHJpZ2h0OjAsdG9wOjAsYm90dG9tOjAsdjowLGg6MH0sdGhpcy5tYXJnaW49e2xlZnQ6MCxyaWdodDowLHRvcDowLGJvdHRvbTowLHY6MCxoOjB9LHRoaXMuJGtlZXBUZXh0QXJlYUF0Q3Vyc29yPSFiLmlzSU9TLHRoaXMuJGxvb3A9bmV3IGQodGhpcy4kcmVuZGVyQ2hhbmdlcy5iaW5kKHRoaXMpLHRoaXMuY29udGFpbmVyLm93bmVyRG9jdW1lbnQuZGVmYXVsdFZpZXcpLHRoaXMuJGxvb3Auc2NoZWR1bGUodGhpcy5DSEFOR0VfRlVMTCksdGhpcy51cGRhdGVDaGFyYWN0ZXJTaXplKCksdGhpcy5zZXRQYWRkaW5nKDQpLHMucmVzZXRPcHRpb25zKHRoaXMpLHMuX3NpZ25hbCgicmVuZGVyZXIiLHRoaXMpfTsoZnVuY3Rpb24oKXt0aGlzLkNIQU5HRV9DVVJTT1I9MSx0aGlzLkNIQU5HRV9NQVJLRVI9Mix0aGlzLkNIQU5HRV9HVVRURVI9NCx0aGlzLkNIQU5HRV9TQ1JPTEw9OCx0aGlzLkNIQU5HRV9MSU5FUz0xNix0aGlzLkNIQU5HRV9URVhUPTMyLHRoaXMuQ0hBTkdFX1NJWkU9NjQsdGhpcy5DSEFOR0VfTUFSS0VSX0JBQ0s9MTI4LHRoaXMuQ0hBTkdFX01BUktFUl9GUk9OVD0yNTYsdGhpcy5DSEFOR0VfRlVMTD01MTIsdGhpcy5DSEFOR0VfSF9TQ1JPTEw9MTAyNCxyLmltcGxlbWVudCh0aGlzLG0pLHRoaXMudXBkYXRlQ2hhcmFjdGVyU2l6ZT1mdW5jdGlvbigpe3RoaXMuJHRleHRMYXllci5hbGxvd0JvbGRGb250cyE9dGhpcy4kYWxsb3dCb2xkRm9udHMmJih0aGlzLiRhbGxvd0JvbGRGb250cz10aGlzLiR0ZXh0TGF5ZXIuYWxsb3dCb2xkRm9udHMsdGhpcy5zZXRTdHlsZSgiYWNlX25vYm9sZCIsIXRoaXMuJGFsbG93Qm9sZEZvbnRzKSksdGhpcy5sYXllckNvbmZpZy5jaGFyYWN0ZXJXaWR0aD10aGlzLmNoYXJhY3RlcldpZHRoPXRoaXMuJHRleHRMYXllci5nZXRDaGFyYWN0ZXJXaWR0aCgpLHRoaXMubGF5ZXJDb25maWcubGluZUhlaWdodD10aGlzLmxpbmVIZWlnaHQ9dGhpcy4kdGV4dExheWVyLmdldExpbmVIZWlnaHQoKSx0aGlzLiR1cGRhdGVQcmludE1hcmdpbigpLGkuc2V0U3R5bGUodGhpcy5zY3JvbGxlci5zdHlsZSwibGluZS1oZWlnaHQiLHRoaXMubGluZUhlaWdodCsicHgiKX0sdGhpcy5zZXRTZXNzaW9uPWZ1bmN0aW9uKGUpe3RoaXMuc2Vzc2lvbiYmdGhpcy5zZXNzaW9uLmRvYy5vZmYoImNoYW5nZU5ld0xpbmVNb2RlIix0aGlzLm9uQ2hhbmdlTmV3TGluZU1vZGUpLHRoaXMuc2Vzc2lvbj1lLGUmJnRoaXMuc2Nyb2xsTWFyZ2luLnRvcCYmZS5nZXRTY3JvbGxUb3AoKTw9MCYmZS5zZXRTY3JvbGxUb3AoLXRoaXMuc2Nyb2xsTWFyZ2luLnRvcCksdGhpcy4kY3Vyc29yTGF5ZXIuc2V0U2Vzc2lvbihlKSx0aGlzLiRtYXJrZXJCYWNrLnNldFNlc3Npb24oZSksdGhpcy4kbWFya2VyRnJvbnQuc2V0U2Vzc2lvbihlKSx0aGlzLiRndXR0ZXJMYXllci5zZXRTZXNzaW9uKGUpLHRoaXMuJHRleHRMYXllci5zZXRTZXNzaW9uKGUpO2lmKCFlKXJldHVybjt0aGlzLiRsb29wLnNjaGVkdWxlKHRoaXMuQ0hBTkdFX0ZVTEwpLHRoaXMuc2Vzc2lvbi4kc2V0Rm9udE1ldHJpY3ModGhpcy4kZm9udE1ldHJpY3MpLHRoaXMuc2Nyb2xsQmFySC5zY3JvbGxMZWZ0PXRoaXMuc2Nyb2xsQmFyVi5zY3JvbGxUb3A9bnVsbCx0aGlzLm9uQ2hhbmdlTmV3TGluZU1vZGU9dGhpcy5vbkNoYW5nZU5ld0xpbmVNb2RlLmJpbmQodGhpcyksdGhpcy5vbkNoYW5nZU5ld0xpbmVNb2RlKCksdGhpcy5zZXNzaW9uLmRvYy5vbigiY2hhbmdlTmV3TGluZU1vZGUiLHRoaXMub25DaGFuZ2VOZXdMaW5lTW9kZSl9LHRoaXMudXBkYXRlTGluZXM9ZnVuY3Rpb24oZSx0LG4pe3Q9PT11bmRlZmluZWQmJih0PUluZmluaXR5KSx0aGlzLiRjaGFuZ2VkTGluZXM/KHRoaXMuJGNoYW5nZWRMaW5lcy5maXJzdFJvdz5lJiYodGhpcy4kY2hhbmdlZExpbmVzLmZpcnN0Um93PWUpLHRoaXMuJGNoYW5nZWRMaW5lcy5sYXN0Um93PHQmJih0aGlzLiRjaGFuZ2VkTGluZXMubGFzdFJvdz10KSk6dGhpcy4kY2hhbmdlZExpbmVzPXtmaXJzdFJvdzplLGxhc3RSb3c6dH07aWYodGhpcy4kY2hhbmdlZExpbmVzLmxhc3RSb3c8dGhpcy5sYXllckNvbmZpZy5maXJzdFJvdyl7aWYoIW4pcmV0dXJuO3RoaXMuJGNoYW5nZWRMaW5lcy5sYXN0Um93PXRoaXMubGF5ZXJDb25maWcubGFzdFJvd31pZih0aGlzLiRjaGFuZ2VkTGluZXMuZmlyc3RSb3c+dGhpcy5sYXllckNvbmZpZy5sYXN0Um93KXJldHVybjt0aGlzLiRsb29wLnNjaGVkdWxlKHRoaXMuQ0hBTkdFX0xJTkVTKX0sdGhpcy5vbkNoYW5nZU5ld0xpbmVNb2RlPWZ1bmN0aW9uKCl7dGhpcy4kbG9vcC5zY2hlZHVsZSh0aGlzLkNIQU5HRV9URVhUKSx0aGlzLiR0ZXh0TGF5ZXIuJHVwZGF0ZUVvbENoYXIoKSx0aGlzLnNlc3Npb24uJGJpZGlIYW5kbGVyLnNldEVvbENoYXIodGhpcy4kdGV4dExheWVyLkVPTF9DSEFSKX0sdGhpcy5vbkNoYW5nZVRhYlNpemU9ZnVuY3Rpb24oKXt0aGlzLiRsb29wLnNjaGVkdWxlKHRoaXMuQ0hBTkdFX1RFWFR8dGhpcy5DSEFOR0VfTUFSS0VSKSx0aGlzLiR0ZXh0TGF5ZXIub25DaGFuZ2VUYWJTaXplKCl9LHRoaXMudXBkYXRlVGV4dD1mdW5jdGlvbigpe3RoaXMuJGxvb3Auc2NoZWR1bGUodGhpcy5DSEFOR0VfVEVYVCl9LHRoaXMudXBkYXRlRnVsbD1mdW5jdGlvbihlKXtlP3RoaXMuJHJlbmRlckNoYW5nZXModGhpcy5DSEFOR0VfRlVMTCwhMCk6dGhpcy4kbG9vcC5zY2hlZHVsZSh0aGlzLkNIQU5HRV9GVUxMKX0sdGhpcy51cGRhdGVGb250U2l6ZT1mdW5jdGlvbigpe3RoaXMuJHRleHRMYXllci5jaGVja0ZvclNpemVDaGFuZ2VzKCl9LHRoaXMuJGNoYW5nZXM9MCx0aGlzLiR1cGRhdGVTaXplQXN5bmM9ZnVuY3Rpb24oKXt0aGlzLiRsb29wLnBlbmRpbmc/dGhpcy4kc2l6ZS4kZGlydHk9ITA6dGhpcy5vblJlc2l6ZSgpfSx0aGlzLm9uUmVzaXplPWZ1bmN0aW9uKGUsdCxuLHIpe2lmKHRoaXMucmVzaXppbmc+MilyZXR1cm47dGhpcy5yZXNpemluZz4wP3RoaXMucmVzaXppbmcrKzp0aGlzLnJlc2l6aW5nPWU/MTowO3ZhciBpPXRoaXMuY29udGFpbmVyO3J8fChyPWkuY2xpZW50SGVpZ2h0fHxpLnNjcm9sbEhlaWdodCksbnx8KG49aS5jbGllbnRXaWR0aHx8aS5zY3JvbGxXaWR0aCk7dmFyIHM9dGhpcy4kdXBkYXRlQ2FjaGVkU2l6ZShlLHQsbixyKTtpZighdGhpcy4kc2l6ZS5zY3JvbGxlckhlaWdodHx8IW4mJiFyKXJldHVybiB0aGlzLnJlc2l6aW5nPTA7ZSYmKHRoaXMuJGd1dHRlckxheWVyLiRwYWRkaW5nPW51bGwpLGU/dGhpcy4kcmVuZGVyQ2hhbmdlcyhzfHRoaXMuJGNoYW5nZXMsITApOnRoaXMuJGxvb3Auc2NoZWR1bGUoc3x0aGlzLiRjaGFuZ2VzKSx0aGlzLnJlc2l6aW5nJiYodGhpcy5yZXNpemluZz0wKSx0aGlzLnNjcm9sbEJhckguc2Nyb2xsTGVmdD10aGlzLnNjcm9sbEJhclYuc2Nyb2xsVG9wPW51bGwsdGhpcy4kY3VzdG9tU2Nyb2xsYmFyJiZ0aGlzLiR1cGRhdGVDdXN0b21TY3JvbGxiYXIoITApfSx0aGlzLiR1cGRhdGVDYWNoZWRTaXplPWZ1bmN0aW9uKGUsdCxuLHIpe3ItPXRoaXMuJGV4dHJhSGVpZ2h0fHwwO3ZhciBzPTAsbz10aGlzLiRzaXplLHU9e3dpZHRoOm8ud2lkdGgsaGVpZ2h0Om8uaGVpZ2h0LHNjcm9sbGVySGVpZ2h0Om8uc2Nyb2xsZXJIZWlnaHQsc2Nyb2xsZXJXaWR0aDpvLnNjcm9sbGVyV2lkdGh9O3ImJihlfHxvLmhlaWdodCE9cikmJihvLmhlaWdodD1yLHN8PXRoaXMuQ0hBTkdFX1NJWkUsby5zY3JvbGxlckhlaWdodD1vLmhlaWdodCx0aGlzLiRob3JpelNjcm9sbCYmKG8uc2Nyb2xsZXJIZWlnaHQtPXRoaXMuc2Nyb2xsQmFySC5nZXRIZWlnaHQoKSksdGhpcy5zY3JvbGxCYXJWLnNldEhlaWdodChvLnNjcm9sbGVySGVpZ2h0KSx0aGlzLnNjcm9sbEJhclYuZWxlbWVudC5zdHlsZS5ib3R0b209dGhpcy5zY3JvbGxCYXJILmdldEhlaWdodCgpKyJweCIsc3w9dGhpcy5DSEFOR0VfU0NST0xMKTtpZihuJiYoZXx8by53aWR0aCE9bikpe3N8PXRoaXMuQ0hBTkdFX1NJWkUsby53aWR0aD1uLHQ9PW51bGwmJih0PXRoaXMuJHNob3dHdXR0ZXI/dGhpcy4kZ3V0dGVyLm9mZnNldFdpZHRoOjApLHRoaXMuZ3V0dGVyV2lkdGg9dCxpLnNldFN0eWxlKHRoaXMuc2Nyb2xsQmFySC5lbGVtZW50LnN0eWxlLCJsZWZ0Iix0KyJweCIpLGkuc2V0U3R5bGUodGhpcy5zY3JvbGxlci5zdHlsZSwibGVmdCIsdCt0aGlzLm1hcmdpbi5sZWZ0KyJweCIpLG8uc2Nyb2xsZXJXaWR0aD1NYXRoLm1heCgwLG4tdC10aGlzLnNjcm9sbEJhclYuZ2V0V2lkdGgoKS10aGlzLm1hcmdpbi5oKSxpLnNldFN0eWxlKHRoaXMuJGd1dHRlci5zdHlsZSwibGVmdCIsdGhpcy5tYXJnaW4ubGVmdCsicHgiKTt2YXIgYT10aGlzLnNjcm9sbEJhclYuZ2V0V2lkdGgoKSsicHgiO2kuc2V0U3R5bGUodGhpcy5zY3JvbGxCYXJILmVsZW1lbnQuc3R5bGUsInJpZ2h0IixhKSxpLnNldFN0eWxlKHRoaXMuc2Nyb2xsZXIuc3R5bGUsInJpZ2h0IixhKSxpLnNldFN0eWxlKHRoaXMuc2Nyb2xsZXIuc3R5bGUsImJvdHRvbSIsdGhpcy5zY3JvbGxCYXJILmdldEhlaWdodCgpKSx0aGlzLnNjcm9sbEJhckguc2V0V2lkdGgoby5zY3JvbGxlcldpZHRoKTtpZih0aGlzLnNlc3Npb24mJnRoaXMuc2Vzc2lvbi5nZXRVc2VXcmFwTW9kZSgpJiZ0aGlzLmFkanVzdFdyYXBMaW1pdCgpfHxlKXN8PXRoaXMuQ0hBTkdFX0ZVTEx9cmV0dXJuIG8uJGRpcnR5PSFufHwhcixzJiZ0aGlzLl9zaWduYWwoInJlc2l6ZSIsdSksc30sdGhpcy5vbkd1dHRlclJlc2l6ZT1mdW5jdGlvbihlKXt2YXIgdD10aGlzLiRzaG93R3V0dGVyP2U6MDt0IT10aGlzLmd1dHRlcldpZHRoJiYodGhpcy4kY2hhbmdlc3w9dGhpcy4kdXBkYXRlQ2FjaGVkU2l6ZSghMCx0LHRoaXMuJHNpemUud2lkdGgsdGhpcy4kc2l6ZS5oZWlnaHQpKSx0aGlzLnNlc3Npb24uZ2V0VXNlV3JhcE1vZGUoKSYmdGhpcy5hZGp1c3RXcmFwTGltaXQoKT90aGlzLiRsb29wLnNjaGVkdWxlKHRoaXMuQ0hBTkdFX0ZVTEwpOnRoaXMuJHNpemUuJGRpcnR5P3RoaXMuJGxvb3Auc2NoZWR1bGUodGhpcy5DSEFOR0VfRlVMTCk6dGhpcy4kY29tcHV0ZUxheWVyQ29uZmlnKCl9LHRoaXMuYWRqdXN0V3JhcExpbWl0PWZ1bmN0aW9uKCl7dmFyIGU9dGhpcy4kc2l6ZS5zY3JvbGxlcldpZHRoLXRoaXMuJHBhZGRpbmcqMix0PU1hdGguZmxvb3IoZS90aGlzLmNoYXJhY3RlcldpZHRoKTtyZXR1cm4gdGhpcy5zZXNzaW9uLmFkanVzdFdyYXBMaW1pdCh0LHRoaXMuJHNob3dQcmludE1hcmdpbiYmdGhpcy4kcHJpbnRNYXJnaW5Db2x1bW4pfSx0aGlzLnNldEFuaW1hdGVkU2Nyb2xsPWZ1bmN0aW9uKGUpe3RoaXMuc2V0T3B0aW9uKCJhbmltYXRlZFNjcm9sbCIsZSl9LHRoaXMuZ2V0QW5pbWF0ZWRTY3JvbGw9ZnVuY3Rpb24oKXtyZXR1cm4gdGhpcy4kYW5pbWF0ZWRTY3JvbGx9LHRoaXMuc2V0U2hvd0ludmlzaWJsZXM9ZnVuY3Rpb24oZSl7dGhpcy5zZXRPcHRpb24oInNob3dJbnZpc2libGVzIixlKSx0aGlzLnNlc3Npb24uJGJpZGlIYW5kbGVyLnNldFNob3dJbnZpc2libGVzKGUpfSx0aGlzLmdldFNob3dJbnZpc2libGVzPWZ1bmN0aW9uKCl7cmV0dXJuIHRoaXMuZ2V0T3B0aW9uKCJzaG93SW52aXNpYmxlcyIpfSx0aGlzLmdldERpc3BsYXlJbmRlbnRHdWlkZXM9ZnVuY3Rpb24oKXtyZXR1cm4gdGhpcy5nZXRPcHRpb24oImRpc3BsYXlJbmRlbnRHdWlkZXMiKX0sdGhpcy5zZXREaXNwbGF5SW5kZW50R3VpZGVzPWZ1bmN0aW9uKGUpe3RoaXMuc2V0T3B0aW9uKCJkaXNwbGF5SW5kZW50R3VpZGVzIixlKX0sdGhpcy5nZXRIaWdobGlnaHRJbmRlbnRHdWlkZXM9ZnVuY3Rpb24oKXtyZXR1cm4gdGhpcy5nZXRPcHRpb24oImhpZ2hsaWdodEluZGVudEd1aWRlcyIpfSx0aGlzLnNldEhpZ2hsaWdodEluZGVudEd1aWRlcz1mdW5jdGlvbihlKXt0aGlzLnNldE9wdGlvbigiaGlnaGxpZ2h0SW5kZW50R3VpZGVzIixlKX0sdGhpcy5zZXRTaG93UHJpbnRNYXJnaW49ZnVuY3Rpb24oZSl7dGhpcy5zZXRPcHRpb24oInNob3dQcmludE1hcmdpbiIsZSl9LHRoaXMuZ2V0U2hvd1ByaW50TWFyZ2luPWZ1bmN0aW9uKCl7cmV0dXJuIHRoaXMuZ2V0T3B0aW9uKCJzaG93UHJpbnRNYXJnaW4iKX0sdGhpcy5zZXRQcmludE1hcmdpbkNvbHVtbj1mdW5jdGlvbihlKXt0aGlzLnNldE9wdGlvbigicHJpbnRNYXJnaW5Db2x1bW4iLGUpfSx0aGlzLmdldFByaW50TWFyZ2luQ29sdW1uPWZ1bmN0aW9uKCl7cmV0dXJuIHRoaXMuZ2V0T3B0aW9uKCJwcmludE1hcmdpbkNvbHVtbiIpfSx0aGlzLmdldFNob3dHdXR0ZXI9ZnVuY3Rpb24oKXtyZXR1cm4gdGhpcy5nZXRPcHRpb24oInNob3dHdXR0ZXIiKX0sdGhpcy5zZXRTaG93R3V0dGVyPWZ1bmN0aW9uKGUpe3JldHVybiB0aGlzLnNldE9wdGlvbigic2hvd0d1dHRlciIsZSl9LHRoaXMuZ2V0RmFkZUZvbGRXaWRnZXRzPWZ1bmN0aW9uKCl7cmV0dXJuIHRoaXMuZ2V0T3B0aW9uKCJmYWRlRm9sZFdpZGdldHMiKX0sdGhpcy5zZXRGYWRlRm9sZFdpZGdldHM9ZnVuY3Rpb24oZSl7dGhpcy5zZXRPcHRpb24oImZhZGVGb2xkV2lkZ2V0cyIsZSl9LHRoaXMuc2V0SGlnaGxpZ2h0R3V0dGVyTGluZT1mdW5jdGlvbihlKXt0aGlzLnNldE9wdGlvbigiaGlnaGxpZ2h0R3V0dGVyTGluZSIsZSl9LHRoaXMuZ2V0SGlnaGxpZ2h0R3V0dGVyTGluZT1mdW5jdGlvbigpe3JldHVybiB0aGlzLmdldE9wdGlvbigiaGlnaGxpZ2h0R3V0dGVyTGluZSIpfSx0aGlzLiR1cGRhdGVQcmludE1hcmdpbj1mdW5jdGlvbigpe2lmKCF0aGlzLiRzaG93UHJpbnRNYXJnaW4mJiF0aGlzLiRwcmludE1hcmdpbkVsKXJldHVybjtpZighdGhpcy4kcHJpbnRNYXJnaW5FbCl7dmFyIGU9aS5jcmVhdGVFbGVtZW50KCJkaXYiKTtlLmNsYXNzTmFtZT0iYWNlX2xheWVyIGFjZV9wcmludC1tYXJnaW4tbGF5ZXIiLHRoaXMuJHByaW50TWFyZ2luRWw9aS5jcmVhdGVFbGVtZW50KCJkaXYiKSx0aGlzLiRwcmludE1hcmdpbkVsLmNsYXNzTmFtZT0iYWNlX3ByaW50LW1hcmdpbiIsZS5hcHBlbmRDaGlsZCh0aGlzLiRwcmludE1hcmdpbkVsKSx0aGlzLmNvbnRlbnQuaW5zZXJ0QmVmb3JlKGUsdGhpcy5jb250ZW50LmZpcnN0Q2hpbGQpfXZhciB0PXRoaXMuJHByaW50TWFyZ2luRWwuc3R5bGU7dC5sZWZ0PU1hdGgucm91bmQodGhpcy5jaGFyYWN0ZXJXaWR0aCp0aGlzLiRwcmludE1hcmdpbkNvbHVtbit0aGlzLiRwYWRkaW5nKSsicHgiLHQudmlzaWJpbGl0eT10aGlzLiRzaG93UHJpbnRNYXJnaW4/InZpc2libGUiOiJoaWRkZW4iLHRoaXMuc2Vzc2lvbiYmdGhpcy5zZXNzaW9uLiR3cmFwPT0tMSYmdGhpcy5hZGp1c3RXcmFwTGltaXQoKX0sdGhpcy5nZXRDb250YWluZXJFbGVtZW50PWZ1bmN0aW9uKCl7cmV0dXJuIHRoaXMuY29udGFpbmVyfSx0aGlzLmdldE1vdXNlRXZlbnRUYXJnZXQ9ZnVuY3Rpb24oKXtyZXR1cm4gdGhpcy5zY3JvbGxlcn0sdGhpcy5nZXRUZXh0QXJlYUNvbnRhaW5lcj1mdW5jdGlvbigpe3JldHVybiB0aGlzLmNvbnRhaW5lcn0sdGhpcy4kbW92ZVRleHRBcmVhVG9DdXJzb3I9ZnVuY3Rpb24oKXtpZih0aGlzLiRpc01vdXNlUHJlc3NlZClyZXR1cm47dmFyIGU9dGhpcy50ZXh0YXJlYS5zdHlsZSx0PXRoaXMuJGNvbXBvc2l0aW9uO2lmKCF0aGlzLiRrZWVwVGV4dEFyZWFBdEN1cnNvciYmIXQpe2kudHJhbnNsYXRlKHRoaXMudGV4dGFyZWEsLTEwMCwwKTtyZXR1cm59dmFyIG49dGhpcy4kY3Vyc29yTGF5ZXIuJHBpeGVsUG9zO2lmKCFuKXJldHVybjt0JiZ0Lm1hcmtlclJhbmdlJiYobj10aGlzLiRjdXJzb3JMYXllci5nZXRQaXhlbFBvc2l0aW9uKHQubWFya2VyUmFuZ2Uuc3RhcnQsITApKTt2YXIgcj10aGlzLmxheWVyQ29uZmlnLHM9bi50b3Asbz1uLmxlZnQ7cy09ci5vZmZzZXQ7dmFyIHU9dCYmdC51c2VUZXh0YXJlYUZvcklNRT90aGlzLmxpbmVIZWlnaHQ6dz8wOjE7aWYoczwwfHxzPnIuaGVpZ2h0LXUpe2kudHJhbnNsYXRlKHRoaXMudGV4dGFyZWEsMCwwKTtyZXR1cm59dmFyIGE9MSxmPXRoaXMuJHNpemUuaGVpZ2h0LXU7aWYoIXQpcys9dGhpcy5saW5lSGVpZ2h0O2Vsc2UgaWYodC51c2VUZXh0YXJlYUZvcklNRSl7dmFyIGw9dGhpcy50ZXh0YXJlYS52YWx1ZTthPXRoaXMuY2hhcmFjdGVyV2lkdGgqdGhpcy5zZXNzaW9uLiRnZXRTdHJpbmdTY3JlZW5XaWR0aChsKVswXX1lbHNlIHMrPXRoaXMubGluZUhlaWdodCsyO28tPXRoaXMuc2Nyb2xsTGVmdCxvPnRoaXMuJHNpemUuc2Nyb2xsZXJXaWR0aC1hJiYobz10aGlzLiRzaXplLnNjcm9sbGVyV2lkdGgtYSksbys9dGhpcy5ndXR0ZXJXaWR0aCt0aGlzLm1hcmdpbi5sZWZ0LGkuc2V0U3R5bGUoZSwiaGVpZ2h0Iix1KyJweCIpLGkuc2V0U3R5bGUoZSwid2lkdGgiLGErInB4IiksaS50cmFuc2xhdGUodGhpcy50ZXh0YXJlYSxNYXRoLm1pbihvLHRoaXMuJHNpemUuc2Nyb2xsZXJXaWR0aC1hKSxNYXRoLm1pbihzLGYpKX0sdGhpcy5nZXRGaXJzdFZpc2libGVSb3c9ZnVuY3Rpb24oKXtyZXR1cm4gdGhpcy5sYXllckNvbmZpZy5maXJzdFJvd30sdGhpcy5nZXRGaXJzdEZ1bGx5VmlzaWJsZVJvdz1mdW5jdGlvbigpe3JldHVybiB0aGlzLmxheWVyQ29uZmlnLmZpcnN0Um93Kyh0aGlzLmxheWVyQ29uZmlnLm9mZnNldD09PTA/MDoxKX0sdGhpcy5nZXRMYXN0RnVsbHlWaXNpYmxlUm93PWZ1bmN0aW9uKCl7dmFyIGU9dGhpcy5sYXllckNvbmZpZyx0PWUubGFzdFJvdyxuPXRoaXMuc2Vzc2lvbi5kb2N1bWVudFRvU2NyZWVuUm93KHQsMCkqZS5saW5lSGVpZ2h0O3JldHVybiBuLXRoaXMuc2Vzc2lvbi5nZXRTY3JvbGxUb3AoKT5lLmhlaWdodC1lLmxpbmVIZWlnaHQ/dC0xOnR9LHRoaXMuZ2V0TGFzdFZpc2libGVSb3c9ZnVuY3Rpb24oKXtyZXR1cm4gdGhpcy5sYXllckNvbmZpZy5sYXN0Um93fSx0aGlzLiRwYWRkaW5nPW51bGwsdGhpcy5zZXRQYWRkaW5nPWZ1bmN0aW9uKGUpe3RoaXMuJHBhZGRpbmc9ZSx0aGlzLiR0ZXh0TGF5ZXIuc2V0UGFkZGluZyhlKSx0aGlzLiRjdXJzb3JMYXllci5zZXRQYWRkaW5nKGUpLHRoaXMuJG1hcmtlckZyb250LnNldFBhZGRpbmcoZSksdGhpcy4kbWFya2VyQmFjay5zZXRQYWRkaW5nKGUpLHRoaXMuJGxvb3Auc2NoZWR1bGUodGhpcy5DSEFOR0VfRlVMTCksdGhpcy4kdXBkYXRlUHJpbnRNYXJnaW4oKX0sdGhpcy5zZXRTY3JvbGxNYXJnaW49ZnVuY3Rpb24oZSx0LG4scil7dmFyIGk9dGhpcy5zY3JvbGxNYXJnaW47aS50b3A9ZXwwLGkuYm90dG9tPXR8MCxpLnJpZ2h0PXJ8MCxpLmxlZnQ9bnwwLGkudj1pLnRvcCtpLmJvdHRvbSxpLmg9aS5sZWZ0K2kucmlnaHQsaS50b3AmJnRoaXMuc2Nyb2xsVG9wPD0wJiZ0aGlzLnNlc3Npb24mJnRoaXMuc2Vzc2lvbi5zZXRTY3JvbGxUb3AoLWkudG9wKSx0aGlzLnVwZGF0ZUZ1bGwoKX0sdGhpcy5zZXRNYXJnaW49ZnVuY3Rpb24oZSx0LG4scil7dmFyIGk9dGhpcy5tYXJnaW47aS50b3A9ZXwwLGkuYm90dG9tPXR8MCxpLnJpZ2h0PXJ8MCxpLmxlZnQ9bnwwLGkudj1pLnRvcCtpLmJvdHRvbSxpLmg9aS5sZWZ0K2kucmlnaHQsdGhpcy4kdXBkYXRlQ2FjaGVkU2l6ZSghMCx0aGlzLmd1dHRlcldpZHRoLHRoaXMuJHNpemUud2lkdGgsdGhpcy4kc2l6ZS5oZWlnaHQpLHRoaXMudXBkYXRlRnVsbCgpfSx0aGlzLmdldEhTY3JvbGxCYXJBbHdheXNWaXNpYmxlPWZ1bmN0aW9uKCl7cmV0dXJuIHRoaXMuJGhTY3JvbGxCYXJBbHdheXNWaXNpYmxlfSx0aGlzLnNldEhTY3JvbGxCYXJBbHdheXNWaXNpYmxlPWZ1bmN0aW9uKGUpe3RoaXMuc2V0T3B0aW9uKCJoU2Nyb2xsQmFyQWx3YXlzVmlzaWJsZSIsZSl9LHRoaXMuZ2V0VlNjcm9sbEJhckFsd2F5c1Zpc2libGU9ZnVuY3Rpb24oKXtyZXR1cm4gdGhpcy4kdlNjcm9sbEJhckFsd2F5c1Zpc2libGV9LHRoaXMuc2V0VlNjcm9sbEJhckFsd2F5c1Zpc2libGU9ZnVuY3Rpb24oZSl7dGhpcy5zZXRPcHRpb24oInZTY3JvbGxCYXJBbHdheXNWaXNpYmxlIixlKX0sdGhpcy4kdXBkYXRlU2Nyb2xsQmFyVj1mdW5jdGlvbigpe3ZhciBlPXRoaXMubGF5ZXJDb25maWcubWF4SGVpZ2h0LHQ9dGhpcy4kc2l6ZS5zY3JvbGxlckhlaWdodDshdGhpcy4kbWF4TGluZXMmJnRoaXMuJHNjcm9sbFBhc3RFbmQmJihlLT0odC10aGlzLmxpbmVIZWlnaHQpKnRoaXMuJHNjcm9sbFBhc3RFbmQsdGhpcy5zY3JvbGxUb3A+ZS10JiYoZT10aGlzLnNjcm9sbFRvcCt0LHRoaXMuc2Nyb2xsQmFyVi5zY3JvbGxUb3A9bnVsbCkpLHRoaXMuc2Nyb2xsQmFyVi5zZXRTY3JvbGxIZWlnaHQoZSt0aGlzLnNjcm9sbE1hcmdpbi52KSx0aGlzLnNjcm9sbEJhclYuc2V0U2Nyb2xsVG9wKHRoaXMuc2Nyb2xsVG9wK3RoaXMuc2Nyb2xsTWFyZ2luLnRvcCl9LHRoaXMuJHVwZGF0ZVNjcm9sbEJhckg9ZnVuY3Rpb24oKXt0aGlzLnNjcm9sbEJhckguc2V0U2Nyb2xsV2lkdGgodGhpcy5sYXllckNvbmZpZy53aWR0aCsyKnRoaXMuJHBhZGRpbmcrdGhpcy5zY3JvbGxNYXJnaW4uaCksdGhpcy5zY3JvbGxCYXJILnNldFNjcm9sbExlZnQodGhpcy5zY3JvbGxMZWZ0K3RoaXMuc2Nyb2xsTWFyZ2luLmxlZnQpfSx0aGlzLiRmcm96ZW49ITEsdGhpcy5mcmVlemU9ZnVuY3Rpb24oKXt0aGlzLiRmcm96ZW49ITB9LHRoaXMudW5mcmVlemU9ZnVuY3Rpb24oKXt0aGlzLiRmcm96ZW49ITF9LHRoaXMuJHJlbmRlckNoYW5nZXM9ZnVuY3Rpb24oZSx0KXt0aGlzLiRjaGFuZ2VzJiYoZXw9dGhpcy4kY2hhbmdlcyx0aGlzLiRjaGFuZ2VzPTApO2lmKCF0aGlzLnNlc3Npb258fCF0aGlzLmNvbnRhaW5lci5vZmZzZXRXaWR0aHx8dGhpcy4kZnJvemVufHwhZSYmIXQpe3RoaXMuJGNoYW5nZXN8PWU7cmV0dXJufWlmKHRoaXMuJHNpemUuJGRpcnR5KXJldHVybiB0aGlzLiRjaGFuZ2VzfD1lLHRoaXMub25SZXNpemUoITApO3RoaXMubGluZUhlaWdodHx8dGhpcy4kdGV4dExheWVyLmNoZWNrRm9yU2l6ZUNoYW5nZXMoKSx0aGlzLl9zaWduYWwoImJlZm9yZVJlbmRlciIsZSksdGhpcy5zZXNzaW9uJiZ0aGlzLnNlc3Npb24uJGJpZGlIYW5kbGVyJiZ0aGlzLnNlc3Npb24uJGJpZGlIYW5kbGVyLnVwZGF0ZUNoYXJhY3RlcldpZHRocyh0aGlzLiRmb250TWV0cmljcyk7dmFyIG49dGhpcy5sYXllckNvbmZpZztpZihlJnRoaXMuQ0hBTkdFX0ZVTEx8fGUmdGhpcy5DSEFOR0VfU0laRXx8ZSZ0aGlzLkNIQU5HRV9URVhUfHxlJnRoaXMuQ0hBTkdFX0xJTkVTfHxlJnRoaXMuQ0hBTkdFX1NDUk9MTHx8ZSZ0aGlzLkNIQU5HRV9IX1NDUk9MTCl7ZXw9dGhpcy4kY29tcHV0ZUxheWVyQ29uZmlnKCl8dGhpcy4kbG9vcC5jbGVhcigpO2lmKG4uZmlyc3RSb3chPXRoaXMubGF5ZXJDb25maWcuZmlyc3RSb3cmJm4uZmlyc3RSb3dTY3JlZW49PXRoaXMubGF5ZXJDb25maWcuZmlyc3RSb3dTY3JlZW4pe3ZhciByPXRoaXMuc2Nyb2xsVG9wKyhuLmZpcnN0Um93LXRoaXMubGF5ZXJDb25maWcuZmlyc3RSb3cpKnRoaXMubGluZUhlaWdodDtyPjAmJih0aGlzLnNjcm9sbFRvcD1yLGV8PXRoaXMuQ0hBTkdFX1NDUk9MTCxlfD10aGlzLiRjb21wdXRlTGF5ZXJDb25maWcoKXx0aGlzLiRsb29wLmNsZWFyKCkpfW49dGhpcy5sYXllckNvbmZpZyx0aGlzLiR1cGRhdGVTY3JvbGxCYXJWKCksZSZ0aGlzLkNIQU5HRV9IX1NDUk9MTCYmdGhpcy4kdXBkYXRlU2Nyb2xsQmFySCgpLGkudHJhbnNsYXRlKHRoaXMuY29udGVudCwtdGhpcy5zY3JvbGxMZWZ0LC1uLm9mZnNldCk7dmFyIHM9bi53aWR0aCsyKnRoaXMuJHBhZGRpbmcrInB4IixvPW4ubWluSGVpZ2h0KyJweCI7aS5zZXRTdHlsZSh0aGlzLmNvbnRlbnQuc3R5bGUsIndpZHRoIixzKSxpLnNldFN0eWxlKHRoaXMuY29udGVudC5zdHlsZSwiaGVpZ2h0IixvKX1lJnRoaXMuQ0hBTkdFX0hfU0NST0xMJiYoaS50cmFuc2xhdGUodGhpcy5jb250ZW50LC10aGlzLnNjcm9sbExlZnQsLW4ub2Zmc2V0KSx0aGlzLnNjcm9sbGVyLmNsYXNzTmFtZT10aGlzLnNjcm9sbExlZnQ8PTA/ImFjZV9zY3JvbGxlciI6ImFjZV9zY3JvbGxlciBhY2Vfc2Nyb2xsLWxlZnQiKTtpZihlJnRoaXMuQ0hBTkdFX0ZVTEwpe3RoaXMuJGNoYW5nZWRMaW5lcz1udWxsLHRoaXMuJHRleHRMYXllci51cGRhdGUobiksdGhpcy4kc2hvd0d1dHRlciYmdGhpcy4kZ3V0dGVyTGF5ZXIudXBkYXRlKG4pLHRoaXMuJGN1c3RvbVNjcm9sbGJhciYmdGhpcy4kc2Nyb2xsRGVjb3JhdG9yLiR1cGRhdGVEZWNvcmF0b3JzKG4pLHRoaXMuJG1hcmtlckJhY2sudXBkYXRlKG4pLHRoaXMuJG1hcmtlckZyb250LnVwZGF0ZShuKSx0aGlzLiRjdXJzb3JMYXllci51cGRhdGUobiksdGhpcy4kbW92ZVRleHRBcmVhVG9DdXJzb3IoKSx0aGlzLl9zaWduYWwoImFmdGVyUmVuZGVyIixlKTtyZXR1cm59aWYoZSZ0aGlzLkNIQU5HRV9TQ1JPTEwpe3RoaXMuJGNoYW5nZWRMaW5lcz1udWxsLGUmdGhpcy5DSEFOR0VfVEVYVHx8ZSZ0aGlzLkNIQU5HRV9MSU5FUz90aGlzLiR0ZXh0TGF5ZXIudXBkYXRlKG4pOnRoaXMuJHRleHRMYXllci5zY3JvbGxMaW5lcyhuKSx0aGlzLiRzaG93R3V0dGVyJiYoZSZ0aGlzLkNIQU5HRV9HVVRURVJ8fGUmdGhpcy5DSEFOR0VfTElORVM/dGhpcy4kZ3V0dGVyTGF5ZXIudXBkYXRlKG4pOnRoaXMuJGd1dHRlckxheWVyLnNjcm9sbExpbmVzKG4pKSx0aGlzLiRjdXN0b21TY3JvbGxiYXImJnRoaXMuJHNjcm9sbERlY29yYXRvci4kdXBkYXRlRGVjb3JhdG9ycyhuKSx0aGlzLiRtYXJrZXJCYWNrLnVwZGF0ZShuKSx0aGlzLiRtYXJrZXJGcm9udC51cGRhdGUobiksdGhpcy4kY3Vyc29yTGF5ZXIudXBkYXRlKG4pLHRoaXMuJG1vdmVUZXh0QXJlYVRvQ3Vyc29yKCksdGhpcy5fc2lnbmFsKCJhZnRlclJlbmRlciIsZSk7cmV0dXJufWUmdGhpcy5DSEFOR0VfVEVYVD8odGhpcy4kY2hhbmdlZExpbmVzPW51bGwsdGhpcy4kdGV4dExheWVyLnVwZGF0ZShuKSx0aGlzLiRzaG93R3V0dGVyJiZ0aGlzLiRndXR0ZXJMYXllci51cGRhdGUobiksdGhpcy4kY3VzdG9tU2Nyb2xsYmFyJiZ0aGlzLiRzY3JvbGxEZWNvcmF0b3IuJHVwZGF0ZURlY29yYXRvcnMobikpOmUmdGhpcy5DSEFOR0VfTElORVM/KCh0aGlzLiR1cGRhdGVMaW5lcygpfHxlJnRoaXMuQ0hBTkdFX0dVVFRFUiYmdGhpcy4kc2hvd0d1dHRlcikmJnRoaXMuJGd1dHRlckxheWVyLnVwZGF0ZShuKSx0aGlzLiRjdXN0b21TY3JvbGxiYXImJnRoaXMuJHNjcm9sbERlY29yYXRvci4kdXBkYXRlRGVjb3JhdG9ycyhuKSk6ZSZ0aGlzLkNIQU5HRV9URVhUfHxlJnRoaXMuQ0hBTkdFX0dVVFRFUj8odGhpcy4kc2hvd0d1dHRlciYmdGhpcy4kZ3V0dGVyTGF5ZXIudXBkYXRlKG4pLHRoaXMuJGN1c3RvbVNjcm9sbGJhciYmdGhpcy4kc2Nyb2xsRGVjb3JhdG9yLiR1cGRhdGVEZWNvcmF0b3JzKG4pKTplJnRoaXMuQ0hBTkdFX0NVUlNPUiYmKHRoaXMuJGhpZ2hsaWdodEd1dHRlckxpbmUmJnRoaXMuJGd1dHRlckxheWVyLnVwZGF0ZUxpbmVIaWdobGlnaHQobiksdGhpcy4kY3VzdG9tU2Nyb2xsYmFyJiZ0aGlzLiRzY3JvbGxEZWNvcmF0b3IuJHVwZGF0ZURlY29yYXRvcnMobikpLGUmdGhpcy5DSEFOR0VfQ1VSU09SJiYodGhpcy4kY3Vyc29yTGF5ZXIudXBkYXRlKG4pLHRoaXMuJG1vdmVUZXh0QXJlYVRvQ3Vyc29yKCkpLGUmKHRoaXMuQ0hBTkdFX01BUktFUnx0aGlzLkNIQU5HRV9NQVJLRVJfRlJPTlQpJiZ0aGlzLiRtYXJrZXJGcm9udC51cGRhdGUobiksZSYodGhpcy5DSEFOR0VfTUFSS0VSfHRoaXMuQ0hBTkdFX01BUktFUl9CQUNLKSYmdGhpcy4kbWFya2VyQmFjay51cGRhdGUobiksdGhpcy5fc2lnbmFsKCJhZnRlclJlbmRlciIsZSl9LHRoaXMuJGF1dG9zaXplPWZ1bmN0aW9uKCl7dmFyIGU9dGhpcy5zZXNzaW9uLmdldFNjcmVlbkxlbmd0aCgpKnRoaXMubGluZUhlaWdodCx0PXRoaXMuJG1heExpbmVzKnRoaXMubGluZUhlaWdodCxuPU1hdGgubWluKHQsTWF0aC5tYXgoKHRoaXMuJG1pbkxpbmVzfHwxKSp0aGlzLmxpbmVIZWlnaHQsZSkpK3RoaXMuc2Nyb2xsTWFyZ2luLnYrKHRoaXMuJGV4dHJhSGVpZ2h0fHwwKTt0aGlzLiRob3JpelNjcm9sbCYmKG4rPXRoaXMuc2Nyb2xsQmFySC5nZXRIZWlnaHQoKSksdGhpcy4kbWF4UGl4ZWxIZWlnaHQmJm4+dGhpcy4kbWF4UGl4ZWxIZWlnaHQmJihuPXRoaXMuJG1heFBpeGVsSGVpZ2h0KTt2YXIgcj1uPD0yKnRoaXMubGluZUhlaWdodCxpPSFyJiZlPnQ7aWYobiE9dGhpcy5kZXNpcmVkSGVpZ2h0fHx0aGlzLiRzaXplLmhlaWdodCE9dGhpcy5kZXNpcmVkSGVpZ2h0fHxpIT10aGlzLiR2U2Nyb2xsKXtpIT10aGlzLiR2U2Nyb2xsJiYodGhpcy4kdlNjcm9sbD1pLHRoaXMuc2Nyb2xsQmFyVi5zZXRWaXNpYmxlKGkpKTt2YXIgcz10aGlzLmNvbnRhaW5lci5jbGllbnRXaWR0aDt0aGlzLmNvbnRhaW5lci5zdHlsZS5oZWlnaHQ9bisicHgiLHRoaXMuJHVwZGF0ZUNhY2hlZFNpemUoITAsdGhpcy4kZ3V0dGVyV2lkdGgscyxuKSx0aGlzLmRlc2lyZWRIZWlnaHQ9bix0aGlzLl9zaWduYWwoImF1dG9zaXplIil9fSx0aGlzLiRjb21wdXRlTGF5ZXJDb25maWc9ZnVuY3Rpb24oKXt2YXIgZT10aGlzLnNlc3Npb24sdD10aGlzLiRzaXplLG49dC5oZWlnaHQ8PTIqdGhpcy5saW5lSGVpZ2h0LHI9dGhpcy5zZXNzaW9uLmdldFNjcmVlbkxlbmd0aCgpLGk9cip0aGlzLmxpbmVIZWlnaHQscz10aGlzLiRnZXRMb25nZXN0TGluZSgpLG89IW4mJih0aGlzLiRoU2Nyb2xsQmFyQWx3YXlzVmlzaWJsZXx8dC5zY3JvbGxlcldpZHRoLXMtMip0aGlzLiRwYWRkaW5nPDApLHU9dGhpcy4kaG9yaXpTY3JvbGwhPT1vO3UmJih0aGlzLiRob3JpelNjcm9sbD1vLHRoaXMuc2Nyb2xsQmFySC5zZXRWaXNpYmxlKG8pKTt2YXIgYT10aGlzLiR2U2Nyb2xsO3RoaXMuJG1heExpbmVzJiZ0aGlzLmxpbmVIZWlnaHQ+MSYmdGhpcy4kYXV0b3NpemUoKTt2YXIgZj10LnNjcm9sbGVySGVpZ2h0K3RoaXMubGluZUhlaWdodCxsPSF0aGlzLiRtYXhMaW5lcyYmdGhpcy4kc2Nyb2xsUGFzdEVuZD8odC5zY3JvbGxlckhlaWdodC10aGlzLmxpbmVIZWlnaHQpKnRoaXMuJHNjcm9sbFBhc3RFbmQ6MDtpKz1sO3ZhciBjPXRoaXMuc2Nyb2xsTWFyZ2luO3RoaXMuc2Vzc2lvbi5zZXRTY3JvbGxUb3AoTWF0aC5tYXgoLWMudG9wLE1hdGgubWluKHRoaXMuc2Nyb2xsVG9wLGktdC5zY3JvbGxlckhlaWdodCtjLmJvdHRvbSkpKSx0aGlzLnNlc3Npb24uc2V0U2Nyb2xsTGVmdChNYXRoLm1heCgtYy5sZWZ0LE1hdGgubWluKHRoaXMuc2Nyb2xsTGVmdCxzKzIqdGhpcy4kcGFkZGluZy10LnNjcm9sbGVyV2lkdGgrYy5yaWdodCkpKTt2YXIgaD0hbiYmKHRoaXMuJHZTY3JvbGxCYXJBbHdheXNWaXNpYmxlfHx0LnNjcm9sbGVySGVpZ2h0LWkrbDwwfHx0aGlzLnNjcm9sbFRvcD5jLnRvcCkscD1hIT09aDtwJiYodGhpcy4kdlNjcm9sbD1oLHRoaXMuc2Nyb2xsQmFyVi5zZXRWaXNpYmxlKGgpKTt2YXIgZD10aGlzLnNjcm9sbFRvcCV0aGlzLmxpbmVIZWlnaHQsdj1NYXRoLmNlaWwoZi90aGlzLmxpbmVIZWlnaHQpLTEsbT1NYXRoLm1heCgwLE1hdGgucm91bmQoKHRoaXMuc2Nyb2xsVG9wLWQpL3RoaXMubGluZUhlaWdodCkpLGc9bSt2LHksYix3PXRoaXMubGluZUhlaWdodDttPWUuc2NyZWVuVG9Eb2N1bWVudFJvdyhtLDApO3ZhciBFPWUuZ2V0Rm9sZExpbmUobSk7RSYmKG09RS5zdGFydC5yb3cpLHk9ZS5kb2N1bWVudFRvU2NyZWVuUm93KG0sMCksYj1lLmdldFJvd0xlbmd0aChtKSp3LGc9TWF0aC5taW4oZS5zY3JlZW5Ub0RvY3VtZW50Um93KGcsMCksZS5nZXRMZW5ndGgoKS0xKSxmPXQuc2Nyb2xsZXJIZWlnaHQrZS5nZXRSb3dMZW5ndGgoZykqdytiLGQ9dGhpcy5zY3JvbGxUb3AteSp3O3ZhciBTPTA7aWYodGhpcy5sYXllckNvbmZpZy53aWR0aCE9c3x8dSlTPXRoaXMuQ0hBTkdFX0hfU0NST0xMO2lmKHV8fHApU3w9dGhpcy4kdXBkYXRlQ2FjaGVkU2l6ZSghMCx0aGlzLmd1dHRlcldpZHRoLHQud2lkdGgsdC5oZWlnaHQpLHRoaXMuX3NpZ25hbCgic2Nyb2xsYmFyVmlzaWJpbGl0eUNoYW5nZWQiKSxwJiYocz10aGlzLiRnZXRMb25nZXN0TGluZSgpKTtyZXR1cm4gdGhpcy5sYXllckNvbmZpZz17d2lkdGg6cyxwYWRkaW5nOnRoaXMuJHBhZGRpbmcsZmlyc3RSb3c6bSxmaXJzdFJvd1NjcmVlbjp5LGxhc3RSb3c6ZyxsaW5lSGVpZ2h0OncsY2hhcmFjdGVyV2lkdGg6dGhpcy5jaGFyYWN0ZXJXaWR0aCxtaW5IZWlnaHQ6ZixtYXhIZWlnaHQ6aSxvZmZzZXQ6ZCxndXR0ZXJPZmZzZXQ6dz9NYXRoLm1heCgwLE1hdGguY2VpbCgoZCt0LmhlaWdodC10LnNjcm9sbGVySGVpZ2h0KS93KSk6MCxoZWlnaHQ6dGhpcy4kc2l6ZS5zY3JvbGxlckhlaWdodH0sdGhpcy5zZXNzaW9uLiRiaWRpSGFuZGxlciYmdGhpcy5zZXNzaW9uLiRiaWRpSGFuZGxlci5zZXRDb250ZW50V2lkdGgocy10aGlzLiRwYWRkaW5nKSxTfSx0aGlzLiR1cGRhdGVMaW5lcz1mdW5jdGlvbigpe2lmKCF0aGlzLiRjaGFuZ2VkTGluZXMpcmV0dXJuO3ZhciBlPXRoaXMuJGNoYW5nZWRMaW5lcy5maXJzdFJvdyx0PXRoaXMuJGNoYW5nZWRMaW5lcy5sYXN0Um93O3RoaXMuJGNoYW5nZWRMaW5lcz1udWxsO3ZhciBuPXRoaXMubGF5ZXJDb25maWc7aWYoZT5uLmxhc3RSb3crMSlyZXR1cm47aWYodDxuLmZpcnN0Um93KXJldHVybjtpZih0PT09SW5maW5pdHkpe3RoaXMuJHNob3dHdXR0ZXImJnRoaXMuJGd1dHRlckxheWVyLnVwZGF0ZShuKSx0aGlzLiR0ZXh0TGF5ZXIudXBkYXRlKG4pO3JldHVybn1yZXR1cm4gdGhpcy4kdGV4dExheWVyLnVwZGF0ZUxpbmVzKG4sZSx0KSwhMH0sdGhpcy4kZ2V0TG9uZ2VzdExpbmU9ZnVuY3Rpb24oKXt2YXIgZT10aGlzLnNlc3Npb24uZ2V0U2NyZWVuV2lkdGgoKTtyZXR1cm4gdGhpcy5zaG93SW52aXNpYmxlcyYmIXRoaXMuc2Vzc2lvbi4kdXNlV3JhcE1vZGUmJihlKz0xKSx0aGlzLiR0ZXh0TGF5ZXImJmU+dGhpcy4kdGV4dExheWVyLk1BWF9MSU5FX0xFTkdUSCYmKGU9dGhpcy4kdGV4dExheWVyLk1BWF9MSU5FX0xFTkdUSCszMCksTWF0aC5tYXgodGhpcy4kc2l6ZS5zY3JvbGxlcldpZHRoLTIqdGhpcy4kcGFkZGluZyxNYXRoLnJvdW5kKGUqdGhpcy5jaGFyYWN0ZXJXaWR0aCkpfSx0aGlzLnVwZGF0ZUZyb250TWFya2Vycz1mdW5jdGlvbigpe3RoaXMuJG1hcmtlckZyb250LnNldE1hcmtlcnModGhpcy5zZXNzaW9uLmdldE1hcmtlcnMoITApKSx0aGlzLiRsb29wLnNjaGVkdWxlKHRoaXMuQ0hBTkdFX01BUktFUl9GUk9OVCl9LHRoaXMudXBkYXRlQmFja01hcmtlcnM9ZnVuY3Rpb24oKXt0aGlzLiRtYXJrZXJCYWNrLnNldE1hcmtlcnModGhpcy5zZXNzaW9uLmdldE1hcmtlcnMoKSksdGhpcy4kbG9vcC5zY2hlZHVsZSh0aGlzLkNIQU5HRV9NQVJLRVJfQkFDSyl9LHRoaXMuYWRkR3V0dGVyRGVjb3JhdGlvbj1mdW5jdGlvbihlLHQpe3RoaXMuJGd1dHRlckxheWVyLmFkZEd1dHRlckRlY29yYXRpb24oZSx0KX0sdGhpcy5yZW1vdmVHdXR0ZXJEZWNvcmF0aW9uPWZ1bmN0aW9uKGUsdCl7dGhpcy4kZ3V0dGVyTGF5ZXIucmVtb3ZlR3V0dGVyRGVjb3JhdGlvbihlLHQpfSx0aGlzLnVwZGF0ZUJyZWFrcG9pbnRzPWZ1bmN0aW9uKGUpe3RoaXMuJGxvb3Auc2NoZWR1bGUodGhpcy5DSEFOR0VfR1VUVEVSKX0sdGhpcy5zZXRBbm5vdGF0aW9ucz1mdW5jdGlvbihlKXt0aGlzLiRndXR0ZXJMYXllci5zZXRBbm5vdGF0aW9ucyhlKSx0aGlzLiRsb29wLnNjaGVkdWxlKHRoaXMuQ0hBTkdFX0dVVFRFUil9LHRoaXMudXBkYXRlQ3Vyc29yPWZ1bmN0aW9uKCl7dGhpcy4kbG9vcC5zY2hlZHVsZSh0aGlzLkNIQU5HRV9DVVJTT1IpfSx0aGlzLmhpZGVDdXJzb3I9ZnVuY3Rpb24oKXt0aGlzLiRjdXJzb3JMYXllci5oaWRlQ3Vyc29yKCl9LHRoaXMuc2hvd0N1cnNvcj1mdW5jdGlvbigpe3RoaXMuJGN1cnNvckxheWVyLnNob3dDdXJzb3IoKX0sdGhpcy5zY3JvbGxTZWxlY3Rpb25JbnRvVmlldz1mdW5jdGlvbihlLHQsbil7dGhpcy5zY3JvbGxDdXJzb3JJbnRvVmlldyhlLG4pLHRoaXMuc2Nyb2xsQ3Vyc29ySW50b1ZpZXcodCxuKX0sdGhpcy5zY3JvbGxDdXJzb3JJbnRvVmlldz1mdW5jdGlvbihlLHQsbil7aWYodGhpcy4kc2l6ZS5zY3JvbGxlckhlaWdodD09PTApcmV0dXJuO3ZhciByPXRoaXMuJGN1cnNvckxheWVyLmdldFBpeGVsUG9zaXRpb24oZSksaT1yLmxlZnQscz1yLnRvcCxvPW4mJm4udG9wfHwwLHU9biYmbi5ib3R0b218fDA7dGhpcy4kc2Nyb2xsQW5pbWF0aW9uJiYodGhpcy4kc3RvcEFuaW1hdGlvbj0hMCk7dmFyIGE9dGhpcy4kc2Nyb2xsQW5pbWF0aW9uP3RoaXMuc2Vzc2lvbi5nZXRTY3JvbGxUb3AoKTp0aGlzLnNjcm9sbFRvcDthK28+cz8odCYmYStvPnMrdGhpcy5saW5lSGVpZ2h0JiYocy09dCp0aGlzLiRzaXplLnNjcm9sbGVySGVpZ2h0KSxzPT09MCYmKHM9LXRoaXMuc2Nyb2xsTWFyZ2luLnRvcCksdGhpcy5zZXNzaW9uLnNldFNjcm9sbFRvcChzKSk6YSt0aGlzLiRzaXplLnNjcm9sbGVySGVpZ2h0LXU8cyt0aGlzLmxpbmVIZWlnaHQmJih0JiZhK3RoaXMuJHNpemUuc2Nyb2xsZXJIZWlnaHQtdTxzLXRoaXMubGluZUhlaWdodCYmKHMrPXQqdGhpcy4kc2l6ZS5zY3JvbGxlckhlaWdodCksdGhpcy5zZXNzaW9uLnNldFNjcm9sbFRvcChzK3RoaXMubGluZUhlaWdodCt1LXRoaXMuJHNpemUuc2Nyb2xsZXJIZWlnaHQpKTt2YXIgZj10aGlzLnNjcm9sbExlZnQ7Zj5pPyhpPHRoaXMuJHBhZGRpbmcrMip0aGlzLmxheWVyQ29uZmlnLmNoYXJhY3RlcldpZHRoJiYoaT0tdGhpcy5zY3JvbGxNYXJnaW4ubGVmdCksdGhpcy5zZXNzaW9uLnNldFNjcm9sbExlZnQoaSkpOmYrdGhpcy4kc2l6ZS5zY3JvbGxlcldpZHRoPGkrdGhpcy5jaGFyYWN0ZXJXaWR0aD90aGlzLnNlc3Npb24uc2V0U2Nyb2xsTGVmdChNYXRoLnJvdW5kKGkrdGhpcy5jaGFyYWN0ZXJXaWR0aC10aGlzLiRzaXplLnNjcm9sbGVyV2lkdGgpKTpmPD10aGlzLiRwYWRkaW5nJiZpLWY8dGhpcy5jaGFyYWN0ZXJXaWR0aCYmdGhpcy5zZXNzaW9uLnNldFNjcm9sbExlZnQoMCl9LHRoaXMuZ2V0U2Nyb2xsVG9wPWZ1bmN0aW9uKCl7cmV0dXJuIHRoaXMuc2Vzc2lvbi5nZXRTY3JvbGxUb3AoKX0sdGhpcy5nZXRTY3JvbGxMZWZ0PWZ1bmN0aW9uKCl7cmV0dXJuIHRoaXMuc2Vzc2lvbi5nZXRTY3JvbGxMZWZ0KCl9LHRoaXMuZ2V0U2Nyb2xsVG9wUm93PWZ1bmN0aW9uKCl7cmV0dXJuIHRoaXMuc2Nyb2xsVG9wL3RoaXMubGluZUhlaWdodH0sdGhpcy5nZXRTY3JvbGxCb3R0b21Sb3c9ZnVuY3Rpb24oKXtyZXR1cm4gTWF0aC5tYXgoMCxNYXRoLmZsb29yKCh0aGlzLnNjcm9sbFRvcCt0aGlzLiRzaXplLnNjcm9sbGVySGVpZ2h0KS90aGlzLmxpbmVIZWlnaHQpLTEpfSx0aGlzLnNjcm9sbFRvUm93PWZ1bmN0aW9uKGUpe3RoaXMuc2Vzc2lvbi5zZXRTY3JvbGxUb3AoZSp0aGlzLmxpbmVIZWlnaHQpfSx0aGlzLmFsaWduQ3Vyc29yPWZ1bmN0aW9uKGUsdCl7dHlwZW9mIGU9PSJudW1iZXIiJiYoZT17cm93OmUsY29sdW1uOjB9KTt2YXIgbj10aGlzLiRjdXJzb3JMYXllci5nZXRQaXhlbFBvc2l0aW9uKGUpLHI9dGhpcy4kc2l6ZS5zY3JvbGxlckhlaWdodC10aGlzLmxpbmVIZWlnaHQsaT1uLnRvcC1yKih0fHwwKTtyZXR1cm4gdGhpcy5zZXNzaW9uLnNldFNjcm9sbFRvcChpKSxpfSx0aGlzLlNURVBTPTgsdGhpcy4kY2FsY1N0ZXBzPWZ1bmN0aW9uKGUsdCl7dmFyIG49MCxyPXRoaXMuU1RFUFMsaT1bXSxzPWZ1bmN0aW9uKGUsdCxuKXtyZXR1cm4gbiooTWF0aC5wb3coZS0xLDMpKzEpK3R9O2ZvcihuPTA7bjxyOysrbilpLnB1c2gocyhuL3RoaXMuU1RFUFMsZSx0LWUpKTtyZXR1cm4gaX0sdGhpcy5zY3JvbGxUb0xpbmU9ZnVuY3Rpb24oZSx0LG4scil7dmFyIGk9dGhpcy4kY3Vyc29yTGF5ZXIuZ2V0UGl4ZWxQb3NpdGlvbih7cm93OmUsY29sdW1uOjB9KSxzPWkudG9wO3QmJihzLT10aGlzLiRzaXplLnNjcm9sbGVySGVpZ2h0LzIpO3ZhciBvPXRoaXMuc2Nyb2xsVG9wO3RoaXMuc2Vzc2lvbi5zZXRTY3JvbGxUb3AocyksbiE9PSExJiZ0aGlzLmFuaW1hdGVTY3JvbGxpbmcobyxyKX0sdGhpcy5hbmltYXRlU2Nyb2xsaW5nPWZ1bmN0aW9uKGUsdCl7ZnVuY3Rpb24gbygpe3IuJHRpbWVyPWNsZWFySW50ZXJ2YWwoci4kdGltZXIpLHIuJHNjcm9sbEFuaW1hdGlvbj1udWxsLHIuJHN0b3BBbmltYXRpb249ITEsdCYmdCgpfXZhciBuPXRoaXMuc2Nyb2xsVG9wO2lmKCF0aGlzLiRhbmltYXRlZFNjcm9sbClyZXR1cm47dmFyIHI9dGhpcztpZihlPT1uKXJldHVybjtpZih0aGlzLiRzY3JvbGxBbmltYXRpb24pe3ZhciBpPXRoaXMuJHNjcm9sbEFuaW1hdGlvbi5zdGVwcztpZihpLmxlbmd0aCl7ZT1pWzBdO2lmKGU9PW4pcmV0dXJufX12YXIgcz1yLiRjYWxjU3RlcHMoZSxuKTt0aGlzLiRzY3JvbGxBbmltYXRpb249e2Zyb206ZSx0bzpuLHN0ZXBzOnN9LGNsZWFySW50ZXJ2YWwodGhpcy4kdGltZXIpLHIuc2Vzc2lvbi5zZXRTY3JvbGxUb3Aocy5zaGlmdCgpKSxyLnNlc3Npb24uJHNjcm9sbFRvcD1uLHRoaXMuJHRpbWVyPXNldEludGVydmFsKGZ1bmN0aW9uKCl7aWYoci4kc3RvcEFuaW1hdGlvbil7bygpO3JldHVybn1pZighci5zZXNzaW9uKXJldHVybiBjbGVhckludGVydmFsKHIuJHRpbWVyKTtzLmxlbmd0aD8oci5zZXNzaW9uLnNldFNjcm9sbFRvcChzLnNoaWZ0KCkpLHIuc2Vzc2lvbi4kc2Nyb2xsVG9wPW4pOm4hPW51bGw/KHIuc2Vzc2lvbi4kc2Nyb2xsVG9wPS0xLHIuc2Vzc2lvbi5zZXRTY3JvbGxUb3Aobiksbj1udWxsKTpvKCl9LDEwKX0sdGhpcy5zY3JvbGxUb1k9ZnVuY3Rpb24oZSl7dGhpcy5zY3JvbGxUb3AhPT1lJiYodGhpcy4kbG9vcC5zY2hlZHVsZSh0aGlzLkNIQU5HRV9TQ1JPTEwpLHRoaXMuc2Nyb2xsVG9wPWUpfSx0aGlzLnNjcm9sbFRvWD1mdW5jdGlvbihlKXt0aGlzLnNjcm9sbExlZnQhPT1lJiYodGhpcy5zY3JvbGxMZWZ0PWUpLHRoaXMuJGxvb3Auc2NoZWR1bGUodGhpcy5DSEFOR0VfSF9TQ1JPTEwpfSx0aGlzLnNjcm9sbFRvPWZ1bmN0aW9uKGUsdCl7dGhpcy5zZXNzaW9uLnNldFNjcm9sbFRvcCh0KSx0aGlzLnNlc3Npb24uc2V0U2Nyb2xsTGVmdChlKX0sdGhpcy5zY3JvbGxCeT1mdW5jdGlvbihlLHQpe3QmJnRoaXMuc2Vzc2lvbi5zZXRTY3JvbGxUb3AodGhpcy5zZXNzaW9uLmdldFNjcm9sbFRvcCgpK3QpLGUmJnRoaXMuc2Vzc2lvbi5zZXRTY3JvbGxMZWZ0KHRoaXMuc2Vzc2lvbi5nZXRTY3JvbGxMZWZ0KCkrZSl9LHRoaXMuaXNTY3JvbGxhYmxlQnk9ZnVuY3Rpb24oZSx0KXtpZih0PDAmJnRoaXMuc2Vzc2lvbi5nZXRTY3JvbGxUb3AoKT49MS10aGlzLnNjcm9sbE1hcmdpbi50b3ApcmV0dXJuITA7aWYodD4wJiZ0aGlzLnNlc3Npb24uZ2V0U2Nyb2xsVG9wKCkrdGhpcy4kc2l6ZS5zY3JvbGxlckhlaWdodC10aGlzLmxheWVyQ29uZmlnLm1heEhlaWdodDwtMSt0aGlzLnNjcm9sbE1hcmdpbi5ib3R0b20pcmV0dXJuITA7aWYoZTwwJiZ0aGlzLnNlc3Npb24uZ2V0U2Nyb2xsTGVmdCgpPj0xLXRoaXMuc2Nyb2xsTWFyZ2luLmxlZnQpcmV0dXJuITA7aWYoZT4wJiZ0aGlzLnNlc3Npb24uZ2V0U2Nyb2xsTGVmdCgpK3RoaXMuJHNpemUuc2Nyb2xsZXJXaWR0aC10aGlzLmxheWVyQ29uZmlnLndpZHRoPC0xK3RoaXMuc2Nyb2xsTWFyZ2luLnJpZ2h0KXJldHVybiEwfSx0aGlzLnBpeGVsVG9TY3JlZW5Db29yZGluYXRlcz1mdW5jdGlvbihlLHQpe3ZhciBuO2lmKHRoaXMuJGhhc0Nzc1RyYW5zZm9ybXMpe249e3RvcDowLGxlZnQ6MH07dmFyIHI9dGhpcy4kZm9udE1ldHJpY3MudHJhbnNmb3JtQ29vcmRpbmF0ZXMoW2UsdF0pO2U9clsxXS10aGlzLmd1dHRlcldpZHRoLXRoaXMubWFyZ2luLmxlZnQsdD1yWzBdfWVsc2Ugbj10aGlzLnNjcm9sbGVyLmdldEJvdW5kaW5nQ2xpZW50UmVjdCgpO3ZhciBpPWUrdGhpcy5zY3JvbGxMZWZ0LW4ubGVmdC10aGlzLiRwYWRkaW5nLHM9aS90aGlzLmNoYXJhY3RlcldpZHRoLG89TWF0aC5mbG9vcigodCt0aGlzLnNjcm9sbFRvcC1uLnRvcCkvdGhpcy5saW5lSGVpZ2h0KSx1PXRoaXMuJGJsb2NrQ3Vyc29yP01hdGguZmxvb3Iocyk6TWF0aC5yb3VuZChzKTtyZXR1cm57cm93Om8sY29sdW1uOnUsc2lkZTpzLXU+MD8xOi0xLG9mZnNldFg6aX19LHRoaXMuc2NyZWVuVG9UZXh0Q29vcmRpbmF0ZXM9ZnVuY3Rpb24oZSx0KXt2YXIgbjtpZih0aGlzLiRoYXNDc3NUcmFuc2Zvcm1zKXtuPXt0b3A6MCxsZWZ0OjB9O3ZhciByPXRoaXMuJGZvbnRNZXRyaWNzLnRyYW5zZm9ybUNvb3JkaW5hdGVzKFtlLHRdKTtlPXJbMV0tdGhpcy5ndXR0ZXJXaWR0aC10aGlzLm1hcmdpbi5sZWZ0LHQ9clswXX1lbHNlIG49dGhpcy5zY3JvbGxlci5nZXRCb3VuZGluZ0NsaWVudFJlY3QoKTt2YXIgaT1lK3RoaXMuc2Nyb2xsTGVmdC1uLmxlZnQtdGhpcy4kcGFkZGluZyxzPWkvdGhpcy5jaGFyYWN0ZXJXaWR0aCxvPXRoaXMuJGJsb2NrQ3Vyc29yP01hdGguZmxvb3Iocyk6TWF0aC5yb3VuZChzKSx1PU1hdGguZmxvb3IoKHQrdGhpcy5zY3JvbGxUb3Atbi50b3ApL3RoaXMubGluZUhlaWdodCk7cmV0dXJuIHRoaXMuc2Vzc2lvbi5zY3JlZW5Ub0RvY3VtZW50UG9zaXRpb24odSxNYXRoLm1heChvLDApLGkpfSx0aGlzLnRleHRUb1NjcmVlbkNvb3JkaW5hdGVzPWZ1bmN0aW9uKGUsdCl7dmFyIG49dGhpcy5zY3JvbGxlci5nZXRCb3VuZGluZ0NsaWVudFJlY3QoKSxyPXRoaXMuc2Vzc2lvbi5kb2N1bWVudFRvU2NyZWVuUG9zaXRpb24oZSx0KSxpPXRoaXMuJHBhZGRpbmcrKHRoaXMuc2Vzc2lvbi4kYmlkaUhhbmRsZXIuaXNCaWRpUm93KHIucm93LGUpP3RoaXMuc2Vzc2lvbi4kYmlkaUhhbmRsZXIuZ2V0UG9zTGVmdChyLmNvbHVtbik6TWF0aC5yb3VuZChyLmNvbHVtbip0aGlzLmNoYXJhY3RlcldpZHRoKSkscz1yLnJvdyp0aGlzLmxpbmVIZWlnaHQ7cmV0dXJue3BhZ2VYOm4ubGVmdCtpLXRoaXMuc2Nyb2xsTGVmdCxwYWdlWTpuLnRvcCtzLXRoaXMuc2Nyb2xsVG9wfX0sdGhpcy52aXN1YWxpemVGb2N1cz1mdW5jdGlvbigpe2kuYWRkQ3NzQ2xhc3ModGhpcy5jb250YWluZXIsImFjZV9mb2N1cyIpfSx0aGlzLnZpc3VhbGl6ZUJsdXI9ZnVuY3Rpb24oKXtpLnJlbW92ZUNzc0NsYXNzKHRoaXMuY29udGFpbmVyLCJhY2VfZm9jdXMiKX0sdGhpcy5zaG93Q29tcG9zaXRpb249ZnVuY3Rpb24oZSl7dGhpcy4kY29tcG9zaXRpb249ZSxlLmNzc1RleHR8fChlLmNzc1RleHQ9dGhpcy50ZXh0YXJlYS5zdHlsZS5jc3NUZXh0KSxlLnVzZVRleHRhcmVhRm9ySU1FPT11bmRlZmluZWQmJihlLnVzZVRleHRhcmVhRm9ySU1FPXRoaXMuJHVzZVRleHRhcmVhRm9ySU1FKSx0aGlzLiR1c2VUZXh0YXJlYUZvcklNRT8oaS5hZGRDc3NDbGFzcyh0aGlzLnRleHRhcmVhLCJhY2VfY29tcG9zaXRpb24iKSx0aGlzLnRleHRhcmVhLnN0eWxlLmNzc1RleHQ9IiIsdGhpcy4kbW92ZVRleHRBcmVhVG9DdXJzb3IoKSx0aGlzLiRjdXJzb3JMYXllci5lbGVtZW50LnN0eWxlLmRpc3BsYXk9Im5vbmUiKTplLm1hcmtlcklkPXRoaXMuc2Vzc2lvbi5hZGRNYXJrZXIoZS5tYXJrZXJSYW5nZSwiYWNlX2NvbXBvc2l0aW9uX21hcmtlciIsInRleHQiKX0sdGhpcy5zZXRDb21wb3NpdGlvblRleHQ9ZnVuY3Rpb24oZSl7dmFyIHQ9dGhpcy5zZXNzaW9uLnNlbGVjdGlvbi5jdXJzb3I7dGhpcy5hZGRUb2tlbihlLCJjb21wb3NpdGlvbl9wbGFjZWhvbGRlciIsdC5yb3csdC5jb2x1bW4pLHRoaXMuJG1vdmVUZXh0QXJlYVRvQ3Vyc29yKCl9LHRoaXMuaGlkZUNvbXBvc2l0aW9uPWZ1bmN0aW9uKCl7aWYoIXRoaXMuJGNvbXBvc2l0aW9uKXJldHVybjt0aGlzLiRjb21wb3NpdGlvbi5tYXJrZXJJZCYmdGhpcy5zZXNzaW9uLnJlbW92ZU1hcmtlcih0aGlzLiRjb21wb3NpdGlvbi5tYXJrZXJJZCksaS5yZW1vdmVDc3NDbGFzcyh0aGlzLnRleHRhcmVhLCJhY2VfY29tcG9zaXRpb24iKSx0aGlzLnRleHRhcmVhLnN0eWxlLmNzc1RleHQ9dGhpcy4kY29tcG9zaXRpb24uY3NzVGV4dDt2YXIgZT10aGlzLnNlc3Npb24uc2VsZWN0aW9uLmN1cnNvcjt0aGlzLnJlbW92ZUV4dHJhVG9rZW4oZS5yb3csZS5jb2x1bW4pLHRoaXMuJGNvbXBvc2l0aW9uPW51bGwsdGhpcy4kY3Vyc29yTGF5ZXIuZWxlbWVudC5zdHlsZS5kaXNwbGF5PSIifSx0aGlzLmFkZFRva2VuPWZ1bmN0aW9uKGUsdCxuLHIpe3ZhciBpPXRoaXMuc2Vzc2lvbjtpLmJnVG9rZW5pemVyLmxpbmVzW25dPW51bGw7dmFyIHM9e3R5cGU6dCx2YWx1ZTplfSxvPWkuZ2V0VG9rZW5zKG4pO2lmKHI9PW51bGwpby5wdXNoKHMpO2Vsc2V7dmFyIHU9MDtmb3IodmFyIGE9MDthPG8ubGVuZ3RoO2ErKyl7dmFyIGY9b1thXTt1Kz1mLnZhbHVlLmxlbmd0aDtpZihyPD11KXt2YXIgbD1mLnZhbHVlLmxlbmd0aC0odS1yKSxjPWYudmFsdWUuc2xpY2UoMCxsKSxoPWYudmFsdWUuc2xpY2UobCk7by5zcGxpY2UoYSwxLHt0eXBlOmYudHlwZSx2YWx1ZTpjfSxzLHt0eXBlOmYudHlwZSx2YWx1ZTpofSk7YnJlYWt9fX10aGlzLnVwZGF0ZUxpbmVzKG4sbil9LHRoaXMucmVtb3ZlRXh0cmFUb2tlbj1mdW5jdGlvbihlLHQpe3RoaXMudXBkYXRlTGluZXMoZSxlKX0sdGhpcy5zZXRUaGVtZT1mdW5jdGlvbihlLHQpe2Z1bmN0aW9uIG8ocil7aWYobi4kdGhlbWVJZCE9ZSlyZXR1cm4gdCYmdCgpO2lmKCFyfHwhci5jc3NDbGFzcyl0aHJvdyBuZXcgRXJyb3IoImNvdWxkbid0IGxvYWQgbW9kdWxlICIrZSsiIG9yIGl0IGRpZG4ndCBjYWxsIGRlZmluZSIpO3IuJGlkJiYobi4kdGhlbWVJZD1yLiRpZCksaS5pbXBvcnRDc3NTdHJpbmcoci5jc3NUZXh0LHIuY3NzQ2xhc3Msbi5jb250YWluZXIpLG4udGhlbWUmJmkucmVtb3ZlQ3NzQ2xhc3Mobi5jb250YWluZXIsbi50aGVtZS5jc3NDbGFzcyk7dmFyIHM9InBhZGRpbmciaW4gcj9yLnBhZGRpbmc6InBhZGRpbmciaW4obi50aGVtZXx8e30pPzQ6bi4kcGFkZGluZztuLiRwYWRkaW5nJiZzIT1uLiRwYWRkaW5nJiZuLnNldFBhZGRpbmcocyksbi4kdGhlbWU9ci5jc3NDbGFzcyxuLnRoZW1lPXIsaS5hZGRDc3NDbGFzcyhuLmNvbnRhaW5lcixyLmNzc0NsYXNzKSxpLnNldENzc0NsYXNzKG4uY29udGFpbmVyLCJhY2VfZGFyayIsci5pc0RhcmspLG4uJHNpemUmJihuLiRzaXplLndpZHRoPTAsbi4kdXBkYXRlU2l6ZUFzeW5jKCkpLG4uX2Rpc3BhdGNoRXZlbnQoInRoZW1lTG9hZGVkIix7dGhlbWU6cn0pLHQmJnQoKX12YXIgbj10aGlzO3RoaXMuJHRoZW1lSWQ9ZSxuLl9kaXNwYXRjaEV2ZW50KCJ0aGVtZUNoYW5nZSIse3RoZW1lOmV9KTtpZighZXx8dHlwZW9mIGU9PSJzdHJpbmciKXt2YXIgcj1lfHx0aGlzLiRvcHRpb25zLnRoZW1lLmluaXRpYWxWYWx1ZTtzLmxvYWRNb2R1bGUoWyJ0aGVtZSIscl0sbyl9ZWxzZSBvKGUpfSx0aGlzLmdldFRoZW1lPWZ1bmN0aW9uKCl7cmV0dXJuIHRoaXMuJHRoZW1lSWR9LHRoaXMuc2V0U3R5bGU9ZnVuY3Rpb24oZSx0KXtpLnNldENzc0NsYXNzKHRoaXMuY29udGFpbmVyLGUsdCE9PSExKX0sdGhpcy51bnNldFN0eWxlPWZ1bmN0aW9uKGUpe2kucmVtb3ZlQ3NzQ2xhc3ModGhpcy5jb250YWluZXIsZSl9LHRoaXMuc2V0Q3Vyc29yU3R5bGU9ZnVuY3Rpb24oZSl7aS5zZXRTdHlsZSh0aGlzLnNjcm9sbGVyLnN0eWxlLCJjdXJzb3IiLGUpfSx0aGlzLnNldE1vdXNlQ3Vyc29yPWZ1bmN0aW9uKGUpe2kuc2V0U3R5bGUodGhpcy5zY3JvbGxlci5zdHlsZSwiY3Vyc29yIixlKX0sdGhpcy5hdHRhY2hUb1NoYWRvd1Jvb3Q9ZnVuY3Rpb24oKXtpLmltcG9ydENzc1N0cmluZyhnLCJhY2VfZWRpdG9yLmNzcyIsdGhpcy5jb250YWluZXIpfSx0aGlzLmRlc3Ryb3k9ZnVuY3Rpb24oKXt0aGlzLmZyZWV6ZSgpLHRoaXMuJGZvbnRNZXRyaWNzLmRlc3Ryb3koKSx0aGlzLiRjdXJzb3JMYXllci5kZXN0cm95KCksdGhpcy5yZW1vdmVBbGxMaXN0ZW5lcnMoKSx0aGlzLmNvbnRhaW5lci50ZXh0Q29udGVudD0iIn0sdGhpcy4kdXBkYXRlQ3VzdG9tU2Nyb2xsYmFyPWZ1bmN0aW9uKGUpe3ZhciB0PXRoaXM7dGhpcy4kaG9yaXpTY3JvbGw9dGhpcy4kdlNjcm9sbD1udWxsLHRoaXMuc2Nyb2xsQmFyVi5lbGVtZW50LnJlbW92ZSgpLHRoaXMuc2Nyb2xsQmFySC5lbGVtZW50LnJlbW92ZSgpLHRoaXMuJHNjcm9sbERlY29yYXRvciYmZGVsZXRlIHRoaXMuJHNjcm9sbERlY29yYXRvcixlPT09ITA/KHRoaXMuc2Nyb2xsQmFyVj1uZXcgcCh0aGlzLmNvbnRhaW5lcix0aGlzKSx0aGlzLnNjcm9sbEJhckg9bmV3IGgodGhpcy5jb250YWluZXIsdGhpcyksdGhpcy5zY3JvbGxCYXJWLnNldEhlaWdodCh0aGlzLiRzaXplLnNjcm9sbGVySGVpZ2h0KSx0aGlzLnNjcm9sbEJhckguc2V0V2lkdGgodGhpcy4kc2l6ZS5zY3JvbGxlcldpZHRoKSx0aGlzLnNjcm9sbEJhclYuYWRkRXZlbnRMaXN0ZW5lcigic2Nyb2xsIixmdW5jdGlvbihlKXt0LiRzY3JvbGxBbmltYXRpb258fHQuc2Vzc2lvbi5zZXRTY3JvbGxUb3AoZS5kYXRhLXQuc2Nyb2xsTWFyZ2luLnRvcCl9KSx0aGlzLnNjcm9sbEJhckguYWRkRXZlbnRMaXN0ZW5lcigic2Nyb2xsIixmdW5jdGlvbihlKXt0LiRzY3JvbGxBbmltYXRpb258fHQuc2Vzc2lvbi5zZXRTY3JvbGxMZWZ0KGUuZGF0YS10LnNjcm9sbE1hcmdpbi5sZWZ0KX0pLHRoaXMuJHNjcm9sbERlY29yYXRvcj1uZXcgeSh0aGlzLnNjcm9sbEJhclYsdGhpcyksdGhpcy4kc2Nyb2xsRGVjb3JhdG9yLiR1cGRhdGVEZWNvcmF0b3JzKCkpOih0aGlzLnNjcm9sbEJhclY9bmV3IGModGhpcy5jb250YWluZXIsdGhpcyksdGhpcy5zY3JvbGxCYXJIPW5ldyBsKHRoaXMuY29udGFpbmVyLHRoaXMpLHRoaXMuc2Nyb2xsQmFyVi5hZGRFdmVudExpc3RlbmVyKCJzY3JvbGwiLGZ1bmN0aW9uKGUpe3QuJHNjcm9sbEFuaW1hdGlvbnx8dC5zZXNzaW9uLnNldFNjcm9sbFRvcChlLmRhdGEtdC5zY3JvbGxNYXJnaW4udG9wKX0pLHRoaXMuc2Nyb2xsQmFySC5hZGRFdmVudExpc3RlbmVyKCJzY3JvbGwiLGZ1bmN0aW9uKGUpe3QuJHNjcm9sbEFuaW1hdGlvbnx8dC5zZXNzaW9uLnNldFNjcm9sbExlZnQoZS5kYXRhLXQuc2Nyb2xsTWFyZ2luLmxlZnQpfSkpfX0pLmNhbGwoRS5wcm90b3R5cGUpLHMuZGVmaW5lT3B0aW9ucyhFLnByb3RvdHlwZSwicmVuZGVyZXIiLHthbmltYXRlZFNjcm9sbDp7aW5pdGlhbFZhbHVlOiExfSxzaG93SW52aXNpYmxlczp7c2V0OmZ1bmN0aW9uKGUpe3RoaXMuJHRleHRMYXllci5zZXRTaG93SW52aXNpYmxlcyhlKSYmdGhpcy4kbG9vcC5zY2hlZHVsZSh0aGlzLkNIQU5HRV9URVhUKX0saW5pdGlhbFZhbHVlOiExfSxzaG93UHJpbnRNYXJnaW46e3NldDpmdW5jdGlvbigpe3RoaXMuJHVwZGF0ZVByaW50TWFyZ2luKCl9LGluaXRpYWxWYWx1ZTohMH0scHJpbnRNYXJnaW5Db2x1bW46e3NldDpmdW5jdGlvbigpe3RoaXMuJHVwZGF0ZVByaW50TWFyZ2luKCl9LGluaXRpYWxWYWx1ZTo4MH0scHJpbnRNYXJnaW46e3NldDpmdW5jdGlvbihlKXt0eXBlb2YgZT09Im51bWJlciImJih0aGlzLiRwcmludE1hcmdpbkNvbHVtbj1lKSx0aGlzLiRzaG93UHJpbnRNYXJnaW49ISFlLHRoaXMuJHVwZGF0ZVByaW50TWFyZ2luKCl9LGdldDpmdW5jdGlvbigpe3JldHVybiB0aGlzLiRzaG93UHJpbnRNYXJnaW4mJnRoaXMuJHByaW50TWFyZ2luQ29sdW1ufX0sc2hvd0d1dHRlcjp7c2V0OmZ1bmN0aW9uKGUpe3RoaXMuJGd1dHRlci5zdHlsZS5kaXNwbGF5PWU/ImJsb2NrIjoibm9uZSIsdGhpcy4kbG9vcC5zY2hlZHVsZSh0aGlzLkNIQU5HRV9GVUxMKSx0aGlzLm9uR3V0dGVyUmVzaXplKCl9LGluaXRpYWxWYWx1ZTohMH0sZmFkZUZvbGRXaWRnZXRzOntzZXQ6ZnVuY3Rpb24oZSl7aS5zZXRDc3NDbGFzcyh0aGlzLiRndXR0ZXIsImFjZV9mYWRlLWZvbGQtd2lkZ2V0cyIsZSl9LGluaXRpYWxWYWx1ZTohMX0sc2hvd0ZvbGRXaWRnZXRzOntzZXQ6ZnVuY3Rpb24oZSl7dGhpcy4kZ3V0dGVyTGF5ZXIuc2V0U2hvd0ZvbGRXaWRnZXRzKGUpLHRoaXMuJGxvb3Auc2NoZWR1bGUodGhpcy5DSEFOR0VfR1VUVEVSKX0saW5pdGlhbFZhbHVlOiEwfSxkaXNwbGF5SW5kZW50R3VpZGVzOntzZXQ6ZnVuY3Rpb24oZSl7dGhpcy4kdGV4dExheWVyLnNldERpc3BsYXlJbmRlbnRHdWlkZXMoZSkmJnRoaXMuJGxvb3Auc2NoZWR1bGUodGhpcy5DSEFOR0VfVEVYVCl9LGluaXRpYWxWYWx1ZTohMH0saGlnaGxpZ2h0SW5kZW50R3VpZGVzOntzZXQ6ZnVuY3Rpb24oZSl7dGhpcy4kdGV4dExheWVyLnNldEhpZ2hsaWdodEluZGVudEd1aWRlcyhlKT09MT90aGlzLiR0ZXh0TGF5ZXIuJGhpZ2hsaWdodEluZGVudEd1aWRlKCk6dGhpcy4kdGV4dExheWVyLiRjbGVhckFjdGl2ZUluZGVudEd1aWRlKHRoaXMuJHRleHRMYXllci4kbGluZXMuY2VsbHMpfSxpbml0aWFsVmFsdWU6ITB9LGhpZ2hsaWdodEd1dHRlckxpbmU6e3NldDpmdW5jdGlvbihlKXt0aGlzLiRndXR0ZXJMYXllci5zZXRIaWdobGlnaHRHdXR0ZXJMaW5lKGUpLHRoaXMuJGxvb3Auc2NoZWR1bGUodGhpcy5DSEFOR0VfR1VUVEVSKX0saW5pdGlhbFZhbHVlOiEwfSxoU2Nyb2xsQmFyQWx3YXlzVmlzaWJsZTp7c2V0OmZ1bmN0aW9uKGUpeyghdGhpcy4kaFNjcm9sbEJhckFsd2F5c1Zpc2libGV8fCF0aGlzLiRob3JpelNjcm9sbCkmJnRoaXMuJGxvb3Auc2NoZWR1bGUodGhpcy5DSEFOR0VfU0NST0xMKX0saW5pdGlhbFZhbHVlOiExfSx2U2Nyb2xsQmFyQWx3YXlzVmlzaWJsZTp7c2V0OmZ1bmN0aW9uKGUpeyghdGhpcy4kdlNjcm9sbEJhckFsd2F5c1Zpc2libGV8fCF0aGlzLiR2U2Nyb2xsKSYmdGhpcy4kbG9vcC5zY2hlZHVsZSh0aGlzLkNIQU5HRV9TQ1JPTEwpfSxpbml0aWFsVmFsdWU6ITF9LGZvbnRTaXplOntzZXQ6ZnVuY3Rpb24oZSl7dHlwZW9mIGU9PSJudW1iZXIiJiYoZSs9InB4IiksdGhpcy5jb250YWluZXIuc3R5bGUuZm9udFNpemU9ZSx0aGlzLnVwZGF0ZUZvbnRTaXplKCl9LGluaXRpYWxWYWx1ZToxMn0sZm9udEZhbWlseTp7c2V0OmZ1bmN0aW9uKGUpe3RoaXMuY29udGFpbmVyLnN0eWxlLmZvbnRGYW1pbHk9ZSx0aGlzLnVwZGF0ZUZvbnRTaXplKCl9fSxtYXhMaW5lczp7c2V0OmZ1bmN0aW9uKGUpe3RoaXMudXBkYXRlRnVsbCgpfX0sbWluTGluZXM6e3NldDpmdW5jdGlvbihlKXt0aGlzLiRtaW5MaW5lczw1NjI5NDk5NTM0MjEzMTF8fCh0aGlzLiRtaW5MaW5lcz0wKSx0aGlzLnVwZGF0ZUZ1bGwoKX19LG1heFBpeGVsSGVpZ2h0OntzZXQ6ZnVuY3Rpb24oZSl7dGhpcy51cGRhdGVGdWxsKCl9LGluaXRpYWxWYWx1ZTowfSxzY3JvbGxQYXN0RW5kOntzZXQ6ZnVuY3Rpb24oZSl7ZT0rZXx8MDtpZih0aGlzLiRzY3JvbGxQYXN0RW5kPT1lKXJldHVybjt0aGlzLiRzY3JvbGxQYXN0RW5kPWUsdGhpcy4kbG9vcC5zY2hlZHVsZSh0aGlzLkNIQU5HRV9TQ1JPTEwpfSxpbml0aWFsVmFsdWU6MCxoYW5kbGVzU2V0OiEwfSxmaXhlZFdpZHRoR3V0dGVyOntzZXQ6ZnVuY3Rpb24oZSl7dGhpcy4kZ3V0dGVyTGF5ZXIuJGZpeGVkV2lkdGg9ISFlLHRoaXMuJGxvb3Auc2NoZWR1bGUodGhpcy5DSEFOR0VfR1VUVEVSKX19LGN1c3RvbVNjcm9sbGJhcjp7c2V0OmZ1bmN0aW9uKGUpe3RoaXMuJHVwZGF0ZUN1c3RvbVNjcm9sbGJhcihlKX0saW5pdGlhbFZhbHVlOiExfSx0aGVtZTp7c2V0OmZ1bmN0aW9uKGUpe3RoaXMuc2V0VGhlbWUoZSl9LGdldDpmdW5jdGlvbigpe3JldHVybiB0aGlzLiR0aGVtZUlkfHx0aGlzLnRoZW1lfSxpbml0aWFsVmFsdWU6Ii4vdGhlbWUvdGV4dG1hdGUiLGhhbmRsZXNTZXQ6ITB9LGhhc0Nzc1RyYW5zZm9ybXM6e30sdXNlVGV4dGFyZWFGb3JJTUU6e2luaXRpYWxWYWx1ZTohYi5pc01vYmlsZSYmIWIuaXNJRX19KSx0LlZpcnR1YWxSZW5kZXJlcj1FfSksZGVmaW5lKCJhY2Uvd29ya2VyL3dvcmtlcl9jbGllbnQiLFsicmVxdWlyZSIsImV4cG9ydHMiLCJtb2R1bGUiLCJhY2UvbGliL29vcCIsImFjZS9saWIvbmV0IiwiYWNlL2xpYi9ldmVudF9lbWl0dGVyIiwiYWNlL2NvbmZpZyJdLGZ1bmN0aW9uKGUsdCxuKXsidXNlIHN0cmljdCI7ZnVuY3Rpb24gdShlKXt2YXIgdD0iaW1wb3J0U2NyaXB0cygnIitpLnF1YWxpZnlVUkwoZSkrIicpOyI7dHJ5e3JldHVybiBuZXcgQmxvYihbdF0se3R5cGU6ImFwcGxpY2F0aW9uL2phdmFzY3JpcHQifSl9Y2F0Y2gobil7dmFyIHI9d2luZG93LkJsb2JCdWlsZGVyfHx3aW5kb3cuV2ViS2l0QmxvYkJ1aWxkZXJ8fHdpbmRvdy5Nb3pCbG9iQnVpbGRlcixzPW5ldyByO3JldHVybiBzLmFwcGVuZCh0KSxzLmdldEJsb2IoImFwcGxpY2F0aW9uL2phdmFzY3JpcHQiKX19ZnVuY3Rpb24gYShlKXtpZih0eXBlb2YgV29ya2VyPT0idW5kZWZpbmVkIilyZXR1cm57cG9zdE1lc3NhZ2U6ZnVuY3Rpb24oKXt9LHRlcm1pbmF0ZTpmdW5jdGlvbigpe319O2lmKG8uZ2V0KCJsb2FkV29ya2VyRnJvbUJsb2IiKSl7dmFyIHQ9dShlKSxuPXdpbmRvdy5VUkx8fHdpbmRvdy53ZWJraXRVUkwscj1uLmNyZWF0ZU9iamVjdFVSTCh0KTtyZXR1cm4gbmV3IFdvcmtlcihyKX1yZXR1cm4gbmV3IFdvcmtlcihlKX12YXIgcj1lKCIuLi9saWIvb29wIiksaT1lKCIuLi9saWIvbmV0Iikscz1lKCIuLi9saWIvZXZlbnRfZW1pdHRlciIpLkV2ZW50RW1pdHRlcixvPWUoIi4uL2NvbmZpZyIpLGY9ZnVuY3Rpb24oZSl7ZS5wb3N0TWVzc2FnZXx8KGU9dGhpcy4kY3JlYXRlV29ya2VyRnJvbU9sZENvbmZpZy5hcHBseSh0aGlzLGFyZ3VtZW50cykpLHRoaXMuJHdvcmtlcj1lLHRoaXMuJHNlbmREZWx0YVF1ZXVlPXRoaXMuJHNlbmREZWx0YVF1ZXVlLmJpbmQodGhpcyksdGhpcy5jaGFuZ2VMaXN0ZW5lcj10aGlzLmNoYW5nZUxpc3RlbmVyLmJpbmQodGhpcyksdGhpcy5vbk1lc3NhZ2U9dGhpcy5vbk1lc3NhZ2UuYmluZCh0aGlzKSx0aGlzLmNhbGxiYWNrSWQ9MSx0aGlzLmNhbGxiYWNrcz17fSx0aGlzLiR3b3JrZXIub25tZXNzYWdlPXRoaXMub25NZXNzYWdlfTsoZnVuY3Rpb24oKXtyLmltcGxlbWVudCh0aGlzLHMpLHRoaXMuJGNyZWF0ZVdvcmtlckZyb21PbGRDb25maWc9ZnVuY3Rpb24odCxuLHIsaSxzKXtlLm5hbWVUb1VybCYmIWUudG9VcmwmJihlLnRvVXJsPWUubmFtZVRvVXJsKTtpZihvLmdldCgicGFja2FnZWQiKXx8IWUudG9VcmwpaT1pfHxvLm1vZHVsZVVybChuLCJ3b3JrZXIiKTtlbHNle3ZhciB1PXRoaXMuJG5vcm1hbGl6ZVBhdGg7aT1pfHx1KGUudG9VcmwoImFjZS93b3JrZXIvd29ya2VyLmpzIixudWxsLCJfIikpO3ZhciBmPXt9O3QuZm9yRWFjaChmdW5jdGlvbih0KXtmW3RdPXUoZS50b1VybCh0LG51bGwsIl8iKS5yZXBsYWNlKC8oXC5qcyk/KFw/LiopPyQvLCIiKSl9KX1yZXR1cm4gdGhpcy4kd29ya2VyPWEoaSkscyYmdGhpcy5zZW5kKCJpbXBvcnRTY3JpcHRzIixzKSx0aGlzLiR3b3JrZXIucG9zdE1lc3NhZ2Uoe2luaXQ6ITAsdGxuczpmLG1vZHVsZTpuLGNsYXNzbmFtZTpyfSksdGhpcy4kd29ya2VyfSx0aGlzLm9uTWVzc2FnZT1mdW5jdGlvbihlKXt2YXIgdD1lLmRhdGE7c3dpdGNoKHQudHlwZSl7Y2FzZSJldmVudCI6dGhpcy5fc2lnbmFsKHQubmFtZSx7ZGF0YTp0LmRhdGF9KTticmVhaztjYXNlImNhbGwiOnZhciBuPXRoaXMuY2FsbGJhY2tzW3QuaWRdO24mJihuKHQuZGF0YSksZGVsZXRlIHRoaXMuY2FsbGJhY2tzW3QuaWRdKTticmVhaztjYXNlImVycm9yIjp0aGlzLnJlcG9ydEVycm9yKHQuZGF0YSk7YnJlYWs7Y2FzZSJsb2ciOndpbmRvdy5jb25zb2xlJiZjb25zb2xlLmxvZyYmY29uc29sZS5sb2cuYXBwbHkoY29uc29sZSx0LmRhdGEpfX0sdGhpcy5yZXBvcnRFcnJvcj1mdW5jdGlvbihlKXt3aW5kb3cuY29uc29sZSYmY29uc29sZS5lcnJvciYmY29uc29sZS5lcnJvcihlKX0sdGhpcy4kbm9ybWFsaXplUGF0aD1mdW5jdGlvbihlKXtyZXR1cm4gaS5xdWFsaWZ5VVJMKGUpfSx0aGlzLnRlcm1pbmF0ZT1mdW5jdGlvbigpe3RoaXMuX3NpZ25hbCgidGVybWluYXRlIix7fSksdGhpcy5kZWx0YVF1ZXVlPW51bGwsdGhpcy4kd29ya2VyLnRlcm1pbmF0ZSgpLHRoaXMuJHdvcmtlcj1udWxsLHRoaXMuJGRvYyYmdGhpcy4kZG9jLm9mZigiY2hhbmdlIix0aGlzLmNoYW5nZUxpc3RlbmVyKSx0aGlzLiRkb2M9bnVsbH0sdGhpcy5zZW5kPWZ1bmN0aW9uKGUsdCl7dGhpcy4kd29ya2VyLnBvc3RNZXNzYWdlKHtjb21tYW5kOmUsYXJnczp0fSl9LHRoaXMuY2FsbD1mdW5jdGlvbihlLHQsbil7aWYobil7dmFyIHI9dGhpcy5jYWxsYmFja0lkKys7dGhpcy5jYWxsYmFja3Nbcl09bix0LnB1c2gocil9dGhpcy5zZW5kKGUsdCl9LHRoaXMuZW1pdD1mdW5jdGlvbihlLHQpe3RyeXt0LmRhdGEmJnQuZGF0YS5lcnImJih0LmRhdGEuZXJyPXttZXNzYWdlOnQuZGF0YS5lcnIubWVzc2FnZSxzdGFjazp0LmRhdGEuZXJyLnN0YWNrLGNvZGU6dC5kYXRhLmVyci5jb2RlfSksdGhpcy4kd29ya2VyJiZ0aGlzLiR3b3JrZXIucG9zdE1lc3NhZ2Uoe2V2ZW50OmUsZGF0YTp7ZGF0YTp0LmRhdGF9fSl9Y2F0Y2gobil7Y29uc29sZS5lcnJvcihuLnN0YWNrKX19LHRoaXMuYXR0YWNoVG9Eb2N1bWVudD1mdW5jdGlvbihlKXt0aGlzLiRkb2MmJnRoaXMudGVybWluYXRlKCksdGhpcy4kZG9jPWUsdGhpcy5jYWxsKCJzZXRWYWx1ZSIsW2UuZ2V0VmFsdWUoKV0pLGUub24oImNoYW5nZSIsdGhpcy5jaGFuZ2VMaXN0ZW5lciwhMCl9LHRoaXMuY2hhbmdlTGlzdGVuZXI9ZnVuY3Rpb24oZSl7dGhpcy5kZWx0YVF1ZXVlfHwodGhpcy5kZWx0YVF1ZXVlPVtdLHNldFRpbWVvdXQodGhpcy4kc2VuZERlbHRhUXVldWUsMCkpLGUuYWN0aW9uPT0iaW5zZXJ0Ij90aGlzLmRlbHRhUXVldWUucHVzaChlLnN0YXJ0LGUubGluZXMpOnRoaXMuZGVsdGFRdWV1ZS5wdXNoKGUuc3RhcnQsZS5lbmQpfSx0aGlzLiRzZW5kRGVsdGFRdWV1ZT1mdW5jdGlvbigpe3ZhciBlPXRoaXMuZGVsdGFRdWV1ZTtpZighZSlyZXR1cm47dGhpcy5kZWx0YVF1ZXVlPW51bGwsZS5sZW5ndGg+NTAmJmUubGVuZ3RoPnRoaXMuJGRvYy5nZXRMZW5ndGgoKT4+MT90aGlzLmNhbGwoInNldFZhbHVlIixbdGhpcy4kZG9jLmdldFZhbHVlKCldKTp0aGlzLmVtaXQoImNoYW5nZSIse2RhdGE6ZX0pfX0pLmNhbGwoZi5wcm90b3R5cGUpO3ZhciBsPWZ1bmN0aW9uKGUsdCxuKXt2YXIgcj1udWxsLGk9ITEsdT1PYmplY3QuY3JlYXRlKHMpLGE9W10sbD1uZXcgZih7bWVzc2FnZUJ1ZmZlcjphLHRlcm1pbmF0ZTpmdW5jdGlvbigpe30scG9zdE1lc3NhZ2U6ZnVuY3Rpb24oZSl7YS5wdXNoKGUpO2lmKCFyKXJldHVybjtpP3NldFRpbWVvdXQoYyk6YygpfX0pO2wuc2V0RW1pdFN5bmM9ZnVuY3Rpb24oZSl7aT1lfTt2YXIgYz1mdW5jdGlvbigpe3ZhciBlPWEuc2hpZnQoKTtlLmNvbW1hbmQ/cltlLmNvbW1hbmRdLmFwcGx5KHIsZS5hcmdzKTplLmV2ZW50JiZ1Ll9zaWduYWwoZS5ldmVudCxlLmRhdGEpfTtyZXR1cm4gdS5wb3N0TWVzc2FnZT1mdW5jdGlvbihlKXtsLm9uTWVzc2FnZSh7ZGF0YTplfSl9LHUuY2FsbGJhY2s9ZnVuY3Rpb24oZSx0KXt0aGlzLnBvc3RNZXNzYWdlKHt0eXBlOiJjYWxsIixpZDp0LGRhdGE6ZX0pfSx1LmVtaXQ9ZnVuY3Rpb24oZSx0KXt0aGlzLnBvc3RNZXNzYWdlKHt0eXBlOiJldmVudCIsbmFtZTplLGRhdGE6dH0pfSxvLmxvYWRNb2R1bGUoWyJ3b3JrZXIiLHRdLGZ1bmN0aW9uKGUpe3I9bmV3IGVbbl0odSk7d2hpbGUoYS5sZW5ndGgpYygpfSksbH07dC5VSVdvcmtlckNsaWVudD1sLHQuV29ya2VyQ2xpZW50PWYsdC5jcmVhdGVXb3JrZXI9YX0pLGRlZmluZSgiYWNlL3BsYWNlaG9sZGVyIixbInJlcXVpcmUiLCJleHBvcnRzIiwibW9kdWxlIiwiYWNlL3JhbmdlIiwiYWNlL2xpYi9ldmVudF9lbWl0dGVyIiwiYWNlL2xpYi9vb3AiXSxmdW5jdGlvbihlLHQsbil7InVzZSBzdHJpY3QiO3ZhciByPWUoIi4vcmFuZ2UiKS5SYW5nZSxpPWUoIi4vbGliL2V2ZW50X2VtaXR0ZXIiKS5FdmVudEVtaXR0ZXIscz1lKCIuL2xpYi9vb3AiKSxvPWZ1bmN0aW9uKGUsdCxuLHIsaSxzKXt2YXIgbz10aGlzO3RoaXMubGVuZ3RoPXQsdGhpcy5zZXNzaW9uPWUsdGhpcy5kb2M9ZS5nZXREb2N1bWVudCgpLHRoaXMubWFpbkNsYXNzPWksdGhpcy5vdGhlcnNDbGFzcz1zLHRoaXMuJG9uVXBkYXRlPXRoaXMub25VcGRhdGUuYmluZCh0aGlzKSx0aGlzLmRvYy5vbigiY2hhbmdlIix0aGlzLiRvblVwZGF0ZSwhMCksdGhpcy4kb3RoZXJzPXIsdGhpcy4kb25DdXJzb3JDaGFuZ2U9ZnVuY3Rpb24oKXtzZXRUaW1lb3V0KGZ1bmN0aW9uKCl7by5vbkN1cnNvckNoYW5nZSgpfSl9LHRoaXMuJHBvcz1uO3ZhciB1PWUuZ2V0VW5kb01hbmFnZXIoKS4kdW5kb1N0YWNrfHxlLmdldFVuZG9NYW5hZ2VyKCkuJHVuZG9zdGFja3x8e2xlbmd0aDotMX07dGhpcy4kdW5kb1N0YWNrRGVwdGg9dS5sZW5ndGgsdGhpcy5zZXR1cCgpLGUuc2VsZWN0aW9uLm9uKCJjaGFuZ2VDdXJzb3IiLHRoaXMuJG9uQ3Vyc29yQ2hhbmdlKX07KGZ1bmN0aW9uKCl7cy5pbXBsZW1lbnQodGhpcyxpKSx0aGlzLnNldHVwPWZ1bmN0aW9uKCl7dmFyIGU9dGhpcyx0PXRoaXMuZG9jLG49dGhpcy5zZXNzaW9uO3RoaXMuc2VsZWN0aW9uQmVmb3JlPW4uc2VsZWN0aW9uLnRvSlNPTigpLG4uc2VsZWN0aW9uLmluTXVsdGlTZWxlY3RNb2RlJiZuLnNlbGVjdGlvbi50b1NpbmdsZVJhbmdlKCksdGhpcy5wb3M9dC5jcmVhdGVBbmNob3IodGhpcy4kcG9zLnJvdyx0aGlzLiRwb3MuY29sdW1uKTt2YXIgaT10aGlzLnBvcztpLiRpbnNlcnRSaWdodD0hMCxpLmRldGFjaCgpLGkubWFya2VySWQ9bi5hZGRNYXJrZXIobmV3IHIoaS5yb3csaS5jb2x1bW4saS5yb3csaS5jb2x1bW4rdGhpcy5sZW5ndGgpLHRoaXMubWFpbkNsYXNzLG51bGwsITEpLHRoaXMub3RoZXJzPVtdLHRoaXMuJG90aGVycy5mb3JFYWNoKGZ1bmN0aW9uKG4pe3ZhciByPXQuY3JlYXRlQW5jaG9yKG4ucm93LG4uY29sdW1uKTtyLiRpbnNlcnRSaWdodD0hMCxyLmRldGFjaCgpLGUub3RoZXJzLnB1c2gocil9KSxuLnNldFVuZG9TZWxlY3QoITEpfSx0aGlzLnNob3dPdGhlck1hcmtlcnM9ZnVuY3Rpb24oKXtpZih0aGlzLm90aGVyc0FjdGl2ZSlyZXR1cm47dmFyIGU9dGhpcy5zZXNzaW9uLHQ9dGhpczt0aGlzLm90aGVyc0FjdGl2ZT0hMCx0aGlzLm90aGVycy5mb3JFYWNoKGZ1bmN0aW9uKG4pe24ubWFya2VySWQ9ZS5hZGRNYXJrZXIobmV3IHIobi5yb3csbi5jb2x1bW4sbi5yb3csbi5jb2x1bW4rdC5sZW5ndGgpLHQub3RoZXJzQ2xhc3MsbnVsbCwhMSl9KX0sdGhpcy5oaWRlT3RoZXJNYXJrZXJzPWZ1bmN0aW9uKCl7aWYoIXRoaXMub3RoZXJzQWN0aXZlKXJldHVybjt0aGlzLm90aGVyc0FjdGl2ZT0hMTtmb3IodmFyIGU9MDtlPHRoaXMub3RoZXJzLmxlbmd0aDtlKyspdGhpcy5zZXNzaW9uLnJlbW92ZU1hcmtlcih0aGlzLm90aGVyc1tlXS5tYXJrZXJJZCl9LHRoaXMub25VcGRhdGU9ZnVuY3Rpb24oZSl7aWYodGhpcy4kdXBkYXRpbmcpcmV0dXJuIHRoaXMudXBkYXRlQW5jaG9ycyhlKTt2YXIgdD1lO2lmKHQuc3RhcnQucm93IT09dC5lbmQucm93KXJldHVybjtpZih0LnN0YXJ0LnJvdyE9PXRoaXMucG9zLnJvdylyZXR1cm47dGhpcy4kdXBkYXRpbmc9ITA7dmFyIG49ZS5hY3Rpb249PT0iaW5zZXJ0Ij90LmVuZC5jb2x1bW4tdC5zdGFydC5jb2x1bW46dC5zdGFydC5jb2x1bW4tdC5lbmQuY29sdW1uLGk9dC5zdGFydC5jb2x1bW4+PXRoaXMucG9zLmNvbHVtbiYmdC5zdGFydC5jb2x1bW48PXRoaXMucG9zLmNvbHVtbit0aGlzLmxlbmd0aCsxLHM9dC5zdGFydC5jb2x1bW4tdGhpcy5wb3MuY29sdW1uO3RoaXMudXBkYXRlQW5jaG9ycyhlKSxpJiYodGhpcy5sZW5ndGgrPW4pO2lmKGkmJiF0aGlzLnNlc3Npb24uJGZyb21VbmRvKWlmKGUuYWN0aW9uPT09Imluc2VydCIpZm9yKHZhciBvPXRoaXMub3RoZXJzLmxlbmd0aC0xO28+PTA7by0tKXt2YXIgdT10aGlzLm90aGVyc1tvXSxhPXtyb3c6dS5yb3csY29sdW1uOnUuY29sdW1uK3N9O3RoaXMuZG9jLmluc2VydE1lcmdlZExpbmVzKGEsZS5saW5lcyl9ZWxzZSBpZihlLmFjdGlvbj09PSJyZW1vdmUiKWZvcih2YXIgbz10aGlzLm90aGVycy5sZW5ndGgtMTtvPj0wO28tLSl7dmFyIHU9dGhpcy5vdGhlcnNbb10sYT17cm93OnUucm93LGNvbHVtbjp1LmNvbHVtbitzfTt0aGlzLmRvYy5yZW1vdmUobmV3IHIoYS5yb3csYS5jb2x1bW4sYS5yb3csYS5jb2x1bW4tbikpfXRoaXMuJHVwZGF0aW5nPSExLHRoaXMudXBkYXRlTWFya2VycygpfSx0aGlzLnVwZGF0ZUFuY2hvcnM9ZnVuY3Rpb24oZSl7dGhpcy5wb3Mub25DaGFuZ2UoZSk7Zm9yKHZhciB0PXRoaXMub3RoZXJzLmxlbmd0aDt0LS07KXRoaXMub3RoZXJzW3RdLm9uQ2hhbmdlKGUpO3RoaXMudXBkYXRlTWFya2VycygpfSx0aGlzLnVwZGF0ZU1hcmtlcnM9ZnVuY3Rpb24oKXtpZih0aGlzLiR1cGRhdGluZylyZXR1cm47dmFyIGU9dGhpcyx0PXRoaXMuc2Vzc2lvbixuPWZ1bmN0aW9uKG4saSl7dC5yZW1vdmVNYXJrZXIobi5tYXJrZXJJZCksbi5tYXJrZXJJZD10LmFkZE1hcmtlcihuZXcgcihuLnJvdyxuLmNvbHVtbixuLnJvdyxuLmNvbHVtbitlLmxlbmd0aCksaSxudWxsLCExKX07bih0aGlzLnBvcyx0aGlzLm1haW5DbGFzcyk7Zm9yKHZhciBpPXRoaXMub3RoZXJzLmxlbmd0aDtpLS07KW4odGhpcy5vdGhlcnNbaV0sdGhpcy5vdGhlcnNDbGFzcyl9LHRoaXMub25DdXJzb3JDaGFuZ2U9ZnVuY3Rpb24oZSl7aWYodGhpcy4kdXBkYXRpbmd8fCF0aGlzLnNlc3Npb24pcmV0dXJuO3ZhciB0PXRoaXMuc2Vzc2lvbi5zZWxlY3Rpb24uZ2V0Q3Vyc29yKCk7dC5yb3c9PT10aGlzLnBvcy5yb3cmJnQuY29sdW1uPj10aGlzLnBvcy5jb2x1bW4mJnQuY29sdW1uPD10aGlzLnBvcy5jb2x1bW4rdGhpcy5sZW5ndGg/KHRoaXMuc2hvd090aGVyTWFya2VycygpLHRoaXMuX2VtaXQoImN1cnNvckVudGVyIixlKSk6KHRoaXMuaGlkZU90aGVyTWFya2VycygpLHRoaXMuX2VtaXQoImN1cnNvckxlYXZlIixlKSl9LHRoaXMuZGV0YWNoPWZ1bmN0aW9uKCl7dGhpcy5zZXNzaW9uLnJlbW92ZU1hcmtlcih0aGlzLnBvcyYmdGhpcy5wb3MubWFya2VySWQpLHRoaXMuaGlkZU90aGVyTWFya2VycygpLHRoaXMuZG9jLm9mZigiY2hhbmdlIix0aGlzLiRvblVwZGF0ZSksdGhpcy5zZXNzaW9uLnNlbGVjdGlvbi5vZmYoImNoYW5nZUN1cnNvciIsdGhpcy4kb25DdXJzb3JDaGFuZ2UpLHRoaXMuc2Vzc2lvbi5zZXRVbmRvU2VsZWN0KCEwKSx0aGlzLnNlc3Npb249bnVsbH0sdGhpcy5jYW5jZWw9ZnVuY3Rpb24oKXtpZih0aGlzLiR1bmRvU3RhY2tEZXB0aD09PS0xKXJldHVybjt2YXIgZT10aGlzLnNlc3Npb24uZ2V0VW5kb01hbmFnZXIoKSx0PShlLiR1bmRvU3RhY2t8fGUuJHVuZG9zdGFjaykubGVuZ3RoLXRoaXMuJHVuZG9TdGFja0RlcHRoO2Zvcih2YXIgbj0wO248dDtuKyspZS51bmRvKHRoaXMuc2Vzc2lvbiwhMCk7dGhpcy5zZWxlY3Rpb25CZWZvcmUmJnRoaXMuc2Vzc2lvbi5zZWxlY3Rpb24uZnJvbUpTT04odGhpcy5zZWxlY3Rpb25CZWZvcmUpfX0pLmNhbGwoby5wcm90b3R5cGUpLHQuUGxhY2VIb2xkZXI9b30pLGRlZmluZSgiYWNlL21vdXNlL211bHRpX3NlbGVjdF9oYW5kbGVyIixbInJlcXVpcmUiLCJleHBvcnRzIiwibW9kdWxlIiwiYWNlL2xpYi9ldmVudCIsImFjZS9saWIvdXNlcmFnZW50Il0sZnVuY3Rpb24oZSx0LG4pe2Z1bmN0aW9uIHMoZSx0KXtyZXR1cm4gZS5yb3c9PXQucm93JiZlLmNvbHVtbj09dC5jb2x1bW59ZnVuY3Rpb24gbyhlKXt2YXIgdD1lLmRvbUV2ZW50LG49dC5hbHRLZXksbz10LnNoaWZ0S2V5LHU9dC5jdHJsS2V5LGE9ZS5nZXRBY2NlbEtleSgpLGY9ZS5nZXRCdXR0b24oKTt1JiZpLmlzTWFjJiYoZj10LmJ1dHRvbik7aWYoZS5lZGl0b3IuaW5NdWx0aVNlbGVjdE1vZGUmJmY9PTIpe2UuZWRpdG9yLnRleHRJbnB1dC5vbkNvbnRleHRNZW51KGUuZG9tRXZlbnQpO3JldHVybn1pZighdSYmIW4mJiFhKXtmPT09MCYmZS5lZGl0b3IuaW5NdWx0aVNlbGVjdE1vZGUmJmUuZWRpdG9yLmV4aXRNdWx0aVNlbGVjdE1vZGUoKTtyZXR1cm59aWYoZiE9PTApcmV0dXJuO3ZhciBsPWUuZWRpdG9yLGM9bC5zZWxlY3Rpb24saD1sLmluTXVsdGlTZWxlY3RNb2RlLHA9ZS5nZXREb2N1bWVudFBvc2l0aW9uKCksZD1jLmdldEN1cnNvcigpLHY9ZS5pblNlbGVjdGlvbigpfHxjLmlzRW1wdHkoKSYmcyhwLGQpLG09ZS54LGc9ZS55LHk9ZnVuY3Rpb24oZSl7bT1lLmNsaWVudFgsZz1lLmNsaWVudFl9LGI9bC5zZXNzaW9uLHc9bC5yZW5kZXJlci5waXhlbFRvU2NyZWVuQ29vcmRpbmF0ZXMobSxnKSxFPXcsUztpZihsLiRtb3VzZUhhbmRsZXIuJGVuYWJsZUp1bXBUb0RlZil1JiZufHxhJiZuP1M9bz8iYmxvY2siOiJhZGQiOm4mJmwuJGJsb2NrU2VsZWN0RW5hYmxlZCYmKFM9ImJsb2NrIik7ZWxzZSBpZihhJiYhbil7Uz0iYWRkIjtpZighaCYmbylyZXR1cm59ZWxzZSBuJiZsLiRibG9ja1NlbGVjdEVuYWJsZWQmJihTPSJibG9jayIpO1MmJmkuaXNNYWMmJnQuY3RybEtleSYmbC4kbW91c2VIYW5kbGVyLmNhbmNlbENvbnRleHRNZW51KCk7aWYoUz09ImFkZCIpe2lmKCFoJiZ2KXJldHVybjtpZighaCl7dmFyIHg9Yy50b09yaWVudGVkUmFuZ2UoKTtsLmFkZFNlbGVjdGlvbk1hcmtlcih4KX12YXIgVD1jLnJhbmdlTGlzdC5yYW5nZUF0UG9pbnQocCk7bC5pblZpcnR1YWxTZWxlY3Rpb25Nb2RlPSEwLG8mJihUPW51bGwseD1jLnJhbmdlc1swXXx8eCxsLnJlbW92ZVNlbGVjdGlvbk1hcmtlcih4KSksbC5vbmNlKCJtb3VzZXVwIixmdW5jdGlvbigpe3ZhciBlPWMudG9PcmllbnRlZFJhbmdlKCk7VCYmZS5pc0VtcHR5KCkmJnMoVC5jdXJzb3IsZS5jdXJzb3IpP2Muc3Vic3RyYWN0UG9pbnQoZS5jdXJzb3IpOihvP2Muc3Vic3RyYWN0UG9pbnQoeC5jdXJzb3IpOngmJihsLnJlbW92ZVNlbGVjdGlvbk1hcmtlcih4KSxjLmFkZFJhbmdlKHgpKSxjLmFkZFJhbmdlKGUpKSxsLmluVmlydHVhbFNlbGVjdGlvbk1vZGU9ITF9KX1lbHNlIGlmKFM9PSJibG9jayIpe2Uuc3RvcCgpLGwuaW5WaXJ0dWFsU2VsZWN0aW9uTW9kZT0hMDt2YXIgTixDPVtdLGs9ZnVuY3Rpb24oKXt2YXIgZT1sLnJlbmRlcmVyLnBpeGVsVG9TY3JlZW5Db29yZGluYXRlcyhtLGcpLHQ9Yi5zY3JlZW5Ub0RvY3VtZW50UG9zaXRpb24oZS5yb3csZS5jb2x1bW4sZS5vZmZzZXRYKTtpZihzKEUsZSkmJnModCxjLmxlYWQpKXJldHVybjtFPWUsbC5zZWxlY3Rpb24ubW92ZVRvUG9zaXRpb24odCksbC5yZW5kZXJlci5zY3JvbGxDdXJzb3JJbnRvVmlldygpLGwucmVtb3ZlU2VsZWN0aW9uTWFya2VycyhDKSxDPWMucmVjdGFuZ3VsYXJSYW5nZUJsb2NrKEUsdyksbC4kbW91c2VIYW5kbGVyLiRjbGlja1NlbGVjdGlvbiYmQy5sZW5ndGg9PTEmJkNbMF0uaXNFbXB0eSgpJiYoQ1swXT1sLiRtb3VzZUhhbmRsZXIuJGNsaWNrU2VsZWN0aW9uLmNsb25lKCkpLEMuZm9yRWFjaChsLmFkZFNlbGVjdGlvbk1hcmtlcixsKSxsLnVwZGF0ZVNlbGVjdGlvbk1hcmtlcnMoKX07aCYmIWE/Yy50b1NpbmdsZVJhbmdlKCk6IWgmJmEmJihOPWMudG9PcmllbnRlZFJhbmdlKCksbC5hZGRTZWxlY3Rpb25NYXJrZXIoTikpLG8/dz1iLmRvY3VtZW50VG9TY3JlZW5Qb3NpdGlvbihjLmxlYWQpOmMubW92ZVRvUG9zaXRpb24ocCksRT17cm93Oi0xLGNvbHVtbjotMX07dmFyIEw9ZnVuY3Rpb24oZSl7aygpLGNsZWFySW50ZXJ2YWwoTyksbC5yZW1vdmVTZWxlY3Rpb25NYXJrZXJzKEMpLEMubGVuZ3RofHwoQz1bYy50b09yaWVudGVkUmFuZ2UoKV0pLE4mJihsLnJlbW92ZVNlbGVjdGlvbk1hcmtlcihOKSxjLnRvU2luZ2xlUmFuZ2UoTikpO2Zvcih2YXIgdD0wO3Q8Qy5sZW5ndGg7dCsrKWMuYWRkUmFuZ2UoQ1t0XSk7bC5pblZpcnR1YWxTZWxlY3Rpb25Nb2RlPSExLGwuJG1vdXNlSGFuZGxlci4kY2xpY2tTZWxlY3Rpb249bnVsbH0sQT1rO3IuY2FwdHVyZShsLmNvbnRhaW5lcix5LEwpO3ZhciBPPXNldEludGVydmFsKGZ1bmN0aW9uKCl7QSgpfSwyMCk7cmV0dXJuIGUucHJldmVudERlZmF1bHQoKX19dmFyIHI9ZSgiLi4vbGliL2V2ZW50IiksaT1lKCIuLi9saWIvdXNlcmFnZW50Iik7dC5vbk1vdXNlRG93bj1vfSksZGVmaW5lKCJhY2UvY29tbWFuZHMvbXVsdGlfc2VsZWN0X2NvbW1hbmRzIixbInJlcXVpcmUiLCJleHBvcnRzIiwibW9kdWxlIiwiYWNlL2tleWJvYXJkL2hhc2hfaGFuZGxlciJdLGZ1bmN0aW9uKGUsdCxuKXt0LmRlZmF1bHRDb21tYW5kcz1be25hbWU6ImFkZEN1cnNvckFib3ZlIixkZXNjcmlwdGlvbjoiQWRkIGN1cnNvciBhYm92ZSIsZXhlYzpmdW5jdGlvbihlKXtlLnNlbGVjdE1vcmVMaW5lcygtMSl9LGJpbmRLZXk6e3dpbjoiQ3RybC1BbHQtVXAiLG1hYzoiQ3RybC1BbHQtVXAifSxzY3JvbGxJbnRvVmlldzoiY3Vyc29yIixyZWFkT25seTohMH0se25hbWU6ImFkZEN1cnNvckJlbG93IixkZXNjcmlwdGlvbjoiQWRkIGN1cnNvciBiZWxvdyIsZXhlYzpmdW5jdGlvbihlKXtlLnNlbGVjdE1vcmVMaW5lcygxKX0sYmluZEtleTp7d2luOiJDdHJsLUFsdC1Eb3duIixtYWM6IkN0cmwtQWx0LURvd24ifSxzY3JvbGxJbnRvVmlldzoiY3Vyc29yIixyZWFkT25seTohMH0se25hbWU6ImFkZEN1cnNvckFib3ZlU2tpcEN1cnJlbnQiLGRlc2NyaXB0aW9uOiJBZGQgY3Vyc29yIGFib3ZlIChza2lwIGN1cnJlbnQpIixleGVjOmZ1bmN0aW9uKGUpe2Uuc2VsZWN0TW9yZUxpbmVzKC0xLCEwKX0sYmluZEtleTp7d2luOiJDdHJsLUFsdC1TaGlmdC1VcCIsbWFjOiJDdHJsLUFsdC1TaGlmdC1VcCJ9LHNjcm9sbEludG9WaWV3OiJjdXJzb3IiLHJlYWRPbmx5OiEwfSx7bmFtZToiYWRkQ3Vyc29yQmVsb3dTa2lwQ3VycmVudCIsZGVzY3JpcHRpb246IkFkZCBjdXJzb3IgYmVsb3cgKHNraXAgY3VycmVudCkiLGV4ZWM6ZnVuY3Rpb24oZSl7ZS5zZWxlY3RNb3JlTGluZXMoMSwhMCl9LGJpbmRLZXk6e3dpbjoiQ3RybC1BbHQtU2hpZnQtRG93biIsbWFjOiJDdHJsLUFsdC1TaGlmdC1Eb3duIn0sc2Nyb2xsSW50b1ZpZXc6ImN1cnNvciIscmVhZE9ubHk6ITB9LHtuYW1lOiJzZWxlY3RNb3JlQmVmb3JlIixkZXNjcmlwdGlvbjoiU2VsZWN0IG1vcmUgYmVmb3JlIixleGVjOmZ1bmN0aW9uKGUpe2Uuc2VsZWN0TW9yZSgtMSl9LGJpbmRLZXk6e3dpbjoiQ3RybC1BbHQtTGVmdCIsbWFjOiJDdHJsLUFsdC1MZWZ0In0sc2Nyb2xsSW50b1ZpZXc6ImN1cnNvciIscmVhZE9ubHk6ITB9LHtuYW1lOiJzZWxlY3RNb3JlQWZ0ZXIiLGRlc2NyaXB0aW9uOiJTZWxlY3QgbW9yZSBhZnRlciIsZXhlYzpmdW5jdGlvbihlKXtlLnNlbGVjdE1vcmUoMSl9LGJpbmRLZXk6e3dpbjoiQ3RybC1BbHQtUmlnaHQiLG1hYzoiQ3RybC1BbHQtUmlnaHQifSxzY3JvbGxJbnRvVmlldzoiY3Vyc29yIixyZWFkT25seTohMH0se25hbWU6InNlbGVjdE5leHRCZWZvcmUiLGRlc2NyaXB0aW9uOiJTZWxlY3QgbmV4dCBiZWZvcmUiLGV4ZWM6ZnVuY3Rpb24oZSl7ZS5zZWxlY3RNb3JlKC0xLCEwKX0sYmluZEtleTp7d2luOiJDdHJsLUFsdC1TaGlmdC1MZWZ0IixtYWM6IkN0cmwtQWx0LVNoaWZ0LUxlZnQifSxzY3JvbGxJbnRvVmlldzoiY3Vyc29yIixyZWFkT25seTohMH0se25hbWU6InNlbGVjdE5leHRBZnRlciIsZGVzY3JpcHRpb246IlNlbGVjdCBuZXh0IGFmdGVyIixleGVjOmZ1bmN0aW9uKGUpe2Uuc2VsZWN0TW9yZSgxLCEwKX0sYmluZEtleTp7d2luOiJDdHJsLUFsdC1TaGlmdC1SaWdodCIsbWFjOiJDdHJsLUFsdC1TaGlmdC1SaWdodCJ9LHNjcm9sbEludG9WaWV3OiJjdXJzb3IiLHJlYWRPbmx5OiEwfSx7bmFtZToidG9nZ2xlU3BsaXRTZWxlY3Rpb25JbnRvTGluZXMiLGRlc2NyaXB0aW9uOiJTcGxpdCBpbnRvIGxpbmVzIixleGVjOmZ1bmN0aW9uKGUpe2UubXVsdGlTZWxlY3QucmFuZ2VDb3VudD4xP2UubXVsdGlTZWxlY3Quam9pblNlbGVjdGlvbnMoKTplLm11bHRpU2VsZWN0LnNwbGl0SW50b0xpbmVzKCl9LGJpbmRLZXk6e3dpbjoiQ3RybC1BbHQtTCIsbWFjOiJDdHJsLUFsdC1MIn0scmVhZE9ubHk6ITB9LHtuYW1lOiJzcGxpdFNlbGVjdGlvbkludG9MaW5lcyIsZGVzY3JpcHRpb246IlNwbGl0IGludG8gbGluZXMiLGV4ZWM6ZnVuY3Rpb24oZSl7ZS5tdWx0aVNlbGVjdC5zcGxpdEludG9MaW5lcygpfSxyZWFkT25seTohMH0se25hbWU6ImFsaWduQ3Vyc29ycyIsZGVzY3JpcHRpb246IkFsaWduIGN1cnNvcnMiLGV4ZWM6ZnVuY3Rpb24oZSl7ZS5hbGlnbkN1cnNvcnMoKX0sYmluZEtleTp7d2luOiJDdHJsLUFsdC1BIixtYWM6IkN0cmwtQWx0LUEifSxzY3JvbGxJbnRvVmlldzoiY3Vyc29yIn0se25hbWU6ImZpbmRBbGwiLGRlc2NyaXB0aW9uOiJGaW5kIGFsbCIsZXhlYzpmdW5jdGlvbihlKXtlLmZpbmRBbGwoKX0sYmluZEtleTp7d2luOiJDdHJsLUFsdC1LIixtYWM6IkN0cmwtQWx0LUcifSxzY3JvbGxJbnRvVmlldzoiY3Vyc29yIixyZWFkT25seTohMH1dLHQubXVsdGlTZWxlY3RDb21tYW5kcz1be25hbWU6InNpbmdsZVNlbGVjdGlvbiIsZGVzY3JpcHRpb246IlNpbmdsZSBzZWxlY3Rpb24iLGJpbmRLZXk6ImVzYyIsZXhlYzpmdW5jdGlvbihlKXtlLmV4aXRNdWx0aVNlbGVjdE1vZGUoKX0sc2Nyb2xsSW50b1ZpZXc6ImN1cnNvciIscmVhZE9ubHk6ITAsaXNBdmFpbGFibGU6ZnVuY3Rpb24oZSl7cmV0dXJuIGUmJmUuaW5NdWx0aVNlbGVjdE1vZGV9fV07dmFyIHI9ZSgiLi4va2V5Ym9hcmQvaGFzaF9oYW5kbGVyIikuSGFzaEhhbmRsZXI7dC5rZXlib2FyZEhhbmRsZXI9bmV3IHIodC5tdWx0aVNlbGVjdENvbW1hbmRzKX0pLGRlZmluZSgiYWNlL211bHRpX3NlbGVjdCIsWyJyZXF1aXJlIiwiZXhwb3J0cyIsIm1vZHVsZSIsImFjZS9yYW5nZV9saXN0IiwiYWNlL3JhbmdlIiwiYWNlL3NlbGVjdGlvbiIsImFjZS9tb3VzZS9tdWx0aV9zZWxlY3RfaGFuZGxlciIsImFjZS9saWIvZXZlbnQiLCJhY2UvbGliL2xhbmciLCJhY2UvY29tbWFuZHMvbXVsdGlfc2VsZWN0X2NvbW1hbmRzIiwiYWNlL3NlYXJjaCIsImFjZS9lZGl0X3Nlc3Npb24iLCJhY2UvZWRpdG9yIiwiYWNlL2NvbmZpZyJdLGZ1bmN0aW9uKGUsdCxuKXtmdW5jdGlvbiBoKGUsdCxuKXtyZXR1cm4gYy4kb3B0aW9ucy53cmFwPSEwLGMuJG9wdGlvbnMubmVlZGxlPXQsYy4kb3B0aW9ucy5iYWNrd2FyZHM9bj09LTEsYy5maW5kKGUpfWZ1bmN0aW9uIHYoZSx0KXtyZXR1cm4gZS5yb3c9PXQucm93JiZlLmNvbHVtbj09dC5jb2x1bW59ZnVuY3Rpb24gbShlKXtpZihlLiRtdWx0aXNlbGVjdE9uU2Vzc2lvbkNoYW5nZSlyZXR1cm47ZS4kb25BZGRSYW5nZT1lLiRvbkFkZFJhbmdlLmJpbmQoZSksZS4kb25SZW1vdmVSYW5nZT1lLiRvblJlbW92ZVJhbmdlLmJpbmQoZSksZS4kb25NdWx0aVNlbGVjdD1lLiRvbk11bHRpU2VsZWN0LmJpbmQoZSksZS4kb25TaW5nbGVTZWxlY3Q9ZS4kb25TaW5nbGVTZWxlY3QuYmluZChlKSxlLiRtdWx0aXNlbGVjdE9uU2Vzc2lvbkNoYW5nZT10Lm9uU2Vzc2lvbkNoYW5nZS5iaW5kKGUpLGUuJGNoZWNrTXVsdGlzZWxlY3RDaGFuZ2U9ZS4kY2hlY2tNdWx0aXNlbGVjdENoYW5nZS5iaW5kKGUpLGUuJG11bHRpc2VsZWN0T25TZXNzaW9uQ2hhbmdlKGUpLGUub24oImNoYW5nZVNlc3Npb24iLGUuJG11bHRpc2VsZWN0T25TZXNzaW9uQ2hhbmdlKSxlLm9uKCJtb3VzZWRvd24iLG8pLGUuY29tbWFuZHMuYWRkQ29tbWFuZHMoZi5kZWZhdWx0Q29tbWFuZHMpLGcoZSl9ZnVuY3Rpb24gZyhlKXtmdW5jdGlvbiByKHQpe24mJihlLnJlbmRlcmVyLnNldE1vdXNlQ3Vyc29yKCIiKSxuPSExKX1pZighZS50ZXh0SW5wdXQpcmV0dXJuO3ZhciB0PWUudGV4dElucHV0LmdldEVsZW1lbnQoKSxuPSExO3UuYWRkTGlzdGVuZXIodCwia2V5ZG93biIsZnVuY3Rpb24odCl7dmFyIGk9dC5rZXlDb2RlPT0xOCYmISh0LmN0cmxLZXl8fHQuc2hpZnRLZXl8fHQubWV0YUtleSk7ZS4kYmxvY2tTZWxlY3RFbmFibGVkJiZpP258fChlLnJlbmRlcmVyLnNldE1vdXNlQ3Vyc29yKCJjcm9zc2hhaXIiKSxuPSEwKTpuJiZyKCl9LGUpLHUuYWRkTGlzdGVuZXIodCwia2V5dXAiLHIsZSksdS5hZGRMaXN0ZW5lcih0LCJibHVyIixyLGUpfXZhciByPWUoIi4vcmFuZ2VfbGlzdCIpLlJhbmdlTGlzdCxpPWUoIi4vcmFuZ2UiKS5SYW5nZSxzPWUoIi4vc2VsZWN0aW9uIikuU2VsZWN0aW9uLG89ZSgiLi9tb3VzZS9tdWx0aV9zZWxlY3RfaGFuZGxlciIpLm9uTW91c2VEb3duLHU9ZSgiLi9saWIvZXZlbnQiKSxhPWUoIi4vbGliL2xhbmciKSxmPWUoIi4vY29tbWFuZHMvbXVsdGlfc2VsZWN0X2NvbW1hbmRzIik7dC5jb21tYW5kcz1mLmRlZmF1bHRDb21tYW5kcy5jb25jYXQoZi5tdWx0aVNlbGVjdENvbW1hbmRzKTt2YXIgbD1lKCIuL3NlYXJjaCIpLlNlYXJjaCxjPW5ldyBsLHA9ZSgiLi9lZGl0X3Nlc3Npb24iKS5FZGl0U2Vzc2lvbjsoZnVuY3Rpb24oKXt0aGlzLmdldFNlbGVjdGlvbk1hcmtlcnM9ZnVuY3Rpb24oKXtyZXR1cm4gdGhpcy4kc2VsZWN0aW9uTWFya2Vyc319KS5jYWxsKHAucHJvdG90eXBlKSxmdW5jdGlvbigpe3RoaXMucmFuZ2VzPW51bGwsdGhpcy5yYW5nZUxpc3Q9bnVsbCx0aGlzLmFkZFJhbmdlPWZ1bmN0aW9uKGUsdCl7aWYoIWUpcmV0dXJuO2lmKCF0aGlzLmluTXVsdGlTZWxlY3RNb2RlJiZ0aGlzLnJhbmdlQ291bnQ9PT0wKXt2YXIgbj10aGlzLnRvT3JpZW50ZWRSYW5nZSgpO3RoaXMucmFuZ2VMaXN0LmFkZChuKSx0aGlzLnJhbmdlTGlzdC5hZGQoZSk7aWYodGhpcy5yYW5nZUxpc3QucmFuZ2VzLmxlbmd0aCE9MilyZXR1cm4gdGhpcy5yYW5nZUxpc3QucmVtb3ZlQWxsKCksdHx8dGhpcy5mcm9tT3JpZW50ZWRSYW5nZShlKTt0aGlzLnJhbmdlTGlzdC5yZW1vdmVBbGwoKSx0aGlzLnJhbmdlTGlzdC5hZGQobiksdGhpcy4kb25BZGRSYW5nZShuKX1lLmN1cnNvcnx8KGUuY3Vyc29yPWUuZW5kKTt2YXIgcj10aGlzLnJhbmdlTGlzdC5hZGQoZSk7cmV0dXJuIHRoaXMuJG9uQWRkUmFuZ2UoZSksci5sZW5ndGgmJnRoaXMuJG9uUmVtb3ZlUmFuZ2UociksdGhpcy5yYW5nZUNvdW50PjEmJiF0aGlzLmluTXVsdGlTZWxlY3RNb2RlJiYodGhpcy5fc2lnbmFsKCJtdWx0aVNlbGVjdCIpLHRoaXMuaW5NdWx0aVNlbGVjdE1vZGU9ITAsdGhpcy5zZXNzaW9uLiR1bmRvU2VsZWN0PSExLHRoaXMucmFuZ2VMaXN0LmF0dGFjaCh0aGlzLnNlc3Npb24pKSx0fHx0aGlzLmZyb21PcmllbnRlZFJhbmdlKGUpfSx0aGlzLnRvU2luZ2xlUmFuZ2U9ZnVuY3Rpb24oZSl7ZT1lfHx0aGlzLnJhbmdlc1swXTt2YXIgdD10aGlzLnJhbmdlTGlzdC5yZW1vdmVBbGwoKTt0Lmxlbmd0aCYmdGhpcy4kb25SZW1vdmVSYW5nZSh0KSxlJiZ0aGlzLmZyb21PcmllbnRlZFJhbmdlKGUpfSx0aGlzLnN1YnN0cmFjdFBvaW50PWZ1bmN0aW9uKGUpe3ZhciB0PXRoaXMucmFuZ2VMaXN0LnN1YnN0cmFjdFBvaW50KGUpO2lmKHQpcmV0dXJuIHRoaXMuJG9uUmVtb3ZlUmFuZ2UodCksdFswXX0sdGhpcy5tZXJnZU92ZXJsYXBwaW5nUmFuZ2VzPWZ1bmN0aW9uKCl7dmFyIGU9dGhpcy5yYW5nZUxpc3QubWVyZ2UoKTtlLmxlbmd0aCYmdGhpcy4kb25SZW1vdmVSYW5nZShlKX0sdGhpcy4kb25BZGRSYW5nZT1mdW5jdGlvbihlKXt0aGlzLnJhbmdlQ291bnQ9dGhpcy5yYW5nZUxpc3QucmFuZ2VzLmxlbmd0aCx0aGlzLnJhbmdlcy51bnNoaWZ0KGUpLHRoaXMuX3NpZ25hbCgiYWRkUmFuZ2UiLHtyYW5nZTplfSl9LHRoaXMuJG9uUmVtb3ZlUmFuZ2U9ZnVuY3Rpb24oZSl7dGhpcy5yYW5nZUNvdW50PXRoaXMucmFuZ2VMaXN0LnJhbmdlcy5sZW5ndGg7aWYodGhpcy5yYW5nZUNvdW50PT0xJiZ0aGlzLmluTXVsdGlTZWxlY3RNb2RlKXt2YXIgdD10aGlzLnJhbmdlTGlzdC5yYW5nZXMucG9wKCk7ZS5wdXNoKHQpLHRoaXMucmFuZ2VDb3VudD0wfWZvcih2YXIgbj1lLmxlbmd0aDtuLS07KXt2YXIgcj10aGlzLnJhbmdlcy5pbmRleE9mKGVbbl0pO3RoaXMucmFuZ2VzLnNwbGljZShyLDEpfXRoaXMuX3NpZ25hbCgicmVtb3ZlUmFuZ2UiLHtyYW5nZXM6ZX0pLHRoaXMucmFuZ2VDb3VudD09PTAmJnRoaXMuaW5NdWx0aVNlbGVjdE1vZGUmJih0aGlzLmluTXVsdGlTZWxlY3RNb2RlPSExLHRoaXMuX3NpZ25hbCgic2luZ2xlU2VsZWN0IiksdGhpcy5zZXNzaW9uLiR1bmRvU2VsZWN0PSEwLHRoaXMucmFuZ2VMaXN0LmRldGFjaCh0aGlzLnNlc3Npb24pKSx0PXR8fHRoaXMucmFuZ2VzWzBdLHQmJiF0LmlzRXF1YWwodGhpcy5nZXRSYW5nZSgpKSYmdGhpcy5mcm9tT3JpZW50ZWRSYW5nZSh0KX0sdGhpcy4kaW5pdFJhbmdlTGlzdD1mdW5jdGlvbigpe2lmKHRoaXMucmFuZ2VMaXN0KXJldHVybjt0aGlzLnJhbmdlTGlzdD1uZXcgcix0aGlzLnJhbmdlcz1bXSx0aGlzLnJhbmdlQ291bnQ9MH0sdGhpcy5nZXRBbGxSYW5nZXM9ZnVuY3Rpb24oKXtyZXR1cm4gdGhpcy5yYW5nZUNvdW50P3RoaXMucmFuZ2VMaXN0LnJhbmdlcy5jb25jYXQoKTpbdGhpcy5nZXRSYW5nZSgpXX0sdGhpcy5zcGxpdEludG9MaW5lcz1mdW5jdGlvbigpe3ZhciBlPXRoaXMucmFuZ2VzLmxlbmd0aD90aGlzLnJhbmdlczpbdGhpcy5nZXRSYW5nZSgpXSx0PVtdO2Zvcih2YXIgbj0wO248ZS5sZW5ndGg7bisrKXt2YXIgcj1lW25dLHM9ci5zdGFydC5yb3csbz1yLmVuZC5yb3c7aWYocz09PW8pdC5wdXNoKHIuY2xvbmUoKSk7ZWxzZXt0LnB1c2gobmV3IGkocyxyLnN0YXJ0LmNvbHVtbixzLHRoaXMuc2Vzc2lvbi5nZXRMaW5lKHMpLmxlbmd0aCkpO3doaWxlKCsrczxvKXQucHVzaCh0aGlzLmdldExpbmVSYW5nZShzLCEwKSk7dC5wdXNoKG5ldyBpKG8sMCxvLHIuZW5kLmNvbHVtbikpfW49PTAmJiF0aGlzLmlzQmFja3dhcmRzKCkmJih0PXQucmV2ZXJzZSgpKX10aGlzLnRvU2luZ2xlUmFuZ2UoKTtmb3IodmFyIG49dC5sZW5ndGg7bi0tOyl0aGlzLmFkZFJhbmdlKHRbbl0pfSx0aGlzLmpvaW5TZWxlY3Rpb25zPWZ1bmN0aW9uKCl7dmFyIGU9dGhpcy5yYW5nZUxpc3QucmFuZ2VzLHQ9ZVtlLmxlbmd0aC0xXSxuPWkuZnJvbVBvaW50cyhlWzBdLnN0YXJ0LHQuZW5kKTt0aGlzLnRvU2luZ2xlUmFuZ2UoKSx0aGlzLnNldFNlbGVjdGlvblJhbmdlKG4sdC5jdXJzb3I9PXQuc3RhcnQpfSx0aGlzLnRvZ2dsZUJsb2NrU2VsZWN0aW9uPWZ1bmN0aW9uKCl7aWYodGhpcy5yYW5nZUNvdW50PjEpe3ZhciBlPXRoaXMucmFuZ2VMaXN0LnJhbmdlcyx0PWVbZS5sZW5ndGgtMV0sbj1pLmZyb21Qb2ludHMoZVswXS5zdGFydCx0LmVuZCk7dGhpcy50b1NpbmdsZVJhbmdlKCksdGhpcy5zZXRTZWxlY3Rpb25SYW5nZShuLHQuY3Vyc29yPT10LnN0YXJ0KX1lbHNle3ZhciByPXRoaXMuc2Vzc2lvbi5kb2N1bWVudFRvU2NyZWVuUG9zaXRpb24odGhpcy5jdXJzb3IpLHM9dGhpcy5zZXNzaW9uLmRvY3VtZW50VG9TY3JlZW5Qb3NpdGlvbih0aGlzLmFuY2hvciksbz10aGlzLnJlY3Rhbmd1bGFyUmFuZ2VCbG9jayhyLHMpO28uZm9yRWFjaCh0aGlzLmFkZFJhbmdlLHRoaXMpfX0sdGhpcy5yZWN0YW5ndWxhclJhbmdlQmxvY2s9ZnVuY3Rpb24oZSx0LG4pe3ZhciByPVtdLHM9ZS5jb2x1bW48dC5jb2x1bW47aWYocyl2YXIgbz1lLmNvbHVtbix1PXQuY29sdW1uLGE9ZS5vZmZzZXRYLGY9dC5vZmZzZXRYO2Vsc2UgdmFyIG89dC5jb2x1bW4sdT1lLmNvbHVtbixhPXQub2Zmc2V0WCxmPWUub2Zmc2V0WDt2YXIgbD1lLnJvdzx0LnJvdztpZihsKXZhciBjPWUucm93LGg9dC5yb3c7ZWxzZSB2YXIgYz10LnJvdyxoPWUucm93O288MCYmKG89MCksYzwwJiYoYz0wKSxjPT1oJiYobj0hMCk7dmFyIHA7Zm9yKHZhciBkPWM7ZDw9aDtkKyspe3ZhciBtPWkuZnJvbVBvaW50cyh0aGlzLnNlc3Npb24uc2NyZWVuVG9Eb2N1bWVudFBvc2l0aW9uKGQsbyxhKSx0aGlzLnNlc3Npb24uc2NyZWVuVG9Eb2N1bWVudFBvc2l0aW9uKGQsdSxmKSk7aWYobS5pc0VtcHR5KCkpe2lmKHAmJnYobS5lbmQscCkpYnJlYWs7cD1tLmVuZH1tLmN1cnNvcj1zP20uc3RhcnQ6bS5lbmQsci5wdXNoKG0pfWwmJnIucmV2ZXJzZSgpO2lmKCFuKXt2YXIgZz1yLmxlbmd0aC0xO3doaWxlKHJbZ10uaXNFbXB0eSgpJiZnPjApZy0tO2lmKGc+MCl7dmFyIHk9MDt3aGlsZShyW3ldLmlzRW1wdHkoKSl5Kyt9Zm9yKHZhciBiPWc7Yj49eTtiLS0pcltiXS5pc0VtcHR5KCkmJnIuc3BsaWNlKGIsMSl9cmV0dXJuIHJ9fS5jYWxsKHMucHJvdG90eXBlKTt2YXIgZD1lKCIuL2VkaXRvciIpLkVkaXRvcjsoZnVuY3Rpb24oKXt0aGlzLnVwZGF0ZVNlbGVjdGlvbk1hcmtlcnM9ZnVuY3Rpb24oKXt0aGlzLnJlbmRlcmVyLnVwZGF0ZUN1cnNvcigpLHRoaXMucmVuZGVyZXIudXBkYXRlQmFja01hcmtlcnMoKX0sdGhpcy5hZGRTZWxlY3Rpb25NYXJrZXI9ZnVuY3Rpb24oZSl7ZS5jdXJzb3J8fChlLmN1cnNvcj1lLmVuZCk7dmFyIHQ9dGhpcy5nZXRTZWxlY3Rpb25TdHlsZSgpO3JldHVybiBlLm1hcmtlcj10aGlzLnNlc3Npb24uYWRkTWFya2VyKGUsImFjZV9zZWxlY3Rpb24iLHQpLHRoaXMuc2Vzc2lvbi4kc2VsZWN0aW9uTWFya2Vycy5wdXNoKGUpLHRoaXMuc2Vzc2lvbi5zZWxlY3Rpb25NYXJrZXJDb3VudD10aGlzLnNlc3Npb24uJHNlbGVjdGlvbk1hcmtlcnMubGVuZ3RoLGV9LHRoaXMucmVtb3ZlU2VsZWN0aW9uTWFya2VyPWZ1bmN0aW9uKGUpe2lmKCFlLm1hcmtlcilyZXR1cm47dGhpcy5zZXNzaW9uLnJlbW92ZU1hcmtlcihlLm1hcmtlcik7dmFyIHQ9dGhpcy5zZXNzaW9uLiRzZWxlY3Rpb25NYXJrZXJzLmluZGV4T2YoZSk7dCE9LTEmJnRoaXMuc2Vzc2lvbi4kc2VsZWN0aW9uTWFya2Vycy5zcGxpY2UodCwxKSx0aGlzLnNlc3Npb24uc2VsZWN0aW9uTWFya2VyQ291bnQ9dGhpcy5zZXNzaW9uLiRzZWxlY3Rpb25NYXJrZXJzLmxlbmd0aH0sdGhpcy5yZW1vdmVTZWxlY3Rpb25NYXJrZXJzPWZ1bmN0aW9uKGUpe3ZhciB0PXRoaXMuc2Vzc2lvbi4kc2VsZWN0aW9uTWFya2Vycztmb3IodmFyIG49ZS5sZW5ndGg7bi0tOyl7dmFyIHI9ZVtuXTtpZighci5tYXJrZXIpY29udGludWU7dGhpcy5zZXNzaW9uLnJlbW92ZU1hcmtlcihyLm1hcmtlcik7dmFyIGk9dC5pbmRleE9mKHIpO2khPS0xJiZ0LnNwbGljZShpLDEpfXRoaXMuc2Vzc2lvbi5zZWxlY3Rpb25NYXJrZXJDb3VudD10Lmxlbmd0aH0sdGhpcy4kb25BZGRSYW5nZT1mdW5jdGlvbihlKXt0aGlzLmFkZFNlbGVjdGlvbk1hcmtlcihlLnJhbmdlKSx0aGlzLnJlbmRlcmVyLnVwZGF0ZUN1cnNvcigpLHRoaXMucmVuZGVyZXIudXBkYXRlQmFja01hcmtlcnMoKX0sdGhpcy4kb25SZW1vdmVSYW5nZT1mdW5jdGlvbihlKXt0aGlzLnJlbW92ZVNlbGVjdGlvbk1hcmtlcnMoZS5yYW5nZXMpLHRoaXMucmVuZGVyZXIudXBkYXRlQ3Vyc29yKCksdGhpcy5yZW5kZXJlci51cGRhdGVCYWNrTWFya2VycygpfSx0aGlzLiRvbk11bHRpU2VsZWN0PWZ1bmN0aW9uKGUpe2lmKHRoaXMuaW5NdWx0aVNlbGVjdE1vZGUpcmV0dXJuO3RoaXMuaW5NdWx0aVNlbGVjdE1vZGU9ITAsdGhpcy5zZXRTdHlsZSgiYWNlX211bHRpc2VsZWN0IiksdGhpcy5rZXlCaW5kaW5nLmFkZEtleWJvYXJkSGFuZGxlcihmLmtleWJvYXJkSGFuZGxlciksdGhpcy5jb21tYW5kcy5zZXREZWZhdWx0SGFuZGxlcigiZXhlYyIsdGhpcy4kb25NdWx0aVNlbGVjdEV4ZWMpLHRoaXMucmVuZGVyZXIudXBkYXRlQ3Vyc29yKCksdGhpcy5yZW5kZXJlci51cGRhdGVCYWNrTWFya2VycygpfSx0aGlzLiRvblNpbmdsZVNlbGVjdD1mdW5jdGlvbihlKXtpZih0aGlzLnNlc3Npb24ubXVsdGlTZWxlY3QuaW5WaXJ0dWFsTW9kZSlyZXR1cm47dGhpcy5pbk11bHRpU2VsZWN0TW9kZT0hMSx0aGlzLnVuc2V0U3R5bGUoImFjZV9tdWx0aXNlbGVjdCIpLHRoaXMua2V5QmluZGluZy5yZW1vdmVLZXlib2FyZEhhbmRsZXIoZi5rZXlib2FyZEhhbmRsZXIpLHRoaXMuY29tbWFuZHMucmVtb3ZlRGVmYXVsdEhhbmRsZXIoImV4ZWMiLHRoaXMuJG9uTXVsdGlTZWxlY3RFeGVjKSx0aGlzLnJlbmRlcmVyLnVwZGF0ZUN1cnNvcigpLHRoaXMucmVuZGVyZXIudXBkYXRlQmFja01hcmtlcnMoKSx0aGlzLl9lbWl0KCJjaGFuZ2VTZWxlY3Rpb24iKX0sdGhpcy4kb25NdWx0aVNlbGVjdEV4ZWM9ZnVuY3Rpb24oZSl7dmFyIHQ9ZS5jb21tYW5kLG49ZS5lZGl0b3I7aWYoIW4ubXVsdGlTZWxlY3QpcmV0dXJuO2lmKCF0Lm11bHRpU2VsZWN0QWN0aW9uKXt2YXIgcj10LmV4ZWMobixlLmFyZ3N8fHt9KTtuLm11bHRpU2VsZWN0LmFkZFJhbmdlKG4ubXVsdGlTZWxlY3QudG9PcmllbnRlZFJhbmdlKCkpLG4ubXVsdGlTZWxlY3QubWVyZ2VPdmVybGFwcGluZ1JhbmdlcygpfWVsc2UgdC5tdWx0aVNlbGVjdEFjdGlvbj09ImZvckVhY2giP3I9bi5mb3JFYWNoU2VsZWN0aW9uKHQsZS5hcmdzKTp0Lm11bHRpU2VsZWN0QWN0aW9uPT0iZm9yRWFjaExpbmUiP3I9bi5mb3JFYWNoU2VsZWN0aW9uKHQsZS5hcmdzLCEwKTp0Lm11bHRpU2VsZWN0QWN0aW9uPT0ic2luZ2xlIj8obi5leGl0TXVsdGlTZWxlY3RNb2RlKCkscj10LmV4ZWMobixlLmFyZ3N8fHt9KSk6cj10Lm11bHRpU2VsZWN0QWN0aW9uKG4sZS5hcmdzfHx7fSk7cmV0dXJuIHJ9LHRoaXMuZm9yRWFjaFNlbGVjdGlvbj1mdW5jdGlvbihlLHQsbil7aWYodGhpcy5pblZpcnR1YWxTZWxlY3Rpb25Nb2RlKXJldHVybjt2YXIgcj1uJiZuLmtlZXBPcmRlcixpPW49PTF8fG4mJm4uJGJ5TGluZXMsbz10aGlzLnNlc3Npb24sdT10aGlzLnNlbGVjdGlvbixhPXUucmFuZ2VMaXN0LGY9KHI/dTphKS5yYW5nZXMsbDtpZighZi5sZW5ndGgpcmV0dXJuIGUuZXhlYz9lLmV4ZWModGhpcyx0fHx7fSk6ZSh0aGlzLHR8fHt9KTt2YXIgYz11Ll9ldmVudFJlZ2lzdHJ5O3UuX2V2ZW50UmVnaXN0cnk9e307dmFyIGg9bmV3IHMobyk7dGhpcy5pblZpcnR1YWxTZWxlY3Rpb25Nb2RlPSEwO2Zvcih2YXIgcD1mLmxlbmd0aDtwLS07KXtpZihpKXdoaWxlKHA+MCYmZltwXS5zdGFydC5yb3c9PWZbcC0xXS5lbmQucm93KXAtLTtoLmZyb21PcmllbnRlZFJhbmdlKGZbcF0pLGguaW5kZXg9cCx0aGlzLnNlbGVjdGlvbj1vLnNlbGVjdGlvbj1oO3ZhciBkPWUuZXhlYz9lLmV4ZWModGhpcyx0fHx7fSk6ZSh0aGlzLHR8fHt9KTshbCYmZCE9PXVuZGVmaW5lZCYmKGw9ZCksaC50b09yaWVudGVkUmFuZ2UoZltwXSl9aC5kZXRhY2goKSx0aGlzLnNlbGVjdGlvbj1vLnNlbGVjdGlvbj11LHRoaXMuaW5WaXJ0dWFsU2VsZWN0aW9uTW9kZT0hMSx1Ll9ldmVudFJlZ2lzdHJ5PWMsdS5tZXJnZU92ZXJsYXBwaW5nUmFuZ2VzKCksdS5yYW5nZXNbMF0mJnUuZnJvbU9yaWVudGVkUmFuZ2UodS5yYW5nZXNbMF0pO3ZhciB2PXRoaXMucmVuZGVyZXIuJHNjcm9sbEFuaW1hdGlvbjtyZXR1cm4gdGhpcy5vbkN1cnNvckNoYW5nZSgpLHRoaXMub25TZWxlY3Rpb25DaGFuZ2UoKSx2JiZ2LmZyb209PXYudG8mJnRoaXMucmVuZGVyZXIuYW5pbWF0ZVNjcm9sbGluZyh2LmZyb20pLGx9LHRoaXMuZXhpdE11bHRpU2VsZWN0TW9kZT1mdW5jdGlvbigpe2lmKCF0aGlzLmluTXVsdGlTZWxlY3RNb2RlfHx0aGlzLmluVmlydHVhbFNlbGVjdGlvbk1vZGUpcmV0dXJuO3RoaXMubXVsdGlTZWxlY3QudG9TaW5nbGVSYW5nZSgpfSx0aGlzLmdldFNlbGVjdGVkVGV4dD1mdW5jdGlvbigpe3ZhciBlPSIiO2lmKHRoaXMuaW5NdWx0aVNlbGVjdE1vZGUmJiF0aGlzLmluVmlydHVhbFNlbGVjdGlvbk1vZGUpe3ZhciB0PXRoaXMubXVsdGlTZWxlY3QucmFuZ2VMaXN0LnJhbmdlcyxuPVtdO2Zvcih2YXIgcj0wO3I8dC5sZW5ndGg7cisrKW4ucHVzaCh0aGlzLnNlc3Npb24uZ2V0VGV4dFJhbmdlKHRbcl0pKTt2YXIgaT10aGlzLnNlc3Npb24uZ2V0RG9jdW1lbnQoKS5nZXROZXdMaW5lQ2hhcmFjdGVyKCk7ZT1uLmpvaW4oaSksZS5sZW5ndGg9PShuLmxlbmd0aC0xKSppLmxlbmd0aCYmKGU9IiIpfWVsc2UgdGhpcy5zZWxlY3Rpb24uaXNFbXB0eSgpfHwoZT10aGlzLnNlc3Npb24uZ2V0VGV4dFJhbmdlKHRoaXMuZ2V0U2VsZWN0aW9uUmFuZ2UoKSkpO3JldHVybiBlfSx0aGlzLiRjaGVja011bHRpc2VsZWN0Q2hhbmdlPWZ1bmN0aW9uKGUsdCl7aWYodGhpcy5pbk11bHRpU2VsZWN0TW9kZSYmIXRoaXMuaW5WaXJ0dWFsU2VsZWN0aW9uTW9kZSl7dmFyIG49dGhpcy5tdWx0aVNlbGVjdC5yYW5nZXNbMF07aWYodGhpcy5tdWx0aVNlbGVjdC5pc0VtcHR5KCkmJnQ9PXRoaXMubXVsdGlTZWxlY3QuYW5jaG9yKXJldHVybjt2YXIgcj10PT10aGlzLm11bHRpU2VsZWN0LmFuY2hvcj9uLmN1cnNvcj09bi5zdGFydD9uLmVuZDpuLnN0YXJ0Om4uY3Vyc29yO3Iucm93IT10LnJvd3x8dGhpcy5zZXNzaW9uLiRjbGlwUG9zaXRpb25Ub0RvY3VtZW50KHIucm93LHIuY29sdW1uKS5jb2x1bW4hPXQuY29sdW1uP3RoaXMubXVsdGlTZWxlY3QudG9TaW5nbGVSYW5nZSh0aGlzLm11bHRpU2VsZWN0LnRvT3JpZW50ZWRSYW5nZSgpKTp0aGlzLm11bHRpU2VsZWN0Lm1lcmdlT3ZlcmxhcHBpbmdSYW5nZXMoKX19LHRoaXMuZmluZEFsbD1mdW5jdGlvbihlLHQsbil7dD10fHx7fSx0Lm5lZWRsZT1lfHx0Lm5lZWRsZTtpZih0Lm5lZWRsZT09dW5kZWZpbmVkKXt2YXIgcj10aGlzLnNlbGVjdGlvbi5pc0VtcHR5KCk/dGhpcy5zZWxlY3Rpb24uZ2V0V29yZFJhbmdlKCk6dGhpcy5zZWxlY3Rpb24uZ2V0UmFuZ2UoKTt0Lm5lZWRsZT10aGlzLnNlc3Npb24uZ2V0VGV4dFJhbmdlKHIpfXRoaXMuJHNlYXJjaC5zZXQodCk7dmFyIGk9dGhpcy4kc2VhcmNoLmZpbmRBbGwodGhpcy5zZXNzaW9uKTtpZighaS5sZW5ndGgpcmV0dXJuIDA7dmFyIHM9dGhpcy5tdWx0aVNlbGVjdDtufHxzLnRvU2luZ2xlUmFuZ2UoaVswXSk7Zm9yKHZhciBvPWkubGVuZ3RoO28tLTspcy5hZGRSYW5nZShpW29dLCEwKTtyZXR1cm4gciYmcy5yYW5nZUxpc3QucmFuZ2VBdFBvaW50KHIuc3RhcnQpJiZzLmFkZFJhbmdlKHIsITApLGkubGVuZ3RofSx0aGlzLnNlbGVjdE1vcmVMaW5lcz1mdW5jdGlvbihlLHQpe3ZhciBuPXRoaXMuc2VsZWN0aW9uLnRvT3JpZW50ZWRSYW5nZSgpLHI9bi5jdXJzb3I9PW4uZW5kLHM9dGhpcy5zZXNzaW9uLmRvY3VtZW50VG9TY3JlZW5Qb3NpdGlvbihuLmN1cnNvcik7dGhpcy5zZWxlY3Rpb24uJGRlc2lyZWRDb2x1bW4mJihzLmNvbHVtbj10aGlzLnNlbGVjdGlvbi4kZGVzaXJlZENvbHVtbik7dmFyIG89dGhpcy5zZXNzaW9uLnNjcmVlblRvRG9jdW1lbnRQb3NpdGlvbihzLnJvdytlLHMuY29sdW1uKTtpZighbi5pc0VtcHR5KCkpdmFyIHU9dGhpcy5zZXNzaW9uLmRvY3VtZW50VG9TY3JlZW5Qb3NpdGlvbihyP24uZW5kOm4uc3RhcnQpLGE9dGhpcy5zZXNzaW9uLnNjcmVlblRvRG9jdW1lbnRQb3NpdGlvbih1LnJvdytlLHUuY29sdW1uKTtlbHNlIHZhciBhPW87aWYocil7dmFyIGY9aS5mcm9tUG9pbnRzKG8sYSk7Zi5jdXJzb3I9Zi5zdGFydH1lbHNle3ZhciBmPWkuZnJvbVBvaW50cyhhLG8pO2YuY3Vyc29yPWYuZW5kfWYuZGVzaXJlZENvbHVtbj1zLmNvbHVtbjtpZighdGhpcy5zZWxlY3Rpb24uaW5NdWx0aVNlbGVjdE1vZGUpdGhpcy5zZWxlY3Rpb24uYWRkUmFuZ2Uobik7ZWxzZSBpZih0KXZhciBsPW4uY3Vyc29yO3RoaXMuc2VsZWN0aW9uLmFkZFJhbmdlKGYpLGwmJnRoaXMuc2VsZWN0aW9uLnN1YnN0cmFjdFBvaW50KGwpfSx0aGlzLnRyYW5zcG9zZVNlbGVjdGlvbnM9ZnVuY3Rpb24oZSl7dmFyIHQ9dGhpcy5zZXNzaW9uLG49dC5tdWx0aVNlbGVjdCxyPW4ucmFuZ2VzO2Zvcih2YXIgaT1yLmxlbmd0aDtpLS07KXt2YXIgcz1yW2ldO2lmKHMuaXNFbXB0eSgpKXt2YXIgbz10LmdldFdvcmRSYW5nZShzLnN0YXJ0LnJvdyxzLnN0YXJ0LmNvbHVtbik7cy5zdGFydC5yb3c9by5zdGFydC5yb3cscy5zdGFydC5jb2x1bW49by5zdGFydC5jb2x1bW4scy5lbmQucm93PW8uZW5kLnJvdyxzLmVuZC5jb2x1bW49by5lbmQuY29sdW1ufX1uLm1lcmdlT3ZlcmxhcHBpbmdSYW5nZXMoKTt2YXIgdT1bXTtmb3IodmFyIGk9ci5sZW5ndGg7aS0tOyl7dmFyIHM9cltpXTt1LnVuc2hpZnQodC5nZXRUZXh0UmFuZ2UocykpfWU8MD91LnVuc2hpZnQodS5wb3AoKSk6dS5wdXNoKHUuc2hpZnQoKSk7Zm9yKHZhciBpPXIubGVuZ3RoO2ktLTspe3ZhciBzPXJbaV0sbz1zLmNsb25lKCk7dC5yZXBsYWNlKHMsdVtpXSkscy5zdGFydC5yb3c9by5zdGFydC5yb3cscy5zdGFydC5jb2x1bW49by5zdGFydC5jb2x1bW59bi5mcm9tT3JpZW50ZWRSYW5nZShuLnJhbmdlc1swXSl9LHRoaXMuc2VsZWN0TW9yZT1mdW5jdGlvbihlLHQsbil7dmFyIHI9dGhpcy5zZXNzaW9uLGk9ci5tdWx0aVNlbGVjdCxzPWkudG9PcmllbnRlZFJhbmdlKCk7aWYocy5pc0VtcHR5KCkpe3M9ci5nZXRXb3JkUmFuZ2Uocy5zdGFydC5yb3cscy5zdGFydC5jb2x1bW4pLHMuY3Vyc29yPWU9PS0xP3Muc3RhcnQ6cy5lbmQsdGhpcy5tdWx0aVNlbGVjdC5hZGRSYW5nZShzKTtpZihuKXJldHVybn12YXIgbz1yLmdldFRleHRSYW5nZShzKSx1PWgocixvLGUpO3UmJih1LmN1cnNvcj1lPT0tMT91LnN0YXJ0OnUuZW5kLHRoaXMuc2Vzc2lvbi51bmZvbGQodSksdGhpcy5tdWx0aVNlbGVjdC5hZGRSYW5nZSh1KSx0aGlzLnJlbmRlcmVyLnNjcm9sbEN1cnNvckludG9WaWV3KG51bGwsLjUpKSx0JiZ0aGlzLm11bHRpU2VsZWN0LnN1YnN0cmFjdFBvaW50KHMuY3Vyc29yKX0sdGhpcy5hbGlnbkN1cnNvcnM9ZnVuY3Rpb24oKXt2YXIgZT10aGlzLnNlc3Npb24sdD1lLm11bHRpU2VsZWN0LG49dC5yYW5nZXMscj0tMSxzPW4uZmlsdGVyKGZ1bmN0aW9uKGUpe2lmKGUuY3Vyc29yLnJvdz09cilyZXR1cm4hMDtyPWUuY3Vyc29yLnJvd30pO2lmKCFuLmxlbmd0aHx8cy5sZW5ndGg9PW4ubGVuZ3RoLTEpe3ZhciBvPXRoaXMuc2VsZWN0aW9uLmdldFJhbmdlKCksdT1vLnN0YXJ0LnJvdyxmPW8uZW5kLnJvdyxsPXU9PWY7aWYobCl7dmFyIGM9dGhpcy5zZXNzaW9uLmdldExlbmd0aCgpLGg7ZG8gaD10aGlzLnNlc3Npb24uZ2V0TGluZShmKTt3aGlsZSgvWz06XS8udGVzdChoKSYmKytmPGMpO2RvIGg9dGhpcy5zZXNzaW9uLmdldExpbmUodSk7d2hpbGUoL1s9Ol0vLnRlc3QoaCkmJi0tdT4wKTt1PDAmJih1PTApLGY+PWMmJihmPWMtMSl9dmFyIHA9dGhpcy5zZXNzaW9uLnJlbW92ZUZ1bGxMaW5lcyh1LGYpO3A9dGhpcy4kcmVBbGlnblRleHQocCxsKSx0aGlzLnNlc3Npb24uaW5zZXJ0KHtyb3c6dSxjb2x1bW46MH0scC5qb2luKCJcbiIpKyJcbiIpLGx8fChvLnN0YXJ0LmNvbHVtbj0wLG8uZW5kLmNvbHVtbj1wW3AubGVuZ3RoLTFdLmxlbmd0aCksdGhpcy5zZWxlY3Rpb24uc2V0UmFuZ2Uobyl9ZWxzZXtzLmZvckVhY2goZnVuY3Rpb24oZSl7dC5zdWJzdHJhY3RQb2ludChlLmN1cnNvcil9KTt2YXIgZD0wLHY9SW5maW5pdHksbT1uLm1hcChmdW5jdGlvbih0KXt2YXIgbj10LmN1cnNvcixyPWUuZ2V0TGluZShuLnJvdyksaT1yLnN1YnN0cihuLmNvbHVtbikuc2VhcmNoKC9cUy9nKTtyZXR1cm4gaT09LTEmJihpPTApLG4uY29sdW1uPmQmJihkPW4uY29sdW1uKSxpPHYmJih2PWkpLGl9KTtuLmZvckVhY2goZnVuY3Rpb24odCxuKXt2YXIgcj10LmN1cnNvcixzPWQtci5jb2x1bW4sbz1tW25dLXY7cz5vP2UuaW5zZXJ0KHIsYS5zdHJpbmdSZXBlYXQoIiAiLHMtbykpOmUucmVtb3ZlKG5ldyBpKHIucm93LHIuY29sdW1uLHIucm93LHIuY29sdW1uLXMrbykpLHQuc3RhcnQuY29sdW1uPXQuZW5kLmNvbHVtbj1kLHQuc3RhcnQucm93PXQuZW5kLnJvdz1yLnJvdyx0LmN1cnNvcj10LmVuZH0pLHQuZnJvbU9yaWVudGVkUmFuZ2UoblswXSksdGhpcy5yZW5kZXJlci51cGRhdGVDdXJzb3IoKSx0aGlzLnJlbmRlcmVyLnVwZGF0ZUJhY2tNYXJrZXJzKCl9fSx0aGlzLiRyZUFsaWduVGV4dD1mdW5jdGlvbihlLHQpe2Z1bmN0aW9uIHUoZSl7cmV0dXJuIGEuc3RyaW5nUmVwZWF0KCIgIixlKX1mdW5jdGlvbiBmKGUpe3JldHVybiBlWzJdP3UoaSkrZVsyXSt1KHMtZVsyXS5sZW5ndGgrbykrZVs0XS5yZXBsYWNlKC9eKFs9Ol0pXHMrLywiJDEgIik6ZVswXX1mdW5jdGlvbiBsKGUpe3JldHVybiBlWzJdP3UoaStzLWVbMl0ubGVuZ3RoKStlWzJdK3UobykrZVs0XS5yZXBsYWNlKC9eKFs9Ol0pXHMrLywiJDEgIik6ZVswXX1mdW5jdGlvbiBjKGUpe3JldHVybiBlWzJdP3UoaSkrZVsyXSt1KG8pK2VbNF0ucmVwbGFjZSgvXihbPTpdKVxzKy8sIiQxICIpOmVbMF19dmFyIG49ITAscj0hMCxpLHMsbztyZXR1cm4gZS5tYXAoZnVuY3Rpb24oZSl7dmFyIHQ9ZS5tYXRjaCgvKFxzKikoLio/KShccyopKFs9Ol0uKikvKTtyZXR1cm4gdD9pPT1udWxsPyhpPXRbMV0ubGVuZ3RoLHM9dFsyXS5sZW5ndGgsbz10WzNdLmxlbmd0aCx0KTooaStzK28hPXRbMV0ubGVuZ3RoK3RbMl0ubGVuZ3RoK3RbM10ubGVuZ3RoJiYocj0hMSksaSE9dFsxXS5sZW5ndGgmJihuPSExKSxpPnRbMV0ubGVuZ3RoJiYoaT10WzFdLmxlbmd0aCksczx0WzJdLmxlbmd0aCYmKHM9dFsyXS5sZW5ndGgpLG8+dFszXS5sZW5ndGgmJihvPXRbM10ubGVuZ3RoKSx0KTpbZV19KS5tYXAodD9mOm4/cj9sOmY6Yyl9fSkuY2FsbChkLnByb3RvdHlwZSksdC5vblNlc3Npb25DaGFuZ2U9ZnVuY3Rpb24oZSl7dmFyIHQ9ZS5zZXNzaW9uO3QmJiF0Lm11bHRpU2VsZWN0JiYodC4kc2VsZWN0aW9uTWFya2Vycz1bXSx0LnNlbGVjdGlvbi4kaW5pdFJhbmdlTGlzdCgpLHQubXVsdGlTZWxlY3Q9dC5zZWxlY3Rpb24pLHRoaXMubXVsdGlTZWxlY3Q9dCYmdC5tdWx0aVNlbGVjdDt2YXIgbj1lLm9sZFNlc3Npb247biYmKG4ubXVsdGlTZWxlY3Qub2ZmKCJhZGRSYW5nZSIsdGhpcy4kb25BZGRSYW5nZSksbi5tdWx0aVNlbGVjdC5vZmYoInJlbW92ZVJhbmdlIix0aGlzLiRvblJlbW92ZVJhbmdlKSxuLm11bHRpU2VsZWN0Lm9mZigibXVsdGlTZWxlY3QiLHRoaXMuJG9uTXVsdGlTZWxlY3QpLG4ubXVsdGlTZWxlY3Qub2ZmKCJzaW5nbGVTZWxlY3QiLHRoaXMuJG9uU2luZ2xlU2VsZWN0KSxuLm11bHRpU2VsZWN0LmxlYWQub2ZmKCJjaGFuZ2UiLHRoaXMuJGNoZWNrTXVsdGlzZWxlY3RDaGFuZ2UpLG4ubXVsdGlTZWxlY3QuYW5jaG9yLm9mZigiY2hhbmdlIix0aGlzLiRjaGVja011bHRpc2VsZWN0Q2hhbmdlKSksdCYmKHQubXVsdGlTZWxlY3Qub24oImFkZFJhbmdlIix0aGlzLiRvbkFkZFJhbmdlKSx0Lm11bHRpU2VsZWN0Lm9uKCJyZW1vdmVSYW5nZSIsdGhpcy4kb25SZW1vdmVSYW5nZSksdC5tdWx0aVNlbGVjdC5vbigibXVsdGlTZWxlY3QiLHRoaXMuJG9uTXVsdGlTZWxlY3QpLHQubXVsdGlTZWxlY3Qub24oInNpbmdsZVNlbGVjdCIsdGhpcy4kb25TaW5nbGVTZWxlY3QpLHQubXVsdGlTZWxlY3QubGVhZC5vbigiY2hhbmdlIix0aGlzLiRjaGVja011bHRpc2VsZWN0Q2hhbmdlKSx0Lm11bHRpU2VsZWN0LmFuY2hvci5vbigiY2hhbmdlIix0aGlzLiRjaGVja011bHRpc2VsZWN0Q2hhbmdlKSksdCYmdGhpcy5pbk11bHRpU2VsZWN0TW9kZSE9dC5zZWxlY3Rpb24uaW5NdWx0aVNlbGVjdE1vZGUmJih0LnNlbGVjdGlvbi5pbk11bHRpU2VsZWN0TW9kZT90aGlzLiRvbk11bHRpU2VsZWN0KCk6dGhpcy4kb25TaW5nbGVTZWxlY3QoKSl9LHQuTXVsdGlTZWxlY3Q9bSxlKCIuL2NvbmZpZyIpLmRlZmluZU9wdGlvbnMoZC5wcm90b3R5cGUsImVkaXRvciIse2VuYWJsZU11bHRpc2VsZWN0OntzZXQ6ZnVuY3Rpb24oZSl7bSh0aGlzKSxlPyh0aGlzLm9uKCJjaGFuZ2VTZXNzaW9uIix0aGlzLiRtdWx0aXNlbGVjdE9uU2Vzc2lvbkNoYW5nZSksdGhpcy5vbigibW91c2Vkb3duIixvKSk6KHRoaXMub2ZmKCJjaGFuZ2VTZXNzaW9uIix0aGlzLiRtdWx0aXNlbGVjdE9uU2Vzc2lvbkNoYW5nZSksdGhpcy5vZmYoIm1vdXNlZG93biIsbykpfSx2YWx1ZTohMH0sZW5hYmxlQmxvY2tTZWxlY3Q6e3NldDpmdW5jdGlvbihlKXt0aGlzLiRibG9ja1NlbGVjdEVuYWJsZWQ9ZX0sdmFsdWU6ITB9fSl9KSxkZWZpbmUoImFjZS9tb2RlL2ZvbGRpbmcvZm9sZF9tb2RlIixbInJlcXVpcmUiLCJleHBvcnRzIiwibW9kdWxlIiwiYWNlL3JhbmdlIl0sZnVuY3Rpb24oZSx0LG4peyJ1c2Ugc3RyaWN0Ijt2YXIgcj1lKCIuLi8uLi9yYW5nZSIpLlJhbmdlLGk9dC5Gb2xkTW9kZT1mdW5jdGlvbigpe307KGZ1bmN0aW9uKCl7dGhpcy5mb2xkaW5nU3RhcnRNYXJrZXI9bnVsbCx0aGlzLmZvbGRpbmdTdG9wTWFya2VyPW51bGwsdGhpcy5nZXRGb2xkV2lkZ2V0PWZ1bmN0aW9uKGUsdCxuKXt2YXIgcj1lLmdldExpbmUobik7cmV0dXJuIHRoaXMuZm9sZGluZ1N0YXJ0TWFya2VyLnRlc3Qocik/InN0YXJ0Ijp0PT0ibWFya2JlZ2luZW5kIiYmdGhpcy5mb2xkaW5nU3RvcE1hcmtlciYmdGhpcy5mb2xkaW5nU3RvcE1hcmtlci50ZXN0KHIpPyJlbmQiOiIifSx0aGlzLmdldEZvbGRXaWRnZXRSYW5nZT1mdW5jdGlvbihlLHQsbil7cmV0dXJuIG51bGx9LHRoaXMuaW5kZW50YXRpb25CbG9jaz1mdW5jdGlvbihlLHQsbil7dmFyIGk9L1xTLyxzPWUuZ2V0TGluZSh0KSxvPXMuc2VhcmNoKGkpO2lmKG89PS0xKXJldHVybjt2YXIgdT1ufHxzLmxlbmd0aCxhPWUuZ2V0TGVuZ3RoKCksZj10LGw9dDt3aGlsZSgrK3Q8YSl7dmFyIGM9ZS5nZXRMaW5lKHQpLnNlYXJjaChpKTtpZihjPT0tMSljb250aW51ZTtpZihjPD1vKXt2YXIgaD1lLmdldFRva2VuQXQodCwwKTtpZighaHx8aC50eXBlIT09InN0cmluZyIpYnJlYWt9bD10fWlmKGw+Zil7dmFyIHA9ZS5nZXRMaW5lKGwpLmxlbmd0aDtyZXR1cm4gbmV3IHIoZix1LGwscCl9fSx0aGlzLm9wZW5pbmdCcmFja2V0QmxvY2s9ZnVuY3Rpb24oZSx0LG4saSxzKXt2YXIgbz17cm93Om4sY29sdW1uOmkrMX0sdT1lLiRmaW5kQ2xvc2luZ0JyYWNrZXQodCxvLHMpO2lmKCF1KXJldHVybjt2YXIgYT1lLmZvbGRXaWRnZXRzW3Uucm93XTtyZXR1cm4gYT09bnVsbCYmKGE9ZS5nZXRGb2xkV2lkZ2V0KHUucm93KSksYT09InN0YXJ0IiYmdS5yb3c+by5yb3cmJih1LnJvdy0tLHUuY29sdW1uPWUuZ2V0TGluZSh1LnJvdykubGVuZ3RoKSxyLmZyb21Qb2ludHMobyx1KX0sdGhpcy5jbG9zaW5nQnJhY2tldEJsb2NrPWZ1bmN0aW9uKGUsdCxuLGkscyl7dmFyIG89e3JvdzpuLGNvbHVtbjppfSx1PWUuJGZpbmRPcGVuaW5nQnJhY2tldCh0LG8pO2lmKCF1KXJldHVybjtyZXR1cm4gdS5jb2x1bW4rKyxvLmNvbHVtbi0tLHIuZnJvbVBvaW50cyh1LG8pfX0pLmNhbGwoaS5wcm90b3R5cGUpfSksZGVmaW5lKCJhY2UvbGluZV93aWRnZXRzIixbInJlcXVpcmUiLCJleHBvcnRzIiwibW9kdWxlIiwiYWNlL2xpYi9kb20iXSxmdW5jdGlvbihlLHQsbil7InVzZSBzdHJpY3QiO2Z1bmN0aW9uIGkoZSl7dGhpcy5zZXNzaW9uPWUsdGhpcy5zZXNzaW9uLndpZGdldE1hbmFnZXI9dGhpcyx0aGlzLnNlc3Npb24uZ2V0Um93TGVuZ3RoPXRoaXMuZ2V0Um93TGVuZ3RoLHRoaXMuc2Vzc2lvbi4kZ2V0V2lkZ2V0U2NyZWVuTGVuZ3RoPXRoaXMuJGdldFdpZGdldFNjcmVlbkxlbmd0aCx0aGlzLnVwZGF0ZU9uQ2hhbmdlPXRoaXMudXBkYXRlT25DaGFuZ2UuYmluZCh0aGlzKSx0aGlzLnJlbmRlcldpZGdldHM9dGhpcy5yZW5kZXJXaWRnZXRzLmJpbmQodGhpcyksdGhpcy5tZWFzdXJlV2lkZ2V0cz10aGlzLm1lYXN1cmVXaWRnZXRzLmJpbmQodGhpcyksdGhpcy5zZXNzaW9uLl9jaGFuZ2VkV2lkZ2V0cz1bXSx0aGlzLiRvbkNoYW5nZUVkaXRvcj10aGlzLiRvbkNoYW5nZUVkaXRvci5iaW5kKHRoaXMpLHRoaXMuc2Vzc2lvbi5vbigiY2hhbmdlIix0aGlzLnVwZGF0ZU9uQ2hhbmdlKSx0aGlzLnNlc3Npb24ub24oImNoYW5nZUZvbGQiLHRoaXMudXBkYXRlT25Gb2xkKSx0aGlzLnNlc3Npb24ub24oImNoYW5nZUVkaXRvciIsdGhpcy4kb25DaGFuZ2VFZGl0b3IpfXZhciByPWUoIi4vbGliL2RvbSIpOyhmdW5jdGlvbigpe3RoaXMuZ2V0Um93TGVuZ3RoPWZ1bmN0aW9uKGUpe3ZhciB0O3JldHVybiB0aGlzLmxpbmVXaWRnZXRzP3Q9dGhpcy5saW5lV2lkZ2V0c1tlXSYmdGhpcy5saW5lV2lkZ2V0c1tlXS5yb3dDb3VudHx8MDp0PTAsIXRoaXMuJHVzZVdyYXBNb2RlfHwhdGhpcy4kd3JhcERhdGFbZV0/MSt0OnRoaXMuJHdyYXBEYXRhW2VdLmxlbmd0aCsxK3R9LHRoaXMuJGdldFdpZGdldFNjcmVlbkxlbmd0aD1mdW5jdGlvbigpe3ZhciBlPTA7cmV0dXJuIHRoaXMubGluZVdpZGdldHMuZm9yRWFjaChmdW5jdGlvbih0KXt0JiZ0LnJvd0NvdW50JiYhdC5oaWRkZW4mJihlKz10LnJvd0NvdW50KX0pLGV9LHRoaXMuJG9uQ2hhbmdlRWRpdG9yPWZ1bmN0aW9uKGUpe3RoaXMuYXR0YWNoKGUuZWRpdG9yKX0sdGhpcy5hdHRhY2g9ZnVuY3Rpb24oZSl7ZSYmZS53aWRnZXRNYW5hZ2VyJiZlLndpZGdldE1hbmFnZXIhPXRoaXMmJmUud2lkZ2V0TWFuYWdlci5kZXRhY2goKTtpZih0aGlzLmVkaXRvcj09ZSlyZXR1cm47dGhpcy5kZXRhY2goKSx0aGlzLmVkaXRvcj1lLGUmJihlLndpZGdldE1hbmFnZXI9dGhpcyxlLnJlbmRlcmVyLm9uKCJiZWZvcmVSZW5kZXIiLHRoaXMubWVhc3VyZVdpZGdldHMpLGUucmVuZGVyZXIub24oImFmdGVyUmVuZGVyIix0aGlzLnJlbmRlcldpZGdldHMpKX0sdGhpcy5kZXRhY2g9ZnVuY3Rpb24oZSl7dmFyIHQ9dGhpcy5lZGl0b3I7aWYoIXQpcmV0dXJuO3RoaXMuZWRpdG9yPW51bGwsdC53aWRnZXRNYW5hZ2VyPW51bGwsdC5yZW5kZXJlci5vZmYoImJlZm9yZVJlbmRlciIsdGhpcy5tZWFzdXJlV2lkZ2V0cyksdC5yZW5kZXJlci5vZmYoImFmdGVyUmVuZGVyIix0aGlzLnJlbmRlcldpZGdldHMpO3ZhciBuPXRoaXMuc2Vzc2lvbi5saW5lV2lkZ2V0cztuJiZuLmZvckVhY2goZnVuY3Rpb24oZSl7ZSYmZS5lbCYmZS5lbC5wYXJlbnROb2RlJiYoZS5faW5Eb2N1bWVudD0hMSxlLmVsLnBhcmVudE5vZGUucmVtb3ZlQ2hpbGQoZS5lbCkpfSl9LHRoaXMudXBkYXRlT25Gb2xkPWZ1bmN0aW9uKGUsdCl7dmFyIG49dC5saW5lV2lkZ2V0cztpZighbnx8IWUuYWN0aW9uKXJldHVybjt2YXIgcj1lLmRhdGEsaT1yLnN0YXJ0LnJvdyxzPXIuZW5kLnJvdyxvPWUuYWN0aW9uPT0iYWRkIjtmb3IodmFyIHU9aSsxO3U8czt1Kyspblt1XSYmKG5bdV0uaGlkZGVuPW8pO25bc10mJihvP25baV0/bltzXS5oaWRkZW49bzpuW2ldPW5bc106KG5baV09PW5bc10mJihuW2ldPXVuZGVmaW5lZCksbltzXS5oaWRkZW49bykpfSx0aGlzLnVwZGF0ZU9uQ2hhbmdlPWZ1bmN0aW9uKGUpe3ZhciB0PXRoaXMuc2Vzc2lvbi5saW5lV2lkZ2V0cztpZighdClyZXR1cm47dmFyIG49ZS5zdGFydC5yb3cscj1lLmVuZC5yb3ctbjtpZihyIT09MClpZihlLmFjdGlvbj09InJlbW92ZSIpe3ZhciBpPXQuc3BsaWNlKG4rMSxyKTshdFtuXSYmaVtpLmxlbmd0aC0xXSYmKHRbbl09aS5wb3AoKSksaS5mb3JFYWNoKGZ1bmN0aW9uKGUpe2UmJnRoaXMucmVtb3ZlTGluZVdpZGdldChlKX0sdGhpcyksdGhpcy4kdXBkYXRlUm93cygpfWVsc2V7dmFyIHM9bmV3IEFycmF5KHIpO3Rbbl0mJnRbbl0uY29sdW1uIT1udWxsJiZlLnN0YXJ0LmNvbHVtbj50W25dLmNvbHVtbiYmbisrLHMudW5zaGlmdChuLDApLHQuc3BsaWNlLmFwcGx5KHQscyksdGhpcy4kdXBkYXRlUm93cygpfX0sdGhpcy4kdXBkYXRlUm93cz1mdW5jdGlvbigpe3ZhciBlPXRoaXMuc2Vzc2lvbi5saW5lV2lkZ2V0cztpZighZSlyZXR1cm47dmFyIHQ9ITA7ZS5mb3JFYWNoKGZ1bmN0aW9uKGUsbil7aWYoZSl7dD0hMSxlLnJvdz1uO3doaWxlKGUuJG9sZFdpZGdldCllLiRvbGRXaWRnZXQucm93PW4sZT1lLiRvbGRXaWRnZXR9fSksdCYmKHRoaXMuc2Vzc2lvbi5saW5lV2lkZ2V0cz1udWxsKX0sdGhpcy4kcmVnaXN0ZXJMaW5lV2lkZ2V0PWZ1bmN0aW9uKGUpe3RoaXMuc2Vzc2lvbi5saW5lV2lkZ2V0c3x8KHRoaXMuc2Vzc2lvbi5saW5lV2lkZ2V0cz1uZXcgQXJyYXkodGhpcy5zZXNzaW9uLmdldExlbmd0aCgpKSk7dmFyIHQ9dGhpcy5zZXNzaW9uLmxpbmVXaWRnZXRzW2Uucm93XTtyZXR1cm4gdCYmKGUuJG9sZFdpZGdldD10LHQuZWwmJnQuZWwucGFyZW50Tm9kZSYmKHQuZWwucGFyZW50Tm9kZS5yZW1vdmVDaGlsZCh0LmVsKSx0Ll9pbkRvY3VtZW50PSExKSksdGhpcy5zZXNzaW9uLmxpbmVXaWRnZXRzW2Uucm93XT1lLGV9LHRoaXMuYWRkTGluZVdpZGdldD1mdW5jdGlvbihlKXt0aGlzLiRyZWdpc3RlckxpbmVXaWRnZXQoZSksZS5zZXNzaW9uPXRoaXMuc2Vzc2lvbjtpZighdGhpcy5lZGl0b3IpcmV0dXJuIGU7dmFyIHQ9dGhpcy5lZGl0b3IucmVuZGVyZXI7ZS5odG1sJiYhZS5lbCYmKGUuZWw9ci5jcmVhdGVFbGVtZW50KCJkaXYiKSxlLmVsLmlubmVySFRNTD1lLmh0bWwpLGUuZWwmJihyLmFkZENzc0NsYXNzKGUuZWwsImFjZV9saW5lV2lkZ2V0Q29udGFpbmVyIiksZS5lbC5zdHlsZS5wb3NpdGlvbj0iYWJzb2x1dGUiLGUuZWwuc3R5bGUuekluZGV4PTUsdC5jb250YWluZXIuYXBwZW5kQ2hpbGQoZS5lbCksZS5faW5Eb2N1bWVudD0hMCxlLmNvdmVyR3V0dGVyfHwoZS5lbC5zdHlsZS56SW5kZXg9MyksZS5waXhlbEhlaWdodD09bnVsbCYmKGUucGl4ZWxIZWlnaHQ9ZS5lbC5vZmZzZXRIZWlnaHQpKSxlLnJvd0NvdW50PT1udWxsJiYoZS5yb3dDb3VudD1lLnBpeGVsSGVpZ2h0L3QubGF5ZXJDb25maWcubGluZUhlaWdodCk7dmFyIG49dGhpcy5zZXNzaW9uLmdldEZvbGRBdChlLnJvdywwKTtlLiRmb2xkPW47aWYobil7dmFyIGk9dGhpcy5zZXNzaW9uLmxpbmVXaWRnZXRzO2Uucm93PT1uLmVuZC5yb3cmJiFpW24uc3RhcnQucm93XT9pW24uc3RhcnQucm93XT1lOmUuaGlkZGVuPSEwfXJldHVybiB0aGlzLnNlc3Npb24uX2VtaXQoImNoYW5nZUZvbGQiLHtkYXRhOntzdGFydDp7cm93OmUucm93fX19KSx0aGlzLiR1cGRhdGVSb3dzKCksdGhpcy5yZW5kZXJXaWRnZXRzKG51bGwsdCksdGhpcy5vbldpZGdldENoYW5nZWQoZSksZX0sdGhpcy5yZW1vdmVMaW5lV2lkZ2V0PWZ1bmN0aW9uKGUpe2UuX2luRG9jdW1lbnQ9ITEsZS5zZXNzaW9uPW51bGwsZS5lbCYmZS5lbC5wYXJlbnROb2RlJiZlLmVsLnBhcmVudE5vZGUucmVtb3ZlQ2hpbGQoZS5lbCk7aWYoZS5lZGl0b3ImJmUuZWRpdG9yLmRlc3Ryb3kpdHJ5e2UuZWRpdG9yLmRlc3Ryb3koKX1jYXRjaCh0KXt9aWYodGhpcy5zZXNzaW9uLmxpbmVXaWRnZXRzKXt2YXIgbj10aGlzLnNlc3Npb24ubGluZVdpZGdldHNbZS5yb3ddO2lmKG49PWUpdGhpcy5zZXNzaW9uLmxpbmVXaWRnZXRzW2Uucm93XT1lLiRvbGRXaWRnZXQsZS4kb2xkV2lkZ2V0JiZ0aGlzLm9uV2lkZ2V0Q2hhbmdlZChlLiRvbGRXaWRnZXQpO2Vsc2Ugd2hpbGUobil7aWYobi4kb2xkV2lkZ2V0PT1lKXtuLiRvbGRXaWRnZXQ9ZS4kb2xkV2lkZ2V0O2JyZWFrfW49bi4kb2xkV2lkZ2V0fX10aGlzLnNlc3Npb24uX2VtaXQoImNoYW5nZUZvbGQiLHtkYXRhOntzdGFydDp7cm93OmUucm93fX19KSx0aGlzLiR1cGRhdGVSb3dzKCl9LHRoaXMuZ2V0V2lkZ2V0c0F0Um93PWZ1bmN0aW9uKGUpe3ZhciB0PXRoaXMuc2Vzc2lvbi5saW5lV2lkZ2V0cyxuPXQmJnRbZV0scj1bXTt3aGlsZShuKXIucHVzaChuKSxuPW4uJG9sZFdpZGdldDtyZXR1cm4gcn0sdGhpcy5vbldpZGdldENoYW5nZWQ9ZnVuY3Rpb24oZSl7dGhpcy5zZXNzaW9uLl9jaGFuZ2VkV2lkZ2V0cy5wdXNoKGUpLHRoaXMuZWRpdG9yJiZ0aGlzLmVkaXRvci5yZW5kZXJlci51cGRhdGVGdWxsKCl9LHRoaXMubWVhc3VyZVdpZGdldHM9ZnVuY3Rpb24oZSx0KXt2YXIgbj10aGlzLnNlc3Npb24uX2NoYW5nZWRXaWRnZXRzLHI9dC5sYXllckNvbmZpZztpZighbnx8IW4ubGVuZ3RoKXJldHVybjt2YXIgaT1JbmZpbml0eTtmb3IodmFyIHM9MDtzPG4ubGVuZ3RoO3MrKyl7dmFyIG89bltzXTtpZighb3x8IW8uZWwpY29udGludWU7aWYoby5zZXNzaW9uIT10aGlzLnNlc3Npb24pY29udGludWU7aWYoIW8uX2luRG9jdW1lbnQpe2lmKHRoaXMuc2Vzc2lvbi5saW5lV2lkZ2V0c1tvLnJvd10hPW8pY29udGludWU7by5faW5Eb2N1bWVudD0hMCx0LmNvbnRhaW5lci5hcHBlbmRDaGlsZChvLmVsKX1vLmg9by5lbC5vZmZzZXRIZWlnaHQsby5maXhlZFdpZHRofHwoby53PW8uZWwub2Zmc2V0V2lkdGgsby5zY3JlZW5XaWR0aD1NYXRoLmNlaWwoby53L3IuY2hhcmFjdGVyV2lkdGgpKTt2YXIgdT1vLmgvci5saW5lSGVpZ2h0O28uY292ZXJMaW5lJiYodS09dGhpcy5zZXNzaW9uLmdldFJvd0xpbmVDb3VudChvLnJvdyksdTwwJiYodT0wKSksby5yb3dDb3VudCE9dSYmKG8ucm93Q291bnQ9dSxvLnJvdzxpJiYoaT1vLnJvdykpfWkhPUluZmluaXR5JiYodGhpcy5zZXNzaW9uLl9lbWl0KCJjaGFuZ2VGb2xkIix7ZGF0YTp7c3RhcnQ6e3JvdzppfX19KSx0aGlzLnNlc3Npb24ubGluZVdpZGdldFdpZHRoPW51bGwpLHRoaXMuc2Vzc2lvbi5fY2hhbmdlZFdpZGdldHM9W119LHRoaXMucmVuZGVyV2lkZ2V0cz1mdW5jdGlvbihlLHQpe3ZhciBuPXQubGF5ZXJDb25maWcscj10aGlzLnNlc3Npb24ubGluZVdpZGdldHM7aWYoIXIpcmV0dXJuO3ZhciBpPU1hdGgubWluKHRoaXMuZmlyc3RSb3csbi5maXJzdFJvdykscz1NYXRoLm1heCh0aGlzLmxhc3RSb3csbi5sYXN0Um93LHIubGVuZ3RoKTt3aGlsZShpPjAmJiFyW2ldKWktLTt0aGlzLmZpcnN0Um93PW4uZmlyc3RSb3csdGhpcy5sYXN0Um93PW4ubGFzdFJvdyx0LiRjdXJzb3JMYXllci5jb25maWc9bjtmb3IodmFyIG89aTtvPD1zO28rKyl7dmFyIHU9cltvXTtpZighdXx8IXUuZWwpY29udGludWU7aWYodS5oaWRkZW4pe3UuZWwuc3R5bGUudG9wPS0xMDAtKHUucGl4ZWxIZWlnaHR8fDApKyJweCI7Y29udGludWV9dS5faW5Eb2N1bWVudHx8KHUuX2luRG9jdW1lbnQ9ITAsdC5jb250YWluZXIuYXBwZW5kQ2hpbGQodS5lbCkpO3ZhciBhPXQuJGN1cnNvckxheWVyLmdldFBpeGVsUG9zaXRpb24oe3JvdzpvLGNvbHVtbjowfSwhMCkudG9wO3UuY292ZXJMaW5lfHwoYSs9bi5saW5lSGVpZ2h0KnRoaXMuc2Vzc2lvbi5nZXRSb3dMaW5lQ291bnQodS5yb3cpKSx1LmVsLnN0eWxlLnRvcD1hLW4ub2Zmc2V0KyJweCI7dmFyIGY9dS5jb3Zlckd1dHRlcj8wOnQuZ3V0dGVyV2lkdGg7dS5maXhlZFdpZHRofHwoZi09dC5zY3JvbGxMZWZ0KSx1LmVsLnN0eWxlLmxlZnQ9ZisicHgiLHUuZnVsbFdpZHRoJiZ1LnNjcmVlbldpZHRoJiYodS5lbC5zdHlsZS5taW5XaWR0aD1uLndpZHRoKzIqbi5wYWRkaW5nKyJweCIpLHUuZml4ZWRXaWR0aD91LmVsLnN0eWxlLnJpZ2h0PXQuc2Nyb2xsQmFyLmdldFdpZHRoKCkrInB4Ijp1LmVsLnN0eWxlLnJpZ2h0PSIifX19KS5jYWxsKGkucHJvdG90eXBlKSx0LkxpbmVXaWRnZXRzPWl9KSxkZWZpbmUoImFjZS9leHQvZXJyb3JfbWFya2VyIixbInJlcXVpcmUiLCJleHBvcnRzIiwibW9kdWxlIiwiYWNlL2xpbmVfd2lkZ2V0cyIsImFjZS9saWIvZG9tIiwiYWNlL3JhbmdlIl0sZnVuY3Rpb24oZSx0LG4peyJ1c2Ugc3RyaWN0IjtmdW5jdGlvbiBvKGUsdCxuKXt2YXIgcj0wLGk9ZS5sZW5ndGgtMTt3aGlsZShyPD1pKXt2YXIgcz1yK2k+PjEsbz1uKHQsZVtzXSk7aWYobz4wKXI9cysxO2Vsc2V7aWYoIShvPDApKXJldHVybiBzO2k9cy0xfX1yZXR1cm4tKHIrMSl9ZnVuY3Rpb24gdShlLHQsbil7dmFyIHI9ZS5nZXRBbm5vdGF0aW9ucygpLnNvcnQocy5jb21wYXJlUG9pbnRzKTtpZighci5sZW5ndGgpcmV0dXJuO3ZhciBpPW8ocix7cm93OnQsY29sdW1uOi0xfSxzLmNvbXBhcmVQb2ludHMpO2k8MCYmKGk9LWktMSksaT49ci5sZW5ndGg/aT1uPjA/MDpyLmxlbmd0aC0xOmk9PT0wJiZuPDAmJihpPXIubGVuZ3RoLTEpO3ZhciB1PXJbaV07aWYoIXV8fCFuKXJldHVybjtpZih1LnJvdz09PXQpe2RvIHU9cltpKz1uXTt3aGlsZSh1JiZ1LnJvdz09PXQpO2lmKCF1KXJldHVybiByLnNsaWNlKCl9dmFyIGE9W107dD11LnJvdztkbyBhW248MD8idW5zaGlmdCI6InB1c2giXSh1KSx1PXJbaSs9bl07d2hpbGUodSYmdS5yb3c9PXQpO3JldHVybiBhLmxlbmd0aCYmYX12YXIgcj1lKCIuLi9saW5lX3dpZGdldHMiKS5MaW5lV2lkZ2V0cyxpPWUoIi4uL2xpYi9kb20iKSxzPWUoIi4uL3JhbmdlIikuUmFuZ2U7dC5zaG93RXJyb3JNYXJrZXI9ZnVuY3Rpb24oZSx0KXt2YXIgbj1lLnNlc3Npb247bi53aWRnZXRNYW5hZ2VyfHwobi53aWRnZXRNYW5hZ2VyPW5ldyByKG4pLG4ud2lkZ2V0TWFuYWdlci5hdHRhY2goZSkpO3ZhciBzPWUuZ2V0Q3Vyc29yUG9zaXRpb24oKSxvPXMucm93LGE9bi53aWRnZXRNYW5hZ2VyLmdldFdpZGdldHNBdFJvdyhvKS5maWx0ZXIoZnVuY3Rpb24oZSl7cmV0dXJuIGUudHlwZT09ImVycm9yTWFya2VyIn0pWzBdO2E/YS5kZXN0cm95KCk6by09dDt2YXIgZj11KG4sbyx0KSxsO2lmKGYpe3ZhciBjPWZbMF07cy5jb2x1bW49KGMucG9zJiZ0eXBlb2YgYy5jb2x1bW4hPSJudW1iZXIiP2MucG9zLnNjOmMuY29sdW1uKXx8MCxzLnJvdz1jLnJvdyxsPWUucmVuZGVyZXIuJGd1dHRlckxheWVyLiRhbm5vdGF0aW9uc1tzLnJvd119ZWxzZXtpZihhKXJldHVybjtsPXt0ZXh0OlsiTG9va3MgZ29vZCEiXSxjbGFzc05hbWU6ImFjZV9vayJ9fWUuc2Vzc2lvbi51bmZvbGQocy5yb3cpLGUuc2VsZWN0aW9uLm1vdmVUb1Bvc2l0aW9uKHMpO3ZhciBoPXtyb3c6cy5yb3csZml4ZWRXaWR0aDohMCxjb3Zlckd1dHRlcjohMCxlbDppLmNyZWF0ZUVsZW1lbnQoImRpdiIpLHR5cGU6ImVycm9yTWFya2VyIn0scD1oLmVsLmFwcGVuZENoaWxkKGkuY3JlYXRlRWxlbWVudCgiZGl2IikpLGQ9aC5lbC5hcHBlbmRDaGlsZChpLmNyZWF0ZUVsZW1lbnQoImRpdiIpKTtkLmNsYXNzTmFtZT0iZXJyb3Jfd2lkZ2V0X2Fycm93ICIrbC5jbGFzc05hbWU7dmFyIHY9ZS5yZW5kZXJlci4kY3Vyc29yTGF5ZXIuZ2V0UGl4ZWxQb3NpdGlvbihzKS5sZWZ0O2Quc3R5bGUubGVmdD12K2UucmVuZGVyZXIuZ3V0dGVyV2lkdGgtNSsicHgiLGguZWwuY2xhc3NOYW1lPSJlcnJvcl93aWRnZXRfd3JhcHBlciIscC5jbGFzc05hbWU9ImVycm9yX3dpZGdldCAiK2wuY2xhc3NOYW1lLHAuaW5uZXJIVE1MPWwudGV4dC5qb2luKCI8YnI+IikscC5hcHBlbmRDaGlsZChpLmNyZWF0ZUVsZW1lbnQoImRpdiIpKTt2YXIgbT1mdW5jdGlvbihlLHQsbil7aWYodD09PTAmJihuPT09ImVzYyJ8fG49PT0icmV0dXJuIikpcmV0dXJuIGguZGVzdHJveSgpLHtjb21tYW5kOiJudWxsIn19O2guZGVzdHJveT1mdW5jdGlvbigpe2lmKGUuJG1vdXNlSGFuZGxlci5pc01vdXNlUHJlc3NlZClyZXR1cm47ZS5rZXlCaW5kaW5nLnJlbW92ZUtleWJvYXJkSGFuZGxlcihtKSxuLndpZGdldE1hbmFnZXIucmVtb3ZlTGluZVdpZGdldChoKSxlLm9mZigiY2hhbmdlU2VsZWN0aW9uIixoLmRlc3Ryb3kpLGUub2ZmKCJjaGFuZ2VTZXNzaW9uIixoLmRlc3Ryb3kpLGUub2ZmKCJtb3VzZXVwIixoLmRlc3Ryb3kpLGUub2ZmKCJjaGFuZ2UiLGguZGVzdHJveSl9LGUua2V5QmluZGluZy5hZGRLZXlib2FyZEhhbmRsZXIobSksZS5vbigiY2hhbmdlU2VsZWN0aW9uIixoLmRlc3Ryb3kpLGUub24oImNoYW5nZVNlc3Npb24iLGguZGVzdHJveSksZS5vbigibW91c2V1cCIsaC5kZXN0cm95KSxlLm9uKCJjaGFuZ2UiLGguZGVzdHJveSksZS5zZXNzaW9uLndpZGdldE1hbmFnZXIuYWRkTGluZVdpZGdldChoKSxoLmVsLm9ubW91c2Vkb3duPWUuZm9jdXMuYmluZChlKSxlLnJlbmRlcmVyLnNjcm9sbEN1cnNvckludG9WaWV3KG51bGwsLjUse2JvdHRvbTpoLmVsLm9mZnNldEhlaWdodH0pfSxpLmltcG9ydENzc1N0cmluZygiXG4gICAgLmVycm9yX3dpZGdldF93cmFwcGVyIHtcbiAgICAgICAgYmFja2dyb3VuZDogaW5oZXJpdDtcbiAgICAgICAgY29sb3I6IGluaGVyaXQ7XG4gICAgICAgIGJvcmRlcjpub25lXG4gICAgfVxuICAgIC5lcnJvcl93aWRnZXQge1xuICAgICAgICBib3JkZXItdG9wOiBzb2xpZCAycHg7XG4gICAgICAgIGJvcmRlci1ib3R0b206IHNvbGlkIDJweDtcbiAgICAgICAgbWFyZ2luOiA1cHggMDtcbiAgICAgICAgcGFkZGluZzogMTBweCA0MHB4O1xuICAgICAgICB3aGl0ZS1zcGFjZTogcHJlLXdyYXA7XG4gICAgfVxuICAgIC5lcnJvcl93aWRnZXQuYWNlX2Vycm9yLCAuZXJyb3Jfd2lkZ2V0X2Fycm93LmFjZV9lcnJvcntcbiAgICAgICAgYm9yZGVyLWNvbG9yOiAjZmY1YTVhXG4gICAgfVxuICAgIC5lcnJvcl93aWRnZXQuYWNlX3dhcm5pbmcsIC5lcnJvcl93aWRnZXRfYXJyb3cuYWNlX3dhcm5pbmd7XG4gICAgICAgIGJvcmRlci1jb2xvcjogI0YxRDgxN1xuICAgIH1cbiAgICAuZXJyb3Jfd2lkZ2V0LmFjZV9pbmZvLCAuZXJyb3Jfd2lkZ2V0X2Fycm93LmFjZV9pbmZve1xuICAgICAgICBib3JkZXItY29sb3I6ICM1YTVhNWFcbiAgICB9XG4gICAgLmVycm9yX3dpZGdldC5hY2Vfb2ssIC5lcnJvcl93aWRnZXRfYXJyb3cuYWNlX29re1xuICAgICAgICBib3JkZXItY29sb3I6ICM1YWFhNWFcbiAgICB9XG4gICAgLmVycm9yX3dpZGdldF9hcnJvdyB7XG4gICAgICAgIHBvc2l0aW9uOiBhYnNvbHV0ZTtcbiAgICAgICAgYm9yZGVyOiBzb2xpZCA1cHg7XG4gICAgICAgIGJvcmRlci10b3AtY29sb3I6IHRyYW5zcGFyZW50IWltcG9ydGFudDtcbiAgICAgICAgYm9yZGVyLXJpZ2h0LWNvbG9yOiB0cmFuc3BhcmVudCFpbXBvcnRhbnQ7XG4gICAgICAgIGJvcmRlci1sZWZ0LWNvbG9yOiB0cmFuc3BhcmVudCFpbXBvcnRhbnQ7XG4gICAgICAgIHRvcDogLTVweDtcbiAgICB9XG4iLCJlcnJvcl9tYXJrZXIuY3NzIiwhMSl9KSxkZWZpbmUoImFjZS9hY2UiLFsicmVxdWlyZSIsImV4cG9ydHMiLCJtb2R1bGUiLCJhY2UvbGliL2RvbSIsImFjZS9saWIvZXZlbnQiLCJhY2UvcmFuZ2UiLCJhY2UvZWRpdG9yIiwiYWNlL2VkaXRfc2Vzc2lvbiIsImFjZS91bmRvbWFuYWdlciIsImFjZS92aXJ0dWFsX3JlbmRlcmVyIiwiYWNlL3dvcmtlci93b3JrZXJfY2xpZW50IiwiYWNlL2tleWJvYXJkL2hhc2hfaGFuZGxlciIsImFjZS9wbGFjZWhvbGRlciIsImFjZS9tdWx0aV9zZWxlY3QiLCJhY2UvbW9kZS9mb2xkaW5nL2ZvbGRfbW9kZSIsImFjZS90aGVtZS90ZXh0bWF0ZSIsImFjZS9leHQvZXJyb3JfbWFya2VyIiwiYWNlL2NvbmZpZyIsImFjZS9sb2FkZXJfYnVpbGQiXSxmdW5jdGlvbihlLHQsbil7InVzZSBzdHJpY3QiO2UoIi4vbG9hZGVyX2J1aWxkIikodCk7dmFyIHI9ZSgiLi9saWIvZG9tIiksaT1lKCIuL2xpYi9ldmVudCIpLHM9ZSgiLi9yYW5nZSIpLlJhbmdlLG89ZSgiLi9lZGl0b3IiKS5FZGl0b3IsdT1lKCIuL2VkaXRfc2Vzc2lvbiIpLkVkaXRTZXNzaW9uLGE9ZSgiLi91bmRvbWFuYWdlciIpLlVuZG9NYW5hZ2VyLGY9ZSgiLi92aXJ0dWFsX3JlbmRlcmVyIikuVmlydHVhbFJlbmRlcmVyO2UoIi4vd29ya2VyL3dvcmtlcl9jbGllbnQiKSxlKCIuL2tleWJvYXJkL2hhc2hfaGFuZGxlciIpLGUoIi4vcGxhY2Vob2xkZXIiKSxlKCIuL211bHRpX3NlbGVjdCIpLGUoIi4vbW9kZS9mb2xkaW5nL2ZvbGRfbW9kZSIpLGUoIi4vdGhlbWUvdGV4dG1hdGUiKSxlKCIuL2V4dC9lcnJvcl9tYXJrZXIiKSx0LmNvbmZpZz1lKCIuL2NvbmZpZyIpLHQuZWRpdD1mdW5jdGlvbihlLG4pe2lmKHR5cGVvZiBlPT0ic3RyaW5nIil7dmFyIHM9ZTtlPWRvY3VtZW50LmdldEVsZW1lbnRCeUlkKHMpO2lmKCFlKXRocm93IG5ldyBFcnJvcigiYWNlLmVkaXQgY2FuJ3QgZmluZCBkaXYgIyIrcyl9aWYoZSYmZS5lbnYmJmUuZW52LmVkaXRvciBpbnN0YW5jZW9mIG8pcmV0dXJuIGUuZW52LmVkaXRvcjt2YXIgdT0iIjtpZihlJiYvaW5wdXR8dGV4dGFyZWEvaS50ZXN0KGUudGFnTmFtZSkpe3ZhciBhPWU7dT1hLnZhbHVlLGU9ci5jcmVhdGVFbGVtZW50KCJwcmUiKSxhLnBhcmVudE5vZGUucmVwbGFjZUNoaWxkKGUsYSl9ZWxzZSBlJiYodT1lLnRleHRDb250ZW50LGUuaW5uZXJIVE1MPSIiKTt2YXIgbD10LmNyZWF0ZUVkaXRTZXNzaW9uKHUpLGM9bmV3IG8obmV3IGYoZSksbCxuKSxoPXtkb2N1bWVudDpsLGVkaXRvcjpjLG9uUmVzaXplOmMucmVzaXplLmJpbmQoYyxudWxsKX07cmV0dXJuIGEmJihoLnRleHRhcmVhPWEpLGkuYWRkTGlzdGVuZXIod2luZG93LCJyZXNpemUiLGgub25SZXNpemUpLGMub24oImRlc3Ryb3kiLGZ1bmN0aW9uKCl7aS5yZW1vdmVMaXN0ZW5lcih3aW5kb3csInJlc2l6ZSIsaC5vblJlc2l6ZSksaC5lZGl0b3IuY29udGFpbmVyLmVudj1udWxsfSksYy5jb250YWluZXIuZW52PWMuZW52PWgsY30sdC5jcmVhdGVFZGl0U2Vzc2lvbj1mdW5jdGlvbihlLHQpe3ZhciBuPW5ldyB1KGUsdCk7cmV0dXJuIG4uc2V0VW5kb01hbmFnZXIobmV3IGEpLG59LHQuUmFuZ2U9cyx0LkVkaXRvcj1vLHQuRWRpdFNlc3Npb249dSx0LlVuZG9NYW5hZ2VyPWEsdC5WaXJ0dWFsUmVuZGVyZXI9Zix0LnZlcnNpb249dC5jb25maWcudmVyc2lvbn0pOyAgICAgICAgICAgIChmdW5jdGlvbigpIHsKICAgICAgICAgICAgICAgIHdpbmRvdy5yZXF1aXJlKFsiYWNlL2FjZSJdLCBmdW5jdGlvbihhKSB7CiAgICAgICAgICAgICAgICAgICAgaWYgKGEpIHsKICAgICAgICAgICAgICAgICAgICAgICAgYS5jb25maWcuaW5pdCh0cnVlKTsKICAgICAgICAgICAgICAgICAgICAgICAgYS5kZWZpbmUgPSB3aW5kb3cuZGVmaW5lOwogICAgICAgICAgICAgICAgICAgIH0KICAgICAgICAgICAgICAgICAgICBpZiAoIXdpbmRvdy5hY2UpCiAgICAgICAgICAgICAgICAgICAgICAgIHdpbmRvdy5hY2UgPSBhOwogICAgICAgICAgICAgICAgICAgIGZvciAodmFyIGtleSBpbiBhKSBpZiAoYS5oYXNPd25Qcm9wZXJ0eShrZXkpKQogICAgICAgICAgICAgICAgICAgICAgICB3aW5kb3cuYWNlW2tleV0gPSBhW2tleV07CiAgICAgICAgICAgICAgICAgICAgd2luZG93LmFjZVsiZGVmYXVsdCJdID0gd2luZG93LmFjZTsKICAgICAgICAgICAgICAgICAgICBpZiAodHlwZW9mIG1vZHVsZSA9PSAib2JqZWN0IiAmJiB0eXBlb2YgZXhwb3J0cyA9PSAib2JqZWN0IiAmJiBtb2R1bGUpIHsKICAgICAgICAgICAgICAgICAgICAgICAgbW9kdWxlLmV4cG9ydHMgPSB3aW5kb3cuYWNlOwogICAgICAgICAgICAgICAgICAgIH0KICAgICAgICAgICAgICAgIH0pOwogICAgICAgICAgICB9KSgpOwogICAgICAgIA==',
    'js-bootstrap' => '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',
    'js-dropzone' => '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