<?php

// Do not allow directly accessing this file.
if ( ! defined( 'ABSPATH' ) ) {
    exit( 'Direct script access denied.' );
}

function nova_miniture_get_demo_array($dir_url, $dir_path){

    $demo_items = array(
        'demo-01' => array(
            'link'          => 'https://miniture.novaworks.net/',
            'title'         => 'Demo 01',
            'data_sample'   => 'data.json',
            'data_product'  => 'furniture.csv',
            'data_widget'   => 'widget.json',
            'data_elementor'=> [
                'header'       => [
                    'location' => 'header',
                    'value' => [
                        'header-1' => 'include/general',
                    ],
                ],
                'footer'       => [
                    'location' => 'footer',
                    'value' => [
                        'footer-1' => 'include/general',
                    ],
                ],
            ],
            'category'      => array(
                'Demo',
	            'Furniture'
            )
        ),
        'demo-02' => array(
            'link'          => 'https://miniture.novaworks.net/home-v2',
            'title'         => 'Demo 02',
            'data_sample'   => 'data.json',
            'data_product'  => 'furniture.csv',
            'data_widget'   => 'widget.json',
            'data_slider'   => 'home-v2.zip',
            'data_elementor'=> [
                'header'       => [
                    'location' => 'header',
                    'value' => [
                        'header-1' => 'include/general',
                    ],
                ],
                'footer'       => [
                    'location' => 'footer',
                    'value' => [
                        'footer-1' => 'include/general',
                    ],
                ],
            ],
            'category'      => array(
                'Demo',
	            'Furniture'
            )
        ),
        'demo-03' => array(
            'link'          => 'https://miniture.novaworks.net/home-v3',
            'title'         => 'Demo 03',
            'data_sample'   => 'data.json',
            'data_product'  => 'furniture.csv',
            'data_widget'   => 'widget.json',
            //'data_slider'   => 'home-v2.zip',
            'data_elementor'=> [
                'header'       => [
                    'location' => 'header',
                    'value' => [
                        'header-1' => 'include/general',
                    ],
                ],
                'footer'       => [
                    'location' => 'footer',
                    'value' => [
                        'footer-1' => 'include/general',
                    ],
                ],
            ],
            'category'      => array(
                'Demo',
	            'Furniture'
            )
        ),
        'demo-04' => array(
            'link'          => 'https://miniture.novaworks.net/home-v4',
            'title'         => 'Demo 04',
            'data_sample'   => 'data.json',
            'data_product'  => 'furniture.csv',
            'data_widget'   => 'widget.json',
            'data_slider'   => 'home-v4.zip',
            'data_elementor'=> [
                'header'       => [
                    'location' => 'header',
                    'value' => [
                        'header-1' => 'include/general',
                    ],
                ],
                'footer'       => [
                    'location' => 'footer',
                    'value' => [
                        'footer-1' => 'include/general',
                    ],
                ],
            ],
            'category'      => array(
                'Demo',
	            'Furniture'
            )
        ),
        'demo-05' => array(
            'link'          => 'https://miniture.novaworks.net/home-v5',
            'title'         => 'Demo 05',
            'data_sample'   => 'data.json',
            'data_product'  => 'furniture.csv',
            'data_widget'   => 'widget.json',
            'data_slider'   => 'home-v5.zip',
            'data_elementor'=> [
                'header'       => [
                    'location' => 'header',
                    'value' => [
                        'header-1' => 'include/general',
                    ],
                ],
                'footer'       => [
                    'location' => 'footer',
                    'value' => [
                        'footer-1' => 'include/general',
                    ],
                ],
            ],
            'category'      => array(
                'Demo',
	            'Furniture'
            )
        ),
        'demo-06' => array(
            'link'          => 'https://miniture.novaworks.net/home-v6',
            'title'         => 'Demo 06',
            'data_sample'   => 'data.json',
            'data_product'  => 'furniture.csv',
            'data_widget'   => 'widget.json',
            //'data_slider'   => 'home-v5.zip',
            'data_elementor'=> [
                'header'       => [
                    'location' => 'header',
                    'value' => [
                        'header-1' => 'include/general',
                    ],
                ],
                'footer'       => [
                    'location' => 'footer',
                    'value' => [
                        'footer-1' => 'include/general',
                    ],
                ],
            ],
            'category'      => array(
                'Demo',
	            'Furniture'
            )
        ),
        'demo-07' => array(
            'link'          => 'https://miniture.novaworks.net/home-v7',
            'title'         => 'Demo 07',
            'data_sample'   => 'data.json',
            'data_product'  => 'fashion.csv',
            'data_widget'   => 'widget.json',
            'data_slider'   => 'home-v7.zip',
            'data_elementor'=> [
                'header'       => [
                    'location' => 'header',
                    'value' => [
                        'header-1' => 'include/general',
                    ],
                ],
                'footer'       => [
                    'location' => 'footer',
                    'value' => [
                        'footer-1' => 'include/general',
                    ],
                ],
            ],
            'category'      => array(
                'Demo',
	            'Fashion'
            )
        ),
        'demo-08' => array(
            'link'          => 'https://miniture.novaworks.net/home-v8',
            'title'         => 'Demo 08',
            'data_sample'   => 'data.json',
            'data_product'  => 'fashion.csv',
            'data_widget'   => 'widget.json',
            //'data_slider'   => 'home-v7.zip',
            'data_elementor'=> [
                'header'       => [
                    'location' => 'header',
                    'value' => [
                        'header-1' => 'include/general',
                    ],
                ],
                'footer'       => [
                    'location' => 'footer',
                    'value' => [
                        'footer-1' => 'include/general',
                    ],
                ],
            ],
            'category'      => array(
                'Demo',
	            'Fashion'
            )
        ),
        'demo-09' => array(
            'link'          => 'https://miniture.novaworks.net/home-v9',
            'title'         => 'Demo 09',
            'data_sample'   => 'data.json',
            'data_product'  => 'glasses.csv',
            'data_widget'   => 'widget.json',
            'data_slider'   => 'home-v9.zip',
            'data_elementor'=> [
                'header'       => [
                    'location' => 'header',
                    'value' => [
                        'header-1' => 'include/general',
                    ],
                ],
                'footer'       => [
                    'location' => 'footer',
                    'value' => [
                        'footer-1' => 'include/general',
                    ],
                ],
            ],
            'category'      => array(
                'Demo',
	            'Fashion'
            )
        ),
        'demo-10' => array(
            'link'          => 'https://miniture.novaworks.net/home-v10',
            'title'         => 'Demo 10',
            'data_sample'   => 'data.json',
            'data_product'  => 'watches.csv',
            'data_widget'   => 'widget.json',
            'data_slider'   => 'home-v10.zip',
            'data_elementor'=> [
                'header'       => [
                    'location' => 'header',
                    'value' => [
                        'header-1' => 'include/general',
                    ],
                ],
                'footer'       => [
                    'location' => 'footer',
                    'value' => [
                        'footer-1' => 'include/general',
                    ],
                ],
            ],
            'category'      => array(
                'Demo',
	            'Fashion'
            )
        ),
        'demo-11' => array(
            'link'          => 'https://miniture.novaworks.net/home-v11',
            'title'         => 'Demo 11',
            'data_sample'   => 'data.json',
            'data_product'  => 'electronic.csv',
            'data_widget'   => 'widget.json',
            //'data_slider'   => 'home-v10.zip',
            'data_elementor'=> [
                'header'       => [
                    'location' => 'header',
                    'value' => [
                        'header-1' => 'include/general',
                    ],
                ],
                'footer'       => [
                    'location' => 'footer',
                    'value' => [
                        'footer-1' => 'include/general',
                    ],
                ],
            ],
            'category'      => array(
                'Demo',
	            'Electronic'
            )
        ),
        'demo-12' => array(
            'link'          => 'https://miniture.novaworks.net/home-v12',
            'title'         => 'Demo 12',
            'data_sample'   => 'data.json',
            'data_product'  => 'smarthome.csv',
            'data_widget'   => 'widget.json',
            'data_slider'   => 'home-v12.zip',
            'data_elementor'=> [
                'header'       => [
                    'location' => 'header',
                    'value' => [
                        'header-1' => 'include/general',
                    ],
                ],
                'footer'       => [
                    'location' => 'footer',
                    'value' => [
                        'footer-1' => 'include/general',
                    ],
                ],
            ],
            'category'      => array(
                'Demo',
	            'Electronic'
            )
        ),
        'demo-13' => array(
            'link'          => 'https://miniture.novaworks.net/home-v13',
            'title'         => 'Demo 13',
            'data_sample'   => 'data.json',
            'data_product'  => 'pets.csv',
            'data_widget'   => 'widget.json',
            'data_slider'   => 'home-v13.zip',
            'data_elementor'=> [
                'header'       => [
                    'location' => 'header',
                    'value' => [
                        'header-1' => 'include/general',
                    ],
                ],
                'footer'       => [
                    'location' => 'footer',
                    'value' => [
                        'footer-1' => 'include/general',
                    ],
                ],
            ],
            'category'      => array(
                'Demo',
	            'Other'
            )
        ),
        'demo-14' => array(
            'link'          => 'https://miniture.novaworks.net/home-v14',
            'title'         => 'Demo 14',
            'data_sample'   => 'data.json',
            'data_product'  => 'baby.csv',
            'data_widget'   => 'widget.json',
            'data_slider'   => 'home-v14.zip',
            'data_elementor'=> [
                'header'       => [
                    'location' => 'header',
                    'value' => [
                        'header-1' => 'include/general',
                    ],
                ],
                'footer'       => [
                    'location' => 'footer',
                    'value' => [
                        'footer-1' => 'include/general',
                    ],
                ],
            ],
            'category'      => array(
                'Demo',
	            'Other'
            )
        ),
    );

    $default_image_setting = array(
        'woocommerce_single_image_width' => 1000,
        'woocommerce_thumbnail_image_width' => 700,
        'woocommerce_thumbnail_cropping' => 'custom',
        'woocommerce_thumbnail_cropping_custom_width' => 1000,
        'woocommerce_thumbnail_cropping_custom_height' => 1000
    );

    $default_menu = array(
        'nova_menu_primary'             => 'Main Menu',
    );

    $default_page = array(
        'page_for_posts' 	            => 'Blog',
        'woocommerce_shop_page_id'      => 'Shop',
        'woocommerce_cart_page_id'      => 'Cart',
        'woocommerce_checkout_page_id'  => 'Checkout',
        'woocommerce_myaccount_page_id' => 'My account'
    );

    $slider = $dir_path . 'Slider/';
    $content = $dir_path . 'Content/';
    $product = $dir_path . 'Product/';
    $widget = $dir_path . 'Widget/';
    $setting = $dir_path . 'Setting/';
    $preview = $dir_url;

    $default_elementor = [
        'archive'           => [
            'location' => 'archive',
            'value' => [
                '' => 'include/archive'
            ]
        ],
        'search-results'    => [
            'location' => 'archive',
            'value'    => '',
            'default' => [
                'name' => 'include/archive/search'
            ],
        ],
        'product'           => [
            'location' => 'single',
            'value' => [
                'single-product-01' => 'include/product'
            ]
        ],
        'product-archive'   => [
            'location' => 'archive',
            'value' => [
                'shop-left-sidebar' => 'include/product_archive'
            ]
        ],
    ];
    $elementor_kit_settings = json_decode('{"template":"default","space_between_widgets":{"column":"0","row":"0","isLinked":true,"unit":"px","size":0},"page_title_selector":"h1.entry-title","active_breakpoints":["viewport_mobile","viewport_mobile_extra","viewport_tablet","viewport_tablet_extra","viewport_laptop"],"viewport_mobile":767,"viewport_md":768,"viewport_mobile_extra":991,"viewport_tablet":1024,"viewport_tablet_extra":1279,"viewport_lg":1025,"viewport_laptop":1599,"system_colors":[{"_id":"primary","title":"Primary","color":"#181818"},{"_id":"secondary","title":"Secondary","color":"#181818"},{"_id":"text","title":"Text","color":"#666666"},{"_id":"accent","title":"Accent","color":"#FFA832"}],"system_typography":[{"_id":"primary","title":"Primary"},{"_id":"secondary","title":"Secondary"},{"_id":"text","title":"Text"},{"_id":"accent","title":"Accent"}],"custom_colors":[{"_id":"756b8a8","title":"Border Color","color":"#ECECEC"}],"custom_typography":[],"default_generic_fonts":"Sans-serif","container_width":{"unit":"px","size":1280,"sizes":[]},"default_page_template":"elementor_header_footer","activeItemIndex":1,"container_padding":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":true},"colors_enable_styleguide_preview":"yes"}', true);
    $data_return = array();

    foreach ($demo_items as $demo_key => $demo_detail){
	    $value = array();
	    $value['title']             = $demo_detail['title'];
	    $value['category']          = !empty($demo_detail['category']) ? $demo_detail['category'] : array('Demo');
	    $value['demo_preset']       = $demo_key;
	    $value['demo_url']          = $demo_detail['link'];
	    $value['preview']           = !empty($demo_detail['preview']) ? $demo_detail['preview'] : ($preview . $demo_key . '.jpg');
	    $value['content']           = !empty($demo_detail['data_sample']) ? $content . $demo_detail['data_sample'] : $content . 'sample-data.json';
	    $value['option']            = !empty($demo_detail['data_option']) ? $setting . $demo_detail['data_option'] : $setting . 'settings.json';
	    $value['product']           = !empty($demo_detail['data_product']) ? $product . $demo_detail['data_product'] : $product . 'sample-product.json';
	    $value['widget']            = !empty($demo_detail['data_widget']) ? $widget . $demo_detail['data_widget'] : $widget . 'widget.json';
	    $value['pages']             = array_merge( $default_page, array( 'page_on_front' => $demo_detail['title'] ));
	    $value['menu-locations']    = array_merge( $default_menu, isset($demo_detail['menu-locations']) ? $demo_detail['menu-locations'] : array());
	    $value['other_setting']     = array_merge( $default_image_setting, isset($demo_detail['other_setting']) ? $demo_detail['other_setting'] : array());
	    if(!empty($demo_detail['data_slider'])){
		    $value['slider'] = $slider . $demo_detail['data_slider'];
	    }
      $value['elementor']         = array_merge( $default_elementor, isset($demo_detail['data_elementor']) ? $demo_detail['data_elementor'] : array());
      $value['elementor_kit_settings']         = array_merge( $elementor_kit_settings, isset($demo_detail['elementor_kit_settings']) ? $demo_detail['elementor_kit_settings'] : array());
	    $data_return[$demo_key] = $value;
    }

    return $data_return;
}
