<?php
$opt_name = NOVA_FRAMEWORK_VAR;

CSF::createSection( $opt_name, array(
    'title'       => esc_html__('Advanced Settings', 'miniture-core'),
    'icon'        => 'fa fa-cogs',
    'description' => __('Remember to backup your Theme Options before&nbsp;<b>Update the Theme.</b>', 'miniture-core'),
    'fields'      => array(
        array(
			'id' => 'enable_open_graph',
			'type' => 'switcher',
			'title' => esc_html__('Enable Meta Tags (Open Graph)', 'miniture-core'),
            'subtitle' => esc_html__('Example: og:image', 'miniture-core'),
			'desc' => esc_html__('Enable Open Graph basic support, if you are using Yoast SEO, it is recommended to disable this option.', 'miniture-core'),
			'default' => 1
		),
		array(
			'id' => 'css_code',
			'type' => 'code_editor',
			'title' => esc_html__('Custom CSS Code', 'miniture-core'),
			'desc' => esc_html__('e.g. #header{ background: #000; } Dont use &lt;style&gt; tags', 'miniture-core'),
			'subtitle' => esc_html__('Paste your CSS code here.', 'miniture-core'),
            'settings' => array(
                'theme'  => 'dracula',
                'mode'   => 'css',
                'tabSize' => 4
            ),
            'sanitize' => false
        ),
        array(
			'id' => 'custom_scripts',
			'type' => 'code_editor',
			'title' => esc_html__('Custom Scripts Below <head>', 'miniture-core'),
            'desc' => esc_html__('Here you can paste your Google Analytics code (not your id) or Adsense code. If you dont have it or you are already using one, just leave blank.', 'miniture-core'),
            'settings' => array(
                'theme'  => 'dracula',
                'mode'   => 'htmlmixed',
                'tabSize' => 4
            ),
            'sanitize' => false
        ),
        array(
			'id' => 'custom_scripts_body',
			'type' => 'code_editor',
			'title' => esc_html__('Custom Scripts just after opening <body>', 'miniture-core'),
            'desc' => esc_html__('Here you can paste your any custom script that will be included on Body with high priority, like Google Tag code.', 'miniture-core'),
            'settings' => array(
                'theme'  => 'dracula',
                'mode'   => 'htmlmixed',
                'tabSize' => 4
            ),
            'sanitize' => false
        ),
        array(
			'id' => 'custom_scripts_footer',
			'type' => 'code_editor',
			'title' => esc_html__('Custom Scripts on Footer before closing </body>', 'miniture-core'),
            'desc' => esc_html__('Here you can paste your any custom script that will be included on Footer with less priority.', 'miniture-core'),
            'settings' => array(
                'theme'  => 'dracula',
                'mode'   => 'htmlmixed',
                'tabSize' => 4
            ),
            'sanitize' => false
        ),
    )
) );
