<?php if ($items): ?>
    <ul>
    <?php foreach ($items as $item): ?>
        <li class="group" data-status="<?= $this->getCollapseStatus($item->pluginClass, false) ? 'expanded' : 'collapsed' ?>" data-group-id="<?= e($item->pluginClass) ?>">
            <div class="group">
                <h4><a href="#"><?= e(trans($item->title)) ?></a></h4>
                <i class="<?= e($item->icon) ?>"></i>
                <span class="description"><?= e(trans($item->description)) ?></span>
            </div>
            <?= $this->makePartial('component_list', ['components'=>$item->items]) ?>
        </li>
    <?php endforeach ?>
    </ul>
<?php else: ?>
    <p class="no-data"><?= e(trans('cms::lang.component.no_records')) ?></p>
<?php endif ?>