<div class="fileupload-config-form">
    <?= Form::open(['data-request-parent' => "#{$parentElementId}"]) ?>
        <input type="hidden" name="file_id" value="<?= $file->id ?>" />

        <?php if (starts_with($displayMode, 'image')): ?>
            <div class="file-upload-modal-image-header">
                <button type="button" class="close" data-dismiss="popup">&times;</button>
                <img
                    src="<?= $file->thumbUrl ?>"
                    class="img-responsive center-block"
                    alt=""
                    title="<?= e(trans('backend::lang.fileupload.attachment')) ?>: <?= e($file->file_name) ?>"
                    style="<?= $cssDimensions ?>" />
            </div>
        <?php else: ?>
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="popup">&times;</button>
                <h4 class="modal-title"><?= e(trans('backend::lang.fileupload.attachment')) ?>: <?= $file->file_name ?></h4>
            </div>
        <?php endif ?>
        <div class="modal-body">
            <p><?= e(trans('backend::lang.fileupload.help')) ?></p>

            <?= $this->getConfigFormWidget()->render(); ?>
        </div>
        <div class="modal-footer">
            <a href="<?= $file->pathUrl ?>" class="pull-left btn btn-link fileupload-url-button" target="_blank">
                <i class="wn-icon-link"></i><?= e(trans('backend::lang.fileupload.attachment_url')) ?>
            </a>
            <button
                type="submit"
                class="btn btn-primary"
                data-request="<?= $this->getEventHandler('onSaveAttachmentConfig') ?>"
                data-popup-load-indicator>
                <?= e(trans('backend::lang.form.save')) ?>
            </button>
            <button
                type="button"
                class="btn btn-default"
                data-dismiss="popup">
                <?= e(trans('backend::lang.form.cancel')) ?>
            </button>
        </div>
    <?= Form::close() ?>
</div>
