<?php
/*
 * login_with_yammer.php
 *
 * @(#) $Id: login_with_yammer.php,v 1.1 2017/02/07 09:09:58 mlemos Exp $
 *
 */

/*
 *  Get the http.php file from http://www.phpclasses.org/httpclient
 */
require('http.php');
require('oauth_client.php');

$client = new oauth_client_class();
$client->debug = true;
$client->debug_http = true;
$client->server = 'Yammer';
$client->redirect_uri = 'https://'.$_SERVER['HTTP_HOST'].
    dirname(strtok($_SERVER['REQUEST_URI'], '?')).'/login_with_yammer.php';

$client->client_id = '';
$application_line = __LINE__;
$client->client_secret = '';

if (strlen($client->client_id) == 0
|| strlen($client->client_secret) == 0) {
    die('Please go to Yammer applications page '.
        'https://www.yammer.com/client_applications (you need to already have '.
        'logged in your Yammer account)in the Register New App form. '.
        'Then in the line '.$application_line.
        ' set the client_id to Client ID and client_secret with Client Secret. '.
        'The Callback URL must be '.$client->redirect_uri);
}

/* API permissions
 */
$client->scope = '';
if (($success = $client->Initialize())) {
    if (($success = $client->Process())) {
        if (strlen($client->authorization_error)) {
            $client->error = $client->authorization_error;
            $success = false;
        } elseif (strlen($client->access_token)) {
            $success = $client->CallAPI(
                'https://www.yammer.com/api/v1/users.json',
                'GET',
                array(),
                array('FailOnAccessError'=>true),
                $user
            );
        }
    }
    $success = $client->Finalize($success);
}
if ($client->exit) {
    exit;
}
if ($success) {
    ?>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">
<html>
<head>
<title>Yammer OAuth client results</title>
</head>
<body>
<?php
            echo '<h1>', HtmlSpecialChars($user[0]->first_name),
    ' you have logged in successfully with Yammer!</h1>';
    echo '<pre>', HtmlSpecialChars(print_r($user, 1)), '</pre>';
    ?>
</body>
</html>
<?php
} else {
    ?>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">
<html>
<head>
<title>OAuth client error</title>
</head>
<body>
<h1>OAuth client error</h1>
<pre>Error: <?php echo HtmlSpecialChars($client->error); ?></pre>
</body>
</html>
<?php
}

?>