<?php
/**
 * This code is licensed under AGPLv3 license or Afterlogic Software License
 * if commercial version of the product was purchased.
 * For full statements of the licenses see LICENSE-AFTERLOGIC and LICENSE-AGPL3 files.
 */

namespace MailSo\Imap;

/**
 * @license https://www.gnu.org/licenses/agpl-3.0.html AGPL-3.0
 * @license https://afterlogic.com/products/common-licensing Afterlogic Software License
 * @copyright Copyright (c) 2019, Afterlogic Corp.
 *
 * @category MailSo
 * @package Imap
 */
class Response
{
    /**
     * @var array
     */
    public $ResponseList;

    /**
     * @var array | null
     */
    public $OptionalResponse;

    /**
     * @var string
     */
    public $StatusOrIndex;

    /**
     * @var string
     */
    public $HumanReadable;

    /**
     * @var bool
     */
    public $IsStatusResponse;

    /**
     * @var string
     */
    public $ResponseType;

    /**
     * @var string
     */
    public $Tag;

    /**
     * @access private
     */
    private function __construct()
    {
        $this->ResponseList = array();
        $this->OptionalResponse = null;
        $this->StatusOrIndex = '';
        $this->HumanReadable = '';
        $this->IsStatusResponse = false;
        $this->ResponseType = \MailSo\Imap\Enumerations\ResponseType::UNKNOWN;
        $this->Tag = '';
    }

    /**
     * @return \MailSo\Imap\Response
     */
    public static function NewInstance()
    {
        return new self();
    }

    /**
     * @param string $aList
     *
     * @return string
     */
    private function recToLine($aList)
    {
        $aResult = array();
        if (\is_array($aList)) {
            foreach ($aList as $mItem) {
                $aResult[] = \is_array($mItem) ? '('.$this->recToLine($mItem).')' : (string) $mItem;
            }
        }

        return \implode(' ', $aResult);
    }


    /**
     * @return string
     */
    public function ToLine()
    {
        return $this->recToLine($this->ResponseList);
    }
}
