
SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

--
-- Database: `webasyst384`
--

-- --------------------------------------------------------

--
-- Table structure for table `team_calendar_external`
--

CREATE TABLE `team_calendar_external` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` varchar(50) DEFAULT NULL,
  `integration_level` enum('subscription','sync','full') NOT NULL DEFAULT 'subscription',
  `name` varchar(255) NOT NULL,
  `contact_id` int(11) DEFAULT NULL,
  `create_datetime` datetime DEFAULT NULL,
  `calendar_id` int(11) DEFAULT NULL,
  `native_calendar_id` text,
  `synchronize_datetime` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `contact_id` (`contact_id`),
  KEY `calendar_id` (`calendar_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `team_calendar_external_params`
--

CREATE TABLE `team_calendar_external_params` (
  `calendar_external_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `value` text,
  PRIMARY KEY (`calendar_external_id`,`name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `team_event_external`
--

CREATE TABLE `team_event_external` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `event_id` int(11) NOT NULL,
  `calendar_external_id` int(11) NOT NULL,
  `native_event_id` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `event_id_calendar_external_id` (`event_id`,`calendar_external_id`),
  KEY `calendar_external_id_native_event_id` (`calendar_external_id`,`native_event_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `team_event_external_params`
--

CREATE TABLE `team_event_external_params` (
  `event_external_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `value` text,
  PRIMARY KEY (`event_external_id`,`name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `team_location`
--

CREATE TABLE `team_location` (
  `group_id` int(11) NOT NULL,
  `address` varchar(255) DEFAULT NULL,
  `longitude` varchar(50) DEFAULT NULL,
  `latitude` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`group_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `wa_agreement_document`
--

CREATE TABLE `wa_agreement_document` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `app_id` varchar(64) NOT NULL,
  `context` varchar(64) NOT NULL,
  `domain` varchar(64) NOT NULL,
  `locale` varchar(8) NOT NULL,
  `document_name` varchar(64) NOT NULL,
  `document_text` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `app_id_context_domain_document_locale` (`app_id`,`context`,`domain`,`document_name`,`locale`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `wa_agreement_log`
--

CREATE TABLE `wa_agreement_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `create_datetime` datetime NOT NULL,
  `app_id` varchar(64) NOT NULL,
  `contact_id` int(11) DEFAULT NULL,
  `ip` varchar(39) DEFAULT NULL,
  `user_agent` varchar(255) DEFAULT NULL,
  `context` varchar(64) NOT NULL,
  `document_name` varchar(64) NOT NULL,
  `document_id` int(11) DEFAULT NULL,
  `accept_method` varchar(64) DEFAULT NULL,
  `domain` varchar(64) NOT NULL,
  `form_url` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `contact_id` (`contact_id`),
  KEY `app_id_context` (`app_id`,`context`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `wa_announcement`
--

CREATE TABLE `wa_announcement` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `app_id` varchar(32) NOT NULL,
  `type` varchar(32) DEFAULT NULL,
  `contact_id` int(11) DEFAULT NULL,
  `text` text NOT NULL,
  `data` text,
  `datetime` datetime NOT NULL,
  `ttl_datetime` datetime DEFAULT NULL,
  `is_pinned` tinyint(4) NOT NULL DEFAULT '0',
  `access` enum('all','limited') NOT NULL DEFAULT 'all',
  PRIMARY KEY (`id`),
  KEY `app_datetime` (`datetime`,`app_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `wa_announcement_comments`
--

CREATE TABLE `wa_announcement_comments` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `announcement_id` int(11) NOT NULL,
  `create_datetime` datetime NOT NULL,
  `update_datetime` datetime DEFAULT NULL,
  `contact_id` int(11) NOT NULL,
  `text` text,
  PRIMARY KEY (`id`),
  KEY `announcement_datetime` (`announcement_id`,`create_datetime`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `wa_announcement_reactions`
--

CREATE TABLE `wa_announcement_reactions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `announcement_id` int(11) NOT NULL,
  `create_datetime` datetime NOT NULL,
  `contact_id` int(11) NOT NULL,
  `reaction` varchar(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `announcement_reaction_contact` (`announcement_id`,`reaction`,`contact_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `wa_announcement_rights`
--

CREATE TABLE `wa_announcement_rights` (
  `group_id` int(11) NOT NULL,
  `announcement_id` int(11) NOT NULL,
  UNIQUE KEY `group_announcement` (`group_id`,`announcement_id`),
  KEY `announcement_id` (`announcement_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `wa_api_auth_codes`
--

CREATE TABLE `wa_api_auth_codes` (
  `code` varchar(32) NOT NULL,
  `contact_id` int(11) NOT NULL,
  `client_id` varchar(32) NOT NULL,
  `scope` text NOT NULL,
  `expires` datetime NOT NULL,
  PRIMARY KEY (`code`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `wa_api_tokens`
--

CREATE TABLE `wa_api_tokens` (
  `contact_id` int(11) NOT NULL,
  `client_id` varchar(32) NOT NULL,
  `token` varchar(32) NOT NULL,
  `scope` text NOT NULL,
  `create_datetime` datetime NOT NULL,
  `last_use_datetime` datetime DEFAULT NULL,
  `expires` datetime DEFAULT NULL,
  PRIMARY KEY (`token`),
  UNIQUE KEY `contact_client` (`contact_id`,`client_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `wa_app_settings`
--

CREATE TABLE `wa_app_settings` (
  `app_id` varchar(64) NOT NULL,
  `name` varchar(64) NOT NULL,
  `value` mediumtext NOT NULL,
  PRIMARY KEY (`app_id`,`name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `wa_app_settings`
--

INSERT INTO `wa_app_settings` VALUES
('webasyst', 'update_time', '1757424981'),
('webasyst', 'locale', 'en_US'),
('webasyst', 'name', '[[site_name]]'),
('webasyst', 'email', '[[admin_email]]'),
('webasyst', 'sender', '[[admin_email]]'),
('team', 'update_time', '1711701444'),
('installer', 'update_time', '1614683137');

-- --------------------------------------------------------

--
-- Table structure for table `wa_app_tokens`
--

CREATE TABLE `wa_app_tokens` (
  `contact_id` int(11) DEFAULT NULL,
  `app_id` varchar(32) NOT NULL,
  `type` varchar(32) NOT NULL,
  `create_datetime` datetime NOT NULL,
  `expire_datetime` datetime DEFAULT NULL,
  `token` varchar(32) NOT NULL,
  `data` text,
  UNIQUE KEY `token` (`token`),
  KEY `app` (`app_id`),
  KEY `contact` (`contact_id`),
  KEY `expire` (`expire_datetime`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `wa_cache`
--

CREATE TABLE `wa_cache` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `expires` datetime NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`),
  KEY `expires` (`expires`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `wa_contact`
--

CREATE TABLE `wa_contact` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(150) NOT NULL,
  `firstname` varchar(50) NOT NULL DEFAULT '',
  `middlename` varchar(50) NOT NULL DEFAULT '',
  `lastname` varchar(50) NOT NULL DEFAULT '',
  `title` varchar(50) NOT NULL DEFAULT '',
  `company` varchar(150) NOT NULL DEFAULT '',
  `jobtitle` varchar(50) NOT NULL DEFAULT '',
  `company_contact_id` int(11) NOT NULL DEFAULT '0',
  `is_company` tinyint(1) NOT NULL DEFAULT '0',
  `is_user` tinyint(1) NOT NULL DEFAULT '0',
  `is_staff` int(11) NOT NULL DEFAULT '0',
  `login` varchar(32) DEFAULT NULL,
  `password` varchar(128) NOT NULL DEFAULT '',
  `last_datetime` datetime DEFAULT NULL,
  `sex` enum('m','f') DEFAULT NULL,
  `birth_day` tinyint(2) unsigned DEFAULT NULL,
  `birth_month` tinyint(2) unsigned DEFAULT NULL,
  `birth_year` smallint(4) DEFAULT NULL,
  `about` text,
  `photo` int(10) unsigned NOT NULL DEFAULT '0',
  `create_datetime` datetime NOT NULL,
  `create_app_id` varchar(32) NOT NULL DEFAULT '',
  `create_method` varchar(32) NOT NULL DEFAULT '',
  `create_contact_id` int(11) NOT NULL DEFAULT '0',
  `locale` varchar(8) NOT NULL DEFAULT '',
  `timezone` varchar(64) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `login` (`login`),
  KEY `name` (`name`),
  KEY `is_user` (`is_user`),
  KEY `is_staff` (`is_staff`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `wa_contact`
--

INSERT INTO `wa_contact` VALUES
(1, '[[admin_lname]] [[admin_fname]]', '[[admin_fname]]', '', '[[admin_lname]]', '', '', '', 0, 0, 1, 0, '[[admin_username]]', '[[admin_pass]]', '[[regtime]]', NULL, NULL, NULL, NULL, NULL, 0, '[[regtime]]', 'webasyst', 'install', 0, 'en_US', '');

-- --------------------------------------------------------

--
-- Table structure for table `wa_contact_auths`
--

CREATE TABLE `wa_contact_auths` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `contact_id` int(11) NOT NULL,
  `session_id` varchar(255) NOT NULL,
  `token` varchar(42) NOT NULL,
  `login_datetime` datetime DEFAULT NULL,
  `last_datetime` datetime DEFAULT NULL,
  `user_agent` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `session_id` (`session_id`),
  UNIQUE KEY `contact_session_id` (`contact_id`,`session_id`),
  KEY `contact_id` (`contact_id`),
  KEY `token` (`token`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Dumping data for table `wa_contact_auths`
--


-- --------------------------------------------------------

--
-- Table structure for table `wa_contact_calendars`
--

CREATE TABLE `wa_contact_calendars` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `bg_color` varchar(7) DEFAULT NULL,
  `font_color` varchar(7) DEFAULT NULL,
  `status_bg_color` varchar(7) DEFAULT NULL,
  `status_font_color` varchar(7) DEFAULT NULL,
  `icon` varchar(255) DEFAULT NULL,
  `sort` int(11) NOT NULL DEFAULT '0',
  `is_limited` tinyint(1) NOT NULL DEFAULT '0',
  `default_status` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `sort` (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=7 ;

--
-- Dumping data for table `wa_contact_calendars`
--

INSERT INTO `wa_contact_calendars` VALUES
(1, 'Vacation', '#b8f2ff', '#00819e', '#00c2ed', '#ffffff', 'fas fa-circle', 0, 0, 'on vacation'),
(2, 'Business', '#d4dcfc', '#0a2eae', '#718ef7', '#ffffff', 'fas fa-circle', 1, 0, 'in a business trip'),
(3, 'Illness', '#fcc197', '#773404', '#f98836', '#ffffff', 'fas fa-circle', 2, 0, 'sick'),
(4, 'Meeting', '#ffeab8', '#9e6f00', '#eba400', '#ffffff', 'fas fa-circle', 3, 0, 'at the meeting'),
(5, 'Remote', '#e9ccff', '#6500b3', '#bb64ff', '#ffffff', 'fas fa-circle', 4, 0, NULL),
(6, 'Other', '#cccccc', '#404040', '#999999', '#ffffff', 'fas fa-circle', 5, 0, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `wa_contact_categories`
--

CREATE TABLE `wa_contact_categories` (
  `category_id` int(11) NOT NULL,
  `contact_id` int(11) NOT NULL,
  PRIMARY KEY (`category_id`,`contact_id`),
  KEY `contact_id` (`contact_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `wa_contact_category`
--

CREATE TABLE `wa_contact_category` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `system_id` varchar(64) DEFAULT NULL,
  `app_id` varchar(32) DEFAULT NULL,
  `icon` varchar(255) DEFAULT NULL,
  `cnt` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `system_id` (`system_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `wa_contact_data`
--

CREATE TABLE `wa_contact_data` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `contact_id` int(11) NOT NULL,
  `field` varchar(32) NOT NULL,
  `ext` varchar(32) NOT NULL DEFAULT '',
  `value` varchar(255) NOT NULL,
  `sort` int(11) NOT NULL DEFAULT '0',
  `status` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `contact_field_sort` (`contact_id`,`field`,`sort`),
  KEY `contact_id` (`contact_id`),
  KEY `value` (`value`),
  KEY `field` (`field`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `wa_contact_data_text`
--

CREATE TABLE `wa_contact_data_text` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `contact_id` int(11) NOT NULL,
  `field` varchar(32) NOT NULL,
  `ext` varchar(32) NOT NULL DEFAULT '',
  `value` text NOT NULL,
  `sort` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `contact_field_sort` (`contact_id`,`field`,`sort`),
  KEY `contact_id` (`contact_id`),
  KEY `field` (`field`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `wa_contact_emails`
--

CREATE TABLE `wa_contact_emails` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `contact_id` int(11) NOT NULL,
  `email` varchar(255) NOT NULL,
  `ext` varchar(32) NOT NULL DEFAULT '',
  `sort` int(11) NOT NULL DEFAULT '0',
  `status` enum('unknown','confirmed','unconfirmed','unavailable') NOT NULL DEFAULT 'unknown',
  PRIMARY KEY (`id`),
  UNIQUE KEY `contact_sort` (`contact_id`,`sort`),
  KEY `email` (`email`),
  KEY `status` (`status`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `wa_contact_emails`
--

INSERT INTO `wa_contact_emails` VALUES
(1, 1, '[[admin_email]]', '', 0, 'unknown');

-- --------------------------------------------------------

--
-- Table structure for table `wa_contact_events`
--

CREATE TABLE `wa_contact_events` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uid` varchar(255) DEFAULT NULL,
  `create_datetime` datetime NOT NULL,
  `update_datetime` datetime NOT NULL,
  `contact_id` int(11) NOT NULL,
  `calendar_id` int(11) NOT NULL,
  `summary` varchar(255) NOT NULL,
  `description` text,
  `location` varchar(255) DEFAULT NULL,
  `start` datetime NOT NULL,
  `end` datetime NOT NULL,
  `is_allday` tinyint(4) NOT NULL DEFAULT '0',
  `is_status` tinyint(4) NOT NULL DEFAULT '0',
  `sequence` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `uid` (`uid`),
  KEY `contact_id` (`contact_id`),
  KEY `calendar_id` (`calendar_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `wa_contact_field_values`
--

CREATE TABLE `wa_contact_field_values` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `parent_field` varchar(64) NOT NULL,
  `parent_value` varchar(255) NOT NULL,
  `field` varchar(64) NOT NULL,
  `value` varchar(255) NOT NULL,
  `sort` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `parent_field` (`parent_field`,`parent_value`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `wa_contact_files`
--

CREATE TABLE `wa_contact_files` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `contact_id` int(11) NOT NULL,
  `purpose` enum('cover','general') NOT NULL DEFAULT 'general',
  `name` varchar(255) DEFAULT NULL,
  `sort` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `contact_id` (`contact_id`),
  KEY `purpose` (`purpose`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `wa_contact_rights`
--

CREATE TABLE `wa_contact_rights` (
  `group_id` int(11) NOT NULL,
  `app_id` varchar(32) NOT NULL,
  `name` varchar(64) NOT NULL,
  `value` int(11) NOT NULL,
  PRIMARY KEY (`group_id`,`app_id`,`name`),
  KEY `name_value` (`name`,`value`,`group_id`,`app_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `wa_contact_rights`
--

INSERT INTO `wa_contact_rights` VALUES
(-1, 'webasyst', 'backend', 1),
(2, 'team', 'backend', 1),
(3, 'team', 'backend', 1),
(1, 'webasyst', 'backend', 2);

-- --------------------------------------------------------

--
-- Table structure for table `wa_contact_settings`
--

CREATE TABLE `wa_contact_settings` (
  `contact_id` int(11) NOT NULL,
  `app_id` varchar(32) NOT NULL DEFAULT '',
  `name` varchar(64) NOT NULL,
  `value` text NOT NULL,
  PRIMARY KEY (`contact_id`,`app_id`,`name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `wa_contact_settings`
--

INSERT INTO `wa_contact_settings` VALUES
(1, 'webasyst', 'wa_announcement_seen', '[[regtime]]'),
(1, 'webasyst', 'dashboard', '1'),
(1, 'webasyst', 'idle_since', '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `wa_contact_waid`
--

CREATE TABLE `wa_contact_waid` (
  `contact_id` int(11) NOT NULL,
  `token` text NOT NULL,
  `webasyst_contact_id` int(11) NOT NULL,
  `create_datetime` datetime NOT NULL,
  `login_datetime` datetime DEFAULT NULL,
  PRIMARY KEY (`contact_id`),
  UNIQUE KEY `webasyst_contact_id` (`webasyst_contact_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `wa_country`
--

CREATE TABLE `wa_country` (
  `name` varchar(255) NOT NULL,
  `iso3letter` varchar(3) NOT NULL,
  `iso2letter` varchar(2) NOT NULL,
  `isonumeric` varchar(3) NOT NULL,
  `fav_sort` int(11) DEFAULT NULL,
  PRIMARY KEY (`iso3letter`),
  UNIQUE KEY `isonumeric` (`isonumeric`),
  UNIQUE KEY `iso2letter` (`iso2letter`),
  KEY `name` (`name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `wa_country`
--

INSERT INTO `wa_country` VALUES
('Afghanistan', 'afg', 'af', '004', NULL),
('Åland Islands', 'ala', 'ax', '248', NULL),
('Albania', 'alb', 'al', '008', NULL),
('Algeria', 'dza', 'dz', '012', NULL),
('American Samoa', 'asm', 'as', '016', NULL),
('Andorra', 'and', 'ad', '020', NULL),
('Angola', 'ago', 'ao', '024', NULL),
('Anguilla', 'aia', 'ai', '660', NULL),
('Antigua and Barbuda', 'atg', 'ag', '028', NULL),
('Argentina', 'arg', 'ar', '032', NULL),
('Armenia', 'arm', 'am', '051', NULL),
('Aruba', 'abw', 'aw', '533', NULL),
('Australia', 'aus', 'au', '036', NULL),
('Austria', 'aut', 'at', '040', NULL),
('Azerbaijan', 'aze', 'az', '031', NULL),
('Bahamas', 'bhs', 'bs', '044', NULL),
('Bahrain', 'bhr', 'bh', '048', NULL),
('Bangladesh', 'bgd', 'bd', '050', NULL),
('Barbados', 'brb', 'bb', '052', NULL),
('Belarus', 'blr', 'by', '112', NULL),
('Belgium', 'bel', 'be', '056', NULL),
('Belize', 'blz', 'bz', '084', NULL),
('Benin', 'ben', 'bj', '204', NULL),
('Bermuda', 'bmu', 'bm', '060', NULL),
('Bhutan', 'btn', 'bt', '064', NULL),
('Bolivia, Plurinational State of', 'bol', 'bo', '068', NULL),
('Bosnia and Herzegovina', 'bih', 'ba', '070', NULL),
('Botswana', 'bwa', 'bw', '072', NULL),
('Bouvet Island', 'bvt', 'bv', '074', NULL),
('Brazil', 'bra', 'br', '076', NULL),
('British Indian Ocean Territory', 'iot', 'io', '086', NULL),
('Brunei Darussalam', 'brn', 'bn', '096', NULL),
('Bulgaria', 'bgr', 'bg', '100', NULL),
('Burkina Faso', 'bfa', 'bf', '854', NULL),
('Burundi', 'bdi', 'bi', '108', NULL),
('Côte d''Ivoire', 'civ', 'ci', '384', NULL),
('Cambodia', 'khm', 'kh', '116', NULL),
('Cameroon', 'cmr', 'cm', '120', NULL),
('Canada', 'can', 'ca', '124', NULL),
('Cape Verde', 'cpv', 'cv', '132', NULL),
('Cayman Islands', 'cym', 'ky', '136', NULL),
('Central African Republic', 'caf', 'cf', '140', NULL),
('Chad', 'tcd', 'td', '148', NULL),
('Chile', 'chl', 'cl', '152', NULL),
('China', 'chn', 'cn', '156', NULL),
('Christmas Island', 'cxr', 'cx', '162', NULL),
('Cocos (Keeling) Islands', 'cck', 'cc', '166', NULL),
('Colombia', 'col', 'co', '170', NULL),
('Comoros', 'com', 'km', '174', NULL),
('Congo', 'cog', 'cg', '178', NULL),
('Congo, the Democratic Republic of the', 'cod', 'cd', '180', NULL),
('Cook Islands', 'cok', 'ck', '184', NULL),
('Costa Rica', 'cri', 'cr', '188', NULL),
('Croatia', 'hrv', 'hr', '191', NULL),
('Cuba', 'cub', 'cu', '192', NULL),
('Cyprus', 'cyp', 'cy', '196', NULL),
('Czech Republic', 'cze', 'cz', '203', NULL),
('Denmark', 'dnk', 'dk', '208', NULL),
('Djibouti', 'dji', 'dj', '262', NULL),
('Dominica', 'dma', 'dm', '212', NULL),
('Dominican Republic', 'dom', 'do', '214', NULL),
('Ecuador', 'ecu', 'ec', '218', NULL),
('Egypt', 'egy', 'eg', '818', NULL),
('El Salvador', 'slv', 'sv', '222', NULL),
('Equatorial Guinea', 'gnq', 'gq', '226', NULL),
('Eritrea', 'eri', 'er', '232', NULL),
('Estonia', 'est', 'ee', '233', NULL),
('Ethiopia', 'eth', 'et', '231', NULL),
('Falkland Islands (Malvinas)', 'flk', 'fk', '238', NULL),
('Faroe Islands', 'fro', 'fo', '234', NULL),
('Fiji', 'fji', 'fj', '242', NULL),
('Finland', 'fin', 'fi', '246', NULL),
('France', 'fra', 'fr', '250', NULL),
('French Guiana', 'guf', 'gf', '254', NULL),
('French Polynesia', 'pyf', 'pf', '258', NULL),
('French Southern Territories', 'atf', 'tf', '260', NULL),
('Gabon', 'gab', 'ga', '266', NULL),
('Gambia', 'gmb', 'gm', '270', NULL),
('Georgia', 'geo', 'ge', '268', NULL),
('Germany', 'deu', 'de', '276', NULL),
('Ghana', 'gha', 'gh', '288', NULL),
('Gibraltar', 'gib', 'gi', '292', NULL),
('Greece', 'grc', 'gr', '300', NULL),
('Greenland', 'grl', 'gl', '304', NULL),
('Grenada', 'grd', 'gd', '308', NULL),
('Guadeloupe', 'glp', 'gp', '312', NULL),
('Guam', 'gum', 'gu', '316', NULL),
('Guatemala', 'gtm', 'gt', '320', NULL),
('Guinea', 'gin', 'gn', '324', NULL),
('Guinea-Bissau', 'gnb', 'gw', '624', NULL),
('Guyana', 'guy', 'gy', '328', NULL),
('Haiti', 'hti', 'ht', '332', NULL),
('Heard Island and McDonald Islands', 'hmd', 'hm', '334', NULL),
('Holy See (Vatican City State)', 'vat', 'va', '336', NULL),
('Honduras', 'hnd', 'hn', '340', NULL),
('Hong Kong', 'hkg', 'hk', '344', NULL),
('Hungary', 'hun', 'hu', '348', NULL),
('Iceland', 'isl', 'is', '352', NULL),
('India', 'ind', 'in', '356', NULL),
('Indonesia', 'idn', 'id', '360', NULL),
('Iran, Islamic Republic of', 'irn', 'ir', '364', NULL),
('Iraq', 'irq', 'iq', '368', NULL),
('Ireland', 'irl', 'ie', '372', NULL),
('Israel', 'isr', 'il', '376', NULL),
('Italy', 'ita', 'it', '380', NULL),
('Jamaica', 'jam', 'jm', '388', NULL),
('Japan', 'jpn', 'jp', '392', NULL),
('Jordan', 'jor', 'jo', '400', NULL),
('Kazakhstan', 'kaz', 'kz', '398', NULL),
('Kenya', 'ken', 'ke', '404', NULL),
('Kiribati', 'kir', 'ki', '296', NULL),
('Korea, Democratic People''s Republic of', 'prk', 'kp', '408', NULL),
('Korea, Republic of', 'kor', 'kr', '410', NULL),
('Kuwait', 'kwt', 'kw', '414', NULL),
('Kyrgyzstan', 'kgz', 'kg', '417', NULL),
('Lao People''s Democratic Republic', 'lao', 'la', '418', NULL),
('Latvia', 'lva', 'lv', '428', NULL),
('Lebanon', 'lbn', 'lb', '422', NULL),
('Lesotho', 'lso', 'ls', '426', NULL),
('Liberia', 'lbr', 'lr', '430', NULL),
('Libyan Arab Jamahiriya', 'lby', 'ly', '434', NULL),
('Liechtenstein', 'lie', 'li', '438', NULL),
('Lithuania', 'ltu', 'lt', '440', NULL),
('Luxembourg', 'lux', 'lu', '442', NULL),
('Macao', 'mac', 'mo', '446', NULL),
('Macedonia, the former Yugoslav Republic of', 'mkd', 'mk', '807', NULL),
('Madagascar', 'mdg', 'mg', '450', NULL),
('Malawi', 'mwi', 'mw', '454', NULL),
('Malaysia', 'mys', 'my', '458', NULL),
('Maldives', 'mdv', 'mv', '462', NULL),
('Mali', 'mli', 'ml', '466', NULL),
('Malta', 'mlt', 'mt', '470', NULL),
('Marshall Islands', 'mhl', 'mh', '584', NULL),
('Martinique', 'mtq', 'mq', '474', NULL),
('Mauritania', 'mrt', 'mr', '478', NULL),
('Mauritius', 'mus', 'mu', '480', NULL),
('Mayotte', 'myt', 'yt', '175', NULL),
('Mexico', 'mex', 'mx', '484', NULL),
('Micronesia, Federated States of', 'fsm', 'fm', '583', NULL),
('Moldova, Republic of', 'mda', 'md', '498', NULL),
('Monaco', 'mco', 'mc', '492', NULL),
('Mongolia', 'mng', 'mn', '496', NULL),
('Montenegro', 'mne', 'me', '499', NULL),
('Montserrat', 'msr', 'ms', '500', NULL),
('Morocco', 'mar', 'ma', '504', NULL),
('Mozambique', 'moz', 'mz', '508', NULL),
('Myanmar', 'mmr', 'mm', '104', NULL),
('Namibia', 'nam', 'na', '516', NULL),
('Nauru', 'nru', 'nr', '520', NULL),
('Nepal', 'npl', 'np', '524', NULL),
('Netherlands', 'nld', 'nl', '528', NULL),
('Netherlands Antilles', 'ant', 'an', '530', NULL),
('New Caledonia', 'ncl', 'nc', '540', NULL),
('New Zealand', 'nzl', 'nz', '554', NULL),
('Nicaragua', 'nic', 'ni', '558', NULL),
('Niger', 'ner', 'ne', '562', NULL),
('Nigeria', 'nga', 'ng', '566', NULL),
('Niue', 'niu', 'nu', '570', NULL),
('Norfolk Island', 'nfk', 'nf', '574', NULL),
('Northern Mariana Islands', 'mnp', 'mp', '580', NULL),
('Norway', 'nor', 'no', '578', NULL),
('Oman', 'omn', 'om', '512', NULL),
('Pakistan', 'pak', 'pk', '586', NULL),
('Palau', 'plw', 'pw', '585', NULL),
('Palestinian Territory, Occupied', 'pse', 'ps', '275', NULL),
('Panama', 'pan', 'pa', '591', NULL),
('Papua New Guinea', 'png', 'pg', '598', NULL),
('Paraguay', 'pry', 'py', '600', NULL),
('Peru', 'per', 'pe', '604', NULL),
('Philippines', 'phl', 'ph', '608', NULL),
('Pitcairn', 'pcn', 'pn', '612', NULL),
('Poland', 'pol', 'pl', '616', NULL),
('Portugal', 'prt', 'pt', '620', NULL),
('Puerto Rico', 'pri', 'pr', '630', NULL),
('Qatar', 'qat', 'qa', '634', NULL),
('Réunion', 'reu', 're', '638', NULL),
('Romania', 'rou', 'ro', '642', NULL),
('Russian Federation', 'rus', 'ru', '643', 1),
('Rwanda', 'rwa', 'rw', '646', NULL),
('Saint Helena, Ascension and Tristan da Cunha', 'shn', 'sh', '654', NULL),
('Saint Kitts and Nevis', 'kna', 'kn', '659', NULL),
('Saint Lucia', 'lca', 'lc', '662', NULL),
('Saint Pierre and Miquelon', 'spm', 'pm', '666', NULL),
('Saint Vincent and the Grenadines', 'vct', 'vc', '670', NULL),
('Samoa', 'wsm', 'ws', '882', NULL),
('San Marino', 'smr', 'sm', '674', NULL),
('Sao Tome and Principe', 'stp', 'st', '678', NULL),
('Saudi Arabia', 'sau', 'sa', '682', NULL),
('Senegal', 'sen', 'sn', '686', NULL),
('Serbia', 'srb', 'rs', '688', NULL),
('Seychelles', 'syc', 'sc', '690', NULL),
('Sierra Leone', 'sle', 'sl', '694', NULL),
('Singapore', 'sgp', 'sg', '702', NULL),
('Slovakia', 'svk', 'sk', '703', NULL),
('Slovenia', 'svn', 'si', '705', NULL),
('Solomon Islands', 'slb', 'sb', '090', NULL),
('Somalia', 'som', 'so', '706', NULL),
('South Africa', 'zaf', 'za', '710', NULL),
('South Georgia and the South Sandwich Islands', 'sgs', 'gs', '239', NULL),
('Spain', 'esp', 'es', '724', NULL),
('Sri Lanka', 'lka', 'lk', '144', NULL),
('Sudan', 'sdn', 'sd', '736', NULL),
('Suriname', 'sur', 'sr', '740', NULL),
('Svalbard and Jan Mayen', 'sjm', 'sj', '744', NULL),
('Swaziland', 'swz', 'sz', '748', NULL),
('Sweden', 'swe', 'se', '752', NULL),
('Switzerland', 'che', 'ch', '756', NULL),
('Syrian Arab Republic', 'syr', 'sy', '760', NULL),
('Taiwan, Province of China', 'twn', 'tw', '158', NULL),
('Tajikistan', 'tjk', 'tj', '762', NULL),
('Tanzania, United Republic of', 'tza', 'tz', '834', NULL),
('Thailand', 'tha', 'th', '764', NULL),
('Timor-Leste', 'tls', 'tl', '626', NULL),
('Togo', 'tgo', 'tg', '768', NULL),
('Tokelau', 'tkl', 'tk', '772', NULL),
('Tonga', 'ton', 'to', '776', NULL),
('Trinidad and Tobago', 'tto', 'tt', '780', NULL),
('Tunisia', 'tun', 'tn', '788', NULL),
('Turkey', 'tur', 'tr', '792', NULL),
('Turkmenistan', 'tkm', 'tm', '795', NULL),
('Turks and Caicos Islands', 'tca', 'tc', '796', NULL),
('Tuvalu', 'tuv', 'tv', '798', NULL),
('Uganda', 'uga', 'ug', '800', NULL),
('Ukraine', 'ukr', 'ua', '804', 1),
('United Arab Emirates', 'are', 'ae', '784', NULL),
('United Kingdom', 'gbr', 'gb', '826', NULL),
('United States', 'usa', 'us', '840', NULL),
('United States Minor Outlying Islands', 'umi', 'um', '581', NULL),
('Uruguay', 'ury', 'uy', '858', NULL),
('Uzbekistan', 'uzb', 'uz', '860', NULL),
('Vanuatu', 'vut', 'vu', '548', NULL),
('Venezuela, Bolivarian Republic of', 'ven', 've', '862', NULL),
('Viet Nam', 'vnm', 'vn', '704', NULL),
('Virgin Islands, British', 'vgb', 'vg', '092', NULL),
('Virgin Islands, U.S.', 'vir', 'vi', '850', NULL),
('Wallis and Futuna', 'wlf', 'wf', '876', NULL),
('Western Sahara', 'esh', 'eh', '732', NULL),
('Yemen', 'yem', 'ye', '887', NULL),
('Zambia', 'zmb', 'zm', '894', NULL),
('Zimbabwe', 'zwe', 'zw', '716', NULL),
('Abkhazia', 'abh', 'ab', '895', NULL),
('Bonaire, Sint Eustatius and Saba', 'bes', 'bq', '535', NULL),
('Guernsey', 'ggy', 'gg', '831', NULL),
('Jersey', 'jey', 'je', '832', NULL),
('Curaçao', 'cuw', 'cw', '531', NULL),
('Isle of Man', 'imn', 'im', '833', NULL),
('Saint Barthélemy', 'blm', 'bl', '652', NULL),
('Saint Martin (French Part)', 'maf', 'mf', '663', NULL),
('Sint Maarten', 'sxm', 'sx', '534', NULL),
('South Ossetia', 'ost', 'os', '896', NULL),
('South Sudan', 'ssd', 'ss', '728', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `wa_dashboard`
--

CREATE TABLE `wa_dashboard` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `hash` varchar(32) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `hash` (`hash`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `wa_group`
--

CREATE TABLE `wa_group` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `cnt` int(11) NOT NULL DEFAULT '0',
  `icon` varchar(255) DEFAULT NULL,
  `sort` int(11) DEFAULT NULL,
  `type` enum('group','location') NOT NULL DEFAULT 'group',
  `description` text,
  PRIMARY KEY (`id`),
  KEY `name` (`name`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=4 ;

--
-- Dumping data for table `wa_group`
--

INSERT INTO `wa_group` VALUES
(1, 'Administrators', 1, NULL, 0, 'group', NULL),
(2, 'My office', 1, NULL, 1, 'location', NULL),
(3, 'Remote', 0, NULL, 2, 'location', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `wa_log`
--

CREATE TABLE `wa_log` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `app_id` varchar(32) NOT NULL,
  `contact_id` int(11) NOT NULL,
  `datetime` datetime NOT NULL,
  `action` varchar(255) NOT NULL,
  `subject_contact_id` int(11) DEFAULT NULL,
  `params` text,
  PRIMARY KEY (`id`),
  KEY `contact` (`contact_id`,`id`),
  KEY `datetime` (`datetime`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `wa_login_log`
--

CREATE TABLE `wa_login_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `contact_id` int(11) NOT NULL,
  `datetime_in` datetime NOT NULL,
  `datetime_out` datetime DEFAULT NULL,
  `ip` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `contact_datetime` (`contact_id`,`datetime_out`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `wa_login_log`
--

INSERT INTO `wa_login_log` VALUES
(1, 1, '[[regtime]]', NULL, '[[clientip]]');

-- --------------------------------------------------------

--
-- Table structure for table `wa_push_subscribers`
--

CREATE TABLE `wa_push_subscribers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `provider_id` varchar(64) NOT NULL,
  `domain` varchar(255) NOT NULL,
  `create_datetime` datetime NOT NULL,
  `contact_id` int(11) DEFAULT NULL,
  `subscriber_data` text NOT NULL,
  `scope` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `provider_id` (`provider_id`),
  KEY `domain` (`domain`),
  KEY `contact_id` (`contact_id`),
  KEY `create_datetime` (`create_datetime`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `wa_region`
--

CREATE TABLE `wa_region` (
  `country_iso3` varchar(3) NOT NULL,
  `code` varchar(8) NOT NULL,
  `name` varchar(255) NOT NULL,
  `fav_sort` int(11) DEFAULT NULL,
  `region_center` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`country_iso3`,`code`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `wa_region`
--

INSERT INTO `wa_region` VALUES
('usa', 'AL', 'Alabama', NULL, 'Montgomery'),
('usa', 'AK', 'Alaska', NULL, 'Juneau'),
('usa', 'AZ', 'Arizona', NULL, 'Phoenix'),
('usa', 'AR', 'Arkansas', NULL, 'Little Rock'),
('usa', 'CA', 'California', NULL, 'Sacramento'),
('usa', 'CO', 'Colorado', NULL, 'Denver'),
('usa', 'CT', 'Connecticut', NULL, 'Hartford'),
('usa', 'DE', 'Delaware', NULL, 'Dover'),
('usa', 'DC', 'District of Columbia', NULL, 'Washington DC'),
('usa', 'FL', 'Florida', NULL, 'Tallahassee'),
('usa', 'GA', 'Georgia', NULL, 'Atlanta'),
('usa', 'HI', 'Hawaii', NULL, 'Honolulu'),
('usa', 'ID', 'Idaho', NULL, 'Boise'),
('usa', 'IL', 'Illinois', NULL, 'Springfield'),
('usa', 'IN', 'Indiana', NULL, 'Indianapolis'),
('usa', 'IA', 'Iowa', NULL, 'Des Moines'),
('usa', 'KS', 'Kansas', NULL, 'Topeka'),
('usa', 'KY', 'Kentucky', NULL, 'Frankfort'),
('usa', 'LA', 'Louisiana', NULL, 'Baton Rouge'),
('usa', 'ME', 'Maine', NULL, 'Augusta'),
('usa', 'MD', 'Maryland', NULL, 'Annapolis'),
('usa', 'MA', 'Massachusetts', NULL, 'Boston'),
('usa', 'MI', 'Michigan', NULL, 'Lansing'),
('usa', 'MN', 'Minnesota', NULL, 'Saint Paul'),
('usa', 'MS', 'Mississippi', NULL, 'Jackson'),
('usa', 'MO', 'Missouri', NULL, 'Jefferson City'),
('usa', 'MT', 'Montana', NULL, 'Helena'),
('usa', 'NE', 'Nebraska', NULL, 'Lincoln'),
('usa', 'NV', 'Nevada', NULL, 'Carson City'),
('usa', 'NH', 'New Hampshire', NULL, 'Concord'),
('usa', 'NJ', 'New Jersey', NULL, 'Trenton'),
('usa', 'NM', 'New Mexico', NULL, 'Santa Fe'),
('usa', 'NY', 'New York', NULL, 'Albany'),
('usa', 'NC', 'North Carolina', NULL, 'Rayleigh'),
('usa', 'ND', 'North Dakota', NULL, 'Bismarck'),
('usa', 'OH', 'Ohio', NULL, 'Columbus'),
('usa', 'OK', 'Oklahoma', NULL, 'Oklahoma City'),
('usa', 'OR', 'Oregon', NULL, 'Salem'),
('usa', 'PA', 'Pennsylvania', NULL, 'Harrisburg'),
('usa', 'RI', 'Rhode Island', NULL, 'Providence'),
('usa', 'SC', 'South Carolina', NULL, 'Columbia'),
('usa', 'SD', 'South Dakota', NULL, 'Pierre'),
('usa', 'TN', 'Tennessee', NULL, 'Nashville'),
('usa', 'TX', 'Texas', NULL, 'Austin'),
('usa', 'UT', 'Utah', NULL, 'Salt Lake City'),
('usa', 'VT', 'Vermont', NULL, 'Montpelier'),
('usa', 'VA', 'Virginia', NULL, 'Richmond'),
('usa', 'WA', 'Washington', NULL, 'Olympia'),
('usa', 'WV', 'West Virginia', NULL, 'Charleston'),
('usa', 'WI', 'Wisconsin', NULL, 'Madison'),
('usa', 'WY', 'Wyoming', NULL, 'Cheyenne'),
('can', '10', 'Newfoundland', NULL, NULL),
('can', '11', 'Prince Edward Island', NULL, NULL),
('can', '12', 'Nova Scotia', NULL, NULL),
('can', '13', 'New Brunswick', NULL, NULL),
('can', '24', 'Quebec', NULL, NULL),
('can', '35', 'Ontario', NULL, NULL),
('can', '46', 'Manitoba', NULL, NULL),
('can', '47', 'Saskatchewan', NULL, NULL),
('can', '48', 'Alberta', NULL, NULL),
('can', '59', 'British Columbia', NULL, NULL),
('can', '60', 'Yukon', NULL, NULL),
('can', '61', 'Northwest Territories', NULL, NULL),
('can', '62', 'Nunavut', NULL, NULL),
('rus', '01', 'Адыгея республика', NULL, NULL),
('rus', '04', 'Алтай республика', NULL, NULL),
('rus', '22', 'Алтайский край', NULL, NULL),
('rus', '28', 'Амурская область', NULL, NULL),
('rus', '29', 'Архангельская область', NULL, NULL),
('rus', '30', 'Астраханская область', NULL, NULL),
('rus', '02', 'Башкортостан республика', NULL, NULL),
('rus', '31', 'Белгородская область', NULL, NULL),
('rus', '32', 'Брянская область', NULL, NULL),
('rus', '03', 'Бурятия республика', NULL, NULL),
('rus', '33', 'Владимирская область', NULL, NULL),
('rus', '34', 'Волгоградская область', NULL, NULL),
('rus', '35', 'Вологодская область', NULL, NULL),
('rus', '36', 'Воронежская область', NULL, NULL),
('rus', '05', 'Дагестан республика', NULL, NULL),
('rus', '93', 'Донецкая Народная Республика', NULL, NULL),
('rus', '79', 'Еврейская автономная область', NULL, NULL),
('rus', '75', 'Забайкальский край', NULL, NULL),
('rus', '90', 'Запорожская область', NULL, NULL),
('rus', '37', 'Ивановская область', NULL, NULL),
('rus', '06', 'Ингушетия республика', NULL, NULL),
('rus', '38', 'Иркутская область', NULL, NULL),
('rus', '07', 'Кабардино-Балкарская республика', NULL, NULL),
('rus', '09', 'Карачаево-Черкесская республика', NULL, NULL),
('rus', '39', 'Калининградская область', NULL, NULL),
('rus', '08', 'Калмыкия республика', NULL, NULL),
('rus', '40', 'Калужская область', NULL, NULL),
('rus', '41', 'Камчатский край', NULL, NULL),
('rus', '10', 'Карелия республика', NULL, NULL),
('rus', '42', 'Кемеровская область', NULL, NULL),
('rus', '43', 'Кировская область', NULL, NULL),
('rus', '11', 'Коми республика', NULL, NULL),
('rus', '44', 'Костромская область', NULL, NULL),
('rus', '23', 'Краснодарский край', NULL, NULL),
('rus', '24', 'Красноярский край', NULL, NULL),
('rus', '91', 'Крым республика', NULL, NULL),
('rus', '45', 'Курганская область', NULL, NULL),
('rus', '46', 'Курская область', NULL, NULL),
('rus', '47', 'Ленинградская область', NULL, NULL),
('rus', '48', 'Липецкая область', NULL, NULL),
('rus', '94', 'Луганская Народная Республика', NULL, NULL),
('rus', '49', 'Магаданская область', NULL, NULL),
('rus', '12', 'Марий Эл республика', NULL, NULL),
('rus', '50', 'Московская область', NULL, NULL),
('rus', '77', 'Москва', NULL, 'Москва'),
('rus', '13', 'Мордовия республика', NULL, NULL),
('rus', '51', 'Мурманская область', NULL, NULL),
('rus', '83', 'Ненецкий автономный округ', NULL, NULL),
('rus', '52', 'Нижегородская область', NULL, NULL),
('rus', '53', 'Новгородская область', NULL, NULL),
('rus', '54', 'Новосибирская область', NULL, NULL),
('rus', '55', 'Омская область', NULL, NULL),
('rus', '56', 'Оренбургская область', NULL, NULL),
('rus', '57', 'Орловская область', NULL, NULL),
('rus', '58', 'Пензенская область', NULL, NULL),
('rus', '59', 'Пермский край', NULL, NULL),
('rus', '25', 'Приморский край', NULL, NULL),
('rus', '60', 'Псковская область', NULL, NULL),
('rus', '61', 'Ростовская область', NULL, NULL),
('rus', '62', 'Рязанская область', NULL, NULL),
('rus', '63', 'Самарская область', NULL, NULL),
('rus', '78', 'Санкт-Петербург', NULL, 'Санкт-Петербург'),
('rus', '64', 'Саратовская область', NULL, NULL),
('rus', '14', 'Саха (Якутия) республика', NULL, NULL),
('rus', '65', 'Сахалинская область', NULL, NULL),
('rus', '66', 'Свердловская область', NULL, NULL),
('rus', '92', 'Севастополь', NULL, 'Севастополь'),
('rus', '15', 'Северная Осетия-Алания', NULL, NULL),
('rus', '67', 'Смоленская область', NULL, NULL),
('rus', '26', 'Ставропольский край', NULL, NULL),
('rus', '68', 'Тамбовская область', NULL, NULL),
('rus', '16', 'Татарстан республика', NULL, NULL),
('rus', '69', 'Тверская область', NULL, NULL),
('rus', '70', 'Томская область', NULL, NULL),
('rus', '71', 'Тульская область', NULL, NULL),
('rus', '72', 'Тюменская область', NULL, NULL),
('rus', '17', 'Тыва республика', NULL, NULL),
('rus', '18', 'Удмуртская республика', NULL, NULL),
('rus', '73', 'Ульяновская область', NULL, NULL),
('rus', '27', 'Хабаровский край', NULL, NULL),
('rus', '19', 'Хакасия республика', NULL, NULL),
('rus', '86', 'Ханты-Мансийский-Югра автономный округ', NULL, NULL),
('rus', '95', 'Херсонская область', NULL, NULL),
('rus', '74', 'Челябинская область', NULL, NULL),
('rus', '20', 'Чеченская республика', NULL, NULL),
('rus', '21', 'Чувашская республика', NULL, NULL),
('rus', '87', 'Чукотский автономный округ', NULL, NULL),
('rus', '89', 'Ямало-Ненецкий автономный округ', NULL, NULL),
('rus', '76', 'Ярославская область', NULL, NULL),
('ukr', '01', 'Автономна Республіка Крим', NULL, NULL),
('ukr', '02', 'Вінницька область', NULL, NULL),
('ukr', '03', 'Волинська область', NULL, NULL),
('ukr', '04', 'Дніпропетровська область', NULL, NULL),
('ukr', '05', 'Донецька область', NULL, NULL),
('ukr', '06', 'Житомирська область', NULL, NULL),
('ukr', '07', 'Закарпатська область', NULL, NULL),
('ukr', '08', 'Запорізька область', NULL, NULL),
('ukr', '09', 'Івано-Франківська область', NULL, NULL),
('ukr', '10', 'Київська область', NULL, NULL),
('ukr', '11', 'місто Київ', NULL, NULL),
('ukr', '12', 'Кіровоградська область', NULL, NULL),
('ukr', '13', 'Луганська область', NULL, NULL),
('ukr', '14', 'Львівська область', NULL, NULL),
('ukr', '15', 'Миколаївська область', NULL, NULL),
('ukr', '16', 'Одеська область', NULL, NULL),
('ukr', '17', 'Полтавська область', NULL, NULL),
('ukr', '18', 'Рівненська область', NULL, NULL),
('ukr', '19', 'Сумська область', NULL, NULL),
('ukr', '20', 'Тернопільська область', NULL, NULL),
('ukr', '21', 'Харківська область', NULL, NULL),
('ukr', '22', 'Херсонська область', NULL, NULL),
('ukr', '23', 'Хмельницька область', NULL, NULL),
('ukr', '24', 'Черкаська область', NULL, NULL),
('ukr', '25', 'Чернігівська область', NULL, NULL),
('ukr', '26', 'Чернівецька область', NULL, NULL),
('blr', '01', 'Брэсцкая вобласць', NULL, 'Брэст'),
('blr', '02', 'Віцебская вобласць', NULL, 'Віцебск'),
('blr', '03', 'Гомельская вобласць', NULL, 'Гомель'),
('blr', '04', 'Гродзенская вобласць', NULL, 'Гродна'),
('blr', '05', 'Мінская вобласць', NULL, 'Мінск'),
('blr', '06', 'Магілёўская вобласць', NULL, 'Магілёў'),
('blr', '07', 'Мінск', NULL, 'Мінск'),
('kaz', '01', 'Астана', NULL, 'Астана'),
('kaz', '02', 'Алматы', NULL, 'Алматы'),
('kaz', '03', 'Ақмола облысы', NULL, 'Көкшетау'),
('kaz', '04', 'Ақтөбе облысы', NULL, 'Ақтөбе'),
('kaz', '05', 'Алматы облысы', NULL, 'Қонаев'),
('kaz', '06', 'Атырау облысы', NULL, 'Атырау'),
('kaz', '07', 'Батыс Қазақстан облысы', NULL, 'Орал'),
('kaz', '08', 'Жамбыл облысы', NULL, 'Тараз'),
('kaz', '09', 'Қарағанды облысы', NULL, 'Қарағанды'),
('kaz', '10', 'Қостанай облысы', NULL, 'Қостанай'),
('kaz', '11', 'Қызылорда облысы', NULL, 'Қызылорда'),
('kaz', '12', 'Маңғыстау облысы', NULL, 'Ақтау'),
('kaz', '13', 'Түркістан облысы', NULL, 'Түркістан'),
('kaz', '14', 'Павлодар облысы', NULL, 'Павлодар'),
('kaz', '15', 'Солтүстік Қазақстан облысы', NULL, 'Петропавл'),
('kaz', '16', 'Шығыс Қазақстан облысы', NULL, 'Өскемен'),
('kaz', '17', 'Шымкент', NULL, 'Шымкент'),
('kaz', '18', 'Абай облысы', NULL, 'Семей'),
('kaz', '19', 'Жетісу облысы', NULL, 'Талдықорған'),
('kaz', '20', 'Ұлытау облысы', NULL, 'Жезқазған'),
('arm', '01', 'Арагацотнская область', NULL, 'Аштарак'),
('arm', '02', 'Араратская область', NULL, 'Арташат'),
('arm', '03', 'Армавирская область', NULL, 'Армавир'),
('arm', '04', 'Вайоцдзорская область', NULL, 'Ехегнадзор'),
('arm', '05', 'Гехаркуникская область', NULL, 'Гавар'),
('arm', '06', 'Котайкская область', NULL, 'Раздан'),
('arm', '07', 'Лорийская область', NULL, 'Ванадзор'),
('arm', '08', 'Сюникская область', NULL, 'Капан'),
('arm', '09', 'Тавушская область', NULL, 'Иджеван'),
('arm', '10', 'Ширакская область', NULL, 'Гюмри'),
('arm', '11', 'Ереван', NULL, 'Ереван'),
('geo', 'GE-AB', 'Абхазская Автономная Республика', NULL, 'Сухуми'),
('geo', 'GE-SZ', 'Самегрело-Верхняя Сванетия', NULL, 'Зугдиди'),
('geo', 'GE-GU', 'Гурия', NULL, 'Озургети'),
('geo', 'GE-AJ', 'Аджарская Автономная Республика', NULL, 'Батуми'),
('geo', 'GE-RL', 'Рача-Лечхуми и Нижняя Сванетия', NULL, 'Амбролаури'),
('geo', 'GE-IM', 'Имеретия', NULL, 'Кутаиси'),
('geo', 'GE-SJ', 'Самцхе-Джавахетия', NULL, 'Ахалцихе'),
('geo', 'GE-SK', 'Шида-Картли', NULL, 'Гори'),
('geo', 'GE-MM', 'Мцхета-Мтианети', NULL, 'Мцхета'),
('geo', 'GE-KK', 'Квемо-Картли', NULL, 'Рустави'),
('geo', 'GE-KA', 'Кахетия', NULL, 'Телави'),
('geo', 'GE-TB', 'Тбилиси', NULL, 'Тбилиси'),
('chn', '11', 'Beijing', NULL, NULL),
('chn', '12', 'Tianjin', NULL, NULL),
('chn', '13', 'Hebei', NULL, NULL),
('chn', '14', 'Shanxi', NULL, NULL),
('chn', '21', 'Liaoning', NULL, NULL),
('chn', '15', 'Inner Mongolia', NULL, NULL),
('chn', '22', 'Jilin', NULL, NULL),
('chn', '23', 'Heilongjiang', NULL, NULL),
('chn', '34', 'Anhui', NULL, NULL),
('chn', '33', 'Zhejiang', NULL, NULL),
('chn', '36', 'Jiangxi', NULL, NULL),
('chn', '31', 'Shanghai', NULL, NULL),
('chn', '35', 'Fujian', NULL, NULL),
('chn', '32', 'Jiangsu', NULL, NULL),
('chn', '37', 'Shandong', NULL, NULL),
('chn', '46', 'Hainan', NULL, NULL),
('chn', '42', 'Hubei', NULL, NULL),
('chn', '43', 'Hunan', NULL, NULL),
('chn', '41', 'Henan', NULL, NULL),
('chn', '44', 'Guangdong', NULL, NULL),
('chn', '45', 'Guangxi', NULL, NULL),
('chn', '50', 'Chongqing', NULL, NULL),
('chn', '51', 'Sichuan', NULL, NULL),
('chn', '61', 'Shaanxi', NULL, NULL),
('chn', '53', 'Yunnan', NULL, NULL),
('chn', '54', 'Xizang', NULL, NULL),
('chn', '62', 'Gansu', NULL, NULL),
('chn', '52', 'Guizhou', NULL, NULL),
('chn', '64', 'Ningxia', NULL, NULL),
('chn', '63', 'Qinghai', NULL, NULL),
('chn', '65', 'Xinjiang', NULL, NULL),
('ind', '37', 'Andhra Pradesh', NULL, 'Amaravati'),
('ind', '12', 'Arunachal Pradesh', NULL, 'Itanagar'),
('ind', '18', 'Assam', NULL, 'Dispur'),
('ind', '10', 'Bihar', NULL, 'Patna'),
('ind', '22', 'Chhattisgarh', NULL, 'Raipur'),
('ind', '7', 'Delhi', NULL, 'Delhi'),
('ind', '30', 'Goa', NULL, 'Panaji'),
('ind', '24', 'Gujarat', NULL, 'Gandhinagar'),
('ind', '6', 'Haryana', NULL, 'Chandigarh'),
('ind', '2', 'Himachal Pradesh', NULL, 'Shimla'),
('ind', '1', 'Jammu and Kashmir', NULL, 'Srinagar'),
('ind', '20', 'Jharkhand', NULL, 'Ranchi'),
('ind', '29', 'Karnataka', NULL, 'Bengaluru'),
('ind', '32', 'Kerala', NULL, 'Thiruvananthapuram'),
('ind', '31', 'Lakshadweep Islands', NULL, 'Kavaratti'),
('ind', '23', 'Madhya Pradesh', NULL, 'Bhopal'),
('ind', '27', 'Maharashtra', NULL, 'Mumbai'),
('ind', '14', 'Manipur', NULL, 'Imphal'),
('ind', '17', 'Meghalaya', NULL, 'Shillong'),
('ind', '15', 'Mizoram', NULL, 'Aizawl'),
('ind', '13', 'Nagaland', NULL, 'Kohima'),
('ind', '21', 'Odisha', NULL, 'Bhubaneswar'),
('ind', '34', 'Pondicherry', NULL, 'Pondicherry'),
('ind', '3', 'Punjab', NULL, 'Chandigarh'),
('ind', '8', 'Rajasthan', NULL, 'Jaipur'),
('ind', '11', 'Sikkim', NULL, 'Gangtok'),
('ind', '33', 'Tamil Nadu', NULL, 'Chennai'),
('ind', '36', 'Telangana', NULL, 'Hyderabad'),
('ind', '16', 'Tripura', NULL, 'Agartala'),
('ind', '9', 'Uttar Pradesh', NULL, 'Lucknow'),
('ind', '5', 'Uttarakhand', NULL, 'Dehradun'),
('ind', '19', 'West Bengal', NULL, 'Kolkata'),
('aus', '1', 'New South Wales', NULL, 'Sydney'),
('aus', '2', 'Victoria', NULL, 'Melbourne'),
('aus', '3', 'Queensland', NULL, 'Brisbane'),
('aus', '4', 'South Australia', NULL, 'Adelaide'),
('aus', '5', 'Western Australia', NULL, 'Perth'),
('aus', '6', 'Tasmania', NULL, 'Hobart'),
('aus', '7', 'Northern Territory', NULL, 'Darwin'),
('aus', '8', 'Australian Capital Territory', NULL, 'Canberra'),
('aus', '9', 'Other Territories', NULL, NULL),
('deu', '01', 'Schleswig-Holstein', NULL, NULL),
('deu', '02', 'Hamburg', NULL, NULL),
('deu', '03', 'Niedersachsen', NULL, NULL),
('deu', '04', 'Bremen', NULL, NULL),
('deu', '05', 'Nordrhein-Westfalen', NULL, NULL),
('deu', '06', 'Hessen', NULL, NULL),
('deu', '07', 'Rheinland-Pfalz', NULL, NULL),
('deu', '08', 'Baden-Württemberg', NULL, NULL),
('deu', '09', 'Bayern', NULL, NULL),
('deu', '10', 'Saarland', NULL, NULL),
('deu', '11', 'Berlin', NULL, NULL),
('deu', '12', 'Brandenburg', NULL, NULL),
('deu', '13', 'Mecklenburg-Vorpommern', NULL, NULL),
('deu', '14', 'Sachsen', NULL, NULL),
('deu', '15', 'Sachsen-Anhalt', NULL, NULL),
('deu', '16', 'Thueringen', NULL, NULL),
('bel', '11', 'Antwerpen', NULL, NULL),
('bel', '12', 'Mechelen', NULL, NULL),
('bel', '13', 'Turnhout', NULL, NULL),
('bel', '21', 'Brussel-Hoofdstad', NULL, NULL),
('bel', '23', 'Halle-Vilvoorde', NULL, NULL),
('bel', '24', 'Leuven', NULL, NULL),
('bel', '25', 'Nijvel', NULL, NULL),
('bel', '31', 'Brugge', NULL, NULL),
('bel', '32', 'Diksmuide', NULL, NULL),
('bel', '33', 'Ieper', NULL, NULL),
('bel', '34', 'Kortrijk', NULL, NULL),
('bel', '35', 'Oostende', NULL, NULL),
('bel', '36', 'Roeselare', NULL, NULL),
('bel', '37', 'Tielt', NULL, NULL),
('bel', '38', 'Veurne', NULL, NULL),
('bel', '41', 'Aalst', NULL, NULL),
('bel', '42', 'Dendermonde', NULL, NULL),
('bel', '43', 'Eeklo', NULL, NULL),
('bel', '44', 'Gent', NULL, NULL),
('bel', '45', 'Oudenaarde', NULL, NULL),
('bel', '46', 'Sint-Niklaas', NULL, NULL),
('bel', '51', 'Aat', NULL, NULL),
('bel', '52', 'Charleroi', NULL, NULL),
('bel', '53', 'Bergen', NULL, NULL),
('bel', '54', 'Moeskroen', NULL, NULL),
('bel', '55', 'Zinnik', NULL, NULL),
('bel', '56', 'Thuin', NULL, NULL),
('bel', '57', 'Doornik', NULL, NULL),
('bel', '61', 'Hoei', NULL, NULL),
('bel', '62', 'Luik', NULL, NULL),
('bel', '63', 'Verviers', NULL, NULL),
('bel', '64', 'Borgworm', NULL, NULL),
('bel', '71', 'Hasselt', NULL, NULL),
('bel', '72', 'Maaseik', NULL, NULL),
('bel', '73', 'Tongeren', NULL, NULL),
('bel', '81', 'Aarlen', NULL, NULL),
('bel', '82', 'Bastenaken', NULL, NULL),
('bel', '83', 'Marche-en-Famenne', NULL, NULL),
('bel', '84', 'Neufchâteau', NULL, NULL),
('bel', '85', 'Virton', NULL, NULL),
('bel', '91', 'Dinant', NULL, NULL),
('bel', '92', 'Namen', NULL, NULL),
('bel', '93', 'Philippeville', NULL, NULL),
('dnk', '101', 'København', NULL, NULL),
('dnk', '102', 'Frederiksberg', NULL, NULL),
('dnk', '150', 'Københavns Amt', NULL, NULL),
('dnk', '200', 'Frederiksborg Amt', NULL, NULL),
('dnk', '250', 'Roskilde Amt', NULL, NULL),
('dnk', '300', 'Vestsjællands Amt', NULL, NULL),
('dnk', '350', 'Storstrøms Amt', NULL, NULL),
('dnk', '400', 'Bornholms Amt', NULL, NULL),
('dnk', '420', 'Fyns Amt', NULL, NULL),
('dnk', '500', 'Sønderjyllands Amt', NULL, NULL),
('dnk', '550', 'Ribe Amt', NULL, NULL),
('dnk', '600', 'Vejle Amt', NULL, NULL),
('dnk', '650', 'Ringkøbing Amt', NULL, NULL),
('dnk', '700', 'Århus Amt', NULL, NULL),
('dnk', '760', 'Viborg Amt', NULL, NULL),
('dnk', '800', 'Nordjyllands Amt', NULL, NULL),
('fra', '01', 'Ain', NULL, NULL),
('fra', '02', 'Aisne', NULL, NULL),
('fra', '03', 'Allier', NULL, NULL),
('fra', '04', 'Alpes-de-Haute-Provence', NULL, NULL),
('fra', '05', 'Hautes-Alpes', NULL, NULL),
('fra', '06', 'Alpes-Maritimes', NULL, NULL),
('fra', '07', 'Ardèche', NULL, NULL),
('fra', '08', 'Ardennes', NULL, NULL),
('fra', '09', 'Ariège', NULL, NULL),
('fra', '10', 'Aube', NULL, NULL),
('fra', '11', 'Aude', NULL, NULL),
('fra', '12', 'Aveyron', NULL, NULL),
('fra', '13', 'Bouches-du-Rhône', NULL, NULL),
('fra', '14', 'Calvados', NULL, NULL),
('fra', '15', 'Cantal', NULL, NULL),
('fra', '16', 'Charente', NULL, NULL),
('fra', '17', 'Charente-Maritime', NULL, NULL),
('fra', '18', 'Cher', NULL, NULL),
('fra', '19', 'Corrèze', NULL, NULL),
('fra', '21', 'Côte-d''Or', NULL, NULL),
('fra', '22', 'Côtes-du-Nord', NULL, NULL),
('fra', '23', 'Creuse', NULL, NULL),
('fra', '24', 'Dordogne', NULL, NULL),
('fra', '25', 'Doubs', NULL, NULL),
('fra', '26', 'Drôme', NULL, NULL),
('fra', '27', 'Eure', NULL, NULL),
('fra', '28', 'Eure-et-Loir', NULL, NULL),
('fra', '29', 'Finistère', NULL, NULL),
('fra', '30', 'Gard', NULL, NULL),
('fra', '31', 'Haute-Garonne', NULL, NULL),
('fra', '32', 'Gers', NULL, NULL),
('fra', '33', 'Gironde', NULL, NULL),
('fra', '34', 'Hérault', NULL, NULL),
('fra', '35', 'Ille-et-Vilaine', NULL, NULL),
('fra', '36', 'Indre', NULL, NULL),
('fra', '37', 'Indre-et-Loire', NULL, NULL),
('fra', '38', 'Isère', NULL, NULL),
('fra', '39', 'Jura', NULL, NULL),
('fra', '40', 'Landes', NULL, NULL),
('fra', '41', 'Loir-et-Cher', NULL, NULL),
('fra', '42', 'Loire', NULL, NULL),
('fra', '43', 'Haute-Loire', NULL, NULL),
('fra', '44', 'Loire-Atlantique', NULL, NULL),
('fra', '45', 'Loiret', NULL, NULL),
('fra', '46', 'Lot', NULL, NULL),
('fra', '47', 'Lot-et-Garonne', NULL, NULL),
('fra', '48', 'Lozère', NULL, NULL),
('fra', '49', 'Maine-et-Loire', NULL, NULL),
('fra', '50', 'Manche', NULL, NULL),
('fra', '51', 'Marne', NULL, NULL),
('fra', '52', 'Haute-Marne', NULL, NULL),
('fra', '53', 'Mayenne', NULL, NULL),
('fra', '54', 'Meurthe-et-Moselle', NULL, NULL),
('fra', '55', 'Meuse', NULL, NULL),
('fra', '56', 'Morbihan', NULL, NULL),
('fra', '57', 'Moselle', NULL, NULL),
('fra', '58', 'Nièvre', NULL, NULL),
('fra', '59', 'Nord', NULL, NULL),
('fra', '60', 'Oise', NULL, NULL),
('fra', '61', 'Orne', NULL, NULL),
('fra', '62', 'Pas-de-Calais', NULL, NULL),
('fra', '63', 'Puy-de-Dôme', NULL, NULL),
('fra', '64', 'Pyrénées-Atlantiques', NULL, NULL),
('fra', '65', 'Hautes-Pyrénées', NULL, NULL),
('fra', '66', 'Pyrénées-Orientales', NULL, NULL),
('fra', '67', 'Bas-Rhin', NULL, NULL),
('fra', '68', 'Haut-Rhin', NULL, NULL),
('fra', '69', 'Rhône', NULL, NULL),
('fra', '70', 'Haute-Saône', NULL, NULL),
('fra', '71', 'Saône-et-Loire', NULL, NULL),
('fra', '72', 'Sarthe', NULL, NULL),
('fra', '73', 'Savoie', NULL, NULL),
('fra', '74', 'Haute-Savoie', NULL, NULL),
('fra', '75', 'Ville-de-Paris', NULL, NULL),
('fra', '76', 'Seine-Maritime', NULL, NULL),
('fra', '77', 'Seine-et-Marne', NULL, NULL),
('fra', '78', 'Yvelines', NULL, NULL),
('fra', '79', 'Deux-Sèvres', NULL, NULL),
('fra', '80', 'Somme', NULL, NULL),
('fra', '81', 'Tarn', NULL, NULL),
('fra', '82', 'Tarn-et-Garonne', NULL, NULL),
('fra', '83', 'Var', NULL, NULL),
('fra', '84', 'Vaucluse', NULL, NULL),
('fra', '85', 'Vendée', NULL, NULL),
('fra', '86', 'Vienne', NULL, NULL),
('fra', '87', 'Haute-Vienne', NULL, NULL),
('fra', '88', 'Vosges', NULL, NULL),
('fra', '89', 'Yonne', NULL, NULL),
('fra', '90', 'Territoire-de-Belfort', NULL, NULL),
('fra', '91', 'Essonne', NULL, NULL),
('fra', '92', 'Hauts-de-Seine', NULL, NULL),
('fra', '93', 'Seine-Saint-Denis', NULL, NULL),
('fra', '94', 'Val-de-Marne', NULL, NULL),
('fra', '95', 'Val-d''Oise', NULL, NULL),
('fra', '99', 'Monaco', NULL, NULL),
('fra', '2A', 'Corse-du-Sud', NULL, NULL),
('fra', '2B', 'Haute-Corse', NULL, NULL),
('grc', '01', 'Aitolias Kai Akarnanias', NULL, NULL),
('grc', '03', 'Voiotia', NULL, NULL),
('grc', '04', 'Eivoias', NULL, NULL),
('grc', '05', 'Evritania', NULL, NULL),
('grc', '06', 'Fthiotida', NULL, NULL),
('grc', '07', 'Fokida', NULL, NULL),
('grc', '11', 'Argolidos', NULL, NULL),
('grc', '12', 'Arkadias', NULL, NULL),
('grc', '13', 'Ahaia', NULL, NULL),
('grc', '14', 'Ilia', NULL, NULL),
('grc', '15', 'Korinthos', NULL, NULL),
('grc', '16', 'Lakonia', NULL, NULL),
('grc', '17', 'Messinia', NULL, NULL),
('grc', '21', 'Zakinthos', NULL, NULL),
('grc', '22', 'Kerkira (Corfu)', NULL, NULL),
('grc', '23', 'Kefallonia', NULL, NULL),
('grc', '24', 'Lefkada', NULL, NULL),
('grc', '31', 'Arta', NULL, NULL),
('grc', '32', 'Thesprotia', NULL, NULL),
('grc', '33', 'Ioannina', NULL, NULL),
('grc', '34', 'Preveza', NULL, NULL),
('grc', '41', 'Karditsa', NULL, NULL),
('grc', '42', 'Larissa', NULL, NULL),
('grc', '43', 'Magnisias', NULL, NULL),
('grc', '44', 'Trikala', NULL, NULL),
('grc', '51', 'Grevena', NULL, NULL),
('grc', '52', 'Drama', NULL, NULL),
('grc', '53', 'Imathia', NULL, NULL),
('grc', '54', 'Thessaloniki', NULL, NULL),
('grc', '55', 'Kavala', NULL, NULL),
('grc', '56', 'Kastoria', NULL, NULL),
('grc', '57', 'Kilkis', NULL, NULL),
('grc', '58', 'Kozani', NULL, NULL),
('grc', '59', 'Pela', NULL, NULL),
('grc', '61', 'Pieria', NULL, NULL),
('grc', '62', 'Seres', NULL, NULL),
('grc', '63', 'Florina', NULL, NULL),
('grc', '64', 'Halkida', NULL, NULL),
('grc', '65', 'Agion Opos', NULL, NULL),
('grc', '71', 'Evros', NULL, NULL),
('grc', '72', 'Xanthi', NULL, NULL),
('grc', '73', 'Rodopi', NULL, NULL),
('grc', '81', 'Dodekanissa (Dodecanese)', NULL, NULL),
('grc', '82', 'Kiklades (Cyclades)', NULL, NULL),
('grc', '83', 'Lesvos', NULL, NULL),
('grc', '84', 'Samos', NULL, NULL),
('grc', '85', 'Hios', NULL, NULL),
('grc', '91', 'Iraklio', NULL, NULL),
('grc', '92', 'Lasithioi', NULL, NULL),
('grc', '93', 'Rethimno', NULL, NULL),
('grc', '94', 'Hania', NULL, NULL),
('grc', 'A1', 'Athina (Athens)', NULL, NULL),
('grc', 'A2', 'Anatoliki Attiki', NULL, NULL),
('grc', 'A3', 'Ditiki Attiki', NULL, NULL),
('grc', 'A4', 'Peiria', NULL, NULL),
('idn', '11', 'Nanggroe Aceh Darussalam', NULL, NULL),
('idn', '12', 'Sumatera Utara', NULL, NULL),
('idn', '13', 'Sumatera Barat', NULL, NULL),
('idn', '14', 'Riau', NULL, NULL),
('idn', '15', 'Jambi', NULL, NULL),
('idn', '16', 'Sumatera Selatan', NULL, NULL),
('idn', '17', 'Bengkulu', NULL, NULL),
('idn', '18', 'Lampung', NULL, NULL),
('idn', '19', 'Kepulauan Bangka Belitung', NULL, NULL),
('idn', '21', 'Kepulauan Riau', NULL, NULL),
('idn', '31', 'DKI Jakarta', NULL, NULL),
('idn', '32', 'Jawa Barat', NULL, NULL),
('idn', '33', 'Jawa Tengah', NULL, NULL),
('idn', '34', 'DI Yogyakarta', NULL, NULL),
('idn', '35', 'Jawa Timur', NULL, NULL),
('idn', '36', 'Banten', NULL, NULL),
('idn', '51', 'Bali', NULL, NULL),
('idn', '52', 'Nusa Tenggara Barat', NULL, NULL),
('idn', '53', 'Nusa Tenggara Timur', NULL, NULL),
('idn', '61', 'Kalimantan Barat', NULL, NULL),
('idn', '62', 'Kalimantan Tengah', NULL, NULL),
('idn', '63', 'Kalimantan Selatan', NULL, NULL),
('idn', '64', 'Kalimantan Timur', NULL, NULL),
('idn', '71', 'Sulawesi Utara', NULL, NULL),
('idn', '72', 'Sulawesi Tengah', NULL, NULL),
('idn', '73', 'Sulawesi Selatan', NULL, NULL),
('idn', '74', 'Sulawesi Tenggara', NULL, NULL),
('idn', '75', 'Gorontalo', NULL, NULL),
('idn', '76', 'Sulawesi Barat', NULL, NULL),
('idn', '81', 'Maluku', NULL, NULL),
('idn', '82', 'Maluku Utara', NULL, NULL),
('idn', '91', 'Papua Barat', NULL, NULL),
('idn', '94', 'Papua', NULL, NULL),
('irl', '01', 'Carlow', NULL, NULL),
('irl', '02', 'Dublin County Borough', NULL, NULL),
('irl', '03', 'South Dublin', NULL, NULL),
('irl', '04', 'Fingal', NULL, NULL),
('irl', '05', 'Dun Laoghaire-Rathdown', NULL, NULL),
('irl', '06', 'Kildare', NULL, NULL),
('irl', '07', 'Kilkenny', NULL, NULL),
('irl', '08', 'Laoighis', NULL, NULL),
('irl', '09', 'Longford', NULL, NULL),
('irl', '10', 'Louth', NULL, NULL),
('irl', '11', 'Meath', NULL, NULL),
('irl', '12', 'Offaly', NULL, NULL),
('irl', '13', 'Westmeath', NULL, NULL),
('irl', '14', 'Wexford', NULL, NULL),
('irl', '15', 'Wicklow', NULL, NULL),
('irl', '16', 'Clare', NULL, NULL),
('irl', '18', 'Cork County Borough', NULL, NULL),
('irl', '19', 'Cork', NULL, NULL),
('irl', '20', 'Kerry', NULL, NULL),
('irl', '22', 'Limerick County Borough', NULL, NULL),
('irl', '23', 'Limerick', NULL, NULL),
('irl', '24', 'Tipperary North Riding', NULL, NULL),
('irl', '25', 'Tipperay South Riding', NULL, NULL),
('irl', '27', 'Waterford County Borough', NULL, NULL),
('irl', '28', 'Waterford', NULL, NULL),
('irl', '29', 'Galway', NULL, NULL),
('irl', '30', 'Leitrim', NULL, NULL),
('irl', '31', 'Mayo', NULL, NULL),
('irl', '32', 'Roscommon', NULL, NULL),
('irl', '33', 'Sligo', NULL, NULL),
('irl', '34', 'Cavan', NULL, NULL),
('irl', '35', 'Donegal', NULL, NULL),
('irl', '36', 'Monaghan', NULL, NULL),
('irl', '37', 'Galway County Borough', NULL, NULL),
('isr', '01', 'Akko', NULL, NULL),
('isr', '02', 'Ashqelon', NULL, NULL),
('isr', '03', 'Beer Sheva', NULL, NULL),
('isr', '04', 'Gaza Area', NULL, NULL),
('isr', '05', 'Golan', NULL, NULL),
('isr', '06', 'Hadera', NULL, NULL),
('isr', '07', 'Haifa', NULL, NULL),
('isr', '08', 'Jericho', NULL, NULL),
('isr', '09', 'Jerusalem', NULL, NULL),
('isr', '10', 'Kinneret', NULL, NULL),
('isr', '11', 'Petah Tiqwa', NULL, NULL),
('isr', '12', 'Ramla', NULL, NULL),
('isr', '13', 'Rehovot', NULL, NULL),
('isr', '14', 'Sharon', NULL, NULL),
('isr', '15', 'Tel Aviv', NULL, NULL),
('isr', '16', 'Yizreel', NULL, NULL),
('isr', '17', 'Zefat', NULL, NULL),
('ita', '001', 'Torino', NULL, NULL),
('ita', '002', 'Vercelli', NULL, NULL),
('ita', '003', 'Novara', NULL, NULL),
('ita', '004', 'Cuneo', NULL, NULL),
('ita', '005', 'Asti', NULL, NULL),
('ita', '006', 'Alessandria', NULL, NULL),
('ita', '007', 'Valle d''Aosta', NULL, NULL),
('ita', '008', 'Imperia', NULL, NULL),
('ita', '009', 'Savona', NULL, NULL),
('ita', '010', 'Genova', NULL, NULL),
('ita', '011', 'La Spezia', NULL, NULL),
('ita', '012', 'Varese', NULL, NULL),
('ita', '013', 'Como', NULL, NULL),
('ita', '014', 'Sondrio', NULL, NULL),
('ita', '015', 'Milano', NULL, NULL),
('ita', '016', 'Bergamo', NULL, NULL),
('ita', '017', 'Brescia', NULL, NULL),
('ita', '018', 'Pavia', NULL, NULL),
('ita', '019', 'Cremona', NULL, NULL),
('ita', '020', 'Mantova', NULL, NULL),
('ita', '021', 'Bolzano', NULL, NULL),
('ita', '022', 'Trento', NULL, NULL),
('ita', '023', 'Verona', NULL, NULL),
('ita', '024', 'Vicenza', NULL, NULL),
('ita', '025', 'Belluno', NULL, NULL),
('ita', '026', 'Treviso', NULL, NULL),
('ita', '027', 'Venezia', NULL, NULL),
('ita', '028', 'Padova', NULL, NULL),
('ita', '029', 'Rovigo', NULL, NULL),
('ita', '030', 'Udine', NULL, NULL),
('ita', '031', 'Gorizia', NULL, NULL),
('ita', '032', 'Trieste', NULL, NULL),
('ita', '033', 'Piacenza', NULL, NULL),
('ita', '034', 'Parma', NULL, NULL),
('ita', '035', 'Reggio Emilia', NULL, NULL),
('ita', '036', 'Modena', NULL, NULL),
('ita', '037', 'Bologna', NULL, NULL),
('ita', '038', 'Ferrara', NULL, NULL),
('ita', '039', 'Ravenna', NULL, NULL),
('ita', '040', 'Forli-Cesena', NULL, NULL),
('ita', '041', 'Pesaro E Urbino', NULL, NULL),
('ita', '042', 'Ancona', NULL, NULL),
('ita', '043', 'Macerata', NULL, NULL),
('ita', '044', 'Ascoli Piceno', NULL, NULL),
('ita', '045', 'Massa Carrara', NULL, NULL),
('ita', '046', 'Lucca', NULL, NULL),
('ita', '047', 'Pistoia', NULL, NULL),
('ita', '048', 'Firenze', NULL, NULL),
('ita', '049', 'Livorno', NULL, NULL),
('ita', '050', 'Pisa', NULL, NULL),
('ita', '051', 'Arezzo', NULL, NULL),
('ita', '052', 'Siena', NULL, NULL),
('ita', '053', 'Grosseto', NULL, NULL),
('ita', '054', 'Perugia', NULL, NULL),
('ita', '055', 'Terni', NULL, NULL),
('ita', '056', 'Viterbo', NULL, NULL),
('ita', '057', 'Rieti', NULL, NULL),
('ita', '058', 'Roma', NULL, NULL),
('ita', '059', 'Latina', NULL, NULL),
('ita', '060', 'Frosinone', NULL, NULL),
('ita', '061', 'Caserta', NULL, NULL),
('ita', '062', 'Benevento', NULL, NULL),
('ita', '063', 'Napoli', NULL, NULL),
('ita', '064', 'Avellino', NULL, NULL),
('ita', '065', 'Salerno', NULL, NULL),
('ita', '066', 'L''Aquila', NULL, NULL),
('ita', '067', 'Teramo', NULL, NULL),
('ita', '068', 'Pescara', NULL, NULL),
('ita', '069', 'Chieti', NULL, NULL),
('ita', '070', 'Campobasso', NULL, NULL),
('ita', '071', 'Foggia', NULL, NULL),
('ita', '072', 'Bari', NULL, NULL),
('ita', '073', 'Taranto', NULL, NULL),
('ita', '074', 'Brindisi', NULL, NULL),
('ita', '075', 'Lecce', NULL, NULL),
('ita', '076', 'Potenza', NULL, NULL),
('ita', '077', 'Matera', NULL, NULL),
('ita', '078', 'Cosenza', NULL, NULL),
('ita', '079', 'Catanzaro', NULL, NULL),
('ita', '080', 'Reggio Calabria', NULL, NULL),
('ita', '081', 'Trapani', NULL, NULL),
('ita', '082', 'Palermo', NULL, NULL),
('ita', '083', 'Messina', NULL, NULL),
('ita', '084', 'Agrigento', NULL, NULL),
('ita', '085', 'Caltanissetta', NULL, NULL),
('ita', '086', 'Enna', NULL, NULL),
('ita', '087', 'Catania', NULL, NULL),
('ita', '088', 'Ragusa', NULL, NULL),
('ita', '089', 'Siracusa', NULL, NULL),
('ita', '090', 'Sassari', NULL, NULL),
('ita', '091', 'Nuoro', NULL, NULL),
('ita', '092', 'Cagliari', NULL, NULL),
('ita', '093', 'Pordenone', NULL, NULL),
('ita', '094', 'Isernia', NULL, NULL),
('ita', '095', 'Oristano', NULL, NULL),
('ita', '096', 'Biella', NULL, NULL),
('ita', '097', 'Lecco', NULL, NULL),
('ita', '098', 'Lodi', NULL, NULL),
('ita', '099', 'Rimini', NULL, NULL),
('ita', '100', 'Prato', NULL, NULL),
('ita', '101', 'Crotone', NULL, NULL),
('ita', '102', 'Vibo Valentia', NULL, NULL),
('ita', '103', 'Verbano-Cusio-Ossola', NULL, NULL),
('ita', '104', 'Olbia-Tempio', NULL, NULL),
('ita', '105', 'Ogliastra', NULL, NULL),
('ita', '106', 'Medio Campidano', NULL, NULL),
('ita', '107', 'Carbonia-Iglesias', NULL, NULL),
('ita', '888', 'Citta del Vaticano', NULL, NULL),
('ita', '999', 'San Marino', NULL, NULL),
('kor', '11', 'Seoul', NULL, NULL),
('kor', '21', 'Busan', NULL, NULL),
('kor', '22', 'Daegu', NULL, NULL),
('kor', '23', 'Incheon', NULL, NULL),
('kor', '24', 'Gwangju', NULL, NULL),
('kor', '25', 'Daejeon', NULL, NULL),
('kor', '26', 'Ulsan', NULL, NULL),
('kor', '31', 'Gyeonggi-do', NULL, NULL),
('kor', '32', 'Gangwon-do', NULL, NULL),
('kor', '33', 'Chungcheongbuk-do', NULL, NULL),
('kor', '34', 'Chungcheongnam-do', NULL, NULL),
('kor', '35', 'Jeollabuk-do', NULL, NULL),
('kor', '36', 'Jeollanam-do', NULL, NULL),
('kor', '37', 'Gyeongsangbuk-do', NULL, NULL),
('kor', '38', 'Gyeongsangnam-do', NULL, NULL),
('kor', '39', 'Jeju-do', NULL, NULL),
('tur', '01', 'Adana', NULL, NULL),
('tur', '02', 'Adýyaman', NULL, NULL),
('tur', '03', 'Afyonkarahisar', NULL, NULL),
('tur', '04', 'Aðrý', NULL, NULL),
('tur', '05', 'Amasya', NULL, NULL),
('tur', '06', 'Ankara', NULL, NULL),
('tur', '07', 'Antalya', NULL, NULL),
('tur', '08', 'Artvin', NULL, NULL),
('tur', '09', 'Aydýn', NULL, NULL),
('tur', '10', 'Balýkesir', NULL, NULL),
('tur', '11', 'Bilecik', NULL, NULL),
('tur', '12', 'Bingöl', NULL, NULL),
('tur', '13', 'Bitlis', NULL, NULL),
('tur', '14', 'Bolu', NULL, NULL),
('tur', '15', 'Burdur', NULL, NULL),
('tur', '16', 'Bursa', NULL, NULL),
('tur', '17', 'Çanakkale', NULL, NULL),
('tur', '18', 'Çankýrý', NULL, NULL),
('tur', '19', 'Çorum', NULL, NULL),
('tur', '20', 'Denizli', NULL, NULL),
('tur', '21', 'Diyarbakýr', NULL, NULL),
('tur', '22', 'Edirne', NULL, NULL),
('tur', '23', 'Elazýð', NULL, NULL),
('tur', '24', 'Erzincan', NULL, NULL),
('tur', '25', 'Erzurum', NULL, NULL),
('tur', '26', 'Eskiþehir', NULL, NULL),
('tur', '27', 'Gaziantep', NULL, NULL),
('tur', '28', 'Giresun', NULL, NULL),
('tur', '29', 'Gümüþhane', NULL, NULL),
('tur', '30', 'Hakkari', NULL, NULL),
('tur', '31', 'Hatay', NULL, NULL),
('tur', '32', 'Isparta', NULL, NULL),
('tur', '33', 'Mersin', NULL, NULL),
('tur', '34', 'Ýstanbul', NULL, NULL),
('tur', '35', 'Ýzmir', NULL, NULL),
('tur', '36', 'Kars', NULL, NULL),
('tur', '37', 'Kastamonu', NULL, NULL),
('tur', '38', 'Kayseri', NULL, NULL),
('tur', '39', 'Kýrklareli', NULL, NULL),
('tur', '40', 'Kýrþehir', NULL, NULL),
('tur', '41', 'Kocaeli', NULL, NULL),
('tur', '42', 'Konya', NULL, NULL),
('tur', '43', 'Kütahya', NULL, NULL),
('tur', '44', 'Malatya', NULL, NULL),
('tur', '45', 'Manisa', NULL, NULL),
('tur', '46', 'Kahramanmaraþ', NULL, NULL),
('tur', '47', 'Mardin', NULL, NULL),
('tur', '48', 'Muðla', NULL, NULL),
('tur', '49', 'Muþ', NULL, NULL),
('tur', '50', 'Nevþehir', NULL, NULL),
('tur', '51', 'Niðde', NULL, NULL),
('tur', '52', 'Ordu', NULL, NULL),
('tur', '53', 'Rize', NULL, NULL),
('tur', '54', 'Sakarya', NULL, NULL),
('tur', '55', 'Samsun', NULL, NULL),
('tur', '56', 'Siirt', NULL, NULL),
('tur', '57', 'Sinop', NULL, NULL),
('tur', '58', 'Sivas', NULL, NULL),
('tur', '59', 'Tekirdað', NULL, NULL),
('tur', '60', 'Tokat', NULL, NULL),
('tur', '61', 'Trabzon', NULL, NULL),
('tur', '62', 'Tunceli', NULL, NULL),
('tur', '63', 'Þanlýurfa', NULL, NULL),
('tur', '64', 'Uþak', NULL, NULL),
('tur', '65', 'Van', NULL, NULL),
('tur', '66', 'Yozgat', NULL, NULL),
('tur', '67', 'Zonguldak', NULL, NULL),
('tur', '68', 'Aksaray', NULL, NULL),
('tur', '69', 'Bayburt', NULL, NULL),
('tur', '70', 'Karaman', NULL, NULL),
('tur', '71', 'Kýrýkkale', NULL, NULL),
('tur', '72', 'Batman', NULL, NULL),
('tur', '73', 'Þýrnak', NULL, NULL),
('tur', '74', 'Bartýn', NULL, NULL),
('tur', '75', 'Ardahan', NULL, NULL),
('tur', '76', 'Iðdýr', NULL, NULL),
('tur', '77', 'Yalova', NULL, NULL),
('tur', '78', 'Karabük', NULL, NULL),
('tur', '79', 'Kilis', NULL, NULL),
('tur', '80', 'Osmaniye', NULL, NULL),
('tur', '81', 'Düzce', NULL, NULL),
('gbr', 'AB', 'Aberdeen', NULL, NULL),
('gbr', 'AL', 'St Albans', NULL, NULL),
('gbr', 'B', 'Birmingham', NULL, NULL),
('gbr', 'BA', 'Bath', NULL, NULL),
('gbr', 'BB', 'Blackburn', NULL, NULL),
('gbr', 'BD', 'Bradford', NULL, NULL),
('gbr', 'BH', 'Bournemouth', NULL, NULL),
('gbr', 'BL', 'Bolton', NULL, NULL),
('gbr', 'BN', 'Brighton', NULL, NULL),
('gbr', 'BR', 'Bromley', NULL, NULL),
('gbr', 'BS', 'Bristol', NULL, NULL),
('gbr', 'BT', 'Northern Ireland', NULL, NULL),
('gbr', 'CA', 'Carlisle', NULL, NULL),
('gbr', 'CB', 'Cambridge', NULL, NULL),
('gbr', 'CF', 'Cardiff', NULL, NULL),
('gbr', 'CH', 'Chester', NULL, NULL),
('gbr', 'CM', 'Chelmsford', NULL, NULL),
('gbr', 'CO', 'Colchester', NULL, NULL),
('gbr', 'CR', 'Croydon', NULL, NULL),
('gbr', 'CT', 'Canterbury', NULL, NULL),
('gbr', 'CV', 'Coventry', NULL, NULL),
('gbr', 'CW', 'Crewe', NULL, NULL),
('gbr', 'DA', 'Dartford', NULL, NULL),
('gbr', 'DD', 'Dundee', NULL, NULL),
('gbr', 'DE', 'Derby', NULL, NULL),
('gbr', 'DG', 'Dumfries', NULL, NULL),
('gbr', 'DH', 'Durham', NULL, NULL),
('gbr', 'DL', 'Darlington', NULL, NULL),
('gbr', 'DN', 'Doncaster', NULL, NULL),
('gbr', 'DT', 'Dorchester', NULL, NULL),
('gbr', 'DY', 'Dudley', NULL, NULL),
('gbr', 'E', 'London E', NULL, NULL),
('gbr', 'EC', 'London EC', NULL, NULL),
('gbr', 'EH', 'Edinburgh', NULL, NULL),
('gbr', 'EN', 'Enfield', NULL, NULL),
('gbr', 'EX', 'Exeter', NULL, NULL),
('gbr', 'FK', 'Falkirk', NULL, NULL),
('gbr', 'FY', 'Blackpool', NULL, NULL),
('gbr', 'G', 'Glasgow', NULL, NULL),
('gbr', 'GL', 'Gloucester', NULL, NULL),
('gbr', 'GU', 'Guildford', NULL, NULL),
('gbr', 'GY', 'Guernsey', NULL, NULL),
('gbr', 'HA', 'Harrow', NULL, NULL),
('gbr', 'HD', 'Huddersfield', NULL, NULL),
('gbr', 'HG', 'Harrogate', NULL, NULL),
('gbr', 'HP', 'Hemel Hempstead', NULL, NULL),
('gbr', 'HR', 'Hereford', NULL, NULL),
('gbr', 'HS', 'Outer Hebrides', NULL, NULL),
('gbr', 'HU', 'Hull', NULL, NULL),
('gbr', 'HX', 'Halifax', NULL, NULL),
('gbr', 'IC', 'Channel Islands', NULL, NULL),
('gbr', 'IG', 'Ilford', NULL, NULL),
('gbr', 'IM', 'Isle of Man', NULL, NULL),
('gbr', 'IP', 'Ipswich', NULL, NULL),
('gbr', 'IV', 'Inverness', NULL, NULL),
('gbr', 'JE', 'Jersey', NULL, NULL),
('gbr', 'KA', 'Kilmarnock', NULL, NULL),
('gbr', 'KT', 'Kingston upon Thames', NULL, NULL),
('gbr', 'KW', 'Kirkwall', NULL, NULL),
('gbr', 'KY', 'Kirkcaldy', NULL, NULL),
('gbr', 'L', 'Liverpool', NULL, NULL),
('gbr', 'LA', 'Lancaster', NULL, NULL),
('gbr', 'LD', 'Llandrindod Wells', NULL, NULL),
('gbr', 'LE', 'Leicester', NULL, NULL),
('gbr', 'LL', 'Llandudno', NULL, NULL),
('gbr', 'LN', 'Lincoln', NULL, NULL),
('gbr', 'LS', 'Leeds', NULL, NULL),
('gbr', 'LU', 'Luton', NULL, NULL),
('gbr', 'M', 'Manchester', NULL, NULL),
('gbr', 'ME', 'Medway', NULL, NULL),
('gbr', 'MK', 'Milton Keynes', NULL, NULL),
('gbr', 'ML', 'Motherwell', NULL, NULL),
('gbr', 'N', 'London N', NULL, NULL),
('gbr', 'NE', 'Newcastle upon Tyne', NULL, NULL),
('gbr', 'NG', 'Nottingham', NULL, NULL),
('gbr', 'NN', 'Northampton', NULL, NULL),
('gbr', 'NP', 'Newport', NULL, NULL),
('gbr', 'NR', 'Norwich', NULL, NULL),
('gbr', 'NW', 'London NW', NULL, NULL),
('gbr', 'OL', 'Oldham', NULL, NULL),
('gbr', 'OX', 'Oxford', NULL, NULL),
('gbr', 'PA', 'Paisley', NULL, NULL),
('gbr', 'PE', 'Peterborough', NULL, NULL),
('gbr', 'PH', 'Perth', NULL, NULL),
('gbr', 'PL', 'Plymouth', NULL, NULL),
('gbr', 'PO', 'Portsmouth', NULL, NULL),
('gbr', 'PR', 'Preston', NULL, NULL),
('gbr', 'RG', 'Reading', NULL, NULL),
('gbr', 'RH', 'Redhill', NULL, NULL),
('gbr', 'RM', 'Romford', NULL, NULL),
('gbr', 'S', 'Sheffield', NULL, NULL),
('gbr', 'SA', 'Swansea', NULL, NULL),
('gbr', 'SE', 'London SE', NULL, NULL),
('gbr', 'SG', 'Stevenage', NULL, NULL),
('gbr', 'SK', 'Stockport', NULL, NULL),
('gbr', 'SL', 'Slough', NULL, NULL),
('gbr', 'SM', 'Sutton', NULL, NULL),
('gbr', 'SN', 'Swindon', NULL, NULL),
('gbr', 'SO', 'Southampton', NULL, NULL),
('gbr', 'SP', 'Salisbury', NULL, NULL),
('gbr', 'SR', 'Sunderland', NULL, NULL),
('gbr', 'SS', 'Southend-on-Sea', NULL, NULL),
('gbr', 'ST', 'Stoke-on-Trent', NULL, NULL),
('gbr', 'SW', 'London SW', NULL, NULL),
('gbr', 'SY', 'Shrewsbury', NULL, NULL),
('gbr', 'TA', 'Taunton', NULL, NULL),
('gbr', 'TD', 'Galashiels', NULL, NULL),
('gbr', 'TF', 'Telford', NULL, NULL),
('gbr', 'TN', 'Tonbridge', NULL, NULL),
('gbr', 'TQ', 'Torquay', NULL, NULL),
('gbr', 'TR', 'Truro', NULL, NULL),
('gbr', 'TS', 'Cleveland', NULL, NULL),
('gbr', 'TW', 'Twickenham', NULL, NULL),
('gbr', 'UB', 'Southall', NULL, NULL),
('gbr', 'W', 'London W', NULL, NULL),
('gbr', 'WA', 'Warrington', NULL, NULL),
('gbr', 'WC', 'London WC', NULL, NULL),
('gbr', 'WD', 'Watford', NULL, NULL),
('gbr', 'WF', 'Wakefield', NULL, NULL),
('gbr', 'WN', 'Wigan', NULL, NULL),
('gbr', 'WR', 'Worcester', NULL, NULL),
('gbr', 'WS', 'Walsall', NULL, NULL),
('gbr', 'WV', 'Wolverhampton', NULL, NULL),
('gbr', 'YO', 'York', NULL, NULL),
('gbr', 'ZE', 'Lerwick', NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `wa_transaction`
--

CREATE TABLE `wa_transaction` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `plugin` varchar(50) NOT NULL,
  `app_id` varchar(50) NOT NULL,
  `merchant_id` varchar(50) DEFAULT NULL,
  `native_id` varchar(255) NOT NULL,
  `create_datetime` datetime NOT NULL,
  `update_datetime` datetime NOT NULL,
  `type` varchar(20) NOT NULL,
  `parent_id` int(11) DEFAULT NULL,
  `order_id` varchar(50) DEFAULT NULL,
  `part_number` int(11) NOT NULL DEFAULT '0',
  `customer_id` varchar(50) DEFAULT NULL,
  `result` varchar(20) NOT NULL,
  `error` varchar(255) DEFAULT NULL,
  `state` varchar(20) DEFAULT NULL,
  `view_data` text,
  `amount` decimal(20,8) NOT NULL DEFAULT '0.00000000',
  `currency_id` varchar(3) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `plugin` (`plugin`),
  KEY `app_id` (`app_id`),
  KEY `merchant_id` (`merchant_id`),
  KEY `transaction_native_id` (`native_id`),
  KEY `parent_id` (`parent_id`),
  KEY `order_id` (`order_id`),
  KEY `customer_id` (`customer_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `wa_transaction_data`
--

CREATE TABLE `wa_transaction_data` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `transaction_id` int(11) NOT NULL,
  `field_id` varchar(50) NOT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `transaction_id` (`transaction_id`),
  KEY `field_id` (`field_id`),
  KEY `value` (`value`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `wa_user_groups`
--

CREATE TABLE `wa_user_groups` (
  `contact_id` int(11) NOT NULL,
  `group_id` int(11) NOT NULL,
  `datetime` datetime DEFAULT NULL,
  PRIMARY KEY (`contact_id`,`group_id`),
  KEY `group_id` (`group_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `wa_user_groups`
--

INSERT INTO `wa_user_groups` VALUES
(1, 2, '[[regtime]]'),
(1, 1, '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `wa_verification_channel`
--

CREATE TABLE `wa_verification_channel` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `address` varchar(64) NOT NULL,
  `type` varchar(64) NOT NULL,
  `create_datetime` datetime DEFAULT NULL,
  `system` int(3) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `address` (`address`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=3 ;

--
-- Dumping data for table `wa_verification_channel`
--

INSERT INTO `wa_verification_channel` VALUES
(1, 'System templates', '*', 'sms', '[[regtime]]', 0),
(2, 'System templates', '[[admin_email]]', 'email', '[[regtime]]', 1);

-- --------------------------------------------------------

--
-- Table structure for table `wa_verification_channel_assets`
--

CREATE TABLE `wa_verification_channel_assets` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `channel_id` int(11) NOT NULL,
  `address` varchar(64) NOT NULL,
  `contact_id` int(11) NOT NULL DEFAULT '0',
  `name` varchar(64) NOT NULL,
  `value` text,
  `expires` datetime DEFAULT NULL,
  `tries` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `channel_address_name` (`channel_id`,`address`,`contact_id`,`name`),
  KEY `name` (`name`),
  KEY `expires` (`expires`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `wa_verification_channel_params`
--

CREATE TABLE `wa_verification_channel_params` (
  `channel_id` int(11) NOT NULL,
  `name` varchar(64) NOT NULL,
  `value` text,
  PRIMARY KEY (`channel_id`,`name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `wa_widget`
--

CREATE TABLE `wa_widget` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `widget` varchar(32) NOT NULL,
  `name` varchar(255) NOT NULL,
  `contact_id` int(11) NOT NULL,
  `dashboard_id` int(11) DEFAULT NULL,
  `create_datetime` datetime NOT NULL,
  `app_id` varchar(32) NOT NULL,
  `block` int(11) NOT NULL,
  `sort` int(11) NOT NULL,
  `size` char(3) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=9 ;

--
-- Dumping data for table `wa_widget`
--

INSERT INTO `wa_widget` VALUES
(1, 'news', 'News', 1, NULL, '[[regtime]]', 'webasyst', 0, 0, '2x2'),
(2, 'news', 'News', 1, NULL, '[[regtime]]', 'webasyst', 1, 0, '2x2'),
(3, 'clock', 'Clock', 1, NULL, '[[regtime]]', 'webasyst', 2, 0, '2x1'),
(4, 'clock', 'Clock', 1, NULL, '[[regtime]]', 'webasyst', 2, 1, '1x1'),
(5, 'clock', 'Clock', 1, NULL, '[[regtime]]', 'webasyst', 2, 2, '1x1'),
(6, 'news', 'News', 1, NULL, '[[regtime]]', 'webasyst', 3, 0, '2x2'),
(7, 'weather', 'Weather', 1, NULL, '[[regtime]]', 'webasyst', 4, 0, '2x2'),
(8, 'news', 'News', 1, NULL, '[[regtime]]', 'webasyst', 5, 0, '2x2');

-- --------------------------------------------------------

--
-- Table structure for table `wa_widget_params`
--

CREATE TABLE `wa_widget_params` (
  `widget_id` int(11) NOT NULL,
  `name` varchar(32) NOT NULL,
  `value` text NOT NULL,
  PRIMARY KEY (`widget_id`,`name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `wa_widget_params`
--

INSERT INTO `wa_widget_params` VALUES
(1, 'rss_feed', 'http://rss.nytimes.com/services/xml/rss/nyt/InternationalHome.xml'),
(2, 'rss_feed', 'http://feeds.washingtonpost.com/rss/world'),
(3, 'source', 'local'),
(3, 'type', 'round'),
(4, 'source', '-4'),
(4, 'town', 'New York'),
(4, 'type', 'round'),
(5, 'source', '1'),
(5, 'town', 'London'),
(5, 'type', 'round'),
(6, 'rss_feed', 'custom'),
(6, 'custom_rss_feed', 'http://feeds.feedburner.com/webasystcom'),
(7, 'city', 'New York'),
(7, 'unit', 'F'),
(8, 'rss_feed', 'http://www.theguardian.com/world/rss'),
(7, 'weathers', '{"2025-10-08 05":{"New York":{"coord":{"lon":-74.006000000000000227373675443232059478759765625,"lat":40.71430000000000148929757415316998958587646484375},"weather":[{"id":500,"main":"Rain","description":"light rain","icon":"10n"}],"base":"stations","main":{"temp":68.7000000000000028421709430404007434844970703125,"feels_like":69.1700000000000017053025658242404460906982421875,"temp_min":68.7000000000000028421709430404007434844970703125,"temp_max":68.7000000000000028421709430404007434844970703125,"pressure":1012,"humidity":83,"sea_level":1012,"grnd_level":1011},"visibility":10000,"wind":{"speed":11.21000000000000085265128291212022304534912109375,"deg":226,"gust":29.35000000000000142108547152020037174224853515625},"rain":{"1h":0.2200000000000000011102230246251565404236316680908203125},"clouds":{"all":100},"dt":1759917407,"sys":{"country":"US","sunrise":1759921186,"sunset":1759962415},"timezone":-14400,"id":5128581,"name":"New York","cod":200}}}');

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
