/*
 * This file is part of the TYPO3 CMS project.
 *
 * It is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License, either version 2
 * of the License, or any later version.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 *
 * The TYPO3 project - inspiring people to share!
 */
import R from"@typo3/core/document-service.js";import h from"nprogress";import"@typo3/backend/input/clearable.js";import"@typo3/backend/element/alert-element.js";import"@typo3/backend/element/icon-element.js";import"@typo3/backend/element/pagination.js";import x from"@typo3/backend/action-button/deferred-action.js";import T from"@typo3/backend/modal.js";import v from"@typo3/backend/notification.js";import{SeverityEnum as f}from"@typo3/backend/enum/severity.js";import u from"@typo3/core/event/regular-event.js";import P from"@typo3/core/ajax/ajax-request.js";var n;(function(i){i.searchForm="#recycler-form",i.searchText="#recycler-form [name=search-text]",i.searchSubmitBtn="#recycler-form button[type=submit]",i.depthSelector="#recycler-form [name=depth]",i.tableSelector="#recycler-form [name=pages]",i.recyclerTable="#itemsInRecycler",i.paginator="#recycler-index nav",i.reloadAction="a[data-action=reload]",i.undo="button[data-action=undo]",i.delete="button[data-action=delete]",i.massUndo="button[data-multi-record-selection-action=massundo]",i.massDelete="button[data-multi-record-selection-action=massdelete]"})(n||(n={}));class S{constructor(){this.paging={currentPage:1,totalPages:1,totalItems:0,itemsPerPage:parseInt(TYPO3.settings.Recycler.pagingSize,10)},this.markedRecordsForMassAction=[],R.ready().then(()=>{this.initialize()})}static refreshPageTree(){top.document.dispatchEvent(new CustomEvent("typo3:pagetree:refresh"))}registerEvents(){new u("submit",e=>{e.preventDefault(),document.querySelector(n.searchText).value!==""&&this.loadDeletedElements()}).delegateTo(document,n.searchForm),new u("input",(e,t)=>{const l=document.querySelector(n.searchSubmitBtn);t.value!==""?l.disabled=!1:(l.disabled=!0,this.loadDeletedElements())}).delegateTo(document,n.searchText),new u("change",()=>{this.loadAvailableTables().then(()=>{this.loadDeletedElements()})}).delegateTo(document,n.depthSelector),new u("change",()=>{this.paging.currentPage=1,this.loadDeletedElements()}).delegateTo(document,n.tableSelector),new u("click",this.undoRecord.bind(this)).delegateTo(document,n.undo),new u("click",this.deleteRecord.bind(this)).delegateTo(document,n.delete),new u("click",e=>{e.preventDefault(),this.loadAvailableTables().then(()=>{this.loadDeletedElements()})}).delegateTo(document,n.reloadAction),document.querySelector(n.searchText).clearable({onClear:()=>{const e=document.querySelector(n.searchSubmitBtn);e.disabled=!0,this.loadDeletedElements()}}),new u("click",e=>{e.preventDefault();const t=e.target.closest("button");t&&(t.dataset.action==="previous"?this.paging.currentPage>1&&this.paging.currentPage--:t.dataset.action==="next"?this.paging.currentPage<this.paging.totalPages&&this.paging.currentPage++:t.dataset.action==="page"&&(this.paging.currentPage=parseInt(t.querySelector("span").textContent,10)),this.loadDeletedElements())}).delegateTo(document,n.paginator),new u("multiRecordSelection:checkbox:state:changed",this.handleCheckboxStateChanged.bind(this)).bindTo(document),new u("multiRecordSelection:action:massundo",this.undoRecord.bind(this)).bindTo(document),new u("multiRecordSelection:action:massdelete",this.deleteRecord.bind(this)).bindTo(document)}initialize(){h.configure({parent:".module-loading-indicator",showSpinner:!1}),this.registerEvents(),TYPO3.settings.Recycler.depthSelection>0&&(document.querySelector(n.depthSelector).value=String(TYPO3.settings.Recycler.depthSelection)),this.loadAvailableTables().then(()=>{this.loadDeletedElements()})}handleCheckboxStateChanged(e){const t=e.target,l=t.closest("tr"),s=l.dataset.table,r=l.dataset.uid,o=s+":"+r;if(t.checked)this.markedRecordsForMassAction.push(o);else{const a=this.markedRecordsForMassAction.indexOf(o);a>-1&&this.markedRecordsForMassAction.splice(a,1)}if(this.markedRecordsForMassAction.length>0){const a=document.querySelector(n.massUndo);if(a.querySelector("span.text").textContent=this.createMessage(TYPO3.lang["button.undoselected"],[this.markedRecordsForMassAction.length.toString(10)]),!TYPO3.settings.Recycler.deleteDisable){const c=document.querySelector(n.massDelete);c.querySelector("span.text").textContent=this.createMessage(TYPO3.lang["button.deleteselected"],[this.markedRecordsForMassAction.length.toString(10)])}}else this.resetMassActionButtons()}resetMassActionButtons(){const e=document.querySelector(n.massUndo);if(this.markedRecordsForMassAction=[],e.querySelector("span.text").textContent=TYPO3.lang["button.undo"],!TYPO3.settings.Recycler.deleteDisable){const t=document.querySelector(n.massDelete);t.querySelector("span.text").textContent=TYPO3.lang["button.delete"]}document.dispatchEvent(new CustomEvent("multiRecordSelection:actions:hide"))}async loadAvailableTables(){const e=document.querySelector(n.tableSelector),t=document.querySelector(n.depthSelector);return h.start(),e.value="",this.paging.currentPage=1,new P(TYPO3.settings.ajaxUrls.recycler).withQueryArguments({action:"getTables",startUid:TYPO3.settings.Recycler.startUid,depth:t.value}).get().then(async l=>{const s=await l.resolve(),r=[];e.replaceChildren();for(const o of s){const a=o[0],c=o[1],d=(o[2]?o[2]:TYPO3.lang.label_allrecordtypes)+" ("+c+")",m=document.createElement("option");m.value=a,m.textContent=d,r.push(m)}return r.length>0&&(e.append(...r),TYPO3.settings.Recycler.tableSelection!==""&&(e.value=TYPO3.settings.Recycler.tableSelection)),l}).finally(()=>h.done())}async loadDeletedElements(){const e=document.querySelector(n.depthSelector),t=document.querySelector(n.tableSelector),l=document.querySelector(n.searchText);return h.start(),this.resetMassActionButtons(),new P(TYPO3.settings.ajaxUrls.recycler).withQueryArguments({action:"getDeletedRecords",depth:e.value,startUid:TYPO3.settings.Recycler.startUid,table:t.value,filterTxt:l.value,start:(this.paging.currentPage-1)*this.paging.itemsPerPage,limit:this.paging.itemsPerPage}).get().then(async s=>{const r=document.querySelector(n.recyclerTable),o=r.querySelector("tbody"),a=await s.resolve();if(a.totalItems===0){if(r.parentElement.querySelector("#no-recycler-records")===null){const c=document.createElement("typo3-backend-alert");c.id="no-recycler-records",c.severity=f.info,c.message=TYPO3.lang["alert.noDeletedRecords"],c.showIcon=!0,r.parentElement.insertBefore(c,r)}}else r.parentElement.querySelector("#no-recycler-records")?.remove(),o.innerHTML=a.rows;return r.toggleAttribute("hidden",a.totalItems===0),this.buildPaginator(a.totalItems),s}).finally(()=>h.done())}deleteRecord(e,t){if(TYPO3.settings.Recycler.deleteDisable)return;const s=(t||e.target).closest("tr"),r=s===null||s.parentElement.tagName!=="TBODY";let o,a;if(r)o=this.markedRecordsForMassAction,a=TYPO3.lang["modal.massdelete.text"];else{const c=s.dataset.uid,g=s.dataset.table,d=s.dataset.recordtitle;o=[g+":"+c],a=g==="pages"?TYPO3.lang["modal.deletepage.text"]:TYPO3.lang["modal.deletecontent.text"],a=this.createMessage(a,[d,"["+o[0]+"]"])}T.advanced({title:TYPO3.lang["modal.delete.header"],content:a,severity:f.error,staticBackdrop:!0,buttons:[{text:TYPO3.lang["button.cancel"],btnClass:"btn-default",trigger:function(){T.dismiss()}},{text:TYPO3.lang["button.delete"],btnClass:"btn-danger",action:new x(()=>{this.callAjaxAction("delete",o,r)})}]})}undoRecord(e,t){const s=(t||e.target).closest("tr"),r=s===null||s.parentElement.tagName!=="TBODY";let o,a,c;if(r)o=this.markedRecordsForMassAction,a=TYPO3.lang["modal.massundo.text"],c=!0;else{const d=s.dataset.uid,m=s.dataset.table,p=s.dataset.recordtitle;o=[m+":"+d],c=m==="pages",a=c?TYPO3.lang["modal.undopage.text"]:TYPO3.lang["modal.undocontent.text"],a=this.createMessage(a,[p,"["+o[0]+"]"]),c&&s.dataset.parentDeleted&&(a+=TYPO3.lang["modal.undo.parentpages"])}let g=null;if(c){const d=document.createElement("div"),m=document.createElement("p");m.textContent=a;const p=document.createElement("div");p.classList.add("form-check");const b=document.createElement("input");b.type="checkbox",b.id="undo-recursive",b.classList.add("form-check-input");const y=document.createElement("label");y.classList.add("form-check-label"),y.htmlFor="undo-recursive",y.textContent=TYPO3.lang["modal.undo.recursive"],p.append(b,y),d.append(m,p),g=d}else{const d=document.createElement("p");d.textContent=a,g=d}T.advanced({title:TYPO3.lang["modal.undo.header"],content:g,severity:f.ok,staticBackdrop:!0,buttons:[{text:TYPO3.lang["button.cancel"],btnClass:"btn-default",trigger:function(){T.dismiss()}},{text:TYPO3.lang["button.undo"],btnClass:"btn-success",action:new x(()=>{this.callAjaxAction("undo",typeof o=="object"?o:[o],r,g.querySelector("#undo-recursive")?.checked)})}]})}async callAjaxAction(e,t,l,s=!1){const r={records:t,action:""};let o=!1;if(e==="undo")r.action="undoRecords",r.recursive=s?1:0,o=!0;else if(e==="delete")r.action="deleteRecords";else return null;return h.start(),new P(TYPO3.settings.ajaxUrls.recycler).post(r).then(async a=>{const c=await a.resolve();return c.success?v.success("",c.message):v.error("",c.message),this.paging.currentPage=1,this.loadAvailableTables().then(()=>{this.loadDeletedElements(),l&&this.resetMassActionButtons(),o&&S.refreshPageTree()}),a})}createMessage(e,t){return typeof e>"u"?"":e.replace(/\{([0-9]+)\}/g,function(l,s){return t[s]})}buildPaginator(e){const t=document.querySelector(n.paginator);if(e===0){t.replaceChildren();return}if(this.paging.totalItems=e,this.paging.totalPages=Math.ceil(e/this.paging.itemsPerPage),this.paging.totalPages===1){t.replaceChildren();return}const l=document.createElement("typo3-backend-pagination");l.paging=this.paging,t.replaceChildren(l)}}var O=new S;export{O as default};
