/*
 * This file is part of the TYPO3 CMS project.
 *
 * It is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License, either version 2
 * of the License, or any later version.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 *
 * The TYPO3 project - inspiring people to share!
 */
import"bootstrap";import $ from"jquery";import{AbstractInteractableModule}from"@typo3/install/module/abstract-interactable-module.js";import Notification from"@typo3/backend/notification.js";import AjaxRequest from"@typo3/core/ajax/ajax-request.js";import SecurityUtility from"@typo3/core/security-utility.js";import FlashMessage from"@typo3/install/renderable/flash-message.js";import InfoBox from"@typo3/install/renderable/info-box.js";import ProgressBar from"@typo3/install/renderable/progress-bar.js";import Severity from"@typo3/install/renderable/severity.js";import Router from"@typo3/install/router.js";class UpgradeWizards extends AbstractInteractableModule{constructor(){super(),this.selectorOutputWizardsContainer=".t3js-upgradeWizards-wizards-output",this.selectorOutputDoneContainer=".t3js-upgradeWizards-done-output",this.selectorWizardsBlockingAddsTemplate=".t3js-upgradeWizards-blocking-adds-template",this.selectorWizardsBlockingAddsRows=".t3js-upgradeWizards-blocking-adds-rows",this.selectorWizardsBlockingAddsExecute=".t3js-upgradeWizards-blocking-adds-execute",this.selectorWizardsBlockingCharsetTemplate=".t3js-upgradeWizards-blocking-charset-template",this.selectorWizardsBlockingCharsetFix=".t3js-upgradeWizards-blocking-charset-fix",this.selectorWizardsDoneBodyTemplate=".t3js-upgradeWizards-done-body-template",this.selectorWizardsDoneRows=".t3js-upgradeWizards-done-rows",this.selectorWizardsDoneRowTemplate=".t3js-upgradeWizards-done-row-template table tr",this.selectorWizardsDoneRowMarkUndone=".t3js-upgradeWizards-done-markUndone",this.selectorWizardsDoneRowTitle=".t3js-upgradeWizards-done-title",this.selectorWizardsListTemplate=".t3js-upgradeWizards-list-template",this.selectorWizardsListRows=".t3js-upgradeWizards-list-rows",this.selectorWizardsListRowTemplate=".t3js-upgradeWizards-list-row-template",this.selectorWizardsListRowTitle=".t3js-upgradeWizards-list-row-title",this.selectorWizardsListRowExplanation=".t3js-upgradeWizards-list-row-explanation",this.selectorWizardsListRowExecute=".t3js-upgradeWizards-list-row-execute",this.selectorWizardsInputTemplate=".t3js-upgradeWizards-input",this.selectorWizardsInputTitle=".t3js-upgradeWizards-input-title",this.selectorWizardsInputDescription=".t3js-upgradeWizards-input-description",this.selectorWizardsInputHtml=".t3js-upgradeWizards-input-html",this.selectorWizardsInputPerform=".t3js-upgradeWizards-input-perform",this.selectorWizardsInputAbort=".t3js-upgradeWizards-input-abort",this.securityUtility=new SecurityUtility}static removeLoadingMessage(e){e.find(".t3js-progressbar").remove()}static renderProgressBar(e){return ProgressBar.render(Severity.loading,e,"")}initialize(e){this.currentModal=e,this.getData().then(()=>{this.doneUpgrades()}),e.on("click",this.selectorWizardsDoneRowMarkUndone,e=>{this.markUndone(e.target.dataset.identifier)}),e.on("click",this.selectorWizardsBlockingCharsetFix,()=>{this.blockingUpgradesDatabaseCharsetFix()}),e.on("click",this.selectorWizardsBlockingAddsExecute,()=>{this.blockingUpgradesDatabaseAddsExecute()}),e.on("click",this.selectorWizardsListRowExecute,e=>{this.wizardInput(e.target.dataset.identifier,e.target.dataset.title)}),e.on("click",this.selectorWizardsInputPerform,e=>{this.wizardExecute(e.target.dataset.identifier,e.target.dataset.title)}),e.on("click",this.selectorWizardsInputAbort,()=>{this.findInModal(this.selectorOutputWizardsContainer).empty(),this.wizardsList()})}getData(){const e=this.getModalBody(),t=this.findInModal(this.selectorOutputWizardsContainer);return new AjaxRequest(Router.getUrl("upgradeWizardsGetData")).get({cache:"no-cache"}).then(async t=>{const s=await t.resolve();!0===s.success?(e.empty().append(s.html),this.blockingUpgradesDatabaseCharsetTest()):Notification.error("Something went wrong","The request was not processed successfully. Please check the browser's console and TYPO3's log.")},e=>{Router.handleAjaxError(e,t)})}blockingUpgradesDatabaseCharsetTest(){const e=this.getModalBody(),t=this.findInModal(this.selectorOutputWizardsContainer);t.empty().append(UpgradeWizards.renderProgressBar("Checking database charset...")),new AjaxRequest(Router.getUrl("upgradeWizardsBlockingDatabaseCharsetTest")).get({cache:"no-cache"}).then(async s=>{const r=await s.resolve();UpgradeWizards.removeLoadingMessage(t),!0===r.success&&(!0===r.needsUpdate?e.find(this.selectorOutputWizardsContainer).append(e.find(this.selectorWizardsBlockingCharsetTemplate)).clone():this.blockingUpgradesDatabaseAdds())},e=>{Router.handleAjaxError(e,t)})}blockingUpgradesDatabaseCharsetFix(){const e=$(this.selectorOutputWizardsContainer);e.empty().append(UpgradeWizards.renderProgressBar("Setting database charset to UTF-8...")),new AjaxRequest(Router.getUrl("upgradeWizardsBlockingDatabaseCharsetFix")).get({cache:"no-cache"}).then(async t=>{const s=await t.resolve();if(UpgradeWizards.removeLoadingMessage(e),!0===s.success)Array.isArray(s.status)&&s.status.length>0&&s.status.forEach(t=>{const s=InfoBox.render(t.severity,t.title,t.message);e.append(s)});else{const t=FlashMessage.render(Severity.error,"Something went wrong","");UpgradeWizards.removeLoadingMessage(e),e.append(t)}},t=>{Router.handleAjaxError(t,e)})}blockingUpgradesDatabaseAdds(){const e=this.getModalBody(),t=this.findInModal(this.selectorOutputWizardsContainer);t.empty().append(UpgradeWizards.renderProgressBar("Check for missing mandatory database tables and fields...")),new AjaxRequest(Router.getUrl("upgradeWizardsBlockingDatabaseAdds")).get({cache:"no-cache"}).then(async s=>{const r=await s.resolve();if(UpgradeWizards.removeLoadingMessage(t),!0===r.success)if(!0===r.needsUpdate){const t=e.find(this.selectorWizardsBlockingAddsTemplate).clone();"object"==typeof r.adds.tables&&r.adds.tables.forEach(e=>{const s="Table: "+this.securityUtility.encodeHtml(e.table);t.find(this.selectorWizardsBlockingAddsRows).append(s,"<br>")}),"object"==typeof r.adds.columns&&r.adds.columns.forEach(e=>{const s="Table: "+this.securityUtility.encodeHtml(e.table)+", Field: "+this.securityUtility.encodeHtml(e.field);t.find(this.selectorWizardsBlockingAddsRows).append(s,"<br>")}),"object"==typeof r.adds.indexes&&r.adds.indexes.forEach(e=>{const s="Table: "+this.securityUtility.encodeHtml(e.table)+", Index: "+this.securityUtility.encodeHtml(e.index);t.find(this.selectorWizardsBlockingAddsRows).append(s,"<br>")}),e.find(this.selectorOutputWizardsContainer).append(t)}else this.wizardsList();else Notification.error("Something went wrong","The request was not processed successfully. Please check the browser's console and TYPO3's log.")},e=>{Router.handleAjaxError(e,t)})}blockingUpgradesDatabaseAddsExecute(){const e=this.findInModal(this.selectorOutputWizardsContainer);e.empty().append(UpgradeWizards.renderProgressBar("Adding database tables and fields...")),new AjaxRequest(Router.getUrl("upgradeWizardsBlockingDatabaseExecute")).get({cache:"no-cache"}).then(async t=>{const s=await t.resolve();if(UpgradeWizards.removeLoadingMessage(e),Array.isArray(s.status)&&s.status.length>0&&s.status.forEach(t=>{const s=InfoBox.render(t.severity,t.title,t.message);e.append(s)}),!0===s.success)this.wizardsList();else if(Array.isArray(s.status)&&0!==s.status.length){const t=$('<div class="btn-toolbar mt-3 mb-4"></div>'),s=$('<button class="btn btn-default">Retry database migration</button>'),r=$('<button class="btn btn-danger">Proceed despite of errors</button>');s.click(()=>{this.blockingUpgradesDatabaseAddsExecute()}),r.click(()=>{t.remove(),this.wizardsList()}),t.append(s),t.append(r),e.append(t)}else{const t=FlashMessage.render(Severity.error,"Something went wrong","");e.append(t)}},t=>{Router.handleAjaxError(t,e)})}wizardsList(){const e=this.getModalBody(),t=this.findInModal(this.selectorOutputWizardsContainer);t.append(UpgradeWizards.renderProgressBar("Loading upgrade wizards...")),new AjaxRequest(Router.getUrl("upgradeWizardsList")).get({cache:"no-cache"}).then(async s=>{const r=await s.resolve();UpgradeWizards.removeLoadingMessage(t);const a=e.find(this.selectorWizardsListTemplate).clone();if(a.removeClass("t3js-upgradeWizards-list-template"),!0===r.success){let t=0,s=0;Array.isArray(r.wizards)&&r.wizards.length>0&&(s=r.wizards.length,r.wizards.forEach(s=>{if(!0===s.shouldRenderWizard){const r=e.find(this.selectorWizardsListRowTemplate).clone();t+=1,r.removeClass("t3js-upgradeWizards-list-row-template"),r.find(this.selectorWizardsListRowTitle).empty().text(s.title),r.find(this.selectorWizardsListRowExplanation).empty().text(s.explanation),r.find(this.selectorWizardsListRowExecute).attr("data-identifier",s.identifier).attr("data-title",s.title),a.find(this.selectorWizardsListRows).append(r)}}),a.find(this.selectorWizardsListRows+" hr:last").remove());let i=100;const o=a.find(".progress"),n=o.find(".progress-bar");t>0?i=Math.round((s-t)/r.wizards.length*100):n.removeClass("progress-bar-info").addClass("progress-bar-success"),o.attr("aria-valuenow",String(i)),n.removeClass("progress-bar-striped").css("width",i+"%").attr("aria-valuenow",String(i)).text(i+"%"),e.find(this.selectorOutputWizardsContainer).append(a),this.findInModal(this.selectorWizardsDoneRowMarkUndone).prop("disabled",!1)}else Notification.error("Something went wrong","The request was not processed successfully. Please check the browser's console and TYPO3's log.")},e=>{Router.handleAjaxError(e,t)})}wizardInput(e,t){const s=this.getModuleContent().data("upgrade-wizards-input-token"),r=this.getModalBody(),a=this.findInModal(this.selectorOutputWizardsContainer);a.empty().append(UpgradeWizards.renderProgressBar('Loading "'+t+'"...')),r.animate({scrollTop:r.scrollTop()-Math.abs(r.find(".t3js-upgrade-status-section").position().top)},250),new AjaxRequest(Router.getUrl("upgradeWizardsInput")).post({install:{action:"upgradeWizardsInput",token:s,identifier:e}}).then(async e=>{const t=await e.resolve();a.empty();const s=r.find(this.selectorWizardsInputTemplate).clone();s.removeClass("t3js-upgradeWizards-input"),!0===t.success&&(Array.isArray(t.status)&&t.status.forEach(e=>{const t=FlashMessage.render(e.severity,e.title,e.message);a.append(t)}),t.userInput.wizardHtml.length>0&&s.find(this.selectorWizardsInputHtml).html(t.userInput.wizardHtml),s.find(this.selectorWizardsInputTitle).text(t.userInput.title),s.find(this.selectorWizardsInputDescription).html(this.securityUtility.stripHtml(t.userInput.description).replace(/\n/g,"<br>")),s.find(this.selectorWizardsInputPerform).attr("data-identifier",t.userInput.identifier).attr("data-title",t.userInput.title)),r.find(this.selectorOutputWizardsContainer).append(s)},e=>{Router.handleAjaxError(e,a)})}wizardExecute(e,t){const s=this.getModuleContent().data("upgrade-wizards-execute-token"),r=this.getModalBody(),a={"install[action]":"upgradeWizardsExecute","install[token]":s,"install[identifier]":e};for(const e of this.findInModal(this.selectorOutputWizardsContainer+" form").serializeArray())a[e.name]=e.value;const i=this.findInModal(this.selectorOutputWizardsContainer);i.empty().append(UpgradeWizards.renderProgressBar('Executing "'+t+'"...')),this.findInModal(this.selectorWizardsDoneRowMarkUndone).prop("disabled",!0),new AjaxRequest(Router.getUrl()).post(a).then(async e=>{const t=await e.resolve();i.empty(),!0===t.success?(Array.isArray(t.status)&&t.status.forEach(e=>{const t=InfoBox.render(e.severity,e.title,e.message);i.append(t)}),this.wizardsList(),r.find(this.selectorOutputDoneContainer).empty(),this.doneUpgrades()):Notification.error("Something went wrong","The request was not processed successfully. Please check the browser's console and TYPO3's log.")},e=>{Router.handleAjaxError(e,i)})}doneUpgrades(){const e=this.getModalBody(),t=e.find(this.selectorOutputDoneContainer);t.empty().append(UpgradeWizards.renderProgressBar("Loading executed upgrade wizards...")),new AjaxRequest(Router.getUrl("upgradeWizardsDoneUpgrades")).get({cache:"no-cache"}).then(async s=>{const r=await s.resolve();if(UpgradeWizards.removeLoadingMessage(t),!0===r.success){Array.isArray(r.status)&&r.status.length>0&&r.status.forEach(e=>{const s=InfoBox.render(e.severity,e.title,e.message);t.append(s)});const s=e.find(this.selectorWizardsDoneBodyTemplate).clone(),a=s.find(this.selectorWizardsDoneRows);let i=!1;Array.isArray(r.wizardsDone)&&r.wizardsDone.length>0&&r.wizardsDone.forEach(t=>{i=!0;const s=e.find(this.selectorWizardsDoneRowTemplate).clone();s.find(this.selectorWizardsDoneRowMarkUndone).attr("data-identifier",t.identifier),s.find(this.selectorWizardsDoneRowTitle).text(t.title),a.append(s)}),Array.isArray(r.rowUpdatersDone)&&r.rowUpdatersDone.length>0&&r.rowUpdatersDone.forEach(t=>{i=!0;const s=e.find(this.selectorWizardsDoneRowTemplate).clone();s.find(this.selectorWizardsDoneRowMarkUndone).attr("data-identifier",t.identifier),s.find(this.selectorWizardsDoneRowTitle).text(t.title),a.append(s)}),i&&(e.find(this.selectorOutputDoneContainer).append(s),this.findInModal(this.selectorWizardsDoneRowMarkUndone).prop("disabled",!0))}else Notification.error("Something went wrong","The request was not processed successfully. Please check the browser's console and TYPO3's log.")},e=>{Router.handleAjaxError(e,t)})}markUndone(e){const t=this.getModuleContent().data("upgrade-wizards-mark-undone-token"),s=this.getModalBody(),r=this.findInModal(this.selectorOutputDoneContainer);r.empty().append(UpgradeWizards.renderProgressBar("Marking upgrade wizard as undone...")),new AjaxRequest(Router.getUrl()).post({install:{action:"upgradeWizardsMarkUndone",token:t,identifier:e}}).then(async e=>{const t=await e.resolve();r.empty(),s.find(this.selectorOutputDoneContainer).empty(),!0===t.success&&Array.isArray(t.status)?t.status.forEach(e=>{Notification.success(e.title,e.message),this.doneUpgrades(),this.blockingUpgradesDatabaseCharsetTest()}):Notification.error("Something went wrong","The request was not processed successfully. Please check the browser's console and TYPO3's log.")},e=>{Router.handleAjaxError(e,r)})}}export default new UpgradeWizards;