
SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

--
-- Database: `traq383`
--

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]attachments`
--

CREATE TABLE `[[dbprefix]]attachments` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `contents` longtext COLLATE utf8_unicode_ci NOT NULL,
  `type` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `size` bigint(20) NOT NULL,
  `user_id` bigint(20) NOT NULL,
  `ticket_id` bigint(20) NOT NULL,
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]components`
--

CREATE TABLE `[[dbprefix]]components` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `project_id` bigint(20) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]custom_fields`
--

CREATE TABLE `[[dbprefix]]custom_fields` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `slug` varchar(255) NOT NULL,
  `type` varchar(255) NOT NULL DEFAULT 'text',
  `values` longtext,
  `multiple` tinyint(1) NOT NULL DEFAULT '0',
  `default_value` varchar(255) DEFAULT NULL,
  `regex` varchar(255) DEFAULT NULL,
  `min_length` int(11) DEFAULT NULL,
  `max_length` int(11) DEFAULT NULL,
  `is_required` tinyint(1) NOT NULL DEFAULT '0',
  `project_id` int(11) NOT NULL,
  `ticket_type_ids` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]custom_field_values`
--

CREATE TABLE `[[dbprefix]]custom_field_values` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `custom_field_id` bigint(20) NOT NULL,
  `ticket_id` bigint(20) NOT NULL,
  `value` text,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]milestones`
--

CREATE TABLE `[[dbprefix]]milestones` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `slug` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `codename` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `info` longtext COLLATE utf8_unicode_ci NOT NULL,
  `changelog` longtext COLLATE utf8_unicode_ci,
  `due` datetime DEFAULT NULL,
  `completed_on` datetime DEFAULT NULL,
  `status` int(1) NOT NULL DEFAULT '1',
  `is_locked` smallint(6) NOT NULL DEFAULT '0',
  `project_id` bigint(20) NOT NULL,
  `displayorder` bigint(20) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]permissions`
--

CREATE TABLE `[[dbprefix]]permissions` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `project_id` bigint(20) NOT NULL DEFAULT '0',
  `type` varchar(255) DEFAULT NULL,
  `type_id` bigint(20) NOT NULL DEFAULT '0',
  `action` varchar(255) NOT NULL DEFAULT '',
  `value` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=108 ;

--
-- Dumping data for table `[[dbprefix]]permissions`
--

INSERT INTO `[[dbprefix]]permissions` VALUES
(1, 0, 'usergroup', 0, 'view', 1),
(2, 0, 'usergroup', 0, 'project_settings', 0),
(3, 0, 'usergroup', 0, 'delete_timeline_events', 0),
(4, 0, 'usergroup', 0, 'view_tickets', 1),
(5, 0, 'usergroup', 0, 'create_tickets', 1),
(6, 0, 'usergroup', 0, 'update_tickets', 1),
(7, 0, 'usergroup', 0, 'delete_tickets', 0),
(8, 0, 'usergroup', 0, 'move_tickets', 0),
(9, 0, 'usergroup', 0, 'comment_on_tickets', 1),
(10, 0, 'usergroup', 0, 'edit_ticket_description', 0),
(11, 0, 'usergroup', 0, 'vote_on_tickets', 1),
(12, 0, 'usergroup', 0, 'add_attachments', 1),
(13, 0, 'usergroup', 0, 'view_attachments', 1),
(14, 0, 'usergroup', 0, 'delete_attachments', 0),
(15, 0, 'usergroup', 0, 'perform_mass_actions', 0),
(16, 0, 'usergroup', 0, 'ticket_properties_set_assigned_to', 0),
(17, 0, 'usergroup', 0, 'ticket_properties_set_milestone', 0),
(18, 0, 'usergroup', 0, 'ticket_properties_set_version', 0),
(19, 0, 'usergroup', 0, 'ticket_properties_set_component', 0),
(20, 0, 'usergroup', 0, 'ticket_properties_set_severity', 0),
(21, 0, 'usergroup', 0, 'ticket_properties_set_priority', 0),
(22, 0, 'usergroup', 0, 'ticket_properties_set_status', 0),
(23, 0, 'usergroup', 0, 'ticket_properties_set_tasks', 0),
(24, 0, 'usergroup', 0, 'ticket_properties_set_related_tickets', 0),
(25, 0, 'usergroup', 0, 'ticket_properties_set_time_proposed', 0),
(26, 0, 'usergroup', 0, 'ticket_properties_set_time_worked', 0),
(27, 0, 'usergroup', 0, 'ticket_properties_change_type', 0),
(28, 0, 'usergroup', 0, 'ticket_properties_change_assigned_to', 0),
(29, 0, 'usergroup', 0, 'ticket_properties_change_milestone', 0),
(30, 0, 'usergroup', 0, 'ticket_properties_change_version', 0),
(31, 0, 'usergroup', 0, 'ticket_properties_change_component', 1),
(32, 0, 'usergroup', 0, 'ticket_properties_change_severity', 0),
(33, 0, 'usergroup', 0, 'ticket_properties_change_priority', 0),
(34, 0, 'usergroup', 0, 'ticket_properties_change_status', 0),
(35, 0, 'usergroup', 0, 'ticket_properties_change_summary', 0),
(36, 0, 'usergroup', 0, 'ticket_properties_change_tasks', 0),
(37, 0, 'usergroup', 0, 'ticket_properties_change_related_tickets', 0),
(38, 0, 'usergroup', 0, 'ticket_properties_change_time_proposed', 0),
(39, 0, 'usergroup', 0, 'ticket_properties_change_time_worked', 0),
(40, 0, 'usergroup', 0, 'ticket_properties_complete_tasks', 0),
(41, 0, 'usergroup', 0, 'edit_ticket_history', 0),
(42, 0, 'usergroup', 0, 'delete_ticket_history', 0),
(43, 0, 'usergroup', 0, 'create_wiki_page', 0),
(44, 0, 'usergroup', 0, 'edit_wiki_page', 0),
(45, 0, 'usergroup', 0, 'delete_wiki_page', 0),
(46, 0, 'usergroup', 3, 'create_tickets', 0),
(47, 0, 'usergroup', 3, 'comment_on_tickets', 0),
(48, 0, 'usergroup', 3, 'update_tickets', 0),
(49, 0, 'usergroup', 3, 'vote_on_tickets', 0),
(50, 0, 'usergroup', 3, 'add_attachments', 0),
(51, 0, 'role', 0, 'view', 1),
(52, 0, 'role', 0, 'project_settings', 0),
(53, 0, 'role', 0, 'delete_timeline_events', 0),
(54, 0, 'role', 0, 'view_tickets', 1),
(55, 0, 'role', 0, 'create_tickets', 1),
(56, 0, 'role', 0, 'update_tickets', 1),
(57, 0, 'role', 0, 'delete_tickets', 0),
(58, 0, 'role', 0, 'move_tickets', 0),
(59, 0, 'role', 0, 'comment_on_tickets', 1),
(60, 0, 'role', 0, 'edit_ticket_description', 0),
(61, 0, 'role', 0, 'vote_on_tickets', 1),
(62, 0, 'role', 0, 'add_attachments', 1),
(63, 0, 'role', 0, 'view_attachments', 1),
(64, 0, 'role', 0, 'delete_attachments', 0),
(65, 0, 'role', 0, 'perform_mass_actions', 0),
(66, 0, 'role', 0, 'ticket_properties_set_assigned_to', 1),
(67, 0, 'role', 0, 'ticket_properties_set_milestone', 1),
(68, 0, 'role', 0, 'ticket_properties_set_version', 1),
(69, 0, 'role', 0, 'ticket_properties_set_component', 1),
(70, 0, 'role', 0, 'ticket_properties_set_severity', 1),
(71, 0, 'role', 0, 'ticket_properties_set_priority', 1),
(72, 0, 'role', 0, 'ticket_properties_set_status', 1),
(73, 0, 'role', 0, 'ticket_properties_set_tasks', 1),
(74, 0, 'role', 0, 'ticket_properties_set_related_tickets', 1),
(75, 0, 'role', 0, 'ticket_properties_set_time_proposed', 1),
(76, 0, 'role', 0, 'ticket_properties_set_time_worked', 1),
(77, 0, 'role', 0, 'ticket_properties_change_type', 1),
(78, 0, 'role', 0, 'ticket_properties_change_assigned_to', 1),
(79, 0, 'role', 0, 'ticket_properties_change_milestone', 1),
(80, 0, 'role', 0, 'ticket_properties_change_version', 1),
(81, 0, 'role', 0, 'ticket_properties_change_component', 1),
(82, 0, 'role', 0, 'ticket_properties_change_severity', 1),
(83, 0, 'role', 0, 'ticket_properties_change_priority', 1),
(84, 0, 'role', 0, 'ticket_properties_change_status', 1),
(85, 0, 'role', 0, 'ticket_properties_change_summary', 1),
(86, 0, 'role', 0, 'ticket_properties_change_tasks', 1),
(87, 0, 'role', 0, 'ticket_properties_change_related_tickets', 1),
(88, 0, 'role', 0, 'ticket_properties_change_time_proposed', 1),
(89, 0, 'role', 0, 'ticket_properties_change_time_worked', 1),
(90, 0, 'role', 0, 'ticket_properties_complete_tasks', 1),
(91, 0, 'role', 0, 'edit_ticket_history', 0),
(92, 0, 'role', 0, 'delete_ticket_history', 0),
(93, 0, 'role', 0, 'create_wiki_page', 0),
(94, 0, 'role', 0, 'edit_wiki_page', 0),
(95, 0, 'role', 0, 'delete_wiki_page', 0),
(96, 0, 'role', 1, 'project_settings', 1),
(97, 0, 'role', 1, 'delete_timeline_events', 1),
(98, 0, 'role', 1, 'delete_tickets', 1),
(99, 0, 'role', 1, 'move_tickets', 1),
(100, 0, 'role', 1, 'edit_ticket_description', 1),
(101, 0, 'role', 1, 'delete_attachments', 1),
(102, 0, 'role', 1, 'edit_ticket_history', 1),
(103, 0, 'role', 1, 'delete_ticket_history', 1),
(104, 0, 'role', 1, 'perform_mass_actions', 1),
(105, 0, 'role', 1, 'create_wiki_page', 1),
(106, 0, 'role', 1, 'edit_wiki_page', 1),
(107, 0, 'role', 1, 'delete_wiki_page', 1);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]plugins`
--

CREATE TABLE `[[dbprefix]]plugins` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `file` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `enabled` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]plugins`
--

INSERT INTO `[[dbprefix]]plugins` VALUES
(1, 'markdown', 1);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]priorities`
--

CREATE TABLE `[[dbprefix]]priorities` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=6 ;

--
-- Dumping data for table `[[dbprefix]]priorities`
--

INSERT INTO `[[dbprefix]]priorities` VALUES
(1, 'Highest'),
(2, 'High'),
(3, 'Normal'),
(4, 'Low'),
(5, 'Lowest');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]projects`
--

CREATE TABLE `[[dbprefix]]projects` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `slug` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `codename` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `info` longtext COLLATE utf8_unicode_ci NOT NULL,
  `next_tid` bigint(20) NOT NULL DEFAULT '1',
  `enable_wiki` tinyint(1) NOT NULL DEFAULT '0',
  `default_ticket_type_id` int(11) DEFAULT NULL,
  `default_ticket_sorting` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'priority.asc',
  `displayorder` bigint(20) NOT NULL DEFAULT '0',
  `private_key` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]project_roles`
--

CREATE TABLE `[[dbprefix]]project_roles` (
  `id` int(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) DEFAULT NULL,
  `assignable` varchar(255) NOT NULL DEFAULT '1',
  `project_id` bigint(20) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=4 ;

--
-- Dumping data for table `[[dbprefix]]project_roles`
--

INSERT INTO `[[dbprefix]]project_roles` VALUES
(1, 'Manager', '1', 0),
(2, 'Developer', '1', 0),
(3, 'Tester', '0', 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]settings`
--

CREATE TABLE `[[dbprefix]]settings` (
  `setting` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `value` longtext COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`setting`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `[[dbprefix]]settings`
--

INSERT INTO `[[dbprefix]]settings` VALUES
('allow_registration', '1'),
('anonymous_user_id', '2'),
('check_for_update', '1'),
('date_format', 'd/m/Y'),
('date_time_format', 'g:iA d/m/Y'),
('db_version', '30800'),
('email_validation', '0'),
('locale', 'enus'),
('mailer_config', 'config'),
('mailer_dsn', 'sendmail://default'),
('notification_from_email', 'noreply@[[domhost]]'),
('site_name', ''),
('site_url', ''),
('theme', 'default'),
('ticket_creation_delay', '30'),
('ticket_history_sorting', 'oldest_first'),
('tickets_per_page', '25'),
('timeline_day_format', 'l, jS F Y'),
('timeline_days_per_page', '7'),
('timeline_time_format', 'h:iA'),
('title', '[[site_name]]');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]severities`
--

CREATE TABLE `[[dbprefix]]severities` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=7 ;

--
-- Dumping data for table `[[dbprefix]]severities`
--

INSERT INTO `[[dbprefix]]severities` VALUES
(1, 'Blocker'),
(2, 'Critical'),
(3, 'Major'),
(4, 'Normal'),
(5, 'Minor'),
(6, 'Trivial');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]statuses`
--

CREATE TABLE `[[dbprefix]]statuses` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `status` smallint(6) NOT NULL,
  `changelog` smallint(6) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=6 ;

--
-- Dumping data for table `[[dbprefix]]statuses`
--

INSERT INTO `[[dbprefix]]statuses` VALUES
(1, 'New', 1, 0),
(2, 'Accepted', 1, 0),
(3, 'Started', 2, 0),
(4, 'Closed', 0, 1),
(5, 'Completed', 0, 1);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]subscriptions`
--

CREATE TABLE `[[dbprefix]]subscriptions` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `type` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL,
  `user_id` bigint(20) NOT NULL,
  `project_id` bigint(20) NOT NULL,
  `object_id` bigint(20) NOT NULL,
  `uuid` varchar(36) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]tickets`
--

CREATE TABLE `[[dbprefix]]tickets` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `ticket_id` bigint(20) NOT NULL,
  `summary` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `body` longtext COLLATE utf8_unicode_ci NOT NULL,
  `user_id` bigint(20) NOT NULL,
  `project_id` bigint(20) NOT NULL,
  `milestone_id` bigint(20) NOT NULL DEFAULT '0',
  `version_id` bigint(20) NOT NULL,
  `component_id` bigint(20) NOT NULL,
  `type_id` bigint(20) NOT NULL,
  `status_id` bigint(20) NOT NULL DEFAULT '1',
  `priority_id` bigint(20) NOT NULL DEFAULT '3',
  `severity_id` bigint(20) NOT NULL,
  `assigned_to_id` bigint(20) NOT NULL,
  `is_closed` bigint(20) NOT NULL DEFAULT '0',
  `is_private` smallint(6) NOT NULL DEFAULT '0',
  `votes` bigint(20) DEFAULT '0',
  `tasks` longtext COLLATE utf8_unicode_ci,
  `extra` longtext COLLATE utf8_unicode_ci NOT NULL,
  `time_proposed` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `time_worked` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]ticket_history`
--

CREATE TABLE `[[dbprefix]]ticket_history` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) NOT NULL,
  `ticket_id` bigint(20) NOT NULL,
  `changes` longtext COLLATE utf8_unicode_ci NOT NULL,
  `comment` longtext COLLATE utf8_unicode_ci NOT NULL,
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]ticket_relationships`
--

CREATE TABLE `[[dbprefix]]ticket_relationships` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `ticket_id` bigint(20) NOT NULL,
  `related_ticket_id` bigint(20) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]timeline`
--

CREATE TABLE `[[dbprefix]]timeline` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `project_id` bigint(20) NOT NULL,
  `owner_id` bigint(20) NOT NULL,
  `action` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `data` longtext COLLATE utf8_unicode_ci,
  `user_id` bigint(20) NOT NULL,
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]types`
--

CREATE TABLE `[[dbprefix]]types` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `bullet` varchar(10) COLLATE utf8_unicode_ci NOT NULL,
  `changelog` smallint(6) NOT NULL DEFAULT '1',
  `template` longtext COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=5 ;

--
-- Dumping data for table `[[dbprefix]]types`
--

INSERT INTO `[[dbprefix]]types` VALUES
(1, 'Defect', '-', 1, ''),
(2, 'Feature Request', '+', 1, ''),
(3, 'Enhancement', '*', 1, ''),
(4, 'Task', '*', 1, '');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]usergroups`
--

CREATE TABLE `[[dbprefix]]usergroups` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `is_admin` smallint(6) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=4 ;

--
-- Dumping data for table `[[dbprefix]]usergroups`
--

INSERT INTO `[[dbprefix]]usergroups` VALUES
(1, 'Administrators', 1),
(2, 'Members', 0),
(3, 'Guests', 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]users`
--

CREATE TABLE `[[dbprefix]]users` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `username` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `password` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `password_ver` varchar(25) COLLATE utf8_unicode_ci DEFAULT 'crypt',
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `email` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `group_id` bigint(20) NOT NULL DEFAULT '2',
  `locale` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `options` text COLLATE utf8_unicode_ci,
  `login_hash` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '0',
  `api_key` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=3 ;

--
-- Dumping data for table `[[dbprefix]]users`
--

INSERT INTO `[[dbprefix]]users` VALUES
(1, '[[admin_username]]', '[[admin_pass]]', 'crypt', '[[admin_realname]]', '[[admin_email]]', 1, NULL, NULL, '[[login_hash]]', NULL, '[[regtime]]'),
(2, 'Anonymous', '$2a$10$115c34ce492354980a71eudSFercXy.a1mLGfPG3hFDgLRttkj2J2', 'crypt', 'Anonymous', 'anonymous0.31454500 [[timestamp]]@[[domhost]]', 3, 'enUS', '{"watch_created_tickets":null}', 'ba2123dc6babeb01407799f2330e79b9616daa3f', NULL, '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]user_roles`
--

CREATE TABLE `[[dbprefix]]user_roles` (
  `id` int(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(20) DEFAULT NULL,
  `project_id` int(20) DEFAULT NULL,
  `project_role_id` int(20) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]wiki`
--

CREATE TABLE `[[dbprefix]]wiki` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `project_id` bigint(20) NOT NULL,
  `title` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `slug` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `main` smallint(6) NOT NULL DEFAULT '0',
  `revision_id` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]wiki_revisions`
--

CREATE TABLE `[[dbprefix]]wiki_revisions` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `wiki_page_id` bigint(20) NOT NULL,
  `revision` bigint(20) NOT NULL DEFAULT '1',
  `content` text NOT NULL,
  `user_id` int(11) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
