<?php

/**
 * payment plugin Paypal
 *
 * Class Paypal
 */
class Paypal extends Tools_PaymentGateway {

    const DAY_PERIOD = 'Day';

    const WEEK_PERIOD = 'Week';

    const MONTH_PERIOD = 'Month';

    const YEAR_PERIOD = 'Year';

    /**
     * Sandbox button end point
     * @var string
     */
    private $buttonSandBoxEndPoin = 'https://www.sandbox.paypal.com/'; //https://www.paypal.com/cgi-bin/webscr
    /**
     * Sandbox validate endpoint
     * @var string
     */
    private $buttonSandBoxValidateEndPoin = 'https://www.sandbox.paypal.com/cgi-bin/webscr';

    /**
     * Paypal validate endpoint
     * @var string
     */
    private $buttonValidateEndPoin = 'https://www.paypal.com/cgi-bin/webscr';

    /**
     * Paypal va
     * @var string
     */
    private $buttonLiveEndPoin = 'https://www.paypal.com/cgi-bin/webscr'; //https://www.paypal.com/cgi-bin/webscr

    /**
     * Sandbox direct payment end point
     *
     * @var string
     */
    private $creditCardSandBoxEndPoin = 'https://api-3t.sandbox.paypal.com/nvp';

    /**
     * Direct payment end point
     *
     * @var string
     */
    private $creditCardLiveEndPoin = 'https://api-3t.paypal.com/nvp';

    /**
     * Hosted method button endpoint sandbox
     *
     * @var string
     */
    private $_buttonHostedSandboxEndPoint = 'https://securepayments.sandbox.paypal.com/webapps/HostedSoleSolutionApp/webflow/sparta/hostedSoleSolutionProcess';

    /**
     * Hosted method button live endpoint
     *
     * @var string
     */
    private $_buttonHostedLiveEndPoint = 'https://securepayments.paypal.com/cgi-bin/acquiringweb';

    /**
     * Api version
     *
     * @var string
     */
    private $API_VERSOIN = '64.0';

    protected $_allowedStatuses = array(Models_Model_CartSession::CART_STATUS_NEW, Models_Model_CartSession::CART_STATUS_ERROR, Models_Model_CartSession::CART_STATUS_PARTIAL);

    protected $_allowedStatusesCheckout = array(
        Models_Model_CartSession::CART_STATUS_NEW,
        Models_Model_CartSession::CART_STATUS_ERROR,
        Models_Model_CartSession::CART_STATUS_PROCESSING
    );

    /**
     * Allowed languages for button
     *
     * @var array
     */
    public static $_allowedLanguages = array(
        'AU' => 'AU',
        'AT' => 'AT',
        'BE' => 'BE',
        'BR' => 'BR',
        'CA' => 'CA',
        'CH' => 'CH',
        'CN' => 'CN',
        'DE' => 'DE',
        'ES' => 'ES',
        'GB' => 'GB',
        'FR' => 'FR',
        'IT' => 'IT',
        'NL' => 'NL',
        'PL' => 'PL',
        'PT' => 'PT',
        'RU' => 'RU',
        'US' => 'US',
        'DK' => 'da_DK',
        'IL' => 'he_IL',
        'ID' => 'id_ID',
        'JP' => 'ja_JP',
        'NO' => 'no_NO',
        'SE' => 'sv_SE',
        'TH' => 'th_TH',
        'TR' => 'tr_TR'
    );

    /**
     * Subscribe types
     */
    const TYPE_SUBSCRIBE = 'subscribe';

    const TYPE_SUBSCRIBE_SIGNUP = 'subscr_signup';

    const TYPE_SUBSCRIBE_PAYMENT = 'subscr_payment';

    const TYPE_SUBSCRIBE_CANCEL = 'subscr_cancel';

    const SUBSCRIBE_BILLING_PERIODS = array('Day', 'Week', 'Month', 'Year');

    const BUTTON_TYPE_HOSTED_PAYMENT = '_hosted-payment';

    const BUTTON_TYPE_CART = '_cart';

    /**
     * Option thank you page (where user redirect after successful purchase)
     */
    const OPTION_THANKYOU = 'option_storethankyou';

    /**
     * Default button label
     */
    const BUTTON_LABEL = 'PayPal';

    /**
     * Secure token
     */
    const PAYPAL_SECURE_TOKEN = 'PaypalToken';

    /**
     * @param $options
     * @param $seotoasterData
     */
    public function  __construct($options, $seotoasterData) {
		parent::__construct($options, $seotoasterData);
        $this->_layout = new Zend_Layout();
        $this->_layout->setLayoutPath(Zend_Layout::getMvcInstance()->getLayoutPath());

        if(($scriptPaths = Zend_Layout::getMvcInstance()->getView()->getScriptPaths()) !== false) {
            $this->_view->setScriptPath($scriptPaths);
        }
        $this->_view->addScriptPath(__DIR__ . '/system/views/');

    }

    /**
     * @param array $requestedParams
     * @return mixed
     */
    public function run($requestedParams = array()) {
        $dispatchersResult = parent::run($requestedParams);
		if($dispatchersResult) {
			return $dispatchersResult;
		}

    }

    /**
     * Provide selection between Credit cart (direct payment) and paypal button
     *
     * @return string
     */
    public function _makeOptionCardbutton(){
       return $this->_view->render("cardbutton.phtml");
    }

    /**
     * Create new customer address
     *
     * @param int $customerId user Id
     * @param array $address
     * @param null $type
     * @return mixed|null
     */
    private function _addAddress($customerId, $address, $type = null){
		$addressTable = new Models_DbTable_CustomerAddress();
		if (!empty($address)){
			if ($type !== null) {
				$address['address_type'] = $type;
			}
			$address = Tools_Misc::clenupAddress($address);
			$address['id'] = Tools_Misc::getAddressUniqKey($address);
			$address['user_id'] = $customerId;
			if (null === ($row = $addressTable->find($address['id'])->current())) {
				$row = $addressTable->createRow();
			}
			$row->setFromArray($address);

			return $row->save();
		}
		return null;
	}

    /**
     * Get shipping as billing
     */
    public function shippingAsBillingAction(){
        $shippingToBilling = $this->_request->getParam('shippingToBilling');
        if($shippingToBilling == '1'){
            $shippingAddressKey = Tools_ShoppingCart::getInstance()->getAddressKey(Models_Model_Customer::ADDRESS_TYPE_SHIPPING);
            if($shippingAddressKey != null){
                $paymentParams = Tools_ShoppingCart::getAddressById($shippingAddressKey);
                echo json_encode(array('error'=>'0','shipping'=>$paymentParams));
            }
        }
        else{
            if(Models_Mapper_ShoppingConfig::getInstance()->getConfigParam('country') != ''){
                $predefinedCountry = Models_Mapper_ShoppingConfig::getInstance()->getConfigParam('country');
            }
            else{
                $predefinedCountry = 'US';
            }

            echo json_encode(array('error'=>'1', 'shippingPredefinedCountry'=>$predefinedCountry));
        }
    }

    /**
     * Credit card (direct payment)
     *
     * @return string
     */
    public function _makeOptionCreditcard(){
        $paypalConfigMapper = Paypal_Models_Mapper_PaypalConfigMapper::getInstance();
        $paypalSettings = $paypalConfigMapper->selectSettings();
        $useSandbox = $paypalSettings[0]->getUseSandbox();
        $apiSignature = $paypalSettings[0]->getApiSignature();
        $apiUser = $paypalSettings[0]->getApiUser();
        $cartContent = Tools_ShoppingCart::getInstance();
        $cartId = $cartContent->getCartId();
        $cart = Models_Mapper_CartSessionMapper::getInstance()->find($cartId);
        if ($cart instanceof  Models_Model_CartSession) {
            $gateway = $cart->getGateway();
            $cartStatus = $cart->getStatus();
            if (!in_array($cartStatus, $this->_allowedStatusesCheckout) && $gateway == 'Paypal') {
                $this->_view->cartStatusError = true;
                unset($this->_sessionHelper->storeCartSessionKey);
                unset($this->_sessionHelper->storeCartSessionConversionKey);
                $cartContent->clean();
            }
        }
        $productList = array_values($cartContent->getContent());
        $this->_view->translator = $this->_translator;
        if(!empty($productList)){
            $this->_view->email = $paypalSettings[0]->getEmail();
            $this->_view->apiSignature = $apiSignature;
            $this->_view->apiUser = $apiUser;
            $this->_view->apiPassword = $paypalSettings[0]->getApiPassword();
            $this->_view->useSandBox = $useSandbox;
            $this->_view->productList = $productList;
            $this->_view->currency = Models_Mapper_ShoppingConfig::getInstance()->getConfigParam('currency');
            $this->_view->allowShipping = true;
            $this->_view->countryList =  $this->_prepareCountryList();
            if(!empty($apiSignature) && !empty($apiUser)) {
                    $cartParams = $cartContent->calculate();
                    $this->_view->totalAmount = $cartParams['total'];
                    $this->_view->shippingPaypal = $cartParams['shipping'];
                    $this->_view->totalTax = $cartParams['totalTax'];

            }
            if(Models_Mapper_ShoppingConfig::getInstance()->getConfigParam('country') != ''){
                $predefinedCountry = Models_Mapper_ShoppingConfig::getInstance()->getConfigParam('country');
            }
            else{
                $predefinedCountry = 'US';
            }
            $billingAddressKey = Tools_ShoppingCart::getInstance()->getAddressKey(Models_Model_Customer::ADDRESS_TYPE_BILLING);

            $phonecountrycodes = Tools_System_Tools::getFullCountryPhoneCodesList(true, array(), true);
            $phonecountrycode = $predefinedCountry;

            $listMasksMapper = Application_Model_Mappers_MasksListMapper::getInstance();
            $this->_view->phonecountrycodes = $phonecountrycodes;
            $this->_view->desktopMasks = $listMasksMapper->getListOfMasksByType(Application_Model_Models_MaskList::MASK_TYPE_DESKTOP);

            if($billingAddressKey != null){
                $paymentParams = Tools_ShoppingCart::getAddressById($billingAddressKey);
                if(isset($paymentParams['state'])){
                    $state = Tools_Geo::getStateById($paymentParams['state']);
                    $paymentParams['state'] = $state['id'];
                    $this->_view->state = $paymentParams['state'];
                }

                $phonecountrycode = $paymentParams['phonecountrycode'];

                $this->_view->firstName = $paymentParams['firstname'];
                $this->_view->lastName = $paymentParams['lastname'];
                $this->_view->address1 = $paymentParams['address1'];
                $this->_view->address2 = $paymentParams['address2'];
                $this->_view->billingEmail = $paymentParams['email'];
                $this->_view->city = $paymentParams['city'];
                $this->_view->zip = $paymentParams['zip'];
                $this->_view->phone = $paymentParams['phone'];
                $predefinedCountry = $paymentParams['country'];

            }
            $this->_view->phonecountrycode = $phonecountrycode;

            $listOfStates = $this->stateCheck($predefinedCountry);
            if($listOfStates['error'] != '1'){
                $this->_view->listOfState = $listOfStates[0];
            }
            $this->_view->predefinedCountry = $predefinedCountry;
            return $this->_view->render("creditcard.phtml");

        }

    }

    public function _makeOptionCreditcardquote()
    {
        if (Tools_Security_Acl::isAllowed(Shopping::RESOURCE_STORE_MANAGEMENT)) {
            return '';
        }

        $paypalConfigMapper = Paypal_Models_Mapper_PaypalConfigMapper::getInstance();
        $paypalSettings = $paypalConfigMapper->getConfigParams();
        if (!empty($paypalSettings)) {
            if (empty($paypalSettings['apiSignature']) || empty($paypalSettings['apiUser']) || empty($paypalSettings['apiPassword'])) {
                if (Tools_Security_Acl::isAllowed(Shopping::RESOURCE_STORE_MANAGEMENT)) {
                    return $this->_translator->translate('Please configure paypal plugin in the config');
                }

                return '';
            }

            $pageHelper = Zend_Controller_Action_HelperBroker::getStaticHelper('page');
            $front = Zend_Controller_Front::getInstance();
            $productMapper = Models_Mapper_ProductMapper::getInstance();
            $quote = Quote_Models_Mapper_QuoteMapper::getInstance()->find(
                $pageHelper->clean($front->getRequest()->getParams('page'))
            );
            if (!$quote instanceof Quote_Models_Model_Quote) {
                throw new Exceptions_SeotoasterPluginException('Quote not found');
            }
            $cart = Models_Mapper_CartSessionMapper::getInstance()->find($quote->getCartId());
            if (!$cart instanceof Models_Model_CartSession) {
                throw new Exceptions_SeotoasterException('Cart not found');
            }
            if ($quote->getStatus() === Quote_Models_Model_Quote::STATUS_LOST) {
                return null;
            }
            $recalculationFlags = $this->_setRecalculationFlags();
            if (!empty($quote->getCreatorId())) {
                $recalculationFlags = $this->_setRecalculationFlags($quote->getCreatorId());
            }
            if (!empty($quote->getEditorId())) {
                $recalculationFlags = $this->_setRecalculationFlags($quote->getEditorId());
            }
            $cartContent = $cart->getCartContent();
            $discount = $cart->getDiscount();
            $discountRate = $cart->getDiscountTaxRate();
            if (!$cartContent) {
                return null;
            }
            $status = $cart->getStatus();


            if ($status != Models_Model_CartSession::CART_STATUS_COMPLETED && $status != Models_Model_CartSession::CART_STATUS_DELIVERED && $status != Models_Model_CartSession::CART_STATUS_SHIPPED) {
                if ($status === Models_Model_CartSession::CART_STATUS_PENDING && $cart->getGateway() !== 'Quote') {
                    return '';
                }

                $cartSession = Tools_ShoppingCart::getInstance();
                $cartSession->setContent(array());
                $cartSession->save();
                $cartSession->setCartId($quote->getCartId());
                $cartSession->setShippingAddressKey($cart->getShippingAddressId());
                $cartSession->setBillingAddressKey($cart->getBillingAddressId());
                $notFreebiesInCart = array();
                $freebiesInCart = array();
                $productsFreebiesRelation = array();
                foreach ($cartContent as $key => $product) {
                    if ($product['freebies'] === '1') {
                        $freebiesInCart[$product['product_id']] = $product['product_id'];
                    } else {
                        $notFreebiesInCart[$product['product_id']] = $product['product_id'];
                    }
                }
                if (!empty($freebiesInCart)) {
                    $where = $productMapper->getDbTable()->getAdapter()->quoteInto(
                        'sphp.freebies_id IN (?)',
                        $freebiesInCart
                    );
                    $where .= ' AND ' . $productMapper->getDbTable()->getAdapter()->quoteInto(
                            'sphp.product_id IN (?)',
                            $notFreebiesInCart
                        );
                    $select = $productMapper->getDbTable()->getAdapter()->select()
                        ->from(
                            array('spfs' => 'shopping_product_freebies_settings'),
                            array(
                                'freebiesGroupKey' => new Zend_Db_Expr("CONCAT(sphp.freebies_id, '_', sphp.product_id)"),
                                'price_value'
                            )
                        )
                        ->joinleft(
                            array('sphp' => 'shopping_product_has_freebies'),
                            'spfs.prod_id = sphp.product_id'
                        )
                        ->where($where);
                    $productFreebiesSettings = $productMapper->getDbTable()->getAdapter()->fetchAssoc($select);
                }

                if (!empty($productFreebiesSettings)) {
                    foreach ($productFreebiesSettings as $prodInfo) {
                        if (array_key_exists($prodInfo['freebies_id'], $freebiesInCart)) {
                            if (isset($productsFreebiesRelation[$prodInfo['freebies_id']])) {
                                $productsFreebiesRelation[$prodInfo['freebies_id']][$prodInfo['product_id']] = $prodInfo['product_id'];
                            } else {
                                $productsFreebiesRelation[$prodInfo['freebies_id']] = array($prodInfo['product_id'] => $prodInfo['product_id']);
                            }
                        }
                    }
                }

                foreach ($cartContent as $key => $product) {
                    $productObject = $productMapper->find($product['product_id']);
                    if ($productObject instanceof Models_Model_Product) {
                        if ($product['freebies'] === '1' && !empty($productsFreebiesRelation)) {
                            foreach ($productsFreebiesRelation[$product['product_id']] as $realProductId) {
                                $itemKey = $this->_generateStorageKey(
                                    $productObject,
                                    array(0 => 'freebies_' . $realProductId)
                                );
                                if (!$cartSession->findBySid($itemKey)) {
                                    $productObject->setFreebies(1);
                                    $cartSession->add(
                                        $productObject,
                                        array(0 => 'freebies_' . $realProductId),
                                        $product['qty'], true, $recalculationFlags['skipOptionRecalculation'],
                                        $recalculationFlags['skipGroupPriceRecalculation']
                                    );
                                }
                            }
                        } else {
                            $options = array();
                            if (is_array($product['options'])) {
                                $options = $this->_parseProductOptions($product['options']);
                            }
                            $productObject->setPrice($product['price']);
                            $productObject->setOriginalPrice($product['original_price']);
                            $productObject->setCurrentPrice(floatval($productObject->getPrice()));
                            $cartSession->add($productObject, $options, $product['qty'], true,
                                $recalculationFlags['skipOptionRecalculation'],
                                $recalculationFlags['skipGroupPriceRecalculation']);
                        }
                    }
                }
                $cartSession->setDiscount($discount);
                $cartSession->setShippingData(array('price' => $cart->getShippingPrice()));
                $cartSession->setDiscountTaxRate($discountRate);
                $cartSession->calculate(true, $recalculationFlags['skipGroupPriceRecalculation']);
                $cartSession->save();

                $this->_view->partialPayment = false;
                $paymentType = $quote->getPaymentType();
                if ($paymentType === Quote_Models_Model_Quote::PAYMENT_TYPE_PARTIAL_PAYMENT) {
                    $cartStatus = $cart->getStatus();
                    $partialPercent = $cart->getPartialPercentage();
                    $partialPaymentType = $cart->getPartialType();
                    if (($cartStatus === Models_Model_CartSession::CART_STATUS_PARTIAL || $cartStatus === Models_Model_CartSession::CART_STATUS_PROCESSING) && !empty((int)$cart->getPartialPaidAmount())) {
                        if ($partialPaymentType === Models_Model_CartSession::CART_PARTIAL_PAYMENT_TYPE_AMOUNT) {
                            $partialPercent = round($partialPercent, 6);
                        } else {
                            $partialPercent = round(100 - $partialPercent, 6);
                        }
                    }

                    $this->_view->partialPayment = true;
                    if (empty($partialPercent)) {
                        $this->_view->partialPayment = false;
                    }

                    $this->_view->partialPercent = $partialPercent;
                }


                $this->_view->totalTax = round($cart->getTotalTax(), 2);
                $this->_view->shipping = round($cart->getShippingPrice(), 2);
                $this->_view->totalAmount = round($cart->getTotal(), 2);
                $this->_view->cartTotal = $cart->getTotal();
                $this->_view->currency = Models_Mapper_ShoppingConfig::getInstance()->getConfigParam('currency');
                $shippingAddressKey = $cart->getShippingAddressId();
                if ($shippingAddressKey != null) {
                    $this->_view->allowShipping = true;
                }
                $this->_view->countryList = $this->_prepareCountryList();
                if (Models_Mapper_ShoppingConfig::getInstance()->getConfigParam('country') != '') {
                    $predefinedCountry = Models_Mapper_ShoppingConfig::getInstance()->getConfigParam('country');
                } else {
                    $predefinedCountry = 'US';
                }

                $phonecountrycodes = Tools_System_Tools::getFullCountryPhoneCodesList(true, array(), true);
                $phonecountrycode = $predefinedCountry;

                $listMasksMapper = Application_Model_Mappers_MasksListMapper::getInstance();
                $this->_view->phonecountrycodes = $phonecountrycodes;
                $this->_view->desktopMasks = $listMasksMapper->getListOfMasksByType(Application_Model_Models_MaskList::MASK_TYPE_DESKTOP);

                $billingAddressKey = $cart->getBillingAddressId();
                if ($billingAddressKey != null) {
                    $paymentParams = Tools_ShoppingCart::getAddressById($billingAddressKey);
                    if (isset($paymentParams['state'])) {
                        $state = Tools_Geo::getStateById($paymentParams['state']);
                        $paymentParams['state'] = $state['id'];
                        $this->_view->state = $paymentParams['state'];
                    }

                    $phonecountrycode = $paymentParams['phonecountrycode'];

                    $this->_view->firstName = $paymentParams['firstname'];
                    $this->_view->lastName = $paymentParams['lastname'];
                    $this->_view->address1 = $paymentParams['address1'];
                    $this->_view->address2 = $paymentParams['address2'];
                    $this->_view->billingEmail = $paymentParams['email'];
                    $this->_view->city = $paymentParams['city'];
                    $this->_view->zip = $paymentParams['zip'];
                    $this->_view->phone = $paymentParams['phone'];
                    $predefinedCountry = $paymentParams['country'];

                }

                $this->_view->phonecountrycode = $phonecountrycode;

                $listOfStates = $this->stateCheck($predefinedCountry);
                if ($listOfStates['error'] == '0') {
                    $this->_view->listOfState = $listOfStates[0];
                }

                $this->_view->predefinedCountry = $predefinedCountry;

                $amountToPay = $this->_view->totalAmount;
                if ($paymentType === Quote_Models_Model_Quote::PAYMENT_TYPE_PARTIAL_PAYMENT) {
                    $partialPaidAmount = $cart->getPartialPaidAmount();
                    $partialPaymentType = $cart->getPartialType();
                    if (!empty($partialPaidAmount) && $partialPaidAmount !== '0.00' && !empty((int) $partialPaidAmount)) {
                        if ($partialPaymentType === Models_Model_CartSession::CART_PARTIAL_PAYMENT_TYPE_AMOUNT) {
                            $amountToPay = round($cart->getTotal() - $cart->getPartialPercentage(),2);
                        } else {
                            $amountToPay = round($cart->getTotal() - round(($cart->getTotal()*$cart->getPartialPercentage())/100, 2),2);
                        }
                    } else {
                        if ($partialPaymentType === Models_Model_CartSession::CART_PARTIAL_PAYMENT_TYPE_AMOUNT) {
                            $amountToPay = round($cart->getPartialPercentage(), 2);
                        } else {
                            $amountToPay = round(($cart->getTotal() * $cart->getPartialPercentage()) / 100, 2);
                        }
                    }
                }

                $currency = Zend_Registry::get('Zend_Currency');

                $this->_view->amountToPay = $currency->toCurrency($amountToPay);

                return $this->_view->render('paypal-creditcard-card-quote.phtml');
            }

        }


        return '';
    }

    /**
     * Paypal button on generated quote page
     *
     * @return null|string
     * @throws Exceptions_SeotoasterException
     * @throws Exceptions_SeotoasterPluginException
     */
    public function _makeOptionQuote()
    {
        if (Tools_Security_Acl::isAllowed(Shopping::RESOURCE_STORE_MANAGEMENT)) {
            return '';
        }
        $paypalSettings = Paypal_Models_Mapper_PaypalConfigMapper::getInstance()->fetchAll();
        $shoppingConfig = Models_Mapper_ShoppingConfig::getInstance()->getConfigParams();
        if (!empty($paypalSettings)) {
            $pageHelper = Zend_Controller_Action_HelperBroker::getStaticHelper('page');
            $front = Zend_Controller_Front::getInstance();
            $productMapper = Models_Mapper_ProductMapper::getInstance();
            $quote = Quote_Models_Mapper_QuoteMapper::getInstance()->find(
                $pageHelper->clean($front->getRequest()->getParams('page'))
            );
            if (!$quote instanceof Quote_Models_Model_Quote) {
                throw new Exceptions_SeotoasterPluginException('Quote not found');
            }
            $cart = Models_Mapper_CartSessionMapper::getInstance()->find($quote->getCartId());
            if (!$cart instanceof Models_Model_CartSession) {
                throw new Exceptions_SeotoasterException('Cart not found');
            }
            if ($quote->getStatus() === Quote_Models_Model_Quote::STATUS_LOST) {
                return null;
            }
            $recalculationFlags = $this->_setRecalculationFlags();
            if (!empty($quote->getCreatorId())) {
                $recalculationFlags = $this->_setRecalculationFlags($quote->getCreatorId());
            }
            if (!empty($quote->getEditorId())) {
                $recalculationFlags = $this->_setRecalculationFlags($quote->getEditorId());
            }
            $cartContent = $cart->getCartContent();
            $discount = $cart->getDiscount();
            $discountRate = $cart->getDiscountTaxRate();
            if (!$cartContent) {
                return null;
            }
            $status = $cart->getStatus();
            if ($status != Models_Model_CartSession::CART_STATUS_COMPLETED && $status != Models_Model_CartSession::CART_STATUS_DELIVERED && $status != Models_Model_CartSession::CART_STATUS_SHIPPED) {
                if($status === Models_Model_CartSession::CART_STATUS_PENDING && $cart->getGateway() !== 'Quote'){
                    return '';
                }
                $cartSession = Tools_ShoppingCart::getInstance();
                $cartSession->setContent(array());
                $cartSession->save();
                $cartSession->setCartId($quote->getCartId());
                $cartSession->setShippingAddressKey($cart->getShippingAddressId());
                $cartSession->setBillingAddressKey($cart->getBillingAddressId());
                $notFreebiesInCart = array();
                $freebiesInCart = array();
                $productsFreebiesRelation = array();
                foreach ($cartContent as $key => $product) {
                    if ($product['freebies'] === '1') {
                        $freebiesInCart[$product['product_id']] = $product['product_id'];
                    } else {
                        $notFreebiesInCart[$product['product_id']] = $product['product_id'];
                    }
                }
                if (!empty($freebiesInCart)) {
                    $where = $productMapper->getDbTable()->getAdapter()->quoteInto(
                        'sphp.freebies_id IN (?)',
                        $freebiesInCart
                    );
                    $where .= ' AND ' . $productMapper->getDbTable()->getAdapter()->quoteInto(
                        'sphp.product_id IN (?)',
                        $notFreebiesInCart
                    );
                    $select = $productMapper->getDbTable()->getAdapter()->select()
                        ->from(
                            array('spfs' => 'shopping_product_freebies_settings'),
                            array(
                                'freebiesGroupKey' => new Zend_Db_Expr("CONCAT(sphp.freebies_id, '_', sphp.product_id)"),
                                'price_value'
                            )
                        )
                        ->joinleft(
                            array('sphp' => 'shopping_product_has_freebies'),
                            'spfs.prod_id = sphp.product_id'
                        )
                        ->where($where);
                    $productFreebiesSettings = $productMapper->getDbTable()->getAdapter()->fetchAssoc($select);
                }

                if (!empty($productFreebiesSettings)) {
                    foreach ($productFreebiesSettings as $prodInfo) {
                        if (array_key_exists($prodInfo['freebies_id'], $freebiesInCart)) {
                            if (isset($productsFreebiesRelation[$prodInfo['freebies_id']])) {
                                $productsFreebiesRelation[$prodInfo['freebies_id']][$prodInfo['product_id']] = $prodInfo['product_id'];
                            } else {
                                $productsFreebiesRelation[$prodInfo['freebies_id']] = array($prodInfo['product_id'] => $prodInfo['product_id']);
                            }
                        }
                    }
                }

                foreach ($cartContent as $key => $product) {
                    $productObject = $productMapper->find($product['product_id']);
                    if ($productObject instanceof Models_Model_Product) {
                        if ($product['freebies'] === '1' && !empty($productsFreebiesRelation)) {
                            foreach ($productsFreebiesRelation[$product['product_id']] as $realProductId) {
                                $itemKey = $this->_generateStorageKey(
                                    $productObject,
                                    array(0 => 'freebies_' . $realProductId)
                                );
                                if (!$cartSession->findBySid($itemKey)) {
                                    $productObject->setFreebies(1);
                                    $cartSession->add(
                                        $productObject,
                                        array(0 => 'freebies_' . $realProductId),
                                        $product['qty'], true, $recalculationFlags['skipOptionRecalculation'], $recalculationFlags['skipGroupPriceRecalculation']
                                    );
                                }
                            }
                        } else {
                            $options = array();
                            if (is_array($product['options'])) {
                                $options = $this->_parseProductOptions($product['options']);
                            }
                            $productObject->setPrice($product['price']);
                            $productObject->setOriginalPrice($product['original_price']);
                            $productObject->setCurrentPrice(floatval($productObject->getPrice()));
                            $cartSession->add($productObject, $options, $product['qty'], true, $recalculationFlags['skipOptionRecalculation'], $recalculationFlags['skipGroupPriceRecalculation']);
                        }
                    }
                }
                $cartSession->setDiscount($discount);
                $cartSession->setShippingData(array('price' => $cart->getShippingPrice()));
                $cartSession->setDiscountTaxRate($discountRate);
                $cartSession->calculate(true , $recalculationFlags['skipGroupPriceRecalculation']);
                $cartSession->save();

                if (!empty($shoppingConfig)) {
                    $this->_view->shoppingCountry = $shoppingConfig['country'];
                } else {
                    $this->_view->shoppingCountry = 'US';
                }

                $useSandbox = $paypalSettings[0]->getUseSandbox();
                $this->_view->email = $paypalSettings[0]->getEmail();
                $this->_view->useSandBox = $useSandbox;
                $this->_view->productList = $cartContent;
                $this->_view->translator = $this->_translator;
                $cartId = $cartSession->getCartId();
                $this->_view->cartId = $cartId;
                $this->_view->totalAmount = round($cartSession->getTotal(), 2);
                $this->_view->totalTax = round($cartSession->getTotalTax(), 2);
                $this->_view->discount = round($discount, 2);

                $shippingData = $cartSession->getShippingData();
                $this->_view->shipping = round($shippingData['price'], 2);
                $this->_view->currency = Models_Mapper_ShoppingConfig::getInstance()->getConfigParam('currency');
                if ($useSandbox == 1) {
                    $this->_view->endPoint = $this->buttonSandBoxEndPoin; //https://www.sandbox.paypal.com/
                } else {
                    $this->_view->endPoint = $this->buttonLiveEndPoin; //'https://www.paypal.com/cgi-bin/webscr'
                }

                $typeSubscribe = array_search(self::TYPE_SUBSCRIBE, $this->_options);
                if (isset($this->_options[1]) && isset($this->_options[2]) && isset($this->_options[3]) && $typeSubscribe) {
                    //subscribe Config
                    $quantityPayments = $this->_options[1];
                    $period = $this->_options[3];
                    $subscribeCycle = $this->_options[2];

                    $this->_view->subscribeCycle = $subscribeCycle;
                    $this->_view->quantityPayments = $quantityPayments;
                    $this->_view->period = $period;
                    return $this->_view->render("subscribe_button.phtml");
                }

                $shippingAddressKey = Tools_ShoppingCart::getInstance()->getAddressKey(Models_Model_Customer::ADDRESS_TYPE_SHIPPING);
                if($shippingAddressKey != null){
                    $paymentParams = Tools_ShoppingCart::getAddressById($shippingAddressKey);
                    if(isset($paymentParams['state'])){
                       $state = Tools_Geo::getStateById($paymentParams['state']);
                       $paymentParams['state'] = $state['state'];
                       $this->_view->firstName = $paymentParams['firstname'];
                       $this->_view->lastName = $paymentParams['lastname'];
                       $this->_view->address1 = $paymentParams['address1'];
                       $this->_view->address2 = $paymentParams['address2'];
                       $this->_view->shippingEmail = $paymentParams['email'];
                       $this->_view->city = $paymentParams['city'];
                       $this->_view->state = $paymentParams['state'];
                       $this->_view->zip = $paymentParams['zip'];
                       $this->_view->country = $paymentParams['country'];
                       $this->_view->allowShipping = true;
                    }
                }

                $typeHostedButton = array_search(self::BUTTON_TYPE_HOSTED_PAYMENT, $this->_options);
                if ($typeHostedButton) {
                    $this->_view->subTotalAmount = round($cartSession->getSubTotal(),2);
                    if ($useSandbox == 1) {
                        $this->_view->endPoint = $this->_buttonHostedSandboxEndPoint;
                    } else {
                        $this->_view->endPoint = $this->_buttonHostedLiveEndPoint;
                    }

                    return $this->_view->render('button-hosted.phtml');
                }

                $this->_view->partialPayment = false;
                $paymentType = $quote->getPaymentType();
                $paymentPart = 'first';
                $partialPaymentType = $cart->getPartialType();
                if ($paymentType === Quote_Models_Model_Quote::PAYMENT_TYPE_PARTIAL_PAYMENT) {
                    $cartStatus = $cart->getStatus();
                    $partialPercent = $cart->getPartialPercentage();
                    if (($cartStatus === Models_Model_CartSession::CART_STATUS_PARTIAL || $cartStatus === Models_Model_CartSession::CART_STATUS_PROCESSING) && !empty((int) $cart->getPartialPaidAmount())) {
                        if ($partialPaymentType === Models_Model_CartSession::CART_PARTIAL_PAYMENT_TYPE_AMOUNT) {
                            $partialPercent = round($cart->getTotal() - $partialPercent, 6);
                        } else {
                            $partialPercent = round(100 - $partialPercent, 6);

                        }

                        $paymentPart = 'second';
                    }

                    $this->_view->partialPayment = true;
                    if (empty($partialPercent)) {
                        $this->_view->partialPayment = false;
                    }

                    $this->_view->partialPercent = $partialPercent;
                }

                $this->_view->paymentType = $paymentType;
                $this->_view->paymentPart = $paymentPart;
                $this->_view->partialPaymentType = $partialPaymentType;

                $pageModel = Application_Model_Mappers_PageMapper::getInstance()->findByUrl($quote->getId().'.html');
                if ($pageModel instanceof Application_Model_Models_Page) {
                    $this->_view->partialPaymentRedirect = $pageModel->getUrl();
                } else{
                    $this->_view->partialPaymentRedirect = '';
                }

                return $this->_view->render("button.phtml");
            }

        } elseif (Tools_Security_Acl::isAllowed(Tools_Security_Acl::RESOURCE_PLUGINS)) {
            return $this->_translator->translate(
                'Number of time periods between each recurrence or time period is missing'
            );
        }
    }


    /**
     * Paypal Credit card recurring quote
     *
     * @return null|string
     * @throws Exceptions_SeotoasterException
     * @throws Exceptions_SeotoasterPluginException
     */
    public function _makeOptionCreditcardrecurringquote()
    {
        if (Tools_Security_Acl::isAllowed(Shopping::RESOURCE_STORE_MANAGEMENT)) {
            return '';
        }
        $paypalSettings = Paypal_Models_Mapper_PaypalConfigMapper::getInstance()->fetchAll();
        if (!isset($this->_options[1])) {
            return '';
        }

        if (!isset($this->_options[2])) {
            return '';
        }

        $quantityPeriods = $this->_options[1];
        $billingPeriod = ucfirst(strtolower(trim($this->_options[2])));
        if (!in_array($billingPeriod, self::SUBSCRIBE_BILLING_PERIODS)) {
            return $this->_translator->translate('Wrong billing period provided.');
        }

        if ($billingPeriod === self::DAY_PERIOD){
            if ($quantityPeriods !== '1') {
                return $this->_translator->translate('Wrong billing period specified.');
            }
        }

        if ($billingPeriod === self::WEEK_PERIOD){
            if ($quantityPeriods !== '1') {
                return $this->_translator->translate('Wrong billing period specified.');
            }
        }

        if ($billingPeriod === self::MONTH_PERIOD){
            if (!in_array($quantityPeriods, array('1', '2', '3', '6'))) {
                return $this->_translator->translate('Wrong billing period specified.');
            }
        }

        if ($billingPeriod === self::YEAR_PERIOD){
            if ($quantityPeriods !== '1') {
                return $this->_translator->translate('Wrong billing period specified.');
            }
        }

        $this->_view->quantityPeriods = $quantityPeriods;
        $this->_view->billingPeriod = $billingPeriod;

        if (!empty($paypalSettings)) {
            $pageHelper = Zend_Controller_Action_HelperBroker::getStaticHelper('page');
            $front = Zend_Controller_Front::getInstance();
            $productMapper = Models_Mapper_ProductMapper::getInstance();
            $quote = Quote_Models_Mapper_QuoteMapper::getInstance()->find(
                $pageHelper->clean($front->getRequest()->getParams('page'))
            );
            if (!$quote instanceof Quote_Models_Model_Quote) {
                throw new Exceptions_SeotoasterPluginException('Quote not found');
            }
            $cart = Models_Mapper_CartSessionMapper::getInstance()->find($quote->getCartId());
            if (!$cart instanceof Models_Model_CartSession) {
                throw new Exceptions_SeotoasterException('Cart not found');
            }
            if ($quote->getStatus() === Quote_Models_Model_Quote::STATUS_LOST) {
                return null;
            }

            $paymentType = $quote->getPaymentType();
            if ($paymentType === Quote_Models_Model_Quote::PAYMENT_TYPE_PARTIAL_PAYMENT) {
                return '';
            }

            if ($paymentType === Quote_Models_Model_Quote::PAYMENT_TYPE_ONLY_SIGNATURE) {
                return '';
            }

            $recalculationFlags = $this->_setRecalculationFlags();
            if (!empty($quote->getCreatorId())) {
                $recalculationFlags = $this->_setRecalculationFlags($quote->getCreatorId());
            }
            if (!empty($quote->getEditorId())) {
                $recalculationFlags = $this->_setRecalculationFlags($quote->getEditorId());
            }
            $cartContent = $cart->getCartContent();
            $discount = $cart->getDiscount();
            $discountRate = $cart->getDiscountTaxRate();
            if (!$cartContent) {
                return null;
            }
            $status = $cart->getStatus();
            if ($status != Models_Model_CartSession::CART_STATUS_COMPLETED && $status != Models_Model_CartSession::CART_STATUS_DELIVERED && $status != Models_Model_CartSession::CART_STATUS_SHIPPED) {
                if($status === Models_Model_CartSession::CART_STATUS_PENDING && $cart->getGateway() !== 'Quote'){
                    return '';
                }
                $cartSession = Tools_ShoppingCart::getInstance();
                $cartSession->setContent(array());
                $cartSession->save();
                $cartSession->setCartId($quote->getCartId());
                $cartSession->setShippingAddressKey($cart->getShippingAddressId());
                $cartSession->setBillingAddressKey($cart->getBillingAddressId());
                $notFreebiesInCart = array();
                $freebiesInCart = array();
                $productsFreebiesRelation = array();
                foreach ($cartContent as $key => $product) {
                    if ($product['freebies'] === '1') {
                        $freebiesInCart[$product['product_id']] = $product['product_id'];
                    } else {
                        $notFreebiesInCart[$product['product_id']] = $product['product_id'];
                    }
                }
                if (!empty($freebiesInCart)) {
                    $where = $productMapper->getDbTable()->getAdapter()->quoteInto(
                        'sphp.freebies_id IN (?)',
                        $freebiesInCart
                    );
                    $where .= ' AND ' . $productMapper->getDbTable()->getAdapter()->quoteInto(
                            'sphp.product_id IN (?)',
                            $notFreebiesInCart
                        );
                    $select = $productMapper->getDbTable()->getAdapter()->select()
                        ->from(
                            array('spfs' => 'shopping_product_freebies_settings'),
                            array(
                                'freebiesGroupKey' => new Zend_Db_Expr("CONCAT(sphp.freebies_id, '_', sphp.product_id)"),
                                'price_value'
                            )
                        )
                        ->joinleft(
                            array('sphp' => 'shopping_product_has_freebies'),
                            'spfs.prod_id = sphp.product_id'
                        )
                        ->where($where);
                    $productFreebiesSettings = $productMapper->getDbTable()->getAdapter()->fetchAssoc($select);
                }

                if (!empty($productFreebiesSettings)) {
                    foreach ($productFreebiesSettings as $prodInfo) {
                        if (array_key_exists($prodInfo['freebies_id'], $freebiesInCart)) {
                            if (isset($productsFreebiesRelation[$prodInfo['freebies_id']])) {
                                $productsFreebiesRelation[$prodInfo['freebies_id']][$prodInfo['product_id']] = $prodInfo['product_id'];
                            } else {
                                $productsFreebiesRelation[$prodInfo['freebies_id']] = array($prodInfo['product_id'] => $prodInfo['product_id']);
                            }
                        }
                    }
                }

                foreach ($cartContent as $key => $product) {
                    $productObject = $productMapper->find($product['product_id']);
                    if ($productObject instanceof Models_Model_Product) {
                        if ($product['freebies'] === '1' && !empty($productsFreebiesRelation)) {
                            foreach ($productsFreebiesRelation[$product['product_id']] as $realProductId) {
                                $itemKey = $this->_generateStorageKey(
                                    $productObject,
                                    array(0 => 'freebies_' . $realProductId)
                                );
                                if (!$cartSession->findBySid($itemKey)) {
                                    $productObject->setFreebies(1);
                                    $cartSession->add(
                                        $productObject,
                                        array(0 => 'freebies_' . $realProductId),
                                        $product['qty'], true, $recalculationFlags['skipOptionRecalculation'], $recalculationFlags['skipGroupPriceRecalculation']
                                    );
                                }
                            }
                        } else {
                            $options = array();
                            if (is_array($product['options'])) {
                                $options = $this->_parseProductOptions($product['options']);
                            }
                            $productObject->setPrice($product['price']);
                            $productObject->setOriginalPrice($product['original_price']);
                            $productObject->setCurrentPrice(floatval($productObject->getPrice()));
                            $cartSession->add($productObject, $options, $product['qty'], true, $recalculationFlags['skipOptionRecalculation'], $recalculationFlags['skipGroupPriceRecalculation']);
                        }
                    }
                }
                $cartSession->setDiscount($discount);
                $cartSession->setShippingData(array('price' => $cart->getShippingPrice()));
                $cartSession->setDiscountTaxRate($discountRate);
                $cartSession->calculate(true , $recalculationFlags['skipGroupPriceRecalculation']);
                $cartSession->save();

                $useSandbox = $paypalSettings[0]->getUseSandbox();
                $this->_view->email = $paypalSettings[0]->getEmail();
                $this->_view->useSandBox = $useSandbox;
                $this->_view->productList = $cartContent;
                $this->_view->translator = $this->_translator;
                $cartId = $cartSession->getCartId();
                $this->_view->cartId = $cartId;
                $this->_view->totalAmount = round($cartSession->getTotal(), 2);
                $this->_view->totalTax = round($cartSession->getTotalTax(), 2);
                $this->_view->discount = round($discount, 2);

                $shippingData = $cartSession->getShippingData();
                $this->_view->shipping = round($shippingData['price'], 2);
                $this->_view->currency = Models_Mapper_ShoppingConfig::getInstance()->getConfigParam('currency');
                if ($useSandbox == 1) {
                    $this->_view->endPoint = $this->buttonSandBoxEndPoin; //https://www.sandbox.paypal.com/
                } else {
                    $this->_view->endPoint = $this->buttonLiveEndPoin; //'https://www.paypal.com/cgi-bin/webscr'
                }

                $typeSubscribe = array_search(self::TYPE_SUBSCRIBE, $this->_options);
                if (isset($this->_options[1]) && isset($this->_options[2]) && isset($this->_options[3]) && $typeSubscribe) {
                    //subscribe Config
                    $quantityPayments = $this->_options[1];
                    $period = $this->_options[3];
                    $subscribeCycle = $this->_options[2];

                    $this->_view->subscribeCycle = $subscribeCycle;
                    $this->_view->quantityPayments = $quantityPayments;
                    $this->_view->period = $period;
                    return $this->_view->render("subscribe_button.phtml");
                }

                $shippingAddressKey = Tools_ShoppingCart::getInstance()->getAddressKey(Models_Model_Customer::ADDRESS_TYPE_SHIPPING);
                if($shippingAddressKey != null){
                    $paymentParams = Tools_ShoppingCart::getAddressById($shippingAddressKey);
                    if(isset($paymentParams['state'])){
                        $state = Tools_Geo::getStateById($paymentParams['state']);
                        $paymentParams['state'] = $state['state'];
                        $this->_view->firstName = $paymentParams['firstname'];
                        $this->_view->lastName = $paymentParams['lastname'];
                        $this->_view->address1 = $paymentParams['address1'];
                        $this->_view->address2 = $paymentParams['address2'];
                        $this->_view->shippingEmail = $paymentParams['email'];
                        $this->_view->city = $paymentParams['city'];
                        $this->_view->state = $paymentParams['state'];
                        $this->_view->zip = $paymentParams['zip'];
                        $this->_view->country = $paymentParams['country'];
                        $this->_view->allowShipping = true;
                    }
                }

                $typeHostedButton = array_search(self::BUTTON_TYPE_HOSTED_PAYMENT, $this->_options);
                if ($typeHostedButton) {
                    $this->_view->subTotalAmount = round($cartSession->getSubTotal(),2);
                    if ($useSandbox == 1) {
                        $this->_view->endPoint = $this->_buttonHostedSandboxEndPoint;
                    } else {
                        $this->_view->endPoint = $this->_buttonHostedLiveEndPoint;
                    }

                    return $this->_view->render('button-hosted.phtml');
                }

                $this->_view->partialPayment = false;
                $paymentType = $quote->getPaymentType();
                $paymentPart = 'first';
                $partialPaymentType = $cart->getPartialType();
                if ($paymentType === Quote_Models_Model_Quote::PAYMENT_TYPE_PARTIAL_PAYMENT) {
                    $cartStatus = $cart->getStatus();
                    $partialPercent = $cart->getPartialPercentage();
                    if (($cartStatus === Models_Model_CartSession::CART_STATUS_PARTIAL || $cartStatus === Models_Model_CartSession::CART_STATUS_PROCESSING) && !empty((int) $cart->getPartialPaidAmount())) {
                        if ($partialPaymentType === Models_Model_CartSession::CART_PARTIAL_PAYMENT_TYPE_AMOUNT) {
                            $partialPercent = round($cart->getTotal() - $partialPercent, 6);
                        } else {
                            $partialPercent = round(100 - $partialPercent, 6);

                        }

                        $paymentPart = 'second';
                    }

                    $this->_view->partialPayment = true;
                    if (empty($partialPercent)) {
                        $this->_view->partialPayment = false;
                    }

                    $this->_view->partialPercent = $partialPercent;
                }

                $this->_view->paymentType = $paymentType;
                $this->_view->paymentPart = $paymentPart;
                $this->_view->partialPaymentType = $partialPaymentType;

                $pageModel = Application_Model_Mappers_PageMapper::getInstance()->findByUrl($quote->getId().'.html');
                if ($pageModel instanceof Application_Model_Models_Page) {
                    $this->_view->partialPaymentRedirect = $pageModel->getUrl();
                } else{
                    $this->_view->partialPaymentRedirect = '';
                }

                $this->_view->totalTax = round($cart->getTotalTax(), 2);
                $this->_view->shipping = round($cart->getShippingPrice(), 2);
                $this->_view->totalAmount = round($cart->getTotal(), 2);
                $this->_view->cartTotal = $cart->getTotal();
                $this->_view->currency = Models_Mapper_ShoppingConfig::getInstance()->getConfigParam('currency');
                $shippingAddressKey = $cart->getShippingAddressId();
                if ($shippingAddressKey != null) {
                    $this->_view->allowShipping = true;
                }
                $this->_view->countryList = $this->_prepareCountryList();
                if (Models_Mapper_ShoppingConfig::getInstance()->getConfigParam('country') != '') {
                    $predefinedCountry = Models_Mapper_ShoppingConfig::getInstance()->getConfigParam('country');
                } else {
                    $predefinedCountry = 'US';
                }

                $phonecountrycodes = Tools_System_Tools::getFullCountryPhoneCodesList(true, array(), true);
                $phonecountrycode = $predefinedCountry;

                $listMasksMapper = Application_Model_Mappers_MasksListMapper::getInstance();
                $this->_view->phonecountrycodes = $phonecountrycodes;
                $this->_view->desktopMasks = $listMasksMapper->getListOfMasksByType(Application_Model_Models_MaskList::MASK_TYPE_DESKTOP);

                $billingAddressKey = $cart->getBillingAddressId();
                if ($billingAddressKey != null) {
                    $paymentParams = Tools_ShoppingCart::getAddressById($billingAddressKey);
                    if (isset($paymentParams['state'])) {
                        $state = Tools_Geo::getStateById($paymentParams['state']);
                        $paymentParams['state'] = $state['id'];
                        $this->_view->state = $paymentParams['state'];
                    }

                    $phonecountrycode = $paymentParams['phonecountrycode'];

                    $this->_view->firstName = $paymentParams['firstname'];
                    $this->_view->lastName = $paymentParams['lastname'];
                    $this->_view->address1 = $paymentParams['address1'];
                    $this->_view->address2 = $paymentParams['address2'];
                    $this->_view->billingEmail = $paymentParams['email'];
                    $this->_view->city = $paymentParams['city'];
                    $this->_view->zip = $paymentParams['zip'];
                    $this->_view->phone = $paymentParams['phone'];
                    $predefinedCountry = $paymentParams['country'];

                }

                $this->_view->phonecountrycode = $phonecountrycode;

                $listOfStates = $this->stateCheck($predefinedCountry);
                if ($listOfStates['error'] == '0') {
                    $this->_view->listOfState = $listOfStates[0];
                }

                $this->_view->predefinedCountry = $predefinedCountry;

                return $this->_view->render("paypal-creditcard-card-quote-recurring.phtml");
            }

        } elseif (Tools_Security_Acl::isAllowed(Tools_Security_Acl::RESOURCE_PLUGINS)) {
            return $this->_translator->translate(
                'Number of time periods between each recurrence or time period is missing'
            );
        }
    }


    /**
     * Pay recurrent action
     */
    public function payCreditCquoterecurringAction(){
        if ($this->_request->isPost()) {
            $data =  $this->_request->getParams();
            if (Models_Mapper_ShoppingConfig::getInstance()->getConfigParam('throttleTransactions') === 'true' && Tools_Misc::checkThrottleTransactionsLimit() === false) {
                $throttleTransactionsLimitMessage = Models_Mapper_ShoppingConfig::getInstance()->getConfigParam('throttleTransactionsLimitMessage');
                $throttleTransactionsLimitMessage = !empty($throttleTransactionsLimitMessage) ? $throttleTransactionsLimitMessage : Tools_Misc::THROTTLE_TRANSACTIONS_DEFAULT_MESSAGE;
                $this->_responseHelper->fail(array(
                    'error' => 1,
                    'generalError' => $this->_translator->translate($throttleTransactionsLimitMessage)
                ));
            };
            $creditCardNum = preg_replace(array('/ /','/-/','/\//'), '', trim($data['cardnumber']));
            $sessionHelper = Zend_Controller_Action_HelperBroker::getStaticHelper('session');
            $customer    = $sessionHelper->getCurrentUser();
            $cartStorage = Tools_ShoppingCart::getInstance();
            $cartId = $cartStorage->getCartId();
            $cart = Models_Mapper_CartSessionMapper::getInstance()->find($cartId);
            if ($cart instanceof  Models_Model_CartSession) {
                $cartStatus = $cart->getStatus();
                $gateway = $cart->getGateway();
                if (!in_array($cartStatus, $this->_allowedStatuses) && $gateway == 'Paypal') {
                    $payResult['error'] = 1;
                    $payResult['message'] = "We can't confirm your order at the moment due to a technical difficulty. If you do not receive an email in the coming hours confirming your purchase, please contact us";
                    $this->_responseHelper->fail($payResult['message']);
                }
            }

            if ($cart->getGateway() === 'Quote') {
                $quoteMapper = Quote_Models_Mapper_QuoteMapper::getInstance();
                $quoteModel = $quoteMapper->findByCartId($cart->getId());
                if ($quoteModel instanceof Quote_Models_Model_Quote) {
                    $signatureRequired = $quoteModel->getIsSignatureRequired();
                    if (!empty($signatureRequired) && empty($quoteModel->getIsQuoteSigned())) {
                        $this->_responseHelper->fail(array(
                            'error' => 1,
                            'generalError' => $this->_translator->translate('Please sign the quote!')
                        ));
                    }

                }
            }


            if (empty($data['quantityPeriods']) || empty($data['billingPeriod'])) {
                $payResult['error'] = 1;
                $payResult['message'] = "Missing recurrent payment type";
                $this->_responseHelper->fail(array(
                    'error' => 1,
                    'generalError' => $this->_translator->translate($payResult['message'])
                ));
            }

            $quantityPeriods= $data['quantityPeriods'];
            $billingPeriod = $data['billingPeriod'];

            $this->updateCartStatus($cartId, Models_Model_CartSession::CART_STATUS_PROCESSING);
            $cartSummary = $cartStorage->calculate();
            $cartSummary['totalTax'] = round($cartSummary['totalTax'], 2);
            $cartSummary['shipping'] = round($cartSummary['shipping'], 2);
            $cartSummary['total'] = round($cartSummary['total'], 2);

            $quoteMapper = Quote_Models_Mapper_QuoteMapper::getInstance();
            $quoteModel = $quoteMapper->findByCartId($cart->getId());
            if (!$quoteModel instanceof Quote_Models_Model_Quote) {
                $this->_responseHelper->fail(array(
                    'error' => 1,
                    'generalError' => $this->_translator->translate('You can pay only on quote!')
                ));
            }

            if (round($data['amt'], 2) !== $cartSummary['total']) {
                $quoteUrl = $quoteModel->getId().'.html';
                $this->_responseHelper->fail(array('error'=> 1,'redirect'=>$this->_websiteUrl.$quoteUrl));
            }

            $paymentType = $quoteModel->getPaymentType();
            if ($paymentType === Quote_Models_Model_Quote::PAYMENT_TYPE_PARTIAL_PAYMENT) {
                $this->_responseHelper->fail(array(
                    'error' => 1,
                    'generalError' => $this->_translator->translate('You can pay only full payment')
                ));
            }

            if ($paymentType === Quote_Models_Model_Quote::PAYMENT_TYPE_ONLY_SIGNATURE) {
                $this->_responseHelper->fail(array(
                    'error' => 1,
                    'generalError' => $this->_translator->translate('You can pay only full payment')
                ));
            }

            $countryPhoneCodeValue = '+'.Zend_Locale::getTranslation($data['phonecountrycode'], 'phoneToTerritory');
            $phone = preg_replace("/[^0-9]/", '', $data['phone']);
            $fullPhone = $countryPhoneCodeValue.trim($phone);

            //saving billing address//
            $customer  = Tools_ShoppingCart::getInstance()->getCustomer();
            $addressType = Models_Model_Customer::ADDRESS_TYPE_BILLING;
            $billingAddressArray = array();
            $billingAddressArray['firstname'] = isset($data['firstname'])?$data['firstname']:'';
            $billingAddressArray['lastname']  = isset($data['lastname'])?$data['lastname']:'';
            $billingAddressArray['company']   = '';
            $billingAddressArray['email']     = isset($data['email'])?$data['email']:'';
            $billingAddressArray['address1']  = isset($data['billing_address1'])?$data['billing_address1']:'';
            $billingAddressArray['address2']  = isset($data['billing_address2'])?$data['billing_address2']:'';
            $billingAddressArray['country']   = isset($data['country'])?$data['country']:'';
            $billingAddressArray['city']      = isset($data['city'])?$data['city']:'';
            $billingAddressArray['state']     = isset($data['state'])?$data['state']:'';
            $billingAddressArray['zip']       = isset($data['zip'])?$data['zip']:'';
            $billingAddressArray['phone']     = isset($phone)?$phone:'';
            $billingAddressArray['phone_country_code_value']  = isset($countryPhoneCodeValue)?$countryPhoneCodeValue:'';
            $billingAddressArray['phonecountrycode']  = isset($data['phonecountrycode'])?$data['phonecountrycode']:'';
            $billingAddressArray['mobile']    = '';

            $addressId = Models_Mapper_CustomerMapper::getInstance()->addAddress($customer, $billingAddressArray, $addressType);
            $cartStorage->setAddressKey($addressType, $addressId)->save()->saveCartSession($customer);
            //end of saving billing address//

            if ($billingPeriod === self::DAY_PERIOD) {
                $billingFrequency = $quantityPeriods;
                $recurrentPeriod = self::DAY_PERIOD;
            }

            if ($billingPeriod === self::WEEK_PERIOD) {
                $billingFrequency = $quantityPeriods;
                $recurrentPeriod = self::WEEK_PERIOD;
            }

            if ($billingPeriod === self::MONTH_PERIOD) {
                $billingFrequency = $quantityPeriods;
                $recurrentPeriod = self::MONTH_PERIOD;
            }

            if ($billingPeriod === self::YEAR_PERIOD) {
                $billingFrequency = $quantityPeriods;
                $recurrentPeriod = self::YEAR_PERIOD;
            }

            if (empty($recurrentPeriod)) {
                $payResult['error'] = 1;
                $payResult['message'] = "Wrong recurrent payment type";
                $this->_responseHelper->fail(array(
                    'error' => 1,
                    'generalError' => $this->_translator->translate($payResult['message'])
                ));
            }

            $profileData = array();
            $profileData['profileStartDate'] = Tools_System_Tools::convertDateFromTimezone('+'. $billingFrequency .' ' . strtolower($recurrentPeriod));
            $profileData['description'] = $data['desc'];
            $profileData['billingPeriod'] = $recurrentPeriod;
            $profileData['billingFrequency'] = $billingFrequency;
            $profileData['amt'] = $cartSummary['total'];
            $profileData['currencyCode'] = $data['currency_code'];
            $profileData['creditCardNumber'] = $creditCardNum;
            $profileData['expirationDate'] = str_pad($data['expiration_date_month'], 2, '0', STR_PAD_LEFT).$data['expiration_date_year'];
            $profileData['cvv'] = trim($data['verification_number']);
            $profileData['email'] = $data['email'];
            $profileData['street'] = $data['billing_address1'];
            $profileData['city'] = $data['city'];
            $profileData['state'] = $data['state'];
            $profileData['countryCode'] = $data['country'];
            $profileData['zip'] = $data['zip'];
            $profileData['userId'] = $cart->getUserId();
            $profileData['cartId'] = $cartId;
            $profileData['initAmt'] = $cartSummary['total'];

            $createProfileResponse = $this->createRecurringProfile($profileData);

            if ($createProfileResponse['error'] === '1') {
                $payResult['error'] = 1;
                $payResult['message'] = $createProfileResponse['message'];
                $this->updateCartStatus($cartId, Models_Model_CartSession::CART_STATUS_ERROR, false, $payResult['message']);
                $this->_responseHelper->fail(array(
                    'error' => 1,
                    'generalError' => $this->_translator->translate($payResult['message'])
                ));
            } elseif (isset($createProfileResponse['paypalRecurringPaymentsModel']) && $createProfileResponse['paypalRecurringPaymentsModel'] instanceof Paypal_Models_Models_PaypalRecurringPaymentsModel) {
                try {
                    $payResult['error'] = 0;

                    $paypalTransactionMapper = Paypal_Models_Mapper_PaypalTransactionMapper::getInstance();
                    $paypalTransaction = new Paypal_Models_Models_PaypalTransactionModel();
                    $rpModel = $createProfileResponse['paypalRecurringPaymentsModel'];
                    $paypalTransaction->setTxnId('');
                    $paypalTransaction->setPayerId($rpModel->getProfileId());
                    $paypalTransaction->setPayerMail($rpModel->getEmail());
                    $paypalTransaction->setAmount($cartSummary['total']);
                    $paypalTransaction->setShippingAmount('');
                    $paypalTransaction->setTax($cartSummary['totalTax']);
                    $paypalTransaction->setCurrency($rpModel->getCurrencyCode());
                    $paypalTransaction->setPaymentStatus(Models_Model_CartSession::CART_STATUS_COMPLETED);
                    $paypalTransaction->setStatus($rpModel->getPayerStatus());
                    $paypalTransaction->setPaymentType('cart-recurring');
                    $paypalTransaction->setPaymentId($cartId);
                    $paypalTransaction->setPaymentDate(Tools_System_Tools::convertDateFromTimezone('now'));
                    $paypalTransaction->setPFirstName($customer->getFullName());
                    $paypalTransaction->setPLastName($customer->getFullName());
                    $paypalTransaction->setPCountry($rpModel->getCountry());
                    $paypalTransaction->setPCountryCode($rpModel->getCountryCode());
                    $paypalTransaction->setPAddressState($rpModel->getState());
                    $paypalTransaction->setPAddressCity($rpModel->getCity());
                    $paypalTransaction->setPAddressZip($rpModel->getZip());
                    $paypalTransaction->setPAddressName($rpModel->getStreet());
                    $paypalTransaction->setCartId($cartId);
                    $paypalTransaction->setPendingReason('');
                    $paypalTransaction->setSubscribeStatus('active');
                    $paypalTransaction->setSubscribePeriod($billingFrequency);
                    $paypalTransaction->setSubscribePeriodType($recurrentPeriod);
                    $paypalTransaction->setSubscribeDate(Tools_System_Tools::convertDateFromTimezone('now'));
                    $paypalTransaction->setSubscriptionId($rpModel->getProfileId());
                    $paypalTransaction->setSubscriptionDatePayed(Tools_System_Tools::convertDateFromTimezone('now'));
                    $paypalTransaction->setSubscriptionAmountPayed($cartSummary['total']);
                    $paypalTransaction->setEmailSent(1);
                    $paypalTransaction->setCustomerEmailSent(1);
                    $paypalTransactionMapper->save($paypalTransaction);

                    $this->updateCartStatus($cartId, Models_Model_CartSession::CART_STATUS_COMPLETED);

                    $cartSession = Models_Mapper_CartSessionMapper::getInstance()->find($cartId);
                    $this->_sessionHelper->storeCartSessionKey = $cartId;
                    $this->_sessionHelper->storeCartSessionConversionKey = $cartId;
                    if ($cartSession->getStatus() !== Models_Model_CartSession::CART_STATUS_PARTIAL) {
                        $cartSession->registerObserver(new Tools_Mail_Watchdog(array(
                            'trigger' => Tools_StoreMailWatchdog::TRIGGER_NEW_ORDER
                        )));
                    }

                    $shoppingConfig = Models_Mapper_ShoppingConfig::getInstance()->getConfigParams();

                    if (!empty($shoppingConfig[Shopping::SHIPPING_IS_GIFT])) {
                        if (!empty($cartSession->getIsGift())) {
                            $cartSession->registerObserver(new Tools_Mail_Watchdog(array(
                                'trigger' => Tools_StoreMailWatchdog::TRIGGER_STORE_GIFT_ORDER
                            )));
                        }
                    }

                    if ($cartSession->getStatus() === Models_Model_CartSession::CART_STATUS_PARTIAL) {
                        $cartSession->registerObserver(new Tools_Mail_Watchdog(array(
                            'trigger' => Tools_StoreMailWatchdog::TRIGGER_STORE_PARTIALPAYMENT
                        )));
                    }

                    if ($cartSession->getStatus() !== Models_Model_CartSession::CART_STATUS_PARTIAL) {
                        if (class_exists('Tools_AppsServiceWatchdog')) {
                            $cartSession->registerObserver(new Tools_AppsServiceWatchdog());
                        }
                    }

                    $cartSession->notifyObservers();

                    if ($recurrentPeriod === self::MONTH_PERIOD && $billingFrequency == '2') {
                        $paymentPeriod = Api_Store_Recurringtypes::RECURRING_PAYMENT_TYPE_TWO_MONTHS;
                    } elseif ($recurrentPeriod === self::MONTH_PERIOD && $billingFrequency == '3') {
                        $paymentPeriod = Api_Store_Recurringtypes::RECURRING_PAYMENT_TYPE_QUARTER;
                    }  elseif ($recurrentPeriod === self::MONTH_PERIOD && $billingFrequency == '6') {
                        $paymentPeriod = Api_Store_Recurringtypes::RECURRING_PAYMENT_TYPE_SEMESTER;
                    } else {
                        $paymentPeriod = 'recurring-payment-' . strtolower($recurrentPeriod);
                    }

                    Tools_RecurringPaymentTools::createRecurringPaymentInfo($cartId, 65535, $rpModel->getProfileId(), '',
                        $paymentPeriod, $cartSummary['total'], 'paypal', $cartSummary['total'], '', 'active', 1, 1);

                    $this->_responseHelper->success($this->_translator->translate('Payment has been completed'));
                } catch (Exception $e) {
                    $paypalError = $e->getMessage();
                    $this->updateCartStatus($cartId, Models_Model_CartSession::CART_STATUS_ERROR, false, $paypalError);
                    $this->_responseHelper->fail(array(
                        'error' => 1,
                        'generalError' => $this->_translator->translate($paypalError)
                    ));
                }
            }

        }
    }

    /**
     * Generate product unique key in cart
     *
     * @param Models_Model_Product $item
     * @param array $options
     * @return string
     */
    private function _generateStorageKey($item, $options = array())
    {
        return substr(md5($item->getName() . $item->getSku() . http_build_query($options)), 0, 10);
    }

    /**
     *
     * Prepare product options
     *
     * @param array $options
     * @return array
     */
    protected function _parseProductOptions($options)
    {
        $parsedOption = array();
        foreach ($options as $option) {
            $parsedOption[$option['id']] = $option['option_id'];
        }
        return $parsedOption;
    }

    /**
     * Get subscription info
     */
    public function getSubscribeDataAction(){
        $cartStorage = Tools_ShoppingCart::getInstance();
        $cartId = $cartStorage->getCartId();
        $cartSession = Models_Mapper_CartSessionMapper::getInstance()->find($cartId);
        $period = filter_var($this->_request->getParam('paymentPeriod'), FILTER_SANITIZE_STRING);
        $quantityPayments = filter_var($this->_request->getParam('paymentQty'), FILTER_SANITIZE_NUMBER_INT);
        if(!empty($cartSession)){
            $status = $cartSession->getStatus();
            if($status === Models_Model_CartSession::CART_STATUS_COMPLETED || $status === Models_Model_CartSession::CART_STATUS_PENDING){
               if($status === Models_Model_CartSession::CART_STATUS_PENDING  && $cartSession->getGateway() === 'Quote'){

               }else{
                    $this->_responseHelper->fail($this->_translator->translate('Already Payed'));
               }
            }
            $total = $cartSession->getTotal();
            $finalTotal = round($total/$quantityPayments, 2);
            $this->updateCartStatus($cartId, Models_Model_CartSession::CART_STATUS_PROCESSING);
            $this->_responseHelper->success(array('total' => $finalTotal));
        }
        $this->_responseHelper->fail('');
    }

    /**
     * Ipn subscription action
     */
    public function  subscribeIpnAction(){
        $data = $this->_request->getParams();
        if(isset($data['txn_type']) && ($data['txn_type'] === self::TYPE_SUBSCRIBE_PAYMENT || $data['txn_type'] === self::TYPE_SUBSCRIBE_SIGNUP)){
            $currency = filter_var($data['mc_currency'], FILTER_SANITIZE_STRING);
            $address = filter_var($data['address_street'], FILTER_SANITIZE_STRING);
            $verifySign = filter_var($data['verify_sign'], FILTER_SANITIZE_STRING);
            $firstName = filter_var($data['first_name'], FILTER_SANITIZE_STRING);
            $lastName = filter_var($data['last_name'], FILTER_SANITIZE_STRING);
            $payerEmail = filter_var($data['payer_email'], FILTER_SANITIZE_STRING);
            $addressState = filter_var($data['address_state'], FILTER_SANITIZE_STRING);
            $ipnTrackingId = filter_var($data['ipn_track_id'], FILTER_SANITIZE_STRING);
            $cartId = filter_var($data['custom'], FILTER_SANITIZE_STRING);
            $subscriptionId = $data['subscr_id'];
            $zip = filter_var($data['address_zip'], FILTER_SANITIZE_STRING);
            $addressName = filter_var($data['address_name'], FILTER_SANITIZE_STRING);

            $paypalTransactionMapper = Paypal_Models_Mapper_PaypalTransactionMapper::getInstance();
            $subscribeExist = $paypalTransactionMapper->getSubscribeBySubscribeId($subscriptionId);

            $cartSessionMapper = Models_Mapper_CartSessionMapper::getInstance();
            $cartContent = $cartSessionMapper->find(intval($cartId));
            if(!empty($cartContent)){
                if($data['txn_type'] === self::TYPE_SUBSCRIBE_SIGNUP){
                    $country = filter_var($data['address_country_code'], FILTER_SANITIZE_STRING);
                    $city = filter_var($data['address_city'], FILTER_SANITIZE_STRING);
                    $recurTimes = filter_var($data['recur_times'], FILTER_SANITIZE_NUMBER_INT);
                    $subscribeDate = filter_var($data['subscr_date'], FILTER_SANITIZE_STRING);

                    $period = filter_var($data['period3'], FILTER_SANITIZE_STRING);

                    $subscribeAmount = $data['mc_amount3'];
                    $periodData = explode(' ', $period);
                    $subscribeCycle = $periodData[0];
                    $subscribePeriodType = $periodData[1];
                }
                if($data['txn_type'] === self::TYPE_SUBSCRIBE_PAYMENT){
                    $paymentStatus = filter_var($data['payment_status'], FILTER_SANITIZE_STRING);
                    $pendingReason = filter_var($data['pending_reason'], FILTER_SANITIZE_STRING);
                    $paymentDate = filter_var($data['payment_date'], FILTER_SANITIZE_STRING);
                    $payerId = filter_var($data['payer_id'], FILTER_SANITIZE_STRING);
                    $txnId = filter_var($data['txn_id'], FILTER_SANITIZE_STRING);
                    if($paymentStatus === 'Completed'){
                        $paymentStatus = Models_Model_CartSession::CART_STATUS_COMPLETED;
                    }
                    if($paymentStatus === 'Pending'){
                        $paymentStatus = Models_Model_CartSession::CART_STATUS_PENDING;
                    }

                    $paymentData = array(
                      'status' => $paymentStatus,
                      'subscriptionAmountPayed' => $data['mc_gross'],
                      'pendingReason' => $pendingReason,
                      'subscriptionDatePayed'=> $paymentDate,
                      'payerId' => $payerId,
                      'txnId'  => $txnId
                    );
                }
                $paypalConfigMapper = Paypal_Models_Mapper_PaypalConfigMapper::getInstance();
                $paypalSettings = $paypalConfigMapper->selectSettings();
                $useSandbox = $paypalSettings[0]->getUseSandbox();
                if($useSandbox == 1) {
                    $endPoint = $this->buttonSandBoxValidateEndPoin; //https://www.sandbox.paypal.com/
                }
                else {
                    $endPoint = $this->buttonValidateEndPoin; //'https://www.paypal.com/cgi-bin/webscr'
                }
                $ipnData = http_build_query(array_merge(array('cmd' => '_notify-validate'), $_POST));
                $validateIpn = $this->getTransactionValidation($ipnData, $endPoint);

                //validation for saving
                if (trim($validateIpn) === 'VERIFIED') {
                    if($data['txn_type'] === self::TYPE_SUBSCRIBE_SIGNUP && empty($subscribeExist)){
                        //saving billing address//
                        $addressType = Models_Model_Customer::ADDRESS_TYPE_BILLING;
                        $billCountryResult = '';
                        $billStateResult = '';
                        $countries = Tools_Geo::getCountries(true);
                        if(isset($country)){
                            if(in_array($country, $countries)){
                                $billCountryResult = array_search($country, $countries);
                            }
                            if(array_key_exists($country, $countries)){
                                    $billCountryResult = $country;
                                }
                            }
                            $states = Tools_Geo::getState(null, true);
                            if(isset($addressState)){
                                if(in_array($addressState, $states)){
                                    $billStateResult = array_search($addressState, $states);
                                }
                            }
                            $billingAddressArray = array();
                            $billingAddressArray['firstname'] = isset($firstName)?$firstName:'';
                            $billingAddressArray['lastname']  = isset($lastName)?$lastName:'';
                            $billingAddressArray['company']   = '';
                            $billingAddressArray['email']     = isset($payerMail)?$payerMail:'';
                            $billingAddressArray['address1']  = isset($address)?$address:'';
                            $billingAddressArray['address2']  = '';
                            $billingAddressArray['country']   = $billCountryResult;
                            $billingAddressArray['city']      = isset($city)?$city:'';
                            $billingAddressArray['state']     = $billStateResult;
                            $billingAddressArray['zip']       = isset($zip)?$zip:'';
                            $billingAddressArray['phone']     = '';
                            $billingAddressArray['mobile']    = '';
                            $addressId = $this->_addAddress($cartContent->getUserId(), $billingAddressArray, $addressType);
                            $cartContent->setBillingAddressId($addressId);
                            $cartSessionMapper->save($cartContent);

                            $paypalTransactionModel = new Paypal_Models_Models_PaypalTransactionModel();
                            $paypalTransactionModel->setTxnId('');
                            $paypalTransactionModel->setPayerId('');
                            $paypalTransactionModel->setPayerMail($payerEmail);
                            $paypalTransactionModel->setAmount($subscribeAmount);
                            $paypalTransactionModel->setShippingAmount(0);
                            $paypalTransactionModel->setTax(0);
                            $paypalTransactionModel->setCurrency($currency);
                            $paypalTransactionModel->setPaymentStatus('');
                            $paypalTransactionModel->setStatus(Models_Model_CartSession::CART_STATUS_PROCESSING);
                            $paypalTransactionModel->setPaymentType(self::TYPE_SUBSCRIBE);
                            $paypalTransactionModel->setPaymentId($cartId);
                            $paypalTransactionModel->setPaymentDate('');
                            $paypalTransactionModel->setPFirstName($firstName);
                            $paypalTransactionModel->setPLastName($lastName);
                            $paypalTransactionModel->setPCountry($country);
                            $paypalTransactionModel->setPCountryCode('');
                            $paypalTransactionModel->setPAddressState($addressState);
                            $paypalTransactionModel->setPAddressCity($city);
                            $paypalTransactionModel->setPAddressZip($zip);
                            $paypalTransactionModel->setPAddressName($addressName);
                            $paypalTransactionModel->setCartId($cartId);
                            $paypalTransactionModel->setPendingReason('');
                            //subscribe info
                            $paypalTransactionModel->setSubscribePeriod($subscribeCycle);
                            $paypalTransactionModel->setSubscribePeriodType($subscribePeriodType);
                            $paypalTransactionModel->setSubscribeQuantity($recurTimes);
                            $paypalTransactionModel->setSubscribeStatus('');
                            $paypalTransactionModel->setSubscribeAmount($subscribeAmount);
                            $paypalTransactionModel->setSubscribeDate($subscribeDate);
                            $paypalTransactionModel->setSubscriptionId($subscriptionId);
                            $paypalTransactionMapper->save($paypalTransactionModel);
                    }elseif($data['txn_type'] === self::TYPE_SUBSCRIBE_PAYMENT && !empty($subscribeExist)){
                        $previousPaymentDate = $subscribeExist[0]->getSubscriptionDatePayed();
                        if($previousPaymentDate !== $paymentDate) {
                            $previousPayedAmount = $subscribeExist[0]->getSubscriptionAmountPayed();
                            if($previousPayedAmount !== ''){
                                $paymentData['subscriptionAmountPayed'] = $paymentData['subscriptionAmountPayed'] + $previousPayedAmount;
                            }
                            $paypalTransactionMapper->updateSubscription($paymentData, $subscriptionId);
                            $cartSessionDbTable = new Models_DbTable_CartSession();
                            $where = $cartSessionDbTable->getAdapter()->quoteInto('id=?', $cartId);
                            $data = array(
                              'total' => $paymentData['subscriptionAmountPayed']
                            );
                            $cartSessionDbTable->getAdapter()->update('shopping_cart_session', $data, $where);
                            $this->updateCartStatus($cartId, $paymentData['status']);
                            //sending email or new order
                            $this->_sessionHelper->storeCartSessionKey = $cartId;
                            $cartContent->registerObserver(new Tools_Mail_Watchdog(array(
                                    'trigger' => Tools_StoreMailWatchdog::TRIGGER_NEW_ORDER
                                )));
                            $cartContent->notifyObservers();
                            //end of sending new order email
                        }
                    }elseif(isset($data['txn_type']) && $data['txn_type'] === self::TYPE_SUBSCRIBE_CANCEL && !empty($subscribeExist)){
                        $paymentDate = filter_var($data['payment_date'], FILTER_SANITIZE_STRING);
                        $paymentData = array(
                            'status' => Models_Model_CartSession::CART_STATUS_CANCELED,
                            'subscriptionDatePayed' => $paymentDate
                        );
                        $paypalTransactionMapper->updateSubscription($paymentData, $subscriptionId);
                        $this->updateCartStatus($cartId, $paymentData['status']);
                    }else{
                        $this->_responseHelper->fail('');
                    }
                }
            }else{
                $this->_responseHelper->fail('');
            }

        }
    }

    /**
     * Paypal button
     *
     * @return string
     */
    public function _makeOptionButton(){
        $paypalConfigMapper = Paypal_Models_Mapper_PaypalConfigMapper::getInstance();
        $paypalSettings = $paypalConfigMapper->selectSettings();
        $useSandbox = $paypalSettings[0]->getUseSandbox();
        $apiSignature = $paypalSettings[0]->getApiSignature();
        $apiUser = $paypalSettings[0]->getApiUser();
        $cartContent = Tools_ShoppingCart::getInstance();
        $productList = array_values($cartContent->getContent());
        $this->_view->translator = $this->_translator;
        $shoppingConfig = Models_Mapper_ShoppingConfig::getInstance()->getConfigParams();
        if(isset($this->_options[1])){
            $this->_view->customButton = true;
        }
        $customLabel = self::BUTTON_LABEL;
        if(isset($this->_options[2])){
            $customLabel = $this->_options[2];
        }
        $this->_view->customLabel = $customLabel;
        if(!empty ($productList)){
            $this->_view->email = $paypalSettings[0]->getEmail();
            $this->_view->apiSignature = $apiSignature;
            $this->_view->apiUser = $apiUser;
            $this->_view->apiPassword = $paypalSettings[0]->getApiPassword();
            $this->_view->useSandBox = $useSandbox;
            $this->_view->productList = $productList;
            $cartParams = $cartContent->calculate();
            $cartId = $cartContent->getCartId();
            $this->_view->totalTax = round($cartParams['totalTax'],2);
            $this->_view->shipping = round($cartParams['shipping'],2);
            $this->_view->totalAmount = round($cartParams['total'],2);
            $this->_view->discount = round($cartParams['discount'],2);
            $this->_view->cartId = $cartId;
            if (!empty($shoppingConfig['country'])) {
                $this->_view->shoppingCountry = $shoppingConfig['country'];
            } else {
                $this->_view->shoppingCountry = 'US';
            }
            $shippingAddressKey = Tools_ShoppingCart::getInstance()->getAddressKey(Models_Model_Customer::ADDRESS_TYPE_SHIPPING);
            if($shippingAddressKey != null){
                $paymentParams = Tools_ShoppingCart::getAddressById($shippingAddressKey);
                if(isset($paymentParams['state'])){
                        $state = Tools_Geo::getStateById($paymentParams['state']);
                        $paymentParams['state'] = $state['state'];
                        $this->_view->firstName = $paymentParams['firstname'];
                        $this->_view->lastName = $paymentParams['lastname'];
                        $this->_view->address1 = $paymentParams['address1'];
                        $this->_view->address2 = $paymentParams['address2'];
                        $this->_view->shippingEmail = $paymentParams['email'];
                        $this->_view->city = $paymentParams['city'];
                        $this->_view->state = $paymentParams['state'];
                        $this->_view->zip = $paymentParams['zip'];
                        $this->_view->country = $paymentParams['country'];
                        $this->_view->allowShipping = true;

                }
            }
            $this->_view->currency = Models_Mapper_ShoppingConfig::getInstance()->getConfigParam('currency');
            if($useSandbox == 1) {
               $this->_view->endPoint = $this->buttonSandBoxEndPoin; //https://www.sandbox.paypal.com/
            }
            else {
               $this->_view->endPoint = $this->buttonLiveEndPoin; //'https://www.paypal.com/cgi-bin/webscr'
            }
            if (!empty($this->_options['1']) && $this->_options['1'] === self::BUTTON_TYPE_HOSTED_PAYMENT) {
                $this->_view->subTotalAmount = round($cartParams['subTotal'],2);
                if($useSandbox == 1) {
                    $this->_view->endPoint = $this->_buttonHostedSandboxEndPoint;
                }
                else {
                    $this->_view->endPoint = $this->_buttonHostedLiveEndPoint;
                }
                return $this->_view->render('button-hosted.phtml');
            } else {
                return $this->_view->render("button.phtml");
            }

        }
    }

    public function _makeOptionProduct()
    {
        if (Tools_Security_Acl::isAllowed(Shopping::RESOURCE_STORE_MANAGEMENT)) {
            return '';
        }
        $paypalSettings = Paypal_Models_Mapper_PaypalConfigMapper::getInstance()->getConfigParams();
        if (!empty($paypalSettings)) {
            $this->_view->translator = $this->_translator;
            if (isset($this->_options[1]) && isset($this->_options[2])) {
                $quantityPeriods = $this->_options[1];
                $billingPeriod = ucfirst(strtolower(trim($this->_options[2])));
                if (!in_array($billingPeriod, self::SUBSCRIBE_BILLING_PERIODS)) {
                    return $this->_translator->translate('Wrong billing period provided.');
                }
                $this->_view->quantityPeriods = $quantityPeriods;
                $this->_view->billingPeriod = $billingPeriod;
            } else {
                return $this->_translator->translate('Wrong subscription configuration.');
            }
            $shoppingConfigMapper = Models_Mapper_ShoppingConfig::getInstance();
            $session = Zend_Controller_Action_HelperBroker::getStaticHelper('session');

            $currentLoggedUser = $session->getCurrentUser();
            if ($currentLoggedUser instanceof Application_Model_Models_User && $currentLoggedUser->getId()) {
                $userFullName = explode(' ', $currentLoggedUser->getFullName());
                $this->_view->firstName = is_array($userFullName) ? $userFullName[0] : '';
                $this->_view->lastName = isset($userFullName[1]) ? $userFullName[1] : '';
                $this->_view->billingEmail = $currentLoggedUser->getEmail();
                $this->_view->isUserLoggedIn = true;
            } else {
                $this->_view->firstName = '';
                $this->_view->lastName = '';
                $this->_view->billingEmail = '';
                $this->_view->address1 = '';
                $this->_view->city = '';
                $this->_view->zip = '';
                $this->_view->isUserLoggedIn = false;
            }
            $this->_view->email = $paypalSettings['email'];
            $this->_view->apiSignature = $paypalSettings['apiSignature'];
            $this->_view->apiUser = $paypalSettings['apiUser'];
            $this->_view->apiPassword = $paypalSettings['apiPassword'];
            $this->_view->useSandBox = $paypalSettings['useSandbox'];
            $this->_view->currency = Models_Mapper_ShoppingConfig::getInstance()->getConfigParam('currency');
            $this->_view->countryList = $this->_prepareCountryList();
            $country = $shoppingConfigMapper->getConfigParam('country');
            if ($country != '') {
                $predefinedCountry = $country;
            } else {
                $predefinedCountry = 'US';
            }
            $phonecountrycodes = Tools_System_Tools::getFullCountryPhoneCodesList(true, array(), true);
            $this->_view->phonecountrycode = $predefinedCountry;
            $listMasksMapper = Application_Model_Mappers_MasksListMapper::getInstance();
            $this->_view->phonecountrycodes = $phonecountrycodes;
            $this->_view->desktopMasks = $listMasksMapper->getListOfMasksByType(Application_Model_Models_MaskList::MASK_TYPE_DESKTOP);
            $this->_view->phone = '';
            $listOfStates = $this->stateCheck($predefinedCountry);
            if ($listOfStates['error'] != '1') {
                $this->_view->listOfState = $listOfStates[0];
            }
            $this->_view->predefinedCountry = $predefinedCountry;

            return $this->_view->render("single-product-payment.phtml");

        } elseif (Tools_Security_Acl::isAllowed(Tools_Security_Acl::RESOURCE_PLUGINS)) {
            return $this->_translator->translate(
                'Plugin is not configured.'
            );
        }
    }

    /**
     * Get country list
     *
     * @return array
     */
    private function _prepareCountryList(){
        $data = Tools_Geo::getCountries(true);
		asort($data);
		return $data;
	}

    /**
     * Prepare states list
     *
     * @param string $country
     * @return array
     */
    public function stateCheck($country){
        $pairs = true;
        $stateData = Tools_Geo::getState($country, $pairs);
        if(!empty ($stateData)){
            $states = '';
            foreach($stateData as $short=>$state){
               $states .= '<option value="'.$short.'">'.$state.'</option>';
            }
           return array('error'=>'0',$states);
        }
        else{
           return  array('error'=>'1');
        }
    }

    /**
     * Prepare shipping data before starting payment with paypal button
     */
    public function getButtonShippingDataAction(){
       $cartStorage = Tools_ShoppingCart::getInstance();
       $cartId = $cartStorage->getCartId();
       $cartSession = Models_Mapper_CartSessionMapper::getInstance()->find($cartId);
       $amount = $this->_request->getParam('amount');
       $paymentPart = $this->_request->getParam('paymentPart');
       if(!empty($cartSession)){
           $cartSummary = $cartStorage->calculate();
           $cartSummary['total'] = round($cartSummary['total'], 2);
           if (round($amount, 2) !== $cartSummary['total']) {
               $checkout = Tools_Misc::getCheckoutPage();
               $this->_responseHelper->fail(array('error'=> 1,'redirect'=>$this->_websiteUrl.$checkout->getUrl()));
           }
           if (Models_Mapper_ShoppingConfig::getInstance()->getConfigParam('throttleTransactions') === 'true' && Tools_Misc::checkThrottleTransactionsLimit() === false) {
               $throttleTransactionsLimitMessage = Models_Mapper_ShoppingConfig::getInstance()->getConfigParam('throttleTransactionsLimitMessage');
               $throttleTransactionsLimitMessage = !empty($throttleTransactionsLimitMessage) ? $throttleTransactionsLimitMessage : Tools_Misc::THROTTLE_TRANSACTIONS_DEFAULT_MESSAGE;
               $this->_responseHelper->fail(array(
                   'error' => 1,
                   'redirect' => $this->_websiteUrl . $this->_websiteHelper->getDefaultPage(),
                   'throttleLimitMessage' => $throttleTransactionsLimitMessage
               ));
           };


           if ($cartSession->getGateway() === 'Quote') {
               $quoteMapper = Quote_Models_Mapper_QuoteMapper::getInstance();
               $quoteModel = $quoteMapper->findByCartId($cartSession->getId());
               if ($quoteModel instanceof Quote_Models_Model_Quote) {
                   $signatureRequired = $quoteModel->getIsSignatureRequired();
                   if (!empty($signatureRequired) && empty($quoteModel->getIsQuoteSigned())) {
                       $this->_responseHelper->fail(array(
                           'error' => 1,
                           'generalError' => $this->_translator->translate('Please sign the quote!')
                       ));
                   }

               }

           }


           $status = $cartSession->getStatus();
           if($status == Models_Model_CartSession::CART_STATUS_COMPLETED || $status == Models_Model_CartSession::CART_STATUS_PENDING){
               if($status === Models_Model_CartSession::CART_STATUS_PENDING  && $cartSession->getGateway() === 'Quote'){

               }else{
                   $thankyouPage = Application_Model_Mappers_PageMapper::getInstance()->fetchByOption(self::OPTION_THANKYOU,
                       true);
                   if (!$thankyouPage) {
                       $this->_responseHelper->fail(array(
                           'error' => 1,
                           'redirect' => $this->_websiteUrl . $this->_websiteHelper->getDefaultPage()
                       ));
                   } else {
                       $this->_sessionHelper->storeCartSessionKey = $cartId;
                       $this->_sessionHelper->storeCartSessionConversionKey = $cartId;
                       $cartStorage->clean();
                       $this->_responseHelper->fail(array(
                           'error' => 1,
                           'redirect' => $this->_websiteUrl . $thankyouPage->getUrl()
                       ));
                   }

                   return;
               }
           }

           if ($status == Models_Model_CartSession::CART_STATUS_PARTIAL && !empty($paymentPart)) {
               if (!empty((int) $cartSession->getPartialPaidAmount()) && $paymentPart == 'first') {
                   $quoteMapper = Quote_Models_Mapper_QuoteMapper::getInstance();
                   $quoteModel = $quoteMapper->findByCartId($cartSession->getId());
                   if ($quoteModel instanceof Quote_Models_Model_Quote) {
                       $quotePage = Application_Model_Mappers_PageMapper::getInstance()->findByUrl($quoteModel->getId().'.html');
                       if ($quotePage instanceof Application_Model_Models_Page) {
                           $quotePageUrl = $quotePage->getUrl();
                           $this->_responseHelper->fail(array(
                               'error' => 1,
                               'redirect' => $this->_websiteUrl . $quotePageUrl
                           ));
                       }
                   }
               }
           }

           //save emails status info
           $paypalTransactionMapper = Paypal_Models_Mapper_PaypalTransactionMapper::getInstance();
           $transactionExists = $paypalTransactionMapper->findByCartId($cartId);
           if (!empty($transactionExists)) {
               $paypalTransaction = $transactionExists[0];
           } else{
               $paypalTransaction  = new Paypal_Models_Models_PaypalTransactionModel();
               $paypalTransaction->setCartId($cartId);
               $paypalTransaction->setPaymentId($cartId);
           }

           if (isset($this->_sessionHelper->storeIsNewCustomer))  {
               $paypalTransaction->setCustomerEmailSent(0);
           } else {
               $paypalTransaction->setCustomerEmailSent(1);
           }

           if (isset($this->_sessionHelper->clientWithNewPassword)) {
               $paypalTransaction->setUserSetPassword(1);
           } else {
               $paypalTransaction->setUserSetPassword(0);
           }

           $paypalTransaction->setEmailSent(0);
           $paypalTransactionMapper->save($paypalTransaction);
       }
       //affiliate block
       $enabledPlugins = Tools_Plugins_Tools::getEnabledPlugins();
       foreach ($enabledPlugins as $plugin) {
          if($plugin->getName() == 'seosambaaffiliatenetwork'){
              $affiliate = Tools_Factory_PluginFactory::createPlugin('seosambaaffiliatenetwork');
              $affiliateStatus = $affiliate->affiliateSave($cartId, 'paypal', 'button');
          }
       }
       //affiliate end
       $this->updateCartStatus($cartId, Models_Model_CartSession::CART_STATUS_PROCESSING);
       echo json_encode(array('error'=>0));

    }

    /**
     * Success action
     */
    public function successAction(){
        $this->_redirector->gotoUrl($this->_websiteUrl.'plugin/shopping/run/thankyou/');
    }

    public function successIpnAction(){
        $cartId = Tools_ShoppingCart::getInstance()->getCartId();
        if ($cartId) {
            $paypalTransactionMapper = Paypal_Models_Mapper_PaypalTransactionMapper::getInstance();
            $transactionExists = $paypalTransactionMapper->findByCartId($cartId);
            $emailSent = false;
            $customerEmailSent = false;
            if (!empty($transactionExists)) {
                $paypalTransactionConfig = $transactionExists[0];
                $emailSent = $paypalTransactionConfig->getEmailSent();
                $customerEmailSent = $paypalTransactionConfig->getCustomerEmailSent();
            } else{
                $paypalTransactionConfig  = new Paypal_Models_Models_PaypalTransactionModel();
            }
            if (!$emailSent) {
                $paypalTransactionConfig->setCartId($cartId);
                $paypalTransactionConfig->setEmailSent(1);
                $paypalTransactionConfig->setCustomerEmailSent(1);
                $paypalTransactionMapper->save($paypalTransactionConfig);
                $this->_redirector->gotoUrl($this->_websiteUrl.'plugin/shopping/run/thankyou/');
            }
            if (isset($this->_sessionHelper->storeIsNewCustomer) && empty($customerEmailSent)) {
                $cartSession = Models_Mapper_CartSessionMapper::getInstance()->find($cartId);
                $status = $cartSession->getStatus();
                if ($status === Models_Model_CartSession::CART_STATUS_COMPLETED || $status === Models_Model_CartSession::CART_STATUS_PENDING || $status === Models_Model_CartSession::CART_STATUS_PARTIAL) {
                    $customer = Models_Mapper_CustomerMapper::getInstance()->find($cartSession->getUserId());
                    if (!isset($this->_sessionHelper->clientWithNewPassword)) {
                        $userMapper = Application_Model_Mappers_UserMapper::getInstance();
                        $userData = $userMapper->find($cartSession->getUserId());
                        $newCustomerPassword = uniqid('customer_' . time());
                        $userData->setPassword($newCustomerPassword);
                        $userMapper->save($userData);
                        $customer->setPassword($newCustomerPassword);
                    }

                    $customer->registerObserver(new Tools_Mail_Watchdog(array(
                        'trigger' => Tools_StoreMailWatchdog::TRIGGER_NEW_CUSTOMER
                    )));
                    $customer->notifyObservers();
                    $paypalTransactionConfig->setCartId($cartId);
                    $paypalTransactionConfig->setCustomerEmailSent(1);
                    $paypalTransactionMapper->save($paypalTransactionConfig);
                    unset($this->_sessionHelper->storeIsNewCustomer);
                }
            } elseif(isset($this->_sessionHelper->storeIsNewCustomer)) {
                unset($this->_sessionHelper->storeIsNewCustomer);
            }
            $thankYouPage = Application_Model_Mappers_PageMapper::getInstance()->fetchByOption(Shopping::OPTION_THANKYOU,
                true);
            if ($thankYouPage instanceof Application_Model_Models_Page) {
                $this->_sessionHelper->storeCartSessionKey = $cartId;
                $this->_sessionHelper->storeCartSessionConversionKey = $cartId;
                $this->_redirector->gotoUrl($this->_websiteUrl . $thankYouPage->getUrl());
            } else {
                $this->_redirector->gotoUrl($this->_websiteUrl);
            }
        }

        $this->_redirector->gotoUrl($this->_websiteUrl);
    }

    /**
     * Paypal ipn response action
     *
     * sandbox.paypal.com/cgi-bin/webscr?cmd=_display-ipns-history
     *
    mc_gross=80.50&protection_eligibility=Eligible&address_status=confirmed&payer_id=PJLGP24R6YNRL&address_street=3136 Hilton Road&payment_date=08:54:10 Sep 03, 2020 PDT&payment_status=Completed&charset=windows-1252&address_zip=48220&first_name=test&mc_fee=2.63&address_country_code=US&address_name=Alex Test&notify_version=3.9&custom=3160_partial&payer_status=verified&business=recurring_paypal_test@gmail.com&address_country=United States&address_city=Ferndale&quantity=1&verify_sign=AlKdba6nQsXUbUP4Whs9staev2QzAHB29GPZV4VTHjkzpusNj27mlyWh&payer_email=alexandra-buyer@seosamba.com&txn_id=63W00967NJ597500P&payment_type=instant&last_name=buyer&address_state=TX&receiver_email=recurring_paypal_test@gmail.com&payment_fee=2.63&shipping_discount=0.00&insurance_amount=0.00&receiver_id=GDGHFQSFEU8ZS&txn_type=web_accept&item_name=&discount=0.00&mc_currency=USD&item_number=&residence_country=US&test_ipn=1&shipping_method=Default&transaction_subject=&payment_gross=80.50&ipn_track_id=9a6c63b8b6f47
     *
     * mc_gross=34.50&protection_eligibility=Eligible&address_status=confirmed&payer_id=PJLGP24R6YNRL&address_street=3136 Hilton Road&payment_date=01:31:14 Sep 04, 2020 PDT&payment_status=Completed&charset=windows-1252&address_zip=48220&first_name=test&mc_fee=1.30&address_country_code=US&address_name=Alex Test&notify_version=3.9&custom=3160_partial&payer_status=verified&business=recurring_paypal_test@gmail.com&address_country=United States&address_city=Ferndale&quantity=1&verify_sign=AFUzd6d5BFLcPs.756upyW0L6Uo6ATSHT5GQvzqqp5Jj7xw4pSfwQQrS&payer_email=alexandra-buyer@seosamba.com&txn_id=9V9689840J4591709&payment_type=instant&last_name=buyer&address_state=TX&receiver_email=recurring_paypal_test@gmail.com&payment_fee=1.30&shipping_discount=0.00&insurance_amount=0.00&receiver_id=GDGHFQSFEU8ZS&txn_type=web_accept&item_name=&discount=0.00&mc_currency=USD&item_number=&residence_country=US&test_ipn=1&shipping_method=Default&transaction_subject=&payment_gross=34.50&ipn_track_id=f5e6a57deb0ed
     *
     */
    public function ipnAction(){
        $txnId = urldecode($this->_request->getParam('txn_id'));
        $payerId = urldecode($this->_request->getParam('payer_id'));
        $payerMail = urldecode($this->_request->getParam('payer_email'));
        $amount = urldecode($this->_request->getParam('mc_gross'));
        $shipAmount = urldecode($this->_request->getParam('mc_shipping1'));
        $tax = urldecode($this->_request->getParam('tax'));
        $currency = urldecode($this->_request->getParam('mc_currency'));
        $paymentStatus = urldecode($this->_request->getParam('payment_status'));
        $status = urldecode($this->_request->getParam('payer_status'));
        $pstTime = date_parse(urldecode($this->_request->getParam('payment_date')));
        $paymentDate = $pstTime['year'].'-'.$pstTime['month'].'-'.$pstTime['day'].' '.$pstTime['hour'].':'.$pstTime['minute'].':'.$pstTime['second'];
        $pFirstName = urldecode($this->_request->getParam('first_name'));
        $pLastName = urldecode($this->_request->getParam('last_name'));
        $pCountry = urldecode($this->_request->getParam('address_country'));
        $pCountryCode = urldecode($this->_request->getParam('address_country_code'));
        $pAddressState = urldecode($this->_request->getParam('address_state'));
        $pAddressCity = urldecode($this->_request->getParam('address_city'));
        $pAddressZip = urldecode($this->_request->getParam('address_zip'));
        $pPhone = urldecode($this->_request->getParam('contact_phone'));
        $pAddressStreet = urldecode($this->_request->getParam('address_street'));
        $cartId = urldecode($this->_request->getParam('custom'));
        $pending = urldecode($this->_request->getParam('pending_reason'));
        $pendingReason = '';
        if(isset($pending)){
          $pendingReason = $pending;
        }

        if ($paymentStatus === 'Refunded') {
            $paymentStatus = Models_Model_CartSession::CART_STATUS_REFUNDED;
        }

        if($paymentStatus == 'Completed'){
            $paymentStatus = Models_Model_CartSession::CART_STATUS_COMPLETED;
        }
        if($paymentStatus == 'Pending'){
            $paymentStatus = Models_Model_CartSession::CART_STATUS_PENDING;
        }

        $partialPayment = false;
        $cartSession = Models_Mapper_CartSessionMapper::getInstance();
        if (preg_match('~\_partial~ui', $cartId)) {
            $cartId = str_replace('_partial', '', $cartId);
            $partialPayment = true;
        }

        $cartContent = $cartSession->find($cartId);
        $paypalTransactionMapper = Paypal_Models_Mapper_PaypalTransactionMapper::getInstance();

        $paypalConfigMapper = Paypal_Models_Mapper_PaypalConfigMapper::getInstance();
        $paypalSettings = $paypalConfigMapper->selectSettings();
        $useSandbox = $paypalSettings[0]->getUseSandbox();
        if($useSandbox == 1) {
            $endPoint = $this->buttonSandBoxValidateEndPoin; //https://www.sandbox.paypal.com/
        }
        else {
            $endPoint = $this->buttonValidateEndPoin; //'https://www.paypal.com/cgi-bin/webscr'
        }
        $ipnData = http_build_query(array_merge(array('cmd' => '_notify-validate'), $_POST));
        $validateIpn = $this->getTransactionValidation($ipnData, $endPoint);
        //validation for saving
        if (trim($validateIpn) === 'VERIFIED' && $cartContent != null) {
            $transactionExists = $paypalTransactionMapper->findByCartId($cartId);
            $emailSent = false;
            if (!empty($transactionExists)) {
                $paypalTransactionConfig = $transactionExists[0];
                $emailSent = $paypalTransactionConfig->getEmailSent();
            } else{
                $paypalTransactionConfig  = new Paypal_Models_Models_PaypalTransactionModel();
            }

            $cartTotal = $cartContent->getTotal();
            $billingFirstName = isset($pFirstName)?$pFirstName:'';
            $billingLastName= isset($pLastName)?$pLastName:'';
            $billingEmail = isset($payerMail)?$payerMail:'';
            $billingAddressStreet = isset($pAddressStreet)?$pAddressStreet:'';

            $customerShippingAddress = array();
            $shippingAddressId = $cartContent->getShippingAddressId();
            if (!empty($shippingAddressId)) {
                $addressTable = new Models_DbTable_CustomerAddress();
                $where = $addressTable->getAdapter()->quoteInto('id = ?', $shippingAddressId);
                $customerShippingAddress = $addressTable->getAdapter()->fetchRow($addressTable->select()->from('shopping_customer_address')->where($where));
            }

            if (!empty($customerShippingAddress)) {
                if (empty($billingFirstName)) {
                    $billingFirstName = $customerShippingAddress['firstname'];
                }
                if (empty($billingLastName)) {
                    $billingLastName = $customerShippingAddress['lastname'];
                }
                if (empty($billingEmail)) {
                    $billingEmail = $customerShippingAddress['email'];
                }
                if (empty($billingAddressStreet)) {
                    $billingAddressStreet = $customerShippingAddress['address1'];
                }
            }

            //saving billing address//
            $cartSessionMapper = Models_Mapper_CartSessionMapper::getInstance();
            $cartSession = $cartSessionMapper->find($cartId);
            $addressType = Models_Model_Customer::ADDRESS_TYPE_BILLING;
            $billCountryResult = '';
            $billStateResult = '';
            $countries = Tools_Geo::getCountries(true);
            if (empty($pCountryCode) && !empty($customerShippingAddress)) {
                $pCountryCode = $customerShippingAddress['country'];
            }


            if(isset($pCountryCode)){
                if(in_array($pCountryCode, $countries)){
                    $billCountryResult = array_search($pCountryCode, $countries);
                }
                if(array_key_exists($pCountryCode, $countries)){
                    $billCountryResult = $pCountryCode;
                }
            }


            $states = Tools_Geo::getState(null, true);
            if(isset($pAddressState)){
                if(in_array($pAddressState, $states)){
                    $billStateResult = array_search($pAddressState, $states);
                } elseif (!empty($pAddressState)) {
                    $billStateResult = $pAddressState;
                }
            }
            $billingAddressArray = array();
            $billingAddressArray['firstname'] = $billingFirstName;
            $billingAddressArray['lastname']  = $billingLastName;
            $billingAddressArray['company']   = '';
            $billingAddressArray['email']     = $billingEmail;
            $billingAddressArray['address1']  = $billingAddressStreet;
            $billingAddressArray['address2']  = '';
            $billingAddressArray['country']   = $billCountryResult;
            $billingAddressArray['city']      = isset($pAddressCity)?$pAddressCity:'';
            $billingAddressArray['state']     = $billStateResult;
            $billingAddressArray['zip']       = isset($pAddressZip)?$pAddressZip:'';
            $billingAddressArray['phone']     = isset($pPhone)?$pPhone:'';
            $billingAddressArray['mobile']    = isset($pPhone)?$pPhone:'';

            $partialPaymentType = $cartSession->getPartialType();
            if ($partialPayment === true) {
                $partialPaidAmount = $cartSession->getPartialPaidAmount();
                $cartSession->setIsPartial('1');
                if (!empty($partialPaidAmount) && $partialPaidAmount !== '0.00') {
                    $cartSession->setPartialPaidAmount($cartSession->getTotal());
                } else {
                    if ($partialPaymentType === Models_Model_CartSession::CART_PARTIAL_PAYMENT_TYPE_AMOUNT) {
                        $cartSession->setPartialPaidAmount(round($cartSession->getPartialPercentage(),
                            2));
                    } else {
                        $cartSession->setPartialPaidAmount(round(($cartSession->getTotal() * $cartSession->getPartialPercentage()) / 100,
                            2));
                    }
                    $paymentStatus = Models_Model_CartSession::CART_STATUS_PARTIAL;
                }

                if ($paypalTransactionConfig->getTxnId() === $txnId) {
                    return '';
                }
            }

            $addressId = $this->_addAddress($cartSession->getUserId(), $billingAddressArray, $addressType);
            $cartSession->setBillingAddressId($addressId);
            $cartSessionMapper->save($cartSession);
            //end of saving billing address//

            $skip = false;
            if ($paymentStatus !== Models_Model_CartSession::CART_STATUS_REFUNDED) {
                $skip = true;
                if ($partialPaymentType === Models_Model_CartSession::CART_PARTIAL_PAYMENT_TYPE_AMOUNT) {
                    $cartPartialAmount = round($cartSession->getPartialPercentage(),2);
                } else {
                    $cartPartialAmount = round(($cartSession->getTotal() * $cartSession->getPartialPercentage()) / 100,
                        2);
                }

                if ($paymentStatus === Models_Model_CartSession::CART_STATUS_PARTIAL) {
                    if ($amount != $cartPartialAmount) {
                        $skip = false;
                    }

                    if ($partialPayment === true) {
                        $skip = true;
                    }
                } else {
                    if ($amount != ($cartSession->getTotal() - $cartPartialAmount)) {
                        $skip = false;
                    }
                }


            }

            if($amount != $cartTotal && $paymentStatus !== Models_Model_CartSession::CART_STATUS_REFUNDED && $skip === false){
                $reason =  $this->_translator->translate('Amount not right');
                $status = Models_Model_CartSession::CART_STATUS_ERROR;
                $paypalTransactionConfig->setTxnId($txnId);
                $paypalTransactionConfig->setPayerId($payerId);
                $paypalTransactionConfig->setPayerMail($payerMail);
                $paypalTransactionConfig->setAmount($amount);
                $paypalTransactionConfig->setShippingAmount($shipAmount);
                $paypalTransactionConfig->setTax($tax);
                $paypalTransactionConfig->setCurrency($currency);
                $paypalTransactionConfig->setPaymentStatus($paymentStatus);
                $paypalTransactionConfig->setStatus($status);
                $paypalTransactionConfig->setPaymentType('button');
                $paypalTransactionConfig->setPaymentId($cartId);
                $paypalTransactionConfig->setPaymentDate($paymentDate);
                $paypalTransactionConfig->setPFirstName($pFirstName);
                $paypalTransactionConfig->setPLastName($pLastName);
                $paypalTransactionConfig->setPCountry($pCountry);
                $paypalTransactionConfig->setPCountryCode($pCountryCode);
                $paypalTransactionConfig->setPAddressState($pAddressState);
                $paypalTransactionConfig->setPAddressCity($pAddressCity);
                $paypalTransactionConfig->setPAddressZip($pAddressZip);
                $paypalTransactionConfig->setPAddressName($pAddressStreet);
                $paypalTransactionConfig->setCartId($cartId);
                $paypalTransactionConfig->setPendingReason($reason);
                $paypalTransactionMapper->save($paypalTransactionConfig);
                $this->updateCartStatus($cartId, Models_Model_CartSession::CART_STATUS_ERROR, false, $reason);
            }
            else{
                //affiliate block
                $enabledPlugins = Tools_Plugins_Tools::getEnabledPlugins();
                foreach ($enabledPlugins as $plugin) {
                    if($plugin->getName() == 'seosambaaffiliatenetwork'){
                        $affiliate = Tools_Factory_PluginFactory::createPlugin('seosambaaffiliatenetwork');
                        $affiliateStatus = $affiliate->affiliateSale($cartId, $amount);
                    }
                }

                $customerEmailSent = $paypalTransactionConfig->getCustomerEmailSent();
                $clientWithNewPassword = $paypalTransactionConfig->getUserSetPassword();
                //affiliate end

                $partiallyPaid = 0;
                if ($partialPayment === true) {
                    if ($partialPaymentType === Models_Model_CartSession::CART_PARTIAL_PAYMENT_TYPE_AMOUNT) {
                        $cartPartialAmount = round($cartSession->getPartialPercentage(),2);
                    } else {
                        $cartPartialAmount = round(($cartSession->getTotal() * $cartSession->getPartialPercentage()) / 100,
                            2);
                    }

                    $amount = $cartSession->getTotal();
                    if ($paymentStatus === Models_Model_CartSession::CART_STATUS_PARTIAL) {
                        $status = Models_Model_CartSession::CART_STATUS_PARTIAL;
                        $partiallyPaid = $cartPartialAmount;
                    } else {
                        $partiallyPaid = $paypalTransactionConfig->getPartiallyPaid() + $cartSession->getTotal() - $cartPartialAmount;
                    }
                }

                $paypalTransactionConfig->setTxnId($txnId);
                $paypalTransactionConfig->setPayerId($payerId);
                $paypalTransactionConfig->setPayerMail($payerMail);
                $paypalTransactionConfig->setAmount($amount);
                $paypalTransactionConfig->setShippingAmount($shipAmount);
                $paypalTransactionConfig->setTax($tax);
                $paypalTransactionConfig->setCurrency($currency);
                $paypalTransactionConfig->setPaymentStatus($paymentStatus);
                $paypalTransactionConfig->setStatus($status);
                $paypalTransactionConfig->setPaymentType('button');
                $paypalTransactionConfig->setPaymentId($cartId);
                $paypalTransactionConfig->setPaymentDate($paymentDate);
                $paypalTransactionConfig->setPFirstName($pFirstName);
                $paypalTransactionConfig->setPLastName($pLastName);
                $paypalTransactionConfig->setPCountry($pCountry);
                $paypalTransactionConfig->setPCountryCode($pCountryCode);
                $paypalTransactionConfig->setPAddressState($pAddressState);
                $paypalTransactionConfig->setPAddressCity($pAddressCity);
                $paypalTransactionConfig->setPAddressZip($pAddressZip);
                $paypalTransactionConfig->setPAddressName($pAddressStreet);
                $paypalTransactionConfig->setCartId($cartId);
                $paypalTransactionConfig->setPendingReason($pendingReason);
                $paypalTransactionConfig->setEmailSent(1);
                $paypalTransactionConfig->setCustomerEmailSent(1);
                $paypalTransactionConfig->setPartiallyPaid($partiallyPaid);
                $paypalTransactionMapper->save($paypalTransactionConfig);
                $this->updateCartStatus($cartId, $paymentStatus);
                //sending email for new order
                if (!$emailSent) {
                    $this->_sessionHelper->storeCartSessionKey = $cartId;
                    $this->_sessionHelper->storeCartSessionConversionKey = $cartId;

                    if ($status === Models_Model_CartSession::CART_STATUS_PARTIAL) {
                        $cartSession->registerObserver(new Tools_Mail_Watchdog(array(
                            'trigger' => Tools_StoreMailWatchdog::TRIGGER_STORE_PARTIALPAYMENT
                        )));
                    }

                    if ($status !== Models_Model_CartSession::CART_STATUS_PARTIAL) {
                        if ($partialPayment === true) {
                            $cartSession->registerObserver(new Tools_Mail_Watchdog(array(
                                'trigger' => Tools_StoreMailWatchdog::TRIGGER_STORE_PARTIALPAYMENT_SECOND
                            )));
                        } else {
                            $cartSession->registerObserver(new Tools_Mail_Watchdog(array(
                                'trigger' => Tools_StoreMailWatchdog::TRIGGER_NEW_ORDER
                            )));
                        }
                    }

                    if (!$customerEmailSent) {
                        $customer = Models_Mapper_CustomerMapper::getInstance()->find($cartSession->getUserId());
                        if (empty($clientWithNewPassword)) {
                            $userMapper = Application_Model_Mappers_UserMapper::getInstance();
                            $userData = $userMapper->find($cartSession->getUserId());
                            $newCustomerPassword = uniqid('customer_' . time());
                            $userData->setPassword($newCustomerPassword);
                            $userMapper->save($userData);
                            $customer->setPassword($newCustomerPassword);
                        }

                        $customer->registerObserver(new Tools_Mail_Watchdog(array(
                            'trigger' => Tools_StoreMailWatchdog::TRIGGER_NEW_CUSTOMER
                        )));
                        $customer->notifyObservers();
                        unset($this->_sessionHelper->storeIsNewCustomer);
                    }

                    if (class_exists('Tools_AppsServiceWatchdog')) {
                        $cartSession->registerObserver(new Tools_AppsServiceWatchdog());
                    }
                    $cartSession->notifyObservers();
                }
                //end of sending new order email
             }
        }

    }

    /**
     * Direct payment action
     */
    public function payCreditCAction(){
       if ($this->_request->isPost()) {
            $data =  $this->_request->getParams();
           if (Models_Mapper_ShoppingConfig::getInstance()->getConfigParam('throttleTransactions') === 'true' && Tools_Misc::checkThrottleTransactionsLimit() === false) {
               $throttleTransactionsLimitMessage = Models_Mapper_ShoppingConfig::getInstance()->getConfigParam('throttleTransactionsLimitMessage');
               $throttleTransactionsLimitMessage = !empty($throttleTransactionsLimitMessage) ? $throttleTransactionsLimitMessage : Tools_Misc::THROTTLE_TRANSACTIONS_DEFAULT_MESSAGE;
               echo json_encode(array('done' => false, 'errorText' => $throttleTransactionsLimitMessage));
               exit;
           };
            $creditCardNum = preg_replace(array('/ /','/-/','/\//'), '', trim($data['cardnumber']));
            $sessionHelper = Zend_Controller_Action_HelperBroker::getStaticHelper('session');
            $customer    = $sessionHelper->getCurrentUser();
            $cartStorage = Tools_ShoppingCart::getInstance();
            $cartId = $cartStorage->getCartId();
            $cart = Models_Mapper_CartSessionMapper::getInstance()->find($cartId);
            if($cart instanceof  Models_Model_CartSession) {
               $cartStatus = $cart->getStatus();
               $gateway = $cart->getGateway();
               if (!in_array($cartStatus, $this->_allowedStatuses) && $gateway == 'Paypal') {
                   $payResult['error'] = 1;
                   $payResult['message'] = "We can't confirm your order at the moment due to a technical difficulty. If you do not receive an email in the coming hours confirming your purchase, please contact us";
                   echo json_encode($payResult);
                   exit;
               }
           }

           //saving billing address//
           $customer  = Tools_ShoppingCart::getInstance()->getCustomer();
           $addressType = Models_Model_Customer::ADDRESS_TYPE_BILLING;
           $billingAddressArray = array();
           $billingAddressArray['firstname'] = isset($data['firstname'])?$data['firstname']:'';
           $billingAddressArray['lastname']  = isset($data['lastname'])?$data['lastname']:'';
           $billingAddressArray['company']   = '';
           $billingAddressArray['email']     = isset($data['email'])?$data['email']:'';
           $billingAddressArray['address1']  = isset($data['billing_address1'])?$data['billing_address1']:'';
           $billingAddressArray['address2']  = isset($data['billing_address2'])?$data['billing_address2']:'';
           $billingAddressArray['country']   = isset($data['country'])?$data['country']:'';
           $billingAddressArray['city']      = isset($data['city'])?$data['city']:'';
           $billingAddressArray['state']     = isset($data['state'])?$data['state']:'';
           $billingAddressArray['zip']       = isset($data['zip'])?$data['zip']:'';
           $billingAddressArray['phone']     = isset($phone)?$phone:'';
           $billingAddressArray['phone_country_code_value']  = isset($countryPhoneCodeValue)?$countryPhoneCodeValue:'';
           $billingAddressArray['phonecountrycode']  = isset($data['phonecountrycode'])?$data['phonecountrycode']:'';
           $billingAddressArray['mobile']    = '';

           $addressId = Models_Mapper_CustomerMapper::getInstance()->addAddress($customer, $billingAddressArray, $addressType);
           $cartStorage->setAddressKey($addressType, $addressId)->save()->saveCartSession($customer);
           //end of saving billing address//

           $this->updateCartStatus($cartId, Models_Model_CartSession::CART_STATUS_PROCESSING);
           $cartSummary = $cartStorage->calculate();
            $cartSummary['totalTax'] = round($cartSummary['totalTax'], 2);
			$cartSummary['shipping'] = round($cartSummary['shipping'], 2);
			$cartSummary['total'] = round($cartSummary['total'], 2);
            if (round($data['amt'], 2) !== $cartSummary['total']) {
                $checkout = Tools_Misc::getCheckoutPage();
                $this->_responseHelper->fail(array('error'=> 1,'redirect'=>$this->_websiteUrl.$checkout->getUrl()));
            }
           $countryPhoneCodeValue = '+'.Zend_Locale::getTranslation($data['phonecountrycode'], 'phoneToTerritory');
           $phone = preg_replace("/[^0-9]/", '', $data['phone']);
           $fullPhone = $countryPhoneCodeValue.trim($phone);

            $dataForPayment = array(
                'PAYMENTACTION'     =>  'Sale',
                'IPADDRESS'         =>  $_SERVER['REMOTE_ADDR'],
                'CREDITCARDTYPE'    =>  $data['type'],
                'ACCT'              =>  $creditCardNum,
                'EXPDATE'           =>  str_pad($data['expiration_date_month'], 2, '0', STR_PAD_LEFT).$data['expiration_date_year'],
                'CVV2'              =>  trim($data['verification_number']),
                'EMAIL'             =>  trim($data['email']),
                'FIRSTNAME'         =>  trim($data['firstname']),
                'LASTNAME'          =>  trim($data['lastname']),
                'STREET'            =>  trim($data['billing_address1']),
                'STREET2'           =>  trim($data['billing_address2']),
                'CITY'              =>  trim($data['city']),
                'STATE'             =>  isset($data['state'])?$data['state']:'',
                'COUNTRYCODE'       =>  $data['country'],
                'ZIP'               =>  trim($data['zip']),
                'PHONENUM'          =>  $fullPhone,
                'AMT'               =>  $cartSummary['total'],
                'ITEMAMT'			=> ($cartSummary['total']-$cartSummary['totalTax']-$cartSummary['shipping']),
				'SHIPPINGAMT'		=>  $cartSummary['shipping'] !== '' ? $cartSummary['shipping'] : '0.00',
                'TAXAMT'			=>	$cartSummary['totalTax'] !== '' ? $cartSummary['totalTax'] : '0.00',
                'CURRENCYCODE'      =>  $data['currency_code'],
                'DESC'              =>  $data['desc']
            );
            $shippingAddressKey = $cartStorage->getAddressKey(Models_Model_Customer::ADDRESS_TYPE_SHIPPING);
            if($shippingAddressKey != null){
                $sessionHelper = Zend_Controller_Action_HelperBroker::getStaticHelper('session');
                $customer = $sessionHelper->getCurrentUser();
                $customerShipping = Tools_ShoppingCart::getAddressById($shippingAddressKey);
                $state = Tools_Geo::getStateById($customerShipping['state']);
                $customerShipping['state'] = $state['state'];
                $dataForPayment = $dataForPayment + array(
                    'SHIPTONAME'     => $customerShipping['firstname'] . ' ' . $customerShipping ['lastname'],
                    'SHIPTOSTREET'   => isset($customerShipping ['address1'])?$customerShipping ['address1']:'',
                    'SHIPTOSTREET2'  => isset($customerShipping ['address2'])?$customerShipping ['address2']:'',
                    'SHIPTOCITY'     => $customerShipping ['city'],
                    'SHIPTOSTATE'    => $customerShipping ['state'],
                    'SHIPTOZIP'      => isset($customerShipping ['zip'])?$customerShipping ['zip']:'',
                    'SHIPTOCOUNTRY'  => $customerShipping ['country'],
                    'SHIPTOPHONENUM' => isset($fullPhone)?$fullPhone:''
                );
            }
            $payment = $this->createDoDirectPayment($dataForPayment);
            if (preg_match('/success/i', $payment['ACK']) && isset($payment['TRANSACTIONID'])) {
                $infoPayment = $this->getTransactionDetails($payment['TRANSACTIONID']);
                if (preg_match('/success/i', $infoPayment['ACK'])) {
                    $paypalTransactionMapper = Paypal_Models_Mapper_PaypalTransactionMapper::getInstance();
                    $paypalTransactionConfig  = new Paypal_Models_Models_PaypalTransactionModel();
                    //affiliate block  
                    $enabledPlugins = Tools_Plugins_Tools::getEnabledPlugins();
                    foreach ($enabledPlugins as $plugin) {
                        if($plugin->getName() == 'seosambaaffiliatenetwork'){
                            $affiliate = Tools_Factory_PluginFactory::createPlugin('seosambaaffiliatenetwork');
                            $affiliateStatus = $affiliate->affiliateSave($cartId, 'paypal', 'creditcard');
                            $affiliateStatus = $affiliate->affiliateSale($cartId, $infoPayment['AMT']);
                        }

                    }
                    //affiliate end

                    $paypalTransactionConfig->setTxnId($infoPayment['TRANSACTIONID']);
                    $paypalTransactionConfig->setPayerId($infoPayment['PAYERID']);
                    $paypalTransactionConfig->setPayerMail($infoPayment['EMAIL']);
                    $paypalTransactionConfig->setAmount($infoPayment['AMT']);
                    $paypalTransactionConfig->setShippingAmount($cartSummary['shipping'] !== '' ? $cartSummary['shipping'] : '0');
                    $paypalTransactionConfig->setTax($cartSummary['totalTax'] !== '' ? $cartSummary['totalTax'] : '0');
                    $paypalTransactionConfig->setCurrency($payment['CURRENCYCODE']);
                    $pendingReason = '';
                    if(isset($infoPayment['PENDINGREASON'])){
                       $pendingReason = $infoPayment['PENDINGREASON'];
                    }
                    $paymentStatus = $infoPayment['PAYMENTSTATUS'];
                    if($infoPayment['PAYMENTSTATUS'] == 'Completed'){
                        $paymentStatus = Models_Model_CartSession::CART_STATUS_COMPLETED;
                    }
                    if($infoPayment['PAYMENTSTATUS'] == 'Pending'){
                        $paymentStatus = Models_Model_CartSession::CART_STATUS_PENDING;
                    }
                    $paypalTransactionConfig->setPaymentStatus($paymentStatus);
                    $paypalTransactionConfig->setStatus($infoPayment['ACK']);
                    $paypalTransactionConfig->setPaymentType('creditcard');
                    $paypalTransactionConfig->setPaymentId($cartId);
                    $paypalTransactionConfig->setPaymentDate($infoPayment['ORDERTIME']);
                    $paypalTransactionConfig->setPFirstName($data['firstname']);
                    $paypalTransactionConfig->setPLastName($data['lastname']);
                    $paypalTransactionConfig->setPCountry(isset($infoPayment['SHIPTOCOUNTRYNAME'])?$infoPayment['SHIPTOCOUNTRYNAME']:'');
                    $paypalTransactionConfig->setPCountryCode(isset($infoPayment['COUNTRYCODE'])?($infoPayment['COUNTRYCODE']):'');
                    $paypalTransactionConfig->setPAddressState(isset($infoPayment['SHIPTOSTATE'])?$infoPayment['SHIPTOSTATE']:'');
                    $paypalTransactionConfig->setPAddressCity(isset($infoPayment['SHIPTOCITY'])?$infoPayment['SHIPTOCITY']:'');
                    $paypalTransactionConfig->setPAddressZip(isset($infoPayment['SHIPTOZIP'])?$infoPayment['SHIPTOZIP']:'');
                    $paypalTransactionConfig->setPAddressName(isset($infoPayment['SHIPTOSTREET'])?$infoPayment['SHIPTOSTREET']:'');
                    $paypalTransactionConfig->setCartId($cartId);
                    $paypalTransactionConfig->setPendingReason($pendingReason);
                    $paypalTransactionMapper->save($paypalTransactionConfig);
                    $this->updateCartStatus($cartId, $paymentStatus);
                    echo json_encode(array('done' => true)); return;
                }
                echo json_encode(array('done' => false)); return;
            }

            $paypalError = $payment['L_SHORTMESSAGE0'];
            if($payment['L_LONGMESSAGE0'] !=''){
                $paypalError = $payment['L_LONGMESSAGE0'];
            }

            $this->updateCartStatus($cartId, Models_Model_CartSession::CART_STATUS_ERROR, false, $paypalError);

            echo json_encode(array('done' => false, 'errorText'=>$paypalError)); return;
        }
    }

    /**
     * Pay recurrent action
     */
    public function payCreditRecurrentAction(){
        if ($this->_request->isPost()) {
            $data =  $this->_request->getParams();
            if (Models_Mapper_ShoppingConfig::getInstance()->getConfigParam('throttleTransactions') === 'true' && Tools_Misc::checkThrottleTransactionsLimit() === false) {
                $throttleTransactionsLimitMessage = Models_Mapper_ShoppingConfig::getInstance()->getConfigParam('throttleTransactionsLimitMessage');
                $throttleTransactionsLimitMessage = !empty($throttleTransactionsLimitMessage) ? $throttleTransactionsLimitMessage : Tools_Misc::THROTTLE_TRANSACTIONS_DEFAULT_MESSAGE;
                echo json_encode(array('done' => false, 'errorText' => $throttleTransactionsLimitMessage));
                exit;
            };
            $creditCardNum = preg_replace(array('/ /','/-/','/\//'), '', trim($data['cardnumber']));
            $sessionHelper = Zend_Controller_Action_HelperBroker::getStaticHelper('session');
            $customer    = $sessionHelper->getCurrentUser();
            $cartStorage = Tools_ShoppingCart::getInstance();
            $cartId = $cartStorage->getCartId();
            $cart = Models_Mapper_CartSessionMapper::getInstance()->find($cartId);
            if($cart instanceof  Models_Model_CartSession) {
                $cartStatus = $cart->getStatus();
                $gateway = $cart->getGateway();
                if (!in_array($cartStatus, $this->_allowedStatuses) && $gateway == 'Paypal') {
                    $payResult['error'] = 1;
                    $payResult['message'] = "We can't confirm your order at the moment due to a technical difficulty. If you do not receive an email in the coming hours confirming your purchase, please contact us";
                    $this->_responseHelper->fail(array(
                        'error' => 1,
                        'generalError' => $payResult['message']
                    ));
                }
            }

            if (empty($data['recurrent'])) {
                $payResult['error'] = 1;
                $payResult['message'] = "Please specify recurrent payment type";
                echo json_encode($payResult);
                exit;
            }

            $this->updateCartStatus($cartId, Models_Model_CartSession::CART_STATUS_PROCESSING);
            $cartSummary = $cartStorage->calculate();
            $cartSummary['totalTax'] = round($cartSummary['totalTax'], 2);
            $cartSummary['shipping'] = round($cartSummary['shipping'], 2);
            $cartSummary['total'] = round($cartSummary['total'], 2);
            if (round($data['amt'], 2) !== $cartSummary['total']) {
                $checkout = Tools_Misc::getCheckoutPage();
                $this->_responseHelper->fail(array('error'=> 1,'redirect'=>$this->_websiteUrl.$checkout->getUrl()));
            }
            $countryPhoneCodeValue = '+'.Zend_Locale::getTranslation($data['phonecountrycode'], 'phoneToTerritory');
            $phone = preg_replace("/[^0-9]/", '', $data['phone']);
            $fullPhone = $countryPhoneCodeValue.trim($phone);

            //saving billing address//
            $customer  = Tools_ShoppingCart::getInstance()->getCustomer();
            $addressType = Models_Model_Customer::ADDRESS_TYPE_BILLING;
            $billingAddressArray = array();
            $billingAddressArray['firstname'] = isset($data['firstname'])?$data['firstname']:'';
            $billingAddressArray['lastname']  = isset($data['lastname'])?$data['lastname']:'';
            $billingAddressArray['company']   = '';
            $billingAddressArray['email']     = isset($data['email'])?$data['email']:'';
            $billingAddressArray['address1']  = isset($data['billing_address1'])?$data['billing_address1']:'';
            $billingAddressArray['address2']  = isset($data['billing_address2'])?$data['billing_address2']:'';
            $billingAddressArray['country']   = isset($data['country'])?$data['country']:'';
            $billingAddressArray['city']      = isset($data['city'])?$data['city']:'';
            $billingAddressArray['state']     = isset($data['state'])?$data['state']:'';
            $billingAddressArray['zip']       = isset($data['zip'])?$data['zip']:'';
            $billingAddressArray['phone']     = isset($phone)?$phone:'';
            $billingAddressArray['phone_country_code_value']  = isset($countryPhoneCodeValue)?$countryPhoneCodeValue:'';
            $billingAddressArray['phonecountrycode']  = isset($data['phonecountrycode'])?$data['phonecountrycode']:'';
            $billingAddressArray['mobile']    = '';

            $addressId = Models_Mapper_CustomerMapper::getInstance()->addAddress($customer, $billingAddressArray, $addressType);
            $cartStorage->setAddressKey($addressType, $addressId)->save()->saveCartSession($customer);
            //end of saving billing address//

            $recurrent = $cartStorage->getRecurringPaymentType();

            if (!empty($recurrent) && $recurrent !== '0') {
                if ($recurrent === Api_Store_Recurringtypes::RECURRING_PAYMENT_TYPE_DAY) {
                    $billingFrequency = '1';
                    $recurrentPeriod = self::DAY_PERIOD;
                } elseif ($recurrent === Api_Store_Recurringtypes::RECURRING_PAYMENT_TYPE_WEEK) {
                    $billingFrequency = '1';
                    $recurrentPeriod = self::WEEK_PERIOD;
                } elseif ($recurrent === Api_Store_Recurringtypes::RECURRING_PAYMENT_TYPE_MONTH) {
                    $billingFrequency = '1';
                    $recurrentPeriod = self::MONTH_PERIOD;
                } elseif ($recurrent === Api_Store_Recurringtypes::RECURRING_PAYMENT_TYPE_TWO_MONTHS) {
                    $billingFrequency = '2';
                    $recurrentPeriod = self::MONTH_PERIOD;
                } elseif ($recurrent === Api_Store_Recurringtypes::RECURRING_PAYMENT_TYPE_QUARTER) {
                    $billingFrequency = '3';
                    $recurrentPeriod = self::MONTH_PERIOD;
                } elseif ($recurrent === Api_Store_Recurringtypes::RECURRING_PAYMENT_TYPE_SEMESTER) {
                    $billingFrequency = '6';
                    $recurrentPeriod = self::MONTH_PERIOD;
                }  elseif ($recurrent === Api_Store_Recurringtypes::RECURRING_PAYMENT_TYPE_YEAR) {
                    $billingFrequency = '1';
                    $recurrentPeriod = self::YEAR_PERIOD;
                }

            } else {
                $recurrentPeriod = null;
            }

            if (empty($recurrentPeriod)) {
                $payResult['error'] = 1;
                $payResult['message'] = "Wrong recurrent payment type";
                echo json_encode($payResult);
                exit;
            }

            $profileData = array();
            $profileData['profileStartDate'] = Tools_System_Tools::convertDateFromTimezone('+'. $billingFrequency .' ' . strtolower($recurrentPeriod));
            $profileData['description'] = $data['desc'];
            $profileData['billingPeriod'] = $recurrentPeriod;
            $profileData['billingFrequency'] = $billingFrequency;
            $profileData['amt'] = $cartSummary['total'];
            $profileData['currencyCode'] = $data['currency_code'];
            $profileData['creditCardNumber'] = $creditCardNum;
            $profileData['expirationDate'] = str_pad($data['expiration_date_month'], 2, '0', STR_PAD_LEFT).$data['expiration_date_year'];
            $profileData['cvv'] = trim($data['verification_number']);
            $profileData['email'] = $data['email'];
            $profileData['street'] = $data['billing_address1'];
            $profileData['city'] = $data['city'];
            $profileData['state'] = $data['state'];
            $profileData['countryCode'] = $data['country'];
            $profileData['zip'] = $data['zip'];
            $profileData['userId'] = $cartStorage->getCustomerId();
            $profileData['cartId'] = $cartId;
            $profileData['initAmt'] = $cartSummary['total'];

            $createProfileResponse = $this->createRecurringProfile($profileData);

            if ($createProfileResponse['error'] === '1') {
                $payResult['error'] = 1;
                $payResult['message'] = $createProfileResponse['message'];
                $this->updateCartStatus($cartId, Models_Model_CartSession::CART_STATUS_ERROR, false, $payResult['message']);
                echo json_encode(array('done' => false, 'errorText' => $payResult['message']));
                return;
            } elseif (isset($createProfileResponse['paypalRecurringPaymentsModel']) && $createProfileResponse['paypalRecurringPaymentsModel'] instanceof Paypal_Models_Models_PaypalRecurringPaymentsModel) {
                try {
                    $payResult['error'] = 0;

                    $paypalTransactionMapper = Paypal_Models_Mapper_PaypalTransactionMapper::getInstance();
                    $paypalTransaction = new Paypal_Models_Models_PaypalTransactionModel();
                    $rpModel = $createProfileResponse['paypalRecurringPaymentsModel'];
                    $paypalTransaction->setTxnId('');
                    $paypalTransaction->setPayerId($rpModel->getProfileId());
                    $paypalTransaction->setPayerMail($rpModel->getEmail());
                    $paypalTransaction->setAmount($cartSummary['total']);
                    $paypalTransaction->setShippingAmount('');
                    $paypalTransaction->setTax($cartSummary['totalTax']);
                    $paypalTransaction->setCurrency($rpModel->getCurrencyCode());
                    $paypalTransaction->setPaymentStatus(Models_Model_CartSession::CART_STATUS_COMPLETED);
                    $paypalTransaction->setStatus($rpModel->getPayerStatus());
                    $paypalTransaction->setPaymentType('cart-recurring-quote');
                    $paypalTransaction->setPaymentId($cartId);
                    $paypalTransaction->setPaymentDate(Tools_System_Tools::convertDateFromTimezone('now'));
                    $paypalTransaction->setPFirstName($customer->getFullName());
                    $paypalTransaction->setPLastName($customer->getFullName());
                    $paypalTransaction->setPCountry($rpModel->getCountry());
                    $paypalTransaction->setPCountryCode($rpModel->getCountryCode());
                    $paypalTransaction->setPAddressState($rpModel->getState());
                    $paypalTransaction->setPAddressCity($rpModel->getCity());
                    $paypalTransaction->setPAddressZip($rpModel->getZip());
                    $paypalTransaction->setPAddressName($rpModel->getStreet());
                    $paypalTransaction->setCartId($cartId);
                    $paypalTransaction->setPendingReason('');
                    $paypalTransaction->setSubscribeStatus('active');
                    $paypalTransaction->setSubscribePeriod($billingFrequency);
                    $paypalTransaction->setSubscribePeriodType($recurrentPeriod);
                    $paypalTransaction->setSubscribeDate(Tools_System_Tools::convertDateFromTimezone('now'));
                    $paypalTransaction->setSubscriptionId($rpModel->getProfileId());
                    $paypalTransaction->setSubscriptionDatePayed(Tools_System_Tools::convertDateFromTimezone('now'));
                    $paypalTransaction->setSubscriptionAmountPayed($cartSummary['total']);
                    $paypalTransaction->setEmailSent(1);
                    $paypalTransaction->setCustomerEmailSent(1);
                    $paypalTransactionMapper->save($paypalTransaction);

                    $this->updateCartStatus($cartId, Models_Model_CartSession::CART_STATUS_COMPLETED);

                    $paymentPeriod = strtolower($cartStorage->getRecurringPaymentType());
                    Tools_RecurringPaymentTools::createRecurringPaymentInfo($cartId, 65535, $rpModel->getProfileId(), '',
                        $paymentPeriod, $cartSummary['total'], 'paypal', $cartSummary['total'], '', 'active', 1, 1);

                    echo json_encode(array('done' => true));
                    return;
                } catch (Exception $e) {
                    $paypalError = $e->getMessage();
                    $this->updateCartStatus($cartId, Models_Model_CartSession::CART_STATUS_ERROR, false, $paypalError);
                    echo json_encode(array('done' => false, 'errorText' => $paypalError));
                    return;
                }
            }

        }
    }

    /**
     * Direct payment action
     */
    public function payCreditCquoteAction(){
        if ($this->_request->isPost()) {
            $data =  $this->_request->getParams();
            if (Models_Mapper_ShoppingConfig::getInstance()->getConfigParam('throttleTransactions') === 'true' && Tools_Misc::checkThrottleTransactionsLimit() === false) {
                $throttleTransactionsLimitMessage = Models_Mapper_ShoppingConfig::getInstance()->getConfigParam('throttleTransactionsLimitMessage');
                $throttleTransactionsLimitMessage = !empty($throttleTransactionsLimitMessage) ? $throttleTransactionsLimitMessage : Tools_Misc::THROTTLE_TRANSACTIONS_DEFAULT_MESSAGE;
                echo json_encode(array('done' => false, 'errorText' => $throttleTransactionsLimitMessage));
                exit;
            };
            $creditCardNum = preg_replace(array('/ /','/-/','/\//'), '', trim($data['cardnumber']));
            $sessionHelper = Zend_Controller_Action_HelperBroker::getStaticHelper('session');
            $customer    = $sessionHelper->getCurrentUser();
            $cartStorage = Tools_ShoppingCart::getInstance();
            $cartId = $cartStorage->getCartId();
            $cart = Models_Mapper_CartSessionMapper::getInstance()->find($cartId);
            if($cart instanceof  Models_Model_CartSession) {
                $cartStatus = $cart->getStatus();
                $gateway = $cart->getGateway();
                if (!in_array($cartStatus, $this->_allowedStatuses) && $gateway == 'Paypal') {
                    $payResult['error'] = 1;
                    $payResult['message'] = "We can't confirm your order at the moment due to a technical difficulty. If you do not receive an email in the coming hours confirming your purchase, please contact us";
                    echo json_encode($payResult);
                    exit;
                }
            }

            if ($cart->getGateway() === 'Quote') {
                $quoteMapper = Quote_Models_Mapper_QuoteMapper::getInstance();
                $quoteModel = $quoteMapper->findByCartId($cart->getId());
                if ($quoteModel instanceof Quote_Models_Model_Quote) {
                    $signatureRequired = $quoteModel->getIsSignatureRequired();
                    if (!empty($signatureRequired) && empty($quoteModel->getIsQuoteSigned())) {
                        $this->_responseHelper->fail(array(
                            'error' => 1,
                            'generalError' => $this->_translator->translate('Please sign the quote!')
                        ));
                    }

                }
            }

            $isPartial = false;
            if (!empty($cart->getIsPartial())) {
                $isPartial = true;
            }

            $partialPaymentType = $cart->getPartialType();

            if ($isPartial === true) {
                $partialPaidAmount = $cart->getPartialPaidAmount();
                $cart->setIsPartial('1');
                if (!empty($partialPaidAmount) && $partialPaidAmount !== '0.00' && !empty((int) $partialPaidAmount)) {
                    $cart->setPartialPaidAmount($cart->getTotal());
                    if ($partialPaymentType === Models_Model_CartSession::CART_PARTIAL_PAYMENT_TYPE_AMOUNT) {
                        $amountToPayPartial = round($cart->getTotal() - $cart->getPartialPercentage(),2);
                    } else {
                        $amountToPayPartial = round($cart->getTotal() - round(($cart->getTotal() * $cart->getPartialPercentage()) / 100,
                                2), 2);
                    }

                    $updatePaymentStatus = Models_Model_CartSession::CART_STATUS_COMPLETED;
                } else {
                    if ($partialPaymentType === Models_Model_CartSession::CART_PARTIAL_PAYMENT_TYPE_AMOUNT) {
                        $amountToPayPartial = round($cart->getPartialPercentage(), 2);
                    } else {
                        $amountToPayPartial = round(($cart->getTotal() * $cart->getPartialPercentage()) / 100, 2);
                    }

                    $cart->setPartialPaidAmount($amountToPayPartial);
                    $updatePaymentStatus = Models_Model_CartSession::CART_STATUS_PARTIAL;
                }
            }

            //$this->updateCartStatus($cartId, Models_Model_CartSession::CART_STATUS_PROCESSING);
            $cartSummary = array();
            $cartSummary['totalTax'] = round($cart->getTotalTax(), 2);
            $cartSummary['shipping'] = round($cart->getShippingPrice(), 2);
            $cartSummary['total'] = round($cart->getTotal(), 2);
            if (round($data['amt'], 2) !== $cartSummary['total']) {
                $quoteMapper = Quote_Models_Mapper_QuoteMapper::getInstance();
                $quoteModel = $quoteMapper->findByCartId($cart->getId());
                if (!$quoteModel instanceof Quote_Models_Model_Quote) {
                    $this->_responseHelper->fail(array(
                        'error' => 1,
                        'generalError' => $this->_translator->translate('You can pay only on quote!')
                    ));
                }

                $quoteUrl = $quoteModel->getId().'.html';
                $this->_responseHelper->fail(array('error'=> 1,'redirect'=>$this->_websiteUrl.$quoteUrl));
            }

            $amountToPay = $cartSummary['total'];
            if ($isPartial === true && !empty($amountToPayPartial)) {
                $amountToPay = $amountToPayPartial;
            }

            $countryPhoneCodeValue = '+'.Zend_Locale::getTranslation($data['phonecountrycode'], 'phoneToTerritory');
            $phone = preg_replace("/[^0-9]/", '', $data['phone']);
            $fullPhone = $countryPhoneCodeValue.trim($phone);

            //saving billing address//
            $customer = Tools_ShoppingCart::getInstance()->getCustomer();
            $addressType = Models_Model_Customer::ADDRESS_TYPE_BILLING;
            $billingAddressArray = array();
            $billingAddressArray['firstname'] = isset($data['firstname']) ? $data['firstname'] : '';
            $billingAddressArray['lastname'] = isset($data['lastname']) ? $data['lastname'] : '';
            $billingAddressArray['company'] = '';
            $billingAddressArray['email'] = isset($data['email']) ? $data['email'] : '';
            $billingAddressArray['address1'] = isset($data['billing_address1']) ? $data['billing_address1'] : '';
            $billingAddressArray['address2'] = isset($data['billing_address2']) ? $data['billing_address2'] : '';
            $billingAddressArray['country'] = isset($data['country']) ? $data['country'] : '';
            $billingAddressArray['city'] = isset($data['city']) ? $data['city'] : '';
            $billingAddressArray['state'] = isset($data['state']) ? $data['state'] : '';
            $billingAddressArray['zip'] = isset($data['zip']) ? $data['zip'] : '';
            $billingAddressArray['phone'] = isset($phone) ? $phone : '';
            $billingAddressArray['phone_country_code_value'] = isset($countryPhoneCodeValue) ? $countryPhoneCodeValue : '';
            $billingAddressArray['phonecountrycode'] = isset($data['phonecountrycode']) ? $data['phonecountrycode'] : '';
            $billingAddressArray['mobile'] = '';

            $addressId = Models_Mapper_CustomerMapper::getInstance()->addAddress($customer,
                $billingAddressArray, $addressType);
            $cartStorage->setAddressKey($addressType, $addressId)->save()->saveCartSession($customer);
            //end of saving billing address//

            $dataForPayment = array(
                'PAYMENTACTION'     =>  'Sale',
                'IPADDRESS'         =>  $_SERVER['REMOTE_ADDR'],
                'CREDITCARDTYPE'    =>  $data['type'],
                'ACCT'              =>  $creditCardNum,
                'EXPDATE'           =>  str_pad($data['expiration_date_month'], 2, '0', STR_PAD_LEFT).$data['expiration_date_year'],
                'CVV2'              =>  trim($data['verification_number']),
                'EMAIL'             =>  trim($data['email']),
                'FIRSTNAME'         =>  trim($data['firstname']),
                'LASTNAME'          =>  trim($data['lastname']),
                'STREET'            =>  trim($data['billing_address1']),
                'STREET2'           =>  trim($data['billing_address2']),
                'CITY'              =>  trim($data['city']),
                'STATE'             =>  isset($data['state'])?$data['state']:'',
                'COUNTRYCODE'       =>  $data['country'],
                'ZIP'               =>  trim($data['zip']),
                'PHONENUM'          =>  $fullPhone,
                'AMT'               =>  $amountToPay,
                'CURRENCYCODE'      =>  $data['currency_code'],
                'DESC'              =>  $data['desc']
            );
            $shippingAddressKey = $cartStorage->getAddressKey(Models_Model_Customer::ADDRESS_TYPE_SHIPPING);
            if($shippingAddressKey != null){
                $sessionHelper = Zend_Controller_Action_HelperBroker::getStaticHelper('session');
                $customer = $sessionHelper->getCurrentUser();
                $customerShipping = Tools_ShoppingCart::getAddressById($shippingAddressKey);
                $state = Tools_Geo::getStateById($customerShipping['state']);
                $customerShipping['state'] = $state['state'];
                $dataForPayment = $dataForPayment + array(
                        'SHIPTONAME'     => $customerShipping['firstname'] . ' ' . $customerShipping ['lastname'],
                        'SHIPTOSTREET'   => isset($customerShipping ['address1'])?$customerShipping ['address1']:'',
                        'SHIPTOSTREET2'  => isset($customerShipping ['address2'])?$customerShipping ['address2']:'',
                        'SHIPTOCITY'     => $customerShipping ['city'],
                        'SHIPTOSTATE'    => $customerShipping ['state'],
                        'SHIPTOZIP'      => isset($customerShipping ['zip'])?$customerShipping ['zip']:'',
                        'SHIPTOCOUNTRY'  => $customerShipping ['country'],
                        'SHIPTOPHONENUM' => isset($fullPhone)?$fullPhone:''
                    );
            }
            $payment = $this->createDoDirectPayment($dataForPayment);
            if (preg_match('/success/i', $payment['ACK']) && isset($payment['TRANSACTIONID'])) {
                $infoPayment = $this->getTransactionDetails($payment['TRANSACTIONID']);
                if (preg_match('/success/i', $infoPayment['ACK'])) {
                    $paypalTransactionMapper = Paypal_Models_Mapper_PaypalTransactionMapper::getInstance();
                    $paypalTransactionConfig = new Paypal_Models_Models_PaypalTransactionModel();
                    //affiliate block
                    $enabledPlugins = Tools_Plugins_Tools::getEnabledPlugins();
                    foreach ($enabledPlugins as $plugin) {
                        if ($plugin->getName() == 'seosambaaffiliatenetwork') {
                            $affiliate = Tools_Factory_PluginFactory::createPlugin('seosambaaffiliatenetwork');
                            $affiliateStatus = $affiliate->affiliateSave($cartId, 'paypal', 'creditcard');
                            $affiliateStatus = $affiliate->affiliateSale($cartId, $infoPayment['AMT']);
                        }

                    }
                    //affiliate end

                    $paypalTransactionConfig->setTxnId($infoPayment['TRANSACTIONID']);
                    $paypalTransactionConfig->setPayerId($infoPayment['PAYERID']);
                    $paypalTransactionConfig->setPayerMail($infoPayment['EMAIL']);
                    $paypalTransactionConfig->setAmount($infoPayment['AMT']);
                    $paypalTransactionConfig->setShippingAmount($cartSummary['shipping'] !== '' ? $cartSummary['shipping'] : '0');
                    $paypalTransactionConfig->setTax($cartSummary['totalTax'] !== '' ? $cartSummary['totalTax'] : '0');
                    $paypalTransactionConfig->setCurrency($payment['CURRENCYCODE']);
                    $pendingReason = '';
                    if (isset($infoPayment['PENDINGREASON'])) {
                        $pendingReason = $infoPayment['PENDINGREASON'];
                    }
                    $paymentStatus = $infoPayment['PAYMENTSTATUS'];
                    if ($infoPayment['PAYMENTSTATUS'] == 'Completed') {
                        $paymentStatus = Models_Model_CartSession::CART_STATUS_COMPLETED;
                    }
                    if ($infoPayment['PAYMENTSTATUS'] == 'Pending') {
                        $paymentStatus = Models_Model_CartSession::CART_STATUS_PENDING;
                    }

                    if ($isPartial === true) {
                        $paymentStatus = $updatePaymentStatus;
                    }

                    $paypalTransactionConfig->setPaymentStatus($paymentStatus);
                    $paypalTransactionConfig->setStatus($infoPayment['ACK']);
                    $paypalTransactionConfig->setPaymentType('creditcard');
                    $paypalTransactionConfig->setPaymentId($cartId);
                    $paypalTransactionConfig->setPaymentDate($infoPayment['ORDERTIME']);
                    $paypalTransactionConfig->setPFirstName($data['firstname']);
                    $paypalTransactionConfig->setPLastName($data['lastname']);
                    $paypalTransactionConfig->setPCountry(isset($infoPayment['SHIPTOCOUNTRYNAME']) ? $infoPayment['SHIPTOCOUNTRYNAME'] : '');
                    $paypalTransactionConfig->setPCountryCode(isset($infoPayment['COUNTRYCODE']) ? ($infoPayment['COUNTRYCODE']) : '');
                    $paypalTransactionConfig->setPAddressState(isset($infoPayment['SHIPTOSTATE']) ? $infoPayment['SHIPTOSTATE'] : '');
                    $paypalTransactionConfig->setPAddressCity(isset($infoPayment['SHIPTOCITY']) ? $infoPayment['SHIPTOCITY'] : '');
                    $paypalTransactionConfig->setPAddressZip(isset($infoPayment['SHIPTOZIP']) ? $infoPayment['SHIPTOZIP'] : '');
                    $paypalTransactionConfig->setPAddressName(isset($infoPayment['SHIPTOSTREET']) ? $infoPayment['SHIPTOSTREET'] : '');
                    $paypalTransactionConfig->setCartId($cartId);
                    $paypalTransactionConfig->setPendingReason($pendingReason);
                    $paypalTransactionMapper->save($paypalTransactionConfig);
                    Models_Mapper_CartSessionMapper::getInstance()->save($cart);
                    $this->updateCartStatus($cartId, $paymentStatus);

                    $cartSession = Models_Mapper_CartSessionMapper::getInstance()->find($cartId);
                    $this->_sessionHelper->storeCartSessionKey = $cartId;
                    $this->_sessionHelper->storeCartSessionConversionKey = $cartId;
                    if ($cartSession->getStatus() !== Models_Model_CartSession::CART_STATUS_PARTIAL) {
                        if ($isPartial === true) {
                            $cartSession->registerObserver(new Tools_Mail_Watchdog(array(
                                'trigger' => Tools_StoreMailWatchdog::TRIGGER_STORE_PARTIALPAYMENT_SECOND
                            )));
                        } else {
                            $cartSession->registerObserver(new Tools_Mail_Watchdog(array(
                                'trigger' => Tools_StoreMailWatchdog::TRIGGER_NEW_ORDER
                            )));
                        }
                    }

                    $shoppingConfig = Models_Mapper_ShoppingConfig::getInstance()->getConfigParams();

                    if (!empty($shoppingConfig[Shopping::SHIPPING_IS_GIFT])) {
                        if (!empty($cartSession->getIsGift())) {
                            $cartSession->registerObserver(new Tools_Mail_Watchdog(array(
                                'trigger' => Tools_StoreMailWatchdog::TRIGGER_STORE_GIFT_ORDER
                            )));
                        }
                    }

                    if ($cartSession->getStatus() === Models_Model_CartSession::CART_STATUS_PARTIAL) {
                        $cartSession->registerObserver(new Tools_Mail_Watchdog(array(
                            'trigger' => Tools_StoreMailWatchdog::TRIGGER_STORE_PARTIALPAYMENT
                        )));
                    }

                    if ($cartSession->getStatus() !== Models_Model_CartSession::CART_STATUS_PARTIAL) {
                        if (class_exists('Tools_AppsServiceWatchdog')) {
                            $cartSession->registerObserver(new Tools_AppsServiceWatchdog());
                        }
                    }

                    $cartSession->notifyObservers();

                    $currency = Zend_Registry::get('Zend_Currency');
                    if (empty($amountToPayPartial)) {
                        $message = $currency->toCurrency($amountToPay);
                    } else {
                        $message = $currency->toCurrency($amountToPayPartial);
                    }


                    $this->_responseHelper->success(array(
                        'error' => 0,
                        'generalSuccess' => $this->_translator->translate('Thank you for your payment of ') . $message
                    ));

                }
            }

            $paypalError = $payment['L_SHORTMESSAGE0'];
            if($payment['L_LONGMESSAGE0'] !=''){
                $paypalError = $payment['L_LONGMESSAGE0'];
            }

            $this->updateCartStatus($cartId, Models_Model_CartSession::CART_STATUS_ERROR, false, $paypalError);

            $this->_responseHelper->fail(array(
                'error' => 1,
                'generalError' => $paypalError
            ));
        }
    }

    /**
     * Call to api
     *
     * @param string $methodName
     * @param string $nvpStr
     * @return array
     */
    public function hashCall($methodName, $nvpStr){
        $paypalConfigMapper = Paypal_Models_Mapper_PaypalConfigMapper::getInstance();
        $paypalSettings = $paypalConfigMapper->selectSettings();
        $useSandBox = $paypalSettings[0]->getUseSandbox();
        $apiSignature = $paypalSettings[0]->getApiSignature();
        $userApiName  = $paypalSettings[0]->getApiUser();
        $userApiPass  = $paypalSettings[0]->getApiPassword();
		if($useSandBox == 1) {
			$endPoint = $this->creditCardSandBoxEndPoin;
		}
		else {
			$endPoint = $this->creditCardLiveEndPoin;
		}
        $coreData = array (
            'METHOD'        =>  $methodName,
            'VERSION'       =>  $this->API_VERSOIN,
            'PWD'           =>  $userApiPass,
            'USER'          =>  $userApiName,
            'SIGNATURE'     =>  $apiSignature
        );
        $nvpRequest = http_build_query($coreData) . $nvpStr;
        $responce = $this->getTransactionValidation($nvpRequest, $endPoint);
		return $this->parseResponse($responce);
	}

    /**
     * Validate transaction
     *
     * @param array $postdata
     * @param string $endPoint
     * @return mixed
     */
    public function getTransactionValidation($postdata,$endPoint) {
		$curl = curl_init();
		curl_setopt($curl, CURLOPT_URL, $endPoint);
		curl_setopt($curl, CURLOPT_POST, 1);
		curl_setopt($curl, CURLOPT_VERBOSE, 0);
		curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
		curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, false);
		curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
		curl_setopt($curl, CURLOPT_POSTFIELDS, $postdata);
		$response = curl_exec($curl);
		curl_close ($curl);
		return $response;
	}

    /**
     * Parse response from gateway
     *
     * @param $response
     * @return array
     */
    public function parseResponse($response){
        $data = array();
        $tmp  = explode('&', $response);
        foreach ($tmp as $item) {
            $val = explode('=', $item);
            if (isset($val[0]) && isset($val[1])) {
                $data[$val[0]] = urldecode($val[1]);
            }
        }
        return $data;
    }

    /**
     * Direct payment call
     *
     * @param array $data
     * @return array
     */
    public function createDoDirectPayment(array $data)
    {
        $stringRequest = '&'.http_build_query($data);
        return $this->hashCall('DoDirectPayment', $stringRequest);
    }

    /**
     * Get transaction details
     *
     * @param integer $transactionId
     * @return array
     */
    public function getTransactionDetails($transactionId)
    {
        $stringRequest = '&TRANSACTIONID='.urlencode($transactionId);
        return $this->hashCall('GetTransactionDetails', $stringRequest);
    }

    /**
     * Config action
     */
    public function configAction(){
        if(Tools_Security_Acl::isAllowed(Tools_Security_Acl::RESOURCE_PLUGINS)){
            $paypalConfigMapper = Paypal_Models_Mapper_PaypalConfigMapper::getInstance();
            $paypalModelConfig  = new Paypal_Models_Models_PaypalConfigModel();
            if($this->_request->isPost()){
                $secureToken = $this->_request->getParam(Tools_System_Tools::CSRF_SECURE_TOKEN, false);
                $tokenValid = Tools_System_Tools::validateToken($secureToken, self::PAYPAL_SECURE_TOKEN);
                if (!$tokenValid) {
                    $this->_responseHelper->fail('');
                }
                $apiPassword = filter_var($this->_request->getParam('password'), FILTER_SANITIZE_STRING);
                if (empty($apiPassword)) {
                    $paypalSettings = $paypalConfigMapper->selectSettings();
                    $apiPassword = $paypalSettings[0]->getApiPassword();
                }
                $email = $this->_request->getParam('email');
                $apiSignature = $this->_request->getParam('apiSignature');
                $apiUser = $this->_request->getParam('user');
                $useSandBox = $this->_request->getParam('useSandBox');
                $paypalModelConfig->setEmail($email);
                $paypalModelConfig->setApiSignature($apiSignature);
                $paypalModelConfig->setApiUser($apiUser);
                $paypalModelConfig->setApiPassword($apiPassword);
                $paypalModelConfig->setUseSandbox($useSandBox);
                $paypalConfigMapper->save($paypalModelConfig);
                $this->_responseHelper->success('');
            }
            else{
                $this->_view->translator = $this->_translator;
                $paypalSettings = $paypalConfigMapper->selectSettings();
                $this->_view->email = $paypalSettings[0]->getEmail();
                $this->_view->apiSignature = $paypalSettings[0]->getApiSignature();
                $this->_view->apiUser = $paypalSettings[0]->getApiUser();
                $this->_view->apiPassword = $paypalSettings[0]->getApiPassword();
                $this->_view->useSandBox = $paypalSettings[0]->getUseSandbox();
                $this->_layout->content = $this->_view->render('paypalConfig.phtml');
                echo $this->_layout->render();

            }

        }
    }

    public function refund($orderId, $refundAmount, $refundNotes)
    {
        $payResult = array('error' => 1);
        $this->_view->translator = $this->_translator;
        $transactionMapper = Paypal_Models_Mapper_PaypalTransactionMapper::getInstance();
        $transForRefund = $transactionMapper->findByCartId($orderId);
        if (empty($transForRefund) || !$transForRefund[0] instanceof Paypal_Models_Models_PaypalTransactionModel) {
            $payResult['errorMessage'] = $this->_translator->translate("There is no order with such ID");
            return $payResult;
        }
        $transForRefund = $transForRefund[0];

        $dataForPayment = array(
            'TRANSACTIONID' => $transForRefund->getTxnId(),
            'CURRENCYCODE' => $transForRefund->getCurrency(),
            'NOTE' => $refundNotes
        );


        $realRefundAmount = $transForRefund->getAmount();
        if ($realRefundAmount > $refundAmount) {
            $dataForPayment['REFUNDTYPE'] = 'Partial';
            $dataForPayment['AMT'] = $refundAmount;
        } else {
            $dataForPayment['REFUNDTYPE'] = 'Full';
        }

        $stringRequest = '&'.http_build_query($dataForPayment);
        $refundPayment = $this->hashCall('RefundTransaction', $stringRequest);

        if($refundPayment['ACK'] == "Success") {
            $transForRefund->setRefundTransactionId($refundPayment['REFUNDTRANSACTIONID']);
            $transForRefund->setStatus(Models_Model_CartSession::CART_STATUS_REFUNDED);
            $transForRefund->setRefundReason($refundNotes);
            $transactionMapper->save($transForRefund);
            $this->updateCartStatus($orderId, Models_Model_CartSession::CART_STATUS_REFUNDED);
            $payResult['error'] = 0;
            $payResult['refundMessage'] = $refundPayment['ACK'];
        }
        if ($refundPayment['ACK'] == "Failure") {
            $payResult['errorMessage'] = $refundPayment['L_LONGMESSAGE0'];

        }
        return $payResult;
    }

    /**
     * https://www.angelleye.com/paypal-recurring-payments-ipn-samples/
     */

    public function recurringIpn($ipnData)
    {
        $isValidIpnData  = $this->verifyIpn($ipnData);
        if ($isValidIpnData === false) {
            return array('error' => '1', 'message' => 'Invalid ipn');
        }
        if (empty($ipnData['txn_type'])) {
            return array('error' => '1', 'message' => 'Profile type status not found.');
        }

        $txnType = $ipnData['txn_type'];

        if (empty($ipnData['recurring_payment_id'])) {
            return array('error' => '1', 'message' => 'Profile payment id.');
        }

        $userId =  $ipnData['userId'];
        unset($ipnData['userId']);

        $cartId =  $ipnData['cartId'];
        unset($ipnData['cartId']);

        $recurringPaymentId = $ipnData['recurring_payment_id'];


        if (in_array($txnType, Tools_RecurringPaymentPaypal::$_recurringProfileTypes, true)) {
            return $this->processRecurringProfileResponse($txnType, $recurringPaymentId, $ipnData, $userId, $cartId);
        }

        return array('error' => '1', 'message' => 'Profile type status not found.');

    }

    /**
     * Process profile response
     *
     * @param string $type profile type
     * @param string $profileId profile id
     * @param array $ipnData ipn data
     * @param int $userId user id
     * @param int $cartId cart id
     * @return array
     * @throws Exceptions_SeotoasterException
     */
    public function processRecurringProfileResponse($type, $profileId, $ipnData, $userId, $cartId = 0)
    {
        $updateLocalProfileResponse = Tools_RecurringPaymentPaypal::updateLocalProfileInfo($profileId, $userId, $cartId);
        if ($updateLocalProfileResponse['error'] === '1') {
            return $updateLocalProfileResponse;
        }

        return array('error' => '0', 'paypalRecurringPaymentsModel' => $updateLocalProfileResponse['paypalRecurringPaymentsModel'], 'sandbox' => '');

    }

    /**
     * Verify ipn data
     *
     * @param array $ipnData ipn data
     * @return bool
     */
    public function verifyIpn($ipnData)
    {
        $paypalConfigMapper = Paypal_Models_Mapper_PaypalConfigMapper::getInstance();
        $paypalSettings = $paypalConfigMapper->getConfigParams();
        $useSandbox = $paypalSettings['useSandbox'];
        if ($useSandbox == '1') {
            $endPoint = $this->buttonSandBoxValidateEndPoin; //https://www.sandbox.paypal.com/
        } else {
            $endPoint = $this->buttonValidateEndPoin; //'https://www.paypal.com/cgi-bin/webscr'
        }
        $ipnData = http_build_query(array_merge(array('cmd' => '_notify-validate'), $ipnData));
        $validateIpn = $this->getTransactionValidation($ipnData, $endPoint);

        if (trim($validateIpn) === 'VERIFIED') {
            return true;
        }

        return false;
    }

    /**
     * Get button language
     *
     * @param string $userCountry user shipping country
     * @return string
     */
    public static function getButtonLocale($userCountry)
    {
        if (array_key_exists($userCountry, self::$_allowedLanguages)) {
            return $userCountry;
        }

        return 'US';
    }

    protected function _setRecalculationFlags($id = false) {
        $recalculationFlags = [
            'skipGroupPriceRecalculation' => false,
            'skipOptionRecalculation' => false
        ];
        if ($id) {
            $userModel = Application_Model_Mappers_UserMapper::getInstance()->find($id);
            if ($userModel instanceof Application_Model_Models_User) {
                $userRoleId = $userModel->getRoleId();
                if ($userRoleId == Shopping::ROLE_SALESPERSON || $userRoleId == Tools_Security_Acl::ROLE_ADMIN || $userRoleId == Tools_Security_Acl::ROLE_SUPERADMIN) {
                    $recalculationFlags['skipGroupPriceRecalculation'] = true;
                    $recalculationFlags['skipOptionRecalculation'] = true;
                }
            }
        }
        return $recalculationFlags;
    }

    /**
     * Cancel recurring profile
     *
     * @param $data
     * @return array
     * @throws Exceptions_SeotoasterException
     */
    public function cancelRecurringProfile($data)
    {
        $userId = $data['userId'];
        $cartId = 0;
        $profileId = $data['profileId'];
        if (!empty($data['cartId'])) {
            $cartId = $data['cartId'];
        }
        $recurringProfileResult = Tools_RecurringPaymentPaypal::cancelRecurringPaymentProfile($profileId);
        if ($recurringProfileResult['error'] === '1') {
            return $recurringProfileResult;
        }

        $profileId = $recurringProfileResult['PROFILEID'];
        $updateLocalProfileResponse = Tools_RecurringPaymentPaypal::updateLocalProfileInfo($profileId, $userId, $cartId);
        if ($updateLocalProfileResponse['error'] === '1') {
            return $updateLocalProfileResponse;
        }

        return array('error' => '0', 'paypalRecurringPaymentsModel' => $updateLocalProfileResponse['paypalRecurringPaymentsModel'], 'sandbox' => '');
    }


    /**
     * @param $data
     * @return array
     * @throws Exceptions_SeotoasterException
     */
    public function updateRecurringProfile($data)
    {
        $optionalBillingParams = array();
        $amt = $data['amt'];
        $creditCardNumber = $data['creditCardNumber'];
        $expirationDate = $data['expirationDate'];
        $cvv = $data['cvv'];
        $email = $data['email'];
        $street = $data['street'];
        $city = $data['city'];
        $state = $data['state'];
        $countryCode = $data['countryCode'];
        $zip = $data['zip'];
        $userId = $data['userId'];
        $cartId = 0;
        $profileId = $data['profileId'];
        if (!empty($data['cartId'])) {
            $cartId = $data['cartId'];
        }
        if (!empty($data['note'])) {
            $optionalBillingParams['note'] = $data['note'];
        }

        $recurringProfileResult = Tools_RecurringPaymentPaypal::updateRecurringPaymentsProfile($profileId,
            $creditCardNumber, $cvv, $expirationDate, $email, $street, $city, $state, $countryCode,
            $zip, $optionalBillingParams);
        if ($recurringProfileResult['error'] === '1') {
            return $recurringProfileResult;
        }

        $profileId = $recurringProfileResult['PROFILEID'];
        $updateLocalProfileResponse = Tools_RecurringPaymentPaypal::updateLocalProfileInfo($profileId, $userId, $cartId);
        if ($updateLocalProfileResponse['error'] === '1') {
            return $updateLocalProfileResponse;
        }

        return array('error' => '0', 'paypalRecurringPaymentsModel' => $updateLocalProfileResponse['paypalRecurringPaymentsModel'], 'sandbox' => '');
    }


    /**
     * Create recurring profile
     *
     * @param array $data recurrent profile data
     * @return array
     * @throws Exceptions_SeotoasterException
     */
    public function createRecurringProfile($data)
    {

        $optionalBillingParams = array();
        $profileStartDate = $data['profileStartDate'];
        $description = $data['description'];
        $billingPeriod = $data['billingPeriod'];
        $billingFrequency = $data['billingFrequency'];
        $amt = $data['amt'];
        $currencyCode = $data['currencyCode'];
        $creditCardNumber = $data['creditCardNumber'];
        $expirationDate = $data['expirationDate'];
        $cvv = $data['cvv'];
        $email = $data['email'];
        $street = $data['street'];
        $city = $data['city'];
        $state = $data['state'];
        $countryCode = $data['countryCode'];
        $zip = $data['zip'];
        $userId = $data['userId'];
        if (!empty($data['initAmt'])) {
            $optionalBillingParams['initAmt'] = $data['initAmt'];
        }
        if (!empty($data['totalBillingCycles'])) {
            $optionalBillingParams['totalBillingCycles'] = $data['totalBillingCycles'];
        }
        if (!empty($data['autoBillOutAtm'])) {
            $optionalBillingParams['autoBillOutAtm'] = $data['autoBillOutAtm'];
        }
        $cartId = 0;
        if (!empty($data['cartId'])) {
            $cartId = $data['cartId'];
        }

        $recurringProfileResult = Tools_RecurringPaymentPaypal::createRecurringPaymentsProfile($profileStartDate, $description, $billingPeriod, $billingFrequency,
            $amt, $currencyCode, $creditCardNumber, $expirationDate, $cvv, $email, $street, $city, $state, $countryCode, $zip, $optionalBillingParams);
        if ($recurringProfileResult['error'] === '1') {
            return $recurringProfileResult;
        }

        $profileId = $recurringProfileResult['PROFILEID'];
        $updateLocalProfileResponse = Tools_RecurringPaymentPaypal::updateLocalProfileInfo($profileId, $userId, $cartId);
        if ($updateLocalProfileResponse['error'] === '1') {
            return $updateLocalProfileResponse;
        }

        return array('error' => '0', 'paypalRecurringPaymentsModel' => $updateLocalProfileResponse['paypalRecurringPaymentsModel'], 'sandbox' => '');

    }


    /**
     * Bill outstanding amount
     *
     * @param array $data recurrent profile data
     * @return array
     * @throws Exceptions_SeotoasterException
     */
    public function billOutstandingAmount($data)
    {
        $userId = $data['userId'];
        $cartId = 0;
        $profileId = $data['profileId'];
        if (!empty($data['cartId'])) {
            $cartId = $data['cartId'];
        }
        $billOutstandingAmountResult = Tools_RecurringPaymentPaypal::billOutstandingAmount($profileId);
        if ($billOutstandingAmountResult['error'] === '1') {
            return $billOutstandingAmountResult;
        }

        $profileId = $billOutstandingAmountResult['PROFILEID'];
        $updateLocalProfileResponse = Tools_RecurringPaymentPaypal::updateLocalProfileInfo($profileId, $userId, $cartId);
        if ($updateLocalProfileResponse['error'] === '1') {
            return $updateLocalProfileResponse;
        }

        return array('error' => '0', 'paypalRecurringPaymentsModel' => $updateLocalProfileResponse['paypalRecurringPaymentsModel'], 'sandbox' => '');
    }

    /**
     * Single product payment action
     */
    public function paySingleProductAction(){
        $payResult = array();
        if ($this->_request->isPost()) {
            $tokenToValidate = $this->_request->getParam(Tools_System_Tools::CSRF_SECURE_TOKEN, false);
            $valid = Tools_System_Tools::validateToken($tokenToValidate, self::PAYPAL_SECURE_TOKEN);
            if (!$valid) {
                $this->_responseHelper->fail('Validation failed');
            }
            $data = filter_var_array($this->_request->getParams(), FILTER_SANITIZE_STRING);
            $data = array_filter($data);
            if (empty($data)) {
                $this->_responseHelper->fail('');
            }
            $productQty = !empty($data['product-qty']) ? $data['product-qty'] : 1;
            $cartSession = Tools_ShoppingCart::getInstance();
            $productMapper = Models_Mapper_ProductMapper::getInstance();
            $product = $productMapper->find($data['productId']);
            if (!$product instanceof Models_Model_Product) {
                $payResult['error'] = 1;
                $payResult['message'] = $this->_translator->translate('Product not found.');
                echo json_encode($payResult);
                return;
            }
            if ($product->getInventory() == '0' || $product->getEnabled() != '1') {
                $payResult['error'] = 1;
                $payResult['message'] = $this->_translator->translate('Product is out of stock.');
                echo json_encode($payResult);
                return;
            }
            $cartSession->clean();
            $cartSession->setContent(array());
            $cartSession->setCartId(null);
            $cartSession->add($product, [], $productQty);
            $cartSession->calculate(true);
            $cartSession->save();

            $session = Zend_Controller_Action_HelperBroker::getStaticHelper('session');
            $currentLoggedUser = $session->getCurrentUser();

            $billingAddress = array();
            $addressType = Models_Model_Customer::ADDRESS_TYPE_BILLING;
            $billingAddress['firstname'] = isset($data['firstname']) ? $data['firstname'] : '';
            $billingAddress['lastname'] = isset($data['lastname']) ? $data['lastname'] : '';
            $billingAddress['company'] = '';
            $billingAddress['email'] = isset($data['email']) ? $data['email'] : '';
            $billingAddress['address1'] = isset($data['billing_address1']) ? $data['billing_address1'] : '';
            $billingAddress['address2'] = '';
            $billingAddress['country'] = isset($data['country']) ? $data['country'] : '';
            $billingAddress['city'] = isset($data['city']) ? $data['city'] : '';
            $billingAddress['state'] = isset($data['state']) ? $data['state'] : '';
            $billingAddress['zip'] = isset($data['zip']) ? $data['zip'] : '';
            $billingAddress['phone'] = isset($data['phone']) ? $data['phone'] : '';
            $billingAddress['phone_country_code_value'] = '';
            $billingAddress['phonecountrycode'] = isset($data['phonecountrycode']) ? $data['phonecountrycode'] : '';
            $customerData = [];
            if ($currentLoggedUser instanceof Application_Model_Models_User && $currentLoggedUser->getId()) {
                $customerData['email'] = $currentLoggedUser->getEmail();
            } else {
                $customerData['firstname'] = isset($data['firstname']) ? $data['firstname'] : '';
                $customerData['lastname'] = isset($data['lastname']) ? $data['lastname'] : '';
                $customerData['email'] = isset($data['email']) ? $data['email'] : '';
                $customerData['mobilecountrycode'] = isset($data['phonecountrycode']) ? $data['phonecountrycode'] : '';
                $customerData['mobile'] = isset($data['phone']) ? $data['phone'] : '';
            }
            $customer = Shopping::processCustomer($customerData);
            if ($customer->getId()) {
                $cartSession->setCustomerId($customer->getId())->calculate(true);
                $addressId = Models_Mapper_CustomerMapper::getInstance()->addAddress($customer, $billingAddress,
                    $addressType);
                $cartSession->setBillingAddressKey($addressId);
                $cartSession->setShippingAddressKey($addressId);
                $cartSession->save()->saveCartSession($customer);

            }
            $cartId = $cartSession->getCartId();
            $amount = $cartSession->getTotal();
            $amount = round($amount, 2);

            $creditCardNum = preg_replace(array('/ /', '/-/', '/\//'), '', trim($data['cardnumber']));
            $data['expiration_date_month'] = strlen($data['expiration_date_month']) === 1 ? '0' . $data['expiration_date_month'] : $data['expiration_date_month'];

            $profileData = array();
            $profileData['profileStartDate'] = Tools_System_Tools::convertDateFromTimezone('+'. $data['quantityPeriods'] .' ' . $data['billingPeriod']);
            $profileData['description'] = $data['desc'];
            $profileData['billingPeriod'] = $data['billingPeriod'];
            $profileData['billingFrequency'] = 1;
            $profileData['amt'] = $amount;
            $profileData['currencyCode'] = $data['currency_code'];
            $profileData['creditCardNumber'] = $creditCardNum;
            $profileData['expirationDate'] = $data['expiration_date_month'] . $data['expiration_date_year'];
            $profileData['cvv'] = $data['verification_number'];
            $profileData['email'] = $data['email'];
            $profileData['street'] = $data['billing_address1'];
            $profileData['city'] = $data['city'];
            $profileData['state'] = $data['state'];
            $profileData['countryCode'] = $data['country'];
            $profileData['zip'] = $data['zip'];
            $profileData['userId'] = $customer->getId();
            $profileData['cartId'] = $cartId;
            $profileData['initAmt'] = $amount;
//            $profileData['totalBillingCycles'] = $data['quantityPayments'];

            $createProfileResponse = $this->createRecurringProfile($profileData);
            if ($createProfileResponse['error'] === '1') {
                $payResult['error'] = 1;
                $payResult['message'] = $createProfileResponse['message'];
                $this->updateCartStatus($cartId, Models_Model_CartSession::CART_STATUS_ERROR, false, $payResult['message']);
            } elseif (isset($createProfileResponse['paypalRecurringPaymentsModel']) && $createProfileResponse['paypalRecurringPaymentsModel'] instanceof Paypal_Models_Models_PaypalRecurringPaymentsModel) {
                try {
                    $payResult['error'] = 0;
                    $paypalTransactionMapper = Paypal_Models_Mapper_PaypalTransactionMapper::getInstance();
                    $paypalTransaction = new Paypal_Models_Models_PaypalTransactionModel();
                    $rpModel = $createProfileResponse['paypalRecurringPaymentsModel'];
                    $paypalTransaction->setTxnId('');
                    $paypalTransaction->setPayerId($rpModel->getProfileId());
                    $paypalTransaction->setPayerMail($rpModel->getEmail());
                    $paypalTransaction->setAmount($amount);
                    $paypalTransaction->setShippingAmount('');
                    $paypalTransaction->setTax(round($cartSession->getTotalTax(), 2));
                    $paypalTransaction->setCurrency($rpModel->getCurrencyCode());
                    $paypalTransaction->setPaymentStatus(Models_Model_CartSession::CART_STATUS_COMPLETED);
                    $paypalTransaction->setStatus($rpModel->getPayerStatus());
                    $paypalTransaction->setPaymentType('single-product');
                    $paypalTransaction->setPaymentId($cartId);
                    $paypalTransaction->setPaymentDate(Tools_System_Tools::convertDateFromTimezone('now'));
                    $paypalTransaction->setPFirstName($customerData['firstname']);
                    $paypalTransaction->setPLastName($customerData['lastname']);
                    $paypalTransaction->setPCountry($rpModel->getCountry());
                    $paypalTransaction->setPCountryCode($rpModel->getCountryCode());
                    $paypalTransaction->setPAddressState($rpModel->getState());
                    $paypalTransaction->setPAddressCity($rpModel->getCity());
                    $paypalTransaction->setPAddressZip($rpModel->getZip());
                    $paypalTransaction->setPAddressName($rpModel->getStreet());
                    $paypalTransaction->setCartId($cartId);
                    $paypalTransaction->setPendingReason('');
                    $paypalTransaction->setSubscribeStatus('active');
                    $paypalTransaction->setSubscribePeriod('');
                    $paypalTransaction->setSubscribePeriodType($data['billingPeriod']);
                    $paypalTransaction->setSubscribeDate(Tools_System_Tools::convertDateFromTimezone('now'));
                    $paypalTransaction->setSubscriptionId($rpModel->getProfileId());
                    $paypalTransaction->setSubscriptionDatePayed(Tools_System_Tools::convertDateFromTimezone('now'));
                    $paypalTransaction->setSubscriptionAmountPayed($amount);
                    $paypalTransaction->setEmailSent(1);
                    $paypalTransaction->setCustomerEmailSent(1);
                    $paypalTransactionMapper->save($paypalTransaction);

                    $this->updateCartStatus($cartId, Models_Model_CartSession::CART_STATUS_COMPLETED);
                    $cart = Models_Mapper_CartSessionMapper::getInstance()->find($cartId);
                    /*$cart->registerObserver(new Tools_Mail_Watchdog(array(
                        'trigger' => Tools_StoreMailWatchdog::TRIGGER_NEW_ORDER
                    )));*/
                    $cart->notifyObservers();
                    $paymentPeriod = 'recurring-payment-' . strtolower($data['billingPeriod']);
                    Tools_RecurringPaymentTools::createRecurringPaymentInfo($cartId, 65535, $rpModel->getProfileId(), '',
                        $paymentPeriod, $amount, 'paypal', $amount, '', 'active', 1, 1);
                } catch (Exception $e) {
                    error_log($e->getMessage());
                }
            }
        }

        echo json_encode($payResult);
        return;
    }

    public function recurringPaymentIpnAction()
    {
        $ipnData = $this->_request->getParams();
        $txnType = filter_var($this->_request->getParam('txn_type'), FILTER_SANITIZE_STRING);
        $recurringPaymentId = filter_var($this->_request->getParam('recurring_payment_id'), FILTER_SANITIZE_STRING);
        if (empty($recurringPaymentId)) {
            return $this->_responseHelper->fail('');
        }

        $paypalTransactionMapper = Paypal_Models_Mapper_PaypalTransactionMapper::getInstance();
        if(isset($ipnData['txn_id'])){
            $txnExists = $paypalTransactionMapper->findByTxnId($ipnData['txn_id']);
        }

        if (!empty($txnExists)) {
            return $this->_responseHelper->success('Transaction exists');
        }

        $paypalRecurringPaymentsMapper = Paypal_Models_Mapper_PaypalRecurringPaymentsMapper::getInstance();
        $cartSessionMapper = Models_Mapper_CartSessionMapper::getInstance();
        $storeRecurringPaymentsMapper = Store_Mapper_RecurringPaymentsMapper::getInstance();
        $paypalRecurringPaymentsModel = $paypalRecurringPaymentsMapper->findByProfileId($recurringPaymentId);
        if (!$paypalRecurringPaymentsModel instanceof Paypal_Models_Models_PaypalRecurringPaymentsModel) {
            return $this->_responseHelper->fail('');
        }
        $userId = $paypalRecurringPaymentsModel->getUserId();
        $cartId = $paypalRecurringPaymentsModel->getCartId();
        $recurringCart = $paypalRecurringPaymentsMapper->findRecurringCartByParentCartId($cartId);
        if (!empty($recurringCart) && isset($recurringCart[0])) {
            $recurringCartId = $recurringCart[0]['recurring_cart_id'];
        }
        $ipnData['userId'] = $userId;
        $ipnData['cartId'] = $cartId;
        $user = Application_Model_Mappers_UserMapper::getInstance()->find($userId);
        if (!$user instanceof Application_Model_Models_User) {
            return $this->_responseHelper->fail('User not found.');
        }
        if ($txnType === Tools_RecurringPaymentPaypal::RECURRING_PROFILE_TYPE_CREATED) {
            return $this->_responseHelper->success('');
        }
        if ($txnType === Tools_RecurringPaymentPaypal::RECURRING_PROFILE_TYPE_REGULAR) {

            //------------------------update shopping recurring payment data---------------------------
            $where = $storeRecurringPaymentsMapper->getDbTable()->getAdapter()->quoteInto('subscription_id = ?', $recurringPaymentId);
            $recurrent = $storeRecurringPaymentsMapper->fetchAll($where);
            if (!(isset($recurrent[0]) && $recurrent[0] instanceof Store_Model_RecurringPayments)) {
                return $this->_responseHelper->success('');
            }
            $recurrentModel = $recurrent[0];
            $recurrentCart = $cartSessionMapper->find($recurrentModel->getCartId());
            $recurrentCart->setId(null);
            $recurrentCart->setPurchasedOn(Tools_System_Tools::convertDateFromTimezone('now'));
            $currentCartId = $cartSessionMapper->save($recurrentCart)->getId();
            $recurrentModel->setSubscriptionDate(Tools_System_Tools::convertDateFromTimezone($ipnData['time_created']));
            $recurrentModel->setLastPaymentDate(Tools_System_Tools::convertDateFromTimezone($ipnData['payment_date']));
            $recurrentModel->setNextPaymentDate(Tools_System_Tools::convertDateFromTimezone($ipnData['next_payment_date']));
            $recurrentModel->setTotalAmountPaid($recurrentModel->getTotalAmountPaid() + $ipnData['amount']);
            $recurrentModel->setTransactionsQuantity($recurrentModel->getTransactionsQuantity() + 1);
            $storeRecurringPaymentsMapper->save($recurrentModel);
            //-------------------------------------------------------------------------------------------

            $recurringProfileResult = $this->recurringIpn($ipnData);
            if ($recurringProfileResult['error'] === '1') {
                error_log($recurringProfileResult['message']);
                return $this->_responseHelper->fail('');
            }
            if (!isset($recurringProfileResult['paypalRecurringPaymentsModel']) || !($recurringProfileResult['paypalRecurringPaymentsModel'] instanceof Paypal_Models_Models_PaypalRecurringPaymentsModel)) {
                return $this->_responseHelper->fail('');
            }
            $rpModel = $recurringProfileResult['paypalRecurringPaymentsModel'];
            try {
                $userFullName = explode(' ', $user->getFullName());

                $paypalTransaction = new Paypal_Models_Models_PaypalTransactionModel();
                $paypalTransaction->setTxnId($ipnData['txn_id']);
                $paypalTransaction->setPayerId($rpModel->getProfileId());
                $paypalTransaction->setPayerMail($rpModel->getEmail());
                $paypalTransaction->setAmount($ipnData['amount']);
                $paypalTransaction->setShippingAmount('');
                $paypalTransaction->setTax('');
                $paypalTransaction->setCurrency($rpModel->getCurrencyCode());
                $paypalTransaction->setPaymentStatus($ipnData['payment_status']);
                $paypalTransaction->setStatus($rpModel->getPayerStatus());
                $paypalTransaction->setPaymentType($ipnData['txn_type']);
                $paypalTransaction->setPaymentId(isset($currentCartId) ? $currentCartId : $cartId);
                $paypalTransaction->setPaymentDate(Tools_System_Tools::convertDateFromTimezone('now'));
                $paypalTransaction->setPFirstName(isset($userFullName[0]) ? $userFullName[0] : '');
                $paypalTransaction->setPLastName(isset($userFullName[1]) ? $userFullName[1] : '');
                $paypalTransaction->setPCountry($rpModel->getCountry());
                $paypalTransaction->setPCountryCode($rpModel->getCountryCode());
                $paypalTransaction->setPAddressState($rpModel->getState());
                $paypalTransaction->setPAddressCity($rpModel->getCity());
                $paypalTransaction->setPAddressZip($rpModel->getZip());
                $paypalTransaction->setPAddressName($rpModel->getStreet());
                $paypalTransaction->setCartId(isset($currentCartId) ? $currentCartId : $cartId);
                $paypalTransaction->setPendingReason('');
                $paypalTransaction->setSubscribeStatus('active');
                $paypalTransaction->setSubscribePeriodType($ipnData['payment_cycle']);
                $paypalTransaction->setSubscribeDate(Tools_System_Tools::convertDateFromTimezone($ipnData['time_created']));
                $paypalTransaction->setSubscriptionId($rpModel->getProfileId());
                $paypalTransaction->setSubscriptionDatePayed(Tools_System_Tools::convertDateFromTimezone($ipnData['payment_date']));
                $paypalTransaction->setSubscriptionAmountPayed($ipnData['amount']);
                $paypalTransaction->setEmailSent(1);
                $paypalTransaction->setCustomerEmailSent(1);
                $paypalTransactionMapper->save($paypalTransaction);

//                $this->_sessionHelper->storeCartSessionKey = $currentCartId;
                $rpModel->registerObserver(new Tools_Mail_Watchdog(array(
                    'trigger' => Tools_PaypalMailWatchdog::TRIGGER_SUBSCRIPTION_RECURRING_PAYMENT,
                    'fullName' => $user->getFullName(),
                    'userEmail' => $user->getEmail()
                )));
                $rpModel->notifyObservers();

            } catch (Exception $e) {
                error_log($e->getMessage());
            }
        }
        if ($txnType === Tools_RecurringPaymentPaypal::RECURRING_PROFILE_TYPE_SKIPPED) {
            return $this->_responseHelper->success('');
        }
        if ($txnType === Tools_RecurringPaymentPaypal::RECURRING_PROFILE_TYPE_FAILED) {
            $paypalRecurringPaymentsModel->registerObserver(new Tools_Mail_Watchdog(array(
                'trigger' => Tools_PaypalMailWatchdog::TRIGGER_SUBSCRIPTION_RECURRING_FAILED,
                'fullName' => $user->getFullName(),
                'userEmail' => $user->getEmail()
            )));
            $paypalRecurringPaymentsModel->notifyObservers();
        }
        if ($txnType === Tools_RecurringPaymentPaypal::RECURRING_PROFILE_TYPE_SUSPENDED_DUE_TO_MAX || $txnType === Tools_RecurringPaymentPaypal::RECURRING_PROFILE_TYPE_SUSPENDED) {
            Tools_RecurringPaymentPaypal::updateLocalProfileInfo($recurringPaymentId, $userId, $cartId);
            if (!empty($recurringCartId)) {
                $storeRecurringPaymentsMapper->updateRecurringStatus($recurringCartId, Store_Model_RecurringPayments::SUSPENDED_RECURRING_PAYMENT);
            }
            $paypalRecurringPaymentsModel->registerObserver(new Tools_Mail_Watchdog(array(
                'trigger' => Tools_PaypalMailWatchdog::TRIGGER_SUBSCRIPTION_RECURRING_SUSPENDED,
                'fullName' => $user->getFullName(),
                'userEmail' => $user->getEmail()
            )));
            $paypalRecurringPaymentsModel->notifyObservers();
        }
        if ($txnType === Tools_RecurringPaymentPaypal::RECURRING_PROFILE_TYPE_CANCEL) {
            Tools_RecurringPaymentPaypal::updateLocalProfileInfo($recurringPaymentId, $userId, $cartId);
            if (!empty($recurringCartId)) {
                $storeRecurringPaymentsMapper->updateRecurringStatus($recurringCartId, Store_Model_RecurringPayments::CANCELED_RECURRING_PAYMENT);
            }
            $paypalRecurringPaymentsModel->registerObserver(new Tools_Mail_Watchdog(array(
                'trigger' => Tools_PaypalMailWatchdog::TRIGGER_SUBSCRIPTION_RECURRING_CANCELED,
                'fullName' => $user->getFullName(),
                'userEmail' => $user->getEmail()
            )));
            $paypalRecurringPaymentsModel->notifyObservers();
        }

        return $this->_responseHelper->success('');
    }

}
