CREATE TABLE IF NOT EXISTS `plugin_notifier_config` (
	`name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
	`value` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
	PRIMARY KEY (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE IF NOT EXISTS `plugin_notifier_subscriptions` (
	`token` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
	`endpoint` varchar(512) COLLATE utf8_unicode_ci NOT NULL,
	`auth` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
	`p256dh` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
	`createdAt` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
	PRIMARY KEY (`token`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE IF NOT EXISTS `plugin_notifier_news` (
	`id` bigint(20) NOT NULL AUTO_INCREMENT,
	`news_id` int(10) unsigned DEFAULT NULL,
	`token` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
	`created_at` timestamp NULL DEFAULT NULL,
	`sent_at` timestamp NULL DEFAULT NULL,
	`status` int(11) NOT NULL DEFAULT '0',
	PRIMARY KEY (`id`),
	KEY `token` (`token`),
	KEY `news_id` (`news_id`),
	CONSTRAINT `plugin_notifier_news_ibfk_3` FOREIGN KEY (`news_id`) REFERENCES `plugin_newslog_news` (`id`) ON DELETE CASCADE ON UPDATE NO ACTION,
	CONSTRAINT `plugin_notifier_news_ibfk_4` FOREIGN KEY (`token`) REFERENCES `plugin_notifier_subscriptions` (`token`) ON DELETE CASCADE ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO `observers_queue` (`observable`, `observer`) VALUES ('Newslog_Models_Model_News',	'Tools_NotifierNewsObserver');

CREATE TABLE IF NOT EXISTS `plugin_notifier_pending_news` (
	`news_id` int(10) unsigned NOT NULL,
	`created_at` timestamp NULL DEFAULT NULL,
	`status` int(11) NOT NULL DEFAULT '0',
	PRIMARY KEY (`news_id`),
	CONSTRAINT `plugin_notifier_news_ibfk_33` FOREIGN KEY (`news_id`) REFERENCES `plugin_newslog_news` (`id`) ON DELETE CASCADE ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- 12/01/2022
-- version: 3.0.1
CREATE TABLE IF NOT EXISTS `plugin_notifier_news_info` (
	`id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
	`news_id` int(10) unsigned NOT NULL,
	`published_at` DATE NULL,
	PRIMARY KEY (`id`),
	CONSTRAINT `plugin_notifier_news_info_ibfk_1` FOREIGN KEY (`news_id`) REFERENCES `plugin_newslog_news` (`id`) ON DELETE CASCADE ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

UPDATE `plugin` SET `version`='3.0.2' WHERE `name`='notifier';