define([
    'backbone',
    'i18n!../../../nls/dashboard_'+$('#main-dashboard-system-language').val()+'_ln'
], function(Backbone, i18n){
    var LeadFormView = Backbone.View.extend({
        el: $('#lead-form'),
        events: {
            'submit': 'submit',
            'blur #lead-email': 'checkEmail',
            'keyup #lead-email': 'checkEmail',
            'click #lead-form-save-and-go-to-profile': 'addAndGoToProfile'
        },
        templates: {

        },
        initialize: function(){
            this.$el = $('#lead-form');
            this.$el.attr('action', $('#website_url').val()+'api/leads/leads');
            $("#lead-organization")
                .on("keydown", function(event) {
                    if ( event.keyCode === $.ui.keyCode.TAB &&
                        $(this).autocomplete( "instance" ).menu.active) {
                        event.preventDefault();
                    }
                })
                .autocomplete({
                    source: function( request, response ) {
                        $.ajax({
                            'url': $('#website_url').val()+'api/leads/leadorganization/',
                            'type':'GET',
                            'dataType':'json',
                            'data': {searchTerm: request.term}
                        }).done(function(responseData){
                            if (!_.isEmpty(responseData)) {
                                response($.map(responseData, function (responseData) {
                                    return {
                                        label: responseData.organization_name,
                                        value: responseData.organization_name
                                    };
                                }));
                            }
                        });
                    },
                    search: function() {

                    },
                    focus: function() {
                        return false;
                    },
                    select: function( event, ui ) {

                    }
                });

        },
        render: function(){
            return this;
        },
        checkEmail:function(e)
        {
            var email = $(e.currentTarget).val(),
                websiteUrl = $('#website_url').val();

            if (_.isEmpty(email)) {
                return false;
            }
            $.ajax({
                'url': websiteUrl+'api/leads/leads/',
                'type':'GET',
                'dataType':'json',
                'data': {'email': email}
            }).done(function(responseData){
                if (!_.isEmpty(responseData.data)) {
                    $('#lead-form-save').val('Go to profile').attr('id', 'go-to-lead-profile').data('cid', responseData.data[0].id);
                    $('#lead-form-save-and-go-to-profile').addClass('hidden');
                } else {
                    $('#go-to-lead-profile').attr('id', 'lead-form-save').val('Add lead');
                    $('#lead-form-save-and-go-to-profile').removeClass('hidden');
                }
            });

            // $.ajax({
            //     'url': websiteUrl+'api/leads/leadorganization/?filter[organization_domain]='+email.replace(/(.*)@/, ''),
            //     'type':'GET',
            //     'dataType':'json'
            // }).done(function(responseData){
            //     if (!_.isEmpty(responseData[0])) {
            //        $('#lead-organization').val(responseData[0].organization_name);
            //     } else {
            //        $('#lead-organization').val('');
            //     }
            // });
        },
        addAndGoToProfile: function(e) {
            e.preventDefault();
            var currentEl = $(e.currentTarget),
                formEl = currentEl.closest('form');

            this.submit(formEl, true);
        },
        submit: function(e, goToProfile){
            if (e.target) {
                e.preventDefault();
                var form =  $(e.currentTarget);
            } else {
                form = e;
            }

            var self = this,
                isValid = true,
                submitButton = form.find('#lead-form-save'),
                goToProfile = goToProfile || false;

            if (submitButton.length < 1) {
                return false;
            }
            _.each(form.find('.required'), function(el){
                if (!$(el).val()){
                    isValid = false;
                }
            });

            if (!isValid){
                showMessage(_.isUndefined(i18n['Missing required field'])?'Missing required field':i18n['Missing required field'], true);
                return false;
            }

            var formParams = form.serialize();

            $.ajax({
                url: form.attr('action'),
                type: 'POST',
                data: formParams,
                dataType: 'json'
            }).done(function(response) {
                 window.OrganizationDetailed.updateOrganizationContactList();
                 showMessage(response.responseText.message, false, 5000);
                 form.find('input[type="text"]').val('');
                 form.find('textarea').val('');
                 form.find('select[name="prefix"]').val('');
                 if (goToProfile) {
                    window.location.href = $('#website_url').val()+'dashboard/leads/#lead/'+response.responseText.leadId
                 } else {
                    $('#switch-lead-creation').trigger('click');
                 }
            }).fail(function(response){
                showMessage(response.responseJSON, true, 5000);
            });
            return false;

        }
    });

    return LeadFormView;
});