define([
    'backbone',
    'text!../../product/templates/productPaginatorTemplate.html',
    '../../product/models/product',
    '../../product/collections/products_pager',
    '../../product/views/productlist',
    '../../product/collections/images',
    'i18n!../../../nls/dashboard_'+$('#main-dashboard-system-language').val()+'_ln'
], function(Backbone,
            ProductPaginatorTmpl, ProductModel, ProductsCollection, ProductListView, ImagesCollection, i18n){
    var LeadProductListView = Backbone.View.extend({
        el: $('#lead-block'),
        events:{
            'click .show-product-list': 'toggleProductList',
            'click #product-list-back-link': 'hideProductList',
            'keypress #product-list-search': 'filterProducts',
            'click .paginator .page': 'paginatorAction',
            'change #product-list-holder input.marker': 'markProducts',
            'click #add-products': 'addProducts'
        },
        templates: {},
        render: function(){
            return this;
        },
        initialize: function(){
            //init products for product list
            this.initProduct();
            $('#product-list-search').ajaxStart(function(){
                $(this).attr('disabled', 'disabled');
            }).ajaxStop(function(){
                $(this).removeAttr('disabled');
            });
            this.images =  new ImagesCollection();
            this.images.on('reset', this.renderImages, this);

            this.initProducts().pager();

        },
        toggleProductList: function(e) {
            e.preventDefault();
            this.initSearchIndex();

            var listtype = $(e.currentTarget).data('listtype'),
                labels = $('#add-products').data('labels'),
                currentProductIds = $('#product-ids').val();

            $('#product-list').show('slide');
            $('#product-list-holder').data('type', listtype);

            if (this.products === null || typeof this.products == 'undefined') {
                $('#product-list-holder').html('<div class="spinner"></div>');
                return this.initProducts().pager();
            }
            $("#lead-form").toggleClass('hidden');
            $('#switch-lead-creation').toggleClass('hidden');
        },
        initProduct: function () {
            this.model = new ProductModel();
            this.model.on('sync', function(){
                if (this.model.has('options')){
                    this.model.get('options').on('add', this.renderOption, this);
                    this.model.get('options').on('reset', this.renderOptions, this);
                }
                if (this.products !== null){
                    this.products.pager();
                }
                this.render();
                showMessage(_.isUndefined(i18n['Product saved.<br/> Go to your search engine optimized product landing page here.'])?'Product saved.<br/> Go to your search engine optimized product landing page here.':i18n['Product saved.<br/> Go to your search engine optimized product landing page here.']);
            }, this);
            this.model.on('error', this.processSaveError, this);
            this.model.get('options').on('add', this.renderOption, this);
            this.model.get('options').on('reset', this.renderOptions, this);
            return this;
        },
        initProducts: function(){
            if (this.products === null || typeof this.products == 'undefined') {
                this.products = new ProductsCollection();
                this.products.bind('add', this.renderProduct, this);
                this.products.bind('reset', this.renderProducts, this);
            }
            return this.products;
        },
        renderProduct: function(product){
            var productView = new ProductListView({model: product});

            this.$('#product-list-holder').append(productView.render().el);
            if (_.has(this.products, 'checked') && _.contains(this.products.checked, product.get('id'))){
                productView.$el.find('input.marker').prop('checked', true);

            }
        },
        renderProducts: function(){
            if (this.products.length){
                this.$('#product-list-holder').empty();
                this.products.each(this.renderProduct, this);
                var paginatorData = {
                    collection : 'products',
                    cssClass: 'mt5px'
                };
                paginatorData = _.extend(paginatorData, this.products.info());
                $('div.paginator', '#product-list').replaceWith(_.template(ProductPaginatorTmpl, paginatorData));
            } else {
                $('#product-list-holder').html('<p class="nothing">'+$('#product-list-holder').data('emptymsg')+'</p>');
            }
        },
        initSearchIndex: _.once(function(){
            $.getJSON($('#website_url').val() + '/plugin/shopping/run/searchindex', function(response){
                self.searchIndex = response;
                $('#product-list-search').autocomplete({
                    minLength: 2,
                    source: response,
                    select: function(event, ui){
                        $('#product-list-search').val(ui.item.value).trigger('keypress', true);
                    }
                });
            });
        }),
        hideProductList: function(){
            $('#product-list').hide('slide');
            var term = $.trim($('#product-list-search').val());
            if (term != this.products.key){
                if (term == ''){
                    $('#product-list-search').trigger('keypress', true);
                } else {
                    $('#product-list-search').val(this.products.key);
                }
            }
            $("#lead-form").toggleClass('hidden');
            $('#switch-lead-creation').toggleClass('hidden');
        },
        filterProducts: function(e, forceRun) {
            if (e.keyCode === 13 || forceRun === true) {
                $('#product-list-holder').html('<div class="spinner"></div>');
                this.products.key = e.currentTarget.value;
                this.products.goTo(this.products.firstPage);
                $(e.target).autocomplete('close');
            }
        },
        paginatorAction:  function(e){
            var page = $(e.currentTarget).data('page');
            var collection = $(e.currentTarget).parent('.paginator').data('collection');
            if (!collection) return false;
            if (_.has(this, collection)){
                collection = this[collection];
            }

            switch (page) {
                case 'first':
                    collection.goTo(collection.firstPage);
                    break;
                case 'prev':
                    if (collection instanceof Backbone.Paginator.requestPager){
                        collection.requestPreviousPage();
                    } else {
                        collection.previousPage();
                    }
                    break;
                case 'next':
                    if (collection instanceof Backbone.Paginator.requestPager){
                        collection.requestNextPage();
                    } else {
                        collection.nextPage();
                    }
                    break;
                case 'last':
                    collection.goTo(collection.totalPages);
                    break;
                default:
                    var pageId = parseInt(page);
                    !_.isNaN(pageId) && collection.goTo(pageId);
                    break;
            }
            return false;
        },
        markProducts: function (e) {
            var checked = [],
                url = $('#website_url').val(),
                img = url + '/system/images/noimage.png';


            var pid = parseInt(e.currentTarget.value),
                alt = e.target.dataset.altImg;
            img = e.target.dataset.imageUrl;
            checked = _.has(this.products, 'checked') ? this.products.checked : [];
            if (e.currentTarget.checked) {
                checked = _.union(checked, pid);
                $('#checked-product-images').append('<span class="productChekedImage productChekedImage-' + pid +
                '" data-product-id="'+pid+'"><img src="' + img + '" alt="' + alt + '" title="' + alt + '" /></span>');
            } else {
                checked = _.without(checked, pid);
                $('#checked-product-images .productChekedImage-' + pid + '').remove();
            }

            this.products.checked = checked;
        },
        addProducts: function() {
            var type = $('#product-list-holder').data('type');

            if (!_.has(this.products, 'checked') || _.isEmpty(this.products.checked)){
                return false;
            }
            $('.productsIds').val(this.products.checked);
            $('#product-list').hide('slide');
            $('#checked-product-images').show();
            $('#switch-lead-creation').removeClass('hidden');
            $('#lead-form').removeClass('hidden');
            return false;
        }

    });

    return LeadProductListView;
});
