define([
    'backbone',
    'i18n!../../../nls/dashboard_'+$('#main-dashboard-system-language').val()+'_ln'
], function(Backbone, i18n){
    var LeadNotesFormView = Backbone.View.extend({
        el: $('#lead-notes-form'),
        events: {
            'submit': 'submit'
        },
        templates: {

        },
        initialize: function(){

        },
        render: function(){
            this.$el.attr('action', $('#website_url').val()+'api/leads/leadnotes');
            return this;
        },
        submit: function(e){
            e.preventDefault();

            var self = this,
                form = $(e.currentTarget),
                isValid = true;

            _.each(form.find('.required'), function(el){
                if (!$(el).val()){
                    isValid = false;
                }
            });

            if (!isValid){
                showMessage('Missing required field', true);
                return false;
            }

            var formParams = form.serialize()+'&secureToken='+$('#lead-grid-token').val();


            $.ajax({
                url: form.attr('action'),
                type: 'POST',
                data: formParams,
                dataType: 'json'
            }).done(function(response) {
                 self.$el.trigger('LeadNotesForm:created');
                 showMessage(response.responseText, false, 5000);
                 form.find('textarea').val('');
            }).fail(function(response){
                showMessage(response.responseJSON, true, 5000);
            });
            return false;

        }
    });

    return LeadNotesFormView;
});