define([
    'backbone',
    'i18n!../../../nls/dashboard_'+$('#main-dashboard-system-language').val()+'_ln'
], function(Backbone, i18n){
    var LeadFormView = Backbone.View.extend({
        el: $('#lead-form'),
        events: {
            'submit': 'submit',
            'blur #lead-email,#lead-mobile,#lead-first-name,#lead-last-name,#lead-zip': 'checkCreatedLead',
            'keyup #lead-email,#lead-mobile,#lead-first-name,#lead-last-name,#lead-zip': 'checkCreatedLead',
            'click #lead-form-save-and-go-to-profile': 'addAndGoToProfile'
        },
        templates: {

        },
        initialize: function(){
            this.$el = $('#lead-form');
            this.$el.attr('action', $('#website_url').val()+'api/leads/leads');
            $('#lead-phone').bind('paste', function () { $(this).val(''); });
            $("#lead-organization")
                .on("keydown", function(event) {
                    if ( event.keyCode === $.ui.keyCode.TAB &&
                        $(this).autocomplete( "instance" ).menu.active) {
                        event.preventDefault();
                    }
                })
                .autocomplete({
                    source: function( request, response ) {
                        $.ajax({
                            'url': $('#website_url').val()+'api/leads/leadorganization/',
                            'type':'GET',
                            'dataType':'json',
                            'data': {searchTerm: request.term}
                        }).done(function(responseData){
                            if (!_.isEmpty(responseData)) {
                                response($.map(responseData, function (responseData) {
                                    return {
                                        label: responseData.organization_name,
                                        value: responseData.organization_name
                                    };
                                }));
                            }
                        });
                    },
                    search: function() {

                    },
                    focus: function() {
                        return false;
                    },
                    select: function( event, ui ) {

                    }
                });

        },
        render: function(){
            return this;
        },
        checkCreatedLead: function(e)
        {
            var self = this,
                currentEl = $(e.currentTarget),
                elType = currentEl.data('type'),
                param = currentEl.val(),
                quickForm = $('#lead-form');

                if(elType == 'email') {
                    self.checkEmail(elType, {'email' : param});
                } else if(elType == 'mobile') {
                    var mobileCountryCode = quickForm.find('#lead_mobile_country_code option:selected').val();
                    self.checkEmail(elType, {'mobileCountryCode' : mobileCountryCode, 'mobile' : param});
                } else if (elType == 'leadFirstName' || elType == 'leadLastName' || elType == 'leadZip') {
                    if(quickForm.find('input[name="leadFirstName"]').val() != '' && quickForm.find('input[name="leadLastName"]').val() && quickForm.find('input[name="leadZip"]').val()) {
                        self.checkEmail(elType, {
                            'leadFirstName' : quickForm.find('input[name="leadFirstName"]').val(),
                            'leadLastName'  : quickForm.find('input[name="leadLastName"]').val(),
                            'leadZip'  : quickForm.find('input[name="leadZip"]').val()
                        });
                    }
                }
        },
        checkEmail:function(elType, params)
        {
            var websiteUrl = $('#website_url').val(),
                lastCheckedElType = '',
                blockedElType = '';

            if (_.isEmpty(params[elType])) {
                return false;
            }
            $.ajax({
                'url': websiteUrl+'api/leads/leads/',
                'type':'GET',
                'dataType':'json',
                'data': params
            }).done(function(responseData){
                lastCheckedElType = $('#lead-form-save-and-go-to-profile').data('last-checked-el-type');
                blockedElType = $('#lead-form-save-and-go-to-profile').data('blocked-el-type');

                if (!_.isEmpty(responseData.data)) {
                    $('#lead-form-save').val('Go to profile').attr('id', 'go-to-lead-profile').data('cid', responseData.data[0].id);
                    $('#lead-form-save-and-go-to-profile').addClass('hidden');
                    $('#lead-form-save-and-go-to-profile').data('last-checked-el-type', elType);
                } else {
                    if (elType === lastCheckedElType || typeof lastCheckedElType === 'undefined') {
                        $('#go-to-lead-profile').attr('id', 'lead-form-save').val('Add lead');
                        $('#lead-form-save-and-go-to-profile').removeClass('hidden');
                        $('#lead-form-save-and-go-to-profile').data('last-checked-el-type', '');
                    }
                }

                $('#lead-form-save-and-go-to-profile').data('blocked-el-type', elType);


            });

            if(elType == 'email') {
                var domainName = params['email'].replace(/(.*)@/, '').trim();

                if (domainName === 'gmail.com' || domainName === 'yahoo.com' || domainName === 'outlook.com') {
                    $('#lead-organization').val('');
                    return false;
                }

                $.ajax({
                    'url': websiteUrl+'api/leads/leadorganization/?filter[organization_domain]='+domainName,
                    'type':'GET',
                    'dataType':'json'
                }).done(function(responseData){
                    if (!_.isEmpty(responseData[0])) {
                        $('#lead-organization').val(responseData[0].organization_name);
                    } else {
                        $('#lead-organization').val('');
                    }
                });
            }
        },
        addAndGoToProfile: function(e) {
            e.preventDefault();
            var currentEl = $(e.currentTarget),
                formEl = currentEl.closest('form');

            this.submit(formEl, true);
        },
        submit: function(e, goToProfile){
            if (e.target) {
                e.preventDefault();
                var form =  $(e.currentTarget);
            } else {
                form = e;
            }

            var self = this,
                isValid = true,
                submitButton = form.find('#lead-form-save'),
                goToProfile = goToProfile || false;

            if (submitButton.length < 1) {
                return false;
            }
            _.each(form.find('.required'), function(el){
                if (!$(el).val()){
                    isValid = false;
                }
            });

            if (!isValid){
                showMessage(_.isUndefined(i18n['Missing required field'])?'Missing required field':i18n['Missing required field'], true);
                return false;
            }

            var formParams = form.serialize();

            $.ajax({
                url: form.attr('action'),
                type: 'POST',
                data: formParams,
                dataType: 'json'
            }).done(function(response) {
                 self.$el.trigger('LeadForm:created');
                 showMessage(response.responseText.message, false, 5000);
                 form.find('input[type="text"]').val('');
                 form.find('textarea').val('');
                 form.find('select[name="prefix"]').val('');
                 if (goToProfile) {
                    window.location.href = $('#website_url').val()+'dashboard/leads/#lead/'+response.responseText.leadId
                 } else {
                    $('#switch-lead-creation').trigger('click');
                 }
            }).fail(function(response){
                showMessage(response.responseJSON, true, 5000);
            });
            return false;

        }
    });

    return LeadFormView;
});
