define([
    'backbone',
    'text!../templates/lead-call-detailed-tab.html',
    'i18n!../../../nls/dashboard_'+$('#main-dashboard-system-language').val()+'_ln',
    'tinyMCE'
], function(Backbone, DetailedCallTmpl, i18n, tinymce){
    var LeadCallFormView = Backbone.View.extend({
        el: $('#lead-detailed-view-config-tab-call'),
        events: {
            'submit form': 'submit',
            'change #call-device-type': 'selectCallDevice',
            'change #lead-phone-mobile-country-codes': 'changeCountryCode',
            'click #log-manually-lead-action': 'logCallManually',
            'click .add-shortcut': 'addShortcut'
        },
        templates: {

        },
        initialize: function(leadModel){
            this.leadModel = leadModel;
        },
        render: function(){
            tinymce.remove();
            this.$el.empty();
            this.$el.html(_.template(DetailedCallTmpl, {'leadModel': this.leadModel, 'i18n' : i18n}));
            var mobileMasks = this.leadModel.get('mobileMasks'),
                mobileCountryCode = this.leadModel.get('lead_mobile_country_code'),
                currentMobileCountryCode = this.attributes.currentMobileCountryCode,
                currentDesktopCountryCode = this.attributes.currentDesktopCountryCode;
            var websiteUrl = $('#website_url').val(),
                self = this;
            if (typeof mobileMasks[mobileCountryCode] !== 'undefined') {
                $('#lead-call-number').mask(mobileMasks[mobileCountryCode].mask_value, {autoclear: false});
            } else {
                $('#lead-call-number').mask('(999) 999 9999', {autoclear: false});
            }
            if ($('#lead-call-number').val() === '') {
                this.changeLeadCallNumber();
            }
            if (typeof mobileMasks[currentMobileCountryCode] !== 'undefined') {
                $('#lead-from-call-mobile').mask(mobileMasks[currentMobileCountryCode].mask_value, {autoclear: false});
            } else {
                $('#lead-from-call-mobile').mask('(999) 999 9999', {autoclear: false});
            }
            var mobile = _.isUndefined(i18n['Mobile'])?'Mobile':i18n['Mobile'];
            $('#lead-from-call-mobile-number').text(mobile + ' ' + $('#lead-from-call-mobile').val());

            if (typeof mobileMasks[currentDesktopCountryCode] !== 'undefined') {
                $('#lead-from-call-desktop').mask(mobileMasks[currentDesktopCountryCode].mask_value, {autoclear: false});
            } else {
                $('#lead-from-call-desktop').mask('(999) 999 9999', {autoclear: false});
            }
            var desktop = _.isUndefined(i18n['Desktop'])?'Desktop':i18n['Desktop'];
            $('#lead-from-call-desktop-number').text(desktop + ' ' + $('#lead-from-call-desktop').val());

            var voipPhone = _.isUndefined(i18n['VOIP phone'])?'VOIP phone':i18n['VOIP phone'];
            $('#lead-from-call-voip-phone-number').text(voipPhone + ' ' + $('#lead-from-call-voip-phone').val());

            this.$el.find('form').attr('action', $('#website_url').val()+'plugin/leads/run/callLead/');

            tinymce.init({
                script_url              : websiteUrl+'system/js/external/tinymce/tinymce.gzip.php',
                selector                : "#call-notes",
                skin                    : 'seotoaster',
                width                   : "100%",
                menubar                 : false,
                browser_spellcheck      : true,
                resize                  : false,
                convert_urls            : false,
                relative_urls           : false,
                statusbar               : false,
                allow_script_urls       : true,
                force_p_newlines        : true,
                forced_root_block       : false,
                entity_encoding         : "raw",
                plugins                 : ["fullscreen"],
                toolbar1                : "fullscreen | spellcheckbtn",
                fontsize_formats        : "8px 10px 12px 14px 16px 18px 24px 36px",
                block_formats           : "Block=div;Paragraph=p;Block Quote=blockquote;Cite=cite;Address=address;Code=code;Preformatted=pre;H2=h2;H3=h3;H4=h4;H5=h5;H6=h6",
                image_advtab            : true,
                extended_valid_elements : "a[*],input[*],select[*],textarea[*]",
                setup                   : function(ed){
                    var keyTime = null;
                    ed.on('change blur keyup', function(ed, e){
                        //@see content.js for this function
                        self.dispatchEditorKeyup(ed, e, keyTime);
                        this.save();
                    });

                    ed.addButton('spellcheckbtn', {
                        icon: true,
                        image: websiteUrl+'plugins/leads/web/images/spellcheck.ico',
                        tooltip: _.isUndefined(i18n['How do I enable spell-check in SeoToaster?'])?'How do I enable spell-check in SeoToaster?':i18n['How do I enable spell-check in SeoToaster?'],
                        onclick: function() {
                            window.open('https://www.seotoaster.com/questions-and-answers/crm-faq#lead-spellchecker', '_blank');
                        }
                    })
                }
            });
            $('#call-notes').html('<span></span>').trigger('keyup');
            this.tinimce = tinymce;

            return this;
        },
        submit: function(e){
            e.preventDefault();

            var self = this,
                form = $(e.currentTarget),
                isValid = true;

            _.each(form.find('.required'), function(el){
                if (!$(el).val()){
                    isValid = false;
                }
            });

            if (!isValid){
                showMessage(_.isUndefined(i18n['Missing required field'])?'Missing required field':i18n['Missing required field'], true);
                return false;
            }

            var formParams = form.serialize()+'&secureToken='+$('#lead-grid-token').val();

            $.ajax({
                url: form.attr('action'),
                type: 'POST',
                data: formParams,
                dataType: 'json'
            }).done(function(response) {
                if (response.error == '1') {
                    showMessage(response.responseText, true, 3000);
                } else {
                    showMessage(response.responseText, false, 5000);
                }
            }).fail(function(response){
                showMessage(response.responseJSON, true, 5000);
            });

            return false;

        },
        selectCallDevice: function(e)
        {
            var deviceTypeEl = $(e.currentTarget),
                deviceType = deviceTypeEl.val(),
                phoneEl = deviceTypeEl.closest('form').find('input[name="lead-call-number"]'),
                mobile = '',
                mobileCountyCode = '',
                phone = '',
                phoneCountryCode ='',
                desktopMasks = this.leadModel.get('desktopMasks'),
                mobileMasks = this.leadModel.get('mobileMasks'),
                organizationMobile = '',
                organizationPhone = '';

            if (deviceType === 'mobile') {
                if (!_.isNull(this.leadModel.get('lead_mobile'))) {
                    mobile = this.leadModel.get('lead_mobile');
                }
                if (!_.isNull(this.leadModel.get('lead_mobile_country_code'))) {
                    mobileCountyCode = this.leadModel.get('lead_mobile_country_code');
                }
                if (_.isEmpty(mobileCountyCode)) {
                    $(this.el).find('#lead-phone-mobile-country-codes').val('AC');
                } else {
                    $(this.el).find('#lead-phone-mobile-country-codes').val(mobileCountyCode);
                }
                phoneEl.val(mobile);

                if (typeof mobileMasks[mobileCountyCode] !== 'undefined') {
                    phoneEl.mask(mobileMasks[mobileCountyCode].full_mask_value, {autoclear: false}).focus();
                } else {
                    phoneEl.mask('(999) 999 9999', {autoclear: false}).focus();
                }
            }

            if (deviceType === 'desktop') {
                if (!_.isNull(this.leadModel.get('lead_phone'))) {
                    phone = this.leadModel.get('lead_phone');
                }
                if (!_.isNull(this.leadModel.get('lead_phone_country_code'))) {
                    phoneCountryCode = this.leadModel.get('lead_phone_country_code');
                }
                if (_.isEmpty(phoneCountryCode)) {
                    $(this.el).find('#lead-phone-mobile-country-codes').val('AC');
                } else {
                    $(this.el).find('#lead-phone-mobile-country-codes').val(phoneCountryCode);
                }
                phoneEl.val(phone);
                if (typeof desktopMasks[phoneCountryCode] !== 'undefined') {
                    phoneEl.mask(desktopMasks[phoneCountryCode].full_mask_value, {autoclear: false}).focus();
                } else {
                    phoneEl.mask('(999) 999 9999', {autoclear: false}).focus();
                }
            }

            if (deviceType === 'organization-mobile') {
                if (!_.isNull(this.leadModel.get('organization_mobile'))) {
                    organizationMobile = this.leadModel.get('organization_mobile');
                }
                if (!_.isNull(this.leadModel.get('organization_mobile_country_code'))) {
                    mobileCountyCode = this.leadModel.get('organization_mobile_country_code');
                }
                if (_.isEmpty(mobileCountyCode)) {
                    $(this.el).find('#lead-phone-mobile-country-codes').val('AC');
                } else {
                    $(this.el).find('#lead-phone-mobile-country-codes').val(mobileCountyCode);
                }
                phoneEl.val(organizationMobile);
                if (typeof mobileMasks[mobileCountyCode] !== 'undefined') {
                    phoneEl.mask(mobileMasks[mobileCountyCode].full_mask_value, {autoclear: false}).focus();
                } else {
                    phoneEl.mask('(999) 999 9999', {autoclear: false}).focus();
                }
            }

            if (deviceType === 'organization-phone') {
                if (!_.isNull(this.leadModel.get('organization_phone'))) {
                    organizationPhone = this.leadModel.get('organization_phone');
                }
                if (!_.isNull(this.leadModel.get('organization_phone_country_code'))) {
                    phoneCountryCode = this.leadModel.get('organization_phone_country_code');
                }
                if (_.isEmpty(phoneCountryCode)) {
                    $(this.el).find('#lead-phone-mobile-country-codes').val('AC');
                } else {
                    $(this.el).find('#lead-phone-mobile-country-codes').val(phoneCountryCode);
                }
                phoneEl.val(organizationPhone);
                if (typeof desktopMasks[phoneCountryCode] !== 'undefined') {
                    phoneEl.mask(desktopMasks[phoneCountryCode].full_mask_value, {autoclear: false}).focus();
                } else {
                    phoneEl.mask('(999) 999 9999', {autoclear: false}).focus();
                }
            }
        },
        changeCountryCode: function(e)
        {
            var countryEl = $(e.currentTarget),
                chosenCountryCode = countryEl.val(),
                deviceType = $(this.el).find('#call-device-type').val(),
                desktopMasks = this.leadModel.get('desktopMasks'),
                mobileMasks = this.leadModel.get('mobileMasks');

            if (deviceType === 'mobile') {
                if (typeof mobileMasks[chosenCountryCode] !== 'undefined') {
                    $(this.el).find('#lead-call-number').mask(mobileMasks[chosenCountryCode].full_mask_value, {autoclear: false});
                } else {
                    $(this.el).find('#lead-call-number').mask('(999) 999 9999', {autoclear: false});
                }
            }

            if (deviceType === 'desktop') {
                if (typeof desktopMasks[chosenCountryCode] !== 'undefined') {
                    $(this.el).find('#lead-call-number').mask(desktopMasks[chosenCountryCode].full_mask_value, {autoclear: false});
                } else {
                    $(this.el).find('#lead-call-number').mask('(999) 999 9999', {autoclear: false});
                }
            }
        },
        logCallManually: function(e)
        {
            e.preventDefault();

            var self = this,
                form = $(e.currentTarget).closest('form'),
                isValid = true;

            _.each(form.find('.required'), function(el){
                if (!$(el).val()){
                    isValid = false;
                }
            });

            if (!isValid){
                showMessage(_.isUndefined(i18n['Missing required field'])?'Missing required field':i18n['Missing required field'], true);
                return false;
            }

            var formParams = form.serialize()+'&secureToken='+$('#lead-grid-token').val();

            $.ajax({
                url: $('#website_url').val()+'plugin/leads/run/manualCallLead/',
                type: 'POST',
                data: formParams,
                dataType: 'json'
            }).done(function(response) {
                if (response.error == '1') {
                    showMessage(response.responseText, true, 3000);
                } else {
                    showMessage(response.responseText, false, 2000);
                    window.leadDetailed.timelineFilter.applyFilter();
                }
            }).fail(function(response){
                showMessage(response.responseJSON, true, 2000);
            });

            return false;
        },
        addShortcut: function (e) {
            tinymce.activeEditor.insertContent($(e.target).data('shortcut'));
        },
        dispatchEditorKeyup: function(editor, event, keyTime) {
            var keyTimer = keyTime;
            if(keyTimer === null) {
                keyTimer = setTimeout(function() {
                    keyTimer = null;
                }, 1000)
            }
        },
        changeLeadCallNumber: function () {
            if (this.leadModel.get('lead_phone') && this.leadModel.get('lead_phone').replace(/[\W_]+/g, '')) {
                $(this.el).find('#lead-call-form #call-device-type').val('desktop');
            } else if (this.leadModel.get('organization_mobile') && this.leadModel.get('organization_mobile').replace(/[\W_]+/g, '')) {
                $(this.el).find('#lead-call-form #call-device-type').val('organization-mobile');
            } else if (this.leadModel.get('organization_phone') && this.leadModel.get('organization_phone').replace(/[\W_]+/g, '')) {
                $(this.el).find('#lead-call-form #call-device-type').val('organization-phone');
            }
            $('#lead-call-form #call-device-type').trigger('change');
        }
    });

    return LeadCallFormView;
});
