define([
    'backbone',
    '../models/lead-custom-params',
    'backbone.paginator'
], function(Backbone, LeadCustomParamsModel){

    var LeadCustomParamsCollection = Backbone.Paginator.requestPager.extend({
        model: LeadCustomParamsModel,
        paginator_core: {
            type: 'GET',
            dataType: 'json',
            url: function(){
                return $('#website_url').val() + 'api/leads/leadcustomparams/';
            }
        },
        paginator_ui: {
            firstPage:    0,
            currentPage:  0,
            perPage:     3000,
            totalPages:  3000
        },
        server_api: {
            count: true,
            limit: function() { return this.perPage; },
            offset: function() { return this.currentPage * this.perPage },
            key: function(){ return this.key; },
            leadId:function(){
                return this.leadId;
            },
            grid:function(){return this.grid;},
            customTabId:function(){return this.customTabId;}
        },
        parse: function(response, xhr){
            if (this.server_api.count){
                this.totalRecords = response.totalRecords;
            } else {
                this.totalRecords = response.length;
            }

            this.totalPages = Math.floor(this.totalRecords / this.perPage);
            return this.server_api.count ? response.data : response;
        }

    });

    return LeadCustomParamsCollection;
});