define([
    'backbone',
    'i18n!../../../nls/config_'+$('#lead-crm-imap-config-system-language').val()+'_ln.js'
], function(Backbone, i18n){
    var LeadImapFormView = Backbone.View.extend({
        el: $('#lead-crm-imap-config-form'),
        events: {
            'submit': 'submit',
            'click #lead-crm-imap-form-cancel': 'cancelEdit'
        },
        templates: {

        },
        initialize: function(){
            this.$el = $('#lead-crm-imap-config-form');
            this.$el.attr('action', $('#website_url').val()+'api/leads/leadimap');
        },
        render: function(){
            return this;
        },
        submit: function(e){

            e.preventDefault();

            var self = this,
                form = $(e.currentTarget),
                isValid = true,
                isUpdate = form.find('#update-imap-config').val(),
                type = 'POST';

            _.each(form.find('.required'), function(el){
                if (!$(el).val()){
                    isValid = false;
                }

                if (isUpdate === 'yes' && $(el).attr('name') === 'password') {
                    isValid = true;
                }
            });

            if (!isValid){
                showMessage(_.isUndefined(i18n['Missing required field'])?'Missing required field':i18n['Missing required field'], true);
                return false;
            }

            if (isUpdate === 'yes') {
                type = 'PUT';
                var processAllEmails = 0;

                if (form.find('#process-all-emails').is(':checked')) {
                    processAllEmails = 1;
                }

                var formParams = JSON.stringify({'stage_name': $('#lead-stage-name').val(),
                    'secureToken':form.find('input[name=secureToken]').val(),
                    'id': form.find('#update-imap-config-id').val(),
                    'service_name':form.find('.service_name').val(),
                    'owner_id' : form.find('.owner_id').val(),
                    'host' : form.find('.host').val(),
                    'login' : form.find('.login').val(),
                    'encryption' : form.find('.encryption').val(),
                    'password' : form.find('.password').val(),
                    'process_all_emails' : processAllEmails
                });
            } else {
                var formParams = form.serialize();
            }

            $.ajax({
                url: form.attr('action'),
                type: type,
                data: formParams,
                dataType: 'json'
            }).done(function(response) {
                 self.$el.trigger('LeadImapForm:created');
                 showMessage(response.message, false, 5000);
                 form.find('input[type="text"]').val('');
                 form.find('#update-imap-config-id').val('');
                 form.find('#update-imap-config').val('no');
                 form.find('.encryption').val('none');
                 form.find('.owner_id').val('0');
                 form.find('.password').prop('placeholder', '').val('');
                 form.find('#lead-crm-imap-form-save').val(_.isUndefined(i18n['Add'])?'Add':i18n['Add']);
                 form.find('#process-all-emails').prop('checked', false);
                 form.find('#lead-crm-imap-form-cancel').addClass('hidden');
            }).fail(function(response){
                showMessage(response.responseJSON, true, 5000);
            });
            return false;

        },
        cancelEdit: function(e)
        {
            e.preventDefault();
            var currentEl = $(e.currentTarget),
                form = currentEl.closest('form');

            currentEl.addClass('hidden');
            form.find('#process-all-emails').prop('checked', false);
            form.find('#lead-crm-imap-form-save').val(_.isUndefined(i18n['Add'])?'Add':i18n['Add']);
            form.find('#update-imap-config').val('no');
            form.find('#update-imap-config-id').val('');
            form.find('input[type="text"]').val('');
            form.find('.owner_id').val(0);
            form.find('.encryption').val('none');
            form.find('.password').prop('placeholder', '').val('');
        }
    });

    return LeadImapFormView;
});
