define([
    'backbone',
    '../collections/lead-tags.js',
    'text!../templates/paginator.html',
    'text!../templates/tags-row.html',
    'i18n!../../../nls/config_'+$('#lead-tags-leads-config-system-language').val()+'_ln.js'
], function(Backbone,
            LeadsTagsCollection, PaginatorTmpl, LeadTagsRowTmpl, i18n
){

    var LeadTagsGridView = Backbone.View.extend({
        el: $('#lead-tags-grid-table'),
        events: {
            'click a[data-role=delete]': 'deleteLeadTag',
            'blur .lead-tag-edit-attribute'  : 'editLeadTag',
            'click td.lead-tags-grid-paginator a.page': 'navigate'
        },
        templates: {
            paginator: _.template(PaginatorTmpl)
        },
        initialize: function(options){
            this.leadTags = new LeadsTagsCollection();
            this.$el =  $('#lead-tags-grid-table');
            this.leadTags.on('reset', this.renderLeadTags, this);
            this.leadTags.on('add', this.renderLeadTags, this);
            this.leadTags.on('destroy', this.renderLeadTags, this);
        },
        render: function(){
            this.leadTags.pager();
        },
        renderLeadTags: function(){
            this.$el.find('tbody').empty();
            this.leadTags.each(this.renderLeadTag, this);
            this.leadTags.info()['i18n'] = i18n;
            if((this.leadTags.length == 0) && (this.leadTags.currentPage != 0)){
                this.leadTags.requestPreviousPage();
            }
            this.$('td.lead-tags-grid-paginator').html(this.templates.paginator(this.leadTags.information));
        },
        renderLeadTag: function(leadsTagsData){
            this.$el.find('tbody').append(_.template(LeadTagsRowTmpl, {'leadsTagsData': leadsTagsData}));
            return false;
        },
        deleteLeadTag: function(e){
            var self = this,
                cid = $(e.currentTarget).data('cid'),
                model = this.leadTags.get(cid);

            showConfirm(_.isUndefined(i18n['Are you sure want to delete'])?'Are you sure want to delete':i18n['Are you sure want to delete'], function(){
                if (model){
                    model.destroy();
                    self.render();
                }
            });
        },
        editLeadTag: function(e)
        {
            var el = $(e.currentTarget),
                currentValue = el.val(),
                oldValue = el.data('old-value'),
                leadTagId = el.closest('tr').data('lead-tag-id'),
                leadTagModel = this.leadTags.get(leadTagId),
                attrName =  el.data('attrName');

            if (currentValue != oldValue) {
                el.data('old-value', currentValue);
                leadTagModel.set(attrName, currentValue);
                leadTagModel.set('secureToken', $('#lead-tags-secure-token').val());
                leadTagModel.save(null, {
                    success: function(model, response){
                        showMessage(response.responseText, false, 5000);
                    },
                    error: function(model, response){
                        showMessage(response.responseJSON, true, 5000);
                    }
                });

            }

        },
        navigate: function(e){
            e.preventDefault();

            var page = $(e.currentTarget).data('page');
            if ($.isNumeric(page)){
                this.leadTags.goTo(page);
            } else {
                switch(page){
                    case 'first':
                        this.leadTags.goTo(this.leadTags.firstPage);
                        break;
                    case 'last':
                        this.leadTags.goTo(this.leadTags.information.lastPage);
                        break;
                    case 'prev':
                        this.leadTags.requestPreviousPage();
                        break;
                    case 'next':
                        this.leadTags.requestNextPage();
                        break;
                }
            }
        }
    });

    return LeadTagsGridView;
});