import {mapGetters} from 'vuex';
import lodash from 'lodash';
import localeMapping from '../../../localizationLanguages';
import pagination from '../../pagination';
import closetask from '../../closetask';
export default {
    data () {
        return {
            loadedScreen: false,
            queryType: 'tasks',
            subType: 'all',
            websiteUrl: $('#website_url').val(),
            hideTaskDialog: true,
            taskNotifyEmail:'',
            taskTitle:'',
            taskDialogId:0,
            checkedTasks:{},
            checkedTasksItems:{},
            taskComment:''
        }
    },
    components: {
        pagination: pagination,
        closetask:closetask
    },
    computed: {
        ...mapGetters({
            formatDate: 'formatDate',
            formatOnlyDate: 'formatOnlyDate',
            formatTimeOnly: 'formatTimeOnly',
            configDataInfo:'getConfigDataInfo',
            additionalInfo:'getAdditionalInfo',
            sortByColumn: 'sortByColumn',
            truncateText: 'truncateText',
            selectedUserId: 'getSelectedUserId',
            leadMeetingsNotesData: 'getLeadMeetingsNotesData',
            checkedTasksItemsData: 'getCheckedTasksItemsData',
            activeTaskMassAction:'getActiveTaskMassAction',
            isMassActionTaskActive:'getIsMassActionTaskActive',
            formatTimeFull:'formatTimeFull',
            cleanText: 'cleanText',
            changedTaskMeetingNotesGrid:'getChangedTaskMeetingNotesGrid'
        })
    },
    watch: {
        selectedUserId (newUserId, oldUseId) {
            console.log(`Old user id ${oldUseId} - new user id ${newUserId}`);
            if (newUserId !== oldUseId) {
                this.$store.commit('setPaginationData',
                    {
                        leadTasksMeetingsNotes: {
                            currentPage: 1,
                            itemsPerPage: 10,
                            totalItems: 0,
                            visiblePages: 4
                        }
                    }
                );

                this.applyFilter();
            }
        },
        activeTaskMassAction  (newData, originalData) {
            if (newData == '0') {
                this.$store.commit('setIsMassActionTaskActive', false);
            } else {
                this.$store.commit('setIsMassActionTaskActive', true);
            }
        },
        changedTaskMeetingNotesGrid (newData, oldData){
            if (newData !== oldData) {
                this.resetSubFilter();
            }
        }
    },
    methods: {
        filterByType(queryType) {
            this.queryType = queryType;
            this.subType = 'all';
            this.$store.commit('setPaginationData',
                {
                    leadTasksMeetingsNotes: {
                        currentPage: 1,
                        itemsPerPage: 10,
                        totalItems: 0,
                        visiblePages: 4
                    }
                }
            );
            this.applyFilter();
        },
        applySubFilter(querySubType) {
            if (querySubType !== this.subType) {
                this.$store.commit('setPaginationData',
                    {
                        leadTasksMeetingsNotes: {
                            currentPage: 1,
                            itemsPerPage: 10,
                            totalItems: 0,
                            visiblePages: 4
                        }
                    }
                );
            }
            this.subType = querySubType;
            this.applyFilter();
        },
        resetSubFilter()
        {
            this.$store.commit('setPaginationData',
                {
                    leadTasksMeetingsNotes: {
                        currentPage: 1,
                        itemsPerPage: 10,
                        totalItems: 0,
                        visiblePages: 4
                    }
                }
            );

            this.applyFilter();
        },
        markTaskCompleted(event, id, index) {
            if (event.target.checked) {
                this.hideTaskDialog = false;
                this.checkedTasks = {};
                this.checkedTasks[id] = id;
                this.taskTitle = this.leadMeetingsNotesData[index]['title'];
                this.taskDialogId = id;
                if (this.leadMeetingsNotesData[index]['userEmail'] === this.leadMeetingsNotesData[index]['creatorEmail']) {
                    this.taskNotifyEmail = this.leadMeetingsNotesData[index]['userEmail'];
                } else {
                    this.taskNotifyEmail = this.leadMeetingsNotesData[index]['userEmail'] + ',' + this.leadMeetingsNotesData[index]['creatorEmail'];
                }
            } else {
                delete this.checkedTasks[id];
                this.hideTaskDialog = true;
            }
        },
        checkedAllTaskItems(event, configData){
            var checkedTasksItems = this.checkedTasksItems;
            if (event.target.checked) {
                _.each(configData, function(taskData){
                    checkedTasksItems[taskData['taskId']] = taskData['taskId'];
                });
            } else {
                _.each(configData, function(taskData){
                    delete checkedTasksItems[taskData['taskId']];
                });
            }

            this.$store.commit('setCheckedTasksItemsData', checkedTasksItems);
            this.$store.commit('setAllCheckedTasksItemsTracking', {'items': checkedTasksItems});
            this.checkedTasksItems = checkedTasksItems;

            this.forceUpdate();
        },
        forceUpdate() {
            // ...
            this.$forceUpdate();  // Notice we have to use a $ here
            // ...
        },
        checkTaskItem(event, id, index) {
            var currentItems = this.checkedTasksItems;
            if (_.isNull(currentItems)) {
                currentItems = {};
            }

            if (event.target.checked) {
                currentItems[id] = id;
            } else {
                delete currentItems[id];
            }

            this.$store.commit('setCheckedTasksItemsData', currentItems);
            this.$store.commit('setAllCheckedTasksItemsTracking', {'items': currentItems});
            this.forceUpdate();
        },
        isAllCheckedTasks() {
            let currentCheckedItems = this.checkedTasksItemsData,
                leadMeetingsNotesData = this.leadMeetingsNotesData,
                allKeyExists = true;

            if (leadMeetingsNotesData.length  === 0) {
                allKeyExists = false;
            }

            leadMeetingsNotesData.forEach(function(leadMeetingsNotesData) {
                if (!currentCheckedItems.hasOwnProperty(leadMeetingsNotesData.taskId)) {
                    allKeyExists = false;
                }
            });

            return allKeyExists;
        },
        isCheckedTaskItem: function(itemKey){
            let currentItems = this.checkedTasksItemsData;

            if (currentItems !== null && currentItems.hasOwnProperty(itemKey)) {
                return true;
            }
            return false;
        },
        changeMassActionTasks: function(e) {
            let activeMassAction = e.target.value;
            if (activeMassAction != 0 && Object.keys(this.checkedTasksItemsData).length === 0) {
                showMessage(this.$t('message.missingTasksCheckedItems'), true, 3000);
                this.$store.commit('setActiveTaskMassAction', '0');
                e.target.value = '0';
            } else {
                this.$store.commit('setActiveTaskMassAction', activeMassAction);
            }
        },
        closeTaskDialog(id) {
            this.hideTaskDialog = true;
            delete this.checkedTasks[id];
            this.taskComment = '';
        },
        async completeTask(){
            const result = await this.$store.dispatch('completeTask', {'router':this.$router, 'taskNotifyEmails': this.taskNotifyEmail, 'taskId':this.taskDialogId, 'taskComment':this.taskComment});
            console.log(result);
            if(result.status === 'error') {
                showMessage('Please re-login', true, 3000);
            } else {
                showMessage(result.responseText.message, false, 3000);
                this.hideTaskDialog = true;
                this.taskComment = '';
                this.applyFilter();
            }
        },
        async applyFilter() {
            //clean checked items
            this.checkedTasksItems = {};
            this.$store.commit('setIsMassActionTaskActive', false);
            this.$store.commit('setActiveTaskMassAction', 0);
            this.$store.commit('setCheckedTasksItemsData', {});
            this.$store.commit('setAllCheckedTasksItemsTracking', {'items': {}});

            this.$store.commit('setFilterData',
                {
                    'queryType': this.queryType,
                    'userId':this.selectedUserId,
                    'querySubType':this.subType
            });

            const result = await this.$store.dispatch('getTasksMeetingsNotesData', {'router':this.$router, 'queryType': this.queryType, 'userId':this.selectedUserId, 'querySubType':this.subType});
            if(result.status === 'error') {
                showMessage('Please re-login', true, 3000);
            } else {
                this.loadedScreen = true;
            }
        }
    },
    async created(){
        this.$store.commit('setFilterData',
            {
                'queryType': this.queryType,
                'userId':this.selectedUserId,
                'querySubType':this.subType
        });

        const result = await this.$store.dispatch('getTasksMeetingsNotesData', {'router':this.$router, 'queryType': this.queryType, 'userId':this.selectedUserId, 'querySubType':this.subType});
        if(result.status === 'error') {
            showMessage('Please re-login', true, 3000);
        } else {
            this.loadedScreen = true;
        }

    },
    async updated() {
        this.$nextTick(function () {
            if (typeof checkboxRadioStyle !== 'undefined' && typeof checkboxRadioStyle() === "function") {
                checkboxRadioStyle();
            }
        })
    }
}
