import {mapGetters} from 'vuex';
import lodash from 'lodash';
import localeMapping from '../../../localizationLanguages';
import pagination from '../../pagination';
import { isProxy, toRaw } from 'vue';
import moment from "moment";
import { Loader } from '@googlemaps/js-api-loader';
export default {
    props: ['leadId'],
    data () {
        return {
            loadedScreen: true,
            locale: $('#dashboard-system-language').val(),
            localeMapping: localeMapping,
            websiteUrl: $('#website_url').val(),
            loadedProfileScreen: false,
            ipAddressesData: [],
            newIpAddress: '',
            processingNewIpAddress: false,
            profileErrorMessage: '',
            lastVisitInfo: {},
            profileStats: {},
            pageLoadAverage: {},
            googleApiKey: '',
            googleMapId: '',
            citiesInfo: {},
            countryCodes: {},
            currentDate: '',
            visitLocations: {},
            infoWindowsData: [],
            mapBounds:[],
            mapMarkers:[],
            advancedMarkerElement:{},
            map:'',
            Map:{},
            visitDetailsData:[],
            activeVisitLine:'',
            visitRowKey:0
        }
    },
    components: {
        pagination: pagination
    },
    computed: {
        ...mapGetters({
            formatDate: 'formatDate',
            formatOnlyDate: 'formatOnlyDate',
            formatTimeOnly: 'formatTimeOnly',
            formatTimeOnlyWithPartOfTheDay: 'formatTimeOnlyWithPartOfTheDay',
            configDataInfo:'getAdditionalInfoDetailedScreen',
            sortByColumn: 'sortByColumn',
            truncateText: 'truncateText',
            toCurrency:'toCurrency',
            unescapeValue:'unescapeValue',
            additionalInfo:'getAdditionalInfoProfileLog',
            profileLogData: 'getProfileLogData',
            leadData:'getDetailedScreenLeadData',
            generalAdditionalInfo:'getAdditionalInfoDetailedScreen',
            profileTableOffset: 'getProfileTableOffset'
        })
    },
    methods: {
        async loadData() {
            const result = await this.$store.dispatch('getProfileTabData',
                {
                    'router':this.$router,
                    'leadId':this.leadId,
                    'spinnerId':'#lead-detailed-view-statistics-tab-profile'
                });

            if (result.error === 1) {
                showMessage(result.message, true, 3000);
            } else {
                this.ipAddressesData = result.ipAddressesData;
                this.lastVisitInfo = result.lastVisitInfo;
                this.profileStats = result.stats;
                this.pageLoadAverage = result.pageLoadAverage;
                this.countryCodes = result.countryCodes;
                this.currentDate = result.currentDate;
                this.googleApiKey = result.googleApiKey;
                this.googleMapId = result.googleMapId;
                this.loadedProfileScreen = true;
                if (this.googleApiKey) {
                    await this.initMap();
                }
            }
        },
        async initMap()
        {
            const loader = new Loader({
                apiKey: this.googleApiKey,
                version: "quarterly"
            });

            let self = this;

            loader
                .importLibrary('maps')
                .then(({Map}) => {
                    let myOptions = self.initOptionsMap();
                    if (self.googleMapId) {
                        myOptions.mapId = self.googleMapId;
                    }
                    self.map = new Map(document.getElementById("full-visits-profile-map"), myOptions);

                    self.visitLocations = {};
                    self.infoWindowsData = [];
                    self.mapBounds = [];
                    self.mapMarkers = [];
                    loader
                        .importLibrary('marker')
                        .then(({AdvancedMarkerElement}) => {
                            setTimeout(async () =>  await self.getVisitLocations(self.leadId),  100);
                        })
                        .catch((e) => {
                            // do something
                        });

                })
                .catch((e) => {
                    // do something
                });
        },
        initOptionsMap()
        {
            return {
                zoom: 12,
                mapId: 'DEMO_MAP_ID',
                center: new google.maps.LatLng(48, 2),
                disableDefaultUI: true,
                zoomControl: true,
                fullscreenControl: true,
                panControl: true,
                mapTypeId: google.maps.MapTypeId.ROADMAP,
                streetViewControl: false,
            }
        },
        async getVisitLocations(leadId){
            let self = this,
                totalVisits = 0,
                citiesInfo = {},
                cityKey = '',
                zoom =  8;

            const result = await this.$store.dispatch('getLeadProfile',
                {
                    'router':this.$router,
                    'leadId':this.leadId,
                });

            if (result.error === 1) {
                showMessage(result.message, true, 3000);
                return false
            } else {
                if (result.data){
                    if (result.googleApiKey) {
                        result.data.forEach(function (marker, value) {
                            self.visitLocations[marker.id] = marker;
                            if (marker.latitude !== null || marker.longitude !== null) {
                                self.addMarkers(marker, result.countryCodes);
                                totalVisits += parseInt(marker.locationsQuantity);
                            }
                            if (marker.countryCode !== null && marker.city !== null) {
                                cityKey = marker.countryCode + '_' + marker.city;
                                if (typeof citiesInfo[cityKey] !== 'undefined') {
                                    citiesInfo[cityKey] = {
                                        'quantity': citiesInfo[cityKey].quantity + marker.locationsQuantity,
                                        'city': marker.city,
                                        'countryCode': marker.countryCode
                                    };
                                } else {
                                    citiesInfo[cityKey] = {
                                        'quantity': marker.locationsQuantity,
                                        'city': marker.city,
                                        'countryCode': marker.countryCode
                                    };
                                }
                            }
                        });

                        let latLngBounds = new google.maps.LatLngBounds();
                        self.mapBounds.forEach(function (marker) {
                            latLngBounds.extend(marker);
                        });
                        google.maps.event.trigger(self.map, 'resize');
                        self.map.setCenter(latLngBounds.getCenter(), self.map.fitBounds(latLngBounds));

                        if (self.mapBounds.length == 1){
                            if (result.googleMapDefaultZoom) {
                                zoom = parseInt(result.googleMapDefaultZoom);
                            }
                            self.map.setZoom(zoom);
                        }
                    }

                    this.citiesInfo = citiesInfo;
                }
            }
        },
        async addMarkers(marker, countryCodes){

            let latLng = new google.maps.LatLng(parseFloat(marker.latitude), parseFloat(marker.longitude)),
                referrerName = '';

            if (marker.referrerName !== null) {
                referrerName = marker.referrerName.replace(/(^,)|(,$)/g, "");
            }

            let markerTextElFirstLine = document.createElement('p'),
                newContent = document.createTextNode(marker.city + ' / '+ countryCodes[marker.countryCode.toUpperCase()]),
                markerTextElSecondLine = document.createElement('p'),
                newContentSecondLine = document.createTextNode(this.$t('message.profileTabFrom') + ': '+ referrerName),
                markerTextElThirdLine = document.createElement('p'),
                newContentThirdLine = document.createTextNode(this.$t('message.profileTabLastVisit') + ': '+ this.formatDate(marker.firstActionTimestamp)),
                markerTextElFourthLine = document.createElement('p'),
                newContentFourthLine = document.createTextNode(marker.visitConverted + ' '+this.$t('message.profileTabGoalConversion')),
                markerTextElFifthLine = document.createElement('p'),
                newContentFifthLine = document.createTextNode(marker.visitCount + ' '+this.$t('message.profileTabPageviews'));

            markerTextElFirstLine.appendChild(newContent);
            markerTextElSecondLine.appendChild(newContentSecondLine);
            markerTextElThirdLine.appendChild(newContentThirdLine);
            markerTextElFourthLine.appendChild(newContentFourthLine);
            markerTextElFifthLine.appendChild(newContentFifthLine);

            let infoWindow = new google.maps.InfoWindow({
                content: markerTextElFirstLine.innerHTML +'<br/><br/>' +markerTextElSecondLine.innerHTML+'<br/><br/>'
                    +markerTextElThirdLine.innerHTML+'<br/><br/>'
                    +markerTextElFourthLine.innerHTML+'<br/><br/>'
                    +markerTextElFifthLine.innerHTML+'<br/><br/>'
            });

            google.maps.event.addListener(this.map, 'click', function() {
                infoWindow.close();
            });

            //infoWindows data
            this.infoWindowsData.push(infoWindow);

            let newMarker = new google.maps.marker.AdvancedMarkerElement(
                {
                    map: toRaw(this.map),
                    title: marker.name,
                    position: latLng
                });

            google.maps.event.addListener(newMarker, 'click', function() {
                infoWindow.setContent(infoWindow['content']);
                infoWindow.open(this.map, this);
            });

            google.maps.event.addListener(infoWindow,'open',function(){
                infoWindow.close();
            });

            this.mapBounds.push(latLng);
        },
        async assignIpAddress()
        {
            if (this.processingNewIpAddress === true) {
                return false;
            }

            this.processingNewIpAddress = true;

            const result = await this.$store.dispatch('addIpAddress',
                {
                    'router':this.$router,
                    'leadId':this.leadId,
                    'ipAddress':this.newIpAddress,
                });

            if (result.error === 1) {
                showMessage(result.message, true, 3000);
                this.processingNewIpAddress = false;
                return false
            } else {
                this.ipAddressesData.push({'lead_ip_address':this.newIpAddress, 'lead_id':this.leadId});
                this.processingNewIpAddress = false;
                this.newIpAddress = '';
                showMessage(result.responseText, false, 5000);
            }
        },
        async deleteIPAddress(ipAddress)
        {
            let self = this;

            showConfirm(this.$t('message.profileTabAreYouSureWantToDelete'), async () => {
                const result = await this.$store.dispatch('deleteIpAddress',
                    {
                        'router':this.$router,
                        'leadId':this.leadId,
                        'ipAddress':ipAddress
                    });

                if (result.error === 1) {
                    showMessage(result.message, true, 3000);
                } else {
                    let ipAddressList = this.ipAddressesData.filter(function(item) {
                        return item.lead_ip_address != ipAddress;
                    });

                    this.ipAddressesData = ipAddressList;
                    showMessage(result.responseText, false, 5000);
                }
            }, async () => {

            });
        },
        getIpAddressesLine()
        {
            let ipAddressesData = this.profileStats.ipAddresses.split(','),
                ipAddressLine = '';

            ipAddressesData.forEach(function(ipAddress, index){
                if (ipAddressesData.length -1 > index)
                {
                    ipAddressLine += ipAddress +', ';
                } else {
                    ipAddressLine += ipAddress;
                }
            });

            return ipAddressLine;
        },
        getResolutionsLine()
        {
            let resolutionsData = this.profileStats.resolutions.split(','),
                resolutionLine = '';

            resolutionsData.forEach(function(resolution, index){
                if (resolutionsData.length -1 > index)
                {
                    resolutionLine += resolution +', ';
                } else {
                    resolutionLine += resolution;
                }
            });

            return resolutionLine;
        },
        getFormattedDate(data)
        {
            let formattedDate ='';


            let ms = this.profileStats.totalSpentTime * 1000,
                date = moment.utc(ms),
                dateMinutes = date.minutes(),
                dateSeconds = date.seconds(),
                dateHours = date.hours();

            if (dateHours != '00') {
                formattedDate += dateHours + ' hours ';
            }
            if (dateMinutes != '00') {
                formattedDate += dateMinutes + ' min ';
            }
            if (dateSeconds != '00') {
                formattedDate += dateSeconds + ' sec';
            }

            return formattedDate;
        },
        getFormattedVisitDurationDate(profileItem)
        {
            let formattedDate ='';


            let ms = profileItem.visitDuration * 1000,
                date = moment.utc(ms),
                dateMinutes = date.minutes(),
                dateSeconds = date.seconds(),
                dateHours = date.hours();

            if (dateHours != '00') {
                formattedDate += dateHours + ' hours ';
            }
            if (dateMinutes != '00') {
                formattedDate += dateMinutes + ' min ';
            }
            if (dateSeconds != '00') {
                formattedDate += dateSeconds + ' sec';
            }

            return formattedDate;
        },
        getFirstVisitDate()
        {
            let firstVisitDate = moment(this.profileStats['firstVisitDate'], 'YYYY-MM-DD HH:mm:ss').format('DD-MMM-YYYY');

            if (firstVisitDate !== 'Invalid date') {
                return firstVisitDate;
            }

            return '';
        },
        getVisitDays()
        {
            let firstDateToCompare = moment(this.profileStats['firstVisitDate'], 'YYYY-MM-DD hh:mm:ss'),
                currentDateToCompare = moment(this.currentDate, 'YYYY-MM-DD hh:mm:ss'),
                days = currentDateToCompare.diff(firstDateToCompare, 'days');

            return days;
        },
        getLastVisitDate()
        {
            let lastVisitDate = moment(this.profileStats['lastVisitDate'], 'YYYY-MM-DD HH:mm:ss').format('DD-MMM-YYYY');

            if (lastVisitDate !== 'Invalid date') {
                return lastVisitDate;
            }

            return '';
        },
        getVisitDaysLast()
        {
            let firstDateToCompare = moment(this.profileStats['lastVisitDate'], 'YYYY-MM-DD hh:mm:ss'),
                currentDateToCompare = moment(this.currentDate, 'YYYY-MM-DD hh:mm:ss'),
                days = currentDateToCompare.diff(firstDateToCompare, 'days');

            return days;
        },
        async getVisitDetails(userProfileLogId)
        {
            if (parseInt(this.activeVisitLine) === parseInt(userProfileLogId)) {
                this.activeVisitLine = 0;
                return false;
            }

            const result = await this.$store.dispatch('getLeadProfileVisit',
                {
                    'router':this.$router,
                    'userProfileLogId':userProfileLogId
                });

            if (result.error === 1) {
                showMessage(result.message, true, 3000);
            } else {
                this.activeVisitLine = parseInt(userProfileLogId);
                this.visitDetailsData = result.data;
                this.visitRowKey = this.visitRowKey + 1;
            }
        }
    },
    async created(){
        if (typeof this.localeMapping[this.locale] !== 'undefined') {
            this.$i18n.locale = this.localeMapping[this.locale];
        }

        this.$store.commit('setPaginationData', {
            profileLog: {
                currentPage: 1,
                itemsPerPage: 10,
                totalItems: 0,
                visiblePages: 4
            }
        });

        this.loadData();
    },
    async updated() {
        this.$nextTick(function () {
            if (typeof checkboxRadioStyle !== 'undefined' && typeof checkboxRadioStyle() === "function") {
                checkboxRadioStyle();
            }
        })
    }
}
