import {mapGetters} from 'vuex';
import lodash from 'lodash';
import localeMapping from '../../../localizationLanguages';
import pagination from '../../pagination';
import moment from 'moment';
import { isProxy, toRaw } from 'vue';

export default {
    data () {
        return {
            loadedScreen: false,
            websiteUrl: $('#website_url').val(),
            localeMapping: localeMapping,
            locale: $('#dashboard-system-language').val(),
            leadsData:[],
            itemsQuantity:0,
            leadIdMergeTo:0,
            mergeProcessingFlag:false,
        }
    },
    components: {

    },
    computed: {
        ...mapGetters({
            configDataInfo:'getConfigDataInfo',
            additionalInfo:'getAdditionalInfo',
            truncateText: 'truncateText',
            unescapeValue:'unescapeValue',
            checkedItemsData:'getCheckedItems',
            totalFoundItems:'getTotalItemsFound',
            filterData:'getFilterData',
            ucFirstAllText:'ucFirstAllText',
        })
    },
    watch: {

    },
    methods: {
        closeMassAction() {
            this.$store.commit('setActiveMassAction', 0);
        },
        async submitRegularForm()
        {
            if(this.leadIdMergeTo == 0) {
                showMessage(this.$t('message.pleaseSpecifyTheLeadToBeMergedTo'), true, 5000);
                return false;
            }

            this.mergeProcessingFlag = true;
            showSpinner('#merge-leads-form', 'merge-leads-stats-spinner dashboard-spinner');

            const result = await this.$store.dispatch('mergeLeadsMassAction', {
                'router': this.$router,
                'leadIds': Object.keys(this.checkedItemsData).join(','),
                'leadMergeToId': this.leadIdMergeTo,
            });

            hideSpinner('.merge-leads-stats-spinner');

            if(result.error != 1) {
                showMessage(result.responseText, false, 3000);
                this.closeMassAction();
                window.location = $('#website_url').val() + 'dashboard/leads/#lead/' + this.leadIdMergeTo
            } else {
                this.mergeProcessingFlag = false;
                showMessage(result.responseText, true, 5000);
            }
        },
        async getLeadsData()
        {
            const result = await this.$store.dispatch('getLeadsDataMassAction', {
                'router': this.$router,
                'checkedLeads': Object.keys(this.checkedItemsData).join(','),
            });

            if (result.error === 1) {
                showMessage(this.$t('message.leadsHaveNotFound'), true, 5000);
                this.closeMassAction();
                return false;
            } else {
                this.leadsData = result.responseText;
                this.itemsQuantity = parseInt(Object.keys(this.checkedItemsData).length);
            }
        },
        async getInitialData()
        {
            let countSelectedLeads = parseInt(Object.keys(this.checkedItemsData).length);

            if (countSelectedLeads === 0) {
                showMessage(this.$t('message.pleaseChooseAtLeastOneLead'), true, 3000);
                this.closeMassAction();
            }

            if (countSelectedLeads < 2) {
                showMessage(this.$t('message.pleaseChooseAtLeast2Leads'), true, 5000);
                this.closeMassAction();
                return false;
            }

            if (countSelectedLeads > 3) {
                showMessage(this.$t('message.youCanMergeNotMoreThan3LeadsAtOnce'), true, 5000);
                this.closeMassAction();
                return false;
            }

            await this.getLeadsData();

            if (this.itemsQuantity > 0) {
                this.loadedScreen = true;
            }
        },
    },
    async created(){
        if (typeof this.localeMapping[this.locale] !== 'undefined') {
            this.$i18n.locale = this.localeMapping[this.locale];
        }

        this.getInitialData();
    },
    async updated() {
        this.$nextTick(function () {
            if (typeof checkboxRadioStyle !== 'undefined' && typeof checkboxRadioStyle() === "function") {
                checkboxRadioStyle();
            }
        })
    }
}
