export const getConfigSavedData = ({commit, state, dispatch}, payload) => {
    showLoader();
    return new Promise((resolve, reject) => {
        $.ajax({
            'url': $('#website_url').val()+'api/leads/leadgoal/',
            'type': 'GET',
            'dataType': 'json',
            'data': {
                'id': payload.id
            }
        }).done(async  function(response){
            hideLoader();
            if (response.status !== 'error') {
                commit('setConfigDataInfo', response.data);
                commit('setAdditionalInfo', response.additionalInfo);
                commit('setGlobalStats', response.globalStats);
                resolve(response);
            } else {
                resolve({ name: 'login', 'message': 'Please re-login'});
            }
        }).fail(async function(response){
            resolve({ name: 'login', 'message': 'Please re-login'});
        });
    });
};


export const deleteOwner = ({commit, state, dispatch}, payload) => {
    showLoader();
    return new Promise((resolve, reject) => {
        $.ajax({
            'url': $('#website_url').val()+'api/leads/leadgoal/id/'+payload.id,
            'type': 'DELETE',
            'dataType': 'json'
        }).done(async  function(response){
            hideLoader();
            if (response.status !== 'error') {
                resolve(response);
            } else {
                resolve({ name: 'login', 'message': 'Please re-login'});
            }
        }).fail(async function(response){
            resolve({ name: 'login', 'message': 'Please re-login'});
        });
    });
};

export const addLeadOwner = ({commit, state, dispatch}, payload) => {
    showLoader();
    return new Promise((resolve, reject) => {
        $.ajax({
            'url': $('#website_url').val()+'api/leads/leadgoal/',
            'type': 'POST',
            'dataType': 'json',
            'data': {
                'userId': payload.user_id,
                'secureToken' : $('#goal-config-token').val()
            }
        }).done(async  function(response){
            hideLoader();
            if (response.status !== 'error') {
                resolve(response);
            } else {
                resolve({ name: 'login', 'message': 'Please re-login'});
            }
        }).fail(async function(response){
            resolve({ name: 'login', 'message': 'Please re-login'});
        });
    });
};

export const getConfigDetailedData = ({commit, state, dispatch}, payload) => {
    showLoader();
    return new Promise((resolve, reject) => {
        $.ajax({
            'url': $('#website_url').val()+'api/leads/leadgoal/',
            'type': 'GET',
            'dataType': 'json',
            'data': {
                'id': payload.id,
                'leadGoalDetailed': payload.leadGoalDetailed
            }
        }).done(async  function(response){
            hideLoader();
            if (response.status !== 'error') {
                commit('setOppGoalStats', response.goalOppStats);
                commit('setGlobalStats', response.globalStats);
                resolve(response);
            } else {
                resolve({ name: 'login', 'message': 'Please re-login'});
            }
        }).fail(async function(response){
            resolve({ name: 'login', 'message': 'Please re-login'});
        });
    });
};

export const updateConfigData = ({commit, state, dispatch}, payload) => {
    showLoader();
    return new Promise((resolve, reject) => {
        $.ajax({
            'url': $('#website_url').val()+'api/leads/leadgoal/',
            'type': 'PUT',
            'dataType': 'json',
            'data': JSON.stringify({
                'id': payload.id,
                'secureToken' : $('#goal-config-token').val(),
                'quotes_amount':payload.quotes_amount,
                'meetings_held':payload.meetings_held,
                'emails_sent':payload.emails_sent,
                'calls_placed':payload.calls_placed,
                'quote_objective':payload.quote_objective
            })
        }).done(async  function(response){
            hideLoader();
            if (response.status !== 'error') {
                resolve(response);
            } else {
                resolve({ name: 'login', 'message': 'Please re-login'});
            }
        }).fail(async function(response){
            resolve({ name: 'login', 'message': 'Please re-login'});
        });
    });
};

export const getOppDataInfo = ({commit, state, dispatch}, payload) => {
    showLoader();
    return new Promise((resolve, reject) => {
        $.ajax({
            'url': $('#website_url').val()+'api/leads/leadgoalopportunities/',
            'type': 'GET',
            'dataType': 'json',
            'data': {
                'goalId': payload.goalId,
                'opportunityId': payload.opportunityId
            }
        }).done(async  function(response){
            hideLoader();
            if (response.status !== 'error') {
                commit('setOppGoalStats', response.goalOppStats);
                commit('setGlobalStats', response.globalStats);
                resolve(response);
            } else {
                resolve({ name: 'login', 'message': 'Please re-login'});
            }
        }).fail(async function(response){
            resolve({ name: 'login', 'message': 'Please re-login'});
        });
    });
};

export const saveOppDataInfo = ({commit, state, dispatch}, payload) => {
    showLoader();
    return new Promise((resolve, reject) => {
        $.ajax({
            'url': $('#website_url').val()+'api/leads/leadgoalopportunities/',
            'type': 'POST',
            'dataType': 'json',
            'data': {
                'goalId': payload.goalId,
                'opportunityId': payload.opportunityId,
                'secureToken' : $('#goal-config-token').val(),
                'oppAmount': payload.oppAmount,
                'oppCount': payload.oppCount,
            }
        }).done(async  function(response){
            hideLoader();
            if (response.status !== 'error') {
                resolve(response);
            } else {
                resolve({ name: 'login', 'message': 'Please re-login'});
            }
        }).fail(async function(response){
            resolve({ name: 'login', 'message': 'Please re-login'});
        });
    });
};

export const saveFiscalYearStart = ({commit, state, dispatch}, payload) => {
    showLoader();
    return new Promise((resolve, reject) => {
        $.ajax({
            'url': $('#website_url').val()+'plugin/leads/run/saveFiscalYearStart/',
            'type': 'POST',
            'dataType': 'json',
            'data': {
                'fiscalYearStartMonth': payload.fiscalYearStartMonth
            }
        }).done(async  function(response){
            hideLoader();
            resolve(response);
        }).fail(async function(response){
            hideLoader();
            resolve({ name: 'login', 'message': 'Please re-login'});
        });
    });
};
