export const importProcedure = ({commit, state, dispatch}, payload) => {
    showLoader();
    return new Promise((resolve, reject) => {
        $.ajax({
            url: $('#website_url').val() + 'plugin/leads/run/importLeads/',
            type: 'POST',
            dataType: 'json',
            data: {
                'secureToken': $('#import-contacts-data-config-token').val(),
                'importType': 'lead',
                'isImportContactsData': true
            }
        }).done(async function (response) {
            hideLoader();
            if (response.error == 0) {
                commit('addImportedLeadsQuantity', response.responseText.importedQuantity);
                resolve(response);
            } else {
                if (response.responseText.generalError) {
                    commit('setErrorLink', {isErrorLink: 1, errorLink: response.responseText.messageLink});
                } else {
                    commit('setImportLeadsError', {isError: 1, message: response.responseText.message});
                }
                if (response.responseText.importedQuantity) {
                    commit('addImportedLeadsQuantity', response.responseText.importedQuantity);
                }
                resolve({'error': '1', 'message': ''});
            }
        }).fail(async function (response) {
            hideLoader();
            commit('setImportLeadsError', {isError: 1, message: 'Something went wrong.'});
            resolve({'error': '1', 'message': 'Something went wrong.'});
        });
    });
};