define([
    'backbone',
    'moment',
    './email-trigger-form',
    './email-trigger-grid',
    './email-sequence-form',
    './email-sequence-triggers',
    'i18n!../../../nls/dashboard_'+$('#email-sequence-dashboard-system-language').val()+'_ln'
], function(Backbone, moment, EmailTriggerFormView, EmailTriggerGridView, EmailSequenceFormView,
            EmailSequenceTriggersView, i18n
){

    var MainView = Backbone.View.extend({
        el: $('#email-trigger-main-block'),
        events: {
            'click #lead-email-sequence-tabs li' : 'showTabs',
            'change input#switch-user-subscribe' : 'switchAnalyzeSubscribedUsers',
            'click .trigger-type-switcher': 'switchTriggerType',
            'change #switch-send-mms': 'switchSendMms',
        },
        templates: {},
        initialize: function(options){

        },
        render: function(){
            $('.tooltip').tooltip();

        },
        showTabs: function(e)
        {
            var el = $(e.currentTarget),
                tabBlockContentId = el.data('tab-id'),
                tabContentName = el.data('tab-name'),
                tabBlockContentEl = $('#'+tabBlockContentId),
                self = this,
                tabContentBlock = el.closest('#email-trigger-main-block').find('.lead-form-block-tabs-content');

            if (el.hasClass('current')) {
                return false;
            }

            //$('#email-trigger-block-section').empty();
            //$('#email-sequence-settings-section').empty();

            console.log(tabBlockContentId);
            if (tabBlockContentEl.hasClass('hidden')) {
                if (tabContentName === 'lead-email-trigger-block') {
                    if(!_.isUndefined(this.emailTriggerForm)) {
                        this.emailTriggerForm.$el.unbind();
                    }
                    if(!_.isUndefined(this.emailTriggerGrid)) {
                        this.emailTriggerGrid.$el.unbind();
                    }
                    this.emailTriggerForm = new EmailTriggerFormView();
                    this.emailTriggerGrid = new EmailTriggerGridView();
                    self.assign({
                        '#email-triggers-form': this.emailTriggerForm,
                        '#email-trigger-grid-block' : this.emailTriggerGrid
                    });

                    this.emailTriggerForm.$el.on('EmailTriggerForm:created', _.bind(this.emailTriggerGrid.render, this.emailTriggerGrid));
                    self.hideTab(tabBlockContentEl, el);
                }

                if (tabContentName === 'lead-emailsequence-block') {
                    if(!_.isUndefined(this.emailSequenceForm)) {
                        this.emailSequenceForm.$el.unbind();
                    }
                    if(!_.isUndefined(this.emailSequenceGrid)) {
                        this.emailSequenceGrid.$el.unbind();
                    }
                    this.emailSequenceForm = new EmailSequenceFormView();
                    this.emailSequenceGrid = new EmailSequenceTriggersView();
                    self.assign({
                        '#email-sequence-form-block': this.emailSequenceForm,
                        '#email-sequence-triggers-block' : this.emailSequenceGrid
                    });

                    this.emailSequenceForm.$el.on('EmailSequenceForm:created', _.bind(this.emailSequenceGrid.render, this.emailSequenceGrid));
                    self.hideTab(tabBlockContentEl, el);
                }
            }

            tabContentBlock.addClass('hidden');
            $('#lead-email-sequence-tabs').find('li').removeClass('current');
            this.hideTab(tabBlockContentEl, el);
        },
        hideTab: function (tabBlockContentEl, el){
            tabBlockContentEl.removeClass('hidden');
            el.closest('li').addClass('current');
        },
        assign: function (selector, view) {
            var selectors;
            if (_.isObject(selector)) {
                selectors = selector;
            }
            else {
                selectors = {};
                selectors[selector] = view;
            }
            if (!selectors) return;
            _.each(selectors, function (view, selector) {
                view.setElement(this.$(selector)).render();
            }, this);
        },
        switchAnalyzeSubscribedUsers: function(e)
        {
            e.preventDefault();
            var self = this,
                analyzeSubscribe = 0;

            if ($(e.currentTarget).is(':checked')) {
                analyzeSubscribe = 1;
            }

            $.ajax({
                'url' : $('#website_url').val()+'/plugin/emailsequence/run/switchAnalyzeSubscribedUsers/',
                'type': 'POST',
                'data': {
                    'secureToken':$('#email-sequence-grid-token').val(),
                    'analyzeSubscribe': analyzeSubscribe
                },
                'dataType' : 'json'
            }).done(function(response){

            });

        },
        switchTriggerType: function(e)
        {
            e.preventDefault();
            var el = $(e.currentTarget),
                type = el.data('filter-log-type');

            $('.trigger-type-switcher').removeClass('current');
            $('#trigger-tab-type').val(type);
            el.addClass('current');

            if(type == 'email') {
                var sendEmailSmsLabel = _.isUndefined(i18n['Send email'])?'Send email':i18n['Send email'];
                $('#trigger-form-sms').hide();
                $('#trigger-form-email').show();
                $('.mms-switcher-block').hide();
                $('#switch-send-mms').prop('checked', false);
                $('.mms-images-block').addClass('hide').hide();
                $('.message-content-block').removeClass('grid_4').addClass('grid_6');
            } else {
                var sendEmailSmsLabel = _.isUndefined(i18n['Send sms'])?'Send sms':i18n['Send sms'];
                $('#trigger-form-email').hide();
                $('#trigger-form-sms').show();
                $('#trigger-form-sms').find('.mce-widget.mce-last').last().hide();
                $('.mms-switcher-block').show();
            }
            $('.send-email-sms-label').text(sendEmailSmsLabel);
        },
        switchSendMms: function () {
            if($('.mms-images-block').hasClass('hide')) {
                $('.mms-images-block').removeClass('hide').show();
                $('.message-content-block').removeClass('grid_6').addClass('grid_4');
            } else {
                $('.mms-images-block').addClass('hide').hide();
                $('.message-content-block').removeClass('grid_4').addClass('grid_6');
            }
        },

    });

    return MainView;
});
