<?php


class Apps extends Tools_Plugins_Abstract {

    const SERVICE_TYPE_EMAIL = 'email';

    const SERVICE_TYPE_SMS = 'sms';

    const SERVICE_TYPE_CRM = 'crm';

    const SERVICE_TYPE_OPEN_AI = 'openai';

    const SECTION_APPS = 'socialposter';

    const SMS_FROM_TYPE_FORM = 'form';

    const SMS_FROM_TYPE_NEW_ORDER = 'newOrder';

    const SMS_FROM_TYPE_TRACKING_NUMBER = 'trackingNumber';

    /**
     * Status when sms sent to admin
     */
    const SMS_OWNER_TYPE_ADMIN = 'admin';

    /**
     * Status when sms sent to the end user
     */
    const SMS_OWNER_TYPE_USER = 'user';

    /**
     * secure token
     */
    const APPS_SECURE_TOKEN = 'AppsToken';

    private $_helpHashMap  = array(
        self::SECTION_APPS => 'cms-applications.html'
    );

    protected $_securedActions = array(
        Tools_Security_Acl::ROLE_SUPERADMIN => array(
            'secured'
        )
    );

    /**
     * layout
     * @var null
     */
    protected $_layout = null;

    private $_websiteConfig = '';

    private $_categoryAlias = array('email' => 'Email marketing', 'sms' => 'SMS and phone services', 'crm' => 'CRM', 'openai' => 'Open AI service setup');

    /**
     * Init method.
     *
     * Use this method to init your plugin's data and variables
     * Use this method to init specific helpers, view, etc...
     */
    protected function _init() {
        $this->_websiteConfig = Zend_Controller_Action_HelperBroker::getStaticHelper('config')->getConfig();

        $this->_layout = new Zend_Layout();
        $this->_layout->setLayoutPath(Zend_Layout::getMvcInstance()->getLayoutPath());

        if(($scriptPaths = Zend_Layout::getMvcInstance()->getView()->getScriptPaths()) !== false) {
            $this->_view->setScriptPath($scriptPaths);
        }
        $this->_view->addScriptPath(__DIR__ . '/system/views/');
    }

    public function appsConfigAction(){
        if(Tools_Security_Acl::isAllowed(Tools_Security_Acl::RESOURCE_PLUGINS)) {
            $appsSettingsMapper = Apps_Models_Mapper_AppsSettingsMapper::getInstance();
            if($this->_request->isPost()){
                $secureToken = $this->_request->getParam(Tools_System_Tools::CSRF_SECURE_TOKEN, false);
                $tokenValid = Tools_System_Tools::validateToken($secureToken, self::APPS_SECURE_TOKEN);
                if (!$tokenValid) {
                    $this->_responseHelper->fail('');
                }
                $data = $this->_request->getParams();
                $appsSettingsModel = new Apps_Models_Models_AppsSettingsModel();
                if(isset($data['service'])){
                    $status = ($data['status'] === 'enable') ? 0 : 1;
                    $appsSettingsModel->setServiceName($data['service']);
                    $appsSettingsModel->setStatus($status);
                    $appsSettingsModel->setCategory($data['category']);
                    $appsSettingsModel->setDetailedInfo($data['detailedInfo']);
                    $appsSettingsMapper->save($appsSettingsModel);
                    $this->_responseHelper->success($this->_translator->translate('Changed'));
                }
                $this->_responseHelper->fail();
            }else{
                $this->_view->localServices = $appsSettingsMapper->selectConfig();
                $categoryAndServices = Apps::apiCall('GET', 'apps', array('services'), array('withcrm' => 'withcrm', 'withSambaEmailMarketing' => 'withSambaEmailMarketing'));
                //$categoryAndServices = json_decode('{"services":{"email":{"constantContact":{"name":"Constant Contact","info":"<span class=\"serviceInfo\">Constant Contact, Inc. is an online marketing company offering email marketing, social media marketing, online survey, event marketing, digital storefronts, and local deals tools, primarily to small businesses, nonprofit organizations, and membership associations. <a class=\"readMore\" target=\"_blank\" href=\"http:\/\/www.seotoaster.com\/cms-applications.html\">Read more<\/a><\/span>","status":true,"params":{"registerLink":"<div style=\"margin-top: 10px; text-align: center;\">\n            <a href=\"http:\/\/diariovasco.localdigitalkit.com\/mail\/?id=438&w=816\" target=\"_blank\">Access your email marketing configuration here.<\/a>\n            <\/div>"}},"sambaEmailMarketing":{"name":"SEO Samba email marketing","info":"Create email campaigns","status":true, "detailedInfo": "1"}},"sms":{"cloud_communication":{"name":"SMS & Phone service","info":"<span class=\"serviceInfo\">Notify your clients wherever they are, using SMS service. <a class=\"readMore\" target=\"_blank\" href=\"http:\/\/www.seotoaster.com\/cms-applications.html\">Read more<\/a><\/span>","status":true,"params":{"registerLink":"<div style=\"margin-top: 10px; text-align: center;\">\n            <a href=\"http:\/\/diariovasco.localdigitalkit.com\/sms\/?id=438\" target=\"_blank\">Buy additional phone numbers around the world to track your campaigns.<\/a>\n            <\/div>"}}},"crm":{"infusionSoft":{"name":"InfusionSoft","info":"<span class=\"serviceInfo\">Notify your clients wherever they are, using SMS service. <a class=\"readMore\" target=\"_blank\" href=\"http:\/\/www.seotoaster.com\/cms-applications.html\">Read more<\/a><\/span>","status":"http:\/\/diariovasco.localdigitalkit.com\/crm\/?id=438&w=816"},"salesForce":{"name":"SalesForce","info":"<span class=\"serviceInfo\">Notify your clients wherever they are, crm. <a class=\"readMore\" target=\"_blank\" href=\"http:\/\/www.seotoaster.com\/cms-applications.html\">Read more<\/a><\/span>","status":"http:\/\/diariovasco.localdigitalkit.com\/crm\/?id=438&w=816"}},"categoryInfo":{"email":"<span class=\"categoryInfo\">Email marketing providers help you reach your audience with mass emails. Reputation is key to reach your audience when using bulk emails.\nHence, why you won\u2019t find a built-in newsletter facility around here. Instead, your system will  add emails right onto your mailing lists from\nyour website forms, as well as from your store dashboard\u2019s client tab (E-commerce version) in a snap.\n    <a class=\"readMore\"\n       target=\"_blank\"\n       href=\"http:\/\/www.seotoaster.com\/cms-applications.html\">Read\n        more<\/a><\/span>","sms":"<span class=\"categoryInfo\"><p>Buy phone numbers internationally for a low monthly fee to deliver superior\n        marketing & customer services.<\/p><p>You can use a single phone number to receive or send SMS when an order has\n        been received or has shipped (eCommerce edition) for instance, and\/or offer web-to-call services to your website\n        visitors, and\/or record and receive\n        calls over regular phone lines to track sales leads generated by your website.<\/p><p>Heck, you can even buy more\n        numbers to record and track phone leads for any\n        online or offline marketing campaign. <a class=\"readMore\"\n                                                target=\"_blank\"\n                                                href=\"http:\/\/www.seotoaster.com\/cms-applications.html\">Read\n            more<\/a><\/p><\/span>","crm":"<span class=\"categoryInfo\"><p>CRM information<\/p><p><a class=\"readMore\"\n                                                target=\"_blank\"\n                                                href=\"http:\/\/www.seotoaster.com\/cms-applications.html\">Read\n            more<\/a><\/p><\/span>"}}}', true);
//                $aiData = array('openAi' => array(
//                    'name' => 'Open AI',
//                    'alt_label' => '',
//                    'info' => '<span class="serviceInfo">AI helper tool service <a class="readMore" target="_blank" href="http://www.seotoaster.com/cms-applications.html">Read more</a></span>',
//                    'status' => true,
//                    'detailedInfo' => 1,
//                    'params' => array(
//                        'purchaseLink' => '<div style="margin-top: 10px; text-align: center;"><a href="https://mojo.loc/plugin/api/run/paymentForm/websiteId/0/pluginNameHash/decc0b9e8f5a15094771faa1a54aca48" target="_blank">Buy additional AI credits</a></div>',
//                        'credits' => array(
//                            'value' => 2,
//                            'originalValue' => 2,
//                            'resetDate' => '03-Mar-2024'
//                        )
//                    )
//                ));
//
//                $categoryAndServices['services']['openai'] = $aiData;
//                $categoryAndServices['services']['categoryInfo']['openai'] = $aiData['openAi']['info'];

                if(isset($categoryAndServices['done']) && $categoryAndServices['done'] === false) {
                    $categoryAndServices = null;
                }
                if($categoryAndServices !== null) {
                    if(isset($categoryAndServices['services']['categoryInfo'])){
                        $this->_view->categoryInfo = $categoryAndServices['services']['categoryInfo'];
                        unset($categoryAndServices['services']['categoryInfo']);
                    }
                    $categoryServicesInfo = array();
                    foreach ($categoryAndServices['services'] as $category => $services) {
                        foreach ($services as $serviceName => $serviceData) {
                            $categoryServicesInfo[$serviceName] = $category;
                        }
                    }

                    $pluginShopping = Application_Model_Mappers_PluginMapper::getInstance()->findByName('shopping');
                    if ($pluginShopping instanceof Application_Model_Models_Plugin) {
                        $this->_view->eccomerceWebsite = true;
                    }

                    $this->_view->categoryServicesInfo = $categoryServicesInfo;
                    $this->_view->categoryAndServices = $categoryAndServices;
                    $this->_view->categoryAlias = $this->_categoryAlias;
                    $allForms = Application_Model_Mappers_FormMapper::getInstance()->fetchAll();
                    $this->_view->forms = $allForms;
                    $this->_view->emailFormsView = $this->_view->render('emailForm.phtml');
                }

            }
            $this->_view->helpSection = self::SECTION_APPS;
            $this->_view->hashMap     = $this->_helpHashMap;
            $this->_layout->content = $this->_view->render('config.phtml');
            echo $this->_layout->render();

        }
    }

    public function chooseFormListAction(){
        if(Tools_Security_Acl::isAllowed(Tools_Security_Acl::RESOURCE_PLUGINS) && $this->_request->isPost()) {
            $formName = $this->_request->getParam('checkedForm');
            $service  = $this->_request->getParam('serviceName');
            $serviceType  = $this->_request->getParam('serviceType');
            $existingForms = Apps_Models_Mapper_AppsSystemFormMapper::getInstance()->getByFormNameService($formName, $service);
            $localLists = array();
            $lists = array();
            $additionalLists = array();
            $additionalLocalList = '';
            if(!empty($existingForms)){
                $localLists = explode(',', $existingForms[0]->getLists());
                $additionalLocalList =  $existingForms[0]->getAdditionalList();
            }
            if(isset($service)){
                $serviceMethodKey = $service.'List';
                $contactLists = Apps::apiCall('GET', 'apps', array($serviceMethodKey));
                if(isset($contactLists[$serviceMethodKey]) && is_array($contactLists[$serviceMethodKey])){
                    if (!empty($contactLists[$serviceMethodKey]['data'])) {
                        if (empty($contactLists[$serviceMethodKey]['data'][$service])) {
                            $this->_responseHelper->fail();
                        }
                        if (!empty($contactLists[$serviceMethodKey]['detailedInfo'])) {
                            $detailedInfo = '1';
                        }
                        foreach($contactLists[$serviceMethodKey]['data'][$service] as $list){
                            $lists[$list['id']] = $list['name'];
                        }
                    } else {
                        if (empty($contactLists[$serviceMethodKey])) {
                            $this->_responseHelper->fail();
                        }
                        foreach($contactLists[$serviceMethodKey] as $list){
                            $lists[$list['id']] = $list['name'];
                        }
                    }
                    $this->_view->lists = $lists;
                }else{
                    $this->_responseHelper->fail();
                }
                if ($serviceType === self::SERVICE_TYPE_CRM) {
                    $additionalLists = Apps::apiCall('GET', 'apps', array($service.'AdditionalList'));
                    if (!empty($additionalLists)) {
                        $additionalListsData = array();
                        foreach ($additionalLists[$service . 'AdditionalList'] as $addList) {
                            foreach ($addList as $listName => $listData) {
                                foreach ($listData as $dataValues) {
                                    $additionalListsData[$dataValues['id']] = $dataValues['name'];
                                }
                            }
                        }
                        $additionalLists = $additionalListsData;
                    }
                }
            }
            if (empty($additionalLists)) {
                $this->_responseHelper->success(array('localLists' => $localLists, 'list' => $lists));
            }
            $this->_responseHelper->success(array('localLists'=> $localLists, 'list' => $lists, 'additionalSelectionList' => $additionalLists, 'additionalLocalList' => $additionalLocalList));
        }
    }

    public function getListCrmAction()
    {
        if (Tools_Security_Acl::isAllowed(Tools_Security_Acl::RESOURCE_PLUGINS) && $this->_request->isPost()) {
            $service  = $this->_request->getParam('serviceName');
            $existingConfig = Apps_Models_Mapper_AppsCrmMapper::getInstance()->getByDataTypeService('ecommerce', $service);
            $localLists = array();
            $lists = array();
            $additionalLists = array();
            $additionalLocalList = '';
            if(!empty($existingConfig)){
                $localLists = explode(',', $existingConfig[0]->getLists());
                $additionalLocalList =  $existingConfig[0]->getAdditionalList();
            }
            if(isset($service)){
                $contactLists = Apps::apiCall('GET', 'apps', array($service.'ListEcommerce'));
                if(isset($contactLists[$service.'ListEcommerce']) && is_array($contactLists[$service.'ListEcommerce'])){
                    foreach($contactLists[$service.'ListEcommerce'] as $list){
                        $lists[$list['id']] = $list['name'];
                    }
                    $this->_view->lists = $lists;
                }else{
                    $this->_responseHelper->fail();
                }

                $additionalLists = Apps::apiCall('GET', 'apps', array($service.'AdditionalListEcommerce'));
                if (!empty($additionalLists)) {
                    $additionalListsData = array();
                    foreach ($additionalLists[$service . 'AdditionalListEcommerce'] as $addList) {
                        foreach ($addList as $listName => $listData) {
                            foreach ($listData as $dataValues) {
                                $additionalListsData[$dataValues['id']] = $dataValues['name'];
                            }
                        }
                    }
                    $additionalLists = $additionalListsData;
                }
            }
            if (empty($additionalLists)) {
                $this->_responseHelper->success(array('localLists'=> $localLists, 'list' => $lists));
            }
            $this->_responseHelper->success(array('localLists'=> $localLists, 'list' => $lists, 'additionalSelectionList' => $additionalLists, 'additionalLocalList' => $additionalLocalList));
        }
    }

    /**
     * Save crm ecommerce list config
     */
    public function saveCrmEcommerceAction()
    {
        if (Tools_Security_Acl::isAllowed(Tools_Security_Acl::RESOURCE_PLUGINS) && $this->_request->isPost()) {
            $secureToken = $this->_request->getParam(Tools_System_Tools::CSRF_SECURE_TOKEN, false);
            $tokenValid = Tools_System_Tools::validateToken($secureToken, self::APPS_SECURE_TOKEN);
            if (!$tokenValid) {
                $this->_responseHelper->fail('');
            }
            $data = $this->_request->getParams();
            $crmConfigMapper = Apps_Models_Mapper_AppsCrmMapper::getInstance();
            if (isset($data['lists']) && !empty($data['lists'])) {
                $appsCrmConfigModel = new Apps_Models_Models_AppsCrmModel();
                $appsCrmConfigModel->setDataType('ecommerce');
                $appsCrmConfigModel->setLists(implode(',', array_values($data['lists'])));
                $appsCrmConfigModel->setAdditionalList($data['additionalSelectValue']);
                $appsCrmConfigModel->setService($data['service']);
                $crmConfigMapper->save($appsCrmConfigModel);
            } elseif (isset($data['deleteList']) && isset($data['service']) && $data['deleteList'] == 1) {
                $crmConfigMapper->deleteServiceConfig($data['service'], 'ecommerce');
            } else {
                $this->_responseHelper->fail();
            }
            $this->_responseHelper->success('');
        }
    }

    public function saveSystemFormAction(){
        if(Tools_Security_Acl::isAllowed(Tools_Security_Acl::RESOURCE_PLUGINS) && $this->_request->isPost()) {
            $secureToken = $this->_request->getParam(Tools_System_Tools::CSRF_SECURE_TOKEN, false);
            $tokenValid = Tools_System_Tools::validateToken($secureToken, self::APPS_SECURE_TOKEN);
            if (!$tokenValid) {
                $this->_responseHelper->fail('');
            }
            $data = $this->_request->getParams();
            $appsSystemFormsMapper = Apps_Models_Mapper_AppsSystemFormMapper::getInstance();
            if(!empty($data['lists'])){
                $appsSystemFormsModel  = new Apps_Models_Models_AppsSystemFormModel();
                $appsSystemFormsModel->setForm($data['formName']);
                $appsSystemFormsModel->setLists(implode(',',array_values($data['lists'])));
                $appsSystemFormsModel->setService($data['service']);
                if (isset($data['additionalSelectionId'])) {
                    $appsSystemFormsModel->setAdditionalList($data['additionalSelectionId']);
                }
                $appsSystemFormsMapper->save($appsSystemFormsModel);
            }elseif(isset($data['deleteList']) && isset($data['service']) && $data['formName'] && $data['deleteList'] == 1 ){
                $appsSystemFormsMapper->deleteList($data['service'], $data['formName']);
            }else{
                $this->_responseHelper->fail();
            }
            $this->_responseHelper->success('');
        }
    }

    public function getEnabledServicesDashboardAction(){
        if(Tools_Security_Acl::isAllowed(Tools_Security_Acl::RESOURCE_PLUGINS)) {
            $data = $this->_request->getParams();
            $enabledServices = Apps_Models_Mapper_AppsSettingsMapper::getInstance()->selectConfigByStatusCategory('1', $data['serviceType']);
            if(!empty($enabledServices)){
                $enabledServicesLabels = array();
                $categoryAndServices = Apps::apiCall('GET', 'apps', array('services'), array('withcrm' => 'withcrm', 'withSambaEmailMarketing' => 'withSambaEmailMarketing'));
                //$categoryAndServices = json_decode('{"services":{"email":{"constantContact":{"name":"Constant Contact","info":"<span class=\"serviceInfo\">Constant Contact, Inc. is an online marketing company offering email marketing, social media marketing, online survey, event marketing, digital storefronts, and local deals tools, primarily to small businesses, nonprofit organizations, and membership associations. <a class=\"readMore\" target=\"_blank\" href=\"http:\/\/www.seotoaster.com\/cms-applications.html\">Read more<\/a><\/span>","status":true,"params":{"registerLink":"<div style=\"margin-top: 10px; text-align: center;\">\n            <a href=\"http:\/\/diariovasco.localdigitalkit.com\/mail\/?id=438&w=816\" target=\"_blank\">Access your email marketing configuration here.<\/a>\n            <\/div>"}},"sambaEmailMarketing":{"name":"SEO Samba email marketing","info":"Create email campaigns","status":true, "detailedInfo": "1"}},"sms":{"cloud_communication":{"name":"SMS & Phone service","info":"<span class=\"serviceInfo\">Notify your clients wherever they are, using SMS service. <a class=\"readMore\" target=\"_blank\" href=\"http:\/\/www.seotoaster.com\/cms-applications.html\">Read more<\/a><\/span>","status":true,"params":{"registerLink":"<div style=\"margin-top: 10px; text-align: center;\">\n            <a href=\"http:\/\/diariovasco.localdigitalkit.com\/sms\/?id=438\" target=\"_blank\">Buy additional phone numbers around the world to track your campaigns.<\/a>\n            <\/div>"}}},"crm":{"infusionSoft":{"name":"InfusionSoft","info":"<span class=\"serviceInfo\">Notify your clients wherever they are, using SMS service. <a class=\"readMore\" target=\"_blank\" href=\"http:\/\/www.seotoaster.com\/cms-applications.html\">Read more<\/a><\/span>","status":"http:\/\/diariovasco.localdigitalkit.com\/crm\/?id=438&w=816"},"salesForce":{"name":"SalesForce","info":"<span class=\"serviceInfo\">Notify your clients wherever they are, crm. <a class=\"readMore\" target=\"_blank\" href=\"http:\/\/www.seotoaster.com\/cms-applications.html\">Read more<\/a><\/span>","status":"http:\/\/diariovasco.localdigitalkit.com\/crm\/?id=438&w=816"}},"categoryInfo":{"email":"<span class=\"categoryInfo\">Email marketing providers help you reach your audience with mass emails. Reputation is key to reach your audience when using bulk emails.\nHence, why you won\u2019t find a built-in newsletter facility around here. Instead, your system will  add emails right onto your mailing lists from\nyour website forms, as well as from your store dashboard\u2019s client tab (E-commerce version) in a snap.\n    <a class=\"readMore\"\n       target=\"_blank\"\n       href=\"http:\/\/www.seotoaster.com\/cms-applications.html\">Read\n        more<\/a><\/span>","sms":"<span class=\"categoryInfo\"><p>Buy phone numbers internationally for a low monthly fee to deliver superior\n        marketing & customer services.<\/p><p>You can use a single phone number to receive or send SMS when an order has\n        been received or has shipped (eCommerce edition) for instance, and\/or offer web-to-call services to your website\n        visitors, and\/or record and receive\n        calls over regular phone lines to track sales leads generated by your website.<\/p><p>Heck, you can even buy more\n        numbers to record and track phone leads for any\n        online or offline marketing campaign. <a class=\"readMore\"\n                                                target=\"_blank\"\n                                                href=\"http:\/\/www.seotoaster.com\/cms-applications.html\">Read\n            more<\/a><\/p><\/span>","crm":"<span class=\"categoryInfo\"><p>CRM information<\/p><p><a class=\"readMore\"\n                                                target=\"_blank\"\n                                                href=\"http:\/\/www.seotoaster.com\/cms-applications.html\">Read\n            more<\/a><\/p><\/span>"}}}', true);
                foreach ($enabledServices as $enabledServiceName => $enabledServiceStatus) {
                    if (!empty($categoryAndServices) && !empty($categoryAndServices['services']) && !empty($categoryAndServices['services'][ $data['serviceType']]) && !empty($categoryAndServices['services'][$data['serviceType']][$enabledServiceName])) {
                        if (!empty($categoryAndServices['services'][$data['serviceType']][$enabledServiceName]['alt_label'])) {
                            $enabledServicesLabels[$enabledServiceName] = $categoryAndServices['services'][$data['serviceType']][$enabledServiceName]['alt_label'];
                        } else {
                            $enabledServicesLabels[$enabledServiceName] = $categoryAndServices['services'][$data['serviceType']][$enabledServiceName]['name'];
                        }
                    } else {
                        $enabledServicesLabels[$enabledServiceName] = $enabledServiceName;
                    }
                }
                $this->_responseHelper->success(array('clients' => $data['customers'], 'enabledServices' => $enabledServices, 'enabledServicesLabels' => $enabledServicesLabels));
            }
            $this->_responseHelper->fail();
        }
    }

    public function getServiceAction(){
        if(Tools_Security_Acl::isAllowed(Tools_Security_Acl::RESOURCE_PLUGINS)) {
            $data = $this->_request->getParams();
            $lists = array();
            if(isset($data['serviceName'])){
                $services = Apps::apiCall('GET', 'apps', array($data['serviceName'].'List'));
                $serviceKey = $data['serviceName'].'List';
                $detailedInfo = '0';
                if(isset($services[$serviceKey])){
                    if (!empty($services[$serviceKey]['data'])) {
                        if (empty($services[$serviceKey]['data'][$data['serviceName']])) {
                            $this->_responseHelper->fail();
                        }

                        if (!empty($services[$serviceKey]['detailedInfo'])) {
                            $detailedInfo = '1';
                        }
                        foreach($services[$serviceKey]['data'][$data['serviceName']] as $list){
                            $lists[$list['id']] = $list['name'];
                        }
                    } else {
                        if (empty($services[$serviceKey])) {
                            $this->_responseHelper->fail();
                        }
                        foreach($services[$serviceKey] as $list){
                            $lists[$list['id']] = $list['name'];
                        }
                    }

                    $this->_responseHelper->success(array('list' =>$lists, 'detailedInfo' => $detailedInfo));
                }
                $this->_responseHelper->fail();
            }
            $this->_responseHelper->fail();
        }
    }

    /**
     * get list of services for dashboard
     */
    public function getServiceDashboardAction()
    {
        if (Tools_Security_Acl::isAllowed(Tools_Security_Acl::RESOURCE_PLUGINS)) {
            $data = $this->_request->getParams();
            $serviceInfo = Apps_Models_Mapper_AppsSettingsMapper::getInstance()->getByServiceName($data['serviceName']);
            $serviceType = $serviceInfo[0]->getCategory();
            $lists = array();
            if (isset($data['serviceName'])) {
                if ($serviceType === self::SERVICE_TYPE_CRM) {
                    $services = Apps::apiCall('GET', 'apps', array($data['serviceName'] . 'ListDashboard'));
                }

                if (isset($services[$data['serviceName'] . 'ListDashboard'])) {
                    foreach ($services[$data['serviceName'] . 'ListDashboard'] as $list) {
                        $lists[$list['id']] = $list['name'];
                    }
                    $this->_responseHelper->success(array('list' => $lists));
                }
                $this->_responseHelper->fail();
            }
            $this->_responseHelper->fail();
        }
    }

    public function sendServicesDashboardAction(){
        if(Tools_Security_Acl::isAllowed(Tools_Security_Acl::RESOURCE_PLUGINS) && $this->_request->isPost()) {
            $serviceData = $this->_request->getParams();
            if(isset($serviceData['customers']) && isset($serviceData['service']) && isset($serviceData['lists'])){
                $serviceModel = Apps_Models_Mapper_AppsSettingsMapper::getInstance()->findByServiceName($serviceData['service']);
                if (!$serviceModel instanceof Apps_Models_Models_AppsSettingsModel) {
                    $this->_responseHelper->fail($this->_translator('Service not found'));
                }
                $serviceType = $serviceModel->getCategory();
                $detailedInfo = $serviceModel->getDetailedInfo();
                $data['services'] = array($serviceData['service'] => array('type' => $serviceType));
                $userDbtable = new Application_Model_DbTable_User();
                if (($serviceType === Apps::SERVICE_TYPE_EMAIL || $serviceType === Apps::SERVICE_TYPE_CRM) && $serviceData['service'] !== 'salesForce') {
                    $where = $userDbtable->getAdapter()->quoteInto('id IN (?)',
                        explode(',', $serviceData['customers']));
                    if (!empty($detailedInfo)) {
                        $select = $userDbtable->getAdapter()->select()->from('user',
                            array('email' => 'email',
                                'firstName' => new Zend_Db_Expr("SUBSTRING_INDEX(full_name, ' ', 1)"),
                                'lastName' => new Zend_Db_Expr("LTRIM(REPLACE(full_name, SUBSTRING_INDEX(full_name, ' ', 1), ''))"),
                                'phoneCountryCode' => 'desktop_country_code',
                                'phoneNumber' => 'desktop_phone',
                                'mobileCode' => 'mobile_country_code',
                                'mobileNumber' => 'mobile_phone'))
                            ->where($where);

                        $users = $userDbtable->getAdapter()->fetchAll($select);
                    } else {
                        $select = $userDbtable->getAdapter()->select()->from('user',
                            array('email', 'full_name'))->where($where);
                        $users = $userDbtable->getAdapter()->fetchPairs($select);
                    }
                } elseif ($serviceType === Apps::SERVICE_TYPE_CRM && $serviceData['service'] === 'salesForce') {
                    $where = $userDbtable->getAdapter()->quoteInto('u.id IN (?)',
                        explode(',', $serviceData['customers']));
                    $where .= ' AND `scs`.`shipping_address_id` IS NOT NULL AND `scs`.`billing_address_id` IS NOT NULL';
                    $select = $userDbtable->getAdapter()->select()->from(array('u' => 'user'),
                        array('u.email', 'u.full_name', 'u.mobile_phone', 'scs.user_id'))
                        ->joinLeft(array('scs' => 'shopping_cart_session'), 'scs.user_id=u.id', array())
                        ->joinLeft(array('scas' => 'shopping_customer_address'), 'scas.id=scs.shipping_address_id',
                            array('shipping_first_name' => 'scas.firstname', 'shipping_address_city' => 'scas.city',
                            'shipping_address_zip' => 'scas.zip', 'shipping_address_country' => 'scas.country',
                                'shipping_address_street' => 'scas.address1', 'scs.id','scs.created_at'
                            ))
                        ->joinLeft(array('scab' => 'shopping_customer_address'), 'scab.id=scs.billing_address_id',
                            array('billing_first_name' => 'scab.firstname', 'billing_address_city' => 'scab.city',
                                'billing_address_zip' => 'scab.zip', 'billing_address_country' => 'scab.country',
                                'billing_address_street' => 'scab.address1')
                        )
                        ->where($where)
                        //->group(array('scs.user_id'))
                        ->order('scs.created_at DESC');
                    $selectFrom = $userDbtable->getAdapter()->select()->from(array('subresult' =>$select))->group('subresult.user_id');
                    $data['services'][$serviceData['service']]['fromDashboard'] = true;
                    $clientsExtended = $userDbtable->getAdapter()->fetchAssoc($selectFrom);
                    $selectFrom->assemble();
                    $where = $userDbtable->getAdapter()->quoteInto('id IN (?)',
                        explode(',', $serviceData['customers']));
                    $select = $userDbtable->getAdapter()->select()->from('user',
                        array('email', 'full_name', 'mobile_phone'))->where($where);
                    $users = $userDbtable->getAdapter()->fetchAssoc($select);
                    $data['services'][$serviceData['service']]['clientsExtended'] = $clientsExtended;
                }
                if(!empty($users)){
                    $data['services'][$serviceData['service']]['clients'] = $users;
                    $data['services'][$serviceData['service']]['lists'] = explode(',', $serviceData['lists']);
                    $response = Apps::apiCall('POST', 'apps', array($serviceData['service'].'Client'), $data);
                    if($response[$serviceData['service'].'Client']['done']){
                        $this->_responseHelper->success('');
                    }
                    $this->_responseHelper->fail($response[$serviceData['service'].'Client']['message']);

                }
            }
        }
    }

    /**
     * Call mojo.seosamba.com api
     *
     * @param string $methodType method type (GET, POST, PUT, DELETE)
     * @param string $methodName method name (apps)
     * @param array $command command list for mojo api
     * @param array $data data
     * @return mixed
     * @throws Exceptions_SeotoasterPluginException
     */
    public static function apiCall($methodType, $methodName, $command, $data = array()) {
        $websiteConfig = Zend_Controller_Action_HelperBroker::getStaticHelper('config')->getConfig();
        $websiteHelper = Zend_Controller_Action_HelperBroker::getStaticHelper('website');
        $websiteUrl = $websiteHelper->getUrl();
        if(isset($websiteConfig['sambaToken']) && (isset($websiteConfig['websiteId'])) ) {
            $url = parse_url($websiteUrl);
            $data['websiteUrl'] = $url['host'];
            $data['websiteId'] = $websiteConfig['websiteId'];
            $data['sambaToken'] = $websiteConfig['sambaToken'];
            $data['command'] = $command;
            $seosambaRequest = Tools_Factory_PluginFactory::createPlugin('api',array(), array('websiteUrl' => $websiteUrl));
            return $seosambaRequest::request($methodType, $methodName, $data);
        }
    }

}
