<?php

if (PHP_SAPI !== 'cli') {
    //die('direct access is not allowed');
}

/*************************************************************************
 * Necessary alter for pcre.backtrack_limit
 *
 ************************************************************************/
ini_set('pcre.backtrack_limit', '10000000000000');

ini_set('session.cookie_httponly', 1);

/*************************************************************************
 * Installation check
 *
 ************************************************************************/
//error_reporting(E_ALL | E_STRICT);

/*************************************************************************
 * Reading current core config
 *
 *************************************************************************/
$coreConfigPath = realpath(__DIR__.'/../../../../system/coreinfo.php');
if (file_exists($coreConfigPath)) {
    require_once realpath($coreConfigPath);
}
defined('CORE') || define('CORE', realpath(__DIR__.'/../../../../seotoaster_core/'));
defined('SITE_NAME') || define('SITE_NAME', '');

/* End reading current core config */

// Define path to application directory
defined('APPLICATION_PATH')
|| define('APPLICATION_PATH', CORE . 'application');

// Define application environment
defined('APPLICATION_ENV')
|| define('APPLICATION_ENV', (getenv('APPLICATION_ENV') ? getenv('APPLICATION_ENV') : 'testing'));

// Ensure library/ is on include_path
set_include_path(
    implode(
        PATH_SEPARATOR,
        array(
            realpath(APPLICATION_PATH . '/../library'),
            get_include_path(),
        )
    )
);

/** Zend_Application */
require_once 'Zend/Application.php';

$application = new Zend_Application(
    APPLICATION_ENV,
    APPLICATION_PATH . '/configs/' . SITE_NAME . '.ini'
);

if (Zend_Registry::isRegistered('session')) {
    $session = Zend_Registry::get('session');
    $session->unLock();
    Zend_Session_Namespace::resetSingleInstance('toaster_' . SITE_NAME);
}

set_include_path(realpath(APPLICATION_PATH . '/app') . PATH_SEPARATOR . get_include_path());

$configIni = new Zend_Config_Ini(APPLICATION_PATH . '/configs/' . SITE_NAME . '.ini');
Zend_Registry::set('website', $configIni->website->website->toArray());
Zend_Registry::set('database', $configIni->database->database->toArray());
Zend_Registry::set('theme', $configIni->theme->theme->toArray());
Zend_Registry::set('news', $configIni->news->news->toArray());
Zend_Registry::set('misc', $configIni->misc->misc->toArray());

$autoloader = Zend_Loader_Autoloader::getInstance();
$autoloader->registerNamespace('Widgets_');
$autoloader->registerNamespace('MagicSpaces_');
$autoloader->registerNamespace('Interfaces_');
$autoloader->registerNamespace('Helpers_');
$autoloader->registerNamespace('Exceptions_');
$autoloader->registerNamespace('Tools_');
$autoloader->registerNamespace('Plugins_');
$autoloader->registerNamespace('Api_');
$autoloader->setFallbackAutoloader(true);

$session = new Zend_Session_Namespace('toaster_' . SITE_NAME, true);
Zend_Registry::set('session', $session);


$websiteConfig = $configIni->website->website->toArray();

Zend_Controller_Action_HelperBroker::addHelper(new Helpers_Action_Page());
Zend_Controller_Action_HelperBroker::addHelper(new Helpers_Action_Session());
Zend_Controller_Action_HelperBroker::addHelper(new Helpers_Action_Admin());
Zend_Controller_Action_HelperBroker::addHelper(new Helpers_Action_Config());
Zend_Controller_Action_HelperBroker::addHelper(new Helpers_Action_Website());
Zend_Controller_Action_HelperBroker::addHelper(new Helpers_Action_Response());
Zend_Controller_Action_HelperBroker::addHelper(new Helpers_Action_Language());
Zend_Controller_Action_HelperBroker::addHelper(new Helpers_Action_Mobile());



$dbConfig = $configIni->database->database->toArray();
$adapter = strtolower($dbConfig['adapter']);
if (!in_array($adapter, array('pdo_mysql', 'mysqli'))) {
    if (extension_loaded('pdo_mysql')) {
        $adapter = 'pdo_mysql';
    } elseif (extension_loaded('mysqli')) {
        $adapter = 'mysqli';
    } else {

    }
}
if ($adapter === 'pdo_mysql') {
    $dbConfig['params']['driver_options'] = array(
        PDO::MYSQL_ATTR_INIT_COMMAND => 'SET NAMES UTF8;',
        PDO::MYSQL_ATTR_USE_BUFFERED_QUERY => true
    );
}
$database = Zend_Db::factory($adapter, $dbConfig['params']);
if ($adapter === 'mysqli') {
    $database->query('SET NAMES UTF8');
    $database->query('SET CHARACTER SET utf8');
}
Zend_Db_Table_Abstract::setDefaultAdapter($database);
Zend_Registry::set('dbAdapter', $database);


$config = Application_Model_Mappers_ConfigMapper::getInstance()->getConfig();
$name = Zend_Locale::getLocaleToTerritory($config['language']);
if ($name !== null) {
    $locale = new Zend_Locale($name);
} else {
    $locale = new Zend_Locale();
}

Zend_Registry::set('Zend_Locale', $locale);

$session = Zend_Registry::get('session');

$locale = (isset($session->locale)) ? $session->locale : Zend_Registry::get('Zend_Locale');

$session->locale = $locale;

$translator = new Zend_Translate(array(
    'adapter' => 'array',
    'content' => $websiteConfig['path'].'system/languages/',
    'scan'    => Zend_Translate::LOCALE_FILENAME,
    'locale'  => $locale->getLanguage(),
    'ignore'  => array('.'),
    'route'   => array('fr' => 'en', 'it' => 'en', 'de' => 'en')
));

Zend_Registry::set('Zend_Locale', $locale);
Zend_Registry::set('Zend_Translate', $translator);
Zend_Registry::set('session', $session);

$filePath = $configIni->website->website->path;
$pluginIncludePath = array(
    '0' => realpath($filePath.'plugins/notifier/system/app'),
);
set_include_path(implode(PATH_SEPARATOR, $pluginIncludePath) . PATH_SEPARATOR . get_include_path());
$websiteConfig = $configIni->website->website->toArray();

Tools_NotifierNewsObserver::processPendingNewsAction();

echo 'Done!';
