<?php


class Notifier_Models_Dbtables_NotifierConfigDbtable extends Zend_Db_Table_Abstract
{
    protected $_name = 'plugin_notifier_config';

    /**
     * Update signle param
     *
     * @param string $name param name
     * @param string $value param value
     * @return bool|mixed
     * @throws Zend_Db_Table_Exception
     */
    public function updateParam($name, $value)
    {
        if ($value === null) {
            return false;
        }
        $rowset = $this->find($name);
        $row = $rowset->current();
        if ($row === null) {
            $row = $this->createRow(array(
                'name' => $name,
                'value' => $value
            ));
        } else {
            $row->value = $value;
        }

        return $row->save();
    }

    /**
     * Select config params
     *
     * @return array
     */
    public function selectConfig()
    {
        return $this->getAdapter()->fetchPairs($this->select()->from($this->_name));
    }

}