tinymce.PluginManager.add('reviewrequestlinks', function(editor, url) {

    function getValues() {
        if (typeof window.tinymcePluginReviewRequestLinks === 'undefined') {
            return new Promise((resolve, reject) => {
                $.ajax({
                    'url': window.location.protocol + '//' + window.location.host + '/plugin/leads/run/getReviewRequestLinks/',
                    'type': 'POST',
                    'dataType': 'json',
                    'data': {}
                }).done(async function (response) {
                    if (parseInt(response.error) === 1) {
                        showMessage(response.responseText, true, 3000);
                        return false;
                    } else {
                        window.tinymcePluginReviewRequestLinks = response.responseText;
                        let responseList = processList(response.responseText);
                        resolve(responseList);
                    }
                }).fail(async function (response) {
                    resolve({name: 'login', 'message': 'Please re-login'});
                });
            });
        } else {
            let response = window.tinymcePluginReviewRequestLinks;
            return processList(response);
        }
    }

    function processList(response)
    {
        var shortCodeList = [];

        for (var i in response) {
            for (var j in response[i]) {
                var newShortcode = {};
                if (typeof response[i][j].alias !== 'undefined') {
                    newShortcode['type'] = 'menuitem';
                    newShortcode['text'] = response[i][j].alias;
                    newShortcode['value'] = response[i][j].option+' ';
                    //newShortcode['icon'] = 'triangleUp';
                    // editor.ui.registry.addIcon(
                    //     "triangleUp",
                    //     '<svg width="16" height="16" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 27.75 31.75"><defs><style>.cls-1{fill:#4c5866;}</style></defs><g id="Layer_2" data-name="Layer 2"><g id="Layer_1-2" data-name="Layer 1"><g id="Underline"><path class="cls-1" d="M13.88,25.69A10.89,10.89,0,0,1,3,14.82V1.88a1.88,1.88,0,1,1,3.75,0V14.82a7,7,0,0,0,7.13,7.12A7,7,0,0,0,21,14.82V1.88a1.88,1.88,0,1,1,3.75,0V14.82A10.89,10.89,0,0,1,13.88,25.69Z"/><path class="cls-1" d="M25.88,31.75h-24a1.88,1.88,0,1,1,0-3.75h24a1.88,1.88,0,0,1,0,3.75Z"/></g></g></g></svg>'
                    // );
                    newShortcode['onSetup'] = function(buttonApi) {
                        var $this = this;
                        this.onAction = function() {
                            editor.insertContent($this.data.value);
                        };
                    }
                } else {
                    newShortcode['type'] = 'menuitem';
                    newShortcode['text'] = response[i][j];
                    newShortcode['value'] = response[i][j]+' ';
                    //newShortcode['icon'] = 'underline';
                    newShortcode['onSetup'] = function(buttonApi) {
                        var $this = this;
                        this.onAction = function() {
                            editor.insertContent($this.data.value);
                        };
                    }
                }

                shortCodeList.push(newShortcode)
            }
        }

        return shortCodeList;
    }

    // Add a button that opens a window
    editor.ui.registry.addMenuButton('reviewrequestlinks', {
        text: 'Review request links',
        fetch: async function (callback) {
            let result = '';
            result = await getValues();
            callback(result);
        }
    });
});
