tinymce.PluginManager.add('charlimit', function(ed) {
    ed.on('init', function() {
        charLimitProcessing();

        function charLimitProcessing() {

            let msgLength = 0,
                endSymbols = 0,
                span = $('#'+ed.id+'-limit-symbols'),
                tempContent = '';

            if(span) {
                let max = $(span).attr('data-maxlength'),
                    previousContentList = [];

                ed.on('change',function(editor) {
                    msgLength = ed.getContent({format : 'text'}).length;
                    endSymbols = max - msgLength;
                    if(ed.getContent() === '') {
                        endSymbols = max;
                    }

                    if(msgLength > max) {
                        previousContentList = ed.undoManager.data;
                        ed.setContent('');
                        tempContent = previousContentList[previousContentList.length - 1].content;
                        ed.insertContent(tempContent);
                    } else {
                        ed.undoManager.add();
                        $('#' + ed.id + '-limit-symbols').attr('data-maxlength', endSymbols).text(endSymbols);
                    }
                });

                ed.on('input',function(editor) {
                    msgLength = ed.getContent({format : 'text'}).length;
                    endSymbols = max - msgLength;
                    if(ed.getContent() === '') {
                        endSymbols = max;
                    }

                    if(msgLength > max) {
                        previousContentList = ed.undoManager.data;
                        ed.setContent('');
                        if (editor.inputType === 'insertFromPaste') {
                            tempContent = previousContentList[previousContentList.length - 2].content;
                        } else {
                            tempContent = previousContentList[previousContentList.length - 1].content;
                        }

                        ed.insertContent(tempContent);
                    } else {
                        ed.undoManager.add();
                        $('#' + ed.id + '-limit-symbols').attr('data-maxlength', endSymbols).text(endSymbols);
                    }
                });
            }
        }
    });
});